<?php
/**
 * IssuedDocument
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  FattureInCloud
 * @author   Fatture In Cloud API team
 * @link     https://fattureincloud.it
 */

/**
 * Fatture in Cloud API v2 - API Reference
 *
 * Connect your software with Fatture in Cloud, the invoicing platform chosen by more than 500.000 businesses in Italy.   The Fatture in Cloud API is based on REST, and makes possible to interact with the user related data prior authorization via OAuth2 protocol.
 *
 * The version of the OpenAPI document: 2.1.3
 * Contact: info@fattureincloud.it
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.9.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace FattureInCloud\Model;

use \ArrayAccess;
use \FattureInCloud\ObjectSerializer;

/**
 * IssuedDocument Class Doc Comment
 *
 * @category Class
 * @package  FattureInCloud
 * @author   Fatture In Cloud API team
 * @link     https://fattureincloud.it
 * @implements \ArrayAccess<string, mixed>
 */
class IssuedDocument implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'IssuedDocument';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'id' => 'int',
        'entity' => '\FattureInCloud\Model\Entity',
        'type' => '\FattureInCloud\Model\IssuedDocumentType',
        'number' => 'int',
        'numeration' => 'string',
        'date' => '\DateTime',
        'year' => 'int',
        'currency' => '\FattureInCloud\Model\Currency',
        'language' => '\FattureInCloud\Model\Language',
        'subject' => 'string',
        'visible_subject' => 'string',
        'rc_center' => 'string',
        'notes' => 'string',
        'rivalsa' => 'float',
        'cassa' => 'float',
        'amount_cassa' => 'float',
        'cassa_taxable' => 'float',
        'amount_cassa_taxable' => 'float',
        'cassa2' => 'float',
        'amount_cassa2' => 'float',
        'cassa2_taxable' => 'float',
        'amount_cassa2_taxable' => 'float',
        'global_cassa_taxable' => 'float',
        'amount_global_cassa_taxable' => 'float',
        'withholding_tax' => 'float',
        'withholding_tax_taxable' => 'float',
        'other_withholding_tax' => 'float',
        'stamp_duty' => 'float',
        'payment_method' => '\FattureInCloud\Model\PaymentMethod',
        'use_split_payment' => 'bool',
        'use_gross_prices' => 'bool',
        'e_invoice' => 'bool',
        'ei_data' => '\FattureInCloud\Model\IssuedDocumentEiData',
        'ei_cassa_type' => 'string',
        'ei_cassa2_type' => 'string',
        'ei_withholding_tax_causal' => 'string',
        'ei_other_withholding_tax_type' => 'string',
        'ei_other_withholding_tax_causal' => 'string',
        'items_list' => '\FattureInCloud\Model\IssuedDocumentItemsListItem[]',
        'payments_list' => '\FattureInCloud\Model\IssuedDocumentPaymentsListItem[]',
        'template' => '\FattureInCloud\Model\DocumentTemplate',
        'delivery_note_template' => '\FattureInCloud\Model\DocumentTemplate',
        'acc_inv_template' => '\FattureInCloud\Model\DocumentTemplate',
        'h_margins' => 'int',
        'v_margins' => 'int',
        'show_payments' => 'bool',
        'show_payment_method' => 'bool',
        'show_totals' => '\FattureInCloud\Model\ShowTotalsMode',
        'show_notification_button' => 'bool',
        'show_tspay_button' => 'bool',
        'delivery_note' => 'bool',
        'accompanying_invoice' => 'bool',
        'dn_number' => 'int',
        'dn_date' => '\DateTime',
        'dn_ai_packages_number' => 'string',
        'dn_ai_weight' => 'string',
        'dn_ai_causal' => 'string',
        'dn_ai_destination' => 'string',
        'dn_ai_transporter' => 'string',
        'dn_ai_notes' => 'string',
        'is_marked' => 'bool',
        'amount_net' => 'float',
        'amount_vat' => 'float',
        'amount_gross' => 'float',
        'amount_due_discount' => 'float',
        'amount_rivalsa' => 'float',
        'amount_rivalsa_taxable' => 'float',
        'amount_withholding_tax' => 'float',
        'amount_withholding_tax_taxable' => 'float',
        'amount_other_withholding_tax' => 'float',
        'amount_other_withholding_tax_taxable' => 'float',
        'amount_enasarco_taxable' => 'float',
        'extra_data' => '\FattureInCloud\Model\IssuedDocumentExtraData',
        'seen_date' => '\DateTime',
        'next_due_date' => '\DateTime',
        'url' => 'string',
        'dn_url' => 'string',
        'ai_url' => 'string',
        'attachment_url' => 'string',
        'attachment_token' => 'string',
        'ei_raw' => 'object',
        'ei_status' => 'string',
        'locked' => 'bool',
        'created_at' => 'string',
        'updated_at' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'id' => null,
        'entity' => null,
        'type' => null,
        'number' => null,
        'numeration' => null,
        'date' => 'date',
        'year' => null,
        'currency' => null,
        'language' => null,
        'subject' => null,
        'visible_subject' => null,
        'rc_center' => null,
        'notes' => null,
        'rivalsa' => null,
        'cassa' => null,
        'amount_cassa' => null,
        'cassa_taxable' => null,
        'amount_cassa_taxable' => null,
        'cassa2' => null,
        'amount_cassa2' => null,
        'cassa2_taxable' => null,
        'amount_cassa2_taxable' => null,
        'global_cassa_taxable' => null,
        'amount_global_cassa_taxable' => null,
        'withholding_tax' => null,
        'withholding_tax_taxable' => null,
        'other_withholding_tax' => null,
        'stamp_duty' => null,
        'payment_method' => null,
        'use_split_payment' => null,
        'use_gross_prices' => null,
        'e_invoice' => null,
        'ei_data' => null,
        'ei_cassa_type' => null,
        'ei_cassa2_type' => null,
        'ei_withholding_tax_causal' => null,
        'ei_other_withholding_tax_type' => null,
        'ei_other_withholding_tax_causal' => null,
        'items_list' => null,
        'payments_list' => null,
        'template' => null,
        'delivery_note_template' => null,
        'acc_inv_template' => null,
        'h_margins' => null,
        'v_margins' => null,
        'show_payments' => null,
        'show_payment_method' => null,
        'show_totals' => null,
        'show_notification_button' => null,
        'show_tspay_button' => null,
        'delivery_note' => null,
        'accompanying_invoice' => null,
        'dn_number' => null,
        'dn_date' => 'date',
        'dn_ai_packages_number' => null,
        'dn_ai_weight' => null,
        'dn_ai_causal' => null,
        'dn_ai_destination' => null,
        'dn_ai_transporter' => null,
        'dn_ai_notes' => null,
        'is_marked' => null,
        'amount_net' => null,
        'amount_vat' => null,
        'amount_gross' => null,
        'amount_due_discount' => null,
        'amount_rivalsa' => null,
        'amount_rivalsa_taxable' => null,
        'amount_withholding_tax' => null,
        'amount_withholding_tax_taxable' => null,
        'amount_other_withholding_tax' => null,
        'amount_other_withholding_tax_taxable' => null,
        'amount_enasarco_taxable' => null,
        'extra_data' => null,
        'seen_date' => 'date',
        'next_due_date' => 'date',
        'url' => null,
        'dn_url' => null,
        'ai_url' => null,
        'attachment_url' => null,
        'attachment_token' => null,
        'ei_raw' => null,
        'ei_status' => null,
        'locked' => null,
        'created_at' => null,
        'updated_at' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static $openAPINullables = [
        'id' => true,
        'entity' => false,
        'type' => false,
        'number' => true,
        'numeration' => true,
        'date' => true,
        'year' => true,
        'currency' => false,
        'language' => false,
        'subject' => true,
        'visible_subject' => true,
        'rc_center' => true,
        'notes' => true,
        'rivalsa' => true,
        'cassa' => true,
        'amount_cassa' => true,
        'cassa_taxable' => true,
        'amount_cassa_taxable' => true,
        'cassa2' => true,
        'amount_cassa2' => true,
        'cassa2_taxable' => true,
        'amount_cassa2_taxable' => true,
        'global_cassa_taxable' => true,
        'amount_global_cassa_taxable' => true,
        'withholding_tax' => true,
        'withholding_tax_taxable' => true,
        'other_withholding_tax' => true,
        'stamp_duty' => true,
        'payment_method' => false,
        'use_split_payment' => true,
        'use_gross_prices' => true,
        'e_invoice' => true,
        'ei_data' => true,
        'ei_cassa_type' => true,
        'ei_cassa2_type' => true,
        'ei_withholding_tax_causal' => true,
        'ei_other_withholding_tax_type' => true,
        'ei_other_withholding_tax_causal' => true,
        'items_list' => true,
        'payments_list' => true,
        'template' => false,
        'delivery_note_template' => false,
        'acc_inv_template' => false,
        'h_margins' => true,
        'v_margins' => true,
        'show_payments' => true,
        'show_payment_method' => true,
        'show_totals' => false,
        'show_notification_button' => true,
        'show_tspay_button' => true,
        'delivery_note' => true,
        'accompanying_invoice' => true,
        'dn_number' => true,
        'dn_date' => true,
        'dn_ai_packages_number' => true,
        'dn_ai_weight' => true,
        'dn_ai_causal' => true,
        'dn_ai_destination' => true,
        'dn_ai_transporter' => true,
        'dn_ai_notes' => true,
        'is_marked' => true,
        'amount_net' => true,
        'amount_vat' => true,
        'amount_gross' => true,
        'amount_due_discount' => true,
        'amount_rivalsa' => true,
        'amount_rivalsa_taxable' => true,
        'amount_withholding_tax' => true,
        'amount_withholding_tax_taxable' => true,
        'amount_other_withholding_tax' => true,
        'amount_other_withholding_tax_taxable' => true,
        'amount_enasarco_taxable' => true,
        'extra_data' => true,
        'seen_date' => true,
        'next_due_date' => true,
        'url' => true,
        'dn_url' => true,
        'ai_url' => true,
        'attachment_url' => true,
        'attachment_token' => true,
        'ei_raw' => true,
        'ei_status' => true,
        'locked' => true,
        'created_at' => true,
        'updated_at' => true
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull($openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'id' => 'id',
        'entity' => 'entity',
        'type' => 'type',
        'number' => 'number',
        'numeration' => 'numeration',
        'date' => 'date',
        'year' => 'year',
        'currency' => 'currency',
        'language' => 'language',
        'subject' => 'subject',
        'visible_subject' => 'visible_subject',
        'rc_center' => 'rc_center',
        'notes' => 'notes',
        'rivalsa' => 'rivalsa',
        'cassa' => 'cassa',
        'amount_cassa' => 'amount_cassa',
        'cassa_taxable' => 'cassa_taxable',
        'amount_cassa_taxable' => 'amount_cassa_taxable',
        'cassa2' => 'cassa2',
        'amount_cassa2' => 'amount_cassa2',
        'cassa2_taxable' => 'cassa2_taxable',
        'amount_cassa2_taxable' => 'amount_cassa2_taxable',
        'global_cassa_taxable' => 'global_cassa_taxable',
        'amount_global_cassa_taxable' => 'amount_global_cassa_taxable',
        'withholding_tax' => 'withholding_tax',
        'withholding_tax_taxable' => 'withholding_tax_taxable',
        'other_withholding_tax' => 'other_withholding_tax',
        'stamp_duty' => 'stamp_duty',
        'payment_method' => 'payment_method',
        'use_split_payment' => 'use_split_payment',
        'use_gross_prices' => 'use_gross_prices',
        'e_invoice' => 'e_invoice',
        'ei_data' => 'ei_data',
        'ei_cassa_type' => 'ei_cassa_type',
        'ei_cassa2_type' => 'ei_cassa2_type',
        'ei_withholding_tax_causal' => 'ei_withholding_tax_causal',
        'ei_other_withholding_tax_type' => 'ei_other_withholding_tax_type',
        'ei_other_withholding_tax_causal' => 'ei_other_withholding_tax_causal',
        'items_list' => 'items_list',
        'payments_list' => 'payments_list',
        'template' => 'template',
        'delivery_note_template' => 'delivery_note_template',
        'acc_inv_template' => 'acc_inv_template',
        'h_margins' => 'h_margins',
        'v_margins' => 'v_margins',
        'show_payments' => 'show_payments',
        'show_payment_method' => 'show_payment_method',
        'show_totals' => 'show_totals',
        'show_notification_button' => 'show_notification_button',
        'show_tspay_button' => 'show_tspay_button',
        'delivery_note' => 'delivery_note',
        'accompanying_invoice' => 'accompanying_invoice',
        'dn_number' => 'dn_number',
        'dn_date' => 'dn_date',
        'dn_ai_packages_number' => 'dn_ai_packages_number',
        'dn_ai_weight' => 'dn_ai_weight',
        'dn_ai_causal' => 'dn_ai_causal',
        'dn_ai_destination' => 'dn_ai_destination',
        'dn_ai_transporter' => 'dn_ai_transporter',
        'dn_ai_notes' => 'dn_ai_notes',
        'is_marked' => 'is_marked',
        'amount_net' => 'amount_net',
        'amount_vat' => 'amount_vat',
        'amount_gross' => 'amount_gross',
        'amount_due_discount' => 'amount_due_discount',
        'amount_rivalsa' => 'amount_rivalsa',
        'amount_rivalsa_taxable' => 'amount_rivalsa_taxable',
        'amount_withholding_tax' => 'amount_withholding_tax',
        'amount_withholding_tax_taxable' => 'amount_withholding_tax_taxable',
        'amount_other_withholding_tax' => 'amount_other_withholding_tax',
        'amount_other_withholding_tax_taxable' => 'amount_other_withholding_tax_taxable',
        'amount_enasarco_taxable' => 'amount_enasarco_taxable',
        'extra_data' => 'extra_data',
        'seen_date' => 'seen_date',
        'next_due_date' => 'next_due_date',
        'url' => 'url',
        'dn_url' => 'dn_url',
        'ai_url' => 'ai_url',
        'attachment_url' => 'attachment_url',
        'attachment_token' => 'attachment_token',
        'ei_raw' => 'ei_raw',
        'ei_status' => 'ei_status',
        'locked' => 'locked',
        'created_at' => 'created_at',
        'updated_at' => 'updated_at'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'id' => 'setId',
        'entity' => 'setEntity',
        'type' => 'setType',
        'number' => 'setNumber',
        'numeration' => 'setNumeration',
        'date' => 'setDate',
        'year' => 'setYear',
        'currency' => 'setCurrency',
        'language' => 'setLanguage',
        'subject' => 'setSubject',
        'visible_subject' => 'setVisibleSubject',
        'rc_center' => 'setRcCenter',
        'notes' => 'setNotes',
        'rivalsa' => 'setRivalsa',
        'cassa' => 'setCassa',
        'amount_cassa' => 'setAmountCassa',
        'cassa_taxable' => 'setCassaTaxable',
        'amount_cassa_taxable' => 'setAmountCassaTaxable',
        'cassa2' => 'setCassa2',
        'amount_cassa2' => 'setAmountCassa2',
        'cassa2_taxable' => 'setCassa2Taxable',
        'amount_cassa2_taxable' => 'setAmountCassa2Taxable',
        'global_cassa_taxable' => 'setGlobalCassaTaxable',
        'amount_global_cassa_taxable' => 'setAmountGlobalCassaTaxable',
        'withholding_tax' => 'setWithholdingTax',
        'withholding_tax_taxable' => 'setWithholdingTaxTaxable',
        'other_withholding_tax' => 'setOtherWithholdingTax',
        'stamp_duty' => 'setStampDuty',
        'payment_method' => 'setPaymentMethod',
        'use_split_payment' => 'setUseSplitPayment',
        'use_gross_prices' => 'setUseGrossPrices',
        'e_invoice' => 'setEInvoice',
        'ei_data' => 'setEiData',
        'ei_cassa_type' => 'setEiCassaType',
        'ei_cassa2_type' => 'setEiCassa2Type',
        'ei_withholding_tax_causal' => 'setEiWithholdingTaxCausal',
        'ei_other_withholding_tax_type' => 'setEiOtherWithholdingTaxType',
        'ei_other_withholding_tax_causal' => 'setEiOtherWithholdingTaxCausal',
        'items_list' => 'setItemsList',
        'payments_list' => 'setPaymentsList',
        'template' => 'setTemplate',
        'delivery_note_template' => 'setDeliveryNoteTemplate',
        'acc_inv_template' => 'setAccInvTemplate',
        'h_margins' => 'setHMargins',
        'v_margins' => 'setVMargins',
        'show_payments' => 'setShowPayments',
        'show_payment_method' => 'setShowPaymentMethod',
        'show_totals' => 'setShowTotals',
        'show_notification_button' => 'setShowNotificationButton',
        'show_tspay_button' => 'setShowTspayButton',
        'delivery_note' => 'setDeliveryNote',
        'accompanying_invoice' => 'setAccompanyingInvoice',
        'dn_number' => 'setDnNumber',
        'dn_date' => 'setDnDate',
        'dn_ai_packages_number' => 'setDnAiPackagesNumber',
        'dn_ai_weight' => 'setDnAiWeight',
        'dn_ai_causal' => 'setDnAiCausal',
        'dn_ai_destination' => 'setDnAiDestination',
        'dn_ai_transporter' => 'setDnAiTransporter',
        'dn_ai_notes' => 'setDnAiNotes',
        'is_marked' => 'setIsMarked',
        'amount_net' => 'setAmountNet',
        'amount_vat' => 'setAmountVat',
        'amount_gross' => 'setAmountGross',
        'amount_due_discount' => 'setAmountDueDiscount',
        'amount_rivalsa' => 'setAmountRivalsa',
        'amount_rivalsa_taxable' => 'setAmountRivalsaTaxable',
        'amount_withholding_tax' => 'setAmountWithholdingTax',
        'amount_withholding_tax_taxable' => 'setAmountWithholdingTaxTaxable',
        'amount_other_withholding_tax' => 'setAmountOtherWithholdingTax',
        'amount_other_withholding_tax_taxable' => 'setAmountOtherWithholdingTaxTaxable',
        'amount_enasarco_taxable' => 'setAmountEnasarcoTaxable',
        'extra_data' => 'setExtraData',
        'seen_date' => 'setSeenDate',
        'next_due_date' => 'setNextDueDate',
        'url' => 'setUrl',
        'dn_url' => 'setDnUrl',
        'ai_url' => 'setAiUrl',
        'attachment_url' => 'setAttachmentUrl',
        'attachment_token' => 'setAttachmentToken',
        'ei_raw' => 'setEiRaw',
        'ei_status' => 'setEiStatus',
        'locked' => 'setLocked',
        'created_at' => 'setCreatedAt',
        'updated_at' => 'setUpdatedAt'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'id' => 'getId',
        'entity' => 'getEntity',
        'type' => 'getType',
        'number' => 'getNumber',
        'numeration' => 'getNumeration',
        'date' => 'getDate',
        'year' => 'getYear',
        'currency' => 'getCurrency',
        'language' => 'getLanguage',
        'subject' => 'getSubject',
        'visible_subject' => 'getVisibleSubject',
        'rc_center' => 'getRcCenter',
        'notes' => 'getNotes',
        'rivalsa' => 'getRivalsa',
        'cassa' => 'getCassa',
        'amount_cassa' => 'getAmountCassa',
        'cassa_taxable' => 'getCassaTaxable',
        'amount_cassa_taxable' => 'getAmountCassaTaxable',
        'cassa2' => 'getCassa2',
        'amount_cassa2' => 'getAmountCassa2',
        'cassa2_taxable' => 'getCassa2Taxable',
        'amount_cassa2_taxable' => 'getAmountCassa2Taxable',
        'global_cassa_taxable' => 'getGlobalCassaTaxable',
        'amount_global_cassa_taxable' => 'getAmountGlobalCassaTaxable',
        'withholding_tax' => 'getWithholdingTax',
        'withholding_tax_taxable' => 'getWithholdingTaxTaxable',
        'other_withholding_tax' => 'getOtherWithholdingTax',
        'stamp_duty' => 'getStampDuty',
        'payment_method' => 'getPaymentMethod',
        'use_split_payment' => 'getUseSplitPayment',
        'use_gross_prices' => 'getUseGrossPrices',
        'e_invoice' => 'getEInvoice',
        'ei_data' => 'getEiData',
        'ei_cassa_type' => 'getEiCassaType',
        'ei_cassa2_type' => 'getEiCassa2Type',
        'ei_withholding_tax_causal' => 'getEiWithholdingTaxCausal',
        'ei_other_withholding_tax_type' => 'getEiOtherWithholdingTaxType',
        'ei_other_withholding_tax_causal' => 'getEiOtherWithholdingTaxCausal',
        'items_list' => 'getItemsList',
        'payments_list' => 'getPaymentsList',
        'template' => 'getTemplate',
        'delivery_note_template' => 'getDeliveryNoteTemplate',
        'acc_inv_template' => 'getAccInvTemplate',
        'h_margins' => 'getHMargins',
        'v_margins' => 'getVMargins',
        'show_payments' => 'getShowPayments',
        'show_payment_method' => 'getShowPaymentMethod',
        'show_totals' => 'getShowTotals',
        'show_notification_button' => 'getShowNotificationButton',
        'show_tspay_button' => 'getShowTspayButton',
        'delivery_note' => 'getDeliveryNote',
        'accompanying_invoice' => 'getAccompanyingInvoice',
        'dn_number' => 'getDnNumber',
        'dn_date' => 'getDnDate',
        'dn_ai_packages_number' => 'getDnAiPackagesNumber',
        'dn_ai_weight' => 'getDnAiWeight',
        'dn_ai_causal' => 'getDnAiCausal',
        'dn_ai_destination' => 'getDnAiDestination',
        'dn_ai_transporter' => 'getDnAiTransporter',
        'dn_ai_notes' => 'getDnAiNotes',
        'is_marked' => 'getIsMarked',
        'amount_net' => 'getAmountNet',
        'amount_vat' => 'getAmountVat',
        'amount_gross' => 'getAmountGross',
        'amount_due_discount' => 'getAmountDueDiscount',
        'amount_rivalsa' => 'getAmountRivalsa',
        'amount_rivalsa_taxable' => 'getAmountRivalsaTaxable',
        'amount_withholding_tax' => 'getAmountWithholdingTax',
        'amount_withholding_tax_taxable' => 'getAmountWithholdingTaxTaxable',
        'amount_other_withholding_tax' => 'getAmountOtherWithholdingTax',
        'amount_other_withholding_tax_taxable' => 'getAmountOtherWithholdingTaxTaxable',
        'amount_enasarco_taxable' => 'getAmountEnasarcoTaxable',
        'extra_data' => 'getExtraData',
        'seen_date' => 'getSeenDate',
        'next_due_date' => 'getNextDueDate',
        'url' => 'getUrl',
        'dn_url' => 'getDnUrl',
        'ai_url' => 'getAiUrl',
        'attachment_url' => 'getAttachmentUrl',
        'attachment_token' => 'getAttachmentToken',
        'ei_raw' => 'getEiRaw',
        'ei_status' => 'getEiStatus',
        'locked' => 'getLocked',
        'created_at' => 'getCreatedAt',
        'updated_at' => 'getUpdatedAt'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }

    public const EI_STATUS_ATTEMPT = 'attempt';
    public const EI_STATUS_MISSING = 'missing';
    public const EI_STATUS_NOT_SENT = 'not_sent';
    public const EI_STATUS_SENT = 'sent';
    public const EI_STATUS_PENDING = 'pending';
    public const EI_STATUS_PROCESSING = 'processing';
    public const EI_STATUS_ERROR = 'error';
    public const EI_STATUS_DISCARDED = 'discarded';
    public const EI_STATUS_NOT_DELIVERED = 'not_delivered';
    public const EI_STATUS_ACCEPTED = 'accepted';
    public const EI_STATUS_REJECTED = 'rejected';
    public const EI_STATUS_NO_RESPONSE = 'no_response';
    public const EI_STATUS_MANUAL_ACCEPTED = 'manual_accepted';
    public const EI_STATUS_MANUAL_REJECTED = 'manual_rejected';

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getEiStatusAllowableValues()
    {
        return [
            self::EI_STATUS_ATTEMPT,
            self::EI_STATUS_MISSING,
            self::EI_STATUS_NOT_SENT,
            self::EI_STATUS_SENT,
            self::EI_STATUS_PENDING,
            self::EI_STATUS_PROCESSING,
            self::EI_STATUS_ERROR,
            self::EI_STATUS_DISCARDED,
            self::EI_STATUS_NOT_DELIVERED,
            self::EI_STATUS_ACCEPTED,
            self::EI_STATUS_REJECTED,
            self::EI_STATUS_NO_RESPONSE,
            self::EI_STATUS_MANUAL_ACCEPTED,
            self::EI_STATUS_MANUAL_REJECTED,
        ];
    }

    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct($data = null)
    {
        $this->setIfExists('id', $data ?? [], null);
        $this->setIfExists('entity', $data ?? [], null);
        $this->setIfExists('type', $data ?? [], null);
        $this->setIfExists('number', $data ?? [], null);
        $this->setIfExists('numeration', $data ?? [], null);
        $this->setIfExists('date', $data ?? [], null);
        $this->setIfExists('year', $data ?? [], null);
        $this->setIfExists('currency', $data ?? [], null);
        $this->setIfExists('language', $data ?? [], null);
        $this->setIfExists('subject', $data ?? [], null);
        $this->setIfExists('visible_subject', $data ?? [], null);
        $this->setIfExists('rc_center', $data ?? [], null);
        $this->setIfExists('notes', $data ?? [], null);
        $this->setIfExists('rivalsa', $data ?? [], null);
        $this->setIfExists('cassa', $data ?? [], null);
        $this->setIfExists('amount_cassa', $data ?? [], null);
        $this->setIfExists('cassa_taxable', $data ?? [], null);
        $this->setIfExists('amount_cassa_taxable', $data ?? [], null);
        $this->setIfExists('cassa2', $data ?? [], null);
        $this->setIfExists('amount_cassa2', $data ?? [], null);
        $this->setIfExists('cassa2_taxable', $data ?? [], null);
        $this->setIfExists('amount_cassa2_taxable', $data ?? [], null);
        $this->setIfExists('global_cassa_taxable', $data ?? [], null);
        $this->setIfExists('amount_global_cassa_taxable', $data ?? [], null);
        $this->setIfExists('withholding_tax', $data ?? [], null);
        $this->setIfExists('withholding_tax_taxable', $data ?? [], null);
        $this->setIfExists('other_withholding_tax', $data ?? [], null);
        $this->setIfExists('stamp_duty', $data ?? [], null);
        $this->setIfExists('payment_method', $data ?? [], null);
        $this->setIfExists('use_split_payment', $data ?? [], null);
        $this->setIfExists('use_gross_prices', $data ?? [], null);
        $this->setIfExists('e_invoice', $data ?? [], null);
        $this->setIfExists('ei_data', $data ?? [], null);
        $this->setIfExists('ei_cassa_type', $data ?? [], null);
        $this->setIfExists('ei_cassa2_type', $data ?? [], null);
        $this->setIfExists('ei_withholding_tax_causal', $data ?? [], null);
        $this->setIfExists('ei_other_withholding_tax_type', $data ?? [], null);
        $this->setIfExists('ei_other_withholding_tax_causal', $data ?? [], null);
        $this->setIfExists('items_list', $data ?? [], null);
        $this->setIfExists('payments_list', $data ?? [], null);
        $this->setIfExists('template', $data ?? [], null);
        $this->setIfExists('delivery_note_template', $data ?? [], null);
        $this->setIfExists('acc_inv_template', $data ?? [], null);
        $this->setIfExists('h_margins', $data ?? [], null);
        $this->setIfExists('v_margins', $data ?? [], null);
        $this->setIfExists('show_payments', $data ?? [], null);
        $this->setIfExists('show_payment_method', $data ?? [], null);
        $this->setIfExists('show_totals', $data ?? [], null);
        $this->setIfExists('show_notification_button', $data ?? [], null);
        $this->setIfExists('show_tspay_button', $data ?? [], null);
        $this->setIfExists('delivery_note', $data ?? [], null);
        $this->setIfExists('accompanying_invoice', $data ?? [], null);
        $this->setIfExists('dn_number', $data ?? [], null);
        $this->setIfExists('dn_date', $data ?? [], null);
        $this->setIfExists('dn_ai_packages_number', $data ?? [], null);
        $this->setIfExists('dn_ai_weight', $data ?? [], null);
        $this->setIfExists('dn_ai_causal', $data ?? [], null);
        $this->setIfExists('dn_ai_destination', $data ?? [], null);
        $this->setIfExists('dn_ai_transporter', $data ?? [], null);
        $this->setIfExists('dn_ai_notes', $data ?? [], null);
        $this->setIfExists('is_marked', $data ?? [], null);
        $this->setIfExists('amount_net', $data ?? [], null);
        $this->setIfExists('amount_vat', $data ?? [], null);
        $this->setIfExists('amount_gross', $data ?? [], null);
        $this->setIfExists('amount_due_discount', $data ?? [], null);
        $this->setIfExists('amount_rivalsa', $data ?? [], null);
        $this->setIfExists('amount_rivalsa_taxable', $data ?? [], null);
        $this->setIfExists('amount_withholding_tax', $data ?? [], null);
        $this->setIfExists('amount_withholding_tax_taxable', $data ?? [], null);
        $this->setIfExists('amount_other_withholding_tax', $data ?? [], null);
        $this->setIfExists('amount_other_withholding_tax_taxable', $data ?? [], null);
        $this->setIfExists('amount_enasarco_taxable', $data ?? [], null);
        $this->setIfExists('extra_data', $data ?? [], null);
        $this->setIfExists('seen_date', $data ?? [], null);
        $this->setIfExists('next_due_date', $data ?? [], null);
        $this->setIfExists('url', $data ?? [], null);
        $this->setIfExists('dn_url', $data ?? [], null);
        $this->setIfExists('ai_url', $data ?? [], null);
        $this->setIfExists('attachment_url', $data ?? [], null);
        $this->setIfExists('attachment_token', $data ?? [], null);
        $this->setIfExists('ei_raw', $data ?? [], null);
        $this->setIfExists('ei_status', $data ?? [], null);
        $this->setIfExists('locked', $data ?? [], null);
        $this->setIfExists('created_at', $data ?? [], null);
        $this->setIfExists('updated_at', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        $allowedValues = $this->getEiStatusAllowableValues();
        if (!is_null($this->container['ei_status']) && !in_array($this->container['ei_status'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'ei_status', must be one of '%s'",
                $this->container['ei_status'],
                implode("', '", $allowedValues)
            );
        }

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets id
     *
     * @return int|null
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     *
     * @param int|null $id Issued document id
     *
     * @return self
     */
    public function setId($id)
    {
        if (is_null($id)) {
            array_push($this->openAPINullablesSetToNull, 'id');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('id', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets entity
     *
     * @return \FattureInCloud\Model\Entity|null
     */
    public function getEntity()
    {
        return $this->container['entity'];
    }

    /**
     * Sets entity
     *
     * @param \FattureInCloud\Model\Entity|null $entity entity
     *
     * @return self
     */
    public function setEntity($entity)
    {
        if (is_null($entity)) {
            throw new \InvalidArgumentException('non-nullable entity cannot be null');
        }
        $this->container['entity'] = $entity;

        return $this;
    }

    /**
     * Gets type
     *
     * @return string|null
     */
    public function getType()
    {
        return $this->container['type'];
    }

    /**
     * Sets type, the accepted values are available in \FattureInCloud\Model\IssuedDocumentType
     *
     * @param string|null $type type
     *
     * @return self
     */
    public function setType($type)
    {
        if (is_null($type)) {
            throw new \InvalidArgumentException('non-nullable type cannot be null');
        }
        $this->container['type'] = $type;

        return $this;
    }

    /**
     * Gets number
     *
     * @return int|null
     */
    public function getNumber()
    {
        return $this->container['number'];
    }

    /**
     * Sets number
     *
     * @param int|null $number Issued document number [If not specified, next number is used]
     *
     * @return self
     */
    public function setNumber($number)
    {
        if (is_null($number)) {
            array_push($this->openAPINullablesSetToNull, 'number');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('number', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['number'] = $number;

        return $this;
    }

    /**
     * Gets numeration
     *
     * @return string|null
     */
    public function getNumeration()
    {
        return $this->container['numeration'];
    }

    /**
     * Sets numeration
     *
     * @param string|null $numeration Issued document numeration [Not available if type=delivery_note]
     *
     * @return self
     */
    public function setNumeration($numeration)
    {
        if (is_null($numeration)) {
            array_push($this->openAPINullablesSetToNull, 'numeration');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('numeration', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['numeration'] = $numeration;

        return $this;
    }

    /**
     * Gets date
     *
     * @return \DateTime|null
     */
    public function getDate()
    {
        return $this->container['date'];
    }

    /**
     * Sets date
     *
     * @param \DateTime|null $date Issued document date [defaults to today's date]
     *
     * @return self
     */
    public function setDate($date)
    {
        if (is_null($date)) {
            array_push($this->openAPINullablesSetToNull, 'date');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('date', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['date'] = $date;

        return $this;
    }

    /**
     * Gets year
     *
     * @return int|null
     */
    public function getYear()
    {
        return $this->container['year'];
    }

    /**
     * Sets year
     *
     * @param int|null $year Issued document year
     *
     * @return self
     */
    public function setYear($year)
    {
        if (is_null($year)) {
            array_push($this->openAPINullablesSetToNull, 'year');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('year', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['year'] = $year;

        return $this;
    }

    /**
     * Gets currency
     *
     * @return \FattureInCloud\Model\Currency|null
     */
    public function getCurrency()
    {
        return $this->container['currency'];
    }

    /**
     * Sets currency
     *
     * @param \FattureInCloud\Model\Currency|null $currency currency
     *
     * @return self
     */
    public function setCurrency($currency)
    {
        if (is_null($currency)) {
            throw new \InvalidArgumentException('non-nullable currency cannot be null');
        }
        $this->container['currency'] = $currency;

        return $this;
    }

    /**
     * Gets language
     *
     * @return \FattureInCloud\Model\Language|null
     */
    public function getLanguage()
    {
        return $this->container['language'];
    }

    /**
     * Sets language
     *
     * @param \FattureInCloud\Model\Language|null $language language
     *
     * @return self
     */
    public function setLanguage($language)
    {
        if (is_null($language)) {
            throw new \InvalidArgumentException('non-nullable language cannot be null');
        }
        $this->container['language'] = $language;

        return $this;
    }

    /**
     * Gets subject
     *
     * @return string|null
     */
    public function getSubject()
    {
        return $this->container['subject'];
    }

    /**
     * Sets subject
     *
     * @param string|null $subject Issued document subject [not shown on the PDF]
     *
     * @return self
     */
    public function setSubject($subject)
    {
        if (is_null($subject)) {
            array_push($this->openAPINullablesSetToNull, 'subject');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('subject', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['subject'] = $subject;

        return $this;
    }

    /**
     * Gets visible_subject
     *
     * @return string|null
     */
    public function getVisibleSubject()
    {
        return $this->container['visible_subject'];
    }

    /**
     * Sets visible_subject
     *
     * @param string|null $visible_subject Issued document visible subject
     *
     * @return self
     */
    public function setVisibleSubject($visible_subject)
    {
        if (is_null($visible_subject)) {
            array_push($this->openAPINullablesSetToNull, 'visible_subject');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('visible_subject', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['visible_subject'] = $visible_subject;

        return $this;
    }

    /**
     * Gets rc_center
     *
     * @return string|null
     */
    public function getRcCenter()
    {
        return $this->container['rc_center'];
    }

    /**
     * Sets rc_center
     *
     * @param string|null $rc_center Issued document revenue center [or cost center if type=supplier_order].
     *
     * @return self
     */
    public function setRcCenter($rc_center)
    {
        if (is_null($rc_center)) {
            array_push($this->openAPINullablesSetToNull, 'rc_center');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('rc_center', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['rc_center'] = $rc_center;

        return $this;
    }

    /**
     * Gets notes
     *
     * @return string|null
     */
    public function getNotes()
    {
        return $this->container['notes'];
    }

    /**
     * Sets notes
     *
     * @param string|null $notes Issued document extra notes
     *
     * @return self
     */
    public function setNotes($notes)
    {
        if (is_null($notes)) {
            array_push($this->openAPINullablesSetToNull, 'notes');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('notes', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['notes'] = $notes;

        return $this;
    }

    /**
     * Gets rivalsa
     *
     * @return float|null
     */
    public function getRivalsa()
    {
        return $this->container['rivalsa'];
    }

    /**
     * Sets rivalsa
     *
     * @param float|null $rivalsa Issued document \"Rivalsa INPS\" percentual value
     *
     * @return self
     */
    public function setRivalsa($rivalsa)
    {
        if (is_null($rivalsa)) {
            array_push($this->openAPINullablesSetToNull, 'rivalsa');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('rivalsa', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['rivalsa'] = $rivalsa;

        return $this;
    }

    /**
     * Gets cassa
     *
     * @return float|null
     */
    public function getCassa()
    {
        return $this->container['cassa'];
    }

    /**
     * Sets cassa
     *
     * @param float|null $cassa Issued document \"Cassa previdenziale\" percentual value
     *
     * @return self
     */
    public function setCassa($cassa)
    {
        if (is_null($cassa)) {
            array_push($this->openAPINullablesSetToNull, 'cassa');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('cassa', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['cassa'] = $cassa;

        return $this;
    }

    /**
     * Gets amount_cassa
     *
     * @return float|null
     */
    public function getAmountCassa()
    {
        return $this->container['amount_cassa'];
    }

    /**
     * Sets amount_cassa
     *
     * @param float|null $amount_cassa [Read Only] Issued document cassa amount.
     *
     * @return self
     */
    public function setAmountCassa($amount_cassa)
    {
        if (is_null($amount_cassa)) {
            array_push($this->openAPINullablesSetToNull, 'amount_cassa');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('amount_cassa', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['amount_cassa'] = $amount_cassa;

        return $this;
    }

    /**
     * Gets cassa_taxable
     *
     * @return float|null
     */
    public function getCassaTaxable()
    {
        return $this->container['cassa_taxable'];
    }

    /**
     * Sets cassa_taxable
     *
     * @param float|null $cassa_taxable Issued document cassa taxable percentage
     *
     * @return self
     */
    public function setCassaTaxable($cassa_taxable)
    {
        if (is_null($cassa_taxable)) {
            array_push($this->openAPINullablesSetToNull, 'cassa_taxable');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('cassa_taxable', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['cassa_taxable'] = $cassa_taxable;

        return $this;
    }

    /**
     * Gets amount_cassa_taxable
     *
     * @return float|null
     */
    public function getAmountCassaTaxable()
    {
        return $this->container['amount_cassa_taxable'];
    }

    /**
     * Sets amount_cassa_taxable
     *
     * @param float|null $amount_cassa_taxable [Can be set only if cassa_taxable is NULL] Issued document cassa taxable amount
     *
     * @return self
     */
    public function setAmountCassaTaxable($amount_cassa_taxable)
    {
        if (is_null($amount_cassa_taxable)) {
            array_push($this->openAPINullablesSetToNull, 'amount_cassa_taxable');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('amount_cassa_taxable', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['amount_cassa_taxable'] = $amount_cassa_taxable;

        return $this;
    }

    /**
     * Gets cassa2
     *
     * @return float|null
     */
    public function getCassa2()
    {
        return $this->container['cassa2'];
    }

    /**
     * Sets cassa2
     *
     * @param float|null $cassa2 Issued document \"Cassa previdenziale 2\" percentual value
     *
     * @return self
     */
    public function setCassa2($cassa2)
    {
        if (is_null($cassa2)) {
            array_push($this->openAPINullablesSetToNull, 'cassa2');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('cassa2', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['cassa2'] = $cassa2;

        return $this;
    }

    /**
     * Gets amount_cassa2
     *
     * @return float|null
     */
    public function getAmountCassa2()
    {
        return $this->container['amount_cassa2'];
    }

    /**
     * Sets amount_cassa2
     *
     * @param float|null $amount_cassa2 [Read Only] Issued document cassa2 amount
     *
     * @return self
     */
    public function setAmountCassa2($amount_cassa2)
    {
        if (is_null($amount_cassa2)) {
            array_push($this->openAPINullablesSetToNull, 'amount_cassa2');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('amount_cassa2', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['amount_cassa2'] = $amount_cassa2;

        return $this;
    }

    /**
     * Gets cassa2_taxable
     *
     * @return float|null
     */
    public function getCassa2Taxable()
    {
        return $this->container['cassa2_taxable'];
    }

    /**
     * Sets cassa2_taxable
     *
     * @param float|null $cassa2_taxable Issued document cassa2 taxable percentage
     *
     * @return self
     */
    public function setCassa2Taxable($cassa2_taxable)
    {
        if (is_null($cassa2_taxable)) {
            array_push($this->openAPINullablesSetToNull, 'cassa2_taxable');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('cassa2_taxable', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['cassa2_taxable'] = $cassa2_taxable;

        return $this;
    }

    /**
     * Gets amount_cassa2_taxable
     *
     * @return float|null
     */
    public function getAmountCassa2Taxable()
    {
        return $this->container['amount_cassa2_taxable'];
    }

    /**
     * Sets amount_cassa2_taxable
     *
     * @param float|null $amount_cassa2_taxable [Can be set only if cassa2_taxable is NULL] Issued document cassa2 taxable amount
     *
     * @return self
     */
    public function setAmountCassa2Taxable($amount_cassa2_taxable)
    {
        if (is_null($amount_cassa2_taxable)) {
            array_push($this->openAPINullablesSetToNull, 'amount_cassa2_taxable');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('amount_cassa2_taxable', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['amount_cassa2_taxable'] = $amount_cassa2_taxable;

        return $this;
    }

    /**
     * Gets global_cassa_taxable
     *
     * @return float|null
     */
    public function getGlobalCassaTaxable()
    {
        return $this->container['global_cassa_taxable'];
    }

    /**
     * Sets global_cassa_taxable
     *
     * @param float|null $global_cassa_taxable Issued document global cassa taxable percentage
     *
     * @return self
     */
    public function setGlobalCassaTaxable($global_cassa_taxable)
    {
        if (is_null($global_cassa_taxable)) {
            array_push($this->openAPINullablesSetToNull, 'global_cassa_taxable');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('global_cassa_taxable', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['global_cassa_taxable'] = $global_cassa_taxable;

        return $this;
    }

    /**
     * Gets amount_global_cassa_taxable
     *
     * @return float|null
     */
    public function getAmountGlobalCassaTaxable()
    {
        return $this->container['amount_global_cassa_taxable'];
    }

    /**
     * Sets amount_global_cassa_taxable
     *
     * @param float|null $amount_global_cassa_taxable [Can be set only if global_cassa_taxable is NULL] Issued document global cassa taxable amount
     *
     * @return self
     */
    public function setAmountGlobalCassaTaxable($amount_global_cassa_taxable)
    {
        if (is_null($amount_global_cassa_taxable)) {
            array_push($this->openAPINullablesSetToNull, 'amount_global_cassa_taxable');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('amount_global_cassa_taxable', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['amount_global_cassa_taxable'] = $amount_global_cassa_taxable;

        return $this;
    }

    /**
     * Gets withholding_tax
     *
     * @return float|null
     */
    public function getWithholdingTax()
    {
        return $this->container['withholding_tax'];
    }

    /**
     * Sets withholding_tax
     *
     * @param float|null $withholding_tax Issued document withholding tax (ritenuta d'acconto) percentual value
     *
     * @return self
     */
    public function setWithholdingTax($withholding_tax)
    {
        if (is_null($withholding_tax)) {
            array_push($this->openAPINullablesSetToNull, 'withholding_tax');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('withholding_tax', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['withholding_tax'] = $withholding_tax;

        return $this;
    }

    /**
     * Gets withholding_tax_taxable
     *
     * @return float|null
     */
    public function getWithholdingTaxTaxable()
    {
        return $this->container['withholding_tax_taxable'];
    }

    /**
     * Sets withholding_tax_taxable
     *
     * @param float|null $withholding_tax_taxable Issued document withholding tax taxable (imponibile) percentual value
     *
     * @return self
     */
    public function setWithholdingTaxTaxable($withholding_tax_taxable)
    {
        if (is_null($withholding_tax_taxable)) {
            array_push($this->openAPINullablesSetToNull, 'withholding_tax_taxable');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('withholding_tax_taxable', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['withholding_tax_taxable'] = $withholding_tax_taxable;

        return $this;
    }

    /**
     * Gets other_withholding_tax
     *
     * @return float|null
     */
    public function getOtherWithholdingTax()
    {
        return $this->container['other_withholding_tax'];
    }

    /**
     * Sets other_withholding_tax
     *
     * @param float|null $other_withholding_tax Issued document other withholding tax (altra ritenuta) percentual value
     *
     * @return self
     */
    public function setOtherWithholdingTax($other_withholding_tax)
    {
        if (is_null($other_withholding_tax)) {
            array_push($this->openAPINullablesSetToNull, 'other_withholding_tax');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('other_withholding_tax', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['other_withholding_tax'] = $other_withholding_tax;

        return $this;
    }

    /**
     * Gets stamp_duty
     *
     * @return float|null
     */
    public function getStampDuty()
    {
        return $this->container['stamp_duty'];
    }

    /**
     * Sets stamp_duty
     *
     * @param float|null $stamp_duty Issued document stamp duty value [0 if not present]
     *
     * @return self
     */
    public function setStampDuty($stamp_duty)
    {
        if (is_null($stamp_duty)) {
            array_push($this->openAPINullablesSetToNull, 'stamp_duty');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('stamp_duty', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['stamp_duty'] = $stamp_duty;

        return $this;
    }

    /**
     * Gets payment_method
     *
     * @return \FattureInCloud\Model\PaymentMethod|null
     */
    public function getPaymentMethod()
    {
        return $this->container['payment_method'];
    }

    /**
     * Sets payment_method
     *
     * @param \FattureInCloud\Model\PaymentMethod|null $payment_method payment_method
     *
     * @return self
     */
    public function setPaymentMethod($payment_method)
    {
        if (is_null($payment_method)) {
            throw new \InvalidArgumentException('non-nullable payment_method cannot be null');
        }
        $this->container['payment_method'] = $payment_method;

        return $this;
    }

    /**
     * Gets use_split_payment
     *
     * @return bool|null
     */
    public function getUseSplitPayment()
    {
        return $this->container['use_split_payment'];
    }

    /**
     * Sets use_split_payment
     *
     * @param bool|null $use_split_payment Issued document uses split payment
     *
     * @return self
     */
    public function setUseSplitPayment($use_split_payment)
    {
        if (is_null($use_split_payment)) {
            array_push($this->openAPINullablesSetToNull, 'use_split_payment');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('use_split_payment', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['use_split_payment'] = $use_split_payment;

        return $this;
    }

    /**
     * Gets use_gross_prices
     *
     * @return bool|null
     */
    public function getUseGrossPrices()
    {
        return $this->container['use_gross_prices'];
    }

    /**
     * Sets use_gross_prices
     *
     * @param bool|null $use_gross_prices Issued document uses gross prices
     *
     * @return self
     */
    public function setUseGrossPrices($use_gross_prices)
    {
        if (is_null($use_gross_prices)) {
            array_push($this->openAPINullablesSetToNull, 'use_gross_prices');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('use_gross_prices', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['use_gross_prices'] = $use_gross_prices;

        return $this;
    }

    /**
     * Gets e_invoice
     *
     * @return bool|null
     */
    public function getEInvoice()
    {
        return $this->container['e_invoice'];
    }

    /**
     * Sets e_invoice
     *
     * @param bool|null $e_invoice Issued document is an e-invoice.
     *
     * @return self
     */
    public function setEInvoice($e_invoice)
    {
        if (is_null($e_invoice)) {
            array_push($this->openAPINullablesSetToNull, 'e_invoice');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('e_invoice', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['e_invoice'] = $e_invoice;

        return $this;
    }

    /**
     * Gets ei_data
     *
     * @return \FattureInCloud\Model\IssuedDocumentEiData|null
     */
    public function getEiData()
    {
        return $this->container['ei_data'];
    }

    /**
     * Sets ei_data
     *
     * @param \FattureInCloud\Model\IssuedDocumentEiData|null $ei_data ei_data
     *
     * @return self
     */
    public function setEiData($ei_data)
    {
        if (is_null($ei_data)) {
            array_push($this->openAPINullablesSetToNull, 'ei_data');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('ei_data', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['ei_data'] = $ei_data;

        return $this;
    }

    /**
     * Gets ei_cassa_type
     *
     * @return string|null
     */
    public function getEiCassaType()
    {
        return $this->container['ei_cassa_type'];
    }

    /**
     * Sets ei_cassa_type
     *
     * @param string|null $ei_cassa_type E-invoice cassa type
     *
     * @return self
     */
    public function setEiCassaType($ei_cassa_type)
    {
        if (is_null($ei_cassa_type)) {
            array_push($this->openAPINullablesSetToNull, 'ei_cassa_type');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('ei_cassa_type', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['ei_cassa_type'] = $ei_cassa_type;

        return $this;
    }

    /**
     * Gets ei_cassa2_type
     *
     * @return string|null
     */
    public function getEiCassa2Type()
    {
        return $this->container['ei_cassa2_type'];
    }

    /**
     * Sets ei_cassa2_type
     *
     * @param string|null $ei_cassa2_type E-invoice cassa2 type
     *
     * @return self
     */
    public function setEiCassa2Type($ei_cassa2_type)
    {
        if (is_null($ei_cassa2_type)) {
            array_push($this->openAPINullablesSetToNull, 'ei_cassa2_type');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('ei_cassa2_type', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['ei_cassa2_type'] = $ei_cassa2_type;

        return $this;
    }

    /**
     * Gets ei_withholding_tax_causal
     *
     * @return string|null
     */
    public function getEiWithholdingTaxCausal()
    {
        return $this->container['ei_withholding_tax_causal'];
    }

    /**
     * Sets ei_withholding_tax_causal
     *
     * @param string|null $ei_withholding_tax_causal E-invoice withholding tax causal
     *
     * @return self
     */
    public function setEiWithholdingTaxCausal($ei_withholding_tax_causal)
    {
        if (is_null($ei_withholding_tax_causal)) {
            array_push($this->openAPINullablesSetToNull, 'ei_withholding_tax_causal');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('ei_withholding_tax_causal', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['ei_withholding_tax_causal'] = $ei_withholding_tax_causal;

        return $this;
    }

    /**
     * Gets ei_other_withholding_tax_type
     *
     * @return string|null
     */
    public function getEiOtherWithholdingTaxType()
    {
        return $this->container['ei_other_withholding_tax_type'];
    }

    /**
     * Sets ei_other_withholding_tax_type
     *
     * @param string|null $ei_other_withholding_tax_type E-invoice other withholding tax type
     *
     * @return self
     */
    public function setEiOtherWithholdingTaxType($ei_other_withholding_tax_type)
    {
        if (is_null($ei_other_withholding_tax_type)) {
            array_push($this->openAPINullablesSetToNull, 'ei_other_withholding_tax_type');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('ei_other_withholding_tax_type', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['ei_other_withholding_tax_type'] = $ei_other_withholding_tax_type;

        return $this;
    }

    /**
     * Gets ei_other_withholding_tax_causal
     *
     * @return string|null
     */
    public function getEiOtherWithholdingTaxCausal()
    {
        return $this->container['ei_other_withholding_tax_causal'];
    }

    /**
     * Sets ei_other_withholding_tax_causal
     *
     * @param string|null $ei_other_withholding_tax_causal E-invoice other withholding tax causal
     *
     * @return self
     */
    public function setEiOtherWithholdingTaxCausal($ei_other_withholding_tax_causal)
    {
        if (is_null($ei_other_withholding_tax_causal)) {
            array_push($this->openAPINullablesSetToNull, 'ei_other_withholding_tax_causal');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('ei_other_withholding_tax_causal', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['ei_other_withholding_tax_causal'] = $ei_other_withholding_tax_causal;

        return $this;
    }

    /**
     * Gets items_list
     *
     * @return \FattureInCloud\Model\IssuedDocumentItemsListItem[]|null
     */
    public function getItemsList()
    {
        return $this->container['items_list'];
    }

    /**
     * Sets items_list
     *
     * @param \FattureInCloud\Model\IssuedDocumentItemsListItem[]|null $items_list items_list
     *
     * @return self
     */
    public function setItemsList($items_list)
    {
        if (is_null($items_list)) {
            array_push($this->openAPINullablesSetToNull, 'items_list');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('items_list', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['items_list'] = $items_list;

        return $this;
    }

    /**
     * Gets payments_list
     *
     * @return \FattureInCloud\Model\IssuedDocumentPaymentsListItem[]|null
     */
    public function getPaymentsList()
    {
        return $this->container['payments_list'];
    }

    /**
     * Sets payments_list
     *
     * @param \FattureInCloud\Model\IssuedDocumentPaymentsListItem[]|null $payments_list payments_list
     *
     * @return self
     */
    public function setPaymentsList($payments_list)
    {
        if (is_null($payments_list)) {
            array_push($this->openAPINullablesSetToNull, 'payments_list');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('payments_list', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['payments_list'] = $payments_list;

        return $this;
    }

    /**
     * Gets template
     *
     * @return \FattureInCloud\Model\DocumentTemplate|null
     */
    public function getTemplate()
    {
        return $this->container['template'];
    }

    /**
     * Sets template
     *
     * @param \FattureInCloud\Model\DocumentTemplate|null $template template
     *
     * @return self
     */
    public function setTemplate($template)
    {
        if (is_null($template)) {
            throw new \InvalidArgumentException('non-nullable template cannot be null');
        }
        $this->container['template'] = $template;

        return $this;
    }

    /**
     * Gets delivery_note_template
     *
     * @return \FattureInCloud\Model\DocumentTemplate|null
     */
    public function getDeliveryNoteTemplate()
    {
        return $this->container['delivery_note_template'];
    }

    /**
     * Sets delivery_note_template
     *
     * @param \FattureInCloud\Model\DocumentTemplate|null $delivery_note_template delivery_note_template
     *
     * @return self
     */
    public function setDeliveryNoteTemplate($delivery_note_template)
    {
        if (is_null($delivery_note_template)) {
            throw new \InvalidArgumentException('non-nullable delivery_note_template cannot be null');
        }
        $this->container['delivery_note_template'] = $delivery_note_template;

        return $this;
    }

    /**
     * Gets acc_inv_template
     *
     * @return \FattureInCloud\Model\DocumentTemplate|null
     */
    public function getAccInvTemplate()
    {
        return $this->container['acc_inv_template'];
    }

    /**
     * Sets acc_inv_template
     *
     * @param \FattureInCloud\Model\DocumentTemplate|null $acc_inv_template acc_inv_template
     *
     * @return self
     */
    public function setAccInvTemplate($acc_inv_template)
    {
        if (is_null($acc_inv_template)) {
            throw new \InvalidArgumentException('non-nullable acc_inv_template cannot be null');
        }
        $this->container['acc_inv_template'] = $acc_inv_template;

        return $this;
    }

    /**
     * Gets h_margins
     *
     * @return int|null
     */
    public function getHMargins()
    {
        return $this->container['h_margins'];
    }

    /**
     * Sets h_margins
     *
     * @param int|null $h_margins Issued document PDF horizontal margins
     *
     * @return self
     */
    public function setHMargins($h_margins)
    {
        if (is_null($h_margins)) {
            array_push($this->openAPINullablesSetToNull, 'h_margins');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('h_margins', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['h_margins'] = $h_margins;

        return $this;
    }

    /**
     * Gets v_margins
     *
     * @return int|null
     */
    public function getVMargins()
    {
        return $this->container['v_margins'];
    }

    /**
     * Sets v_margins
     *
     * @param int|null $v_margins Issued document PDF vertical margins
     *
     * @return self
     */
    public function setVMargins($v_margins)
    {
        if (is_null($v_margins)) {
            array_push($this->openAPINullablesSetToNull, 'v_margins');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('v_margins', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['v_margins'] = $v_margins;

        return $this;
    }

    /**
     * Gets show_payments
     *
     * @return bool|null
     */
    public function getShowPayments()
    {
        return $this->container['show_payments'];
    }

    /**
     * Sets show_payments
     *
     * @param bool|null $show_payments Show the expiration dates of the payments on the document
     *
     * @return self
     */
    public function setShowPayments($show_payments)
    {
        if (is_null($show_payments)) {
            array_push($this->openAPINullablesSetToNull, 'show_payments');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('show_payments', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['show_payments'] = $show_payments;

        return $this;
    }

    /**
     * Gets show_payment_method
     *
     * @return bool|null
     */
    public function getShowPaymentMethod()
    {
        return $this->container['show_payment_method'];
    }

    /**
     * Sets show_payment_method
     *
     * @param bool|null $show_payment_method Show the payment method details on the document
     *
     * @return self
     */
    public function setShowPaymentMethod($show_payment_method)
    {
        if (is_null($show_payment_method)) {
            array_push($this->openAPINullablesSetToNull, 'show_payment_method');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('show_payment_method', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['show_payment_method'] = $show_payment_method;

        return $this;
    }

    /**
     * Gets show_totals
     *
     * @return string|null
     */
    public function getShowTotals()
    {
        return $this->container['show_totals'];
    }

    /**
     * Sets show_totals, the accepted values are available in \FattureInCloud\Model\ShowTotalsMode
     *
     * @param string|null $show_totals show_totals
     *
     * @return self
     */
    public function setShowTotals($show_totals)
    {
        if (is_null($show_totals)) {
            throw new \InvalidArgumentException('non-nullable show_totals cannot be null');
        }
        $this->container['show_totals'] = $show_totals;

        return $this;
    }

    /**
     * Gets show_notification_button
     *
     * @return bool|null
     */
    public function getShowNotificationButton()
    {
        return $this->container['show_notification_button'];
    }

    /**
     * Sets show_notification_button
     *
     * @param bool|null $show_notification_button Show notification button in the PDF
     *
     * @return self
     */
    public function setShowNotificationButton($show_notification_button)
    {
        if (is_null($show_notification_button)) {
            array_push($this->openAPINullablesSetToNull, 'show_notification_button');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('show_notification_button', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['show_notification_button'] = $show_notification_button;

        return $this;
    }

    /**
     * Gets show_tspay_button
     *
     * @return bool|null
     */
    public function getShowTspayButton()
    {
        return $this->container['show_tspay_button'];
    }

    /**
     * Sets show_tspay_button
     *
     * @param bool|null $show_tspay_button Show ts pay button in the PDF
     *
     * @return self
     */
    public function setShowTspayButton($show_tspay_button)
    {
        if (is_null($show_tspay_button)) {
            array_push($this->openAPINullablesSetToNull, 'show_tspay_button');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('show_tspay_button', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['show_tspay_button'] = $show_tspay_button;

        return $this;
    }

    /**
     * Gets delivery_note
     *
     * @return bool|null
     */
    public function getDeliveryNote()
    {
        return $this->container['delivery_note'];
    }

    /**
     * Sets delivery_note
     *
     * @param bool|null $delivery_note Issued document has delivery note
     *
     * @return self
     */
    public function setDeliveryNote($delivery_note)
    {
        if (is_null($delivery_note)) {
            array_push($this->openAPINullablesSetToNull, 'delivery_note');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('delivery_note', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['delivery_note'] = $delivery_note;

        return $this;
    }

    /**
     * Gets accompanying_invoice
     *
     * @return bool|null
     */
    public function getAccompanyingInvoice()
    {
        return $this->container['accompanying_invoice'];
    }

    /**
     * Sets accompanying_invoice
     *
     * @param bool|null $accompanying_invoice Issued document has an accompanying invoice
     *
     * @return self
     */
    public function setAccompanyingInvoice($accompanying_invoice)
    {
        if (is_null($accompanying_invoice)) {
            array_push($this->openAPINullablesSetToNull, 'accompanying_invoice');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('accompanying_invoice', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['accompanying_invoice'] = $accompanying_invoice;

        return $this;
    }

    /**
     * Gets dn_number
     *
     * @return int|null
     */
    public function getDnNumber()
    {
        return $this->container['dn_number'];
    }

    /**
     * Sets dn_number
     *
     * @param int|null $dn_number Issued document attached delivery note number
     *
     * @return self
     */
    public function setDnNumber($dn_number)
    {
        if (is_null($dn_number)) {
            array_push($this->openAPINullablesSetToNull, 'dn_number');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('dn_number', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['dn_number'] = $dn_number;

        return $this;
    }

    /**
     * Gets dn_date
     *
     * @return \DateTime|null
     */
    public function getDnDate()
    {
        return $this->container['dn_date'];
    }

    /**
     * Sets dn_date
     *
     * @param \DateTime|null $dn_date Issued document attached delivery note date
     *
     * @return self
     */
    public function setDnDate($dn_date)
    {
        if (is_null($dn_date)) {
            array_push($this->openAPINullablesSetToNull, 'dn_date');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('dn_date', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['dn_date'] = $dn_date;

        return $this;
    }

    /**
     * Gets dn_ai_packages_number
     *
     * @return string|null
     */
    public function getDnAiPackagesNumber()
    {
        return $this->container['dn_ai_packages_number'];
    }

    /**
     * Sets dn_ai_packages_number
     *
     * @param string|null $dn_ai_packages_number Issued document attached delivery note number of packages
     *
     * @return self
     */
    public function setDnAiPackagesNumber($dn_ai_packages_number)
    {
        if (is_null($dn_ai_packages_number)) {
            array_push($this->openAPINullablesSetToNull, 'dn_ai_packages_number');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('dn_ai_packages_number', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['dn_ai_packages_number'] = $dn_ai_packages_number;

        return $this;
    }

    /**
     * Gets dn_ai_weight
     *
     * @return string|null
     */
    public function getDnAiWeight()
    {
        return $this->container['dn_ai_weight'];
    }

    /**
     * Sets dn_ai_weight
     *
     * @param string|null $dn_ai_weight Issued document attached delivery note package weight
     *
     * @return self
     */
    public function setDnAiWeight($dn_ai_weight)
    {
        if (is_null($dn_ai_weight)) {
            array_push($this->openAPINullablesSetToNull, 'dn_ai_weight');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('dn_ai_weight', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['dn_ai_weight'] = $dn_ai_weight;

        return $this;
    }

    /**
     * Gets dn_ai_causal
     *
     * @return string|null
     */
    public function getDnAiCausal()
    {
        return $this->container['dn_ai_causal'];
    }

    /**
     * Sets dn_ai_causal
     *
     * @param string|null $dn_ai_causal Issued document attached delivery note causal
     *
     * @return self
     */
    public function setDnAiCausal($dn_ai_causal)
    {
        if (is_null($dn_ai_causal)) {
            array_push($this->openAPINullablesSetToNull, 'dn_ai_causal');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('dn_ai_causal', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['dn_ai_causal'] = $dn_ai_causal;

        return $this;
    }

    /**
     * Gets dn_ai_destination
     *
     * @return string|null
     */
    public function getDnAiDestination()
    {
        return $this->container['dn_ai_destination'];
    }

    /**
     * Sets dn_ai_destination
     *
     * @param string|null $dn_ai_destination Issued document attached delivery note destination
     *
     * @return self
     */
    public function setDnAiDestination($dn_ai_destination)
    {
        if (is_null($dn_ai_destination)) {
            array_push($this->openAPINullablesSetToNull, 'dn_ai_destination');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('dn_ai_destination', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['dn_ai_destination'] = $dn_ai_destination;

        return $this;
    }

    /**
     * Gets dn_ai_transporter
     *
     * @return string|null
     */
    public function getDnAiTransporter()
    {
        return $this->container['dn_ai_transporter'];
    }

    /**
     * Sets dn_ai_transporter
     *
     * @param string|null $dn_ai_transporter Issued document attached delivery note transporter
     *
     * @return self
     */
    public function setDnAiTransporter($dn_ai_transporter)
    {
        if (is_null($dn_ai_transporter)) {
            array_push($this->openAPINullablesSetToNull, 'dn_ai_transporter');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('dn_ai_transporter', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['dn_ai_transporter'] = $dn_ai_transporter;

        return $this;
    }

    /**
     * Gets dn_ai_notes
     *
     * @return string|null
     */
    public function getDnAiNotes()
    {
        return $this->container['dn_ai_notes'];
    }

    /**
     * Sets dn_ai_notes
     *
     * @param string|null $dn_ai_notes Issued document attached delivery note notes
     *
     * @return self
     */
    public function setDnAiNotes($dn_ai_notes)
    {
        if (is_null($dn_ai_notes)) {
            array_push($this->openAPINullablesSetToNull, 'dn_ai_notes');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('dn_ai_notes', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['dn_ai_notes'] = $dn_ai_notes;

        return $this;
    }

    /**
     * Gets is_marked
     *
     * @return bool|null
     */
    public function getIsMarked()
    {
        return $this->container['is_marked'];
    }

    /**
     * Sets is_marked
     *
     * @param bool|null $is_marked Issued document is marked
     *
     * @return self
     */
    public function setIsMarked($is_marked)
    {
        if (is_null($is_marked)) {
            array_push($this->openAPINullablesSetToNull, 'is_marked');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('is_marked', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['is_marked'] = $is_marked;

        return $this;
    }

    /**
     * Gets amount_net
     *
     * @return float|null
     */
    public function getAmountNet()
    {
        return $this->container['amount_net'];
    }

    /**
     * Sets amount_net
     *
     * @param float|null $amount_net [Read only] Issued document total net amount
     *
     * @return self
     */
    public function setAmountNet($amount_net)
    {
        if (is_null($amount_net)) {
            array_push($this->openAPINullablesSetToNull, 'amount_net');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('amount_net', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['amount_net'] = $amount_net;

        return $this;
    }

    /**
     * Gets amount_vat
     *
     * @return float|null
     */
    public function getAmountVat()
    {
        return $this->container['amount_vat'];
    }

    /**
     * Sets amount_vat
     *
     * @param float|null $amount_vat [Read Only] Issued document total vat amount
     *
     * @return self
     */
    public function setAmountVat($amount_vat)
    {
        if (is_null($amount_vat)) {
            array_push($this->openAPINullablesSetToNull, 'amount_vat');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('amount_vat', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['amount_vat'] = $amount_vat;

        return $this;
    }

    /**
     * Gets amount_gross
     *
     * @return float|null
     */
    public function getAmountGross()
    {
        return $this->container['amount_gross'];
    }

    /**
     * Sets amount_gross
     *
     * @param float|null $amount_gross [Read Only] Issued document total gross amount
     *
     * @return self
     */
    public function setAmountGross($amount_gross)
    {
        if (is_null($amount_gross)) {
            array_push($this->openAPINullablesSetToNull, 'amount_gross');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('amount_gross', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['amount_gross'] = $amount_gross;

        return $this;
    }

    /**
     * Gets amount_due_discount
     *
     * @return float|null
     */
    public function getAmountDueDiscount()
    {
        return $this->container['amount_due_discount'];
    }

    /**
     * Sets amount_due_discount
     *
     * @param float|null $amount_due_discount Issued document amount due discount
     *
     * @return self
     */
    public function setAmountDueDiscount($amount_due_discount)
    {
        if (is_null($amount_due_discount)) {
            array_push($this->openAPINullablesSetToNull, 'amount_due_discount');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('amount_due_discount', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['amount_due_discount'] = $amount_due_discount;

        return $this;
    }

    /**
     * Gets amount_rivalsa
     *
     * @return float|null
     */
    public function getAmountRivalsa()
    {
        return $this->container['amount_rivalsa'];
    }

    /**
     * Sets amount_rivalsa
     *
     * @param float|null $amount_rivalsa [Read Only] Issued document rivalsa amount
     *
     * @return self
     */
    public function setAmountRivalsa($amount_rivalsa)
    {
        if (is_null($amount_rivalsa)) {
            array_push($this->openAPINullablesSetToNull, 'amount_rivalsa');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('amount_rivalsa', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['amount_rivalsa'] = $amount_rivalsa;

        return $this;
    }

    /**
     * Gets amount_rivalsa_taxable
     *
     * @return float|null
     */
    public function getAmountRivalsaTaxable()
    {
        return $this->container['amount_rivalsa_taxable'];
    }

    /**
     * Sets amount_rivalsa_taxable
     *
     * @param float|null $amount_rivalsa_taxable Issued document taxable rivalsa amount
     *
     * @return self
     */
    public function setAmountRivalsaTaxable($amount_rivalsa_taxable)
    {
        if (is_null($amount_rivalsa_taxable)) {
            array_push($this->openAPINullablesSetToNull, 'amount_rivalsa_taxable');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('amount_rivalsa_taxable', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['amount_rivalsa_taxable'] = $amount_rivalsa_taxable;

        return $this;
    }

    /**
     * Gets amount_withholding_tax
     *
     * @return float|null
     */
    public function getAmountWithholdingTax()
    {
        return $this->container['amount_withholding_tax'];
    }

    /**
     * Sets amount_withholding_tax
     *
     * @param float|null $amount_withholding_tax [Read Only] Issued document withholding tax amount (ritenuta d'acconto).
     *
     * @return self
     */
    public function setAmountWithholdingTax($amount_withholding_tax)
    {
        if (is_null($amount_withholding_tax)) {
            array_push($this->openAPINullablesSetToNull, 'amount_withholding_tax');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('amount_withholding_tax', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['amount_withholding_tax'] = $amount_withholding_tax;

        return $this;
    }

    /**
     * Gets amount_withholding_tax_taxable
     *
     * @return float|null
     */
    public function getAmountWithholdingTaxTaxable()
    {
        return $this->container['amount_withholding_tax_taxable'];
    }

    /**
     * Sets amount_withholding_tax_taxable
     *
     * @param float|null $amount_withholding_tax_taxable Issued document taxable withholding tax amount
     *
     * @return self
     */
    public function setAmountWithholdingTaxTaxable($amount_withholding_tax_taxable)
    {
        if (is_null($amount_withholding_tax_taxable)) {
            array_push($this->openAPINullablesSetToNull, 'amount_withholding_tax_taxable');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('amount_withholding_tax_taxable', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['amount_withholding_tax_taxable'] = $amount_withholding_tax_taxable;

        return $this;
    }

    /**
     * Gets amount_other_withholding_tax
     *
     * @return float|null
     */
    public function getAmountOtherWithholdingTax()
    {
        return $this->container['amount_other_withholding_tax'];
    }

    /**
     * Sets amount_other_withholding_tax
     *
     * @param float|null $amount_other_withholding_tax [Read Only] Issued document other withholding tax amount (altra ritenuta)
     *
     * @return self
     */
    public function setAmountOtherWithholdingTax($amount_other_withholding_tax)
    {
        if (is_null($amount_other_withholding_tax)) {
            array_push($this->openAPINullablesSetToNull, 'amount_other_withholding_tax');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('amount_other_withholding_tax', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['amount_other_withholding_tax'] = $amount_other_withholding_tax;

        return $this;
    }

    /**
     * Gets amount_other_withholding_tax_taxable
     *
     * @return float|null
     */
    public function getAmountOtherWithholdingTaxTaxable()
    {
        return $this->container['amount_other_withholding_tax_taxable'];
    }

    /**
     * Sets amount_other_withholding_tax_taxable
     *
     * @param float|null $amount_other_withholding_tax_taxable Issued document taxable other withholding tax amount
     *
     * @return self
     */
    public function setAmountOtherWithholdingTaxTaxable($amount_other_withholding_tax_taxable)
    {
        if (is_null($amount_other_withholding_tax_taxable)) {
            array_push($this->openAPINullablesSetToNull, 'amount_other_withholding_tax_taxable');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('amount_other_withholding_tax_taxable', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['amount_other_withholding_tax_taxable'] = $amount_other_withholding_tax_taxable;

        return $this;
    }

    /**
     * Gets amount_enasarco_taxable
     *
     * @return float|null
     */
    public function getAmountEnasarcoTaxable()
    {
        return $this->container['amount_enasarco_taxable'];
    }

    /**
     * Sets amount_enasarco_taxable
     *
     * @param float|null $amount_enasarco_taxable Issued document taxable enasarco amount
     *
     * @return self
     */
    public function setAmountEnasarcoTaxable($amount_enasarco_taxable)
    {
        if (is_null($amount_enasarco_taxable)) {
            array_push($this->openAPINullablesSetToNull, 'amount_enasarco_taxable');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('amount_enasarco_taxable', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['amount_enasarco_taxable'] = $amount_enasarco_taxable;

        return $this;
    }

    /**
     * Gets extra_data
     *
     * @return \FattureInCloud\Model\IssuedDocumentExtraData|null
     */
    public function getExtraData()
    {
        return $this->container['extra_data'];
    }

    /**
     * Sets extra_data
     *
     * @param \FattureInCloud\Model\IssuedDocumentExtraData|null $extra_data extra_data
     *
     * @return self
     */
    public function setExtraData($extra_data)
    {
        if (is_null($extra_data)) {
            array_push($this->openAPINullablesSetToNull, 'extra_data');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('extra_data', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['extra_data'] = $extra_data;

        return $this;
    }

    /**
     * Gets seen_date
     *
     * @return \DateTime|null
     */
    public function getSeenDate()
    {
        return $this->container['seen_date'];
    }

    /**
     * Sets seen_date
     *
     * @param \DateTime|null $seen_date Issued document seen date
     *
     * @return self
     */
    public function setSeenDate($seen_date)
    {
        if (is_null($seen_date)) {
            array_push($this->openAPINullablesSetToNull, 'seen_date');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('seen_date', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['seen_date'] = $seen_date;

        return $this;
    }

    /**
     * Gets next_due_date
     *
     * @return \DateTime|null
     */
    public function getNextDueDate()
    {
        return $this->container['next_due_date'];
    }

    /**
     * Sets next_due_date
     *
     * @param \DateTime|null $next_due_date Issued document date of the next not paid payment
     *
     * @return self
     */
    public function setNextDueDate($next_due_date)
    {
        if (is_null($next_due_date)) {
            array_push($this->openAPINullablesSetToNull, 'next_due_date');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('next_due_date', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['next_due_date'] = $next_due_date;

        return $this;
    }

    /**
     * Gets url
     *
     * @return string|null
     */
    public function getUrl()
    {
        return $this->container['url'];
    }

    /**
     * Sets url
     *
     * @param string|null $url [Temporary] [Read Only] Issued document url of the document PDF file
     *
     * @return self
     */
    public function setUrl($url)
    {
        if (is_null($url)) {
            array_push($this->openAPINullablesSetToNull, 'url');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('url', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['url'] = $url;

        return $this;
    }

    /**
     * Gets dn_url
     *
     * @return string|null
     */
    public function getDnUrl()
    {
        return $this->container['dn_url'];
    }

    /**
     * Sets dn_url
     *
     * @param string|null $dn_url [Temporary] [Read Only] Issued document url of the attached delivery note PDF file
     *
     * @return self
     */
    public function setDnUrl($dn_url)
    {
        if (is_null($dn_url)) {
            array_push($this->openAPINullablesSetToNull, 'dn_url');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('dn_url', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['dn_url'] = $dn_url;

        return $this;
    }

    /**
     * Gets ai_url
     *
     * @return string|null
     */
    public function getAiUrl()
    {
        return $this->container['ai_url'];
    }

    /**
     * Sets ai_url
     *
     * @param string|null $ai_url [Temporary] [Read Only] Issued document url of the accompanying invoice PDF file
     *
     * @return self
     */
    public function setAiUrl($ai_url)
    {
        if (is_null($ai_url)) {
            array_push($this->openAPINullablesSetToNull, 'ai_url');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('ai_url', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['ai_url'] = $ai_url;

        return $this;
    }

    /**
     * Gets attachment_url
     *
     * @return string|null
     */
    public function getAttachmentUrl()
    {
        return $this->container['attachment_url'];
    }

    /**
     * Sets attachment_url
     *
     * @param string|null $attachment_url [Temporary] [Read Only] Issued document url of the attached file
     *
     * @return self
     */
    public function setAttachmentUrl($attachment_url)
    {
        if (is_null($attachment_url)) {
            array_push($this->openAPINullablesSetToNull, 'attachment_url');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('attachment_url', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['attachment_url'] = $attachment_url;

        return $this;
    }

    /**
     * Gets attachment_token
     *
     * @return string|null
     */
    public function getAttachmentToken()
    {
        return $this->container['attachment_token'];
    }

    /**
     * Sets attachment_token
     *
     * @param string|null $attachment_token [Write Only] Issued document attachment token returned by POST /issued_documents/attachment
     *
     * @return self
     */
    public function setAttachmentToken($attachment_token)
    {
        if (is_null($attachment_token)) {
            array_push($this->openAPINullablesSetToNull, 'attachment_token');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('attachment_token', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['attachment_token'] = $attachment_token;

        return $this;
    }

    /**
     * Gets ei_raw
     *
     * @return object|null
     */
    public function getEiRaw()
    {
        return $this->container['ei_raw'];
    }

    /**
     * Sets ei_raw
     *
     * @param object|null $ei_raw Issued document advanced raw attributes for e-invoices
     *
     * @return self
     */
    public function setEiRaw($ei_raw)
    {
        if (is_null($ei_raw)) {
            array_push($this->openAPINullablesSetToNull, 'ei_raw');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('ei_raw', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['ei_raw'] = $ei_raw;

        return $this;
    }

    /**
     * Gets ei_status
     *
     * @return string|null
     */
    public function getEiStatus()
    {
        return $this->container['ei_status'];
    }

    /**
     * Sets ei_status, the accepted values are available in string
     *
     * @param string|null $ei_status [Read only] Status of the e-invoice.   * **attempt** - We are trying to send the invoice, please wait up to 2 hours   * **missing** - The invoice is missing   * **not_sent** - The invoice has yet to be sent   * **sent** - The invoice was sent   * **pending** - The checks for the digital signature and sending are in progress   * **processing** - The SDI is delivering the invoice to the customer   * **error** - An error occurred while handling the invoice, please try to resend it or contact support   * **discarded** - The invoice has been rejected by the SDI, so it must be corrected and re-sent   * **not_delivered** - The SDI was unable to deliver the invoice   * **accepted** - The customer accepted the invoice   * **rejected** - The customer rejected the invoice, so it must be corrected   * **no_response** - A response has not yet been received whithin the deadline, contact the customer to ascertain the status of the invoice   * **manual_accepted** - The customer accepted the invoice   * **manual_rejected** - The customer rejected the invoice
     *
     * @return self
     */
    public function setEiStatus($ei_status)
    {
        if (is_null($ei_status)) {
            array_push($this->openAPINullablesSetToNull, 'ei_status');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('ei_status', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $allowedValues = $this->getEiStatusAllowableValues();
        if (!is_null($ei_status) && !in_array($ei_status, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'ei_status', must be one of '%s'",
                    $ei_status,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['ei_status'] = $ei_status;

        return $this;
    }

    /**
     * Gets locked
     *
     * @return bool|null
     */
    public function getLocked()
    {
        return $this->container['locked'];
    }

    /**
     * Sets locked
     *
     * @param bool|null $locked Issued Document can't be edited
     *
     * @return self
     */
    public function setLocked($locked)
    {
        if (is_null($locked)) {
            array_push($this->openAPINullablesSetToNull, 'locked');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('locked', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['locked'] = $locked;

        return $this;
    }

    /**
     * Gets created_at
     *
     * @return string|null
     */
    public function getCreatedAt()
    {
        return $this->container['created_at'];
    }

    /**
     * Sets created_at
     *
     * @param string|null $created_at Issued document creation date
     *
     * @return self
     */
    public function setCreatedAt($created_at)
    {
        if (is_null($created_at)) {
            array_push($this->openAPINullablesSetToNull, 'created_at');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('created_at', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['created_at'] = $created_at;

        return $this;
    }

    /**
     * Gets updated_at
     *
     * @return string|null
     */
    public function getUpdatedAt()
    {
        return $this->container['updated_at'];
    }

    /**
     * Sets updated_at
     *
     * @param string|null $updated_at Issued document last update date
     *
     * @return self
     */
    public function setUpdatedAt($updated_at)
    {
        if (is_null($updated_at)) {
            array_push($this->openAPINullablesSetToNull, 'updated_at');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('updated_at', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['updated_at'] = $updated_at;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link     https://fattureincloud.it
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
        return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


