<?php
/**
 * Entity
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  FattureInCloud
 * @author   Fatture In Cloud API team
 * @link     https://fattureincloud.it
 */

/**
 * Fatture in Cloud API v2 - API Reference
 *
 * Connect your software with Fatture in Cloud, the invoicing platform chosen by more than 500.000 businesses in Italy.   The Fatture in Cloud API is based on REST, and makes possible to interact with the user related data prior authorization via OAuth2 protocol.
 *
 * The version of the OpenAPI document: 2.1.3
 * Contact: info@fattureincloud.it
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.9.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace FattureInCloud\Model;

use \ArrayAccess;
use \FattureInCloud\ObjectSerializer;

/**
 * Entity Class Doc Comment
 *
 * @category Class
 * @package  FattureInCloud
 * @author   Fatture In Cloud API team
 * @link     https://fattureincloud.it
 * @implements \ArrayAccess<string, mixed>
 */
class Entity implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'Entity';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'id' => 'int',
        'code' => 'string',
        'name' => 'string',
        'type' => '\FattureInCloud\Model\EntityType',
        'first_name' => 'string',
        'last_name' => 'string',
        'contact_person' => 'string',
        'vat_number' => 'string',
        'tax_code' => 'string',
        'address_street' => 'string',
        'address_postal_code' => 'string',
        'address_city' => 'string',
        'address_province' => 'string',
        'address_extra' => 'string',
        'country' => 'string',
        'country_iso' => 'string',
        'email' => 'string',
        'certified_email' => 'string',
        'phone' => 'string',
        'fax' => 'string',
        'notes' => 'string',
        'default_payment_terms' => 'int',
        'default_vat' => '\FattureInCloud\Model\VatType',
        'default_payment_terms_type' => '\FattureInCloud\Model\PaymentTermsType',
        'default_payment_method' => '\FattureInCloud\Model\PaymentMethod',
        'bank_name' => 'string',
        'bank_iban' => 'string',
        'bank_swift_code' => 'string',
        'shipping_address' => 'string',
        'e_invoice' => 'bool',
        'ei_code' => 'string',
        'has_intent_declaration' => 'bool',
        'intent_declaration_protocol_number' => 'string',
        'intent_declaration_protocol_date' => '\DateTime',
        'created_at' => 'string',
        'updated_at' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'id' => null,
        'code' => null,
        'name' => null,
        'type' => null,
        'first_name' => null,
        'last_name' => null,
        'contact_person' => null,
        'vat_number' => null,
        'tax_code' => null,
        'address_street' => null,
        'address_postal_code' => null,
        'address_city' => null,
        'address_province' => null,
        'address_extra' => null,
        'country' => null,
        'country_iso' => null,
        'email' => null,
        'certified_email' => null,
        'phone' => null,
        'fax' => null,
        'notes' => null,
        'default_payment_terms' => null,
        'default_vat' => null,
        'default_payment_terms_type' => null,
        'default_payment_method' => null,
        'bank_name' => null,
        'bank_iban' => null,
        'bank_swift_code' => null,
        'shipping_address' => null,
        'e_invoice' => null,
        'ei_code' => null,
        'has_intent_declaration' => null,
        'intent_declaration_protocol_number' => null,
        'intent_declaration_protocol_date' => 'date',
        'created_at' => null,
        'updated_at' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static $openAPINullables = [
        'id' => true,
        'code' => true,
        'name' => true,
        'type' => true,
        'first_name' => true,
        'last_name' => true,
        'contact_person' => true,
        'vat_number' => true,
        'tax_code' => true,
        'address_street' => true,
        'address_postal_code' => true,
        'address_city' => true,
        'address_province' => true,
        'address_extra' => true,
        'country' => true,
        'country_iso' => true,
        'email' => true,
        'certified_email' => true,
        'phone' => true,
        'fax' => true,
        'notes' => true,
        'default_payment_terms' => true,
        'default_vat' => true,
        'default_payment_terms_type' => false,
        'default_payment_method' => false,
        'bank_name' => true,
        'bank_iban' => true,
        'bank_swift_code' => true,
        'shipping_address' => true,
        'e_invoice' => true,
        'ei_code' => true,
        'has_intent_declaration' => true,
        'intent_declaration_protocol_number' => true,
        'intent_declaration_protocol_date' => true,
        'created_at' => true,
        'updated_at' => true
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull($openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'id' => 'id',
        'code' => 'code',
        'name' => 'name',
        'type' => 'type',
        'first_name' => 'first_name',
        'last_name' => 'last_name',
        'contact_person' => 'contact_person',
        'vat_number' => 'vat_number',
        'tax_code' => 'tax_code',
        'address_street' => 'address_street',
        'address_postal_code' => 'address_postal_code',
        'address_city' => 'address_city',
        'address_province' => 'address_province',
        'address_extra' => 'address_extra',
        'country' => 'country',
        'country_iso' => 'country_iso',
        'email' => 'email',
        'certified_email' => 'certified_email',
        'phone' => 'phone',
        'fax' => 'fax',
        'notes' => 'notes',
        'default_payment_terms' => 'default_payment_terms',
        'default_vat' => 'default_vat',
        'default_payment_terms_type' => 'default_payment_terms_type',
        'default_payment_method' => 'default_payment_method',
        'bank_name' => 'bank_name',
        'bank_iban' => 'bank_iban',
        'bank_swift_code' => 'bank_swift_code',
        'shipping_address' => 'shipping_address',
        'e_invoice' => 'e_invoice',
        'ei_code' => 'ei_code',
        'has_intent_declaration' => 'has_intent_declaration',
        'intent_declaration_protocol_number' => 'intent_declaration_protocol_number',
        'intent_declaration_protocol_date' => 'intent_declaration_protocol_date',
        'created_at' => 'created_at',
        'updated_at' => 'updated_at'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'id' => 'setId',
        'code' => 'setCode',
        'name' => 'setName',
        'type' => 'setType',
        'first_name' => 'setFirstName',
        'last_name' => 'setLastName',
        'contact_person' => 'setContactPerson',
        'vat_number' => 'setVatNumber',
        'tax_code' => 'setTaxCode',
        'address_street' => 'setAddressStreet',
        'address_postal_code' => 'setAddressPostalCode',
        'address_city' => 'setAddressCity',
        'address_province' => 'setAddressProvince',
        'address_extra' => 'setAddressExtra',
        'country' => 'setCountry',
        'country_iso' => 'setCountryIso',
        'email' => 'setEmail',
        'certified_email' => 'setCertifiedEmail',
        'phone' => 'setPhone',
        'fax' => 'setFax',
        'notes' => 'setNotes',
        'default_payment_terms' => 'setDefaultPaymentTerms',
        'default_vat' => 'setDefaultVat',
        'default_payment_terms_type' => 'setDefaultPaymentTermsType',
        'default_payment_method' => 'setDefaultPaymentMethod',
        'bank_name' => 'setBankName',
        'bank_iban' => 'setBankIban',
        'bank_swift_code' => 'setBankSwiftCode',
        'shipping_address' => 'setShippingAddress',
        'e_invoice' => 'setEInvoice',
        'ei_code' => 'setEiCode',
        'has_intent_declaration' => 'setHasIntentDeclaration',
        'intent_declaration_protocol_number' => 'setIntentDeclarationProtocolNumber',
        'intent_declaration_protocol_date' => 'setIntentDeclarationProtocolDate',
        'created_at' => 'setCreatedAt',
        'updated_at' => 'setUpdatedAt'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'id' => 'getId',
        'code' => 'getCode',
        'name' => 'getName',
        'type' => 'getType',
        'first_name' => 'getFirstName',
        'last_name' => 'getLastName',
        'contact_person' => 'getContactPerson',
        'vat_number' => 'getVatNumber',
        'tax_code' => 'getTaxCode',
        'address_street' => 'getAddressStreet',
        'address_postal_code' => 'getAddressPostalCode',
        'address_city' => 'getAddressCity',
        'address_province' => 'getAddressProvince',
        'address_extra' => 'getAddressExtra',
        'country' => 'getCountry',
        'country_iso' => 'getCountryIso',
        'email' => 'getEmail',
        'certified_email' => 'getCertifiedEmail',
        'phone' => 'getPhone',
        'fax' => 'getFax',
        'notes' => 'getNotes',
        'default_payment_terms' => 'getDefaultPaymentTerms',
        'default_vat' => 'getDefaultVat',
        'default_payment_terms_type' => 'getDefaultPaymentTermsType',
        'default_payment_method' => 'getDefaultPaymentMethod',
        'bank_name' => 'getBankName',
        'bank_iban' => 'getBankIban',
        'bank_swift_code' => 'getBankSwiftCode',
        'shipping_address' => 'getShippingAddress',
        'e_invoice' => 'getEInvoice',
        'ei_code' => 'getEiCode',
        'has_intent_declaration' => 'getHasIntentDeclaration',
        'intent_declaration_protocol_number' => 'getIntentDeclarationProtocolNumber',
        'intent_declaration_protocol_date' => 'getIntentDeclarationProtocolDate',
        'created_at' => 'getCreatedAt',
        'updated_at' => 'getUpdatedAt'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct($data = null)
    {
        $this->setIfExists('id', $data ?? [], null);
        $this->setIfExists('code', $data ?? [], null);
        $this->setIfExists('name', $data ?? [], null);
        $this->setIfExists('type', $data ?? [], null);
        $this->setIfExists('first_name', $data ?? [], null);
        $this->setIfExists('last_name', $data ?? [], null);
        $this->setIfExists('contact_person', $data ?? [], null);
        $this->setIfExists('vat_number', $data ?? [], null);
        $this->setIfExists('tax_code', $data ?? [], null);
        $this->setIfExists('address_street', $data ?? [], null);
        $this->setIfExists('address_postal_code', $data ?? [], null);
        $this->setIfExists('address_city', $data ?? [], null);
        $this->setIfExists('address_province', $data ?? [], null);
        $this->setIfExists('address_extra', $data ?? [], null);
        $this->setIfExists('country', $data ?? [], null);
        $this->setIfExists('country_iso', $data ?? [], null);
        $this->setIfExists('email', $data ?? [], null);
        $this->setIfExists('certified_email', $data ?? [], null);
        $this->setIfExists('phone', $data ?? [], null);
        $this->setIfExists('fax', $data ?? [], null);
        $this->setIfExists('notes', $data ?? [], null);
        $this->setIfExists('default_payment_terms', $data ?? [], null);
        $this->setIfExists('default_vat', $data ?? [], null);
        $this->setIfExists('default_payment_terms_type', $data ?? [], null);
        $this->setIfExists('default_payment_method', $data ?? [], null);
        $this->setIfExists('bank_name', $data ?? [], null);
        $this->setIfExists('bank_iban', $data ?? [], null);
        $this->setIfExists('bank_swift_code', $data ?? [], null);
        $this->setIfExists('shipping_address', $data ?? [], null);
        $this->setIfExists('e_invoice', $data ?? [], null);
        $this->setIfExists('ei_code', $data ?? [], null);
        $this->setIfExists('has_intent_declaration', $data ?? [], null);
        $this->setIfExists('intent_declaration_protocol_number', $data ?? [], null);
        $this->setIfExists('intent_declaration_protocol_date', $data ?? [], null);
        $this->setIfExists('created_at', $data ?? [], null);
        $this->setIfExists('updated_at', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets id
     *
     * @return int|null
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     *
     * @param int|null $id Entity id
     *
     * @return self
     */
    public function setId($id)
    {
        if (is_null($id)) {
            array_push($this->openAPINullablesSetToNull, 'id');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('id', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets code
     *
     * @return string|null
     */
    public function getCode()
    {
        return $this->container['code'];
    }

    /**
     * Sets code
     *
     * @param string|null $code Entity code
     *
     * @return self
     */
    public function setCode($code)
    {
        if (is_null($code)) {
            array_push($this->openAPINullablesSetToNull, 'code');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('code', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['code'] = $code;

        return $this;
    }

    /**
     * Gets name
     *
     * @return string|null
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     *
     * @param string|null $name Entity name
     *
     * @return self
     */
    public function setName($name)
    {
        if (is_null($name)) {
            array_push($this->openAPINullablesSetToNull, 'name');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('name', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets type
     *
     * @return string|null
     */
    public function getType()
    {
        return $this->container['type'];
    }

    /**
     * Sets type, the accepted values are available in \FattureInCloud\Model\EntityType
     *
     * @param string|null $type type
     *
     * @return self
     */
    public function setType($type)
    {
        if (is_null($type)) {
            array_push($this->openAPINullablesSetToNull, 'type');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('type', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['type'] = $type;

        return $this;
    }

    /**
     * Gets first_name
     *
     * @return string|null
     */
    public function getFirstName()
    {
        return $this->container['first_name'];
    }

    /**
     * Sets first_name
     *
     * @param string|null $first_name Entity first name
     *
     * @return self
     */
    public function setFirstName($first_name)
    {
        if (is_null($first_name)) {
            array_push($this->openAPINullablesSetToNull, 'first_name');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('first_name', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['first_name'] = $first_name;

        return $this;
    }

    /**
     * Gets last_name
     *
     * @return string|null
     */
    public function getLastName()
    {
        return $this->container['last_name'];
    }

    /**
     * Sets last_name
     *
     * @param string|null $last_name Entity last name
     *
     * @return self
     */
    public function setLastName($last_name)
    {
        if (is_null($last_name)) {
            array_push($this->openAPINullablesSetToNull, 'last_name');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('last_name', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['last_name'] = $last_name;

        return $this;
    }

    /**
     * Gets contact_person
     *
     * @return string|null
     */
    public function getContactPerson()
    {
        return $this->container['contact_person'];
    }

    /**
     * Sets contact_person
     *
     * @param string|null $contact_person Entity contact person
     *
     * @return self
     */
    public function setContactPerson($contact_person)
    {
        if (is_null($contact_person)) {
            array_push($this->openAPINullablesSetToNull, 'contact_person');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('contact_person', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['contact_person'] = $contact_person;

        return $this;
    }

    /**
     * Gets vat_number
     *
     * @return string|null
     */
    public function getVatNumber()
    {
        return $this->container['vat_number'];
    }

    /**
     * Sets vat_number
     *
     * @param string|null $vat_number Entity vat number
     *
     * @return self
     */
    public function setVatNumber($vat_number)
    {
        if (is_null($vat_number)) {
            array_push($this->openAPINullablesSetToNull, 'vat_number');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('vat_number', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['vat_number'] = $vat_number;

        return $this;
    }

    /**
     * Gets tax_code
     *
     * @return string|null
     */
    public function getTaxCode()
    {
        return $this->container['tax_code'];
    }

    /**
     * Sets tax_code
     *
     * @param string|null $tax_code Entity tax code
     *
     * @return self
     */
    public function setTaxCode($tax_code)
    {
        if (is_null($tax_code)) {
            array_push($this->openAPINullablesSetToNull, 'tax_code');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('tax_code', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['tax_code'] = $tax_code;

        return $this;
    }

    /**
     * Gets address_street
     *
     * @return string|null
     */
    public function getAddressStreet()
    {
        return $this->container['address_street'];
    }

    /**
     * Sets address_street
     *
     * @param string|null $address_street Entitity address street
     *
     * @return self
     */
    public function setAddressStreet($address_street)
    {
        if (is_null($address_street)) {
            array_push($this->openAPINullablesSetToNull, 'address_street');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('address_street', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['address_street'] = $address_street;

        return $this;
    }

    /**
     * Gets address_postal_code
     *
     * @return string|null
     */
    public function getAddressPostalCode()
    {
        return $this->container['address_postal_code'];
    }

    /**
     * Sets address_postal_code
     *
     * @param string|null $address_postal_code Entity address postal code
     *
     * @return self
     */
    public function setAddressPostalCode($address_postal_code)
    {
        if (is_null($address_postal_code)) {
            array_push($this->openAPINullablesSetToNull, 'address_postal_code');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('address_postal_code', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['address_postal_code'] = $address_postal_code;

        return $this;
    }

    /**
     * Gets address_city
     *
     * @return string|null
     */
    public function getAddressCity()
    {
        return $this->container['address_city'];
    }

    /**
     * Sets address_city
     *
     * @param string|null $address_city Entity address city
     *
     * @return self
     */
    public function setAddressCity($address_city)
    {
        if (is_null($address_city)) {
            array_push($this->openAPINullablesSetToNull, 'address_city');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('address_city', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['address_city'] = $address_city;

        return $this;
    }

    /**
     * Gets address_province
     *
     * @return string|null
     */
    public function getAddressProvince()
    {
        return $this->container['address_province'];
    }

    /**
     * Sets address_province
     *
     * @param string|null $address_province Entity address province
     *
     * @return self
     */
    public function setAddressProvince($address_province)
    {
        if (is_null($address_province)) {
            array_push($this->openAPINullablesSetToNull, 'address_province');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('address_province', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['address_province'] = $address_province;

        return $this;
    }

    /**
     * Gets address_extra
     *
     * @return string|null
     */
    public function getAddressExtra()
    {
        return $this->container['address_extra'];
    }

    /**
     * Sets address_extra
     *
     * @param string|null $address_extra Entity address extra info
     *
     * @return self
     */
    public function setAddressExtra($address_extra)
    {
        if (is_null($address_extra)) {
            array_push($this->openAPINullablesSetToNull, 'address_extra');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('address_extra', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['address_extra'] = $address_extra;

        return $this;
    }

    /**
     * Gets country
     *
     * @return string|null
     */
    public function getCountry()
    {
        return $this->container['country'];
    }

    /**
     * Sets country
     *
     * @param string|null $country Entity country
     *
     * @return self
     */
    public function setCountry($country)
    {
        if (is_null($country)) {
            array_push($this->openAPINullablesSetToNull, 'country');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('country', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['country'] = $country;

        return $this;
    }

    /**
     * Gets country_iso
     *
     * @return string|null
     */
    public function getCountryIso()
    {
        return $this->container['country_iso'];
    }

    /**
     * Sets country_iso
     *
     * @param string|null $country_iso Entity country iso code
     *
     * @return self
     */
    public function setCountryIso($country_iso)
    {
        if (is_null($country_iso)) {
            array_push($this->openAPINullablesSetToNull, 'country_iso');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('country_iso', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['country_iso'] = $country_iso;

        return $this;
    }

    /**
     * Gets email
     *
     * @return string|null
     */
    public function getEmail()
    {
        return $this->container['email'];
    }

    /**
     * Sets email
     *
     * @param string|null $email Entity email
     *
     * @return self
     */
    public function setEmail($email)
    {
        if (is_null($email)) {
            array_push($this->openAPINullablesSetToNull, 'email');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('email', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['email'] = $email;

        return $this;
    }

    /**
     * Gets certified_email
     *
     * @return string|null
     */
    public function getCertifiedEmail()
    {
        return $this->container['certified_email'];
    }

    /**
     * Sets certified_email
     *
     * @param string|null $certified_email Entity certified email
     *
     * @return self
     */
    public function setCertifiedEmail($certified_email)
    {
        if (is_null($certified_email)) {
            array_push($this->openAPINullablesSetToNull, 'certified_email');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('certified_email', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['certified_email'] = $certified_email;

        return $this;
    }

    /**
     * Gets phone
     *
     * @return string|null
     */
    public function getPhone()
    {
        return $this->container['phone'];
    }

    /**
     * Sets phone
     *
     * @param string|null $phone Entity phone
     *
     * @return self
     */
    public function setPhone($phone)
    {
        if (is_null($phone)) {
            array_push($this->openAPINullablesSetToNull, 'phone');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('phone', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['phone'] = $phone;

        return $this;
    }

    /**
     * Gets fax
     *
     * @return string|null
     */
    public function getFax()
    {
        return $this->container['fax'];
    }

    /**
     * Sets fax
     *
     * @param string|null $fax Entity fax
     *
     * @return self
     */
    public function setFax($fax)
    {
        if (is_null($fax)) {
            array_push($this->openAPINullablesSetToNull, 'fax');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('fax', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['fax'] = $fax;

        return $this;
    }

    /**
     * Gets notes
     *
     * @return string|null
     */
    public function getNotes()
    {
        return $this->container['notes'];
    }

    /**
     * Sets notes
     *
     * @param string|null $notes Entity extra
     *
     * @return self
     */
    public function setNotes($notes)
    {
        if (is_null($notes)) {
            array_push($this->openAPINullablesSetToNull, 'notes');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('notes', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['notes'] = $notes;

        return $this;
    }

    /**
     * Gets default_payment_terms
     *
     * @return int|null
     */
    public function getDefaultPaymentTerms()
    {
        return $this->container['default_payment_terms'];
    }

    /**
     * Sets default_payment_terms
     *
     * @param int|null $default_payment_terms [Only for client] Client default payment terms
     *
     * @return self
     */
    public function setDefaultPaymentTerms($default_payment_terms)
    {
        if (is_null($default_payment_terms)) {
            array_push($this->openAPINullablesSetToNull, 'default_payment_terms');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('default_payment_terms', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['default_payment_terms'] = $default_payment_terms;

        return $this;
    }

    /**
     * Gets default_vat
     *
     * @return \FattureInCloud\Model\VatType|null
     */
    public function getDefaultVat()
    {
        return $this->container['default_vat'];
    }

    /**
     * Sets default_vat
     *
     * @param \FattureInCloud\Model\VatType|null $default_vat default_vat
     *
     * @return self
     */
    public function setDefaultVat($default_vat)
    {
        if (is_null($default_vat)) {
            array_push($this->openAPINullablesSetToNull, 'default_vat');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('default_vat', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['default_vat'] = $default_vat;

        return $this;
    }

    /**
     * Gets default_payment_terms_type
     *
     * @return string|null
     */
    public function getDefaultPaymentTermsType()
    {
        return $this->container['default_payment_terms_type'];
    }

    /**
     * Sets default_payment_terms_type, the accepted values are available in \FattureInCloud\Model\PaymentTermsType
     *
     * @param string|null $default_payment_terms_type default_payment_terms_type
     *
     * @return self
     */
    public function setDefaultPaymentTermsType($default_payment_terms_type)
    {
        if (is_null($default_payment_terms_type)) {
            throw new \InvalidArgumentException('non-nullable default_payment_terms_type cannot be null');
        }
        $this->container['default_payment_terms_type'] = $default_payment_terms_type;

        return $this;
    }

    /**
     * Gets default_payment_method
     *
     * @return \FattureInCloud\Model\PaymentMethod|null
     */
    public function getDefaultPaymentMethod()
    {
        return $this->container['default_payment_method'];
    }

    /**
     * Sets default_payment_method
     *
     * @param \FattureInCloud\Model\PaymentMethod|null $default_payment_method default_payment_method
     *
     * @return self
     */
    public function setDefaultPaymentMethod($default_payment_method)
    {
        if (is_null($default_payment_method)) {
            throw new \InvalidArgumentException('non-nullable default_payment_method cannot be null');
        }
        $this->container['default_payment_method'] = $default_payment_method;

        return $this;
    }

    /**
     * Gets bank_name
     *
     * @return string|null
     */
    public function getBankName()
    {
        return $this->container['bank_name'];
    }

    /**
     * Sets bank_name
     *
     * @param string|null $bank_name [Only for client] Client bank name
     *
     * @return self
     */
    public function setBankName($bank_name)
    {
        if (is_null($bank_name)) {
            array_push($this->openAPINullablesSetToNull, 'bank_name');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('bank_name', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['bank_name'] = $bank_name;

        return $this;
    }

    /**
     * Gets bank_iban
     *
     * @return string|null
     */
    public function getBankIban()
    {
        return $this->container['bank_iban'];
    }

    /**
     * Sets bank_iban
     *
     * @param string|null $bank_iban [Only for client] Client bank iban
     *
     * @return self
     */
    public function setBankIban($bank_iban)
    {
        if (is_null($bank_iban)) {
            array_push($this->openAPINullablesSetToNull, 'bank_iban');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('bank_iban', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['bank_iban'] = $bank_iban;

        return $this;
    }

    /**
     * Gets bank_swift_code
     *
     * @return string|null
     */
    public function getBankSwiftCode()
    {
        return $this->container['bank_swift_code'];
    }

    /**
     * Sets bank_swift_code
     *
     * @param string|null $bank_swift_code [Only for client] Client bank swift code
     *
     * @return self
     */
    public function setBankSwiftCode($bank_swift_code)
    {
        if (is_null($bank_swift_code)) {
            array_push($this->openAPINullablesSetToNull, 'bank_swift_code');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('bank_swift_code', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['bank_swift_code'] = $bank_swift_code;

        return $this;
    }

    /**
     * Gets shipping_address
     *
     * @return string|null
     */
    public function getShippingAddress()
    {
        return $this->container['shipping_address'];
    }

    /**
     * Sets shipping_address
     *
     * @param string|null $shipping_address [Only for client] Client Shipping address
     *
     * @return self
     */
    public function setShippingAddress($shipping_address)
    {
        if (is_null($shipping_address)) {
            array_push($this->openAPINullablesSetToNull, 'shipping_address');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('shipping_address', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['shipping_address'] = $shipping_address;

        return $this;
    }

    /**
     * Gets e_invoice
     *
     * @return bool|null
     */
    public function getEInvoice()
    {
        return $this->container['e_invoice'];
    }

    /**
     * Sets e_invoice
     *
     * @param bool|null $e_invoice [Only for client] Use e-invoices.
     *
     * @return self
     */
    public function setEInvoice($e_invoice)
    {
        if (is_null($e_invoice)) {
            array_push($this->openAPINullablesSetToNull, 'e_invoice');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('e_invoice', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['e_invoice'] = $e_invoice;

        return $this;
    }

    /**
     * Gets ei_code
     *
     * @return string|null
     */
    public function getEiCode()
    {
        return $this->container['ei_code'];
    }

    /**
     * Sets ei_code
     *
     * @param string|null $ei_code [Only for client] E-invoices code.
     *
     * @return self
     */
    public function setEiCode($ei_code)
    {
        if (is_null($ei_code)) {
            array_push($this->openAPINullablesSetToNull, 'ei_code');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('ei_code', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['ei_code'] = $ei_code;

        return $this;
    }

    /**
     * Gets has_intent_declaration
     *
     * @return bool|null
     */
    public function getHasIntentDeclaration()
    {
        return $this->container['has_intent_declaration'];
    }

    /**
     * Sets has_intent_declaration
     *
     * @param bool|null $has_intent_declaration [Only for client] Has intent declaration.
     *
     * @return self
     */
    public function setHasIntentDeclaration($has_intent_declaration)
    {
        if (is_null($has_intent_declaration)) {
            array_push($this->openAPINullablesSetToNull, 'has_intent_declaration');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('has_intent_declaration', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['has_intent_declaration'] = $has_intent_declaration;

        return $this;
    }

    /**
     * Gets intent_declaration_protocol_number
     *
     * @return string|null
     */
    public function getIntentDeclarationProtocolNumber()
    {
        return $this->container['intent_declaration_protocol_number'];
    }

    /**
     * Sets intent_declaration_protocol_number
     *
     * @param string|null $intent_declaration_protocol_number [Only for client] Client intent declaration protocol number
     *
     * @return self
     */
    public function setIntentDeclarationProtocolNumber($intent_declaration_protocol_number)
    {
        if (is_null($intent_declaration_protocol_number)) {
            array_push($this->openAPINullablesSetToNull, 'intent_declaration_protocol_number');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('intent_declaration_protocol_number', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['intent_declaration_protocol_number'] = $intent_declaration_protocol_number;

        return $this;
    }

    /**
     * Gets intent_declaration_protocol_date
     *
     * @return \DateTime|null
     */
    public function getIntentDeclarationProtocolDate()
    {
        return $this->container['intent_declaration_protocol_date'];
    }

    /**
     * Sets intent_declaration_protocol_date
     *
     * @param \DateTime|null $intent_declaration_protocol_date [Only for client] Client intent declaration protocol date
     *
     * @return self
     */
    public function setIntentDeclarationProtocolDate($intent_declaration_protocol_date)
    {
        if (is_null($intent_declaration_protocol_date)) {
            array_push($this->openAPINullablesSetToNull, 'intent_declaration_protocol_date');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('intent_declaration_protocol_date', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['intent_declaration_protocol_date'] = $intent_declaration_protocol_date;

        return $this;
    }

    /**
     * Gets created_at
     *
     * @return string|null
     */
    public function getCreatedAt()
    {
        return $this->container['created_at'];
    }

    /**
     * Sets created_at
     *
     * @param string|null $created_at Entity creation date
     *
     * @return self
     */
    public function setCreatedAt($created_at)
    {
        if (is_null($created_at)) {
            array_push($this->openAPINullablesSetToNull, 'created_at');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('created_at', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['created_at'] = $created_at;

        return $this;
    }

    /**
     * Gets updated_at
     *
     * @return string|null
     */
    public function getUpdatedAt()
    {
        return $this->container['updated_at'];
    }

    /**
     * Sets updated_at
     *
     * @param string|null $updated_at Entity last update date
     *
     * @return self
     */
    public function setUpdatedAt($updated_at)
    {
        if (is_null($updated_at)) {
            array_push($this->openAPINullablesSetToNull, 'updated_at');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('updated_at', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['updated_at'] = $updated_at;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link     https://fattureincloud.it
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
        return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


