<?php
/**
 * ArchiveApi
 * PHP version 7.4
 *
 * @category Class
 * @package  FattureInCloud
 * @author   Fatture In Cloud API team
 * @link     https://fattureincloud.it
 */

/**
 * Fatture in Cloud API v2 - API Reference
 *
 * Connect your software with Fatture in Cloud, the invoicing platform chosen by more than 500.000 businesses in Italy.   The Fatture in Cloud API is based on REST, and makes possible to interact with the user related data prior authorization via OAuth2 protocol.
 *
 * The version of the OpenAPI document: 2.1.3
 * Contact: info@fattureincloud.it
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.9.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace FattureInCloud\Api;

use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\ConnectException;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\RequestOptions;
use FattureInCloud\ApiException;
use FattureInCloud\Configuration;
use FattureInCloud\HeaderSelector;
use FattureInCloud\ObjectSerializer;

/**
 * ArchiveApi Class Doc Comment
 *
 * @category Class
 * @package  FattureInCloud
 * @author   Fatture In Cloud API team
 * @link     https://fattureincloud.it
 */
class ArchiveApi
{
    /**
     * @var ClientInterface
     */
    protected $client;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @var int Host index
     */
    protected $hostIndex;

    /** @var string[] $contentTypes **/
    public const contentTypes = [
        'createArchiveDocument' => [
            'application/json',
        ],
        'deleteArchiveDocument' => [
            'application/json',
        ],
        'getArchiveDocument' => [
            'application/json',
        ],
        'listArchiveDocuments' => [
            'application/json',
        ],
        'modifyArchiveDocument' => [
            'application/json',
        ],
        'uploadArchiveDocumentAttachment' => [
            'multipart/form-data',
        ],
    ];

    /**
     * @param ClientInterface $client
     * @param Configuration   $config
     * @param HeaderSelector  $selector
     * @param int             $hostIndex (Optional) host index to select the list of hosts if defined in the OpenAPI spec
     */
    public function __construct(
        ClientInterface $client = null,
        Configuration $config = null,
        HeaderSelector $selector = null,
        $hostIndex = 0
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: Configuration::getDefaultConfiguration();
        $this->headerSelector = $selector ?: new HeaderSelector();
        $this->hostIndex = $hostIndex;
    }

    /**
     * Set the host index
     *
     * @param int $hostIndex Host index (required)
     */
    public function setHostIndex($hostIndex): void
    {
        $this->hostIndex = $hostIndex;
    }

    /**
     * Get the host index
     *
     * @return int Host index
     */
    public function getHostIndex()
    {
        return $this->hostIndex;
    }

    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Operation createArchiveDocument
     *
     * Create Archive Document
     *
     * @param  int $company_id The ID of the company. (required)
     * @param  \FattureInCloud\Model\CreateArchiveDocumentRequest $create_archive_document_request The Archive Document. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createArchiveDocument'] to see the possible values for this operation
     *
     * @throws \FattureInCloud\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \FattureInCloud\Model\CreateArchiveDocumentResponse
     */
    public function createArchiveDocument($company_id, $create_archive_document_request = null, string $contentType = self::contentTypes['createArchiveDocument'][0])
    {
        list($response) = $this->createArchiveDocumentWithHttpInfo($company_id, $create_archive_document_request, $contentType);
        return $response;
    }

    /**
     * Operation createArchiveDocumentWithHttpInfo
     *
     * Create Archive Document
     *
     * @param  int $company_id The ID of the company. (required)
     * @param  \FattureInCloud\Model\CreateArchiveDocumentRequest $create_archive_document_request The Archive Document. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createArchiveDocument'] to see the possible values for this operation
     *
     * @throws \FattureInCloud\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \FattureInCloud\Model\CreateArchiveDocumentResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function createArchiveDocumentWithHttpInfo($company_id, $create_archive_document_request = null, string $contentType = self::contentTypes['createArchiveDocument'][0])
    {
        $request = $this->createArchiveDocumentRequest($company_id, $create_archive_document_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch ($statusCode) {
                case 200:
                    if ('\FattureInCloud\Model\CreateArchiveDocumentResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\FattureInCloud\Model\CreateArchiveDocumentResponse' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\FattureInCloud\Model\CreateArchiveDocumentResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\FattureInCloud\Model\CreateArchiveDocumentResponse';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\FattureInCloud\Model\CreateArchiveDocumentResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation createArchiveDocumentAsync
     *
     * Create Archive Document
     *
     * @param  int $company_id The ID of the company. (required)
     * @param  \FattureInCloud\Model\CreateArchiveDocumentRequest $create_archive_document_request The Archive Document. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createArchiveDocument'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createArchiveDocumentAsync($company_id, $create_archive_document_request = null, string $contentType = self::contentTypes['createArchiveDocument'][0])
    {
        return $this->createArchiveDocumentAsyncWithHttpInfo($company_id, $create_archive_document_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createArchiveDocumentAsyncWithHttpInfo
     *
     * Create Archive Document
     *
     * @param  int $company_id The ID of the company. (required)
     * @param  \FattureInCloud\Model\CreateArchiveDocumentRequest $create_archive_document_request The Archive Document. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createArchiveDocument'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createArchiveDocumentAsyncWithHttpInfo($company_id, $create_archive_document_request = null, string $contentType = self::contentTypes['createArchiveDocument'][0])
    {
        $returnType = '\FattureInCloud\Model\CreateArchiveDocumentResponse';
        $request = $this->createArchiveDocumentRequest($company_id, $create_archive_document_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createArchiveDocument'
     *
     * @param  int $company_id The ID of the company. (required)
     * @param  \FattureInCloud\Model\CreateArchiveDocumentRequest $create_archive_document_request The Archive Document. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createArchiveDocument'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function createArchiveDocumentRequest($company_id, $create_archive_document_request = null, string $contentType = self::contentTypes['createArchiveDocument'][0])
    {

        // verify the required parameter 'company_id' is set
        if ($company_id === null || (is_array($company_id) && count($company_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $company_id when calling createArchiveDocument'
            );
        }



        $resourcePath = '/c/{company_id}/archive';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($company_id !== null) {
            $resourcePath = str_replace(
                '{' . 'company_id' . '}',
                ObjectSerializer::toPathValue($company_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($create_archive_document_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($create_archive_document_request));
            } else {
                $httpBody = $create_archive_document_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation deleteArchiveDocument
     *
     * Delete Archive Document
     *
     * @param  int $company_id The ID of the company. (required)
     * @param  int $document_id The ID of the document. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteArchiveDocument'] to see the possible values for this operation
     *
     * @throws \FattureInCloud\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function deleteArchiveDocument($company_id, $document_id, string $contentType = self::contentTypes['deleteArchiveDocument'][0])
    {
        $this->deleteArchiveDocumentWithHttpInfo($company_id, $document_id, $contentType);
    }

    /**
     * Operation deleteArchiveDocumentWithHttpInfo
     *
     * Delete Archive Document
     *
     * @param  int $company_id The ID of the company. (required)
     * @param  int $document_id The ID of the document. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteArchiveDocument'] to see the possible values for this operation
     *
     * @throws \FattureInCloud\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteArchiveDocumentWithHttpInfo($company_id, $document_id, string $contentType = self::contentTypes['deleteArchiveDocument'][0])
    {
        $request = $this->deleteArchiveDocumentRequest($company_id, $document_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
            throw $e;
        }
    }

    /**
     * Operation deleteArchiveDocumentAsync
     *
     * Delete Archive Document
     *
     * @param  int $company_id The ID of the company. (required)
     * @param  int $document_id The ID of the document. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteArchiveDocument'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteArchiveDocumentAsync($company_id, $document_id, string $contentType = self::contentTypes['deleteArchiveDocument'][0])
    {
        return $this->deleteArchiveDocumentAsyncWithHttpInfo($company_id, $document_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation deleteArchiveDocumentAsyncWithHttpInfo
     *
     * Delete Archive Document
     *
     * @param  int $company_id The ID of the company. (required)
     * @param  int $document_id The ID of the document. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteArchiveDocument'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteArchiveDocumentAsyncWithHttpInfo($company_id, $document_id, string $contentType = self::contentTypes['deleteArchiveDocument'][0])
    {
        $returnType = '';
        $request = $this->deleteArchiveDocumentRequest($company_id, $document_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deleteArchiveDocument'
     *
     * @param  int $company_id The ID of the company. (required)
     * @param  int $document_id The ID of the document. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteArchiveDocument'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function deleteArchiveDocumentRequest($company_id, $document_id, string $contentType = self::contentTypes['deleteArchiveDocument'][0])
    {

        // verify the required parameter 'company_id' is set
        if ($company_id === null || (is_array($company_id) && count($company_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $company_id when calling deleteArchiveDocument'
            );
        }

        // verify the required parameter 'document_id' is set
        if ($document_id === null || (is_array($document_id) && count($document_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $document_id when calling deleteArchiveDocument'
            );
        }


        $resourcePath = '/c/{company_id}/archive/{document_id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($company_id !== null) {
            $resourcePath = str_replace(
                '{' . 'company_id' . '}',
                ObjectSerializer::toPathValue($company_id),
                $resourcePath
            );
        }
        // path params
        if ($document_id !== null) {
            $resourcePath = str_replace(
                '{' . 'document_id' . '}',
                ObjectSerializer::toPathValue($document_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'DELETE',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getArchiveDocument
     *
     * Get Archive Document
     *
     * @param  int $company_id The ID of the company. (required)
     * @param  int $document_id The ID of the document. (required)
     * @param  string $fields List of comma-separated fields. (optional)
     * @param  string $fieldset Name of the fieldset. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getArchiveDocument'] to see the possible values for this operation
     *
     * @throws \FattureInCloud\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \FattureInCloud\Model\GetArchiveDocumentResponse
     */
    public function getArchiveDocument($company_id, $document_id, $fields = null, $fieldset = null, string $contentType = self::contentTypes['getArchiveDocument'][0])
    {
        list($response) = $this->getArchiveDocumentWithHttpInfo($company_id, $document_id, $fields, $fieldset, $contentType);
        return $response;
    }

    /**
     * Operation getArchiveDocumentWithHttpInfo
     *
     * Get Archive Document
     *
     * @param  int $company_id The ID of the company. (required)
     * @param  int $document_id The ID of the document. (required)
     * @param  string $fields List of comma-separated fields. (optional)
     * @param  string $fieldset Name of the fieldset. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getArchiveDocument'] to see the possible values for this operation
     *
     * @throws \FattureInCloud\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \FattureInCloud\Model\GetArchiveDocumentResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function getArchiveDocumentWithHttpInfo($company_id, $document_id, $fields = null, $fieldset = null, string $contentType = self::contentTypes['getArchiveDocument'][0])
    {
        $request = $this->getArchiveDocumentRequest($company_id, $document_id, $fields, $fieldset, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch ($statusCode) {
                case 200:
                    if ('\FattureInCloud\Model\GetArchiveDocumentResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\FattureInCloud\Model\GetArchiveDocumentResponse' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\FattureInCloud\Model\GetArchiveDocumentResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\FattureInCloud\Model\GetArchiveDocumentResponse';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\FattureInCloud\Model\GetArchiveDocumentResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getArchiveDocumentAsync
     *
     * Get Archive Document
     *
     * @param  int $company_id The ID of the company. (required)
     * @param  int $document_id The ID of the document. (required)
     * @param  string $fields List of comma-separated fields. (optional)
     * @param  string $fieldset Name of the fieldset. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getArchiveDocument'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getArchiveDocumentAsync($company_id, $document_id, $fields = null, $fieldset = null, string $contentType = self::contentTypes['getArchiveDocument'][0])
    {
        return $this->getArchiveDocumentAsyncWithHttpInfo($company_id, $document_id, $fields, $fieldset, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getArchiveDocumentAsyncWithHttpInfo
     *
     * Get Archive Document
     *
     * @param  int $company_id The ID of the company. (required)
     * @param  int $document_id The ID of the document. (required)
     * @param  string $fields List of comma-separated fields. (optional)
     * @param  string $fieldset Name of the fieldset. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getArchiveDocument'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getArchiveDocumentAsyncWithHttpInfo($company_id, $document_id, $fields = null, $fieldset = null, string $contentType = self::contentTypes['getArchiveDocument'][0])
    {
        $returnType = '\FattureInCloud\Model\GetArchiveDocumentResponse';
        $request = $this->getArchiveDocumentRequest($company_id, $document_id, $fields, $fieldset, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getArchiveDocument'
     *
     * @param  int $company_id The ID of the company. (required)
     * @param  int $document_id The ID of the document. (required)
     * @param  string $fields List of comma-separated fields. (optional)
     * @param  string $fieldset Name of the fieldset. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getArchiveDocument'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getArchiveDocumentRequest($company_id, $document_id, $fields = null, $fieldset = null, string $contentType = self::contentTypes['getArchiveDocument'][0])
    {

        // verify the required parameter 'company_id' is set
        if ($company_id === null || (is_array($company_id) && count($company_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $company_id when calling getArchiveDocument'
            );
        }

        // verify the required parameter 'document_id' is set
        if ($document_id === null || (is_array($document_id) && count($document_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $document_id when calling getArchiveDocument'
            );
        }




        $resourcePath = '/c/{company_id}/archive/{document_id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $fields,
            'fields', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $fieldset,
            'fieldset', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);


        // path params
        if ($company_id !== null) {
            $resourcePath = str_replace(
                '{' . 'company_id' . '}',
                ObjectSerializer::toPathValue($company_id),
                $resourcePath
            );
        }
        // path params
        if ($document_id !== null) {
            $resourcePath = str_replace(
                '{' . 'document_id' . '}',
                ObjectSerializer::toPathValue($document_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation listArchiveDocuments
     *
     * List Archive Documents
     *
     * @param  int $company_id The ID of the company. (required)
     * @param  string $fields List of comma-separated fields. (optional)
     * @param  string $fieldset Name of the fieldset. (optional)
     * @param  string $sort List of comma-separated fields for result sorting (minus for desc sorting). (optional)
     * @param  int $page The page to retrieve. (optional, default to 1)
     * @param  int $per_page The size of the page. (optional, default to 5)
     * @param  string $q Query for filtering the results. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['listArchiveDocuments'] to see the possible values for this operation
     *
     * @throws \FattureInCloud\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \FattureInCloud\Model\ListArchiveDocumentsResponse
     */
    public function listArchiveDocuments($company_id, $fields = null, $fieldset = null, $sort = null, $page = 1, $per_page = 5, $q = null, string $contentType = self::contentTypes['listArchiveDocuments'][0])
    {
        list($response) = $this->listArchiveDocumentsWithHttpInfo($company_id, $fields, $fieldset, $sort, $page, $per_page, $q, $contentType);
        return $response;
    }

    /**
     * Operation listArchiveDocumentsWithHttpInfo
     *
     * List Archive Documents
     *
     * @param  int $company_id The ID of the company. (required)
     * @param  string $fields List of comma-separated fields. (optional)
     * @param  string $fieldset Name of the fieldset. (optional)
     * @param  string $sort List of comma-separated fields for result sorting (minus for desc sorting). (optional)
     * @param  int $page The page to retrieve. (optional, default to 1)
     * @param  int $per_page The size of the page. (optional, default to 5)
     * @param  string $q Query for filtering the results. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['listArchiveDocuments'] to see the possible values for this operation
     *
     * @throws \FattureInCloud\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \FattureInCloud\Model\ListArchiveDocumentsResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function listArchiveDocumentsWithHttpInfo($company_id, $fields = null, $fieldset = null, $sort = null, $page = 1, $per_page = 5, $q = null, string $contentType = self::contentTypes['listArchiveDocuments'][0])
    {
        $request = $this->listArchiveDocumentsRequest($company_id, $fields, $fieldset, $sort, $page, $per_page, $q, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch ($statusCode) {
                case 200:
                    if ('\FattureInCloud\Model\ListArchiveDocumentsResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\FattureInCloud\Model\ListArchiveDocumentsResponse' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\FattureInCloud\Model\ListArchiveDocumentsResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\FattureInCloud\Model\ListArchiveDocumentsResponse';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\FattureInCloud\Model\ListArchiveDocumentsResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation listArchiveDocumentsAsync
     *
     * List Archive Documents
     *
     * @param  int $company_id The ID of the company. (required)
     * @param  string $fields List of comma-separated fields. (optional)
     * @param  string $fieldset Name of the fieldset. (optional)
     * @param  string $sort List of comma-separated fields for result sorting (minus for desc sorting). (optional)
     * @param  int $page The page to retrieve. (optional, default to 1)
     * @param  int $per_page The size of the page. (optional, default to 5)
     * @param  string $q Query for filtering the results. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['listArchiveDocuments'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function listArchiveDocumentsAsync($company_id, $fields = null, $fieldset = null, $sort = null, $page = 1, $per_page = 5, $q = null, string $contentType = self::contentTypes['listArchiveDocuments'][0])
    {
        return $this->listArchiveDocumentsAsyncWithHttpInfo($company_id, $fields, $fieldset, $sort, $page, $per_page, $q, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation listArchiveDocumentsAsyncWithHttpInfo
     *
     * List Archive Documents
     *
     * @param  int $company_id The ID of the company. (required)
     * @param  string $fields List of comma-separated fields. (optional)
     * @param  string $fieldset Name of the fieldset. (optional)
     * @param  string $sort List of comma-separated fields for result sorting (minus for desc sorting). (optional)
     * @param  int $page The page to retrieve. (optional, default to 1)
     * @param  int $per_page The size of the page. (optional, default to 5)
     * @param  string $q Query for filtering the results. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['listArchiveDocuments'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function listArchiveDocumentsAsyncWithHttpInfo($company_id, $fields = null, $fieldset = null, $sort = null, $page = 1, $per_page = 5, $q = null, string $contentType = self::contentTypes['listArchiveDocuments'][0])
    {
        $returnType = '\FattureInCloud\Model\ListArchiveDocumentsResponse';
        $request = $this->listArchiveDocumentsRequest($company_id, $fields, $fieldset, $sort, $page, $per_page, $q, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'listArchiveDocuments'
     *
     * @param  int $company_id The ID of the company. (required)
     * @param  string $fields List of comma-separated fields. (optional)
     * @param  string $fieldset Name of the fieldset. (optional)
     * @param  string $sort List of comma-separated fields for result sorting (minus for desc sorting). (optional)
     * @param  int $page The page to retrieve. (optional, default to 1)
     * @param  int $per_page The size of the page. (optional, default to 5)
     * @param  string $q Query for filtering the results. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['listArchiveDocuments'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function listArchiveDocumentsRequest($company_id, $fields = null, $fieldset = null, $sort = null, $page = 1, $per_page = 5, $q = null, string $contentType = self::contentTypes['listArchiveDocuments'][0])
    {

        // verify the required parameter 'company_id' is set
        if ($company_id === null || (is_array($company_id) && count($company_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $company_id when calling listArchiveDocuments'
            );
        }





        if ($per_page !== null && $per_page > 100) {
            throw new \InvalidArgumentException('invalid value for "$per_page" when calling ArchiveApi.listArchiveDocuments, must be smaller than or equal to 100.');
        }
        if ($per_page !== null && $per_page < 1) {
            throw new \InvalidArgumentException('invalid value for "$per_page" when calling ArchiveApi.listArchiveDocuments, must be bigger than or equal to 1.');
        }



        $resourcePath = '/c/{company_id}/archive';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $fields,
            'fields', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $fieldset,
            'fieldset', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $sort,
            'sort', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $page,
            'page', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $per_page,
            'per_page', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $q,
            'q', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);


        // path params
        if ($company_id !== null) {
            $resourcePath = str_replace(
                '{' . 'company_id' . '}',
                ObjectSerializer::toPathValue($company_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation modifyArchiveDocument
     *
     * Modify Archive Document
     *
     * @param  int $company_id The ID of the company. (required)
     * @param  int $document_id The ID of the document. (required)
     * @param  \FattureInCloud\Model\ModifyArchiveDocumentRequest $modify_archive_document_request Modified Archive Document (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['modifyArchiveDocument'] to see the possible values for this operation
     *
     * @throws \FattureInCloud\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \FattureInCloud\Model\ModifyArchiveDocumentResponse
     */
    public function modifyArchiveDocument($company_id, $document_id, $modify_archive_document_request = null, string $contentType = self::contentTypes['modifyArchiveDocument'][0])
    {
        list($response) = $this->modifyArchiveDocumentWithHttpInfo($company_id, $document_id, $modify_archive_document_request, $contentType);
        return $response;
    }

    /**
     * Operation modifyArchiveDocumentWithHttpInfo
     *
     * Modify Archive Document
     *
     * @param  int $company_id The ID of the company. (required)
     * @param  int $document_id The ID of the document. (required)
     * @param  \FattureInCloud\Model\ModifyArchiveDocumentRequest $modify_archive_document_request Modified Archive Document (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['modifyArchiveDocument'] to see the possible values for this operation
     *
     * @throws \FattureInCloud\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \FattureInCloud\Model\ModifyArchiveDocumentResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function modifyArchiveDocumentWithHttpInfo($company_id, $document_id, $modify_archive_document_request = null, string $contentType = self::contentTypes['modifyArchiveDocument'][0])
    {
        $request = $this->modifyArchiveDocumentRequest($company_id, $document_id, $modify_archive_document_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch ($statusCode) {
                case 200:
                    if ('\FattureInCloud\Model\ModifyArchiveDocumentResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\FattureInCloud\Model\ModifyArchiveDocumentResponse' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\FattureInCloud\Model\ModifyArchiveDocumentResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\FattureInCloud\Model\ModifyArchiveDocumentResponse';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\FattureInCloud\Model\ModifyArchiveDocumentResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation modifyArchiveDocumentAsync
     *
     * Modify Archive Document
     *
     * @param  int $company_id The ID of the company. (required)
     * @param  int $document_id The ID of the document. (required)
     * @param  \FattureInCloud\Model\ModifyArchiveDocumentRequest $modify_archive_document_request Modified Archive Document (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['modifyArchiveDocument'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function modifyArchiveDocumentAsync($company_id, $document_id, $modify_archive_document_request = null, string $contentType = self::contentTypes['modifyArchiveDocument'][0])
    {
        return $this->modifyArchiveDocumentAsyncWithHttpInfo($company_id, $document_id, $modify_archive_document_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation modifyArchiveDocumentAsyncWithHttpInfo
     *
     * Modify Archive Document
     *
     * @param  int $company_id The ID of the company. (required)
     * @param  int $document_id The ID of the document. (required)
     * @param  \FattureInCloud\Model\ModifyArchiveDocumentRequest $modify_archive_document_request Modified Archive Document (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['modifyArchiveDocument'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function modifyArchiveDocumentAsyncWithHttpInfo($company_id, $document_id, $modify_archive_document_request = null, string $contentType = self::contentTypes['modifyArchiveDocument'][0])
    {
        $returnType = '\FattureInCloud\Model\ModifyArchiveDocumentResponse';
        $request = $this->modifyArchiveDocumentRequest($company_id, $document_id, $modify_archive_document_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'modifyArchiveDocument'
     *
     * @param  int $company_id The ID of the company. (required)
     * @param  int $document_id The ID of the document. (required)
     * @param  \FattureInCloud\Model\ModifyArchiveDocumentRequest $modify_archive_document_request Modified Archive Document (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['modifyArchiveDocument'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function modifyArchiveDocumentRequest($company_id, $document_id, $modify_archive_document_request = null, string $contentType = self::contentTypes['modifyArchiveDocument'][0])
    {

        // verify the required parameter 'company_id' is set
        if ($company_id === null || (is_array($company_id) && count($company_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $company_id when calling modifyArchiveDocument'
            );
        }

        // verify the required parameter 'document_id' is set
        if ($document_id === null || (is_array($document_id) && count($document_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $document_id when calling modifyArchiveDocument'
            );
        }



        $resourcePath = '/c/{company_id}/archive/{document_id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($company_id !== null) {
            $resourcePath = str_replace(
                '{' . 'company_id' . '}',
                ObjectSerializer::toPathValue($company_id),
                $resourcePath
            );
        }
        // path params
        if ($document_id !== null) {
            $resourcePath = str_replace(
                '{' . 'document_id' . '}',
                ObjectSerializer::toPathValue($document_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($modify_archive_document_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($modify_archive_document_request));
            } else {
                $httpBody = $modify_archive_document_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation uploadArchiveDocumentAttachment
     *
     * Upload Archive Document Attachment
     *
     * @param  int $company_id The ID of the company. (required)
     * @param  string $filename Attachment file name (optional)
     * @param  \SplFileObject $attachment Attachment file [.png, .jpg, .gif, .pdf, .zip, .xls, .xlsx, .doc, .docx] (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['uploadArchiveDocumentAttachment'] to see the possible values for this operation
     *
     * @throws \FattureInCloud\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \FattureInCloud\Model\UploadArchiveAttachmentResponse
     */
    public function uploadArchiveDocumentAttachment($company_id, $filename = null, $attachment = null, string $contentType = self::contentTypes['uploadArchiveDocumentAttachment'][0])
    {
        list($response) = $this->uploadArchiveDocumentAttachmentWithHttpInfo($company_id, $filename, $attachment, $contentType);
        return $response;
    }

    /**
     * Operation uploadArchiveDocumentAttachmentWithHttpInfo
     *
     * Upload Archive Document Attachment
     *
     * @param  int $company_id The ID of the company. (required)
     * @param  string $filename Attachment file name (optional)
     * @param  \SplFileObject $attachment Attachment file [.png, .jpg, .gif, .pdf, .zip, .xls, .xlsx, .doc, .docx] (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['uploadArchiveDocumentAttachment'] to see the possible values for this operation
     *
     * @throws \FattureInCloud\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \FattureInCloud\Model\UploadArchiveAttachmentResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function uploadArchiveDocumentAttachmentWithHttpInfo($company_id, $filename = null, $attachment = null, string $contentType = self::contentTypes['uploadArchiveDocumentAttachment'][0])
    {
        $request = $this->uploadArchiveDocumentAttachmentRequest($company_id, $filename, $attachment, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch ($statusCode) {
                case 200:
                    if ('\FattureInCloud\Model\UploadArchiveAttachmentResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\FattureInCloud\Model\UploadArchiveAttachmentResponse' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\FattureInCloud\Model\UploadArchiveAttachmentResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\FattureInCloud\Model\UploadArchiveAttachmentResponse';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\FattureInCloud\Model\UploadArchiveAttachmentResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation uploadArchiveDocumentAttachmentAsync
     *
     * Upload Archive Document Attachment
     *
     * @param  int $company_id The ID of the company. (required)
     * @param  string $filename Attachment file name (optional)
     * @param  \SplFileObject $attachment Attachment file [.png, .jpg, .gif, .pdf, .zip, .xls, .xlsx, .doc, .docx] (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['uploadArchiveDocumentAttachment'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function uploadArchiveDocumentAttachmentAsync($company_id, $filename = null, $attachment = null, string $contentType = self::contentTypes['uploadArchiveDocumentAttachment'][0])
    {
        return $this->uploadArchiveDocumentAttachmentAsyncWithHttpInfo($company_id, $filename, $attachment, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation uploadArchiveDocumentAttachmentAsyncWithHttpInfo
     *
     * Upload Archive Document Attachment
     *
     * @param  int $company_id The ID of the company. (required)
     * @param  string $filename Attachment file name (optional)
     * @param  \SplFileObject $attachment Attachment file [.png, .jpg, .gif, .pdf, .zip, .xls, .xlsx, .doc, .docx] (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['uploadArchiveDocumentAttachment'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function uploadArchiveDocumentAttachmentAsyncWithHttpInfo($company_id, $filename = null, $attachment = null, string $contentType = self::contentTypes['uploadArchiveDocumentAttachment'][0])
    {
        $returnType = '\FattureInCloud\Model\UploadArchiveAttachmentResponse';
        $request = $this->uploadArchiveDocumentAttachmentRequest($company_id, $filename, $attachment, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'uploadArchiveDocumentAttachment'
     *
     * @param  int $company_id The ID of the company. (required)
     * @param  string $filename Attachment file name (optional)
     * @param  \SplFileObject $attachment Attachment file [.png, .jpg, .gif, .pdf, .zip, .xls, .xlsx, .doc, .docx] (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['uploadArchiveDocumentAttachment'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function uploadArchiveDocumentAttachmentRequest($company_id, $filename = null, $attachment = null, string $contentType = self::contentTypes['uploadArchiveDocumentAttachment'][0])
    {

        // verify the required parameter 'company_id' is set
        if ($company_id === null || (is_array($company_id) && count($company_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $company_id when calling uploadArchiveDocumentAttachment'
            );
        }




        $resourcePath = '/c/{company_id}/archive/attachment';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($company_id !== null) {
            $resourcePath = str_replace(
                '{' . 'company_id' . '}',
                ObjectSerializer::toPathValue($company_id),
                $resourcePath
            );
        }

        // form params
        if ($filename !== null) {
            $formParams['filename'] = ObjectSerializer::toFormValue($filename);
        }
        // form params
        if ($attachment !== null) {
            $multipart = true;
            $formParams['attachment'] = [];
            $paramFiles = is_array($attachment) ? $attachment : [$attachment];
            foreach ($paramFiles as $paramFile) {
                $formParams['attachment'][] = \GuzzleHttp\Psr7\Utils::tryFopen(
                    ObjectSerializer::toFormValue($paramFile),
                    'rb'
                );
            }
        }

        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption()
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[RequestOptions::DEBUG] = fopen($this->config->getDebugFile(), 'a');
            if (!$options[RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }

        return $options;
    }
}
