# # IssuedDocument

## Properties

Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**id** | **int** | Issued document id | [optional]
**entity** | [**\FattureInCloud\Model\Entity**](Entity.md) |  | [optional]
**type** | [**\FattureInCloud\Model\IssuedDocumentType**](IssuedDocumentType.md) |  | [optional]
**number** | **int** | Issued document number [If not specified, next number is used] | [optional]
**numeration** | **string** | Issued document numeration [Not available if type&#x3D;delivery_note] | [optional]
**date** | **\DateTime** | Issued document date [defaults to today&#39;s date] | [optional]
**year** | **int** | Issued document year | [optional]
**currency** | [**\FattureInCloud\Model\Currency**](Currency.md) |  | [optional]
**language** | [**\FattureInCloud\Model\Language**](Language.md) |  | [optional]
**subject** | **string** | Issued document subject [not shown on the PDF] | [optional]
**visible_subject** | **string** | Issued document visible subject | [optional]
**rc_center** | **string** | Issued document revenue center [or cost center if type&#x3D;supplier_order]. | [optional]
**notes** | **string** | Issued document extra notes | [optional]
**rivalsa** | **float** | Issued document \&quot;Rivalsa INPS\&quot; percentual value | [optional]
**cassa** | **float** | Issued document \&quot;Cassa previdenziale\&quot; percentual value | [optional]
**amount_cassa** | **float** | [Read Only] Issued document cassa amount. | [optional] [readonly]
**cassa_taxable** | **float** | Issued document cassa taxable percentage | [optional]
**amount_cassa_taxable** | **float** | [Can be set only if cassa_taxable is NULL] Issued document cassa taxable amount | [optional]
**cassa2** | **float** | Issued document \&quot;Cassa previdenziale 2\&quot; percentual value | [optional]
**amount_cassa2** | **float** | [Read Only] Issued document cassa2 amount | [optional] [readonly]
**cassa2_taxable** | **float** | Issued document cassa2 taxable percentage | [optional]
**amount_cassa2_taxable** | **float** | [Can be set only if cassa2_taxable is NULL] Issued document cassa2 taxable amount | [optional]
**global_cassa_taxable** | **float** | Issued document global cassa taxable percentage | [optional]
**amount_global_cassa_taxable** | **float** | [Can be set only if global_cassa_taxable is NULL] Issued document global cassa taxable amount | [optional]
**withholding_tax** | **float** | Issued document withholding tax (ritenuta d&#39;acconto) percentual value | [optional]
**withholding_tax_taxable** | **float** | Issued document withholding tax taxable (imponibile) percentual value | [optional]
**other_withholding_tax** | **float** | Issued document other withholding tax (altra ritenuta) percentual value | [optional]
**stamp_duty** | **float** | Issued document stamp duty value [0 if not present] | [optional]
**payment_method** | [**\FattureInCloud\Model\PaymentMethod**](PaymentMethod.md) |  | [optional]
**use_split_payment** | **bool** | Issued document uses split payment | [optional]
**use_gross_prices** | **bool** | Issued document uses gross prices | [optional]
**e_invoice** | **bool** | Issued document is an e-invoice. | [optional]
**ei_data** | [**\FattureInCloud\Model\IssuedDocumentEiData**](IssuedDocumentEiData.md) |  | [optional]
**ei_cassa_type** | **string** | E-invoice cassa type | [optional]
**ei_cassa2_type** | **string** | E-invoice cassa2 type | [optional]
**ei_withholding_tax_causal** | **string** | E-invoice withholding tax causal | [optional]
**ei_other_withholding_tax_type** | **string** | E-invoice other withholding tax type | [optional]
**ei_other_withholding_tax_causal** | **string** | E-invoice other withholding tax causal | [optional]
**items_list** | [**\FattureInCloud\Model\IssuedDocumentItemsListItem[]**](IssuedDocumentItemsListItem.md) |  | [optional]
**payments_list** | [**\FattureInCloud\Model\IssuedDocumentPaymentsListItem[]**](IssuedDocumentPaymentsListItem.md) |  | [optional]
**template** | [**\FattureInCloud\Model\DocumentTemplate**](DocumentTemplate.md) |  | [optional]
**delivery_note_template** | [**\FattureInCloud\Model\DocumentTemplate**](DocumentTemplate.md) |  | [optional]
**acc_inv_template** | [**\FattureInCloud\Model\DocumentTemplate**](DocumentTemplate.md) |  | [optional]
**h_margins** | **int** | Issued document PDF horizontal margins | [optional]
**v_margins** | **int** | Issued document PDF vertical margins | [optional]
**show_payments** | **bool** | Show the expiration dates of the payments on the document | [optional]
**show_payment_method** | **bool** | Show the payment method details on the document | [optional]
**show_totals** | [**\FattureInCloud\Model\ShowTotalsMode**](ShowTotalsMode.md) |  | [optional]
**show_notification_button** | **bool** | Show notification button in the PDF | [optional]
**show_tspay_button** | **bool** | Show ts pay button in the PDF | [optional]
**delivery_note** | **bool** | Issued document has delivery note | [optional]
**accompanying_invoice** | **bool** | Issued document has an accompanying invoice | [optional]
**dn_number** | **int** | Issued document attached delivery note number | [optional]
**dn_date** | **\DateTime** | Issued document attached delivery note date | [optional]
**dn_ai_packages_number** | **string** | Issued document attached delivery note number of packages | [optional]
**dn_ai_weight** | **string** | Issued document attached delivery note package weight | [optional]
**dn_ai_causal** | **string** | Issued document attached delivery note causal | [optional]
**dn_ai_destination** | **string** | Issued document attached delivery note destination | [optional]
**dn_ai_transporter** | **string** | Issued document attached delivery note transporter | [optional]
**dn_ai_notes** | **string** | Issued document attached delivery note notes | [optional]
**is_marked** | **bool** | Issued document is marked | [optional]
**amount_net** | **float** | [Read only] Issued document total net amount | [optional] [readonly]
**amount_vat** | **float** | [Read Only] Issued document total vat amount | [optional] [readonly]
**amount_gross** | **float** | [Read Only] Issued document total gross amount | [optional] [readonly]
**amount_due_discount** | **float** | Issued document amount due discount | [optional]
**amount_rivalsa** | **float** | [Read Only] Issued document rivalsa amount | [optional] [readonly]
**amount_rivalsa_taxable** | **float** | Issued document taxable rivalsa amount | [optional]
**amount_withholding_tax** | **float** | [Read Only] Issued document withholding tax amount (ritenuta d&#39;acconto). | [optional] [readonly]
**amount_withholding_tax_taxable** | **float** | Issued document taxable withholding tax amount | [optional]
**amount_other_withholding_tax** | **float** | [Read Only] Issued document other withholding tax amount (altra ritenuta) | [optional] [readonly]
**amount_other_withholding_tax_taxable** | **float** | Issued document taxable other withholding tax amount | [optional]
**amount_enasarco_taxable** | **float** | Issued document taxable enasarco amount | [optional]
**extra_data** | [**\FattureInCloud\Model\IssuedDocumentExtraData**](IssuedDocumentExtraData.md) |  | [optional]
**seen_date** | **\DateTime** | Issued document seen date | [optional]
**next_due_date** | **\DateTime** | Issued document date of the next not paid payment | [optional]
**url** | **string** | [Temporary] [Read Only] Issued document url of the document PDF file | [optional]
**dn_url** | **string** | [Temporary] [Read Only] Issued document url of the attached delivery note PDF file | [optional]
**ai_url** | **string** | [Temporary] [Read Only] Issued document url of the accompanying invoice PDF file | [optional]
**attachment_url** | **string** | [Temporary] [Read Only] Issued document url of the attached file | [optional] [readonly]
**attachment_token** | **string** | [Write Only] Issued document attachment token returned by POST /issued_documents/attachment | [optional]
**ei_raw** | **object** | Issued document advanced raw attributes for e-invoices | [optional]
**ei_status** | **string** | [Read only] Status of the e-invoice.   * **attempt** - We are trying to send the invoice, please wait up to 2 hours   * **missing** - The invoice is missing   * **not_sent** - The invoice has yet to be sent   * **sent** - The invoice was sent   * **pending** - The checks for the digital signature and sending are in progress   * **processing** - The SDI is delivering the invoice to the customer   * **error** - An error occurred while handling the invoice, please try to resend it or contact support   * **discarded** - The invoice has been rejected by the SDI, so it must be corrected and re-sent   * **not_delivered** - The SDI was unable to deliver the invoice   * **accepted** - The customer accepted the invoice   * **rejected** - The customer rejected the invoice, so it must be corrected   * **no_response** - A response has not yet been received whithin the deadline, contact the customer to ascertain the status of the invoice   * **manual_accepted** - The customer accepted the invoice   * **manual_rejected** - The customer rejected the invoice | [optional]
**locked** | **bool** | Issued Document can&#39;t be edited | [optional]
**created_at** | **string** | Issued document creation date | [optional]
**updated_at** | **string** | Issued document last update date | [optional]

[[Back to Model list]](../../README.md#models) [[Back to API list]](../../README.md#endpoints) [[Back to README]](../../README.md)
