<div align="center">
  <img src="./assets/design/latest/app_logo.svg" width="300" height="100" />    
  <p><b>RiMusic</b> is a <b>multilingual</b> Android application for streaming music from YouTube Music.</p>
  <p>It began as an <b>extension</b> of <b>ViMusic</b>, then acquired its own identity.</p>
<p><b>It allowing the user to customize it at will.</b></p>
</div>

## ✨ Features
- **Multilingual support:** English, Italian, German, Russian, French, Spanish, Czech, Turkish, Romanian and more. Contributions for other languages are welcome
- UI Mode, change style from RiMusic to classic ViMusic style and viceversa
- Play songs from YouTube Music
- Change your favorite language from settings
- Auto cache songs for offline playback with a custom cache size
- Download songs or entire playlists for offline playback (not cache) 
- Background playback with stop when app swipe out from task manager
- Minimized player optimizations
- Listening statistics
- Audio visualizer on player with many type of effects. THIS FEATURES REQUIRE MIC PERMISSION, ONLY AVAILABLE IF ACTIVATED FROM SETTINGS. BY DEFAULT IT IS DISABLED [Full list of permissions](https://github.com/fast4x/RiMusic/wiki/FAQs#what-permissions-are-used)
- News, mood and musical genres
- New albums from favourite artists
- Search for songs, albums, artists and playlists
- Bookmark artists and albums
- Import online playlists 
- Local playlist management
- Export/Import local playlist, can share with friend RiMusic playlist
- Reorder songs in playlist or queue
- Persistent queue
- Clear queue
- Share menu with support for YouTube and YouTube Music links
- Fetch, display, edit and translate synchronized, or not, songs lyrics
- Light, Dark, Dynamic, PureBlack and ModernBack themes
- Sleep timer with customizable time
- Audio control panel: control volume of app and device, playback speed and pitch
- Audio normalization
- Audio auto-skip silence
- Android Auto support
- Android TV support
- Youtube Video support
- Widgets in home screen
- Check for Updates, which can be enabled or disabled in settings

## 📷 Screenshots
<div align="center">
  <img src="./fastlane/metadata/android/en-US/images/phoneScreenshots/1.jpg" width="15%" />
  <img src="./fastlane/metadata/android/en-US/images/phoneScreenshots/2.jpg" width="15%" />
  <img src="./fastlane/metadata/android/en-US/images/phoneScreenshots/3.jpg" width="15%" />
  <img src="./fastlane/metadata/android/en-US/images/phoneScreenshots/4.jpg" width="15%" />
  <img src="./fastlane/metadata/android/en-US/images/phoneScreenshots/5.jpg" width="15%" />
  <img src="./fastlane/metadata/android/en-US/images/phoneScreenshots/6.jpg" width="15%" />
</div>

## 🌐 Languages available
- **Afrikaans** thanks to [HelloZebra1133](https://crowdin.com/profile/HelloZebra1133)
- **Arabic:** thanks to [ABS zarzis](https://crowdin.com/profile/abszar) and [Ahmad Al Juwaisri](https://crowdin.com/profile/juwaisri)
- **Bangla:** thanks to [Ann Naser Nabil](https://github.com/AnnNaserNabil)
- **Bashkir:** thanks to [Shilave malay](https://crowdin.com/profile/Bash.boy)
- **Catalan:** thanks to [Aniol](https://crowdin.com/profile/aniol) and [EMC_Translator](https://crowdin.com/profile/EMC_Translator)
- **Chinese Simplified:** thanks to [benhaotang](https://crowdin.com/profile/benhaotang) and [SharkChan0622](https://github.com/SharkChan0622)
- **Chinese Traditional:** thanks to [YeeTW](https://github.com/yjcTW) and [SharkChan0622](https://github.com/SharkChan0622)
- **Czech:** thanks to [ikanakova](https://github.com/ikanakova) and [JZITNIK-github](https://github.com/JZITNIK-github)
- **Danish** thanks to [cultcats](https://crowdin.com/profile/cultcats)
- **Dutch:** thanks to [BabyBenefactor](https://crowdin.com/profile/BabyBenefactor)
- **English:** thanks to [koliwan](https://crowdin.com/profile/koliwan) and [Glich440](https://github.com/Glich440) and [fast4x](https://github.com/fast4x)
- **Esperanto:** thanks to [kefiiris](https://github.com/kefiiris)
- **Estonian** thanks to [beez276](https://crowdin.com/profile/beez276)
- **Filipino** thanks to [Clyde-Timonera](https://github.com/Clyde-Timonera)
- **Finnish:** thanks to [rikalaj](https://crowdin.com/profile/rikalaj)
- **French:** thanks to [NEVARLeVrai](https://github.com/NEVARLeVrai)
- **Galician:** thanks to [ninjum](https://crowdin.com/profile/ninjum)
- **German:** thanks to [materialred](https://crowdin.com/profile/materialred) and [OlimitLolli](https://crowdin.com/profile/OlimitLolli) and [Lolozweipunktnull](https://crowdin.com/profile/Lolozweipunktnull) and [Seryoga1984](https://crowdin.com/profile/Seryoga1984) and [Conk](https://crowdin.com/profile/conk) and [siggi1984](https://github.com/siggi1984)
- **Greek:** thanks to [Marinkas](https://github.com/Marinkas)
- **Hebrew:** thanks to [opcitgv](https://crowdin.com/profile/opcitgv) and [TheCreeperDuck](https://crowdin.com/profile/thecreeperduck)
- **Hindi:** thanks to [NikunjKhangwal](https://crowdin.com/profile/nikunjkhangwal) and [Sharunkumar](https://crowdin.com/profile/sharunkumar) and [Th3-C0der](https://github.com/Th3-C0der)
- **Hungarìan:** thanks to [Zan1456](https://crowdin.com/profile/Zan1456) and [Ndvok](https://crowdin.com/profile/ndvok)
- **Italian:** thanks to [agefcgo](https://crowdin.com/profile/agefcgo) and [CiccioDerole](https://crowdin.com/profile/CiccioDerole) and [fast4x](https://github.com/fast4x)
- **Indonesian:** thanks to [luthfialfarabi](https://crowdin.com/profile/luthfialfarabi) and [teddysulaimanGL](https://github.com/teddysulaimanGL) and [Fausta Ahmad](https://crowdin.com/profile/faustaahmad)  
- **Interlingua** thanks to [softinterlingua](https://github.com/softinterlingua)
- **Japanese:** thanks to [Mid_Vur_Shaan](https://crowdin.com/profile/Mid_Vur_Shaan)
- **Korean:** thanks to [ZeroZero00](https://crowdin.com/profile/ZeroZero00) and [TsyQax](https://crowdin.com/profile/TsyQax)
- **Norwegian:** thanks to [xyrcon](https://crowdin.com/profile/xyrcon)
- **Odia:** thanks to [Get100percent](https://github.com/Get100percent)
- **Persian:** thanks to [CUMOON](https://github.com/CUMOON)
- **Polish:** thanks to [Zduniusz](https://crowdin.com/profile/zduniusz) and [AntoniNowak](https://crowdin.com/profile/AntoniNowak) and [roklc](https://github.com/roklc) and [Adam Kop](https://crowdin.com/profile/damianadam000)
- **Portuguese:** thanks to [ManuelCoimbra](https://crowdin.com/profile/ManuelCoimbra) and [NEVARLeVrai](https://github.com/NEVARLeVrai)
- **Portuguese, Brazilian:** thanks to [xSyntheticWave](https://crowdin.com/profile/xSyntheticWave) and [RegularWater](https://crowdin.com/profile/RegularWater) and [NEVARLeVrai](https://github.com/NEVARLeVrai)
- **Romanian:** thanks to [OrangeZXZ](https://github.com/OrangeZxZ)
- **Russian:** thanks to [koliwan](https://crowdin.com/profile/koliwan) and [Nebula-Mechanica](https://crowdin.com/profile/Nebula-Mechanica) and [Alnoer](https://crowdin.com/profile/Alnoer) and [kptmx](https://crowdin.com/profile/kptmx) and [Crayz310](https://github.com/Crayz310) and [Vladimir](https://crowdin.com/profile/vladimir15426) and [@siggi1984](https://github.com/siggi1984)
- **Serbian (Cyrillic, Latin)** thanks to [IvanMaksimovic77](https://github.com/IvanMaksimovic77)
- **Spanish:** thanks to [iOSStarWorld](https://crowdin.com/profile/iosstarworld) and [Corotyest](https://crowdin.com/profile/corotyest) and [DanielSevillano](https://github.com/DanielSevillano) and [Fabian Urra](https://crowdin.com/profile/nsagcl)
- **Sinhala:** thanks to [VINULA2007](https://crowdin.com/profile/VINULA2007)
- **Swedish:** thanks to [sebbe.ekman](https://crowdin.com/profile/sebbe.ekman) and [Dženan](https://crowdin.com/profile/Dženan)
- **Turkish:** thanks to [abfreeman](https://github.com/abfreeman) and [2010furs](https://github.com/2010furs) and [Muha Aliss](https://crowdin.com/profile/muhaaliss)
- **Telugu** thanks to [SureshTimma](https://crowdin.com/profile/sureshtimma)
- **Ukrainian:** thanks to [NiXT0y](https://crowdin.com/profile/nixt0y) and [Crayz310](https://github.com/Crayz310) 
- **Vietnamese:** thanks to [teaminh](https://crowdin.com/profile/teaminh)

## 📲 Installation
[<img src="./assets/images/getItGithub.png" alt="GitHub" height="80">](https://github.com/fast4x/RiMusic/releases/latest)
[<img src="./assets/images/getItIzzyOnDroid.png" alt="IzzyOnDroid" height="80">](https://apt.izzysoft.de/fdroid/index/apk/it.fast4x.rimusic/)
[<img src="./assets/images/getItf-droid.png" alt="F-Droid" height="80">](https://f-droid.org/it/packages/it.fast4x.rimusic/)
[<img src="./assets/images/getItOpenapk.png" alt="OpenAPK" height="80">](https://www.openapk.net/rimusic/it.fast4x.rimusic/)
[<img src="./assets/images/getItAccrescent.png" alt="Accrescent" height="80">](https://accrescent.app/app/it.fast4x.rimusic)
[<img src="./assets/images/getItObtainium.png" alt="Obtainium" height="80">](https://apps.obtainium.imranr.dev/redirect?r=obtainium://app/%7B%22id%22%3A%22it.fast4x.rimusic%22%2C%22url%22%3A%22https%3A%2F%2Fgithub.com%2Ffast4x%2Frimusic%22%2C%22author%22%3A%22fast4x%22%2C%22name%22%3A%22RiMusic%22%2C%22preferredApkIndex%22%3A0%2C%22additionalSettings%22%3A%22%7B%5C%22includePrereleases%5C%22%3Afalse%2C%5C%22fallbackToOlderReleases%5C%22%3Atrue%2C%5C%22filterReleaseTitlesByRegEx%5C%22%3A%5C%22%5C%22%2C%5C%22filterReleaseNotesByRegEx%5C%22%3A%5C%22%5C%22%2C%5C%22verifyLatestTag%5C%22%3Afalse%2C%5C%22dontSortReleasesList%5C%22%3Afalse%2C%5C%22useLatestAssetDateAsReleaseDate%5C%22%3Afalse%2C%5C%22trackOnly%5C%22%3Afalse%2C%5C%22versionExtractionRegEx%5C%22%3A%5C%22%5C%22%2C%5C%22matchGroupToUse%5C%22%3A%5C%22%5C%22%2C%5C%22versionDetection%5C%22%3Atrue%2C%5C%22releaseDateAsVersion%5C%22%3Afalse%2C%5C%22useVersionCodeAsOSVersion%5C%22%3Afalse%2C%5C%22apkFilterRegEx%5C%22%3A%5C%22%5C%22%2C%5C%22invertAPKFilter%5C%22%3Afalse%2C%5C%22autoApkFilterByArch%5C%22%3Atrue%2C%5C%22appName%5C%22%3A%5C%22%5C%22%2C%5C%22shizukuPretendToBeGooglePlay%5C%22%3Afalse%2C%5C%22allowInsecure%5C%22%3Afalse%2C%5C%22exemptFromBackgroundUpdates%5C%22%3Afalse%2C%5C%22skipUpdateNotifications%5C%22%3Afalse%2C%5C%22about%5C%22%3A%5C%22RiMusic%20is%20a%20multilingual%20Android%20application%20for%20streaming%20music%20from%20YouTube%20Music.%20It%20began%20as%20an%20extension%20of%20ViMusic%2C%20then%20acquired%20its%20own%20identity.%20It%20allowing%20the%20user%20to%20customize%20it%20at%20will.%5C%22%7D%22%2C%22overrideSource%22%3Anull%7D)

## ❗ CUSTOM VERSION
WARNING, the custom version is not an official release, download only if invited by the developer!
[Go to custom version](https://github.com/fast4x/RiMusic/releases/tag/custom-version)

## ❓ FAQs
- See [Wiki page FAQs](https://github.com/fast4x/RiMusic/wiki/FAQs)
- [Group on Telegram ](https://t.me/rimusic_app)
- [Community on Reddit](https://www.reddit.com/r/RiMusicApp/)
- [Discord Server](https://discord.gg/y7NJwdwXEM) 

## 🤝 Contributing
**Pull requests are welcome**
- If you want:
    - to **develop new functions** or **fix a bug**, fork the repository and send a pull request.
    - to **translate** or **improve a translation** read the section Translations


### 🔤 Translations
- Go to [Crowdin](https://crowdin.com/project/rimusic/invite?h=73f0e6b64be1c64a8aebd467d286cf851925330) and help with the translations.

###  **Developer / Designer that contribute:**
- [25huizengek1](https://github.com/25huizengek1)
- [821938089](https://github.com/821938089)
- [aneesh1122](https://github.com/aneesh1122)
- [bbyeen](https://github.com/bbyeen)
- [Craeckie](https://github.com/Craeckie)
- [DanielSevillano](https://github.com/DanielSevillano)
- [fast4x](https://github.com/fast4x)
- [ikanakova](https://github.com/ikanakova)
- [iscle](https://github.com/iscle)
- [jaimtres](https://github.com/jaimtres)
- [JZITNIK](https://github.com/jzitnik-dev)
- [KyNarec](https://github.com/KyNarec)
- [knighthat](https://github.com/knighthat)
- [locxter](https://github.com/locxter)
- [lrusso96](https://github.com/lrusso96)
- [martkol](https://github.com/martkol)
- [ov1d1u ](https://github.com/ov1d1u)
- [roklc](https://github.com/roklc)
- [sharunkumar](https://github.com/sharunkumar/sharunkumar)
- [SuhasDissa](https://github.com/SuhasDissa)
- [twistios](https://github.com/twistios)


## 🫂 Acknowledgments
- [**ViMusic**](https://github.com/vfsfitvnm/ViMusic)
- **RiMusic actual Logo Design** [jaimtres](https://github.com/jaimtres)
- **RiMusic previous Logo and many actual icons** [@ikanakova](https://github.com/ikanakova)
- **RiMusic Website and other features** [JZITNIK-github](https://github.com/JZITNIK-github) and [martkol](https://github.com/martkol)
- **RiMusic New player and lyrics layouts** [aneesh1122](https://github.com/aneesh1122)
- [**YouTube-Internal-Clients**](https://github.com/zerodytrash/YouTube-Internal-Clients): A python script that discovers hidden YouTube API clients. Just a research project.
- [**Ionicons**](https://github.com/ionic-team/ionicons): Premium hand-crafted icons built by Ionic, for Ionic apps and web apps everywhere.
- [**Translator**](https://github.com/therealbush/translator): A simple and free Google Translate library for Kotlin/JVM and Java.
- [**KuGou**](https://www.kugou.com): Lyrics provider
- [**LrcLib**](https://lrclib.net): Lyrics provider


## ❗ Disclaimer
This project and its contents are not affiliated with, funded, authorized, endorsed by, or in any way associated with YouTube, Google LLC or any of its affiliates and subsidiaries.

Any trademark, service mark, trade name, or other intellectual property rights used in this project are owned by the respective owners.
