/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.commands;

import com.android.bundle.Commands;
import com.android.bundle.Config;
import com.android.bundle.Devices;
import com.android.tools.build.bundletool.archive.ArchivedApksGenerator;
import com.android.tools.build.bundletool.commands.BuildApksCommand;
import com.android.tools.build.bundletool.device.ApkMatcher;
import com.android.tools.build.bundletool.device.ModuleMatcher;
import com.android.tools.build.bundletool.io.ApkSerializerManager;
import com.android.tools.build.bundletool.io.ApkSetWriter;
import com.android.tools.build.bundletool.io.TempDirectory;
import com.android.tools.build.bundletool.mergers.BundleModuleMerger;
import com.android.tools.build.bundletool.model.AppBundle;
import com.android.tools.build.bundletool.model.BundleModule;
import com.android.tools.build.bundletool.model.BundleModuleName;
import com.android.tools.build.bundletool.model.GeneratedApks;
import com.android.tools.build.bundletool.model.GeneratedAssetSlices;
import com.android.tools.build.bundletool.model.ModuleDeliveryType;
import com.android.tools.build.bundletool.model.ModuleSplit;
import com.android.tools.build.bundletool.model.OptimizationDimension;
import com.android.tools.build.bundletool.model.ResourceId;
import com.android.tools.build.bundletool.model.VariantKey;
import com.android.tools.build.bundletool.model.exceptions.IncompatibleDeviceException;
import com.android.tools.build.bundletool.model.exceptions.InvalidCommandException;
import com.android.tools.build.bundletool.model.targeting.AlternativeVariantTargetingPopulator;
import com.android.tools.build.bundletool.model.utils.LocaleConfigXmlInjector;
import com.android.tools.build.bundletool.model.utils.ModuleDependenciesUtils;
import com.android.tools.build.bundletool.model.utils.SplitsXmlInjector;
import com.android.tools.build.bundletool.model.version.Version;
import com.android.tools.build.bundletool.model.version.VersionGuardedFeature;
import com.android.tools.build.bundletool.optimizations.ApkOptimizations;
import com.android.tools.build.bundletool.shards.ShardedApksFacade;
import com.android.tools.build.bundletool.splitters.ApkGenerationConfiguration;
import com.android.tools.build.bundletool.splitters.AssetSlicesGenerator;
import com.android.tools.build.bundletool.splitters.ResourceAnalyzer;
import com.android.tools.build.bundletool.splitters.SplitApksGenerator;
import com.android.tools.build.bundletool.validation.AppBundleValidator;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.common.io.MoreFiles;
import com.google.common.io.RecursiveDeleteOption;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Optional;
import java.util.stream.Stream;
import javax.inject.Inject;

public final class BuildApksManager {
    private final AppBundle appBundle;
    private final BuildApksCommand command;
    private final Version bundletoolVersion;
    private final Optional<Devices.DeviceSpec> deviceSpec;
    private final TempDirectory tempDir;
    private final ApkSerializerManager apkSerializerManager;
    private final SplitApksGenerator splitApksGenerator;
    private final ShardedApksFacade shardedApksFacade;
    private final ApkOptimizations apkOptimizations;
    private final ArchivedApksGenerator archivedApksGenerator;

    @Inject
    BuildApksManager(AppBundle appBundle, BuildApksCommand command, Version bundletoolVersion, Optional<Devices.DeviceSpec> deviceSpec, TempDirectory tempDir, ApkSerializerManager apkSerializerManager, SplitApksGenerator splitApksGenerator, ShardedApksFacade shardedApksFacade, ApkOptimizations apkOptimizations, ArchivedApksGenerator archivedApksGenerator) {
        this.appBundle = appBundle;
        this.command = command;
        this.bundletoolVersion = bundletoolVersion;
        this.deviceSpec = deviceSpec;
        this.tempDir = tempDir;
        this.splitApksGenerator = splitApksGenerator;
        this.apkSerializerManager = apkSerializerManager;
        this.shardedApksFacade = shardedApksFacade;
        this.apkOptimizations = apkOptimizations;
        this.archivedApksGenerator = archivedApksGenerator;
    }

    public void execute() throws IOException {
        ImmutableSet<BundleModuleName> permanentlyFusedModules = ImmutableSet.of();
        ImmutableSet<BundleModule> requestedModules = this.command.getModules().isEmpty() ? ImmutableSet.of() : ModuleDependenciesUtils.getModulesIncludingDependencies(this.appBundle, BuildApksManager.getBundleModules(this.appBundle, this.command.getModules()));
        GeneratedApks.Builder generatedApksBuilder = GeneratedApks.builder();
        GeneratedAssetSlices.Builder generatedAssetSlices = GeneratedAssetSlices.builder();
        boolean enableUniversalAsFallbackForSplits = false;
        boolean enableInstallTimeNonRemovableModules = false;
        ApksToGenerate apksToGenerate = new ApksToGenerate(this.appBundle, this.command.getApkBuildMode(), enableUniversalAsFallbackForSplits, this.deviceSpec);
        if (apksToGenerate.generateSplitApks()) {
            AppBundle mergedAppBundle = BundleModuleMerger.mergeNonRemovableInstallTimeModules(this.appBundle, enableInstallTimeNonRemovableModules);
            AppBundleValidator bundleValidator = AppBundleValidator.create(this.command.getExtraValidators());
            bundleValidator.validate(mergedAppBundle);
            generatedApksBuilder.setSplitApks(this.generateSplitApks(mergedAppBundle));
            permanentlyFusedModules = Sets.difference(this.appBundle.getModules().keySet(), mergedAppBundle.getModules().keySet()).immutableCopy();
        }
        if (apksToGenerate.generateInstantApks()) {
            generatedApksBuilder.setInstantApks(this.generateInstantApks(this.appBundle));
        }
        if (apksToGenerate.generateStandaloneApks()) {
            generatedApksBuilder.setStandaloneApks(this.generateStandaloneApks(this.appBundle));
        }
        if (apksToGenerate.generateUniversalApk()) {
            ImmutableList<BundleModule> modulesToFuse = requestedModules.isEmpty() ? this.modulesToFuse(BuildApksManager.getModulesForStandaloneApks(this.appBundle)) : requestedModules.asList();
            generatedApksBuilder.setStandaloneApks(this.shardedApksFacade.generateSplits(modulesToFuse, ApkOptimizations.getOptimizationsForUniversalApk()));
        }
        if (apksToGenerate.generateSystemApks()) {
            generatedApksBuilder.setSystemApks(this.generateSystemApks(this.appBundle, requestedModules));
        }
        if (apksToGenerate.generateArchivedApks()) {
            generatedApksBuilder.setArchivedApks(this.generateArchivedApks(this.appBundle));
        }
        if (apksToGenerate.generateAssetSlices()) {
            generatedAssetSlices.setAssetSlices(this.generateAssetSlices(this.appBundle));
        }
        GeneratedApks generatedApks = AlternativeVariantTargetingPopulator.populateAlternativeVariantTargeting(generatedApksBuilder.build(), this.appBundle.isAssetOnly() ? Optional.empty() : this.appBundle.getBaseModule().getAndroidManifest().getMaxSdkVersion());
        generatedApks = GeneratedApks.fromModuleSplits(((ImmutableMap)generatedApks.getAllApksGroupedByOrderedVariants().asMap()).entrySet().stream().map(keySplit -> {
            SplitsXmlInjector splitsXmlInjector = new SplitsXmlInjector();
            ImmutableList<ModuleSplit> moduleSplits = splitsXmlInjector.process((VariantKey)keySplit.getKey(), (Collection)keySplit.getValue());
            if (this.appBundle.injectLocaleConfig()) {
                LocaleConfigXmlInjector localeConfigXmlInjector = new LocaleConfigXmlInjector();
                moduleSplits = localeConfigXmlInjector.process((VariantKey)keySplit.getKey(), moduleSplits);
            }
            return moduleSplits;
        }).flatMap(Collection::stream).collect(ImmutableList.toImmutableList()));
        if (this.deviceSpec.isPresent()) {
            BuildApksManager.checkDeviceCompatibilityWithBundle(generatedApks, this.deviceSpec.get());
        }
        if (this.command.getOverwriteOutput() && Files.exists(this.command.getOutputFile(), new LinkOption[0])) {
            MoreFiles.deleteRecursively(this.command.getOutputFile(), RecursiveDeleteOption.ALLOW_INSECURE);
        }
        this.apkSerializerManager.serializeApkSet(this.createApkSetWriter(this.tempDir.getPath()), generatedApks, generatedAssetSlices.build(), this.deviceSpec, BuildApksManager.getLocalTestingInfo(this.appBundle), permanentlyFusedModules);
    }

    private ImmutableList<ModuleSplit> generateStandaloneApks(AppBundle appBundle) {
        ImmutableList<BundleModule> allModules = BuildApksManager.getModulesForStandaloneApks(appBundle);
        return appBundle.isApex() ? this.shardedApksFacade.generateApexSplits(this.modulesToFuse(allModules)) : this.shardedApksFacade.generateSplits(this.modulesToFuse(allModules), this.apkOptimizations);
    }

    private ImmutableList<ModuleSplit> generateAssetSlices(AppBundle appBundle) {
        ApkGenerationConfiguration assetSlicesGenerationConfiguration = this.getAssetSliceGenerationConfiguration();
        AssetSlicesGenerator assetSlicesGenerator = new AssetSlicesGenerator(appBundle, assetSlicesGenerationConfiguration, this.command.getAssetModulesVersionOverride());
        return assetSlicesGenerator.generateAssetSlices();
    }

    private ImmutableList<ModuleSplit> generateInstantApks(AppBundle appBundle) {
        ImmutableList allFeatureModules = ((ImmutableCollection)appBundle.getFeatureModules().values()).asList();
        ImmutableList<BundleModule> instantModules = allFeatureModules.stream().filter(BundleModule::isInstantModule).collect(ImmutableList.toImmutableList());
        ApkGenerationConfiguration instantApkGenerationConfiguration = this.getCommonSplitApkGenerationConfiguration(appBundle).setForInstantAppVariants(true).setEnableDexCompressionSplitter(false).build();
        return this.splitApksGenerator.generateSplits(instantModules, instantApkGenerationConfiguration);
    }

    private ImmutableList<ModuleSplit> generateSplitApks(AppBundle appBundle) throws IOException {
        ApkGenerationConfiguration.Builder apkGenerationConfiguration = this.getCommonSplitApkGenerationConfiguration(appBundle);
        if (VersionGuardedFeature.RESOURCES_REFERENCED_IN_MANIFEST_TO_MASTER_SPLIT.enabledForVersion(this.bundletoolVersion)) {
            apkGenerationConfiguration.setBaseManifestReachableResources(new ResourceAnalyzer(appBundle).findAllAppResourcesReachableFromBaseManifest());
        }
        ImmutableList<BundleModule> featureModules = ((ImmutableCollection)appBundle.getFeatureModules().values()).asList();
        return this.splitApksGenerator.generateSplits(featureModules, apkGenerationConfiguration.build());
    }

    private ImmutableList<ModuleSplit> generateSystemApks(AppBundle appBundle, ImmutableSet<BundleModule> requestedModules) {
        ImmutableList<BundleModule> featureModules = ((ImmutableCollection)appBundle.getFeatureModules().values()).asList();
        ImmutableList<Object> modulesToFuse = requestedModules.isEmpty() ? this.modulesToFuse(featureModules) : requestedModules.asList();
        return this.shardedApksFacade.generateSystemSplits(featureModules, modulesToFuse.stream().map(BundleModule::getName).collect(ImmutableSet.toImmutableSet()), this.getSystemApkOptimizations());
    }

    private ImmutableList<ModuleSplit> generateArchivedApks(AppBundle appBundle) throws IOException {
        return ImmutableList.of(this.archivedApksGenerator.generateArchivedApk(appBundle, this.command.getAppStorePackageName()));
    }

    private static void checkDeviceCompatibilityWithBundle(GeneratedApks generatedApks, Devices.DeviceSpec deviceSpec) {
        ApkMatcher apkMatcher = new ApkMatcher(deviceSpec);
        generatedApks.getAllApksStream().forEach(apkMatcher::checkCompatibleWithApkTargeting);
    }

    private ApkSetWriter createApkSetWriter(Path tempDir) {
        switch (this.command.getOutputFormat()) {
            case APK_SET: {
                return ApkSetWriter.zip(tempDir, this.command.getOutputFile());
            }
            case DIRECTORY: {
                return ApkSetWriter.directory(this.command.getOutputFile());
            }
        }
        throw InvalidCommandException.builder().withInternalMessage("Unsupported output format '%s'.", new Object[]{this.command.getOutputFormat()}).build();
    }

    private ApkGenerationConfiguration.Builder getCommonSplitApkGenerationConfiguration(AppBundle appBundle) {
        Config.BundleConfig bundleConfig = appBundle.getBundleConfig();
        Version bundleToolVersion = Version.of(bundleConfig.getBundletool().getVersion());
        ApkGenerationConfiguration.Builder apkGenerationConfiguration = ApkGenerationConfiguration.builder().setOptimizationDimensions(this.apkOptimizations.getSplitDimensions());
        apkGenerationConfiguration.setEnableUncompressedNativeLibraries(this.apkOptimizations.getUncompressNativeLibraries());
        this.setEnableUncompressedDexOptimization(appBundle, apkGenerationConfiguration);
        apkGenerationConfiguration.setEnableSparseEncodingVariant(bundleConfig.getOptimizations().getResourceOptimizations().getSparseEncoding().equals(Config.ResourceOptimizations.SparseEncoding.VARIANT_FOR_SDK_32));
        apkGenerationConfiguration.setInstallableOnExternalStorage(appBundle.getBaseModule().getAndroidManifest().getInstallLocationValue().map(installLocation -> installLocation.equals("auto") || installLocation.equals("preferExternal")).orElse(false));
        apkGenerationConfiguration.setMasterPinnedResourceIds(bundleConfig.getMasterResources().getResourceIdsList().stream().map(ResourceId::create).collect(ImmutableSet.toImmutableSet()));
        apkGenerationConfiguration.setMasterPinnedResourceNames(ImmutableSet.copyOf(bundleConfig.getMasterResources().getResourceNamesList()));
        apkGenerationConfiguration.setSuffixStrippings(this.apkOptimizations.getSuffixStrippings());
        apkGenerationConfiguration.setEnableBaseModuleMinSdkAsDefaultTargeting(this.command.getEnableBaseModuleMinSdkAsDefaultTargeting());
        this.command.getMinSdkForAdditionalVariantWithV3Rotation().ifPresent(apkGenerationConfiguration::setMinSdkForAdditionalVariantWithV3Rotation);
        return apkGenerationConfiguration;
    }

    private void setEnableUncompressedDexOptimization(AppBundle appBundle, ApkGenerationConfiguration.Builder builder) {
        if (appBundle.getUncompressedDexOptOut()) {
            builder.setEnableDexCompressionSplitter(false);
            return;
        }
        builder.setEnableDexCompressionSplitter(this.apkOptimizations.getUncompressDexFiles());
        builder.setDexCompressionSplitterForTargetSdk(this.apkOptimizations.getUncompressedDexTargetSdk());
    }

    private ApkGenerationConfiguration getAssetSliceGenerationConfiguration() {
        return ApkGenerationConfiguration.builder().setEnableBaseModuleMinSdkAsDefaultTargeting(this.command.getEnableBaseModuleMinSdkAsDefaultTargeting()).setOptimizationDimensions(this.apkOptimizations.getSplitDimensionsForAssetModules()).setSuffixStrippings(this.apkOptimizations.getSuffixStrippings()).build();
    }

    private ImmutableList<BundleModule> modulesToFuse(ImmutableList<BundleModule> modules) {
        if (this.appBundle.getBundleConfig().getOptimizations().getStandaloneConfig().getFeatureModulesMode().equals(Config.StandaloneConfig.FeatureModulesMode.SEPARATE_FEATURE_MODULES)) {
            return modules;
        }
        return modules.stream().filter(BundleModule::isIncludedInFusing).filter(module -> !this.command.getFuseOnlyDeviceMatchingModules() || this.matchModuleToDevice((BundleModule)module)).collect(ImmutableList.toImmutableList());
    }

    private boolean matchModuleToDevice(BundleModule module) {
        if (!this.deviceSpec.isPresent()) {
            return false;
        }
        return new ModuleMatcher(this.deviceSpec.get()).matchesModuleTargeting(module.getModuleMetadata().getTargeting());
    }

    private ApkOptimizations getSystemApkOptimizations() {
        ImmutableSet<BuildApksCommand.SystemApkOption> systemApkOptions = this.command.getSystemApkOptions();
        ApkOptimizations.Builder apkOptimizationsBuilder = this.apkOptimizations.toBuilder();
        Preconditions.checkArgument(this.deviceSpec.isPresent(), "Must specify a device spec in system mode");
        if (this.deviceSpec.get().getScreenDensity() == 0) {
            apkOptimizationsBuilder.setSplitDimensions(Sets.difference(this.apkOptimizations.getSplitDimensions(), ImmutableSet.of(OptimizationDimension.SCREEN_DENSITY)).immutableCopy());
        }
        return apkOptimizationsBuilder.setUncompressNativeLibraries(systemApkOptions.contains((Object)BuildApksCommand.SystemApkOption.UNCOMPRESSED_NATIVE_LIBRARIES)).setUncompressDexFiles(systemApkOptions.contains((Object)BuildApksCommand.SystemApkOption.UNCOMPRESSED_DEX_FILES)).build();
    }

    private static boolean targetsOnlyPreL(AppBundle bundle) {
        Optional<Integer> maxSdkVersion = bundle.getBaseModule().getAndroidManifest().getMaxSdkVersion();
        return maxSdkVersion.isPresent() && maxSdkVersion.get() < 21;
    }

    private static boolean targetsPreL(AppBundle bundle) {
        int baseMinSdkVersion = bundle.getBaseModule().getAndroidManifest().getEffectiveMinSdkVersion();
        return baseMinSdkVersion < 21;
    }

    private static ImmutableList<BundleModule> getBundleModules(AppBundle appBundle, ImmutableSet<String> moduleNames) {
        if (moduleNames.contains("_ALL_")) {
            return ((ImmutableCollection)appBundle.getModules().values()).asList();
        }
        return moduleNames.stream().map(BundleModuleName::create).map(appBundle::getModule).collect(ImmutableList.toImmutableList());
    }

    private static ImmutableList<BundleModule> getModulesForStandaloneApks(AppBundle appBundle) {
        return Stream.concat(appBundle.getFeatureModules().values().stream(), appBundle.getAssetModules().values().stream().filter(module -> module.getDeliveryType().equals((Object)ModuleDeliveryType.ALWAYS_INITIAL_INSTALL))).collect(ImmutableList.toImmutableList());
    }

    private static Commands.LocalTestingInfo getLocalTestingInfo(AppBundle bundle) {
        Commands.LocalTestingInfo.Builder localTestingInfo = Commands.LocalTestingInfo.newBuilder();
        if (bundle.isAssetOnly()) {
            return localTestingInfo.setEnabled(false).build();
        }
        bundle.getBaseModule().getAndroidManifest().getMetadataValue("local_testing_dir").ifPresent(localTestingPath -> localTestingInfo.setEnabled(true).setLocalTestingPath((String)localTestingPath));
        return localTestingInfo.build();
    }

    private static class ApksToGenerate {
        private final AppBundle appBundle;
        private final BuildApksCommand.ApkBuildMode apkBuildMode;
        private final boolean enableUniversalAsFallbackForSplits;
        private final Optional<Devices.DeviceSpec> deviceSpec;

        private ApksToGenerate(AppBundle appBundle, BuildApksCommand.ApkBuildMode apkBuildMode, boolean enableUniversalAsFallbackForSplits, Optional<Devices.DeviceSpec> deviceSpec) {
            this.appBundle = appBundle;
            this.apkBuildMode = apkBuildMode;
            this.enableUniversalAsFallbackForSplits = enableUniversalAsFallbackForSplits;
            this.deviceSpec = deviceSpec;
            this.validate();
        }

        private void validate() {
            boolean generatesAtLeastOneApk;
            if (this.appBundle.isApex() && this.apkBuildMode.equals((Object)BuildApksCommand.ApkBuildMode.UNIVERSAL)) {
                throw InvalidCommandException.builder().withInternalMessage("APEX bundles do not support universal apks.").build();
            }
            if (this.deviceSpec.isPresent()) {
                int deviceSdk = this.deviceSpec.get().getSdkVersion();
                Optional<Integer> appMaxSdk = this.appBundle.getBaseModule().getAndroidManifest().getMaxSdkVersion();
                if (this.apkBuildMode.equals((Object)BuildApksCommand.ApkBuildMode.DEFAULT) || this.apkBuildMode.equals((Object)BuildApksCommand.ApkBuildMode.PERSISTENT)) {
                    if (deviceSdk >= 21) {
                        if (!this.generateSplitApks()) {
                            throw IncompatibleDeviceException.builder().withUserMessage("App Bundle targets pre-L devices, but the device has SDK version higher or equal to L.").build();
                        }
                    } else if (!this.generateStandaloneApks()) {
                        throw IncompatibleDeviceException.builder().withUserMessage("App Bundle targets L+ devices, but the device has SDK version lower than L.").build();
                    }
                }
                if (appMaxSdk.isPresent() && deviceSdk > appMaxSdk.get()) {
                    throw IncompatibleDeviceException.builder().withUserMessage("Max SDK version of the App Bundle is lower than SDK version of the device").build();
                }
            }
            boolean bl2 = generatesAtLeastOneApk = this.generateStandaloneApks() || this.generateSplitApks() || this.generateInstantApks() || this.generateUniversalApk() || this.generateSystemApks() || this.generateArchivedApks() || this.generateAssetSlices();
            if (!generatesAtLeastOneApk) {
                throw InvalidCommandException.builder().withInternalMessage("No APKs to generate.").build();
            }
        }

        public boolean generateSplitApks() {
            if (this.appBundle.isApex()) {
                return false;
            }
            if (this.appBundle.isAssetOnly()) {
                return false;
            }
            if (!this.apkBuildMode.equals((Object)BuildApksCommand.ApkBuildMode.DEFAULT) && !this.apkBuildMode.equals((Object)BuildApksCommand.ApkBuildMode.PERSISTENT)) {
                return false;
            }
            return !BuildApksManager.targetsOnlyPreL(this.appBundle) && this.deviceSpec.map(spec -> spec.getSdkVersion() >= 21).orElse(true) != false;
        }

        public boolean generateStandaloneApks() {
            if (!this.apkBuildMode.equals((Object)BuildApksCommand.ApkBuildMode.DEFAULT) && !this.apkBuildMode.equals((Object)BuildApksCommand.ApkBuildMode.PERSISTENT)) {
                return false;
            }
            if (this.appBundle.isAssetOnly()) {
                return false;
            }
            if (this.appBundle.isApex()) {
                return true;
            }
            return BuildApksManager.targetsPreL(this.appBundle) && this.deviceSpec.map(spec -> spec.getSdkVersion() < 21).orElse(true) != false;
        }

        public boolean generateInstantApks() {
            if (this.appBundle.isApex()) {
                return false;
            }
            if (this.appBundle.isAssetOnly()) {
                return false;
            }
            return this.apkBuildMode.equals((Object)BuildApksCommand.ApkBuildMode.DEFAULT) || this.apkBuildMode.equals((Object)BuildApksCommand.ApkBuildMode.INSTANT);
        }

        public boolean generateUniversalApk() {
            if (this.appBundle.isApex()) {
                return false;
            }
            if (this.appBundle.isAssetOnly()) {
                return false;
            }
            boolean shouldGenerateAsFallback = this.enableUniversalAsFallbackForSplits && this.generateSplitApks() && !this.generateStandaloneApks();
            return this.apkBuildMode.equals((Object)BuildApksCommand.ApkBuildMode.UNIVERSAL) || shouldGenerateAsFallback;
        }

        public boolean generateSystemApks() {
            if (this.appBundle.isApex()) {
                return false;
            }
            if (this.appBundle.isAssetOnly()) {
                return false;
            }
            return this.apkBuildMode.equals((Object)BuildApksCommand.ApkBuildMode.SYSTEM);
        }

        public boolean generateArchivedApks() {
            if (this.appBundle.isApex() || this.appBundle.isAssetOnly()) {
                return false;
            }
            return this.apkBuildMode.equals((Object)BuildApksCommand.ApkBuildMode.ARCHIVE);
        }

        public boolean generateAssetSlices() {
            if (this.appBundle.isApex()) {
                return false;
            }
            return this.appBundle.isAssetOnly() || this.apkBuildMode.equals((Object)BuildApksCommand.ApkBuildMode.DEFAULT) || this.apkBuildMode.equals((Object)BuildApksCommand.ApkBuildMode.INSTANT) || this.apkBuildMode.equals((Object)BuildApksCommand.ApkBuildMode.PERSISTENT);
        }
    }
}

