## Publications using SpikingJelly

| Papers                                                       | Codes                                                        | Publisher                                                    |
| ------------------------------------------------------------ | ------------------------------------------------------------ | ------------------------------------------------------------ |
| [Incorporating Learnable Membrane Time Constant to Enhance Learning of Spiking Neural Networks](https://arxiv.org/abs/2007.05785) | https://github.com/fangwei123456/Parametric-Leaky-Integrate-and-Fire-Spiking-Neuron | ICCV 2021                                                    |
| [Pruning of Deep Spiking Neural Networks through Gradient Rewiring](https://arxiv.org/abs/2105.04916) | https://github.com/Yanqi-Chen/Gradient-Rewiring              | IJCAI 2021                                                   |
| [Optimal ANN-SNN Conversion for Fast and Accurate Inference in Deep Spiking Neural Networks](https://arxiv.org/abs/2105.11654) | https://github.com/DingJianhao/OptSNNConvertion-RNL-RIL      | IJCAI 2021                                                   |
| [Deep Residual Learning in Spiking Neural Networks](https://arxiv.org/abs/2102.04159) | https://github.com/fangwei123456/Spike-Element-Wise-ResNet   | NeurIPS 2021                                                 |
| [Spiking Neural Networks Trained via Proxy](https://arxiv.org/abs/2109.13208) | https://github.com/SRKH/ProxyLearning                        | IEEE Access                                                  |
| [StereoSpike: Depth Learning with a Spiking Neural Network](https://arxiv.org/abs/2109.13751) | https://github.com/urancon/StereoSpike                       | IEEE Access                                                  |
| [An Odor Recognition Algorithm of Electronic Noses Based on Convolutional Spiking Neural Network for Spoiled Food Identification](https://iopscience.iop.org/article/10.1149/1945-7111/ac1699/meta) |                                                              | Journal of The Electrochemical Society                       |
| [Cascade Spiking Neuron Network For Event-based Image Classification In Noisy Environment](https://www.techrxiv.org/articles/preprint/Cascade_Spiking_Neuron_Network_For_Event-based_Image_Classification_In_Noisy_Environment/16571043) |                                                              |                                                              |
| [Keys to Accurate Feature Extraction Using Residual Spiking Neural Networks](https://iopscience.iop.org/article/10.1088/2634-4386/ac8bef/meta) | https://github.com/VicenteAlex/Spiking_ResNet                | Neuromorphic Computing and Engineering                       |
| [Human-Level Control through Directly-Trained Deep Spiking Q-Networks](https://arxiv.org/abs/2201.07211) | https://github.com/AptX395/Deep-Spiking-Q-Networks           | IEEE Transactions on Cybernetics                             |
| [Deep Reinforcement Learning with Spiking Q-learning](https://arxiv.org/abs/2201.09754) |                                                              |                                                              |
| [Event-based Video Reconstruction via Potential-assisted Spiking Neural Network](https://arxiv.org/abs/2201.10943) | https://github.com/LinZhu111/EVSNN                           | CVPR 2022                                                    |
| [Optimal ANN-SNN Conversion for High-accuracy and Ultra-low-latency Spiking Neural Networks](https://openreview.net/forum?id=7B3IJMM1k_M) | https://github.com/putshua/SNN-conversion-QCFS               | ICLR 2022                                                    |
| [Optimized Potential Initialization for Low-latency Spiking Neural Networks](https://arxiv.org/abs/2202.01440) |                                                              | AAAI 2022                                                    |
| [AutoSNN: Towards Energy-Efficient Spiking Neural Networks](https://arxiv.org/abs/2201.12738) |                                                              | ICML 2022                                                    |
| [Neural Architecture Search for Spiking Neural Networks](https://arxiv.org/abs/2201.10355) | https://github.com/Intelligent-Computing-Lab-Yale/Neural-Architecture-Search-for-Spiking-Neural-Networks | ECCV 2022                                                    |
| [FEAS: A Faster Event-driven Accelerator Supporting Inhibitory Spiking Neural Network](https://ieeexplore.ieee.org/document/9720483/) |                                                              | International Symposium on Parallel Architectures, Algorithms and Programming (PAAP) 2021 |
| [Neuromorphic Data Augmentation for Training Spiking Neural Networks](https://arxiv.org/abs/2203.06145) | https://github.com/Intelligent-Computing-Lab-Yale/NDA_SNN    | ECCV 2022                                                    |
| [SIT: A Bionic and Non-Linear Neuron for Spiking Neural Network](https://arxiv.org/abs/2203.16117) |                                                              |                                                              |
| [Building and training a deep spiking neural network for ECG classification](https://www.sciencedirect.com/science/article/pii/S1746809422002713) |                                                              | Biomedical Signal Processing and Control                     |
| [DynSNN: A Dynamic Approach to Reduce Redundancy in Spiking Neural Networks](https://ieeexplore.ieee.org/abstract/document/9746566) |                                                              | ICASSP 2022                                                  |
| [Object Detection with Spiking Neural Networks on Automotive Event Data](https://arxiv.org/abs/2205.04339) |                                                              | IJCNN 2022                                                   |
| [State Transition of Dendritic Spines Improves Learning of Sparse Spiking Neural Networks](https://proceedings.mlr.press/v162/chen22ac.html) | https://github.com/Yanqi-Chen/STDS                           | ICML 2022                                                    |
| [Training High-Performance Low-Latency Spiking Neural Networks by Differentiation on Spike Representation](https://arxiv.org/abs/2205.00459) | https://github.com/qymeng94/DSR                              | CVPR 2022                                                    |
| [Relaxation LIF: A gradient-based spiking neuron for direct training deep spiking neural networks](https://www.sciencedirect.com/science/article/pii/S092523122200755X) |                                                              | Neurocomputing                                               |
| [SNN2ANN: A Fast and Memory-Efficient Training Framework for Spiking Neural Networks](https://arxiv.org/abs/2206.09449) | https://github.com/TJXTT/SNN2ANN                             |                                                              |
| [Spiking Neural Networks for Frame-based and Event-based Single Object Localization](https://arxiv.org/abs/2206.06506) |                                                              |                                                              |
| [TCJA-SNN: Temporal-Channel Joint Attention for Spiking Neural Networks](https://arxiv.org/abs/2206.10177) | https://github.com/ridgerchu/TCJA                            |                                                    	IEEE Transactions on Neural Networks and Learning Systems          |
| [Exploring Lottery Ticket Hypothesis in Spiking Neural Networks](https://arxiv.org/abs/2207.01382) | https://github.com/Intelligent-Computing-Lab-Yale/Exploring-Lottery-Ticket-Hypothesis-in-SNNs | ECCV 2022                                                    |
| [Spiking Graph Convolutional Networks](https://arxiv.org/abs/2205.02767) | https://github.com/ZulunZhu/SpikingGCN                       | IJCAI 2022                                                   |
| [Spiking VGG7: Deep Convolutional Spiking Neural Network with Direct Training for Object Recognition](https://www.mdpi.com/2079-9292/11/13/2097) |                                                              | Electronics                                                  |
| [Spiking Neural Network Based on Layer-Wise Compensation for Event-Stream Image Classification](https://link.springer.com/chapter/10.1007/978-981-19-3927-3_72) |                                                              | International Technical Conference on Advances in Computing, Control and Industrial Engineering (CCIE 2021) |
| [A calibratable sensory neuron based on epitaxial VO2 for spike-based neuromorphic multisensory system](https://www.nature.com/articles/s41467-022-31747-w) | https://github.com/billyuanpku96/SNN-for-sensory-neuron      | Nature Communications                                        |
| [A model of TaOx threshold switching memristor for neuromorphic computing](https://aip.scitation.org/doi/full/10.1063/5.0096643) |                                                              | Journal of Applied Physics                                   |
| [Label Distribution Learning via Implicit Distribution Representation](https://arxiv.org/abs/2209.13824) |                                                              |                                                              |
| [Spiking SiamFC++: Deep Spiking Neural Network for Object Tracking](https://arxiv.org/abs/2209.12010) |                                                              |                                                              |
| [Spikformer: When Spiking Neural Network Meets Transformer](https://openreview.net/forum?id=frE4fUwz_h) | https://github.com/ZK-Zhou/spikformer                        | ICLR 2023                                                    |
| [SNN-SC: A Spiking Semantic Communication Framework for Classification](https://arxiv.org/abs/2210.06836) |                                                              |                                                              |
| [STSC-SNN: Spatio-Temporal Synaptic Connection with Temporal Convolution and Attention for Spiking Neural Networks](https://arxiv.org/abs/2210.05241) |                                                              |                                                              |
| [Online Training Through Time for Spiking Neural Networks](https://arxiv.org/abs/2210.04195) | https://github.com/pkuxmq/OTTT-SNN                           | NeurIPS 2022                                                 |
| [Training Spiking Neural Networks with Event-driven Backpropagation](https://openreview.net/forum?id=nC8VC8gVGPo) | https://github.com/zhuyaoyu/SNN-event-driven-learning        | NeurIPS 2022                                                 |
| [GLIF: A Unified Gated Leaky Integrate-and-Fire Neuron for Spiking Neural Networks](https://openreview.net/forum?id=UmFSx2c4ubT) | https://github.com/Ikarosy/Gated-LIF                         | NeurIPS 2022                                                 |
| [Temporal Effective Batch Normalization in Spiking Neural Networks](https://openreview.net/forum?id=fLIgyyQiJqz) | https://openreview.net/attachment?id=fLIgyyQiJqz&name=supplementary_material | NeurIPS 2022                                                 |
| [Attention Spiking Neural Networks](https://ieeexplore.ieee.org/document/10032591) | https://github.com/fangwei123456/spikingjelly/pull/329       | IEEE Transactions on Pattern Analysis and Machine Intelligence |
| [Training Full Spike Neural Networks via Auxiliary Accumulation Pathway](https://arxiv.org/abs/2301.11929) |                                                              |                                                              |
| [Bridging the Gap between ANNs and SNNs by Calibrating Offset Spikes](https://openreview.net/forum?id=PFbzoWZyZRX) | https://github.com/hzc1208/ANN2SNN_COS                       | ICLR 2023                                                    |
| [A Unified Framework of Soft Threshold Pruning](https://openreview.net/forum?id=cCFqcrq0d8) |                                                              | ICLR 2023                                                    |
| [Reducing ANN-SNN Conversion Error through Residual Membrane Potential](https://arxiv.org/abs/2302.02091) | https://github.com/hzc1208/ANN2SNN_SRP                       | AAAI 2023                                                    |
| [MSS-DepthNet: Depth Prediction with Multi-Step Spiking Neural Network](https://arxiv.org/abs/2211.12156) |                                                              |                                                              |
| [An Analytical Estimation of Spiking Neural Networks Energy Efficiency](https://arxiv.org/abs/2210.13107) |                                                              | ICONIP 2022                                                  |
| [Spikeformer: A Novel Architecture for Training High-Performance Low-Latency Spiking Neural Network](https://arxiv.org/abs/2211.10686) |                                                              |                                                              |
| [A Low Latency Adaptive Coding Spiking Framework for Deep Reinforcement Learning](https://arxiv.org/abs/2211.11760) |                                                              |                                                              |
| [Skin Cancer Classification Using Deep Spiking Neural Network](https://link.springer.com/article/10.1007/s10278-023-00776-2) |                                                              | Journal of Digital Imaging                                   |
| [Entrenamiento supervisado de redes neuronales de impulsos](https://ruc.udc.es/dspace/handle/2183/31382) |                                                              | XLIII Jornadas de Automática                                 |
| [Spiking Neuron Network Based on VTEAM Memristor and MOSFET-LIF Neuron](https://link.springer.com/chapter/10.1007/978-3-031-14903-0_5) |                                                              | International Federation for Information Processing 2022     |
| [Spiking Emotions: Dynamic Vision Emotion Recognition Using Spiking Neural Networks](https://ceur-ws.org/Vol-3331/paper08.pdf) |                                                              | International Conference on Algorithms, High Performance Computing and Artificial Intelligence 2022 |
| [Bio-inspired Active Learning method in spiking neural network](https://www.sciencedirect.com/science/article/pii/S0950705122012898) |                                                              | Knowledge-Based Systems                                      |
| [Deep Spiking Residual Shrinkage Network for Bearing Fault Diagnosis](https://ieeexplore.ieee.org/abstract/document/9994622) |                                                              | IEEE Transactions on Cybernetics                             |
| [Control and regulation of skyrmionic topological charge in a novel synthetic antiferromagnetic nanostructure](https://pubs.rsc.org/en/content/articlelanding/2023/nr/d2nr06498g) |                                                              | Nanoscale                                                    |
| [Accurate ECG Classification Based on Spiking Neural Network and Attentional Mechanism for Real-Time Implementation on Personal Portable Devices](https://www.mdpi.com/2079-9292/11/12/1889) |                                                              | Electronics                                                  |
| [Dynamic Threshold Integrate and Fire Neuron Model for Low Latency Spiking Neural Networks](https://papers.ssrn.com/sol3/papers.cfm?abstract_id=4179879) |                                                              | Neurocomputing                                               |
| [Neuromorphic-P2M: Processing-in-Pixel-in-Memory Paradigm for Neuromorphic Image Sensors](https://arxiv.org/abs/2301.09111) |                                                              | Frontiers in Neuroinformatics                                |
| [Bioinspired membrane learnable spiking neural network for autonomous vehicle sensors fault diagnosis under open environments](https://www.sciencedirect.com/science/article/pii/S0951832023000170) |                                                              | Reliability Engineering & System Safety                      |
| [Surrogate-Assisted Cooperative Co-evolutionary Reservoir Architecture Search for Liquid State Machines](https://ieeexplore.ieee.org/abstract/document/10005101) |                                                              | IEEE Transactions on Emerging Topics in Computational Intelligence |
| [Supervised Learning Algorithm Based on Spike Train Inner Product for Deep Spiking Neural Networks](https://www.mdpi.com/2076-3425/13/2/168) |                                                              | Brain Sciences                                               |
| [Mitigating Catastrophic Forgetting in Spiking Neural Networks through Threshold Modulation](https://openreview.net/forum?id=15SoThZmtU) | https://github.com/Thvnvtos/Nm-SNN                           | Transactions on Machine Learning Research                    |
| [Optical Flow estimation with Event-based Cameras and Spiking Neural Networks](https://arxiv.org/abs/2302.06492) | https://github.com/J-Cuadrado/OF_EV_SNN                      | Frontiers in Neuroscience                                    |
| [Poster: Backdoor Attacks on Spiking NNs and Neuromorphic Datasets](https://dl.acm.org/doi/10.1145/3548606.3563532) | https://github.com/GorkaAbad/NeuromorphicBackdoors           | CCS 2022                                                     |
| [Sneaky Spikes: Uncovering Stealthy Backdoor Attacks in Spiking Neural Networks with Neuromorphic Data](https://arxiv.org/abs/2302.06279) | https://github.com/GorkaAbad/Sneaky-Spikes                   | NDSS 2024                                                    |
| [SpikeGPT: Generative Pre-trained Language Model with Spiking Neural Networks](https://arxiv.org/abs/2302.13939) | https://github.com/ridgerchu/SpikeGPT                        |                                                              |
| [Trainable quantization for Speedy Spiking Neural Networks](https://www.frontiersin.org/articles/10.3389/fnins.2023.1154241/full) |                                                              | Frontiers in Neuroscience                                    |
| [Training-aware Low Precision Quantization in Spiking Neural Networks](https://ieeexplore.ieee.org/abstract/document/10051957) |                                                              | Asilomar Conference on Signals, Systems & Computers 2022     |
| [Towards Memory- and Time-Efficient Backpropagation for Training Spiking Neural Networks](https://arxiv.org/abs/2302.14311) | https://github.com/qymeng94/SLTT                             | ICCV 2023                                                    |
| [Biologically inspired structure learning with reverse knowledge distillation for spiking neural networks](https://arxiv.org/abs/2304.09500) |                                                              |                                                              |
| [Detecting COVID-19 on CT Images with Impulsive-Backpropagation Neural Networks](https://ieeexplore.ieee.org/abstract/document/10033991) |                                                              | Chinese Control and Decision Conference, CCDC 2022           |
| [Rethinking Deep Spiking Neural Networks: A Multi-Layer Perceptron Approach](https://openreview.net/forum?id=-1x2-lp1eZf) |                                                              |                                                              |
| [Deep Spiking Neural Networks with High Representation Similarity Model Visual Pathways of Macaque and Mouse](https://arxiv.org/abs/2303.06060) |                                                              | AAAI 2023                                                    |
| [A Hybrid ANN-SNN Architecture for Low-Power and Low-Latency Visual Perception](https://arxiv.org/abs/2303.14176) |                                                              |                                                              |
| [Constrain Bias Addition to Train Low-Latency Spiking Neural Networks](https://www.mdpi.com/2076-3425/13/2/319) |                                                              | Brain Sciences                                               |
| [Event-based Human Pose Tracking by Spiking Spatiotemporal Transformer](https://arxiv.org/abs/2303.09681) | https://github.com/JimmyZou/HumanPoseTracking_SNN            |                                                              |
| [Constructing Deep Spiking Neural Networks from Artificial Neural Networks with Knowledge Distillation](https://arxiv.org/abs/2304.05627) |                                                              | CVPR 2023                                                    |
| [Spiking-Fer: Spiking Neural Network for Facial Expression Recognition With Event Cameras](https://arxiv.org/abs/2304.10211) |                                                              | International Conference on Content-based Multimedia Indexing, 2023 |
| [Parallel Spiking Neurons with High Efficiency and Ability to Learn Long-term Dependencies](https://arxiv.org/abs/2304.12760) | https://github.com/fangwei123456/Parallel-Spiking-Neuron     | NeurIPS 2023                                                 |
| [Spikingformer: Spike-driven Residual Learning for Transformer-based Spiking Neural Network](https://arxiv.org/abs/2304.11954) | https://github.com/zhouchenlin2096/Spikingformer             |                                                              |
| [Enhancing the Performance of Transformer-based Spiking Neural Networks by Improved Downsampling with Precise Gradient Backpropagation](https://arxiv.org/abs/2305.05954) | https://github.com/zhouchenlin2096/Spikingformer-CML         |                                                              |
| [Lip print recognition based on convolutional spiking neural network](https://www.spiedigitallibrary.org/conference-proceedings-of-spie/12707/127073M/Lip-print-recognition-based-on-convolutional-spiking-neural-network/10.1117/12.2680982.short) |                                                              | International Conference on Image, Signal Processing, and Pattern Recognition 2023 |
| [Deep recurrent spiking neural networks capture both static and dynamic representations of the visual cortex under movie stimuli](https://arxiv.org/abs/2306.01354) |                                                              |                                                              |
| [Low Precision Quantization-aware Training in Spiking Neural Networks with Differentiable Quantization Function](https://arxiv.org/abs/2305.19295) |                                                              |                                                              |
| [A Brain-Inspired Spiking Network Framework Based on Multi-Time-Step Self-Attention for Lithium-ion Batteries Capacity Prediction](https://ieeexplore.ieee.org/abstract/document/10132013) |                                                              | IEEE Transactions on Consumer Electronics                    |
| [Neurogenesis Dynamics-inspired Spiking Neural Network Training Acceleration](https://arxiv.org/abs/2304.12214) |                                                              |                                                              |
| [Exploring Joint Embedding Architectures and Data Augmentations for Self-Supervised Representation Learning in Event-Based Vision](https://openaccess.thecvf.com/content/CVPR2023W/EventVision/html/Barchid_Exploring_Joint_Embedding_Architectures_and_Data_Augmentations_for_Self-Supervised_Representation_CVPRW_2023_paper.html) | https://github.com/Barchid/exploring_event_ssl               | CVPR 2023                                                    |
| [End-to-End Neuromorphic Lip-Reading](https://openaccess.thecvf.com/content/CVPR2023W/EventVision/html/Bulzomi_End-to-End_Neuromorphic_Lip-Reading_CVPRW_2023_paper.html) |                                                              | CVPR 2023 Workshops                                          |
| [Configurable NbOx Memristors as Artificial Synapses or Neurons Achieved by Regulating the Forming Compliance Current for the Spiking Neural Network](https://onlinelibrary.wiley.com/doi/abs/10.1002/aelm.202300018) |                                                              | Advanced Electronic Materials                                |
| [Learning Delays in Spiking Neural Networks using Dilated Convolutions with Learnable Spacings](https://arxiv.org/abs/2306.17670) | https://github.com/Thvnvtos/SNN-delays                       | ICLR 2024                                                    |
| [Spike-driven Transformer](https://arxiv.org/abs/2307.01694) | https://github.com/BICLab/Spike-Driven-Transformer           | NeurIPS 2023                                                 |
| [Inherent Redundancy in Spiking Neural Networks](https://arxiv.org/abs/2308.08227) | https://github.com/BICLab/ASA-SNN                            | ICCV 2023                                                    |
| [Training of Spiking Neural Network joint Curriculum Learning Strategy](https://arxiv.org/abs/2309.04737) |                                                              |                                                              |
| [Spiking-Diffusion: Vector Quantized Discrete Diffusion Model with Spiking Neural Networks](https://arxiv.org/abs/2308.10187) |                                                              |                                                              |
| [SpikeBERT: A Language Spikformer Trained with Two-Stage Knowledge Distillation from BERT](https://arxiv.org/abs/2308.15122) |                                                              |                                                              |
| [Resource Constrained Model Compression via Minimax Optimization for Spiking Neural Networks](https://arxiv.org/abs/2308.04672) | https://github.com/chenjallen/Resource-Constrained-Compression-on-SNN | ACM MM 2023                                                  |
| [Privacy-Preserving Discretized Spiking Neural Networks](https://arxiv.org/abs/2308.12529) |                                                              |                                                              |
| [Attention-free Spikformer: Mixing Spike Sequences with Simple Linear Transforms](https://arxiv.org/abs/2308.02557) |                                                              |                                                              |
| [Efficient Deep Spiking Multi-Layer Perceptrons with Multiplication-Free Inference](https://arxiv.org/abs/2306.12465) |                                                              |                                                              |
| [Improving Spiking Neural Network Performance with Auxiliary Learning](https://www.mdpi.com/2504-4990/5/3/52) |                                                              | Machine Learning and Knowledge Extraction                    |
| [SDenseNet-An Improved DenseNet Model for Spiking Neural Networks](https://iopscience.iop.org/article/10.1088/1742-6596/2575/1/012004/meta) |                                                              | Journal of Physics: Conference Series                        |
| [Enhancing Robustness of Memristor Crossbar-Based Spiking Neural Networks against Nonidealities: A Hybrid Approach for Neuromorphic Computing in Noisy Environments](https://onlinelibrary.wiley.com/doi/full/10.1002/aisy.202300411) |                                                              | Advanced Intelligent Systems                                 |
| [A LIF Neuron With Adaptive Firing Frequency Based on the GaSe Memristor](https://ieeexplore.ieee.org/abstract/document/10171222) |                                                              | IEEE Transactions on Electron Devices                        |
| [Direct training high-performance spiking neural networks for object recognition and detection](https://www.frontiersin.org/articles/10.3389/fnins.2023.1229951/full) |                                                              | Frontiers in Neuroscience                                    |
| [Efficient asynchronous federated neuromorphic learning of spiking neural networks](https://www.sciencedirect.com/science/article/pii/S0925231223008093) |                                                              | Neurocomputing                                               |
| [Predicting the temporal-dynamic trajectories of cortical neuronal responses in non-human primates based on deep spiking neural network](https://link.springer.com/article/10.1007/s11571-023-09989-1) |                                                              | Cognitive Neurodynamics                                      |
| [Hybrid Spiking Fully Convolutional Neural Network for Semantic Segmentation](https://www.mdpi.com/2079-9292/12/17/3565) |                                                              | Electronics                                                  |
| [A Character-level Short Text Classification Model Based On Spiking Neural Networks](https://ieeexplore.ieee.org/abstract/document/10191963) |                                                              | IJCNN 2023                                                   |
| [CBMC: A Biomimetic Approach for Control of a 7-Degree of Freedom Robotic Arm](https://www.mdpi.com/2313-7673/8/5/389) |                                                              | Biomimetics                                                  |
| [FABLE: A Development and Computing Framework for Brain-inspired Learning Algorithms](https://ieeexplore.ieee.org/abstract/document/10192026) |                                                              | IJCNN 2023                                                   |
| [Hybrid photonic deep convolutional residual spiking neural networks for text classification](https://opg.optica.org/abstract.cfm?uri=oe-31-17-28489) |                                                              | Optics Express                                               |
| [Energy-Efficient Spiking Segmenter for Frame and Event-Based Images](https://www.mdpi.com/2313-7673/8/4/356) |                                                              | Biomimetics                                                  |
| [SPIDEN: deep Spiking Neural Networks for efficient image denoising](https://www.frontiersin.org/articles/10.3389/fnins.2023.1224457/full) |                                                              | Frontiers in Neuroscience                                    |
| [Batch normalization-free weight-binarized SNN based on hardware-saving IF neuron](https://www.sciencedirect.com/science/article/pii/S0925231223003570) |                                                              | Neurocomputing                                               |
| [AC2AS: Activation Consistency Coupled ANN-SNN framework for fast and memory-efficient SNN training](https://www.sciencedirect.com/science/article/pii/S0031320323005241) |                                                              | Pattern Recognition                                          |
| [Back to Homogeneous Computing: A Tightly-Coupled Neuromorphic Processor With Neuromorphic ISA](https://ieeexplore.ieee.org/abstract/document/10226235/) |                                                              | IEEE Transactions on Parallel and Distributed Systems        |
| [Bioinspired Spiking Spatiotemporal Attention Framework for Lithium-Ion Batteries Capacity and RUL Prediction by Electrochemical Impedance Spectroscopy](https://papers.ssrn.com/sol3/papers.cfm?abstract_id=4472252) |                                                              |                                                              |
| [Spiking neural network with working memory can integrate and rectify spatiotemporal features](https://www.frontiersin.org/articles/10.3389/fnins.2023.1167134/full) |                                                              | Frontiers in Neuroscience                                    |
| [CMOS-PCM Based Artificial Thermosensory Neuron for Bio-Inspired Sensing](https://ieeexplore.ieee.org/abstract/document/10231240) |                                                              | 2023 IEEE 23rd International Conference on Nanotechnology (NANO) |
| [SpikingJelly: An open-source machine learning infrastructure platform for spike-based intelligence](https://www.science.org/doi/10.1126/sciadv.adi1480) | https://doi.org/10.5281/zenodo.8310901                       | Science Advances                                             |
| [Masked Spiking Transformer](https://openaccess.thecvf.com/content/ICCV2023/html/Wang_Masked_Spiking_Transformer_ICCV_2023_paper.html) | https://github.com/bic-L/Masked-Spiking-Transformer          | ICCV 2023                                                    |
| [Rate Gradient Approximation Attack Threats Deep Spiking Neural Networks](https://openaccess.thecvf.com/content/CVPR2023/html/Bu_Rate_Gradient_Approximation_Attack_Threats_Deep_Spiking_Neural_Networks_CVPR_2023_paper.html) | https://github.com/putshua/SNN_attack_RGA                    | CVPR 2023                                                    |
| [Exploring Loss Functions for Time-based Training Strategy in Spiking Neural Networks](https://openreview.net/forum?id=8IvW2k5VeA) | https://github.com/zhuyaoyu/SNN-temporal-training-losses     | NeurIPS 2023                                                 |
| [EICIL: Joint Excitatory Inhibitory Cycle Iteration Learning for Deep Spiking Neural Networks](https://openreview.net/forum?id=OMDgOjdqoZ) | https://openreview.net/attachment?id=OMDgOjdqoZ&name=supplementary_material | NeurIPS 2023                                                 |
| [On-chip spiking neural networks based on add-drop ring microresonators and electrically reconfigurable phase-change materials photonic switches](https://opg.optica.org/prj/upcoming_pdf.cfm?id=507178) |                                                              | Photonics Research                                           |
| [Spiking Neural Network Enhanced Hand Gesture Recognition Using Low-Cost Single-photon Avalanche Diode Array](https://arxiv.org/abs/2402.05441) | https://github.com/zzy666666zzy/TinyLiDAR_NET_SNN            |                                                              |
| [CLIF: Complementary Leaky Integrate-and-Fire Neuron for Spiking Neural Networks](https://arxiv.org/abs/2402.04663) |                                                              |                                                              |
| [Towards Improved Imbalance Robustness in Continual Multi-Label Learning with Dual Output Spiking Architecture (DOSA)](https://arxiv.org/abs/2402.04596) |                                                              |                                                              |
| [Facial Expression Recognition Based on Convolutional Spiking Neural Network and STDP Fine-Tune](https://www.preprints.org/manuscript/202401.2165/v1) |                                                              |                                                              |
| [Spiking-PhysFormer: Camera-Based Remote Photoplethysmography with Parallel Spike-driven Transformer](https://arxiv.org/abs/2402.04798) |                                                              |                                                              |
| [Spiking CenterNet: A Distillation-boosted Spiking Neural Network for Object Detection](https://arxiv.org/abs/2402.01287) |                                                              |                                                              |
| [Efficient and Effective Time-Series Forecasting with Spiking Neural Networks](https://arxiv.org/abs/2402.01533) |                                                              |                                                              |
| [Efficient Structure Slimming for Spiking Neural Networks](https://ieeexplore.ieee.org/abstract/document/10391076/) |                                                              | IEEE Transactions on Artificial Intelligence                 |
| [Fully Spiking Actor Network with Intra-layer Connections for Reinforcement Learning](https://arxiv.org/abs/2401.05444) |                                                              |                                                              |
| [Sampling complex topology structures for spiking neural networks](https://www.sciencedirect.com/science/article/pii/S0893608024000352) | https://github.com/stiger1000/Random-Sampling-SNN            | Neural Networks                                              |
| [Spikeformer: Training high-performance spiking neural network with transformer](https://www.sciencedirect.com/science/article/pii/S092523122400050X) |                                                              | Neurocomputing                                               |
| [Multi-LRA: Multi logical residual architecture for spiking neural networks](https://www.sciencedirect.com/science/article/pii/S0020025524000495) |                                                              | Information Sciences                                         |
| [Spiking-Detr: A Spike-Driven End-to-End Object Detection Framework on Spike-Form Data Streams Using Spiking-Transformer and Spiking Residual Learning](https://papers.ssrn.com/sol3/papers.cfm?abstract_id=4706194) | https://github.com/JosephBH0622/Spiking-DETR                 |                                                              |
| [Trainable Region of Interest Prediction: Hard Attention Framework for Hardware-Efficient Event-Based Computer Vision Neural Networks on Neuromorphic Processors](https://lup.lub.lu.se/student-papers/search/publication/9142302) |                                                              | LUND UNIVERSITY                                              |
| [Memory-Efficient Reversible Spiking Neural Networks](https://arxiv.org/abs/2312.07922) | https://github.com/mi804/RevSNN                              | AAAI 2024                                                    |
| [Hierarchical Mapping of Large-Scale Spiking Convolutional Neural Networks Onto Resource-Constrained Neuromorphic Processor](https://ieeexplore.ieee.org/abstract/document/10363652) |                                                              | IEEE Transactions on Computer-Aided Design of Integrated Circuits and Systems |
| [Shrinking Your TimeStep: Towards Low-Latency Neuromorphic Object Recognition with Spiking Neural Network](https://arxiv.org/abs/2401.01912) |                                                              | AAAI 2024                                                    |
| [Fast gradient-free activation maximization for neurons in spiking neural networks](https://arxiv.org/abs/2401.10748) | https://github.com/iabs-neuro/mango                          |                                                              |
| [Event-based Shape from Polarization with Spiking Neural Networks](https://arxiv.org/abs/2312.16071) |                                                              |                                                              |
| [Spiking Neural Networks for Active Time-Resolved SPAD Imaging](https://openaccess.thecvf.com/content/WACV2024/html/Lin_Spiking_Neural_Networks_for_Active_Time-Resolved_SPAD_Imaging_WACV_2024_paper.html) |                                                              | WACV 2024                                                    |
| [Deep Pulse-Coupled Neural Networks](https://arxiv.org/abs/2401.08649) |                                                              |                                                              |
| [Optimizing skyrmionium movement and stability via stray magnetic fields in trilayer nanowire constructs](https://pubs.rsc.org/en/content/articlelanding/2024/cp/d3cp05340g/unauth) |                                                              | Physical Chemistry Chemical Physics                          |
| [Pursing the Sparse Limitation of Spiking Deep Learning Structures](https://arxiv.org/abs/2311.12060) |                                                              |                                                              |
| [Effective Surrogate Gradient Learning With High-Order Information Bottleneck for Spike-Based Machine Intelligence](https://ieeexplore.ieee.org/abstract/document/10325627) |                                                              | IEEE Transactions on Neural Networks and Learning Systems    |
| [RFI Detection with Spiking Neural Networks](https://arxiv.org/abs/2311.14303) |                                                              |                                                              |
| [A brain-inspired energy-efficient Wide Spiking Residual Attention Framework for intelligent fault diagnosis](https://www.sciencedirect.com/science/article/pii/S0951832023007871) |                                                              | Reliability Engineering & System Safety                      |
| [A two-stage spiking meta-learning method for few-shot classification](https://www.sciencedirect.com/science/article/pii/S095070512300970X) |                                                              | Knowledge-Based Systems                                      |
| [Efficient Spiking Neural Architecture Search with Mixed Neuron Models and Variable Thresholds](https://link.springer.com/chapter/10.1007/978-981-99-8082-6_36) |                                                              | ICONIP 2023                                                  |
| [Rethinking Residual Connection in Training Large-Scale Spiking Neural Networks](https://arxiv.org/abs/2311.05171) |                                                              |                                                              |
| [OR Residual Connection Achieving Comparable Accuracy to ADD Residual Connection in Deep Residual Spiking Neural Networks](https://arxiv.org/abs/2311.06570) |                                                              |                                                              |
| [SUSHI: Ultra-High-Speed and Ultra-Low-Power Neuromorphic Chip Using Superconducting Single-Flux-Quantum Circuits](https://dl.acm.org/doi/abs/10.1145/3613424.3623787) |                                                              | MICRO 2023                                                   |
| [Tensor Decomposition Based Attention Module for Spiking Neural Networks](https://arxiv.dosf.top/abs/2310.14576) |                                                              |                                               Knowledge-Based Systems               |
| [Spiking Semantic Communication for Feature Transmission with HARQ](https://arxiv.org/abs/2310.08804) |                                                              |                                                             |
| [SpikePoint: An Efficient Point-based Spiking Neural Network for Event Cameras Action Recognition](https://arxiv.org/abs/2310.07189) |                                                              |                                                              |
| [Enhancing neuromorphic computing with advanced spiking neural network architectures](https://helvia.uco.es/handle/10396/26030) |                                                              | Universidad de Córdoba                                       |
| [Simple and Effective Visual Place Recognition via Spiking Neural Networks and Deep Information](https://ieeexplore.ieee.org/abstract/document/10351617) |                                                              | International Conference on Civil Aviation Safety and Information Technology (ICCASIT), 2023 |
| [An efficient pruning and fine-tuning method for deep spiking neural network](https://link.springer.com/article/10.1007/s10489-023-05056-8) |                                                              | Applied Intelligence                                         |
| [Spike Camera Image Reconstruction Using Deep Spiking Neural Networks](https://ieeexplore.ieee.org/abstract/document/10288531) |                                                              | IEEE Transactions on Circuits and Systems for Video Technology |
| [Autonomous Driving using Spiking Neural Networks on Dynamic Vision Sensor Data: A Case Study of Traffic Light Change Detection](https://arxiv.org/abs/2311.09225) | https://github.com/xueleichen/snn-dvs-carla                  |                                                              |
| [Bioinspired spiking spatiotemporal attention framework for lithium-ion batteries state-of-health estimation](https://www.sciencedirect.com/science/article/pii/S1364032123005853) |                                                              | Renewable and Sustainable Energy Reviews                     |
| [Spiking neural networks for embedded event-based vision](https://theses.hal.science/tel-04393971/) |                                                              | Université Côte d'Azur                                       |
| [Hardware-Algorithm Co-design Enabling Processing-in-Pixel-in-Memory (P2M) for Neuromorphic Vision Sensors](https://arxiv.org/abs/2310.16844) |                                                              |                                                              |
| [Mitigating Overfitting for Deep Learning-based Aging-related Bug Prediction via Brain-inspired Regularization in Spiking Neural Networks](https://ieeexplore.ieee.org/abstract/document/10301319) |                                                              | International Symposium on Software Reliability Engineering Workshops (ISSREW), 2023 |
| [Energy-Efficient Visual Search by Eye Movement and Low-Latency Spiking Neural Network](https://arxiv.org/abs/2310.06578) |                                                              |                                                              |
| [Gaining the Sparse Rewards by Exploring Binary Lottery Tickets in Spiking Neural Network](https://arxiv.org/abs/2309.13302) |                                                              |                                                              |
| [Efficient Privacy-Preserving Convolutional Spiking Neural Networks with FHE](https://arxiv.org/abs/2309.09025v1) |                                                              |                                                              |
| [Predicting the temporal-dynamic trajectories of cortical neuronal responses in non-human primates based on deep spiking neural network](https://link.springer.com/article/10.1007/s11571-023-09989-1) |                                                              | Cognitive Neurodynamics                                      |
| [Learning Spiking Neural Network from Easy to Hard task](https://arxiv.org/abs/2309.04737) |                                                              |                                                              |
| [Reconstruction of Adaptive Leaky Integrate-and-Fire Neuron to Enhance the Spiking Neural Networks Performance by Establishing Complex Dynamics](https://ieeexplore.ieee.org/abstract/document/10375825) |                                                              | IEEE Transactions on Neural Networks and Learning Systems    |
| [Spiking-Diffusion: Vector Quantized Discrete Diffusion Model with Spiking Neural Networks](https://arxiv.org/abs/2308.10187) |                                                              |                                                              |
| [Back to Homogeneous Computing: A Tightly-Coupled Neuromorphic Processor With Neuromorphic ISA](https://ieeexplore.ieee.org/abstract/document/10226235) |                                                              | IEEE Transactions on Parallel and Distributed Systems        |
| [CBMC: A Biomimetic Approach for Control of a 7-Degree of Freedom Robotic Arm](https://www.mdpi.com/2313-7673/8/5/389) |                                                              | Biomimetics                                                  |
| [Enhancing Robustness of Memristor Crossbar-Based Spiking Neural Networks against Nonidealities: A Hybrid Approach for Neuromorphic Computing in Noisy Environments](https://onlinelibrary.wiley.com/doi/full/10.1002/aisy.202300411) |                                                              | Advanced Intelligent Systems                                 |
| [Efficient asynchronous federated neuromorphic learning of spiking neural networks](https://www.sciencedirect.com/science/article/pii/S0925231223008093) |                                                              | Neurocomputing                                               |
| [A High-speed and Low-power FPGA Implementation of Spiking Convolutional Neural Network Using Logarithmic Quantization](https://ieeexplore.ieee.org/abstract/document/10280835) |                                                              | International Conference on Natural Computation, Fuzzy Systems and Knowledge Discovery (ICNC-FSKD), 2023 |
| [SDenseNet-An Improved DenseNet Model for Spiking Neural Networks](https://iopscience.iop.org/article/10.1088/1742-6596/2575/1/012004) |                                                              | Journal of Physics: Conference Series                        |
| [Comparing energy efficiency of Leaky integrate-and-fire and Spike response neuron models in Spiking Neural Networks](https://www.diva-portal.org/smash/get/diva2:1779214/FULLTEXT01.pdf) |                                                              | KTH Royal Institute of Technology                            |
| [A neuromorphic physiological signal processing system based on VO2 memristor for next-generation human-machine interface](https://www.nature.com/articles/s41467-023-39430-4) |                                                              | Nature Communications                                        |
| [Event-based classification of defects in civil infrastructures with Artificial and Spiking Neural Networks](https://link.springer.com/chapter/10.1007/978-3-031-43078-7_51) |                                                              | International Work-Conference on Artificial Neural Networks, 2023 |
| [NeuroBench: A Framework for Benchmarking Neuromorphic Computing Algorithms and Systems](https://arxiv.org/abs/2304.04640) |                                                              |                                                              |
| [Optimal ANN-SNN Conversion with Group Neurons](https://arxiv.org/abs/2402.19061) | https://github.com/Lyu6PosHao/ANN2SNN_GN                     | ICASSP 2024                                                  |
| [SGLFormer: Spiking Global-Local-Fusion Transformer with high performance](https://www.frontiersin.org/journals/neuroscience/articles/10.3389/fnins.2024.1371290/full) | https://github.com/ZhangHanN1/SGLFormer                      | Frontiers in Neuroscience 2024                               |
| [QKFormer: Hierarchical Spiking Transformer using Q-K Attention](https://arxiv.org/pdf/2403.16552.pdf) | https://github.com/zhouchenlin2096/QKFormer                  |                                                              |
| [Methodology based on spiking neural networks for univariate time-series forecasting](https://www.sciencedirect.com/science/article/pii/S0893608024000959) |                                                              | Neural Networks                                              |
| [A Unified Evaluation Framework for Spiking Neural Network Hardware Accelerators Based on Emerging Non-Volatile Memory Devices](https://arxiv.org/abs/2402.19139) |                                                              |                                                              |
| [SpikeNAS: A Fast Memory-Aware Neural Architecture Search Framework for Spiking Neural Network-based Autonomous Agents](https://arxiv.org/abs/2402.11322) |                                                              |                                                              |
| [SDiT: Spiking Diffusion Model with Transformer](https://arxiv.org/abs/2402.11588) |                                                              |                                                              |
| [RepSViT: An Efficient Vision Transformer Based on Spiking Neural Networks for Object Recognition in Satellite On-Orbit Remote Sensing Images](https://ieeexplore.ieee.org/abstract/document/10440355) |                                                              | IEEE Transactions on Geoscience and Remote Sensing           |
| [Toward High Performance, Programmable Extreme-Edge Intelligence for Neuromorphic Vision Sensors utilizing Magnetic Domain Wall Motion-based MTJ](https://arxiv.org/abs/2402.15121) |                                                              |                                                              |
| [A Unified Evaluation Framework for Spiking Neural Network Hardware Accelerators Based on Emerging Non-Volatile Memory Devices](https://arxiv.org/abs/2402.19139) |                                                              |                                                              |
| [A light-weight neuromorphic controlling clock gating based multi-core cryptography platform](https://www.sciencedirect.com/science/article/pii/S0141933124000358) |                                                              | Microprocessors and Microsystems                             |
| [基于多维投影时空事件帧的动态视觉传感手势识别(Gesture Recognition for Dynamic Vision Sensor Based on Multi-dimensional Projection Spatiotemporal Event Frame)](https://www.china-simulation.com/CN/abstract/abstract3337.shtml) |                                                              | 系统仿真学报                                                 |
| [Point-to-Spike Residual Learning for Energy-Efficient 3D Point Cloud Classification](https://ojs.aaai.org/index.php/AAAI/article/view/28425) |                                                              | AAAI 2024                                                    |
| [EAS-SNN: End-to-End Adaptive Sampling and Representation for Event-based Detection with Recurrent Spiking Neural Networks](https://arxiv.org/abs/2403.12574) |                                                              |                                                              |
| [Using spiking neural networks to assist fine art and philology study: to classify styles of Chinese calligraphy with minimal computing power](https://openreview.net/forum?id=1715SJkbj7) |                                                              | ICLR 2024 Tiny Papers                                        |
| [Spiking Wavelet Transformer](https://arxiv.org/abs/2403.11138) |                                                              |                                                              |
| [A Hybrid SNN-ANN Network for Event-based Object Detection with Spatial and Temporal Attention](https://arxiv.org/abs/2403.10173) |                                                              |                                                              |
| [A novel stochastic resonance based deep residual network for fault diagnosis of rolling bearing system](https://www.sciencedirect.com/science/article/pii/S0019057824001289) |                                                              | ISA Transactions                                             |
| [Application of SNNS Model Based On Multi-Dimensional Attention In Drone Radio Frequency Signal Classification](https://ieeexplore.ieee.org/abstract/document/10446694) |                                                              | ICASSP 2024                                                  |
| [Fourier or Wavelet bases as counterpart self-attention in spikformer for efficient visual classification](https://arxiv.org/abs/2403.18228) |                                                              |                                                              |
| [Spikewhisper: Temporal Spike Backdoor Attacks on Federated Neuromorphic Learning over Low-power Devices](https://arxiv.org/abs/2403.18607) |                                                              |                                                              |
| [GET: Group Event Transformer for Event-Based Vision](https://openaccess.thecvf.com/content/ICCV2023/html/Peng_GET_Group_Event_Transformer_for_Event-Based_Vision_ICCV_2023_paper.html) | https://github.com/Peterande/GET-Group-Event-Transformer     | ICCV 2023                                                    |
|[Tensor decomposition based attention module for spiking neural networks](https://www.sciencedirect.com/science/article/abs/pii/S0950705124004143)| https://github.com/RisingEntropy/PFA| Knowledge-Based Systems                                                                                                    |
|[Fast gradient-free activation maximization for neurons in spiking neural networks](https://arxiv.org/abs/2401.10748)| https://github.com/iabs-neuro/mango |  |
|[Direct training high-performance deep spiking neural networks: a review of theories and methods](https://www.frontiersin.org/journals/neuroscience/articles/10.3389/fnins.2024.1383844/full)|  |Frontiers in Neuroscience 2024|

If you use SpikingJelly in your paper, you can also add it to this table by pull request.

