# 🚀 Contributing to SpikingJelly

Welcome to the SpikingJelly community! We appreciate your interest in contributing to our project. This guide will help you get started, so let's dive in! 😄

## How Can You Contribute?

1. 🐞 **Report Issues**: Found a bug or have a feature request? Please check our [existing issues](https://github.com/fangwei123456/spikingjelly/issues) to see if it's already reported. If not, feel free to [create a new issue](https://github.com/fangwei123456/spikingjelly/issues/new) to let us know!

2. 🛠️ **Contribute Code**: You can contribute by fixing issues or implementing new features. Check out our [list of open issues](https://github.com/fangwei123456/spikingjelly/issues) for a place to start.

3. 📚 **Translate Documentation**: Help us make our project more accessible by translating documentation from English to Chinese or vice versa. If you're interested in this, please see the section below.

4. 📢 **Join the Discussion**: Feel free to participate in discussions related to development plans or other project matters in the [GitHub issues](https://github.com/fangwei123456/spikingjelly/issues) section. Your input is valuable!

## Reporting Issues

1. When reporting an issue, please provide as much detail as possible. This includes the version of SpikingJelly, your operating system, and any error messages you encounter.

2. Use clear and concise language to describe the issue or feature request. Be sure to include steps to reproduce the problem.

3. If you want to report a bug, please use the "Bug" label. If it's a feature request, use the "Feature" label.

## Contributing Code

1. Start by forking the repository and cloning it to your local machine.

2. Create a new branch for your work: `git checkout -b my-new-feature`.

3. Write clean, concise code and ensure it adheres to our coding standards.

4. Test your code thoroughly and ensure it doesn't break existing functionality.

5. Submit a Pull Request (PR) to our repository with a clear description of the changes you've made.

6. We'll review your PR and may provide feedback or request changes. Once it's approved, your contribution will be merged.

## Translating Documentation

1. We welcome contributions to translate our documentation. If you'd like to help, check out the "docs" folder in the repository.

2. Create a new branch for your translation work: `git checkout -b my-translation`.

3. Translate the documentation from English to Chinese or from Chinese to English.

4. Submit a Pull Request with your translated documentation, and we'll review and merge it.

## Thank You!

Your contributions are invaluable to SpikingJelly's development. We look forward to your participation and appreciate your help in making SpikingJelly better for everyone! 🎉

Let's work together to build an amazing SpikingJelly community! If you have any questions or need assistance, don't hesitate to ask. 😊
