/**
 * Layout component that queries for data
 * with Gatsby's useStaticQuery component
 *
 * See: https://www.gatsbyjs.com/docs/how-to/querying-data/use-static-query/
 */

import * as React from "react"

import Header from "./header"
import Footer from "./footer"
import {Breadcrumb} from 'gatsby-plugin-breadcrumb'

const Layout = ({ children,location='',crumbLabel }) => {
  
  return (
    <>
      <Header />
      {/* <Breadcrumb location={location} crumbLabel={crumbLabel} /> */}
      <main>{children}</main>
      <Footer />
    </>
  )
}

export default Layout
