# Contributing to ELF
We want to make contributing to this project as easy and transparent as possible.  
We also welcome any fork attempt from this project.  

## Our Development Process
ELF is developed mainly by Yuandong Tian, Qucheng Gong and Yuxin Wu from Facebook AI Research since Jan. 2017.
Since it opens to the public, its future development will be conducted in this open source branch.  

## Bug reports
Please follow the steps when you find a bug:

1. use the Github issue search to check if the issue has been addressed before. 
2. Make sure if the issue has been fixed by synchronizing the most recent branch in the repository. 
3. Write a simple and easy-to-understand test case that reveals the issue. We use github issues to track public bugs. please ensure your description is clear and has sufficient instructions to be able to reproduce the issue.

## Pull Requests
We actively welcome your pull requests.

1. Fork the repo and create your branch from `master`.
2. If you've added code that should be tested, add tests.
3. If you've changed APIs, update the documentation.
4. Ensure the test suite passes.
5. Make sure your code lints.
6. If you haven't already, complete the Contributor License Agreement ("CLA").

## Contributor License Agreement ("CLA")
In order to accept your pull request, we need you to submit a CLA. You only need
to do this once to work on any of Facebook's open source projects.

Complete your CLA here: <https://code.facebook.com/cla>

## Coding Style  
* 2 spaces for indentation rather than tabs
* 80 character line length

## License
By contributing to ELF, you agree that your contributions will be licensed under its BSD license.
