<!---
-- Copyright (c) Meta Platforms, Inc. and affiliates.
--
-- This source code is licensed under the MIT license found in the
-- LICENSE file in the root directory of this source tree.
-->

# Java/JNI Example

These files serve to illustrate how you can interoperate with CQL generated
code in Java.

* `./CGSQLMain.java`

This is just a simple main program that creates the result set and then prints it out.
It's not especially reusable but we need a main so here it is.


* `./TestResult.c`
* `./TestResult.h`
* `./TestResult.java`

This is the JNI class that runs the particular stored procedure we need in this
sample.  See Sample.sql below.  The native code has to
  * open a database
  * call the stored procedure with any args (there are none other than the database in this example)
    * for any real code this would need to be generalized
  * close the database

The general purpose classes and the compiler output concern themselves with
allowing result sets to be accessed from Java.  There is no general way to
invoke stored procedures with arbitrary signatures at this time. Though you could
imagine using the JSON output to codegen JNI wrappers as well as result set
readers.  This area is ripe for future development to make Java access easier.

* `./com_facebook_cgsql_CQLResultSet.c`
* `./com_facebook_cgsql_CQLResultSet.h`
* `./com/facebook/cgsql/CQLResultSet.java`
* `./com/facebook/cgsql/CQLViewModel.java`

These are the re-usable parts.  `CQLResultSet` uses standard JNI methods to
read the primitive types out of any result set.  The compiler produce a subclass
of `CQLViewModel` that uses `CQLResultSet` to do its job.  The JNI C file
`com_facebook_cgsql_CQLResultSet.c` has the necessary calls to the runtime to
do that reading.  Each of the functions is just a few lines of code. The `.h` file
is auto-generated by `java -h` from the .java and hence doesn't actually need
to be checked in but it's included because it's useful to browse without
building and any diffs might be interesting in further porting efforts.

* `./Sample.sql`

This is is a stored procedure that creates a table, puts stuff in it, and then returns
its contents.  This is in some sense the core of the demo.  Everything else is
scaffolding.

* `./make.sh`
* `./clean.sh`

Use `make.sh` to build and execute the JNI demo.  Use `clean.sh` to clean up
the build artifacts afterwards.

Build notes:

* set `CGSQL_GCC=1` if you're using GCC rather than clang
* set `JAVA_HOME` to the location of your JDK, for `jni.h` and friends.
* set `SQLITE_PATH` to the location of your SQLite installation if you want to use an amalgam build of SQLITE rather than just use `-lsqlite3`

`make.sh` is itself pretty straightforward
