# RNTester

The RNTester showcases React Native views and modules.

## Running this app

Before running the app, make sure you ran:
```sh
git clone https://github.com/facebook/react-native.git
cd react-native
yarn install
```

### Running on iOS

If you are testing non-fabric component, search for and modify the `fabric_enabled` flag in [RNTester's Podfile](https://github.com/facebook/react-native/blob/main/packages/rn-tester/Podfile).

```ruby
fabric_enabled = false
```

Also, if you previously built RNTester with fabric enabled, you might need to clean up the build files and Pods.
```sh
# Clean the generated files and folders to clean install RNTester
cd packages/rn-tester
yarn clean-ios
```

If you are still having a problem after doing the clean up (which can happen if you have built RNTester with older React Native versions where files were generated inside the react-native folder.), the best way might be to clean-install react-native (e.g. remove node_modules and yarn install). If after cleaning up, you are still having issues, you might also want to try `RCT_NEW_ARCH_ENABLED=0 bundle exec pod install` to disable the new architecture as it might be conflicting.

Both macOS and Xcode are required.
1. `cd packages/rn-tester`
2. Install [Bundler](https://bundler.io/): `gem install bundler`. We use bundler to install the right version of [CocoaPods](https://cocoapods.org/) locally.
3. Install Bundler and CocoaPods dependencies: `bundle install && bundle exec pod install` or `yarn setup-ios-hermes`. In order to use JSC instead of Hermes engine, run: `USE_HERMES=0 bundle exec pod install` or `yarn setup-ios-jsc` instead.
4. Open the generated `RNTesterPods.xcworkspace`. This is not checked in, as it is generated by CocoaPods. Do not open `RNTesterPods.xcodeproj` directly.

#### Note for Apple Silicon users

If you own a Mac laptop with Apple Silicon, you need to run some different commands to install and run cocoapods.

- `sudo arch -x86_64 gem install ffi`: this installs the `ffi` package to load dynamically-linked libraries.
- `arch -x86_64 pod install`: this run `pod install` with the right architecture.

### Running on Android

You'll need to have all the [prerequisites](https://reactnative.dev/contributing/how-to-build-from-source#prerequisites) (SDK, NDK) for Building React Native installed.

You can build and run RN-Tester by using this command from the root of the repo:

```sh
yarn android
```

If you wish to use JSC instead you should invoke:

```sh
cd packages/rn-tester
yarn install-android-jsc
yarn start
```

> [!NOTE]
> Building for the first time can take a while.

If you're using a physical device, run `adb reverse tcp:8081 tcp:8081` to make sure the device can access Metro.

See [Running on Device](https://reactnative.dev/docs/running-on-device) for additional instructions on using a physical device.

## Building from source

Building the app on both iOS and Android means building the React Native framework from source. This way you're running the latest native and JS code the way you see it in your clone of the github repo.

This is different from apps created using `react-native init` which have a dependency on a specific version of React Native JS and native code, declared in a `package.json` file (and `build.gradle` for Android apps).
