/**
 * Copyright (c) Meta Platforms, Inc. and affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 *
 * @flow strict
 * @format
 */

import type {FeatureFlagDefinitions} from '../../types';

import {DO_NOT_MODIFY_COMMENT, getCxxTypeFromDefaultValue} from '../../utils';
import signedsource from 'signedsource';

export default function (definitions: FeatureFlagDefinitions): string {
  return signedsource.signFile(`/*
 * Copyright (c) Meta Platforms, Inc. and affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 *
 * ${signedsource.getSigningToken()}
 */

${DO_NOT_MODIFY_COMMENT}

#include "NativeReactNativeFeatureFlags.h"
#include <react/featureflags/ReactNativeFeatureFlags.h>

#ifdef RN_DISABLE_OSS_PLUGIN_HEADER
#include "Plugins.h"
#endif

std::shared_ptr<facebook::react::TurboModule>
NativeReactNativeFeatureFlagsModuleProvider(
    std::shared_ptr<facebook::react::CallInvoker> jsInvoker) {
  return std::make_shared<facebook::react::NativeReactNativeFeatureFlags>(
      std::move(jsInvoker));
}

namespace facebook::react {

NativeReactNativeFeatureFlags::NativeReactNativeFeatureFlags(
    std::shared_ptr<CallInvoker> jsInvoker)
    : NativeReactNativeFeatureFlagsCxxSpec(std::move(jsInvoker)) {}

${Object.entries(definitions.common)
  .map(([flagName, flagConfig]) =>
    flagConfig.skipNativeAPI
      ? `${getCxxTypeFromDefaultValue(
          flagConfig.defaultValue,
        )} NativeReactNativeFeatureFlags::${flagName}(
    jsi::Runtime& /*runtime*/) {
  // This flag is configured with \`skipNativeAPI: true\`.
  // TODO(T204838867): Implement support for optional methods in C++ TM codegen and remove the method definition altogether.
  return ${JSON.stringify(flagConfig.defaultValue)};
}`
      : `${getCxxTypeFromDefaultValue(
          flagConfig.defaultValue,
        )} NativeReactNativeFeatureFlags::${flagName}(
    jsi::Runtime& /*runtime*/) {
  return ReactNativeFeatureFlags::${flagName}();
}`,
  )
  .join('\n\n')}

} // namespace facebook::react
`);
}
