/**
 * Copyright (c) Meta Platforms, Inc. and affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */

const fs = require('fs');
const path = require('path');

const tsComponentFixturePath = path.join(__dirname, '../../react-native-codegen/src/parsers/typescript/components/__test_fixtures__/fixtures.js');
const tsComponentSnapshotPath = path.join(__dirname, '../../react-native-codegen/src/parsers/typescript/components/__tests__/__snapshots__/typescript-component-parser-test.js.snap');
const tsModuleFixturePath = path.join(__dirname, '../../react-native-codegen/src/parsers/typescript/modules/__test_fixtures__/fixtures.js');
const tsModuleSnapshotPath = path.join(__dirname, '../../react-native-codegen/src/parsers/typescript/modules/__tests__/__snapshots__/typescript-module-parser-snapshot-test.js.snap');
const snapshotOutputPath = path.join(__dirname, '../__generated__');

function genereateSnapshotTestCases(name, fixturePath, snapshotPath, outputPath) {
    const fixtures = require(fixturePath);
    const snapshots = require(snapshotPath);
    for (const key of Object.keys(fixtures)) {
        const snapshotName = `RN Codegen TypeScript Parser can generate fixture ${key} 1`;
        const snapshotString = snapshots[snapshotName];
        const snapshot = snapshotString.substring(2, snapshotString.length - 2);
        const tsSourceCode = `
/**
 * Copyright (c) Meta Platforms, Inc. and affiliates.
 *
 * DO NOT MODIFY
 * Generated by src/build.js
 * From snapshot: ${name} - ${key}
 */

import type { SchemaType } from '@react-native/codegen/lib/CodegenSchema';
const snapshot : SchemaType = ${snapshot};
export default snapshot;
`;
        fs.writeFileSync(path.join(outputPath, `${name}_${key}.ts`), tsSourceCode, { encoding: 'utf-8' });
    }
}

genereateSnapshotTestCases('component', tsComponentFixturePath, tsComponentSnapshotPath, snapshotOutputPath);
genereateSnapshotTestCases('module', tsModuleFixturePath, tsModuleSnapshotPath, snapshotOutputPath);
