-- ----------------------------------------
-- EyouCms MySQL Data Transfer 
-- 
-- Server         : 127.0.0.1_3306
-- Server Version : 5.7.26
-- Host           : 127.0.0.1:3306
-- Database       : e15
-- 
-- Part : #1
-- Version : #v1.6.3
-- Date : 2023-06-08 14:06:09
-- -----------------------------------------

SET FOREIGN_KEY_CHECKS = 0;


-- -----------------------------
-- Table structure for `ey_ad`
-- -----------------------------
DROP TABLE IF EXISTS `ey_ad`;
CREATE TABLE `ey_ad` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '广告id',
  `pid` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '广告位置ID',
  `media_type` tinyint(1) DEFAULT '0' COMMENT '广告类型',
  `title` varchar(60) DEFAULT '' COMMENT '广告名称',
  `links` varchar(255) DEFAULT '' COMMENT '广告链接',
  `litpic` varchar(255) DEFAULT '' COMMENT '图片地址',
  `start_time` int(11) DEFAULT '0' COMMENT '投放时间',
  `end_time` int(11) DEFAULT '0' COMMENT '结束时间',
  `intro` text COMMENT '描述',
  `link_man` varchar(60) DEFAULT '' COMMENT '添加人',
  `link_email` varchar(60) DEFAULT '' COMMENT '添加人邮箱',
  `link_phone` varchar(60) DEFAULT '' COMMENT '添加人联系电话',
  `click` int(11) DEFAULT '0' COMMENT '点击量',
  `bgcolor` varchar(30) DEFAULT '' COMMENT '背景颜色',
  `status` tinyint(1) unsigned DEFAULT '1' COMMENT '1=显示，0=屏蔽',
  `sort_order` int(11) DEFAULT '0' COMMENT '排序',
  `target` varchar(50) DEFAULT '' COMMENT '是否开启浏览器新窗口',
  `admin_id` int(10) DEFAULT '0' COMMENT '管理员ID',
  `is_del` tinyint(1) DEFAULT '0' COMMENT '伪删除，1=是，0=否',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '多语言',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`),
  KEY `position_id` (`pid`) USING BTREE,
  KEY `status` (`status`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

-- -----------------------------
-- Records of `ey_ad`
-- -----------------------------
INSERT INTO `ey_ad` VALUES ('1', '1', '1', '幻灯一', '', '/public/upload/other/2018/08/08/30ab58347a81a8f8f6c6915934b0655d.jpg', '0', '0', '', '', '', '', '0', '', '1', '100', '1', '0', '0', 'cn', '1533543051', '1533717188');
INSERT INTO `ey_ad` VALUES ('2', '1', '1', '幻灯二', '', '/public/upload/other/2018/08/08/af1436112fa9ca0ab6a025623dff7c4f.jpg', '0', '0', '', '', '', '', '0', '', '1', '100', '1', '0', '0', 'cn', '1533543086', '1533717167');

-- -----------------------------
-- Table structure for `ey_ad_position`
-- -----------------------------
DROP TABLE IF EXISTS `ey_ad_position`;
CREATE TABLE `ey_ad_position` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(60) NOT NULL DEFAULT '' COMMENT '广告位置名称',
  `type` tinyint(1) NOT NULL DEFAULT '1' COMMENT '广告展示类型，1图片类型，2媒体类型，3HTML代码',
  `width` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT '广告位宽度',
  `height` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT '广告位高度',
  `intro` text NOT NULL COMMENT '广告描述',
  `status` tinyint(1) NOT NULL DEFAULT '1' COMMENT '0关闭1开启',
  `lang` varchar(50) NOT NULL DEFAULT 'cn' COMMENT '多语言',
  `admin_id` int(10) NOT NULL DEFAULT '0' COMMENT '管理员ID',
  `is_del` tinyint(1) NOT NULL DEFAULT '0' COMMENT '伪删除，1=是，0=否',
  `add_time` int(11) NOT NULL DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COMMENT='广告位置表';

-- -----------------------------
-- Records of `ey_ad_position`
-- -----------------------------
INSERT INTO `ey_ad_position` VALUES ('1', '首页幻灯', '1', '1600', '380', '', '1', 'cn', '0', '0', '1533542954', '1533950824');

-- -----------------------------
-- Table structure for `ey_addon17_content`
-- -----------------------------
DROP TABLE IF EXISTS `ey_addon17_content`;
CREATE TABLE `ey_addon17_content` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `aid` int(10) DEFAULT '0' COMMENT '文档ID',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  `video` varchar(251) NOT NULL DEFAULT '' COMMENT '视频上传',
  PRIMARY KEY (`id`),
  KEY `aid` (`aid`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=7 DEFAULT CHARSET=utf8 COMMENT='附加表';

-- -----------------------------
-- Records of `ey_addon17_content`
-- -----------------------------
INSERT INTO `ey_addon17_content` VALUES ('1', '82', '1637110204', '1637110204', '/uploads/media/200706/1-200F61RZ5.mp4');
INSERT INTO `ey_addon17_content` VALUES ('2', '83', '1637110204', '1637110204', '/uploads/media/200706/1-200F61RZ5.mp4');
INSERT INTO `ey_addon17_content` VALUES ('3', '84', '1637110204', '1637110204', '/uploads/media/200706/1-200F61RZ5.mp4');
INSERT INTO `ey_addon17_content` VALUES ('4', '85', '1637110204', '1637110204', '/uploads/media/200706/1-200F61RZ5.mp4');
INSERT INTO `ey_addon17_content` VALUES ('5', '86', '1637110204', '1637110204', '/uploads/media/200706/1-200F61RZ5.mp4');
INSERT INTO `ey_addon17_content` VALUES ('6', '87', '1637110204', '1637110204', '/uploads/media/200706/1-200F61RZ5.mp4');

-- -----------------------------
-- Table structure for `ey_admin`
-- -----------------------------
DROP TABLE IF EXISTS `ey_admin`;
CREATE TABLE `ey_admin` (
  `admin_id` smallint(5) unsigned NOT NULL AUTO_INCREMENT COMMENT '用户id',
  `user_name` varchar(20) NOT NULL DEFAULT '' COMMENT '用户名',
  `pen_name` varchar(50) DEFAULT '' COMMENT '笔名（发布文章后显示责任编辑的名字）',
  `true_name` varchar(20) DEFAULT '' COMMENT '真实姓名',
  `mobile` varchar(11) DEFAULT '' COMMENT '手机号码',
  `email` varchar(60) DEFAULT '' COMMENT 'email',
  `password` varchar(255) NOT NULL DEFAULT '' COMMENT '密码',
  `head_pic` varchar(255) DEFAULT '' COMMENT '头像',
  `last_login` int(11) DEFAULT '0' COMMENT '最后登录时间',
  `last_ip` varchar(15) DEFAULT '' COMMENT '最后登录ip',
  `login_cnt` int(11) DEFAULT '0' COMMENT '登录次数',
  `session_id` varchar(50) DEFAULT '' COMMENT 'session_id',
  `parent_id` int(10) DEFAULT '0' COMMENT '父管理员ID',
  `role_id` int(10) NOT NULL DEFAULT '-1' COMMENT '角色组ID（-1表示超级管理员）',
  `mark_lang` varchar(50) DEFAULT 'cn' COMMENT '当前语言标识',
  `status` tinyint(1) DEFAULT '1' COMMENT '状态(0=屏蔽，1=正常)',
  `syn_users_id` int(10) DEFAULT '0' COMMENT '同步注册到会员表',
  `desc` varchar(500) DEFAULT '' COMMENT '工作内容',
  `wechat_followed` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '记录是否关注了微信公众号，默认0；0=未关注、1=已关注',
  `wechat_open_id` varchar(50) NOT NULL DEFAULT '' COMMENT 'open_id，关注微信公众号后存入',
  `add_time` int(11) DEFAULT '0' COMMENT '添加时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`admin_id`),
  KEY `user_name` (`user_name`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

-- -----------------------------
-- Records of `ey_admin`
-- -----------------------------
INSERT INTO `ey_admin` VALUES ('1', 'admin', '', 'admin', '', '', '$2y$11$81d7d29e92eaf2d6fb983OPDvdXqmWwnaph/XCC1jFartpYbZHjr2', '', '1686204250', '127.0.0.1', '2', 'm49uhv668f9vgsmv6d6ni3ss2l', '0', '-1', 'cn', '1', '0', '', '0', '', '1686204242', '0');

-- -----------------------------
-- Table structure for `ey_admin_log`
-- -----------------------------
DROP TABLE IF EXISTS `ey_admin_log`;
CREATE TABLE `ey_admin_log` (
  `log_id` bigint(16) unsigned NOT NULL AUTO_INCREMENT COMMENT '表id',
  `admin_id` int(10) NOT NULL DEFAULT '-1' COMMENT '管理员id',
  `log_info` text COMMENT '日志描述',
  `log_ip` varchar(30) DEFAULT '' COMMENT 'ip地址',
  `log_url` varchar(255) DEFAULT '' COMMENT 'url',
  `log_time` int(11) DEFAULT '0' COMMENT '日志时间',
  PRIMARY KEY (`log_id`),
  KEY `admin_id` (`admin_id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=154 DEFAULT CHARSET=utf8;

-- -----------------------------
-- Records of `ey_admin_log`
-- -----------------------------
INSERT INTO `ey_admin_log` VALUES ('150', '1', '后台登录', '127.0.0.1', '/login.php', '1686204250');
INSERT INTO `ey_admin_log` VALUES ('149', '-1', '访问后台', '127.0.0.1', '/login.php', '1686204243');
INSERT INTO `ey_admin_log` VALUES ('151', '1', '保存自定义变量：网站公告,手机号码,地址,电话,邮箱,微信二维码,客服QQ', '127.0.0.1', '/login.php', '1686204322');
INSERT INTO `ey_admin_log` VALUES ('152', '1', '编辑友情链接：优酷', '127.0.0.1', '/login.php', '1686204333');
INSERT INTO `ey_admin_log` VALUES ('153', '1', '编辑栏目：联系我们', '127.0.0.1', '/login.php', '1686204361');

-- -----------------------------
-- Table structure for `ey_admin_menu`
-- -----------------------------
DROP TABLE IF EXISTS `ey_admin_menu`;
CREATE TABLE `ey_admin_menu` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `menu_id` int(11) DEFAULT '0',
  `title` varchar(100) DEFAULT '' COMMENT '导航名称',
  `controller_name` varchar(50) DEFAULT '' COMMENT '控制器',
  `action_name` varchar(50) DEFAULT '' COMMENT '方法名',
  `param` varchar(255) DEFAULT '' COMMENT '参数',
  `icon` varchar(50) DEFAULT 'iconfont e-lanmuguanli' COMMENT '图标',
  `is_menu` tinyint(1) DEFAULT '0' COMMENT '是否显示为左侧菜单',
  `is_switch` tinyint(1) DEFAULT '0' COMMENT '是否显示在switch_map页面中',
  `sort_order` int(10) DEFAULT '100' COMMENT '排序号',
  `status` tinyint(1) DEFAULT '1' COMMENT '状态，1=显示，0=隐藏',
  `lang` varchar(20) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`),
  UNIQUE KEY `menu_id` (`menu_id`)
) ENGINE=MyISAM AUTO_INCREMENT=15 DEFAULT CHARSET=utf8 COMMENT='外挂功能地图菜单表';

-- -----------------------------
-- Records of `ey_admin_menu`
-- -----------------------------
INSERT INTO `ey_admin_menu` VALUES ('1', '1005', '欢迎页', 'Index', 'welcome', '', 'fa fa-user', '0', '1', '100', '1', 'cn', '1667470611', '1667470611');
INSERT INTO `ey_admin_menu` VALUES ('2', '1001', '栏目管理', 'Arctype', 'index', '|mt20|1', 'iconfont e-lanmuguanli', '1', '1', '100', '1', 'cn', '1667470611', '1667470611');
INSERT INTO `ey_admin_menu` VALUES ('3', '1002', '内容管理', 'Archives', 'index', '', 'iconfont e-neirongwendang', '1', '1', '100', '1', 'cn', '1667470611', '1667470611');
INSERT INTO `ey_admin_menu` VALUES ('4', '1004', '待审文档', 'Archives', 'index_draft', '|menu|1', 'iconfont e-tougao', '0', '1', '100', '1', 'cn', '1667470611', '1667470611');
INSERT INTO `ey_admin_menu` VALUES ('5', '1003', '广告管理', 'AdPosition', 'index', '', 'iconfont e-guanggao', '1', '1', '100', '1', 'cn', '1667470611', '1667470611');
INSERT INTO `ey_admin_menu` VALUES ('6', '2001', '基本信息', 'System', 'web', '', 'iconfont e-shezhi', '1', '1', '100', '1', 'cn', '1667470611', '1667470611');
INSERT INTO `ey_admin_menu` VALUES ('7', '2002', '可视编辑', 'Uiset', 'ui_index', '', 'iconfont e-keshihuabianji', '0', '1', '100', '1', 'cn', '1667470611', '1667470611');
INSERT INTO `ey_admin_menu` VALUES ('8', '2003', 'SEO模块', 'Seo', 'seo', '', 'iconfont e-seo', '1', '1', '100', '1', 'cn', '1667470611', '1667470611');
INSERT INTO `ey_admin_menu` VALUES ('9', '2004', '功能地图', 'Index', 'switch_map', '', 'iconfont e-caidangongneng', '1', '0', '10000', '1', 'cn', '1667470611', '1667470611');
INSERT INTO `ey_admin_menu` VALUES ('10', '2005', '插件应用', 'Weapp', 'index', '', 'iconfont e-chajian', '1', '1', '100', '1', 'cn', '1667470611', '1667470839');
INSERT INTO `ey_admin_menu` VALUES ('11', '2006', '会员中心', 'Member', 'users_index', '', 'iconfont e-gerenzhongxin', '0', '1', '100', '1', 'cn', '1667470611', '1667470611');
INSERT INTO `ey_admin_menu` VALUES ('12', '2008', '商城中心', 'Shop', 'home', '', 'iconfont e-shangcheng', '1', '1', '100', '1', 'cn', '1667470611', '1667470612');
INSERT INTO `ey_admin_menu` VALUES ('13', '2009', '可视化小程序', 'Diyminipro', 'page_edit', '', 'fa fa-code', '0', '1', '100', '1', 'cn', '1667470611', '1667470611');
INSERT INTO `ey_admin_menu` VALUES ('14', '2004018', '留言中心', 'Form', 'index', '', 'iconfont e-biaodanguanli', '0', '1', '100', '1', 'cn', '1677037793', '1677146423');

-- -----------------------------
-- Table structure for `ey_admin_wxlogin`
-- -----------------------------
DROP TABLE IF EXISTS `ey_admin_wxlogin`;
CREATE TABLE `ey_admin_wxlogin` (
  `wx_id` int(11) NOT NULL AUTO_INCREMENT,
  `type` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '1=官方公众号，2=微信应用',
  `admin_id` int(11) NOT NULL DEFAULT '0' COMMENT '用户id',
  `openid` varchar(50) NOT NULL DEFAULT '' COMMENT 'openid',
  `nickname` varchar(100) NOT NULL DEFAULT '' COMMENT '微信昵称',
  `unionid` varchar(200) NOT NULL DEFAULT '' COMMENT 'unionid',
  `headimgurl` varchar(200) NOT NULL DEFAULT '' COMMENT '头像',
  `add_time` int(11) NOT NULL DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`wx_id`) USING BTREE,
  KEY `openid` (`openid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='后台微信登录记录表';


-- -----------------------------
-- Table structure for `ey_anli_content`
-- -----------------------------
DROP TABLE IF EXISTS `ey_anli_content`;
CREATE TABLE `ey_anli_content` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `aid` int(10) DEFAULT '0' COMMENT '文档ID',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  `xinghao` varchar(200) NOT NULL DEFAULT '' COMMENT '产品型号',
  `body` longtext COMMENT '内容',
  PRIMARY KEY (`id`),
  KEY `aid` (`aid`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 COMMENT='附加表';

-- -----------------------------
-- Records of `ey_anli_content`
-- -----------------------------
INSERT INTO `ey_anli_content` VALUES ('1', '3', '1550193208', '1550193208', 'YS-BLM6256', '&lt;p style=&quot;text-align: center;&quot;&gt;&lt;img src=&quot;/uploads/ueditor/20190215/713cd23751c0e7fe62bbf1e5191f2152.png&quot; title=&quot;713cd23751c0e7fe62bbf1e5191f2152.png&quot; alt=&quot;713cd23751c0e7fe62bbf1e5191f2152.png&quot;/&gt;&lt;/p&gt;&lt;p style=&quot;text-align: center;&quot;&gt;这里是案例展示的内容。&lt;/p&gt;');
INSERT INTO `ey_anli_content` VALUES ('2', '4', '1550193197', '1550193197', 'YS-BLM5769', '&lt;p style=&quot;text-align: center;&quot;&gt;&lt;span style=&quot;text-align: center;&quot;&gt;&lt;img src=&quot;/uploads/ueditor/20190215/dee87fce7eb58059bed81a1f7cce81b0.png&quot; title=&quot;dee87fce7eb58059bed81a1f7cce81b0.png&quot; alt=&quot;dee87fce7eb58059bed81a1f7cce81b0.png&quot;/&gt;&lt;/span&gt;&lt;/p&gt;&lt;p style=&quot;text-align: center;&quot;&gt;&lt;span style=&quot;text-align: center;&quot;&gt;这里是案例展示的内容。&lt;/span&gt;&lt;/p&gt;');
INSERT INTO `ey_anli_content` VALUES ('3', '5', '1550193179', '1550193179', 'YS-BLM5616', '&lt;p style=&quot;text-align: center;&quot;&gt;&lt;img src=&quot;/uploads/ueditor/20190215/d345a633a2d6f69507e6881fdf20d568.png&quot; title=&quot;d345a633a2d6f69507e6881fdf20d568.png&quot; alt=&quot;d345a633a2d6f69507e6881fdf20d568.png&quot;/&gt;&lt;/p&gt;&lt;p style=&quot;text-align: center;&quot;&gt;这里是案例展示的内容。&lt;/p&gt;');
INSERT INTO `ey_anli_content` VALUES ('4', '6', '1550193145', '1550193145', 'YS-BLM8649', '&lt;p style=&quot;text-align: center;&quot;&gt;&lt;img src=&quot;/uploads/ueditor/20190215/18f42e633e075f417df9b68df41a072f.png&quot; title=&quot;18f42e633e075f417df9b68df41a072f.png&quot; alt=&quot;18f42e633e075f417df9b68df41a072f.png&quot;/&gt;&lt;/p&gt;&lt;p style=&quot;text-align: center;&quot;&gt;这里是案例展示的内容。&lt;br/&gt;&lt;/p&gt;');

-- -----------------------------
-- Table structure for `ey_appletstyle_content`
-- -----------------------------
DROP TABLE IF EXISTS `ey_appletstyle_content`;
CREATE TABLE `ey_appletstyle_content` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `aid` int(10) DEFAULT '0' COMMENT '文档ID',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  `color` enum('red','blue','golden','black') DEFAULT 'red' COMMENT '背景色',
  PRIMARY KEY (`id`),
  KEY `aid` (`aid`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COMMENT='附加表';

-- -----------------------------
-- Records of `ey_appletstyle_content`
-- -----------------------------
INSERT INTO `ey_appletstyle_content` VALUES ('1', '110', '1666943946', '1666943946', 'black');

-- -----------------------------
-- Table structure for `ey_archives`
-- -----------------------------
DROP TABLE IF EXISTS `ey_archives`;
CREATE TABLE `ey_archives` (
  `aid` int(10) NOT NULL AUTO_INCREMENT,
  `typeid` int(10) NOT NULL DEFAULT '0' COMMENT '当前栏目',
  `stypeid` varchar(90) DEFAULT '' COMMENT '副栏目ID集合',
  `channel` int(10) NOT NULL DEFAULT '0' COMMENT '模型ID',
  `is_b` tinyint(1) DEFAULT '0' COMMENT '加粗',
  `title` varchar(200) DEFAULT '' COMMENT '标题',
  `subtitle` varchar(200) DEFAULT '' COMMENT '副标题',
  `litpic` varchar(250) DEFAULT '' COMMENT '缩略图',
  `is_head` tinyint(1) DEFAULT '0' COMMENT '头条（0=否，1=是）',
  `is_special` tinyint(1) DEFAULT '0' COMMENT '特荐（0=否，1=是）',
  `is_top` tinyint(1) DEFAULT '0' COMMENT '置顶（0=否，1=是）',
  `is_recom` tinyint(1) DEFAULT '0' COMMENT '推荐（0=否，1=是）',
  `is_jump` tinyint(1) DEFAULT '0' COMMENT '跳转链接（0=否，1=是）',
  `is_litpic` tinyint(1) DEFAULT '0' COMMENT '图片（0=否，1=是）',
  `is_roll` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '滚动（0=否，1=是）',
  `is_slide` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '幻灯（0=否，1=是）',
  `is_diyattr` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '自定义（0=否，1=是）',
  `origin` varchar(200) DEFAULT '' COMMENT '来源',
  `author` varchar(200) DEFAULT '' COMMENT '作者',
  `click` int(10) DEFAULT '0' COMMENT '浏览量',
  `arcrank` int(10) DEFAULT '0' COMMENT '阅读权限：0=开放浏览，-1=待审核稿件',
  `jumplinks` varchar(255) DEFAULT '' COMMENT '外链跳转',
  `ismake` tinyint(1) DEFAULT '0' COMMENT '是否静态页面（0=动态，1=静态）',
  `seo_title` varchar(200) DEFAULT '' COMMENT 'SEO标题',
  `seo_keywords` varchar(200) DEFAULT '' COMMENT 'SEO关键词',
  `seo_description` text COMMENT 'SEO描述',
  `attrlist_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '参数列表ID',
  `merchant_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '多商家ID',
  `free_shipping` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '商品是否包邮(1包邮(免运费)  0跟随系统)',
  `users_price` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '会员价',
  `users_free` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否会员免费，默认0不免费，1为免费',
  `old_price` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '产品旧价',
  `sales_num` int(10) NOT NULL DEFAULT '0' COMMENT '总销售量',
  `virtual_sales` int(10) DEFAULT '0' COMMENT '商品虚拟销售量',
  `sales_all` int(10) DEFAULT '0' COMMENT '虚拟总销量',
  `stock_count` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '商品库存量',
  `stock_show` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '商品库存在产品详情页是否显示，1为显示，0为不显示',
  `prom_type` tinyint(1) unsigned DEFAULT '0' COMMENT '产品类型：0=普通产品，1=虚拟(默认手动发货)，2=虚拟(网盘)，3=虚拟(自定义文本) 4-核销',
  `tempview` varchar(200) DEFAULT '' COMMENT '文档模板文件名',
  `status` tinyint(1) DEFAULT '1' COMMENT '状态(0=屏蔽，1=正常)',
  `sort_order` int(10) DEFAULT '0' COMMENT '排序号',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `admin_id` int(10) DEFAULT '0' COMMENT '管理员ID',
  `users_id` int(10) DEFAULT '0' COMMENT '会员ID',
  `arc_level_id` int(10) DEFAULT '0' COMMENT '文档会员权限ID',
  `restric_type` tinyint(1) DEFAULT '0' COMMENT '限制模式，0=免费，1=付费，2=会员专享，3=会员付费',
  `is_del` tinyint(1) DEFAULT '0' COMMENT '伪删除，1=是，0=否',
  `del_method` tinyint(1) DEFAULT '0' COMMENT '伪删除状态，1为主动删除，2为跟随上级栏目被动删除',
  `joinaid` int(10) DEFAULT '0' COMMENT '关联文档ID',
  `downcount` int(10) DEFAULT '0' COMMENT '下载次数',
  `appraise` int(10) DEFAULT '0' COMMENT '评价数',
  `collection` int(10) DEFAULT '0' COMMENT '收藏数',
  `htmlfilename` varchar(500) DEFAULT '' COMMENT '自定义文件名',
  `province_id` int(10) DEFAULT '0' COMMENT '省份',
  `city_id` int(10) DEFAULT '0' COMMENT '所在城市',
  `area_id` int(10) DEFAULT '0' COMMENT '所在区域',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  `no_vip_pay` tinyint(3) DEFAULT '0' COMMENT 'restric_type = 2 时,会员专享,非会员可付费使用,0-关闭,1-开启',
  PRIMARY KEY (`aid`),
  KEY `aid` (`typeid`,`channel`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=41 DEFAULT CHARSET=utf8 COMMENT='资讯表';

-- -----------------------------
-- Records of `ey_archives`
-- -----------------------------
INSERT INTO `ey_archives` VALUES ('1', '1', '', '6', '0', '关于我们', '', '', '0', '0', '0', '0', '0', '1', '0', '0', '0', '', '', '0', '0', '', '0', '', '', '', '0', '0', '0', '0.00', '0', '0.00', '0', '0', '0', '99999', '1', '0', '', '1', '100', 'cn', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1533541630', '1533951919', '0');
INSERT INTO `ey_archives` VALUES ('2', '8', '', '6', '0', '联系我们', '', '', '0', '0', '0', '0', '0', '1', '0', '0', '0', '', '', '0', '0', '', '0', '', '', '', '0', '0', '0', '0.00', '0', '0.00', '0', '0', '0', '99999', '1', '0', '', '1', '100', 'cn', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1533542101', '1533952743', '0');
INSERT INTO `ey_archives` VALUES ('33', '4', '', '1', '0', '挖掘机技术哪个最难?结果你绝对想不到!', '', '/public/upload/article/2018/08/08/440968896e09b835108e5c875e10ed9d.jpg', '0', '0', '0', '0', '0', '1', '0', '0', '0', '', '', '129', '0', '', '0', '', '', '如何鉴别一名机手是老司机还是新手呢？开挖掘机时间长短可不是主要的因素，而操作的手法才是判断的根本。一名新手成长为老司机不仅要不断的努力学习，同时还要经过不同工况的作业锻炼，最后才能步入老司机的行业。在不同的作业中，老司机们普遍认为挖沟难度比较大，然而事实并非如此，砖家为大家列举出6项难度比较大的施工作业，其中最难的可要比挖沟难度高出千百倍，相信有的老司机一定不服，想要挑战一下，别着急看看下文绝对让你心服口服！NO.6：甩土难度指数：甩土算是挖掘机作业里面的基本功了，学徒时师傅第一个教的应该就是这种作业。甩土难度不大，好学容易入手，但是也是需要多加练习的。', '0', '0', '0', '0.00', '0', '0.00', '0', '0', '0', '99999', '1', '0', '', '1', '3', 'cn', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1533701828', '1533701828', '0');
INSERT INTO `ey_archives` VALUES ('32', '9', '', '1', '0', '产品展示八', '', '/public/upload/article/2018/08/08/05d8e4df3da42ceba569bc1923eece00.jpg', '0', '0', '0', '0', '0', '1', '0', '0', '0', '', '', '177', '0', '', '0', '', '', '', '0', '0', '0', '0.00', '0', '0.00', '0', '0', '0', '99999', '1', '0', '', '1', '100', 'cn', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1533700540', '1533700540', '0');
INSERT INTO `ey_archives` VALUES ('31', '9', '', '1', '0', '产品展示七', '', '/public/upload/article/2018/08/08/e7b0152290f11ff755e30a2190401c9e.jpg', '0', '0', '0', '0', '0', '1', '0', '0', '0', '', '', '182', '0', '', '0', '', '', '', '0', '0', '0', '0.00', '0', '0.00', '0', '0', '0', '99999', '1', '0', '', '1', '100', 'cn', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1533700471', '1533700471', '0');
INSERT INTO `ey_archives` VALUES ('30', '9', '', '1', '0', '产品展示六', '', '/public/upload/article/2018/08/08/bed591cb4c51928ebcb6274af599af8c.jpg', '0', '0', '0', '0', '0', '1', '0', '0', '0', '', '', '295', '0', '', '0', '', '', '', '0', '0', '0', '0.00', '0', '0.00', '0', '0', '0', '99999', '1', '0', '', '1', '100', 'cn', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1533700316', '1533700316', '0');
INSERT INTO `ey_archives` VALUES ('29', '9', '', '1', '0', '产品展示五', '', '/public/upload/article/2018/08/08/a6e447aa881fe48a0f50b0141f890688.jpg', '0', '0', '0', '0', '0', '1', '0', '0', '0', '', '', '113', '0', '', '0', '', '', '', '0', '0', '0', '0.00', '0', '0.00', '0', '0', '0', '99999', '1', '0', '', '1', '100', 'cn', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1533700205', '1533700205', '0');
INSERT INTO `ey_archives` VALUES ('28', '9', '', '1', '0', '产品展示四', '', '/public/upload/article/2018/08/08/3660241e6506a9a7348a3533926985e7.jpg', '0', '0', '0', '0', '0', '1', '0', '0', '0', '', '', '262', '0', '', '0', '', '', '', '0', '0', '0', '0.00', '0', '0.00', '0', '0', '0', '99999', '1', '0', '', '1', '100', 'cn', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1533700111', '1533700111', '0');
INSERT INTO `ey_archives` VALUES ('11', '3', '', '1', '0', '天苍苍，野茫茫，挖掘技术哪家强？', '', '', '0', '0', '0', '0', '0', '1', '0', '0', '0', '', '', '254', '0', '', '0', '', '', '补肾、壮阳、补虚、益精血、强筋骨、托疮毒。温肾益精：用于肾阳虚、精血不足所致的畏寒肢冷、阳痿早泄、梦遗滑精、宫冷不孕、小便频数、腰膝酸痛、头晕耳鸣、精神疲乏以及妇女冲任虚寒所致的崩漏带下等。温补内托：用于疮疡久溃不敛、阴疽疮肿内陷不起。1、补虚强身鹿茸的保健功效非常高，是良好的全身强壮药。鹿茸含有比人参更丰富的氨基酸、卵磷脂、维生素和微量元素等。鹿茸性温而不燥，能振奋和提高机体功能，对全身虚弱、久病者，有较好的保健作用。2、提高免疫力鹿茸可以提高机体的细胞免疫和体液免疫功能，促进淋巴细胞的转化，具有免疫促进剂的作用。鹿茸能增加机体对外界的防御能力，调节体内的免疫平衡而避免疾病发生，并能促进创伤愈合、病体康复，从而起到强壮身体，抵抗衰老的作用。3、抗疲劳鹿茸含胶质、蛋白质、钙、铁、锌、铜、铬、锰等丰富的营养，能提高机体功能，改善睡眠和食欲，改善蛋白质和能量代谢，减轻疲劳。', '0', '0', '0', '0.00', '0', '0.00', '0', '0', '0', '99999', '1', '0', '', '1', '4', 'cn', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1533546369', '1533951766', '0');
INSERT INTO `ey_archives` VALUES ('39', '3', '', '1', '0', '双轮振动压路机发动机正常工作但振动不工作的原因', '', '', '0', '0', '0', '0', '0', '1', '0', '0', '0', '', '', '251', '0', '', '0', '', '', '作为厂家售后技术，我们会给客户解决各种各样不同的问题与设备日常使用中的技巧与预防出现问题的技巧。今天讲述一下常见问题：双轮振动压路机出现发动机正常工作，但是振动系统不工作的故障排除与维护。问题：双轮振动压路机发动机正常工作，但振动系统不工作？问题查找与排除技巧：①、发动机飞轮与液压泵输入轴之间的弹性传动盘脱落或损坏，造成动力无法传送到震动泵，就造成振动不工作。②、振动液压马达与振动轴之间的联轴器损坏，导致液压马达的动力无法输入。③、液压油箱缺油了或者吸油过滤器严重堵塞，就会导致液压系统的主回路不能及时的补油。④、液压泵或者马达磨损严重。维护与防止技巧：①、双轮振动压路机在使用的过程中，要按照正确的平稳的的方式去操作。按照不同工程压球正确的调整压路机的静线压力、震动幅度、频率和碾压速度。要经常检查发动机的转速表和振动频率表，更不要随便改装压路机及其配重。②、每次施工前后要及时检查液压系统是否有泄漏、各个零部件的工作情况是否正常和润滑油量是否正常。严格按照维护保养说明来进行保养维护，要保证液压油的清洁剂质量，按时清理各种过滤器的滤网。检查振动系统各部件的零件。', '0', '0', '0', '0.00', '0', '0.00', '0', '0', '0', '99999', '1', '0', '', '1', '5', 'cn', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1533951807', '1533951807', '0');
INSERT INTO `ey_archives` VALUES ('12', '3', '', '1', '0', '赤裸裸戏谑的背后是白领对蓝领阶层的心理歧视', '', '', '0', '0', '0', '0', '0', '1', '0', '0', '0', '', '', '129', '0', '', '0', '', '', '市场上最常见的鹿茸   鹿茸分等十分复杂，梅花鹿茸的“二杠茸”及“三岔茸”均各分四等；马鹿茸分五个等级，很烦琐，不再叙述。   鹿茸的分枝越多，则骨化越重，质量越差。“三岔茸”远不及“二杠茸”，价格亦相差很大。“二茬茸”质量亦没有“头茬茸”好。初生茸：尚没有分支的茸。长25～30厘米，直径2～3厘米。圆柱形，外皮红棕色至棕色，密生黄棕色或浅灰色细毛茸。全枝常显骨化。鹿茸壮阳效果好么-温肾壮阳的血肉有情之品   鹿茸味甘、咸，性温。具有补肾阳，益精血，强筋骨，调冲任，托疮毒的功效。古代有许多名医十分推崇鹿茸的补养作用，李时珍称鹿茸“生精补髓，养血益阳，强筋健骨，治一切虚损，耳聋目暗，目眩运(晕)虚痢”。久服耐老。现在一般用于以下病证。   1．肾阳虚衰，精血不足证症状见畏寒肢冷，阴痿早泄，宫冷不孕，小便频数，腰膝酸软，头晕耳鸣，精神疲乏，虚汗盗汗等，常单味鹿茸浸泡酒饮；或配伍人参、山药、山茱萸等药浸酒，或制丸服。   2．肾虚骨弱。腰膝无力', '0', '0', '0', '0.00', '0', '0.00', '0', '0', '0', '99999', '1', '0', '', '1', '3', 'cn', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1533546479', '1533952320', '0');
INSERT INTO `ey_archives` VALUES ('13', '3', '', '1', '0', '“学挖掘机技术哪家强？”为啥火起来了？', '', '', '0', '0', '0', '0', '0', '1', '0', '0', '0', '', '', '254', '0', '', '0', '', '', '一般挖掘机学校毕业的学生，如果没什么关系只能去比较苦的矿上，混到建筑道路这种环境较好的工地比较难。有很多技校毕业的学生毕业后仍然会找师傅再带一段时间，这样不仅能再磨练一下技术，还能顺便寻个比较好的工作。', '0', '0', '0', '0.00', '0', '0.00', '0', '0', '0', '99999', '1', '0', '', '1', '2', 'cn', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1533547487', '1533711787', '0');
INSERT INTO `ey_archives` VALUES ('14', '3', '', '1', '0', '挖掘机培训学校', '', '/public/upload/article/2018/08/08/b68c9c83aaab7ea4e35ab9a401998db4.jpg', '0', '0', '0', '0', '0', '1', '0', '0', '0', '', '', '107', '0', '', '0', '', '', '现在学习挖掘机的职业技术很多，大家听得最多的就是蓝翔，网友戏称“皇家布鲁塞特大学”（blue shit 的音译）, 除此之外各地都有当地的培训学校。在培训学校能够学到完善的理论知识和较全面的操作技术，但是由于培训时间普遍比较短，导致学员的实际操作水平有限。', '0', '0', '0', '0.00', '0', '0.00', '0', '0', '0', '99999', '1', '0', '', '1', '1', 'cn', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1533547565', '1533711722', '0');
INSERT INTO `ey_archives` VALUES ('36', '6', '', '1', '0', '成功案例三', '', '/public/upload/article/2018/08/08/ed9e5d0f6fbc4edd1df0771bbe12a6ad.jpg', '0', '0', '0', '0', '0', '1', '0', '0', '0', '', '', '171', '0', '', '0', '', '', '蓝翔的火，在于它已然成为段子手们撸出茧的梗。“挖掘机到底哪家强?中国山东找蓝翔”，是许多故事进阶为段子的标配式结局。不管这故事是言情的、玄幻的、恐怖的，在结尾来上这么一句，都能在剧情跳跃和翻转中，迎来喜剧性效果。而“蓝翔”二字对舆论嗨点的引爆作用，最终也能兑换为段子的传播广度。', '0', '0', '0', '0.00', '0', '0.00', '0', '0', '0', '99999', '1', '0', '', '1', '100', 'cn', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1533713680', '1533713680', '0');
INSERT INTO `ey_archives` VALUES ('15', '5', '', '1', '0', '资质荣誉1', '', '/public/upload/article/2018/08/09/6bd63d11c3dea067952c74d6540e090f.jpg', '0', '0', '0', '0', '0', '1', '0', '0', '0', '', '', '153', '0', '', '0', '', '', '', '0', '0', '0', '0.00', '0', '0.00', '0', '0', '0', '99999', '1', '0', '', '1', '100', 'cn', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1533550487', '1533798391', '0');
INSERT INTO `ey_archives` VALUES ('16', '5', '', '1', '0', '资质荣誉2', '', '/public/upload/article/2018/08/09/0f2c1787f7721d3d5e2950e141a232f4.jpg', '0', '0', '0', '0', '0', '1', '0', '0', '0', '', '', '249', '0', '', '0', '', '', '', '0', '0', '0', '0.00', '0', '0.00', '0', '0', '0', '99999', '1', '0', '', '1', '100', 'cn', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1533550542', '1533798351', '0');
INSERT INTO `ey_archives` VALUES ('17', '4', '', '1', '0', '技术服务', '', '/public/upload/article/2018/08/08/306618c4fb0cf8c2c494bd823998f0f3.jpg', '0', '0', '0', '0', '0', '1', '0', '0', '0', '', '', '172', '0', '', '0', '', '', '市场上最常见的鹿茸   鹿茸分等十分复杂，梅花鹿茸的“二杠茸”及“三岔茸”均各分四等；马鹿茸分五个等级，很烦琐，不再叙述。   鹿茸的分枝越多，则骨化越重，质量越差。“三岔茸”远不及“二杠茸”，价格亦相差很大。“二茬茸”质量亦没有“头茬茸”好。初生茸：尚没有分支的茸。长25～30厘米，直径2～3厘米。圆柱形，外皮红棕色至棕色，密生黄棕色或浅灰色细毛茸。全枝常显骨化。鹿茸壮阳效果好么-温肾壮阳的血肉有情之品   鹿茸味甘、咸，性温。具有补肾阳，益精血，强筋骨，调冲任，托疮毒的功效。古代有许多名医十分推崇鹿茸的补养作用，李时珍称鹿茸“生精补髓，养血益阳，强筋健骨，治一切虚损，耳聋目暗，目眩运(晕)虚痢”。久服耐老。现在一般用于以下病证。   1．肾阳虚衰，精血不足证症状见畏寒肢冷，阴痿早泄，宫冷不孕，小便频数，腰膝酸软，头晕耳鸣，精神疲乏，虚汗盗汗等，常单味鹿茸浸泡酒饮；或配伍人参、山药、山茱萸等药浸酒，或制丸服。   2．肾虚骨弱。腰膝无力', '0', '0', '0', '0.00', '0', '0.00', '0', '0', '0', '99999', '1', '0', '', '1', '4', 'cn', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1533614969', '1533701422', '0');
INSERT INTO `ey_archives` VALUES ('27', '9', '', '1', '0', '产品展示三', '', '/public/upload/article/2018/08/08/9b79e3c544bb7edc32b6e027d1bb1121.jpg', '0', '0', '0', '0', '0', '1', '0', '0', '0', '', '', '153', '0', '', '0', '', '', '', '0', '0', '0', '0.00', '0', '0.00', '0', '0', '0', '99999', '1', '0', '', '1', '100', 'cn', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1533700080', '1533700080', '0');
INSERT INTO `ey_archives` VALUES ('26', '9', '', '1', '0', '产品展示二', '', '/public/upload/article/2018/08/08/4943ef898f7059b0a4737e5f4df1b470.jpg', '0', '0', '0', '0', '0', '1', '0', '0', '0', '', '', '126', '0', '', '0', '', '', '', '0', '0', '0', '0.00', '0', '0.00', '0', '0', '0', '99999', '1', '0', '', '1', '100', 'cn', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1533700047', '1533700047', '0');
INSERT INTO `ey_archives` VALUES ('25', '9', '', '1', '0', '产品标题一', '', '/public/upload/article/2018/08/08/cf0605e2c22b73220689fddf60c832da.jpg', '0', '0', '0', '0', '0', '1', '0', '0', '0', '', '', '166', '0', '', '0', '', '', '', '0', '0', '0', '0.00', '0', '0.00', '0', '0', '0', '99999', '1', '0', '', '1', '100', 'cn', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1533699860', '1533699860', '0');
INSERT INTO `ey_archives` VALUES ('24', '5', '', '1', '0', '荣誉资质3', '', '/public/upload/article/2018/08/09/7a9d2a6ce6d5fd75bfee68c933e35ccd.jpg', '0', '0', '0', '0', '0', '1', '0', '0', '0', '', '', '128', '0', '', '0', '', '', ' ', '0', '0', '0', '0.00', '0', '0.00', '0', '0', '0', '99999', '1', '0', '', '1', '100', 'cn', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1533628235', '1533798304', '0');
INSERT INTO `ey_archives` VALUES ('22', '6', '', '1', '0', '成功案例二', '', '/public/upload/article/2018/08/08/2353a7fbb821113d799596630a7ae536.jpg', '0', '0', '0', '0', '0', '1', '0', '0', '0', '', '', '153', '0', '', '0', '', '', '蓝翔，又名“布鲁弗莱”或“不撸谢特”，全名是山东蓝翔高级技工学校。虽是技校，可究其风头，在国内学校中罕有媲迹者，甚至可秒杀清华北大。虽然北方名校“纽伊斯特(NewEast)”，在江湖上与其齐名，可它充其量也只是“南慕容，北乔峰”式类比，名为技校“双子星”，实力却不在一个量级上。蓝翔的火，在于它已然成为段子手们撸出茧的梗。“挖掘机到底哪家强?中国山东找蓝翔”，是许多故事进阶为段子的标配式结局。不管这故事是言情的、玄幻的、恐怖的，在结尾来上这么一句，都能在剧情跳跃和翻转中，迎来喜剧性效果。而“蓝翔”二字对舆论嗨点的引爆作用，最终也能兑换为段子的传播广度。', '0', '0', '0', '0.00', '0', '0.00', '0', '0', '0', '99999', '1', '0', '', '1', '100', 'cn', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1533627969', '1533713674', '0');
INSERT INTO `ey_archives` VALUES ('23', '6', '', '1', '0', '成功案例一', '', '/public/upload/article/2018/08/08/239c319baa1b6ddec60b92c7f18a1f80.jpg', '0', '0', '0', '0', '0', '1', '0', '0', '0', '', '', '251', '0', '', '0', '', '', '不过这种方式也存在很多弊病：有的师傅可能只教某几个技术，徒弟学到的驾驶技术比较单一，后面工作中仍要不断学习；有些师傅的不良习惯也很容易遗传给徒弟；另外由于不是专业老师，学徒经常会受到师傅的歧视、冷暴力、刁难等行为。', '0', '0', '0', '0.00', '0', '0.00', '0', '0', '0', '99999', '1', '0', '', '1', '100', 'cn', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1533628002', '1533713625', '0');
INSERT INTO `ey_archives` VALUES ('34', '4', '', '1', '0', '除了去蓝翔,我该如何学习开挖掘机?', '', '/public/upload/article/2018/08/08/b1100157ee6b9e9fe0eca442f8b1d787.jpg', '0', '0', '0', '0', '0', '1', '0', '0', '0', '', '', '285', '0', '', '0', '', '', '根据我们调查来看，挖掘机学习途径大体上分为三类：师徒式学习、职业技术学校学习、自学成才。这三种学习方式各有优劣、不同体系下出来的学员水平也不一样。常见三种途径：师徒+技校+自学1.师傅带徒弟：在国内大多数挖掘机司机都是通过师傅带徒弟、徒弟一边学一边做工程这种方式培养出来的。这种方式让徒弟在耳濡目染中学到师傅的良好技术，徒弟的实际操作经验增长很快；而且在这种半工半学的工程中不仅学到了挖掘机技术，更重要的是与当地的工头接触较多，有利于出师后单干。另外由于这种方式是半工半学，基本上前面几个月花点钱，后面徒弟能够独立干台班后就不用给师傅钱了，相对去技校的成本很低。', '0', '0', '0', '0.00', '0', '0.00', '0', '0', '0', '99999', '1', '0', '', '1', '2', 'cn', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1533702036', '1533702036', '0');
INSERT INTO `ey_archives` VALUES ('35', '4', '', '1', '0', '是极大推崇职业教育的成果依然不显著', '', '/public/upload/article/2018/08/08/75c97a27229a1156ff17707a06773210.jpg', '0', '0', '0', '0', '0', '1', '0', '0', '0', '', '', '264', '0', '', '0', '', '', '一是娱乐精神过头，人格形象裂变。互联网每年都有那么一两次网民狂欢。恶搞黑人是网民的一贯做法，体现了包容、共融、参与的网络精神。然而大众娱乐没错，偶尔全民狂欢也有喜感。但是娱乐但不能心藏龌龊，肆意揭发他人短处，晾晒他人的弱势。况且如果学校和个人有违法行为，法律自会处置。如今流言蜚语的舆论审判代替了司法审批，道德攻击替代了法律惩戒。二是将“黑”进行到底是道德优越感作怪。此次网民狂欢由部分大学生领衔，不少所谓公知凑热闹赚曝光度也堂而皇之拿人开涮。不少本科生嘲笑蓝翔技工学校，甚至把清华大学与它同时放置于大众目光焦烤。正牌军与野鸡大学的比对，狭隘的价值观驱使下，学历优越感和道德优越感无限扩大。三是赤裸裸戏谑的背后是白领对蓝领阶层的心理歧视。这种歧视，有对社会分工的不解，有对收入的极差的非议，有对劳动时间与劳动效率的不匹配的抵触。实际上拥有挖掘机技术非高大上所能形容，他们的工资岂是我们想象的到?年薪高的让我等这些小白领只能仰望天空。故而歧视便心安理得起来。此外，如此大规模高级黑“技工”，宣告这几年国家高等教育体质改革特别是极大推崇职业教育的成果依然不显著。职业教育登不上大雅之堂的就业理念依然占据主', '0', '0', '0', '0.00', '0', '0.00', '0', '0', '0', '99999', '1', '0', '', '1', '1', 'cn', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1533710663', '1533951702', '0');
INSERT INTO `ey_archives` VALUES ('37', '6', '', '1', '0', '成功案例四', '', '/public/upload/article/2018/08/08/bcbe2706a9649904b387e9b50c8ac4c0.jpg', '0', '0', '0', '0', '0', '1', '0', '0', '0', '', '', '175', '0', '', '0', '', '', '有人归结为其24年没变过的广告语——“挖掘机哪家强?中国山东找蓝翔”。它气势雄浑，语调铿锵，最重要的是简单粗暴。在其广告的狂轰乱炸之下，很多人如今再听到这话时，总会自然而然地脑补起唐国强竖大拇指的场景。这就像濡染多了神曲《小苹果》后，再听到“你是我的……”时，会本能地续上“小呀小苹果”一样。尽管NewEast的“遇到新东方厨师就嫁了吧”，也习得此道，但气场上终究逊了一筹。', '0', '0', '0', '0.00', '0', '0.00', '0', '0', '0', '99999', '1', '0', '', '1', '100', 'cn', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1533713770', '1533713770', '0');
INSERT INTO `ey_archives` VALUES ('38', '4', '', '1', '0', '日本６月核心机械订货连续第二个月下降', '', '', '0', '0', '0', '0', '0', '1', '0', '0', '0', '', '', '108', '0', '', '0', '', '', '数据显示，６月份核心机械订货额约为８２７６亿日元，环比下降８．８％。其中，制造业订货额为３８１８亿日元，环比下降１５．９％；非制造业订货额为４４５４亿日元，环比下降７．０％。包括政府和公共机构需求以及外需等在内的６月份机械订货总额为２．２１３９万亿日元，环比减少１４．４％。　　日本内阁府将对机械订货基本情况的判断从“正在复苏”下调至“复苏动向中可见停滞迹象”，这是内阁府时隔一年多来首次下调机械订货基本情况判断。　　数据还显示，经季节调整后的二季度日本核心机械订货额为２．６７８６万亿日元，比上一季度增加２．２％，连续４个季度增加。二季度机械订货总额为７．３０９４万亿日元，环比增加２．６％。　　日本机械订货统计数据基于日本政府对国内２８０家生产企业的调查统计结果，反映日本企业今后６至９个月的设备投资动向，是日本民间设备投资的重要先行指标。', '0', '0', '0', '0.00', '0', '0.00', '0', '0', '0', '99999', '1', '0', '', '1', '5', 'cn', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1533951683', '1533951683', '0');
INSERT INTO `ey_archives` VALUES ('40', '10', '', '1', '0', '产品展示九', '', '/public/upload/article/2018/08/11/a7464699cd881373d8791dfc764c3089.jpg', '0', '0', '0', '0', '0', '1', '0', '0', '0', '', '', '298', '0', '', '0', '', '', '', '0', '0', '0', '0.00', '0', '0.00', '0', '0', '0', '99999', '1', '0', '', '1', '100', 'cn', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1533952460', '1533952460', '0');

-- -----------------------------
-- Table structure for `ey_archives_flag`
-- -----------------------------
DROP TABLE IF EXISTS `ey_archives_flag`;
CREATE TABLE `ey_archives_flag` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `flag_name` varchar(255) NOT NULL DEFAULT '' COMMENT '文档属性名称',
  `flag_attr` varchar(10) NOT NULL DEFAULT '' COMMENT '属性值',
  `flag_fieldname` varchar(255) NOT NULL DEFAULT '' COMMENT '字段名',
  `status` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '状态， 1---显示， 0---隐藏',
  `sort_order` int(11) unsigned NOT NULL DEFAULT '0',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`),
  UNIQUE KEY `flag_attr` (`flag_attr`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=10 DEFAULT CHARSET=utf8 COMMENT='文档属性配置表';

-- -----------------------------
-- Records of `ey_archives_flag`
-- -----------------------------
INSERT INTO `ey_archives_flag` VALUES ('1', '头条', 'h', 'is_head', '1', '1', 'cn', '1606272350', '1606272350');
INSERT INTO `ey_archives_flag` VALUES ('2', '推荐', 'c', 'is_recom', '1', '2', 'cn', '1606272350', '1606272350');
INSERT INTO `ey_archives_flag` VALUES ('3', '加推', 'a', 'is_special', '1', '3', 'cn', '1606272350', '1606272350');
INSERT INTO `ey_archives_flag` VALUES ('4', '标粗', 'b', 'is_b', '1', '4', 'cn', '1606272350', '1606272350');
INSERT INTO `ey_archives_flag` VALUES ('5', '有图', 'p', 'is_litpic', '1', '5', 'cn', '1606272350', '1606272350');
INSERT INTO `ey_archives_flag` VALUES ('6', '外链', 'j', 'is_jump', '1', '6', 'cn', '1606272350', '1606272350');
INSERT INTO `ey_archives_flag` VALUES ('7', '轮播', 's', 'is_slide', '0', '7', 'cn', '1606272350', '1606272350');
INSERT INTO `ey_archives_flag` VALUES ('8', '滚动', 'r', 'is_roll', '0', '8', 'cn', '1606272350', '1606272350');
INSERT INTO `ey_archives_flag` VALUES ('9', '热文', 'd', 'is_diyattr', '0', '9', 'cn', '1606272350', '1606272350');

-- -----------------------------
-- Table structure for `ey_arcmulti`
-- -----------------------------
DROP TABLE IF EXISTS `ey_arcmulti`;
CREATE TABLE `ey_arcmulti` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `tagid` varchar(60) NOT NULL DEFAULT '' COMMENT '标签ID',
  `tagname` varchar(60) NOT NULL DEFAULT '' COMMENT '标签名',
  `innertext` text NOT NULL COMMENT '标签模板代码',
  `pagesize` int(10) NOT NULL DEFAULT '0' COMMENT '分页列表',
  `querysql` text NOT NULL COMMENT '完整SQL',
  `ordersql` varchar(200) DEFAULT '' COMMENT '排序SQL',
  `addfieldsSql` varchar(255) DEFAULT '' COMMENT '附加字段SQL',
  `addtableName` varchar(50) DEFAULT '' COMMENT '附加字段的数据表，不包含表前缀',
  `attstr` text COMMENT '属性字符串',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='多页标记存储数据表';


-- -----------------------------
-- Table structure for `ey_arcrank`
-- -----------------------------
DROP TABLE IF EXISTS `ey_arcrank`;
CREATE TABLE `ey_arcrank` (
  `id` smallint(5) unsigned NOT NULL AUTO_INCREMENT COMMENT '权限ID',
  `rank` smallint(6) DEFAULT '0' COMMENT '权限值',
  `name` char(20) DEFAULT '' COMMENT '会员名称',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='文档阅读权限表';

-- -----------------------------
-- Records of `ey_arcrank`
-- -----------------------------
INSERT INTO `ey_arcrank` VALUES ('1', '0', '开放浏览', 'cn', '0', '1552376880');
INSERT INTO `ey_arcrank` VALUES ('2', '-1', '待审核稿件', 'cn', '0', '1552376880');

-- -----------------------------
-- Table structure for `ey_arctype`
-- -----------------------------
DROP TABLE IF EXISTS `ey_arctype`;
CREATE TABLE `ey_arctype` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `channeltype` int(10) DEFAULT '0' COMMENT '栏目顶级模型ID',
  `current_channel` int(10) DEFAULT '0' COMMENT '栏目当前模型ID',
  `parent_id` int(10) DEFAULT '0' COMMENT '栏目上级ID',
  `topid` int(10) DEFAULT '0' COMMENT '顶级栏目ID',
  `typename` varchar(200) DEFAULT '' COMMENT '栏目名称',
  `dirname` varchar(200) DEFAULT '' COMMENT '目录英文名',
  `dirpath` varchar(200) DEFAULT '' COMMENT '目录存放HTML路径',
  `diy_dirpath` varchar(200) DEFAULT '' COMMENT '列表静态文件存放规则',
  `rulelist` varchar(200) DEFAULT '' COMMENT '列表静态文件存放规则',
  `ruleview` varchar(200) DEFAULT '' COMMENT '文档静态文件存放规则',
  `englist_name` varchar(200) DEFAULT '' COMMENT '栏目英文名',
  `grade` tinyint(1) DEFAULT '0' COMMENT '栏目等级',
  `typelink` varchar(200) DEFAULT '' COMMENT '栏目链接',
  `litpic` varchar(250) DEFAULT '' COMMENT '栏目图片',
  `templist` varchar(200) DEFAULT '' COMMENT '列表模板文件名',
  `tempview` varchar(200) DEFAULT '' COMMENT '文档模板文件名',
  `seo_title` varchar(200) DEFAULT '' COMMENT 'SEO标题',
  `seo_keywords` varchar(200) DEFAULT '' COMMENT 'seo关键字',
  `seo_description` text COMMENT 'seo描述',
  `sort_order` int(10) DEFAULT '0' COMMENT '排序号',
  `is_hidden` tinyint(1) DEFAULT '0' COMMENT '是否隐藏栏目：0=显示，1=隐藏',
  `is_part` tinyint(1) DEFAULT '0' COMMENT '栏目属性：0=内容栏目，1=外部链接',
  `admin_id` int(10) DEFAULT '0' COMMENT '管理员ID',
  `is_del` tinyint(1) DEFAULT '0' COMMENT '伪删除，1=是，0=否',
  `del_method` tinyint(1) DEFAULT '0' COMMENT '伪删除状态，1为主动删除，2为跟随上级栏目被动删除',
  `status` tinyint(1) DEFAULT '1' COMMENT '启用 (1=正常，0=屏蔽)',
  `is_release` tinyint(1) DEFAULT '0' COMMENT '栏目是否应用于会员投稿发布，1是，0否',
  `weapp_code` varchar(50) DEFAULT '' COMMENT '插件栏目唯一标识',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  `target` tinyint(1) DEFAULT '0' COMMENT '新窗口打开',
  `nofollow` tinyint(1) DEFAULT '0' COMMENT '防抓取',
  `typearcrank` int(10) DEFAULT '0' COMMENT '阅读权限：0=开放浏览，-1=待审核稿件',
  `empty_logic` tinyint(1) DEFAULT '0' COMMENT '空内容逻辑',
  PRIMARY KEY (`id`),
  UNIQUE KEY `dirname` (`dirname`,`lang`) USING BTREE,
  KEY `parent_id` (`channeltype`,`parent_id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=19 DEFAULT CHARSET=utf8;

-- -----------------------------
-- Records of `ey_arctype`
-- -----------------------------
INSERT INTO `ey_arctype` VALUES ('1', '6', '6', '0', '0', '关于我们', 'guanyuwomen', '/guanyuwomen', '/guanyuwomen', '', '', 'ABOUT US', '0', '', '', 'lists_single.htm', '', '', '', '', '1', '0', '0', '0', '0', '0', '1', '0', '', 'cn', '1533541630', '1651223514', '0', '0', '0', '1');
INSERT INTO `ey_arctype` VALUES ('2', '1', '1', '0', '0', '产品展示', 'chanpinzhanshi', '/chanpinzhanshi', '/chanpinzhanshi', '', '', 'PRODUCT SHOW', '0', '', '', 'lists_article_product.htm', 'view_article.htm', '', '', '', '2', '0', '0', '0', '0', '0', '1', '1', '', 'cn', '1533541671', '1651223514', '0', '0', '0', '0');
INSERT INTO `ey_arctype` VALUES ('3', '1', '1', '0', '0', '新闻资讯', 'xinwenzixun', '/xinwenzixun', '/xinwenzixun', '', '', 'NEWS CENTER', '0', '', '', 'lists_article.htm', 'view_article.htm', '', '', '', '3', '0', '0', '0', '0', '0', '1', '1', '', 'cn', '1533541713', '1651223514', '0', '0', '0', '0');
INSERT INTO `ey_arctype` VALUES ('4', '1', '1', '0', '0', '技术支持', 'jishuzhichi', '/jishuzhichi', '/jishuzhichi', '', '', 'SUPPORT', '0', '', '/public/upload/arctype/2018/08/08/202de842af2c66f65249c453dab4ad8d.jpg', 'lists_article.htm', 'view_article.htm', '', '', '', '4', '0', '0', '0', '0', '0', '1', '1', '', 'cn', '1533541787', '1651223514', '0', '0', '0', '0');
INSERT INTO `ey_arctype` VALUES ('5', '1', '1', '0', '0', '资质荣誉', 'zizhirongyu', '/zizhirongyu', '/zizhirongyu', '', '', 'HONOR', '0', '', '', 'lists_article_product.htm', 'view_article.htm', '', '', '', '5', '0', '0', '0', '0', '0', '1', '1', '', 'cn', '1533541838', '1651223514', '0', '0', '0', '0');
INSERT INTO `ey_arctype` VALUES ('6', '1', '1', '0', '0', '成功案列', 'chenggonganli', '/chenggonganli', '/chenggonganli', '', '', 'CASE CENTER', '0', '', '', 'lists_article_product.htm', 'view_article.htm', '', '', '', '6', '0', '0', '0', '0', '0', '1', '1', '', 'cn', '1533541928', '1651223514', '0', '0', '0', '0');
INSERT INTO `ey_arctype` VALUES ('7', '8', '8', '0', '0', '在线留言', 'zaixianliuyan', '/zaixianliuyan', '/zaixianliuyan', '', '', 'Message', '0', '', '', 'lists_guestbook.htm', '', '', '', '', '7', '0', '0', '0', '0', '0', '1', '0', '', 'cn', '1533542038', '1651223514', '0', '0', '0', '0');
INSERT INTO `ey_arctype` VALUES ('8', '6', '6', '0', '0', '联系我们', 'lianxiwomen', '/lianxiwomen', '/lianxiwomen', '', '', 'CONTACT US', '0', '', '', 'lists_single.htm', '', '', '', '', '8', '0', '0', '0', '0', '0', '1', '0', '', 'cn', '1533542101', '1686204361', '0', '0', '0', '1');
INSERT INTO `ey_arctype` VALUES ('9', '1', '1', '2', '2', '产品分类1', 'chanpinfenlei1', '/chanpinzhanshi/chanpinfenlei1', '/chanpinzhanshi/chanpinfenlei1', '', '', '', '1', '', '/public/upload/arctype/2018/08/07/cd957aaf601721ab74a76b7bc0663347.jpg', 'lists_article_product.htm', 'view_article.htm', '', '', '', '100', '0', '0', '0', '0', '0', '1', '1', '', 'cn', '1533544954', '1651223514', '0', '0', '0', '0');
INSERT INTO `ey_arctype` VALUES ('10', '1', '1', '2', '2', '产品分类2', 'chanpinfenlei2', '/chanpinzhanshi/chanpinfenlei2', '/chanpinzhanshi/chanpinfenlei2', '', '', '', '1', '', '/public/upload/arctype/2018/08/07/1767ca4397a978f9fd654c883250a21e.jpg', 'lists_article_product.htm', 'view_article.htm', '', '', '', '100', '0', '0', '0', '0', '0', '1', '1', '', 'cn', '1533544988', '1651223514', '0', '0', '0', '0');
INSERT INTO `ey_arctype` VALUES ('11', '1', '1', '2', '2', '产品分类3', 'chanpinfenlei3', '/chanpinzhanshi/chanpinfenlei3', '/chanpinzhanshi/chanpinfenlei3', '', '', '', '1', '', '/public/upload/arctype/2018/08/07/8678626bf00d8ba476e064885b35d57b.jpg', 'lists_article_product.htm', 'view_article.htm', '', '', '', '100', '0', '0', '0', '0', '0', '1', '1', '', 'cn', '1533545013', '1651223514', '0', '0', '0', '0');
INSERT INTO `ey_arctype` VALUES ('12', '1', '1', '2', '2', '产品分类4', 'chanpinfenlei4', '/chanpinzhanshi/chanpinfenlei4', '/chanpinzhanshi/chanpinfenlei4', '', '', '', '1', '', '/public/upload/arctype/2018/08/07/4c9d49cb37217afb022a3b5ce4cb0ef9.jpg', 'lists_article_product.htm', 'view_article.htm', '', '', '', '100', '0', '0', '0', '0', '0', '1', '1', '', 'cn', '1533545041', '1651223514', '0', '0', '0', '0');
INSERT INTO `ey_arctype` VALUES ('13', '1', '1', '2', '2', '产品分类5', 'chanpinfenlei5', '/chanpinzhanshi/chanpinfenlei5', '/chanpinzhanshi/chanpinfenlei5', '', '', '', '1', '', '', 'lists_article_product.htm', 'view_article.htm', '', '', '', '100', '0', '0', '0', '0', '0', '1', '1', '', 'cn', '1533699631', '1651223514', '0', '0', '0', '0');
INSERT INTO `ey_arctype` VALUES ('14', '1', '1', '2', '2', '产品分类6', 'chanpinfenlei6', '/chanpinzhanshi/chanpinfenlei6', '/chanpinzhanshi/chanpinfenlei6', '', '', '', '1', '', '', 'lists_article_product.htm', 'view_article.htm', '', '', '', '100', '0', '0', '0', '0', '0', '1', '1', '', 'cn', '1533699676', '1651223514', '0', '0', '0', '0');
INSERT INTO `ey_arctype` VALUES ('15', '1', '1', '2', '2', '产品分类7', 'chanpinfenlei7', '/chanpinzhanshi/chanpinfenlei7', '/chanpinzhanshi/chanpinfenlei7', '', '', '', '1', '', '', 'lists_article_product.htm', 'view_article.htm', '', '', '', '100', '0', '0', '0', '0', '0', '1', '1', '', 'cn', '1533699711', '1651223514', '0', '0', '0', '0');
INSERT INTO `ey_arctype` VALUES ('16', '1', '1', '2', '2', '产品分类9', 'chanpinfenlei9', '/chanpinzhanshi/chanpinfenlei9', '/chanpinzhanshi/chanpinfenlei9', '', '', '', '1', '', '', 'lists_article_product.htm', 'view_article.htm', '', '', '', '100', '0', '0', '0', '0', '0', '1', '1', '', 'cn', '1533699730', '1651223514', '0', '0', '0', '0');
INSERT INTO `ey_arctype` VALUES ('17', '1', '1', '2', '2', '产品分类10', 'chanpinfenlei10', '/chanpinzhanshi/chanpinfenlei10', '/chanpinzhanshi/chanpinfenlei10', '', '', '', '1', '', '', 'lists_article_product.htm', 'view_article.htm', '', '', '', '100', '0', '0', '0', '0', '0', '1', '1', '', 'cn', '1533699744', '1651223514', '0', '0', '0', '0');

-- -----------------------------
-- Table structure for `ey_article17_content`
-- -----------------------------
DROP TABLE IF EXISTS `ey_article17_content`;
CREATE TABLE `ey_article17_content` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `aid` int(10) DEFAULT '0' COMMENT '文档ID',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  `content` longtext COMMENT '文章内容',
  `vrdz` varchar(251) NOT NULL DEFAULT '' COMMENT '全景地址',
  PRIMARY KEY (`id`),
  KEY `aid` (`aid`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=9 DEFAULT CHARSET=utf8 COMMENT='附加表';

-- -----------------------------
-- Records of `ey_article17_content`
-- -----------------------------
INSERT INTO `ey_article17_content` VALUES ('1', '34', '1649299290', '1649299290', '富力湾海南富力湾与夏威夷、加勒比海、巴厘岛这些世界著名的旅游胜地同在一条黄金北纬18&amp;deg;上，是富力集团在海南布局的唯一一个高端热带滨海休闲度假社区，且紧邻亚洲大型海洋主题公园-富力湾海洋欢乐世界，轻松享有休闲惬意的度假生活。', 'https://720yun.com/t/83vkuwrw01w?scene_id=40544503');
INSERT INTO `ey_article17_content` VALUES ('2', '35', '1649299290', '1649299290', '合景汀澜海岸凝萃合景泰富17年国际豪宅开发经验而倾力打造的旅游地产新作，抢占国际旅游岛未来高端的珍珠海岸核心区位，荟萃众多奢侈度假配套。更携手大师团队定制一线海幕豪宅，在这里找到如塞舌尔般的私密海岸天堂。', 'https://720yun.com/t/80vkc72wdpe?scene_id=64311939');
INSERT INTO `ey_article17_content` VALUES ('3', '36', '1649299290', '1649299290', '&amp;ldquo;海棠华着&amp;rdquo;位于中国三亚海棠湾-中国国家海岸，三亚海棠湾海棠北路18号（凯宾斯基酒店旁），项目占地面积为29.3万平米，容积率0.4，绿化率62.2%，地上建筑面积约12万平米，一共分为三期开发，一期为174套别墅产品，主力户型为约300-400平米（使用面积）的院落别墅户型，是三亚一线临海别墅群，配建拥有百年历史的华尔道夫酒店，该酒店素有&amp;ldquo;总统行宫&amp;rdquo;的称号。', 'https://720yun.com/t/58vkc72l5iq?scene_id=64260374');
INSERT INTO `ey_article17_content` VALUES ('4', '37', '1649299290', '1649299290', '融创日月湾，拥有目前海南的北纬 18&amp;deg;绝品度假双岛。日月湾旅游度假区总规划面积约3.45万亩，，日月岛合计约 1492 亩，其中日岛约 840亩，总建筑面积约 76 万㎡，建筑密度 16.5%，绿化率高达 52%。从日月湾高速出口至项目1500米路程，途经滨海大道，可以一览日月湾迷人的滨海风光。经过与陆地连接的日岛跨海大桥，可以领略别样的海岛风情。&amp;nbsp;', 'https://720yun.com/t/83vkuwrw01w?scene_id=40544503');
INSERT INTO `ey_article17_content` VALUES ('5', '38', '1649299290', '1649299290', '臻园一期&amp;bull;洋房概况：前期共推出108套洋房，总高6层，一梯两户，建筑面积75平，2房2厅一厨一卫两阳台，得房率高，性价比高。板楼设计，通透户型，双阳台设计，带品质精装，满足你的度假、投资的双重需求。海南第一个温泉度假区，东南亚异域风情小镇，侨乡之城，享受成熟的商业配套和淳朴的小镇风情。', 'https://720yun.com/t/3fvkumqh5ib?scene_id=42183767');
INSERT INTO `ey_article17_content` VALUES ('6', '39', '1649299290', '1649299290', '万科海上大都会左岸项目位于三亚市城央湾区三亚湾，南临20公里椰梦长廊，步行200米即可畅享沙滩大海。三亚湾路和新城路围绕在项目南北两侧，与三亚市核心干道凤凰路、规划核心干道三横路毗邻。导航距离凤凰机场约6公里，导航距离三亚动车站约8公里。周边有多条公交及旅游线路，直达海棠湾免税城，亚龙湾，大小洞天，城市乐园等，交通四通八达，非常便利。', 'https://720yun.com/t/2fvkc7phzr9?scene_id=64241384');
INSERT INTO `ey_article17_content` VALUES ('7', '40', '1649299290', '1649299290', '梦幻不夜城，蜈支洲岛，南田温泉，水稻国家公园，海中海高尔夫，亚特兰蒂斯水上乐园等。', 'https://720yun.com/t/05vku72b7ql?scene_id=40965268');
INSERT INTO `ey_article17_content` VALUES ('8', '41', '1649299290', '1649299290', '龙栖海岸位于海南&amp;middot;大三亚&amp;middot;龙栖湾，龙栖湾滨海旅游度假区，由海南中城投开发建设。北纬18&amp;deg;以南，307亩观海大城，南北通透两梯两户。56㎡海豚大阳台，拥16公里龙栖湾首栖霞海岸，观海阅山，不负盛景。邻南中国海上文旅基地、南繁基地、万豪酒店。项目釆用两梯两户纯板式洋房设计，户型设计合理，全明格局，公摊少、采光足、南北通透，电梯入户。', 'https://720yun.com/t/5bvkcy1ygdl?scene_id=62651738');

-- -----------------------------
-- Table structure for `ey_article_content`
-- -----------------------------
DROP TABLE IF EXISTS `ey_article_content`;
CREATE TABLE `ey_article_content` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `aid` int(10) DEFAULT '0' COMMENT '文档ID',
  `content` longtext COMMENT '内容详情',
  `content_ey_m` longtext COMMENT '手机端内容详情',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`),
  KEY `news_id` (`aid`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=39 DEFAULT CHARSET=utf8 COMMENT='资讯内容表_存储正常内容';

-- -----------------------------
-- Records of `ey_article_content`
-- -----------------------------
INSERT INTO `ey_article_content` VALUES ('30', '32', '&lt;p style=&quot;text-align:center&quot;&gt;&lt;img src=&quot;/public/upload/article/2018/08/08/7a8ac5a9b332e6c48dfa1d1971b0aacd.jpg&quot; title=&quot;7a8ac5a9b332e6c48dfa1d1971b0aacd.jpg&quot; alt=&quot;7a8ac5a9b332e6c48dfa1d1971b0aacd.jpg&quot;/&gt;&lt;/p&gt;', '', '1533700540', '1533700540');
INSERT INTO `ey_article_content` VALUES ('29', '31', '&lt;p style=&quot;text-align:center&quot;&gt;&lt;img src=&quot;/public/upload/article/2018/08/08/99f16c847d4a1cbdc640e78f8b3fa7c5.jpg&quot; title=&quot;99f16c847d4a1cbdc640e78f8b3fa7c5.jpg&quot; alt=&quot;99f16c847d4a1cbdc640e78f8b3fa7c5.jpg&quot;/&gt;&lt;/p&gt;', '', '1533700471', '1533700471');
INSERT INTO `ey_article_content` VALUES ('28', '30', '&lt;p style=&quot;text-align:center&quot;&gt;&lt;img src=&quot;/public/upload/article/2018/08/08/4b4fd8e0e478c6447c53f42122ce195b.jpg&quot; title=&quot;4b4fd8e0e478c6447c53f42122ce195b.jpg&quot; alt=&quot;4b4fd8e0e478c6447c53f42122ce195b.jpg&quot;/&gt;&lt;/p&gt;', '', '1533700316', '1533700316');
INSERT INTO `ey_article_content` VALUES ('27', '29', '&lt;p style=&quot;text-align:center&quot;&gt;&lt;img src=&quot;/public/upload/article/2018/08/08/7967a2bb81918030f32f74fb1b1aed0e.jpg&quot; title=&quot;7967a2bb81918030f32f74fb1b1aed0e.jpg&quot; alt=&quot;7967a2bb81918030f32f74fb1b1aed0e.jpg&quot;/&gt;&lt;/p&gt;', '', '1533700205', '1533700205');
INSERT INTO `ey_article_content` VALUES ('26', '28', '&lt;p style=&quot;text-align:center&quot;&gt;&lt;img src=&quot;/public/upload/article/2018/08/08/4ab3de88a25ac8409771c5773d57cd1e.jpg&quot; title=&quot;4ab3de88a25ac8409771c5773d57cd1e.jpg&quot; alt=&quot;4ab3de88a25ac8409771c5773d57cd1e.jpg&quot;/&gt;&lt;/p&gt;', '', '1533700111', '1533700111');
INSERT INTO `ey_article_content` VALUES ('25', '27', '&lt;p style=&quot;text-align:center&quot;&gt;&lt;img src=&quot;/public/upload/article/2018/08/08/7a67d6acfd30d0187ef9aa3cdced1765.jpg&quot; title=&quot;7a67d6acfd30d0187ef9aa3cdced1765.jpg&quot; alt=&quot;7a67d6acfd30d0187ef9aa3cdced1765.jpg&quot;/&gt;&lt;/p&gt;', '', '1533700080', '1533700080');
INSERT INTO `ey_article_content` VALUES ('24', '26', '&lt;p style=&quot;text-align:center&quot;&gt;&lt;img src=&quot;/public/upload/article/2018/08/08/d35332bade3d63399f5e6801327a8b05.jpg&quot; title=&quot;d35332bade3d63399f5e6801327a8b05.jpg&quot; alt=&quot;d35332bade3d63399f5e6801327a8b05.jpg&quot;/&gt;&lt;/p&gt;', '', '1533700047', '1533700047');
INSERT INTO `ey_article_content` VALUES ('9', '11', '&lt;p style=&quot;margin-top: 0px; margin-bottom: 20px; padding: 0px; color: rgb(51, 51, 51); font-family: &amp;quot;Helvetica Neue&amp;quot;, Helvetica, Arial, &amp;quot;PingFang SC&amp;quot;, &amp;quot;Hiragino Sans GB&amp;quot;, &amp;quot;Heiti SC&amp;quot;, &amp;quot;Microsoft YaHei&amp;quot;, &amp;quot;WenQuanYi Micro Hei&amp;quot;, sans-serif; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;&lt;span style=&quot;line-height: 26px;&quot;&gt;“天苍苍，野茫茫，挖掘技术哪家强？可汗问所欲，木兰不用尚书郎，愿驰千里足，挖掘技术哪家强？”&lt;/span&gt;&lt;br/&gt;&lt;/p&gt;&lt;p style=&quot;margin-top: 0px; margin-bottom: 20px; padding: 0px; color: rgb(51, 51, 51); font-family: &amp;quot;Helvetica Neue&amp;quot;, Helvetica, Arial, &amp;quot;PingFang SC&amp;quot;, &amp;quot;Hiragino Sans GB&amp;quot;, &amp;quot;Heiti SC&amp;quot;, &amp;quot;Microsoft YaHei&amp;quot;, &amp;quot;WenQuanYi Micro Hei&amp;quot;, sans-serif; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;先看个这几天挺火的帖子吧：&lt;/p&gt;&lt;p style=&quot;margin-top: 0px; margin-bottom: 20px; padding: 0px; color: rgb(51, 51, 51); font-family: &amp;quot;Helvetica Neue&amp;quot;, Helvetica, Arial, &amp;quot;PingFang SC&amp;quot;, &amp;quot;Hiragino Sans GB&amp;quot;, &amp;quot;Heiti SC&amp;quot;, &amp;quot;Microsoft YaHei&amp;quot;, &amp;quot;WenQuanYi Micro Hei&amp;quot;, sans-serif; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;“2000年当第一次公开恋情时，王菲31岁，谢霆锋20岁，王菲年龄是谢霆锋的1.55倍。转眼到了2014年，如今两人破镜重圆，王菲45岁，谢霆锋34岁，王菲的年龄是谢霆锋的1.32倍。现在问题来了：一，求两人年龄倍数与公历年的时间序列收敛函数。二，这事给张柏芝、李亚鹏留下了不小的心理阴影，求阴影面积是多少?三，如果用挖掘机填补阴影面积，那请问，挖掘机技术哪家强？”&lt;/p&gt;&lt;p style=&quot;margin-top: 0px; margin-bottom: 20px; padding: 0px; color: rgb(51, 51, 51); font-family: &amp;quot;Helvetica Neue&amp;quot;, Helvetica, Arial, &amp;quot;PingFang SC&amp;quot;, &amp;quot;Hiragino Sans GB&amp;quot;, &amp;quot;Heiti SC&amp;quot;, &amp;quot;Microsoft YaHei&amp;quot;, &amp;quot;WenQuanYi Micro Hei&amp;quot;, sans-serif; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;&lt;br/&gt;&lt;/p&gt;&lt;p style=&quot;margin-top: 0px; margin-bottom: 20px; padding: 0px; color: rgb(51, 51, 51); font-family: &amp;quot;Helvetica Neue&amp;quot;, Helvetica, Arial, &amp;quot;PingFang SC&amp;quot;, &amp;quot;Hiragino Sans GB&amp;quot;, &amp;quot;Heiti SC&amp;quot;, &amp;quot;Microsoft YaHei&amp;quot;, &amp;quot;WenQuanYi Micro Hei&amp;quot;, sans-serif; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;这帖子蹿红，原因不难想见：它有锋菲恋的时髦噱头，有“你的QED解不出我光量子的孤单”式的技术梗……而最关键的爆点，则在于收尾处的那句，“挖掘机技术哪家强”?&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;', '', '1533546369', '1533951766');
INSERT INTO `ey_article_content` VALUES ('10', '12', '&lt;div label-module=&quot;para&quot;&gt;一是娱乐精神过头，人格形象裂变。互联网每年都有那么一两次网民狂欢。恶搞黑人是网民的一贯做法，体现了包容、共融、参与的网络精神。然而大众娱乐没错，偶尔全民狂欢也有喜感。但是娱乐但不能心藏龌龊，肆意揭发他人短处，晾晒他人的弱势。况且如果学校和个人有违法行为，法律自会处置。如今流言蜚语的舆论审判代替了司法审批，道德攻击替代了法律惩戒。&lt;/div&gt;&lt;div label-module=&quot;para&quot;&gt;二是将“黑”进行到底是道德优越感作怪。此次网民狂欢由部分大学生领衔，不少所谓公知凑热闹赚曝光度也堂而皇之拿人开涮。不少本科生嘲笑蓝翔技工学校，甚至把清华大学与它同时放置于大众目光焦烤。正牌军与野鸡大学的比对，狭隘的价值观驱使下，学历优越感和道德优越感无限扩大。&lt;/div&gt;&lt;div label-module=&quot;para&quot;&gt;三是赤裸裸戏谑的背后是白领对蓝领阶层的心理歧视。这种歧视，有对社会分工的不解，有对收入的极差的非议，有对劳动时间与劳动效率的不匹配的抵触。实际上拥有挖掘机技术非高大上所能形容，他们的工资岂是我们想象的到?年薪高的让我等这些小白领只能仰望天空。故而歧视便心安理得起来。&lt;/div&gt;&lt;div label-module=&quot;para&quot;&gt;此外，如此大规模高级黑“技工”，宣告这几年国家高等教育体质改革特别是极大推崇职业教育的成果依然不显著。职业教育登不上大雅之堂的就业理念依然占据主体，多元化的职业认同不被看好。&lt;/div&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;', '', '1533546479', '1533952320');
INSERT INTO `ey_article_content` VALUES ('38', '40', '&lt;p style=&quot;text-align: center;&quot;&gt;&lt;img src=&quot;/public/upload/article/2018/08/11/a7464699cd881373d8791dfc764c3089.jpg&quot; title=&quot;a7464699cd881373d8791dfc764c3089.jpg&quot; alt=&quot;a7464699cd881373d8791dfc764c3089.jpg&quot; width=&quot;525&quot; height=&quot;350&quot; border=&quot;0&quot; vspace=&quot;0&quot; style=&quot;width: 525px; height: 350px;&quot;/&gt;&lt;/p&gt;', '', '1533952460', '1533952460');
INSERT INTO `ey_article_content` VALUES ('11', '13', '&lt;p&gt;一般挖掘机学校毕业的学生，如果没什么关系只能去比较苦的矿上，混到建筑道路这种环境较好的工地比较难。有很多技校毕业的学生毕业后仍然会找师傅再带一段时间，这样不仅能再磨练一下技术，还能顺便寻个比较好的工作。&lt;/p&gt;', '', '1533547487', '1533711787');
INSERT INTO `ey_article_content` VALUES ('34', '36', '&lt;p style=&quot;margin-top: 0px; margin-bottom: 20px; padding: 0px; color: rgb(51, 51, 51); font-family: &amp;quot;Helvetica Neue&amp;quot;, Helvetica, Arial, &amp;quot;PingFang SC&amp;quot;, &amp;quot;Hiragino Sans GB&amp;quot;, &amp;quot;Heiti SC&amp;quot;, &amp;quot;Microsoft YaHei&amp;quot;, &amp;quot;WenQuanYi Micro Hei&amp;quot;, sans-serif; white-space: normal; background-color: rgb(255, 255, 255);&quot;&gt;蓝翔的火，在于它已然成为段子手们撸出茧的梗。“挖掘机到底哪家强?中国山东找蓝翔”，是许多故事进阶为段子的标配式结局。不管这故事是言情的、玄幻的、恐怖的，在结尾来上这么一句，都能在剧情跳跃和翻转中，迎来喜剧性效果。而“蓝翔”二字对舆论嗨点的引爆作用，最终也能兑换为段子的传播广度。&lt;br/&gt;&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;', '', '1533713680', '1533713680');
INSERT INTO `ey_article_content` VALUES ('35', '37', '&lt;p&gt;有人归结为其24年没变过的广告语——“挖掘机哪家强?中国山东找蓝翔”。它气势雄浑，语调铿锵，最重要的是简单粗暴。在其广告的狂轰乱炸之下，很多人如今再听到这话时，总会自然而然地脑补起唐国强竖大拇指的场景。这就像濡染多了神曲《小苹果》后，再听到“你是我的……”时，会本能地续上“小呀小苹果”一样。尽管NewEast的“遇到新东方厨师就嫁了吧”，也习得此道，但气场上终究逊了一筹。&lt;/p&gt;', '', '1533713770', '1533713770');
INSERT INTO `ey_article_content` VALUES ('12', '14', '&lt;p&gt;现在学习挖掘机的职业技术很多，大家听得最多的就是蓝翔，网友戏称“皇家布鲁塞特大学”（blue shit 的音译）, 除此之外各地都有当地的培训学校。在培训学校能够学到完善的理论知识和较全面的操作技术，但是由于培训时间普遍比较短，导致学员的实际操作水平有限。&lt;/p&gt;', '', '1533547565', '1533711722');
INSERT INTO `ey_article_content` VALUES ('13', '15', '&lt;p style=&quot;text-align:center&quot;&gt;&lt;img src=&quot;/public/upload/article/2018/08/09/ef87e47e13961f19b8e2b303374bb1cf.jpg&quot; title=&quot;ef87e47e13961f19b8e2b303374bb1cf.jpg&quot; alt=&quot;ef87e47e13961f19b8e2b303374bb1cf.jpg&quot;/&gt;&lt;/p&gt;', '', '1533550487', '1533798391');
INSERT INTO `ey_article_content` VALUES ('14', '16', '&lt;p style=&quot;text-align:center&quot;&gt;&lt;img src=&quot;/public/upload/article/2018/08/09/3b37f7e11c6b0242c1284b0bff29cdf9.jpg&quot; title=&quot;3b37f7e11c6b0242c1284b0bff29cdf9.jpg&quot; alt=&quot;3b37f7e11c6b0242c1284b0bff29cdf9.jpg&quot;/&gt;&lt;/p&gt;', '', '1533550542', '1533798351');
INSERT INTO `ey_article_content` VALUES ('15', '17', '&lt;p&gt;&lt;br/&gt;&lt;/p&gt;&lt;div label-module=&quot;para&quot;&gt;一是娱乐精神过头，人格形象裂变。互联网每年都有那么一两次网民狂欢。恶搞黑人是网民的一贯做法，体现了包容、共融、参与的网络精神。然而大众娱乐没错，偶尔全民狂欢也有喜感。但是娱乐但不能心藏龌龊，肆意揭发他人短处，晾晒他人的弱势。况且如果学校和个人有违法行为，法律自会处置。如今流言蜚语的舆论审判代替了司法审批，道德攻击替代了法律惩戒。&lt;/div&gt;&lt;div label-module=&quot;para&quot;&gt;二是将“黑”进行到底是道德优越感作怪。此次网民狂欢由部分大学生领衔，不少所谓公知凑热闹赚曝光度也堂而皇之拿人开涮。不少本科生嘲笑蓝翔技工学校，甚至把清华大学与它同时放置于大众目光焦烤。正牌军与野鸡大学的比对，狭隘的价值观驱使下，学历优越感和道德优越感无限扩大。&lt;/div&gt;&lt;div label-module=&quot;para&quot;&gt;三是赤裸裸戏谑的背后是白领对蓝领阶层的心理歧视。这种歧视，有对社会分工的不解，有对收入的极差的非议，有对劳动时间与劳动效率的不匹配的抵触。实际上拥有挖掘机技术非高大上所能形容，他们的工资岂是我们想象的到?年薪高的让我等这些小白领只能仰望天空。故而歧视便心安理得起来。&lt;/div&gt;&lt;div label-module=&quot;para&quot;&gt;此外，如此大规模高级黑“技工”，宣告这几年国家高等教育体质改革特别是极大推崇职业教育的成果依然不显著。职业教育登不上大雅之堂的就业理念依然占据主体，多元化的职业认同不被看好。&lt;/div&gt;&lt;div label-module=&quot;para&quot;&gt;黑，与不黑，是互联网赋予每一个网民的权力。但是，每粒尘埃都有光，野百合也有春天。你人格高尚的前提是他人予以你的尊重。拿他人尊严开刷的行为，恶意的“黑”与互联网精神背道而驰，纵然“黑”能带来欢乐，也不会有高尚。因为平等，是人性光辉绽放的起码。惟有彼此尊重，生命才有可能美好的一塌糊涂，欢乐才能幸福长久&lt;/div&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;', '', '1533614969', '1533701422');
INSERT INTO `ey_article_content` VALUES ('31', '33', '&lt;p&gt;如何鉴别一名机手是老司机还是新手呢？开挖掘机时间长短可不是主要的因素，而操作的手法才是判断的根本。一名新手成长为老司机不仅要不断的努力学习，同时还要经过不同工况的作业锻炼，最后才能步入老司机的行业。&lt;/p&gt;&lt;p&gt;在不同的作业中，老司机们普遍认为挖沟难度比较大，然而事实并非如此，砖家为大家列举出6项难度比较大的施工作业，其中最难的可要比挖沟难度高出千百倍，相信有的老司机一定不服，想要挑战一下，别着急看看下文绝对让你心服口服！&lt;/p&gt;&lt;p&gt;NO.6：甩土&lt;/p&gt;&lt;p&gt;难度指数：★&lt;/p&gt;&lt;p&gt;甩土算是挖掘机作业里面的基本功了，学徒时师傅第一个教的应该就是这种作业。甩土难度不大，好学容易入手，但是也是需要多加练习的。&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;', '', '1533701828', '1533701828');
INSERT INTO `ey_article_content` VALUES ('23', '25', '&lt;p style=&quot;text-align:center&quot;&gt;&lt;img src=&quot;/public/upload/article/2018/08/08/33d7c072e07c3380ba586c003fd00263.jpg&quot; title=&quot;33d7c072e07c3380ba586c003fd00263.jpg&quot; alt=&quot;33d7c072e07c3380ba586c003fd00263.jpg&quot;/&gt;&lt;/p&gt;', '', '1533699860', '1533699860');
INSERT INTO `ey_article_content` VALUES ('22', '24', '&lt;p&gt;&amp;nbsp;&lt;/p&gt;&lt;p style=&quot;text-align:center&quot;&gt;&lt;img src=&quot;/public/upload/article/2018/08/09/1880e23edc285a39a302fadbe1f5d7e2.jpg&quot; title=&quot;1880e23edc285a39a302fadbe1f5d7e2.jpg&quot; alt=&quot;1880e23edc285a39a302fadbe1f5d7e2.jpg&quot;/&gt;&lt;/p&gt;', '', '1533628235', '1533798304');
INSERT INTO `ey_article_content` VALUES ('20', '22', '&lt;p&gt;蓝翔，又名“布鲁弗莱”或“不撸谢特”，全名是山东蓝翔高级技工学校。虽是技校，可究其风头，在国内学校中罕有媲迹者，甚至可秒杀清华北大。虽然北方名校“纽伊斯特(NewEast)”，在江湖上与其齐名，可它充其量也只是“南慕容，北乔峰”式类比，名为技校“双子星”，实力却不在一个量级上。&lt;/p&gt;&lt;p&gt;蓝翔的火，在于它已然成为段子手们撸出茧的梗。“挖掘机到底哪家强?中国山东找蓝翔”，是许多故事进阶为段子的标配式结局。不管这故事是言情的、玄幻的、恐怖的，在结尾来上这么一句，都能在剧情跳跃和翻转中，迎来喜剧性效果。而“蓝翔”二字对舆论嗨点的引爆作用，最终也能兑换为段子的传播广度。&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;', '', '1533627969', '1533713674');
INSERT INTO `ey_article_content` VALUES ('21', '23', '&lt;p&gt;不过这种方式也存在很多弊病：有的师傅可能只教某几个技术，徒弟学到的驾驶技术比较单一，后面工作中仍要不断学习；有些师傅的不良习惯也很容易遗传给徒弟；另外由于不是专业老师，学徒经常会受到师傅的歧视、冷暴力、刁难等行为。&lt;br/&gt;&lt;/p&gt;', '', '1533628002', '1533713625');
INSERT INTO `ey_article_content` VALUES ('32', '34', '&lt;p&gt;根据我们调查来看，挖掘机学习途径大体上分为三类：师徒式学习、职业技术学校学习、自学成才。这三种学习方式各有优劣、不同体系下出来的学员水平也不一样。&lt;/p&gt;&lt;p&gt;常见三种途径：师徒+技校+自学&lt;/p&gt;&lt;p&gt;1.师傅带徒弟：在国内大多数挖掘机司机都是通过师傅带徒弟、徒弟一边学一边做工程这种方式培养出来的。这种方式让徒弟在耳濡目染中学到师傅的良好技术，徒弟的实际操作经验增长很快；而且在这种半工半学的工程中不仅学到了挖掘机技术，更重要的是与当地的工头接触较多，有利于出师后单干。另外由于这种方式是半工半学，基本上前面几个月花点钱，后面徒弟能够独立干台班后就不用给师傅钱了，相对去技校的成本很低。&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;', '', '1533702036', '1533702036');
INSERT INTO `ey_article_content` VALUES ('33', '35', '&lt;div label-module=&quot;para&quot;&gt;一是娱乐精神过头，人格形象裂变。互联网每年都有那么一两次网民狂欢。恶搞黑人是网民的一贯做法，体现了包容、共融、参与的网络精神。然而大众娱乐没错，偶尔全民狂欢也有喜感。但是娱乐但不能心藏龌龊，肆意揭发他人短处，晾晒他人的弱势。况且如果学校和个人有违法行为，法律自会处置。如今流言蜚语的舆论审判代替了司法审批，道德攻击替代了法律惩戒。&lt;/div&gt;&lt;div label-module=&quot;para&quot;&gt;二是将“黑”进行到底是道德优越感作怪。此次网民狂欢由部分大学生领衔，不少所谓公知凑热闹赚曝光度也堂而皇之拿人开涮。不少本科生嘲笑蓝翔技工学校，甚至把清华大学与它同时放置于大众目光焦烤。正牌军与野鸡大学的比对，狭隘的价值观驱使下，学历优越感和道德优越感无限扩大。&lt;/div&gt;&lt;div label-module=&quot;para&quot;&gt;三是赤裸裸戏谑的背后是白领对蓝领阶层的心理歧视。这种歧视，有对社会分工的不解，有对收入的极差的非议，有对劳动时间与劳动效率的不匹配的抵触。实际上拥有挖掘机技术非高大上所能形容，他们的工资岂是我们想象的到?年薪高的让我等这些小白领只能仰望天空。故而歧视便心安理得起来。&lt;/div&gt;&lt;div label-module=&quot;para&quot;&gt;此外，如此大规模高级黑“技工”，宣告这几年国家高等教育体质改革特别是极大推崇职业教育的成果依然不显著。职业教育登不上大雅之堂的就业理念依然占据主体，多元化的职业认同不被看好。&lt;/div&gt;&lt;div label-module=&quot;para&quot;&gt;黑，与不黑，是互联网赋予每一个网民的权力。但是，每粒尘埃都有光，野百合也有春天。你人格高尚的前提是他人予以你的尊重。拿他人尊严开刷的行为，恶意的“黑”与互联网精神背道而驰，纵然“黑”能带来欢乐，也不会有高尚。因为平等，是人性光辉绽放的起码。惟有彼此尊重，生命才有可能美好的一塌糊涂，欢乐才能幸福长久&lt;/div&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;', '', '1533710663', '1533951702');
INSERT INTO `ey_article_content` VALUES ('36', '38', '&lt;p&gt;数据显示，６月份核心机械订货额约为８２７６亿日元，环比下降８．８％。其中，制造业订货额为３８１８亿日元，环比下降１５．９％；非制造业订货额为４４５４亿日元，环比下降７．０％。包括政府和公共机构需求以及外需等在内的６月份机械订货总额为２．２１３９万亿日元，环比减少１４．４％。&lt;/p&gt;&lt;p&gt;　　日本内阁府将对机械订货基本情况的判断从“正在复苏”下调至“复苏动向中可见停滞迹象”，这是内阁府时隔一年多来首次下调机械订货基本情况判断。&lt;/p&gt;&lt;p&gt;　　数据还显示，经季节调整后的二季度日本核心机械订货额为２．６７８６万亿日元，比上一季度增加２．２％，连续４个季度增加。二季度机械订货总额为７．３０９４万亿日元，环比增加２．６％。&lt;/p&gt;&lt;p&gt;　　日本机械订货统计数据基于日本政府对国内２８０家生产企业的调查统计结果，反映日本企业今后６至９个月的设备投资动向，是日本民间设备投资的重要先行指标。&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;', '', '1533951683', '1533951683');
INSERT INTO `ey_article_content` VALUES ('37', '39', '&lt;p&gt;作为厂家售后技术，我们会给客户解决各种各样不同的问题与设备日常使用中的技巧与预防出现问题的技巧。今天讲述一下常见问题：双轮振动压路机出现发动机正常工作，但是振动系统不工作的故障排除与维护。&lt;/p&gt;&lt;p&gt;问题：双轮振动压路机发动机正常工作，但振动系统不工作？&lt;/p&gt;&lt;p&gt;问题查找与排除技巧：①、发动机飞轮与液压泵输入轴之间的弹性传动盘脱落或损坏，造成动力无法传送到震动泵，就造成振动不工作。&lt;/p&gt;&lt;p&gt;②、振动液压马达与振动轴之间的联轴器损坏，导致液压马达的动力无法输入。&lt;/p&gt;&lt;p&gt;③、液压油箱缺油了或者吸油过滤器严重堵塞，就会导致液压系统的主回路不能及时的补油。&lt;/p&gt;&lt;p&gt;④、液压泵或者马达磨损严重。&lt;/p&gt;&lt;p&gt;维护与防止技巧：①、双轮振动压路机在使用的过程中，要按照正确的平稳的的方式去操作。按照不同工程压球正确的调整压路机的静线压力、震动幅度、频率和碾压速度。要经常检查发动机的转速表和振动频率表，更不要随便改装压路机及其配重。&lt;/p&gt;&lt;p&gt;②、每次施工前后要及时检查液压系统是否有泄漏、各个零部件的工作情况是否正常和润滑油量是否正常。严格按照维护保养说明来进行保养维护，要保证液压油的清洁剂质量，按时清理各种过滤器的滤网。检查振动系统各部件的零件。&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;', '', '1533951807', '1533951807');

-- -----------------------------
-- Table structure for `ey_article_order`
-- -----------------------------
DROP TABLE IF EXISTS `ey_article_order`;
CREATE TABLE `ey_article_order` (
  `order_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '文章订单ID',
  `order_code` varchar(50) NOT NULL DEFAULT '' COMMENT '媒体订单编号',
  `users_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '会员ID',
  `order_status` tinyint(1) NOT NULL DEFAULT '0' COMMENT '订单状态：0未付款，1已付款',
  `order_amount` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '订单应付总金额',
  `pay_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '支付时间',
  `pay_name` varchar(20) NOT NULL DEFAULT '' COMMENT '支付方式名称',
  `wechat_pay_type` varchar(20) NOT NULL DEFAULT '' COMMENT '微信支付时，标记使用的支付类型（扫码支付，微信内部，微信H5页面）',
  `pay_details` text COMMENT '支付时返回的数据，以serialize序列化后存入，用于后续查询。',
  `product_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '视频文档ID',
  `product_name` varchar(100) DEFAULT '' COMMENT '视频文档名称',
  `product_litpic` varchar(500) DEFAULT '' COMMENT '视频文档封面图片',
  `lang` varchar(30) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) unsigned DEFAULT '0' COMMENT '下单时间',
  `update_time` int(11) unsigned DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`order_id`),
  UNIQUE KEY `order_code` (`order_code`) USING BTREE,
  KEY `users_id` (`users_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='文章订单表';


-- -----------------------------
-- Table structure for `ey_article_pay`
-- -----------------------------
DROP TABLE IF EXISTS `ey_article_pay`;
CREATE TABLE `ey_article_pay` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `aid` int(11) DEFAULT '0',
  `part_free` tinyint(1) DEFAULT '0' COMMENT '是否试看 0-否 1-是',
  `size` float(10,2) DEFAULT '1.00' COMMENT 'KB',
  `free_content` longtext COMMENT '试看内容',
  `add_time` int(11) DEFAULT '0',
  `update_time` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='文章付费预览表';


-- -----------------------------
-- Table structure for `ey_ask`
-- -----------------------------
DROP TABLE IF EXISTS `ey_ask`;
CREATE TABLE `ey_ask` (
  `ask_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `type_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '问题栏目ID',
  `users_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '会员ID',
  `ask_title` varchar(200) NOT NULL DEFAULT '' COMMENT '问题标题',
  `is_recom` tinyint(1) NOT NULL DEFAULT '0' COMMENT '问题是否推荐',
  `status` tinyint(1) NOT NULL DEFAULT '0' COMMENT '问题状态：0未解决，1已解决，2已关闭',
  `click` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '浏览点击量',
  `replies` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '问题回复量',
  `content` text NOT NULL COMMENT '问题内容',
  `url` varchar(255) NOT NULL DEFAULT '' COMMENT '问题网址',
  `users_ip` varchar(50) NOT NULL DEFAULT '' COMMENT '问题发布时IP地址',
  `is_review` tinyint(1) NOT NULL DEFAULT '1' COMMENT '问题是否审核，1是，0否',
  `follow` tinyint(1) NOT NULL DEFAULT '0' COMMENT '关注问题则表示有回复时发送邮件通知到问题发布人',
  `solve_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '解决时间(这个问题存在最佳答案则表示已解决)',
  `bestanswer_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '最佳答案',
  `sort_order` int(10) NOT NULL DEFAULT '100' COMMENT '排序号',
  `add_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '新增时间',
  `update_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  `money` decimal(8,2) NOT NULL DEFAULT '0.00' COMMENT '悬赏金额',
  `is_del` tinyint(1) DEFAULT '0' COMMENT '1-删除',
  PRIMARY KEY (`ask_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='问题表';


-- -----------------------------
-- Table structure for `ey_ask_answer`
-- -----------------------------
DROP TABLE IF EXISTS `ey_ask_answer`;
CREATE TABLE `ey_ask_answer` (
  `answer_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `ask_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '问题ID',
  `is_bestanswer` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否最佳答案，0否，1是',
  `is_review` tinyint(1) NOT NULL DEFAULT '1' COMMENT '问题是否审核，1是，0否',
  `type_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '问题栏目ID',
  `users_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '用户ID',
  `username` varchar(50) NOT NULL DEFAULT '' COMMENT '用户名',
  `click_like` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '点赞量',
  `users_ip` varchar(30) NOT NULL DEFAULT '' COMMENT '用户IP地址',
  `content` text NOT NULL COMMENT '内容',
  `ifcheck` tinyint(1) NOT NULL DEFAULT '1',
  `answer_pid` int(10) NOT NULL DEFAULT '0' COMMENT '子答案的父答案',
  `at_users_id` int(10) NOT NULL DEFAULT '0' COMMENT '被@的用户ID',
  `at_answer_id` int(10) NOT NULL DEFAULT '0' COMMENT '@答案ID',
  `add_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '新增时间',
  `update_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  `is_del` tinyint(1) NOT NULL DEFAULT '0' COMMENT '1-删除',
  PRIMARY KEY (`answer_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='答案表';


-- -----------------------------
-- Table structure for `ey_ask_answer_like`
-- -----------------------------
DROP TABLE IF EXISTS `ey_ask_answer_like`;
CREATE TABLE `ey_ask_answer_like` (
  `like_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `ask_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '问题ID',
  `answer_id` int(10) NOT NULL DEFAULT '0' COMMENT '答案ID',
  `users_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '用户ID',
  `click_like` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '点赞',
  `like_source` tinyint(1) unsigned NOT NULL DEFAULT '2' COMMENT '点赞来源，1=点赞提问(ask_id)，2=点赞评论(answer_id)，3=点赞回复(answer_id)，默认值为2，兼容以前的那些评论数据',
  `users_ip` varchar(30) NOT NULL DEFAULT '' COMMENT '用户IP地址',
  `add_time` int(10) unsigned NOT NULL DEFAULT '0',
  `update_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`like_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='答案点赞表';


-- -----------------------------
-- Table structure for `ey_ask_score_level`
-- -----------------------------
DROP TABLE IF EXISTS `ey_ask_score_level`;
CREATE TABLE `ey_ask_score_level` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `name` varchar(55) DEFAULT '',
  `min` mediumint(8) DEFAULT '0',
  `max` mediumint(8) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 COMMENT='积分等级表';

-- -----------------------------
-- Records of `ey_ask_score_level`
-- -----------------------------
INSERT INTO `ey_ask_score_level` VALUES ('1', '青铜', '0', '1000');
INSERT INTO `ey_ask_score_level` VALUES ('2', '白银', '1001', '5000');
INSERT INTO `ey_ask_score_level` VALUES ('3', '黄金', '5001', '20000');
INSERT INTO `ey_ask_score_level` VALUES ('4', '王者', '20001', '0');

-- -----------------------------
-- Table structure for `ey_ask_type`
-- -----------------------------
DROP TABLE IF EXISTS `ey_ask_type`;
CREATE TABLE `ey_ask_type` (
  `type_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '栏目自增',
  `type_name` varchar(100) NOT NULL DEFAULT '' COMMENT '栏目名称',
  `parent_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '上级ID',
  `seo_title` varchar(200) DEFAULT '' COMMENT 'SEO标题',
  `seo_keywords` varchar(200) DEFAULT '' COMMENT 'seo关键字',
  `seo_description` text COMMENT 'seo描述',
  `sort_order` int(10) unsigned NOT NULL DEFAULT '100' COMMENT '排序号',
  `add_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '新增时间',
  `update_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`type_id`)
) ENGINE=MyISAM AUTO_INCREMENT=6 DEFAULT CHARSET=utf8 COMMENT='问题栏目分类表';

-- -----------------------------
-- Records of `ey_ask_type`
-- -----------------------------
INSERT INTO `ey_ask_type` VALUES ('1', '问题求助', '0', '', '', '', '100', '1565770890', '1611910466');
INSERT INTO `ey_ask_type` VALUES ('2', '功能建议', '0', '', '', '', '100', '1565770890', '1611910466');
INSERT INTO `ey_ask_type` VALUES ('3', 'BUG反馈', '1', '', '', '', '100', '1565771021', '1611910466');
INSERT INTO `ey_ask_type` VALUES ('4', '其他问题', '1', '', '', '', '100', '1565771021', '1611910466');
INSERT INTO `ey_ask_type` VALUES ('5', '业务咨询', '0', '', '', '', '100', '1611910466', '1611910466');

-- -----------------------------
-- Table structure for `ey_auth_access`
-- -----------------------------
DROP TABLE IF EXISTS `ey_auth_access`;
CREATE TABLE `ey_auth_access` (
  `role_id` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT '角色ID',
  `rule_id` int(11) NOT NULL DEFAULT '0' COMMENT '权限ID',
  KEY `role_id` (`role_id`) USING BTREE,
  KEY `rule_id` (`rule_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='权限授权表';

-- -----------------------------
-- Records of `ey_auth_access`
-- -----------------------------
INSERT INTO `ey_auth_access` VALUES ('12', '176');
INSERT INTO `ey_auth_access` VALUES ('12', '177');
INSERT INTO `ey_auth_access` VALUES ('12', '178');
INSERT INTO `ey_auth_access` VALUES ('12', '179');
INSERT INTO `ey_auth_access` VALUES ('12', '180');
INSERT INTO `ey_auth_access` VALUES ('12', '181');
INSERT INTO `ey_auth_access` VALUES ('12', '182');
INSERT INTO `ey_auth_access` VALUES ('12', '183');
INSERT INTO `ey_auth_access` VALUES ('12', '184');
INSERT INTO `ey_auth_access` VALUES ('12', '185');
INSERT INTO `ey_auth_access` VALUES ('12', '186');
INSERT INTO `ey_auth_access` VALUES ('12', '187');
INSERT INTO `ey_auth_access` VALUES ('12', '188');
INSERT INTO `ey_auth_access` VALUES ('12', '189');
INSERT INTO `ey_auth_access` VALUES ('12', '190');
INSERT INTO `ey_auth_access` VALUES ('12', '191');
INSERT INTO `ey_auth_access` VALUES ('12', '192');
INSERT INTO `ey_auth_access` VALUES ('12', '193');
INSERT INTO `ey_auth_access` VALUES ('12', '194');
INSERT INTO `ey_auth_access` VALUES ('12', '195');
INSERT INTO `ey_auth_access` VALUES ('12', '196');
INSERT INTO `ey_auth_access` VALUES ('12', '197');
INSERT INTO `ey_auth_access` VALUES ('12', '198');
INSERT INTO `ey_auth_access` VALUES ('12', '81');
INSERT INTO `ey_auth_access` VALUES ('12', '62');
INSERT INTO `ey_auth_access` VALUES ('12', '61');
INSERT INTO `ey_auth_access` VALUES ('12', '8');
INSERT INTO `ey_auth_access` VALUES ('12', '70');
INSERT INTO `ey_auth_access` VALUES ('12', '71');
INSERT INTO `ey_auth_access` VALUES ('12', '72');
INSERT INTO `ey_auth_access` VALUES ('11', '176');
INSERT INTO `ey_auth_access` VALUES ('11', '177');
INSERT INTO `ey_auth_access` VALUES ('11', '178');
INSERT INTO `ey_auth_access` VALUES ('11', '179');
INSERT INTO `ey_auth_access` VALUES ('11', '180');
INSERT INTO `ey_auth_access` VALUES ('11', '181');
INSERT INTO `ey_auth_access` VALUES ('11', '182');
INSERT INTO `ey_auth_access` VALUES ('11', '184');
INSERT INTO `ey_auth_access` VALUES ('11', '185');
INSERT INTO `ey_auth_access` VALUES ('11', '186');
INSERT INTO `ey_auth_access` VALUES ('11', '187');
INSERT INTO `ey_auth_access` VALUES ('11', '188');
INSERT INTO `ey_auth_access` VALUES ('11', '189');
INSERT INTO `ey_auth_access` VALUES ('11', '191');
INSERT INTO `ey_auth_access` VALUES ('11', '192');
INSERT INTO `ey_auth_access` VALUES ('11', '193');
INSERT INTO `ey_auth_access` VALUES ('11', '194');
INSERT INTO `ey_auth_access` VALUES ('11', '195');
INSERT INTO `ey_auth_access` VALUES ('11', '196');
INSERT INTO `ey_auth_access` VALUES ('11', '197');
INSERT INTO `ey_auth_access` VALUES ('11', '198');
INSERT INTO `ey_auth_access` VALUES ('11', '199');
INSERT INTO `ey_auth_access` VALUES ('11', '200');
INSERT INTO `ey_auth_access` VALUES ('11', '201');
INSERT INTO `ey_auth_access` VALUES ('11', '202');
INSERT INTO `ey_auth_access` VALUES ('11', '203');
INSERT INTO `ey_auth_access` VALUES ('11', '204');
INSERT INTO `ey_auth_access` VALUES ('11', '205');
INSERT INTO `ey_auth_access` VALUES ('11', '206');
INSERT INTO `ey_auth_access` VALUES ('11', '207');
INSERT INTO `ey_auth_access` VALUES ('11', '208');
INSERT INTO `ey_auth_access` VALUES ('11', '209');
INSERT INTO `ey_auth_access` VALUES ('11', '210');
INSERT INTO `ey_auth_access` VALUES ('11', '211');
INSERT INTO `ey_auth_access` VALUES ('11', '125');
INSERT INTO `ey_auth_access` VALUES ('11', '126');
INSERT INTO `ey_auth_access` VALUES ('11', '127');
INSERT INTO `ey_auth_access` VALUES ('11', '62');
INSERT INTO `ey_auth_access` VALUES ('11', '136');
INSERT INTO `ey_auth_access` VALUES ('11', '137');
INSERT INTO `ey_auth_access` VALUES ('11', '138');
INSERT INTO `ey_auth_access` VALUES ('11', '139');
INSERT INTO `ey_auth_access` VALUES ('11', '140');
INSERT INTO `ey_auth_access` VALUES ('11', '141');
INSERT INTO `ey_auth_access` VALUES ('11', '142');
INSERT INTO `ey_auth_access` VALUES ('11', '143');
INSERT INTO `ey_auth_access` VALUES ('11', '61');
INSERT INTO `ey_auth_access` VALUES ('11', '212');
INSERT INTO `ey_auth_access` VALUES ('11', '8');
INSERT INTO `ey_auth_access` VALUES ('11', '70');
INSERT INTO `ey_auth_access` VALUES ('11', '71');
INSERT INTO `ey_auth_access` VALUES ('11', '72');
INSERT INTO `ey_auth_access` VALUES ('11', '9');
INSERT INTO `ey_auth_access` VALUES ('11', '77');
INSERT INTO `ey_auth_access` VALUES ('11', '78');
INSERT INTO `ey_auth_access` VALUES ('11', '79');
INSERT INTO `ey_auth_access` VALUES ('11', '148');
INSERT INTO `ey_auth_access` VALUES ('11', '149');
INSERT INTO `ey_auth_access` VALUES ('11', '150');
INSERT INTO `ey_auth_access` VALUES ('11', '151');
INSERT INTO `ey_auth_access` VALUES ('11', '144');
INSERT INTO `ey_auth_access` VALUES ('11', '145');
INSERT INTO `ey_auth_access` VALUES ('11', '146');
INSERT INTO `ey_auth_access` VALUES ('11', '147');
INSERT INTO `ey_auth_access` VALUES ('11', '155');
INSERT INTO `ey_auth_access` VALUES ('11', '156');
INSERT INTO `ey_auth_access` VALUES ('11', '157');
INSERT INTO `ey_auth_access` VALUES ('11', '158');
INSERT INTO `ey_auth_access` VALUES ('11', '159');

-- -----------------------------
-- Table structure for `ey_auth_modular`
-- -----------------------------
DROP TABLE IF EXISTS `ey_auth_modular`;
CREATE TABLE `ey_auth_modular` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `parent_id` int(11) DEFAULT '0' COMMENT '父级ID',
  `name` varchar(50) DEFAULT '' COMMENT '名称',
  `controller` varchar(50) DEFAULT '' COMMENT '控制器',
  `action` varchar(50) DEFAULT '' COMMENT '操作名',
  `grade` tinyint(1) DEFAULT '0' COMMENT '级别',
  `url` varchar(200) DEFAULT '' COMMENT '链接',
  `sort_order` int(11) DEFAULT '0' COMMENT '排序号',
  `is_menu` tinyint(1) DEFAULT '1' COMMENT '显示菜单(1=是，0=否)',
  `status` tinyint(1) DEFAULT '1' COMMENT '状态(1=正常，0=屏蔽)',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`),
  KEY `parent_id` (`parent_id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=515 DEFAULT CHARSET=utf8;

-- -----------------------------
-- Records of `ey_auth_modular`
-- -----------------------------
INSERT INTO `ey_auth_modular` VALUES ('513', '481', 'SEO优化', 'Seo', 'index', '2', '', '100', '1', '1', '1524208193', '0');
INSERT INTO `ey_auth_modular` VALUES ('9', '514', '高级选项', '', '', '1', '', '0', '1', '1', '1503301507', '1527306955');
INSERT INTO `ey_auth_modular` VALUES ('12', '514', '基本信息', 'System', 'index', '1', '', '1', '1', '1', '0', '1527306913');
INSERT INTO `ey_auth_modular` VALUES ('13', '9', '修改密码', 'Admin', 'admin_pwd', '2', '', '3', '1', '1', '1503301723', '0');
INSERT INTO `ey_auth_modular` VALUES ('14', '9', '管理员列表', 'Admin', 'index', '2', '', '0', '1', '1', '1503301765', '1527306984');
INSERT INTO `ey_auth_modular` VALUES ('15', '9', '角色列表', 'Admin', 'role', '2', '', '0', '1', '1', '1503301781', '1527307009');
INSERT INTO `ey_auth_modular` VALUES ('16', '9', '模块列表', 'Admin', 'modular', '2', '', '0', '1', '1', '1503301793', '1527307006');
INSERT INTO `ey_auth_modular` VALUES ('17', '9', '权限列表', 'Admin', 'rule', '2', '', '0', '1', '1', '1503301805', '1527307004');
INSERT INTO `ey_auth_modular` VALUES ('18', '9', '日志列表', 'Admin', 'log', '2', '', '0', '1', '1', '1503301840', '1527306999');
INSERT INTO `ey_auth_modular` VALUES ('19', '9', '数据备份', 'Tools', 'index', '2', '', '0', '1', '1', '1503301857', '1527307033');
INSERT INTO `ey_auth_modular` VALUES ('21', '9', '数据还原', 'Tools', 'restore', '2', '', '0', '1', '1', '1503302091', '1527307044');
INSERT INTO `ey_auth_modular` VALUES ('22', '9', '地区列表', 'System', 'region', '2', '', '2', '0', '1', '1505441023', '0');
INSERT INTO `ey_auth_modular` VALUES ('23', '0', '常规', '', '', '0', '', '0', '1', '1', '1503308630', '1503367345');
INSERT INTO `ey_auth_modular` VALUES ('27', '514', '调试外观', '', '', '1', '', '1', '1', '1', '0', '1527306927');
INSERT INTO `ey_auth_modular` VALUES ('28', '27', '电脑版', 'Uiset', 'pc', '2', '/index.php/home/Index/index.html?ui_set=on', '0', '1', '1', '1503368313', '1523432343');
INSERT INTO `ey_auth_modular` VALUES ('30', '27', '手机版', 'Uiset', 'mobile', '2', '', '0', '1', '1', '1503368589', '1509093563');
INSERT INTO `ey_auth_modular` VALUES ('35', '9', '清除缓存', 'System', 'clearCache', '2', '', '20', '1', '1', '1503655673', '0');
INSERT INTO `ey_auth_modular` VALUES ('41', '23', '设置栏目', 'Arctype', 'index', '1', '', '0', '1', '1', '1503999661', '1527307162');
INSERT INTO `ey_auth_modular` VALUES ('62', '9', '邮件模板', 'EmailTemplate', 'index', '2', '', '5', '1', '1', '1505204834', '1509090070');
INSERT INTO `ey_auth_modular` VALUES ('64', '9', '短信模板', 'SmsTemplate', 'index', '2', '', '4', '1', '1', '1505204889', '1509086592');
INSERT INTO `ey_auth_modular` VALUES ('470', '23', '发布文档', 'Channeltype', 'index', '1', '', '0', '1', '1', '1505726990', '1527307178');
INSERT INTO `ey_auth_modular` VALUES ('480', '481', '友情链接', 'Links', 'index', '2', '', '7', '1', '1', '1505803829', '1522996913');
INSERT INTO `ey_auth_modular` VALUES ('481', '514', '营销设置', '', '', '1', '', '0', '1', '1', '1505873468', '1527306945');
INSERT INTO `ey_auth_modular` VALUES ('482', '481', '广告列表', 'Ad', 'index', '2', '', '0', '1', '1', '1505873498', '0');
INSERT INTO `ey_auth_modular` VALUES ('483', '481', '广告位置', 'AdPosition', 'index', '2', '', '0', '1', '1', '1505873675', '0');
INSERT INTO `ey_auth_modular` VALUES ('514', '0', '设置', '', '', '0', '', '100', '1', '1', '1527306892', '0');

-- -----------------------------
-- Table structure for `ey_auth_role`
-- -----------------------------
DROP TABLE IF EXISTS `ey_auth_role`;
CREATE TABLE `ey_auth_role` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) DEFAULT '' COMMENT '角色名',
  `pid` int(10) DEFAULT '0' COMMENT '父角色ID',
  `remark` text COMMENT '备注信息',
  `grade` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT '级别',
  `language` text COMMENT '多语言权限',
  `online_update` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '在线升级',
  `switch_map` tinyint(1) DEFAULT '0' COMMENT '功能地图',
  `only_oneself` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '只看自己发布',
  `check_oneself` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '发布文档自动通过审核，1--是，0--否',
  `cud` varchar(255) DEFAULT '' COMMENT '增改删',
  `permission` longtext COMMENT '已允许的权限',
  `built_in` tinyint(1) DEFAULT '0' COMMENT '内置用户组，1表示内置',
  `sort_order` int(10) DEFAULT '0' COMMENT '排序号',
  `status` tinyint(1) DEFAULT '1' COMMENT '状态(1=正常，0=屏蔽)',
  `admin_id` int(10) DEFAULT '0' COMMENT '操作管理员ID',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COMMENT='管理员角色表';

-- -----------------------------
-- Records of `ey_auth_role`
-- -----------------------------
INSERT INTO `ey_auth_role` VALUES ('1', '优化推广员', '0', '', '0', 'a:1:{i:0;s:2:\"cn\";}', '0', '1', '1', '1', 'a:3:{i:0;s:3:\"add\";i:1;s:4:\"edit\";i:2;s:3:\"del\";}', 'a:2:{s:5:\"rules\";a:8:{i:0;s:1:\"1\";i:1;s:1:\"3\";i:2;s:1:\"4\";i:3;s:1:\"8\";i:4;s:1:\"9\";i:5;s:2:\"10\";i:6;s:2:\"14\";i:7;i:2;}s:7:\"arctype\";a:40:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";i:3;s:1:\"4\";i:4;s:1:\"5\";i:5;s:1:\"6\";i:6;s:2:\"33\";i:7;s:2:\"34\";i:8;s:2:\"35\";i:9;s:2:\"36\";i:10;s:2:\"37\";i:11;s:2:\"38\";i:12;s:2:\"39\";i:13;s:2:\"40\";i:14;s:2:\"41\";i:15;s:2:\"42\";i:16;s:2:\"43\";i:17;s:2:\"44\";i:18;s:2:\"45\";i:19;s:2:\"46\";i:20;s:2:\"47\";i:21;s:2:\"48\";i:22;s:1:\"8\";i:23;s:2:\"32\";i:24;s:1:\"9\";i:25;s:2:\"30\";i:26;s:2:\"31\";i:27;s:2:\"11\";i:28;s:2:\"12\";i:29;s:2:\"13\";i:30;s:2:\"23\";i:31;s:2:\"20\";i:32;s:2:\"24\";i:33;s:2:\"25\";i:34;s:2:\"21\";i:35;s:2:\"26\";i:36;s:2:\"22\";i:37;s:2:\"27\";i:38;s:2:\"28\";i:39;s:2:\"29\";}}', '1', '100', '1', '0', '1541207843', '0');
INSERT INTO `ey_auth_role` VALUES ('2', '内容管理员', '0', '', '0', 'a:1:{i:0;s:2:\"cn\";}', '0', '1', '1', '1', 'a:3:{i:0;s:3:\"add\";i:1;s:4:\"edit\";i:2;s:3:\"del\";}', 'a:2:{s:5:\"rules\";a:4:{i:0;s:1:\"1\";i:1;s:2:\"10\";i:2;s:2:\"14\";i:3;i:2;}s:7:\"arctype\";a:40:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";i:3;s:1:\"4\";i:4;s:1:\"5\";i:5;s:1:\"6\";i:6;s:2:\"33\";i:7;s:2:\"34\";i:8;s:2:\"35\";i:9;s:2:\"36\";i:10;s:2:\"37\";i:11;s:2:\"38\";i:12;s:2:\"39\";i:13;s:2:\"40\";i:14;s:2:\"41\";i:15;s:2:\"42\";i:16;s:2:\"43\";i:17;s:2:\"44\";i:18;s:2:\"45\";i:19;s:2:\"46\";i:20;s:2:\"47\";i:21;s:2:\"48\";i:22;s:1:\"8\";i:23;s:2:\"32\";i:24;s:1:\"9\";i:25;s:2:\"30\";i:26;s:2:\"31\";i:27;s:2:\"11\";i:28;s:2:\"12\";i:29;s:2:\"13\";i:30;s:2:\"23\";i:31;s:2:\"20\";i:32;s:2:\"24\";i:33;s:2:\"25\";i:34;s:2:\"21\";i:35;s:2:\"26\";i:36;s:2:\"22\";i:37;s:2:\"27\";i:38;s:2:\"28\";i:39;s:2:\"29\";}}', '1', '100', '1', '0', '1541207846', '0');

-- -----------------------------
-- Table structure for `ey_auth_role_admin`
-- -----------------------------
DROP TABLE IF EXISTS `ey_auth_role_admin`;
CREATE TABLE `ey_auth_role_admin` (
  `role_id` int(11) DEFAULT '0' COMMENT '角色 id',
  `admin_id` int(11) DEFAULT '0' COMMENT '用户id',
  KEY `role_id` (`role_id`) USING BTREE,
  KEY `admin_id` (`admin_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='用户角色对应表';

-- -----------------------------
-- Records of `ey_auth_role_admin`
-- -----------------------------
INSERT INTO `ey_auth_role_admin` VALUES ('-1', '1');
INSERT INTO `ey_auth_role_admin` VALUES ('11', '22');
INSERT INTO `ey_auth_role_admin` VALUES ('12', '17');
INSERT INTO `ey_auth_role_admin` VALUES ('12', '16');

-- -----------------------------
-- Table structure for `ey_auth_rule`
-- -----------------------------
DROP TABLE IF EXISTS `ey_auth_rule`;
CREATE TABLE `ey_auth_rule` (
  `id` smallint(6) unsigned NOT NULL AUTO_INCREMENT,
  `modular_id` int(11) DEFAULT '0' COMMENT '所属模块',
  `name` varchar(50) DEFAULT '' COMMENT '权限名字',
  `right` text COMMENT '权限码(控制器+操作)',
  `remark` varchar(255) DEFAULT '' COMMENT '备注',
  `is_del` tinyint(1) DEFAULT '0' COMMENT '删除状态 1删除,0正常',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  `sort_order` int(11) DEFAULT '0' COMMENT '排序号',
  `is_menu` tinyint(1) DEFAULT '1' COMMENT '是否为菜单(1=是，0=否)',
  `group` varchar(20) DEFAULT '' COMMENT '应用名称app',
  `status` tinyint(1) DEFAULT '1' COMMENT '显示(1=正常，0=屏蔽)',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=213 DEFAULT CHARSET=utf8 COMMENT='后台权限菜单表';

-- -----------------------------
-- Records of `ey_auth_rule`
-- -----------------------------
INSERT INTO `ey_auth_rule` VALUES ('6', '17', '权限列表', 'Admin@rule', '', '0', '0', '1503390907', '0', '1', 'system', '1');
INSERT INTO `ey_auth_rule` VALUES ('8', '14', '管理员列表', 'Admin@index', '', '0', '0', '1503392270', '0', '1', 'system', '1');
INSERT INTO `ey_auth_rule` VALUES ('9', '15', '角色列表', 'Admin@role', '', '0', '0', '1503392666', '0', '1', 'system', '1');
INSERT INTO `ey_auth_rule` VALUES ('38', '19', '数据备份列表', 'Tools@index', '', '0', '0', '1504515434', '0', '1', 'tools', '1');
INSERT INTO `ey_auth_rule` VALUES ('39', '21', '数据还原列表', 'Tools@restore', '', '0', '0', '1504515452', '0', '1', 'tools', '1');
INSERT INTO `ey_auth_rule` VALUES ('49', '18', '管理员日志', 'Admin@log', '', '0', '0', '1504485820', '0', '1', 'system', '1');
INSERT INTO `ey_auth_rule` VALUES ('61', '35', '清除页面缓存', 'System@clearCache,System@clearHtmlCache', '', '0', '0', '1519357846', '0', '1', 'system', '1');
INSERT INTO `ey_auth_rule` VALUES ('62', '13', '修改管理员密码', 'Admin@admin_pwd', '', '0', '0', '1504485678', '0', '1', 'system', '1');
INSERT INTO `ey_auth_rule` VALUES ('65', '17', '新增权限', 'Admin@rule_add', '', '0', '1503390930', '1503391981', '0', '1', '', '1');
INSERT INTO `ey_auth_rule` VALUES ('66', '17', '编辑权限', 'Admin@rule_edit,Index@changeTableVal', '', '0', '1503390947', '1503392474', '0', '1', '', '1');
INSERT INTO `ey_auth_rule` VALUES ('67', '17', '删除权限', 'Admin@rule_del', '', '0', '1503390965', '0', '0', '1', '', '1');
INSERT INTO `ey_auth_rule` VALUES ('70', '14', '新增管理员', 'Admin@admin_add', '', '0', '1503392290', '0', '0', '1', '', '1');
INSERT INTO `ey_auth_rule` VALUES ('71', '14', '编辑管理员', 'Admin@admin_edit,Index@changeTableVal', '', '0', '1503392302', '1517986419', '0', '1', '', '1');
INSERT INTO `ey_auth_rule` VALUES ('72', '14', '删除管理员', 'Admin@admin_del', '', '0', '1503392315', '1504578385', '0', '1', '', '1');
INSERT INTO `ey_auth_rule` VALUES ('73', '16', '模块列表', 'Admin@modular', '', '0', '1503392570', '0', '0', '1', '', '1');
INSERT INTO `ey_auth_rule` VALUES ('74', '16', '新增模块', 'Admin@modular_add', '', '0', '1503392591', '0', '0', '1', '', '1');
INSERT INTO `ey_auth_rule` VALUES ('75', '16', '编辑模块', 'Admin@modular_edit,Index@changeTableVal', '', '0', '1503392610', '0', '0', '1', '', '1');
INSERT INTO `ey_auth_rule` VALUES ('76', '16', '删除模块', 'Admin@modular_del', '', '0', '1503392626', '0', '0', '1', '', '1');
INSERT INTO `ey_auth_rule` VALUES ('77', '15', '新增角色', 'Admin@role_add', '', '0', '1503392691', '0', '0', '1', '', '1');
INSERT INTO `ey_auth_rule` VALUES ('78', '15', '编辑角色', 'Admin@role_edit,Index@changeTableVal', '', '0', '1503392718', '1517986448', '0', '1', '', '1');
INSERT INTO `ey_auth_rule` VALUES ('79', '15', '删除角色', 'Admin@role_del', '', '0', '1503392736', '0', '0', '1', '', '1');
INSERT INTO `ey_auth_rule` VALUES ('81', '12', '平台设置', 'System@index,System@handle', '', '0', '1504486050', '0', '0', '1', '', '1');
INSERT INTO `ey_auth_rule` VALUES ('117', '19', '备份数据', 'Tools@export', '', '0', '1504514716', '0', '0', '1', '', '1');
INSERT INTO `ey_auth_rule` VALUES ('118', '19', '优化数据', 'Tools@optimize', '', '0', '1504514788', '0', '0', '1', '', '1');
INSERT INTO `ey_auth_rule` VALUES ('119', '19', '修复数据', 'Tools@repair', '', '0', '1504514809', '0', '0', '1', '', '1');
INSERT INTO `ey_auth_rule` VALUES ('120', '21', '导入sql文件', 'Tools@restoreUpload', '', '0', '1504515139', '0', '0', '1', '', '1');
INSERT INTO `ey_auth_rule` VALUES ('121', '21', '恢复数据 ', 'Tools@import', '', '0', '1504515184', '0', '0', '1', '', '1');
INSERT INTO `ey_auth_rule` VALUES ('122', '21', '下载数据', 'Tools@downFile', '', '0', '1504515311', '0', '0', '1', '', '1');
INSERT INTO `ey_auth_rule` VALUES ('123', '21', '删除数据', 'Tools@del', '', '0', '1504515399', '0', '0', '1', '', '1');
INSERT INTO `ey_auth_rule` VALUES ('128', '64', '短信模板列表', 'SmsTemplate@index', '', '0', '1517987270', '0', '0', '1', '', '1');
INSERT INTO `ey_auth_rule` VALUES ('129', '64', '新增短信模板', 'SmsTemplate@add', '', '0', '1517987289', '0', '0', '1', '', '1');
INSERT INTO `ey_auth_rule` VALUES ('130', '64', '编辑短信模板', 'SmsTemplate@edit,Index@changeTableVal', '', '0', '1517987336', '0', '0', '1', '', '1');
INSERT INTO `ey_auth_rule` VALUES ('131', '64', '删除短信模板', 'SmsTemplate@del', '', '0', '1517987359', '0', '0', '1', '', '1');
INSERT INTO `ey_auth_rule` VALUES ('132', '62', '邮件模板列表', 'EmailTemplate@index', '', '0', '1517987387', '0', '0', '1', '', '1');
INSERT INTO `ey_auth_rule` VALUES ('133', '62', '新增邮件模板', 'EmailTemplate@add', '', '0', '1517994951', '0', '0', '1', '', '1');
INSERT INTO `ey_auth_rule` VALUES ('134', '62', '编辑邮件模板', 'EmailTemplate@edit,Index@changeTableVal', '', '0', '1517994976', '0', '0', '1', '', '1');
INSERT INTO `ey_auth_rule` VALUES ('135', '62', '删除邮件模板', 'EmailTemplate@del', '', '0', '1517995005', '0', '0', '1', '', '1');
INSERT INTO `ey_auth_rule` VALUES ('140', '480', '友情链接列表', 'Links@index', '', '0', '1517995297', '0', '0', '1', '', '1');
INSERT INTO `ey_auth_rule` VALUES ('141', '480', '新增友情链接', 'Links@add', '', '0', '1517995311', '0', '0', '1', '', '1');
INSERT INTO `ey_auth_rule` VALUES ('142', '480', '编辑友情链接', 'Links@edit,Index@changeTableVal', '', '0', '1517995329', '0', '0', '1', '', '1');
INSERT INTO `ey_auth_rule` VALUES ('143', '480', '删除友情链接', 'Links@del', '', '0', '1517995344', '0', '0', '1', '', '1');
INSERT INTO `ey_auth_rule` VALUES ('144', '483', '广告位列表', 'AdPosition@index', '', '0', '1517995508', '0', '0', '1', '', '1');
INSERT INTO `ey_auth_rule` VALUES ('145', '483', '新增广告位', 'AdPosition@add', '', '0', '1517995525', '0', '0', '1', '', '1');
INSERT INTO `ey_auth_rule` VALUES ('146', '483', '编辑广告位', 'AdPosition@edit,Index@changeTableVal', '', '0', '1517995544', '0', '0', '1', '', '1');
INSERT INTO `ey_auth_rule` VALUES ('147', '483', '删除广告位', 'AdPosition@del', '', '0', '1517995556', '0', '0', '1', '', '1');
INSERT INTO `ey_auth_rule` VALUES ('148', '482', '广告列表', 'Ad@index', '', '0', '1517995581', '0', '0', '1', '', '1');
INSERT INTO `ey_auth_rule` VALUES ('149', '482', '新增广告', 'Ad@add', '', '0', '1517995595', '0', '0', '1', '', '1');
INSERT INTO `ey_auth_rule` VALUES ('150', '482', '编辑广告', 'Ad@edit,Index@changeTableVal', '', '0', '1517995612', '0', '0', '1', '', '1');
INSERT INTO `ey_auth_rule` VALUES ('151', '482', '删除广告', 'Ad@del', '', '0', '1517995626', '0', '0', '1', '', '1');
INSERT INTO `ey_auth_rule` VALUES ('212', '35', '清除数据缓存', 'System@clearCache,System@clearSystemCache,System@fastClearCache', '', '0', '1519357889', '0', '0', '1', '', '1');

-- -----------------------------
-- Table structure for `ey_channelfield`
-- -----------------------------
DROP TABLE IF EXISTS `ey_channelfield`;
CREATE TABLE `ey_channelfield` (
  `id` int(10) NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `name` varchar(32) NOT NULL DEFAULT '' COMMENT '字段名称',
  `channel_id` int(10) NOT NULL DEFAULT '0' COMMENT '所属文档模型id',
  `title` varchar(250) NOT NULL DEFAULT '' COMMENT '字段标题',
  `dtype` varchar(32) NOT NULL DEFAULT '' COMMENT '字段类型',
  `define` text NOT NULL COMMENT '字段定义',
  `maxlength` int(10) NOT NULL DEFAULT '0' COMMENT '最大长度，文本数据必须填写，大于255为text类型',
  `dfvalue` text NOT NULL COMMENT '默认值',
  `dfvalue_unit` varchar(50) NOT NULL DEFAULT '' COMMENT '数值单位',
  `remark` varchar(256) NOT NULL DEFAULT '' COMMENT '提示说明',
  `is_screening` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否应用于条件筛选',
  `is_release` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否应用于会员投稿发布',
  `ifeditable` tinyint(1) NOT NULL DEFAULT '1' COMMENT '是否在编辑页显示',
  `ifrequire` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否必填',
  `ifsystem` tinyint(1) NOT NULL DEFAULT '0' COMMENT '字段分类，1=系统(不可修改)，0=自定义',
  `ifmain` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否主表字段',
  `ifcontrol` tinyint(1) NOT NULL DEFAULT '1' COMMENT '状态，控制该条数据是否允许被控制，1为不允许控制，0为允许控制',
  `sort_order` int(5) NOT NULL DEFAULT '100' COMMENT '排序',
  `status` tinyint(1) NOT NULL DEFAULT '1' COMMENT '状态',
  `add_time` int(11) NOT NULL DEFAULT '0' COMMENT '创建时间',
  `update_time` int(11) NOT NULL DEFAULT '0' COMMENT '更新时间',
  `set_type` tinyint(3) DEFAULT '0' COMMENT '区域选择时使用是否为三级联动,1-是',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=201 DEFAULT CHARSET=utf8 COMMENT='自定义字段表';

-- -----------------------------
-- Records of `ey_channelfield`
-- -----------------------------
INSERT INTO `ey_channelfield` VALUES ('1', 'add_time', '0', '新增时间', 'datetime', 'int(11)', '250', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533091575', '1533091575', '0');
INSERT INTO `ey_channelfield` VALUES ('2', 'update_time', '0', '更新时间', 'datetime', 'int(11)', '250', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533091601', '1533091601', '0');
INSERT INTO `ey_channelfield` VALUES ('3', 'aid', '0', '文档ID', 'int', 'int(11)', '250', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533091624', '1533091624', '0');
INSERT INTO `ey_channelfield` VALUES ('4', 'typeid', '0', '当前栏目ID', 'int', 'int(11)', '250', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533091930', '1533091930', '0');
INSERT INTO `ey_channelfield` VALUES ('5', 'channel', '0', '模型ID', 'int', 'int(11)', '250', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533092214', '1533092214', '0');
INSERT INTO `ey_channelfield` VALUES ('6', 'is_b', '0', '是否加粗', 'switch', 'tinyint(1)', '250', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533092246', '1533092246', '0');
INSERT INTO `ey_channelfield` VALUES ('7', 'title', '0', '文档标题', 'text', 'varchar(250)', '250', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533092381', '1533092381', '0');
INSERT INTO `ey_channelfield` VALUES ('8', 'litpic', '0', '缩略图', 'img', 'varchar(250)', '250', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533092398', '1533092398', '0');
INSERT INTO `ey_channelfield` VALUES ('9', 'is_head', '0', '是否头条', 'switch', 'tinyint(1)', '250', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533092420', '1533092420', '0');
INSERT INTO `ey_channelfield` VALUES ('10', 'is_special', '0', '是否特荐', 'switch', 'tinyint(1)', '250', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533092439', '1533092439', '0');
INSERT INTO `ey_channelfield` VALUES ('11', 'is_top', '0', '是否置顶', 'switch', 'tinyint(1)', '250', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533092454', '1533092454', '0');
INSERT INTO `ey_channelfield` VALUES ('12', 'is_recom', '0', '是否推荐', 'switch', 'tinyint(1)', '250', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533092468', '1533092468', '0');
INSERT INTO `ey_channelfield` VALUES ('13', 'is_jump', '0', '是否跳转', 'switch', 'tinyint(1)', '250', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533092484', '1533092484', '0');
INSERT INTO `ey_channelfield` VALUES ('14', 'author', '0', '作者', 'text', 'varchar(250)', '250', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533092498', '1533092498', '0');
INSERT INTO `ey_channelfield` VALUES ('15', 'click', '0', '浏览量', 'int', 'int(11)', '250', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533092512', '1533092512', '0');
INSERT INTO `ey_channelfield` VALUES ('16', 'arcrank', '0', '阅读权限', 'select', 'tinyint(1)', '250', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533092534', '1533092534', '0');
INSERT INTO `ey_channelfield` VALUES ('17', 'jumplinks', '0', '跳转链接', 'text', 'varchar(250)', '250', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533092553', '1533092553', '0');
INSERT INTO `ey_channelfield` VALUES ('18', 'ismake', '0', '是否静态页面', 'switch', 'tinyint(1)', '250', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533092698', '1533092698', '0');
INSERT INTO `ey_channelfield` VALUES ('19', 'seo_title', '0', 'SEO标题', 'text', 'varchar(250)', '250', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533092713', '1533092713', '0');
INSERT INTO `ey_channelfield` VALUES ('20', 'seo_keywords', '0', 'SEO关键词', 'text', 'varchar(250)', '250', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533092725', '1533092725', '0');
INSERT INTO `ey_channelfield` VALUES ('21', 'seo_description', '0', 'SEO描述', 'text', 'varchar(250)', '250', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533092739', '1533092739', '0');
INSERT INTO `ey_channelfield` VALUES ('22', 'status', '0', '状态', 'switch', 'tinyint(1)', '250', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533092753', '1533092753', '0');
INSERT INTO `ey_channelfield` VALUES ('23', 'sort_order', '0', '排序号', 'int', 'int(11)', '250', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533092766', '1533092766', '0');
INSERT INTO `ey_channelfield` VALUES ('24', 'content', '2', '内容详情', 'htmltext', 'longtext', '250', '', '', '', '0', '1', '1', '0', '1', '0', '0', '100', '1', '1533359739', '1533359739', '0');
INSERT INTO `ey_channelfield` VALUES ('25', 'content', '3', '内容详情', 'htmltext', 'longtext', '250', '', '', '', '0', '1', '1', '0', '1', '0', '0', '100', '1', '1533359588', '1533359588', '0');
INSERT INTO `ey_channelfield` VALUES ('26', 'content', '4', '内容详情', 'htmltext', 'longtext', '250', '', '', '', '0', '1', '1', '0', '1', '0', '0', '100', '1', '1533359752', '1533359752', '0');
INSERT INTO `ey_channelfield` VALUES ('27', 'content', '6', '内容详情', 'htmltext', 'longtext', '250', '', '', '', '0', '1', '1', '0', '1', '0', '0', '100', '1', '1533464715', '1533464715', '0');
INSERT INTO `ey_channelfield` VALUES ('29', 'content', '1', '内容详情', 'htmltext', 'longtext', '250', '', '', '', '0', '1', '1', '0', '1', '0', '0', '100', '1', '1533464713', '1533464713', '0');
INSERT INTO `ey_channelfield` VALUES ('30', 'update_time', '-99', '更新时间', 'datetime', 'int(11)', '11', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533524780', '1533524780', '0');
INSERT INTO `ey_channelfield` VALUES ('31', 'add_time', '-99', '新增时间', 'datetime', 'int(11)', '11', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533524780', '1533524780', '0');
INSERT INTO `ey_channelfield` VALUES ('32', 'status', '-99', '启用 (1=正常，0=屏蔽)', 'switch', 'tinyint(1)', '1', '1', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533524780', '1533524780', '0');
INSERT INTO `ey_channelfield` VALUES ('33', 'is_part', '-99', '栏目属性：0=内容栏目，1=外部链接', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533524780', '1533524780', '0');
INSERT INTO `ey_channelfield` VALUES ('34', 'is_hidden', '-99', '是否隐藏栏目：0=显示，1=隐藏', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533524780', '1533524780', '0');
INSERT INTO `ey_channelfield` VALUES ('35', 'sort_order', '-99', '排序号', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533524780', '1533524780', '0');
INSERT INTO `ey_channelfield` VALUES ('36', 'seo_description', '-99', 'seo描述', 'multitext', 'text', '0', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533524780', '1533524780', '0');
INSERT INTO `ey_channelfield` VALUES ('37', 'seo_keywords', '-99', 'seo关键字', 'text', 'varchar(200)', '200', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533524780', '1533524780', '0');
INSERT INTO `ey_channelfield` VALUES ('38', 'seo_title', '-99', 'SEO标题', 'text', 'varchar(200)', '200', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533524780', '1533524780', '0');
INSERT INTO `ey_channelfield` VALUES ('39', 'tempview', '-99', '文档模板文件名', 'text', 'varchar(200)', '200', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533524780', '1533524780', '0');
INSERT INTO `ey_channelfield` VALUES ('40', 'templist', '-99', '列表模板文件名', 'text', 'varchar(200)', '200', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533524780', '1533524780', '0');
INSERT INTO `ey_channelfield` VALUES ('41', 'litpic', '-99', '栏目图片', 'img', 'varchar(250)', '250', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533524780', '1533524780', '0');
INSERT INTO `ey_channelfield` VALUES ('42', 'typelink', '-99', '栏目链接', 'text', 'varchar(200)', '200', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533524780', '1533524780', '0');
INSERT INTO `ey_channelfield` VALUES ('43', 'grade', '-99', '栏目等级', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533524780', '1533524780', '0');
INSERT INTO `ey_channelfield` VALUES ('44', 'englist_name', '-99', '栏目英文名', 'text', 'varchar(200)', '200', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533524780', '1533524780', '0');
INSERT INTO `ey_channelfield` VALUES ('45', 'dirpath', '-99', '目录存放HTML路径', 'text', 'varchar(200)', '200', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533524780', '1533524780', '0');
INSERT INTO `ey_channelfield` VALUES ('46', 'dirname', '-99', '目录英文名', 'text', 'varchar(200)', '200', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533524780', '1533524780', '0');
INSERT INTO `ey_channelfield` VALUES ('47', 'typename', '-99', '栏目名称', 'text', 'varchar(200)', '200', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533524780', '1533524780', '0');
INSERT INTO `ey_channelfield` VALUES ('48', 'parent_id', '-99', '栏目上级ID', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533524780', '1533524780', '0');
INSERT INTO `ey_channelfield` VALUES ('49', 'current_channel', '-99', '栏目当前模型ID', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533524780', '1533524780', '0');
INSERT INTO `ey_channelfield` VALUES ('50', 'channeltype', '-99', '栏目顶级模型ID', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533524780', '1533524780', '0');
INSERT INTO `ey_channelfield` VALUES ('51', 'id', '-99', '栏目ID', 'int', 'int(10)', '10', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533524780', '1533524780', '0');
INSERT INTO `ey_channelfield` VALUES ('52', 'del_method', '-99', '伪删除状态，1为主动删除，2为跟随上级栏目被动删除', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1547890773', '1547890773', '0');
INSERT INTO `ey_channelfield` VALUES ('53', 'is_del', '0', '伪删除，1=是，0=否', 'switch', 'tinyint(1)', '250', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1547890773', '1547890773', '0');
INSERT INTO `ey_channelfield` VALUES ('54', 'del_method', '0', '伪删除状态，1为主动删除，2为跟随上级栏目被动删除', 'switch', 'tinyint(1)', '250', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1547890773', '1547890773', '0');
INSERT INTO `ey_channelfield` VALUES ('55', 'admin_id', '0', '管理员ID', 'int', 'int(10)', '250', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1547890773', '1547890773', '0');
INSERT INTO `ey_channelfield` VALUES ('56', 'lang', '0', '语言标识', 'text', 'varchar(250)', '250', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1547890773', '1547890773', '0');
INSERT INTO `ey_channelfield` VALUES ('57', 'prom_type', '0', '产品类型：0普通产品，1虚拟产品', 'switch', 'tinyint(1) unsigned', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1557042574', '1557042574', '0');
INSERT INTO `ey_channelfield` VALUES ('58', 'users_price', '0', '价格', 'decimal', 'decimal(10,2)', '10', '0.00', '', '', '0', '0', '1', '0', '1', '1', '0', '100', '1', '1557042574', '1557042574', '0');
INSERT INTO `ey_channelfield` VALUES ('59', 'prom_type', '2', '产品类型：0普通产品，1虚拟产品', 'switch', 'tinyint(1) unsigned', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1557042574', '1557042574', '0');
INSERT INTO `ey_channelfield` VALUES ('60', 'users_price', '2', '价格', 'decimal', 'decimal(10,2)', '10', '0.00', '', '', '0', '0', '1', '0', '1', '1', '0', '100', '1', '1557042574', '1557042574', '0');
INSERT INTO `ey_channelfield` VALUES ('61', 'users_id', '0', '会员ID', 'int', 'int(11)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1557042574', '1557042574', '0');
INSERT INTO `ey_channelfield` VALUES ('62', 'arc_level_id', '0', '文档会员权限ID', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1557042574', '1557042574', '0');
INSERT INTO `ey_channelfield` VALUES ('63', 'arc_level_id', '4', '文档会员权限ID', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1557042574', '1557042574', '0');
INSERT INTO `ey_channelfield` VALUES ('64', 'weapp_code', '-99', '插件栏目唯一标识', 'text', 'varchar(200)', '200', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1557042574', '1557042574', '0');
INSERT INTO `ey_channelfield` VALUES ('65', 'is_release', '-99', '栏目是否应用于会员投稿发布，1是，0否', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1557042574', '1557042574', '0');
INSERT INTO `ey_channelfield` VALUES ('66', 'old_price', '0', '产品旧价', 'decimal', 'decimal(10,2)', '10', '0.00', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1557042574', '1557042574', '0');
INSERT INTO `ey_channelfield` VALUES ('67', 'stock_count', '0', '商品库存量', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1557042574', '1557042574', '0');
INSERT INTO `ey_channelfield` VALUES ('68', 'stock_show', '0', '商品库存在产品详情页是否显示，1为显示，0为不显示', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1557042574', '1557042574', '0');
INSERT INTO `ey_channelfield` VALUES ('69', 'joinaid', '0', '关联文档ID', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1557042574', '1557042574', '0');
INSERT INTO `ey_channelfield` VALUES ('70', 'downcount', '0', '下载次数', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1557042574', '1557042574', '0');
INSERT INTO `ey_channelfield` VALUES ('71', 'downcount', '4', '下载次数', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1557042574', '1557042574', '0');
INSERT INTO `ey_channelfield` VALUES ('72', 'htmlfilename', '0', '自定义文件名', 'text', 'varchar(50)', '50', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1557042574', '1557042574', '0');
INSERT INTO `ey_channelfield` VALUES ('73', 'htmlfilename', '1', '自定义文件名', 'text', 'varchar(50)', '50', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1557042574', '1557042574', '0');
INSERT INTO `ey_channelfield` VALUES ('74', 'htmlfilename', '2', '自定义文件名', 'text', 'varchar(50)', '50', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1557042574', '1557042574', '0');
INSERT INTO `ey_channelfield` VALUES ('75', 'htmlfilename', '3', '自定义文件名', 'text', 'varchar(50)', '50', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1557042574', '1557042574', '0');
INSERT INTO `ey_channelfield` VALUES ('76', 'htmlfilename', '4', '自定义文件名', 'text', 'varchar(50)', '50', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1557042574', '1557042574', '0');
INSERT INTO `ey_channelfield` VALUES ('77', 'htmlfilename', '6', '自定义文件名', 'text', 'varchar(50)', '50', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1557042574', '1557042574', '0');
INSERT INTO `ey_channelfield` VALUES ('78', 'attrlist_id', '0', '参数列表ID', 'int', 'int(10) unsigned', '10', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533091930', '1533091930', '0');
INSERT INTO `ey_channelfield` VALUES ('79', 'sales_num', '0', '销售量', 'int', 'int(10) unsigned', '10', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533091930', '1533091930', '0');
INSERT INTO `ey_channelfield` VALUES ('81', 'topid', '-99', '顶级栏目ID', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1557042574', '1613980400', '0');
INSERT INTO `ey_channelfield` VALUES ('82', 'is_slide', '0', '是否幻灯', 'switch', 'tinyint(1)', '250', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533092420', '1533092420', '0');
INSERT INTO `ey_channelfield` VALUES ('83', 'is_roll', '0', '是否幻灯', 'switch', 'tinyint(1)', '250', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533092420', '1533092420', '0');
INSERT INTO `ey_channelfield` VALUES ('84', 'is_diyattr', '0', '是否自定义', 'switch', 'tinyint(1)', '250', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533092420', '1533092420', '0');
INSERT INTO `ey_channelfield` VALUES ('85', 'update_time', '5', '更新时间', 'datetime', 'int(11)', '11', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1651223510', '1651223510', '0');
INSERT INTO `ey_channelfield` VALUES ('86', 'add_time', '5', '新增时间', 'datetime', 'int(11)', '11', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1651223510', '1651223510', '0');
INSERT INTO `ey_channelfield` VALUES ('87', 'htmlfilename', '5', '自定义文件名', 'text', 'varchar(50)', '50', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1651223510', '1651223510', '0');
INSERT INTO `ey_channelfield` VALUES ('88', 'downcount', '5', '下载次数', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1651223510', '1651223510', '0');
INSERT INTO `ey_channelfield` VALUES ('89', 'joinaid', '5', '关联文档ID', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1651223510', '1651223510', '0');
INSERT INTO `ey_channelfield` VALUES ('90', 'del_method', '5', '伪删除状态，1为主动删除，2为跟随上级栏目被动删除', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1651223510', '1651223510', '0');
INSERT INTO `ey_channelfield` VALUES ('91', 'is_del', '5', '伪删除，1=是，0=否', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1651223510', '1651223510', '0');
INSERT INTO `ey_channelfield` VALUES ('92', 'arc_level_id', '5', '文档会员权限ID', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1651223510', '1651223510', '0');
INSERT INTO `ey_channelfield` VALUES ('93', 'users_id', '5', '会员ID', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1651223510', '1651223510', '0');
INSERT INTO `ey_channelfield` VALUES ('94', 'admin_id', '5', '管理员ID', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1651223510', '1651223510', '0');
INSERT INTO `ey_channelfield` VALUES ('95', 'lang', '5', '语言标识', 'text', 'varchar(50)', '50', 'cn', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1651223510', '1651223510', '0');
INSERT INTO `ey_channelfield` VALUES ('96', 'sort_order', '5', '排序号', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1651223510', '1651223510', '0');
INSERT INTO `ey_channelfield` VALUES ('97', 'status', '5', '状态(0=屏蔽，1=正常)', 'switch', 'tinyint(1)', '1', '1', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1651223510', '1651223510', '0');
INSERT INTO `ey_channelfield` VALUES ('98', 'tempview', '5', '文档模板文件名', 'text', 'varchar(200)', '200', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1651223510', '1651223510', '0');
INSERT INTO `ey_channelfield` VALUES ('99', 'prom_type', '5', '产品类型：0=普通产品，1=虚拟(默认手动发货)，2=虚拟(网盘', 'switch', 'tinyint(1) unsigned', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1651223510', '1651223510', '0');
INSERT INTO `ey_channelfield` VALUES ('100', 'stock_show', '5', '商品库存在产品详情页是否显示，1为显示，0为不显示', 'switch', 'tinyint(1) unsigned', '1', '1', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1651223510', '1651223510', '0');
INSERT INTO `ey_channelfield` VALUES ('101', 'stock_count', '5', '商品库存量', 'int', 'int(10) unsigned', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1651223510', '1651223510', '0');
INSERT INTO `ey_channelfield` VALUES ('102', 'sales_num', '5', '销售量', 'int', 'int(10) unsigned', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1651223510', '1651223510', '0');
INSERT INTO `ey_channelfield` VALUES ('103', 'old_price', '5', '产品旧价', 'decimal', 'decimal(10,2)', '10', '0.00', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1651223510', '1651223510', '0');
INSERT INTO `ey_channelfield` VALUES ('104', 'users_free', '5', '是否会员免费，默认0不免费，1为免费', 'switch', 'tinyint(1) unsigned', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1651223510', '1651223510', '0');
INSERT INTO `ey_channelfield` VALUES ('105', 'users_price', '5', '会员价', 'decimal', 'decimal(10,2)', '10', '0.00', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1651223510', '1651223510', '0');
INSERT INTO `ey_channelfield` VALUES ('106', 'attrlist_id', '5', '参数列表ID', 'int', 'int(10) unsigned', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1651223510', '1651223510', '0');
INSERT INTO `ey_channelfield` VALUES ('107', 'seo_description', '5', 'SEO描述', 'multitext', 'text', '0', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1651223510', '1651223510', '0');
INSERT INTO `ey_channelfield` VALUES ('108', 'seo_keywords', '5', 'SEO关键词', 'text', 'varchar(200)', '200', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1651223510', '1651223510', '0');
INSERT INTO `ey_channelfield` VALUES ('109', 'seo_title', '5', 'SEO标题', 'text', 'varchar(200)', '200', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1651223510', '1651223510', '0');
INSERT INTO `ey_channelfield` VALUES ('110', 'ismake', '5', '是否静态页面（0=动态，1=静态）', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1651223510', '1651223510', '0');
INSERT INTO `ey_channelfield` VALUES ('111', 'jumplinks', '5', '外链跳转', 'text', 'varchar(200)', '200', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1651223510', '1651223510', '0');
INSERT INTO `ey_channelfield` VALUES ('112', 'arcrank', '5', '阅读权限：0=开放浏览，-1=待审核稿件', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1651223510', '1651223510', '0');
INSERT INTO `ey_channelfield` VALUES ('113', 'click', '5', '浏览量', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1651223510', '1651223510', '0');
INSERT INTO `ey_channelfield` VALUES ('114', 'author', '5', '作者', 'text', 'varchar(200)', '200', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1651223510', '1651223510', '0');
INSERT INTO `ey_channelfield` VALUES ('115', 'is_diyattr', '5', '自定义（0=否，1=是）', 'switch', 'tinyint(1) unsigned', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1651223510', '1651223510', '0');
INSERT INTO `ey_channelfield` VALUES ('116', 'is_slide', '5', '幻灯（0=否，1=是）', 'switch', 'tinyint(1) unsigned', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1651223510', '1651223510', '0');
INSERT INTO `ey_channelfield` VALUES ('117', 'is_roll', '5', '滚动（0=否，1=是）', 'switch', 'tinyint(1) unsigned', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1651223510', '1651223510', '0');
INSERT INTO `ey_channelfield` VALUES ('118', 'is_litpic', '5', '图片（0=否，1=是）', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1651223510', '1651223510', '0');
INSERT INTO `ey_channelfield` VALUES ('119', 'is_jump', '5', '跳转链接（0=否，1=是）', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1651223510', '1651223510', '0');
INSERT INTO `ey_channelfield` VALUES ('120', 'is_recom', '5', '推荐（0=否，1=是）', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1651223510', '1651223510', '0');
INSERT INTO `ey_channelfield` VALUES ('121', 'is_top', '5', '置顶（0=否，1=是）', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1651223510', '1651223510', '0');
INSERT INTO `ey_channelfield` VALUES ('122', 'is_special', '5', '特荐（0=否，1=是）', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1651223510', '1651223510', '0');
INSERT INTO `ey_channelfield` VALUES ('123', 'is_head', '5', '头条（0=否，1=是）', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1651223510', '1651223510', '0');
INSERT INTO `ey_channelfield` VALUES ('124', 'litpic', '5', '缩略图', 'img', 'varchar(250)', '250', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1651223510', '1651223510', '0');
INSERT INTO `ey_channelfield` VALUES ('125', 'title', '5', '标题', 'text', 'varchar(200)', '200', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1651223510', '1651223510', '0');
INSERT INTO `ey_channelfield` VALUES ('126', 'is_b', '5', '加粗', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1651223510', '1651223510', '0');
INSERT INTO `ey_channelfield` VALUES ('127', 'channel', '5', '模型ID', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1651223510', '1651223510', '0');
INSERT INTO `ey_channelfield` VALUES ('128', 'typeid', '5', '当前栏目', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1651223510', '1651223510', '0');
INSERT INTO `ey_channelfield` VALUES ('129', 'aid', '5', 'aid', 'int', 'int(10)', '10', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1651223510', '1651223510', '0');
INSERT INTO `ey_channelfield` VALUES ('130', 'content', '5', '内容详情', 'htmltext', 'longtext', '0', '', '', '', '0', '1', '1', '0', '1', '0', '0', '100', '1', '1651223510', '1651223510', '0');
INSERT INTO `ey_channelfield` VALUES ('131', 'courseware', '5', '课件地址', 'text', 'varchar(200)', '200', '', '', '', '0', '1', '0', '0', '1', '0', '1', '100', '1', '1651223510', '1651223510', '0');
INSERT INTO `ey_channelfield` VALUES ('132', 'courseware_free', '5', '课件收费', 'select', 'enum(\'免费\',\'收费\')', '0', '免费,收费', '', '', '0', '1', '0', '0', '1', '0', '1', '100', '1', '1651223510', '1651223510', '0');
INSERT INTO `ey_channelfield` VALUES ('133', 'total_duration', '5', '视频总时长', 'int', 'int(10)', '10', '0', '', '', '0', '1', '0', '0', '1', '0', '1', '100', '1', '1651223510', '1651223510', '0');
INSERT INTO `ey_channelfield` VALUES ('134', 'total_video', '5', '视频数', 'int', 'int(10)', '10', '0', '', '', '0', '1', '0', '0', '1', '0', '1', '100', '1', '1651223510', '1651223510', '0');
INSERT INTO `ey_channelfield` VALUES ('135', 'update_time', '7', '更新时间', 'datetime', 'int(11)', '11', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1651223510', '1651223510', '0');
INSERT INTO `ey_channelfield` VALUES ('136', 'add_time', '7', '新增时间', 'datetime', 'int(11)', '11', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1651223510', '1651223510', '0');
INSERT INTO `ey_channelfield` VALUES ('137', 'htmlfilename', '7', '自定义文件名', 'text', 'varchar(50)', '50', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1651223510', '1651223510', '0');
INSERT INTO `ey_channelfield` VALUES ('138', 'downcount', '7', '下载次数', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1651223510', '1651223510', '0');
INSERT INTO `ey_channelfield` VALUES ('139', 'joinaid', '7', '关联文档ID', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1651223510', '1651223510', '0');
INSERT INTO `ey_channelfield` VALUES ('140', 'del_method', '7', '伪删除状态，1为主动删除，2为跟随上级栏目被动删除', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1651223510', '1651223510', '0');
INSERT INTO `ey_channelfield` VALUES ('141', 'is_del', '7', '伪删除，1=是，0=否', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1651223510', '1651223510', '0');
INSERT INTO `ey_channelfield` VALUES ('142', 'arc_level_id', '7', '文档会员权限ID', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1651223510', '1651223510', '0');
INSERT INTO `ey_channelfield` VALUES ('143', 'users_id', '7', '会员ID', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1651223510', '1651223510', '0');
INSERT INTO `ey_channelfield` VALUES ('144', 'admin_id', '7', '管理员ID', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1651223510', '1651223510', '0');
INSERT INTO `ey_channelfield` VALUES ('145', 'lang', '7', '语言标识', 'text', 'varchar(50)', '50', 'cn', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1651223510', '1651223510', '0');
INSERT INTO `ey_channelfield` VALUES ('146', 'sort_order', '7', '排序号', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1651223510', '1651223510', '0');
INSERT INTO `ey_channelfield` VALUES ('147', 'status', '7', '状态(0=屏蔽，1=正常)', 'switch', 'tinyint(1)', '1', '1', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1651223510', '1651223510', '0');
INSERT INTO `ey_channelfield` VALUES ('148', 'tempview', '7', '文档模板文件名', 'text', 'varchar(200)', '200', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1651223510', '1651223510', '0');
INSERT INTO `ey_channelfield` VALUES ('149', 'prom_type', '7', '产品类型：0=普通产品，1=虚拟(默认手动发货)，2=虚拟(网盘', 'switch', 'tinyint(1) unsigned', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1651223510', '1651223510', '0');
INSERT INTO `ey_channelfield` VALUES ('150', 'stock_show', '7', '商品库存在产品详情页是否显示，1为显示，0为不显示', 'switch', 'tinyint(1) unsigned', '1', '1', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1651223510', '1651223510', '0');
INSERT INTO `ey_channelfield` VALUES ('151', 'stock_count', '7', '商品库存量', 'int', 'int(10) unsigned', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1651223510', '1651223510', '0');
INSERT INTO `ey_channelfield` VALUES ('152', 'sales_num', '7', '销售量', 'int', 'int(10) unsigned', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1651223510', '1651223510', '0');
INSERT INTO `ey_channelfield` VALUES ('153', 'old_price', '7', '产品旧价', 'decimal', 'decimal(10,2)', '10', '0.00', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1651223510', '1651223510', '0');
INSERT INTO `ey_channelfield` VALUES ('154', 'users_free', '7', '是否会员免费，默认0不免费，1为免费', 'switch', 'tinyint(1) unsigned', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1651223510', '1651223510', '0');
INSERT INTO `ey_channelfield` VALUES ('155', 'users_price', '7', '会员价', 'decimal', 'decimal(10,2)', '10', '0.00', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1651223510', '1651223510', '0');
INSERT INTO `ey_channelfield` VALUES ('156', 'attrlist_id', '7', '参数列表ID', 'int', 'int(10) unsigned', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1651223510', '1651223510', '0');
INSERT INTO `ey_channelfield` VALUES ('157', 'seo_description', '7', 'SEO描述', 'multitext', 'text', '0', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1651223510', '1651223510', '0');
INSERT INTO `ey_channelfield` VALUES ('158', 'seo_keywords', '7', 'SEO关键词', 'text', 'varchar(200)', '200', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1651223510', '1651223510', '0');
INSERT INTO `ey_channelfield` VALUES ('159', 'seo_title', '7', 'SEO标题', 'text', 'varchar(200)', '200', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1651223510', '1651223510', '0');
INSERT INTO `ey_channelfield` VALUES ('160', 'ismake', '7', '是否静态页面（0=动态，1=静态）', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1651223510', '1651223510', '0');
INSERT INTO `ey_channelfield` VALUES ('161', 'jumplinks', '7', '外链跳转', 'text', 'varchar(200)', '200', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1651223510', '1651223510', '0');
INSERT INTO `ey_channelfield` VALUES ('162', 'arcrank', '7', '阅读权限：0=开放浏览，-1=待审核稿件', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1651223510', '1651223510', '0');
INSERT INTO `ey_channelfield` VALUES ('163', 'click', '7', '浏览量', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1651223510', '1651223510', '0');
INSERT INTO `ey_channelfield` VALUES ('164', 'author', '7', '作者', 'text', 'varchar(200)', '200', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1651223510', '1651223510', '0');
INSERT INTO `ey_channelfield` VALUES ('165', 'is_diyattr', '7', '自定义（0=否，1=是）', 'switch', 'tinyint(1) unsigned', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1651223510', '1651223510', '0');
INSERT INTO `ey_channelfield` VALUES ('166', 'is_slide', '7', '幻灯（0=否，1=是）', 'switch', 'tinyint(1) unsigned', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1651223510', '1651223510', '0');
INSERT INTO `ey_channelfield` VALUES ('167', 'is_roll', '7', '滚动（0=否，1=是）', 'switch', 'tinyint(1) unsigned', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1651223510', '1651223510', '0');
INSERT INTO `ey_channelfield` VALUES ('168', 'is_litpic', '7', '图片（0=否，1=是）', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1651223510', '1651223510', '0');
INSERT INTO `ey_channelfield` VALUES ('169', 'is_jump', '7', '跳转链接（0=否，1=是）', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1651223510', '1651223510', '0');
INSERT INTO `ey_channelfield` VALUES ('170', 'is_recom', '7', '推荐（0=否，1=是）', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1651223510', '1651223510', '0');
INSERT INTO `ey_channelfield` VALUES ('171', 'is_top', '7', '置顶（0=否，1=是）', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1651223510', '1651223510', '0');
INSERT INTO `ey_channelfield` VALUES ('172', 'is_special', '7', '特荐（0=否，1=是）', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1651223510', '1651223510', '0');
INSERT INTO `ey_channelfield` VALUES ('173', 'is_head', '7', '头条（0=否，1=是）', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1651223510', '1651223510', '0');
INSERT INTO `ey_channelfield` VALUES ('174', 'litpic', '7', '缩略图', 'img', 'varchar(250)', '250', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1651223510', '1651223510', '0');
INSERT INTO `ey_channelfield` VALUES ('175', 'title', '7', '标题', 'text', 'varchar(200)', '200', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1651223510', '1651223510', '0');
INSERT INTO `ey_channelfield` VALUES ('176', 'is_b', '7', '加粗', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1651223510', '1651223510', '0');
INSERT INTO `ey_channelfield` VALUES ('177', 'channel', '7', '模型ID', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1651223510', '1651223510', '0');
INSERT INTO `ey_channelfield` VALUES ('178', 'typeid', '7', '当前栏目', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1651223510', '1651223510', '0');
INSERT INTO `ey_channelfield` VALUES ('179', 'aid', '7', 'aid', 'int', 'int(10)', '10', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1651223510', '1651223510', '0');
INSERT INTO `ey_channelfield` VALUES ('180', 'content', '7', '内容详情', 'htmltext', 'longtext', '0', '', '', '', '0', '1', '1', '0', '1', '0', '0', '100', '1', '1651223510', '1651223510', '0');
INSERT INTO `ey_channelfield` VALUES ('181', 'appraise', '0', '评价数', 'int', 'int(10)', '250', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533091930', '1533091930', '0');
INSERT INTO `ey_channelfield` VALUES ('182', 'collection', '0', '收藏数', 'int', 'int(10)', '250', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533091930', '1533091930', '0');
INSERT INTO `ey_channelfield` VALUES ('183', 'subtitle', '0', '副标题', 'text', 'varchar(200)', '200', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1636338535', '1636338535', '0');
INSERT INTO `ey_channelfield` VALUES ('184', 'origin', '0', '来源', 'text', 'varchar(30)', '30', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1636338535', '1636338535', '0');
INSERT INTO `ey_channelfield` VALUES ('185', 'stypeid', '0', '副栏目', 'text', 'varchar(90)', '90', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1636338535', '1636338535', '0');
INSERT INTO `ey_channelfield` VALUES ('186', 'target', '-99', '新窗口打开', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1547890773', '1547890773', '0');
INSERT INTO `ey_channelfield` VALUES ('187', 'nofollow', '-99', '防抓取', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1547890773', '1547890773', '0');
INSERT INTO `ey_channelfield` VALUES ('188', 'content_ey_m', '1', '手机端内容详情', 'htmltext', 'longtext', '250', '', '', '', '0', '1', '1', '0', '1', '0', '0', '100', '1', '1533464713', '1623047123', '0');
INSERT INTO `ey_channelfield` VALUES ('189', 'content_ey_m', '2', '手机端内容详情', 'htmltext', 'longtext', '250', '', '', '', '0', '1', '1', '0', '1', '0', '0', '100', '1', '1645086030', '1645086039', '0');
INSERT INTO `ey_channelfield` VALUES ('190', 'content_ey_m', '3', '手机端内容详情', 'htmltext', 'longtext', '250', '', '', '', '0', '1', '1', '0', '1', '0', '0', '100', '1', '1533359588', '1533359588', '0');
INSERT INTO `ey_channelfield` VALUES ('191', 'content_ey_m', '4', '手机端内容详情', 'htmltext', 'longtext', '250', '', '', '', '0', '1', '1', '0', '1', '0', '0', '100', '1', '1533359752', '1533359752', '0');
INSERT INTO `ey_channelfield` VALUES ('192', 'content_ey_m', '5', '手机端内容详情', 'htmltext', 'longtext', '250', '', '', '', '0', '1', '1', '0', '1', '0', '0', '100', '1', '1591957363', '1591957363', '0');
INSERT INTO `ey_channelfield` VALUES ('193', 'content_ey_m', '6', '手机端内容详情', 'htmltext', 'longtext', '250', '', '', '', '0', '1', '1', '0', '1', '0', '0', '100', '1', '1533464715', '1533464715', '0');
INSERT INTO `ey_channelfield` VALUES ('194', 'content_ey_m', '7', '手机端内容详情', 'htmltext', 'longtext', '250', '', '', '', '0', '1', '1', '0', '1', '0', '0', '100', '1', '1602320145', '1602320145', '0');
INSERT INTO `ey_channelfield` VALUES ('195', 'restric_type', '0', '限制模式，0=免费，1=付费，2=会员专享，3=会员付费', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1616293251', '1616293251', '0');
INSERT INTO `ey_channelfield` VALUES ('196', 'diy_dirpath', '-99', '自定义HTML保存路径', 'text', 'varchar(200)', '200', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533524780', '1533524780', '0');
INSERT INTO `ey_channelfield` VALUES ('197', 'rulelist', '-99', '列表静态文件存放规则', 'text', 'varchar(200)', '200', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533524780', '1533524780', '0');
INSERT INTO `ey_channelfield` VALUES ('198', 'ruleview', '-99', '文档静态文件存放规则', 'text', 'varchar(200)', '200', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533524780', '1533524780', '0');
INSERT INTO `ey_channelfield` VALUES ('199', 'typearcrank', '-99', '阅读权限：0=开放浏览，-1=待审核稿件', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1547890773', '1547890773', '0');
INSERT INTO `ey_channelfield` VALUES ('200', 'empty_logic', '-99', '空内容逻辑', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533524780', '1533524780', '0');

-- -----------------------------
-- Table structure for `ey_channelfield_bind`
-- -----------------------------
DROP TABLE IF EXISTS `ey_channelfield_bind`;
CREATE TABLE `ey_channelfield_bind` (
  `id` int(10) NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `typeid` int(10) DEFAULT '0' COMMENT '栏目ID',
  `field_id` int(10) DEFAULT '0' COMMENT '自定义字段ID',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='栏目与自定义字段绑定表';


-- -----------------------------
-- Table structure for `ey_channelfield_log`
-- -----------------------------
DROP TABLE IF EXISTS `ey_channelfield_log`;
CREATE TABLE `ey_channelfield_log` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) DEFAULT '' COMMENT '字段名称',
  `channel_id` int(10) DEFAULT '0' COMMENT '模型ID',
  `dtype` varchar(32) DEFAULT '' COMMENT '字段类型',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='自定义字段日志表';


-- -----------------------------
-- Table structure for `ey_channeltype`
-- -----------------------------
DROP TABLE IF EXISTS `ey_channeltype`;
CREATE TABLE `ey_channeltype` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `nid` varchar(50) NOT NULL DEFAULT '' COMMENT '识别id',
  `title` varchar(30) DEFAULT '' COMMENT '名称',
  `ntitle` varchar(30) DEFAULT '' COMMENT '左侧菜单名称',
  `table` varchar(50) DEFAULT '' COMMENT '表名',
  `ctl_name` varchar(50) DEFAULT '' COMMENT '控制器名称（区分大小写）',
  `status` tinyint(1) DEFAULT '1' COMMENT '状态(1=启用，0=屏蔽)',
  `ifsystem` tinyint(1) DEFAULT '0' COMMENT '字段分类，1=系统(不可修改)，0=自定义',
  `is_repeat_title` tinyint(1) DEFAULT '1' COMMENT '文档标题重复，1=允许，0=不允许',
  `is_release` tinyint(1) DEFAULT '0' COMMENT '模型是否允许应用于会员投稿发布，1是，0否',
  `is_litpic_users_release` tinyint(1) DEFAULT '1' COMMENT '缩略图是否应用于会员投稿，1=允许，0=不允许',
  `data` text COMMENT '额外序列化存储数据',
  `is_del` tinyint(1) DEFAULT '0' COMMENT '伪删除，1=是，0=否',
  `sort_order` smallint(6) DEFAULT '50' COMMENT '排序',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idention` (`nid`) USING BTREE,
  UNIQUE KEY `ctl_name` (`ctl_name`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=101 DEFAULT CHARSET=utf8;

-- -----------------------------
-- Records of `ey_channeltype`
-- -----------------------------
INSERT INTO `ey_channeltype` VALUES ('1', 'article', '文章模型', '文章', 'article', 'Article', '1', '1', '1', '1', '1', '', '0', '1', '0', '1613980324');
INSERT INTO `ey_channeltype` VALUES ('4', 'download', '下载模型', '下载', 'download', 'Download', '0', '1', '1', '1', '1', '', '0', '4', '0', '1613980324');
INSERT INTO `ey_channeltype` VALUES ('2', 'product', '产品模型', '产品', 'product', 'Product', '0', '1', '1', '1', '1', '', '0', '2', '0', '1613980324');
INSERT INTO `ey_channeltype` VALUES ('8', 'guestbook', '留言模型', '留言', 'guestbook', 'Guestbook', '1', '1', '1', '1', '1', '', '0', '8', '1509197711', '1613980324');
INSERT INTO `ey_channeltype` VALUES ('6', 'single', '单页模型', '单页', 'single', 'Single', '1', '1', '1', '1', '1', '', '0', '6', '1523091961', '1613980324');
INSERT INTO `ey_channeltype` VALUES ('3', 'images', '图集模型', '图集', 'images', 'Images', '0', '1', '1', '1', '1', '', '0', '3', '1523929121', '1613980324');
INSERT INTO `ey_channeltype` VALUES ('5', 'media', '视频模型', '视频', 'media', 'Media', '0', '1', '1', '1', '1', '', '0', '5', '1509197711', '1564532747');
INSERT INTO `ey_channeltype` VALUES ('7', 'special', '专题模型', '专题', 'special', 'Special', '0', '1', '1', '1', '1', '', '0', '7', '1509197711', '1564532747');
INSERT INTO `ey_channeltype` VALUES ('51', 'ask', '问答模型', '问答', 'ask', 'Ask', '0', '1', '1', '1', '1', '', '1', '9', '1509197711', '1686204365');

-- -----------------------------
-- Table structure for `ey_citysite`
-- -----------------------------
DROP TABLE IF EXISTS `ey_citysite`;
CREATE TABLE `ey_citysite` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '表id',
  `name` varchar(32) DEFAULT '' COMMENT '地区名称',
  `level` tinyint(4) DEFAULT '0' COMMENT '地区等级 分省市县区',
  `parent_id` int(10) DEFAULT '0' COMMENT '父id',
  `topid` int(10) DEFAULT '0' COMMENT '顶级ID',
  `initial` varchar(5) DEFAULT '' COMMENT '首字母',
  `status` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '状态（1：开启，0：隐藏）',
  `is_hot` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否热门',
  `domain` varchar(50) NOT NULL DEFAULT '' COMMENT '二级域名',
  `is_open` tinyint(1) DEFAULT '0' COMMENT '二级域名开启状态，0=否，1=是',
  `seoset` tinyint(1) DEFAULT '0' COMMENT 'SEO设置，0=使用主站，1=自定义',
  `seo_title` varchar(200) DEFAULT '' COMMENT 'SEO标题',
  `seo_keywords` varchar(200) DEFAULT '' COMMENT 'SEO关键词',
  `seo_description` text COMMENT 'SEO描述',
  `sort_order` int(6) unsigned NOT NULL DEFAULT '100' COMMENT '排序',
  `add_time` int(11) NOT NULL DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) NOT NULL DEFAULT '0' COMMENT '更新时间',
  `showall` tinyint(3) DEFAULT '1' COMMENT '是否显示主站信息',
  PRIMARY KEY (`id`),
  KEY `domain` (`domain`) USING BTREE,
  KEY `level` (`level`,`status`) USING BTREE,
  KEY `initial` (`initial`,`sort_order`,`id`) USING BTREE,
  KEY `parent_id` (`parent_id`,`status`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='城市分站表';


-- -----------------------------
-- Table structure for `ey_common_pic`
-- -----------------------------
DROP TABLE IF EXISTS `ey_common_pic`;
CREATE TABLE `ey_common_pic` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '常用图片ID',
  `pic_path` varchar(255) NOT NULL DEFAULT '' COMMENT '图片地址',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '多语言',
  `add_time` int(11) NOT NULL DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COMMENT='常用图片';

-- -----------------------------
-- Records of `ey_common_pic`
-- -----------------------------
INSERT INTO `ey_common_pic` VALUES ('1', '/uploads/allimg/20230608/1-23060Q405105G.jpg', 'cn', '1686204311', '1686204311');

-- -----------------------------
-- Table structure for `ey_company_content`
-- -----------------------------
DROP TABLE IF EXISTS `ey_company_content`;
CREATE TABLE `ey_company_content` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `aid` int(10) DEFAULT '0' COMMENT '文档ID',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  `nrxq` longtext COMMENT '公司简介',
  `lianxiren` varchar(200) NOT NULL DEFAULT '' COMMENT '联系人',
  `telphone` varchar(200) NOT NULL DEFAULT '' COMMENT '联系电话',
  `adress` varchar(200) NOT NULL DEFAULT '' COMMENT '公司地址',
  `qygm` enum('20人以下','20-99人','100-499人','500-999人','1000-9999人','10000人以上') DEFAULT '20人以下' COMMENT '企业规模',
  `qyfl` set('环境好','年终奖','双休','五险一金','加班费','朝九晚五','交通方便','加班补助','包食宿','管理规范','有提成','全勤奖','有年假','专车接送','有补助','晋升快','车贴','房贴','压力小','技术培训','旅游') DEFAULT '' COMMENT '企业福利',
  `qyrz` varchar(250) NOT NULL DEFAULT '' COMMENT '营业执照',
  PRIMARY KEY (`id`),
  KEY `aid` (`aid`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=14 DEFAULT CHARSET=utf8 COMMENT='附加表';

-- -----------------------------
-- Records of `ey_company_content`
-- -----------------------------
INSERT INTO `ey_company_content` VALUES ('1', '148', '1628383510', '1628383510', '', '', '', '宝应县洪宝水产品经营部', '20人以下', '环境好', '');
INSERT INTO `ey_company_content` VALUES ('2', '151', '1629699139', '1629699139', '&lt;p&gt;江苏省宝应县水产批发市场欢迎你&lt;/p&gt;', '任洪宝', '15366919619', '江苏省宝应县水产批发市场', '20-99人', '环境好,年终奖', '/uploads/user/1/allimg/20210808/1-210PR2523B35.png');
INSERT INTO `ey_company_content` VALUES ('3', '156', '1629878523', '1629878523', '&lt;p&gt;dddddddd&lt;/p&gt;', '任洪宝', '15366919619', '宝应县洪宝水产品经营部', '20人以下', '环境好', '');
INSERT INTO `ey_company_content` VALUES ('4', '160', '1629697806', '1629697806', '', '', '', '宝应县洪宝水产品经营部', '20人以下', '环境好', '');
INSERT INTO `ey_company_content` VALUES ('5', '170', '1630564691', '1630564691', '', '', '', '', '20人以下', '', '');
INSERT INTO `ey_company_content` VALUES ('6', '175', '1631255393', '1631255393', '&lt;p&gt;易优内容管理系统(EyouCms) 隶属于海南赞赞网络科技有限公司，易优cms以模板多、易优化、开源而闻名，是国内新锐的PHP开源网站管理系统，也是受用户好评的PHP类CMS系统，在经历多年的发展，目前的版本无论在功能，还是在后台易用性方面，都有了长足的发展和进步，eyoucms免费版的主要目标用户锁定在有企业建站需求的群体，当然也不乏有个人用户和学校等在使用该系统。&lt;/p&gt;\r\n&lt;p&gt;企业网站，无论大型还是中小型企业，利用网络传递信息在一定程度上提高了办事的效率，提高企业的竞争力。EyouCms网站建设系统适合做各类型网站，EyouCms是什么，EyouCms是一个自由和开放源码的内容管理系统，它是一个可以独立使用的内容发布系统（CMS）。在中国，EyouCms属于人们喜爱的CMS系统。&lt;/p&gt;\r\n&lt;p&gt;政府机关，通过建立政府门户，有利于各种信息和资源的整合，为政府和社会公众之间加强联系和沟通，从而使政府可以更快、更便捷、更有效开展工作。&lt;/p&gt;\r\n&lt;p&gt;教育机构，通过网络信息的引入，使得教育机构之间及教育机构内部和教育者之间进行信息传递，全面提升教育类网站的层面。&lt;br data-filtered=&quot;filtered&quot; /&gt;&lt;br data-filtered=&quot;filtered&quot; /&gt;我们的愿景：成为模板建站行业的领跑者&lt;br data-filtered=&quot;filtered&quot; /&gt;企业的使命：让天下没有难做的网站&lt;br data-filtered=&quot;filtered&quot; /&gt;企业价值观：拥抱变化，创造价值！&lt;/p&gt;', '易优-小菜', '0898-88888888', '海南省海口市龙华区城西镇龙昆南路146号', '20人以下', '环境好,年终奖,双休,加班费,朝九晚五', '/uploads/ueditor/20210902/1-210Z2224634607.jpg');
INSERT INTO `ey_company_content` VALUES ('7', '176', '1630595816', '1630595816', '&lt;p&gt;大闸蟹批发网是以养殖、批发、销售大闸蟹为主的网络平台，我们为经销商提供正宗大闸蟹批发，12年匠心专注好蟹,高端蟹,选洪宝蟹家!批发热线：153-6691-9619。&lt;/p&gt;', '任洪宝', '15366919619', '江苏省宝应县山阳镇苏中水产批发市场', '20-99人', '加班费,朝九晚五,加班补助,管理规范,有提成', '/uploads/ueditor/20210902/1-210Z223021H20.png');
INSERT INTO `ey_company_content` VALUES ('8', '186', '1631255620', '1631255620', '&lt;p&gt;北京英才网科技有限公司成立于2018年3月，是一家基于人力资源行业，为客户提供一站式、标准化人力资源解决方案的专业化公司，是国内较早从事人力资源外包的专业人才服务机构之一。同时也是区域招聘网站&amp;mdash;&amp;mdash;北京英才网的运营商。&lt;/p&gt;', '易优-小菜', '0898-66963973', '海南省海口市龙华区城西镇龙昆南路146号', '20人以下', '年终奖,五险一金,加班费,加班补助,旅游', '');
INSERT INTO `ey_company_content` VALUES ('9', '189', '1630599177', '1630599177', '&lt;p&gt;阿里巴巴集团的使命是让天下没有难做的生意。&lt;br /&gt;我们旨在赋能企业改变营销、销售和经营的方式。我们为商家、品牌及其他企业提供基本的互联网基础设施以及营销平台，让其可借助互联网的力量与用户和客户互动。我们的业务包括核心电商、云计算、数字媒体和娱乐以及创新项目和其他业务。我们并通过子公司菜鸟网络及所投资的关联公司口碑，参与物流和本地服务行业，同时与蚂蚁金融服务集团有战略合作，该金融服务集团主要通过中国领先的第三方网上支付平台支付宝运营。&lt;br /&gt;&lt;br /&gt;我们的愿景&lt;br /&gt;我们旨在构建未来的商务生态系统。我们的愿景是让客户相会、工作和生活在阿里巴巴，并持续发展最少102年。&lt;/p&gt;', '易优-小菜', '0898-66963973', '海南省海口市龙华区城西镇龙昆南路146号', '20-99人', '加班费,朝九晚五,加班补助,管理规范,有年假', '');
INSERT INTO `ey_company_content` VALUES ('10', '210', '1631255318', '1631255318', '&lt;p&gt;北京百度网讯科技有限公司成立于2001年06月05日，注册地位于北京市海淀区上地十街10号百度大厦2层，法定代表人为梁志祥。经营范围包括技术转让、技术咨询、技术服务、技术培训、技术推广;设计、开发、销售计算机软件;经济信息咨询;利用www.baidu.com、www.hao123.com(www.hao222.net、www.hao222.com)网站发布广告;设计、制作、代理、发布广告;货物进出口、技术进出口、代理进出口;医疗软件技术开发;委托生产电子产品、玩具、照相器材;销售家用电器、机械设备、五金交电(不含电动自行车)、电子产品、文化用品、照相器材、计算机、软件及辅助设备、化妆品、卫生用品、体育用品、纺织品、服装、鞋帽、日用品、家具、首饰、避孕器具、工艺品、钟表、眼镜、玩具、汽车及摩托车配件、仪器仪表、塑料制品、花、草及观赏植物、建筑材料、通讯设备、汽车电子产品、器件和元件、自行开发后的产品;预防保健咨询;公园门票、文艺演出、体育赛事、展览会票务代理;翻译服务;通讯设备和电子产品的技术开发;计算机系统服务;车联网技术开发;汽车电子产品设计、研发、制造(北京市中心城区除外);演出经纪;人才中介服;经营电信业务;利用信息网络经营音乐娱乐产品、演出剧(节)目、动漫产品、游戏产品(含网络游戏虚拟货币发行)、表演、网络游戏技法展示或解说(网络文化经营许可证有效期至2020年04月17日);因特网信息服务业务(除出版、教育、医疗保健以外的内容);图书、电子出版物、音像制品批发、零售、网上销售。(市场主体依法自主选择经营项目,开展经营活动;演出经纪、人才中介服务、利用信息网络经营音乐娱乐产品、演出剧(节)目、动漫产品、游戏产品(含网络游戏虚拟货币发行)、表演、网络游戏技法展示或解说、经营电信业务以及依法须经批准的项目,经相关部门批准后依批准的内容开展经营活动;不得从事国家和本市产业政策禁止和限制类项目的经营活动。)北京百度网讯科技有限公司对外投资53家公司，具有9处分支机构。&lt;/p&gt;', '陈先生', '13986665659', '广东省广州市', '1000-9999人', '年终奖,双休,五险一金,加班费,朝九晚五', '/uploads/ueditor/20210910/1-210910142R5260.jpg');
INSERT INTO `ey_company_content` VALUES ('11', '211', '1631255813', '1631255813', '&lt;p&gt;深圳市腾讯计算机系统有限公司成立于1998年11月，由马化腾、张志东、许晨晔、陈一丹、曾李青五位创始人共同创立。 腾讯多元化的服务包括：社交和通信服务QQ及微信/WeChat、社交网络平台QQ空间、腾讯游戏旗下QQ游戏平台、门户网站腾讯网、腾讯新闻客户端和网络视频服务腾讯视频等。&amp;nbsp; 2004年腾讯公司在香港联交所主板公开上市（股票代号00700），董事会主席兼首席执行官是马化腾。 2018年6月20日，世界品牌实验室（World Brand Lab）在北京发布了2018年《中国500最具价值品牌》分析报告。腾讯居第二位。2018年12月，世界品牌实验室编制的《2018世界品牌500强》揭晓，排名第39。&amp;nbsp; 2019年7月，发布2019《财富》世界500强：位列237位。&amp;nbsp; 2019年8月，入选2019年中国最佳董事会50强。2019年9月1日，2019中国服务业企业500强榜单在济南发布，腾讯控股有限公司排名第32位。 2019年10月，2019福布斯全球数字经济100强榜位列14位。&amp;nbsp; 2019年10月23日， 2019《财富》未来50强榜单公布，腾讯控股有限公司排名第12。 [7]&amp;nbsp;&amp;nbsp;&amp;ldquo;一带一路&amp;rdquo;中国企业100强榜单排名第14位。2019年12月，腾讯入选2019中国品牌强国盛典榜样100品牌。 [9]&amp;nbsp;&amp;nbsp;2019年12月18日，人民日报发布中国品牌发展指数100榜单，腾讯排名第4位。&lt;/p&gt;', '周先生', '13986665659', '北京市东五环', '1000-9999人', '环境好,年终奖,加班费', '');
INSERT INTO `ey_company_content` VALUES ('12', '212', '1631255981', '1631255981', '&lt;p&gt;京东是中国的综合网络零售商，是中国电子商务领域受消费者欢迎和具有影响力的电子商务网站之一，在线销售家电、数码通讯、电脑、家居百货、服装服饰、母婴、图书、食品、在线旅游等12大类数万个品牌百万种优质商品。京东在2012年的中国自营B2C市场占据49%的份额，凭借全供应链继续扩大在中国电子商务市场的优势。京东已经建立华北、华东、华南、西南、华中、东北六大物流中心，同时在全国超过360座城市建立核心城市配送站。2012年8月14日，京东与苏宁开打&quot;史上最惨烈价格战&quot; 。2013年3月30日19点整正式切换了域名，并且更换新的logo&lt;/p&gt;', '刘先生', '020-88888888', '广东省广州市', '20人以下', '五险一金,加班费,朝九晚五', '');
INSERT INTO `ey_company_content` VALUES ('13', '213', '1631256094', '1631256094', '&lt;p&gt;上海寻梦信息技术有限公司成立于2014年，2015年4月，创办新电商平台拼多多，拼多多现为公司旗下主要产品。&lt;/p&gt;\r\n&lt;p&gt;目前，拼多多平台已汇聚7.313亿年度活跃买家和510万活跃商户，平台年交易额达人民币14576亿元，迅速发展成为中国第二大电商平台。&lt;/p&gt;\r\n&lt;p&gt;拼多多以独创的社交拼团为核心模式，主打百亿补贴、农货上行、产地好货等，致力于服务中国最广大的普通消费者。&lt;/p&gt;\r\n&lt;p&gt;拼多多平台以&amp;ldquo;好货不贵&amp;rdquo;为运营理念，为消费者提供补贴折扣大牌商品、原产地农产品、工厂产品和新品牌商品等。其中，拼多多独创发起的百亿补贴创造了中国电商行业活动规模和持续时长的新纪录。&lt;/p&gt;\r\n&lt;p&gt;拼多多脱胎于农产品电商拼好货。人民网此前发布报告显示，拼多多已经成为中国最大的农产品上行平台。&lt;/p&gt;\r\n&lt;p&gt;2018年7月，拼多多在美国纳斯达克证券交易所正式挂牌上市。&lt;/p&gt;', '李先生', '0898-88888888', '广东省广州市', '20人以下', '五险一金,加班费,朝九晚五,交通方便,加班补助', '');

-- -----------------------------
-- Table structure for `ey_config`
-- -----------------------------
DROP TABLE IF EXISTS `ey_config`;
CREATE TABLE `ey_config` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) DEFAULT '' COMMENT '配置的key键名',
  `value` text,
  `inc_type` varchar(64) DEFAULT '' COMMENT '配置分组',
  `desc` varchar(50) DEFAULT '' COMMENT '描述',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `is_del` tinyint(1) DEFAULT '0' COMMENT '是否已删除，0=否，1=是',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=179 DEFAULT CHARSET=utf8;

-- -----------------------------
-- Records of `ey_config`
-- -----------------------------
INSERT INTO `ey_config` VALUES ('1', 'is_mark', '0', 'water', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('2', 'mark_txt', '易优Cms', 'water', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('3', 'mark_img', '/public/upload/water/2018/05/08/93806077e5a4c4e12ceed30df5cde761.png', 'water', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('4', 'mark_width', '200', 'water', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('5', 'mark_height', '50', 'water', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('6', 'mark_degree', '54', 'water', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('7', 'mark_quality', '56', 'water', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('8', 'mark_sel', '9', 'water', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('9', 'sms_time_out', '120', 'sms', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('10', 'theme_style', '1', 'basic', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('11', 'file_size', '100', 'basic', '', 'cn', '0', '1613980347');
INSERT INTO `ey_config` VALUES ('12', 'image_type', 'jpg|gif|png|bmp|jpeg|ico', 'basic', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('13', 'file_type', 'zip|gz|rar|iso|doc|xls|ppt|wps', 'basic', '', 'cn', '0', '1613980373');
INSERT INTO `ey_config` VALUES ('14', 'media_type', 'swf|mpg|mp3|rm|rmvb|wmv|wma|wav|mid|mov|mp4', 'basic', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('15', 'web_keywords', '', 'web', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('17', 'sms_platform', '1', 'sms', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('18', 'seo_viewtitle_format', '2', 'seo', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('19', 'smtp_server', 'smtp.qq.com', 'smtp', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('20', 'smtp_port', '465', 'smtp', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('21', 'smtp_user', 'xxxxxxxxx@qq.com', 'smtp', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('22', 'smtp_pwd', 'xxxxxxxxxxx', 'smtp', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('23', 'inc_type', 'smtp', 'smtp', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('24', 'mark_type', 'img', 'water', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('25', 'mark_txt_size', '30', 'water', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('26', 'mark_txt_color', '#000000', 'water', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('27', 'oss_switch', '0', 'oss', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('28', 'web_name', '全液压双驱挖掘机压路机类网站模板', 'web', '', 'cn', '0', '1686204300');
INSERT INTO `ey_config` VALUES ('29', 'web_logo', '/public/upload/system/2018/08/11/36c56e60b0b118311090b095eb371a6b.png', 'web', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('30', 'web_ico', '/favicon.ico', 'web', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('31', 'web_basehost', 'http://e15.eyou.hk', 'web', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('32', 'web_description', '', 'web', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('79', 'web_recordnum', '粤ICP备88889999号', 'web', '', 'cn', '0', '1686204300');
INSERT INTO `ey_config` VALUES ('33', 'web_copyright', 'Copyright © 2012-2023 某某挖掘机有限公司 版权所有', 'web', '', 'cn', '0', '1686204300');
INSERT INTO `ey_config` VALUES ('34', 'web_thirdcode_pc', '', 'web', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('35', 'web_thirdcode_wap', '', 'web', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('39', 'seo_arcdir', '/html', 'seo', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('40', 'seo_pseudo', '1', 'seo', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('41', 'list_symbol', '&gt;', 'basic', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('42', 'sitemap_auto', '1', 'sitemap', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('43', 'sitemap_not1', '0', 'sitemap', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('44', 'sitemap_not2', '1', 'sitemap', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('45', 'sitemap_xml', '1', 'sitemap', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('46', 'sitemap_txt', '0', 'sitemap', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('47', 'sitemap_zzbaidutoken', '', 'sitemap', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('48', 'seo_expires_in', '7200', 'seo', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('55', 'web_title', '全液压双驱挖掘机压路机类网站模板', 'web', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('56', 'smtp_test_eamil', 'xxxxxxxx@qq.com', 'smtp', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('57', 'web_authortoken', '6e27af8a47788c33317c98fd9b0d8e03', 'web', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('58', 'web_attr_3', '广东省广州市', 'web', '', 'cn', '0', '1686204322');
INSERT INTO `ey_config` VALUES ('59', 'web_attr_2', '13899998888', 'web', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('60', 'web_attr_1', '诚信为本：市场永远在变，诚信永远不变。', 'web', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('61', 'web_attr_4', '020-66889888', 'web', '', 'cn', '0', '1686204322');
INSERT INTO `ey_config` VALUES ('81', 'web_attr_5', 'admin@youweb.com', 'web', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('62', 'seo_inlet', '1', 'seo', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('63', 'web_cmspath', '', 'web', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('64', 'web_sqldatapath', '/data/sqldata_zuf5p9Qv2yFAnda4kcQj', 'web', '', 'cn', '0', '1686204252');
INSERT INTO `ey_config` VALUES ('65', 'web_cmsurl', '', 'web', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('66', 'web_templets_dir', '/template', 'web', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('67', 'web_templeturl', '/template', 'web', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('68', 'web_templets_pc', '/template/pc', 'web', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('69', 'web_templets_m', '/template/mobile', 'web', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('70', 'web_eyoucms', 'http://www.eyoucms.com', 'web', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('78', '_cmscopyright', 'Sn7EvxrCrzpAbyeBz8w6hfCE', 'php', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('76', 'seo_liststitle_format', '2', 'seo', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('77', 'web_status', '0', 'web', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('80', 'web_is_authortoken', '0', 'web', '', 'cn', '0', '1667470604');
INSERT INTO `ey_config` VALUES ('82', 'web_attr_6', '/uploads/allimg/20230608/1-23060Q405105G.jpg', 'web', '', 'cn', '0', '1686204322');
INSERT INTO `ey_config` VALUES ('83', 'web_attr_7', '88889999', 'web', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('84', 'seo_rewrite_format', '2', 'seo', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('85', 'seo_dynamic_format', '1', 'seo', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('86', 'system_sql_mode', 'ONLY_FULL_GROUP_BY,STRICT_TRANS_TABLES,NO_ZERO_IN_DATE,NO_ZERO_DATE,ERROR_FOR_DIVISION_BY_ZERO,NO_AUTO_CREATE_USER,NO_ENGINE_SUBSTITUTION', 'system', '', 'cn', '0', '1667470604');
INSERT INTO `ey_config` VALUES ('87', 'web_adminbasefile', '/login.php', 'web', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('88', 'system_home_default_lang', 'cn', 'system', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('89', 'system_langnum', '1', 'system', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('90', 'system_version', 'v1.6.3', 'system', '', 'cn', '0', '1686204259');
INSERT INTO `ey_config` VALUES ('91', 'php_eyou_blacklist', '', 'php', '', 'cn', '0', '1559126932');
INSERT INTO `ey_config` VALUES ('92', 'system_upgrade_filelist', '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', 'system', '', 'cn', '0', '1686204253');
INSERT INTO `ey_config` VALUES ('165', 'php_websensitive', '5aix5LmQDXzljZrlvakNfOS4lueVjOadrw185aSc5bqXDXzotYzljZoNfOaequaUrw186aOO5pq0DXxib2INfOaKvOazqA18OyZhbXA7Iw18YeeJhw185aSn54mHDXzmrKfnvo4=', 'php', '', 'cn', '0', '1686204243');
INSERT INTO `ey_config` VALUES ('166', 'php_allow_service_os', 'eyJjb2RlIjoxLCJtc2ciOiJcdTY4YzBcdTZkNGJcdTUyMzBcdTY1YjBcdTcyNDhcdTY3MmMiLCJtc2cxIjoiXHU1NTQ2XHU3NTI4XHU3MjQ4XHU2NzJjXHU2NTJmXHU2MzAxXHU1NzI4XHU3ZWJmXHU2NmY0XHU2NWIwIn0=', 'php', '', 'cn', '0', '1680749324');
INSERT INTO `ey_config` VALUES ('93', 'smtp_syn_weapp', '1', 'smtp', '', 'cn', '0', '1559126937');
INSERT INTO `ey_config` VALUES ('94', 'system_auth_code', '$2y$11$81d7d29e92eaf2d6fb983b7', 'system', '', 'cn', '0', '1613980304');
INSERT INTO `ey_config` VALUES ('97', 'system_smtp_tpl_5', '1', 'system', '', 'cn', '0', '1613980373');
INSERT INTO `ey_config` VALUES ('98', 'syn_gb_attribute_showlist', '1', 'syn', '', 'cn', '0', '1613980373');
INSERT INTO `ey_config` VALUES ('99', 'syn_admin_logic_sms_template', '1', 'syn', '', 'cn', '0', '1613980373');
INSERT INTO `ey_config` VALUES ('100', 'php_weapp_plugin_open', '1', 'php', '', 'cn', '0', '1686204260');
INSERT INTO `ey_config` VALUES ('101', 'syn_admin_logic_unlink', '1', 'syn', '', 'cn', '0', '1613980373');
INSERT INTO `ey_config` VALUES ('102', 'syn_admin_logic_update_basic', '1', 'syn', '', 'cn', '0', '1613980373');
INSERT INTO `ey_config` VALUES ('95', 'system_robots_edit', '1', 'system', '', 'cn', '0', '1613980347');
INSERT INTO `ey_config` VALUES ('96', 'system_synleveldata', '1', 'system', '', 'cn', '0', '1613980347');
INSERT INTO `ey_config` VALUES ('103', 'syn_admin_logic_update_tag', '1', 'syn', '', 'cn', '0', '1613980373');
INSERT INTO `ey_config` VALUES ('104', 'syn_admin_logic_update_arctype', '1', 'syn', '', 'cn', '0', '1613980373');
INSERT INTO `ey_config` VALUES ('105', 'php_serviceinfo', '335dCAUDVlFRCAIIUVMBUVAAUwdSVQMIXgcCUw8YQE4EW0BdW0APFQhOVxpbFAxWW01Qfg4zIWFCDwxsSw8UWAp3VXdmBwoUBG5YdwBSS0ADDVBTMAFQW0k7Im5DDBZgG1VZYlp9AC4AXUNNAGNLQAMNU1MsLVBJSVMibkEKAAsod1V3VHgQLgBCQ3lQDnZOaF0HaiJVLE4JWz9TXCkKTlABBllmXVNVDHB2YBtbS3xUWxNdV19HFRoCE0JRDBBfCFVWVUZURFtDZEcAA1AOa0cAVwFTPhAMWlpeakxUBAxQZUYMUAMEPRQAVA8FakwDVwRWbhZWAAhZPxMBC1daZRQPAAANbxNXVgwBZBQADA8FaRAGBgRTZU0FAAYIQU4bAExHUFpBCxIGCRACQ2pMD1BQUG4WV1cAXj8TDgkFBmUUDVZbAG8TWFcNAmQUAwwDBGkQBgZTBGVNVVUOAT8XD1YNAGRABlEFB2RHDVUGXWtHUwMCUkBJG1kWEl5WEQ9KBgsRAhdvE1kDXQdkFAMLDlRpEApTBAFlTVcDVQw/FwBXDANkQAcDUFJkRwwEB1hrRwJXBls+EA8LW15qTFVVDVJlRg0CVwA9FA0GCAVqTFFUBVQQT0AETEwLCURUEAUITwwRAhdvE1kDXQdkFAMLDlRpEApTBAFlTVcDVQw/FwBXDANkQAcDUFJkRwwEB1hrRwJXBls+EA8LW15qTFVVDVJlRg0CVwA9FA0GCAVqTFFUBVQQT0AETUkWA0RAEQdIFFxATBcJRAQYcUVxC0YOfl9jUVEkDhxjblpWV25SDnALVkt1X1hULCV5RV4yQVB6YXxTVxooCVxwIRZVVDUEXSZVR2JmelAuJWECdSV3TlFhQgx/MFZUcFITUX9UNVZaJlVKYmMKVgA2CV5xC1kNeVhkEn8nIFx1eyoff1MTVXAMbwdbcl8fOzcBAlk2B1V+WFpRfAkzEnR8IV9QaF5fG00bWlwXCVBNQ1pHQQhSGw0QF0kQBw0IWFENRAwbBhtWFBdbUxcfRAIOXFcaWxQIVQYEA1QGUgQLAQZWAFpVUF8CDgoLAAUAVQANCloDUxsbEFAdQgoQAEpnCggUA1NOGxVLSldARzkVCFVXGlsGFRVRWQpBBj0SXFpBXAYVQRdJBVZeWVxdOQ8UVRACURobXlxBF11BWEcbFEETX11BWAlNG0ZLUEEPBUMCEFkFW1BZEBlHUAILAUxnAAlDVxdAA1EVEU9QUhYRPkheTQZfV2hdRQBcQVhUFRoTD1IbWVAVQ1BAZ1pfAkNbCB4aEkJYQ0dGRwhSTkdQSzwCU1VBWAlNG1JcUWwSCAxdEAJQAwwGAA1SClNaSRtNEwJXTQY9TQhUVhoPAlBSVQ8KClIPCRsQRQ1CPAMJVVcUOUVcERRQAlxsV0YRXEMEQXhSAwRrW3tfCkovIS9NW1EFX3YKKFoFbWoMbEkkAgVsaFMvcXNUVmEwSy4YJ1pcNz8HYAkgWgVtUEF7dw4CBWxrCyxbdF5+di9GAFAGQXEJCV9hKzcIL21iCm17M1IvbHsMOX5sBH9fNAY7KjALdhksXGErNwsvbXlVbXszUyxCc0A5fmwGfE8sBjsqMApiNCxbYSs3Cy9UaghtezNTL297TyhYCQoQSA', 'php', '', 'cn', '0', '1686204260');
INSERT INTO `ey_config` VALUES ('106', 'php_servicecode', '1b41ffe0a29e06c62fc79356f4a58bbe', 'php', '', 'cn', '0', '1667470604');
INSERT INTO `ey_config` VALUES ('107', 'syn_admin_logic_video_addfields', '5', 'syn', '', 'cn', '0', '1651223510');
INSERT INTO `ey_config` VALUES ('108', 'syn_admin_logic_special_addfields', '5', 'syn', '', 'cn', '0', '1651223510');
INSERT INTO `ey_config` VALUES ('109', 'syn_admin_logic_session_conf', '1', 'syn', '', 'cn', '0', '1613980400');
INSERT INTO `ey_config` VALUES ('110', 'syn_admin_logic_add_tag', '1', 'syn', '', 'cn', '0', '1613980400');
INSERT INTO `ey_config` VALUES ('111', 'syn_admin_logic_users_parameter', '1', 'syn', '', 'cn', '0', '1613980400');
INSERT INTO `ey_config` VALUES ('112', 'syn_admin_logic_users_download', '1', 'syn', '', 'cn', '0', '1613980400');
INSERT INTO `ey_config` VALUES ('113', 'syn_admin_logic_arctype_topid2', '1', 'syn', '', 'cn', '0', '1613980400');
INSERT INTO `ey_config` VALUES ('114', 'syn_admin_logic_check_oneself', '1', 'syn', '', 'cn', '0', '1613980400');
INSERT INTO `ey_config` VALUES ('115', 'syn_admin_logic_links_group', '1', 'syn', '', 'cn', '0', '1613980400');
INSERT INTO `ey_config` VALUES ('116', 'sms_type', '1', 'sms', '', 'cn', '0', '1613980400');
INSERT INTO `ey_config` VALUES ('117', 'syn_admin_logic_1608189503', '1', 'syn', '', 'cn', '0', '1613980400');
INSERT INTO `ey_config` VALUES ('118', 'download_select_servername', 'a:6:{i:0;s:12:\"立即下载\";i:1;s:15:\"本地服务器\";i:2;s:15:\"远程服务器\";i:3;s:12:\"百度网盘\";i:4;s:15:\"七牛云存储\";i:5;s:12:\"腾讯网盘\";}', 'download', '', 'cn', '0', '1613980400');
INSERT INTO `ey_config` VALUES ('119', 'syn_admin_logic_1608191377', '1', 'syn', '', 'cn', '0', '1613980400');
INSERT INTO `ey_config` VALUES ('120', 'system_paginate_pagesize', '20', 'system', '', 'cn', '0', '1613980400');
INSERT INTO `ey_config` VALUES ('121', 'web_theme_color', '#3398cc', 'web', '', 'cn', '0', '1613980400');
INSERT INTO `ey_config` VALUES ('122', 'web_assist_color', '#2189be', 'web', '', 'cn', '0', '1613980400');
INSERT INTO `ey_config` VALUES ('123', 'web_loginbgimg', '/public/static/admin/loginbg/login-bg-3.png', 'web', '', 'cn', '0', '1667470612');
INSERT INTO `ey_config` VALUES ('124', 'syn_admin_logic_1609039608', '1', 'syn', '', 'cn', '0', '1613980400');
INSERT INTO `ey_config` VALUES ('125', 'syn_admin_logic_1609291091', '1', 'syn', '', 'cn', '0', '1613980400');
INSERT INTO `ey_config` VALUES ('126', 'admin_logic_1610086647', '1', 'syn', '', 'cn', '0', '1613980400');
INSERT INTO `ey_config` VALUES ('127', 'syn_admin_logic_video_addfields_2', '1', 'syn', '', 'cn', '0', '1651223510');
INSERT INTO `ey_config` VALUES ('128', 'syn_admin_logic_1608884981_2', '1', 'syn', '', 'cn', '0', '1651223510');
INSERT INTO `ey_config` VALUES ('129', 'system_correctarctypedirpath', '1', 'system', '', 'cn', '0', '1651223514');
INSERT INTO `ey_config` VALUES ('130', 'php_servicemeal', '2', 'php', '', 'cn', '0', '1667470604');
INSERT INTO `ey_config` VALUES ('131', 'system_crypt_auth_code', '$2y$11$81d7d29e92eaf2d6fb983b7', 'system', '', 'cn', '0', '1667470597');
INSERT INTO `ey_config` VALUES ('132', 'web_adminlogo', '', 'web', '', 'cn', '0', '1667470612');
INSERT INTO `ey_config` VALUES ('133', 'web_loginlogo', '', 'web', '', 'cn', '0', '1667470612');
INSERT INTO `ey_config` VALUES ('134', 'syn_admin_logic_1608884981', '1', 'syn', '', 'cn', '0', '1667470612');
INSERT INTO `ey_config` VALUES ('135', 'syn_admin_logic_arctype_topid', '2', 'syn', '', 'cn', '0', '1667470612');
INSERT INTO `ey_config` VALUES ('136', 'syn_admin_logic_balance_pay', '1', 'syn', '', 'cn', '0', '1667470612');
INSERT INTO `ey_config` VALUES ('137', 'basic_img_style_wh', '0', 'basic', '', 'cn', '0', '1667470612');
INSERT INTO `ey_config` VALUES ('138', 'syn_admin_logic_1610086648', '1', 'syn', '', 'cn', '0', '1667470612');
INSERT INTO `ey_config` VALUES ('139', 'syn_admin_logic_1614829120', '1', 'syn', '', 'cn', '0', '1667470612');
INSERT INTO `ey_config` VALUES ('140', 'syn_admin_logic_1614829121', '1', 'syn', '', 'cn', '0', '1667470612');
INSERT INTO `ey_config` VALUES ('141', 'syn_admin_logic_1616123192', '1', 'syn', '', 'cn', '0', '1667470612');
INSERT INTO `ey_config` VALUES ('142', 'syn_admin_logic_ask_answer_like', '1', 'syn', '', 'cn', '0', '1667470612');
INSERT INTO `ey_config` VALUES ('143', 'syn_admin_logic_archives_1618279798', '1', 'syn', '', 'cn', '0', '1667470612');
INSERT INTO `ey_config` VALUES ('144', 'admin_logic_1_1648775669', '1', 'syn', '', 'cn', '0', '1667470612');
INSERT INTO `ey_config` VALUES ('145', 'syn_admin_logic_1623036205', '1', 'syn', '', 'cn', '0', '1667470612');
INSERT INTO `ey_config` VALUES ('146', 'admin_logic_1623055490', '1', 'syn', '', 'cn', '0', '1667470612');
INSERT INTO `ey_config` VALUES ('147', 'system_use_language', '0', 'system', '', 'cn', '0', '1667470612');
INSERT INTO `ey_config` VALUES ('148', 'admin_logic_1623133485', '1', 'syn', '', 'cn', '0', '1667470612');
INSERT INTO `ey_config` VALUES ('149', 'other_pcwapjs', '0', 'other', '', 'cn', '0', '1667470612');
INSERT INTO `ey_config` VALUES ('150', 'seo_uphtml_after_home', '0', 'seo', '', 'cn', '0', '1667470612');
INSERT INTO `ey_config` VALUES ('151', 'seo_uphtml_after_channel', '1', 'seo', '', 'cn', '0', '1667470612');
INSERT INTO `ey_config` VALUES ('152', 'seo_uphtml_after_pernext', '1', 'seo', '', 'cn', '0', '1667470612');
INSERT INTO `ey_config` VALUES ('153', 'seo_html_templet', 'index.htm', 'seo', '', 'cn', '0', '1667470612');
INSERT INTO `ey_config` VALUES ('154', 'seo_html_position', '../index.html', 'seo', '', 'cn', '0', '1667470612');
INSERT INTO `ey_config` VALUES ('155', 'seo_showmod', '1', 'seo', '', 'cn', '0', '1667470612');
INSERT INTO `ey_config` VALUES ('156', 'seo_maxpagesize', '50', 'seo', '', 'cn', '0', '1667470612');
INSERT INTO `ey_config` VALUES ('157', 'seo_upnext', '1', 'seo', '', 'cn', '0', '1667470612');
INSERT INTO `ey_config` VALUES ('158', 'seo_pagesize', '20', 'seo', '', 'cn', '0', '1667470612');
INSERT INTO `ey_config` VALUES ('159', 'basic_img_auto_wh', '0', 'basic', '', 'cn', '0', '1667470612');
INSERT INTO `ey_config` VALUES ('160', 'basic_img_alt', '0', 'basic', '', 'cn', '0', '1667470612');
INSERT INTO `ey_config` VALUES ('161', 'basic_img_title', '0', 'basic', '', 'cn', '0', '1667470612');
INSERT INTO `ey_config` VALUES ('162', 'seo_html_arcdir', 'html', 'seo', '', 'cn', '0', '1667470767');
INSERT INTO `ey_config` VALUES ('163', 'web_weapp_switch', '-1', 'web', '', 'cn', '0', '1686204268');
INSERT INTO `ey_config` VALUES ('164', 'system_usecodelist', 'af3fVgBUVgkGBlYBUVcCXFYGBVICUQwHBVBUAFBtR1kDUVQkVwMueFFzImRQPXd4X3h5NREgcXFYfDdwI10peyMwZSRxPSlvQUIudiQ2d2hlRWwmJDBscQRCImI0YzVgCSd7MWEuBW8GTgJ0N1xhbGUAUCQOGXhoX0oBdTN3J2kdFlYjXDUqbl5VB2AwKX97X3d6IwoOeXNycyh0DgIhaVRbVzFxLSF7QXAidlE9d2hbRmQwJw9lG0cZIEETVAFJKlRwDntXM0sOXDxbKxZnXmpXVQwWAHIGVXYyAlZ9KFFSE30cfgYFSm9cAksHHmdWakdiGFMtZVt4fgBbV3o8SxMhfQ5ATydTUmY/WBcccGFlVm43Iw5zcVNZNGYJVTJpMBF8IWIAJ2tjbwJzCV1Qa0RVbickDWJzZQcqYjRgK2tVFWE+Zi4gcWR8PGIgDGJvAn9sJiEWdXNiaD1+GnghaVQBZyRxNih7dA8IcDAMYm5lWmE6KAACWkB9OR4IeBR3FA1ADkYDU3VgYFZ9JjV9cnVGV0A7', 'system', '', 'cn', '0', '1667470846');
INSERT INTO `ey_config` VALUES ('167', 'php_atqueryrequest', 'eyIwIjp7ImV4cGlyZV90aW1lIjoxMjk2MDAwfSwiMSI6eyJleHBpcmVfdGltZSI6ODY0MDAwfSwiMS41Ijp7ImV4cGlyZV90aW1lIjo4NjQwMDB9LCIyIjp7ImV4cGlyZV90aW1lIjo4NjQwMDB9fQ==', 'php', '', 'cn', '0', '1686204260');
INSERT INTO `ey_config` VALUES ('168', 'php_atqueryrequest_time', '1686204260', 'php', '', 'cn', '0', '1686204260');
INSERT INTO `ey_config` VALUES ('169', 'php_atqueryrequest_time2', '1686204260', 'php', '', 'cn', '0', '1686204260');
INSERT INTO `ey_config` VALUES ('170', 'search_tabu_words', '<\r\n>\r\n\"\r\n;\r\n,\r\n@\r\n&\r\n#\r\n\\\r\n*', 'search', '', 'cn', '0', '1686204261');
INSERT INTO `ey_config` VALUES ('171', 'web_anti_brushing', '0', 'web', '', 'cn', '0', '1686204261');
INSERT INTO `ey_config` VALUES ('172', 'web_status_mode', '0', 'web', '', 'cn', '0', '1686204300');
INSERT INTO `ey_config` VALUES ('173', 'web_status_text', '网站暂时关闭，维护中……', 'web', '', 'cn', '0', '1686204300');
INSERT INTO `ey_config` VALUES ('174', 'web_status_url', '', 'web', '', 'cn', '0', '1686204300');
INSERT INTO `ey_config` VALUES ('175', 'web_status_tpl', '', 'web', '', 'cn', '0', '1686204300');
INSERT INTO `ey_config` VALUES ('176', 'web_recordnum_mode', '0', 'web', '', 'cn', '0', '1686204300');
INSERT INTO `ey_config` VALUES ('177', 'web_garecordnum', '', 'web', '', 'cn', '0', '1686204300');
INSERT INTO `ey_config` VALUES ('178', 'web_garecordnum_mode', '0', 'web', '', 'cn', '0', '1686204300');

-- -----------------------------
-- Table structure for `ey_config_attribute`
-- -----------------------------
DROP TABLE IF EXISTS `ey_config_attribute`;
CREATE TABLE `ey_config_attribute` (
  `attr_id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '表单id',
  `inc_type` varchar(20) DEFAULT '' COMMENT '变量分组',
  `type_id` int(11) unsigned DEFAULT '1',
  `attr_name` varchar(60) DEFAULT '' COMMENT '变量标题',
  `attr_var_name` varchar(50) DEFAULT '' COMMENT '变量名',
  `attr_input_type` tinyint(1) unsigned DEFAULT '0' COMMENT ' 0=文本框，1=下拉框，2=多行文本框，3=上传图片',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`attr_id`)
) ENGINE=MyISAM AUTO_INCREMENT=8 DEFAULT CHARSET=utf8 COMMENT='留言表单属性';

-- -----------------------------
-- Records of `ey_config_attribute`
-- -----------------------------
INSERT INTO `ey_config_attribute` VALUES ('1', 'web', '1', '网站公告', 'web_attr_1', '0', 'cn', '1533544029', '1686204322');
INSERT INTO `ey_config_attribute` VALUES ('2', 'web', '1', '手机号码', 'web_attr_2', '0', 'cn', '1533550261', '1686204322');
INSERT INTO `ey_config_attribute` VALUES ('3', 'web', '1', '地址', 'web_attr_3', '0', 'cn', '1533550302', '1686204322');
INSERT INTO `ey_config_attribute` VALUES ('4', 'web', '1', '电话', 'web_attr_4', '0', 'cn', '1533550375', '1686204322');
INSERT INTO `ey_config_attribute` VALUES ('5', 'web', '1', '邮箱', 'web_attr_5', '0', 'cn', '1533550438', '1686204322');
INSERT INTO `ey_config_attribute` VALUES ('6', 'web', '1', '微信二维码', 'web_attr_6', '3', 'cn', '1533607848', '1686204322');
INSERT INTO `ey_config_attribute` VALUES ('7', 'web', '1', '客服QQ', 'web_attr_7', '0', 'cn', '1533608360', '1686204322');

-- -----------------------------
-- Table structure for `ey_config_type`
-- -----------------------------
DROP TABLE IF EXISTS `ey_config_type`;
CREATE TABLE `ey_config_type` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `type_name` varchar(255) DEFAULT '' COMMENT '分组名称',
  `status` tinyint(1) DEFAULT '1',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  `sort_order` int(11) DEFAULT '100' COMMENT '排序',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COMMENT='自定义变量分组表';

-- -----------------------------
-- Records of `ey_config_type`
-- -----------------------------
INSERT INTO `ey_config_type` VALUES ('1', '默认分组', '1', 'cn', '1650271499', '1650271499', '100');

-- -----------------------------
-- Table structure for `ey_cp_content`
-- -----------------------------
DROP TABLE IF EXISTS `ey_cp_content`;
CREATE TABLE `ey_cp_content` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `aid` int(10) DEFAULT '0' COMMENT '文档ID',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  `content` longtext COMMENT '内容详情',
  PRIMARY KEY (`id`),
  KEY `aid` (`aid`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=19 DEFAULT CHARSET=utf8 COMMENT='附加表';

-- -----------------------------
-- Records of `ey_cp_content`
-- -----------------------------
INSERT INTO `ey_cp_content` VALUES ('1', '15', '1555053555', '1555053555', '&lt;p style=&quot;text-align: center;&quot;&gt;&lt;img src=&quot;/uploads/ueditor/20190412/bcd617212957c9dc6a5412c58c7446d5.jpg&quot; title=&quot;bcd617212957c9dc6a5412c58c7446d5.jpg&quot; alt=&quot;bcd617212957c9dc6a5412c58c7446d5.jpg&quot;/&gt;&lt;/p&gt;');
INSERT INTO `ey_cp_content` VALUES ('2', '16', '1555053579', '1555053579', '&lt;p style=&quot;text-align: center;&quot;&gt;&lt;img src=&quot;/uploads/ueditor/20190412/85ff99bfd9efbd4e1ae17dc2ead76035.jpg&quot; title=&quot;85ff99bfd9efbd4e1ae17dc2ead76035.jpg&quot; alt=&quot;85ff99bfd9efbd4e1ae17dc2ead76035.jpg&quot;/&gt;&lt;/p&gt;');
INSERT INTO `ey_cp_content` VALUES ('3', '17', '1555053594', '1555053594', '&lt;p style=&quot;text-align: center;&quot;&gt;&lt;img src=&quot;/uploads/ueditor/20190412/1c763a29611a28b4b5f9f000b3481a0c.jpg&quot; title=&quot;1c763a29611a28b4b5f9f000b3481a0c.jpg&quot; alt=&quot;1c763a29611a28b4b5f9f000b3481a0c.jpg&quot;/&gt;&lt;/p&gt;');
INSERT INTO `ey_cp_content` VALUES ('4', '18', '1555053608', '1555053608', '&lt;p style=&quot;text-align: center;&quot;&gt;&lt;img src=&quot;/uploads/ueditor/20190412/98763fb03fa81c201889ea0c26e7490e.jpg&quot; title=&quot;98763fb03fa81c201889ea0c26e7490e.jpg&quot; alt=&quot;98763fb03fa81c201889ea0c26e7490e.jpg&quot;/&gt;&lt;/p&gt;');
INSERT INTO `ey_cp_content` VALUES ('5', '19', '1555053624', '1555053624', '&lt;p style=&quot;text-align: center;&quot;&gt;&lt;img src=&quot;/uploads/ueditor/20190412/ee4dff6a00936118779ae001f252725e.jpg&quot; title=&quot;ee4dff6a00936118779ae001f252725e.jpg&quot; alt=&quot;ee4dff6a00936118779ae001f252725e.jpg&quot;/&gt;&lt;/p&gt;');
INSERT INTO `ey_cp_content` VALUES ('6', '20', '1555053639', '1555053639', '&lt;p style=&quot;text-align: center;&quot;&gt;&lt;img src=&quot;/uploads/ueditor/20190412/6d8a523e021f2229eee481b33e1bf54c.jpg&quot; title=&quot;6d8a523e021f2229eee481b33e1bf54c.jpg&quot; alt=&quot;6d8a523e021f2229eee481b33e1bf54c.jpg&quot;/&gt;&lt;/p&gt;');
INSERT INTO `ey_cp_content` VALUES ('7', '21', '1555053764', '1555053764', '&lt;p style=&quot;text-align: center;&quot;&gt;&lt;img src=&quot;/uploads/ueditor/20190412/261db2db709dc3c012a18d88c6844159.png&quot; title=&quot;261db2db709dc3c012a18d88c6844159.png&quot; alt=&quot;261db2db709dc3c012a18d88c6844159.png&quot;/&gt;&lt;/p&gt;');
INSERT INTO `ey_cp_content` VALUES ('8', '22', '1555053778', '1555053778', '&lt;p style=&quot;text-align: center;&quot;&gt;&lt;img src=&quot;/uploads/ueditor/20190412/ae58acdec7b6e9585ee2beba5d14a652.png&quot; title=&quot;ae58acdec7b6e9585ee2beba5d14a652.png&quot; alt=&quot;ae58acdec7b6e9585ee2beba5d14a652.png&quot;/&gt;&lt;/p&gt;');
INSERT INTO `ey_cp_content` VALUES ('9', '23', '1555053794', '1555053794', '&lt;p style=&quot;text-align: center;&quot;&gt;&lt;img src=&quot;/uploads/ueditor/20190412/82eb83d1842cfbed36c1c1700faf3b68.png&quot; title=&quot;82eb83d1842cfbed36c1c1700faf3b68.png&quot; alt=&quot;82eb83d1842cfbed36c1c1700faf3b68.png&quot;/&gt;&lt;/p&gt;');
INSERT INTO `ey_cp_content` VALUES ('10', '24', '1555053920', '1555053920', '&lt;p style=&quot;text-align: center;&quot;&gt;&lt;img src=&quot;/uploads/ueditor/20190412/19f0405d149bcd41ec20b2dbb089f004.png&quot; title=&quot;19f0405d149bcd41ec20b2dbb089f004.png&quot; alt=&quot;19f0405d149bcd41ec20b2dbb089f004.png&quot;/&gt;&lt;/p&gt;');
INSERT INTO `ey_cp_content` VALUES ('11', '25', '1555053934', '1555053934', '&lt;p style=&quot;text-align: center;&quot;&gt;&lt;img src=&quot;/uploads/ueditor/20190412/a6c87d8626dc0763ec0a29e886957442.png&quot; title=&quot;a6c87d8626dc0763ec0a29e886957442.png&quot; alt=&quot;a6c87d8626dc0763ec0a29e886957442.png&quot;/&gt;&lt;/p&gt;');
INSERT INTO `ey_cp_content` VALUES ('12', '26', '1555053950', '1555053950', '&lt;p style=&quot;text-align: center;&quot;&gt;&lt;img src=&quot;/uploads/ueditor/20190412/df517acf1c9cc0c7ce64cf4d4acd6007.png&quot; title=&quot;df517acf1c9cc0c7ce64cf4d4acd6007.png&quot; alt=&quot;df517acf1c9cc0c7ce64cf4d4acd6007.png&quot;/&gt;&lt;/p&gt;');
INSERT INTO `ey_cp_content` VALUES ('13', '27', '1555054000', '1555054000', '&lt;p style=&quot;text-align: center;&quot;&gt;&lt;img src=&quot;/uploads/ueditor/20190412/d3db198cedafd09ff66d32f7a021c3d9.png&quot; title=&quot;d3db198cedafd09ff66d32f7a021c3d9.png&quot; alt=&quot;d3db198cedafd09ff66d32f7a021c3d9.png&quot;/&gt;&lt;/p&gt;');
INSERT INTO `ey_cp_content` VALUES ('14', '28', '1555054012', '1555054012', '&lt;p style=&quot;text-align: center;&quot;&gt;&lt;img src=&quot;/uploads/ueditor/20190412/2ee2205244719343d6e10ed6d0ee347f.png&quot; title=&quot;2ee2205244719343d6e10ed6d0ee347f.png&quot; alt=&quot;2ee2205244719343d6e10ed6d0ee347f.png&quot;/&gt;&lt;/p&gt;');
INSERT INTO `ey_cp_content` VALUES ('15', '29', '1555054025', '1555054025', '&lt;p style=&quot;text-align: center;&quot;&gt;&lt;img src=&quot;/uploads/ueditor/20190412/316a0cd9a5a644cc9a4eff69291c065c.png&quot; title=&quot;316a0cd9a5a644cc9a4eff69291c065c.png&quot; alt=&quot;316a0cd9a5a644cc9a4eff69291c065c.png&quot;/&gt;&lt;/p&gt;');
INSERT INTO `ey_cp_content` VALUES ('16', '30', '1555054039', '1555054039', '&lt;p style=&quot;text-align: center;&quot;&gt;&lt;img src=&quot;/uploads/ueditor/20190412/132289025f8a3c3e156605143b2d81d7.png&quot; title=&quot;132289025f8a3c3e156605143b2d81d7.png&quot; alt=&quot;132289025f8a3c3e156605143b2d81d7.png&quot;/&gt;&lt;/p&gt;');
INSERT INTO `ey_cp_content` VALUES ('17', '31', '1555054204', '1555054204', '&lt;p style=&quot;text-align: center;&quot;&gt;&lt;img src=&quot;/uploads/ueditor/20190412/a9a301b263d459d02328394d11762573.png&quot; title=&quot;a9a301b263d459d02328394d11762573.png&quot; alt=&quot;a9a301b263d459d02328394d11762573.png&quot;/&gt;&lt;/p&gt;');
INSERT INTO `ey_cp_content` VALUES ('18', '32', '1555054216', '1555054216', '&lt;p style=&quot;text-align: center;&quot;&gt;&lt;img src=&quot;/uploads/ueditor/20190412/65137ee3f9b70f15fa3b11cfaac0da5a.png&quot; title=&quot;65137ee3f9b70f15fa3b11cfaac0da5a.png&quot; alt=&quot;65137ee3f9b70f15fa3b11cfaac0da5a.png&quot;/&gt;&lt;/p&gt;');

-- -----------------------------
-- Table structure for `ey_cs_content`
-- -----------------------------
DROP TABLE IF EXISTS `ey_cs_content`;
CREATE TABLE `ey_cs_content` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `aid` int(10) DEFAULT '0' COMMENT '文档ID',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  `wzwz` varchar(200) NOT NULL DEFAULT '' COMMENT '网址',
  `ico` varchar(250) NOT NULL DEFAULT '' COMMENT '图标',
  PRIMARY KEY (`id`),
  KEY `aid` (`aid`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COMMENT='附加表';

-- -----------------------------
-- Records of `ey_cs_content`
-- -----------------------------
INSERT INTO `ey_cs_content` VALUES ('1', '27', '1614155119', '1614155119', 'https://www.bt.cn/', '/uploads/allimg/20190228/339b80f3d43d9a348a98746c502e28a1.jpg');

-- -----------------------------
-- Table structure for `ey_custom_content`
-- -----------------------------
DROP TABLE IF EXISTS `ey_custom_content`;
CREATE TABLE `ey_custom_content` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `aid` int(10) DEFAULT '0' COMMENT '文档ID',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`),
  KEY `aid` (`aid`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='附加表';


-- -----------------------------
-- Table structure for `ey_ddos_log`
-- -----------------------------
DROP TABLE IF EXISTS `ey_ddos_log`;
CREATE TABLE `ey_ddos_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `md5key` varchar(50) DEFAULT '' COMMENT 'md5值',
  `file_name` varchar(500) DEFAULT '' COMMENT '文件名',
  `file_num` int(10) DEFAULT '0' COMMENT '已扫描数',
  `file_total` int(10) DEFAULT '0' COMMENT '总文件数',
  `file_num_ky` int(10) DEFAULT '0' COMMENT '可疑恶意文件数',
  `is_suspicious` tinyint(1) DEFAULT '0' COMMENT '是否可疑',
  `html` text,
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='ddos查杀进度记录表';


-- -----------------------------
-- Table structure for `ey_discount_active`
-- -----------------------------
DROP TABLE IF EXISTS `ey_discount_active`;
CREATE TABLE `ey_discount_active` (
  `active_id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '活动会场ID',
  `active_name` varchar(255) DEFAULT '' COMMENT '活动名称',
  `start_date` int(11) unsigned DEFAULT '0' COMMENT '活动开始时间',
  `end_date` int(11) DEFAULT '0' COMMENT '活动结束时间',
  `limit_type` tinyint(3) unsigned DEFAULT '1' COMMENT '限购类型 1-不限购,2-活动期内每人最多购买n件,3-活动期内每人每天最多购买n件',
  `limit` int(11) unsigned DEFAULT '0' COMMENT '限购数量',
  `preheat` tinyint(3) DEFAULT '0' COMMENT '是否开启预热 0-关闭 1-开启',
  `preheat_time` int(11) DEFAULT '0' COMMENT '预热时间,不能大于开启时间',
  `status` tinyint(3) unsigned NOT NULL DEFAULT '1' COMMENT '活动状态(0禁用 1启用)',
  `is_del` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '是否删除',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '创建时间',
  `update_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`active_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='限时折扣-活动会场表';


-- -----------------------------
-- Table structure for `ey_discount_active_goods`
-- -----------------------------
DROP TABLE IF EXISTS `ey_discount_active_goods`;
CREATE TABLE `ey_discount_active_goods` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键ID',
  `active_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '活动ID',
  `aid` int(11) NOT NULL DEFAULT '0' COMMENT '文档id',
  `discount_goods_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '秒杀商品ID',
  `sales_actual` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '实际销量',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '创建时间',
  `update_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='限时折扣-活动会场与商品关联表';


-- -----------------------------
-- Table structure for `ey_discount_goods`
-- -----------------------------
DROP TABLE IF EXISTS `ey_discount_goods`;
CREATE TABLE `ey_discount_goods` (
  `discount_gid` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '限时折扣商品ID',
  `aid` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '商品ID->aid',
  `discount_stock` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '限时折扣商品库存总量',
  `discount_price` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '限时折扣价格',
  `sales` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '累积销量',
  `virtual_sales` int(11) NOT NULL DEFAULT '0' COMMENT '虚拟销量',
  `sort_order` int(11) unsigned NOT NULL DEFAULT '100' COMMENT '商品排序(数字越小越靠前)',
  `status` tinyint(3) unsigned NOT NULL DEFAULT '1' COMMENT '商品状态(0下架 1上架)',
  `is_del` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '是否删除',
  `is_sku` tinyint(1) NOT NULL DEFAULT '0' COMMENT '1-多规格商品',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '创建时间',
  `update_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`discount_gid`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='限时折扣-商品表';


-- -----------------------------
-- Table structure for `ey_diyminipro`
-- -----------------------------
DROP TABLE IF EXISTS `ey_diyminipro`;
CREATE TABLE `ey_diyminipro` (
  `mini_id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '模板ID',
  `categoryid` int(11) NOT NULL DEFAULT '0' COMMENT '分类ID',
  `name` varchar(100) NOT NULL DEFAULT '' COMMENT '模板标题',
  `litpic` varchar(250) NOT NULL DEFAULT '' COMMENT '封面图',
  `component` text NOT NULL COMMENT '组件库',
  `status` tinyint(1) NOT NULL DEFAULT '0' COMMENT '状态：4=审核中，5=发布',
  `cloud_id` int(10) NOT NULL DEFAULT '0' COMMENT '云ID',
  `config` text NOT NULL COMMENT '相关序列化信息',
  `is_del` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '伪删除，1=是，0=否',
  `lang` varchar(10) NOT NULL DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`mini_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='微信小程序记录表';


-- -----------------------------
-- Table structure for `ey_diyminipro_page`
-- -----------------------------
DROP TABLE IF EXISTS `ey_diyminipro_page`;
CREATE TABLE `ey_diyminipro_page` (
  `page_id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '页面id',
  `page_type` tinyint(3) NOT NULL DEFAULT '-1' COMMENT '页面类型(1首页 -1自定义页)',
  `page_name` varchar(255) NOT NULL DEFAULT '' COMMENT '页面名称',
  `page_data` longtext NOT NULL COMMENT '页面数据',
  `mini_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '微信小程序id',
  `is_home` tinyint(1) NOT NULL DEFAULT '0' COMMENT '设为首页：0=否，1=是',
  `is_system` tinyint(1) NOT NULL DEFAULT '0' COMMENT '系统内置',
  `is_show` tinyint(1) NOT NULL DEFAULT '1' COMMENT '是否显示：1=显示，0=隐藏',
  `is_del` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '伪删除，1=是，0=否',
  `lang` varchar(10) NOT NULL DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`page_id`),
  KEY `mini_id` (`mini_id`,`lang`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='微信小程序diy页面表';


-- -----------------------------
-- Table structure for `ey_diyminipro_setting`
-- -----------------------------
DROP TABLE IF EXISTS `ey_diyminipro_setting`;
CREATE TABLE `ey_diyminipro_setting` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `name` varchar(60) NOT NULL DEFAULT '' COMMENT '页面组',
  `value` text NOT NULL COMMENT '组装之后的值',
  `mini_id` int(11) NOT NULL DEFAULT '0' COMMENT '小程序ID',
  `lang` varchar(10) NOT NULL DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) NOT NULL DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`),
  KEY `type` (`name`) USING BTREE,
  KEY `mini_id` (`mini_id`,`lang`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='微信小程序多功能配置表';


-- -----------------------------
-- Table structure for `ey_download_attr_field`
-- -----------------------------
DROP TABLE IF EXISTS `ey_download_attr_field`;
CREATE TABLE `ey_download_attr_field` (
  `field_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `field_name` varchar(32) DEFAULT '' COMMENT '字段名称',
  `field_title` varchar(32) DEFAULT '' COMMENT '字段标题',
  `field_use` tinyint(1) DEFAULT '0' COMMENT '字段是否使用，0未使用，1为使用',
  `sort_order` smallint(5) DEFAULT '0' COMMENT '排序',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) unsigned DEFAULT '0' COMMENT '上传时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`field_id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COMMENT='上传文件属性表';

-- -----------------------------
-- Records of `ey_download_attr_field`
-- -----------------------------
INSERT INTO `ey_download_attr_field` VALUES ('1', 'extract_code', '提取码', '1', '1', 'cn', '1561001807', '1561024954');
INSERT INTO `ey_download_attr_field` VALUES ('2', 'server_name', '服务器名称', '1', '2', 'cn', '1561001807', '1561078673');

-- -----------------------------
-- Table structure for `ey_download_content`
-- -----------------------------
DROP TABLE IF EXISTS `ey_download_content`;
CREATE TABLE `ey_download_content` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `aid` int(10) DEFAULT '0' COMMENT '文档ID',
  `content` longtext COMMENT '内容详情',
  `content_ey_m` longtext COMMENT '手机端内容详情',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`),
  KEY `news_id` (`aid`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='资讯内容表_存储正常内容';


-- -----------------------------
-- Table structure for `ey_download_file`
-- -----------------------------
DROP TABLE IF EXISTS `ey_download_file`;
CREATE TABLE `ey_download_file` (
  `file_id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `aid` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT '产品ID',
  `title` varchar(200) DEFAULT '' COMMENT '产品标题',
  `file_url` varchar(255) DEFAULT '' COMMENT '文件存储路径',
  `extract_code` varchar(20) DEFAULT '' COMMENT '文件提取码',
  `file_size` varchar(255) DEFAULT '' COMMENT '文件大小',
  `file_ext` varchar(50) DEFAULT '' COMMENT '文件后缀名',
  `file_name` varchar(200) DEFAULT '' COMMENT '文件名',
  `server_name` varchar(200) DEFAULT '' COMMENT '服务器名称',
  `file_mime` varchar(200) DEFAULT '' COMMENT '文件类型',
  `uhash` varchar(200) DEFAULT '' COMMENT '自定义的一种加密方式，用于文件下载权限验证',
  `md5file` varchar(200) DEFAULT '' COMMENT 'md5_file加密，可以检测上传/下载的文件包是否损坏',
  `is_remote` tinyint(1) DEFAULT '0' COMMENT '是否远程',
  `downcount` int(10) DEFAULT '0' COMMENT '下载次数',
  `sort_order` smallint(5) DEFAULT '0' COMMENT '排序',
  `add_time` int(10) unsigned DEFAULT '0' COMMENT '上传时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`file_id`),
  KEY `arcid` (`aid`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


-- -----------------------------
-- Table structure for `ey_download_log`
-- -----------------------------
DROP TABLE IF EXISTS `ey_download_log`;
CREATE TABLE `ey_download_log` (
  `log_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `users_id` int(10) DEFAULT '0' COMMENT '用户ID',
  `aid` int(10) DEFAULT '0' COMMENT '文档ID',
  `file_id` int(10) DEFAULT '0' COMMENT '附件ID',
  `ip` varchar(20) DEFAULT '' COMMENT 'ip',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '编辑时间',
  PRIMARY KEY (`log_id`),
  KEY `file_id` (`file_id`,`aid`,`users_id`) USING BTREE,
  KEY `aid` (`aid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='下载记录表';


-- -----------------------------
-- Table structure for `ey_download_order`
-- -----------------------------
DROP TABLE IF EXISTS `ey_download_order`;
CREATE TABLE `ey_download_order` (
  `order_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '文章订单ID',
  `order_code` varchar(50) NOT NULL DEFAULT '' COMMENT '媒体订单编号',
  `users_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '会员ID',
  `order_status` tinyint(1) NOT NULL DEFAULT '0' COMMENT '订单状态：0未付款，1已付款',
  `order_amount` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '订单应付总金额',
  `pay_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '支付时间',
  `pay_name` varchar(20) NOT NULL DEFAULT '' COMMENT '支付方式名称',
  `wechat_pay_type` varchar(20) NOT NULL DEFAULT '' COMMENT '微信支付时，标记使用的支付类型（扫码支付，微信内部，微信H5页面）',
  `pay_details` text COMMENT '支付时返回的数据，以serialize序列化后存入，用于后续查询。',
  `product_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '视频文档ID',
  `product_name` varchar(100) DEFAULT '' COMMENT '视频文档名称',
  `product_litpic` varchar(500) DEFAULT '' COMMENT '视频文档封面图片',
  `lang` varchar(30) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) unsigned DEFAULT '0' COMMENT '下单时间',
  `update_time` int(11) unsigned DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`order_id`),
  UNIQUE KEY `order_code` (`order_code`) USING BTREE,
  KEY `users_id` (`users_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;


-- -----------------------------
-- Table structure for `ey_email_template`
-- -----------------------------
DROP TABLE IF EXISTS `ey_email_template`;
CREATE TABLE `ey_email_template` (
  `tpl_id` mediumint(8) NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `tpl_title` varchar(100) DEFAULT '' COMMENT '邮件标题',
  `tpl_content` text COMMENT '发送邮件内容',
  `send_scene` varchar(100) DEFAULT '' COMMENT '邮件发送场景',
  `add_time` int(11) DEFAULT NULL COMMENT '添加时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`tpl_id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

-- -----------------------------
-- Records of `ey_email_template`
-- -----------------------------
INSERT INTO `ey_email_template` VALUES ('1', '您有新的邮件，请注意查收！', '<p>亲爱的会员：</p><p>${content}</p>', '1', '1509268284', '1509281095');

-- -----------------------------
-- Table structure for `ey_field_type`
-- -----------------------------
DROP TABLE IF EXISTS `ey_field_type`;
CREATE TABLE `ey_field_type` (
  `name` varchar(32) NOT NULL DEFAULT '' COMMENT '字段类型',
  `title` varchar(64) NOT NULL DEFAULT '' COMMENT '中文类型名',
  `ifoption` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否需要设置选项',
  `sort_order` int(10) NOT NULL DEFAULT '0' COMMENT '排序',
  `add_time` int(11) NOT NULL DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`name`),
  UNIQUE KEY `name` (`name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='字段类型表';

-- -----------------------------
-- Records of `ey_field_type`
-- -----------------------------
INSERT INTO `ey_field_type` VALUES ('text', '单行文本', '0', '1', '1532485708', '1532485708');
INSERT INTO `ey_field_type` VALUES ('checkbox', '多选项', '1', '5', '1532485708', '1532485708');
INSERT INTO `ey_field_type` VALUES ('multitext', '多行文本', '0', '2', '1532485708', '1532485708');
INSERT INTO `ey_field_type` VALUES ('radio', '单选项', '1', '4', '1532485708', '1532485708');
INSERT INTO `ey_field_type` VALUES ('switch', '开关', '0', '13', '1532485708', '1532485708');
INSERT INTO `ey_field_type` VALUES ('select', '下拉框', '1', '6', '1532485708', '1532485708');
INSERT INTO `ey_field_type` VALUES ('img', '单张图', '0', '10', '1532485708', '1532485708');
INSERT INTO `ey_field_type` VALUES ('int', '整数类型', '0', '7', '1532485708', '1532485708');
INSERT INTO `ey_field_type` VALUES ('datetime', '日期和时间', '0', '12', '1532485708', '1532485708');
INSERT INTO `ey_field_type` VALUES ('htmltext', 'HTML文本', '0', '3', '1532485708', '1532485708');
INSERT INTO `ey_field_type` VALUES ('imgs', '多张图', '0', '11', '1532485708', '1532485708');
INSERT INTO `ey_field_type` VALUES ('decimal', '金额类型', '0', '9', '1532485708', '1532485708');
INSERT INTO `ey_field_type` VALUES ('float', '小数类型', '0', '8', '1532485708', '1532485708');
INSERT INTO `ey_field_type` VALUES ('region', '区域类型', '1', '6', '1532485708', '1532485708');
INSERT INTO `ey_field_type` VALUES ('file', '附件类型', '0', '11', '1532485708', '1532485708');
INSERT INTO `ey_field_type` VALUES ('media', '多媒体类型', '0', '11', '1532485708', '1532485708');

-- -----------------------------
-- Table structure for `ey_form`
-- -----------------------------
DROP TABLE IF EXISTS `ey_form`;
CREATE TABLE `ey_form` (
  `form_id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增表单ID',
  `form_name` varchar(255) NOT NULL DEFAULT '' COMMENT '表单名称',
  `intro` text NOT NULL COMMENT '表单描述，预留',
  `status` tinyint(1) NOT NULL DEFAULT '1' COMMENT '表单状态，0关闭，1开启',
  `attr_auto` tinyint(1) DEFAULT '0' COMMENT '自动标签：0=否，1=是',
  `lang` varchar(10) NOT NULL DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) NOT NULL DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`form_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='表单管理表';


-- -----------------------------
-- Table structure for `ey_fuwu_content`
-- -----------------------------
DROP TABLE IF EXISTS `ey_fuwu_content`;
CREATE TABLE `ey_fuwu_content` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `aid` int(10) DEFAULT '0' COMMENT '文档ID',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`),
  KEY `aid` (`aid`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='附加表';


-- -----------------------------
-- Table structure for `ey_guestbook`
-- -----------------------------
DROP TABLE IF EXISTS `ey_guestbook`;
CREATE TABLE `ey_guestbook` (
  `aid` int(11) NOT NULL AUTO_INCREMENT,
  `form_type` tinyint(1) DEFAULT '0' COMMENT '数据分类：0=留言模型，1=自由表单',
  `typeid` int(11) DEFAULT '0' COMMENT '栏目ID/表单ID',
  `channel` smallint(5) DEFAULT '0' COMMENT '模型ID',
  `users_id` int(11) DEFAULT '0' COMMENT '用户id',
  `md5data` varchar(50) DEFAULT '' COMMENT '数据序列化之后的MD5加密，提交内容的唯一性',
  `ip` varchar(255) DEFAULT '' COMMENT 'ip地址',
  `is_read` tinyint(1) DEFAULT '0' COMMENT '0=未读，1=已读',
  `is_star` tinyint(1) DEFAULT '0' COMMENT '标记星号',
  `source` tinyint(1) DEFAULT '0' COMMENT '提交来源：1=电脑端，2=手机端',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`aid`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;


-- -----------------------------
-- Table structure for `ey_guestbook_attr`
-- -----------------------------
DROP TABLE IF EXISTS `ey_guestbook_attr`;
CREATE TABLE `ey_guestbook_attr` (
  `guest_attr_id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '留言表单id自增',
  `aid` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT '留言id',
  `form_type` tinyint(1) DEFAULT '0' COMMENT '数据分类：0=留言模型，1=自由表单',
  `attr_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '表单id',
  `attr_value` text COMMENT '表单值',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`guest_attr_id`),
  KEY `attr_id` (`attr_id`) USING BTREE,
  KEY `guest_id` (`aid`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=7 DEFAULT CHARSET=utf8 COMMENT='留言表单属性值';


-- -----------------------------
-- Table structure for `ey_guestbook_attribute`
-- -----------------------------
DROP TABLE IF EXISTS `ey_guestbook_attribute`;
CREATE TABLE `ey_guestbook_attribute` (
  `attr_id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '表单id',
  `attr_name` varchar(60) DEFAULT '' COMMENT '表单名称',
  `typeid` int(11) unsigned DEFAULT '0' COMMENT '栏目ID/表单ID',
  `form_type` tinyint(1) DEFAULT '0' COMMENT '数据分类：0=留言模型，1=自由表单',
  `attr_input_type` tinyint(1) unsigned DEFAULT '0' COMMENT ' 0=文本框，1=下拉框，2=多行文本框',
  `attr_values` text COMMENT '可选值列表',
  `is_showlist` tinyint(1) DEFAULT '0' COMMENT '在列表显示 0=隐藏，1=显示',
  `required` tinyint(1) DEFAULT '0' COMMENT '必填 0=否，1=是',
  `validate_type` smallint(5) DEFAULT '0' COMMENT '验证格式，0=不验证，1=手机，2=Email',
  `real_validate` tinyint(1) unsigned DEFAULT '0' COMMENT '是否进行真实验证，0=不验证，1=真实验证',
  `sort_order` int(11) unsigned DEFAULT '0' COMMENT '表单排序',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `is_del` tinyint(1) DEFAULT '0' COMMENT '是否已删除，0=否，1=是',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`attr_id`),
  KEY `guest_id` (`typeid`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COMMENT='留言表单属性';

-- -----------------------------
-- Records of `ey_guestbook_attribute`
-- -----------------------------
INSERT INTO `ey_guestbook_attribute` VALUES ('1', '姓名', '7', '0', '0', '', '1', '0', '0', '0', '100', 'cn', '0', '1533612170', '1613980373');
INSERT INTO `ey_guestbook_attribute` VALUES ('2', '留言内容', '7', '0', '2', '', '1', '0', '0', '0', '100', 'cn', '0', '1533612191', '1613980373');
INSERT INTO `ey_guestbook_attribute` VALUES ('3', '手机号码', '7', '0', '0', '', '1', '0', '0', '0', '100', 'cn', '0', '1533612201', '1613980373');

-- -----------------------------
-- Table structure for `ey_guwen_content`
-- -----------------------------
DROP TABLE IF EXISTS `ey_guwen_content`;
CREATE TABLE `ey_guwen_content` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `aid` int(10) DEFAULT '0' COMMENT '文档ID',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  `diy_cyjy` varchar(200) NOT NULL DEFAULT '' COMMENT '从业经验',
  `diy_cgal` varchar(200) NOT NULL DEFAULT '' COMMENT '成功案例',
  `diy_dh` varchar(200) NOT NULL DEFAULT '' COMMENT '电话',
  `content` longtext COMMENT '详情',
  PRIMARY KEY (`id`),
  KEY `aid` (`aid`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=18 DEFAULT CHARSET=utf8 COMMENT='附加表';

-- -----------------------------
-- Records of `ey_guwen_content`
-- -----------------------------
INSERT INTO `ey_guwen_content` VALUES ('1', '101', '1622787976', '1622787976', '4', '56', '13812345678', '&lt;p&gt;优秀的人，无论生活和工作给他人展示的总是一个态度，即做事踏实和用心。&lt;/p&gt;');
INSERT INTO `ey_guwen_content` VALUES ('3', '103', '1622788158', '1622788158', '5', '76', '13812345678', '&lt;p&gt;做透，揭示了“细中见精”、“小中见大”、“伟大与平凡”的真理。&lt;/p&gt;');
INSERT INTO `ey_guwen_content` VALUES ('2', '102', '1622787971', '1622787971', '3', '58', '13812345678', '&lt;p&gt;优秀的人，无论生活和工作给他人展示的总是一个态度，即做事踏实和用心&lt;/p&gt;');
INSERT INTO `ey_guwen_content` VALUES ('4', '104', '1622788475', '1622788475', '6', '67', '13812345678', '&lt;p&gt;生活和工作给他人展示的总是一个态度，即做事踏实和用心。&lt;/p&gt;');
INSERT INTO `ey_guwen_content` VALUES ('5', '105', '1622788225', '1622788225', '5', '86', '13812345678', '&lt;p&gt;无论生活和工作给他人展示的总是一个态度，即做事踏实和用心。&lt;/p&gt;');
INSERT INTO `ey_guwen_content` VALUES ('6', '106', '1622788253', '1622788253', '5', '58', '13812345678', '&lt;p&gt;无论生活和工作给他人展示的总是一个态度。&lt;/p&gt;');
INSERT INTO `ey_guwen_content` VALUES ('7', '107', '1622788281', '1622788281', '4', '46', '13812345678', '&lt;p&gt;不论做什么工作，都要重视小事、关注细节，把小事做细、做透，揭示了“细中见精”、“小中见大”、“伟大与平凡”的真理。&lt;/p&gt;');
INSERT INTO `ey_guwen_content` VALUES ('8', '108', '1622788320', '1622788320', '6', '72', '13812345678', '&lt;p&gt;公司经营范围为股权投资、债权投资、项目投资、资产管理、企业并购重组、投资管理及咨询和理财信息咨询。 金融作为联想控股成员企业，把为中小企业融资融智，推动实体经济发展。&lt;/p&gt;');
INSERT INTO `ey_guwen_content` VALUES ('9', '109', '1622788354', '1622788354', '6', '113', '13812345678', '&lt;p&gt;优秀的人，无论生活和工作给他人展示的总是一个态度，即做事踏实和用心。不论做什么工作，都要重视小事、关注细节，把小事做细、做透，揭示了“细中见精”、“小中见大”、“伟大与平凡”的真理。&lt;/p&gt;');
INSERT INTO `ey_guwen_content` VALUES ('10', '110', '1622788394', '1622788394', '6', '164', '13812345678', '&lt;p&gt;优秀的人，无论生活和工作给他人展示的总是一个态度，即做事踏实和用心。不论做什么工作，都要重视小事、关注细节，把小事做细、做透，揭示了“细中见精”、“小中见大”、“伟大与平凡”的真理。&lt;/p&gt;');
INSERT INTO `ey_guwen_content` VALUES ('11', '111', '1622788422', '1622788422', '4', '76', '13812345678', '&lt;p&gt;工作给他人展示的总是一个态度，即做事踏实和用心。不论做什么工作，都要重视小事、关注细节，把小事做细、做透，揭示了“细中见精”、“小中见大”、“伟大与平凡”的真理。&lt;/p&gt;');
INSERT INTO `ey_guwen_content` VALUES ('12', '112', '1622788459', '1622788459', '5', '96', '13812345678', '&lt;p&gt;无论生活和工作给他人展示的总是一个态度，即做事踏实和用心。不论做什么工作，都要重视小事、关注细节.&lt;/p&gt;');
INSERT INTO `ey_guwen_content` VALUES ('13', '113', '1622788664', '1622788664', '6', '135', '13812345678', '&lt;p&gt;优秀的人，无论生活和工作给他人展示的总是一个态度，即做事踏实和用心。不论做什么工作，都要重视小事、关注细节，把小事做细、做透，揭示了“细中见精”、“小中见大”、“伟大与平凡”的真理。&lt;/p&gt;');
INSERT INTO `ey_guwen_content` VALUES ('14', '114', '1622788722', '1622788722', '3', '76', '13812345678', '&lt;p&gt;优秀的人，无论生活和工作给他人展示的总是一个态度，即做事踏实和用心。不论做什么工作，都要重视小事、关注细节，把小事做细、做透，揭示了“细中见精”、“小中见大”、“伟大与平凡”的真理。&lt;/p&gt;');
INSERT INTO `ey_guwen_content` VALUES ('15', '115', '1622788750', '1622788750', '9', '352', '13812345678', '&lt;p&gt;优秀的人，无论生活和工作给他人展示的总是一个态度，即做事踏实和用心。不论做什么工作，都要重视小事、关注细节，把小事做细、做透，揭示了“细中见精”、“小中见大”、“伟大与平凡”的真理。&lt;/p&gt;');
INSERT INTO `ey_guwen_content` VALUES ('16', '116', '1622788814', '1622788814', '5', '287', '13812345678', '&lt;p&gt;无论生活和工作给他人展示的总是一个态度，即做事踏实和用心。不论做什么工作，都要重视小事、关注细节，把小事做细、做透，揭示了“细中见精”、“小中见大”、“伟大与平凡”的真理。&lt;/p&gt;');
INSERT INTO `ey_guwen_content` VALUES ('17', '117', '1622788851', '1622788851', '6', '276', '13812345678', '&lt;p&gt;不论做什么工作，都要重视小事、关注细节，把小事做细、做透，揭示了“细中见精”、“小中见大”、“伟大与平凡”的真理。&lt;/p&gt;');

-- -----------------------------
-- Table structure for `ey_hezuo_content`
-- -----------------------------
DROP TABLE IF EXISTS `ey_hezuo_content`;
CREATE TABLE `ey_hezuo_content` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `aid` int(10) DEFAULT '0' COMMENT '文档ID',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`),
  KEY `aid` (`aid`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=9 DEFAULT CHARSET=utf8 COMMENT='附加表';

-- -----------------------------
-- Records of `ey_hezuo_content`
-- -----------------------------
INSERT INTO `ey_hezuo_content` VALUES ('1', '66', '1599636856', '1599636856');
INSERT INTO `ey_hezuo_content` VALUES ('2', '67', '1599636870', '1599636870');
INSERT INTO `ey_hezuo_content` VALUES ('3', '68', '1599636881', '1599636881');
INSERT INTO `ey_hezuo_content` VALUES ('4', '69', '1599636893', '1599636893');
INSERT INTO `ey_hezuo_content` VALUES ('5', '70', '1599636904', '1599636904');
INSERT INTO `ey_hezuo_content` VALUES ('6', '71', '1599636918', '1599636918');
INSERT INTO `ey_hezuo_content` VALUES ('7', '72', '1599636930', '1599636930');
INSERT INTO `ey_hezuo_content` VALUES ('8', '73', '1599636943', '1599636943');

-- -----------------------------
-- Table structure for `ey_hooks`
-- -----------------------------
DROP TABLE IF EXISTS `ey_hooks`;
CREATE TABLE `ey_hooks` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键',
  `name` varchar(50) NOT NULL DEFAULT '' COMMENT '钩子名称',
  `description` text COMMENT '描述',
  `module` varchar(50) DEFAULT '' COMMENT '钩子挂载的插件',
  `status` tinyint(1) unsigned DEFAULT '1' COMMENT '状态：0=无效，1=有效',
  `add_time` int(10) DEFAULT NULL,
  `update_time` int(10) unsigned DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`),
  KEY `name` (`name`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='插件钩子表';


-- -----------------------------
-- Table structure for `ey_images17_content`
-- -----------------------------
DROP TABLE IF EXISTS `ey_images17_content`;
CREATE TABLE `ey_images17_content` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `aid` int(10) DEFAULT '0' COMMENT '文档ID',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  `imgurls` text COMMENT '图片集合|10001',
  `content` longtext COMMENT '图集内容',
  PRIMARY KEY (`id`),
  KEY `aid` (`aid`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=7 DEFAULT CHARSET=utf8 COMMENT='附加表';

-- -----------------------------
-- Records of `ey_images17_content`
-- -----------------------------
INSERT INTO `ey_images17_content` VALUES ('1', '1', '1636426759', '1636426759', 'a:2:{i:0;a:2:{s:9:\"image_url\";s:39:\"/uploads/allimg/200730/1-200I01A107.jpg\";s:5:\"intro\";s:0:\"\";}i:1;a:2:{s:9:\"image_url\";s:39:\"/uploads/allimg/200730/1-200I01A112.jpg\";s:5:\"intro\";s:0:\"\";}}', '');
INSERT INTO `ey_images17_content` VALUES ('2', '2', '1636426759', '1636426759', 'a:4:{i:0;a:2:{s:9:\"image_url\";s:39:\"/uploads/allimg/200730/1-200I01G441.jpg\";s:5:\"intro\";s:0:\"\";}i:1;a:2:{s:9:\"image_url\";s:39:\"/uploads/allimg/200730/1-200I01G443.jpg\";s:5:\"intro\";s:0:\"\";}i:2;a:2:{s:9:\"image_url\";s:39:\"/uploads/allimg/200730/1-200I01G445.jpg\";s:5:\"intro\";s:0:\"\";}i:3;a:2:{s:9:\"image_url\";s:39:\"/uploads/allimg/200730/1-200I01G447.jpg\";s:5:\"intro\";s:0:\"\";}}', '');
INSERT INTO `ey_images17_content` VALUES ('3', '3', '1636426759', '1636426759', 'a:2:{i:0;a:2:{s:9:\"image_url\";s:39:\"/uploads/allimg/200730/1-200I01H912.jpg\";s:5:\"intro\";s:0:\"\";}i:1;a:2:{s:9:\"image_url\";s:39:\"/uploads/allimg/200730/1-200I01H914.jpg\";s:5:\"intro\";s:0:\"\";}}', '');
INSERT INTO `ey_images17_content` VALUES ('4', '4', '1636426759', '1636426759', 'a:2:{i:0;a:2:{s:9:\"image_url\";s:39:\"/uploads/allimg/200730/1-200I01I011.jpg\";s:5:\"intro\";s:0:\"\";}i:1;a:2:{s:9:\"image_url\";s:39:\"/uploads/allimg/200730/1-200I01I013.jpg\";s:5:\"intro\";s:0:\"\";}}', '');
INSERT INTO `ey_images17_content` VALUES ('5', '5', '1636426759', '1636426759', 'a:2:{i:0;a:2:{s:9:\"image_url\";s:39:\"/uploads/allimg/200730/1-200I01I059.jpg\";s:5:\"intro\";s:0:\"\";}i:1;a:2:{s:9:\"image_url\";s:39:\"/uploads/allimg/200730/1-200I01I101.jpg\";s:5:\"intro\";s:0:\"\";}}', '');
INSERT INTO `ey_images17_content` VALUES ('6', '6', '1636426759', '1636426759', 'a:2:{i:0;a:2:{s:9:\"image_url\";s:39:\"/uploads/allimg/200730/1-200I01I206.jpg\";s:5:\"intro\";s:0:\"\";}i:1;a:2:{s:9:\"image_url\";s:39:\"/uploads/allimg/200730/1-200I01I208.jpg\";s:5:\"intro\";s:0:\"\";}}', '');

-- -----------------------------
-- Table structure for `ey_images18_content`
-- -----------------------------
DROP TABLE IF EXISTS `ey_images18_content`;
CREATE TABLE `ey_images18_content` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `aid` int(10) DEFAULT '0' COMMENT '文档ID',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  `imgurls` text COMMENT '图片集合|10001',
  `content` longtext COMMENT '图集内容',
  `dizhi` varchar(251) NOT NULL DEFAULT '' COMMENT '地址',
  `jingdu` varchar(251) NOT NULL DEFAULT '' COMMENT '地图经度',
  `weidu` varchar(251) NOT NULL DEFAULT '' COMMENT '地图维度',
  PRIMARY KEY (`id`),
  KEY `aid` (`aid`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 COMMENT='附加表';

-- -----------------------------
-- Records of `ey_images18_content`
-- -----------------------------
INSERT INTO `ey_images18_content` VALUES ('1', '18', '1637133079', '1637133079', 'a:4:{i:0;a:2:{s:9:\"image_url\";s:40:\"/uploads/allimg/200603/1-2006031Q134.jpg\";s:5:\"intro\";s:0:\"\";}i:1;a:2:{s:9:\"image_url\";s:40:\"/uploads/allimg/200603/1-2006031Q135.jpg\";s:5:\"intro\";s:0:\"\";}i:2;a:2:{s:9:\"image_url\";s:40:\"/uploads/allimg/200603/1-2006031Q136.jpg\";s:5:\"intro\";s:0:\"\";}i:3;a:2:{s:9:\"image_url\";s:40:\"/uploads/allimg/200603/1-2006031Q138.jpg\";s:5:\"intro\";s:0:\"\";}}', '&lt;p&gt;\r\n	北京市八宝山殡仪馆是全市规模最大、设施齐全的殡仪服务单位，承担着本市城近郊区市民、已故党和国家领导人、海外侨胞、国际友人的殡仪服务业务。每年承办告别活动6000余场，接待来宾近百万人次，年火化量2万多具。本馆坚持&amp;ldquo;服务第一，丧家至上&amp;rdquo;的宗旨，不断推行科学管理，提高服务质量，受到社会好评，连续多次被评为&amp;ldquo;首都精神文明单位&amp;rdquo;、&amp;ldquo;全国殡葬改革先进单位&amp;rdquo;、&amp;ldquo;北京市花园市单位&amp;rdquo;，2004年被国家民政部评为全国民政基层行风建设先进集体。&lt;/p&gt;\r\n&lt;p&gt;\r\n	　　八宝山殡仪馆始建于1958年，是北京历史上较早的殡仪馆之一。多年来，几经大规模建设改造，已经形成一整套独特的建设风格和服务体系，&amp;ldquo;八宝山&amp;rdquo;因此而成为中国殡葬业的代名词。&lt;/p&gt;\r\n&lt;p&gt;\r\n	　　服务标准：殡仪服务人员要统一着装，仪表端庄，语言文明，挂牌服务；各岗位职责明确，规范服务；遵守职业道德，拒收馈赠，杜绝索取财物。执行国家物价部门规定的收费标准。&lt;/p&gt;\r\n&lt;p&gt;\r\n	　　1、&amp;ldquo;一条龙&amp;rdquo;车辆调度室服务员：使用文明用语，服务态度热情，耐心解答询问，准确叮嘱家属等车时间、地点、注意事项。&lt;/p&gt;\r\n&lt;p&gt;\r\n	　　2、灵车司机：服从调度室安排，准时到达接运遗体地点；文明驾驶，保证车辆平稳不颠簸，转弯和过路口时照顾家属车辆，不甩车。&lt;/p&gt;\r\n&lt;p&gt;\r\n	　　3、引导服务员（接尸工）：接运遗体轻抬轻放；尊重亡者，脱穿衣文明；主动服务，满足要求；排忧解难，耐心周到。&lt;/p&gt;\r\n&lt;p&gt;\r\n	　　4、整容工：一般整容化妆着色均匀、自然、神态安祥、衣着整齐。特殊整容力求恢复原貌达到亡者家属满意。&lt;/p&gt;\r\n&lt;p&gt;\r\n	　　5、告别室服务员：尊重家属要求，协助布置会场；提供必要服务。&lt;/p&gt;\r\n&lt;p&gt;\r\n	　　6、火化工：遵守操作规程，保证骨灰质量。&lt;/p&gt;\r\n&lt;p&gt;\r\n	　　7、售盒服务员：服务态度和蔼，熟悉商品特点，主动介绍商品，满足不同层次的需要。&lt;/p&gt;\r\n&lt;p&gt;\r\n	　　8、刻字工：按要求逐字刻印，字迹清楚，准确无误。&lt;/p&gt;\r\n&lt;p&gt;\r\n	　　9、收银员：认真审核收费项目，填写标据字迹清楚，收款时唱收唱付。&lt;/p&gt;\r\n&lt;p&gt;\r\n	　　10、发灰员：严格按照发灰手续办理，凭火化证发放骨灰。尊重逝者，双手递送，杜绝差错。&lt;/p&gt;\r\n&lt;p&gt;\r\n	　　11、骨灰堂服务员：填写卡片字迹清楚，准确无误；陪同家属到达存骨灰堂室。&lt;/p&gt;\r\n&lt;p&gt;\r\n	　　服务时限：1、全天候二十四小时提供殡仪服务。2、按照丧家要求准时到达接运遗体地点。3、以遗体进入火化车间为准，四小时内取灰。&lt;/p&gt;\r\n&lt;p&gt;\r\n	　　向社会各界郑重承诺：&lt;/p&gt;\r\n&lt;p&gt;\r\n	　　1、加强廉政建设，纠正行业不正之风，严格遵守职业道德规范，不得接受丧家馈增的烟、酒、钱、物。&lt;/p&gt;\r\n&lt;p&gt;\r\n	　　2、坚持优质服务，文明用语，礼貌待人，主动热情，严格按照殡仪服务规范进行工作。&lt;/p&gt;\r\n&lt;p&gt;\r\n	　　3、严格执行国家物价部门规定的收费标准。&lt;/p&gt;\r\n&lt;p&gt;\r\n	　　4、实行面对全市各区县和国内、国际的二十四小时全天候&amp;ldquo;一条龙&amp;rdquo;服务，并保证灵车随叫随到接运遗体（四小时之内）。&lt;/p&gt;\r\n&lt;p&gt;\r\n	　　5、火化遗体保证文明操作，一炉一尸，保证当天取灰（四小时）之内。&lt;/p&gt;\r\n', '北京市石景山区石景山路9号', '113.269251', '23.201809');
INSERT INTO `ey_images18_content` VALUES ('2', '19', '1637133079', '1637133079', 'a:3:{i:0;a:2:{s:9:\"image_url\";s:39:\"/uploads/allimg/200603/1-2006031SS0.jpg\";s:5:\"intro\";s:0:\"\";}i:1;a:2:{s:9:\"image_url\";s:39:\"/uploads/allimg/200603/1-2006031SS3.jpg\";s:5:\"intro\";s:0:\"\";}i:2;a:2:{s:9:\"image_url\";s:39:\"/uploads/allimg/200603/1-2006031SS6.jpg\";s:5:\"intro\";s:0:\"\";}}', '&lt;p&gt;\r\n	北京市八宝山殡仪馆是全市规模最大、设施齐全的殡仪服务单位，承担着本市城近郊区市民、已故党和国家领导人、海外侨胞、国际友人的殡仪服务业务。每年承办告别活动6000余场，接待来宾近百万人次，年火化量2万多具。本馆坚持&amp;ldquo;服务第一，丧家至上&amp;rdquo;的宗旨，不断推行科学管理，提高服务质量，受到社会好评，连续多次被评为&amp;ldquo;首都精神文明单位&amp;rdquo;、&amp;ldquo;全国殡葬改革先进单位&amp;rdquo;、&amp;ldquo;北京市花园市单位&amp;rdquo;，2004年被国家民政部评为全国民政基层行风建设先进集体。&lt;/p&gt;\r\n&lt;p&gt;\r\n	　　八宝山殡仪馆始建于1958年，是北京历史上较早的殡仪馆之一。多年来，几经大规模建设改造，已经形成一整套独特的建设风格和服务体系，&amp;ldquo;八宝山&amp;rdquo;因此而成为中国殡葬业的代名词。&lt;/p&gt;\r\n&lt;p&gt;\r\n	　　服务标准：殡仪服务人员要统一着装，仪表端庄，语言文明，挂牌服务；各岗位职责明确，规范服务；遵守职业道德，拒收馈赠，杜绝索取财物。执行国家物价部门规定的收费标准。&lt;/p&gt;\r\n', '广州市平谷区西峪水库东岸', '113.269251', '23.201809');
INSERT INTO `ey_images18_content` VALUES ('3', '20', '1637133079', '1637133079', 'a:3:{i:0;a:2:{s:9:\"image_url\";s:40:\"/uploads/allimg/200603/1-2006031S923.jpg\";s:5:\"intro\";s:0:\"\";}i:1;a:2:{s:9:\"image_url\";s:40:\"/uploads/allimg/200603/1-2006031S926.jpg\";s:5:\"intro\";s:0:\"\";}i:2;a:2:{s:9:\"image_url\";s:40:\"/uploads/allimg/200603/1-2006031S929.jpg\";s:5:\"intro\";s:0:\"\";}}', '&lt;p&gt;\r\n	北京市八宝山殡仪馆是全市规模最大、设施齐全的殡仪服务单位，承担着本市城近郊区市民、已故党和国家领导人、海外侨胞、国际友人的殡仪服务业务。每年承办告别活动6000余场，接待来宾近百万人次，年火化量2万多具。本馆坚持&amp;ldquo;服务第一，丧家至上&amp;rdquo;的宗旨，不断推行科学管理，提高服务质量，受到社会好评，连续多次被评为&amp;ldquo;首都精神文明单位&amp;rdquo;、&amp;ldquo;全国殡葬改革先进单位&amp;rdquo;、&amp;ldquo;北京市花园市单位&amp;rdquo;，2004年被国家民政部评为全国民政基层行风建设先进集体。&lt;/p&gt;\r\n&lt;p&gt;\r\n	　　八宝山殡仪馆始建于1958年，是北京历史上较早的殡仪馆之一。多年来，几经大规模建设改造，已经形成一整套独特的建设风格和服务体系，&amp;ldquo;八宝山&amp;rdquo;因此而成为中国殡葬业的代名词。&lt;/p&gt;\r\n&lt;p&gt;\r\n	　　服务标准：殡仪服务人员要统一着装，仪表端庄，语言文明，挂牌服务；各岗位职责明确，规范服务；遵守职业道德，拒收馈赠，杜绝索取财物。执行国家物价部门规定的收费标准。&lt;/p&gt;\r\n&lt;p&gt;\r\n	　　1、&amp;ldquo;一条龙&amp;rdquo;车辆调度室服务员：使用文明用语，服务态度热情，耐心解答询问，准确叮嘱家属等车时间、地点、注意事项。&lt;/p&gt;\r\n&lt;p&gt;\r\n	　　2、灵车司机：服从调度室安排，准时到达接运遗体地点；文明驾驶，保证车辆平稳不颠簸，转弯和过路口时照顾家属车辆，不甩车。&lt;/p&gt;\r\n&lt;p&gt;\r\n	　　3、引导服务员（接尸工）：接运遗体轻抬轻放；尊重亡者，脱穿衣文明；主动服务，满足要求；排忧解难，耐心周到。&lt;/p&gt;\r\n&lt;p&gt;\r\n	　　4、整容工：一般整容化妆着色均匀、自然、神态安祥、衣着整齐。特殊整容力求恢复原貌达到亡者家属满意。&lt;/p&gt;\r\n', '广州市平谷区西峪水库东岸', '113.269251', '23.201809');
INSERT INTO `ey_images18_content` VALUES ('4', '21', '1637133079', '1637133079', 'a:3:{i:0;a:2:{s:9:\"image_url\";s:40:\"/uploads/allimg/200603/1-2006031T021.jpg\";s:5:\"intro\";s:0:\"\";}i:1;a:2:{s:9:\"image_url\";s:40:\"/uploads/allimg/200603/1-2006031T024.jpg\";s:5:\"intro\";s:0:\"\";}i:2;a:2:{s:9:\"image_url\";s:40:\"/uploads/allimg/200603/1-2006031T027.jpg\";s:5:\"intro\";s:0:\"\";}}', '&lt;p&gt;\r\n	北京市八宝山殡仪馆是全市规模最大、设施齐全的殡仪服务单位，承担着本市城近郊区市民、已故党和国家领导人、海外侨胞、国际友人的殡仪服务业务。每年承办告别活动6000余场，接待来宾近百万人次，年火化量2万多具。本馆坚持&amp;ldquo;服务第一，丧家至上&amp;rdquo;的宗旨，不断推行科学管理，提高服务质量，受到社会好评，连续多次被评为&amp;ldquo;首都精神文明单位&amp;rdquo;、&amp;ldquo;全国殡葬改革先进单位&amp;rdquo;、&amp;ldquo;北京市花园市单位&amp;rdquo;，2004年被国家民政部评为全国民政基层行风建设先进集体。&lt;/p&gt;\r\n&lt;p&gt;\r\n	　　八宝山殡仪馆始建于1958年，是北京历史上较早的殡仪馆之一。多年来，几经大规模建设改造，已经形成一整套独特的建设风格和服务体系，&amp;ldquo;八宝山&amp;rdquo;因此而成为中国殡葬业的代名词。&lt;/p&gt;\r\n&lt;p&gt;\r\n	　　服务标准：殡仪服务人员要统一着装，仪表端庄，语言文明，挂牌服务；各岗位职责明确，规范服务；遵守职业道德，拒收馈赠，杜绝索取财物。执行国家物价部门规定的收费标准。&lt;/p&gt;\r\n&lt;p&gt;\r\n	　　1、&amp;ldquo;一条龙&amp;rdquo;车辆调度室服务员：使用文明用语，服务态度热情，耐心解答询问，准确叮嘱家属等车时间、地点、注意事项。&lt;/p&gt;\r\n&lt;p&gt;\r\n	　　2、灵车司机：服从调度室安排，准时到达接运遗体地点；文明驾驶，保证车辆平稳不颠簸，转弯和过路口时照顾家属车辆，不甩车。&lt;/p&gt;\r\n&lt;p&gt;\r\n	　　3、引导服务员（接尸工）：接运遗体轻抬轻放；尊重亡者，脱穿衣文明；主动服务，满足要求；排忧解难，耐心周到。&lt;/p&gt;\r\n&lt;p&gt;\r\n	　　4、整容工：一般整容化妆着色均匀、自然、神态安祥、衣着整齐。特殊整容力求恢复原貌达到亡者家属满意。&lt;/p&gt;\r\n&lt;p&gt;\r\n	　　5、告别室服务员：尊重家属要求，协助布置会场；提供必要服务。&lt;/p&gt;\r\n&lt;p&gt;\r\n	　　6、火化工：遵守操作规程，保证骨灰质量。&lt;/p&gt;\r\n&lt;p&gt;\r\n	　　7、售盒服务员：服务态度和蔼，熟悉商品特点，主动介绍商品，满足不同层次的需要。&lt;/p&gt;\r\n&lt;p&gt;\r\n	　　8、刻字工：按要求逐字刻印，字迹清楚，准确无误。&lt;/p&gt;\r\n&lt;p&gt;\r\n	　　9、收银员：认真审核收费项目，填写标据字迹清楚，收款时唱收唱付。&lt;/p&gt;\r\n', '广州市平谷区西峪水库东岸', '113.269251', '23.201809');

-- -----------------------------
-- Table structure for `ey_images2_content`
-- -----------------------------
DROP TABLE IF EXISTS `ey_images2_content`;
CREATE TABLE `ey_images2_content` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `aid` int(10) DEFAULT '0' COMMENT '文档ID',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  `image_list` text COMMENT '相册|10001',
  `content` longtext COMMENT '内容详情',
  PRIMARY KEY (`id`),
  KEY `aid` (`aid`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COMMENT='附加表';

-- -----------------------------
-- Records of `ey_images2_content`
-- -----------------------------
INSERT INTO `ey_images2_content` VALUES ('1', '10', '1641812233', '1641812233', 'a:7:{i:0;a:2:{s:9:\"image_url\";s:44:\"/uploads/allimg/20220109/1-22010920020EJ.jpg\";s:5:\"intro\";s:0:\"\";}i:1;a:2:{s:9:\"image_url\";s:45:\"/uploads/allimg/20220109/1-22010920020C59.jpg\";s:5:\"intro\";s:0:\"\";}i:2;a:2:{s:9:\"image_url\";s:45:\"/uploads/allimg/20220109/1-22010920020C33.jpg\";s:5:\"intro\";s:0:\"\";}i:3;a:2:{s:9:\"image_url\";s:46:\"/uploads/allimg/20220109/1-220109200206406.jpg\";s:5:\"intro\";s:0:\"\";}i:4;a:2:{s:9:\"image_url\";s:44:\"/uploads/allimg/20220109/1-22010920020EO.jpg\";s:5:\"intro\";s:0:\"\";}i:5;a:2:{s:9:\"image_url\";s:46:\"/uploads/allimg/20220109/1-220109200206240.jpg\";s:5:\"intro\";s:0:\"\";}i:6;a:2:{s:9:\"image_url\";s:44:\"/uploads/allimg/20220109/1-2201091TU0446.jpg\";s:5:\"intro\";s:0:\"\";}}', '&lt;p&gt;这是一个测试的相册，和图集差不多哦这是一个测试的相册，和图集差不多哦这是一个测试的相册，和图集差不多哦这是一个测试的相册，和图集差不多哦这是一个测试的相册，和图集差不多哦这是一个测试的相册，和图集差不多哦&lt;/p&gt;');

-- -----------------------------
-- Table structure for `ey_images_content`
-- -----------------------------
DROP TABLE IF EXISTS `ey_images_content`;
CREATE TABLE `ey_images_content` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `aid` int(10) DEFAULT '0' COMMENT '文档ID',
  `content` longtext COMMENT '内容详情',
  `content_ey_m` longtext COMMENT '手机端内容详情',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`),
  KEY `news_id` (`aid`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='资讯内容表_存储正常内容';


-- -----------------------------
-- Table structure for `ey_images_upload`
-- -----------------------------
DROP TABLE IF EXISTS `ey_images_upload`;
CREATE TABLE `ey_images_upload` (
  `img_id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `aid` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT '图集ID',
  `title` varchar(200) DEFAULT '' COMMENT '产品标题',
  `image_url` varchar(255) DEFAULT '' COMMENT '文件存储路径',
  `intro` varchar(2000) DEFAULT '' COMMENT '图集描述',
  `width` int(11) DEFAULT '0' COMMENT '图片宽度',
  `height` int(11) DEFAULT '0' COMMENT '图片高度',
  `filesize` mediumint(8) unsigned DEFAULT '0' COMMENT '文件大小',
  `mime` varchar(50) DEFAULT '' COMMENT '图片类型',
  `sort_order` smallint(5) DEFAULT '0' COMMENT '排序',
  `add_time` int(10) unsigned DEFAULT '0' COMMENT '上传时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`img_id`),
  KEY `arcid` (`aid`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


-- -----------------------------
-- Table structure for `ey_job_company`
-- -----------------------------
DROP TABLE IF EXISTS `ey_job_company`;
CREATE TABLE `ey_job_company` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `aid` int(11) NOT NULL DEFAULT '0',
  `companyname` varchar(255) DEFAULT NULL,
  `experienceJobname` varchar(255) DEFAULT NULL,
  `jobrespons` varchar(255) DEFAULT NULL,
  `jobtime` varchar(50) DEFAULT '0',
  `lang` varchar(50) NOT NULL DEFAULT 'cn',
  `add_time` int(11) NOT NULL DEFAULT '0',
  `update_time` int(11) NOT NULL DEFAULT '0',
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=26 DEFAULT CHARSET=utf8;

-- -----------------------------
-- Records of `ey_job_company`
-- -----------------------------
INSERT INTO `ey_job_company` VALUES ('13', '150', '宝胜电缆集团', '大闸蟹', '淡淡的', '2021-08-08 ~ 2021-09-08', 'cn', '1628433468', '1628433468');
INSERT INTO `ey_job_company` VALUES ('14', '150', '大闸蟹的', '爱爱爱', '反反复复', '2021-08-08 ~ 2021-09-08', 'cn', '1628433468', '1628433468');
INSERT INTO `ey_job_company` VALUES ('15', '154', '宝应袖长起初', '羞里公', '维修汽车', '2021-08-11 ~ 2021-09-11', 'cn', '1628634043', '1629693993');
INSERT INTO `ey_job_company` VALUES ('16', '154', '水产批发商行', '大闸蟹', '淡淡的销售', '2021-08-11 ~ 2021-09-11', 'cn', '1628634043', '1629693993');
INSERT INTO `ey_job_company` VALUES ('17', '181', '宝应县洪宝水产品经营部', '调蟹工', '负责大闸蟹规格大小', '2019-08-02 ~ 2021-10-02', 'cn', '1630596359', '1630596563');
INSERT INTO `ey_job_company` VALUES ('18', '181', '海南赞赞网络科技有限公司', '编程师', 'PHP代码编写', '2020-09-16 ~ 2021-10-02', 'cn', '1630596359', '1630596563');
INSERT INTO `ey_job_company` VALUES ('19', '183', '北京亿联智慧科技有限公司', '权证专员', '金融/投资/证券', '2018-09-02 ~ 2021-10-02', 'cn', '1630597320', '1631257029');
INSERT INTO `ey_job_company` VALUES ('20', '184', '北京众志伟业房地产经济有限公司', '房地产开发', '销售主任', '2018-09-19 ~ 2020-10-02', 'cn', '1630598253', '1630598253');
INSERT INTO `ey_job_company` VALUES ('21', '185', '吕梁市离石区邦德达商贸有限公司', '店铺运营', '互联网/电子商务', '2021-09-02 ~ 2021-10-02', 'cn', '1630598487', '1631257755');
INSERT INTO `ey_job_company` VALUES ('22', '185', '吕梁市离石区志凌便利店', '店长', '快速消费品(食品/饮料/化妆品)', '2021-09-03 ~ 2021-10-03', 'cn', '1630598487', '1631257755');
INSERT INTO `ey_job_company` VALUES ('23', '185', '太原市金点教育', '教务主管', '教育/培训/院校', '2017-09-21 ~ 2019-10-03', 'cn', '1630598487', '1631257755');
INSERT INTO `ey_job_company` VALUES ('24', '185', '山西省社会科学院', '办公室助理', '教育/培训/院校', '2021-06-03 ~ 2021-09-03', 'cn', '1630598487', '1631257755');
INSERT INTO `ey_job_company` VALUES ('25', '185', '青岛啤酒华北营销分公司', '渠道经理', '快速消费品(食品/饮料/化妆品)', '2021-09-03 ~ 2021-10-03', 'cn', '1630598487', '1631257755');

-- -----------------------------
-- Table structure for `ey_job_content`
-- -----------------------------
DROP TABLE IF EXISTS `ey_job_content`;
CREATE TABLE `ey_job_content` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `aid` int(10) DEFAULT '0' COMMENT '文档ID',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  `neirong` longtext COMMENT '内容详情',
  `gzjy` enum('经验不限','1年以下','1-3年','3-5年','5-10年','10年以上') DEFAULT '经验不限' COMMENT '工作经验',
  `xbsx` enum('男','女') DEFAULT '男' COMMENT '性别筛选',
  `xlyq` enum('小学','初中','高中','中技','中专','大专','本科','硕士','博士','博后') DEFAULT '小学' COMMENT '最高学历',
  `birthday` varchar(200) NOT NULL DEFAULT '' COMMENT '出生年份',
  `mobile` varchar(200) NOT NULL DEFAULT '' COMMENT '手机',
  `current` enum('我目前已离职、可快速到岗','我目前在职、但考虑换个新环境','观望有好的机会再考虑','目前暂无跳槽打算','应届毕业生') DEFAULT '我目前已离职、可快速到岗' COMMENT '目前状态',
  `wage` enum('1000~1500/月','1500~2000/月','2000~3000/月','3000~5000/月','5000~10000/月','10000以上/月','面议') DEFAULT '1000~1500/月' COMMENT '期望薪资',
  `nature` enum('全职','兼职','实习') DEFAULT '全职' COMMENT '工作性质',
  `specialty` text COMMENT '自我描述',
  `speciality` set('形象好','气质佳','能出差','很幽默','技术精悍','有亲和力','高学历','经验丰富','能加班','海归','会开车','口才好','声音甜美','会应酬','诚实守信','外语好','性格开朗','有上进心','人脉广','知识丰富','才艺多') DEFAULT '' COMMENT '特长标签',
  `birthdy` int(10) NOT NULL DEFAULT '0' COMMENT '年龄',
  `qwgw` varchar(200) NOT NULL DEFAULT '' COMMENT '期望岗位',
  PRIMARY KEY (`id`),
  KEY `aid` (`aid`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=39 DEFAULT CHARSET=utf8 COMMENT='附加表';

-- -----------------------------
-- Records of `ey_job_content`
-- -----------------------------
INSERT INTO `ey_job_content` VALUES ('1', '110', '1628190635', '1628190635', '', '经验不限', '男', '小学', '1628186311', '0', '我目前已离职、可快速到岗', '2000~3000/月', '全职', '', '', '0', '');
INSERT INTO `ey_job_content` VALUES ('2', '112', '1628190684', '1628190684', '&lt;p&gt;淡淡的&lt;/p&gt;', '经验不限', '男', '小学', '1628190665', '0', '我目前已离职、可快速到岗', '1000~1500/月', '全职', '', '有亲和力', '0', '');
INSERT INTO `ey_job_content` VALUES ('3', '113', '1628199373', '1628199373', '', '经验不限', '男', '小学', '1628199373', '0', '我目前已离职、可快速到岗', '1000~1500/月', '全职', '', '', '0', '');
INSERT INTO `ey_job_content` VALUES ('4', '114', '1628199401', '1628199401', '', '经验不限', '男', '小学', '1628199401', '0', '我目前已离职、可快速到岗', '1000~1500/月', '全职', '', '', '0', '');
INSERT INTO `ey_job_content` VALUES ('5', '115', '1628199445', '1628199445', '', '经验不限', '男', '小学', '1628199445', '0', '我目前已离职、可快速到岗', '1000~1500/月', '全职', '', '', '0', '');
INSERT INTO `ey_job_content` VALUES ('6', '116', '1628199542', '1628199542', '', '经验不限', '男', '小学', '1628199542', '0', '我目前已离职、可快速到岗', '1000~1500/月', '全职', '', '', '0', '');
INSERT INTO `ey_job_content` VALUES ('7', '117', '1628199585', '1628199585', '', '经验不限', '男', '小学', '1628199585', '0', '我目前已离职、可快速到岗', '1000~1500/月', '全职', '', '', '0', '');
INSERT INTO `ey_job_content` VALUES ('8', '118', '1628199673', '1628199673', '', '经验不限', '男', '小学', '1628199673', '0', '我目前已离职、可快速到岗', '1000~1500/月', '全职', '', '', '0', '');
INSERT INTO `ey_job_content` VALUES ('9', '119', '1628200256', '1628200256', '', '经验不限', '男', '小学', '1628200256', '0', '我目前已离职、可快速到岗', '1000~1500/月', '全职', '', '', '0', '');
INSERT INTO `ey_job_content` VALUES ('10', '120', '1628200385', '1628200385', '', '经验不限', '男', '小学', '1628200385', '0', '我目前已离职、可快速到岗', '1000~1500/月', '全职', '', '', '0', '');
INSERT INTO `ey_job_content` VALUES ('11', '122', '1628200547', '1628200547', '', '经验不限', '男', '小学', '1628200547', '0', '我目前已离职、可快速到岗', '1000~1500/月', '全职', '', '', '0', '');
INSERT INTO `ey_job_content` VALUES ('12', '123', '1628200623', '1628200623', '', '经验不限', '男', '小学', '1628200623', '0', '我目前已离职、可快速到岗', '1000~1500/月', '全职', '', '', '0', '');
INSERT INTO `ey_job_content` VALUES ('13', '124', '1628200659', '1628200659', '', '经验不限', '男', '小学', '1628200659', '0', '我目前已离职、可快速到岗', '1000~1500/月', '全职', '', '', '0', '');
INSERT INTO `ey_job_content` VALUES ('14', '125', '1628200677', '1628200677', '', '经验不限', '男', '小学', '1628200677', '0', '我目前已离职、可快速到岗', '1000~1500/月', '全职', '', '', '0', '');
INSERT INTO `ey_job_content` VALUES ('15', '126', '1628204570', '1628204570', '', '经验不限', '男', '小学', '1628204570', '0', '我目前已离职、可快速到岗', '1000~1500/月', '全职', '', '', '0', '');
INSERT INTO `ey_job_content` VALUES ('16', '127', '1628204608', '1628204608', '', '经验不限', '男', '小学', '1628204608', '0', '我目前已离职、可快速到岗', '1000~1500/月', '全职', '', '', '0', '');
INSERT INTO `ey_job_content` VALUES ('17', '128', '1628204632', '1628204632', '', '经验不限', '男', '小学', '1628204632', '0', '我目前已离职、可快速到岗', '1000~1500/月', '全职', '', '', '0', '');
INSERT INTO `ey_job_content` VALUES ('18', '129', '1628205486', '1628205486', '', '经验不限', '男', '小学', '1628205486', '0', '我目前已离职、可快速到岗', '1000~1500/月', '全职', '', '', '0', '');
INSERT INTO `ey_job_content` VALUES ('19', '132', '1628208413', '1628208413', '', '1-3年', '女', '中专', '2021-08-06', '15366919619', '我目前在职、但考虑换个新环境', '1500~2000/月', '实习', '22222222', '能出差,有亲和力,高学历', '0', '');
INSERT INTO `ey_job_content` VALUES ('20', '133', '1628208636', '1628208636', '', '经验不限', '男', '小学', '', '', '我目前已离职、可快速到岗', '1000~1500/月', '全职', '淡淡的', '', '0', '');
INSERT INTO `ey_job_content` VALUES ('21', '134', '1628208681', '1628208681', '', '经验不限', '男', '小学', '', '', '我目前已离职、可快速到岗', '1000~1500/月', '全职', '去去去', '', '0', '');
INSERT INTO `ey_job_content` VALUES ('22', '135', '1628289597', '1628289597', '', '经验不限', '男', '小学', '', '', '我目前已离职、可快速到岗', '1000~1500/月', '全职', '', '', '0', '');
INSERT INTO `ey_job_content` VALUES ('23', '143', '1628372455', '1628372455', '', '经验不限', '男', '小学', '', '', '我目前已离职、可快速到岗', '1000~1500/月', '全职', '', '', '0', '');
INSERT INTO `ey_job_content` VALUES ('24', '144', '1628374209', '1628374209', '', '经验不限', '男', '小学', '', '', '我目前已离职、可快速到岗', '1000~1500/月', '全职', '', '', '0', '');
INSERT INTO `ey_job_content` VALUES ('25', '145', '1628374266', '1628374266', '', '经验不限', '男', '小学', '', '', '我目前已离职、可快速到岗', '1000~1500/月', '全职', '', '', '0', '');
INSERT INTO `ey_job_content` VALUES ('26', '146', '1628381743', '1628381743', '', '1-3年', '男', '高中', '', '', '我目前已离职、可快速到岗', '1000~1500/月', '全职', '', '会应酬,诚实守信,外语好,性格开朗,有上进心', '0', '');
INSERT INTO `ey_job_content` VALUES ('27', '147', '1628382156', '1628382156', '', '经验不限', '男', '小学', '', '', '我目前已离职、可快速到岗', '1000~1500/月', '全职', '', '', '0', '');
INSERT INTO `ey_job_content` VALUES ('28', '149', '1628383556', '1628383556', '', '经验不限', '男', '小学', '', '', '我目前已离职、可快速到岗', '1000~1500/月', '全职', '', '', '0', '');
INSERT INTO `ey_job_content` VALUES ('29', '150', '1628433468', '1628433468', '', '1年以下', '男', '大专', '2021-08-08', '15366919619', '我目前已离职、可快速到岗', '3000~5000/月', '全职', '我是一个很开心的', '形象好,气质佳,会开车,口才好,声音甜美', '0', '');
INSERT INTO `ey_job_content` VALUES ('30', '154', '1629693993', '1629693993', '', '1年以下', '男', '小学', '2021-08-09', '15366919619', '我目前已离职、可快速到岗', '2000~3000/月', '全职', '淡淡的淡淡的多\r\n顶顶顶顶顶\r\n的的\r\n的的', '很幽默,技术精悍,有亲和力', '20', '');
INSERT INTO `ey_job_content` VALUES ('31', '158', '1628841294', '1628841294', '', '经验不限', '男', '小学', '2021-08-13', '15366919619', '我目前已离职、可快速到岗', '1000~1500/月', '兼职', '大家好啊', '能出差,很幽默,声音甜美', '20', '销售');
INSERT INTO `ey_job_content` VALUES ('32', '159', '1628841473', '1628841473', '', '经验不限', '男', '小学', '', '', '我目前已离职、可快速到岗', '1000~1500/月', '全职', '', '', '0', '');
INSERT INTO `ey_job_content` VALUES ('33', '161', '1629694582', '1629694582', '', '经验不限', '男', '小学', '', '', '我目前已离职、可快速到岗', '1000~1500/月', '全职', '', '', '0', '');
INSERT INTO `ey_job_content` VALUES ('34', '181', '1630596563', '1630596563', '', '3-5年', '男', '大专', '2021-09-02', '15366919619', '我目前已离职、可快速到岗', '10000以上/月', '全职', '一个开朗活泼的男孩！', '技术精悍,有亲和力,经验丰富,能加班,会开车', '33', '销售类职位');
INSERT INTO `ey_job_content` VALUES ('35', '182', '1630596808', '1630596808', '', '1-3年', '女', '本科', '2021-09-02', '15366919619', '我目前在职、但考虑换个新环境', '1000~1500/月', '全职', '目前正在找工作', '形象好,气质佳,很幽默,知识丰富,才艺多', '22', '软件测试');
INSERT INTO `ey_job_content` VALUES ('36', '183', '1631257029', '1631257029', '', '1-3年', '男', '小学', '2021-09-02', '0898-66963973', '目前暂无跳槽打算', '1000~1500/月', '全职', '目前正在找工作', '很幽默,有亲和力,会开车,口才好', '36', '金融/投资/证券');
INSERT INTO `ey_job_content` VALUES ('37', '184', '1630598253', '1630598253', '', '5-10年', '男', '大专', '2021-09-02', '0898-66963973', '观望有好的机会再考虑', '5000~10000/月', '全职', '大家好！', '经验丰富,能加班,海归', '28', '销售管理,销售人员');
INSERT INTO `ey_job_content` VALUES ('38', '185', '1631257755', '1631257755', '', '1-3年', '男', '大专', '2021-09-02', '0898-88888888', '我目前已离职、可快速到岗', '2000~3000/月', '全职', '期望地区：东城区,济南市,石家庄市,西安市,太原市\r\n期望行业：互联网/电子商务电子技术/半导体/集成电路批发/零售快速消费品(食品/饮料/化妆品)电力/电气/水利', '形象好,气质佳,能出差,技术精悍', '36', '销售经理渠道/分销经理区域销售经理销售代表渠道/分销专员');

-- -----------------------------
-- Table structure for `ey_job_school`
-- -----------------------------
DROP TABLE IF EXISTS `ey_job_school`;
CREATE TABLE `ey_job_school` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `aid` int(11) NOT NULL DEFAULT '0',
  `school` varchar(255) DEFAULT NULL,
  `speciality` varchar(255) DEFAULT NULL,
  `education` text,
  `schooltime` varchar(255) DEFAULT NULL,
  `lang` varchar(50) NOT NULL DEFAULT 'cn',
  `add_time` int(11) NOT NULL DEFAULT '0',
  `update_time` int(11) NOT NULL DEFAULT '0',
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8;

-- -----------------------------
-- Records of `ey_job_school`
-- -----------------------------
INSERT INTO `ey_job_school` VALUES ('2', '132', '2', '2', '初中', '2', 'cn', '1628206027', '1628206027');
INSERT INTO `ey_job_school` VALUES ('3', '132', '22', '22', '初中', '2', 'cn', '1628207961', '1628207961');
INSERT INTO `ey_job_school` VALUES ('4', '133', '3', '3', '初中', '2', 'cn', '1628208439', '1628208439');
INSERT INTO `ey_job_school` VALUES ('5', '135', '淡淡的', '淡淡的', '小学', '2021-08-06 ~ 2021-09-06', 'cn', '1628210068', '1628289597');
INSERT INTO `ey_job_school` VALUES ('8', '150', '江阴职业技术学院', '室内设计', '大专', '2021-08-08 ~ 2021-09-08', 'cn', '1628433468', '1628433468');
INSERT INTO `ey_job_school` VALUES ('9', '154', '宝应大学', '设计专业', '大专', '2021-08-11 ~ 2021-09-11', 'cn', '1628634043', '1629693993');
INSERT INTO `ey_job_school` VALUES ('10', '154', '扬州大学', '装卸设计', '本科', '2021-08-11 ~ 2021-09-11', 'cn', '1628634043', '1629693993');
INSERT INTO `ey_job_school` VALUES ('11', '181', '江阴市职业技术学院', '室内专业设计', '大专', '2016-09-02 ~ 2019-10-02', 'cn', '1630596359', '1630596563');
INSERT INTO `ey_job_school` VALUES ('12', '182', '齐鲁工业大学', '计算机科学与技术专业', '本科', '2016-09-02 ~ 2021-10-02', 'cn', '1630596808', '1630596808');
INSERT INTO `ey_job_school` VALUES ('13', '183', '北京电子科技职业学院', '工商管理', '大专', '2018-09-02 ~ 2021-10-02', 'cn', '1630597320', '1631257029');
INSERT INTO `ey_job_school` VALUES ('14', '184', '河北工业职业技术大学', '金融管理', '大专', '2017-09-02 ~ 2019-10-02', 'cn', '1630598253', '1630598253');
INSERT INTO `ey_job_school` VALUES ('15', '185', '吕梁高等专科学校', '化学教育', '大专', '2021-09-02 ~ 2021-10-02', 'cn', '1630598487', '1631257756');

-- -----------------------------
-- Table structure for `ey_jobhuntertop_log`
-- -----------------------------
DROP TABLE IF EXISTS `ey_jobhuntertop_log`;
CREATE TABLE `ey_jobhuntertop_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `users_id` int(11) NOT NULL DEFAULT '0',
  `days` int(11) NOT NULL DEFAULT '0',
  `users_name` varchar(255) DEFAULT NULL,
  `company_name` varchar(255) DEFAULT NULL,
  `aid` int(10) NOT NULL DEFAULT '0',
  `arc_tile` varchar(255) DEFAULT NULL,
  `price` decimal(10,2) NOT NULL DEFAULT '0.00',
  `type_id` int(11) NOT NULL DEFAULT '0',
  `type_title` varchar(255) DEFAULT NULL,
  `add_time` int(10) NOT NULL DEFAULT '0',
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


-- -----------------------------
-- Table structure for `ey_jobrefresh_log`
-- -----------------------------
DROP TABLE IF EXISTS `ey_jobrefresh_log`;
CREATE TABLE `ey_jobrefresh_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `users_id` int(11) NOT NULL DEFAULT '0',
  `users_name` varchar(255) DEFAULT NULL,
  `company_name` varchar(255) DEFAULT NULL,
  `aid` int(10) NOT NULL DEFAULT '0',
  `arc_tile` varchar(255) DEFAULT NULL,
  `price` decimal(10,2) NOT NULL DEFAULT '0.00',
  `add_time` int(10) NOT NULL DEFAULT '0',
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


-- -----------------------------
-- Table structure for `ey_jobtop`
-- -----------------------------
DROP TABLE IF EXISTS `ey_jobtop`;
CREATE TABLE `ey_jobtop` (
  `type_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `type_name` varchar(255) DEFAULT NULL COMMENT '类型名称',
  `level_id` int(10) DEFAULT '0' COMMENT '会员等级ID',
  `price` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '价格',
  `limit_id` int(10) DEFAULT '0',
  `days` int(10) DEFAULT '0',
  `sort_order` smallint(5) NOT NULL DEFAULT '0' COMMENT '排序',
  `lang` varchar(20) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`type_id`)
) ENGINE=MyISAM AUTO_INCREMENT=10 DEFAULT CHARSET=utf8 COMMENT='会员产品类型表';

-- -----------------------------
-- Records of `ey_jobtop`
-- -----------------------------
INSERT INTO `ey_jobtop` VALUES ('1', '置顶7天', '1', '10.00', '1', '7', '100', 'cn', '1628513598', '1628711099');
INSERT INTO `ey_jobtop` VALUES ('2', '置顶7天', '3', '5.00', '1', '7', '100', 'cn', '1628513780', '1628711099');
INSERT INTO `ey_jobtop` VALUES ('6', '置顶7天', '2', '2.00', '1', '7', '100', 'cn', '1628516919', '1628711099');
INSERT INTO `ey_jobtop` VALUES ('7', '置顶15天', '1', '20.00', '2', '15', '100', 'cn', '1628528694', '1628711099');
INSERT INTO `ey_jobtop` VALUES ('8', '置顶15天', '2', '10.00', '2', '15', '100', 'cn', '1628528694', '1628711099');
INSERT INTO `ey_jobtop` VALUES ('9', '置顶15天', '3', '4.00', '2', '15', '100', 'cn', '1628528694', '1628711099');

-- -----------------------------
-- Table structure for `ey_jobtop_log`
-- -----------------------------
DROP TABLE IF EXISTS `ey_jobtop_log`;
CREATE TABLE `ey_jobtop_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `users_id` int(11) NOT NULL DEFAULT '0',
  `days` int(11) NOT NULL DEFAULT '0',
  `users_name` varchar(255) DEFAULT NULL,
  `company_name` varchar(255) DEFAULT NULL,
  `aid` int(10) NOT NULL DEFAULT '0',
  `arc_tile` varchar(255) DEFAULT NULL,
  `price` decimal(10,2) NOT NULL DEFAULT '0.00',
  `type_id` int(11) NOT NULL DEFAULT '0',
  `type_title` varchar(255) DEFAULT NULL,
  `add_time` int(10) NOT NULL DEFAULT '0',
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


-- -----------------------------
-- Table structure for `ey_language`
-- -----------------------------
DROP TABLE IF EXISTS `ey_language`;
CREATE TABLE `ey_language` (
  `id` int(10) NOT NULL AUTO_INCREMENT COMMENT '信息ID，自增',
  `title` varchar(100) NOT NULL DEFAULT '' COMMENT '语言名称',
  `mark` varchar(50) NOT NULL DEFAULT '' COMMENT '语言标识（唯一）',
  `url` varchar(200) NOT NULL DEFAULT '' COMMENT '单独域名(外部链接)',
  `target` tinyint(1) NOT NULL DEFAULT '0' COMMENT '新窗口打开，0=否，1=是',
  `is_home_default` tinyint(1) DEFAULT '0' COMMENT '默认前台语言，1=是，0=否',
  `is_admin_default` tinyint(1) DEFAULT '0' COMMENT '默认后台语言，1=是，0=否',
  `syn_pack_id` int(10) DEFAULT '0' COMMENT '最后一次同步官方语言包ID',
  `status` tinyint(1) NOT NULL DEFAULT '0' COMMENT '语言状态，0=关闭，1=开启',
  `sort_order` int(10) DEFAULT '0' COMMENT '排序号',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COMMENT='多语言主表';

-- -----------------------------
-- Records of `ey_language`
-- -----------------------------
INSERT INTO `ey_language` VALUES ('1', '简体中文', 'cn', '', '0', '1', '1', '24', '1', '100', '1541583096', '1543890743');

-- -----------------------------
-- Table structure for `ey_language_attr`
-- -----------------------------
DROP TABLE IF EXISTS `ey_language_attr`;
CREATE TABLE `ey_language_attr` (
  `id` int(10) NOT NULL AUTO_INCREMENT COMMENT '信息ID，自增',
  `attr_name` varchar(200) NOT NULL DEFAULT '' COMMENT '来自ey_weapp_language_attr表的attr_name',
  `attr_value` text NOT NULL COMMENT '变量值',
  `attr_group` varchar(50) DEFAULT '' COMMENT '分组，以表名划分（不含表前缀）',
  `lang` varchar(50) NOT NULL DEFAULT '' COMMENT '所属语言',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`),
  KEY `attr_value` (`attr_name`,`lang`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='多语言模板变量关联绑定表';


-- -----------------------------
-- Table structure for `ey_language_attribute`
-- -----------------------------
DROP TABLE IF EXISTS `ey_language_attribute`;
CREATE TABLE `ey_language_attribute` (
  `attr_id` int(10) NOT NULL AUTO_INCREMENT COMMENT '信息ID，自增',
  `attr_title` varchar(200) NOT NULL DEFAULT '' COMMENT '变量标题',
  `attr_name` varchar(200) NOT NULL DEFAULT '' COMMENT '变量名称',
  `attr_group` varchar(50) DEFAULT '' COMMENT '分组，以表名划分（不含表前缀）',
  `is_del` tinyint(1) DEFAULT '0' COMMENT '伪删除，0=否，1=是',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`attr_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='多语言模板变量表';


-- -----------------------------
-- Table structure for `ey_language_mark`
-- -----------------------------
DROP TABLE IF EXISTS `ey_language_mark`;
CREATE TABLE `ey_language_mark` (
  `id` int(10) NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `title` varchar(50) NOT NULL DEFAULT '' COMMENT '国家语言名称',
  `cn_title` varchar(50) NOT NULL DEFAULT '' COMMENT '中文名称',
  `mark` varchar(50) DEFAULT '' COMMENT '多语言标识',
  `pinyin` varchar(100) DEFAULT '' COMMENT '拼音',
  `sort_order` int(10) NOT NULL DEFAULT '0' COMMENT '排序号',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=58 DEFAULT CHARSET=utf8 COMMENT='国家语言表';

-- -----------------------------
-- Records of `ey_language_mark`
-- -----------------------------
INSERT INTO `ey_language_mark` VALUES ('1', '简体中文', '简体中文', 'cn', 'zhongwenjianti', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('2', 'Vietnamese', '越南语', 'vi', 'yuenanyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('3', '繁体中文', '繁体中文', 'zh', 'zhongwenfanti', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('4', 'English', '英语', 'en', 'yingyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('5', 'Indonesian', '印尼语', 'id', 'yinniyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('6', 'Urdu', '乌尔都语', 'ur', 'wuerduyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('7', 'Yiddish', '意第绪语', 'yi', 'yidixuyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('8', 'Italian', '意大利语', 'it', 'yidaliyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('9', 'Greek', '希腊语', 'el', 'xilayu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('10', 'Spanish Basque', '西班牙的巴斯克语', 'eu', 'xibanyadebasikeyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('11', 'Spanish', '西班牙语', 'es', 'xibanyayu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('12', 'Hungarian', '匈牙利语', 'hu', 'xiongyaliyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('13', 'Hebrew', '希伯来语', 'iw', 'xibolaiyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('14', 'Ukrainian', '乌克兰语', 'uk', 'wukelanyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('15', 'Welsh', '威尔士语', 'cy', 'weiershiyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('16', 'Thai', '泰语', 'th', 'taiyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('17', 'Turkish', '土耳其语', 'tr', 'tuerqiyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('18', 'Swahili', '斯瓦希里语', 'sw', 'siwaxiliyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('19', 'Japanese', '日语', 'ja', 'riyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('20', 'Swedish', '瑞典语', 'sv', 'ruidianyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('21', 'Serbian', '塞尔维亚语', 'sr', 'saierweiyayu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('22', 'Slovak', '斯洛伐克语', 'sk', 'siluofakeyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('23', 'Slovenian', '斯洛文尼亚语', 'sl', 'siluowenniyayu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('24', 'Portuguese', '葡萄牙语', 'pt', 'putaoyayu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('25', 'Norwegian', '挪威语', 'no', 'nuoweiyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('26', 'Macedonian', '马其顿语', 'mk', 'maqidunyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('27', 'Malay', '马来语', 'ms', 'malaiyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('28', 'Maltese', '马耳他语', 'mt', 'maertayu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('29', 'Romanian', '罗马尼亚语', 'ro', 'luomaniyayu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('30', 'Lithuanian', '立陶宛语', 'lt', 'litaowanyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('31', 'Latvian', '拉脱维亚语', 'lv', 'latuoweiyayu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('32', 'Latin', '拉丁语', 'la', 'ladingyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('33', 'Croatian', '克罗地亚语', 'hr', 'keluodiyayu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('34', 'Czech', '捷克语', 'cs', 'jiekeyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('35', 'Catalan', '加泰罗尼亚语', 'ca', 'jiatailuoniyayu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('36', 'Galician', '加利西亚语', 'gl', 'jialixiyayu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('37', 'Dutch', '荷兰语', 'nl', 'helanyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('38', 'Korean', '韩语', 'ko', 'hanyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('39', 'Haitian Creole', '海地克里奥尔语', 'ht', 'haidikeliaoeryu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('40', 'Finnish', '芬兰语', 'fi', 'fenlanyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('41', 'Filipino', '菲律宾语', 'tl', 'feilvbinyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('42', 'Russian', '俄语', 'ru', 'eyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('43', 'Boolean (Afrikaans)', '布尔语(南非荷兰语)', 'af', 'bueryunanfeihelanyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('44', 'French', '法语', 'fr', 'fayu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('45', 'Danish', '丹麦语', 'da', 'danmaiyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('46', 'German', '德语', 'de', 'deyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('47', 'Azerbaijani', '阿塞拜疆语', 'az', 'asaibaijiangyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('48', 'Irish', '爱尔兰语', 'ga', 'aierlanyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('49', 'Estonian', '爱沙尼亚语', 'et', 'aishaniyayu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('50', 'Belarusian', '白俄罗斯语', 'be', 'baieluosiyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('51', 'Bulgarian', '保加利亚语', 'bg', 'baojialiyayu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('52', 'Icelandic', '冰岛语', 'is', 'bingdaoyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('53', 'Polish', '波兰语', 'pl', 'bolanyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('54', 'Persian', '波斯语', 'fa', 'bosiyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('55', 'Arabic', '阿拉伯语', 'ar', 'alaboyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('56', 'Albanian', '阿尔巴尼亚语', 'sq', 'aerbaniyayu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('57', 'Uyghur', '维吾尔族语', 'ug', 'weiwuerzuyu', '100', '0', '1541583096');

-- -----------------------------
-- Table structure for `ey_language_pack`
-- -----------------------------
DROP TABLE IF EXISTS `ey_language_pack`;
CREATE TABLE `ey_language_pack` (
  `id` int(10) NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `name` varchar(50) NOT NULL DEFAULT '' COMMENT '变量名',
  `value` text NOT NULL COMMENT '变量值',
  `is_syn` tinyint(1) DEFAULT '0' COMMENT '同步官方语言包：0=否，1=是',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `sort_order` int(10) DEFAULT '0' COMMENT '排序号',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=13 DEFAULT CHARSET=utf8 COMMENT='模板语言包变量';

-- -----------------------------
-- Records of `ey_language_pack`
-- -----------------------------
INSERT INTO `ey_language_pack` VALUES ('1', 'sys1', '首页', '1', 'cn', '100', '1543890216', '1543890216');
INSERT INTO `ey_language_pack` VALUES ('2', 'sys2', '上一页', '1', 'cn', '100', '1543890216', '1543890216');
INSERT INTO `ey_language_pack` VALUES ('3', 'sys3', '下一页', '1', 'cn', '100', '1543890216', '1543890216');
INSERT INTO `ey_language_pack` VALUES ('4', 'sys4', '末页', '1', 'cn', '100', '1543890216', '1543890216');
INSERT INTO `ey_language_pack` VALUES ('5', 'sys5', '共<strong>%s</strong>页 <strong>%s</strong>条', '1', 'cn', '100', '1543890216', '1543890216');
INSERT INTO `ey_language_pack` VALUES ('6', 'sys6', '全部', '1', 'cn', '100', '1543890216', '1543890216');
INSERT INTO `ey_language_pack` VALUES ('7', 'sys7', '搜索', '1', 'cn', '100', '1543890216', '1543890216');
INSERT INTO `ey_language_pack` VALUES ('8', 'sys8', '查看详情', '1', 'cn', '100', '1543890216', '1543890216');
INSERT INTO `ey_language_pack` VALUES ('9', 'sys9', '网站首页', '1', 'cn', '100', '1543890216', '1543890216');
INSERT INTO `ey_language_pack` VALUES ('10', 'sys10', '暂无', '1', 'cn', '100', '1543890216', '1543890216');
INSERT INTO `ey_language_pack` VALUES ('11', 'sys11', '上一篇', '1', 'cn', '100', '1543890216', '1543890216');
INSERT INTO `ey_language_pack` VALUES ('12', 'sys12', '下一篇', '1', 'cn', '100', '1543890216', '1543890216');

-- -----------------------------
-- Table structure for `ey_links`
-- -----------------------------
DROP TABLE IF EXISTS `ey_links`;
CREATE TABLE `ey_links` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `typeid` tinyint(1) DEFAULT '1' COMMENT '类型：1=文字链接，2=图片链接',
  `groupid` int(11) unsigned NOT NULL DEFAULT '1' COMMENT '分组id， 默认分组值为1',
  `title` varchar(50) DEFAULT '' COMMENT '网站标题',
  `url` varchar(100) DEFAULT '' COMMENT '网站地址',
  `logo` varchar(255) DEFAULT '' COMMENT '网站LOGO',
  `sort_order` int(11) DEFAULT '0' COMMENT '排序号',
  `target` tinyint(1) DEFAULT '0' COMMENT '是否开启浏览器新窗口',
  `nofollow` tinyint(1) DEFAULT '0',
  `email` varchar(50) DEFAULT NULL,
  `intro` text COMMENT '网站简况',
  `status` tinyint(1) DEFAULT '1' COMMENT '状态(1=显示，0=屏蔽)',
  `province_id` int(10) DEFAULT '0' COMMENT '省份',
  `city_id` int(10) DEFAULT '0' COMMENT '所在城市',
  `area_id` int(10) DEFAULT '0' COMMENT '所在区域',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `delete_time` int(11) DEFAULT '0' COMMENT '软删除时间',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;

-- -----------------------------
-- Records of `ey_links`
-- -----------------------------
INSERT INTO `ey_links` VALUES ('1', '1', '1', '优酷', 'https://www.youku.com/', '', '100', '1', '0', '', '', '1', '0', '0', '0', 'cn', '0', '1533550678', '1686204333');

-- -----------------------------
-- Table structure for `ey_links_group`
-- -----------------------------
DROP TABLE IF EXISTS `ey_links_group`;
CREATE TABLE `ey_links_group` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `group_name` varchar(255) NOT NULL DEFAULT '' COMMENT '分组名称',
  `status` tinyint(2) unsigned NOT NULL DEFAULT '1' COMMENT '状态(1=显示，0=屏蔽)',
  `sort_order` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '排序号',
  `lang` varchar(50) NOT NULL DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(10) unsigned NOT NULL DEFAULT '0',
  `update_time` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COMMENT='友情链接分组';

-- -----------------------------
-- Records of `ey_links_group`
-- -----------------------------
INSERT INTO `ey_links_group` VALUES ('1', '默认分组', '1', '100', 'cn', '1613980400', '1613980400');

-- -----------------------------
-- Table structure for `ey_media_content`
-- -----------------------------
DROP TABLE IF EXISTS `ey_media_content`;
CREATE TABLE `ey_media_content` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `aid` int(10) NOT NULL DEFAULT '0' COMMENT '文档ID',
  `content` longtext COMMENT '内容详情',
  `content_ey_m` longtext COMMENT '手机端内容详情',
  `courseware` varchar(200) NOT NULL DEFAULT '' COMMENT '课件地址',
  `courseware_free` enum('免费','收费') NOT NULL DEFAULT '免费' COMMENT '课件收费',
  `total_duration` int(10) NOT NULL DEFAULT '0' COMMENT '视频总时长',
  `total_video` int(10) NOT NULL DEFAULT '0' COMMENT '视频数',
  `add_time` int(11) NOT NULL DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `aid` (`aid`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='视频附加表';


-- -----------------------------
-- Table structure for `ey_media_file`
-- -----------------------------
DROP TABLE IF EXISTS `ey_media_file`;
CREATE TABLE `ey_media_file` (
  `file_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '视频模型文件表',
  `aid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '文档ID',
  `title` varchar(200) NOT NULL DEFAULT '' COMMENT '文档标题',
  `file_name` varchar(200) NOT NULL DEFAULT '' COMMENT '文件名称',
  `file_title` varchar(200) NOT NULL DEFAULT '' COMMENT '选集标题',
  `file_url` text NOT NULL COMMENT '存储路径',
  `file_time` int(8) NOT NULL DEFAULT '0' COMMENT '文件时长',
  `file_ext` varchar(50) NOT NULL DEFAULT '' COMMENT '文件后缀名',
  `file_size` varchar(255) NOT NULL DEFAULT '' COMMENT '文件大小',
  `file_mime` varchar(200) NOT NULL DEFAULT '' COMMENT '文件类型',
  `uhash` varchar(200) NOT NULL DEFAULT '' COMMENT '自定义的一种加密方式，用于视频播放的权限验证',
  `md5file` varchar(200) NOT NULL DEFAULT '' COMMENT 'md5_file加密，可以检测上传/播放的视频文件是否损坏',
  `is_remote` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否远程 1-远程',
  `playcount` int(10) NOT NULL DEFAULT '0' COMMENT '播放次数',
  `gratis` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否试看，0不试看，1试看',
  `sort_order` smallint(5) NOT NULL DEFAULT '0' COMMENT '排序',
  `add_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '上传时间',
  `update_time` int(11) NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`file_id`) USING BTREE,
  KEY `aid` (`aid`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='视频附件表';


-- -----------------------------
-- Table structure for `ey_media_log`
-- -----------------------------
DROP TABLE IF EXISTS `ey_media_log`;
CREATE TABLE `ey_media_log` (
  `log_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `users_id` int(10) DEFAULT '0' COMMENT '用户ID',
  `aid` int(10) DEFAULT '0' COMMENT '文档ID',
  `file_id` int(10) DEFAULT '0' COMMENT '视频ID',
  `ip` varchar(20) DEFAULT '' COMMENT 'ip',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '编辑时间',
  PRIMARY KEY (`log_id`),
  KEY `file_id` (`file_id`,`aid`,`users_id`) USING BTREE,
  KEY `aid` (`aid`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='视频日志表';


-- -----------------------------
-- Table structure for `ey_media_order`
-- -----------------------------
DROP TABLE IF EXISTS `ey_media_order`;
CREATE TABLE `ey_media_order` (
  `order_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '媒体订单ID',
  `order_code` varchar(50) NOT NULL DEFAULT '' COMMENT '媒体订单编号',
  `users_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '会员ID',
  `mobile` varchar(20) DEFAULT '' COMMENT '手机',
  `order_status` tinyint(1) NOT NULL DEFAULT '0' COMMENT '订单状态：0未付款，1已付款',
  `order_amount` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '订单应付总金额',
  `pay_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '支付时间',
  `pay_name` varchar(20) NOT NULL DEFAULT '' COMMENT '支付方式名称',
  `wechat_pay_type` varchar(20) NOT NULL DEFAULT '' COMMENT '微信支付时，标记使用的支付类型（扫码支付，微信内部，微信H5页面）',
  `pay_details` text COMMENT '支付时返回的数据，以serialize序列化后存入，用于后续查询。',
  `product_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '视频文档ID',
  `product_name` varchar(100) DEFAULT '' COMMENT '视频文档名称',
  `product_litpic` varchar(500) DEFAULT '' COMMENT '视频文档封面图片',
  `lang` varchar(30) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) unsigned DEFAULT '0' COMMENT '下单时间',
  `update_time` int(11) unsigned DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`order_id`),
  UNIQUE KEY `order_code` (`order_code`) USING BTREE,
  KEY `users_id` (`users_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='视频订单表';


-- -----------------------------
-- Table structure for `ey_media_play_record`
-- -----------------------------
DROP TABLE IF EXISTS `ey_media_play_record`;
CREATE TABLE `ey_media_play_record` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `users_id` int(10) DEFAULT '0' COMMENT '用户id',
  `aid` int(10) DEFAULT '0' COMMENT '课程id',
  `file_id` int(10) DEFAULT '0' COMMENT '文件id',
  `play_time` int(10) DEFAULT '0' COMMENT '播放时间',
  `add_time` int(10) DEFAULT '0' COMMENT '添加时间',
  `update_time` int(10) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='视频播放时长表';


-- -----------------------------
-- Table structure for `ey_memgift`
-- -----------------------------
DROP TABLE IF EXISTS `ey_memgift`;
CREATE TABLE `ey_memgift` (
  `gift_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '礼品列表',
  `type` tinyint(3) NOT NULL DEFAULT '1' COMMENT '-1-实物,2-会员产品',
  `type_id` int(10) DEFAULT '0' COMMENT '类型为会员产品时的会员产品类型(users_type_manage)type_id',
  `score` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '所需积分',
  `litpic` varchar(250) NOT NULL DEFAULT '',
  `giftname` varchar(60) NOT NULL DEFAULT '',
  `num` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT '兑换次数',
  `content` longtext COMMENT '礼品详情',
  `stock` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '库存总数',
  `is_del` tinyint(3) NOT NULL DEFAULT '0' COMMENT '0-正常,1-删除',
  `status` tinyint(2) NOT NULL DEFAULT '1' COMMENT '礼品状态：1=显示，0=隐藏',
  `add_time` int(10) DEFAULT '0',
  `update_time` int(10) DEFAULT '0',
  `sort_order` int(10) DEFAULT '100' COMMENT '排序',
  PRIMARY KEY (`gift_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;


-- -----------------------------
-- Table structure for `ey_memgiftget`
-- -----------------------------
DROP TABLE IF EXISTS `ey_memgiftget`;
CREATE TABLE `ey_memgiftget` (
  `gid` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `giftname` char(60) NOT NULL DEFAULT '',
  `gift_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '礼品ID',
  `score` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '积分',
  `users_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `status` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '状态,0-待发货,1-已发货,2-退回,3-重发',
  `name` varchar(255) NOT NULL DEFAULT '' COMMENT '姓名',
  `mobile` varchar(55) NOT NULL DEFAULT '' COMMENT '手机',
  `address` varchar(255) NOT NULL DEFAULT '' COMMENT '地址',
  `add_time` int(10) DEFAULT '0',
  `update_time` int(10) DEFAULT '0',
  `type_id` int(11) DEFAULT '0' COMMENT '兑换会员产品时,会员产品套餐(表::users_type_manage)type_id',
  PRIMARY KEY (`gid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;


-- -----------------------------
-- Table structure for `ey_nav_list`
-- -----------------------------
DROP TABLE IF EXISTS `ey_nav_list`;
CREATE TABLE `ey_nav_list` (
  `nav_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '导航ID',
  `nav_name` varchar(200) NOT NULL DEFAULT '' COMMENT '导航名称',
  `parent_id` int(10) NOT NULL DEFAULT '0' COMMENT '上级菜单id',
  `topid` int(10) NOT NULL DEFAULT '0' COMMENT '顶级菜单id',
  `en_name` varchar(200) NOT NULL DEFAULT '' COMMENT '英文名称',
  `nav_url` varchar(200) NOT NULL DEFAULT '' COMMENT '导航链接',
  `position_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '导航位置',
  `arctype_sync` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否与栏目同步',
  `type_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '同步栏目的ID',
  `nav_pic` varchar(255) NOT NULL DEFAULT '' COMMENT '导航图片',
  `is_remote` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否远程图片',
  `target` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否打开新窗口，1=是，0=否',
  `nofollow` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否使用nofollow，1=是，0=否',
  `status` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '启用 (1=正常，0=停用)',
  `is_del` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '伪删除，1=是，0=否',
  `sort_order` int(10) unsigned NOT NULL DEFAULT '100' COMMENT '排序号',
  `add_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`nav_id`) USING BTREE,
  KEY `position_id` (`position_id`) USING BTREE,
  KEY `type_id` (`type_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='导航列表';


-- -----------------------------
-- Table structure for `ey_nav_position`
-- -----------------------------
DROP TABLE IF EXISTS `ey_nav_position`;
CREATE TABLE `ey_nav_position` (
  `position_id` int(10) NOT NULL AUTO_INCREMENT COMMENT '导航列表ID',
  `position_name` varchar(200) DEFAULT '' COMMENT '导航列表名称',
  `sort_order` int(10) DEFAULT '0' COMMENT '排序号',
  `is_del` tinyint(1) DEFAULT '0' COMMENT '伪删除，1=是，0=否',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`position_id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=7 DEFAULT CHARSET=utf8 COMMENT='导航位置表';

-- -----------------------------
-- Records of `ey_nav_position`
-- -----------------------------
INSERT INTO `ey_nav_position` VALUES ('1', 'PC端主导航', '100', '0', '0', '1624861478');
INSERT INTO `ey_nav_position` VALUES ('2', 'PC端顶部导航', '100', '0', '0', '1624861478');
INSERT INTO `ey_nav_position` VALUES ('3', 'PC端中部导航', '100', '0', '0', '1624861478');
INSERT INTO `ey_nav_position` VALUES ('4', 'PC端底部导航', '100', '0', '0', '1624861478');
INSERT INTO `ey_nav_position` VALUES ('5', '移动端中部导航', '100', '0', '0', '1624861478');
INSERT INTO `ey_nav_position` VALUES ('6', '移动端底部导航', '100', '0', '0', '1624861478');

-- -----------------------------
-- Table structure for `ey_nzsm_content`
-- -----------------------------
DROP TABLE IF EXISTS `ey_nzsm_content`;
CREATE TABLE `ey_nzsm_content` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `aid` int(10) DEFAULT '0' COMMENT '文档ID',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  `zdy` varchar(200) NOT NULL DEFAULT '' COMMENT '字段一',
  `zde` varchar(200) NOT NULL DEFAULT '' COMMENT '字段二',
  `zdsa` varchar(200) NOT NULL DEFAULT '' COMMENT '字段三',
  `zdsi` varchar(200) NOT NULL DEFAULT '' COMMENT '字段四',
  `zdw` varchar(200) NOT NULL DEFAULT '' COMMENT '字段五',
  PRIMARY KEY (`id`),
  KEY `aid` (`aid`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 COMMENT='附加表';

-- -----------------------------
-- Records of `ey_nzsm_content`
-- -----------------------------
INSERT INTO `ey_nzsm_content` VALUES ('1', '8', '1589159107', '1589159107', '短信接口', '企业邮局', '云服务器', '主机租用', '域名注册');
INSERT INTO `ey_nzsm_content` VALUES ('2', '9', '1589159121', '1589159121', '', '手机商城', '小程序商城', '微商城', 'B2C商城');
INSERT INTO `ey_nzsm_content` VALUES ('3', '10', '1589159131', '1589159131', '', 'APP开发', '微信公众平台开发', '手机网站', '小程序开发');
INSERT INTO `ey_nzsm_content` VALUES ('4', '11', '1589159145', '1589159145', 'B2C商城网站建设', '新闻门户网站建设', '营销网站建设', '品牌网站建设', '企业网站建设');

-- -----------------------------
-- Table structure for `ey_pay_api_config`
-- -----------------------------
DROP TABLE IF EXISTS `ey_pay_api_config`;
CREATE TABLE `ey_pay_api_config` (
  `pay_id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '支付接口配置ID，自增',
  `pay_name` varchar(64) NOT NULL DEFAULT '' COMMENT '支付接口配置名称，微信支付，支付宝支付...',
  `pay_mark` varchar(64) NOT NULL DEFAULT '' COMMENT '支付接口配置标识，wechat，alipay...',
  `pay_info` text NOT NULL COMMENT '支付接口配置信息，数组以序列化存储',
  `pay_terminal` varchar(100) NOT NULL DEFAULT '' COMMENT '支付时的终端，暂时预留',
  `system_built` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否属于系统内置，0否，1是',
  `status` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '状态(0=关闭，1=开启)',
  `lang` varchar(30) NOT NULL DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '添加时间',
  `update_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`pay_id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COMMENT='支付接口配置表';

-- -----------------------------
-- Records of `ey_pay_api_config`
-- -----------------------------
INSERT INTO `ey_pay_api_config` VALUES ('1', '微信支付', 'wechat', '', 'a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}', '1', '1', 'cn', '1590111253', '1590661409');
INSERT INTO `ey_pay_api_config` VALUES ('2', '支付宝支付', 'alipay', '', 'a:4:{s:8:\"computer\";i:0;s:6:\"c_mark\";i:0;s:6:\"mobile\";i:0;s:6:\"m_mark\";i:0;}', '1', '1', 'cn', '1590111253', '1667470612');

-- -----------------------------
-- Table structure for `ey_pick_up_points`
-- -----------------------------
DROP TABLE IF EXISTS `ey_pick_up_points`;
CREATE TABLE `ey_pick_up_points` (
  `id` int(10) NOT NULL AUTO_INCREMENT COMMENT '提货点',
  `title` varchar(155) DEFAULT '' COMMENT '名称',
  `intro` varchar(255) DEFAULT '' COMMENT '简介',
  `phone` varchar(55) DEFAULT '' COMMENT '手机号',
  `province` mediumint(8) DEFAULT '0',
  `city` mediumint(8) DEFAULT '0',
  `area` mediumint(8) DEFAULT '0',
  `address` varchar(255) DEFAULT '' COMMENT '详细地址',
  `bussiness_time` varchar(150) DEFAULT '' COMMENT '营业时间',
  `logo` varchar(255) DEFAULT '' COMMENT 'logo',
  `litpic` varchar(255) DEFAULT '' COMMENT '大',
  `lng` varchar(100) DEFAULT '' COMMENT '经度',
  `lat` varchar(100) DEFAULT '' COMMENT '纬度',
  `add_time` int(10) DEFAULT '0',
  `update_time` int(10) DEFAULT '0',
  `status` tinyint(1) DEFAULT '0' COMMENT '状态 0-显示 1-不显示',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='核销提货点表';


-- -----------------------------
-- Table structure for `ey_plugin`
-- -----------------------------
DROP TABLE IF EXISTS `ey_plugin`;
CREATE TABLE `ey_plugin` (
  `code` varchar(13) DEFAULT NULL COMMENT '插件编码',
  `name` varchar(55) DEFAULT NULL COMMENT '中文名字',
  `version` varchar(255) DEFAULT NULL COMMENT '插件的版本',
  `author` varchar(30) DEFAULT NULL COMMENT '插件作者',
  `config` text COMMENT '配置信息',
  `config_value` text COMMENT '配置值信息',
  `desc` varchar(255) DEFAULT NULL COMMENT '插件描述',
  `status` tinyint(1) DEFAULT '0' COMMENT '是否启用',
  `type` varchar(50) DEFAULT NULL COMMENT '插件类型 payment支付 login 登陆 shipping物流',
  `icon` varchar(255) DEFAULT NULL COMMENT '图标',
  `bank_code` text COMMENT '网银配置信息',
  `scene` tinyint(1) DEFAULT '0' COMMENT '使用场景 0PC+手机 1手机 2PC 3APP 4小程序',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间'
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- -----------------------------
-- Records of `ey_plugin`
-- -----------------------------
INSERT INTO `ey_plugin` VALUES ('alipayMobile', '手机网站支付宝', '1.0', '宇宙人', 'a:6:{i:0;a:4:{s:4:\"name\";s:14:\"alipay_account\";s:5:\"label\";s:15:\"支付宝帐户\";s:4:\"type\";s:4:\"text\";s:5:\"value\";s:0:\"\";}i:1;a:4:{s:4:\"name\";s:10:\"alipay_key\";s:5:\"label\";s:21:\"交易安全校验码\";s:4:\"type\";s:4:\"text\";s:5:\"value\";s:0:\"\";}i:2;a:4:{s:4:\"name\";s:14:\"alipay_partner\";s:5:\"label\";s:17:\"合作者身份ID\";s:4:\"type\";s:4:\"text\";s:5:\"value\";s:0:\"\";}i:3;a:4:{s:4:\"name\";s:18:\"alipay_private_key\";s:5:\"label\";s:6:\"秘钥\";s:4:\"type\";s:8:\"textarea\";s:5:\"value\";s:0:\"\";}i:4;a:4:{s:4:\"name\";s:17:\"alipay_pay_method\";s:5:\"label\";s:19:\" 选择接口类型\";s:4:\"type\";s:6:\"select\";s:6:\"option\";a:2:{i:0;s:24:\"使用担保交易接口\";i:1;s:30:\"使用即时到帐交易接口\";}}i:5;a:4:{s:4:\"name\";s:7:\"is_bank\";s:5:\"label\";s:18:\"是否开通网银\";s:4:\"type\";s:6:\"select\";s:6:\"option\";a:2:{i:0;s:3:\"否\";i:1;s:3:\"是\";}}}', '', '手机端网站支付宝 ', '0', 'payment', 'logo.jpg', 'N;', '1', '0');
INSERT INTO `ey_plugin` VALUES ('cod', '到货付款', '1.0', 'IT宇宙人', 'a:1:{i:0;a:4:{s:4:\"name\";s:9:\"code_desc\";s:5:\"label\";s:12:\"配送描述\";s:4:\"type\";s:4:\"text\";s:5:\"value\";s:0:\"\";}}', '', '货到付款插件 ', '0', 'payment', 'logo.jpg', 'N;', '0', '0');
INSERT INTO `ey_plugin` VALUES ('miniAppPay', '微信小程序支付', '1.0', 'lhb', 'a:4:{i:0;a:5:{s:4:\"name\";s:5:\"appid\";s:5:\"label\";s:20:\"绑定支付的APPID\";s:4:\"type\";s:4:\"text\";s:5:\"value\";s:0:\"\";s:4:\"hint\";s:0:\"\";}i:1;a:4:{s:4:\"name\";s:5:\"mchid\";s:5:\"label\";s:9:\"商户号\";s:4:\"type\";s:4:\"text\";s:5:\"value\";s:0:\"\";}i:2;a:4:{s:4:\"name\";s:3:\"key\";s:5:\"label\";s:18:\"商户支付密钥\";s:4:\"type\";s:4:\"text\";s:5:\"value\";s:0:\"\";}i:3;a:4:{s:4:\"name\";s:9:\"appsecret\";s:5:\"label\";s:15:\"小程序secret\";s:4:\"type\";s:4:\"text\";s:5:\"value\";s:0:\"\";}}', '', '微信小程序支付信息', '0', 'payment', 'logo.jpg', 'N;', '4', '0');
INSERT INTO `ey_plugin` VALUES ('appWeixinPay', 'App微信支付', '1.0', 'wangqh', 'a:3:{i:0;a:5:{s:4:\"name\";s:5:\"appid\";s:5:\"label\";s:20:\"绑定支付的APPID\";s:4:\"type\";s:4:\"text\";s:5:\"value\";s:0:\"\";s:4:\"hint\";s:0:\"\";}i:1;a:4:{s:4:\"name\";s:5:\"mchid\";s:5:\"label\";s:9:\"商户号\";s:4:\"type\";s:4:\"text\";s:5:\"value\";s:0:\"\";}i:2;a:4:{s:4:\"name\";s:3:\"key\";s:5:\"label\";s:18:\"商户支付密钥\";s:4:\"type\";s:4:\"text\";s:5:\"value\";s:0:\"\";}}', '', '微信开放平台支付信息', '0', 'payment', 'logo.jpg', 'N;', '3', '0');
INSERT INTO `ey_plugin` VALUES ('tenpay', 'PC端财付通', '1.0', 'IT宇宙人', 'a:2:{i:0;a:4:{s:4:\"name\";s:7:\"partner\";s:5:\"label\";s:7:\"partner\";s:4:\"type\";s:4:\"text\";s:5:\"value\";s:0:\"\";}i:1;a:4:{s:4:\"name\";s:3:\"key\";s:5:\"label\";s:3:\"key\";s:4:\"type\";s:4:\"text\";s:5:\"value\";s:0:\"\";}}', '', 'PC端财付通插件 ', '0', 'payment', 'logo.jpg', 'N;', '2', '0');
INSERT INTO `ey_plugin` VALUES ('alipay', 'PC端支付宝', '1.0', 'jy_pwn', 'a:6:{i:0;a:4:{s:4:\"name\";s:14:\"alipay_account\";s:5:\"label\";s:15:\"支付宝帐户\";s:4:\"type\";s:4:\"text\";s:5:\"value\";s:0:\"\";}i:1;a:4:{s:4:\"name\";s:10:\"alipay_key\";s:5:\"label\";s:21:\"交易安全校验码\";s:4:\"type\";s:4:\"text\";s:5:\"value\";s:0:\"\";}i:2;a:4:{s:4:\"name\";s:14:\"alipay_partner\";s:5:\"label\";s:17:\"合作者身份ID\";s:4:\"type\";s:4:\"text\";s:5:\"value\";s:0:\"\";}i:3;a:4:{s:4:\"name\";s:18:\"alipay_private_key\";s:5:\"label\";s:6:\"秘钥\";s:4:\"type\";s:8:\"textarea\";s:5:\"value\";s:0:\"\";}i:4;a:4:{s:4:\"name\";s:17:\"alipay_pay_method\";s:5:\"label\";s:19:\" 选择接口类型\";s:4:\"type\";s:6:\"select\";s:6:\"option\";a:2:{i:0;s:24:\"使用担保交易接口\";i:1;s:30:\"使用即时到帐交易接口\";}}i:5;a:4:{s:4:\"name\";s:7:\"is_bank\";s:5:\"label\";s:18:\"是否开通网银\";s:4:\"type\";s:6:\"select\";s:6:\"option\";a:2:{i:0;s:3:\"否\";i:1;s:3:\"是\";}}}', '', 'PC端支付宝插件 ', '0', 'payment', 'logo.jpg', 'a:8:{s:12:\"招商银行\";s:9:\"CMB-DEBIT\";s:18:\"中国工商银行\";s:10:\"ICBC-DEBIT\";s:12:\"交通银行\";s:10:\"COMM-DEBIT\";s:18:\"中国建设银行\";s:9:\"CCB-DEBIT\";s:18:\"中国民生银行\";s:4:\"CMBC\";s:12:\"中国银行\";s:9:\"BOC-DEBIT\";s:18:\"中国农业银行\";s:3:\"ABC\";s:12:\"上海银行\";s:6:\"SHBANK\";}', '2', '0');
INSERT INTO `ey_plugin` VALUES ('unionpay', '银联在线支付', '1.0', '奇闻科技', 'a:4:{i:0;a:4:{s:4:\"name\";s:12:\"unionpay_mid\";s:5:\"label\";s:9:\"商户号\";s:4:\"type\";s:4:\"text\";s:5:\"value\";s:15:\"777290058130619\";}i:1;a:4:{s:4:\"name\";s:21:\"unionpay_cer_password\";s:5:\"label\";s:25:\" 商户私钥证书密码\";s:4:\"type\";s:4:\"text\";s:5:\"value\";s:6:\"000000\";}i:2;a:4:{s:4:\"name\";s:13:\"unionpay_user\";s:5:\"label\";s:19:\" 企业网银账号\";s:4:\"type\";s:4:\"text\";s:5:\"value\";s:12:\"123456789001\";}i:3;a:4:{s:4:\"name\";s:17:\"unionpay_password\";s:5:\"label\";s:19:\" 企业网银密码\";s:4:\"type\";s:4:\"text\";s:5:\"value\";s:6:\"789001\";}}', '', '银联在线支付插件 ', '0', 'payment', 'logo.jpg', 'N;', '0', '0');
INSERT INTO `ey_plugin` VALUES ('weixin', '微信支付', '1.0', 'IT宇宙人', 'a:5:{i:0;a:4:{s:4:\"name\";s:5:\"appid\";s:5:\"label\";s:20:\"绑定支付的APPID\";s:4:\"type\";s:4:\"text\";s:5:\"value\";s:0:\"\";}i:1;a:4:{s:4:\"name\";s:5:\"mchid\";s:5:\"label\";s:9:\"商户号\";s:4:\"type\";s:4:\"text\";s:5:\"value\";s:0:\"\";}i:2;a:4:{s:4:\"name\";s:3:\"key\";s:5:\"label\";s:18:\"商户支付密钥\";s:4:\"type\";s:4:\"text\";s:5:\"value\";s:0:\"\";}i:3;a:4:{s:4:\"name\";s:9:\"appsecret\";s:5:\"label\";s:57:\"公众帐号secert（仅JSAPI支付的时候需要配置)\";s:4:\"type\";s:4:\"text\";s:5:\"value\";s:0:\"\";}i:4;a:4:{s:4:\"name\";s:6:\"smchid\";s:5:\"label\";s:48:\"服务商商户号，企业在线付款需用到\";s:4:\"type\";s:4:\"text\";s:5:\"value\";s:0:\"\";}}', '', 'PC端+微信公众号支付', '0', 'payment', 'logo.jpg', 'N;', '0', '0');
INSERT INTO `ey_plugin` VALUES ('helloworld', 'HelloWorld插件', 'v2.0.5,v2.0.7', '惹妹子生气了', '', '', '适合v2.0.5 , v2.0.7', '0', 'function', 'logo.jpg', 'N;', '0', '0');
INSERT INTO `ey_plugin` VALUES ('weixin', '微信登录', '1.0', '彭老师', 'a:3:{i:0;a:4:{s:4:\"name\";s:5:\"appid\";s:5:\"label\";s:17:\"开放平台appid\";s:4:\"type\";s:4:\"text\";s:5:\"value\";s:0:\"\";}i:1;a:4:{s:4:\"name\";s:6:\"secret\";s:5:\"label\";s:18:\"开放平台secret\";s:4:\"type\";s:4:\"text\";s:5:\"value\";s:0:\"\";}i:2;a:4:{s:4:\"name\";s:10:\"return_url\";s:5:\"label\";s:9:\"回调URL\";s:4:\"type\";s:4:\"text\";s:5:\"value\";s:0:\"\";}}', 'a:3:{s:5:\"appid\";s:18:\"wx0f0ff39efd386c42\";s:6:\"secret\";s:32:\"fc878c9641346adc9b7d7e299572ba42\";s:10:\"return_url\";s:67:\"http://www.lvxing1788.com/index/LoginApi/callback/oauth/weixin.html\";}', '微信扫码登录插件 ', '1', 'login', 'logo.jpg', 'N;', '0', '1513556648');
INSERT INTO `ey_plugin` VALUES ('qq', 'QQ登录', '1.0', '彭老师', 'a:3:{i:0;a:4:{s:4:\"name\";s:6:\"app_id\";s:5:\"label\";s:6:\"app_id\";s:4:\"type\";s:4:\"text\";s:5:\"value\";s:0:\"\";}i:1;a:4:{s:4:\"name\";s:10:\"app_secret\";s:5:\"label\";s:10:\"app_secret\";s:4:\"type\";s:4:\"text\";s:5:\"value\";s:0:\"\";}i:2;a:4:{s:4:\"name\";s:10:\"return_url\";s:5:\"label\";s:9:\"回调URL\";s:4:\"type\";s:4:\"text\";s:5:\"value\";s:0:\"\";}}', '', 'QQ登录插件 ', '1', 'login', 'logo.jpg', 'N;', '0', '0');

-- -----------------------------
-- Table structure for `ey_product_attr`
-- -----------------------------
DROP TABLE IF EXISTS `ey_product_attr`;
CREATE TABLE `ey_product_attr` (
  `product_attr_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '产品属性id自增',
  `aid` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT '产品id',
  `attr_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '属性id',
  `attr_value` text COMMENT '属性值',
  `attr_price` varchar(255) DEFAULT '' COMMENT '属性价格',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`product_attr_id`),
  KEY `aid` (`aid`) USING BTREE,
  KEY `attr_id` (`attr_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


-- -----------------------------
-- Table structure for `ey_product_attribute`
-- -----------------------------
DROP TABLE IF EXISTS `ey_product_attribute`;
CREATE TABLE `ey_product_attribute` (
  `attr_id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '属性id',
  `attr_name` varchar(60) DEFAULT '' COMMENT '属性名称',
  `typeid` int(11) unsigned DEFAULT '0' COMMENT '栏目id',
  `attr_index` tinyint(1) unsigned DEFAULT '0' COMMENT '0不需要检索 1关键字检索 2范围检索',
  `attr_input_type` tinyint(1) unsigned DEFAULT '0' COMMENT ' 0=文本框，1=下拉框，2=多行文本框',
  `attr_values` text COMMENT '可选值列表',
  `sort_order` int(11) unsigned DEFAULT '0' COMMENT '属性排序',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `is_del` tinyint(1) DEFAULT '0' COMMENT '是否已删除，0=否，1=是',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`attr_id`),
  KEY `cat_id` (`typeid`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


-- -----------------------------
-- Table structure for `ey_product_content`
-- -----------------------------
DROP TABLE IF EXISTS `ey_product_content`;
CREATE TABLE `ey_product_content` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `aid` int(10) DEFAULT '0' COMMENT '文档ID',
  `content` longtext COMMENT '内容详情',
  `content_ey_m` longtext COMMENT '手机端内容详情',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`),
  KEY `news_id` (`aid`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='资讯内容表_存储正常内容';


-- -----------------------------
-- Table structure for `ey_product_custom_param`
-- -----------------------------
DROP TABLE IF EXISTS `ey_product_custom_param`;
CREATE TABLE `ey_product_custom_param` (
  `param_id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '参数ID',
  `aid` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '参数ID',
  `param_name` varchar(60) NOT NULL DEFAULT '' COMMENT '参数名称',
  `param_value` varchar(200) NOT NULL DEFAULT '' COMMENT '参数值',
  `sort_order` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '属性排序',
  `add_time` int(11) NOT NULL DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`param_id`),
  KEY `aid` (`aid`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;


-- -----------------------------
-- Table structure for `ey_product_img`
-- -----------------------------
DROP TABLE IF EXISTS `ey_product_img`;
CREATE TABLE `ey_product_img` (
  `img_id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `aid` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT '产品ID',
  `title` varchar(200) DEFAULT '' COMMENT '产品标题',
  `image_url` varchar(255) DEFAULT '' COMMENT '文件存储路径',
  `intro` varchar(2000) DEFAULT '' COMMENT '图集描述',
  `width` int(11) DEFAULT '0' COMMENT '图片宽度',
  `height` int(11) DEFAULT '0' COMMENT '图片高度',
  `filesize` varchar(255) DEFAULT '' COMMENT '文件大小',
  `mime` varchar(50) DEFAULT '' COMMENT '图片类型',
  `sort_order` smallint(5) DEFAULT '0' COMMENT '排序',
  `add_time` int(10) unsigned DEFAULT '0' COMMENT '上传时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`img_id`),
  KEY `arcid` (`aid`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


-- -----------------------------
-- Table structure for `ey_product_netdisk`
-- -----------------------------
DROP TABLE IF EXISTS `ey_product_netdisk`;
CREATE TABLE `ey_product_netdisk` (
  `nd_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '网盘商品id',
  `aid` int(10) DEFAULT '0' COMMENT '产品ID',
  `netdisk_url` varchar(255) NOT NULL DEFAULT '' COMMENT '网盘地址',
  `netdisk_pwd` varchar(50) NOT NULL DEFAULT '' COMMENT '提取码',
  `unzip_pwd` varchar(50) NOT NULL DEFAULT '' COMMENT '解压密码',
  `text_content` text NOT NULL COMMENT '文本内容',
  `lang` varchar(10) NOT NULL DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`nd_id`) USING BTREE,
  KEY `aid` (`aid`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='产品虚拟表';


-- -----------------------------
-- Table structure for `ey_product_spec_data`
-- -----------------------------
DROP TABLE IF EXISTS `ey_product_spec_data`;
CREATE TABLE `ey_product_spec_data` (
  `spec_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `aid` int(10) DEFAULT '0' COMMENT '产品ID',
  `spec_mark_id` int(10) DEFAULT '0' COMMENT '规格标记ID',
  `spec_name` varchar(100) DEFAULT '' COMMENT '规格名称',
  `spec_value_id` int(10) DEFAULT '0' COMMENT '规格值ID',
  `spec_value` varchar(100) DEFAULT '' COMMENT '规格值',
  `spec_is_select` tinyint(1) DEFAULT '0' COMMENT '是否选中（0=否，1=是）',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`spec_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='产品规格数据表';


-- -----------------------------
-- Table structure for `ey_product_spec_data_handle`
-- -----------------------------
DROP TABLE IF EXISTS `ey_product_spec_data_handle`;
CREATE TABLE `ey_product_spec_data_handle` (
  `spec_id` int(10) DEFAULT '0' COMMENT '对应 product_spec_data 数据表',
  `aid` int(10) DEFAULT '0' COMMENT '对应 product_spec_data 数据表',
  `spec_mark_id` int(10) DEFAULT '0' COMMENT '对应 product_spec_data 数据表',
  `spec_name` varchar(100) DEFAULT '' COMMENT '对应 product_spec_data 数据表',
  `spec_value_id` int(10) DEFAULT '0' COMMENT '对应 product_spec_data 数据表',
  `spec_value` varchar(100) DEFAULT '' COMMENT '对应 product_spec_data 数据表',
  `spec_is_select` tinyint(1) DEFAULT '0' COMMENT '对应 product_spec_data 数据表',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '对应 product_spec_data 数据表',
  `add_time` int(11) DEFAULT '0' COMMENT '对应 product_spec_data 数据表',
  `update_time` int(11) DEFAULT '0' COMMENT '对应 product_spec_data 数据表'
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='商品规格表(product_spec_data)预处理规格数据表';


-- -----------------------------
-- Table structure for `ey_product_spec_preset`
-- -----------------------------
DROP TABLE IF EXISTS `ey_product_spec_preset`;
CREATE TABLE `ey_product_spec_preset` (
  `preset_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `preset_mark_id` int(10) DEFAULT '0' COMMENT '预设参数标记ID',
  `preset_name` varchar(100) DEFAULT '' COMMENT '规格名称',
  `preset_value` varchar(100) DEFAULT '' COMMENT '规格值',
  `spec_sync` tinyint(1) unsigned DEFAULT '0' COMMENT '是否同步到已发布的商品规格：0否，1是。',
  `sort_order` int(10) DEFAULT '100' COMMENT '排序号',
  `merchant_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '多商家ID',
  `product_add` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否在商品添加或编辑页添加的规格信息，0否，1是，默认0',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`preset_id`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COMMENT='产品规格预设表';

-- -----------------------------
-- Records of `ey_product_spec_preset`
-- -----------------------------
INSERT INTO `ey_product_spec_preset` VALUES ('1', '1', '产品颜色', '红', '0', '100', '0', '0', 'cn', '1565752372', '1565752623');
INSERT INTO `ey_product_spec_preset` VALUES ('2', '1', '产品颜色', '蓝', '0', '100', '0', '0', 'cn', '1565752372', '1565752623');
INSERT INTO `ey_product_spec_preset` VALUES ('3', '1', '产品颜色', '黄', '0', '100', '0', '0', 'cn', '1565752372', '1565752623');

-- -----------------------------
-- Table structure for `ey_product_spec_value`
-- -----------------------------
DROP TABLE IF EXISTS `ey_product_spec_value`;
CREATE TABLE `ey_product_spec_value` (
  `value_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `aid` int(10) NOT NULL DEFAULT '0' COMMENT '产品ID',
  `spec_value_id` varchar(100) NOT NULL DEFAULT '' COMMENT '规格值ID',
  `spec_price` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '规格价格',
  `spec_stock` int(10) NOT NULL DEFAULT '0' COMMENT '规格库存',
  `spec_sales_num` int(10) NOT NULL DEFAULT '0' COMMENT '销售量',
  `seckill_price` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '秒杀价格',
  `seckill_stock` int(10) NOT NULL DEFAULT '0' COMMENT '秒杀库存(独立库存，与spec_stock/限时折扣库存不同步)',
  `seckill_sales_num` int(10) NOT NULL DEFAULT '0' COMMENT '秒杀销售量',
  `is_seckill` tinyint(1) NOT NULL DEFAULT '0' COMMENT '0-普通 1-秒杀',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  `discount_price` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '限时折扣价格',
  `discount_stock` int(10) NOT NULL DEFAULT '0' COMMENT '限时折扣库存(独立库存，与spec_stock/秒杀库存不同步)',
  `discount_sales_num` int(10) NOT NULL DEFAULT '0' COMMENT '限时折扣销售量',
  `is_discount` tinyint(1) NOT NULL DEFAULT '0' COMMENT '0-普通 1-限时折扣',
  PRIMARY KEY (`value_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='产品多规格组装表';


-- -----------------------------
-- Table structure for `ey_quickentry`
-- -----------------------------
DROP TABLE IF EXISTS `ey_quickentry`;
CREATE TABLE `ey_quickentry` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `title` varchar(20) DEFAULT '' COMMENT '名称',
  `laytext` varchar(50) DEFAULT '' COMMENT '完整标题',
  `type` smallint(5) DEFAULT '0' COMMENT '归类，1=快捷入口，2=内容统计',
  `controller` varchar(50) DEFAULT '' COMMENT '控制器名',
  `action` varchar(20) DEFAULT '' COMMENT '操作名',
  `vars` varchar(100) DEFAULT '' COMMENT 'URL参数字符串',
  `groups` smallint(5) DEFAULT '0' COMMENT '分组，1=模型',
  `checked` tinyint(4) DEFAULT '0' COMMENT '选中，0=否，1=是',
  `status` tinyint(1) DEFAULT '1' COMMENT '状态，1=有效，0=无效',
  `sort_order` int(10) DEFAULT '0' COMMENT '排序',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`),
  KEY `type` (`type`,`status`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=40 DEFAULT CHARSET=utf8 COMMENT='快捷入口表';

-- -----------------------------
-- Records of `ey_quickentry`
-- -----------------------------
INSERT INTO `ey_quickentry` VALUES ('1', '产品', '产品列表', '1', 'Product', 'index', 'channel=2', '1', '0', '0', '3', '1569232484', '1686204365');
INSERT INTO `ey_quickentry` VALUES ('2', '下载', '下载列表', '1', 'Download', 'index', 'channel=4', '1', '0', '0', '4', '1569232484', '1686204365');
INSERT INTO `ey_quickentry` VALUES ('3', '文章', '文章列表', '1', 'Article', 'index', 'channel=1', '1', '0', '1', '6', '1569232484', '1686204365');
INSERT INTO `ey_quickentry` VALUES ('4', '图集', '图集列表', '1', 'Images', 'index', 'channel=3', '1', '0', '0', '7', '1569232484', '1686204365');
INSERT INTO `ey_quickentry` VALUES ('5', '内容管理', '内容列表', '1', 'Archives', 'index', '', '0', '0', '1', '13', '1569232484', '1571893529');
INSERT INTO `ey_quickentry` VALUES ('7', '回收站', '回收站', '1', 'RecycleBin', 'archives_index', '', '0', '1', '1', '4', '1569232484', '1571893529');
INSERT INTO `ey_quickentry` VALUES ('8', '栏目管理', '栏目管理', '1', 'Arctype', 'index', '', '0', '0', '1', '5', '1569232484', '1571893529');
INSERT INTO `ey_quickentry` VALUES ('9', '留言', '留言管理', '1', 'Form', 'index', '', '1', '0', '1', '6', '1569232484', '1680749330');
INSERT INTO `ey_quickentry` VALUES ('10', '网站信息', '网站信息', '1', 'System', 'web', '', '0', '0', '1', '7', '1569232484', '1571893529');
INSERT INTO `ey_quickentry` VALUES ('11', '水印配置', '水印配置', '1', 'System', 'water', '', '0', '1', '1', '8', '1569232484', '1571893529');
INSERT INTO `ey_quickentry` VALUES ('12', '缩略图配置', '缩略图配置', '1', 'System', 'thumb', '', '0', '1', '1', '9', '1569232484', '1571893529');
INSERT INTO `ey_quickentry` VALUES ('13', '数据备份', '数据备份', '1', 'Tools', 'index', '', '0', '0', '1', '11', '1569232484', '1571893529');
INSERT INTO `ey_quickentry` VALUES ('14', 'URL配置', 'URL配置', '1', 'Seo', 'seo', '', '0', '1', '1', '1', '1569232484', '1571893529');
INSERT INTO `ey_quickentry` VALUES ('15', '模板管理', '模板管理', '1', 'Filemanager', 'index', '', '0', '1', '1', '6', '1569232484', '1571893529');
INSERT INTO `ey_quickentry` VALUES ('16', 'SiteMap', 'SiteMap', '1', 'Sitemap', 'index', '', '0', '1', '1', '12', '1569232484', '1571893529');
INSERT INTO `ey_quickentry` VALUES ('17', '频道模型', '频道模型', '1', 'Channeltype', 'index', '', '0', '1', '1', '2', '1569232484', '1571893529');
INSERT INTO `ey_quickentry` VALUES ('18', '广告管理', '广告管理', '1', 'AdPosition', 'index', '', '0', '0', '1', '3', '1569232484', '1571893529');
INSERT INTO `ey_quickentry` VALUES ('19', '友情链接', '友情链接', '1', 'Links', 'index', '', '0', '0', '1', '10', '1569232484', '1571893529');
INSERT INTO `ey_quickentry` VALUES ('20', 'Tags管理', 'Tags管理', '1', 'Tags', 'index', '', '0', '1', '1', '14', '1569232484', '1571893529');
INSERT INTO `ey_quickentry` VALUES ('21', '管理员管理', '管理员管理', '1', 'Admin', 'index', '', '0', '0', '1', '15', '1569232484', '1571893529');
INSERT INTO `ey_quickentry` VALUES ('22', '接口配置', '接口配置', '1', 'System', 'api_conf', '', '0', '1', '1', '16', '1569232484', '1571893529');
INSERT INTO `ey_quickentry` VALUES ('23', '文章', '文章列表', '2', 'Article', 'index', 'channel=1', '1', '1', '1', '1', '1569310798', '1686204365');
INSERT INTO `ey_quickentry` VALUES ('24', '产品', '产品列表', '2', 'Product', 'index', 'channel=2', '1', '0', '0', '2', '1569310798', '1686204365');
INSERT INTO `ey_quickentry` VALUES ('25', '下载', '下载列表', '2', 'Download', 'index', 'channel=4', '1', '0', '0', '4', '1569310798', '1686204365');
INSERT INTO `ey_quickentry` VALUES ('26', '图集', '图集列表', '2', 'Images', 'index', 'channel=3', '1', '0', '0', '3', '1569310798', '1686204365');
INSERT INTO `ey_quickentry` VALUES ('27', '留言', '留言管理', '2', 'Form', 'index', '', '1', '0', '1', '5', '1569310798', '1680749330');
INSERT INTO `ey_quickentry` VALUES ('28', '广告', '广告管理', '2', 'AdPosition', 'index', '', '0', '1', '1', '8', '1569232484', '1571898872');
INSERT INTO `ey_quickentry` VALUES ('29', '友情链接', '友情链接', '2', 'Links', 'index', '', '0', '1', '1', '9', '1569232484', '1571898872');
INSERT INTO `ey_quickentry` VALUES ('30', 'Tags标签', 'Tags管理', '2', 'Tags', 'index', '', '0', '1', '1', '10', '1569232484', '1571898872');
INSERT INTO `ey_quickentry` VALUES ('31', '会员', '会员管理', '2', 'Member', 'users_index', '', '0', '0', '0', '7', '1569232484', '1686204365');
INSERT INTO `ey_quickentry` VALUES ('32', '插件应用', '插件应用', '1', 'Weapp', 'index', '', '0', '0', '0', '17', '1569232484', '1686204365');
INSERT INTO `ey_quickentry` VALUES ('33', '会员中心', '会员中心', '1', 'Member', 'users_index', '', '0', '0', '0', '18', '1569232484', '1686204365');
INSERT INTO `ey_quickentry` VALUES ('34', '商城中心', '商城中心', '1', 'Shop', 'index', '', '0', '0', '0', '19', '1569232484', '1686204365');
INSERT INTO `ey_quickentry` VALUES ('35', '订单', '订单管理', '2', 'Shop', 'index', '', '0', '0', '0', '6', '1569232484', '1686204365');
INSERT INTO `ey_quickentry` VALUES ('37', '专题', '专题列表', '2', 'Special', 'index', 'channel=7', '1', '0', '0', '7', '1600078966', '1686204365');
INSERT INTO `ey_quickentry` VALUES ('39', '视频', '视频列表', '2', 'Media', 'index', 'channel=5', '1', '0', '0', '4', '1569310798', '1686204365');

-- -----------------------------
-- Table structure for `ey_recruit_content`
-- -----------------------------
DROP TABLE IF EXISTS `ey_recruit_content`;
CREATE TABLE `ey_recruit_content` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `aid` int(10) DEFAULT '0' COMMENT '文档ID',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  `gzdd` varchar(200) NOT NULL DEFAULT '' COMMENT '工作地点',
  `xlyq` varchar(200) NOT NULL DEFAULT '' COMMENT '学历要求',
  `xzdy` varchar(200) NOT NULL DEFAULT '' COMMENT '薪资待遇',
  `gzxz` varchar(200) NOT NULL DEFAULT '' COMMENT '工作性质',
  `gznx` varchar(200) NOT NULL DEFAULT '' COMMENT '工作年限',
  `zprs` varchar(200) NOT NULL DEFAULT '' COMMENT '招聘人数',
  `nnxq` longtext COMMENT '内容详情',
  PRIMARY KEY (`id`),
  KEY `aid` (`aid`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=7 DEFAULT CHARSET=utf8 COMMENT='附加表';

-- -----------------------------
-- Records of `ey_recruit_content`
-- -----------------------------
INSERT INTO `ey_recruit_content` VALUES ('1', '82', '1563528211', '1563528211', '广州市', '中专以上学历', '5000-10000元', '全职', '1年以上', '若干', '&lt;p&gt;工作内容：&lt;br style=&quot;outline: 0px; text-size-adjust: none; -webkit-tap-highlight-color: rgba(0, 0, 0, 0.05); color: rgb(46, 52, 59); font-family: &amp;quot;Microsoft YaHei&amp;quot;, &amp;quot;Hiragino Sans GB&amp;quot;, 微软雅黑, arial, Tahoma, SimSun, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);&quot;/&gt;1、负责公司手机游戏产品的在线推广；&lt;br style=&quot;outline: 0px; text-size-adjust: none; -webkit-tap-highlight-color: rgba(0, 0, 0, 0.05); color: rgb(46, 52, 59); font-family: &amp;quot;Microsoft YaHei&amp;quot;, &amp;quot;Hiragino Sans GB&amp;quot;, 微软雅黑, arial, Tahoma, SimSun, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);&quot;/&gt;2、做好每天的推广统计，定制有效的投放策略并执行；&lt;br style=&quot;outline: 0px; text-size-adjust: none; -webkit-tap-highlight-color: rgba(0, 0, 0, 0.05); color: rgb(46, 52, 59); font-family: &amp;quot;Microsoft YaHei&amp;quot;, &amp;quot;Hiragino Sans GB&amp;quot;, 微软雅黑, arial, Tahoma, SimSun, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);&quot;/&gt;3、完成每天的业绩要求，只要你努力，月入过万不是梦&lt;br style=&quot;outline: 0px; text-size-adjust: none; -webkit-tap-highlight-color: rgba(0, 0, 0, 0.05); color: rgb(46, 52, 59); font-family: &amp;quot;Microsoft YaHei&amp;quot;, &amp;quot;Hiragino Sans GB&amp;quot;, 微软雅黑, arial, Tahoma, SimSun, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);&quot;/&gt;职位要求：&lt;br style=&quot;outline: 0px; text-size-adjust: none; -webkit-tap-highlight-color: rgba(0, 0, 0, 0.05); color: rgb(46, 52, 59); font-family: &amp;quot;Microsoft YaHei&amp;quot;, &amp;quot;Hiragino Sans GB&amp;quot;, 微软雅黑, arial, Tahoma, SimSun, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);&quot;/&gt;1学历不限，欢迎优秀应届生（优秀者可放宽）；男女不限，19~24岁&lt;br style=&quot;outline: 0px; text-size-adjust: none; -webkit-tap-highlight-color: rgba(0, 0, 0, 0.05); color: rgb(46, 52, 59); font-family: &amp;quot;Microsoft YaHei&amp;quot;, &amp;quot;Hiragino Sans GB&amp;quot;, 微软雅黑, arial, Tahoma, SimSun, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);&quot;/&gt;2.亲和力强、沟通流畅、重点突出；&lt;br style=&quot;outline: 0px; text-size-adjust: none; -webkit-tap-highlight-color: rgba(0, 0, 0, 0.05); color: rgb(46, 52, 59); font-family: &amp;quot;Microsoft YaHei&amp;quot;, &amp;quot;Hiragino Sans GB&amp;quot;, 微软雅黑, arial, Tahoma, SimSun, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);&quot;/&gt;3.个性开朗、反应敏捷，有较强的服务意识和责任心；&lt;br style=&quot;outline: 0px; text-size-adjust: none; -webkit-tap-highlight-color: rgba(0, 0, 0, 0.05); color: rgb(46, 52, 59); font-family: &amp;quot;Microsoft YaHei&amp;quot;, &amp;quot;Hiragino Sans GB&amp;quot;, 微软雅黑, arial, Tahoma, SimSun, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);&quot;/&gt;4.能熟练运用QQ及微信聊天软件，懂得电脑的基本操作，打字速度不限&lt;br style=&quot;outline: 0px; text-size-adjust: none; -webkit-tap-highlight-color: rgba(0, 0, 0, 0.05); color: rgb(46, 52, 59); font-family: &amp;quot;Microsoft YaHei&amp;quot;, &amp;quot;Hiragino Sans GB&amp;quot;, 微软雅黑, arial, Tahoma, SimSun, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);&quot;/&gt;我们期待怀揣梦想的你加入我们！&lt;br style=&quot;outline: 0px; text-size-adjust: none; -webkit-tap-highlight-color: rgba(0, 0, 0, 0.05); color: rgb(46, 52, 59); font-family: &amp;quot;Microsoft YaHei&amp;quot;, &amp;quot;Hiragino Sans GB&amp;quot;, 微软雅黑, arial, Tahoma, SimSun, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);&quot;/&gt;5、有经验者优先考虑！！！！！&lt;/p&gt;');
INSERT INTO `ey_recruit_content` VALUES ('2', '83', '1563528292', '1563528292', '广州市', '中专以上学历', '5000-8000元', '全职', '2年以上', '2位', '&lt;p&gt;&lt;span style=&quot;color: rgb(46, 52, 59); font-family: &amp;quot;Microsoft YaHei&amp;quot;, &amp;quot;Hiragino Sans GB&amp;quot;, 微软雅黑, arial, Tahoma, SimSun, sans-serif; font-size: 14px; background-color: rgb(255, 255, 255);&quot;&gt;岗位职责：&lt;/span&gt;&lt;br style=&quot;outline: 0px; text-size-adjust: none; -webkit-tap-highlight-color: rgba(0, 0, 0, 0.05); color: rgb(46, 52, 59); font-family: &amp;quot;Microsoft YaHei&amp;quot;, &amp;quot;Hiragino Sans GB&amp;quot;, 微软雅黑, arial, Tahoma, SimSun, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);&quot;/&gt;&lt;span style=&quot;color: rgb(46, 52, 59); font-family: &amp;quot;Microsoft YaHei&amp;quot;, &amp;quot;Hiragino Sans GB&amp;quot;, 微软雅黑, arial, Tahoma, SimSun, sans-serif; font-size: 14px; background-color: rgb(255, 255, 255);&quot;&gt;1、负责网站相关栏目、信息的搜集、编辑、发布等工作。&lt;/span&gt;&lt;br style=&quot;outline: 0px; text-size-adjust: none; -webkit-tap-highlight-color: rgba(0, 0, 0, 0.05); color: rgb(46, 52, 59); font-family: &amp;quot;Microsoft YaHei&amp;quot;, &amp;quot;Hiragino Sans GB&amp;quot;, 微软雅黑, arial, Tahoma, SimSun, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);&quot;/&gt;&lt;span style=&quot;color: rgb(46, 52, 59); font-family: &amp;quot;Microsoft YaHei&amp;quot;, &amp;quot;Hiragino Sans GB&amp;quot;, 微软雅黑, arial, Tahoma, SimSun, sans-serif; font-size: 14px; background-color: rgb(255, 255, 255);&quot;&gt;2、完成信息内容的策划和日常信息的更新与维护。&lt;/span&gt;&lt;br style=&quot;outline: 0px; text-size-adjust: none; -webkit-tap-highlight-color: rgba(0, 0, 0, 0.05); color: rgb(46, 52, 59); font-family: &amp;quot;Microsoft YaHei&amp;quot;, &amp;quot;Hiragino Sans GB&amp;quot;, 微软雅黑, arial, Tahoma, SimSun, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);&quot;/&gt;&lt;span style=&quot;color: rgb(46, 52, 59); font-family: &amp;quot;Microsoft YaHei&amp;quot;, &amp;quot;Hiragino Sans GB&amp;quot;, 微软雅黑, arial, Tahoma, SimSun, sans-serif; font-size: 14px; background-color: rgb(255, 255, 255);&quot;&gt;3、编写网站宣传资料及相关产品信息。&lt;/span&gt;&lt;br style=&quot;outline: 0px; text-size-adjust: none; -webkit-tap-highlight-color: rgba(0, 0, 0, 0.05); color: rgb(46, 52, 59); font-family: &amp;quot;Microsoft YaHei&amp;quot;, &amp;quot;Hiragino Sans GB&amp;quot;, 微软雅黑, arial, Tahoma, SimSun, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);&quot;/&gt;&lt;span style=&quot;color: rgb(46, 52, 59); font-family: &amp;quot;Microsoft YaHei&amp;quot;, &amp;quot;Hiragino Sans GB&amp;quot;, 微软雅黑, arial, Tahoma, SimSun, sans-serif; font-size: 14px; background-color: rgb(255, 255, 255);&quot;&gt;4、配合部门编辑策划推广活动。&lt;/span&gt;&lt;br style=&quot;outline: 0px; text-size-adjust: none; -webkit-tap-highlight-color: rgba(0, 0, 0, 0.05); color: rgb(46, 52, 59); font-family: &amp;quot;Microsoft YaHei&amp;quot;, &amp;quot;Hiragino Sans GB&amp;quot;, 微软雅黑, arial, Tahoma, SimSun, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);&quot;/&gt;&lt;span style=&quot;color: rgb(46, 52, 59); font-family: &amp;quot;Microsoft YaHei&amp;quot;, &amp;quot;Hiragino Sans GB&amp;quot;, 微软雅黑, arial, Tahoma, SimSun, sans-serif; font-size: 14px; background-color: rgb(255, 255, 255);&quot;&gt;5、部门总监下发的其他任务。&lt;/span&gt;&lt;br style=&quot;outline: 0px; text-size-adjust: none; -webkit-tap-highlight-color: rgba(0, 0, 0, 0.05); color: rgb(46, 52, 59); font-family: &amp;quot;Microsoft YaHei&amp;quot;, &amp;quot;Hiragino Sans GB&amp;quot;, 微软雅黑, arial, Tahoma, SimSun, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);&quot;/&gt;&lt;span style=&quot;color: rgb(46, 52, 59); font-family: &amp;quot;Microsoft YaHei&amp;quot;, &amp;quot;Hiragino Sans GB&amp;quot;, 微软雅黑, arial, Tahoma, SimSun, sans-serif; font-size: 14px; background-color: rgb(255, 255, 255);&quot;&gt;任职资格：&lt;/span&gt;&lt;br style=&quot;outline: 0px; text-size-adjust: none; -webkit-tap-highlight-color: rgba(0, 0, 0, 0.05); color: rgb(46, 52, 59); font-family: &amp;quot;Microsoft YaHei&amp;quot;, &amp;quot;Hiragino Sans GB&amp;quot;, 微软雅黑, arial, Tahoma, SimSun, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);&quot;/&gt;&lt;span style=&quot;color: rgb(46, 52, 59); font-family: &amp;quot;Microsoft YaHei&amp;quot;, &amp;quot;Hiragino Sans GB&amp;quot;, 微软雅黑, arial, Tahoma, SimSun, sans-serif; font-size: 14px; background-color: rgb(255, 255, 255);&quot;&gt;1、编辑、新闻、中文等相关专业优先，大专及以上学历。&lt;/span&gt;&lt;br style=&quot;outline: 0px; text-size-adjust: none; -webkit-tap-highlight-color: rgba(0, 0, 0, 0.05); color: rgb(46, 52, 59); font-family: &amp;quot;Microsoft YaHei&amp;quot;, &amp;quot;Hiragino Sans GB&amp;quot;, 微软雅黑, arial, Tahoma, SimSun, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);&quot;/&gt;&lt;span style=&quot;color: rgb(46, 52, 59); font-family: &amp;quot;Microsoft YaHei&amp;quot;, &amp;quot;Hiragino Sans GB&amp;quot;, 微软雅黑, arial, Tahoma, SimSun, sans-serif; font-size: 14px; background-color: rgb(255, 255, 255);&quot;&gt;2、有编辑或从事相关工作经验优先。&lt;/span&gt;&lt;br style=&quot;outline: 0px; text-size-adjust: none; -webkit-tap-highlight-color: rgba(0, 0, 0, 0.05); color: rgb(46, 52, 59); font-family: &amp;quot;Microsoft YaHei&amp;quot;, &amp;quot;Hiragino Sans GB&amp;quot;, 微软雅黑, arial, Tahoma, SimSun, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);&quot;/&gt;&lt;span style=&quot;color: rgb(46, 52, 59); font-family: &amp;quot;Microsoft YaHei&amp;quot;, &amp;quot;Hiragino Sans GB&amp;quot;, 微软雅黑, arial, Tahoma, SimSun, sans-serif; font-size: 14px; background-color: rgb(255, 255, 255);&quot;&gt;3、熟练使用网页制作软件和网络搜索工具，了解网站运行、维护相关知识。&lt;/span&gt;&lt;br style=&quot;outline: 0px; text-size-adjust: none; -webkit-tap-highlight-color: rgba(0, 0, 0, 0.05); color: rgb(46, 52, 59); font-family: &amp;quot;Microsoft YaHei&amp;quot;, &amp;quot;Hiragino Sans GB&amp;quot;, 微软雅黑, arial, Tahoma, SimSun, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);&quot;/&gt;&lt;span style=&quot;color: rgb(46, 52, 59); font-family: &amp;quot;Microsoft YaHei&amp;quot;, &amp;quot;Hiragino Sans GB&amp;quot;, 微软雅黑, arial, Tahoma, SimSun, sans-serif; font-size: 14px; background-color: rgb(255, 255, 255);&quot;&gt;4、良好的文字功底，信息采编能力。&lt;/span&gt;&lt;br style=&quot;outline: 0px; text-size-adjust: none; -webkit-tap-highlight-color: rgba(0, 0, 0, 0.05); color: rgb(46, 52, 59); font-family: &amp;quot;Microsoft YaHei&amp;quot;, &amp;quot;Hiragino Sans GB&amp;quot;, 微软雅黑, arial, Tahoma, SimSun, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);&quot;/&gt;&lt;span style=&quot;color: rgb(46, 52, 59); font-family: &amp;quot;Microsoft YaHei&amp;quot;, &amp;quot;Hiragino Sans GB&amp;quot;, 微软雅黑, arial, Tahoma, SimSun, sans-serif; font-size: 14px; background-color: rgb(255, 255, 255);&quot;&gt;5、欢迎应届毕业生来应聘。&lt;/span&gt;&lt;/p&gt;');
INSERT INTO `ey_recruit_content` VALUES ('3', '94', '1565225547', '1565225547', '广州市', '专科以上学历', '5000-8000元', '全职', '2年以上', '若干', '&lt;p&gt;1、负责客户开发、提供客户服务、公司服务的推广、建立与维护客户关系；&lt;/p&gt;&lt;p&gt;2、根据市场营销计划和个人销售目标，完成各阶段销售目标；&lt;/p&gt;&lt;p&gt;3、进行市场调研，确定目标市场，收集分析竞争对象信息，制订、执行销售对策；&lt;/p&gt;&lt;p&gt;4、与内部相关部门建立并维持良好的协作关系，以客户和市场为导向，协调各方面关系，确保合同的顺利执行。&lt;/p&gt;&lt;p&gt;【岗位要求】&lt;/p&gt;&lt;p&gt;1、专科学历，有一定客户服务工作经验或销售经验，有一定的客户服务知识和能力。&lt;/p&gt;&lt;p&gt;2、计算机操作熟练，office办公软件使用熟练，有一定的网络基础知识，熟练使用Photoshop等制图工具着优先考虑。&lt;/p&gt;&lt;p&gt;3、要求一定要有“客户优先”的服务精神，一切从帮助客户、满足客户角度出发。&lt;/p&gt;&lt;p&gt;4、性格要求沉稳、隐忍，善于倾听，有同理心，乐观、积极。普通话标准、流利，反应灵敏。&lt;/p&gt;&lt;p&gt;5、热爱工作，敬业、勤恳、乐于思考，具有自我发展的主观的主题愿望和自我学习能力。可适当加班者优先。&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;');
INSERT INTO `ey_recruit_content` VALUES ('4', '95', '1565225608', '1565225608', '广州市', '专科以上学历', '5000-10000元', '全职', '2年以上', '若干', '&lt;p&gt;岗位职责：1、利用网络进行公司产品的销售及推广2、了解网络销售，有信心和良好的学习能力3、完成团队目标4、通过网络进行渠道开发和业务拓展5、熟悉互联网络，熟练使用网络交流工具和各种办公软件6、有较强的沟通能力&lt;/p&gt;&lt;p&gt;任职要求：1、年龄18～25之间，有空杯心态者优先2、性格开朗，喜欢与人沟通，表达流畅，普通话标准3、具备一定的客户服务精神，准确把握客户需求4、认真细致，能接受挑战性任务5、有无销售经验均可，欢迎应届毕业生应聘&lt;/p&gt;&lt;p&gt;薪资待遇：底薪+高抽成+奖金+年底双薪+生日聚餐，不定期的聚会和旅游等&lt;/p&gt;&lt;p&gt;晋升空间：业务基础—精英业务员—销售组长—销售主管—核心主管&lt;/p&gt;&lt;p&gt;销售激励：礼品奖励、现金奖金、出单奖励、周业绩奖励、月销售前三奖励。依法享受法定节假日（带薪旅游、带薪年假、婚假。、产假、员工生日庆祝）&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;');
INSERT INTO `ey_recruit_content` VALUES ('5', '96', '1565225638', '1565225638', '广州市', '专科以上学历', '5000-10000元', '全职', '2年以上', '若干', '&lt;p&gt;任职要求： 1、年龄25-35岁，本科及以上学历，网络安全相关专业，持网络安全证书，2年以上同岗位工作经验； 2、熟知防火墙、入侵检测、网络流量识别控制等信息安全产品相关技术；熟悉网络协议、网络编程及相关网络产品开发技术； 3、具备良好的安全意识能力、语言表达能力、逻辑思维能力、执行力、责任心、团队协作能力。 岗位职责： 1、安全设备的日常监控与维护，及时进行安全设备策略的变更与调整；安全运维的结果文档、技术资料、设备日志，配置信息等相关资料的管理及维护； 2、定期关注安全设备系统的升级补丁，合适准确性后及时更新补丁，完成安全设备系统升级； 3、安全设备的健康检查、健康检查表、基线统计、流量统计、特殊事件报告、日报、周报等日常工作； 4、参与信息安全事件的分析工作和应急处理工作；定期安全评估、扫描和加固，协助进行安全加固； 5、协助制定网络安全规范与方案，优化现有网络安全架构，定期评估网络安全风险，负责针对运行故障、安全事件开展分析和总结，定期开展运行维护、故障处理及安全事件分析； 6、完成上级领导交办的其他任务，并做好与其他部门的协调配合工作。&lt;/p&gt;');
INSERT INTO `ey_recruit_content` VALUES ('6', '97', '1565225697', '1565225697', '广州市', '专科以上学历', '5000-8000元', '全职', '1年以上', '2位', '&lt;p&gt;岗位职责1、组织参与重要项目的创意构思、文案及客户提案, 给予前期提案、设计创意说明及后期结案报告等服务；2、执行并监督所负责项目的创意构思和文案；3、稿件思路清晰，能够完成稿件写作思路规划；4、协助领导进行创意提案，保证工作的顺利推进；5、独立撰写各类稿件（新闻稿、综述稿、评论稿、专访稿等）、策划方案、报告等任职资格1、大专及以上学历；2、一年以上市场策划及文案工作经验；3、能够准确捕捉产品亮点，具备恰如其分的文字表现能力；4、熟悉专业创意方法，思维敏捷，洞察力强，文字功底扎实，语言表达能力强；福利待遇：1.公司为员工提供以市场标杆，以能力、绩效为标准，具有市场竞争力的薪资待遇；2.为员工缴纳社会保险和办理住房公积金、带薪年假、法定节假日、小暑假；3.员工享有专业持续的提升培训机制、不定期的拓展福利、稳健的晋升机制；4.生日福利、传统节日福利、年终奖、年终分红等多种特色福利；试用期工资3500职能类别：网站&lt;/p&gt;');

-- -----------------------------
-- Table structure for `ey_recruitsite`
-- -----------------------------
DROP TABLE IF EXISTS `ey_recruitsite`;
CREATE TABLE `ey_recruitsite` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(32) NOT NULL COMMENT '地区名称',
  `level` tinyint(4) NOT NULL DEFAULT '0' COMMENT '地区等级 分省市县区',
  `parent_id` int(10) NOT NULL DEFAULT '0' COMMENT '父id',
  `topid` int(10) NOT NULL DEFAULT '0' COMMENT '顶级ID',
  `initial` varchar(10) NOT NULL COMMENT '首字母',
  `status` tinyint(1) NOT NULL DEFAULT '1' COMMENT '状态（1：开启，0：隐藏）',
  `domain` varchar(50) DEFAULT NULL COMMENT '查询条件',
  `sort_order` int(6) NOT NULL DEFAULT '100' COMMENT '排序',
  `add_time` int(11) NOT NULL DEFAULT '0',
  `update_time` int(11) NOT NULL DEFAULT '0',
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=28 DEFAULT CHARSET=utf8;

-- -----------------------------
-- Records of `ey_recruitsite`
-- -----------------------------
INSERT INTO `ey_recruitsite` VALUES ('6', '市场销售', '1', '0', '0', 'S', '1', 'scxs', '100', '1628013234', '1628013234');
INSERT INTO `ey_recruitsite` VALUES ('7', '销售经理', '2', '6', '6', 'X', '1', 'xsjl', '100', '1628013256', '1628013256');
INSERT INTO `ey_recruitsite` VALUES ('8', '销售助理', '3', '7', '6', 'X', '1', 'xszl', '100', '1628013280', '1628013280');
INSERT INTO `ey_recruitsite` VALUES ('9', '行政人事', '1', '0', '0', 'X', '1', 'xzrs', '100', '1628013294', '1628013294');
INSERT INTO `ey_recruitsite` VALUES ('10', '市场/营销经理', '2', '6', '6', 'S', '1', 'yxjl', '100', '1628013354', '1628013354');
INSERT INTO `ey_recruitsite` VALUES ('11', '销售主管', '2', '6', '6', 'X', '1', 'xszg', '100', '1628013366', '1628013366');
INSERT INTO `ey_recruitsite` VALUES ('12', '市场部主管', '3', '11', '6', 'S', '1', 'scbzg', '100', '1628013377', '1628013430');
INSERT INTO `ey_recruitsite` VALUES ('13', '市场调研/业务分析', '2', '6', '6', 'S', '1', 'scdy', '100', '1628013449', '1628013449');
INSERT INTO `ey_recruitsite` VALUES ('14', '推（营、促）销员', '2', '6', '6', 'T', '1', 'tcxy', '100', '1628013464', '1628013464');
INSERT INTO `ey_recruitsite` VALUES ('15', '市场/行销企划', '2', '6', '6', 'S', '1', 'scxqh', '100', '1628013477', '1628013477');
INSERT INTO `ey_recruitsite` VALUES ('16', '产品/品牌企划', '2', '6', '6', 'C', '1', 'cppqh', '100', '1628013490', '1628013490');
INSERT INTO `ey_recruitsite` VALUES ('17', '电话销售', '2', '6', '6', 'D', '1', 'dhxs', '100', '1628013502', '1628013502');
INSERT INTO `ey_recruitsite` VALUES ('18', '公关经理', '2', '6', '6', 'G', '1', 'ggjl', '100', '1628013520', '1628013520');
INSERT INTO `ey_recruitsite` VALUES ('19', '销售工程师', '2', '6', '6', 'X', '1', 'xsgxs', '100', '1628013558', '1628013558');
INSERT INTO `ey_recruitsite` VALUES ('20', '市场推广/拓展/合作', '2', '6', '6', 'S', '1', 'sctg', '100', '1628013568', '1628013568');
INSERT INTO `ey_recruitsite` VALUES ('21', '城建装修', '1', '0', '0', 'C', '1', 'cjzx', '100', '1628013594', '1628013594');
INSERT INTO `ey_recruitsite` VALUES ('22', '客户服务', '1', '0', '0', 'K', '1', 'khfw', '100', '1628013604', '1628013604');
INSERT INTO `ey_recruitsite` VALUES ('23', '会计财务', '1', '0', '0', 'H', '1', 'kjcw', '100', '1628013614', '1628013614');
INSERT INTO `ey_recruitsite` VALUES ('24', '普工技工', '1', '0', '0', 'P', '1', 'pgjg', '100', '1628013626', '1628013626');
INSERT INTO `ey_recruitsite` VALUES ('25', '餐饮休闲', '1', '0', '0', 'C', '1', 'cyxx', '100', '1628013637', '1628013637');
INSERT INTO `ey_recruitsite` VALUES ('26', '金融保险', '1', '0', '0', 'J', '1', 'jrbx', '100', '1628013647', '1628013647');
INSERT INTO `ey_recruitsite` VALUES ('27', '人事经理', '2', '9', '9', 'R', '1', 'rsjl', '100', '1628089579', '1628089579');

-- -----------------------------
-- Table structure for `ey_region`
-- -----------------------------
DROP TABLE IF EXISTS `ey_region`;
CREATE TABLE `ey_region` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '表id',
  `name` varchar(32) DEFAULT '' COMMENT '地区名称',
  `level` tinyint(4) DEFAULT '0' COMMENT '地区等级 分省市县区',
  `parent_id` int(10) DEFAULT '0' COMMENT '父id',
  `initial` varchar(5) DEFAULT '' COMMENT '首字母',
  PRIMARY KEY (`id`),
  KEY `parent_id` (`parent_id`) USING BTREE,
  KEY `level` (`level`) USING BTREE,
  KEY `initial` (`initial`)
) ENGINE=MyISAM AUTO_INCREMENT=47971 DEFAULT CHARSET=utf8 COMMENT='区域表';

-- -----------------------------
-- Records of `ey_region`
-- -----------------------------
INSERT INTO `ey_region` VALUES ('1', '北京市', '1', '0', 'B');
INSERT INTO `ey_region` VALUES ('2', '北京市', '2', '1', 'B');
INSERT INTO `ey_region` VALUES ('3', '东城区', '3', '2', 'D');
INSERT INTO `ey_region` VALUES ('14', '西城区', '3', '2', 'X');
INSERT INTO `ey_region` VALUES ('22', '崇文区', '3', '2', 'C');
INSERT INTO `ey_region` VALUES ('30', '宣武区', '3', '2', 'X');
INSERT INTO `ey_region` VALUES ('39', '朝阳区', '3', '2', 'C');
INSERT INTO `ey_region` VALUES ('83', '丰台区', '3', '2', 'F');
INSERT INTO `ey_region` VALUES ('105', '石景山区', '3', '2', 'S');
INSERT INTO `ey_region` VALUES ('115', '海淀区', '3', '2', 'H');
INSERT INTO `ey_region` VALUES ('145', '门头沟区', '3', '2', 'M');
INSERT INTO `ey_region` VALUES ('159', '房山区', '3', '2', 'F');
INSERT INTO `ey_region` VALUES ('188', '通州区', '3', '2', 'T');
INSERT INTO `ey_region` VALUES ('204', '顺义区', '3', '2', 'S');
INSERT INTO `ey_region` VALUES ('227', '昌平区', '3', '2', 'C');
INSERT INTO `ey_region` VALUES ('245', '大兴区', '3', '2', 'D');
INSERT INTO `ey_region` VALUES ('264', '怀柔区', '3', '2', 'H');
INSERT INTO `ey_region` VALUES ('281', '平谷区', '3', '2', 'P');
INSERT INTO `ey_region` VALUES ('301', '密云区', '3', '2', 'M');
INSERT INTO `ey_region` VALUES ('322', '延庆区', '3', '2', 'Y');
INSERT INTO `ey_region` VALUES ('338', '天津市', '1', '0', 'T');
INSERT INTO `ey_region` VALUES ('339', '天津市', '2', '338', 'T');
INSERT INTO `ey_region` VALUES ('340', '和平区', '3', '339', 'H');
INSERT INTO `ey_region` VALUES ('347', '河东区', '3', '339', 'H');
INSERT INTO `ey_region` VALUES ('361', '河西区', '3', '339', 'H');
INSERT INTO `ey_region` VALUES ('375', '南开区', '3', '339', 'N');
INSERT INTO `ey_region` VALUES ('388', '河北区', '3', '339', 'H');
INSERT INTO `ey_region` VALUES ('399', '红桥区', '3', '339', 'H');
INSERT INTO `ey_region` VALUES ('410', '塘沽区', '3', '339', 'T');
INSERT INTO `ey_region` VALUES ('425', '汉沽区', '3', '339', 'H');
INSERT INTO `ey_region` VALUES ('435', '大港区', '3', '339', 'D');
INSERT INTO `ey_region` VALUES ('445', '东丽区', '3', '339', 'D');
INSERT INTO `ey_region` VALUES ('460', '西青区', '3', '339', 'X');
INSERT INTO `ey_region` VALUES ('473', '津南区', '3', '339', 'J');
INSERT INTO `ey_region` VALUES ('488', '北辰区', '3', '339', 'B');
INSERT INTO `ey_region` VALUES ('504', '武清区', '3', '339', 'W');
INSERT INTO `ey_region` VALUES ('538', '宝坻区', '3', '339', 'B');
INSERT INTO `ey_region` VALUES ('570', '宁河区', '3', '339', 'N');
INSERT INTO `ey_region` VALUES ('586', '静海区', '3', '339', 'J');
INSERT INTO `ey_region` VALUES ('608', '蓟州区', '3', '339', 'J');
INSERT INTO `ey_region` VALUES ('636', '河北省', '1', '0', 'H');
INSERT INTO `ey_region` VALUES ('637', '石家庄市', '2', '636', 'S');
INSERT INTO `ey_region` VALUES ('638', '市辖区', '3', '637', 'S');
INSERT INTO `ey_region` VALUES ('639', '长安区', '3', '637', 'C');
INSERT INTO `ey_region` VALUES ('651', '桥东区', '3', '637', 'Q');
INSERT INTO `ey_region` VALUES ('662', '桥西区', '3', '637', 'Q');
INSERT INTO `ey_region` VALUES ('675', '新华区', '3', '637', 'X');
INSERT INTO `ey_region` VALUES ('691', '井陉矿区', '3', '637', 'J');
INSERT INTO `ey_region` VALUES ('697', '裕华区', '3', '637', 'Y');
INSERT INTO `ey_region` VALUES ('708', '井陉县', '3', '637', 'J');
INSERT INTO `ey_region` VALUES ('726', '正定县', '3', '637', 'Z');
INSERT INTO `ey_region` VALUES ('736', '栾城县', '3', '637', 'L');
INSERT INTO `ey_region` VALUES ('745', '行唐县', '3', '637', 'X');
INSERT INTO `ey_region` VALUES ('761', '灵寿县', '3', '637', 'L');
INSERT INTO `ey_region` VALUES ('777', '高邑县', '3', '637', 'G');
INSERT INTO `ey_region` VALUES ('783', '深泽县', '3', '637', 'S');
INSERT INTO `ey_region` VALUES ('790', '赞皇县', '3', '637', 'Z');
INSERT INTO `ey_region` VALUES ('802', '无极县', '3', '637', 'W');
INSERT INTO `ey_region` VALUES ('814', '平山县', '3', '637', 'P');
INSERT INTO `ey_region` VALUES ('838', '元氏县', '3', '637', 'Y');
INSERT INTO `ey_region` VALUES ('854', '赵县', '3', '637', 'Z');
INSERT INTO `ey_region` VALUES ('866', '辛集市', '3', '637', 'X');
INSERT INTO `ey_region` VALUES ('882', '藁城市', '3', '637', 'G');
INSERT INTO `ey_region` VALUES ('898', '晋州市', '3', '637', 'J');
INSERT INTO `ey_region` VALUES ('909', '新乐市', '3', '637', 'X');
INSERT INTO `ey_region` VALUES ('922', '鹿泉市', '3', '637', 'L');
INSERT INTO `ey_region` VALUES ('936', '唐山市', '2', '636', 'T');
INSERT INTO `ey_region` VALUES ('937', '市辖区', '3', '936', 'S');
INSERT INTO `ey_region` VALUES ('938', '路南区', '3', '936', 'L');
INSERT INTO `ey_region` VALUES ('952', '路北区', '3', '936', 'L');
INSERT INTO `ey_region` VALUES ('965', '古冶区', '3', '936', 'G');
INSERT INTO `ey_region` VALUES ('977', '开平区', '3', '936', 'K');
INSERT INTO `ey_region` VALUES ('989', '丰南区', '3', '936', 'F');
INSERT INTO `ey_region` VALUES ('1007', '丰润区', '3', '936', 'F');
INSERT INTO `ey_region` VALUES ('1034', '滦县', '3', '936', 'L');
INSERT INTO `ey_region` VALUES ('1048', '滦南县', '3', '936', 'L');
INSERT INTO `ey_region` VALUES ('1067', '乐亭县', '3', '936', 'L');
INSERT INTO `ey_region` VALUES ('1085', '迁西县', '3', '936', 'Q');
INSERT INTO `ey_region` VALUES ('1104', '玉田县', '3', '936', 'Y');
INSERT INTO `ey_region` VALUES ('1125', '唐海县', '3', '936', 'T');
INSERT INTO `ey_region` VALUES ('1140', '遵化市', '3', '936', 'Z');
INSERT INTO `ey_region` VALUES ('1168', '迁安市', '3', '936', 'Q');
INSERT INTO `ey_region` VALUES ('1188', '秦皇岛市', '2', '636', 'Q');
INSERT INTO `ey_region` VALUES ('1189', '市辖区', '3', '1188', 'S');
INSERT INTO `ey_region` VALUES ('1190', '海港区', '3', '1188', 'H');
INSERT INTO `ey_region` VALUES ('1208', '山海关区', '3', '1188', 'S');
INSERT INTO `ey_region` VALUES ('1218', '北戴河区', '3', '1188', 'B');
INSERT INTO `ey_region` VALUES ('1223', '青龙县', '3', '1188', 'Q');
INSERT INTO `ey_region` VALUES ('1249', '昌黎县', '3', '1188', 'C');
INSERT INTO `ey_region` VALUES ('1266', '抚宁县', '3', '1188', 'F');
INSERT INTO `ey_region` VALUES ('1278', '卢龙县', '3', '1188', 'L');
INSERT INTO `ey_region` VALUES ('1291', '邯郸市', '2', '636', 'H');
INSERT INTO `ey_region` VALUES ('1292', '市辖区', '3', '1291', 'S');
INSERT INTO `ey_region` VALUES ('1293', '邯山区', '3', '1291', 'H');
INSERT INTO `ey_region` VALUES ('1307', '丛台区', '3', '1291', 'C');
INSERT INTO `ey_region` VALUES ('1319', '复兴区', '3', '1291', 'F');
INSERT INTO `ey_region` VALUES ('1329', '峰峰矿区', '3', '1291', 'F');
INSERT INTO `ey_region` VALUES ('1339', '邯郸县', '3', '1291', 'H');
INSERT INTO `ey_region` VALUES ('1350', '临漳县', '3', '1291', 'L');
INSERT INTO `ey_region` VALUES ('1365', '成安县', '3', '1291', 'C');
INSERT INTO `ey_region` VALUES ('1375', '大名县', '3', '1291', 'D');
INSERT INTO `ey_region` VALUES ('1396', '涉县', '3', '1291', 'S');
INSERT INTO `ey_region` VALUES ('1414', '磁县', '3', '1291', 'C');
INSERT INTO `ey_region` VALUES ('1434', '肥乡县', '3', '1291', 'F');
INSERT INTO `ey_region` VALUES ('1444', '永年县', '3', '1291', 'Y');
INSERT INTO `ey_region` VALUES ('1465', '邱县', '3', '1291', 'Q');
INSERT INTO `ey_region` VALUES ('1473', '鸡泽县', '3', '1291', 'J');
INSERT INTO `ey_region` VALUES ('1481', '广平县', '3', '1291', 'G');
INSERT INTO `ey_region` VALUES ('1489', '馆陶县', '3', '1291', 'G');
INSERT INTO `ey_region` VALUES ('1498', '魏县', '3', '1291', 'W');
INSERT INTO `ey_region` VALUES ('1520', '曲周县', '3', '1291', 'Q');
INSERT INTO `ey_region` VALUES ('1531', '武安市', '3', '1291', 'W');
INSERT INTO `ey_region` VALUES ('1554', '邢台市', '2', '636', 'X');
INSERT INTO `ey_region` VALUES ('1555', '市辖区', '3', '1554', 'S');
INSERT INTO `ey_region` VALUES ('1556', '桥东区', '3', '1554', 'Q');
INSERT INTO `ey_region` VALUES ('1564', '桥西区', '3', '1554', 'Q');
INSERT INTO `ey_region` VALUES ('1572', '邢台县', '3', '1554', 'X');
INSERT INTO `ey_region` VALUES ('1593', '临城县', '3', '1554', 'L');
INSERT INTO `ey_region` VALUES ('1602', '内邱县', '3', '1554', 'N');
INSERT INTO `ey_region` VALUES ('1612', '柏乡县', '3', '1554', 'B');
INSERT INTO `ey_region` VALUES ('1619', '隆尧县', '3', '1554', 'L');
INSERT INTO `ey_region` VALUES ('1633', '任县', '3', '1554', 'R');
INSERT INTO `ey_region` VALUES ('1642', '南和县', '3', '1554', 'N');
INSERT INTO `ey_region` VALUES ('1651', '宁晋县', '3', '1554', 'N');
INSERT INTO `ey_region` VALUES ('1669', '巨鹿县', '3', '1554', 'J');
INSERT INTO `ey_region` VALUES ('1680', '新河县', '3', '1554', 'X');
INSERT INTO `ey_region` VALUES ('1687', '广宗县', '3', '1554', 'G');
INSERT INTO `ey_region` VALUES ('1696', '平乡县', '3', '1554', 'P');
INSERT INTO `ey_region` VALUES ('1704', '威县', '3', '1554', 'W');
INSERT INTO `ey_region` VALUES ('1721', '清河县', '3', '1554', 'Q');
INSERT INTO `ey_region` VALUES ('1728', '临西县', '3', '1554', 'L');
INSERT INTO `ey_region` VALUES ('1738', '南宫市', '3', '1554', 'N');
INSERT INTO `ey_region` VALUES ('1754', '沙河市', '3', '1554', 'S');
INSERT INTO `ey_region` VALUES ('1772', '保定市', '2', '636', 'B');
INSERT INTO `ey_region` VALUES ('1773', '市辖区', '3', '1772', 'S');
INSERT INTO `ey_region` VALUES ('1774', '新市区', '3', '1772', 'X');
INSERT INTO `ey_region` VALUES ('1787', '北市区', '3', '1772', 'B');
INSERT INTO `ey_region` VALUES ('1796', '南市区', '3', '1772', 'N');
INSERT INTO `ey_region` VALUES ('1806', '满城区', '3', '1772', 'M');
INSERT INTO `ey_region` VALUES ('1820', '清苑区', '3', '1772', 'Q');
INSERT INTO `ey_region` VALUES ('1839', '涞水县', '3', '1772', 'L');
INSERT INTO `ey_region` VALUES ('1856', '阜平县', '3', '1772', 'F');
INSERT INTO `ey_region` VALUES ('1870', '徐水区', '3', '1772', 'X');
INSERT INTO `ey_region` VALUES ('1885', '定兴县', '3', '1772', 'D');
INSERT INTO `ey_region` VALUES ('1902', '唐县', '3', '1772', 'T');
INSERT INTO `ey_region` VALUES ('1923', '高阳县', '3', '1772', 'G');
INSERT INTO `ey_region` VALUES ('1933', '容城县', '3', '1772', 'R');
INSERT INTO `ey_region` VALUES ('1942', '涞源县', '3', '1772', 'L');
INSERT INTO `ey_region` VALUES ('1960', '望都县', '3', '1772', 'W');
INSERT INTO `ey_region` VALUES ('1969', '安新县', '3', '1772', 'A');
INSERT INTO `ey_region` VALUES ('1982', '易县', '3', '1772', 'Y');
INSERT INTO `ey_region` VALUES ('2010', '曲阳县', '3', '1772', 'Q');
INSERT INTO `ey_region` VALUES ('2029', '蠡县', '3', '1772', 'L');
INSERT INTO `ey_region` VALUES ('2043', '顺平县', '3', '1772', 'S');
INSERT INTO `ey_region` VALUES ('2054', '博野县', '3', '1772', 'B');
INSERT INTO `ey_region` VALUES ('2062', '雄县', '3', '1772', 'X');
INSERT INTO `ey_region` VALUES ('2072', '涿州市', '3', '1772', 'Z');
INSERT INTO `ey_region` VALUES ('2088', '定州市', '3', '1772', 'D');
INSERT INTO `ey_region` VALUES ('2114', '安国市', '3', '1772', 'A');
INSERT INTO `ey_region` VALUES ('2126', '高碑店市', '3', '1772', 'G');
INSERT INTO `ey_region` VALUES ('2142', '张家口市', '2', '636', 'Z');
INSERT INTO `ey_region` VALUES ('2143', '市辖区', '3', '2142', 'S');
INSERT INTO `ey_region` VALUES ('2144', '桥东区', '3', '2142', 'Q');
INSERT INTO `ey_region` VALUES ('2154', '桥西区', '3', '2142', 'Q');
INSERT INTO `ey_region` VALUES ('2164', '宣化区', '3', '2142', 'X');
INSERT INTO `ey_region` VALUES ('2176', '下花园区', '3', '2142', 'X');
INSERT INTO `ey_region` VALUES ('2183', '宣化县', '3', '2142', 'X');
INSERT INTO `ey_region` VALUES ('2198', '张北县', '3', '2142', 'Z');
INSERT INTO `ey_region` VALUES ('2220', '康保县', '3', '2142', 'K');
INSERT INTO `ey_region` VALUES ('2237', '沽源县', '3', '2142', 'G');
INSERT INTO `ey_region` VALUES ('2256', '尚义县', '3', '2142', 'S');
INSERT INTO `ey_region` VALUES ('2271', '蔚县', '3', '2142', 'W');
INSERT INTO `ey_region` VALUES ('2294', '阳原县', '3', '2142', 'Y');
INSERT INTO `ey_region` VALUES ('2309', '怀安县', '3', '2142', 'H');
INSERT INTO `ey_region` VALUES ('2321', '万全县', '3', '2142', 'W');
INSERT INTO `ey_region` VALUES ('2333', '怀来县', '3', '2142', 'H');
INSERT INTO `ey_region` VALUES ('2351', '涿鹿县', '3', '2142', 'Z');
INSERT INTO `ey_region` VALUES ('2369', '赤城县', '3', '2142', 'C');
INSERT INTO `ey_region` VALUES ('2388', '崇礼县', '3', '2142', 'C');
INSERT INTO `ey_region` VALUES ('2400', '承德市', '2', '636', 'C');
INSERT INTO `ey_region` VALUES ('2401', '市辖区', '3', '2400', 'S');
INSERT INTO `ey_region` VALUES ('2402', '双桥区', '3', '2400', 'S');
INSERT INTO `ey_region` VALUES ('2415', '双滦区', '3', '2400', 'S');
INSERT INTO `ey_region` VALUES ('2422', '鹰手营子矿区', '3', '2400', 'Y');
INSERT INTO `ey_region` VALUES ('2427', '承德县', '3', '2400', 'C');
INSERT INTO `ey_region` VALUES ('2453', '兴隆县', '3', '2400', 'X');
INSERT INTO `ey_region` VALUES ('2474', '平泉县', '3', '2400', 'P');
INSERT INTO `ey_region` VALUES ('2494', '滦平县', '3', '2400', 'L');
INSERT INTO `ey_region` VALUES ('2517', '隆化县', '3', '2400', 'L');
INSERT INTO `ey_region` VALUES ('2543', '丰宁县', '3', '2400', 'F');
INSERT INTO `ey_region` VALUES ('2570', '宽城县', '3', '2400', 'K');
INSERT INTO `ey_region` VALUES ('2589', '围场县', '3', '2400', 'W');
INSERT INTO `ey_region` VALUES ('2629', '沧州市', '2', '636', 'C');
INSERT INTO `ey_region` VALUES ('2630', '市辖区', '3', '2629', 'S');
INSERT INTO `ey_region` VALUES ('2631', '新华区', '3', '2629', 'X');
INSERT INTO `ey_region` VALUES ('2639', '运河区', '3', '2629', 'Y');
INSERT INTO `ey_region` VALUES ('2648', '沧县', '3', '2629', 'C');
INSERT INTO `ey_region` VALUES ('2668', '青县', '3', '2629', 'Q');
INSERT INTO `ey_region` VALUES ('2680', '东光县', '3', '2629', 'D');
INSERT INTO `ey_region` VALUES ('2690', '海兴县', '3', '2629', 'H');
INSERT INTO `ey_region` VALUES ('2701', '盐山县', '3', '2629', 'Y');
INSERT INTO `ey_region` VALUES ('2714', '肃宁县', '3', '2629', 'S');
INSERT INTO `ey_region` VALUES ('2724', '南皮县', '3', '2629', 'N');
INSERT INTO `ey_region` VALUES ('2734', '吴桥县', '3', '2629', 'W');
INSERT INTO `ey_region` VALUES ('2745', '献县', '3', '2629', 'X');
INSERT INTO `ey_region` VALUES ('2765', '孟村县', '3', '2629', 'M');
INSERT INTO `ey_region` VALUES ('2772', '泊头市', '3', '2629', 'B');
INSERT INTO `ey_region` VALUES ('2788', '任邱市', '3', '2629', 'R');
INSERT INTO `ey_region` VALUES ('2809', '黄骅市', '3', '2629', 'H');
INSERT INTO `ey_region` VALUES ('2828', '河间市', '3', '2629', 'H');
INSERT INTO `ey_region` VALUES ('2849', '廊坊市', '2', '636', 'L');
INSERT INTO `ey_region` VALUES ('2850', '市辖区', '3', '2849', 'S');
INSERT INTO `ey_region` VALUES ('2851', '安次区', '3', '2849', 'A');
INSERT INTO `ey_region` VALUES ('2862', '广阳区', '3', '2849', 'G');
INSERT INTO `ey_region` VALUES ('2873', '固安县', '3', '2849', 'G');
INSERT INTO `ey_region` VALUES ('2883', '永清县', '3', '2849', 'Y');
INSERT INTO `ey_region` VALUES ('2895', '香河县', '3', '2849', 'X');
INSERT INTO `ey_region` VALUES ('2906', '大城县', '3', '2849', 'D');
INSERT INTO `ey_region` VALUES ('2918', '文安县', '3', '2849', 'W');
INSERT INTO `ey_region` VALUES ('2932', '大厂县', '3', '2849', 'D');
INSERT INTO `ey_region` VALUES ('2939', '霸州市', '3', '2849', 'B');
INSERT INTO `ey_region` VALUES ('2953', '三河市', '3', '2849', 'S');
INSERT INTO `ey_region` VALUES ('2968', '衡水市', '2', '636', 'H');
INSERT INTO `ey_region` VALUES ('2969', '市辖区', '3', '2968', 'S');
INSERT INTO `ey_region` VALUES ('2970', '桃城区', '3', '2968', 'T');
INSERT INTO `ey_region` VALUES ('2983', '枣强县', '3', '2968', 'Z');
INSERT INTO `ey_region` VALUES ('2995', '武邑县', '3', '2968', 'W');
INSERT INTO `ey_region` VALUES ('3005', '武强县', '3', '2968', 'W');
INSERT INTO `ey_region` VALUES ('3012', '饶阳县', '3', '2968', 'R');
INSERT INTO `ey_region` VALUES ('3020', '安平县', '3', '2968', 'A');
INSERT INTO `ey_region` VALUES ('3029', '故城县', '3', '2968', 'G');
INSERT INTO `ey_region` VALUES ('3043', '景县', '3', '2968', 'J');
INSERT INTO `ey_region` VALUES ('3060', '阜城县', '3', '2968', 'F');
INSERT INTO `ey_region` VALUES ('3071', '冀州市', '3', '2968', 'J');
INSERT INTO `ey_region` VALUES ('3083', '深州市', '3', '2968', 'S');
INSERT INTO `ey_region` VALUES ('3102', '山西省', '1', '0', 'S');
INSERT INTO `ey_region` VALUES ('3103', '太原市', '2', '3102', 'T');
INSERT INTO `ey_region` VALUES ('3104', '市辖区', '3', '3103', 'S');
INSERT INTO `ey_region` VALUES ('3105', '小店区(人口含高新经济区)', '3', '3103', 'X');
INSERT INTO `ey_region` VALUES ('3117', '迎泽区', '3', '3103', 'Y');
INSERT INTO `ey_region` VALUES ('3126', '杏花岭区', '3', '3103', 'X');
INSERT INTO `ey_region` VALUES ('3140', '尖草坪区', '3', '3103', 'J');
INSERT INTO `ey_region` VALUES ('3155', '万柏林区', '3', '3103', 'W');
INSERT INTO `ey_region` VALUES ('3171', '晋源区', '3', '3103', 'J');
INSERT INTO `ey_region` VALUES ('3178', '清徐县', '3', '3103', 'Q');
INSERT INTO `ey_region` VALUES ('3188', '阳曲县', '3', '3103', 'Y');
INSERT INTO `ey_region` VALUES ('3200', '娄烦县', '3', '3103', 'L');
INSERT INTO `ey_region` VALUES ('3209', '古交市', '3', '3103', 'G');
INSERT INTO `ey_region` VALUES ('3224', '大同市', '2', '3102', 'D');
INSERT INTO `ey_region` VALUES ('3225', '市辖区', '3', '3224', 'S');
INSERT INTO `ey_region` VALUES ('3226', '大同市城区', '3', '3224', 'D');
INSERT INTO `ey_region` VALUES ('3241', '矿区', '3', '3224', 'K');
INSERT INTO `ey_region` VALUES ('3266', '南郊区', '3', '3224', 'N');
INSERT INTO `ey_region` VALUES ('3277', '新荣区', '3', '3224', 'X');
INSERT INTO `ey_region` VALUES ('3286', '阳高县', '3', '3224', 'Y');
INSERT INTO `ey_region` VALUES ('3300', '天镇县', '3', '3224', 'T');
INSERT INTO `ey_region` VALUES ('3312', '广灵县', '3', '3224', 'G');
INSERT INTO `ey_region` VALUES ('3322', '灵丘县', '3', '3224', 'L');
INSERT INTO `ey_region` VALUES ('3335', '浑源县', '3', '3224', 'H');
INSERT INTO `ey_region` VALUES ('3354', '左云县', '3', '3224', 'Z');
INSERT INTO `ey_region` VALUES ('3364', '大同县', '3', '3224', 'D');
INSERT INTO `ey_region` VALUES ('3379', '阳泉市', '2', '3102', 'Y');
INSERT INTO `ey_region` VALUES ('3380', '市辖区', '3', '3379', 'S');
INSERT INTO `ey_region` VALUES ('3381', '城区', '3', '3379', 'C');
INSERT INTO `ey_region` VALUES ('3388', '矿区', '3', '3379', 'K');
INSERT INTO `ey_region` VALUES ('3395', '郊区', '3', '3379', 'J');
INSERT INTO `ey_region` VALUES ('3405', '平定县', '3', '3379', 'P');
INSERT INTO `ey_region` VALUES ('3416', '盂县', '3', '3379', 'Y');
INSERT INTO `ey_region` VALUES ('3431', '长治市', '2', '3102', 'C');
INSERT INTO `ey_region` VALUES ('3432', '市辖区', '3', '3431', 'S');
INSERT INTO `ey_region` VALUES ('3433', '长治市城区', '3', '3431', 'C');
INSERT INTO `ey_region` VALUES ('3445', '长治市郊区', '3', '3431', 'C');
INSERT INTO `ey_region` VALUES ('3454', '长治县', '3', '3431', 'C');
INSERT INTO `ey_region` VALUES ('3466', '襄垣县', '3', '3431', 'X');
INSERT INTO `ey_region` VALUES ('3478', '屯留县', '3', '3431', 'T');
INSERT INTO `ey_region` VALUES ('3493', '平顺县', '3', '3431', 'P');
INSERT INTO `ey_region` VALUES ('3506', '黎城县', '3', '3431', 'L');
INSERT INTO `ey_region` VALUES ('3516', '壶关县', '3', '3431', 'H');
INSERT INTO `ey_region` VALUES ('3530', '长子县', '3', '3431', 'C');
INSERT INTO `ey_region` VALUES ('3543', '武乡县', '3', '3431', 'W');
INSERT INTO `ey_region` VALUES ('3558', '沁县', '3', '3431', 'Q');
INSERT INTO `ey_region` VALUES ('3572', '沁源县', '3', '3431', 'Q');
INSERT INTO `ey_region` VALUES ('3587', '潞城市', '3', '3431', 'L');
INSERT INTO `ey_region` VALUES ('3597', '晋城市', '2', '3102', 'J');
INSERT INTO `ey_region` VALUES ('3598', '市辖区', '3', '3597', 'S');
INSERT INTO `ey_region` VALUES ('3599', '晋城市城区', '3', '3597', 'J');
INSERT INTO `ey_region` VALUES ('3608', '沁水县', '3', '3597', 'Q');
INSERT INTO `ey_region` VALUES ('3623', '阳城县', '3', '3597', 'Y');
INSERT INTO `ey_region` VALUES ('3642', '陵川县', '3', '3597', 'L');
INSERT INTO `ey_region` VALUES ('3655', '泽州县', '3', '3597', 'Z');
INSERT INTO `ey_region` VALUES ('3673', '高平市', '3', '3597', 'G');
INSERT INTO `ey_region` VALUES ('3690', '朔州市', '2', '3102', 'S');
INSERT INTO `ey_region` VALUES ('3691', '市辖区', '3', '3690', 'S');
INSERT INTO `ey_region` VALUES ('3692', '朔城区', '3', '3690', 'S');
INSERT INTO `ey_region` VALUES ('3709', '平鲁区', '3', '3690', 'P');
INSERT INTO `ey_region` VALUES ('3723', '山阴县', '3', '3690', 'S');
INSERT INTO `ey_region` VALUES ('3739', '应县', '3', '3690', 'Y');
INSERT INTO `ey_region` VALUES ('3752', '右玉县', '3', '3690', 'Y');
INSERT INTO `ey_region` VALUES ('3763', '怀仁县', '3', '3690', 'H');
INSERT INTO `ey_region` VALUES ('3776', '晋中市', '2', '3102', 'J');
INSERT INTO `ey_region` VALUES ('3777', '市辖区', '3', '3776', 'S');
INSERT INTO `ey_region` VALUES ('3778', '榆次区', '3', '3776', 'Y');
INSERT INTO `ey_region` VALUES ('3799', '榆社县', '3', '3776', 'Y');
INSERT INTO `ey_region` VALUES ('3810', '左权县', '3', '3776', 'Z');
INSERT INTO `ey_region` VALUES ('3822', '和顺县', '3', '3776', 'H');
INSERT INTO `ey_region` VALUES ('3833', '昔阳县', '3', '3776', 'X');
INSERT INTO `ey_region` VALUES ('3846', '寿阳县', '3', '3776', 'S');
INSERT INTO `ey_region` VALUES ('3861', '太谷县', '3', '3776', 'T');
INSERT INTO `ey_region` VALUES ('3871', '祁县', '3', '3776', 'Q');
INSERT INTO `ey_region` VALUES ('3880', '平遥县', '3', '3776', 'P');
INSERT INTO `ey_region` VALUES ('3895', '灵石县', '3', '3776', 'L');
INSERT INTO `ey_region` VALUES ('3908', '介休市', '3', '3776', 'J');
INSERT INTO `ey_region` VALUES ('3925', '运城市', '2', '3102', 'Y');
INSERT INTO `ey_region` VALUES ('3926', '市辖区', '3', '3925', 'S');
INSERT INTO `ey_region` VALUES ('3927', '盐湖区', '3', '3925', 'Y');
INSERT INTO `ey_region` VALUES ('3950', '临猗县', '3', '3925', 'L');
INSERT INTO `ey_region` VALUES ('3967', '万荣县', '3', '3925', 'W');
INSERT INTO `ey_region` VALUES ('3982', '闻喜县', '3', '3925', 'W');
INSERT INTO `ey_region` VALUES ('3996', '稷山县', '3', '3925', 'J');
INSERT INTO `ey_region` VALUES ('4004', '新绛县', '3', '3925', 'X');
INSERT INTO `ey_region` VALUES ('4013', '绛县', '3', '3925', 'J');
INSERT INTO `ey_region` VALUES ('4024', '垣曲县', '3', '3925', 'Y');
INSERT INTO `ey_region` VALUES ('4036', '夏县', '3', '3925', 'X');
INSERT INTO `ey_region` VALUES ('4048', '平陆县', '3', '3925', 'P');
INSERT INTO `ey_region` VALUES ('4059', '芮城县', '3', '3925', 'R');
INSERT INTO `ey_region` VALUES ('4070', '永济市', '3', '3925', 'Y');
INSERT INTO `ey_region` VALUES ('4082', '河津市', '3', '3925', 'H');
INSERT INTO `ey_region` VALUES ('4093', '忻州市', '2', '3102', 'X');
INSERT INTO `ey_region` VALUES ('4094', '市辖区', '3', '4093', 'S');
INSERT INTO `ey_region` VALUES ('4095', '忻府区', '3', '4093', 'X');
INSERT INTO `ey_region` VALUES ('4116', '定襄县', '3', '4093', 'D');
INSERT INTO `ey_region` VALUES ('4126', '五台县', '3', '4093', 'W');
INSERT INTO `ey_region` VALUES ('4146', '代县', '3', '4093', 'D');
INSERT INTO `ey_region` VALUES ('4158', '繁峙县', '3', '4093', 'F');
INSERT INTO `ey_region` VALUES ('4172', '宁武县', '3', '4093', 'N');
INSERT INTO `ey_region` VALUES ('4189', '静乐县', '3', '4093', 'J');
INSERT INTO `ey_region` VALUES ('4204', '神池县', '3', '4093', 'S');
INSERT INTO `ey_region` VALUES ('4215', '五寨县', '3', '4093', 'W');
INSERT INTO `ey_region` VALUES ('4228', '岢岚县', '3', '4093', 'K');
INSERT INTO `ey_region` VALUES ('4241', '河曲县', '3', '4093', 'H');
INSERT INTO `ey_region` VALUES ('4255', '保德县', '3', '4093', 'B');
INSERT INTO `ey_region` VALUES ('4269', '偏关县', '3', '4093', 'P');
INSERT INTO `ey_region` VALUES ('4280', '原平市', '3', '4093', 'Y');
INSERT INTO `ey_region` VALUES ('4304', '临汾市', '2', '3102', 'L');
INSERT INTO `ey_region` VALUES ('4305', '市辖区', '3', '4304', 'S');
INSERT INTO `ey_region` VALUES ('4306', '尧都区', '3', '4304', 'Y');
INSERT INTO `ey_region` VALUES ('4333', '曲沃县', '3', '4304', 'Q');
INSERT INTO `ey_region` VALUES ('4341', '翼城县', '3', '4304', 'Y');
INSERT INTO `ey_region` VALUES ('4352', '襄汾县', '3', '4304', 'X');
INSERT INTO `ey_region` VALUES ('4366', '洪洞县', '3', '4304', 'H');
INSERT INTO `ey_region` VALUES ('4383', '古县', '3', '4304', 'G');
INSERT INTO `ey_region` VALUES ('4391', '安泽县', '3', '4304', 'A');
INSERT INTO `ey_region` VALUES ('4399', '浮山县', '3', '4304', 'F');
INSERT INTO `ey_region` VALUES ('4409', '吉县', '3', '4304', 'J');
INSERT INTO `ey_region` VALUES ('4418', '乡宁县', '3', '4304', 'X');
INSERT INTO `ey_region` VALUES ('4429', '大宁县', '3', '4304', 'D');
INSERT INTO `ey_region` VALUES ('4436', '隰县', '3', '4304', 'X');
INSERT INTO `ey_region` VALUES ('4445', '永和县', '3', '4304', 'Y');
INSERT INTO `ey_region` VALUES ('4453', '蒲县', '3', '4304', 'P');
INSERT INTO `ey_region` VALUES ('4463', '汾西县', '3', '4304', 'F');
INSERT INTO `ey_region` VALUES ('4472', '侯马市', '3', '4304', 'H');
INSERT INTO `ey_region` VALUES ('4481', '霍州市', '3', '4304', 'H');
INSERT INTO `ey_region` VALUES ('4494', '吕梁市', '2', '3102', 'L');
INSERT INTO `ey_region` VALUES ('4495', '市辖区', '3', '4494', 'S');
INSERT INTO `ey_region` VALUES ('4496', '离石区', '3', '4494', 'L');
INSERT INTO `ey_region` VALUES ('4509', '文水县', '3', '4494', 'W');
INSERT INTO `ey_region` VALUES ('4522', '交城县', '3', '4494', 'J');
INSERT INTO `ey_region` VALUES ('4533', '兴县', '3', '4494', 'X');
INSERT INTO `ey_region` VALUES ('4551', '临县', '3', '4494', 'L');
INSERT INTO `ey_region` VALUES ('4575', '柳林县', '3', '4494', 'L');
INSERT INTO `ey_region` VALUES ('4591', '石楼县', '3', '4494', 'S');
INSERT INTO `ey_region` VALUES ('4601', '岚县', '3', '4494', 'L');
INSERT INTO `ey_region` VALUES ('4614', '方山县', '3', '4494', 'F');
INSERT INTO `ey_region` VALUES ('4622', '中阳县', '3', '4494', 'Z');
INSERT INTO `ey_region` VALUES ('4630', '交口县', '3', '4494', 'J');
INSERT INTO `ey_region` VALUES ('4638', '孝义市', '3', '4494', 'X');
INSERT INTO `ey_region` VALUES ('4655', '汾阳市', '3', '4494', 'F');
INSERT INTO `ey_region` VALUES ('4670', '内蒙古自治区', '1', '0', 'N');
INSERT INTO `ey_region` VALUES ('4671', '呼和浩特市', '2', '4670', 'H');
INSERT INTO `ey_region` VALUES ('4672', '市辖区', '3', '4671', 'S');
INSERT INTO `ey_region` VALUES ('4673', '新城区', '3', '4671', 'X');
INSERT INTO `ey_region` VALUES ('4684', '回民区', '3', '4671', 'H');
INSERT INTO `ey_region` VALUES ('4693', '玉泉区', '3', '4671', 'Y');
INSERT INTO `ey_region` VALUES ('4702', '赛罕区', '3', '4671', 'S');
INSERT INTO `ey_region` VALUES ('4715', '土左旗', '3', '4671', 'T');
INSERT INTO `ey_region` VALUES ('4727', '托克托县', '3', '4671', 'T');
INSERT INTO `ey_region` VALUES ('4733', '和林格尔县', '3', '4671', 'H');
INSERT INTO `ey_region` VALUES ('4742', '清水河县', '3', '4671', 'Q');
INSERT INTO `ey_region` VALUES ('4749', '武川县', '3', '4671', 'W');
INSERT INTO `ey_region` VALUES ('4759', '包头市', '2', '4670', 'B');
INSERT INTO `ey_region` VALUES ('4760', '市辖区', '3', '4759', 'S');
INSERT INTO `ey_region` VALUES ('4761', '东河区', '3', '4759', 'D');
INSERT INTO `ey_region` VALUES ('4775', '昆都仑区', '3', '4759', 'K');
INSERT INTO `ey_region` VALUES ('4791', '青山区', '3', '4759', 'Q');
INSERT INTO `ey_region` VALUES ('4803', '石拐区', '3', '4759', 'S');
INSERT INTO `ey_region` VALUES ('4810', '白云鄂博矿区', '3', '4759', 'B');
INSERT INTO `ey_region` VALUES ('4813', '九原区', '3', '4759', 'J');
INSERT INTO `ey_region` VALUES ('4823', '土默特右旗', '3', '4759', 'T');
INSERT INTO `ey_region` VALUES ('4833', '固阳县', '3', '4759', 'G');
INSERT INTO `ey_region` VALUES ('4840', '达茂联合旗', '3', '4759', 'D');
INSERT INTO `ey_region` VALUES ('4849', '乌海市', '2', '4670', 'W');
INSERT INTO `ey_region` VALUES ('4850', '乌海市辖区', '3', '4849', 'W');
INSERT INTO `ey_region` VALUES ('4851', '海勃湾区', '3', '4849', 'H');
INSERT INTO `ey_region` VALUES ('4859', '海南区', '3', '4849', 'H');
INSERT INTO `ey_region` VALUES ('4865', '乌达区', '3', '4849', 'W');
INSERT INTO `ey_region` VALUES ('4874', '赤峰市', '2', '4670', 'C');
INSERT INTO `ey_region` VALUES ('4875', '市辖区', '3', '4874', 'S');
INSERT INTO `ey_region` VALUES ('4876', '红山区', '3', '4874', 'H');
INSERT INTO `ey_region` VALUES ('4888', '元宝山区', '3', '4874', 'Y');
INSERT INTO `ey_region` VALUES ('4896', '松山区', '3', '4874', 'S');
INSERT INTO `ey_region` VALUES ('4919', '阿鲁科尔沁旗', '3', '4874', 'A');
INSERT INTO `ey_region` VALUES ('4932', '巴林左旗', '3', '4874', 'B');
INSERT INTO `ey_region` VALUES ('4944', '巴林右旗', '3', '4874', 'B');
INSERT INTO `ey_region` VALUES ('4953', '林西县', '3', '4874', 'L');
INSERT INTO `ey_region` VALUES ('4963', '克什克腾旗', '3', '4874', 'K');
INSERT INTO `ey_region` VALUES ('4975', '翁牛特旗', '3', '4874', 'W');
INSERT INTO `ey_region` VALUES ('4988', '喀喇沁旗', '3', '4874', 'K');
INSERT INTO `ey_region` VALUES ('4999', '宁城县', '3', '4874', 'N');
INSERT INTO `ey_region` VALUES ('5013', '敖汉旗', '3', '4874', 'A');
INSERT INTO `ey_region` VALUES ('5029', '通辽市', '2', '4670', 'T');
INSERT INTO `ey_region` VALUES ('5030', '市辖区', '3', '5029', 'S');
INSERT INTO `ey_region` VALUES ('5031', '科尔沁区', '3', '5029', 'K');
INSERT INTO `ey_region` VALUES ('5062', '科尔沁左翼中旗', '3', '5029', 'K');
INSERT INTO `ey_region` VALUES ('5079', '科左后旗', '3', '5029', 'K');
INSERT INTO `ey_region` VALUES ('5104', '开鲁县', '3', '5029', 'K');
INSERT INTO `ey_region` VALUES ('5118', '库伦旗', '3', '5029', 'K');
INSERT INTO `ey_region` VALUES ('5125', '奈曼旗', '3', '5029', 'N');
INSERT INTO `ey_region` VALUES ('5139', '扎鲁特旗', '3', '5029', 'Z');
INSERT INTO `ey_region` VALUES ('5155', '霍林郭勒市', '3', '5029', 'H');
INSERT INTO `ey_region` VALUES ('5162', '鄂尔多斯市', '2', '4670', 'E');
INSERT INTO `ey_region` VALUES ('5163', '东胜区', '3', '5162', 'D');
INSERT INTO `ey_region` VALUES ('5176', '达拉特旗', '3', '5162', 'D');
INSERT INTO `ey_region` VALUES ('5185', '准格尔旗', '3', '5162', 'Z');
INSERT INTO `ey_region` VALUES ('5195', '鄂托克前旗', '3', '5162', 'E');
INSERT INTO `ey_region` VALUES ('5201', '鄂托克旗', '3', '5162', 'E');
INSERT INTO `ey_region` VALUES ('5210', '杭锦旗', '3', '5162', 'H');
INSERT INTO `ey_region` VALUES ('5219', '乌审旗', '3', '5162', 'W');
INSERT INTO `ey_region` VALUES ('5228', '伊金霍洛旗', '3', '5162', 'Y');
INSERT INTO `ey_region` VALUES ('5236', '呼伦贝尔市', '2', '4670', 'H');
INSERT INTO `ey_region` VALUES ('5237', '市辖区', '3', '5236', 'S');
INSERT INTO `ey_region` VALUES ('5238', '海拉尔区', '3', '5236', 'H');
INSERT INTO `ey_region` VALUES ('5249', '阿荣旗', '3', '5236', 'A');
INSERT INTO `ey_region` VALUES ('5262', '莫力达瓦旗', '3', '5236', 'M');
INSERT INTO `ey_region` VALUES ('5277', '鄂伦春旗', '3', '5236', 'E');
INSERT INTO `ey_region` VALUES ('5303', '鄂温旗', '3', '5236', 'E');
INSERT INTO `ey_region` VALUES ('5314', '陈巴尔虎旗镇', '3', '5236', 'C');
INSERT INTO `ey_region` VALUES ('5323', '新巴尔虎左旗', '3', '5236', 'X');
INSERT INTO `ey_region` VALUES ('5330', '新巴尔虎右旗', '3', '5236', 'X');
INSERT INTO `ey_region` VALUES ('5337', '满洲里市', '3', '5236', 'M');
INSERT INTO `ey_region` VALUES ('5354', '牙克石市', '3', '5236', 'Y');
INSERT INTO `ey_region` VALUES ('5371', '扎兰屯市', '3', '5236', 'Z');
INSERT INTO `ey_region` VALUES ('5397', '额尔古纳市', '3', '5236', 'E');
INSERT INTO `ey_region` VALUES ('5410', '根河市', '3', '5236', 'G');
INSERT INTO `ey_region` VALUES ('5418', '巴彦淖尔市', '2', '4670', 'B');
INSERT INTO `ey_region` VALUES ('5419', '市辖区', '3', '5418', 'S');
INSERT INTO `ey_region` VALUES ('5420', '临河区', '3', '5418', 'L');
INSERT INTO `ey_region` VALUES ('5440', '五原县', '3', '5418', 'W');
INSERT INTO `ey_region` VALUES ('5450', '磴口县', '3', '5418', 'D');
INSERT INTO `ey_region` VALUES ('5461', '乌拉特前旗', '3', '5418', 'W');
INSERT INTO `ey_region` VALUES ('5477', '乌拉特中旗', '3', '5418', 'W');
INSERT INTO `ey_region` VALUES ('5489', '乌拉特后旗', '3', '5418', 'W');
INSERT INTO `ey_region` VALUES ('5495', '杭锦后旗', '3', '5418', 'H');
INSERT INTO `ey_region` VALUES ('5505', '乌兰察布市', '2', '4670', 'W');
INSERT INTO `ey_region` VALUES ('5506', '市辖区', '3', '5505', 'S');
INSERT INTO `ey_region` VALUES ('5507', '集宁区', '3', '5505', 'J');
INSERT INTO `ey_region` VALUES ('5518', '卓资县', '3', '5505', 'Z');
INSERT INTO `ey_region` VALUES ('5526', '化德县', '3', '5505', 'H');
INSERT INTO `ey_region` VALUES ('5532', '商都县', '3', '5505', 'S');
INSERT INTO `ey_region` VALUES ('5542', '兴和县', '3', '5505', 'X');
INSERT INTO `ey_region` VALUES ('5551', '凉城县', '3', '5505', 'L');
INSERT INTO `ey_region` VALUES ('5562', '察哈尔右翼前旗', '3', '5505', 'C');
INSERT INTO `ey_region` VALUES ('5571', '察右中旗', '3', '5505', 'C');
INSERT INTO `ey_region` VALUES ('5582', '察哈尔右翼后旗', '3', '5505', 'C');
INSERT INTO `ey_region` VALUES ('5590', '四子王旗', '3', '5505', 'S');
INSERT INTO `ey_region` VALUES ('5603', '丰镇市', '3', '5505', 'F');
INSERT INTO `ey_region` VALUES ('5616', '兴安盟', '2', '4670', 'X');
INSERT INTO `ey_region` VALUES ('5617', '乌兰浩特市', '3', '5616', 'W');
INSERT INTO `ey_region` VALUES ('5629', '阿尔山市', '3', '5616', 'A');
INSERT INTO `ey_region` VALUES ('5636', '科右前旗', '3', '5616', 'K');
INSERT INTO `ey_region` VALUES ('5655', '科右中旗', '3', '5616', 'K');
INSERT INTO `ey_region` VALUES ('5677', '扎赉特旗', '3', '5616', 'Z');
INSERT INTO `ey_region` VALUES ('5692', '突泉县', '3', '5616', 'T');
INSERT INTO `ey_region` VALUES ('5702', '锡林郭勒盟', '2', '4670', 'X');
INSERT INTO `ey_region` VALUES ('5703', '二连浩特市', '3', '5702', 'E');
INSERT INTO `ey_region` VALUES ('5709', '锡林浩特市', '3', '5702', 'X');
INSERT INTO `ey_region` VALUES ('5723', '阿巴嘎旗', '3', '5702', 'A');
INSERT INTO `ey_region` VALUES ('5731', '苏尼特左旗', '3', '5702', 'S');
INSERT INTO `ey_region` VALUES ('5738', '苏尼特右旗', '3', '5702', 'S');
INSERT INTO `ey_region` VALUES ('5745', '东乌珠穆沁旗', '3', '5702', 'D');
INSERT INTO `ey_region` VALUES ('5758', '西乌珠穆沁旗', '3', '5702', 'X');
INSERT INTO `ey_region` VALUES ('5766', '太仆寺旗', '3', '5702', 'T');
INSERT INTO `ey_region` VALUES ('5774', '镶黄旗', '3', '5702', 'X');
INSERT INTO `ey_region` VALUES ('5778', '正镶白旗', '3', '5702', 'Z');
INSERT INTO `ey_region` VALUES ('5785', '正蓝旗', '3', '5702', 'Z');
INSERT INTO `ey_region` VALUES ('5794', '多伦县', '3', '5702', 'D');
INSERT INTO `ey_region` VALUES ('5799', '阿拉善盟', '2', '4670', 'A');
INSERT INTO `ey_region` VALUES ('5800', '阿拉善左旗', '3', '5799', 'A');
INSERT INTO `ey_region` VALUES ('5814', '阿拉善右旗', '3', '5799', 'A');
INSERT INTO `ey_region` VALUES ('5820', '额济纳旗', '3', '5799', 'E');
INSERT INTO `ey_region` VALUES ('5827', '辽宁省', '1', '0', 'L');
INSERT INTO `ey_region` VALUES ('5828', '沈阳市', '2', '5827', 'S');
INSERT INTO `ey_region` VALUES ('5829', '市辖区', '3', '5828', 'S');
INSERT INTO `ey_region` VALUES ('5830', '和平区', '3', '5828', 'H');
INSERT INTO `ey_region` VALUES ('5848', '沈河区', '3', '5828', 'S');
INSERT INTO `ey_region` VALUES ('5859', '大东区', '3', '5828', 'D');
INSERT INTO `ey_region` VALUES ('5873', '皇姑区', '3', '5828', 'H');
INSERT INTO `ey_region` VALUES ('5894', '铁西区', '3', '5828', 'T');
INSERT INTO `ey_region` VALUES ('5909', '苏家屯区', '3', '5828', 'S');
INSERT INTO `ey_region` VALUES ('5934', '东陵区', '3', '5828', 'D');
INSERT INTO `ey_region` VALUES ('5954', '新城子区', '3', '5828', 'X');
INSERT INTO `ey_region` VALUES ('5975', '于洪区', '3', '5828', 'Y');
INSERT INTO `ey_region` VALUES ('5998', '辽中县', '3', '5828', 'L');
INSERT INTO `ey_region` VALUES ('6020', '康平县', '3', '5828', 'K');
INSERT INTO `ey_region` VALUES ('6038', '法库县', '3', '5828', 'F');
INSERT INTO `ey_region` VALUES ('6058', '新民市', '3', '5828', 'X');
INSERT INTO `ey_region` VALUES ('6088', '大连市', '2', '5827', 'D');
INSERT INTO `ey_region` VALUES ('6089', '市辖区', '3', '6088', 'S');
INSERT INTO `ey_region` VALUES ('6090', '中山区', '3', '6088', 'Z');
INSERT INTO `ey_region` VALUES ('6099', '西岗区', '3', '6088', 'X');
INSERT INTO `ey_region` VALUES ('6107', '沙河口区', '3', '6088', 'S');
INSERT INTO `ey_region` VALUES ('6117', '甘井子区', '3', '6088', 'G');
INSERT INTO `ey_region` VALUES ('6137', '旅顺口区', '3', '6088', 'L');
INSERT INTO `ey_region` VALUES ('6153', '金州区', '3', '6088', 'J');
INSERT INTO `ey_region` VALUES ('6178', '长海县', '3', '6088', 'C');
INSERT INTO `ey_region` VALUES ('6184', '瓦房店市', '3', '6088', 'W');
INSERT INTO `ey_region` VALUES ('6217', '普兰店市', '3', '6088', 'P');
INSERT INTO `ey_region` VALUES ('6239', '庄河市', '3', '6088', 'Z');
INSERT INTO `ey_region` VALUES ('6266', '鞍山市', '2', '5827', 'A');
INSERT INTO `ey_region` VALUES ('6267', '市辖区', '3', '6266', 'S');
INSERT INTO `ey_region` VALUES ('6268', '铁东区', '3', '6266', 'T');
INSERT INTO `ey_region` VALUES ('6282', '铁西区', '3', '6266', 'T');
INSERT INTO `ey_region` VALUES ('6293', '立山区', '3', '6266', 'L');
INSERT INTO `ey_region` VALUES ('6303', '千山区', '3', '6266', 'Q');
INSERT INTO `ey_region` VALUES ('6316', '台安县', '3', '6266', 'T');
INSERT INTO `ey_region` VALUES ('6331', '岫岩县', '3', '6266', 'X');
INSERT INTO `ey_region` VALUES ('6354', '海城市', '3', '6266', 'H');
INSERT INTO `ey_region` VALUES ('6384', '抚顺市', '2', '5827', 'F');
INSERT INTO `ey_region` VALUES ('6385', '市辖区', '3', '6384', 'S');
INSERT INTO `ey_region` VALUES ('6386', '新抚区', '3', '6384', 'X');
INSERT INTO `ey_region` VALUES ('6395', '东洲区', '3', '6384', 'D');
INSERT INTO `ey_region` VALUES ('6409', '望花区', '3', '6384', 'W');
INSERT INTO `ey_region` VALUES ('6422', '顺城区', '3', '6384', 'S');
INSERT INTO `ey_region` VALUES ('6432', '抚顺县', '3', '6384', 'F');
INSERT INTO `ey_region` VALUES ('6445', '新宾县', '3', '6384', 'X');
INSERT INTO `ey_region` VALUES ('6461', '清原县', '3', '6384', 'Q');
INSERT INTO `ey_region` VALUES ('6476', '本溪市', '2', '5827', 'B');
INSERT INTO `ey_region` VALUES ('6477', '市辖区', '3', '6476', 'S');
INSERT INTO `ey_region` VALUES ('6478', '平山区', '3', '6476', 'P');
INSERT INTO `ey_region` VALUES ('6488', '溪湖区', '3', '6476', 'X');
INSERT INTO `ey_region` VALUES ('6499', '明山区', '3', '6476', 'M');
INSERT INTO `ey_region` VALUES ('6509', '南芬区', '3', '6476', 'N');
INSERT INTO `ey_region` VALUES ('6515', '本溪县', '3', '6476', 'B');
INSERT INTO `ey_region` VALUES ('6528', '桓仁县', '3', '6476', 'H');
INSERT INTO `ey_region` VALUES ('6542', '丹东市', '2', '5827', 'D');
INSERT INTO `ey_region` VALUES ('6543', '市辖区', '3', '6542', 'S');
INSERT INTO `ey_region` VALUES ('6544', '元宝区', '3', '6542', 'Y');
INSERT INTO `ey_region` VALUES ('6552', '振兴区', '3', '6542', 'Z');
INSERT INTO `ey_region` VALUES ('6563', '振安区', '3', '6542', 'Z');
INSERT INTO `ey_region` VALUES ('6573', '宽甸县', '3', '6542', 'K');
INSERT INTO `ey_region` VALUES ('6596', '东港市', '3', '6542', 'D');
INSERT INTO `ey_region` VALUES ('6621', '凤城市', '3', '6542', 'F');
INSERT INTO `ey_region` VALUES ('6643', '锦州市', '2', '5827', 'J');
INSERT INTO `ey_region` VALUES ('6644', '市辖区', '3', '6643', 'S');
INSERT INTO `ey_region` VALUES ('6645', '古塔区', '3', '6643', 'G');
INSERT INTO `ey_region` VALUES ('6655', '凌河区', '3', '6643', 'L');
INSERT INTO `ey_region` VALUES ('6668', '太和区', '3', '6643', 'T');
INSERT INTO `ey_region` VALUES ('6683', '黑山县', '3', '6643', 'H');
INSERT INTO `ey_region` VALUES ('6706', '义县', '3', '6643', 'Y');
INSERT INTO `ey_region` VALUES ('6725', '凌海市', '3', '6643', 'L');
INSERT INTO `ey_region` VALUES ('6750', '北镇市', '3', '6643', 'B');
INSERT INTO `ey_region` VALUES ('6771', '营口市', '2', '5827', 'Y');
INSERT INTO `ey_region` VALUES ('6772', '市辖区', '3', '6771', 'S');
INSERT INTO `ey_region` VALUES ('6773', '站前区', '3', '6771', 'Z');
INSERT INTO `ey_region` VALUES ('6781', '西市区', '3', '6771', 'X');
INSERT INTO `ey_region` VALUES ('6789', '鲅鱼圈区', '3', '6771', 'B');
INSERT INTO `ey_region` VALUES ('6797', '老边区', '3', '6771', 'L');
INSERT INTO `ey_region` VALUES ('6804', '盖州市', '3', '6771', 'G');
INSERT INTO `ey_region` VALUES ('6832', '大石桥市', '3', '6771', 'D');
INSERT INTO `ey_region` VALUES ('6851', '阜新市', '2', '5827', 'F');
INSERT INTO `ey_region` VALUES ('6852', '市辖区', '3', '6851', 'S');
INSERT INTO `ey_region` VALUES ('6853', '海州区', '3', '6851', 'H');
INSERT INTO `ey_region` VALUES ('6865', '新邱区', '3', '6851', 'X');
INSERT INTO `ey_region` VALUES ('6871', '太平区', '3', '6851', 'T');
INSERT INTO `ey_region` VALUES ('6878', '清河门区', '3', '6851', 'Q');
INSERT INTO `ey_region` VALUES ('6885', '细河区', '3', '6851', 'X');
INSERT INTO `ey_region` VALUES ('6893', '阜新县', '3', '6851', 'F');
INSERT INTO `ey_region` VALUES ('6930', '彰武县', '3', '6851', 'Z');
INSERT INTO `ey_region` VALUES ('6955', '辽阳市', '2', '5827', 'L');
INSERT INTO `ey_region` VALUES ('6956', '市辖区', '3', '6955', 'S');
INSERT INTO `ey_region` VALUES ('6957', '白塔区', '3', '6955', 'B');
INSERT INTO `ey_region` VALUES ('6964', '文圣区', '3', '6955', 'W');
INSERT INTO `ey_region` VALUES ('6971', '宏伟区', '3', '6955', 'H');
INSERT INTO `ey_region` VALUES ('6977', '弓长岭区', '3', '6955', 'G');
INSERT INTO `ey_region` VALUES ('6983', '太子河区', '3', '6955', 'T');
INSERT INTO `ey_region` VALUES ('6989', '辽阳县', '3', '6955', 'L');
INSERT INTO `ey_region` VALUES ('7007', '灯塔市', '3', '6955', 'D');
INSERT INTO `ey_region` VALUES ('7024', '盘锦市', '2', '5827', 'P');
INSERT INTO `ey_region` VALUES ('7025', '市辖区', '3', '7024', 'S');
INSERT INTO `ey_region` VALUES ('7026', '双台子区', '3', '7024', 'S');
INSERT INTO `ey_region` VALUES ('7036', '兴隆台区', '3', '7024', 'X');
INSERT INTO `ey_region` VALUES ('7055', '大洼县', '3', '7024', 'D');
INSERT INTO `ey_region` VALUES ('7072', '盘山县', '3', '7024', 'P');
INSERT INTO `ey_region` VALUES ('7088', '铁岭市', '2', '5827', 'T');
INSERT INTO `ey_region` VALUES ('7089', '市辖区', '3', '7088', 'S');
INSERT INTO `ey_region` VALUES ('7090', '银州区', '3', '7088', 'Y');
INSERT INTO `ey_region` VALUES ('7099', '清河区', '3', '7088', 'Q');
INSERT INTO `ey_region` VALUES ('7105', '铁岭县', '3', '7088', 'T');
INSERT INTO `ey_region` VALUES ('7121', '西丰县', '3', '7088', 'X');
INSERT INTO `ey_region` VALUES ('7140', '昌图县', '3', '7088', 'C');
INSERT INTO `ey_region` VALUES ('7180', '调兵山市', '3', '7088', 'D');
INSERT INTO `ey_region` VALUES ('7186', '开原市', '3', '7088', 'K');
INSERT INTO `ey_region` VALUES ('7208', '朝阳市', '2', '5827', 'C');
INSERT INTO `ey_region` VALUES ('7209', '市辖区', '3', '7208', 'S');
INSERT INTO `ey_region` VALUES ('7210', '双塔区', '3', '7208', 'S');
INSERT INTO `ey_region` VALUES ('7225', '龙城区', '3', '7208', 'L');
INSERT INTO `ey_region` VALUES ('7238', '朝阳县', '3', '7208', 'C');
INSERT INTO `ey_region` VALUES ('7267', '建平县', '3', '7208', 'J');
INSERT INTO `ey_region` VALUES ('7299', '喀喇沁左翼县', '3', '7208', 'K');
INSERT INTO `ey_region` VALUES ('7322', '北票市', '3', '7208', 'B');
INSERT INTO `ey_region` VALUES ('7360', '凌源市', '3', '7208', 'L');
INSERT INTO `ey_region` VALUES ('7391', '葫芦岛市', '2', '5827', 'H');
INSERT INTO `ey_region` VALUES ('7392', '市辖区', '3', '7391', 'S');
INSERT INTO `ey_region` VALUES ('7393', '连山区', '3', '7391', 'L');
INSERT INTO `ey_region` VALUES ('7419', '龙港区', '3', '7391', 'L');
INSERT INTO `ey_region` VALUES ('7433', '南票区', '3', '7391', 'N');
INSERT INTO `ey_region` VALUES ('7446', '绥中县', '3', '7391', 'S');
INSERT INTO `ey_region` VALUES ('7474', '建昌县', '3', '7391', 'J');
INSERT INTO `ey_region` VALUES ('7503', '兴城市', '3', '7391', 'X');
INSERT INTO `ey_region` VALUES ('7531', '吉林省', '1', '0', 'J');
INSERT INTO `ey_region` VALUES ('7532', '长春市', '2', '7531', 'C');
INSERT INTO `ey_region` VALUES ('7533', '长春市辖区', '3', '7532', 'C');
INSERT INTO `ey_region` VALUES ('7534', '南关区', '3', '7532', 'N');
INSERT INTO `ey_region` VALUES ('7552', '宽城区', '3', '7532', 'K');
INSERT INTO `ey_region` VALUES ('7569', '朝阳区', '3', '7532', 'C');
INSERT INTO `ey_region` VALUES ('7582', '二道区', '3', '7532', 'E');
INSERT INTO `ey_region` VALUES ('7597', '绿园区', '3', '7532', 'L');
INSERT INTO `ey_region` VALUES ('7610', '双阳区', '3', '7532', 'S');
INSERT INTO `ey_region` VALUES ('7619', '农安县', '3', '7532', 'N');
INSERT INTO `ey_region` VALUES ('7642', '九台市', '3', '7532', 'J');
INSERT INTO `ey_region` VALUES ('7658', '榆树市', '3', '7532', 'Y');
INSERT INTO `ey_region` VALUES ('7687', '德惠市', '3', '7532', 'D');
INSERT INTO `ey_region` VALUES ('7706', '吉林市', '2', '7531', 'J');
INSERT INTO `ey_region` VALUES ('7707', '吉林市辖区', '3', '7706', 'J');
INSERT INTO `ey_region` VALUES ('7708', '昌邑区', '3', '7706', 'C');
INSERT INTO `ey_region` VALUES ('7731', '龙潭区', '3', '7706', 'L');
INSERT INTO `ey_region` VALUES ('7752', '船营区', '3', '7706', 'C');
INSERT INTO `ey_region` VALUES ('7768', '丰满区', '3', '7706', 'F');
INSERT INTO `ey_region` VALUES ('7781', '永吉县', '3', '7706', 'Y');
INSERT INTO `ey_region` VALUES ('7792', '蛟河市', '3', '7706', 'J');
INSERT INTO `ey_region` VALUES ('7810', '桦甸市', '3', '7706', 'H');
INSERT INTO `ey_region` VALUES ('7828', '舒兰市', '3', '7706', 'S');
INSERT INTO `ey_region` VALUES ('7849', '磐石市', '3', '7706', 'P');
INSERT INTO `ey_region` VALUES ('7868', '四平市', '2', '7531', 'S');
INSERT INTO `ey_region` VALUES ('7869', '四平市辖区', '3', '7868', 'S');
INSERT INTO `ey_region` VALUES ('7870', '铁西区', '3', '7868', 'T');
INSERT INTO `ey_region` VALUES ('7878', '铁东区', '3', '7868', 'T');
INSERT INTO `ey_region` VALUES ('7892', '梨树县', '3', '7868', 'L');
INSERT INTO `ey_region` VALUES ('7916', '伊通县', '3', '7868', 'Y');
INSERT INTO `ey_region` VALUES ('7933', '公主岭市', '3', '7868', 'G');
INSERT INTO `ey_region` VALUES ('7964', '双辽市', '3', '7868', 'S');
INSERT INTO `ey_region` VALUES ('7986', '辽源市', '2', '7531', 'L');
INSERT INTO `ey_region` VALUES ('7987', '辽源市辖区', '3', '7986', 'L');
INSERT INTO `ey_region` VALUES ('7988', '龙山区', '3', '7986', 'L');
INSERT INTO `ey_region` VALUES ('8000', '西安区', '3', '7986', 'X');
INSERT INTO `ey_region` VALUES ('8008', '东丰县', '3', '7986', 'D');
INSERT INTO `ey_region` VALUES ('8023', '东辽县', '3', '7986', 'D');
INSERT INTO `ey_region` VALUES ('8037', '通化市', '2', '7531', 'T');
INSERT INTO `ey_region` VALUES ('8038', '通化市辖区', '3', '8037', 'T');
INSERT INTO `ey_region` VALUES ('8039', '东昌区', '3', '8037', 'D');
INSERT INTO `ey_region` VALUES ('8051', '二道江区', '3', '8037', 'E');
INSERT INTO `ey_region` VALUES ('8058', '通化县', '3', '8037', 'T');
INSERT INTO `ey_region` VALUES ('8076', '辉南县', '3', '8037', 'H');
INSERT INTO `ey_region` VALUES ('8088', '柳河县', '3', '8037', 'L');
INSERT INTO `ey_region` VALUES ('8104', '梅河口市', '3', '8037', 'M');
INSERT INTO `ey_region` VALUES ('8129', '集安市', '3', '8037', 'J');
INSERT INTO `ey_region` VALUES ('8144', '白山市', '2', '7531', 'B');
INSERT INTO `ey_region` VALUES ('8145', '白山市辖区', '3', '8144', 'B');
INSERT INTO `ey_region` VALUES ('8146', '八道江区', '3', '8144', 'B');
INSERT INTO `ey_region` VALUES ('8159', '江源区', '3', '8144', 'J');
INSERT INTO `ey_region` VALUES ('8168', '抚松县', '3', '8144', 'F');
INSERT INTO `ey_region` VALUES ('8183', '靖宇县', '3', '8144', 'J');
INSERT INTO `ey_region` VALUES ('8192', '长白县', '3', '8144', 'C');
INSERT INTO `ey_region` VALUES ('8202', '临江市', '3', '8144', 'L');
INSERT INTO `ey_region` VALUES ('8216', '松原市', '2', '7531', 'S');
INSERT INTO `ey_region` VALUES ('8217', '松原市辖区', '3', '8216', 'S');
INSERT INTO `ey_region` VALUES ('8218', '宁江区', '3', '8216', 'N');
INSERT INTO `ey_region` VALUES ('8239', '前郭县', '3', '8216', 'Q');
INSERT INTO `ey_region` VALUES ('8266', '长岭县', '3', '8216', 'C');
INSERT INTO `ey_region` VALUES ('8300', '乾安县', '3', '8216', 'Q');
INSERT INTO `ey_region` VALUES ('8311', '扶余县', '3', '8216', 'F');
INSERT INTO `ey_region` VALUES ('8333', '白城市', '2', '7531', 'B');
INSERT INTO `ey_region` VALUES ('8334', '白城市辖区', '3', '8333', 'B');
INSERT INTO `ey_region` VALUES ('8335', '洮北区', '3', '8333', 'T');
INSERT INTO `ey_region` VALUES ('8362', '镇赉县', '3', '8333', 'Z');
INSERT INTO `ey_region` VALUES ('8375', '通榆县', '3', '8333', 'T');
INSERT INTO `ey_region` VALUES ('8393', '洮南市', '3', '8333', 'T');
INSERT INTO `ey_region` VALUES ('8420', '大安市', '3', '8333', 'D');
INSERT INTO `ey_region` VALUES ('8445', '延边州', '2', '7531', 'Y');
INSERT INTO `ey_region` VALUES ('8446', '延吉市', '3', '8445', 'Y');
INSERT INTO `ey_region` VALUES ('8456', '图们市', '3', '8445', 'T');
INSERT INTO `ey_region` VALUES ('8464', '敦化市', '3', '8445', 'D');
INSERT INTO `ey_region` VALUES ('8489', '珲春市', '3', '8445', 'H');
INSERT INTO `ey_region` VALUES ('8504', '龙井市', '3', '8445', 'L');
INSERT INTO `ey_region` VALUES ('8515', '和龙市', '3', '8445', 'H');
INSERT INTO `ey_region` VALUES ('8530', '汪清县', '3', '8445', 'W');
INSERT INTO `ey_region` VALUES ('8545', '安图县', '3', '8445', 'A');
INSERT INTO `ey_region` VALUES ('8558', '黑龙江省', '1', '0', 'H');
INSERT INTO `ey_region` VALUES ('8559', '哈尔滨市', '2', '8558', 'H');
INSERT INTO `ey_region` VALUES ('8560', '市辖区', '3', '8559', 'S');
INSERT INTO `ey_region` VALUES ('8561', '道里区', '3', '8559', 'D');
INSERT INTO `ey_region` VALUES ('8585', '南岗区', '3', '8559', 'N');
INSERT INTO `ey_region` VALUES ('8606', '道外区', '3', '8559', 'D');
INSERT INTO `ey_region` VALUES ('8633', '平房区', '3', '8559', 'P');
INSERT INTO `ey_region` VALUES ('8642', '松北区', '3', '8559', 'S');
INSERT INTO `ey_region` VALUES ('8650', '香坊区', '3', '8559', 'X');
INSERT INTO `ey_region` VALUES ('8676', '呼兰区', '3', '8559', 'H');
INSERT INTO `ey_region` VALUES ('8694', '阿城区', '3', '8559', 'A');
INSERT INTO `ey_region` VALUES ('8714', '依兰县', '3', '8559', 'Y');
INSERT INTO `ey_region` VALUES ('8729', '方正县', '3', '8559', 'F');
INSERT INTO `ey_region` VALUES ('8740', '宾县', '3', '8559', 'B');
INSERT INTO `ey_region` VALUES ('8758', '巴彦县', '3', '8559', 'B');
INSERT INTO `ey_region` VALUES ('8778', '木兰县', '3', '8559', 'M');
INSERT INTO `ey_region` VALUES ('8788', '通河县', '3', '8559', 'T');
INSERT INTO `ey_region` VALUES ('8800', '延寿县', '3', '8559', 'Y');
INSERT INTO `ey_region` VALUES ('8812', '双城市', '3', '8559', 'S');
INSERT INTO `ey_region` VALUES ('8838', '尚志市', '3', '8559', 'S');
INSERT INTO `ey_region` VALUES ('8858', '五常市', '3', '8559', 'W');
INSERT INTO `ey_region` VALUES ('8884', '齐齐哈尔市', '2', '8558', 'Q');
INSERT INTO `ey_region` VALUES ('8885', '市辖区', '3', '8884', 'S');
INSERT INTO `ey_region` VALUES ('8886', '龙沙区', '3', '8884', 'L');
INSERT INTO `ey_region` VALUES ('8894', '建华区', '3', '8884', 'J');
INSERT INTO `ey_region` VALUES ('8901', '铁锋区', '3', '8884', 'T');
INSERT INTO `ey_region` VALUES ('8911', '昂昂溪区', '3', '8884', 'A');
INSERT INTO `ey_region` VALUES ('8918', '富拉尔基区', '3', '8884', 'F');
INSERT INTO `ey_region` VALUES ('8928', '碾子山区', '3', '8884', 'N');
INSERT INTO `ey_region` VALUES ('8934', '梅里斯达斡尔族区', '3', '8884', 'M');
INSERT INTO `ey_region` VALUES ('8943', '龙江县', '3', '8884', 'L');
INSERT INTO `ey_region` VALUES ('8958', '依安县', '3', '8884', 'Y');
INSERT INTO `ey_region` VALUES ('8976', '泰来县', '3', '8884', 'T');
INSERT INTO `ey_region` VALUES ('8998', '甘南县', '3', '8884', 'G');
INSERT INTO `ey_region` VALUES ('9011', '富裕县', '3', '8884', 'F');
INSERT INTO `ey_region` VALUES ('9024', '克山县', '3', '8884', 'K');
INSERT INTO `ey_region` VALUES ('9048', '克东县', '3', '8884', 'K');
INSERT INTO `ey_region` VALUES ('9067', '拜泉县', '3', '8884', 'B');
INSERT INTO `ey_region` VALUES ('9084', '讷河市', '3', '8884', 'N');
INSERT INTO `ey_region` VALUES ('9117', '鸡西市', '2', '8558', 'J');
INSERT INTO `ey_region` VALUES ('9118', '市辖区', '3', '9117', 'S');
INSERT INTO `ey_region` VALUES ('9119', '鸡冠区', '3', '9117', 'J');
INSERT INTO `ey_region` VALUES ('9129', '恒山区', '3', '9117', 'H');
INSERT INTO `ey_region` VALUES ('9139', '滴道区', '3', '9117', 'D');
INSERT INTO `ey_region` VALUES ('9146', '梨树区', '3', '9117', 'L');
INSERT INTO `ey_region` VALUES ('9153', '城子河区', '3', '9117', 'C');
INSERT INTO `ey_region` VALUES ('9161', '麻山区', '3', '9117', 'M');
INSERT INTO `ey_region` VALUES ('9164', '鸡东县', '3', '9117', 'J');
INSERT INTO `ey_region` VALUES ('9178', '虎林市', '3', '9117', 'H');
INSERT INTO `ey_region` VALUES ('9199', '密山市', '3', '9117', 'M');
INSERT INTO `ey_region` VALUES ('9222', '鹤岗市', '2', '8558', 'H');
INSERT INTO `ey_region` VALUES ('9223', '市辖区', '3', '9222', 'S');
INSERT INTO `ey_region` VALUES ('9224', '向阳区', '3', '9222', 'X');
INSERT INTO `ey_region` VALUES ('9230', '工农区', '3', '9222', 'G');
INSERT INTO `ey_region` VALUES ('9237', '南山区', '3', '9222', 'N');
INSERT INTO `ey_region` VALUES ('9244', '兴安区', '3', '9222', 'X');
INSERT INTO `ey_region` VALUES ('9250', '东山区', '3', '9222', 'D');
INSERT INTO `ey_region` VALUES ('9261', '兴山区', '3', '9222', 'X');
INSERT INTO `ey_region` VALUES ('9266', '萝北县', '3', '9222', 'L');
INSERT INTO `ey_region` VALUES ('9283', '绥滨县', '3', '9222', 'S');
INSERT INTO `ey_region` VALUES ('9296', '双鸭山市', '2', '8558', 'S');
INSERT INTO `ey_region` VALUES ('9297', '市辖区', '3', '9296', 'S');
INSERT INTO `ey_region` VALUES ('9298', '尖山区', '3', '9296', 'J');
INSERT INTO `ey_region` VALUES ('9307', '岭东区', '3', '9296', 'L');
INSERT INTO `ey_region` VALUES ('9317', '四方台区', '3', '9296', 'S');
INSERT INTO `ey_region` VALUES ('9323', '宝山区', '3', '9296', 'B');
INSERT INTO `ey_region` VALUES ('9335', '集贤县', '3', '9296', 'J');
INSERT INTO `ey_region` VALUES ('9356', '友谊县', '3', '9296', 'Y');
INSERT INTO `ey_region` VALUES ('9370', '宝清县', '3', '9296', 'B');
INSERT INTO `ey_region` VALUES ('9393', '饶河县', '3', '9296', 'R');
INSERT INTO `ey_region` VALUES ('9419', '大庆市', '2', '8558', 'D');
INSERT INTO `ey_region` VALUES ('9420', '市辖区', '3', '9419', 'S');
INSERT INTO `ey_region` VALUES ('9421', '萨尔图区', '3', '9419', 'S');
INSERT INTO `ey_region` VALUES ('9431', '龙凤区', '3', '9419', 'L');
INSERT INTO `ey_region` VALUES ('9440', '让胡路区', '3', '9419', 'R');
INSERT INTO `ey_region` VALUES ('9451', '红岗区', '3', '9419', 'H');
INSERT INTO `ey_region` VALUES ('9458', '大同区', '3', '9419', 'D');
INSERT INTO `ey_region` VALUES ('9474', '肇州县', '3', '9419', 'Z');
INSERT INTO `ey_region` VALUES ('9489', '肇源县', '3', '9419', 'Z');
INSERT INTO `ey_region` VALUES ('9514', '林甸县', '3', '9419', 'L');
INSERT INTO `ey_region` VALUES ('9527', '杜尔伯特县', '3', '9419', 'D');
INSERT INTO `ey_region` VALUES ('9553', '伊春市', '2', '8558', 'Y');
INSERT INTO `ey_region` VALUES ('9554', '市辖区', '3', '9553', 'S');
INSERT INTO `ey_region` VALUES ('9555', '伊春区', '3', '9553', 'Y');
INSERT INTO `ey_region` VALUES ('9561', '南岔区', '3', '9553', 'N');
INSERT INTO `ey_region` VALUES ('9581', '友好区', '3', '9553', 'Y');
INSERT INTO `ey_region` VALUES ('9599', '西林区', '3', '9553', 'X');
INSERT INTO `ey_region` VALUES ('9603', '翠峦区', '3', '9553', 'C');
INSERT INTO `ey_region` VALUES ('9614', '新青区', '3', '9553', 'X');
INSERT INTO `ey_region` VALUES ('9631', '美溪区', '3', '9553', 'M');
INSERT INTO `ey_region` VALUES ('9647', '金山屯区', '3', '9553', 'J');
INSERT INTO `ey_region` VALUES ('9660', '五营区', '3', '9553', 'W');
INSERT INTO `ey_region` VALUES ('9671', '乌马河区', '3', '9553', 'W');
INSERT INTO `ey_region` VALUES ('9685', '汤旺河区', '3', '9553', 'T');
INSERT INTO `ey_region` VALUES ('9702', '带岭区', '3', '9553', 'D');
INSERT INTO `ey_region` VALUES ('9715', '乌伊岭区', '3', '9553', 'W');
INSERT INTO `ey_region` VALUES ('9729', '红星区', '3', '9553', 'H');
INSERT INTO `ey_region` VALUES ('9742', '上甘岭区', '3', '9553', 'S');
INSERT INTO `ey_region` VALUES ('9756', '嘉荫县', '3', '9553', 'J');
INSERT INTO `ey_region` VALUES ('9772', '铁力市', '3', '9553', 'T');
INSERT INTO `ey_region` VALUES ('9785', '佳木斯市', '2', '8558', 'J');
INSERT INTO `ey_region` VALUES ('9786', '市辖区', '3', '9785', 'S');
INSERT INTO `ey_region` VALUES ('9787', '向阳区', '3', '9785', 'X');
INSERT INTO `ey_region` VALUES ('9795', '前进区', '3', '9785', 'Q');
INSERT INTO `ey_region` VALUES ('9802', '东风区', '3', '9785', 'D');
INSERT INTO `ey_region` VALUES ('9810', '郊区', '3', '9785', 'J');
INSERT INTO `ey_region` VALUES ('9825', '桦南县', '3', '9785', 'H');
INSERT INTO `ey_region` VALUES ('9839', '桦川县', '3', '9785', 'H');
INSERT INTO `ey_region` VALUES ('9851', '汤原县', '3', '9785', 'T');
INSERT INTO `ey_region` VALUES ('9866', '抚远县', '3', '9785', 'F');
INSERT INTO `ey_region` VALUES ('9879', '同江市', '3', '9785', 'T');
INSERT INTO `ey_region` VALUES ('9907', '富锦市', '3', '9785', 'F');
INSERT INTO `ey_region` VALUES ('9930', '七台河市', '2', '8558', 'Q');
INSERT INTO `ey_region` VALUES ('9931', '市辖区', '3', '9930', 'S');
INSERT INTO `ey_region` VALUES ('9932', '新兴区', '3', '9930', 'X');
INSERT INTO `ey_region` VALUES ('9944', '桃山区', '3', '9930', 'T');
INSERT INTO `ey_region` VALUES ('9952', '茄子河区', '3', '9930', 'Q');
INSERT INTO `ey_region` VALUES ('9962', '勃利县', '3', '9930', 'B');
INSERT INTO `ey_region` VALUES ('9981', '牡丹江市', '2', '8558', 'M');
INSERT INTO `ey_region` VALUES ('9982', '市辖区', '3', '9981', 'S');
INSERT INTO `ey_region` VALUES ('9983', '东安区', '3', '9981', 'D');
INSERT INTO `ey_region` VALUES ('9989', '阳明区', '3', '9981', 'Y');
INSERT INTO `ey_region` VALUES ('9996', '爱民区', '3', '9981', 'A');
INSERT INTO `ey_region` VALUES ('10005', '西安区', '3', '9981', 'X');
INSERT INTO `ey_region` VALUES ('10014', '东宁县', '3', '9981', 'D');
INSERT INTO `ey_region` VALUES ('10022', '林口县', '3', '9981', 'L');
INSERT INTO `ey_region` VALUES ('10036', '绥芬河市', '3', '9981', 'S');
INSERT INTO `ey_region` VALUES ('10039', '海林市', '3', '9981', 'H');
INSERT INTO `ey_region` VALUES ('10056', '宁安市', '3', '9981', 'N');
INSERT INTO `ey_region` VALUES ('10072', '穆棱市', '3', '9981', 'M');
INSERT INTO `ey_region` VALUES ('10084', '黑河市', '2', '8558', 'H');
INSERT INTO `ey_region` VALUES ('10085', '市辖区', '3', '10084', 'S');
INSERT INTO `ey_region` VALUES ('10086', '爱辉区', '3', '10084', 'A');
INSERT INTO `ey_region` VALUES ('10122', '嫩江县', '3', '10084', 'N');
INSERT INTO `ey_region` VALUES ('10150', '逊克县', '3', '10084', 'X');
INSERT INTO `ey_region` VALUES ('10168', '孙吴县', '3', '10084', 'S');
INSERT INTO `ey_region` VALUES ('10192', '北安市', '3', '10084', 'B');
INSERT INTO `ey_region` VALUES ('10214', '五大连池市', '3', '10084', 'W');
INSERT INTO `ey_region` VALUES ('10252', '绥化市', '2', '8558', 'S');
INSERT INTO `ey_region` VALUES ('10253', '市辖区', '3', '10252', 'S');
INSERT INTO `ey_region` VALUES ('10254', '北林区', '3', '10252', 'B');
INSERT INTO `ey_region` VALUES ('10281', '望奎县', '3', '10252', 'W');
INSERT INTO `ey_region` VALUES ('10301', '兰西县', '3', '10252', 'L');
INSERT INTO `ey_region` VALUES ('10320', '青冈县', '3', '10252', 'Q');
INSERT INTO `ey_region` VALUES ('10342', '庆安县', '3', '10252', 'Q');
INSERT INTO `ey_region` VALUES ('10360', '明水县', '3', '10252', 'M');
INSERT INTO `ey_region` VALUES ('10380', '绥棱县', '3', '10252', 'S');
INSERT INTO `ey_region` VALUES ('10401', '安达市', '3', '10252', 'A');
INSERT INTO `ey_region` VALUES ('10425', '肇东市', '3', '10252', 'Z');
INSERT INTO `ey_region` VALUES ('10452', '海伦市', '3', '10252', 'H');
INSERT INTO `ey_region` VALUES ('10483', '大兴安岭地区', '2', '8558', 'D');
INSERT INTO `ey_region` VALUES ('10484', '加格达奇区', '3', '10483', 'J');
INSERT INTO `ey_region` VALUES ('10495', '松岭区', '3', '10483', 'S');
INSERT INTO `ey_region` VALUES ('10500', '新林区', '3', '10483', 'X');
INSERT INTO `ey_region` VALUES ('10509', '呼中区', '3', '10483', 'H');
INSERT INTO `ey_region` VALUES ('10515', '呼玛县', '3', '10483', 'H');
INSERT INTO `ey_region` VALUES ('10525', '塔河县', '3', '10483', 'T');
INSERT INTO `ey_region` VALUES ('10534', '漠河县', '3', '10483', 'M');
INSERT INTO `ey_region` VALUES ('10543', '上海市', '1', '0', 'S');
INSERT INTO `ey_region` VALUES ('10544', '上海市', '2', '10543', 'S');
INSERT INTO `ey_region` VALUES ('10545', '黄浦区', '3', '10544', 'H');
INSERT INTO `ey_region` VALUES ('10555', '卢湾区', '3', '10544', 'L');
INSERT INTO `ey_region` VALUES ('10560', '徐汇区', '3', '10544', 'X');
INSERT INTO `ey_region` VALUES ('10575', '长宁区', '3', '10544', 'C');
INSERT INTO `ey_region` VALUES ('10586', '静安区', '3', '10544', 'J');
INSERT INTO `ey_region` VALUES ('10592', '普陀区', '3', '10544', 'P');
INSERT INTO `ey_region` VALUES ('10602', '闸北区', '3', '10544', 'Z');
INSERT INTO `ey_region` VALUES ('10612', '虹口区', '3', '10544', 'H');
INSERT INTO `ey_region` VALUES ('10623', '杨浦区', '3', '10544', 'Y');
INSERT INTO `ey_region` VALUES ('10636', '闵行区', '3', '10544', 'M');
INSERT INTO `ey_region` VALUES ('10650', '宝山区', '3', '10544', 'B');
INSERT INTO `ey_region` VALUES ('10664', '嘉定区', '3', '10544', 'J');
INSERT INTO `ey_region` VALUES ('10678', '浦东新区', '3', '10544', 'P');
INSERT INTO `ey_region` VALUES ('10704', '金山区', '3', '10544', 'J');
INSERT INTO `ey_region` VALUES ('10715', '松江区', '3', '10544', 'S');
INSERT INTO `ey_region` VALUES ('10735', '青浦区', '3', '10544', 'Q');
INSERT INTO `ey_region` VALUES ('10747', '南汇区', '3', '10544', 'N');
INSERT INTO `ey_region` VALUES ('10765', '奉贤区', '3', '10544', 'F');
INSERT INTO `ey_region` VALUES ('10780', '崇明区', '3', '10544', 'C');
INSERT INTO `ey_region` VALUES ('10808', '江苏省', '1', '0', 'J');
INSERT INTO `ey_region` VALUES ('10809', '南京市', '2', '10808', 'N');
INSERT INTO `ey_region` VALUES ('10810', '市辖区', '3', '10809', 'S');
INSERT INTO `ey_region` VALUES ('10811', '玄武区', '3', '10809', 'X');
INSERT INTO `ey_region` VALUES ('10820', '白下区', '3', '10809', 'B');
INSERT INTO `ey_region` VALUES ('10831', '秦淮区', '3', '10809', 'Q');
INSERT INTO `ey_region` VALUES ('10837', '建邺区', '3', '10809', 'J');
INSERT INTO `ey_region` VALUES ('10845', '鼓楼区', '3', '10809', 'G');
INSERT INTO `ey_region` VALUES ('10853', '下关区', '3', '10809', 'X');
INSERT INTO `ey_region` VALUES ('10860', '浦口区', '3', '10809', 'P');
INSERT INTO `ey_region` VALUES ('10876', '栖霞区', '3', '10809', 'Q');
INSERT INTO `ey_region` VALUES ('10894', '雨花台区', '3', '10809', 'Y');
INSERT INTO `ey_region` VALUES ('10903', '江宁区', '3', '10809', 'J');
INSERT INTO `ey_region` VALUES ('10916', '六合区', '3', '10809', 'L');
INSERT INTO `ey_region` VALUES ('10937', '溧水县', '3', '10809', 'L');
INSERT INTO `ey_region` VALUES ('10947', '高淳县', '3', '10809', 'G');
INSERT INTO `ey_region` VALUES ('10960', '无锡市', '2', '10808', 'W');
INSERT INTO `ey_region` VALUES ('10961', '市辖区', '3', '10960', 'S');
INSERT INTO `ey_region` VALUES ('10962', '崇安区', '3', '10960', 'C');
INSERT INTO `ey_region` VALUES ('10969', '南长区', '3', '10960', 'N');
INSERT INTO `ey_region` VALUES ('10976', '北塘区', '3', '10960', 'B');
INSERT INTO `ey_region` VALUES ('10981', '锡山区', '3', '10960', 'X');
INSERT INTO `ey_region` VALUES ('10990', '惠山区', '3', '10960', 'H');
INSERT INTO `ey_region` VALUES ('10999', '滨湖区', '3', '10960', 'B');
INSERT INTO `ey_region` VALUES ('11018', '江阴市', '3', '10960', 'J');
INSERT INTO `ey_region` VALUES ('11039', '宜兴市', '3', '10960', 'Y');
INSERT INTO `ey_region` VALUES ('11067', '徐州市', '2', '10808', 'X');
INSERT INTO `ey_region` VALUES ('11068', '市辖区', '3', '11067', 'S');
INSERT INTO `ey_region` VALUES ('11069', '鼓楼区', '3', '11067', 'G');
INSERT INTO `ey_region` VALUES ('11081', '云龙区', '3', '11067', 'Y');
INSERT INTO `ey_region` VALUES ('11089', '九里区', '3', '11067', 'J');
INSERT INTO `ey_region` VALUES ('11103', '贾汪区', '3', '11067', 'J');
INSERT INTO `ey_region` VALUES ('11115', '泉山区', '3', '11067', 'Q');
INSERT INTO `ey_region` VALUES ('11126', '丰县', '3', '11067', 'F');
INSERT INTO `ey_region` VALUES ('11142', '沛县', '3', '11067', 'P');
INSERT INTO `ey_region` VALUES ('11160', '铜山县', '3', '11067', 'T');
INSERT INTO `ey_region` VALUES ('11182', '睢宁县', '3', '11067', 'S');
INSERT INTO `ey_region` VALUES ('11200', '新沂市', '3', '11067', 'X');
INSERT INTO `ey_region` VALUES ('11218', '邳州市', '3', '11067', 'P');
INSERT INTO `ey_region` VALUES ('11245', '常州市', '2', '10808', 'C');
INSERT INTO `ey_region` VALUES ('11246', '常州市区', '3', '11245', 'C');
INSERT INTO `ey_region` VALUES ('11247', '天宁区', '3', '11245', 'T');
INSERT INTO `ey_region` VALUES ('11254', '钟楼区', '3', '11245', 'Z');
INSERT INTO `ey_region` VALUES ('11262', '戚墅堰区', '3', '11245', 'Q');
INSERT INTO `ey_region` VALUES ('11266', '新北区', '3', '11245', 'X');
INSERT INTO `ey_region` VALUES ('11276', '武进区', '3', '11245', 'W');
INSERT INTO `ey_region` VALUES ('11311', '溧阳市', '3', '11245', 'L');
INSERT INTO `ey_region` VALUES ('11331', '金坛市', '3', '11245', 'J');
INSERT INTO `ey_region` VALUES ('11348', '苏州市', '2', '10808', 'S');
INSERT INTO `ey_region` VALUES ('11349', '市辖区', '3', '11348', 'S');
INSERT INTO `ey_region` VALUES ('11350', '沧浪区', '3', '11348', 'C');
INSERT INTO `ey_region` VALUES ('11357', '平江区', '3', '11348', 'P');
INSERT INTO `ey_region` VALUES ('11368', '金阊区', '3', '11348', 'J');
INSERT INTO `ey_region` VALUES ('11374', '苏州高新区虎丘区', '3', '11348', 'S');
INSERT INTO `ey_region` VALUES ('11387', '吴中区', '3', '11348', 'W');
INSERT INTO `ey_region` VALUES ('11409', '相城区', '3', '11348', 'X');
INSERT INTO `ey_region` VALUES ('11419', '常熟市', '3', '11348', 'C');
INSERT INTO `ey_region` VALUES ('11433', '张家港市', '3', '11348', 'Z');
INSERT INTO `ey_region` VALUES ('11448', '昆山市', '3', '11348', 'K');
INSERT INTO `ey_region` VALUES ('11460', '吴江市', '3', '11348', 'W');
INSERT INTO `ey_region` VALUES ('11472', '太仓市', '3', '11348', 'T');
INSERT INTO `ey_region` VALUES ('11482', '南通市', '2', '10808', 'N');
INSERT INTO `ey_region` VALUES ('11483', '市辖区', '3', '11482', 'S');
INSERT INTO `ey_region` VALUES ('11484', '崇川区', '3', '11482', 'C');
INSERT INTO `ey_region` VALUES ('11502', '港闸区', '3', '11482', 'G');
INSERT INTO `ey_region` VALUES ('11510', '海安县', '3', '11482', 'H');
INSERT INTO `ey_region` VALUES ('11526', '如东', '3', '11482', 'R');
INSERT INTO `ey_region` VALUES ('11542', '启东市', '3', '11482', 'Q');
INSERT INTO `ey_region` VALUES ('11568', '如皋市', '3', '11482', 'R');
INSERT INTO `ey_region` VALUES ('11600', '通州市', '3', '11482', 'T');
INSERT INTO `ey_region` VALUES ('11627', '海门市', '3', '11482', 'H');
INSERT INTO `ey_region` VALUES ('11663', '连云港市', '2', '10808', 'L');
INSERT INTO `ey_region` VALUES ('11664', '市辖区', '3', '11663', 'S');
INSERT INTO `ey_region` VALUES ('11665', '连云区', '3', '11663', 'L');
INSERT INTO `ey_region` VALUES ('11678', '新浦区', '3', '11663', 'X');
INSERT INTO `ey_region` VALUES ('11692', '海州区', '3', '11663', 'H');
INSERT INTO `ey_region` VALUES ('11699', '赣榆县', '3', '11663', 'G');
INSERT INTO `ey_region` VALUES ('11722', '东海县', '3', '11663', 'D');
INSERT INTO `ey_region` VALUES ('11747', '灌云县', '3', '11663', 'G');
INSERT INTO `ey_region` VALUES ('11771', '灌南县', '3', '11663', 'G');
INSERT INTO `ey_region` VALUES ('11786', '淮安市', '2', '10808', 'H');
INSERT INTO `ey_region` VALUES ('11787', '市辖区', '3', '11786', 'S');
INSERT INTO `ey_region` VALUES ('11788', '清河区', '3', '11786', 'Q');
INSERT INTO `ey_region` VALUES ('11801', '楚州区', '3', '11786', 'C');
INSERT INTO `ey_region` VALUES ('11830', '淮阴区', '3', '11786', 'H');
INSERT INTO `ey_region` VALUES ('11853', '清浦区', '3', '11786', 'Q');
INSERT INTO `ey_region` VALUES ('11863', '涟水县', '3', '11786', 'L');
INSERT INTO `ey_region` VALUES ('11896', '洪泽县', '3', '11786', 'H');
INSERT INTO `ey_region` VALUES ('11909', '盱眙县', '3', '11786', 'X');
INSERT INTO `ey_region` VALUES ('11931', '金湖县', '3', '11786', 'J');
INSERT INTO `ey_region` VALUES ('11947', '盐城市', '2', '10808', 'Y');
INSERT INTO `ey_region` VALUES ('11948', '市辖区', '3', '11947', 'S');
INSERT INTO `ey_region` VALUES ('11949', '亭湖区', '3', '11947', 'T');
INSERT INTO `ey_region` VALUES ('11967', '盐都区', '3', '11947', 'Y');
INSERT INTO `ey_region` VALUES ('11982', '响水县', '3', '11947', 'X');
INSERT INTO `ey_region` VALUES ('11998', '滨海县', '3', '11947', 'B');
INSERT INTO `ey_region` VALUES ('12017', '阜宁县', '3', '11947', 'F');
INSERT INTO `ey_region` VALUES ('12040', '射阳县', '3', '11947', 'S');
INSERT INTO `ey_region` VALUES ('12066', '建湖县', '3', '11947', 'J');
INSERT INTO `ey_region` VALUES ('12083', '东台市', '3', '11947', 'D');
INSERT INTO `ey_region` VALUES ('12117', '大丰市', '3', '11947', 'D');
INSERT INTO `ey_region` VALUES ('12135', '扬州市', '2', '10808', 'Y');
INSERT INTO `ey_region` VALUES ('12136', '市辖区', '3', '12135', 'S');
INSERT INTO `ey_region` VALUES ('12137', '广陵区', '3', '12135', 'G');
INSERT INTO `ey_region` VALUES ('12144', '邗江区', '3', '12135', 'H');
INSERT INTO `ey_region` VALUES ('12160', '维扬区', '3', '12135', 'W');
INSERT INTO `ey_region` VALUES ('12175', '宝应县', '3', '12135', 'B');
INSERT INTO `ey_region` VALUES ('12191', '仪征市', '3', '12135', 'Y');
INSERT INTO `ey_region` VALUES ('12212', '高邮市', '3', '12135', 'G');
INSERT INTO `ey_region` VALUES ('12235', '江都市', '3', '12135', 'J');
INSERT INTO `ey_region` VALUES ('12249', '镇江市', '2', '10808', 'Z');
INSERT INTO `ey_region` VALUES ('12250', '市区', '3', '12249', 'S');
INSERT INTO `ey_region` VALUES ('12251', '京口区', '3', '12249', 'J');
INSERT INTO `ey_region` VALUES ('12265', '润州区', '3', '12249', 'R');
INSERT INTO `ey_region` VALUES ('12273', '丹徒区', '3', '12249', 'D');
INSERT INTO `ey_region` VALUES ('12282', '丹阳市', '3', '12249', 'D');
INSERT INTO `ey_region` VALUES ('12300', '扬中市', '3', '12249', 'Y');
INSERT INTO `ey_region` VALUES ('12312', '句容市', '3', '12249', 'J');
INSERT INTO `ey_region` VALUES ('12343', '泰州市', '2', '10808', 'T');
INSERT INTO `ey_region` VALUES ('12344', '市辖区', '3', '12343', 'S');
INSERT INTO `ey_region` VALUES ('12345', '海陵区', '3', '12343', 'H');
INSERT INTO `ey_region` VALUES ('12362', '高港区', '3', '12343', 'G');
INSERT INTO `ey_region` VALUES ('12370', '兴化市', '3', '12343', 'X');
INSERT INTO `ey_region` VALUES ('12407', '靖江市', '3', '12343', 'J');
INSERT INTO `ey_region` VALUES ('12423', '泰兴市', '3', '12343', 'T');
INSERT INTO `ey_region` VALUES ('12450', '姜堰市', '3', '12343', 'J');
INSERT INTO `ey_region` VALUES ('12475', '宿迁市', '2', '10808', 'S');
INSERT INTO `ey_region` VALUES ('12476', '市辖区', '3', '12475', 'S');
INSERT INTO `ey_region` VALUES ('12477', '宿城区', '3', '12475', 'S');
INSERT INTO `ey_region` VALUES ('12496', '宿豫区', '3', '12475', 'S');
INSERT INTO `ey_region` VALUES ('12515', '沭阳县', '3', '12475', 'S');
INSERT INTO `ey_region` VALUES ('12551', '泗阳县', '3', '12475', 'S');
INSERT INTO `ey_region` VALUES ('12570', '泗洪县', '3', '12475', 'S');
INSERT INTO `ey_region` VALUES ('12596', '浙江省', '1', '0', 'Z');
INSERT INTO `ey_region` VALUES ('12597', '杭州市', '2', '12596', 'H');
INSERT INTO `ey_region` VALUES ('12598', '市辖区', '3', '12597', 'S');
INSERT INTO `ey_region` VALUES ('12599', '上城区', '3', '12597', 'S');
INSERT INTO `ey_region` VALUES ('12606', '下城区', '3', '12597', 'X');
INSERT INTO `ey_region` VALUES ('12615', '江干区', '3', '12597', 'J');
INSERT INTO `ey_region` VALUES ('12626', '拱墅区', '3', '12597', 'G');
INSERT INTO `ey_region` VALUES ('12637', '西湖区', '3', '12597', 'X');
INSERT INTO `ey_region` VALUES ('12652', '滨江区', '3', '12597', 'B');
INSERT INTO `ey_region` VALUES ('12656', '萧山区', '3', '12597', 'X');
INSERT INTO `ey_region` VALUES ('12685', '余杭区', '3', '12597', 'Y');
INSERT INTO `ey_region` VALUES ('12705', '桐庐县', '3', '12597', 'T');
INSERT INTO `ey_region` VALUES ('12719', '淳安县', '3', '12597', 'C');
INSERT INTO `ey_region` VALUES ('12743', '建德市', '3', '12597', 'J');
INSERT INTO `ey_region` VALUES ('12760', '富阳市', '3', '12597', 'F');
INSERT INTO `ey_region` VALUES ('12786', '临安市', '3', '12597', 'L');
INSERT INTO `ey_region` VALUES ('12813', '宁波市', '2', '12596', 'N');
INSERT INTO `ey_region` VALUES ('12814', '市辖区', '3', '12813', 'S');
INSERT INTO `ey_region` VALUES ('12815', '海曙区', '3', '12813', 'H');
INSERT INTO `ey_region` VALUES ('12824', '江东区', '3', '12813', 'J');
INSERT INTO `ey_region` VALUES ('12832', '江北区', '3', '12813', 'J');
INSERT INTO `ey_region` VALUES ('12841', '北仑区', '3', '12813', 'B');
INSERT INTO `ey_region` VALUES ('12851', '镇海区', '3', '12813', 'Z');
INSERT INTO `ey_region` VALUES ('12858', '鄞州区', '3', '12813', 'Y');
INSERT INTO `ey_region` VALUES ('12881', '象山县', '3', '12813', 'X');
INSERT INTO `ey_region` VALUES ('12900', '宁海县', '3', '12813', 'N');
INSERT INTO `ey_region` VALUES ('12919', '余姚市', '3', '12813', 'Y');
INSERT INTO `ey_region` VALUES ('12941', '慈溪市', '3', '12813', 'C');
INSERT INTO `ey_region` VALUES ('12962', '奉化市', '3', '12813', 'F');
INSERT INTO `ey_region` VALUES ('12974', '温州市', '2', '12596', 'W');
INSERT INTO `ey_region` VALUES ('12975', '市辖区', '3', '12974', 'S');
INSERT INTO `ey_region` VALUES ('12976', '鹿城区', '3', '12974', 'L');
INSERT INTO `ey_region` VALUES ('12998', '龙湾区', '3', '12974', 'L');
INSERT INTO `ey_region` VALUES ('13009', '瓯海区', '3', '12974', 'O');
INSERT INTO `ey_region` VALUES ('13023', '洞头县', '3', '12974', 'D');
INSERT INTO `ey_region` VALUES ('13030', '永嘉县', '3', '12974', 'Y');
INSERT INTO `ey_region` VALUES ('13069', '平阳县', '3', '12974', 'P');
INSERT INTO `ey_region` VALUES ('13101', '苍南县', '3', '12974', 'C');
INSERT INTO `ey_region` VALUES ('13138', '文成县', '3', '12974', 'W');
INSERT INTO `ey_region` VALUES ('13172', '泰顺县', '3', '12974', 'T');
INSERT INTO `ey_region` VALUES ('13209', '瑞安市', '3', '12974', 'R');
INSERT INTO `ey_region` VALUES ('13248', '乐清市', '3', '12974', 'L');
INSERT INTO `ey_region` VALUES ('13280', '嘉兴市', '2', '12596', 'J');
INSERT INTO `ey_region` VALUES ('13281', '市辖区', '3', '13280', 'S');
INSERT INTO `ey_region` VALUES ('13282', '南湖区', '3', '13280', 'N');
INSERT INTO `ey_region` VALUES ('13295', '秀洲区', '3', '13280', 'X');
INSERT INTO `ey_region` VALUES ('13304', '嘉善县', '3', '13280', 'J');
INSERT INTO `ey_region` VALUES ('13316', '海盐县', '3', '13280', 'H');
INSERT INTO `ey_region` VALUES ('13325', '海宁市', '3', '13280', 'H');
INSERT INTO `ey_region` VALUES ('13339', '平湖市', '3', '13280', 'P');
INSERT INTO `ey_region` VALUES ('13350', '桐乡市', '3', '13280', 'T');
INSERT INTO `ey_region` VALUES ('13364', '湖州市', '2', '12596', 'H');
INSERT INTO `ey_region` VALUES ('13365', '市辖区', '3', '13364', 'S');
INSERT INTO `ey_region` VALUES ('13366', '吴兴区', '3', '13364', 'W');
INSERT INTO `ey_region` VALUES ('13382', '南浔区', '3', '13364', 'N');
INSERT INTO `ey_region` VALUES ('13392', '德清县', '3', '13364', 'D');
INSERT INTO `ey_region` VALUES ('13404', '长兴县', '3', '13364', 'C');
INSERT INTO `ey_region` VALUES ('13421', '安吉县', '3', '13364', 'A');
INSERT INTO `ey_region` VALUES ('13437', '绍兴市', '2', '12596', 'S');
INSERT INTO `ey_region` VALUES ('13438', '市辖区', '3', '13437', 'S');
INSERT INTO `ey_region` VALUES ('13439', '越城区', '3', '13437', 'Y');
INSERT INTO `ey_region` VALUES ('13453', '绍兴县', '3', '13437', 'S');
INSERT INTO `ey_region` VALUES ('13473', '新昌县', '3', '13437', 'X');
INSERT INTO `ey_region` VALUES ('13490', '诸暨市', '3', '13437', 'Z');
INSERT INTO `ey_region` VALUES ('13518', '上虞市', '3', '13437', 'S');
INSERT INTO `ey_region` VALUES ('13542', '嵊州市', '3', '13437', 'S');
INSERT INTO `ey_region` VALUES ('13564', '金华市', '2', '12596', 'J');
INSERT INTO `ey_region` VALUES ('13565', '市辖区', '3', '13564', 'S');
INSERT INTO `ey_region` VALUES ('13566', '婺城区', '3', '13564', 'W');
INSERT INTO `ey_region` VALUES ('13594', '金东区', '3', '13564', 'J');
INSERT INTO `ey_region` VALUES ('13606', '武义县', '3', '13564', 'W');
INSERT INTO `ey_region` VALUES ('13625', '浦江县', '3', '13564', 'P');
INSERT INTO `ey_region` VALUES ('13641', '磐安县', '3', '13564', 'P');
INSERT INTO `ey_region` VALUES ('13662', '兰溪市', '3', '13564', 'L');
INSERT INTO `ey_region` VALUES ('13678', '义乌市', '3', '13564', 'Y');
INSERT INTO `ey_region` VALUES ('13692', '东阳市', '3', '13564', 'D');
INSERT INTO `ey_region` VALUES ('13711', '永康市', '3', '13564', 'Y');
INSERT INTO `ey_region` VALUES ('13726', '衢州市', '2', '12596', 'Q');
INSERT INTO `ey_region` VALUES ('13727', '市辖区', '3', '13726', 'S');
INSERT INTO `ey_region` VALUES ('13728', '柯城区', '3', '13726', 'K');
INSERT INTO `ey_region` VALUES ('13746', '衢江区', '3', '13726', 'Q');
INSERT INTO `ey_region` VALUES ('13768', '常山县', '3', '13726', 'C');
INSERT INTO `ey_region` VALUES ('13783', '开化县', '3', '13726', 'K');
INSERT INTO `ey_region` VALUES ('13802', '龙游县', '3', '13726', 'L');
INSERT INTO `ey_region` VALUES ('13818', '江山市', '3', '13726', 'J');
INSERT INTO `ey_region` VALUES ('13840', '舟山市', '2', '12596', 'Z');
INSERT INTO `ey_region` VALUES ('13841', '市辖区', '3', '13840', 'S');
INSERT INTO `ey_region` VALUES ('13842', '定海区', '3', '13840', 'D');
INSERT INTO `ey_region` VALUES ('13859', '普陀区', '3', '13840', 'P');
INSERT INTO `ey_region` VALUES ('13874', '岱山县', '3', '13840', 'D');
INSERT INTO `ey_region` VALUES ('13882', '嵊泗县', '3', '13840', 'S');
INSERT INTO `ey_region` VALUES ('13890', '台州市', '2', '12596', 'T');
INSERT INTO `ey_region` VALUES ('13891', '市辖区', '3', '13890', 'S');
INSERT INTO `ey_region` VALUES ('13892', '椒江区', '3', '13890', 'J');
INSERT INTO `ey_region` VALUES ('13903', '黄岩区', '3', '13890', 'H');
INSERT INTO `ey_region` VALUES ('13923', '路桥区', '3', '13890', 'L');
INSERT INTO `ey_region` VALUES ('13934', '玉环县', '3', '13890', 'Y');
INSERT INTO `ey_region` VALUES ('13944', '三门县', '3', '13890', 'S');
INSERT INTO `ey_region` VALUES ('13959', '天台县', '3', '13890', 'T');
INSERT INTO `ey_region` VALUES ('13975', '仙居县', '3', '13890', 'X');
INSERT INTO `ey_region` VALUES ('13996', '温岭市', '3', '13890', 'W');
INSERT INTO `ey_region` VALUES ('14013', '临海市', '3', '13890', 'L');
INSERT INTO `ey_region` VALUES ('14033', '丽水市', '2', '12596', 'L');
INSERT INTO `ey_region` VALUES ('14034', '市辖区', '3', '14033', 'S');
INSERT INTO `ey_region` VALUES ('14035', '莲都区', '3', '14033', 'L');
INSERT INTO `ey_region` VALUES ('14054', '青田县', '3', '14033', 'Q');
INSERT INTO `ey_region` VALUES ('14086', '缙云县', '3', '14033', 'J');
INSERT INTO `ey_region` VALUES ('14111', '遂昌县', '3', '14033', 'S');
INSERT INTO `ey_region` VALUES ('14132', '松阳县', '3', '14033', 'S');
INSERT INTO `ey_region` VALUES ('14153', '云和县', '3', '14033', 'Y');
INSERT INTO `ey_region` VALUES ('14168', '庆元县', '3', '14033', 'Q');
INSERT INTO `ey_region` VALUES ('14189', '景宁县', '3', '14033', 'J');
INSERT INTO `ey_region` VALUES ('14214', '龙泉市', '3', '14033', 'L');
INSERT INTO `ey_region` VALUES ('14234', '安徽省', '1', '0', 'A');
INSERT INTO `ey_region` VALUES ('14235', '合肥市', '2', '14234', 'H');
INSERT INTO `ey_region` VALUES ('14236', '市辖区', '3', '14235', 'S');
INSERT INTO `ey_region` VALUES ('14237', '瑶海区', '3', '14235', 'Y');
INSERT INTO `ey_region` VALUES ('14254', '庐阳区', '3', '14235', 'L');
INSERT INTO `ey_region` VALUES ('14269', '蜀山区', '3', '14235', 'S');
INSERT INTO `ey_region` VALUES ('14286', '包河区', '3', '14235', 'B');
INSERT INTO `ey_region` VALUES ('14297', '长丰县', '3', '14235', 'C');
INSERT INTO `ey_region` VALUES ('14314', '肥东县', '3', '14235', 'F');
INSERT INTO `ey_region` VALUES ('14334', '肥西县', '3', '14235', 'F');
INSERT INTO `ey_region` VALUES ('14351', '芜湖市', '2', '14234', 'W');
INSERT INTO `ey_region` VALUES ('14352', '市辖区', '3', '14351', 'S');
INSERT INTO `ey_region` VALUES ('14353', '镜湖区', '3', '14351', 'J');
INSERT INTO `ey_region` VALUES ('14366', '弋江区', '3', '14351', 'Y');
INSERT INTO `ey_region` VALUES ('14374', '鸠江区', '3', '14351', 'J');
INSERT INTO `ey_region` VALUES ('14382', '三山区', '3', '14351', 'S');
INSERT INTO `ey_region` VALUES ('14387', '芜湖县', '3', '14351', 'W');
INSERT INTO `ey_region` VALUES ('14394', '繁昌县', '3', '14351', 'F');
INSERT INTO `ey_region` VALUES ('14401', '南陵县', '3', '14351', 'N');
INSERT INTO `ey_region` VALUES ('14410', '蚌埠市', '2', '14234', 'B');
INSERT INTO `ey_region` VALUES ('14411', '市辖区', '3', '14410', 'S');
INSERT INTO `ey_region` VALUES ('14412', '龙子湖区', '3', '14410', 'L');
INSERT INTO `ey_region` VALUES ('14422', '蚌山区', '3', '14410', 'B');
INSERT INTO `ey_region` VALUES ('14434', '禹会区', '3', '14410', 'Y');
INSERT INTO `ey_region` VALUES ('14443', '淮上区', '3', '14410', 'H');
INSERT INTO `ey_region` VALUES ('14449', '怀远县', '3', '14410', 'H');
INSERT INTO `ey_region` VALUES ('14471', '五河县', '3', '14410', 'W');
INSERT INTO `ey_region` VALUES ('14487', '固镇县', '3', '14410', 'G');
INSERT INTO `ey_region` VALUES ('14500', '淮南市', '2', '14234', 'H');
INSERT INTO `ey_region` VALUES ('14501', '市辖区', '3', '14500', 'S');
INSERT INTO `ey_region` VALUES ('14502', '大通区', '3', '14500', 'D');
INSERT INTO `ey_region` VALUES ('14508', '田家庵区', '3', '14500', 'T');
INSERT INTO `ey_region` VALUES ('14523', '谢家集区', '3', '14500', 'X');
INSERT INTO `ey_region` VALUES ('14535', '八公山区', '3', '14500', 'B');
INSERT INTO `ey_region` VALUES ('14542', '潘集区', '3', '14500', 'P');
INSERT INTO `ey_region` VALUES ('14554', '凤台县', '3', '14500', 'F');
INSERT INTO `ey_region` VALUES ('14575', '马鞍山市', '2', '14234', 'M');
INSERT INTO `ey_region` VALUES ('14576', '市辖区', '3', '14575', 'S');
INSERT INTO `ey_region` VALUES ('14577', '金家庄区', '3', '14575', 'J');
INSERT INTO `ey_region` VALUES ('14583', '花山区', '3', '14575', 'H');
INSERT INTO `ey_region` VALUES ('14589', '雨山区', '3', '14575', 'Y');
INSERT INTO `ey_region` VALUES ('14597', '当涂县', '3', '14575', 'D');
INSERT INTO `ey_region` VALUES ('14612', '淮北市', '2', '14234', 'H');
INSERT INTO `ey_region` VALUES ('14613', '市辖区', '3', '14612', 'S');
INSERT INTO `ey_region` VALUES ('14614', '杜集区', '3', '14612', 'D');
INSERT INTO `ey_region` VALUES ('14620', '相山区', '3', '14612', 'X');
INSERT INTO `ey_region` VALUES ('14632', '烈山区', '3', '14612', 'L');
INSERT INTO `ey_region` VALUES ('14641', '濉溪县', '3', '14612', 'S');
INSERT INTO `ey_region` VALUES ('14653', '铜陵市', '2', '14234', 'T');
INSERT INTO `ey_region` VALUES ('14654', '市辖区', '3', '14653', 'S');
INSERT INTO `ey_region` VALUES ('14655', '铜官山区', '3', '14653', 'T');
INSERT INTO `ey_region` VALUES ('14663', '狮子山区', '3', '14653', 'S');
INSERT INTO `ey_region` VALUES ('14671', '铜陵市郊区', '3', '14653', 'T');
INSERT INTO `ey_region` VALUES ('14678', '铜陵县', '3', '14653', 'T');
INSERT INTO `ey_region` VALUES ('14687', '安庆市', '2', '14234', 'A');
INSERT INTO `ey_region` VALUES ('14688', '市辖区', '3', '14687', 'S');
INSERT INTO `ey_region` VALUES ('14689', '迎江区', '3', '14687', 'Y');
INSERT INTO `ey_region` VALUES ('14700', '大观区', '3', '14687', 'D');
INSERT INTO `ey_region` VALUES ('14712', '宜秀区', '3', '14687', 'Y');
INSERT INTO `ey_region` VALUES ('14720', '怀宁县', '3', '14687', 'H');
INSERT INTO `ey_region` VALUES ('14741', '枞阳县', '3', '14687', 'C');
INSERT INTO `ey_region` VALUES ('14764', '潜山县', '3', '14687', 'Q');
INSERT INTO `ey_region` VALUES ('14782', '太湖县', '3', '14687', 'T');
INSERT INTO `ey_region` VALUES ('14798', '宿松县', '3', '14687', 'S');
INSERT INTO `ey_region` VALUES ('14823', '望江县', '3', '14687', 'W');
INSERT INTO `ey_region` VALUES ('14834', '岳西县', '3', '14687', 'Y');
INSERT INTO `ey_region` VALUES ('14859', '桐城市', '3', '14687', 'T');
INSERT INTO `ey_region` VALUES ('14887', '黄山市', '2', '14234', 'H');
INSERT INTO `ey_region` VALUES ('14888', '市辖区', '3', '14887', 'S');
INSERT INTO `ey_region` VALUES ('14889', '屯溪区', '3', '14887', 'T');
INSERT INTO `ey_region` VALUES ('14900', '黄山区', '3', '14887', 'H');
INSERT INTO `ey_region` VALUES ('14917', '徽州区', '3', '14887', 'H');
INSERT INTO `ey_region` VALUES ('14926', '歙县', '3', '14887', 'S');
INSERT INTO `ey_region` VALUES ('14955', '休宁县', '3', '14887', 'X');
INSERT INTO `ey_region` VALUES ('14977', '黟县', '3', '14887', 'Y');
INSERT INTO `ey_region` VALUES ('14986', '祁门县', '3', '14887', 'Q');
INSERT INTO `ey_region` VALUES ('15005', '滁州市', '2', '14234', 'C');
INSERT INTO `ey_region` VALUES ('15006', '市辖区', '3', '15005', 'S');
INSERT INTO `ey_region` VALUES ('15007', '琅琊区', '3', '15005', 'L');
INSERT INTO `ey_region` VALUES ('15016', '南谯区', '3', '15005', 'N');
INSERT INTO `ey_region` VALUES ('15034', '来安县', '3', '15005', 'L');
INSERT INTO `ey_region` VALUES ('15053', '全椒县', '3', '15005', 'Q');
INSERT INTO `ey_region` VALUES ('15071', '定远县', '3', '15005', 'D');
INSERT INTO `ey_region` VALUES ('15109', '凤阳县', '3', '15005', 'F');
INSERT INTO `ey_region` VALUES ('15136', '天长市', '3', '15005', 'T');
INSERT INTO `ey_region` VALUES ('15166', '明光市', '3', '15005', 'M');
INSERT INTO `ey_region` VALUES ('15194', '阜阳市', '2', '14234', 'F');
INSERT INTO `ey_region` VALUES ('15195', '市辖区', '3', '15194', 'S');
INSERT INTO `ey_region` VALUES ('15196', '颍州区', '3', '15194', 'Y');
INSERT INTO `ey_region` VALUES ('15211', '颍东区', '3', '15194', 'Y');
INSERT INTO `ey_region` VALUES ('15224', '颍泉区', '3', '15194', 'Y');
INSERT INTO `ey_region` VALUES ('15231', '临泉县', '3', '15194', 'L');
INSERT INTO `ey_region` VALUES ('15264', '太和县', '3', '15194', 'T');
INSERT INTO `ey_region` VALUES ('15296', '阜南县', '3', '15194', 'F');
INSERT INTO `ey_region` VALUES ('15328', '颍上县', '3', '15194', 'Y');
INSERT INTO `ey_region` VALUES ('15359', '界首市', '3', '15194', 'J');
INSERT INTO `ey_region` VALUES ('15378', '宿州市', '2', '14234', 'S');
INSERT INTO `ey_region` VALUES ('15379', '市辖区', '3', '15378', 'S');
INSERT INTO `ey_region` VALUES ('15380', '墉桥区', '3', '15378', 'Y');
INSERT INTO `ey_region` VALUES ('15417', '砀山县', '3', '15378', 'D');
INSERT INTO `ey_region` VALUES ('15437', '萧县', '3', '15378', 'X');
INSERT INTO `ey_region` VALUES ('15461', '灵璧县', '3', '15378', 'L');
INSERT INTO `ey_region` VALUES ('15482', '泗县', '3', '15378', 'S');
INSERT INTO `ey_region` VALUES ('15499', '巢湖市', '2', '14234', 'C');
INSERT INTO `ey_region` VALUES ('15500', '市辖区', '3', '15499', 'S');
INSERT INTO `ey_region` VALUES ('15501', '居巢区', '3', '15499', 'J');
INSERT INTO `ey_region` VALUES ('15520', '庐江县', '3', '15499', 'L');
INSERT INTO `ey_region` VALUES ('15542', '无为县', '3', '15499', 'W');
INSERT INTO `ey_region` VALUES ('15566', '含山县', '3', '15499', 'H');
INSERT INTO `ey_region` VALUES ('15575', '和县', '3', '15499', 'H');
INSERT INTO `ey_region` VALUES ('15586', '六安市', '2', '14234', 'L');
INSERT INTO `ey_region` VALUES ('15587', '市辖区', '3', '15586', 'S');
INSERT INTO `ey_region` VALUES ('15588', '金安区', '3', '15586', 'J');
INSERT INTO `ey_region` VALUES ('15612', '裕安区', '3', '15586', 'Y');
INSERT INTO `ey_region` VALUES ('15635', '寿县', '3', '15586', 'S');
INSERT INTO `ey_region` VALUES ('15662', '霍邱县', '3', '15586', 'H');
INSERT INTO `ey_region` VALUES ('15698', '舒城县', '3', '15586', 'S');
INSERT INTO `ey_region` VALUES ('15720', '金寨县', '3', '15586', 'J');
INSERT INTO `ey_region` VALUES ('15747', '霍山县', '3', '15586', 'H');
INSERT INTO `ey_region` VALUES ('15764', '亳州市', '2', '14234', 'H');
INSERT INTO `ey_region` VALUES ('15765', '市辖区', '3', '15764', 'S');
INSERT INTO `ey_region` VALUES ('15766', '谯城区', '3', '15764', 'Q');
INSERT INTO `ey_region` VALUES ('15795', '涡阳县', '3', '15764', 'W');
INSERT INTO `ey_region` VALUES ('15823', '蒙城县', '3', '15764', 'M');
INSERT INTO `ey_region` VALUES ('15843', '利辛县', '3', '15764', 'L');
INSERT INTO `ey_region` VALUES ('15871', '池州市', '2', '14234', 'C');
INSERT INTO `ey_region` VALUES ('15872', '市辖区', '3', '15871', 'S');
INSERT INTO `ey_region` VALUES ('15873', '贵池区', '3', '15871', 'G');
INSERT INTO `ey_region` VALUES ('15900', '东至县', '3', '15871', 'D');
INSERT INTO `ey_region` VALUES ('15930', '石台县', '3', '15871', 'S');
INSERT INTO `ey_region` VALUES ('15944', '青阳县', '3', '15871', 'Q');
INSERT INTO `ey_region` VALUES ('15958', '宣城市', '2', '14234', 'X');
INSERT INTO `ey_region` VALUES ('15959', '市辖区', '3', '15958', 'S');
INSERT INTO `ey_region` VALUES ('15960', '宣州区', '3', '15958', 'X');
INSERT INTO `ey_region` VALUES ('15987', '郎溪县', '3', '15958', 'L');
INSERT INTO `ey_region` VALUES ('16001', '广德县', '3', '15958', 'G');
INSERT INTO `ey_region` VALUES ('16013', '泾县', '3', '15958', 'J');
INSERT INTO `ey_region` VALUES ('16025', '绩溪县', '3', '15958', 'J');
INSERT INTO `ey_region` VALUES ('16037', '旌德县', '3', '15958', 'J');
INSERT INTO `ey_region` VALUES ('16048', '宁国市', '3', '15958', 'N');
INSERT INTO `ey_region` VALUES ('16068', '福建省', '1', '0', 'F');
INSERT INTO `ey_region` VALUES ('16069', '福州市', '2', '16068', 'F');
INSERT INTO `ey_region` VALUES ('16070', '市辖区', '3', '16069', 'S');
INSERT INTO `ey_region` VALUES ('16071', '鼓楼区', '3', '16069', 'G');
INSERT INTO `ey_region` VALUES ('16082', '台江区', '3', '16069', 'T');
INSERT INTO `ey_region` VALUES ('16093', '仓山区', '3', '16069', 'C');
INSERT INTO `ey_region` VALUES ('16108', '马尾区', '3', '16069', 'M');
INSERT INTO `ey_region` VALUES ('16113', '晋安区', '3', '16069', 'J');
INSERT INTO `ey_region` VALUES ('16123', '闽侯县', '3', '16069', 'M');
INSERT INTO `ey_region` VALUES ('16140', '连江县', '3', '16069', 'L');
INSERT INTO `ey_region` VALUES ('16164', '罗源县', '3', '16069', 'L');
INSERT INTO `ey_region` VALUES ('16177', '闽清县', '3', '16069', 'M');
INSERT INTO `ey_region` VALUES ('16194', '永泰县', '3', '16069', 'Y');
INSERT INTO `ey_region` VALUES ('16216', '平潭县', '3', '16069', 'P');
INSERT INTO `ey_region` VALUES ('16232', '福清市', '3', '16069', 'F');
INSERT INTO `ey_region` VALUES ('16259', '长乐市', '3', '16069', 'C');
INSERT INTO `ey_region` VALUES ('16278', '厦门市', '2', '16068', 'X');
INSERT INTO `ey_region` VALUES ('16279', '市辖区', '3', '16278', 'S');
INSERT INTO `ey_region` VALUES ('16280', '思明区', '3', '16278', 'S');
INSERT INTO `ey_region` VALUES ('16294', '海沧区', '3', '16278', 'H');
INSERT INTO `ey_region` VALUES ('16303', '湖里区', '3', '16278', 'H');
INSERT INTO `ey_region` VALUES ('16315', '集美区', '3', '16278', 'J');
INSERT INTO `ey_region` VALUES ('16326', '同安区', '3', '16278', 'T');
INSERT INTO `ey_region` VALUES ('16341', '翔安区', '3', '16278', 'X');
INSERT INTO `ey_region` VALUES ('16348', '莆田市', '2', '16068', 'P');
INSERT INTO `ey_region` VALUES ('16349', '市辖区', '3', '16348', 'S');
INSERT INTO `ey_region` VALUES ('16350', '城厢区', '3', '16348', 'C');
INSERT INTO `ey_region` VALUES ('16358', '涵江区', '3', '16348', 'H');
INSERT INTO `ey_region` VALUES ('16372', '荔城区', '3', '16348', 'L');
INSERT INTO `ey_region` VALUES ('16379', '秀屿区', '3', '16348', 'X');
INSERT INTO `ey_region` VALUES ('16393', '仙游县', '3', '16348', 'X');
INSERT INTO `ey_region` VALUES ('16412', '三明市', '2', '16068', 'S');
INSERT INTO `ey_region` VALUES ('16413', '市辖区', '3', '16412', 'S');
INSERT INTO `ey_region` VALUES ('16414', '梅列区', '3', '16412', 'M');
INSERT INTO `ey_region` VALUES ('16421', '三元区', '3', '16412', 'S');
INSERT INTO `ey_region` VALUES ('16430', '明溪县', '3', '16412', 'M');
INSERT INTO `ey_region` VALUES ('16440', '清流县', '3', '16412', 'Q');
INSERT INTO `ey_region` VALUES ('16455', '宁化县', '3', '16412', 'N');
INSERT INTO `ey_region` VALUES ('16472', '大田县', '3', '16412', 'D');
INSERT INTO `ey_region` VALUES ('16492', '尤溪县', '3', '16412', 'Y');
INSERT INTO `ey_region` VALUES ('16508', '沙县', '3', '16412', 'S');
INSERT INTO `ey_region` VALUES ('16521', '将乐县', '3', '16412', 'J');
INSERT INTO `ey_region` VALUES ('16535', '泰宁县', '3', '16412', 'T');
INSERT INTO `ey_region` VALUES ('16545', '建宁县', '3', '16412', 'J');
INSERT INTO `ey_region` VALUES ('16556', '永安市', '3', '16412', 'Y');
INSERT INTO `ey_region` VALUES ('16572', '泉州市', '2', '16068', 'Q');
INSERT INTO `ey_region` VALUES ('16573', '市辖区', '3', '16572', 'S');
INSERT INTO `ey_region` VALUES ('16574', '鲤城区', '3', '16572', 'L');
INSERT INTO `ey_region` VALUES ('16584', '丰泽区', '3', '16572', 'F');
INSERT INTO `ey_region` VALUES ('16593', '洛江区', '3', '16572', 'L');
INSERT INTO `ey_region` VALUES ('16600', '泉港区', '3', '16572', 'Q');
INSERT INTO `ey_region` VALUES ('16608', '惠安县', '3', '16572', 'H');
INSERT INTO `ey_region` VALUES ('16625', '安溪县', '3', '16572', 'A');
INSERT INTO `ey_region` VALUES ('16650', '永春县', '3', '16572', 'Y');
INSERT INTO `ey_region` VALUES ('16673', '德化县', '3', '16572', 'D');
INSERT INTO `ey_region` VALUES ('16692', '金门县', '3', '16572', 'J');
INSERT INTO `ey_region` VALUES ('16693', '石狮市', '3', '16572', 'S');
INSERT INTO `ey_region` VALUES ('16703', '晋江市', '3', '16572', 'J');
INSERT INTO `ey_region` VALUES ('16726', '南安市', '3', '16572', 'N');
INSERT INTO `ey_region` VALUES ('16754', '漳州市', '2', '16068', 'Z');
INSERT INTO `ey_region` VALUES ('16755', '市辖区', '3', '16754', 'S');
INSERT INTO `ey_region` VALUES ('16756', '芗城区', '3', '16754', 'X');
INSERT INTO `ey_region` VALUES ('16772', '龙文区', '3', '16754', 'L');
INSERT INTO `ey_region` VALUES ('16778', '云霄县', '3', '16754', 'Y');
INSERT INTO `ey_region` VALUES ('16790', '漳浦县', '3', '16754', 'Z');
INSERT INTO `ey_region` VALUES ('16821', '诏安县', '3', '16754', 'Z');
INSERT INTO `ey_region` VALUES ('16842', '长泰县', '3', '16754', 'C');
INSERT INTO `ey_region` VALUES ('16852', '东山县', '3', '16754', 'D');
INSERT INTO `ey_region` VALUES ('16860', '南靖县', '3', '16754', 'N');
INSERT INTO `ey_region` VALUES ('16872', '平和县', '3', '16754', 'P');
INSERT INTO `ey_region` VALUES ('16889', '华安县', '3', '16754', 'H');
INSERT INTO `ey_region` VALUES ('16899', '龙海市', '3', '16754', 'L');
INSERT INTO `ey_region` VALUES ('16924', '南平市', '2', '16068', 'N');
INSERT INTO `ey_region` VALUES ('16925', '市辖区', '3', '16924', 'S');
INSERT INTO `ey_region` VALUES ('16926', '延平区', '3', '16924', 'Y');
INSERT INTO `ey_region` VALUES ('16948', '顺昌县', '3', '16924', 'S');
INSERT INTO `ey_region` VALUES ('16961', '浦城县', '3', '16924', 'P');
INSERT INTO `ey_region` VALUES ('16982', '光泽县', '3', '16924', 'G');
INSERT INTO `ey_region` VALUES ('16991', '松溪县', '3', '16924', 'S');
INSERT INTO `ey_region` VALUES ('17001', '政和县', '3', '16924', 'Z');
INSERT INTO `ey_region` VALUES ('17012', '邵武市', '3', '16924', 'S');
INSERT INTO `ey_region` VALUES ('17033', '武夷山市', '3', '16924', 'W');
INSERT INTO `ey_region` VALUES ('17044', '建瓯市', '3', '16924', 'J');
INSERT INTO `ey_region` VALUES ('17063', '建阳市', '3', '16924', 'J');
INSERT INTO `ey_region` VALUES ('17077', '龙岩市', '2', '16068', 'L');
INSERT INTO `ey_region` VALUES ('17078', '市辖区', '3', '17077', 'S');
INSERT INTO `ey_region` VALUES ('17079', '新罗区', '3', '17077', 'X');
INSERT INTO `ey_region` VALUES ('17099', '长汀县', '3', '17077', 'C');
INSERT INTO `ey_region` VALUES ('17118', '永定县', '3', '17077', 'Y');
INSERT INTO `ey_region` VALUES ('17143', '上杭县', '3', '17077', 'S');
INSERT INTO `ey_region` VALUES ('17166', '武平县', '3', '17077', 'W');
INSERT INTO `ey_region` VALUES ('17184', '连城县', '3', '17077', 'L');
INSERT INTO `ey_region` VALUES ('17202', '漳平市', '3', '17077', 'Z');
INSERT INTO `ey_region` VALUES ('17219', '宁德市　', '2', '16068', 'N');
INSERT INTO `ey_region` VALUES ('17220', '市辖区', '3', '17219', 'S');
INSERT INTO `ey_region` VALUES ('17221', '蕉城区', '3', '17219', 'J');
INSERT INTO `ey_region` VALUES ('17239', '霞浦县', '3', '17219', 'X');
INSERT INTO `ey_region` VALUES ('17254', '古田县', '3', '17219', 'G');
INSERT INTO `ey_region` VALUES ('17269', '屏南县', '3', '17219', 'P');
INSERT INTO `ey_region` VALUES ('17281', '寿宁县', '3', '17219', 'S');
INSERT INTO `ey_region` VALUES ('17296', '周宁县', '3', '17219', 'Z');
INSERT INTO `ey_region` VALUES ('17306', '柘荣县', '3', '17219', 'Z');
INSERT INTO `ey_region` VALUES ('17316', '福安市', '3', '17219', 'F');
INSERT INTO `ey_region` VALUES ('17341', '福鼎市', '3', '17219', 'F');
INSERT INTO `ey_region` VALUES ('17359', '江西省', '1', '0', 'J');
INSERT INTO `ey_region` VALUES ('17360', '南昌市', '2', '17359', 'N');
INSERT INTO `ey_region` VALUES ('17361', '市辖区', '3', '17360', 'S');
INSERT INTO `ey_region` VALUES ('17362', '东湖区', '3', '17360', 'D');
INSERT INTO `ey_region` VALUES ('17374', '西湖区', '3', '17360', 'X');
INSERT INTO `ey_region` VALUES ('17387', '青云谱区', '3', '17360', 'Q');
INSERT INTO `ey_region` VALUES ('17395', '湾里区', '3', '17360', 'W');
INSERT INTO `ey_region` VALUES ('17402', '青山湖区', '3', '17360', 'Q');
INSERT INTO `ey_region` VALUES ('17420', '南昌县', '3', '17360', 'N');
INSERT INTO `ey_region` VALUES ('17443', '新建县', '3', '17360', 'X');
INSERT INTO `ey_region` VALUES ('17471', '安义县', '3', '17360', 'A');
INSERT INTO `ey_region` VALUES ('17485', '进贤县', '3', '17360', 'J');
INSERT INTO `ey_region` VALUES ('17508', '景德镇市', '2', '17359', 'J');
INSERT INTO `ey_region` VALUES ('17509', '市辖区', '3', '17508', 'S');
INSERT INTO `ey_region` VALUES ('17510', '昌江区', '3', '17508', 'C');
INSERT INTO `ey_region` VALUES ('17534', '珠山区', '3', '17508', 'Z');
INSERT INTO `ey_region` VALUES ('17545', '浮梁县', '3', '17508', 'F');
INSERT INTO `ey_region` VALUES ('17568', '乐平市', '3', '17508', 'L');
INSERT INTO `ey_region` VALUES ('17589', '萍乡市', '2', '17359', 'P');
INSERT INTO `ey_region` VALUES ('17590', '市辖区', '3', '17589', 'S');
INSERT INTO `ey_region` VALUES ('17591', '安源区', '3', '17589', 'A');
INSERT INTO `ey_region` VALUES ('17604', '湘东区', '3', '17589', 'X');
INSERT INTO `ey_region` VALUES ('17616', '莲花县', '3', '17589', 'L');
INSERT INTO `ey_region` VALUES ('17630', '上栗县', '3', '17589', 'S');
INSERT INTO `ey_region` VALUES ('17640', '芦溪县', '3', '17589', 'L');
INSERT INTO `ey_region` VALUES ('17651', '九江市', '2', '17359', 'J');
INSERT INTO `ey_region` VALUES ('17652', '市辖区', '3', '17651', 'S');
INSERT INTO `ey_region` VALUES ('17653', '庐山区', '3', '17651', 'L');
INSERT INTO `ey_region` VALUES ('17667', '浔阳区', '3', '17651', 'X');
INSERT INTO `ey_region` VALUES ('17676', '九江县', '3', '17651', 'J');
INSERT INTO `ey_region` VALUES ('17693', '武宁县', '3', '17651', 'W');
INSERT INTO `ey_region` VALUES ('17714', '修水县', '3', '17651', 'X');
INSERT INTO `ey_region` VALUES ('17751', '永修县', '3', '17651', 'Y');
INSERT INTO `ey_region` VALUES ('17773', '德安县', '3', '17651', 'D');
INSERT INTO `ey_region` VALUES ('17792', '星子县', '3', '17651', 'X');
INSERT INTO `ey_region` VALUES ('17807', '都昌县', '3', '17651', 'D');
INSERT INTO `ey_region` VALUES ('17834', '湖口县', '3', '17651', 'H');
INSERT INTO `ey_region` VALUES ('17849', '彭泽县', '3', '17651', 'P');
INSERT INTO `ey_region` VALUES ('17872', '瑞昌市', '3', '17651', 'R');
INSERT INTO `ey_region` VALUES ('17894', '新余市', '2', '17359', 'X');
INSERT INTO `ey_region` VALUES ('17895', '市辖区', '3', '17894', 'S');
INSERT INTO `ey_region` VALUES ('17896', '渝水区', '3', '17894', 'Y');
INSERT INTO `ey_region` VALUES ('17917', '分宜县', '3', '17894', 'F');
INSERT INTO `ey_region` VALUES ('17934', '鹰潭市', '2', '17359', 'Y');
INSERT INTO `ey_region` VALUES ('17935', '市辖区', '3', '17934', 'S');
INSERT INTO `ey_region` VALUES ('17936', '月湖区', '3', '17934', 'Y');
INSERT INTO `ey_region` VALUES ('17945', '余江县', '3', '17934', 'Y');
INSERT INTO `ey_region` VALUES ('17966', '贵溪市', '3', '17934', 'G');
INSERT INTO `ey_region` VALUES ('17999', '赣州市', '2', '17359', 'G');
INSERT INTO `ey_region` VALUES ('18000', '市辖区', '3', '17999', 'S');
INSERT INTO `ey_region` VALUES ('18001', '章贡区', '3', '17999', 'Z');
INSERT INTO `ey_region` VALUES ('18016', '赣县', '3', '17999', 'G');
INSERT INTO `ey_region` VALUES ('18037', '信丰县', '3', '17999', 'X');
INSERT INTO `ey_region` VALUES ('18055', '大余县', '3', '17999', 'D');
INSERT INTO `ey_region` VALUES ('18068', '上犹县', '3', '17999', 'S');
INSERT INTO `ey_region` VALUES ('18084', '崇义县', '3', '17999', 'C');
INSERT INTO `ey_region` VALUES ('18102', '安远县', '3', '17999', 'A');
INSERT INTO `ey_region` VALUES ('18122', '龙南县', '3', '17999', 'L');
INSERT INTO `ey_region` VALUES ('18139', '定南县', '3', '17999', 'D');
INSERT INTO `ey_region` VALUES ('18148', '全南县', '3', '17999', 'Q');
INSERT INTO `ey_region` VALUES ('18161', '宁都县', '3', '17999', 'N');
INSERT INTO `ey_region` VALUES ('18187', '于都县', '3', '17999', 'Y');
INSERT INTO `ey_region` VALUES ('18212', '兴国县', '3', '17999', 'X');
INSERT INTO `ey_region` VALUES ('18239', '会昌县', '3', '17999', 'H');
INSERT INTO `ey_region` VALUES ('18260', '寻乌县', '3', '17999', 'X');
INSERT INTO `ey_region` VALUES ('18276', '石城县', '3', '17999', 'S');
INSERT INTO `ey_region` VALUES ('18287', '瑞金市', '3', '17999', 'R');
INSERT INTO `ey_region` VALUES ('18306', '南康市', '3', '17999', 'N');
INSERT INTO `ey_region` VALUES ('18330', '吉安市', '2', '17359', 'J');
INSERT INTO `ey_region` VALUES ('18331', '市辖区', '3', '18330', 'S');
INSERT INTO `ey_region` VALUES ('18332', '吉州区', '3', '18330', 'J');
INSERT INTO `ey_region` VALUES ('18345', '青原区', '3', '18330', 'Q');
INSERT INTO `ey_region` VALUES ('18356', '吉安县', '3', '18330', 'J');
INSERT INTO `ey_region` VALUES ('18378', '吉水县', '3', '18330', 'J');
INSERT INTO `ey_region` VALUES ('18398', '峡江县', '3', '18330', 'X');
INSERT INTO `ey_region` VALUES ('18411', '新干县', '3', '18330', 'X');
INSERT INTO `ey_region` VALUES ('18429', '永丰县', '3', '18330', 'Y');
INSERT INTO `ey_region` VALUES ('18454', '泰和县', '3', '18330', 'T');
INSERT INTO `ey_region` VALUES ('18483', '遂川县', '3', '18330', 'S');
INSERT INTO `ey_region` VALUES ('18510', '万安县', '3', '18330', 'W');
INSERT INTO `ey_region` VALUES ('18529', '安福县', '3', '18330', 'A');
INSERT INTO `ey_region` VALUES ('18550', '永新县', '3', '18330', 'Y');
INSERT INTO `ey_region` VALUES ('18575', '井冈山市', '3', '18330', 'J');
INSERT INTO `ey_region` VALUES ('18598', '宜春市', '2', '17359', 'Y');
INSERT INTO `ey_region` VALUES ('18599', '市辖区', '3', '18598', 'S');
INSERT INTO `ey_region` VALUES ('18600', '袁州区', '3', '18598', 'Y');
INSERT INTO `ey_region` VALUES ('18639', '奉新县', '3', '18598', 'F');
INSERT INTO `ey_region` VALUES ('18659', '万载县', '3', '18598', 'W');
INSERT INTO `ey_region` VALUES ('18678', '上高县', '3', '18598', 'S');
INSERT INTO `ey_region` VALUES ('18696', '宜丰县', '3', '18598', 'Y');
INSERT INTO `ey_region` VALUES ('18714', '靖安县', '3', '18598', 'J');
INSERT INTO `ey_region` VALUES ('18727', '铜鼓县', '3', '18598', 'T');
INSERT INTO `ey_region` VALUES ('18741', '丰城市', '3', '18598', 'F');
INSERT INTO `ey_region` VALUES ('18777', '樟树市', '3', '18598', 'Z');
INSERT INTO `ey_region` VALUES ('18799', '高安市', '3', '18598', 'G');
INSERT INTO `ey_region` VALUES ('18829', '抚州市', '2', '17359', 'F');
INSERT INTO `ey_region` VALUES ('18830', '市辖区', '3', '18829', 'S');
INSERT INTO `ey_region` VALUES ('18831', '临川区', '3', '18829', 'L');
INSERT INTO `ey_region` VALUES ('18869', '南城县', '3', '18829', 'N');
INSERT INTO `ey_region` VALUES ('18882', '黎川县', '3', '18829', 'L');
INSERT INTO `ey_region` VALUES ('18900', '南丰县', '3', '18829', 'N');
INSERT INTO `ey_region` VALUES ('18915', '崇仁县', '3', '18829', 'C');
INSERT INTO `ey_region` VALUES ('18931', '乐安县', '3', '18829', 'L');
INSERT INTO `ey_region` VALUES ('18949', '宜黄县', '3', '18829', 'Y');
INSERT INTO `ey_region` VALUES ('18965', '金溪县', '3', '18829', 'J');
INSERT INTO `ey_region` VALUES ('18980', '资溪县', '3', '18829', 'Z');
INSERT INTO `ey_region` VALUES ('18988', '东乡县', '3', '18829', 'D');
INSERT INTO `ey_region` VALUES ('19010', '广昌县', '3', '18829', 'G');
INSERT INTO `ey_region` VALUES ('19024', '上饶市', '2', '17359', 'S');
INSERT INTO `ey_region` VALUES ('19025', '市辖区', '3', '19024', 'S');
INSERT INTO `ey_region` VALUES ('19026', '信州区', '3', '19024', 'X');
INSERT INTO `ey_region` VALUES ('19038', '上饶县', '3', '19024', 'S');
INSERT INTO `ey_region` VALUES ('19062', '广丰县', '3', '19024', 'G');
INSERT INTO `ey_region` VALUES ('19088', '玉山县', '3', '19024', 'Y');
INSERT INTO `ey_region` VALUES ('19108', '铅山县', '3', '19024', 'Q');
INSERT INTO `ey_region` VALUES ('19136', '横峰县', '3', '19024', 'H');
INSERT INTO `ey_region` VALUES ('19151', '弋阳县', '3', '19024', 'Y');
INSERT INTO `ey_region` VALUES ('19171', '余干县', '3', '19024', 'Y');
INSERT INTO `ey_region` VALUES ('19202', '鄱阳县', '3', '19024', 'P');
INSERT INTO `ey_region` VALUES ('19234', '万年县', '3', '19024', 'W');
INSERT INTO `ey_region` VALUES ('19248', '婺源县', '3', '19024', 'W');
INSERT INTO `ey_region` VALUES ('19265', '德兴市', '3', '19024', 'D');
INSERT INTO `ey_region` VALUES ('19280', '山东省', '1', '0', 'S');
INSERT INTO `ey_region` VALUES ('19281', '济南市', '2', '19280', 'J');
INSERT INTO `ey_region` VALUES ('19282', '市辖区', '3', '19281', 'S');
INSERT INTO `ey_region` VALUES ('19283', '历下区', '3', '19281', 'L');
INSERT INTO `ey_region` VALUES ('19295', '市中区', '3', '19281', 'S');
INSERT INTO `ey_region` VALUES ('19311', '槐荫区', '3', '19281', 'H');
INSERT INTO `ey_region` VALUES ('19326', '天桥区', '3', '19281', 'T');
INSERT INTO `ey_region` VALUES ('19342', '历城区', '3', '19281', 'L');
INSERT INTO `ey_region` VALUES ('19359', '长清区', '3', '19281', 'C');
INSERT INTO `ey_region` VALUES ('19370', '平阴县', '3', '19281', 'P');
INSERT INTO `ey_region` VALUES ('19378', '济阳县', '3', '19281', 'J');
INSERT INTO `ey_region` VALUES ('19387', '商河县', '3', '19281', 'S');
INSERT INTO `ey_region` VALUES ('19400', '章丘市', '3', '19281', 'Z');
INSERT INTO `ey_region` VALUES ('19421', '青岛市', '2', '19280', 'Q');
INSERT INTO `ey_region` VALUES ('19422', '市辖区', '3', '19421', 'S');
INSERT INTO `ey_region` VALUES ('19423', '市南区', '3', '19421', 'S');
INSERT INTO `ey_region` VALUES ('19438', '市北区', '3', '19421', 'S');
INSERT INTO `ey_region` VALUES ('19456', '四方区', '3', '19421', 'S');
INSERT INTO `ey_region` VALUES ('19464', '黄岛区', '3', '19421', 'H');
INSERT INTO `ey_region` VALUES ('19471', '崂山区', '3', '19421', 'L');
INSERT INTO `ey_region` VALUES ('19476', '李沧区', '3', '19421', 'L');
INSERT INTO `ey_region` VALUES ('19488', '城阳区', '3', '19421', 'C');
INSERT INTO `ey_region` VALUES ('19497', '胶州市', '3', '19421', 'J');
INSERT INTO `ey_region` VALUES ('19516', '即墨市', '3', '19421', 'J');
INSERT INTO `ey_region` VALUES ('19540', '平度市', '3', '19421', 'P');
INSERT INTO `ey_region` VALUES ('19572', '胶南市', '3', '19421', 'J');
INSERT INTO `ey_region` VALUES ('19590', '莱西市', '3', '19421', 'L');
INSERT INTO `ey_region` VALUES ('19608', '淄博市', '2', '19280', 'Z');
INSERT INTO `ey_region` VALUES ('19609', '市辖区', '3', '19608', 'S');
INSERT INTO `ey_region` VALUES ('19610', '淄川区', '3', '19608', 'Z');
INSERT INTO `ey_region` VALUES ('19632', '张店区', '3', '19608', 'Z');
INSERT INTO `ey_region` VALUES ('19649', '博山区', '3', '19608', 'B');
INSERT INTO `ey_region` VALUES ('19663', '临淄区', '3', '19608', 'L');
INSERT INTO `ey_region` VALUES ('19678', '周村区', '3', '19608', 'Z');
INSERT INTO `ey_region` VALUES ('19688', '桓台县', '3', '19608', 'H');
INSERT INTO `ey_region` VALUES ('19700', '高青县', '3', '19608', 'G');
INSERT INTO `ey_region` VALUES ('19710', '沂源县', '3', '19608', 'Y');
INSERT INTO `ey_region` VALUES ('19724', '枣庄市', '2', '19280', 'Z');
INSERT INTO `ey_region` VALUES ('19725', '市辖区', '3', '19724', 'S');
INSERT INTO `ey_region` VALUES ('19726', '市中区', '3', '19724', 'S');
INSERT INTO `ey_region` VALUES ('19738', '薛城区', '3', '19724', 'X');
INSERT INTO `ey_region` VALUES ('19748', '峄城区', '3', '19724', 'Y');
INSERT INTO `ey_region` VALUES ('19756', '台儿庄区', '3', '19724', 'T');
INSERT INTO `ey_region` VALUES ('19763', '山亭区', '3', '19724', 'S');
INSERT INTO `ey_region` VALUES ('19774', '滕州市', '3', '19724', 'T');
INSERT INTO `ey_region` VALUES ('19796', '东营市', '2', '19280', 'D');
INSERT INTO `ey_region` VALUES ('19797', '市辖区', '3', '19796', 'S');
INSERT INTO `ey_region` VALUES ('19798', '东营区', '3', '19796', 'D');
INSERT INTO `ey_region` VALUES ('19809', '河口区', '3', '19796', 'H');
INSERT INTO `ey_region` VALUES ('19817', '垦利县', '3', '19796', 'K');
INSERT INTO `ey_region` VALUES ('19825', '利津县', '3', '19796', 'L');
INSERT INTO `ey_region` VALUES ('19835', '广饶县', '3', '19796', 'G');
INSERT INTO `ey_region` VALUES ('19846', '烟台市', '2', '19280', 'Y');
INSERT INTO `ey_region` VALUES ('19847', '市辖区', '3', '19846', 'S');
INSERT INTO `ey_region` VALUES ('19848', '芝罘区', '3', '19846', 'Z');
INSERT INTO `ey_region` VALUES ('19861', '福山区', '3', '19846', 'F');
INSERT INTO `ey_region` VALUES ('19873', '牟平区', '3', '19846', 'M');
INSERT INTO `ey_region` VALUES ('19887', '莱山区', '3', '19846', 'L');
INSERT INTO `ey_region` VALUES ('19893', '长岛县', '3', '19846', 'C');
INSERT INTO `ey_region` VALUES ('19902', '龙口市', '3', '19846', 'L');
INSERT INTO `ey_region` VALUES ('19916', '莱阳市', '3', '19846', 'L');
INSERT INTO `ey_region` VALUES ('19935', '莱州市', '3', '19846', 'L');
INSERT INTO `ey_region` VALUES ('19952', '蓬莱市', '3', '19846', 'P');
INSERT INTO `ey_region` VALUES ('19965', '招远市', '3', '19846', 'Z');
INSERT INTO `ey_region` VALUES ('19980', '栖霞市', '3', '19846', 'Q');
INSERT INTO `ey_region` VALUES ('19996', '海阳市', '3', '19846', 'H');
INSERT INTO `ey_region` VALUES ('20012', '潍坊市', '2', '19280', 'W');
INSERT INTO `ey_region` VALUES ('20013', '市辖区', '3', '20012', 'S');
INSERT INTO `ey_region` VALUES ('20014', '潍城区', '3', '20012', 'W');
INSERT INTO `ey_region` VALUES ('20023', '寒亭区', '3', '20012', 'H');
INSERT INTO `ey_region` VALUES ('20034', '坊子区', '3', '20012', 'F');
INSERT INTO `ey_region` VALUES ('20043', '奎文区', '3', '20012', 'K');
INSERT INTO `ey_region` VALUES ('20055', '临朐县', '3', '20012', 'L');
INSERT INTO `ey_region` VALUES ('20074', '昌乐县', '3', '20012', 'C');
INSERT INTO `ey_region` VALUES ('20091', '青州市', '3', '20012', 'Q');
INSERT INTO `ey_region` VALUES ('20113', '诸城市', '3', '20012', 'Z');
INSERT INTO `ey_region` VALUES ('20137', '寿光市', '3', '20012', 'S');
INSERT INTO `ey_region` VALUES ('20155', '安丘市', '3', '20012', 'A');
INSERT INTO `ey_region` VALUES ('20179', '高密市', '3', '20012', 'G');
INSERT INTO `ey_region` VALUES ('20200', '昌邑市', '3', '20012', 'C');
INSERT INTO `ey_region` VALUES ('20216', '济宁市', '2', '19280', 'J');
INSERT INTO `ey_region` VALUES ('20217', '市辖区', '3', '20216', 'S');
INSERT INTO `ey_region` VALUES ('20218', '市中区', '3', '20216', 'S');
INSERT INTO `ey_region` VALUES ('20227', '任城区', '3', '20216', 'R');
INSERT INTO `ey_region` VALUES ('20257', '鱼台县', '3', '20216', 'Y');
INSERT INTO `ey_region` VALUES ('20268', '金乡县', '3', '20216', 'J');
INSERT INTO `ey_region` VALUES ('20282', '嘉祥县', '3', '20216', 'J');
INSERT INTO `ey_region` VALUES ('20298', '汶上县', '3', '20216', 'W');
INSERT INTO `ey_region` VALUES ('20313', '泗水县', '3', '20216', 'S');
INSERT INTO `ey_region` VALUES ('20327', '梁山县', '3', '20216', 'L');
INSERT INTO `ey_region` VALUES ('20342', '曲阜市', '3', '20216', 'Q');
INSERT INTO `ey_region` VALUES ('20355', '兖州市', '3', '20216', 'Y');
INSERT INTO `ey_region` VALUES ('20368', '邹城市', '3', '20216', 'Z');
INSERT INTO `ey_region` VALUES ('20386', '泰安市', '2', '19280', 'T');
INSERT INTO `ey_region` VALUES ('20387', '市辖区', '3', '20386', 'S');
INSERT INTO `ey_region` VALUES ('20388', '泰山区', '3', '20386', 'T');
INSERT INTO `ey_region` VALUES ('20397', '岱岳区', '3', '20386', 'D');
INSERT INTO `ey_region` VALUES ('20416', '宁阳县', '3', '20386', 'N');
INSERT INTO `ey_region` VALUES ('20429', '东平县', '3', '20386', 'D');
INSERT INTO `ey_region` VALUES ('20444', '新泰市', '3', '20386', 'X');
INSERT INTO `ey_region` VALUES ('20465', '肥城市', '3', '20386', 'F');
INSERT INTO `ey_region` VALUES ('20480', '威海市', '2', '19280', 'W');
INSERT INTO `ey_region` VALUES ('20481', '市辖区', '3', '20480', 'S');
INSERT INTO `ey_region` VALUES ('20482', '环翠区', '3', '20480', 'H');
INSERT INTO `ey_region` VALUES ('20500', '文登市', '3', '20480', 'W');
INSERT INTO `ey_region` VALUES ('20519', '荣成市', '3', '20480', 'R');
INSERT INTO `ey_region` VALUES ('20542', '乳山市', '3', '20480', 'R');
INSERT INTO `ey_region` VALUES ('20558', '日照市', '2', '19280', 'R');
INSERT INTO `ey_region` VALUES ('20559', '市辖区', '3', '20558', 'S');
INSERT INTO `ey_region` VALUES ('20560', '东港区', '3', '20558', 'D');
INSERT INTO `ey_region` VALUES ('20573', '岚山区', '3', '20558', 'L');
INSERT INTO `ey_region` VALUES ('20583', '五莲县', '3', '20558', 'W');
INSERT INTO `ey_region` VALUES ('20596', '莒县', '3', '20558', 'J');
INSERT INTO `ey_region` VALUES ('20618', '莱芜市', '2', '19280', 'L');
INSERT INTO `ey_region` VALUES ('20619', '市辖区', '3', '20618', 'S');
INSERT INTO `ey_region` VALUES ('20620', '莱城区', '3', '20618', 'L');
INSERT INTO `ey_region` VALUES ('20636', '钢城区', '3', '20618', 'G');
INSERT INTO `ey_region` VALUES ('20642', '临沂市', '2', '19280', 'L');
INSERT INTO `ey_region` VALUES ('20643', '临沂市辖区', '3', '20642', 'L');
INSERT INTO `ey_region` VALUES ('20644', '兰山区', '3', '20642', 'L');
INSERT INTO `ey_region` VALUES ('20656', '罗庄区', '3', '20642', 'L');
INSERT INTO `ey_region` VALUES ('20665', '河东区', '3', '20642', 'H');
INSERT INTO `ey_region` VALUES ('20678', '沂南县', '3', '20642', 'Y');
INSERT INTO `ey_region` VALUES ('20696', '郯城县', '3', '20642', 'T');
INSERT INTO `ey_region` VALUES ('20714', '沂水县', '3', '20642', 'Y');
INSERT INTO `ey_region` VALUES ('20734', '苍山县', '3', '20642', 'C');
INSERT INTO `ey_region` VALUES ('20756', '费县', '3', '20642', 'F');
INSERT INTO `ey_region` VALUES ('20775', '平邑县', '3', '20642', 'P');
INSERT INTO `ey_region` VALUES ('20792', '莒南县', '3', '20642', 'J');
INSERT INTO `ey_region` VALUES ('20811', '蒙阴县', '3', '20642', 'M');
INSERT INTO `ey_region` VALUES ('20823', '临沭县', '3', '20642', 'L');
INSERT INTO `ey_region` VALUES ('20836', '德州市', '2', '19280', 'D');
INSERT INTO `ey_region` VALUES ('20837', '市辖区', '3', '20836', 'S');
INSERT INTO `ey_region` VALUES ('20838', '德城区', '3', '20836', 'D');
INSERT INTO `ey_region` VALUES ('20850', '陵县', '3', '20836', 'L');
INSERT INTO `ey_region` VALUES ('20864', '宁津县', '3', '20836', 'N');
INSERT INTO `ey_region` VALUES ('20876', '庆云县', '3', '20836', 'Q');
INSERT INTO `ey_region` VALUES ('20886', '临邑县', '3', '20836', 'L');
INSERT INTO `ey_region` VALUES ('20899', '齐河县', '3', '20836', 'Q');
INSERT INTO `ey_region` VALUES ('20914', '平原县', '3', '20836', 'P');
INSERT INTO `ey_region` VALUES ('20927', '夏津县', '3', '20836', 'X');
INSERT INTO `ey_region` VALUES ('20942', '武城县', '3', '20836', 'W');
INSERT INTO `ey_region` VALUES ('20952', '乐陵市', '3', '20836', 'L');
INSERT INTO `ey_region` VALUES ('20969', '禹城市', '3', '20836', 'Y');
INSERT INTO `ey_region` VALUES ('20981', '聊城市', '2', '19280', 'L');
INSERT INTO `ey_region` VALUES ('20982', '市辖区', '3', '20981', 'S');
INSERT INTO `ey_region` VALUES ('20983', '东昌府区', '3', '20981', 'D');
INSERT INTO `ey_region` VALUES ('21004', '阳谷县', '3', '20981', 'Y');
INSERT INTO `ey_region` VALUES ('21023', '莘县', '3', '20981', 'S');
INSERT INTO `ey_region` VALUES ('21046', '茌平县', '3', '20981', 'C');
INSERT INTO `ey_region` VALUES ('21063', '东阿县', '3', '20981', 'D');
INSERT INTO `ey_region` VALUES ('21075', '冠县', '3', '20981', 'G');
INSERT INTO `ey_region` VALUES ('21093', '高唐县', '3', '20981', 'G');
INSERT INTO `ey_region` VALUES ('21106', '临清市', '3', '20981', 'L');
INSERT INTO `ey_region` VALUES ('21123', '滨州市', '2', '19280', 'B');
INSERT INTO `ey_region` VALUES ('21124', '市辖区', '3', '21123', 'S');
INSERT INTO `ey_region` VALUES ('21125', '滨城区', '3', '21123', 'B');
INSERT INTO `ey_region` VALUES ('21141', '惠民县', '3', '21123', 'H');
INSERT INTO `ey_region` VALUES ('21156', '阳信县', '3', '21123', 'Y');
INSERT INTO `ey_region` VALUES ('21166', '无棣县', '3', '21123', 'W');
INSERT INTO `ey_region` VALUES ('21178', '沾化县', '3', '21123', 'Z');
INSERT INTO `ey_region` VALUES ('21190', '博兴县', '3', '21123', 'B');
INSERT INTO `ey_region` VALUES ('21201', '邹平县', '3', '21123', 'Z');
INSERT INTO `ey_region` VALUES ('21218', '菏泽市', '2', '19280', 'H');
INSERT INTO `ey_region` VALUES ('21219', '市辖区', '3', '21218', 'S');
INSERT INTO `ey_region` VALUES ('21220', '牡丹区', '3', '21218', 'M');
INSERT INTO `ey_region` VALUES ('21245', '曹县', '3', '21218', 'C');
INSERT INTO `ey_region` VALUES ('21271', '单县', '3', '21218', 'D');
INSERT INTO `ey_region` VALUES ('21292', '成武县', '3', '21218', 'C');
INSERT INTO `ey_region` VALUES ('21305', '巨野县', '3', '21218', 'J');
INSERT INTO `ey_region` VALUES ('21322', '郓城县', '3', '21218', 'Y');
INSERT INTO `ey_region` VALUES ('21344', '鄄城县', '3', '21218', 'J');
INSERT INTO `ey_region` VALUES ('21361', '定陶县', '3', '21218', 'D');
INSERT INTO `ey_region` VALUES ('21373', '东明县', '3', '21218', 'D');
INSERT INTO `ey_region` VALUES ('21387', '河南省', '1', '0', 'H');
INSERT INTO `ey_region` VALUES ('21388', '郑州市', '2', '21387', 'Z');
INSERT INTO `ey_region` VALUES ('21389', '市辖区', '3', '21388', 'S');
INSERT INTO `ey_region` VALUES ('21390', '中原区', '3', '21388', 'Z');
INSERT INTO `ey_region` VALUES ('21404', '二七区', '3', '21388', 'E');
INSERT INTO `ey_region` VALUES ('21420', '管城回族区', '3', '21388', 'G');
INSERT INTO `ey_region` VALUES ('21435', '金水区', '3', '21388', 'J');
INSERT INTO `ey_region` VALUES ('21453', '上街区', '3', '21388', 'S');
INSERT INTO `ey_region` VALUES ('21460', '惠济区', '3', '21388', 'H');
INSERT INTO `ey_region` VALUES ('21469', '中牟县', '3', '21388', 'Z');
INSERT INTO `ey_region` VALUES ('21487', '巩义市', '3', '21388', 'G');
INSERT INTO `ey_region` VALUES ('21508', '荥阳市', '3', '21388', 'X');
INSERT INTO `ey_region` VALUES ('21523', '新密市', '3', '21388', 'X');
INSERT INTO `ey_region` VALUES ('21542', '新郑市', '3', '21388', 'X');
INSERT INTO `ey_region` VALUES ('21558', '登封市', '3', '21388', 'D');
INSERT INTO `ey_region` VALUES ('21575', '开封市', '2', '21387', 'K');
INSERT INTO `ey_region` VALUES ('21576', '市辖区', '3', '21575', 'S');
INSERT INTO `ey_region` VALUES ('21577', '龙亭区', '3', '21575', 'L');
INSERT INTO `ey_region` VALUES ('21584', '顺河区', '3', '21575', 'S');
INSERT INTO `ey_region` VALUES ('21593', '鼓楼区', '3', '21575', 'G');
INSERT INTO `ey_region` VALUES ('21602', '禹王台区', '3', '21575', 'Y');
INSERT INTO `ey_region` VALUES ('21610', '金明区', '3', '21575', 'J');
INSERT INTO `ey_region` VALUES ('21618', '杞县', '3', '21575', 'Q');
INSERT INTO `ey_region` VALUES ('21640', '通许县', '3', '21575', 'T');
INSERT INTO `ey_region` VALUES ('21653', '尉氏县', '3', '21575', 'W');
INSERT INTO `ey_region` VALUES ('21671', '开封县', '3', '21575', 'K');
INSERT INTO `ey_region` VALUES ('21687', '兰考县', '3', '21575', 'L');
INSERT INTO `ey_region` VALUES ('21711', '洛阳市', '2', '21387', 'L');
INSERT INTO `ey_region` VALUES ('21712', '市辖区', '3', '21711', 'S');
INSERT INTO `ey_region` VALUES ('21713', '老城区', '3', '21711', 'L');
INSERT INTO `ey_region` VALUES ('21722', '西工区', '3', '21711', 'X');
INSERT INTO `ey_region` VALUES ('21733', '廛河回族区', '3', '21711', 'C');
INSERT INTO `ey_region` VALUES ('21742', '涧西区', '3', '21711', 'J');
INSERT INTO `ey_region` VALUES ('21758', '吉利区', '3', '21711', 'J');
INSERT INTO `ey_region` VALUES ('21761', '洛龙区', '3', '21711', 'L');
INSERT INTO `ey_region` VALUES ('21770', '孟津县', '3', '21711', 'M');
INSERT INTO `ey_region` VALUES ('21781', '新安县', '3', '21711', 'X');
INSERT INTO `ey_region` VALUES ('21794', '栾川县', '3', '21711', 'L');
INSERT INTO `ey_region` VALUES ('21809', '嵩县', '3', '21711', 'S');
INSERT INTO `ey_region` VALUES ('21829', '汝阳县', '3', '21711', 'R');
INSERT INTO `ey_region` VALUES ('21844', '宜阳县', '3', '21711', 'Y');
INSERT INTO `ey_region` VALUES ('21862', '洛宁县', '3', '21711', 'L');
INSERT INTO `ey_region` VALUES ('21881', '伊川县', '3', '21711', 'Y');
INSERT INTO `ey_region` VALUES ('21896', '偃师市', '3', '21711', 'Y');
INSERT INTO `ey_region` VALUES ('21913', '平顶山市', '2', '21387', 'P');
INSERT INTO `ey_region` VALUES ('21914', '市辖区', '3', '21913', 'S');
INSERT INTO `ey_region` VALUES ('21915', '新华区', '3', '21913', 'X');
INSERT INTO `ey_region` VALUES ('21928', '卫东区', '3', '21913', 'W');
INSERT INTO `ey_region` VALUES ('21940', '石龙区', '3', '21913', 'S');
INSERT INTO `ey_region` VALUES ('21945', '湛河区', '3', '21913', 'Z');
INSERT INTO `ey_region` VALUES ('21954', '宝丰县', '3', '21913', 'B');
INSERT INTO `ey_region` VALUES ('21968', '叶  县', '3', '21913', 'Y');
INSERT INTO `ey_region` VALUES ('21987', '鲁山县', '3', '21913', 'L');
INSERT INTO `ey_region` VALUES ('22009', '郏  县', '3', '21913', 'J');
INSERT INTO `ey_region` VALUES ('22024', '舞钢市', '3', '21913', 'W');
INSERT INTO `ey_region` VALUES ('22037', '汝州市', '3', '21913', 'R');
INSERT INTO `ey_region` VALUES ('22058', '安阳市', '2', '21387', 'A');
INSERT INTO `ey_region` VALUES ('22059', '市辖区', '3', '22058', 'S');
INSERT INTO `ey_region` VALUES ('22060', '文峰区', '3', '22058', 'W');
INSERT INTO `ey_region` VALUES ('22080', '北关区', '3', '22058', 'B');
INSERT INTO `ey_region` VALUES ('22090', '殷都区', '3', '22058', 'Y');
INSERT INTO `ey_region` VALUES ('22101', '龙安区', '3', '22058', 'L');
INSERT INTO `ey_region` VALUES ('22111', '安阳县', '3', '22058', 'A');
INSERT INTO `ey_region` VALUES ('22133', '汤阴县', '3', '22058', 'T');
INSERT INTO `ey_region` VALUES ('22144', '滑县', '3', '22058', 'H');
INSERT INTO `ey_region` VALUES ('22167', '内黄县', '3', '22058', 'N');
INSERT INTO `ey_region` VALUES ('22185', '林州市', '3', '22058', 'L');
INSERT INTO `ey_region` VALUES ('22206', '鹤壁市', '2', '21387', 'H');
INSERT INTO `ey_region` VALUES ('22207', '市辖区', '3', '22206', 'S');
INSERT INTO `ey_region` VALUES ('22208', '鹤山区', '3', '22206', 'H');
INSERT INTO `ey_region` VALUES ('22216', '山城区', '3', '22206', 'S');
INSERT INTO `ey_region` VALUES ('22224', '淇滨区', '3', '22206', 'Q');
INSERT INTO `ey_region` VALUES ('22232', '浚县', '3', '22206', 'J');
INSERT INTO `ey_region` VALUES ('22243', '淇县', '3', '22206', 'Q');
INSERT INTO `ey_region` VALUES ('22251', '新乡市', '2', '21387', 'X');
INSERT INTO `ey_region` VALUES ('22252', '市辖区', '3', '22251', 'S');
INSERT INTO `ey_region` VALUES ('22253', '红旗区', '3', '22251', 'H');
INSERT INTO `ey_region` VALUES ('22264', '卫滨区', '3', '22251', 'W');
INSERT INTO `ey_region` VALUES ('22273', '凤泉区', '3', '22251', 'F');
INSERT INTO `ey_region` VALUES ('22279', '牧野区', '3', '22251', 'M');
INSERT INTO `ey_region` VALUES ('22290', '新乡县', '3', '22251', 'X');
INSERT INTO `ey_region` VALUES ('22299', '获嘉县', '3', '22251', 'H');
INSERT INTO `ey_region` VALUES ('22312', '原阳县', '3', '22251', 'Y');
INSERT INTO `ey_region` VALUES ('22330', '延津县', '3', '22251', 'Y');
INSERT INTO `ey_region` VALUES ('22347', '封丘县', '3', '22251', 'F');
INSERT INTO `ey_region` VALUES ('22367', '长垣县', '3', '22251', 'C');
INSERT INTO `ey_region` VALUES ('22386', '卫辉市', '3', '22251', 'W');
INSERT INTO `ey_region` VALUES ('22400', '辉县市', '3', '22251', 'H');
INSERT INTO `ey_region` VALUES ('22423', '焦作市', '2', '21387', 'J');
INSERT INTO `ey_region` VALUES ('22424', '市辖区', '3', '22423', 'S');
INSERT INTO `ey_region` VALUES ('22425', '解放区', '3', '22423', 'J');
INSERT INTO `ey_region` VALUES ('22435', '中站区', '3', '22423', 'Z');
INSERT INTO `ey_region` VALUES ('22446', '马村区', '3', '22423', 'M');
INSERT INTO `ey_region` VALUES ('22454', '山阳区', '3', '22423', 'S');
INSERT INTO `ey_region` VALUES ('22465', '修武县', '3', '22423', 'X');
INSERT INTO `ey_region` VALUES ('22475', '博爱县', '3', '22423', 'B');
INSERT INTO `ey_region` VALUES ('22487', '武陟县', '3', '22423', 'W');
INSERT INTO `ey_region` VALUES ('22503', '温县', '3', '22423', 'W');
INSERT INTO `ey_region` VALUES ('22515', '济源市', '3', '22423', 'J');
INSERT INTO `ey_region` VALUES ('22532', '沁阳市', '3', '22423', 'Q');
INSERT INTO `ey_region` VALUES ('22546', '孟州市', '3', '22423', 'M');
INSERT INTO `ey_region` VALUES ('22558', '濮阳市', '2', '21387', 'P');
INSERT INTO `ey_region` VALUES ('22559', '市辖区', '3', '22558', 'S');
INSERT INTO `ey_region` VALUES ('22560', '华龙区', '3', '22558', 'H');
INSERT INTO `ey_region` VALUES ('22578', '清丰县', '3', '22558', 'Q');
INSERT INTO `ey_region` VALUES ('22596', '南乐县', '3', '22558', 'N');
INSERT INTO `ey_region` VALUES ('22609', '范县', '3', '22558', 'F');
INSERT INTO `ey_region` VALUES ('22622', '台前县', '3', '22558', 'T');
INSERT INTO `ey_region` VALUES ('22632', '濮阳县', '3', '22558', 'P');
INSERT INTO `ey_region` VALUES ('22655', '许昌市', '2', '21387', 'X');
INSERT INTO `ey_region` VALUES ('22656', '市辖区', '3', '22655', 'S');
INSERT INTO `ey_region` VALUES ('22657', '魏都区', '3', '22655', 'W');
INSERT INTO `ey_region` VALUES ('22671', '许昌县', '3', '22655', 'X');
INSERT INTO `ey_region` VALUES ('22688', '鄢陵县', '3', '22655', 'Y');
INSERT INTO `ey_region` VALUES ('22701', '襄城县', '3', '22655', 'X');
INSERT INTO `ey_region` VALUES ('22718', '禹州市', '3', '22655', 'Y');
INSERT INTO `ey_region` VALUES ('22745', '长葛市', '3', '22655', 'C');
INSERT INTO `ey_region` VALUES ('22762', '漯河市', '2', '21387', 'L');
INSERT INTO `ey_region` VALUES ('22763', '市辖区', '3', '22762', 'S');
INSERT INTO `ey_region` VALUES ('22764', '源汇区', '3', '22762', 'Y');
INSERT INTO `ey_region` VALUES ('22773', '郾城区', '3', '22762', 'Y');
INSERT INTO `ey_region` VALUES ('22783', '召陵区', '3', '22762', 'Z');
INSERT INTO `ey_region` VALUES ('22793', '舞阳县', '3', '22762', 'W');
INSERT INTO `ey_region` VALUES ('22808', '临颖县', '3', '22762', 'L');
INSERT INTO `ey_region` VALUES ('22824', '三门峡市', '2', '21387', 'S');
INSERT INTO `ey_region` VALUES ('22825', '市辖区', '3', '22824', 'S');
INSERT INTO `ey_region` VALUES ('22826', '湖滨区', '3', '22824', 'H');
INSERT INTO `ey_region` VALUES ('22838', '渑池县', '3', '22824', 'M');
INSERT INTO `ey_region` VALUES ('22851', '陕县', '3', '22824', 'S');
INSERT INTO `ey_region` VALUES ('22865', '卢氏县', '3', '22824', 'L');
INSERT INTO `ey_region` VALUES ('22885', '义马市', '3', '22824', 'Y');
INSERT INTO `ey_region` VALUES ('22893', '灵宝市', '3', '22824', 'L');
INSERT INTO `ey_region` VALUES ('22910', '南阳市', '2', '21387', 'N');
INSERT INTO `ey_region` VALUES ('22911', '市辖区', '3', '22910', 'S');
INSERT INTO `ey_region` VALUES ('22912', '宛城区', '3', '22910', 'W');
INSERT INTO `ey_region` VALUES ('22930', '卧龙区', '3', '22910', 'W');
INSERT INTO `ey_region` VALUES ('22951', '南召县', '3', '22910', 'N');
INSERT INTO `ey_region` VALUES ('22973', '方城县', '3', '22910', 'F');
INSERT INTO `ey_region` VALUES ('22992', '西峡县', '3', '22910', 'X');
INSERT INTO `ey_region` VALUES ('23013', '镇平县', '3', '22910', 'Z');
INSERT INTO `ey_region` VALUES ('23036', '内乡县', '3', '22910', 'N');
INSERT INTO `ey_region` VALUES ('23053', '淅川县', '3', '22910', 'X');
INSERT INTO `ey_region` VALUES ('23071', '社旗县', '3', '22910', 'S');
INSERT INTO `ey_region` VALUES ('23087', '唐河县', '3', '22910', 'T');
INSERT INTO `ey_region` VALUES ('23108', '新野县', '3', '22910', 'X');
INSERT INTO `ey_region` VALUES ('23123', '桐柏县', '3', '22910', 'T');
INSERT INTO `ey_region` VALUES ('23140', '邓州市', '3', '22910', 'D');
INSERT INTO `ey_region` VALUES ('23170', '商丘市', '2', '21387', 'S');
INSERT INTO `ey_region` VALUES ('23171', '市辖区', '3', '23170', 'S');
INSERT INTO `ey_region` VALUES ('23172', '梁园区', '3', '23170', 'L');
INSERT INTO `ey_region` VALUES ('23192', '睢阳区', '3', '23170', 'S');
INSERT INTO `ey_region` VALUES ('23211', '民权县', '3', '23170', 'M');
INSERT INTO `ey_region` VALUES ('23232', '睢县', '3', '23170', 'S');
INSERT INTO `ey_region` VALUES ('23253', '宁陵县', '3', '23170', 'N');
INSERT INTO `ey_region` VALUES ('23268', '柘城县', '3', '23170', 'Z');
INSERT INTO `ey_region` VALUES ('23290', '虞城县', '3', '23170', 'Y');
INSERT INTO `ey_region` VALUES ('23317', '夏邑县', '3', '23170', 'X');
INSERT INTO `ey_region` VALUES ('23342', '永城市', '3', '23170', 'Y');
INSERT INTO `ey_region` VALUES ('23372', '信阳市', '2', '21387', 'X');
INSERT INTO `ey_region` VALUES ('23373', '市辖区', '3', '23372', 'S');
INSERT INTO `ey_region` VALUES ('23374', '浉河区', '3', '23372', 'S');
INSERT INTO `ey_region` VALUES ('23393', '平桥区', '3', '23372', 'P');
INSERT INTO `ey_region` VALUES ('23414', '罗山县', '3', '23372', 'L');
INSERT INTO `ey_region` VALUES ('23435', '光山县', '3', '23372', 'G');
INSERT INTO `ey_region` VALUES ('23455', '新县', '3', '23372', 'X');
INSERT INTO `ey_region` VALUES ('23471', '商城县', '3', '23372', 'S');
INSERT INTO `ey_region` VALUES ('23492', '固始县', '3', '23372', 'G');
INSERT INTO `ey_region` VALUES ('23525', '潢川县', '3', '23372', 'H');
INSERT INTO `ey_region` VALUES ('23549', '淮滨县', '3', '23372', 'H');
INSERT INTO `ey_region` VALUES ('23567', '息县', '3', '23372', 'X');
INSERT INTO `ey_region` VALUES ('23589', '周口市', '2', '21387', 'Z');
INSERT INTO `ey_region` VALUES ('23590', '市辖区', '3', '23589', 'S');
INSERT INTO `ey_region` VALUES ('23591', '川汇区', '3', '23589', 'C');
INSERT INTO `ey_region` VALUES ('23604', '扶沟县', '3', '23589', 'F');
INSERT INTO `ey_region` VALUES ('23621', '西华县', '3', '23589', 'X');
INSERT INTO `ey_region` VALUES ('23647', '商水县', '3', '23589', 'S');
INSERT INTO `ey_region` VALUES ('23672', '沈丘县', '3', '23589', 'S');
INSERT INTO `ey_region` VALUES ('23695', '郸城县', '3', '23589', 'D');
INSERT INTO `ey_region` VALUES ('23716', '淮阳县', '3', '23589', 'H');
INSERT INTO `ey_region` VALUES ('23736', '太康县', '3', '23589', 'T');
INSERT INTO `ey_region` VALUES ('23766', '鹿邑县', '3', '23589', 'L');
INSERT INTO `ey_region` VALUES ('23796', '项城市', '3', '23589', 'X');
INSERT INTO `ey_region` VALUES ('23818', '驻马店市', '2', '21387', 'Z');
INSERT INTO `ey_region` VALUES ('23819', '市辖区', '3', '23818', 'S');
INSERT INTO `ey_region` VALUES ('23820', '驿城区', '3', '23818', 'Y');
INSERT INTO `ey_region` VALUES ('23840', '西平县', '3', '23818', 'X');
INSERT INTO `ey_region` VALUES ('23861', '上蔡县', '3', '23818', 'S');
INSERT INTO `ey_region` VALUES ('23886', '平舆县', '3', '23818', 'P');
INSERT INTO `ey_region` VALUES ('23905', '正阳县', '3', '23818', 'Z');
INSERT INTO `ey_region` VALUES ('23926', '确山县', '3', '23818', 'Q');
INSERT INTO `ey_region` VALUES ('23940', '泌阳县', '3', '23818', 'M');
INSERT INTO `ey_region` VALUES ('23965', '汝南县', '3', '23818', 'R');
INSERT INTO `ey_region` VALUES ('23983', '遂平县', '3', '23818', 'S');
INSERT INTO `ey_region` VALUES ('23999', '新蔡县', '3', '23818', 'X');
INSERT INTO `ey_region` VALUES ('24022', '湖北省', '1', '0', 'H');
INSERT INTO `ey_region` VALUES ('24023', '武汉市', '2', '24022', 'W');
INSERT INTO `ey_region` VALUES ('24024', '市辖区', '3', '24023', 'S');
INSERT INTO `ey_region` VALUES ('24025', '江岸区', '3', '24023', 'J');
INSERT INTO `ey_region` VALUES ('24043', '江汉区', '3', '24023', 'J');
INSERT INTO `ey_region` VALUES ('24057', '硚口区', '3', '24023', 'Q');
INSERT INTO `ey_region` VALUES ('24069', '汉阳区', '3', '24023', 'H');
INSERT INTO `ey_region` VALUES ('24082', '武昌区', '3', '24023', 'W');
INSERT INTO `ey_region` VALUES ('24098', '青山区', '3', '24023', 'Q');
INSERT INTO `ey_region` VALUES ('24111', '洪山区', '3', '24023', 'H');
INSERT INTO `ey_region` VALUES ('24129', '东西湖区', '3', '24023', 'D');
INSERT INTO `ey_region` VALUES ('24142', '汉南区', '3', '24023', 'H');
INSERT INTO `ey_region` VALUES ('24150', '蔡甸区', '3', '24023', 'C');
INSERT INTO `ey_region` VALUES ('24165', '江夏区', '3', '24023', 'J');
INSERT INTO `ey_region` VALUES ('24185', '黄陂区', '3', '24023', 'H');
INSERT INTO `ey_region` VALUES ('24205', '武汉市新洲区', '3', '24023', 'W');
INSERT INTO `ey_region` VALUES ('24224', '黄石市', '2', '24022', 'H');
INSERT INTO `ey_region` VALUES ('24225', '市辖区', '3', '24224', 'S');
INSERT INTO `ey_region` VALUES ('24226', '黄石港区', '3', '24224', 'H');
INSERT INTO `ey_region` VALUES ('24233', '西塞山区', '3', '24224', 'X');
INSERT INTO `ey_region` VALUES ('24242', '下陆区', '3', '24224', 'X');
INSERT INTO `ey_region` VALUES ('24247', '铁山区', '3', '24224', 'T');
INSERT INTO `ey_region` VALUES ('24250', '阳新县', '3', '24224', 'Y');
INSERT INTO `ey_region` VALUES ('24273', '大冶市', '3', '24224', 'D');
INSERT INTO `ey_region` VALUES ('24291', '十堰市', '2', '24022', 'S');
INSERT INTO `ey_region` VALUES ('24292', '市辖区', '3', '24291', 'S');
INSERT INTO `ey_region` VALUES ('24293', '茅箭区', '3', '24291', 'M');
INSERT INTO `ey_region` VALUES ('24302', '张湾区', '3', '24291', 'Z');
INSERT INTO `ey_region` VALUES ('24314', '郧县', '3', '24291', 'Y');
INSERT INTO `ey_region` VALUES ('24335', '郧西县', '3', '24291', 'Y');
INSERT INTO `ey_region` VALUES ('24354', '竹山县', '3', '24291', 'Z');
INSERT INTO `ey_region` VALUES ('24374', '竹溪县', '3', '24291', 'Z');
INSERT INTO `ey_region` VALUES ('24405', '房县', '3', '24291', 'F');
INSERT INTO `ey_region` VALUES ('24435', '丹江口市', '3', '24291', 'D');
INSERT INTO `ey_region` VALUES ('24453', '宜昌市', '2', '24022', 'Y');
INSERT INTO `ey_region` VALUES ('24454', '市辖区', '3', '24453', 'S');
INSERT INTO `ey_region` VALUES ('24455', '西陵区', '3', '24453', 'X');
INSERT INTO `ey_region` VALUES ('24465', '伍家岗区', '3', '24453', 'W');
INSERT INTO `ey_region` VALUES ('24471', '点军区', '3', '24453', 'D');
INSERT INTO `ey_region` VALUES ('24477', '猇亭区', '3', '24453', 'X');
INSERT INTO `ey_region` VALUES ('24481', '夷陵区', '3', '24453', 'Y');
INSERT INTO `ey_region` VALUES ('24495', '远安县', '3', '24453', 'Y');
INSERT INTO `ey_region` VALUES ('24503', '兴山县', '3', '24453', 'X');
INSERT INTO `ey_region` VALUES ('24512', '秭归县', '3', '24453', 'Z');
INSERT INTO `ey_region` VALUES ('24525', '长阳县', '3', '24453', 'C');
INSERT INTO `ey_region` VALUES ('24537', '五峰县', '3', '24453', 'W');
INSERT INTO `ey_region` VALUES ('24546', '宜都市', '3', '24453', 'Y');
INSERT INTO `ey_region` VALUES ('24559', '当阳市', '3', '24453', 'D');
INSERT INTO `ey_region` VALUES ('24570', '枝江市', '3', '24453', 'Z');
INSERT INTO `ey_region` VALUES ('24580', '襄樊市', '2', '24022', 'X');
INSERT INTO `ey_region` VALUES ('24581', '市辖区', '3', '24580', 'S');
INSERT INTO `ey_region` VALUES ('24582', '襄城区', '3', '24580', 'X');
INSERT INTO `ey_region` VALUES ('24591', '樊城区', '3', '24580', 'F');
INSERT INTO `ey_region` VALUES ('24608', '襄阳区', '3', '24580', 'X');
INSERT INTO `ey_region` VALUES ('24623', '南漳县', '3', '24580', 'N');
INSERT INTO `ey_region` VALUES ('24635', '谷城县', '3', '24580', 'G');
INSERT INTO `ey_region` VALUES ('24647', '保康县', '3', '24580', 'B');
INSERT INTO `ey_region` VALUES ('24659', '老河口市', '3', '24580', 'L');
INSERT INTO `ey_region` VALUES ('24674', '枣阳市', '3', '24580', 'Z');
INSERT INTO `ey_region` VALUES ('24692', '宜城市', '3', '24580', 'Y');
INSERT INTO `ey_region` VALUES ('24706', '鄂州市', '2', '24022', 'E');
INSERT INTO `ey_region` VALUES ('24707', '市辖区', '3', '24706', 'S');
INSERT INTO `ey_region` VALUES ('24708', '粱子湖区', '3', '24706', 'L');
INSERT INTO `ey_region` VALUES ('24714', '华容区', '3', '24706', 'H');
INSERT INTO `ey_region` VALUES ('24722', '鄂城区', '3', '24706', 'E');
INSERT INTO `ey_region` VALUES ('24737', '荆门市', '2', '24022', 'J');
INSERT INTO `ey_region` VALUES ('24738', '市辖区', '3', '24737', 'S');
INSERT INTO `ey_region` VALUES ('24739', '东宝区', '3', '24737', 'D');
INSERT INTO `ey_region` VALUES ('24749', '掇刀区', '3', '24737', 'D');
INSERT INTO `ey_region` VALUES ('24755', '京山县', '3', '24737', 'J');
INSERT INTO `ey_region` VALUES ('24778', '沙洋县', '3', '24737', 'S');
INSERT INTO `ey_region` VALUES ('24794', '钟祥市', '3', '24737', 'Z');
INSERT INTO `ey_region` VALUES ('24816', '孝感市', '2', '24022', 'X');
INSERT INTO `ey_region` VALUES ('24817', '市辖区', '3', '24816', 'S');
INSERT INTO `ey_region` VALUES ('24818', '孝南区', '3', '24816', 'X');
INSERT INTO `ey_region` VALUES ('24838', '孝昌县', '3', '24816', 'X');
INSERT INTO `ey_region` VALUES ('24853', '大悟县', '3', '24816', 'D');
INSERT INTO `ey_region` VALUES ('24871', '云梦县', '3', '24816', 'Y');
INSERT INTO `ey_region` VALUES ('24885', '应城市', '3', '24816', 'Y');
INSERT INTO `ey_region` VALUES ('24903', '安陆市', '3', '24816', 'A');
INSERT INTO `ey_region` VALUES ('24920', '汉川市', '3', '24816', 'H');
INSERT INTO `ey_region` VALUES ('24949', '荆州市', '2', '24022', 'J');
INSERT INTO `ey_region` VALUES ('24950', '市辖区', '3', '24949', 'S');
INSERT INTO `ey_region` VALUES ('24951', '沙市区', '3', '24949', 'S');
INSERT INTO `ey_region` VALUES ('24965', '荆州区', '3', '24949', 'J');
INSERT INTO `ey_region` VALUES ('24978', '公安县', '3', '24949', 'G');
INSERT INTO `ey_region` VALUES ('24995', '监利县', '3', '24949', 'J');
INSERT INTO `ey_region` VALUES ('25019', '江陵县', '3', '24949', 'J');
INSERT INTO `ey_region` VALUES ('25032', '石首市', '3', '24949', 'S');
INSERT INTO `ey_region` VALUES ('25048', '洪湖市', '3', '24949', 'H');
INSERT INTO `ey_region` VALUES ('25069', '松滋市', '3', '24949', 'S');
INSERT INTO `ey_region` VALUES ('25086', '黄冈市', '2', '24022', 'H');
INSERT INTO `ey_region` VALUES ('25087', '市辖区', '3', '25086', 'S');
INSERT INTO `ey_region` VALUES ('25088', '黄州区', '3', '25086', 'H');
INSERT INTO `ey_region` VALUES ('25099', '团风县', '3', '25086', 'T');
INSERT INTO `ey_region` VALUES ('25112', '红安县', '3', '25086', 'H');
INSERT INTO `ey_region` VALUES ('25126', '罗田县', '3', '25086', 'L');
INSERT INTO `ey_region` VALUES ('25143', '英山县', '3', '25086', 'Y');
INSERT INTO `ey_region` VALUES ('25158', '浠水县', '3', '25086', 'X');
INSERT INTO `ey_region` VALUES ('25175', '蕲春县', '3', '25086', 'Q');
INSERT INTO `ey_region` VALUES ('25192', '黄梅县', '3', '25086', 'H');
INSERT INTO `ey_region` VALUES ('25211', '麻城市', '3', '25086', 'M');
INSERT INTO `ey_region` VALUES ('25235', '武穴市', '3', '25086', 'W');
INSERT INTO `ey_region` VALUES ('25249', '咸宁市', '2', '24022', 'X');
INSERT INTO `ey_region` VALUES ('25250', '市辖区', '3', '25249', 'S');
INSERT INTO `ey_region` VALUES ('25251', '咸安区', '3', '25249', 'X');
INSERT INTO `ey_region` VALUES ('25266', '嘉鱼县', '3', '25249', 'J');
INSERT INTO `ey_region` VALUES ('25276', '通城县', '3', '25249', 'T');
INSERT INTO `ey_region` VALUES ('25290', '崇阳县', '3', '25249', 'C');
INSERT INTO `ey_region` VALUES ('25303', '通山县', '3', '25249', 'T');
INSERT INTO `ey_region` VALUES ('25317', '赤壁市', '3', '25249', 'C');
INSERT INTO `ey_region` VALUES ('25335', '随州市', '2', '24022', 'S');
INSERT INTO `ey_region` VALUES ('25336', '市辖区', '3', '25335', 'S');
INSERT INTO `ey_region` VALUES ('25337', '曾都区', '3', '25335', 'Z');
INSERT INTO `ey_region` VALUES ('25367', '广水市', '3', '25335', 'G');
INSERT INTO `ey_region` VALUES ('25388', '恩施州', '2', '24022', 'E');
INSERT INTO `ey_region` VALUES ('25389', '恩施市', '3', '25388', 'E');
INSERT INTO `ey_region` VALUES ('25406', '利川市', '3', '25388', 'L');
INSERT INTO `ey_region` VALUES ('25422', '建始县', '3', '25388', 'J');
INSERT INTO `ey_region` VALUES ('25433', '巴东县', '3', '25388', 'B');
INSERT INTO `ey_region` VALUES ('25446', '宣恩县', '3', '25388', 'X');
INSERT INTO `ey_region` VALUES ('25456', '咸丰县', '3', '25388', 'X');
INSERT INTO `ey_region` VALUES ('25467', '来凤县', '3', '25388', 'L');
INSERT INTO `ey_region` VALUES ('25476', '鹤峰县', '3', '25388', 'H');
INSERT INTO `ey_region` VALUES ('25487', '省直辖行政单位', '2', '24022', 'S');
INSERT INTO `ey_region` VALUES ('25488', '仙桃市', '3', '25487', 'X');
INSERT INTO `ey_region` VALUES ('25516', '潜江市', '3', '25487', 'Q');
INSERT INTO `ey_region` VALUES ('25541', '天门市', '3', '25487', 'T');
INSERT INTO `ey_region` VALUES ('25570', '神农架林区', '3', '25487', 'S');
INSERT INTO `ey_region` VALUES ('25579', '湖南省', '1', '0', 'H');
INSERT INTO `ey_region` VALUES ('25580', '长沙市', '2', '25579', 'C');
INSERT INTO `ey_region` VALUES ('25581', '市辖区', '3', '25580', 'S');
INSERT INTO `ey_region` VALUES ('25582', '芙蓉区', '3', '25580', 'F');
INSERT INTO `ey_region` VALUES ('25596', '天心区', '3', '25580', 'T');
INSERT INTO `ey_region` VALUES ('25607', '岳麓区', '3', '25580', 'Y');
INSERT INTO `ey_region` VALUES ('25620', '开福区', '3', '25580', 'K');
INSERT INTO `ey_region` VALUES ('25634', '雨花区', '3', '25580', 'Y');
INSERT INTO `ey_region` VALUES ('25645', '长沙县', '3', '25580', 'C');
INSERT INTO `ey_region` VALUES ('25666', '望城县', '3', '25580', 'W');
INSERT INTO `ey_region` VALUES ('25686', '宁乡县', '3', '25580', 'N');
INSERT INTO `ey_region` VALUES ('25720', '浏阳市', '3', '25580', 'L');
INSERT INTO `ey_region` VALUES ('25758', '株洲市', '2', '25579', 'Z');
INSERT INTO `ey_region` VALUES ('25759', '市辖区', '3', '25758', 'S');
INSERT INTO `ey_region` VALUES ('25760', '荷塘区', '3', '25758', 'H');
INSERT INTO `ey_region` VALUES ('25768', '芦淞区', '3', '25758', 'L');
INSERT INTO `ey_region` VALUES ('25777', '石峰区', '3', '25758', 'S');
INSERT INTO `ey_region` VALUES ('25785', '天元区', '3', '25758', 'T');
INSERT INTO `ey_region` VALUES ('25791', '株洲县', '3', '25758', 'Z');
INSERT INTO `ey_region` VALUES ('25810', '攸县', '3', '25758', 'Y');
INSERT INTO `ey_region` VALUES ('25836', '茶陵县', '3', '25758', 'C');
INSERT INTO `ey_region` VALUES ('25863', '炎陵县', '3', '25758', 'Y');
INSERT INTO `ey_region` VALUES ('25881', '醴陵市', '3', '25758', 'L');
INSERT INTO `ey_region` VALUES ('25912', '湘潭市', '2', '25579', 'X');
INSERT INTO `ey_region` VALUES ('25913', '市辖区', '3', '25912', 'S');
INSERT INTO `ey_region` VALUES ('25914', '雨湖区', '3', '25912', 'Y');
INSERT INTO `ey_region` VALUES ('25929', '岳塘区', '3', '25912', 'Y');
INSERT INTO `ey_region` VALUES ('25947', '湘潭县', '3', '25912', 'X');
INSERT INTO `ey_region` VALUES ('25970', '湘乡市', '3', '25912', 'X');
INSERT INTO `ey_region` VALUES ('25993', '韶山市', '3', '25912', 'S');
INSERT INTO `ey_region` VALUES ('26001', '衡阳市', '2', '25579', 'H');
INSERT INTO `ey_region` VALUES ('26002', '市辖区', '3', '26001', 'S');
INSERT INTO `ey_region` VALUES ('26003', '珠晖区', '3', '26001', 'Z');
INSERT INTO `ey_region` VALUES ('26019', '雁峰区', '3', '26001', 'Y');
INSERT INTO `ey_region` VALUES ('26028', '石鼓区', '3', '26001', 'S');
INSERT INTO `ey_region` VALUES ('26037', '蒸湘区', '3', '26001', 'Z');
INSERT INTO `ey_region` VALUES ('26045', '南岳区', '3', '26001', 'N');
INSERT INTO `ey_region` VALUES ('26051', '衡阳县', '3', '26001', 'H');
INSERT INTO `ey_region` VALUES ('26080', '衡南县', '3', '26001', 'H');
INSERT INTO `ey_region` VALUES ('26112', '衡山县', '3', '26001', 'H');
INSERT INTO `ey_region` VALUES ('26130', '衡东县', '3', '26001', 'H');
INSERT INTO `ey_region` VALUES ('26155', '祁东县', '3', '26001', 'Q');
INSERT INTO `ey_region` VALUES ('26179', '耒阳市', '3', '26001', 'L');
INSERT INTO `ey_region` VALUES ('26215', '常宁市', '3', '26001', 'C');
INSERT INTO `ey_region` VALUES ('26242', '邵阳市', '2', '25579', 'S');
INSERT INTO `ey_region` VALUES ('26243', '市辖区', '3', '26242', 'S');
INSERT INTO `ey_region` VALUES ('26244', '双清区', '3', '26242', 'S');
INSERT INTO `ey_region` VALUES ('26257', '大祥区', '3', '26242', 'D');
INSERT INTO `ey_region` VALUES ('26272', '北塔区', '3', '26242', 'B');
INSERT INTO `ey_region` VALUES ('26279', '邵东县', '3', '26242', 'S');
INSERT INTO `ey_region` VALUES ('26306', '新邵县', '3', '26242', 'X');
INSERT INTO `ey_region` VALUES ('26322', '邵阳县', '3', '26242', 'S');
INSERT INTO `ey_region` VALUES ('26348', '隆回县', '3', '26242', 'L');
INSERT INTO `ey_region` VALUES ('26375', '洞口县', '3', '26242', 'D');
INSERT INTO `ey_region` VALUES ('26399', '绥宁县', '3', '26242', 'S');
INSERT INTO `ey_region` VALUES ('26425', '新宁县', '3', '26242', 'X');
INSERT INTO `ey_region` VALUES ('26444', '城步县', '3', '26242', 'C');
INSERT INTO `ey_region` VALUES ('26465', '武冈市', '3', '26242', 'W');
INSERT INTO `ey_region` VALUES ('26485', '岳阳市', '2', '25579', 'Y');
INSERT INTO `ey_region` VALUES ('26486', '市辖区', '3', '26485', 'S');
INSERT INTO `ey_region` VALUES ('26487', '岳阳楼区', '3', '26485', 'Y');
INSERT INTO `ey_region` VALUES ('26511', '云溪区', '3', '26485', 'Y');
INSERT INTO `ey_region` VALUES ('26521', '君山区', '3', '26485', 'J');
INSERT INTO `ey_region` VALUES ('26529', '岳阳县', '3', '26485', 'Y');
INSERT INTO `ey_region` VALUES ('26551', '华容县', '3', '26485', 'H');
INSERT INTO `ey_region` VALUES ('26572', '湘阴县', '3', '26485', 'X');
INSERT INTO `ey_region` VALUES ('26592', '平江县', '3', '26485', 'P');
INSERT INTO `ey_region` VALUES ('26620', '汩罗市', '3', '26485', 'G');
INSERT INTO `ey_region` VALUES ('26657', '临湘市', '3', '26485', 'L');
INSERT INTO `ey_region` VALUES ('26683', '常德市', '2', '25579', 'C');
INSERT INTO `ey_region` VALUES ('26684', '市辖区', '3', '26683', 'S');
INSERT INTO `ey_region` VALUES ('26685', '武陵区', '3', '26683', 'W');
INSERT INTO `ey_region` VALUES ('26702', '鼎城区', '3', '26683', 'D');
INSERT INTO `ey_region` VALUES ('26741', '安乡县', '3', '26683', 'A');
INSERT INTO `ey_region` VALUES ('26762', '汉寿县', '3', '26683', 'H');
INSERT INTO `ey_region` VALUES ('26793', '澧县', '3', '26683', 'L');
INSERT INTO `ey_region` VALUES ('26826', '临澧县', '3', '26683', 'L');
INSERT INTO `ey_region` VALUES ('26844', '桃源县', '3', '26683', 'T');
INSERT INTO `ey_region` VALUES ('26885', '石门县', '3', '26683', 'S');
INSERT INTO `ey_region` VALUES ('26912', '津市市', '3', '26683', 'J');
INSERT INTO `ey_region` VALUES ('26925', '张家界市', '2', '25579', 'Z');
INSERT INTO `ey_region` VALUES ('26926', '市辖区', '3', '26925', 'S');
INSERT INTO `ey_region` VALUES ('26927', '永定区', '3', '26925', 'Y');
INSERT INTO `ey_region` VALUES ('26959', '武陵源区', '3', '26925', 'W');
INSERT INTO `ey_region` VALUES ('26966', '慈利县', '3', '26925', 'C');
INSERT INTO `ey_region` VALUES ('26998', '桑植县', '3', '26925', 'S');
INSERT INTO `ey_region` VALUES ('27038', '益阳市', '2', '25579', 'Y');
INSERT INTO `ey_region` VALUES ('27039', '市辖区', '3', '27038', 'S');
INSERT INTO `ey_region` VALUES ('27040', '资阳区', '3', '27038', 'Z');
INSERT INTO `ey_region` VALUES ('27049', '赫山区', '3', '27038', 'H');
INSERT INTO `ey_region` VALUES ('27069', '南县', '3', '27038', 'N');
INSERT INTO `ey_region` VALUES ('27087', '桃江县', '3', '27038', 'T');
INSERT INTO `ey_region` VALUES ('27106', '安化县', '3', '27038', 'A');
INSERT INTO `ey_region` VALUES ('27130', '沅江市', '3', '27038', 'Y');
INSERT INTO `ey_region` VALUES ('27147', '郴州市', '2', '25579', 'C');
INSERT INTO `ey_region` VALUES ('27148', '市辖区', '3', '27147', 'S');
INSERT INTO `ey_region` VALUES ('27149', '北湖区', '3', '27147', 'B');
INSERT INTO `ey_region` VALUES ('27168', '苏仙区', '3', '27147', 'S');
INSERT INTO `ey_region` VALUES ('27188', '桂阳县', '3', '27147', 'G');
INSERT INTO `ey_region` VALUES ('27228', '宜章县', '3', '27147', 'Y');
INSERT INTO `ey_region` VALUES ('27256', '永兴县', '3', '27147', 'Y');
INSERT INTO `ey_region` VALUES ('27282', '嘉禾县', '3', '27147', 'J');
INSERT INTO `ey_region` VALUES ('27300', '临武县', '3', '27147', 'L');
INSERT INTO `ey_region` VALUES ('27323', '汝城县', '3', '27147', 'R');
INSERT INTO `ey_region` VALUES ('27347', '桂东县', '3', '27147', 'G');
INSERT INTO `ey_region` VALUES ('27367', '安仁县', '3', '27147', 'A');
INSERT INTO `ey_region` VALUES ('27389', '资兴市', '3', '27147', 'Z');
INSERT INTO `ey_region` VALUES ('27418', '永州市', '2', '25579', 'Y');
INSERT INTO `ey_region` VALUES ('27419', '市辖区', '3', '27418', 'S');
INSERT INTO `ey_region` VALUES ('27420', '零陵区', '3', '27418', 'L');
INSERT INTO `ey_region` VALUES ('27437', '冷水滩区', '3', '27418', 'L');
INSERT INTO `ey_region` VALUES ('27459', '祁阳县', '3', '27418', 'Q');
INSERT INTO `ey_region` VALUES ('27492', '东安县', '3', '27418', 'D');
INSERT INTO `ey_region` VALUES ('27511', '双牌县', '3', '27418', 'S');
INSERT INTO `ey_region` VALUES ('27527', '道县', '3', '27418', 'D');
INSERT INTO `ey_region` VALUES ('27554', '江永县', '3', '27418', 'J');
INSERT INTO `ey_region` VALUES ('27567', '宁远县', '3', '27418', 'N');
INSERT INTO `ey_region` VALUES ('27585', '蓝山县', '3', '27418', 'L');
INSERT INTO `ey_region` VALUES ('27606', '新田县', '3', '27418', 'X');
INSERT INTO `ey_region` VALUES ('27626', '江华县', '3', '27418', 'J');
INSERT INTO `ey_region` VALUES ('27650', '怀化市', '2', '25579', 'H');
INSERT INTO `ey_region` VALUES ('27651', '市辖区', '3', '27650', 'S');
INSERT INTO `ey_region` VALUES ('27652', '鹤城区', '3', '27650', 'H');
INSERT INTO `ey_region` VALUES ('27667', '中方县', '3', '27650', 'Z');
INSERT INTO `ey_region` VALUES ('27690', '沅陵县', '3', '27650', 'Y');
INSERT INTO `ey_region` VALUES ('27714', '辰溪县', '3', '27650', 'C');
INSERT INTO `ey_region` VALUES ('27745', '溆浦县', '3', '27650', 'X');
INSERT INTO `ey_region` VALUES ('27789', '会同县', '3', '27650', 'H');
INSERT INTO `ey_region` VALUES ('27815', '麻阳县', '3', '27650', 'M');
INSERT INTO `ey_region` VALUES ('27839', '新晃县', '3', '27650', 'X');
INSERT INTO `ey_region` VALUES ('27863', '芷江县', '3', '27650', 'Z');
INSERT INTO `ey_region` VALUES ('27892', '靖州苗族侗族县', '3', '27650', 'J');
INSERT INTO `ey_region` VALUES ('27906', '通道县', '3', '27650', 'T');
INSERT INTO `ey_region` VALUES ('27930', '洪江市', '3', '27650', 'H');
INSERT INTO `ey_region` VALUES ('27963', '娄底市', '2', '25579', 'L');
INSERT INTO `ey_region` VALUES ('27964', '市辖区', '3', '27963', 'S');
INSERT INTO `ey_region` VALUES ('27965', '娄星区', '3', '27963', 'L');
INSERT INTO `ey_region` VALUES ('27980', '双峰县', '3', '27963', 'S');
INSERT INTO `ey_region` VALUES ('27997', '新化县', '3', '27963', 'X');
INSERT INTO `ey_region` VALUES ('28027', '冷水江市', '3', '27963', 'L');
INSERT INTO `ey_region` VALUES ('28044', '涟源市', '3', '27963', 'L');
INSERT INTO `ey_region` VALUES ('28065', '湘西州', '2', '25579', 'X');
INSERT INTO `ey_region` VALUES ('28066', '吉首市', '3', '28065', 'J');
INSERT INTO `ey_region` VALUES ('28082', '泸溪县', '3', '28065', 'L');
INSERT INTO `ey_region` VALUES ('28099', '凤凰县', '3', '28065', 'F');
INSERT INTO `ey_region` VALUES ('28124', '花垣县', '3', '28065', 'H');
INSERT INTO `ey_region` VALUES ('28143', '保靖县', '3', '28065', 'B');
INSERT INTO `ey_region` VALUES ('28161', '古丈县', '3', '28065', 'G');
INSERT INTO `ey_region` VALUES ('28174', '永顺县', '3', '28065', 'Y');
INSERT INTO `ey_region` VALUES ('28205', '龙山县', '3', '28065', 'L');
INSERT INTO `ey_region` VALUES ('28240', '广东省', '1', '0', 'G');
INSERT INTO `ey_region` VALUES ('28241', '广州市', '2', '28240', 'G');
INSERT INTO `ey_region` VALUES ('28242', '市辖区', '3', '28241', 'S');
INSERT INTO `ey_region` VALUES ('28243', '荔湾区', '3', '28241', 'L');
INSERT INTO `ey_region` VALUES ('28266', '越秀区', '3', '28241', 'Y');
INSERT INTO `ey_region` VALUES ('28289', '海珠区', '3', '28241', 'H');
INSERT INTO `ey_region` VALUES ('28308', '天河区', '3', '28241', 'T');
INSERT INTO `ey_region` VALUES ('28330', '白云区', '3', '28241', 'B');
INSERT INTO `ey_region` VALUES ('28349', '黄埔区', '3', '28241', 'H');
INSERT INTO `ey_region` VALUES ('28359', '番禺区', '3', '28241', 'F');
INSERT INTO `ey_region` VALUES ('28377', '花都区', '3', '28241', 'H');
INSERT INTO `ey_region` VALUES ('28386', '南沙区', '3', '28241', 'N');
INSERT INTO `ey_region` VALUES ('28392', '萝岗区', '3', '28241', 'L');
INSERT INTO `ey_region` VALUES ('28399', '增城市', '3', '28241', 'Z');
INSERT INTO `ey_region` VALUES ('28409', '从化市', '3', '28241', 'C');
INSERT INTO `ey_region` VALUES ('28421', '韶关市', '2', '28240', 'S');
INSERT INTO `ey_region` VALUES ('28422', '市辖区', '3', '28421', 'S');
INSERT INTO `ey_region` VALUES ('28423', '武江区', '3', '28421', 'W');
INSERT INTO `ey_region` VALUES ('28431', '浈江区', '3', '28421', 'Z');
INSERT INTO `ey_region` VALUES ('28448', '曲江区', '3', '28421', 'Q');
INSERT INTO `ey_region` VALUES ('28463', '始兴县', '3', '28421', 'S');
INSERT INTO `ey_region` VALUES ('28475', '仁化县', '3', '28421', 'R');
INSERT INTO `ey_region` VALUES ('28488', '翁源县', '3', '28421', 'W');
INSERT INTO `ey_region` VALUES ('28497', '乳源县', '3', '28421', 'R');
INSERT INTO `ey_region` VALUES ('28509', '新丰县', '3', '28421', 'X');
INSERT INTO `ey_region` VALUES ('28517', '乐昌市', '3', '28421', 'L');
INSERT INTO `ey_region` VALUES ('28539', '南雄市', '3', '28421', 'N');
INSERT INTO `ey_region` VALUES ('28558', '深圳市', '2', '28240', 'S');
INSERT INTO `ey_region` VALUES ('28559', '市辖区', '3', '28558', 'S');
INSERT INTO `ey_region` VALUES ('28560', '罗湖区', '3', '28558', 'L');
INSERT INTO `ey_region` VALUES ('28571', '福田区', '3', '28558', 'F');
INSERT INTO `ey_region` VALUES ('28581', '南山区', '3', '28558', 'N');
INSERT INTO `ey_region` VALUES ('28590', '宝安区', '3', '28558', 'B');
INSERT INTO `ey_region` VALUES ('28604', '龙岗区', '3', '28558', 'L');
INSERT INTO `ey_region` VALUES ('28619', '盐田区', '3', '28558', 'Y');
INSERT INTO `ey_region` VALUES ('28626', '珠海市', '2', '28240', 'Z');
INSERT INTO `ey_region` VALUES ('28627', '市辖区', '3', '28626', 'S');
INSERT INTO `ey_region` VALUES ('28628', '香洲区', '3', '28626', 'X');
INSERT INTO `ey_region` VALUES ('28646', '斗门区', '3', '28626', 'D');
INSERT INTO `ey_region` VALUES ('28654', '金湾区', '3', '28626', 'J');
INSERT INTO `ey_region` VALUES ('28659', '汕头市', '2', '28240', 'S');
INSERT INTO `ey_region` VALUES ('28660', '市辖区', '3', '28659', 'S');
INSERT INTO `ey_region` VALUES ('28661', '龙湖区', '3', '28659', 'L');
INSERT INTO `ey_region` VALUES ('28669', '金平区', '3', '28659', 'J');
INSERT INTO `ey_region` VALUES ('28687', '濠江区', '3', '28659', 'H');
INSERT INTO `ey_region` VALUES ('28695', '潮阳区', '3', '28659', 'C');
INSERT INTO `ey_region` VALUES ('28709', '潮南区', '3', '28659', 'C');
INSERT INTO `ey_region` VALUES ('28721', '澄海区', '3', '28659', 'C');
INSERT INTO `ey_region` VALUES ('28733', '南澳县', '3', '28659', 'N');
INSERT INTO `ey_region` VALUES ('28737', '佛山市', '2', '28240', 'F');
INSERT INTO `ey_region` VALUES ('28738', '市辖区', '3', '28737', 'S');
INSERT INTO `ey_region` VALUES ('28739', '禅城区', '3', '28737', 'C');
INSERT INTO `ey_region` VALUES ('28744', '南海区', '3', '28737', 'N');
INSERT INTO `ey_region` VALUES ('28753', '顺德区', '3', '28737', 'S');
INSERT INTO `ey_region` VALUES ('28764', '三水区', '3', '28737', 'S');
INSERT INTO `ey_region` VALUES ('28776', '高明区', '3', '28737', 'G');
INSERT INTO `ey_region` VALUES ('28785', '江门市', '2', '28240', 'J');
INSERT INTO `ey_region` VALUES ('28786', '市辖区', '3', '28785', 'S');
INSERT INTO `ey_region` VALUES ('28787', '蓬江区', '3', '28785', 'P');
INSERT INTO `ey_region` VALUES ('28797', '江海区', '3', '28785', 'J');
INSERT INTO `ey_region` VALUES ('28803', '新会区', '3', '28785', 'X');
INSERT INTO `ey_region` VALUES ('28818', '台山市', '3', '28785', 'T');
INSERT INTO `ey_region` VALUES ('28837', '开平市', '3', '28785', 'K');
INSERT INTO `ey_region` VALUES ('28853', '鹤山市', '3', '28785', 'H');
INSERT INTO `ey_region` VALUES ('28867', '恩平市', '3', '28785', 'E');
INSERT INTO `ey_region` VALUES ('28880', '湛江市', '2', '28240', 'Z');
INSERT INTO `ey_region` VALUES ('28881', '市辖区', '3', '28880', 'S');
INSERT INTO `ey_region` VALUES ('28882', '湛江市赤坎区', '3', '28880', 'Z');
INSERT INTO `ey_region` VALUES ('28891', '湛江市霞山区', '3', '28880', 'Z');
INSERT INTO `ey_region` VALUES ('28904', '湛江市坡头区', '3', '28880', 'Z');
INSERT INTO `ey_region` VALUES ('28914', '湛江市麻章区', '3', '28880', 'Z');
INSERT INTO `ey_region` VALUES ('28923', '遂溪县', '3', '28880', 'S');
INSERT INTO `ey_region` VALUES ('28941', '徐闻县', '3', '28880', 'X');
INSERT INTO `ey_region` VALUES ('28962', '廉江市', '3', '28880', 'L');
INSERT INTO `ey_region` VALUES ('28984', '雷州市', '3', '28880', 'L');
INSERT INTO `ey_region` VALUES ('29010', '吴川市', '3', '28880', 'W');
INSERT INTO `ey_region` VALUES ('29026', '茂名市', '2', '28240', 'M');
INSERT INTO `ey_region` VALUES ('29027', '市辖区', '3', '29026', 'S');
INSERT INTO `ey_region` VALUES ('29028', '茂南区', '3', '29026', 'M');
INSERT INTO `ey_region` VALUES ('29045', '茂港区', '3', '29026', 'M');
INSERT INTO `ey_region` VALUES ('29053', '电白县', '3', '29026', 'D');
INSERT INTO `ey_region` VALUES ('29075', '高州市', '3', '29026', 'G');
INSERT INTO `ey_region` VALUES ('29107', '化州市', '3', '29026', 'H');
INSERT INTO `ey_region` VALUES ('29138', '信宜市', '3', '29026', 'X');
INSERT INTO `ey_region` VALUES ('29159', '肇庆市', '2', '28240', 'Z');
INSERT INTO `ey_region` VALUES ('29160', '市辖区', '3', '29159', 'S');
INSERT INTO `ey_region` VALUES ('29161', '端州区', '3', '29159', 'D');
INSERT INTO `ey_region` VALUES ('29169', '鼎湖区', '3', '29159', 'D');
INSERT INTO `ey_region` VALUES ('29178', '广宁县', '3', '29159', 'G');
INSERT INTO `ey_region` VALUES ('29196', '怀集县', '3', '29159', 'H');
INSERT INTO `ey_region` VALUES ('29217', '封开县', '3', '29159', 'F');
INSERT INTO `ey_region` VALUES ('29234', '德庆县', '3', '29159', 'D');
INSERT INTO `ey_region` VALUES ('29248', '高要市', '3', '29159', 'G');
INSERT INTO `ey_region` VALUES ('29266', '四会市', '3', '29159', 'S');
INSERT INTO `ey_region` VALUES ('29282', '惠州市', '2', '28240', 'H');
INSERT INTO `ey_region` VALUES ('29283', '市辖区', '3', '29282', 'S');
INSERT INTO `ey_region` VALUES ('29284', '惠城区', '3', '29282', 'H');
INSERT INTO `ey_region` VALUES ('29304', '惠阳区', '3', '29282', 'H');
INSERT INTO `ey_region` VALUES ('29317', '博罗县', '3', '29282', 'B');
INSERT INTO `ey_region` VALUES ('29335', '惠东县', '3', '29282', 'H');
INSERT INTO `ey_region` VALUES ('29355', '龙门县', '3', '29282', 'L');
INSERT INTO `ey_region` VALUES ('29371', '梅州市', '2', '28240', 'M');
INSERT INTO `ey_region` VALUES ('29372', '市辖区', '3', '29371', 'S');
INSERT INTO `ey_region` VALUES ('29373', '梅江区', '3', '29371', 'M');
INSERT INTO `ey_region` VALUES ('29380', '梅县', '3', '29371', 'M');
INSERT INTO `ey_region` VALUES ('29400', '大埔县', '3', '29371', 'D');
INSERT INTO `ey_region` VALUES ('29418', '丰顺县', '3', '29371', 'F');
INSERT INTO `ey_region` VALUES ('29436', '五华县', '3', '29371', 'W');
INSERT INTO `ey_region` VALUES ('29453', '平远县', '3', '29371', 'P');
INSERT INTO `ey_region` VALUES ('29466', '蕉岭县', '3', '29371', 'J');
INSERT INTO `ey_region` VALUES ('29477', '兴宁市', '3', '29371', 'X');
INSERT INTO `ey_region` VALUES ('29498', '汕尾市', '2', '28240', 'S');
INSERT INTO `ey_region` VALUES ('29499', '市辖区', '3', '29498', 'S');
INSERT INTO `ey_region` VALUES ('29500', '城区', '3', '29498', 'C');
INSERT INTO `ey_region` VALUES ('29511', '海丰县', '3', '29498', 'H');
INSERT INTO `ey_region` VALUES ('29529', '陆河县', '3', '29498', 'L');
INSERT INTO `ey_region` VALUES ('29538', '陆丰市', '3', '29498', 'L');
INSERT INTO `ey_region` VALUES ('29568', '河源市', '2', '28240', 'H');
INSERT INTO `ey_region` VALUES ('29569', '市辖区', '3', '29568', 'S');
INSERT INTO `ey_region` VALUES ('29570', '源城区', '3', '29568', 'Y');
INSERT INTO `ey_region` VALUES ('29578', '紫金县', '3', '29568', 'Z');
INSERT INTO `ey_region` VALUES ('29599', '龙川县', '3', '29568', 'L');
INSERT INTO `ey_region` VALUES ('29625', '连平县', '3', '29568', 'L');
INSERT INTO `ey_region` VALUES ('29639', '和平县', '3', '29568', 'H');
INSERT INTO `ey_region` VALUES ('29657', '东源县', '3', '29568', 'D');
INSERT INTO `ey_region` VALUES ('29679', '阳江市', '2', '28240', 'Y');
INSERT INTO `ey_region` VALUES ('29680', '市辖区', '3', '29679', 'S');
INSERT INTO `ey_region` VALUES ('29681', '江城区', '3', '29679', 'J');
INSERT INTO `ey_region` VALUES ('29698', '阳西县', '3', '29679', 'Y');
INSERT INTO `ey_region` VALUES ('29709', '阳东县', '3', '29679', 'Y');
INSERT INTO `ey_region` VALUES ('29729', '阳春市', '3', '29679', 'Y');
INSERT INTO `ey_region` VALUES ('29755', '清远市', '2', '28240', 'Q');
INSERT INTO `ey_region` VALUES ('29756', '市辖区', '3', '29755', 'S');
INSERT INTO `ey_region` VALUES ('29757', '清城区', '3', '29755', 'Q');
INSERT INTO `ey_region` VALUES ('29766', '佛冈县', '3', '29755', 'F');
INSERT INTO `ey_region` VALUES ('29773', '阳山县', '3', '29755', 'Y');
INSERT INTO `ey_region` VALUES ('29787', '连山县', '3', '29755', 'L');
INSERT INTO `ey_region` VALUES ('29797', '连南县', '3', '29755', 'L');
INSERT INTO `ey_region` VALUES ('29805', '清新县', '3', '29755', 'Q');
INSERT INTO `ey_region` VALUES ('29816', '英德市', '3', '29755', 'Y');
INSERT INTO `ey_region` VALUES ('29842', '连州市', '3', '29755', 'L');
INSERT INTO `ey_region` VALUES ('29855', '东莞市', '2', '28240', 'D');
INSERT INTO `ey_region` VALUES ('29890', '中山市', '2', '28240', 'Z');
INSERT INTO `ey_region` VALUES ('29915', '潮州市', '2', '28240', 'C');
INSERT INTO `ey_region` VALUES ('29916', '市辖区', '3', '29915', 'S');
INSERT INTO `ey_region` VALUES ('29917', '潮州市湘桥区', '3', '29915', 'C');
INSERT INTO `ey_region` VALUES ('29930', '潮州市潮安县', '3', '29915', 'C');
INSERT INTO `ey_region` VALUES ('29954', '潮州市饶平县', '3', '29915', 'C');
INSERT INTO `ey_region` VALUES ('29977', '揭阳市', '2', '28240', 'J');
INSERT INTO `ey_region` VALUES ('29978', '市辖区', '3', '29977', 'S');
INSERT INTO `ey_region` VALUES ('29979', '榕城区', '3', '29977', 'R');
INSERT INTO `ey_region` VALUES ('29990', '揭东县', '3', '29977', 'J');
INSERT INTO `ey_region` VALUES ('30008', '揭西县', '3', '29977', 'J');
INSERT INTO `ey_region` VALUES ('30032', '惠来县', '3', '29977', 'H');
INSERT INTO `ey_region` VALUES ('30054', '普宁市', '3', '29977', 'P');
INSERT INTO `ey_region` VALUES ('30086', '云浮市', '2', '28240', 'Y');
INSERT INTO `ey_region` VALUES ('30087', '市辖区', '3', '30086', 'S');
INSERT INTO `ey_region` VALUES ('30088', '云城区', '3', '30086', 'Y');
INSERT INTO `ey_region` VALUES ('30096', '新兴县', '3', '30086', 'X');
INSERT INTO `ey_region` VALUES ('30112', '郁南县', '3', '30086', 'Y');
INSERT INTO `ey_region` VALUES ('30132', '云安县', '3', '30086', 'Y');
INSERT INTO `ey_region` VALUES ('30141', '罗定市', '3', '30086', 'L');
INSERT INTO `ey_region` VALUES ('30164', '广西壮族自治区', '1', '0', 'G');
INSERT INTO `ey_region` VALUES ('30165', '南宁市', '2', '30164', 'N');
INSERT INTO `ey_region` VALUES ('30166', '市辖区', '3', '30165', 'S');
INSERT INTO `ey_region` VALUES ('30167', '兴宁区', '3', '30165', 'X');
INSERT INTO `ey_region` VALUES ('30174', '青秀区', '3', '30165', 'Q');
INSERT INTO `ey_region` VALUES ('30186', '江南区', '3', '30165', 'J');
INSERT INTO `ey_region` VALUES ('30196', '西乡塘区', '3', '30165', 'X');
INSERT INTO `ey_region` VALUES ('30214', '良庆区', '3', '30165', 'L');
INSERT INTO `ey_region` VALUES ('30222', '邕宁区', '3', '30165', 'Y');
INSERT INTO `ey_region` VALUES ('30228', '武鸣县', '3', '30165', 'W');
INSERT INTO `ey_region` VALUES ('30245', '隆安县', '3', '30165', 'L');
INSERT INTO `ey_region` VALUES ('30257', '马山县', '3', '30165', 'M');
INSERT INTO `ey_region` VALUES ('30270', '上林县', '3', '30165', 'S');
INSERT INTO `ey_region` VALUES ('30282', '宾阳县', '3', '30165', 'B');
INSERT INTO `ey_region` VALUES ('30300', '横县', '3', '30165', 'H');
INSERT INTO `ey_region` VALUES ('30319', '柳州市', '2', '30164', 'L');
INSERT INTO `ey_region` VALUES ('30320', '市辖区', '3', '30319', 'S');
INSERT INTO `ey_region` VALUES ('30321', '城中区', '3', '30319', 'C');
INSERT INTO `ey_region` VALUES ('30329', '鱼峰区', '3', '30319', 'Y');
INSERT INTO `ey_region` VALUES ('30338', '柳南区', '3', '30319', 'L');
INSERT INTO `ey_region` VALUES ('30348', '柳北区', '3', '30319', 'L');
INSERT INTO `ey_region` VALUES ('30361', '柳江县', '3', '30319', 'L');
INSERT INTO `ey_region` VALUES ('30374', '柳城县', '3', '30319', 'L');
INSERT INTO `ey_region` VALUES ('30387', '鹿寨县', '3', '30319', 'L');
INSERT INTO `ey_region` VALUES ('30398', '融安县', '3', '30319', 'R');
INSERT INTO `ey_region` VALUES ('30411', '融水县', '3', '30319', 'R');
INSERT INTO `ey_region` VALUES ('30432', '三江县', '3', '30319', 'S');
INSERT INTO `ey_region` VALUES ('30448', '桂林市', '2', '30164', 'G');
INSERT INTO `ey_region` VALUES ('30449', '市辖区', '3', '30448', 'S');
INSERT INTO `ey_region` VALUES ('30450', '秀峰区', '3', '30448', 'X');
INSERT INTO `ey_region` VALUES ('30454', '叠彩区', '3', '30448', 'D');
INSERT INTO `ey_region` VALUES ('30458', '象山区', '3', '30448', 'X');
INSERT INTO `ey_region` VALUES ('30463', '七星区', '3', '30448', 'Q');
INSERT INTO `ey_region` VALUES ('30469', '雁山区', '3', '30448', 'Y');
INSERT INTO `ey_region` VALUES ('30475', '阳朔县', '3', '30448', 'Y');
INSERT INTO `ey_region` VALUES ('30485', '临桂县', '3', '30448', 'L');
INSERT INTO `ey_region` VALUES ('30497', '灵川县', '3', '30448', 'L');
INSERT INTO `ey_region` VALUES ('30509', '全州县', '3', '30448', 'Q');
INSERT INTO `ey_region` VALUES ('30528', '兴安县', '3', '30448', 'X');
INSERT INTO `ey_region` VALUES ('30539', '永福县', '3', '30448', 'Y');
INSERT INTO `ey_region` VALUES ('30549', '灌阳县', '3', '30448', 'G');
INSERT INTO `ey_region` VALUES ('30559', '龙胜县', '3', '30448', 'L');
INSERT INTO `ey_region` VALUES ('30570', '资源县', '3', '30448', 'Z');
INSERT INTO `ey_region` VALUES ('30578', '平乐县', '3', '30448', 'P');
INSERT INTO `ey_region` VALUES ('30589', '荔浦县', '3', '30448', 'L');
INSERT INTO `ey_region` VALUES ('30603', '恭城县', '3', '30448', 'G');
INSERT INTO `ey_region` VALUES ('30613', '梧州市', '2', '30164', 'W');
INSERT INTO `ey_region` VALUES ('30614', '市辖区', '3', '30613', 'S');
INSERT INTO `ey_region` VALUES ('30615', '万秀区', '3', '30613', 'W');
INSERT INTO `ey_region` VALUES ('30622', '蝶山区', '3', '30613', 'D');
INSERT INTO `ey_region` VALUES ('30628', '长洲区', '3', '30613', 'C');
INSERT INTO `ey_region` VALUES ('30633', '苍梧县', '3', '30613', 'C');
INSERT INTO `ey_region` VALUES ('30646', '藤县', '3', '30613', 'T');
INSERT INTO `ey_region` VALUES ('30663', '蒙山县', '3', '30613', 'M');
INSERT INTO `ey_region` VALUES ('30673', '岑溪市', '3', '30613', 'C');
INSERT INTO `ey_region` VALUES ('30688', '北海市', '2', '30164', 'B');
INSERT INTO `ey_region` VALUES ('30689', '市辖区', '3', '30688', 'S');
INSERT INTO `ey_region` VALUES ('30690', '海城区', '3', '30688', 'H');
INSERT INTO `ey_region` VALUES ('30699', '银海区', '3', '30688', 'Y');
INSERT INTO `ey_region` VALUES ('30704', '铁山港区', '3', '30688', 'T');
INSERT INTO `ey_region` VALUES ('30708', '合浦县', '3', '30688', 'H');
INSERT INTO `ey_region` VALUES ('30724', '防城港市', '2', '30164', 'F');
INSERT INTO `ey_region` VALUES ('30725', '市辖区', '3', '30724', 'S');
INSERT INTO `ey_region` VALUES ('30726', '港口区', '3', '30724', 'G');
INSERT INTO `ey_region` VALUES ('30732', '防城区', '3', '30724', 'F');
INSERT INTO `ey_region` VALUES ('30748', '上思县', '3', '30724', 'S');
INSERT INTO `ey_region` VALUES ('30758', '东兴市', '3', '30724', 'D');
INSERT INTO `ey_region` VALUES ('30762', '钦州市', '2', '30164', 'Q');
INSERT INTO `ey_region` VALUES ('30763', '市辖区', '3', '30762', 'S');
INSERT INTO `ey_region` VALUES ('30764', '钦南区', '3', '30762', 'Q');
INSERT INTO `ey_region` VALUES ('30783', '钦北区', '3', '30762', 'Q');
INSERT INTO `ey_region` VALUES ('30796', '灵山县', '3', '30762', 'L');
INSERT INTO `ey_region` VALUES ('30817', '浦北县', '3', '30762', 'P');
INSERT INTO `ey_region` VALUES ('30834', '贵港市', '2', '30164', 'G');
INSERT INTO `ey_region` VALUES ('30835', '市辖区', '3', '30834', 'S');
INSERT INTO `ey_region` VALUES ('30836', '港北区', '3', '30834', 'G');
INSERT INTO `ey_region` VALUES ('30845', '港南区', '3', '30834', 'G');
INSERT INTO `ey_region` VALUES ('30855', '覃塘区', '3', '30834', 'Q');
INSERT INTO `ey_region` VALUES ('30866', '平南县', '3', '30834', 'P');
INSERT INTO `ey_region` VALUES ('30888', '桂平市', '3', '30834', 'G');
INSERT INTO `ey_region` VALUES ('30915', '玉林市', '2', '30164', 'Y');
INSERT INTO `ey_region` VALUES ('30916', '市辖区', '3', '30915', 'S');
INSERT INTO `ey_region` VALUES ('30917', '玉州区', '3', '30915', 'Y');
INSERT INTO `ey_region` VALUES ('30933', '容县', '3', '30915', 'R');
INSERT INTO `ey_region` VALUES ('30949', '陆川县', '3', '30915', 'L');
INSERT INTO `ey_region` VALUES ('30964', '博白县', '3', '30915', 'B');
INSERT INTO `ey_region` VALUES ('30993', '兴业县', '3', '30915', 'X');
INSERT INTO `ey_region` VALUES ('31007', '北流市', '3', '30915', 'B');
INSERT INTO `ey_region` VALUES ('31033', '百色市', '2', '30164', 'B');
INSERT INTO `ey_region` VALUES ('31034', '市辖区', '3', '31033', 'S');
INSERT INTO `ey_region` VALUES ('31035', '右江区', '3', '31033', 'Y');
INSERT INTO `ey_region` VALUES ('31045', '田阳县', '3', '31033', 'T');
INSERT INTO `ey_region` VALUES ('31056', '田东县', '3', '31033', 'T');
INSERT INTO `ey_region` VALUES ('31067', '平果县', '3', '31033', 'P');
INSERT INTO `ey_region` VALUES ('31081', '德保县', '3', '31033', 'D');
INSERT INTO `ey_region` VALUES ('31095', '靖西县', '3', '31033', 'J');
INSERT INTO `ey_region` VALUES ('31115', '那坡县', '3', '31033', 'N');
INSERT INTO `ey_region` VALUES ('31125', '凌云县', '3', '31033', 'L');
INSERT INTO `ey_region` VALUES ('31134', '乐业县', '3', '31033', 'L');
INSERT INTO `ey_region` VALUES ('31143', '田林县', '3', '31033', 'T');
INSERT INTO `ey_region` VALUES ('31158', '西林县', '3', '31033', 'X');
INSERT INTO `ey_region` VALUES ('31167', '隆林县', '3', '31033', 'L');
INSERT INTO `ey_region` VALUES ('31184', '贺州市', '2', '30164', 'H');
INSERT INTO `ey_region` VALUES ('31185', '市辖区', '3', '31184', 'S');
INSERT INTO `ey_region` VALUES ('31186', '八步区', '3', '31184', 'B');
INSERT INTO `ey_region` VALUES ('31208', '昭平县', '3', '31184', 'Z');
INSERT INTO `ey_region` VALUES ('31221', '钟山县', '3', '31184', 'Z');
INSERT INTO `ey_region` VALUES ('31236', '富川县', '3', '31184', 'F');
INSERT INTO `ey_region` VALUES ('31249', '河池市', '2', '30164', 'H');
INSERT INTO `ey_region` VALUES ('31250', '市辖区', '3', '31249', 'S');
INSERT INTO `ey_region` VALUES ('31251', '金城江区', '3', '31249', 'J');
INSERT INTO `ey_region` VALUES ('31264', '南丹县', '3', '31249', 'N');
INSERT INTO `ey_region` VALUES ('31276', '天峨县', '3', '31249', 'T');
INSERT INTO `ey_region` VALUES ('31286', '凤山县', '3', '31249', 'F');
INSERT INTO `ey_region` VALUES ('31296', '东兰县', '3', '31249', 'D');
INSERT INTO `ey_region` VALUES ('31311', '罗城县', '3', '31249', 'L');
INSERT INTO `ey_region` VALUES ('31323', '环江县', '3', '31249', 'H');
INSERT INTO `ey_region` VALUES ('31336', '巴马县', '3', '31249', 'B');
INSERT INTO `ey_region` VALUES ('31347', '都安县', '3', '31249', 'D');
INSERT INTO `ey_region` VALUES ('31367', '大化县', '3', '31249', 'D');
INSERT INTO `ey_region` VALUES ('31384', '宜州市', '3', '31249', 'Y');
INSERT INTO `ey_region` VALUES ('31401', '来宾市', '2', '30164', 'L');
INSERT INTO `ey_region` VALUES ('31402', '市辖区', '3', '31401', 'S');
INSERT INTO `ey_region` VALUES ('31403', '兴宾区', '3', '31401', 'X');
INSERT INTO `ey_region` VALUES ('31427', '忻城县', '3', '31401', 'X');
INSERT INTO `ey_region` VALUES ('31440', '象州县', '3', '31401', 'X');
INSERT INTO `ey_region` VALUES ('31452', '武宣县', '3', '31401', 'W');
INSERT INTO `ey_region` VALUES ('31463', '金秀县', '3', '31401', 'J');
INSERT INTO `ey_region` VALUES ('31474', '合山市', '3', '31401', 'H');
INSERT INTO `ey_region` VALUES ('31478', '崇左市', '2', '30164', 'C');
INSERT INTO `ey_region` VALUES ('31479', '市辖区', '3', '31478', 'S');
INSERT INTO `ey_region` VALUES ('31480', '江州区', '3', '31478', 'J');
INSERT INTO `ey_region` VALUES ('31490', '扶绥县', '3', '31478', 'F');
INSERT INTO `ey_region` VALUES ('31502', '宁明县', '3', '31478', 'N');
INSERT INTO `ey_region` VALUES ('31516', '龙州县', '3', '31478', 'L');
INSERT INTO `ey_region` VALUES ('31529', '大新县', '3', '31478', 'D');
INSERT INTO `ey_region` VALUES ('31544', '天等县', '3', '31478', 'T');
INSERT INTO `ey_region` VALUES ('31558', '凭祥市', '3', '31478', 'P');
INSERT INTO `ey_region` VALUES ('31563', '海南省', '1', '0', 'H');
INSERT INTO `ey_region` VALUES ('31564', '海口市', '2', '31563', 'H');
INSERT INTO `ey_region` VALUES ('31565', '市辖区', '3', '31564', 'S');
INSERT INTO `ey_region` VALUES ('31566', '秀英区', '3', '31564', 'X');
INSERT INTO `ey_region` VALUES ('31575', '龙华区', '3', '31564', 'L');
INSERT INTO `ey_region` VALUES ('31587', '琼山区', '3', '31564', 'Q');
INSERT INTO `ey_region` VALUES ('31601', '美兰区', '3', '31564', 'M');
INSERT INTO `ey_region` VALUES ('31618', '三亚市', '2', '31563', 'S');
INSERT INTO `ey_region` VALUES ('47967', '海棠区', '3', '31618', 'H');
INSERT INTO `ey_region` VALUES ('31634', '五指山市', '2', '31563', 'W');
INSERT INTO `ey_region` VALUES ('31635', '冲山镇', '3', '31634', 'C');
INSERT INTO `ey_region` VALUES ('31636', '南圣镇', '3', '31634', 'N');
INSERT INTO `ey_region` VALUES ('31637', '毛阳镇', '3', '31634', 'M');
INSERT INTO `ey_region` VALUES ('31638', '番阳镇', '3', '31634', 'F');
INSERT INTO `ey_region` VALUES ('31639', '畅好乡', '3', '31634', 'C');
INSERT INTO `ey_region` VALUES ('31640', '毛道乡', '3', '31634', 'M');
INSERT INTO `ey_region` VALUES ('31641', '水满乡', '3', '31634', 'S');
INSERT INTO `ey_region` VALUES ('31642', '国营畅好农场', '3', '31634', 'G');
INSERT INTO `ey_region` VALUES ('31643', '琼海市', '2', '31563', 'Q');
INSERT INTO `ey_region` VALUES ('31644', '嘉积镇', '3', '31643', 'J');
INSERT INTO `ey_region` VALUES ('31645', '万泉镇', '3', '31643', 'W');
INSERT INTO `ey_region` VALUES ('31646', '石壁镇', '3', '31643', 'S');
INSERT INTO `ey_region` VALUES ('31647', '中原镇', '3', '31643', 'Z');
INSERT INTO `ey_region` VALUES ('31648', '博敖镇', '3', '31643', 'B');
INSERT INTO `ey_region` VALUES ('31649', '阳江镇', '3', '31643', 'Y');
INSERT INTO `ey_region` VALUES ('31650', '龙江镇', '3', '31643', 'L');
INSERT INTO `ey_region` VALUES ('31651', '潭门镇', '3', '31643', 'T');
INSERT INTO `ey_region` VALUES ('31652', '塔洋镇', '3', '31643', 'T');
INSERT INTO `ey_region` VALUES ('31653', '长坡镇', '3', '31643', 'C');
INSERT INTO `ey_region` VALUES ('31654', '大路镇', '3', '31643', 'D');
INSERT INTO `ey_region` VALUES ('31655', '会山镇', '3', '31643', 'H');
INSERT INTO `ey_region` VALUES ('31656', '国营东太农场', '3', '31643', 'G');
INSERT INTO `ey_region` VALUES ('31657', '国营东平农场', '3', '31643', 'G');
INSERT INTO `ey_region` VALUES ('31658', '国营东红农场', '3', '31643', 'G');
INSERT INTO `ey_region` VALUES ('31659', '国营东升农场', '3', '31643', 'G');
INSERT INTO `ey_region` VALUES ('31660', '国营南俸农场', '3', '31643', 'G');
INSERT INTO `ey_region` VALUES ('31661', '彬村山华侨农场', '3', '31643', 'B');
INSERT INTO `ey_region` VALUES ('31662', '儋州市', '2', '31563', 'D');
INSERT INTO `ey_region` VALUES ('31663', '那大镇', '3', '31662', 'N');
INSERT INTO `ey_region` VALUES ('31664', '和庆镇', '3', '31662', 'H');
INSERT INTO `ey_region` VALUES ('31665', '南丰镇', '3', '31662', 'N');
INSERT INTO `ey_region` VALUES ('31666', '大成镇', '3', '31662', 'D');
INSERT INTO `ey_region` VALUES ('31667', '雅星镇', '3', '31662', 'Y');
INSERT INTO `ey_region` VALUES ('31668', '兰洋镇', '3', '31662', 'L');
INSERT INTO `ey_region` VALUES ('31669', '光村镇', '3', '31662', 'G');
INSERT INTO `ey_region` VALUES ('31670', '木棠镇', '3', '31662', 'M');
INSERT INTO `ey_region` VALUES ('31671', '海头镇', '3', '31662', 'H');
INSERT INTO `ey_region` VALUES ('31672', '峨蔓镇', '3', '31662', 'E');
INSERT INTO `ey_region` VALUES ('31673', '三都镇', '3', '31662', 'S');
INSERT INTO `ey_region` VALUES ('31674', '王五镇', '3', '31662', 'W');
INSERT INTO `ey_region` VALUES ('31675', '白马井镇', '3', '31662', 'B');
INSERT INTO `ey_region` VALUES ('31676', '中和镇', '3', '31662', 'Z');
INSERT INTO `ey_region` VALUES ('31677', '排浦镇', '3', '31662', 'P');
INSERT INTO `ey_region` VALUES ('31678', '东成镇', '3', '31662', 'D');
INSERT INTO `ey_region` VALUES ('31679', '新州镇', '3', '31662', 'X');
INSERT INTO `ey_region` VALUES ('31680', '国营西培农场', '3', '31662', 'G');
INSERT INTO `ey_region` VALUES ('31681', '国营西华农场', '3', '31662', 'G');
INSERT INTO `ey_region` VALUES ('31682', '国营西庆农场', '3', '31662', 'G');
INSERT INTO `ey_region` VALUES ('31683', '国营西流农场', '3', '31662', 'G');
INSERT INTO `ey_region` VALUES ('31684', '国营西联农场', '3', '31662', 'G');
INSERT INTO `ey_region` VALUES ('31685', '国营蓝洋农场', '3', '31662', 'G');
INSERT INTO `ey_region` VALUES ('31686', '国营新盈农场', '3', '31662', 'G');
INSERT INTO `ey_region` VALUES ('31687', '国营八一农场东山分场', '3', '31662', 'G');
INSERT INTO `ey_region` VALUES ('31688', '国营八一农场金川分场', '3', '31662', 'G');
INSERT INTO `ey_region` VALUES ('31689', '国营八一农场长岭分场', '3', '31662', 'G');
INSERT INTO `ey_region` VALUES ('31690', '国营八一农场英岛分场', '3', '31662', 'G');
INSERT INTO `ey_region` VALUES ('31691', '国营八一农场春江分场', '3', '31662', 'G');
INSERT INTO `ey_region` VALUES ('31692', '国营八一农场强打管区', '3', '31662', 'G');
INSERT INTO `ey_region` VALUES ('31693', '国营龙山农场', '3', '31662', 'G');
INSERT INTO `ey_region` VALUES ('31694', '国营红岭农场', '3', '31662', 'G');
INSERT INTO `ey_region` VALUES ('31695', '洋浦经济开发区', '3', '31662', 'Y');
INSERT INTO `ey_region` VALUES ('31696', '华南热作学院', '3', '31662', 'H');
INSERT INTO `ey_region` VALUES ('31697', '文昌市', '2', '31563', 'W');
INSERT INTO `ey_region` VALUES ('31698', '文城镇', '3', '31697', 'W');
INSERT INTO `ey_region` VALUES ('31699', '重兴镇', '3', '31697', 'Z');
INSERT INTO `ey_region` VALUES ('31700', '蓬莱镇', '3', '31697', 'P');
INSERT INTO `ey_region` VALUES ('31701', '会文镇', '3', '31697', 'H');
INSERT INTO `ey_region` VALUES ('31702', '东路镇', '3', '31697', 'D');
INSERT INTO `ey_region` VALUES ('31703', '潭牛镇', '3', '31697', 'T');
INSERT INTO `ey_region` VALUES ('31704', '东阁镇', '3', '31697', 'D');
INSERT INTO `ey_region` VALUES ('31705', '文教镇', '3', '31697', 'W');
INSERT INTO `ey_region` VALUES ('31706', '东郊镇', '3', '31697', 'D');
INSERT INTO `ey_region` VALUES ('31707', '龙楼镇', '3', '31697', 'L');
INSERT INTO `ey_region` VALUES ('31708', '昌洒镇', '3', '31697', 'C');
INSERT INTO `ey_region` VALUES ('31709', '翁田镇', '3', '31697', 'W');
INSERT INTO `ey_region` VALUES ('31710', '抱罗镇', '3', '31697', 'B');
INSERT INTO `ey_region` VALUES ('31711', '冯坡镇', '3', '31697', 'F');
INSERT INTO `ey_region` VALUES ('31712', '锦山镇', '3', '31697', 'J');
INSERT INTO `ey_region` VALUES ('31713', '铺前镇', '3', '31697', 'P');
INSERT INTO `ey_region` VALUES ('31714', '国营东路农场', '3', '31697', 'G');
INSERT INTO `ey_region` VALUES ('31715', '国营南阳农场', '3', '31697', 'G');
INSERT INTO `ey_region` VALUES ('31716', '国营罗豆农场', '3', '31697', 'G');
INSERT INTO `ey_region` VALUES ('31717', '国营文昌橡胶研究所', '3', '31697', 'G');
INSERT INTO `ey_region` VALUES ('31718', '万宁市', '2', '31563', 'W');
INSERT INTO `ey_region` VALUES ('31719', '万城镇', '3', '31718', 'W');
INSERT INTO `ey_region` VALUES ('31720', '龙滚镇', '3', '31718', 'L');
INSERT INTO `ey_region` VALUES ('31721', '和乐镇', '3', '31718', 'H');
INSERT INTO `ey_region` VALUES ('31722', '后安镇', '3', '31718', 'H');
INSERT INTO `ey_region` VALUES ('31723', '大茂镇', '3', '31718', 'D');
INSERT INTO `ey_region` VALUES ('31724', '东澳镇', '3', '31718', 'D');
INSERT INTO `ey_region` VALUES ('31725', '礼纪镇', '3', '31718', 'L');
INSERT INTO `ey_region` VALUES ('31726', '长丰镇', '3', '31718', 'C');
INSERT INTO `ey_region` VALUES ('31727', '山根镇', '3', '31718', 'S');
INSERT INTO `ey_region` VALUES ('31728', '北大镇', '3', '31718', 'B');
INSERT INTO `ey_region` VALUES ('31729', '南桥镇', '3', '31718', 'N');
INSERT INTO `ey_region` VALUES ('31730', '三更罗镇', '3', '31718', 'S');
INSERT INTO `ey_region` VALUES ('31731', '国营东兴农场', '3', '31718', 'G');
INSERT INTO `ey_region` VALUES ('31732', '国营东和农场', '3', '31718', 'G');
INSERT INTO `ey_region` VALUES ('31733', '国营东岭农场', '3', '31718', 'G');
INSERT INTO `ey_region` VALUES ('31734', '国营南林农场', '3', '31718', 'G');
INSERT INTO `ey_region` VALUES ('31735', '国营新中农场', '3', '31718', 'G');
INSERT INTO `ey_region` VALUES ('31736', '兴隆华侨农场', '3', '31718', 'X');
INSERT INTO `ey_region` VALUES ('31737', '地方国营六连林场', '3', '31718', 'D');
INSERT INTO `ey_region` VALUES ('31738', '东方市', '2', '31563', 'D');
INSERT INTO `ey_region` VALUES ('31739', '八所镇', '3', '31738', 'B');
INSERT INTO `ey_region` VALUES ('31740', '东河镇', '3', '31738', 'D');
INSERT INTO `ey_region` VALUES ('31741', '大田镇', '3', '31738', 'D');
INSERT INTO `ey_region` VALUES ('31742', '感城镇', '3', '31738', 'G');
INSERT INTO `ey_region` VALUES ('31743', '板桥镇', '3', '31738', 'B');
INSERT INTO `ey_region` VALUES ('31744', '三家镇', '3', '31738', 'S');
INSERT INTO `ey_region` VALUES ('31745', '四更镇', '3', '31738', 'S');
INSERT INTO `ey_region` VALUES ('31746', '新龙镇', '3', '31738', 'X');
INSERT INTO `ey_region` VALUES ('31747', '天安乡', '3', '31738', 'T');
INSERT INTO `ey_region` VALUES ('31748', '江边乡', '3', '31738', 'J');
INSERT INTO `ey_region` VALUES ('31749', '国营广坝农场', '3', '31738', 'G');
INSERT INTO `ey_region` VALUES ('31750', '国营公爱农场', '3', '31738', 'G');
INSERT INTO `ey_region` VALUES ('31751', '国营红泉农场', '3', '31738', 'G');
INSERT INTO `ey_region` VALUES ('31752', '省国营东方华侨农场', '3', '31738', 'S');
INSERT INTO `ey_region` VALUES ('31753', '定安县', '2', '31563', 'D');
INSERT INTO `ey_region` VALUES ('31754', '定城镇', '3', '31753', 'D');
INSERT INTO `ey_region` VALUES ('31755', '新竹镇', '3', '31753', 'X');
INSERT INTO `ey_region` VALUES ('31756', '龙湖镇', '3', '31753', 'L');
INSERT INTO `ey_region` VALUES ('31757', '黄竹镇', '3', '31753', 'H');
INSERT INTO `ey_region` VALUES ('31758', '雷鸣镇', '3', '31753', 'L');
INSERT INTO `ey_region` VALUES ('31759', '龙门镇', '3', '31753', 'L');
INSERT INTO `ey_region` VALUES ('31760', '龙河镇', '3', '31753', 'L');
INSERT INTO `ey_region` VALUES ('31761', '岭口镇', '3', '31753', 'L');
INSERT INTO `ey_region` VALUES ('31762', '翰林镇', '3', '31753', 'H');
INSERT INTO `ey_region` VALUES ('31763', '富文镇', '3', '31753', 'F');
INSERT INTO `ey_region` VALUES ('31764', '国营中瑞农场', '3', '31753', 'G');
INSERT INTO `ey_region` VALUES ('31765', '国营南海农场', '3', '31753', 'G');
INSERT INTO `ey_region` VALUES ('31766', '国营金鸡岭农场', '3', '31753', 'G');
INSERT INTO `ey_region` VALUES ('31767', '定安热作研究所', '3', '31753', 'D');
INSERT INTO `ey_region` VALUES ('31768', '屯昌县', '2', '31563', 'T');
INSERT INTO `ey_region` VALUES ('31769', '屯城镇', '3', '31768', 'T');
INSERT INTO `ey_region` VALUES ('31770', '新兴镇', '3', '31768', 'X');
INSERT INTO `ey_region` VALUES ('31771', '枫木镇', '3', '31768', 'F');
INSERT INTO `ey_region` VALUES ('31772', '乌坡镇', '3', '31768', 'W');
INSERT INTO `ey_region` VALUES ('31773', '南吕镇', '3', '31768', 'N');
INSERT INTO `ey_region` VALUES ('31774', '南坤镇', '3', '31768', 'N');
INSERT INTO `ey_region` VALUES ('31775', '坡心镇', '3', '31768', 'P');
INSERT INTO `ey_region` VALUES ('31776', '西昌镇', '3', '31768', 'X');
INSERT INTO `ey_region` VALUES ('31777', '国营中建农场', '3', '31768', 'G');
INSERT INTO `ey_region` VALUES ('31778', '国营中坤农场', '3', '31768', 'G');
INSERT INTO `ey_region` VALUES ('31779', '国营黄岭农场', '3', '31768', 'G');
INSERT INTO `ey_region` VALUES ('31780', '国营南吕农场', '3', '31768', 'G');
INSERT INTO `ey_region` VALUES ('31781', '国营广青农场', '3', '31768', 'G');
INSERT INTO `ey_region` VALUES ('31782', '国营晨星农场', '3', '31768', 'G');
INSERT INTO `ey_region` VALUES ('31783', '澄迈县', '2', '31563', 'C');
INSERT INTO `ey_region` VALUES ('31784', '金江镇', '3', '31783', 'J');
INSERT INTO `ey_region` VALUES ('31785', '老城镇', '3', '31783', 'L');
INSERT INTO `ey_region` VALUES ('31786', '瑞溪镇', '3', '31783', 'R');
INSERT INTO `ey_region` VALUES ('31787', '永发镇', '3', '31783', 'Y');
INSERT INTO `ey_region` VALUES ('31788', '加乐镇', '3', '31783', 'J');
INSERT INTO `ey_region` VALUES ('31789', '文儒镇', '3', '31783', 'W');
INSERT INTO `ey_region` VALUES ('31790', '中兴镇', '3', '31783', 'Z');
INSERT INTO `ey_region` VALUES ('31791', '仁兴镇', '3', '31783', 'R');
INSERT INTO `ey_region` VALUES ('31792', '福山镇', '3', '31783', 'F');
INSERT INTO `ey_region` VALUES ('31793', '桥头镇', '3', '31783', 'Q');
INSERT INTO `ey_region` VALUES ('31794', '国营红光农场', '3', '31783', 'G');
INSERT INTO `ey_region` VALUES ('31795', '国营红岗农场', '3', '31783', 'G');
INSERT INTO `ey_region` VALUES ('31796', '国营西达农场', '3', '31783', 'G');
INSERT INTO `ey_region` VALUES ('31797', '国营昆仑农场', '3', '31783', 'G');
INSERT INTO `ey_region` VALUES ('31798', '国营和岭农场', '3', '31783', 'G');
INSERT INTO `ey_region` VALUES ('31799', '国营金安农场', '3', '31783', 'G');
INSERT INTO `ey_region` VALUES ('31800', '澄迈县华侨农场', '3', '31783', 'C');
INSERT INTO `ey_region` VALUES ('31801', '临高县', '2', '31563', 'L');
INSERT INTO `ey_region` VALUES ('31802', '临城镇', '3', '31801', 'L');
INSERT INTO `ey_region` VALUES ('31803', '波莲镇', '3', '31801', 'B');
INSERT INTO `ey_region` VALUES ('31804', '东英镇', '3', '31801', 'D');
INSERT INTO `ey_region` VALUES ('31805', '博厚镇', '3', '31801', 'B');
INSERT INTO `ey_region` VALUES ('31806', '皇桐镇', '3', '31801', 'H');
INSERT INTO `ey_region` VALUES ('31807', '多文镇', '3', '31801', 'D');
INSERT INTO `ey_region` VALUES ('31808', '和舍镇', '3', '31801', 'H');
INSERT INTO `ey_region` VALUES ('31809', '南宝镇', '3', '31801', 'N');
INSERT INTO `ey_region` VALUES ('31810', '新盈镇', '3', '31801', 'X');
INSERT INTO `ey_region` VALUES ('31811', '调楼镇', '3', '31801', 'D');
INSERT INTO `ey_region` VALUES ('31812', '国营红华农场', '3', '31801', 'G');
INSERT INTO `ey_region` VALUES ('31813', '国营加来农场', '3', '31801', 'G');
INSERT INTO `ey_region` VALUES ('31814', '白沙县', '2', '31563', 'B');
INSERT INTO `ey_region` VALUES ('31815', '牙叉镇', '3', '31814', 'Y');
INSERT INTO `ey_region` VALUES ('31816', '七坊镇', '3', '31814', 'Q');
INSERT INTO `ey_region` VALUES ('31817', '邦溪镇', '3', '31814', 'B');
INSERT INTO `ey_region` VALUES ('31818', '打安镇', '3', '31814', 'D');
INSERT INTO `ey_region` VALUES ('31819', '细水乡', '3', '31814', 'X');
INSERT INTO `ey_region` VALUES ('31820', '元门乡', '3', '31814', 'Y');
INSERT INTO `ey_region` VALUES ('31821', '南开乡', '3', '31814', 'N');
INSERT INTO `ey_region` VALUES ('31822', '阜龙乡', '3', '31814', 'F');
INSERT INTO `ey_region` VALUES ('31823', '青松乡', '3', '31814', 'Q');
INSERT INTO `ey_region` VALUES ('31824', '金波乡', '3', '31814', 'J');
INSERT INTO `ey_region` VALUES ('31825', '荣邦乡', '3', '31814', 'R');
INSERT INTO `ey_region` VALUES ('31826', '国营金波农场', '3', '31814', 'G');
INSERT INTO `ey_region` VALUES ('31827', '国营白沙农场', '3', '31814', 'G');
INSERT INTO `ey_region` VALUES ('31828', '国营牙叉农场', '3', '31814', 'G');
INSERT INTO `ey_region` VALUES ('31829', '国营卫星农场', '3', '31814', 'G');
INSERT INTO `ey_region` VALUES ('31830', '国营龙江农场', '3', '31814', 'G');
INSERT INTO `ey_region` VALUES ('31831', '国营珠碧江农场', '3', '31814', 'G');
INSERT INTO `ey_region` VALUES ('31832', '国营芙蓉田农场', '3', '31814', 'G');
INSERT INTO `ey_region` VALUES ('31833', '国营大岭农场', '3', '31814', 'G');
INSERT INTO `ey_region` VALUES ('31834', '国营邦溪农场', '3', '31814', 'G');
INSERT INTO `ey_region` VALUES ('31835', '昌江县', '2', '31563', 'C');
INSERT INTO `ey_region` VALUES ('31836', '石碌镇', '3', '31835', 'S');
INSERT INTO `ey_region` VALUES ('31837', '叉河镇', '3', '31835', 'C');
INSERT INTO `ey_region` VALUES ('31838', '十月田镇', '3', '31835', 'S');
INSERT INTO `ey_region` VALUES ('31839', '乌烈镇', '3', '31835', 'W');
INSERT INTO `ey_region` VALUES ('31840', '昌化镇', '3', '31835', 'C');
INSERT INTO `ey_region` VALUES ('31841', '海尾镇', '3', '31835', 'H');
INSERT INTO `ey_region` VALUES ('31842', '七叉镇', '3', '31835', 'Q');
INSERT INTO `ey_region` VALUES ('31843', '王下乡', '3', '31835', 'W');
INSERT INTO `ey_region` VALUES ('31844', '国营红田农场', '3', '31835', 'G');
INSERT INTO `ey_region` VALUES ('31845', '国营红林农场', '3', '31835', 'G');
INSERT INTO `ey_region` VALUES ('31846', '国营坝王岭林场', '3', '31835', 'G');
INSERT INTO `ey_region` VALUES ('31847', '海南钢铁公司', '3', '31835', 'H');
INSERT INTO `ey_region` VALUES ('31848', '乐东县', '2', '31563', 'L');
INSERT INTO `ey_region` VALUES ('31849', '抱由镇', '3', '31848', 'B');
INSERT INTO `ey_region` VALUES ('31850', '万冲镇', '3', '31848', 'W');
INSERT INTO `ey_region` VALUES ('31851', '大安镇', '3', '31848', 'D');
INSERT INTO `ey_region` VALUES ('31852', '志仲镇', '3', '31848', 'Z');
INSERT INTO `ey_region` VALUES ('31853', '千家镇', '3', '31848', 'Q');
INSERT INTO `ey_region` VALUES ('31854', '九所镇', '3', '31848', 'J');
INSERT INTO `ey_region` VALUES ('31855', '利国镇', '3', '31848', 'L');
INSERT INTO `ey_region` VALUES ('31856', '黄流镇', '3', '31848', 'H');
INSERT INTO `ey_region` VALUES ('31857', '佛罗镇', '3', '31848', 'F');
INSERT INTO `ey_region` VALUES ('31858', '尖峰镇', '3', '31848', 'J');
INSERT INTO `ey_region` VALUES ('31859', '莺歌海镇', '3', '31848', 'Y');
INSERT INTO `ey_region` VALUES ('31860', '国营乐中农场', '3', '31848', 'G');
INSERT INTO `ey_region` VALUES ('31861', '国营山荣农场', '3', '31848', 'G');
INSERT INTO `ey_region` VALUES ('31862', '国营乐光农场', '3', '31848', 'G');
INSERT INTO `ey_region` VALUES ('31863', '国营报伦农场', '3', '31848', 'G');
INSERT INTO `ey_region` VALUES ('31864', '国营福报农场', '3', '31848', 'G');
INSERT INTO `ey_region` VALUES ('31865', '国营保国农场', '3', '31848', 'G');
INSERT INTO `ey_region` VALUES ('31866', '国营保显农场', '3', '31848', 'G');
INSERT INTO `ey_region` VALUES ('31867', '国营尖峰岭林业公司', '3', '31848', 'G');
INSERT INTO `ey_region` VALUES ('31868', '国营莺歌海盐场', '3', '31848', 'G');
INSERT INTO `ey_region` VALUES ('31869', '陵水县', '2', '31563', 'L');
INSERT INTO `ey_region` VALUES ('31870', '椰林镇', '3', '31869', 'Y');
INSERT INTO `ey_region` VALUES ('31871', '光坡镇', '3', '31869', 'G');
INSERT INTO `ey_region` VALUES ('31872', '三才镇', '3', '31869', 'S');
INSERT INTO `ey_region` VALUES ('31873', '英州镇', '3', '31869', 'Y');
INSERT INTO `ey_region` VALUES ('31874', '隆广镇', '3', '31869', 'L');
INSERT INTO `ey_region` VALUES ('31875', '文罗镇', '3', '31869', 'W');
INSERT INTO `ey_region` VALUES ('31876', '本号镇', '3', '31869', 'B');
INSERT INTO `ey_region` VALUES ('31877', '新村镇', '3', '31869', 'X');
INSERT INTO `ey_region` VALUES ('31878', '黎安镇', '3', '31869', 'L');
INSERT INTO `ey_region` VALUES ('31879', '提蒙乡', '3', '31869', 'T');
INSERT INTO `ey_region` VALUES ('31880', '群英乡', '3', '31869', 'Q');
INSERT INTO `ey_region` VALUES ('31881', '国营岭门农场', '3', '31869', 'G');
INSERT INTO `ey_region` VALUES ('31882', '国营南平农场', '3', '31869', 'G');
INSERT INTO `ey_region` VALUES ('31883', '国营吊罗山林业公司', '3', '31869', 'G');
INSERT INTO `ey_region` VALUES ('31884', '保亭县', '2', '31563', 'B');
INSERT INTO `ey_region` VALUES ('31885', '保城镇', '3', '31884', 'B');
INSERT INTO `ey_region` VALUES ('31886', '什玲镇', '3', '31884', 'S');
INSERT INTO `ey_region` VALUES ('31887', '加茂镇', '3', '31884', 'J');
INSERT INTO `ey_region` VALUES ('31888', '响水镇', '3', '31884', 'X');
INSERT INTO `ey_region` VALUES ('31889', '新政镇', '3', '31884', 'X');
INSERT INTO `ey_region` VALUES ('31890', '三道镇', '3', '31884', 'S');
INSERT INTO `ey_region` VALUES ('31891', '六弓乡', '3', '31884', 'L');
INSERT INTO `ey_region` VALUES ('31892', '南林乡', '3', '31884', 'N');
INSERT INTO `ey_region` VALUES ('31893', '毛感乡', '3', '31884', 'M');
INSERT INTO `ey_region` VALUES ('31894', '国营五指山茶场', '3', '31884', 'G');
INSERT INTO `ey_region` VALUES ('31895', '国营新星农场', '3', '31884', 'G');
INSERT INTO `ey_region` VALUES ('31896', '国营保亭热作所', '3', '31884', 'G');
INSERT INTO `ey_region` VALUES ('31897', '国营金江农场', '3', '31884', 'G');
INSERT INTO `ey_region` VALUES ('31898', '国营南茂农场', '3', '31884', 'G');
INSERT INTO `ey_region` VALUES ('31899', '国营三道农场', '3', '31884', 'G');
INSERT INTO `ey_region` VALUES ('31900', '琼中县', '2', '31563', 'Q');
INSERT INTO `ey_region` VALUES ('31901', '营根镇', '3', '31900', 'Y');
INSERT INTO `ey_region` VALUES ('31902', '湾岭镇', '3', '31900', 'W');
INSERT INTO `ey_region` VALUES ('31903', '黎母山镇', '3', '31900', 'L');
INSERT INTO `ey_region` VALUES ('31904', '和平镇', '3', '31900', 'H');
INSERT INTO `ey_region` VALUES ('31905', '长征镇', '3', '31900', 'C');
INSERT INTO `ey_region` VALUES ('31906', '红毛镇', '3', '31900', 'H');
INSERT INTO `ey_region` VALUES ('31907', '中平镇', '3', '31900', 'Z');
INSERT INTO `ey_region` VALUES ('31908', '吊罗山乡', '3', '31900', 'D');
INSERT INTO `ey_region` VALUES ('31909', '上安乡', '3', '31900', 'S');
INSERT INTO `ey_region` VALUES ('31910', '什运乡', '3', '31900', 'S');
INSERT INTO `ey_region` VALUES ('31911', '国营新进农场', '3', '31900', 'G');
INSERT INTO `ey_region` VALUES ('31912', '国营大丰农场', '3', '31900', 'G');
INSERT INTO `ey_region` VALUES ('31913', '国营阳江农场', '3', '31900', 'G');
INSERT INTO `ey_region` VALUES ('31914', '国营乌石农场', '3', '31900', 'G');
INSERT INTO `ey_region` VALUES ('31915', '国营南方农场', '3', '31900', 'G');
INSERT INTO `ey_region` VALUES ('31916', '国营岭头农场', '3', '31900', 'G');
INSERT INTO `ey_region` VALUES ('31917', '国营加钗农场', '3', '31900', 'G');
INSERT INTO `ey_region` VALUES ('31918', '国营长征农场', '3', '31900', 'G');
INSERT INTO `ey_region` VALUES ('31919', '国营乘坡农场', '3', '31900', 'G');
INSERT INTO `ey_region` VALUES ('31920', '国营太平农场', '3', '31900', 'G');
INSERT INTO `ey_region` VALUES ('31921', '国营新伟农场', '3', '31900', 'G');
INSERT INTO `ey_region` VALUES ('31922', '国营黎母山林业公司', '3', '31900', 'G');
INSERT INTO `ey_region` VALUES ('31923', '西沙群岛', '3', '31924', 'X');
INSERT INTO `ey_region` VALUES ('31924', '三沙市', '2', '31563', 'S');
INSERT INTO `ey_region` VALUES ('31925', '南沙群岛', '3', '31924', 'N');
INSERT INTO `ey_region` VALUES ('47499', '香港岛', '2', '47494', 'X');
INSERT INTO `ey_region` VALUES ('31927', '中沙群岛的岛礁及其海域', '3', '31924', 'Z');
INSERT INTO `ey_region` VALUES ('47498', '九龙', '2', '47494', 'J');
INSERT INTO `ey_region` VALUES ('31929', '重庆市', '1', '0', 'Z');
INSERT INTO `ey_region` VALUES ('31930', '重庆市', '2', '31929', 'C');
INSERT INTO `ey_region` VALUES ('31931', '万州区', '3', '31930', 'W');
INSERT INTO `ey_region` VALUES ('31984', '涪陵区', '3', '31930', 'F');
INSERT INTO `ey_region` VALUES ('32031', '渝中区', '3', '31930', 'Y');
INSERT INTO `ey_region` VALUES ('32044', '大渡口区', '3', '31930', 'D');
INSERT INTO `ey_region` VALUES ('32053', '江北区', '3', '31930', 'J');
INSERT INTO `ey_region` VALUES ('32066', '沙坪坝区', '3', '31930', 'S');
INSERT INTO `ey_region` VALUES ('32093', '九龙坡区', '3', '31930', 'J');
INSERT INTO `ey_region` VALUES ('32112', '南岸区', '3', '31930', 'N');
INSERT INTO `ey_region` VALUES ('32127', '北碚区', '3', '31930', 'B');
INSERT INTO `ey_region` VALUES ('32145', '万盛区', '3', '31930', 'W');
INSERT INTO `ey_region` VALUES ('32156', '双桥区', '3', '31930', 'S');
INSERT INTO `ey_region` VALUES ('32160', '渝北区', '3', '31930', 'Y');
INSERT INTO `ey_region` VALUES ('32191', '巴南区', '3', '31930', 'B');
INSERT INTO `ey_region` VALUES ('32213', '黔江区', '3', '31930', 'Q');
INSERT INTO `ey_region` VALUES ('32244', '长寿区', '3', '31930', 'C');
INSERT INTO `ey_region` VALUES ('32263', '江津区', '3', '31930', 'J');
INSERT INTO `ey_region` VALUES ('32291', '合川区', '3', '31930', 'H');
INSERT INTO `ey_region` VALUES ('32322', '永川区', '3', '31930', 'Y');
INSERT INTO `ey_region` VALUES ('32345', '南川区', '3', '31930', 'N');
INSERT INTO `ey_region` VALUES ('32380', '县', '2', '31929', 'X');
INSERT INTO `ey_region` VALUES ('32381', '綦江县', '3', '32380', 'Q');
INSERT INTO `ey_region` VALUES ('32401', '潼南县', '3', '32380', 'T');
INSERT INTO `ey_region` VALUES ('32424', '铜梁县', '3', '32380', 'T');
INSERT INTO `ey_region` VALUES ('32453', '大足县', '3', '32380', 'D');
INSERT INTO `ey_region` VALUES ('32478', '荣昌县', '3', '32380', 'R');
INSERT INTO `ey_region` VALUES ('32499', '璧山县', '3', '32380', 'B');
INSERT INTO `ey_region` VALUES ('32513', '梁平县', '3', '32380', 'L');
INSERT INTO `ey_region` VALUES ('32549', '城口县', '3', '32380', 'C');
INSERT INTO `ey_region` VALUES ('32574', '丰都县', '3', '32380', 'F');
INSERT INTO `ey_region` VALUES ('32606', '垫江县', '3', '32380', 'D');
INSERT INTO `ey_region` VALUES ('32632', '武隆县', '3', '32380', 'W');
INSERT INTO `ey_region` VALUES ('32659', '忠县', '3', '32380', 'Z');
INSERT INTO `ey_region` VALUES ('32688', '开县', '3', '32380', 'K');
INSERT INTO `ey_region` VALUES ('32727', '云阳县', '3', '32380', 'Y');
INSERT INTO `ey_region` VALUES ('32771', '奉节县', '3', '32380', 'F');
INSERT INTO `ey_region` VALUES ('32802', '巫山县', '3', '32380', 'W');
INSERT INTO `ey_region` VALUES ('32829', '巫溪县', '3', '32380', 'W');
INSERT INTO `ey_region` VALUES ('32861', '石柱县', '3', '32380', 'S');
INSERT INTO `ey_region` VALUES ('32894', '秀山县', '3', '32380', 'X');
INSERT INTO `ey_region` VALUES ('32927', '酉阳县', '3', '32380', 'Y');
INSERT INTO `ey_region` VALUES ('32967', '彭水县', '3', '32380', 'P');
INSERT INTO `ey_region` VALUES ('33007', '四川省', '1', '0', 'S');
INSERT INTO `ey_region` VALUES ('33008', '成都市', '2', '33007', 'C');
INSERT INTO `ey_region` VALUES ('33009', '市辖区', '3', '33008', 'S');
INSERT INTO `ey_region` VALUES ('33010', '锦江区', '3', '33008', 'J');
INSERT INTO `ey_region` VALUES ('33027', '青羊区', '3', '33008', 'Q');
INSERT INTO `ey_region` VALUES ('33042', '金牛区', '3', '33008', 'J');
INSERT INTO `ey_region` VALUES ('33058', '武侯区', '3', '33008', 'W');
INSERT INTO `ey_region` VALUES ('33076', '成华区', '3', '33008', 'C');
INSERT INTO `ey_region` VALUES ('33091', '龙泉驿区', '3', '33008', 'L');
INSERT INTO `ey_region` VALUES ('33104', '青白江区', '3', '33008', 'Q');
INSERT INTO `ey_region` VALUES ('33116', '新都区', '3', '33008', 'X');
INSERT INTO `ey_region` VALUES ('33130', '温江区', '3', '33008', 'W');
INSERT INTO `ey_region` VALUES ('33141', '金堂县', '3', '33008', 'J');
INSERT INTO `ey_region` VALUES ('33163', '双流县', '3', '33008', 'S');
INSERT INTO `ey_region` VALUES ('33189', '郫县', '3', '33008', 'P');
INSERT INTO `ey_region` VALUES ('33205', '大邑县', '3', '33008', 'D');
INSERT INTO `ey_region` VALUES ('33226', '蒲江县', '3', '33008', 'P');
INSERT INTO `ey_region` VALUES ('33239', '新津县', '3', '33008', 'X');
INSERT INTO `ey_region` VALUES ('33252', '都江堰市', '3', '33008', 'D');
INSERT INTO `ey_region` VALUES ('33272', '彭州市', '3', '33008', 'P');
INSERT INTO `ey_region` VALUES ('33293', '邛崃市', '3', '33008', 'Q');
INSERT INTO `ey_region` VALUES ('33318', '崇州市', '3', '33008', 'C');
INSERT INTO `ey_region` VALUES ('33344', '自贡市', '2', '33007', 'Z');
INSERT INTO `ey_region` VALUES ('33345', '市辖区', '3', '33344', 'S');
INSERT INTO `ey_region` VALUES ('33346', '自流井区', '3', '33344', 'Z');
INSERT INTO `ey_region` VALUES ('33360', '贡井区', '3', '33344', 'G');
INSERT INTO `ey_region` VALUES ('33374', '大安区', '3', '33344', 'D');
INSERT INTO `ey_region` VALUES ('33391', '沿滩区', '3', '33344', 'Y');
INSERT INTO `ey_region` VALUES ('33405', '荣县', '3', '33344', 'R');
INSERT INTO `ey_region` VALUES ('33433', '富顺县', '3', '33344', 'F');
INSERT INTO `ey_region` VALUES ('33460', '攀枝花市', '2', '33007', 'P');
INSERT INTO `ey_region` VALUES ('33461', '市辖区', '3', '33460', 'S');
INSERT INTO `ey_region` VALUES ('33462', '攀枝花东区', '3', '33460', 'P');
INSERT INTO `ey_region` VALUES ('33473', '西区', '3', '33460', 'X');
INSERT INTO `ey_region` VALUES ('33481', '仁和区', '3', '33460', 'R');
INSERT INTO `ey_region` VALUES ('33497', '米易县', '3', '33460', 'M');
INSERT INTO `ey_region` VALUES ('33511', '盐边县', '3', '33460', 'Y');
INSERT INTO `ey_region` VALUES ('33528', '泸州市', '2', '33007', 'L');
INSERT INTO `ey_region` VALUES ('33529', '市辖区', '3', '33528', 'S');
INSERT INTO `ey_region` VALUES ('33530', '江阳区', '3', '33528', 'J');
INSERT INTO `ey_region` VALUES ('33548', '纳溪区', '3', '33528', 'N');
INSERT INTO `ey_region` VALUES ('33563', '龙马潭区', '3', '33528', 'L');
INSERT INTO `ey_region` VALUES ('33577', '泸县', '3', '33528', 'L');
INSERT INTO `ey_region` VALUES ('33597', '合江县', '3', '33528', 'H');
INSERT INTO `ey_region` VALUES ('33625', '叙永县', '3', '33528', 'X');
INSERT INTO `ey_region` VALUES ('33654', '古蔺县', '3', '33528', 'G');
INSERT INTO `ey_region` VALUES ('33681', '德阳市', '2', '33007', 'D');
INSERT INTO `ey_region` VALUES ('33682', '市辖区', '3', '33681', 'S');
INSERT INTO `ey_region` VALUES ('33683', '旌阳区', '3', '33681', 'J');
INSERT INTO `ey_region` VALUES ('33701', '中江县', '3', '33681', 'Z');
INSERT INTO `ey_region` VALUES ('33747', '罗江县', '3', '33681', 'L');
INSERT INTO `ey_region` VALUES ('33758', '广汉市', '3', '33681', 'G');
INSERT INTO `ey_region` VALUES ('33778', '什邡市', '3', '33681', 'S');
INSERT INTO `ey_region` VALUES ('33795', '绵竹市', '3', '33681', 'M');
INSERT INTO `ey_region` VALUES ('33817', '绵阳市', '2', '33007', 'M');
INSERT INTO `ey_region` VALUES ('33818', '市辖区', '3', '33817', 'S');
INSERT INTO `ey_region` VALUES ('33819', '涪城区', '3', '33817', 'F');
INSERT INTO `ey_region` VALUES ('33844', '游仙区', '3', '33817', 'Y');
INSERT INTO `ey_region` VALUES ('33873', '三台县', '3', '33817', 'S');
INSERT INTO `ey_region` VALUES ('33937', '盐亭县', '3', '33817', 'Y');
INSERT INTO `ey_region` VALUES ('33974', '安县', '3', '33817', 'A');
INSERT INTO `ey_region` VALUES ('33995', '梓潼县', '3', '33817', 'Z');
INSERT INTO `ey_region` VALUES ('34028', '北川县', '3', '33817', 'B');
INSERT INTO `ey_region` VALUES ('34049', '平武县', '3', '33817', 'P');
INSERT INTO `ey_region` VALUES ('34075', '江油市', '3', '33817', 'J');
INSERT INTO `ey_region` VALUES ('34120', '广元市', '2', '33007', 'G');
INSERT INTO `ey_region` VALUES ('34121', '市辖区', '3', '34120', 'S');
INSERT INTO `ey_region` VALUES ('34122', '市中区', '3', '34120', 'S');
INSERT INTO `ey_region` VALUES ('34143', '元坝区', '3', '34120', 'Y');
INSERT INTO `ey_region` VALUES ('34173', '朝天区', '3', '34120', 'C');
INSERT INTO `ey_region` VALUES ('34199', '旺苍县', '3', '34120', 'W');
INSERT INTO `ey_region` VALUES ('34238', '青川县', '3', '34120', 'Q');
INSERT INTO `ey_region` VALUES ('34276', '剑阁县', '3', '34120', 'J');
INSERT INTO `ey_region` VALUES ('34334', '苍溪县', '3', '34120', 'C');
INSERT INTO `ey_region` VALUES ('34376', '遂宁市', '2', '33007', 'S');
INSERT INTO `ey_region` VALUES ('34377', '市辖区', '3', '34376', 'S');
INSERT INTO `ey_region` VALUES ('34378', '船山区', '3', '34376', 'C');
INSERT INTO `ey_region` VALUES ('34404', '安居区', '3', '34376', 'A');
INSERT INTO `ey_region` VALUES ('34426', '蓬溪县', '3', '34376', 'P');
INSERT INTO `ey_region` VALUES ('34458', '射洪县', '3', '34376', 'S');
INSERT INTO `ey_region` VALUES ('34489', '大英县', '3', '34376', 'D');
INSERT INTO `ey_region` VALUES ('34501', '内江市', '2', '33007', 'N');
INSERT INTO `ey_region` VALUES ('34502', '市辖区', '3', '34501', 'S');
INSERT INTO `ey_region` VALUES ('34503', '市中区', '3', '34501', 'S');
INSERT INTO `ey_region` VALUES ('34524', '东兴区', '3', '34501', 'D');
INSERT INTO `ey_region` VALUES ('34554', '威远县', '3', '34501', 'W');
INSERT INTO `ey_region` VALUES ('34575', '资中县', '3', '34501', 'Z');
INSERT INTO `ey_region` VALUES ('34609', '隆昌县', '3', '34501', 'L');
INSERT INTO `ey_region` VALUES ('34628', '乐山市', '2', '33007', 'L');
INSERT INTO `ey_region` VALUES ('34629', '市辖区', '3', '34628', 'S');
INSERT INTO `ey_region` VALUES ('34630', '市中区', '3', '34628', 'S');
INSERT INTO `ey_region` VALUES ('34661', '沙湾区', '3', '34628', 'S');
INSERT INTO `ey_region` VALUES ('34676', '五通桥区', '3', '34628', 'W');
INSERT INTO `ey_region` VALUES ('34689', '金口河区', '3', '34628', 'J');
INSERT INTO `ey_region` VALUES ('34696', '犍为县', '3', '34628', 'Q');
INSERT INTO `ey_region` VALUES ('34727', '井研县', '3', '34628', 'J');
INSERT INTO `ey_region` VALUES ('34755', '夹江县', '3', '34628', 'J');
INSERT INTO `ey_region` VALUES ('34778', '沐川县', '3', '34628', 'M');
INSERT INTO `ey_region` VALUES ('34799', '峨边县', '3', '34628', 'E');
INSERT INTO `ey_region` VALUES ('34819', '马边县', '3', '34628', 'M');
INSERT INTO `ey_region` VALUES ('34840', '峨眉山市', '3', '34628', 'E');
INSERT INTO `ey_region` VALUES ('34859', '南充市', '2', '33007', 'N');
INSERT INTO `ey_region` VALUES ('34860', '市辖区', '3', '34859', 'S');
INSERT INTO `ey_region` VALUES ('34861', '顺庆区', '3', '34859', 'S');
INSERT INTO `ey_region` VALUES ('34890', '高坪区', '3', '34859', 'G');
INSERT INTO `ey_region` VALUES ('34923', '嘉陵区', '3', '34859', 'J');
INSERT INTO `ey_region` VALUES ('34967', '南部县', '3', '34859', 'N');
INSERT INTO `ey_region` VALUES ('35040', '营山县', '3', '34859', 'Y');
INSERT INTO `ey_region` VALUES ('35094', '蓬安县', '3', '34859', 'P');
INSERT INTO `ey_region` VALUES ('35134', '仪陇县', '3', '34859', 'Y');
INSERT INTO `ey_region` VALUES ('35193', '西充县', '3', '34859', 'X');
INSERT INTO `ey_region` VALUES ('35238', '阆中市', '3', '34859', 'L');
INSERT INTO `ey_region` VALUES ('35288', '眉山市', '2', '33007', 'M');
INSERT INTO `ey_region` VALUES ('35289', '市辖区', '3', '35288', 'S');
INSERT INTO `ey_region` VALUES ('35290', '东坡区', '3', '35288', 'D');
INSERT INTO `ey_region` VALUES ('35317', '仁寿县', '3', '35288', 'R');
INSERT INTO `ey_region` VALUES ('35378', '彭山县', '3', '35288', 'P');
INSERT INTO `ey_region` VALUES ('35392', '洪雅县', '3', '35288', 'H');
INSERT INTO `ey_region` VALUES ('35408', '丹棱县', '3', '35288', 'D');
INSERT INTO `ey_region` VALUES ('35416', '青神县', '3', '35288', 'Q');
INSERT INTO `ey_region` VALUES ('35427', '宜宾市', '2', '33007', 'Y');
INSERT INTO `ey_region` VALUES ('35428', '市辖区', '3', '35427', 'S');
INSERT INTO `ey_region` VALUES ('35429', '翠屏区', '3', '35427', 'C');
INSERT INTO `ey_region` VALUES ('35454', '宜宾县', '3', '35427', 'Y');
INSERT INTO `ey_region` VALUES ('35481', '南溪县', '3', '35427', 'N');
INSERT INTO `ey_region` VALUES ('35497', '江安县', '3', '35427', 'J');
INSERT INTO `ey_region` VALUES ('35516', '长宁县', '3', '35427', 'C');
INSERT INTO `ey_region` VALUES ('35535', '高县', '3', '35427', 'G');
INSERT INTO `ey_region` VALUES ('35555', '珙县', '3', '35427', 'G');
INSERT INTO `ey_region` VALUES ('35573', '筠连县', '3', '35427', 'J');
INSERT INTO `ey_region` VALUES ('35592', '兴文县', '3', '35427', 'X');
INSERT INTO `ey_region` VALUES ('35608', '屏山县', '3', '35427', 'P');
INSERT INTO `ey_region` VALUES ('35625', '广安市', '2', '33007', 'G');
INSERT INTO `ey_region` VALUES ('35626', '市辖区', '3', '35625', 'S');
INSERT INTO `ey_region` VALUES ('35627', '广安区', '3', '35625', 'G');
INSERT INTO `ey_region` VALUES ('35677', '岳池县', '3', '35625', 'Y');
INSERT INTO `ey_region` VALUES ('35721', '武胜县', '3', '35625', 'W');
INSERT INTO `ey_region` VALUES ('35753', '邻水县', '3', '35625', 'L');
INSERT INTO `ey_region` VALUES ('35799', '华蓥市', '3', '35625', 'H');
INSERT INTO `ey_region` VALUES ('35813', '达州市', '2', '33007', 'D');
INSERT INTO `ey_region` VALUES ('35814', '市辖区', '3', '35813', 'S');
INSERT INTO `ey_region` VALUES ('35815', '通川区', '3', '35813', 'T');
INSERT INTO `ey_region` VALUES ('35829', '达县', '3', '35813', 'D');
INSERT INTO `ey_region` VALUES ('35894', '宣汉县', '3', '35813', 'X');
INSERT INTO `ey_region` VALUES ('35949', '开江县', '3', '35813', 'K');
INSERT INTO `ey_region` VALUES ('35970', '大竹县', '3', '35813', 'D');
INSERT INTO `ey_region` VALUES ('36021', '渠县', '3', '35813', 'Q');
INSERT INTO `ey_region` VALUES ('36082', '万源市', '3', '35813', 'W');
INSERT INTO `ey_region` VALUES ('36136', '雅安市', '2', '33007', 'Y');
INSERT INTO `ey_region` VALUES ('36137', '市辖区', '3', '36136', 'S');
INSERT INTO `ey_region` VALUES ('36138', '雨城区', '3', '36136', 'Y');
INSERT INTO `ey_region` VALUES ('36161', '名山县', '3', '36136', 'M');
INSERT INTO `ey_region` VALUES ('36182', '荥经县', '3', '36136', 'Y');
INSERT INTO `ey_region` VALUES ('36204', '汉源县', '3', '36136', 'H');
INSERT INTO `ey_region` VALUES ('36245', '石棉县', '3', '36136', 'S');
INSERT INTO `ey_region` VALUES ('36263', '天全县', '3', '36136', 'T');
INSERT INTO `ey_region` VALUES ('36279', '芦山县', '3', '36136', 'L');
INSERT INTO `ey_region` VALUES ('36289', '宝兴县', '3', '36136', 'B');
INSERT INTO `ey_region` VALUES ('36299', '巴中市', '2', '33007', 'B');
INSERT INTO `ey_region` VALUES ('36300', '市辖区', '3', '36299', 'S');
INSERT INTO `ey_region` VALUES ('36301', '巴州区', '3', '36299', 'B');
INSERT INTO `ey_region` VALUES ('36354', '通江县', '3', '36299', 'T');
INSERT INTO `ey_region` VALUES ('36404', '南江县', '3', '36299', 'N');
INSERT INTO `ey_region` VALUES ('36453', '平昌县', '3', '36299', 'P');
INSERT INTO `ey_region` VALUES ('36497', '资阳市', '2', '33007', 'Z');
INSERT INTO `ey_region` VALUES ('36498', '市辖区', '3', '36497', 'S');
INSERT INTO `ey_region` VALUES ('36499', '雁江区', '3', '36497', 'Y');
INSERT INTO `ey_region` VALUES ('36527', '安岳县', '3', '36497', 'A');
INSERT INTO `ey_region` VALUES ('36597', '乐至县', '3', '36497', 'L');
INSERT INTO `ey_region` VALUES ('36623', '简阳市', '3', '36497', 'J');
INSERT INTO `ey_region` VALUES ('36679', '阿坝州', '2', '33007', 'A');
INSERT INTO `ey_region` VALUES ('36680', '汶川县', '3', '36679', 'W');
INSERT INTO `ey_region` VALUES ('36694', '理县', '3', '36679', 'L');
INSERT INTO `ey_region` VALUES ('36708', '茂县', '3', '36679', 'M');
INSERT INTO `ey_region` VALUES ('36731', '松潘县', '3', '36679', 'S');
INSERT INTO `ey_region` VALUES ('36759', '九寨沟县', '3', '36679', 'J');
INSERT INTO `ey_region` VALUES ('36778', '金川县', '3', '36679', 'J');
INSERT INTO `ey_region` VALUES ('36802', '小金县', '3', '36679', 'X');
INSERT INTO `ey_region` VALUES ('36824', '黑水县', '3', '36679', 'H');
INSERT INTO `ey_region` VALUES ('36842', '马尔康县', '3', '36679', 'M');
INSERT INTO `ey_region` VALUES ('36858', '壤塘县', '3', '36679', 'R');
INSERT INTO `ey_region` VALUES ('36871', '阿坝县', '3', '36679', 'A');
INSERT INTO `ey_region` VALUES ('36893', '若尔盖县', '3', '36679', 'R');
INSERT INTO `ey_region` VALUES ('36914', '红原县', '3', '36679', 'H');
INSERT INTO `ey_region` VALUES ('36926', '甘孜州', '2', '33007', 'G');
INSERT INTO `ey_region` VALUES ('36927', '康定县', '3', '36926', 'K');
INSERT INTO `ey_region` VALUES ('36949', '泸定县', '3', '36926', 'L');
INSERT INTO `ey_region` VALUES ('36962', '丹巴县', '3', '36926', 'D');
INSERT INTO `ey_region` VALUES ('36978', '九龙县', '3', '36926', 'J');
INSERT INTO `ey_region` VALUES ('36997', '雅江县', '3', '36926', 'Y');
INSERT INTO `ey_region` VALUES ('37015', '道孚县', '3', '36926', 'D');
INSERT INTO `ey_region` VALUES ('37038', '炉霍县', '3', '36926', 'L');
INSERT INTO `ey_region` VALUES ('37055', '甘孜县', '3', '36926', 'G');
INSERT INTO `ey_region` VALUES ('37078', '新龙县', '3', '36926', 'X');
INSERT INTO `ey_region` VALUES ('37098', '德格县', '3', '36926', 'D');
INSERT INTO `ey_region` VALUES ('37125', '白玉县', '3', '36926', 'B');
INSERT INTO `ey_region` VALUES ('37143', '石渠县', '3', '36926', 'S');
INSERT INTO `ey_region` VALUES ('37166', '色达县', '3', '36926', 'S');
INSERT INTO `ey_region` VALUES ('37184', '理塘县', '3', '36926', 'L');
INSERT INTO `ey_region` VALUES ('37209', '巴塘县', '3', '36926', 'B');
INSERT INTO `ey_region` VALUES ('37229', '乡城县', '3', '36926', 'X');
INSERT INTO `ey_region` VALUES ('37242', '稻城县', '3', '36926', 'D');
INSERT INTO `ey_region` VALUES ('37257', '得荣县', '3', '36926', 'D');
INSERT INTO `ey_region` VALUES ('37270', '凉山州', '2', '33007', 'L');
INSERT INTO `ey_region` VALUES ('37271', '西昌市', '3', '37270', 'X');
INSERT INTO `ey_region` VALUES ('37315', '木里县', '3', '37270', 'M');
INSERT INTO `ey_region` VALUES ('37345', '盐源县', '3', '37270', 'Y');
INSERT INTO `ey_region` VALUES ('37380', '德昌', '3', '37270', 'D');
INSERT INTO `ey_region` VALUES ('37404', '会理县', '3', '37270', 'H');
INSERT INTO `ey_region` VALUES ('37455', '会东县', '3', '37270', 'H');
INSERT INTO `ey_region` VALUES ('37509', '宁南县', '3', '37270', 'N');
INSERT INTO `ey_region` VALUES ('37535', '普格县', '3', '37270', 'P');
INSERT INTO `ey_region` VALUES ('37570', '布拖县', '3', '37270', 'B');
INSERT INTO `ey_region` VALUES ('37601', '金阳县', '3', '37270', 'J');
INSERT INTO `ey_region` VALUES ('37636', '昭觉县', '3', '37270', 'Z');
INSERT INTO `ey_region` VALUES ('37684', '喜德县', '3', '37270', 'X');
INSERT INTO `ey_region` VALUES ('37709', '冕宁县', '3', '37270', 'M');
INSERT INTO `ey_region` VALUES ('37748', '越西县', '3', '37270', 'Y');
INSERT INTO `ey_region` VALUES ('37790', '甘洛县', '3', '37270', 'G');
INSERT INTO `ey_region` VALUES ('37819', '美姑县', '3', '37270', 'M');
INSERT INTO `ey_region` VALUES ('37856', '雷波县', '3', '37270', 'L');
INSERT INTO `ey_region` VALUES ('37906', '贵州省', '1', '0', 'G');
INSERT INTO `ey_region` VALUES ('37907', '贵阳市', '2', '37906', 'G');
INSERT INTO `ey_region` VALUES ('37908', '市辖区', '3', '37907', 'S');
INSERT INTO `ey_region` VALUES ('37909', '南明区', '3', '37907', 'N');
INSERT INTO `ey_region` VALUES ('37927', '云岩区', '3', '37907', 'Y');
INSERT INTO `ey_region` VALUES ('37944', '花溪区', '3', '37907', 'H');
INSERT INTO `ey_region` VALUES ('37961', '乌当区', '3', '37907', 'W');
INSERT INTO `ey_region` VALUES ('37977', '白云区', '3', '37907', 'B');
INSERT INTO `ey_region` VALUES ('37987', '小河区', '3', '37907', 'X');
INSERT INTO `ey_region` VALUES ('37991', '开阳县', '3', '37907', 'K');
INSERT INTO `ey_region` VALUES ('38008', '息烽县', '3', '37907', 'X');
INSERT INTO `ey_region` VALUES ('38019', '修文县', '3', '37907', 'X');
INSERT INTO `ey_region` VALUES ('38030', '清镇市', '3', '37907', 'Q');
INSERT INTO `ey_region` VALUES ('38042', '六盘水市', '2', '37906', 'L');
INSERT INTO `ey_region` VALUES ('38043', '钟山区', '3', '38042', 'Z');
INSERT INTO `ey_region` VALUES ('38053', '六枝特区', '3', '38042', 'L');
INSERT INTO `ey_region` VALUES ('38073', '水城县', '3', '38042', 'S');
INSERT INTO `ey_region` VALUES ('38107', '盘县', '3', '38042', 'P');
INSERT INTO `ey_region` VALUES ('38145', '遵义市', '2', '37906', 'Z');
INSERT INTO `ey_region` VALUES ('38146', '市辖区', '3', '38145', 'S');
INSERT INTO `ey_region` VALUES ('38147', '红花岗区', '3', '38145', 'H');
INSERT INTO `ey_region` VALUES ('38164', '汇川区', '3', '38145', 'H');
INSERT INTO `ey_region` VALUES ('38174', '遵义县', '3', '38145', 'Z');
INSERT INTO `ey_region` VALUES ('38206', '桐梓县', '3', '38145', 'T');
INSERT INTO `ey_region` VALUES ('38231', '绥阳县', '3', '38145', 'S');
INSERT INTO `ey_region` VALUES ('38247', '正安县', '3', '38145', 'Z');
INSERT INTO `ey_region` VALUES ('38267', '道真县', '3', '38145', 'D');
INSERT INTO `ey_region` VALUES ('38282', '务川县', '3', '38145', 'W');
INSERT INTO `ey_region` VALUES ('38298', '凤冈县', '3', '38145', 'F');
INSERT INTO `ey_region` VALUES ('38313', '湄潭县', '3', '38145', 'M');
INSERT INTO `ey_region` VALUES ('38329', '余庆县', '3', '38145', 'Y');
INSERT INTO `ey_region` VALUES ('38340', '习水县', '3', '38145', 'X');
INSERT INTO `ey_region` VALUES ('38364', '赤水市', '3', '38145', 'C');
INSERT INTO `ey_region` VALUES ('38382', '仁怀市', '3', '38145', 'R');
INSERT INTO `ey_region` VALUES ('38402', '安顺市', '2', '37906', 'A');
INSERT INTO `ey_region` VALUES ('38403', '市辖区', '3', '38402', 'S');
INSERT INTO `ey_region` VALUES ('38404', '西秀区', '3', '38402', 'X');
INSERT INTO `ey_region` VALUES ('38429', '平坝县', '3', '38402', 'P');
INSERT INTO `ey_region` VALUES ('38440', '普定县', '3', '38402', 'P');
INSERT INTO `ey_region` VALUES ('38452', '镇宁县', '3', '38402', 'Z');
INSERT INTO `ey_region` VALUES ('38469', '关岭县', '3', '38402', 'G');
INSERT INTO `ey_region` VALUES ('38484', '紫云县', '3', '38402', 'Z');
INSERT INTO `ey_region` VALUES ('38497', '铜仁地区', '2', '37906', 'T');
INSERT INTO `ey_region` VALUES ('38498', '铜仁市', '3', '38497', 'T');
INSERT INTO `ey_region` VALUES ('38516', '江口县', '3', '38497', 'J');
INSERT INTO `ey_region` VALUES ('38526', '玉屏县', '3', '38497', 'Y');
INSERT INTO `ey_region` VALUES ('38533', '石阡县', '3', '38497', 'S');
INSERT INTO `ey_region` VALUES ('38552', '思南县　', '3', '38497', 'S');
INSERT INTO `ey_region` VALUES ('38580', '印江县', '3', '38497', 'Y');
INSERT INTO `ey_region` VALUES ('38598', '德江县', '3', '38497', 'D');
INSERT INTO `ey_region` VALUES ('38619', '沿河县', '3', '38497', 'Y');
INSERT INTO `ey_region` VALUES ('38642', '松桃县', '3', '38497', 'S');
INSERT INTO `ey_region` VALUES ('38671', '万山特区', '3', '38497', 'W');
INSERT INTO `ey_region` VALUES ('38677', '黔西南州', '2', '37906', 'Q');
INSERT INTO `ey_region` VALUES ('38678', '兴义市', '3', '38677', 'X');
INSERT INTO `ey_region` VALUES ('38705', '兴仁县', '3', '38677', 'X');
INSERT INTO `ey_region` VALUES ('38722', '普安县', '3', '38677', 'P');
INSERT INTO `ey_region` VALUES ('38737', '晴隆县', '3', '38677', 'Q');
INSERT INTO `ey_region` VALUES ('38752', '贞丰县', '3', '38677', 'Z');
INSERT INTO `ey_region` VALUES ('38766', '望谟县', '3', '38677', 'W');
INSERT INTO `ey_region` VALUES ('38784', '册亨县', '3', '38677', 'C');
INSERT INTO `ey_region` VALUES ('38799', '安龙县', '3', '38677', 'A');
INSERT INTO `ey_region` VALUES ('38816', '毕节地区', '2', '37906', 'B');
INSERT INTO `ey_region` VALUES ('38817', '毕节市', '3', '38816', 'B');
INSERT INTO `ey_region` VALUES ('38859', '大方县', '3', '38816', 'D');
INSERT INTO `ey_region` VALUES ('38896', '黔西县', '3', '38816', 'Q');
INSERT INTO `ey_region` VALUES ('38925', '金沙县', '3', '38816', 'J');
INSERT INTO `ey_region` VALUES ('38952', '织金县', '3', '38816', 'Z');
INSERT INTO `ey_region` VALUES ('38985', '纳雍县', '3', '38816', 'N');
INSERT INTO `ey_region` VALUES ('39011', '威宁县', '3', '38816', 'W');
INSERT INTO `ey_region` VALUES ('39047', '赫章县', '3', '38816', 'H');
INSERT INTO `ey_region` VALUES ('39075', '黔东南州', '2', '37906', 'Q');
INSERT INTO `ey_region` VALUES ('39076', '凯里市', '3', '39075', 'K');
INSERT INTO `ey_region` VALUES ('39092', '黄平县', '3', '39075', 'H');
INSERT INTO `ey_region` VALUES ('39107', '施秉县', '3', '39075', 'S');
INSERT INTO `ey_region` VALUES ('39116', '三穗县', '3', '39075', 'S');
INSERT INTO `ey_region` VALUES ('39126', '镇远县', '3', '39075', 'Z');
INSERT INTO `ey_region` VALUES ('39139', '岑巩县', '3', '39075', 'C');
INSERT INTO `ey_region` VALUES ('39151', '天柱县', '3', '39075', 'T');
INSERT INTO `ey_region` VALUES ('39168', '锦屏县', '3', '39075', 'J');
INSERT INTO `ey_region` VALUES ('39184', '剑河县', '3', '39075', 'J');
INSERT INTO `ey_region` VALUES ('39197', '台江县', '3', '39075', 'T');
INSERT INTO `ey_region` VALUES ('39206', '黎平县', '3', '39075', 'L');
INSERT INTO `ey_region` VALUES ('39232', '榕江县', '3', '39075', 'R');
INSERT INTO `ey_region` VALUES ('39252', '从江县', '3', '39075', 'C');
INSERT INTO `ey_region` VALUES ('39274', '雷山县', '3', '39075', 'L');
INSERT INTO `ey_region` VALUES ('39284', '麻江县', '3', '39075', 'M');
INSERT INTO `ey_region` VALUES ('39294', '丹寨县', '3', '39075', 'D');
INSERT INTO `ey_region` VALUES ('39302', '黔南州', '2', '37906', 'Q');
INSERT INTO `ey_region` VALUES ('39303', '都匀市', '3', '39302', 'D');
INSERT INTO `ey_region` VALUES ('39327', '福泉市', '3', '39302', 'F');
INSERT INTO `ey_region` VALUES ('39345', '荔波县', '3', '39302', 'L');
INSERT INTO `ey_region` VALUES ('39363', '贵定县', '3', '39302', 'G');
INSERT INTO `ey_region` VALUES ('39384', '瓮安县', '3', '39302', 'W');
INSERT INTO `ey_region` VALUES ('39408', '独山县', '3', '39302', 'D');
INSERT INTO `ey_region` VALUES ('39427', '平塘县', '3', '39302', 'P');
INSERT INTO `ey_region` VALUES ('39447', '罗甸县', '3', '39302', 'L');
INSERT INTO `ey_region` VALUES ('39474', '长顺县', '3', '39302', 'C');
INSERT INTO `ey_region` VALUES ('39493', '龙里县', '3', '39302', 'L');
INSERT INTO `ey_region` VALUES ('39508', '惠水县', '3', '39302', 'H');
INSERT INTO `ey_region` VALUES ('39534', '三都县', '3', '39302', 'S');
INSERT INTO `ey_region` VALUES ('39556', '云南省', '1', '0', 'Y');
INSERT INTO `ey_region` VALUES ('39557', '昆明市', '2', '39556', 'K');
INSERT INTO `ey_region` VALUES ('39558', '市辖区', '3', '39557', 'S');
INSERT INTO `ey_region` VALUES ('39559', '五华区', '3', '39557', 'W');
INSERT INTO `ey_region` VALUES ('39571', '盘龙区', '3', '39557', 'P');
INSERT INTO `ey_region` VALUES ('39582', '官渡区', '3', '39557', 'G');
INSERT INTO `ey_region` VALUES ('39594', '西山区', '3', '39557', 'X');
INSERT INTO `ey_region` VALUES ('39605', '东川区', '3', '39557', 'D');
INSERT INTO `ey_region` VALUES ('39614', '呈贡县', '3', '39557', 'C');
INSERT INTO `ey_region` VALUES ('39622', '晋宁县', '3', '39557', 'J');
INSERT INTO `ey_region` VALUES ('39632', '富民县', '3', '39557', 'F');
INSERT INTO `ey_region` VALUES ('39640', '宜良县', '3', '39557', 'Y');
INSERT INTO `ey_region` VALUES ('39650', '石林县', '3', '39557', 'S');
INSERT INTO `ey_region` VALUES ('39659', '嵩明县', '3', '39557', 'S');
INSERT INTO `ey_region` VALUES ('39667', '禄劝县', '3', '39557', 'L');
INSERT INTO `ey_region` VALUES ('39684', '寻甸县', '3', '39557', 'X');
INSERT INTO `ey_region` VALUES ('39701', '安宁市', '3', '39557', 'A');
INSERT INTO `ey_region` VALUES ('39710', '曲靖市', '2', '39556', 'Q');
INSERT INTO `ey_region` VALUES ('39711', '市辖区', '3', '39710', 'S');
INSERT INTO `ey_region` VALUES ('39712', '麒麟区', '3', '39710', 'Q');
INSERT INTO `ey_region` VALUES ('39724', '马龙县', '3', '39710', 'M');
INSERT INTO `ey_region` VALUES ('39733', '陆良县', '3', '39710', 'L');
INSERT INTO `ey_region` VALUES ('39744', '师宗县', '3', '39710', 'S');
INSERT INTO `ey_region` VALUES ('39753', '罗平县', '3', '39710', 'L');
INSERT INTO `ey_region` VALUES ('39766', '富源县', '3', '39710', 'F');
INSERT INTO `ey_region` VALUES ('39778', '会泽县', '3', '39710', 'H');
INSERT INTO `ey_region` VALUES ('39800', '沾益县', '3', '39710', 'Z');
INSERT INTO `ey_region` VALUES ('39809', '宣威市', '3', '39710', 'X');
INSERT INTO `ey_region` VALUES ('39836', '玉溪市', '2', '39556', 'Y');
INSERT INTO `ey_region` VALUES ('39837', '市辖区', '3', '39836', 'S');
INSERT INTO `ey_region` VALUES ('39838', '红塔区', '3', '39836', 'H');
INSERT INTO `ey_region` VALUES ('39850', '江川县', '3', '39836', 'J');
INSERT INTO `ey_region` VALUES ('39858', '澄江县', '3', '39836', 'C');
INSERT INTO `ey_region` VALUES ('39865', '通海县', '3', '39836', 'T');
INSERT INTO `ey_region` VALUES ('39875', '华宁县', '3', '39836', 'H');
INSERT INTO `ey_region` VALUES ('39881', '易门县', '3', '39836', 'Y');
INSERT INTO `ey_region` VALUES ('39889', '峨山县', '3', '39836', 'E');
INSERT INTO `ey_region` VALUES ('39899', '新平县', '3', '39836', 'X');
INSERT INTO `ey_region` VALUES ('39912', '元江县', '3', '39836', 'Y');
INSERT INTO `ey_region` VALUES ('39923', '保山市', '2', '39556', 'B');
INSERT INTO `ey_region` VALUES ('39924', '市辖区', '3', '39923', 'S');
INSERT INTO `ey_region` VALUES ('39925', '隆阳区', '3', '39923', 'L');
INSERT INTO `ey_region` VALUES ('39946', '施甸县', '3', '39923', 'S');
INSERT INTO `ey_region` VALUES ('39960', '腾冲县', '3', '39923', 'T');
INSERT INTO `ey_region` VALUES ('39979', '龙陵县', '3', '39923', 'L');
INSERT INTO `ey_region` VALUES ('39990', '昌宁县', '3', '39923', 'C');
INSERT INTO `ey_region` VALUES ('40004', '昭通市', '2', '39556', 'Z');
INSERT INTO `ey_region` VALUES ('40005', '市辖区', '3', '40004', 'S');
INSERT INTO `ey_region` VALUES ('40006', '昭阳区', '3', '40004', 'Z');
INSERT INTO `ey_region` VALUES ('40027', '鲁甸县', '3', '40004', 'L');
INSERT INTO `ey_region` VALUES ('40040', '巧家县', '3', '40004', 'Q');
INSERT INTO `ey_region` VALUES ('40057', '盐津县', '3', '40004', 'Y');
INSERT INTO `ey_region` VALUES ('40068', '大关县', '3', '40004', 'D');
INSERT INTO `ey_region` VALUES ('40078', '永善县', '3', '40004', 'Y');
INSERT INTO `ey_region` VALUES ('40094', '绥江县', '3', '40004', 'S');
INSERT INTO `ey_region` VALUES ('40100', '镇雄县', '3', '40004', 'Z');
INSERT INTO `ey_region` VALUES ('40129', '彝良县', '3', '40004', 'Y');
INSERT INTO `ey_region` VALUES ('40145', '威信县', '3', '40004', 'W');
INSERT INTO `ey_region` VALUES ('40156', '水富县', '3', '40004', 'S');
INSERT INTO `ey_region` VALUES ('40160', '丽江市', '2', '39556', 'L');
INSERT INTO `ey_region` VALUES ('40161', '市辖区', '3', '40160', 'S');
INSERT INTO `ey_region` VALUES ('40162', '古城区', '3', '40160', 'G');
INSERT INTO `ey_region` VALUES ('40172', '玉龙县', '3', '40160', 'Y');
INSERT INTO `ey_region` VALUES ('40189', '永胜县', '3', '40160', 'Y');
INSERT INTO `ey_region` VALUES ('40205', '华坪县', '3', '40160', 'H');
INSERT INTO `ey_region` VALUES ('40214', '宁蒗县', '3', '40160', 'N');
INSERT INTO `ey_region` VALUES ('40230', '思茅市', '2', '39556', 'S');
INSERT INTO `ey_region` VALUES ('40231', '市辖区', '3', '40230', 'S');
INSERT INTO `ey_region` VALUES ('40232', '翠云区', '3', '40230', 'C');
INSERT INTO `ey_region` VALUES ('40240', '普洱县', '3', '40230', 'P');
INSERT INTO `ey_region` VALUES ('40250', '墨江县', '3', '40230', 'M');
INSERT INTO `ey_region` VALUES ('40266', '景东县', '3', '40230', 'J');
INSERT INTO `ey_region` VALUES ('40280', '景谷县', '3', '40230', 'J');
INSERT INTO `ey_region` VALUES ('40291', '镇沅县', '3', '40230', 'Z');
INSERT INTO `ey_region` VALUES ('40301', '江城县', '3', '40230', 'J');
INSERT INTO `ey_region` VALUES ('40310', '孟连县', '3', '40230', 'M');
INSERT INTO `ey_region` VALUES ('40318', '澜沧县', '3', '40230', 'L');
INSERT INTO `ey_region` VALUES ('40340', '西盟县', '3', '40230', 'X');
INSERT INTO `ey_region` VALUES ('40348', '临沧市', '2', '39556', 'L');
INSERT INTO `ey_region` VALUES ('40349', '市辖区', '3', '40348', 'S');
INSERT INTO `ey_region` VALUES ('40350', '临翔区', '3', '40348', 'L');
INSERT INTO `ey_region` VALUES ('40361', '凤庆县', '3', '40348', 'F');
INSERT INTO `ey_region` VALUES ('40375', '云县', '3', '40348', 'Y');
INSERT INTO `ey_region` VALUES ('40388', '永德县', '3', '40348', 'Y');
INSERT INTO `ey_region` VALUES ('40400', '镇康县', '3', '40348', 'Z');
INSERT INTO `ey_region` VALUES ('40408', '双江县', '3', '40348', 'S');
INSERT INTO `ey_region` VALUES ('40417', '耿马县', '3', '40348', 'G');
INSERT INTO `ey_region` VALUES ('40429', '沧源县', '3', '40348', 'C');
INSERT INTO `ey_region` VALUES ('40441', '楚雄州', '2', '39556', 'C');
INSERT INTO `ey_region` VALUES ('40442', '楚雄市', '3', '40441', 'C');
INSERT INTO `ey_region` VALUES ('40458', '双柏县', '3', '40441', 'S');
INSERT INTO `ey_region` VALUES ('40467', '牟定县', '3', '40441', 'M');
INSERT INTO `ey_region` VALUES ('40475', '南华县', '3', '40441', 'N');
INSERT INTO `ey_region` VALUES ('40486', '姚安县', '3', '40441', 'Y');
INSERT INTO `ey_region` VALUES ('40496', '大姚县', '3', '40441', 'D');
INSERT INTO `ey_region` VALUES ('40509', '永仁县', '3', '40441', 'Y');
INSERT INTO `ey_region` VALUES ('40517', '元谋县', '3', '40441', 'Y');
INSERT INTO `ey_region` VALUES ('40528', '武定县', '3', '40441', 'W');
INSERT INTO `ey_region` VALUES ('40540', '禄丰县', '3', '40441', 'L');
INSERT INTO `ey_region` VALUES ('40555', '红河州', '2', '39556', 'H');
INSERT INTO `ey_region` VALUES ('40556', '个旧市', '3', '40555', 'G');
INSERT INTO `ey_region` VALUES ('40567', '开远市', '3', '40555', 'K');
INSERT INTO `ey_region` VALUES ('40576', '蒙自县', '3', '40555', 'M');
INSERT INTO `ey_region` VALUES ('40588', '屏边县', '3', '40555', 'P');
INSERT INTO `ey_region` VALUES ('40596', '建水县', '3', '40555', 'J');
INSERT INTO `ey_region` VALUES ('40611', '石屏县', '3', '40555', 'S');
INSERT INTO `ey_region` VALUES ('40621', '弥勒县', '3', '40555', 'M');
INSERT INTO `ey_region` VALUES ('40635', '泸西县', '3', '40555', 'L');
INSERT INTO `ey_region` VALUES ('40644', '元阳县', '3', '40555', 'Y');
INSERT INTO `ey_region` VALUES ('40659', '红河县', '3', '40555', 'H');
INSERT INTO `ey_region` VALUES ('40673', '金平县', '3', '40555', 'J');
INSERT INTO `ey_region` VALUES ('40688', '绿春县', '3', '40555', 'L');
INSERT INTO `ey_region` VALUES ('40698', '河口县', '3', '40555', 'H');
INSERT INTO `ey_region` VALUES ('40705', '文山州', '2', '39556', 'W');
INSERT INTO `ey_region` VALUES ('40706', '文山县', '3', '40705', 'W');
INSERT INTO `ey_region` VALUES ('40722', '砚山县', '3', '40705', 'Y');
INSERT INTO `ey_region` VALUES ('40734', '西畴县', '3', '40705', 'X');
INSERT INTO `ey_region` VALUES ('40744', '麻栗坡县', '3', '40705', 'M');
INSERT INTO `ey_region` VALUES ('40756', '马关县', '3', '40705', 'M');
INSERT INTO `ey_region` VALUES ('40770', '丘北县', '3', '40705', 'Q');
INSERT INTO `ey_region` VALUES ('40783', '广南县', '3', '40705', 'G');
INSERT INTO `ey_region` VALUES ('40802', '富宁县', '3', '40705', 'F');
INSERT INTO `ey_region` VALUES ('40816', '西双版纳州', '2', '39556', 'X');
INSERT INTO `ey_region` VALUES ('40817', '景洪市', '3', '40816', 'J');
INSERT INTO `ey_region` VALUES ('40829', '勐海县', '3', '40816', 'M');
INSERT INTO `ey_region` VALUES ('40841', '勐腊县', '3', '40816', 'M');
INSERT INTO `ey_region` VALUES ('40852', '大理州', '2', '39556', 'D');
INSERT INTO `ey_region` VALUES ('40853', '大理市', '3', '40852', 'D');
INSERT INTO `ey_region` VALUES ('40866', '漾濞县', '3', '40852', 'Y');
INSERT INTO `ey_region` VALUES ('40876', '祥云县', '3', '40852', 'X');
INSERT INTO `ey_region` VALUES ('40887', '宾川县', '3', '40852', 'B');
INSERT INTO `ey_region` VALUES ('40901', '弥渡县', '3', '40852', 'M');
INSERT INTO `ey_region` VALUES ('40910', '南涧县', '3', '40852', 'N');
INSERT INTO `ey_region` VALUES ('40919', '巍山县', '3', '40852', 'W');
INSERT INTO `ey_region` VALUES ('40930', '永平县', '3', '40852', 'Y');
INSERT INTO `ey_region` VALUES ('40938', '云龙县', '3', '40852', 'Y');
INSERT INTO `ey_region` VALUES ('40950', '洱源县', '3', '40852', 'E');
INSERT INTO `ey_region` VALUES ('40960', '剑川县', '3', '40852', 'J');
INSERT INTO `ey_region` VALUES ('40969', '鹤庆县', '3', '40852', 'H');
INSERT INTO `ey_region` VALUES ('40979', '德宏州', '2', '39556', 'D');
INSERT INTO `ey_region` VALUES ('40980', '瑞丽市', '3', '40979', 'R');
INSERT INTO `ey_region` VALUES ('40988', '潞西市', '3', '40979', 'L');
INSERT INTO `ey_region` VALUES ('41000', '梁河县', '3', '40979', 'L');
INSERT INTO `ey_region` VALUES ('41010', '盈江县', '3', '40979', 'Y');
INSERT INTO `ey_region` VALUES ('41026', '陇川县', '3', '40979', 'L');
INSERT INTO `ey_region` VALUES ('41036', '怒江州', '2', '39556', 'N');
INSERT INTO `ey_region` VALUES ('41037', '泸水县', '3', '41036', 'L');
INSERT INTO `ey_region` VALUES ('41047', '福贡县', '3', '41036', 'F');
INSERT INTO `ey_region` VALUES ('41055', '贡山县', '3', '41036', 'G');
INSERT INTO `ey_region` VALUES ('41061', '兰坪县', '3', '41036', 'L');
INSERT INTO `ey_region` VALUES ('41070', '迪庆州', '2', '39556', 'D');
INSERT INTO `ey_region` VALUES ('41071', '香格里拉县', '3', '41070', 'X');
INSERT INTO `ey_region` VALUES ('41083', '德钦县', '3', '41070', 'D');
INSERT INTO `ey_region` VALUES ('41092', '维西县', '3', '41070', 'W');
INSERT INTO `ey_region` VALUES ('41103', '西藏自治区', '1', '0', 'X');
INSERT INTO `ey_region` VALUES ('41104', '拉萨市', '2', '41103', 'L');
INSERT INTO `ey_region` VALUES ('41105', '市辖区', '3', '41104', 'S');
INSERT INTO `ey_region` VALUES ('41106', '城关区', '3', '41104', 'C');
INSERT INTO `ey_region` VALUES ('41118', '林周县', '3', '41104', 'L');
INSERT INTO `ey_region` VALUES ('41129', '当雄县', '3', '41104', 'D');
INSERT INTO `ey_region` VALUES ('41138', '尼木县', '3', '41104', 'N');
INSERT INTO `ey_region` VALUES ('41147', '曲水县', '3', '41104', 'Q');
INSERT INTO `ey_region` VALUES ('41154', '堆龙德庆', '3', '41104', 'D');
INSERT INTO `ey_region` VALUES ('41162', '达孜县', '3', '41104', 'D');
INSERT INTO `ey_region` VALUES ('41169', '墨竹工卡县', '3', '41104', 'M');
INSERT INTO `ey_region` VALUES ('41178', '昌都地区', '2', '41103', 'C');
INSERT INTO `ey_region` VALUES ('41179', '昌都县', '3', '41178', 'C');
INSERT INTO `ey_region` VALUES ('41195', '江达县', '3', '41178', 'J');
INSERT INTO `ey_region` VALUES ('41209', '贡觉县', '3', '41178', 'G');
INSERT INTO `ey_region` VALUES ('41222', '类乌齐县', '3', '41178', 'L');
INSERT INTO `ey_region` VALUES ('41233', '丁青县', '3', '41178', 'D');
INSERT INTO `ey_region` VALUES ('41247', '察亚县', '3', '41178', 'C');
INSERT INTO `ey_region` VALUES ('41261', '八宿县', '3', '41178', 'B');
INSERT INTO `ey_region` VALUES ('41276', '左贡县', '3', '41178', 'Z');
INSERT INTO `ey_region` VALUES ('41287', '芒康县', '3', '41178', 'M');
INSERT INTO `ey_region` VALUES ('41304', '洛隆县', '3', '41178', 'L');
INSERT INTO `ey_region` VALUES ('41316', '边坝县', '3', '41178', 'B');
INSERT INTO `ey_region` VALUES ('41328', '山南地区', '2', '41103', 'S');
INSERT INTO `ey_region` VALUES ('41329', '乃东县', '3', '41328', 'N');
INSERT INTO `ey_region` VALUES ('41337', '扎囊县', '3', '41328', 'Z');
INSERT INTO `ey_region` VALUES ('41343', '贡嘎县', '3', '41328', 'G');
INSERT INTO `ey_region` VALUES ('41352', '桑日县', '3', '41328', 'S');
INSERT INTO `ey_region` VALUES ('41357', '琼结县', '3', '41328', 'Q');
INSERT INTO `ey_region` VALUES ('41362', '曲松县', '3', '41328', 'Q');
INSERT INTO `ey_region` VALUES ('41368', '措美县', '3', '41328', 'C');
INSERT INTO `ey_region` VALUES ('41373', '洛扎县', '3', '41328', 'L');
INSERT INTO `ey_region` VALUES ('41381', '加查县', '3', '41328', 'J');
INSERT INTO `ey_region` VALUES ('41389', '隆子县', '3', '41328', 'L');
INSERT INTO `ey_region` VALUES ('41401', '错那县', '3', '41328', 'C');
INSERT INTO `ey_region` VALUES ('41412', '浪卡子县', '3', '41328', 'L');
INSERT INTO `ey_region` VALUES ('41423', '日喀则地区', '2', '41103', 'R');
INSERT INTO `ey_region` VALUES ('41424', '日喀则市', '3', '41423', 'R');
INSERT INTO `ey_region` VALUES ('41437', '南木林县', '3', '41423', 'N');
INSERT INTO `ey_region` VALUES ('41455', '江孜县', '3', '41423', 'J');
INSERT INTO `ey_region` VALUES ('41475', '定日县', '3', '41423', 'D');
INSERT INTO `ey_region` VALUES ('41489', '萨迦县', '3', '41423', 'S');
INSERT INTO `ey_region` VALUES ('41501', '拉孜县', '3', '41423', 'L');
INSERT INTO `ey_region` VALUES ('41513', '昂仁县', '3', '41423', 'A');
INSERT INTO `ey_region` VALUES ('41531', '谢通门县', '3', '41423', 'X');
INSERT INTO `ey_region` VALUES ('41551', '白朗县', '3', '41423', 'B');
INSERT INTO `ey_region` VALUES ('41563', '仁布县', '3', '41423', 'R');
INSERT INTO `ey_region` VALUES ('41573', '康马县', '3', '41423', 'K');
INSERT INTO `ey_region` VALUES ('41583', '定结县', '3', '41423', 'D');
INSERT INTO `ey_region` VALUES ('41594', '仲巴县', '3', '41423', 'Z');
INSERT INTO `ey_region` VALUES ('41608', '亚东县', '3', '41423', 'Y');
INSERT INTO `ey_region` VALUES ('41616', '吉隆县', '3', '41423', 'J');
INSERT INTO `ey_region` VALUES ('41622', '聂拉木县', '3', '41423', 'N');
INSERT INTO `ey_region` VALUES ('41630', '萨嘎县', '3', '41423', 'S');
INSERT INTO `ey_region` VALUES ('41639', '岗巴县', '3', '41423', 'G');
INSERT INTO `ey_region` VALUES ('41645', '那曲地区', '2', '41103', 'N');
INSERT INTO `ey_region` VALUES ('41646', '那曲县', '3', '41645', 'N');
INSERT INTO `ey_region` VALUES ('41659', '嘉黎县', '3', '41645', 'J');
INSERT INTO `ey_region` VALUES ('41670', '比如县', '3', '41645', 'B');
INSERT INTO `ey_region` VALUES ('41681', '聂荣县', '3', '41645', 'N');
INSERT INTO `ey_region` VALUES ('41692', '安多县', '3', '41645', 'A');
INSERT INTO `ey_region` VALUES ('41706', '申扎县', '3', '41645', 'S');
INSERT INTO `ey_region` VALUES ('41715', '索县', '3', '41645', 'S');
INSERT INTO `ey_region` VALUES ('41726', '班戈县', '3', '41645', 'B');
INSERT INTO `ey_region` VALUES ('41737', '巴青县', '3', '41645', 'B');
INSERT INTO `ey_region` VALUES ('41748', '尼玛县', '3', '41645', 'N');
INSERT INTO `ey_region` VALUES ('41770', '阿里地区', '2', '41103', 'A');
INSERT INTO `ey_region` VALUES ('41771', '普兰县', '3', '41770', 'P');
INSERT INTO `ey_region` VALUES ('41775', '札达县', '3', '41770', 'Z');
INSERT INTO `ey_region` VALUES ('41782', '噶尔县', '3', '41770', 'G');
INSERT INTO `ey_region` VALUES ('41788', '日土县', '3', '41770', 'R');
INSERT INTO `ey_region` VALUES ('41794', '革吉县', '3', '41770', 'G');
INSERT INTO `ey_region` VALUES ('41800', '改则县', '3', '41770', 'G');
INSERT INTO `ey_region` VALUES ('41808', '措勤县', '3', '41770', 'C');
INSERT INTO `ey_region` VALUES ('41814', '林芝地区', '2', '41103', 'L');
INSERT INTO `ey_region` VALUES ('41815', '林芝县', '3', '41814', 'L');
INSERT INTO `ey_region` VALUES ('41823', '工布江达县', '3', '41814', 'G');
INSERT INTO `ey_region` VALUES ('41833', '米林县', '3', '41814', 'M');
INSERT INTO `ey_region` VALUES ('41842', '墨脱县', '3', '41814', 'M');
INSERT INTO `ey_region` VALUES ('41851', '波密县', '3', '41814', 'B');
INSERT INTO `ey_region` VALUES ('41863', '察隅县', '3', '41814', 'C');
INSERT INTO `ey_region` VALUES ('41870', '朗县', '3', '41814', 'L');
INSERT INTO `ey_region` VALUES ('41877', '陕西省', '1', '0', 'S');
INSERT INTO `ey_region` VALUES ('41878', '西安市', '2', '41877', 'X');
INSERT INTO `ey_region` VALUES ('41879', '市辖区', '3', '41878', 'S');
INSERT INTO `ey_region` VALUES ('41880', '新城区', '3', '41878', 'X');
INSERT INTO `ey_region` VALUES ('41890', '碑林区', '3', '41878', 'B');
INSERT INTO `ey_region` VALUES ('41899', '莲湖区', '3', '41878', 'L');
INSERT INTO `ey_region` VALUES ('41909', '灞桥区', '3', '41878', 'B');
INSERT INTO `ey_region` VALUES ('41919', '未央区', '3', '41878', 'W');
INSERT INTO `ey_region` VALUES ('41930', '雁塔区', '3', '41878', 'Y');
INSERT INTO `ey_region` VALUES ('41939', '阎良区', '3', '41878', 'Y');
INSERT INTO `ey_region` VALUES ('41947', '临潼区', '3', '41878', 'L');
INSERT INTO `ey_region` VALUES ('41971', '长安区', '3', '41878', 'C');
INSERT INTO `ey_region` VALUES ('41997', '蓝田县', '3', '41878', 'L');
INSERT INTO `ey_region` VALUES ('42020', '周至县', '3', '41878', 'Z');
INSERT INTO `ey_region` VALUES ('42043', '户县', '3', '41878', 'H');
INSERT INTO `ey_region` VALUES ('42060', '高陵县', '3', '41878', 'G');
INSERT INTO `ey_region` VALUES ('42069', '铜川市', '2', '41877', 'T');
INSERT INTO `ey_region` VALUES ('42070', '市辖区', '3', '42069', 'S');
INSERT INTO `ey_region` VALUES ('42071', '王益区', '3', '42069', 'W');
INSERT INTO `ey_region` VALUES ('42079', '印台区', '3', '42069', 'Y');
INSERT INTO `ey_region` VALUES ('42091', '耀州区', '3', '42069', 'Y');
INSERT INTO `ey_region` VALUES ('42108', '宜君县', '3', '42069', 'Y');
INSERT INTO `ey_region` VALUES ('42119', '宝鸡市', '2', '41877', 'B');
INSERT INTO `ey_region` VALUES ('42120', '市辖区', '3', '42119', 'S');
INSERT INTO `ey_region` VALUES ('42121', '渭滨区', '3', '42119', 'W');
INSERT INTO `ey_region` VALUES ('42133', '金台区', '3', '42119', 'J');
INSERT INTO `ey_region` VALUES ('42146', '陈仓区', '3', '42119', 'C');
INSERT INTO `ey_region` VALUES ('42165', '凤翔县', '3', '42119', 'F');
INSERT INTO `ey_region` VALUES ('42183', '岐山县', '3', '42119', 'Q');
INSERT INTO `ey_region` VALUES ('42198', '扶风县', '3', '42119', 'F');
INSERT INTO `ey_region` VALUES ('42211', '眉县', '3', '42119', 'M');
INSERT INTO `ey_region` VALUES ('42224', '陇县', '3', '42119', 'L');
INSERT INTO `ey_region` VALUES ('42240', '千阳县', '3', '42119', 'Q');
INSERT INTO `ey_region` VALUES ('42252', '麟游县', '3', '42119', 'L');
INSERT INTO `ey_region` VALUES ('42263', '凤县', '3', '42119', 'F');
INSERT INTO `ey_region` VALUES ('42278', '太白县', '3', '42119', 'T');
INSERT INTO `ey_region` VALUES ('42287', '咸阳市', '2', '41877', 'X');
INSERT INTO `ey_region` VALUES ('42288', '市辖区', '3', '42287', 'S');
INSERT INTO `ey_region` VALUES ('42289', '秦都区', '3', '42287', 'Q');
INSERT INTO `ey_region` VALUES ('42302', '杨凌区', '3', '42287', 'Y');
INSERT INTO `ey_region` VALUES ('42308', '渭城区', '3', '42287', 'W');
INSERT INTO `ey_region` VALUES ('42319', '三原县', '3', '42287', 'S');
INSERT INTO `ey_region` VALUES ('42334', '泾阳县', '3', '42287', 'J');
INSERT INTO `ey_region` VALUES ('42351', '乾县', '3', '42287', 'Q');
INSERT INTO `ey_region` VALUES ('42372', '礼泉县', '3', '42287', 'L');
INSERT INTO `ey_region` VALUES ('42388', '永寿县', '3', '42287', 'Y');
INSERT INTO `ey_region` VALUES ('42402', '彬县', '3', '42287', 'B');
INSERT INTO `ey_region` VALUES ('42419', '长武县', '3', '42287', 'C');
INSERT INTO `ey_region` VALUES ('42431', '旬邑县', '3', '42287', 'X');
INSERT INTO `ey_region` VALUES ('42446', '淳化县', '3', '42287', 'C');
INSERT INTO `ey_region` VALUES ('42462', '武功县', '3', '42287', 'W');
INSERT INTO `ey_region` VALUES ('42475', '兴平市', '3', '42287', 'X');
INSERT INTO `ey_region` VALUES ('42490', '渭南市', '2', '41877', 'W');
INSERT INTO `ey_region` VALUES ('42491', '市辖区', '3', '42490', 'S');
INSERT INTO `ey_region` VALUES ('42492', '临渭区', '3', '42490', 'L');
INSERT INTO `ey_region` VALUES ('42523', '华县', '3', '42490', 'H');
INSERT INTO `ey_region` VALUES ('42538', '潼关县', '3', '42490', 'T');
INSERT INTO `ey_region` VALUES ('42547', '大荔县', '3', '42490', 'D');
INSERT INTO `ey_region` VALUES ('42577', '合阳县', '3', '42490', 'H');
INSERT INTO `ey_region` VALUES ('42594', '澄城县', '3', '42490', 'C');
INSERT INTO `ey_region` VALUES ('42609', '蒲城县', '3', '42490', 'P');
INSERT INTO `ey_region` VALUES ('42634', '白水县', '3', '42490', 'B');
INSERT INTO `ey_region` VALUES ('42649', '富平县', '3', '42490', 'F');
INSERT INTO `ey_region` VALUES ('42674', '韩城市', '3', '42490', 'H');
INSERT INTO `ey_region` VALUES ('42691', '华阴市', '3', '42490', 'H');
INSERT INTO `ey_region` VALUES ('42703', '延安市', '2', '41877', 'Y');
INSERT INTO `ey_region` VALUES ('42704', '市辖区', '3', '42703', 'S');
INSERT INTO `ey_region` VALUES ('42705', '宝塔区', '3', '42703', 'B');
INSERT INTO `ey_region` VALUES ('42729', '延长县', '3', '42703', 'Y');
INSERT INTO `ey_region` VALUES ('42742', '延川县', '3', '42703', 'Y');
INSERT INTO `ey_region` VALUES ('42757', '子长县', '3', '42703', 'Z');
INSERT INTO `ey_region` VALUES ('42771', '安塞县', '3', '42703', 'A');
INSERT INTO `ey_region` VALUES ('42784', '志丹县', '3', '42703', 'Z');
INSERT INTO `ey_region` VALUES ('42796', '吴起县', '3', '42703', 'W');
INSERT INTO `ey_region` VALUES ('42809', '甘泉县', '3', '42703', 'G');
INSERT INTO `ey_region` VALUES ('42818', '富县', '3', '42703', 'F');
INSERT INTO `ey_region` VALUES ('42833', '洛川县', '3', '42703', 'L');
INSERT INTO `ey_region` VALUES ('42850', '宜川县', '3', '42703', 'Y');
INSERT INTO `ey_region` VALUES ('42863', '黄龙县', '3', '42703', 'H');
INSERT INTO `ey_region` VALUES ('42874', '黄陵县', '3', '42703', 'H');
INSERT INTO `ey_region` VALUES ('42888', '汉中市', '2', '41877', 'H');
INSERT INTO `ey_region` VALUES ('42889', '市辖区', '3', '42888', 'S');
INSERT INTO `ey_region` VALUES ('42890', '汉台区', '3', '42888', 'H');
INSERT INTO `ey_region` VALUES ('42908', '南郑县', '3', '42888', 'N');
INSERT INTO `ey_region` VALUES ('42939', '城固县', '3', '42888', 'C');
INSERT INTO `ey_region` VALUES ('42965', '洋县', '3', '42888', 'Y');
INSERT INTO `ey_region` VALUES ('42992', '西乡县', '3', '42888', 'X');
INSERT INTO `ey_region` VALUES ('43016', '勉县', '3', '42888', 'M');
INSERT INTO `ey_region` VALUES ('43042', '宁强县', '3', '42888', 'N');
INSERT INTO `ey_region` VALUES ('43069', '略阳县', '3', '42888', 'L');
INSERT INTO `ey_region` VALUES ('43091', '镇巴县', '3', '42888', 'Z');
INSERT INTO `ey_region` VALUES ('43116', '留坝县', '3', '42888', 'L');
INSERT INTO `ey_region` VALUES ('43126', '佛坪县', '3', '42888', 'F');
INSERT INTO `ey_region` VALUES ('43136', '榆林市', '2', '41877', 'Y');
INSERT INTO `ey_region` VALUES ('43137', '市辖区', '3', '43136', 'S');
INSERT INTO `ey_region` VALUES ('43138', '榆阳区', '3', '43136', 'Y');
INSERT INTO `ey_region` VALUES ('43170', '神木县', '3', '43136', 'S');
INSERT INTO `ey_region` VALUES ('43190', '府谷县', '3', '43136', 'F');
INSERT INTO `ey_region` VALUES ('43211', '横山县', '3', '43136', 'H');
INSERT INTO `ey_region` VALUES ('43230', '靖边县', '3', '43136', 'J');
INSERT INTO `ey_region` VALUES ('43253', '定边县', '3', '43136', 'D');
INSERT INTO `ey_region` VALUES ('43279', '绥德县', '3', '43136', 'S');
INSERT INTO `ey_region` VALUES ('43300', '米脂县', '3', '43136', 'M');
INSERT INTO `ey_region` VALUES ('43314', '佳县', '3', '43136', 'J');
INSERT INTO `ey_region` VALUES ('43335', '吴堡县', '3', '43136', 'W');
INSERT INTO `ey_region` VALUES ('43344', '清涧县', '3', '43136', 'Q');
INSERT INTO `ey_region` VALUES ('43360', '子洲县', '3', '43136', 'Z');
INSERT INTO `ey_region` VALUES ('43379', '安康市', '2', '41877', 'A');
INSERT INTO `ey_region` VALUES ('43380', '市辖区', '3', '43379', 'S');
INSERT INTO `ey_region` VALUES ('43381', '汉滨区', '3', '43379', 'H');
INSERT INTO `ey_region` VALUES ('43428', '汉阴县', '3', '43379', 'H');
INSERT INTO `ey_region` VALUES ('43447', '石泉县', '3', '43379', 'S');
INSERT INTO `ey_region` VALUES ('43463', '宁陕县', '3', '43379', 'N');
INSERT INTO `ey_region` VALUES ('43478', '紫阳县', '3', '43379', 'Z');
INSERT INTO `ey_region` VALUES ('43504', '岚皋县', '3', '43379', 'L');
INSERT INTO `ey_region` VALUES ('43522', '平利县', '3', '43379', 'P');
INSERT INTO `ey_region` VALUES ('43535', '镇坪县', '3', '43379', 'Z');
INSERT INTO `ey_region` VALUES ('43546', '旬阳县', '3', '43379', 'X');
INSERT INTO `ey_region` VALUES ('43575', '白河县', '3', '43379', 'B');
INSERT INTO `ey_region` VALUES ('43592', '商洛市', '2', '41877', 'S');
INSERT INTO `ey_region` VALUES ('43593', '市辖区', '3', '43592', 'S');
INSERT INTO `ey_region` VALUES ('43594', '商州区', '3', '43592', 'S');
INSERT INTO `ey_region` VALUES ('43628', '洛南县', '3', '43592', 'L');
INSERT INTO `ey_region` VALUES ('43654', '丹凤县', '3', '43592', 'D');
INSERT INTO `ey_region` VALUES ('43676', '商南县', '3', '43592', 'S');
INSERT INTO `ey_region` VALUES ('43699', '山阳县', '3', '43592', 'S');
INSERT INTO `ey_region` VALUES ('43730', '镇安县', '3', '43592', 'Z');
INSERT INTO `ey_region` VALUES ('43759', '柞水县', '3', '43592', 'Z');
INSERT INTO `ey_region` VALUES ('43776', '甘肃省', '1', '0', 'G');
INSERT INTO `ey_region` VALUES ('43777', '兰州市', '2', '43776', 'L');
INSERT INTO `ey_region` VALUES ('43778', '市辖区', '3', '43777', 'S');
INSERT INTO `ey_region` VALUES ('43779', '城关区', '3', '43777', 'C');
INSERT INTO `ey_region` VALUES ('43804', '七里河区', '3', '43777', 'Q');
INSERT INTO `ey_region` VALUES ('43820', '兰州市西固区', '3', '43777', 'L');
INSERT INTO `ey_region` VALUES ('43836', '安宁区', '3', '43777', 'A');
INSERT INTO `ey_region` VALUES ('43845', '红古区', '3', '43777', 'H');
INSERT INTO `ey_region` VALUES ('43853', '永登县', '3', '43777', 'Y');
INSERT INTO `ey_region` VALUES ('43872', '皋兰县', '3', '43777', 'G');
INSERT INTO `ey_region` VALUES ('43880', '榆中县', '3', '43777', 'Y');
INSERT INTO `ey_region` VALUES ('43904', '嘉峪关市', '2', '43776', 'J');
INSERT INTO `ey_region` VALUES ('43905', '市辖', '3', '43904', 'S');
INSERT INTO `ey_region` VALUES ('43914', '金昌市', '2', '43776', 'J');
INSERT INTO `ey_region` VALUES ('43915', '市辖区', '3', '43914', 'S');
INSERT INTO `ey_region` VALUES ('43916', '金川区', '3', '43914', 'J');
INSERT INTO `ey_region` VALUES ('43925', '永昌县', '3', '43914', 'Y');
INSERT INTO `ey_region` VALUES ('43936', '白银市', '2', '43776', 'B');
INSERT INTO `ey_region` VALUES ('43937', '市辖区', '3', '43936', 'S');
INSERT INTO `ey_region` VALUES ('43938', '白银区', '3', '43936', 'B');
INSERT INTO `ey_region` VALUES ('43949', '平川区', '3', '43936', 'P');
INSERT INTO `ey_region` VALUES ('43961', '靖远县', '3', '43936', 'J');
INSERT INTO `ey_region` VALUES ('43980', '会宁县', '3', '43936', 'H');
INSERT INTO `ey_region` VALUES ('44009', '景泰县', '3', '43936', 'J');
INSERT INTO `ey_region` VALUES ('44022', '天水市', '2', '43776', 'T');
INSERT INTO `ey_region` VALUES ('44023', '市辖区', '3', '44022', 'S');
INSERT INTO `ey_region` VALUES ('44024', '秦州区', '3', '44022', 'Q');
INSERT INTO `ey_region` VALUES ('44048', '麦积区', '3', '44022', 'M');
INSERT INTO `ey_region` VALUES ('44069', '清水县', '3', '44022', 'Q');
INSERT INTO `ey_region` VALUES ('44088', '秦安县', '3', '44022', 'Q');
INSERT INTO `ey_region` VALUES ('44106', '甘谷县', '3', '44022', 'G');
INSERT INTO `ey_region` VALUES ('44122', '武山县', '3', '44022', 'W');
INSERT INTO `ey_region` VALUES ('44138', '张家川县', '3', '44022', 'Z');
INSERT INTO `ey_region` VALUES ('44154', '武威市', '2', '43776', 'W');
INSERT INTO `ey_region` VALUES ('44155', '市辖区', '3', '44154', 'S');
INSERT INTO `ey_region` VALUES ('44156', '凉州区', '3', '44154', 'L');
INSERT INTO `ey_region` VALUES ('44202', '民勤县', '3', '44154', 'M');
INSERT INTO `ey_region` VALUES ('44221', '古浪县', '3', '44154', 'G');
INSERT INTO `ey_region` VALUES ('44242', '天祝县', '3', '44154', 'T');
INSERT INTO `ey_region` VALUES ('44265', '张掖市', '2', '43776', 'Z');
INSERT INTO `ey_region` VALUES ('44266', '市辖区', '3', '44265', 'S');
INSERT INTO `ey_region` VALUES ('44267', '甘州区', '3', '44265', 'G');
INSERT INTO `ey_region` VALUES ('44294', '肃南县', '3', '44265', 'S');
INSERT INTO `ey_region` VALUES ('44305', '民乐县', '3', '44265', 'M');
INSERT INTO `ey_region` VALUES ('44317', '临泽县', '3', '44265', 'L');
INSERT INTO `ey_region` VALUES ('44331', '高台县', '3', '44265', 'G');
INSERT INTO `ey_region` VALUES ('44341', '山丹县', '3', '44265', 'S');
INSERT INTO `ey_region` VALUES ('44352', '平凉市', '2', '43776', 'P');
INSERT INTO `ey_region` VALUES ('44353', '市辖区', '3', '44352', 'S');
INSERT INTO `ey_region` VALUES ('44354', '崆峒区', '3', '44352', 'K');
INSERT INTO `ey_region` VALUES ('44375', '泾川县', '3', '44352', 'J');
INSERT INTO `ey_region` VALUES ('44392', '灵台县', '3', '44352', 'L');
INSERT INTO `ey_region` VALUES ('44408', '崇信县', '3', '44352', 'C');
INSERT INTO `ey_region` VALUES ('44418', '华亭县', '3', '44352', 'H');
INSERT INTO `ey_region` VALUES ('44431', '庄浪县', '3', '44352', 'Z');
INSERT INTO `ey_region` VALUES ('44451', '静宁县', '3', '44352', 'J');
INSERT INTO `ey_region` VALUES ('44477', '酒泉市', '2', '43776', 'J');
INSERT INTO `ey_region` VALUES ('44478', '市辖区', '3', '44477', 'S');
INSERT INTO `ey_region` VALUES ('44479', '肃州区', '3', '44477', 'S');
INSERT INTO `ey_region` VALUES ('44504', '金塔县', '3', '44477', 'J');
INSERT INTO `ey_region` VALUES ('44516', '瓜州县', '3', '44477', 'G');
INSERT INTO `ey_region` VALUES ('44531', '肃北县', '3', '44477', 'S');
INSERT INTO `ey_region` VALUES ('44535', '阿克塞县', '3', '44477', 'A');
INSERT INTO `ey_region` VALUES ('44539', '玉门市', '3', '44477', 'Y');
INSERT INTO `ey_region` VALUES ('44557', '敦煌市', '3', '44477', 'D');
INSERT INTO `ey_region` VALUES ('44569', '庆阳市', '2', '43776', 'Q');
INSERT INTO `ey_region` VALUES ('44570', '市辖区', '3', '44569', 'S');
INSERT INTO `ey_region` VALUES ('44571', '西峰区', '3', '44569', 'X');
INSERT INTO `ey_region` VALUES ('44582', '庆城县', '3', '44569', 'Q');
INSERT INTO `ey_region` VALUES ('44598', '环县', '3', '44569', 'H');
INSERT INTO `ey_region` VALUES ('44620', '华池县', '3', '44569', 'H');
INSERT INTO `ey_region` VALUES ('44636', '合水县', '3', '44569', 'H');
INSERT INTO `ey_region` VALUES ('44649', '正宁县', '3', '44569', 'Z');
INSERT INTO `ey_region` VALUES ('44660', '宁县', '3', '44569', 'N');
INSERT INTO `ey_region` VALUES ('44679', '镇原县', '3', '44569', 'Z');
INSERT INTO `ey_region` VALUES ('44699', '定西市', '2', '43776', 'D');
INSERT INTO `ey_region` VALUES ('44700', '市辖区', '3', '44699', 'S');
INSERT INTO `ey_region` VALUES ('44701', '安定区', '3', '44699', 'A');
INSERT INTO `ey_region` VALUES ('44723', '通渭县', '3', '44699', 'T');
INSERT INTO `ey_region` VALUES ('44742', '陇西县', '3', '44699', 'L');
INSERT INTO `ey_region` VALUES ('44760', '渭源县', '3', '44699', 'W');
INSERT INTO `ey_region` VALUES ('44777', '临洮县', '3', '44699', 'L');
INSERT INTO `ey_region` VALUES ('44796', '漳县', '3', '44699', 'Z');
INSERT INTO `ey_region` VALUES ('44810', '岷县', '3', '44699', 'M');
INSERT INTO `ey_region` VALUES ('44829', '陇南市', '2', '43776', 'L');
INSERT INTO `ey_region` VALUES ('44830', '市辖区', '3', '44829', 'S');
INSERT INTO `ey_region` VALUES ('44831', '武都区', '3', '44829', 'W');
INSERT INTO `ey_region` VALUES ('44868', '成县', '3', '44829', 'C');
INSERT INTO `ey_region` VALUES ('44886', '文县', '3', '44829', 'W');
INSERT INTO `ey_region` VALUES ('44907', '宕昌县', '3', '44829', 'D');
INSERT INTO `ey_region` VALUES ('44933', '康县', '3', '44829', 'K');
INSERT INTO `ey_region` VALUES ('44955', '西和县', '3', '44829', 'X');
INSERT INTO `ey_region` VALUES ('44976', '礼县', '3', '44829', 'L');
INSERT INTO `ey_region` VALUES ('45006', '徽县', '3', '44829', 'H');
INSERT INTO `ey_region` VALUES ('45022', '两当县', '3', '44829', 'L');
INSERT INTO `ey_region` VALUES ('45035', '临夏州', '2', '43776', 'L');
INSERT INTO `ey_region` VALUES ('45036', '临夏市', '3', '45035', 'L');
INSERT INTO `ey_region` VALUES ('45047', '临夏县', '3', '45035', 'L');
INSERT INTO `ey_region` VALUES ('45073', '康乐县', '3', '45035', 'K');
INSERT INTO `ey_region` VALUES ('45089', '永靖县', '3', '45035', 'Y');
INSERT INTO `ey_region` VALUES ('45107', '广河县', '3', '45035', 'G');
INSERT INTO `ey_region` VALUES ('45117', '和政县', '3', '45035', 'H');
INSERT INTO `ey_region` VALUES ('45131', '东乡县', '3', '45035', 'D');
INSERT INTO `ey_region` VALUES ('45156', '积石山县', '3', '45035', 'J');
INSERT INTO `ey_region` VALUES ('45174', '甘南州', '2', '43776', 'G');
INSERT INTO `ey_region` VALUES ('45175', '合作市', '3', '45174', 'H');
INSERT INTO `ey_region` VALUES ('45186', '临潭县', '3', '45174', 'L');
INSERT INTO `ey_region` VALUES ('45203', '卓尼县', '3', '45174', 'Z');
INSERT INTO `ey_region` VALUES ('45219', '舟曲县', '3', '45174', 'Z');
INSERT INTO `ey_region` VALUES ('45239', '迭部县', '3', '45174', 'D');
INSERT INTO `ey_region` VALUES ('45251', '玛曲县', '3', '45174', 'M');
INSERT INTO `ey_region` VALUES ('45263', '碌曲县', '3', '45174', 'L');
INSERT INTO `ey_region` VALUES ('45272', '夏河县', '3', '45174', 'X');
INSERT INTO `ey_region` VALUES ('45286', '青海省', '1', '0', 'Q');
INSERT INTO `ey_region` VALUES ('45287', '西宁市', '2', '45286', 'X');
INSERT INTO `ey_region` VALUES ('45288', '市辖区', '3', '45287', 'S');
INSERT INTO `ey_region` VALUES ('45289', '城东区', '3', '45287', 'C');
INSERT INTO `ey_region` VALUES ('45299', '城中区', '3', '45287', 'C');
INSERT INTO `ey_region` VALUES ('45306', '城西区', '3', '45287', 'C');
INSERT INTO `ey_region` VALUES ('45314', '城北区', '3', '45287', 'C');
INSERT INTO `ey_region` VALUES ('45320', '大通县', '3', '45287', 'D');
INSERT INTO `ey_region` VALUES ('45341', '湟中县', '3', '45287', 'H');
INSERT INTO `ey_region` VALUES ('45358', '湟源县', '3', '45287', 'H');
INSERT INTO `ey_region` VALUES ('45368', '海东地区', '2', '45286', 'H');
INSERT INTO `ey_region` VALUES ('45369', '平安县', '3', '45368', 'P');
INSERT INTO `ey_region` VALUES ('45378', '民和县', '3', '45368', 'M');
INSERT INTO `ey_region` VALUES ('45401', '乐都县', '3', '45368', 'L');
INSERT INTO `ey_region` VALUES ('45421', '互助县', '3', '45368', 'H');
INSERT INTO `ey_region` VALUES ('45441', '化隆县', '3', '45368', 'H');
INSERT INTO `ey_region` VALUES ('45461', '循化县', '3', '45368', 'X');
INSERT INTO `ey_region` VALUES ('45471', '海北州', '2', '45286', 'H');
INSERT INTO `ey_region` VALUES ('45472', '门源县', '3', '45471', 'M');
INSERT INTO `ey_region` VALUES ('45487', '祁连县', '3', '45471', 'Q');
INSERT INTO `ey_region` VALUES ('45495', '海晏县', '3', '45471', 'H');
INSERT INTO `ey_region` VALUES ('45502', '刚察县', '3', '45471', 'G');
INSERT INTO `ey_region` VALUES ('45510', '黄南州', '2', '45286', 'H');
INSERT INTO `ey_region` VALUES ('45511', '同仁县', '3', '45510', 'T');
INSERT INTO `ey_region` VALUES ('45523', '尖扎县', '3', '45510', 'J');
INSERT INTO `ey_region` VALUES ('45533', '泽库县', '3', '45510', 'Z');
INSERT INTO `ey_region` VALUES ('45542', '河南县', '3', '45510', 'H');
INSERT INTO `ey_region` VALUES ('45548', '海南州', '2', '45286', 'H');
INSERT INTO `ey_region` VALUES ('45549', '共和县', '3', '45548', 'G');
INSERT INTO `ey_region` VALUES ('45566', '同德县', '3', '45548', 'T');
INSERT INTO `ey_region` VALUES ('45573', '贵德县', '3', '45548', 'G');
INSERT INTO `ey_region` VALUES ('45581', '兴海县', '3', '45548', 'X');
INSERT INTO `ey_region` VALUES ('45589', '贵南县', '3', '45548', 'G');
INSERT INTO `ey_region` VALUES ('45597', '果洛州', '2', '45286', 'G');
INSERT INTO `ey_region` VALUES ('45598', '玛沁县', '3', '45597', 'M');
INSERT INTO `ey_region` VALUES ('45607', '班玛县', '3', '45597', 'B');
INSERT INTO `ey_region` VALUES ('45617', '甘德县', '3', '45597', 'G');
INSERT INTO `ey_region` VALUES ('45625', '达日县', '3', '45597', 'D');
INSERT INTO `ey_region` VALUES ('45636', '久治县', '3', '45597', 'J');
INSERT INTO `ey_region` VALUES ('45643', '玛多县', '3', '45597', 'M');
INSERT INTO `ey_region` VALUES ('45648', '玉树州', '2', '45286', 'Y');
INSERT INTO `ey_region` VALUES ('45649', '玉树县', '3', '45648', 'Y');
INSERT INTO `ey_region` VALUES ('45659', '杂多县', '3', '45648', 'Z');
INSERT INTO `ey_region` VALUES ('45668', '称多县', '3', '45648', 'C');
INSERT INTO `ey_region` VALUES ('45676', '治多县', '3', '45648', 'Z');
INSERT INTO `ey_region` VALUES ('45683', '囊谦县', '3', '45648', 'N');
INSERT INTO `ey_region` VALUES ('45694', '曲麻莱县', '3', '45648', 'Q');
INSERT INTO `ey_region` VALUES ('45701', '海西州', '2', '45286', 'H');
INSERT INTO `ey_region` VALUES ('45702', '格尔木市', '3', '45701', 'G');
INSERT INTO `ey_region` VALUES ('45714', '德令哈市', '3', '45701', 'D');
INSERT INTO `ey_region` VALUES ('45727', '乌兰县', '3', '45701', 'W');
INSERT INTO `ey_region` VALUES ('45733', '都兰县', '3', '45701', 'D');
INSERT INTO `ey_region` VALUES ('45742', '天峻县', '3', '45701', 'T');
INSERT INTO `ey_region` VALUES ('45753', '宁夏回族自治区', '1', '0', 'N');
INSERT INTO `ey_region` VALUES ('45754', '银川市', '2', '45753', 'Y');
INSERT INTO `ey_region` VALUES ('45755', '市辖区', '3', '45754', 'S');
INSERT INTO `ey_region` VALUES ('45756', '兴庆区', '3', '45754', 'X');
INSERT INTO `ey_region` VALUES ('45772', '西夏区', '3', '45754', 'X');
INSERT INTO `ey_region` VALUES ('45784', '金凤区', '3', '45754', 'J');
INSERT INTO `ey_region` VALUES ('45794', '永宁县', '3', '45754', 'Y');
INSERT INTO `ey_region` VALUES ('45803', '贺兰县', '3', '45754', 'H');
INSERT INTO `ey_region` VALUES ('45813', '灵武市', '3', '45754', 'L');
INSERT INTO `ey_region` VALUES ('45825', '石嘴山市', '2', '45753', 'S');
INSERT INTO `ey_region` VALUES ('45826', '市辖区', '3', '45825', 'S');
INSERT INTO `ey_region` VALUES ('45827', '大武口区', '3', '45825', 'D');
INSERT INTO `ey_region` VALUES ('45839', '惠农区', '3', '45825', 'H');
INSERT INTO `ey_region` VALUES ('45856', '平罗县', '3', '45825', 'P');
INSERT INTO `ey_region` VALUES ('45871', '吴忠市', '2', '45753', 'W');
INSERT INTO `ey_region` VALUES ('45872', '市辖区', '3', '45871', 'S');
INSERT INTO `ey_region` VALUES ('45877', '利通区', '3', '45871', 'L');
INSERT INTO `ey_region` VALUES ('45892', '盐池县', '3', '45871', 'Y');
INSERT INTO `ey_region` VALUES ('45903', '同心县', '3', '45871', 'T');
INSERT INTO `ey_region` VALUES ('45914', '青铜峡市', '3', '45871', 'Q');
INSERT INTO `ey_region` VALUES ('45926', '固原市', '2', '45753', 'G');
INSERT INTO `ey_region` VALUES ('45927', '市辖区', '3', '45926', 'S');
INSERT INTO `ey_region` VALUES ('45928', '原州区', '3', '45926', 'Y');
INSERT INTO `ey_region` VALUES ('45944', '西吉县', '3', '45926', 'X');
INSERT INTO `ey_region` VALUES ('45964', '隆德县', '3', '45926', 'L');
INSERT INTO `ey_region` VALUES ('45978', '泾源县', '3', '45926', 'J');
INSERT INTO `ey_region` VALUES ('45986', '彭阳县', '3', '45926', 'P');
INSERT INTO `ey_region` VALUES ('45999', '中卫市', '2', '45753', 'Z');
INSERT INTO `ey_region` VALUES ('46000', '市辖区', '3', '45999', 'S');
INSERT INTO `ey_region` VALUES ('46012', '沙坡头区', '3', '45999', 'S');
INSERT INTO `ey_region` VALUES ('46013', '中宁县', '3', '45999', 'Z');
INSERT INTO `ey_region` VALUES ('46026', '海原县', '3', '45999', 'H');
INSERT INTO `ey_region` VALUES ('46047', '新疆维吾尔自治区', '1', '0', 'X');
INSERT INTO `ey_region` VALUES ('46048', '乌鲁木齐市', '2', '46047', 'W');
INSERT INTO `ey_region` VALUES ('46049', '市辖区', '3', '46048', 'S');
INSERT INTO `ey_region` VALUES ('46050', '天山区', '3', '46048', 'T');
INSERT INTO `ey_region` VALUES ('46065', '沙依巴克区', '3', '46048', 'S');
INSERT INTO `ey_region` VALUES ('46079', '新市区', '3', '46048', 'X');
INSERT INTO `ey_region` VALUES ('46095', '水磨沟区', '3', '46048', 'S');
INSERT INTO `ey_region` VALUES ('46104', '头屯河区', '3', '46048', 'T');
INSERT INTO `ey_region` VALUES ('46114', '达坂城区', '3', '46048', 'D');
INSERT INTO `ey_region` VALUES ('46123', '东山区', '3', '46048', 'D');
INSERT INTO `ey_region` VALUES ('46128', '乌鲁木齐县', '3', '46048', 'W');
INSERT INTO `ey_region` VALUES ('46138', '克拉玛依市', '2', '46047', 'K');
INSERT INTO `ey_region` VALUES ('46139', '市辖区', '3', '46138', 'S');
INSERT INTO `ey_region` VALUES ('46140', '独山子区', '3', '46138', 'D');
INSERT INTO `ey_region` VALUES ('46144', '克拉玛依区', '3', '46138', 'K');
INSERT INTO `ey_region` VALUES ('46155', '白碱滩区', '3', '46138', 'B');
INSERT INTO `ey_region` VALUES ('46158', '乌尔禾区', '3', '46138', 'W');
INSERT INTO `ey_region` VALUES ('46162', '吐鲁番地区', '2', '46047', 'T');
INSERT INTO `ey_region` VALUES ('46163', '吐鲁番市', '3', '46162', 'T');
INSERT INTO `ey_region` VALUES ('46178', '鄯善县', '3', '46162', 'S');
INSERT INTO `ey_region` VALUES ('46189', '托克逊县', '3', '46162', 'T');
INSERT INTO `ey_region` VALUES ('46197', '哈密地区', '2', '46047', 'H');
INSERT INTO `ey_region` VALUES ('46198', '哈密市', '3', '46197', 'H');
INSERT INTO `ey_region` VALUES ('46230', '巴里坤县', '3', '46197', 'B');
INSERT INTO `ey_region` VALUES ('46246', '伊吾县', '3', '46197', 'Y');
INSERT INTO `ey_region` VALUES ('46255', '昌吉州', '2', '46047', 'C');
INSERT INTO `ey_region` VALUES ('46256', '昌吉市', '3', '46255', 'C');
INSERT INTO `ey_region` VALUES ('46275', '阜康市', '3', '46255', 'F');
INSERT INTO `ey_region` VALUES ('46289', '米泉市', '3', '46255', 'M');
INSERT INTO `ey_region` VALUES ('46299', '呼图壁县', '3', '46255', 'H');
INSERT INTO `ey_region` VALUES ('46316', '玛纳斯', '3', '46255', 'M');
INSERT INTO `ey_region` VALUES ('46337', '奇台县', '3', '46255', 'Q');
INSERT INTO `ey_region` VALUES ('46355', '吉木萨尔县', '3', '46255', 'J');
INSERT INTO `ey_region` VALUES ('46366', '木垒县', '3', '46255', 'M');
INSERT INTO `ey_region` VALUES ('46380', '博州', '2', '46047', 'B');
INSERT INTO `ey_region` VALUES ('46381', '博乐市', '3', '46380', 'B');
INSERT INTO `ey_region` VALUES ('46399', '精河县', '3', '46380', 'J');
INSERT INTO `ey_region` VALUES ('46410', '温泉县', '3', '46380', 'W');
INSERT INTO `ey_region` VALUES ('46422', '巴州', '2', '46047', 'B');
INSERT INTO `ey_region` VALUES ('46423', '库尔勒市', '3', '46422', 'K');
INSERT INTO `ey_region` VALUES ('46451', '轮台县', '3', '46422', 'L');
INSERT INTO `ey_region` VALUES ('46463', '尉犁县', '3', '46422', 'W');
INSERT INTO `ey_region` VALUES ('46476', '若羌县', '3', '46422', 'R');
INSERT INTO `ey_region` VALUES ('46486', '且末县', '3', '46422', 'Q');
INSERT INTO `ey_region` VALUES ('46500', '焉耆县', '3', '46422', 'Y');
INSERT INTO `ey_region` VALUES ('46512', '和静县', '3', '46422', 'H');
INSERT INTO `ey_region` VALUES ('46531', '和硕县', '3', '46422', 'H');
INSERT INTO `ey_region` VALUES ('46542', '博湖县', '3', '46422', 'B');
INSERT INTO `ey_region` VALUES ('46551', '阿克苏地区', '2', '46047', 'A');
INSERT INTO `ey_region` VALUES ('46552', '阿克苏市', '3', '46551', 'A');
INSERT INTO `ey_region` VALUES ('46571', '温宿县', '3', '46551', 'W');
INSERT INTO `ey_region` VALUES ('46592', '库车县', '3', '46551', 'K');
INSERT INTO `ey_region` VALUES ('46617', '沙雅县', '3', '46551', 'S');
INSERT INTO `ey_region` VALUES ('46630', '新和县', '3', '46551', 'X');
INSERT INTO `ey_region` VALUES ('46640', '拜城县', '3', '46551', 'B');
INSERT INTO `ey_region` VALUES ('46657', '乌什县', '3', '46551', 'W');
INSERT INTO `ey_region` VALUES ('46668', '阿瓦提县', '3', '46551', 'A');
INSERT INTO `ey_region` VALUES ('46682', '柯坪县', '3', '46551', 'K');
INSERT INTO `ey_region` VALUES ('46688', '克州', '2', '46047', 'K');
INSERT INTO `ey_region` VALUES ('46689', '阿图什市', '3', '46688', 'A');
INSERT INTO `ey_region` VALUES ('46704', '阿克陶县', '3', '46688', 'A');
INSERT INTO `ey_region` VALUES ('46723', '阿合奇县', '3', '46688', 'A');
INSERT INTO `ey_region` VALUES ('46733', '乌恰县', '3', '46688', 'W');
INSERT INTO `ey_region` VALUES ('46747', '喀什地区', '2', '46047', 'K');
INSERT INTO `ey_region` VALUES ('46748', '喀什市', '3', '46747', 'K');
INSERT INTO `ey_region` VALUES ('46761', '疏附县', '3', '46747', 'S');
INSERT INTO `ey_region` VALUES ('46780', '疏勒县', '3', '46747', 'S');
INSERT INTO `ey_region` VALUES ('46797', '英吉沙县', '3', '46747', 'Y');
INSERT INTO `ey_region` VALUES ('46813', '泽普县', '3', '46747', 'Z');
INSERT INTO `ey_region` VALUES ('46830', '莎车县', '3', '46747', 'S');
INSERT INTO `ey_region` VALUES ('46863', '叶城县', '3', '46747', 'Y');
INSERT INTO `ey_region` VALUES ('46885', '麦盖提县', '3', '46747', 'M');
INSERT INTO `ey_region` VALUES ('46902', '岳普湖县', '3', '46747', 'Y');
INSERT INTO `ey_region` VALUES ('46913', '伽师县', '3', '46747', 'Q');
INSERT INTO `ey_region` VALUES ('46928', '巴楚县', '3', '46747', 'B');
INSERT INTO `ey_region` VALUES ('46942', '塔什库尔干县', '3', '46747', 'T');
INSERT INTO `ey_region` VALUES ('46957', '和田地区', '2', '46047', 'H');
INSERT INTO `ey_region` VALUES ('46958', '和田市', '3', '46957', 'H');
INSERT INTO `ey_region` VALUES ('46971', '和田县', '3', '46957', 'H');
INSERT INTO `ey_region` VALUES ('46983', '墨玉县', '3', '46957', 'M');
INSERT INTO `ey_region` VALUES ('47002', '皮山县', '3', '46957', 'P');
INSERT INTO `ey_region` VALUES ('47020', '洛浦县', '3', '46957', 'L');
INSERT INTO `ey_region` VALUES ('47032', '策勒县', '3', '46957', 'C');
INSERT INTO `ey_region` VALUES ('47042', '于田县', '3', '46957', 'Y');
INSERT INTO `ey_region` VALUES ('47061', '民丰县', '3', '46957', 'M');
INSERT INTO `ey_region` VALUES ('47069', '伊犁州', '2', '46047', 'Y');
INSERT INTO `ey_region` VALUES ('47070', '伊宁市', '3', '47069', 'Y');
INSERT INTO `ey_region` VALUES ('47091', '奎屯市', '3', '47069', 'K');
INSERT INTO `ey_region` VALUES ('47099', '伊宁县', '3', '47069', 'Y');
INSERT INTO `ey_region` VALUES ('47121', '察布查尔县', '3', '47069', 'C');
INSERT INTO `ey_region` VALUES ('47143', '霍城县', '3', '47069', 'H');
INSERT INTO `ey_region` VALUES ('47164', '巩留县', '3', '47069', 'G');
INSERT INTO `ey_region` VALUES ('47180', '新源县', '3', '47069', 'X');
INSERT INTO `ey_region` VALUES ('47196', '昭苏县', '3', '47069', 'Z');
INSERT INTO `ey_region` VALUES ('47214', '特克斯县', '3', '47069', 'T');
INSERT INTO `ey_region` VALUES ('47226', '尼勒克县', '3', '47069', 'N');
INSERT INTO `ey_region` VALUES ('47241', '塔城地区', '2', '46047', 'T');
INSERT INTO `ey_region` VALUES ('47242', '塔城市', '3', '47241', 'T');
INSERT INTO `ey_region` VALUES ('47258', '乌苏市', '3', '47241', 'W');
INSERT INTO `ey_region` VALUES ('47291', '额敏县', '3', '47241', 'E');
INSERT INTO `ey_region` VALUES ('47315', '沙湾县', '3', '47241', 'S');
INSERT INTO `ey_region` VALUES ('47338', '托里县', '3', '47241', 'T');
INSERT INTO `ey_region` VALUES ('47351', '裕民县', '3', '47241', 'Y');
INSERT INTO `ey_region` VALUES ('47360', '和布县', '3', '47241', 'H');
INSERT INTO `ey_region` VALUES ('47374', '阿勒泰地区', '2', '46047', 'A');
INSERT INTO `ey_region` VALUES ('47375', '阿勒泰市', '3', '47374', 'A');
INSERT INTO `ey_region` VALUES ('47393', '布尔津县', '3', '47374', 'B');
INSERT INTO `ey_region` VALUES ('47401', '富蕴县', '3', '47374', 'F');
INSERT INTO `ey_region` VALUES ('47411', '福海县', '3', '47374', 'F');
INSERT INTO `ey_region` VALUES ('47424', '哈巴河县', '3', '47374', 'H');
INSERT INTO `ey_region` VALUES ('47433', '青河县', '3', '47374', 'Q');
INSERT INTO `ey_region` VALUES ('47441', '吉木乃县', '3', '47374', 'J');
INSERT INTO `ey_region` VALUES ('47450', '省直辖行政单位', '2', '46047', 'S');
INSERT INTO `ey_region` VALUES ('47451', '石河子市', '3', '47450', 'S');
INSERT INTO `ey_region` VALUES ('47460', '阿拉尔市', '3', '47450', 'A');
INSERT INTO `ey_region` VALUES ('47477', '图木舒克市', '3', '47450', 'T');
INSERT INTO `ey_region` VALUES ('47486', '五家渠市', '3', '47450', 'W');
INSERT INTO `ey_region` VALUES ('47493', '台湾省', '1', '0', 'T');
INSERT INTO `ey_region` VALUES ('47494', '香港特别行政区', '1', '0', 'X');
INSERT INTO `ey_region` VALUES ('47495', '澳门特别行政区', '1', '0', 'A');
INSERT INTO `ey_region` VALUES ('47496', '龙华新区', '3', '28558', 'L');
INSERT INTO `ey_region` VALUES ('47497', '光明新区', '3', '28558', 'G');
INSERT INTO `ey_region` VALUES ('47500', '新界', '2', '47494', 'X');
INSERT INTO `ey_region` VALUES ('47501', '观塘区', '3', '47498', 'G');
INSERT INTO `ey_region` VALUES ('47502', '黄大仙区', '3', '47498', 'H');
INSERT INTO `ey_region` VALUES ('47503', '九龙城区', '3', '47498', 'J');
INSERT INTO `ey_region` VALUES ('47504', '深水埗区', '3', '47498', 'S');
INSERT INTO `ey_region` VALUES ('47505', '油尖旺区', '3', '47498', 'Y');
INSERT INTO `ey_region` VALUES ('47506', '东区', '3', '47499', 'D');
INSERT INTO `ey_region` VALUES ('47507', '南区', '3', '47499', 'N');
INSERT INTO `ey_region` VALUES ('47508', '湾仔', '3', '47499', 'W');
INSERT INTO `ey_region` VALUES ('47509', '中西区', '3', '47499', 'Z');
INSERT INTO `ey_region` VALUES ('47510', '北区', '3', '47500', 'B');
INSERT INTO `ey_region` VALUES ('47511', '大埔区', '3', '47500', 'D');
INSERT INTO `ey_region` VALUES ('47512', '葵青区', '3', '47500', 'K');
INSERT INTO `ey_region` VALUES ('47513', '离岛区', '3', '47500', 'L');
INSERT INTO `ey_region` VALUES ('47514', '荃湾区', '3', '47500', 'Q');
INSERT INTO `ey_region` VALUES ('47515', '沙田区', '3', '47500', 'S');
INSERT INTO `ey_region` VALUES ('47516', '屯门区', '3', '47500', 'T');
INSERT INTO `ey_region` VALUES ('47517', '西贡区', '3', '47500', 'X');
INSERT INTO `ey_region` VALUES ('47518', '元朗区', '3', '47500', 'Y');
INSERT INTO `ey_region` VALUES ('47519', '澳门半岛', '2', '47495', 'A');
INSERT INTO `ey_region` VALUES ('47520', '离岛', '2', '47495', 'L');
INSERT INTO `ey_region` VALUES ('47521', '大堂区', '3', '47519', 'D');
INSERT INTO `ey_region` VALUES ('47522', '风顺堂区', '3', '47519', 'F');
INSERT INTO `ey_region` VALUES ('47523', '花地玛堂区', '3', '47519', 'H');
INSERT INTO `ey_region` VALUES ('47524', '花王堂区', '3', '47519', 'H');
INSERT INTO `ey_region` VALUES ('47525', '望德堂区', '3', '47519', 'W');
INSERT INTO `ey_region` VALUES ('47526', '嘉模堂区', '3', '47520', 'J');
INSERT INTO `ey_region` VALUES ('47527', '路氹填海区', '3', '47520', 'L');
INSERT INTO `ey_region` VALUES ('47528', '圣方济各堂区', '3', '47520', 'S');
INSERT INTO `ey_region` VALUES ('47529', '高雄市', '2', '47493', 'G');
INSERT INTO `ey_region` VALUES ('47530', '花莲县', '2', '47493', 'H');
INSERT INTO `ey_region` VALUES ('47531', '基隆市', '2', '47493', 'J');
INSERT INTO `ey_region` VALUES ('47532', '嘉义市', '2', '47493', 'J');
INSERT INTO `ey_region` VALUES ('47533', '嘉义县', '2', '47493', 'J');
INSERT INTO `ey_region` VALUES ('47534', '金门县', '2', '47493', 'J');
INSERT INTO `ey_region` VALUES ('47535', '连江县', '2', '47493', 'L');
INSERT INTO `ey_region` VALUES ('47536', '苗栗县', '2', '47493', 'M');
INSERT INTO `ey_region` VALUES ('47537', '南投县', '2', '47493', 'N');
INSERT INTO `ey_region` VALUES ('47538', '澎湖县', '2', '47493', 'P');
INSERT INTO `ey_region` VALUES ('47539', '屏东县', '2', '47493', 'P');
INSERT INTO `ey_region` VALUES ('47540', '台北市', '2', '47493', 'T');
INSERT INTO `ey_region` VALUES ('47541', '台东县', '2', '47493', 'T');
INSERT INTO `ey_region` VALUES ('47542', '台南市', '2', '47493', 'T');
INSERT INTO `ey_region` VALUES ('47543', '台中市', '2', '47493', 'T');
INSERT INTO `ey_region` VALUES ('47544', '桃园市', '2', '47493', 'T');
INSERT INTO `ey_region` VALUES ('47545', '新北市', '2', '47493', 'X');
INSERT INTO `ey_region` VALUES ('47546', '新竹市', '2', '47493', 'X');
INSERT INTO `ey_region` VALUES ('47547', '新竹县', '2', '47493', 'X');
INSERT INTO `ey_region` VALUES ('47548', '宜兰县', '2', '47493', 'Y');
INSERT INTO `ey_region` VALUES ('47549', '云林县', '2', '47493', 'Y');
INSERT INTO `ey_region` VALUES ('47550', '彰化县', '2', '47493', 'Z');
INSERT INTO `ey_region` VALUES ('47551', '阿莲区', '3', '47529', 'A');
INSERT INTO `ey_region` VALUES ('47552', '大寮区', '3', '47529', 'D');
INSERT INTO `ey_region` VALUES ('47553', '大社区', '3', '47529', 'D');
INSERT INTO `ey_region` VALUES ('47554', '大树区', '3', '47529', 'D');
INSERT INTO `ey_region` VALUES ('47555', '凤山区', '3', '47529', 'F');
INSERT INTO `ey_region` VALUES ('47556', '冈山区', '3', '47529', 'G');
INSERT INTO `ey_region` VALUES ('47557', '鼓山区', '3', '47529', 'G');
INSERT INTO `ey_region` VALUES ('47558', '湖内区', '3', '47529', 'H');
INSERT INTO `ey_region` VALUES ('47559', '甲仙区', '3', '47529', 'J');
INSERT INTO `ey_region` VALUES ('47560', '林园区', '3', '47529', 'L');
INSERT INTO `ey_region` VALUES ('47561', '苓雅区', '3', '47529', 'L');
INSERT INTO `ey_region` VALUES ('47562', '六龟区', '3', '47529', 'L');
INSERT INTO `ey_region` VALUES ('47563', '路竹区', '3', '47529', 'L');
INSERT INTO `ey_region` VALUES ('47564', '茂林区', '3', '47529', 'M');
INSERT INTO `ey_region` VALUES ('47565', '美浓区', '3', '47529', 'M');
INSERT INTO `ey_region` VALUES ('47566', '弥陀区', '3', '47529', 'M');
INSERT INTO `ey_region` VALUES ('47567', '楠梓区', '3', '47529', 'N');
INSERT INTO `ey_region` VALUES ('47568', '那玛夏区', '3', '47529', 'N');
INSERT INTO `ey_region` VALUES ('47569', '内门区', '3', '47529', 'N');
INSERT INTO `ey_region` VALUES ('47570', '鸟松区', '3', '47529', 'N');
INSERT INTO `ey_region` VALUES ('47571', '旗津区', '3', '47529', 'Q');
INSERT INTO `ey_region` VALUES ('47572', '旗门区', '3', '47529', 'Q');
INSERT INTO `ey_region` VALUES ('47573', '其它区', '3', '47529', 'Q');
INSERT INTO `ey_region` VALUES ('47574', '前金区', '3', '47529', 'Q');
INSERT INTO `ey_region` VALUES ('47575', '前镇区', '3', '47529', 'Q');
INSERT INTO `ey_region` VALUES ('47576', '桥头区', '3', '47529', 'Q');
INSERT INTO `ey_region` VALUES ('47577', '茄萣区', '3', '47529', 'Q');
INSERT INTO `ey_region` VALUES ('47578', '芩雅区', '3', '47529', 'Q');
INSERT INTO `ey_region` VALUES ('47579', '仁武区', '3', '47529', 'R');
INSERT INTO `ey_region` VALUES ('47580', '三民区', '3', '47529', 'S');
INSERT INTO `ey_region` VALUES ('47581', '杉林区', '3', '47529', 'S');
INSERT INTO `ey_region` VALUES ('47582', '桃源区', '3', '47529', 'T');
INSERT INTO `ey_region` VALUES ('47583', '田寮区', '3', '47529', 'T');
INSERT INTO `ey_region` VALUES ('47584', '小港区', '3', '47529', 'X');
INSERT INTO `ey_region` VALUES ('47585', '新兴区', '3', '47529', 'X');
INSERT INTO `ey_region` VALUES ('47586', '燕巢区', '3', '47529', 'Y');
INSERT INTO `ey_region` VALUES ('47587', '盐埕区', '3', '47529', 'Y');
INSERT INTO `ey_region` VALUES ('47588', '永安区', '3', '47529', 'Y');
INSERT INTO `ey_region` VALUES ('47589', '梓官区', '3', '47529', 'Z');
INSERT INTO `ey_region` VALUES ('47590', '左营区', '3', '47529', 'Z');
INSERT INTO `ey_region` VALUES ('47591', '丰滨乡', '3', '47530', 'F');
INSERT INTO `ey_region` VALUES ('47592', '凤林镇', '3', '47530', 'F');
INSERT INTO `ey_region` VALUES ('47593', '富里乡', '3', '47530', 'F');
INSERT INTO `ey_region` VALUES ('47594', '光复乡', '3', '47530', 'G');
INSERT INTO `ey_region` VALUES ('47595', '花莲市', '3', '47530', 'H');
INSERT INTO `ey_region` VALUES ('47596', '吉安乡', '3', '47530', 'J');
INSERT INTO `ey_region` VALUES ('47597', '瑞穗乡', '3', '47530', 'R');
INSERT INTO `ey_region` VALUES ('47598', '寿丰乡', '3', '47530', 'S');
INSERT INTO `ey_region` VALUES ('47599', '太鲁阁', '3', '47530', 'T');
INSERT INTO `ey_region` VALUES ('47600', '万荣乡', '3', '47530', 'W');
INSERT INTO `ey_region` VALUES ('47601', '新城乡', '3', '47530', 'X');
INSERT INTO `ey_region` VALUES ('47602', '秀林乡', '3', '47530', 'X');
INSERT INTO `ey_region` VALUES ('47603', '玉里镇', '3', '47530', 'Y');
INSERT INTO `ey_region` VALUES ('47604', '卓溪乡', '3', '47530', 'Z');
INSERT INTO `ey_region` VALUES ('47605', '安乐区', '3', '47531', 'A');
INSERT INTO `ey_region` VALUES ('47606', '暖暖区', '3', '47531', 'N');
INSERT INTO `ey_region` VALUES ('47607', '七堵区', '3', '47531', 'Q');
INSERT INTO `ey_region` VALUES ('47608', '其它区', '3', '47531', 'Q');
INSERT INTO `ey_region` VALUES ('47609', '仁爱区', '3', '47531', 'R');
INSERT INTO `ey_region` VALUES ('47610', '信义区', '3', '47531', 'X');
INSERT INTO `ey_region` VALUES ('47611', '中山区', '3', '47531', 'Z');
INSERT INTO `ey_region` VALUES ('47612', '中正区', '3', '47531', 'Z');
INSERT INTO `ey_region` VALUES ('47613', '东区', '3', '47532', 'D');
INSERT INTO `ey_region` VALUES ('47614', '西区', '3', '47532', 'X');
INSERT INTO `ey_region` VALUES ('47615', '其它区', '3', '47532', 'Q');
INSERT INTO `ey_region` VALUES ('47616', '阿里山乡', '3', '47533', 'A');
INSERT INTO `ey_region` VALUES ('47617', '布袋镇', '3', '47533', 'B');
INSERT INTO `ey_region` VALUES ('47618', '大林镇', '3', '47533', 'D');
INSERT INTO `ey_region` VALUES ('47619', '大埔乡', '3', '47533', 'D');
INSERT INTO `ey_region` VALUES ('47620', '东石乡', '3', '47533', 'D');
INSERT INTO `ey_region` VALUES ('47621', '番路乡', '3', '47533', 'F');
INSERT INTO `ey_region` VALUES ('47622', '六脚乡', '3', '47533', 'L');
INSERT INTO `ey_region` VALUES ('47623', '鹿草乡', '3', '47533', 'L');
INSERT INTO `ey_region` VALUES ('47624', '梅山乡', '3', '47533', 'M');
INSERT INTO `ey_region` VALUES ('47625', '民雄乡', '3', '47533', 'M');
INSERT INTO `ey_region` VALUES ('47626', '朴子市', '3', '47533', 'P');
INSERT INTO `ey_region` VALUES ('47627', '水上乡', '3', '47533', 'S');
INSERT INTO `ey_region` VALUES ('47628', '太保市', '3', '47533', 'T');
INSERT INTO `ey_region` VALUES ('47629', '溪口乡', '3', '47533', 'X');
INSERT INTO `ey_region` VALUES ('47630', '新港乡', '3', '47533', 'X');
INSERT INTO `ey_region` VALUES ('47631', '义竹乡', '3', '47533', 'Y');
INSERT INTO `ey_region` VALUES ('47632', '中埔乡', '3', '47533', 'Z');
INSERT INTO `ey_region` VALUES ('47633', '竹崎乡', '3', '47533', 'Z');
INSERT INTO `ey_region` VALUES ('47634', '金城镇', '3', '47534', 'J');
INSERT INTO `ey_region` VALUES ('47635', '金湖镇', '3', '47534', 'J');
INSERT INTO `ey_region` VALUES ('47636', '金宁乡', '3', '47534', 'J');
INSERT INTO `ey_region` VALUES ('47637', '金沙镇', '3', '47534', 'J');
INSERT INTO `ey_region` VALUES ('47638', '烈屿乡', '3', '47534', 'L');
INSERT INTO `ey_region` VALUES ('47639', '乌邱乡', '3', '47534', 'W');
INSERT INTO `ey_region` VALUES ('47640', '北竿乡', '3', '47535', 'B');
INSERT INTO `ey_region` VALUES ('47641', '东引乡', '3', '47535', 'D');
INSERT INTO `ey_region` VALUES ('47642', '莒光乡', '3', '47535', 'J');
INSERT INTO `ey_region` VALUES ('47643', '南竿乡', '3', '47535', 'N');
INSERT INTO `ey_region` VALUES ('47644', '大湖乡', '3', '47536', 'D');
INSERT INTO `ey_region` VALUES ('47645', '公馆乡', '3', '47536', 'G');
INSERT INTO `ey_region` VALUES ('47646', '后龙镇', '3', '47536', 'H');
INSERT INTO `ey_region` VALUES ('47647', '苗栗市', '3', '47536', 'M');
INSERT INTO `ey_region` VALUES ('47648', '南庄乡', '3', '47536', 'N');
INSERT INTO `ey_region` VALUES ('47649', '三湾乡', '3', '47536', 'S');
INSERT INTO `ey_region` VALUES ('47650', '三义乡', '3', '47536', 'S');
INSERT INTO `ey_region` VALUES ('47651', '狮潭乡', '3', '47536', 'S');
INSERT INTO `ey_region` VALUES ('47652', '泰安乡', '3', '47536', 'T');
INSERT INTO `ey_region` VALUES ('47653', '铜锣乡', '3', '47536', 'T');
INSERT INTO `ey_region` VALUES ('47654', '通宵镇', '3', '47536', 'T');
INSERT INTO `ey_region` VALUES ('47655', '头份镇', '3', '47536', 'T');
INSERT INTO `ey_region` VALUES ('47656', '头屋乡', '3', '47536', 'T');
INSERT INTO `ey_region` VALUES ('47657', '西湖乡', '3', '47536', 'X');
INSERT INTO `ey_region` VALUES ('47658', '苑里镇', '3', '47536', 'Y');
INSERT INTO `ey_region` VALUES ('47659', '造桥乡', '3', '47536', 'Z');
INSERT INTO `ey_region` VALUES ('47660', '竹南镇', '3', '47536', 'Z');
INSERT INTO `ey_region` VALUES ('47661', '卓兰镇', '3', '47536', 'Z');
INSERT INTO `ey_region` VALUES ('47662', '草屯镇', '3', '47537', 'C');
INSERT INTO `ey_region` VALUES ('47663', '国姓乡', '3', '47537', 'G');
INSERT INTO `ey_region` VALUES ('47664', '集集镇', '3', '47537', 'J');
INSERT INTO `ey_region` VALUES ('47665', '鹿谷乡', '3', '47537', 'L');
INSERT INTO `ey_region` VALUES ('47666', '名间乡', '3', '47537', 'M');
INSERT INTO `ey_region` VALUES ('47667', '南投市', '3', '47537', 'N');
INSERT INTO `ey_region` VALUES ('47668', '埔里镇', '3', '47537', 'P');
INSERT INTO `ey_region` VALUES ('47669', '仁爱乡', '3', '47537', 'R');
INSERT INTO `ey_region` VALUES ('47670', '水里乡', '3', '47537', 'S');
INSERT INTO `ey_region` VALUES ('47671', '信义乡', '3', '47537', 'X');
INSERT INTO `ey_region` VALUES ('47672', '鱼池乡', '3', '47537', 'Y');
INSERT INTO `ey_region` VALUES ('47673', '中寮乡', '3', '47537', 'Z');
INSERT INTO `ey_region` VALUES ('47674', '竹山镇', '3', '47537', 'Z');
INSERT INTO `ey_region` VALUES ('47675', '白沙乡', '3', '47538', 'B');
INSERT INTO `ey_region` VALUES ('47676', '湖西乡', '3', '47538', 'H');
INSERT INTO `ey_region` VALUES ('47677', '马公市', '3', '47538', 'M');
INSERT INTO `ey_region` VALUES ('47678', '七美乡', '3', '47538', 'Q');
INSERT INTO `ey_region` VALUES ('47679', '望安乡', '3', '47538', 'W');
INSERT INTO `ey_region` VALUES ('47680', '西屿乡', '3', '47538', 'X');
INSERT INTO `ey_region` VALUES ('47681', '长治乡', '3', '47539', 'C');
INSERT INTO `ey_region` VALUES ('47682', '潮州镇', '3', '47539', 'C');
INSERT INTO `ey_region` VALUES ('47683', '车城乡', '3', '47539', 'C');
INSERT INTO `ey_region` VALUES ('47684', '春日乡', '3', '47539', 'C');
INSERT INTO `ey_region` VALUES ('47685', '东港镇', '3', '47539', 'D');
INSERT INTO `ey_region` VALUES ('47686', '枋寮乡', '3', '47539', 'F');
INSERT INTO `ey_region` VALUES ('47687', '枋山乡', '3', '47539', 'F');
INSERT INTO `ey_region` VALUES ('47688', '高树乡', '3', '47539', 'G');
INSERT INTO `ey_region` VALUES ('47689', '恒春镇', '3', '47539', 'H');
INSERT INTO `ey_region` VALUES ('47690', '佳冬乡', '3', '47539', 'J');
INSERT INTO `ey_region` VALUES ('47691', '九如乡', '3', '47539', 'J');
INSERT INTO `ey_region` VALUES ('47692', '崁顶乡', '3', '47539', 'K');
INSERT INTO `ey_region` VALUES ('47693', '来义乡', '3', '47539', 'L');
INSERT INTO `ey_region` VALUES ('47694', '里港乡', '3', '47539', 'L');
INSERT INTO `ey_region` VALUES ('47695', '林边乡', '3', '47539', 'L');
INSERT INTO `ey_region` VALUES ('47696', '麟洛乡', '3', '47539', 'L');
INSERT INTO `ey_region` VALUES ('47697', '琉球乡', '3', '47539', 'L');
INSERT INTO `ey_region` VALUES ('47698', '玛家乡', '3', '47539', 'M');
INSERT INTO `ey_region` VALUES ('47699', '满州乡', '3', '47539', 'M');
INSERT INTO `ey_region` VALUES ('47700', '牡丹乡', '3', '47539', 'M');
INSERT INTO `ey_region` VALUES ('47701', '南州乡', '3', '47539', 'N');
INSERT INTO `ey_region` VALUES ('47702', '内埔乡', '3', '47539', 'N');
INSERT INTO `ey_region` VALUES ('47703', '屏东市', '3', '47539', 'P');
INSERT INTO `ey_region` VALUES ('47704', '三地门乡', '3', '47539', 'S');
INSERT INTO `ey_region` VALUES ('47705', '狮子乡', '3', '47539', 'S');
INSERT INTO `ey_region` VALUES ('47706', '泰武乡', '3', '47539', 'T');
INSERT INTO `ey_region` VALUES ('47707', '万丹乡', '3', '47539', 'W');
INSERT INTO `ey_region` VALUES ('47708', '万峦乡', '3', '47539', 'W');
INSERT INTO `ey_region` VALUES ('47709', '雾台乡', '3', '47539', 'W');
INSERT INTO `ey_region` VALUES ('47710', '新埤乡', '3', '47539', 'X');
INSERT INTO `ey_region` VALUES ('47711', '新园乡', '3', '47539', 'X');
INSERT INTO `ey_region` VALUES ('47712', '盐埔乡', '3', '47539', 'Y');
INSERT INTO `ey_region` VALUES ('47713', '竹田乡', '3', '47539', 'Z');
INSERT INTO `ey_region` VALUES ('47714', '北投区', '3', '47540', 'B');
INSERT INTO `ey_region` VALUES ('47715', '大安区', '3', '47540', 'D');
INSERT INTO `ey_region` VALUES ('47716', '大同区', '3', '47540', 'D');
INSERT INTO `ey_region` VALUES ('47717', '南港区', '3', '47540', 'N');
INSERT INTO `ey_region` VALUES ('47718', '内湖区', '3', '47540', 'N');
INSERT INTO `ey_region` VALUES ('47719', '士林区', '3', '47540', 'S');
INSERT INTO `ey_region` VALUES ('47720', '松山区', '3', '47540', 'S');
INSERT INTO `ey_region` VALUES ('47721', '万华区', '3', '47540', 'W');
INSERT INTO `ey_region` VALUES ('47722', '文山区', '3', '47540', 'W');
INSERT INTO `ey_region` VALUES ('47723', '信义区', '3', '47540', 'X');
INSERT INTO `ey_region` VALUES ('47724', '中山区', '3', '47540', 'Z');
INSERT INTO `ey_region` VALUES ('47725', '中正区', '3', '47540', 'Z');
INSERT INTO `ey_region` VALUES ('47726', '其它区', '3', '47540', 'Q');
INSERT INTO `ey_region` VALUES ('47727', '卑南乡', '3', '47541', 'B');
INSERT INTO `ey_region` VALUES ('47728', '长滨乡', '3', '47541', 'C');
INSERT INTO `ey_region` VALUES ('47729', '成功镇', '3', '47541', 'C');
INSERT INTO `ey_region` VALUES ('47730', '池上乡', '3', '47541', 'C');
INSERT INTO `ey_region` VALUES ('47731', '达仁乡', '3', '47541', 'D');
INSERT INTO `ey_region` VALUES ('47732', '大武乡', '3', '47541', 'D');
INSERT INTO `ey_region` VALUES ('47733', '东河乡', '3', '47541', 'D');
INSERT INTO `ey_region` VALUES ('47734', '关山镇', '3', '47541', 'G');
INSERT INTO `ey_region` VALUES ('47735', '海端乡', '3', '47541', 'H');
INSERT INTO `ey_region` VALUES ('47736', '金峰乡', '3', '47541', 'J');
INSERT INTO `ey_region` VALUES ('47737', '兰屿乡', '3', '47541', 'L');
INSERT INTO `ey_region` VALUES ('47738', '鹿野乡', '3', '47541', 'L');
INSERT INTO `ey_region` VALUES ('47739', '绿岛乡', '3', '47541', 'L');
INSERT INTO `ey_region` VALUES ('47740', '台东市', '3', '47541', 'T');
INSERT INTO `ey_region` VALUES ('47741', '太麻里乡', '3', '47541', 'T');
INSERT INTO `ey_region` VALUES ('47742', '延平乡', '3', '47541', 'Y');
INSERT INTO `ey_region` VALUES ('47743', '中西区', '3', '47542', 'Z');
INSERT INTO `ey_region` VALUES ('47744', '东区', '3', '47542', 'D');
INSERT INTO `ey_region` VALUES ('47745', '南区', '3', '47542', 'N');
INSERT INTO `ey_region` VALUES ('47746', '北区', '3', '47542', 'B');
INSERT INTO `ey_region` VALUES ('47747', '安平区', '3', '47542', 'A');
INSERT INTO `ey_region` VALUES ('47748', '安南区', '3', '47542', 'A');
INSERT INTO `ey_region` VALUES ('47749', '其它区', '3', '47542', 'Q');
INSERT INTO `ey_region` VALUES ('47750', '永康区', '3', '47542', 'Y');
INSERT INTO `ey_region` VALUES ('47751', '归仁区', '3', '47542', 'G');
INSERT INTO `ey_region` VALUES ('47752', '新化区', '3', '47542', 'X');
INSERT INTO `ey_region` VALUES ('47753', '左镇区', '3', '47542', 'Z');
INSERT INTO `ey_region` VALUES ('47754', '玉井区', '3', '47542', 'Y');
INSERT INTO `ey_region` VALUES ('47755', '楠西区', '3', '47542', 'N');
INSERT INTO `ey_region` VALUES ('47756', '南化区', '3', '47542', 'N');
INSERT INTO `ey_region` VALUES ('47757', '仁德区', '3', '47542', 'R');
INSERT INTO `ey_region` VALUES ('47758', '关庙区', '3', '47542', 'G');
INSERT INTO `ey_region` VALUES ('47759', '龙崎区', '3', '47542', 'L');
INSERT INTO `ey_region` VALUES ('47760', '官田区', '3', '47542', 'G');
INSERT INTO `ey_region` VALUES ('47761', '麻豆区', '3', '47542', 'M');
INSERT INTO `ey_region` VALUES ('47762', '佳里区', '3', '47542', 'J');
INSERT INTO `ey_region` VALUES ('47763', '西港区', '3', '47542', 'X');
INSERT INTO `ey_region` VALUES ('47764', '七股区', '3', '47542', 'Q');
INSERT INTO `ey_region` VALUES ('47765', '将军区', '3', '47542', 'J');
INSERT INTO `ey_region` VALUES ('47766', '学甲区', '3', '47542', 'X');
INSERT INTO `ey_region` VALUES ('47767', '北门区', '3', '47542', 'B');
INSERT INTO `ey_region` VALUES ('47768', '新营区', '3', '47542', 'X');
INSERT INTO `ey_region` VALUES ('47769', '后壁区', '3', '47542', 'H');
INSERT INTO `ey_region` VALUES ('47770', '白河区', '3', '47542', 'B');
INSERT INTO `ey_region` VALUES ('47771', '东山区', '3', '47542', 'D');
INSERT INTO `ey_region` VALUES ('47772', '六甲区', '3', '47542', 'L');
INSERT INTO `ey_region` VALUES ('47773', '下营区', '3', '47542', 'X');
INSERT INTO `ey_region` VALUES ('47774', '柳营区', '3', '47542', 'L');
INSERT INTO `ey_region` VALUES ('47775', '盐水区', '3', '47542', 'Y');
INSERT INTO `ey_region` VALUES ('47776', '善化区', '3', '47542', 'S');
INSERT INTO `ey_region` VALUES ('47777', '大内区', '3', '47542', 'D');
INSERT INTO `ey_region` VALUES ('47778', '山上区', '3', '47542', 'S');
INSERT INTO `ey_region` VALUES ('47779', '新市区', '3', '47542', 'X');
INSERT INTO `ey_region` VALUES ('47780', '安定区', '3', '47542', 'A');
INSERT INTO `ey_region` VALUES ('47781', '中区', '3', '47543', 'Z');
INSERT INTO `ey_region` VALUES ('47782', '东区', '3', '47543', 'D');
INSERT INTO `ey_region` VALUES ('47783', '南区', '3', '47543', 'N');
INSERT INTO `ey_region` VALUES ('47784', '西区', '3', '47543', 'X');
INSERT INTO `ey_region` VALUES ('47785', '北区', '3', '47543', 'B');
INSERT INTO `ey_region` VALUES ('47786', '北屯区', '3', '47543', 'B');
INSERT INTO `ey_region` VALUES ('47787', '西屯区', '3', '47543', 'X');
INSERT INTO `ey_region` VALUES ('47788', '南屯区', '3', '47543', 'N');
INSERT INTO `ey_region` VALUES ('47789', '其它区', '3', '47543', 'Q');
INSERT INTO `ey_region` VALUES ('47790', '太平区', '3', '47543', 'T');
INSERT INTO `ey_region` VALUES ('47791', '大里区', '3', '47543', 'D');
INSERT INTO `ey_region` VALUES ('47792', '雾峰区', '3', '47543', 'W');
INSERT INTO `ey_region` VALUES ('47793', '乌日区', '3', '47543', 'W');
INSERT INTO `ey_region` VALUES ('47794', '丰原区', '3', '47543', 'F');
INSERT INTO `ey_region` VALUES ('47795', '后里区', '3', '47543', 'H');
INSERT INTO `ey_region` VALUES ('47796', '石冈区', '3', '47543', 'S');
INSERT INTO `ey_region` VALUES ('47797', '东势区', '3', '47543', 'D');
INSERT INTO `ey_region` VALUES ('47798', '和平区', '3', '47543', 'H');
INSERT INTO `ey_region` VALUES ('47799', '新社区', '3', '47543', 'X');
INSERT INTO `ey_region` VALUES ('47800', '潭子区', '3', '47543', 'T');
INSERT INTO `ey_region` VALUES ('47801', '大雅区', '3', '47543', 'D');
INSERT INTO `ey_region` VALUES ('47802', '神冈区', '3', '47543', 'S');
INSERT INTO `ey_region` VALUES ('47803', '大肚区', '3', '47543', 'D');
INSERT INTO `ey_region` VALUES ('47804', '沙鹿区', '3', '47543', 'S');
INSERT INTO `ey_region` VALUES ('47805', '龙井区', '3', '47543', 'L');
INSERT INTO `ey_region` VALUES ('47806', '梧栖区', '3', '47543', 'W');
INSERT INTO `ey_region` VALUES ('47807', '清水区', '3', '47543', 'Q');
INSERT INTO `ey_region` VALUES ('47808', '大甲区', '3', '47543', 'D');
INSERT INTO `ey_region` VALUES ('47809', '外埔区', '3', '47543', 'W');
INSERT INTO `ey_region` VALUES ('47810', '大安区', '3', '47543', 'D');
INSERT INTO `ey_region` VALUES ('47811', '中坜区', '3', '47544', 'Z');
INSERT INTO `ey_region` VALUES ('47812', '平镇区', '3', '47544', 'P');
INSERT INTO `ey_region` VALUES ('47813', '龙潭区', '3', '47544', 'L');
INSERT INTO `ey_region` VALUES ('47814', '杨梅区', '3', '47544', 'Y');
INSERT INTO `ey_region` VALUES ('47815', '新屋区', '3', '47544', 'X');
INSERT INTO `ey_region` VALUES ('47816', '观音区', '3', '47544', 'G');
INSERT INTO `ey_region` VALUES ('47817', '桃园区', '3', '47544', 'T');
INSERT INTO `ey_region` VALUES ('47818', '龟山区', '3', '47544', 'G');
INSERT INTO `ey_region` VALUES ('47819', '八德区', '3', '47544', 'B');
INSERT INTO `ey_region` VALUES ('47820', '大溪区', '3', '47544', 'D');
INSERT INTO `ey_region` VALUES ('47821', '复兴区', '3', '47544', 'F');
INSERT INTO `ey_region` VALUES ('47822', '大园区', '3', '47544', 'D');
INSERT INTO `ey_region` VALUES ('47823', '芦竹区', '3', '47544', 'L');
INSERT INTO `ey_region` VALUES ('47824', '万里区', '3', '47545', 'W');
INSERT INTO `ey_region` VALUES ('47825', '金山区', '3', '47545', 'J');
INSERT INTO `ey_region` VALUES ('47826', '板桥区', '3', '47545', 'B');
INSERT INTO `ey_region` VALUES ('47827', '汐止区', '3', '47545', 'X');
INSERT INTO `ey_region` VALUES ('47828', '深坑区', '3', '47545', 'S');
INSERT INTO `ey_region` VALUES ('47829', '石碇区', '3', '47545', 'S');
INSERT INTO `ey_region` VALUES ('47830', '瑞芳区', '3', '47545', 'R');
INSERT INTO `ey_region` VALUES ('47831', '平溪区', '3', '47545', 'P');
INSERT INTO `ey_region` VALUES ('47832', '双溪区', '3', '47545', 'S');
INSERT INTO `ey_region` VALUES ('47833', '贡寮区', '3', '47545', 'G');
INSERT INTO `ey_region` VALUES ('47834', '新店区', '3', '47545', 'X');
INSERT INTO `ey_region` VALUES ('47835', '坪林区', '3', '47545', 'P');
INSERT INTO `ey_region` VALUES ('47836', '乌来区', '3', '47545', 'W');
INSERT INTO `ey_region` VALUES ('47837', '永和区', '3', '47545', 'Y');
INSERT INTO `ey_region` VALUES ('47838', '中和区', '3', '47545', 'Z');
INSERT INTO `ey_region` VALUES ('47839', '土城区', '3', '47545', 'T');
INSERT INTO `ey_region` VALUES ('47840', '三峡区', '3', '47545', 'S');
INSERT INTO `ey_region` VALUES ('47841', '树林区', '3', '47545', 'S');
INSERT INTO `ey_region` VALUES ('47842', '莺歌区', '3', '47545', 'Y');
INSERT INTO `ey_region` VALUES ('47843', '三重区', '3', '47545', 'S');
INSERT INTO `ey_region` VALUES ('47844', '新庄区', '3', '47545', 'X');
INSERT INTO `ey_region` VALUES ('47845', '泰山区', '3', '47545', 'T');
INSERT INTO `ey_region` VALUES ('47846', '林口区', '3', '47545', 'L');
INSERT INTO `ey_region` VALUES ('47847', '芦洲区', '3', '47545', 'L');
INSERT INTO `ey_region` VALUES ('47848', '五股区', '3', '47545', 'W');
INSERT INTO `ey_region` VALUES ('47849', '八里区', '3', '47545', 'B');
INSERT INTO `ey_region` VALUES ('47850', '淡水区', '3', '47545', 'D');
INSERT INTO `ey_region` VALUES ('47851', '三芝区', '3', '47545', 'S');
INSERT INTO `ey_region` VALUES ('47852', '石门区', '3', '47545', 'S');
INSERT INTO `ey_region` VALUES ('47853', '东区', '3', '47546', 'D');
INSERT INTO `ey_region` VALUES ('47854', '北区', '3', '47546', 'B');
INSERT INTO `ey_region` VALUES ('47855', '香山区', '3', '47546', 'X');
INSERT INTO `ey_region` VALUES ('47856', '其它区', '3', '47546', 'Q');
INSERT INTO `ey_region` VALUES ('47857', '竹北市', '3', '47547', 'Z');
INSERT INTO `ey_region` VALUES ('47858', '湖口乡', '3', '47547', 'H');
INSERT INTO `ey_region` VALUES ('47859', '新丰乡', '3', '47547', 'X');
INSERT INTO `ey_region` VALUES ('47860', '新埔镇', '3', '47547', 'X');
INSERT INTO `ey_region` VALUES ('47861', '关西镇', '3', '47547', 'G');
INSERT INTO `ey_region` VALUES ('47862', '芎林乡', '3', '47547', 'X');
INSERT INTO `ey_region` VALUES ('47863', '宝山乡', '3', '47547', 'B');
INSERT INTO `ey_region` VALUES ('47864', '竹东镇', '3', '47547', 'Z');
INSERT INTO `ey_region` VALUES ('47865', '五峰乡', '3', '47547', 'W');
INSERT INTO `ey_region` VALUES ('47866', '横山乡', '3', '47547', 'H');
INSERT INTO `ey_region` VALUES ('47867', '尖石乡', '3', '47547', 'J');
INSERT INTO `ey_region` VALUES ('47868', '北埔乡', '3', '47547', 'B');
INSERT INTO `ey_region` VALUES ('47869', '峨眉乡', '3', '47547', 'E');
INSERT INTO `ey_region` VALUES ('47870', '宜兰市', '3', '47548', 'Y');
INSERT INTO `ey_region` VALUES ('47871', '头城镇', '3', '47548', 'T');
INSERT INTO `ey_region` VALUES ('47872', '礁溪乡', '3', '47548', 'J');
INSERT INTO `ey_region` VALUES ('47873', '壮围乡', '3', '47548', 'Z');
INSERT INTO `ey_region` VALUES ('47874', '员山乡', '3', '47548', 'Y');
INSERT INTO `ey_region` VALUES ('47875', '罗东镇', '3', '47548', 'L');
INSERT INTO `ey_region` VALUES ('47876', '三星乡', '3', '47548', 'S');
INSERT INTO `ey_region` VALUES ('47877', '大同乡', '3', '47548', 'D');
INSERT INTO `ey_region` VALUES ('47878', '五结乡', '3', '47548', 'W');
INSERT INTO `ey_region` VALUES ('47879', '冬山乡', '3', '47548', 'D');
INSERT INTO `ey_region` VALUES ('47880', '苏澳镇', '3', '47548', 'S');
INSERT INTO `ey_region` VALUES ('47881', '南澳乡', '3', '47548', 'N');
INSERT INTO `ey_region` VALUES ('47882', '钓鱼台', '3', '47548', 'D');
INSERT INTO `ey_region` VALUES ('47883', '斗南镇', '3', '47549', 'D');
INSERT INTO `ey_region` VALUES ('47884', '大埤乡', '3', '47549', 'D');
INSERT INTO `ey_region` VALUES ('47885', '虎尾镇', '3', '47549', 'H');
INSERT INTO `ey_region` VALUES ('47886', '土库镇', '3', '47549', 'T');
INSERT INTO `ey_region` VALUES ('47887', '褒忠乡', '3', '47549', 'B');
INSERT INTO `ey_region` VALUES ('47888', '东势乡', '3', '47549', 'D');
INSERT INTO `ey_region` VALUES ('47889', '台西乡', '3', '47549', 'T');
INSERT INTO `ey_region` VALUES ('47890', '仑背乡', '3', '47549', 'L');
INSERT INTO `ey_region` VALUES ('47891', '麦寮乡', '3', '47549', 'M');
INSERT INTO `ey_region` VALUES ('47892', '斗六市', '3', '47549', 'D');
INSERT INTO `ey_region` VALUES ('47893', '林内乡', '3', '47549', 'L');
INSERT INTO `ey_region` VALUES ('47894', '古坑乡', '3', '47549', 'G');
INSERT INTO `ey_region` VALUES ('47895', '莿桐乡', '3', '47549', 'C');
INSERT INTO `ey_region` VALUES ('47896', '西螺镇', '3', '47549', 'X');
INSERT INTO `ey_region` VALUES ('47897', '二仑乡', '3', '47549', 'E');
INSERT INTO `ey_region` VALUES ('47898', '北港镇', '3', '47549', 'B');
INSERT INTO `ey_region` VALUES ('47899', '水林乡', '3', '47549', 'S');
INSERT INTO `ey_region` VALUES ('47900', '口湖乡', '3', '47549', 'K');
INSERT INTO `ey_region` VALUES ('47901', '四湖乡', '3', '47549', 'S');
INSERT INTO `ey_region` VALUES ('47902', '元长乡', '3', '47549', 'Y');
INSERT INTO `ey_region` VALUES ('47903', '彰化市', '3', '47550', 'Z');
INSERT INTO `ey_region` VALUES ('47904', '芬园乡', '3', '47550', 'F');
INSERT INTO `ey_region` VALUES ('47905', '花坛乡', '3', '47550', 'H');
INSERT INTO `ey_region` VALUES ('47906', '秀水乡', '3', '47550', 'X');
INSERT INTO `ey_region` VALUES ('47907', '鹿港镇', '3', '47550', 'L');
INSERT INTO `ey_region` VALUES ('47908', '福兴乡', '3', '47550', 'F');
INSERT INTO `ey_region` VALUES ('47909', '线西乡', '3', '47550', 'X');
INSERT INTO `ey_region` VALUES ('47910', '和美镇', '3', '47550', 'H');
INSERT INTO `ey_region` VALUES ('47911', '伸港乡', '3', '47550', 'S');
INSERT INTO `ey_region` VALUES ('47912', '员林镇', '3', '47550', 'Y');
INSERT INTO `ey_region` VALUES ('47913', '社头乡', '3', '47550', 'S');
INSERT INTO `ey_region` VALUES ('47914', '永靖乡', '3', '47550', 'Y');
INSERT INTO `ey_region` VALUES ('47915', '埔心乡', '3', '47550', 'P');
INSERT INTO `ey_region` VALUES ('47916', '溪湖镇', '3', '47550', 'X');
INSERT INTO `ey_region` VALUES ('47917', '大村乡', '3', '47550', 'D');
INSERT INTO `ey_region` VALUES ('47918', '埔盐乡', '3', '47550', 'P');
INSERT INTO `ey_region` VALUES ('47919', '田中镇', '3', '47550', 'T');
INSERT INTO `ey_region` VALUES ('47920', '北斗镇', '3', '47550', 'B');
INSERT INTO `ey_region` VALUES ('47921', '田尾乡', '3', '47550', 'T');
INSERT INTO `ey_region` VALUES ('47922', '埤头乡', '3', '47550', 'P');
INSERT INTO `ey_region` VALUES ('47923', '溪州乡', '3', '47550', 'X');
INSERT INTO `ey_region` VALUES ('47924', '竹塘乡', '3', '47550', 'Z');
INSERT INTO `ey_region` VALUES ('47925', '二林镇', '3', '47550', 'E');
INSERT INTO `ey_region` VALUES ('47926', '大城乡', '3', '47550', 'D');
INSERT INTO `ey_region` VALUES ('47927', '芳苑乡', '3', '47550', 'F');
INSERT INTO `ey_region` VALUES ('47928', '二水乡', '3', '47550', 'E');
INSERT INTO `ey_region` VALUES ('47929', '莲池区', '3', '1772', 'L');
INSERT INTO `ey_region` VALUES ('47930', '竞秀区', '3', '1772', 'J');
INSERT INTO `ey_region` VALUES ('47931', '常平镇', '3', '29855', 'C');
INSERT INTO `ey_region` VALUES ('47932', '茶山镇', '3', '29855', 'C');
INSERT INTO `ey_region` VALUES ('47933', '大朗镇', '3', '29855', 'D');
INSERT INTO `ey_region` VALUES ('47934', '大岭山镇', '3', '29855', 'D');
INSERT INTO `ey_region` VALUES ('47935', '道滘镇', '3', '29855', 'D');
INSERT INTO `ey_region` VALUES ('47936', '东城街道', '3', '29855', 'D');
INSERT INTO `ey_region` VALUES ('47937', '东坑镇', '3', '29855', 'D');
INSERT INTO `ey_region` VALUES ('47938', '凤岗镇', '3', '29855', 'F');
INSERT INTO `ey_region` VALUES ('47939', '高埗镇', '3', '29855', 'G');
INSERT INTO `ey_region` VALUES ('47940', '莞城街道', '3', '29855', 'G');
INSERT INTO `ey_region` VALUES ('47941', '横沥镇', '3', '29855', 'H');
INSERT INTO `ey_region` VALUES ('47942', '洪梅镇', '3', '29855', 'H');
INSERT INTO `ey_region` VALUES ('47943', '厚街镇', '3', '29855', 'H');
INSERT INTO `ey_region` VALUES ('47944', '黄江镇', '3', '29855', 'H');
INSERT INTO `ey_region` VALUES ('47945', '虎门镇', '3', '29855', 'H');
INSERT INTO `ey_region` VALUES ('47946', '寮步镇', '3', '29855', 'L');
INSERT INTO `ey_region` VALUES ('47947', '麻涌镇', '3', '29855', 'M');
INSERT INTO `ey_region` VALUES ('47948', '南城街道', '3', '29855', 'N');
INSERT INTO `ey_region` VALUES ('47949', '桥头镇', '3', '29855', 'Q');
INSERT INTO `ey_region` VALUES ('47950', '清溪镇', '3', '29855', 'Q');
INSERT INTO `ey_region` VALUES ('47951', '企石镇', '3', '29855', 'Q');
INSERT INTO `ey_region` VALUES ('47952', '沙田镇', '3', '29855', 'S');
INSERT INTO `ey_region` VALUES ('47953', '石碣镇', '3', '29855', 'S');
INSERT INTO `ey_region` VALUES ('47954', '石龙镇', '3', '29855', 'S');
INSERT INTO `ey_region` VALUES ('47955', '石排镇', '3', '29855', 'S');
INSERT INTO `ey_region` VALUES ('47956', '松山湖管委会', '3', '29855', 'S');
INSERT INTO `ey_region` VALUES ('47957', '塘厦镇', '3', '29855', 'T');
INSERT INTO `ey_region` VALUES ('47958', '望牛墩镇', '3', '29855', 'W');
INSERT INTO `ey_region` VALUES ('47959', '万江街道', '3', '29855', 'W');
INSERT INTO `ey_region` VALUES ('47960', '谢岗镇', '3', '29855', 'X');
INSERT INTO `ey_region` VALUES ('47961', '长安镇', '3', '29855', 'Z');
INSERT INTO `ey_region` VALUES ('47962', '樟木头镇', '3', '29855', 'Z');
INSERT INTO `ey_region` VALUES ('47963', '中堂镇', '3', '29855', 'Z');
INSERT INTO `ey_region` VALUES ('47964', '海外', '1', '0', 'H');
INSERT INTO `ey_region` VALUES ('47965', '海外', '2', '47964', 'H');
INSERT INTO `ey_region` VALUES ('47966', '海外', '3', '47965', 'H');
INSERT INTO `ey_region` VALUES ('47968', '吉阳区', '3', '31618', 'J');
INSERT INTO `ey_region` VALUES ('47969', '天涯区', '3', '31618', 'T');
INSERT INTO `ey_region` VALUES ('47970', '崖州区', '3', '31618', 'Y');

-- -----------------------------
-- Table structure for `ey_search_locking`
-- -----------------------------
DROP TABLE IF EXISTS `ey_search_locking`;
CREATE TABLE `ey_search_locking` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `users_id` int(10) DEFAULT '0' COMMENT '用户ID',
  `ip` varchar(20) DEFAULT '' COMMENT 'ip',
  `locking_time` int(11) DEFAULT '0' COMMENT '锁定时间',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='搜索记录锁定表';


-- -----------------------------
-- Table structure for `ey_search_word`
-- -----------------------------
DROP TABLE IF EXISTS `ey_search_word`;
CREATE TABLE `ey_search_word` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `word` varchar(255) DEFAULT '' COMMENT '关键词',
  `searchNum` int(10) DEFAULT '1' COMMENT '搜索次数',
  `resultNum` int(10) DEFAULT '0' COMMENT '搜索结果数量',
  `sort_order` int(10) DEFAULT '0' COMMENT '排序号',
  `users_id` int(11) DEFAULT '0' COMMENT '用户id',
  `ip` varchar(20) DEFAULT '' COMMENT 'ip',
  `is_hot` tinyint(1) DEFAULT '0' COMMENT '是否热搜',
  `lang` varchar(30) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`),
  KEY `word` (`word`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='搜索词统计表';


-- -----------------------------
-- Table structure for `ey_setting`
-- -----------------------------
DROP TABLE IF EXISTS `ey_setting`;
CREATE TABLE `ey_setting` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) DEFAULT '' COMMENT '配置的key键名',
  `value` text,
  `inc_type` varchar(64) DEFAULT '' COMMENT '配置分组',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`),
  KEY `inc_type` (`inc_type`,`lang`)
) ENGINE=MyISAM AUTO_INCREMENT=49 DEFAULT CHARSET=utf8 COMMENT='系统非全局配置表';

-- -----------------------------
-- Records of `ey_setting`
-- -----------------------------
INSERT INTO `ey_setting` VALUES ('1', 'adminlogin_427d1aac31a93d744edd637f1fbbf00c', '0', 'adminlogin', 'cn', '1667470611');
INSERT INTO `ey_setting` VALUES ('2', 'adminlogin_a62896d354440964bb1db242596917b1', '0', 'adminlogin', 'cn', '1667470611');
INSERT INTO `ey_setting` VALUES ('3', 'adminlogin_99ae1cc546e0ed202a83693c75f1afe0', '0', 'adminlogin', 'cn', '1667470611');
INSERT INTO `ey_setting` VALUES ('4', 'ask_ques_steps', '1、写问题标题，描述具体现象。杜绝 “求救，大佬，小白…” 等和问题无关的词汇。\r\n2、选择问题的分类，选择正确的内容分类，能更快的得到其他人的回复。\r\n3、遇到的问题比较急需解决，可以给问题悬赏一定的金额报酬，能让更多同行参与进来出谋策划，从中选择自己心仪的答案。\r\n4、写问题内容详细描述你碰到的困难，写清楚你尝试了什么方法，错误代码，软件的版本等，更容易得到答案。\r\n5、点击发布。', 'ask', 'cn', '1667470612');
INSERT INTO `ey_setting` VALUES ('5', 'admin_logic_1649299958', '1', 'syn', 'cn', '1667470612');
INSERT INTO `ey_setting` VALUES ('6', 'system_old_product_attr', '0', 'system', 'cn', '1667470612');
INSERT INTO `ey_setting` VALUES ('7', 'syn_admin_logic_1625725290', '1', 'syn', 'cn', '1667470612');
INSERT INTO `ey_setting` VALUES ('8', 'syn_admin_logic_1629252424', '1', 'syn', 'cn', '1667470612');
INSERT INTO `ey_setting` VALUES ('9', 'admin_logic_1634204189', '1', 'syn', 'cn', '1667470612');
INSERT INTO `ey_setting` VALUES ('10', 'admin_logic_1634280892', '1', 'syn', 'cn', '1667470612');
INSERT INTO `ey_setting` VALUES ('11', 'admin_logic_1635326854', '1', 'syn', 'cn', '1667470612');
INSERT INTO `ey_setting` VALUES ('12', 'admin_logic_1635389623', '1', 'syn', 'cn', '1667470612');
INSERT INTO `ey_setting` VALUES ('13', 'admin_logic_1636875693', '1', 'syn', 'cn', '1667470612');
INSERT INTO `ey_setting` VALUES ('14', 'admin_logic_1637033990', '1', 'syn', 'cn', '1667470612');
INSERT INTO `ey_setting` VALUES ('15', 'admin_logic_1640918327', '1', 'syn', 'cn', '1667470612');
INSERT INTO `ey_setting` VALUES ('16', 'admin_logic_1638857408', '1', 'syn', 'cn', '1667470612');
INSERT INTO `ey_setting` VALUES ('17', 'admin_logic_1643352860', '2', 'syn', 'cn', '1667470612');
INSERT INTO `ey_setting` VALUES ('18', 'admin_logic_1643352862', '1', 'syn', 'cn', '1667470612');
INSERT INTO `ey_setting` VALUES ('19', 'admin_logic_1643352863', '1', 'syn', 'cn', '1667470612');
INSERT INTO `ey_setting` VALUES ('20', 'security_askanswer_list', '[\"\\u60a8\\u5e38\\u7528\\u7684\\u624b\\u673a\\u53f7\\u7801\\u662f\\uff1f\",\"\\u60a8\\u5e38\\u7528\\u7684\\u7535\\u5b50\\u90ae\\u7bb1\\u662f\\uff1f\",\"\\u60a8\\u771f\\u5b9e\\u7684\\u59d3\\u540d\\u662f\\uff1f\",\"\\u60a8\\u521d\\u4e2d\\u5b66\\u6821\\u540d\\u662f\\uff1f\",\"\\u60a8\\u7684\\u51fa\\u751f\\u5730\\u540d\\u662f\\uff1f\",\"\\u60a8\\u914d\\u5076\\u7684\\u59d3\\u540d\\u662f\\uff1f\",\"\\u60a8\\u7684\\u8eab\\u4efd\\u8bc1\\u53f7\\u540e\\u516b\\u4f4d\\u662f\\uff1f\",\"\\u60a8\\u9ad8\\u4e2d\\u73ed\\u4e3b\\u4efb\\u7684\\u540d\\u5b57\\u662f\\uff1f\",\"\\u60a8\\u521d\\u4e2d\\u73ed\\u4e3b\\u4efb\\u7684\\u540d\\u5b57\\u662f\\uff1f\",\"\\u60a8\\u6700\\u559c\\u6b22\\u7684\\u660e\\u661f\\u540d\\u5b57\\u662f\\uff1f\",\"\\u5bf9\\u60a8\\u5f71\\u54cd\\u6700\\u5927\\u7684\\u4eba\\u540d\\u5b57\\u662f\\uff1f\"]', 'security', 'cn', '1667470612');
INSERT INTO `ey_setting` VALUES ('21', 'admin_logic_1643352864', '1', 'syn', 'cn', '1667470612');
INSERT INTO `ey_setting` VALUES ('22', 'admin_logic_1647918733', '1', 'syn', 'cn', '1667470612');
INSERT INTO `ey_setting` VALUES ('23', 'system_originlist', '[\"\\u7f51\\u7edc\"]', 'system', 'cn', '1667470612');
INSERT INTO `ey_setting` VALUES ('24', 'admin_logic_1648435161', '1', 'syn', 'cn', '1667470612');
INSERT INTO `ey_setting` VALUES ('25', 'admin_logic_1648882158', '1', 'syn', 'cn', '1667470612');
INSERT INTO `ey_setting` VALUES ('26', 'admin_logic_1649399344', '1', 'syn', 'cn', '1667470612');
INSERT INTO `ey_setting` VALUES ('27', 'syn_admin_logic_1616123194', '1', 'syn', 'cn', '1667470612');
INSERT INTO `ey_setting` VALUES ('28', 'admin_logic_1655453263', '1', 'syn', 'cn', '1667470767');
INSERT INTO `ey_setting` VALUES ('29', 'admin_logic_1652254594', '1', 'syn', 'cn', '1667470767');
INSERT INTO `ey_setting` VALUES ('30', 'designated_column_1657069673', '1', 'syn', 'cn', '1667470767');
INSERT INTO `ey_setting` VALUES ('31', 'admin_logic_1652771782', '1', 'syn', 'cn', '1667470767');
INSERT INTO `ey_setting` VALUES ('32', 'syn_admin_logic_1616123195', '1', 'syn', 'cn', '1667470767');
INSERT INTO `ey_setting` VALUES ('33', 'admin_logic_1651114275', '1', 'syn', 'cn', '1667470767');
INSERT INTO `ey_setting` VALUES ('34', 'syn_admin_logic_1661483783', '1', 'syn', 'cn', '1667470767');
INSERT INTO `ey_setting` VALUES ('35', 'admin_logic_1662518904', '1', 'syn', 'cn', '1667470767');
INSERT INTO `ey_setting` VALUES ('36', 'admin_logic_1663290997', '1', 'syn', 'cn', '1667470767');
INSERT INTO `ey_setting` VALUES ('37', 'syn_admin_logic_1660557712', '1', 'syn', 'cn', '1667470768');
INSERT INTO `ey_setting` VALUES ('38', 'system_codelogic_1638857408', '4c8eVVIEAAcBCQUFCAdVUwFTXglWVVEHAApRBgNvF1IBXFYzBW5jdmd/YXR+NDUlAionb2UsZCMJdyRwBX1yMAUxdDAOV3ZhZwh6cAgjMDASVjNgdjB1IzcDJHM0X3siMz16MlNiY290fHFkeV8gJSM5AGlxNHE1HUo3YyN6ZyNSDFU3NGZSYVlvf3NfKyoxM1ohfEQwVDUkaAdzNExjNQ42USYjTGR1d3xhZn00NTUOFCJqXxN4SRYBN0UpB2RfEDgcN1JCSlFDYwJkUFNIJw9aKmJJEVI1U25MUjVeAVAtVnxXLU5ff2JMWmJ8CCgdIFsvfGsPahQHXgZ4MwZFIStQQiovBGprHmhSUX8qUAIdISVUajFoMDdqNlhbdmAzNCVgICN9Y2Vab2ddYig1NlUoNAlXNHUJCnEgZRVuZ1dXJXU3U3dzQH92fQVqNzITVSUxaWk3aCYdZiBDJGxUHlsmdiQjYXJbf31xTXFTNiICJyV+ejVzFk5KCgAtTAcCDAEYEQxeBmYFW2JjAT83AywqN3lYQG0', 'system', 'cn', '1667470844');
INSERT INTO `ey_setting` VALUES ('39', 'admin_logic_1667210674', '1', 'syn', 'cn', '1667470862');
INSERT INTO `ey_setting` VALUES ('40', 'admin_logic_1667357946', '1', 'syn', 'cn', '1667470862');
INSERT INTO `ey_setting` VALUES ('41', 'admin_logic_1673941712', '1', 'syn', 'cn', '1686204252');
INSERT INTO `ey_setting` VALUES ('42', 'admin_logic_1676854942', '1', 'syn', 'cn', '1686204252');
INSERT INTO `ey_setting` VALUES ('43', 'admin_logic_1675243579', '1', 'syn', 'cn', '1686204252');
INSERT INTO `ey_setting` VALUES ('44', 'admin_logic_1677555001', '1', 'syn', 'cn', '1686204252');
INSERT INTO `ey_setting` VALUES ('45', 'admin_logic_1678762367', '1', 'syn', 'cn', '1686204252');
INSERT INTO `ey_setting` VALUES ('46', 'admin_logic_1685584104', '1', 'syn', 'cn', '1686204261');
INSERT INTO `ey_setting` VALUES ('47', 'admin_logic_1682580429', '1', 'syn', 'cn', '1686204261');
INSERT INTO `ey_setting` VALUES ('48', 'admin_logic_1680749290', '1', 'syn', 'cn', '1686204261');

-- -----------------------------
-- Table structure for `ey_sharp_active`
-- -----------------------------
DROP TABLE IF EXISTS `ey_sharp_active`;
CREATE TABLE `ey_sharp_active` (
  `active_id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '活动会场ID',
  `active_date` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '活动日期',
  `status` tinyint(3) unsigned NOT NULL DEFAULT '1' COMMENT '活动状态(0禁用 1启用)',
  `is_del` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '是否删除',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '创建时间',
  `update_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`active_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='整点秒杀-活动会场表';


-- -----------------------------
-- Table structure for `ey_sharp_active_goods`
-- -----------------------------
DROP TABLE IF EXISTS `ey_sharp_active_goods`;
CREATE TABLE `ey_sharp_active_goods` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键ID',
  `active_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '活动会场ID',
  `active_time_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '活动场次ID',
  `aid` int(11) NOT NULL DEFAULT '0' COMMENT '文档id',
  `sharp_goods_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '秒杀商品ID',
  `sales_actual` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '实际销量',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '创建时间',
  `update_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='整点秒杀-活动会场与商品关联表';


-- -----------------------------
-- Table structure for `ey_sharp_active_time`
-- -----------------------------
DROP TABLE IF EXISTS `ey_sharp_active_time`;
CREATE TABLE `ey_sharp_active_time` (
  `active_time_id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '场次ID',
  `active_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '活动会场ID',
  `active_time` tinyint(3) unsigned NOT NULL DEFAULT '1' COMMENT '场次时间(0点-23点)',
  `status` tinyint(3) unsigned NOT NULL DEFAULT '1' COMMENT '活动状态(0禁用 1启用)',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '创建时间',
  `update_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`active_time_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='整点秒杀-活动会场场次表';


-- -----------------------------
-- Table structure for `ey_sharp_goods`
-- -----------------------------
DROP TABLE IF EXISTS `ey_sharp_goods`;
CREATE TABLE `ey_sharp_goods` (
  `sharp_goods_id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '秒杀商品ID',
  `aid` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '商品ID->aid',
  `limit` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '限购数量',
  `seckill_stock` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '秒杀商品库存总量',
  `seckill_price` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '秒杀价格',
  `sales` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '累积销量',
  `virtual_sales` int(11) NOT NULL DEFAULT '0' COMMENT '虚拟销量',
  `sort_order` int(11) unsigned NOT NULL DEFAULT '100' COMMENT '商品排序(数字越小越靠前)',
  `status` tinyint(3) unsigned NOT NULL DEFAULT '1' COMMENT '商品状态(0下架 1上架)',
  `is_del` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '是否删除',
  `is_sku` tinyint(1) NOT NULL DEFAULT '0' COMMENT '1-多规格商品',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '创建时间',
  `update_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`sharp_goods_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='整点秒杀-商品表';


-- -----------------------------
-- Table structure for `ey_sharp_setting`
-- -----------------------------
DROP TABLE IF EXISTS `ey_sharp_setting`;
CREATE TABLE `ey_sharp_setting` (
  `key` varchar(30) NOT NULL DEFAULT '' COMMENT '设置项标示',
  `describe` varchar(255) NOT NULL DEFAULT '' COMMENT '设置项描述',
  `values` mediumtext NOT NULL COMMENT '设置内容(json格式)',
  `update_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  UNIQUE KEY `unique_key` (`key`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='整点秒杀设置表';


-- -----------------------------
-- Table structure for `ey_shop_address`
-- -----------------------------
DROP TABLE IF EXISTS `ey_shop_address`;
CREATE TABLE `ey_shop_address` (
  `addr_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '地址id',
  `users_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '会员id',
  `consignee` varchar(60) NOT NULL DEFAULT '' COMMENT '收货人',
  `country` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '国家',
  `province` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '省份',
  `city` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '城市',
  `district` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '县区',
  `address` varchar(500) NOT NULL DEFAULT '' COMMENT '详细地址',
  `zipcode` varchar(10) NOT NULL DEFAULT '' COMMENT '邮政编码',
  `mobile` varchar(20) NOT NULL DEFAULT '' COMMENT '手机',
  `is_default` tinyint(1) DEFAULT '0' COMMENT '是否默认，0否，1是。',
  `lang` varchar(30) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '添加时间',
  `update_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`addr_id`),
  KEY `users_id` (`users_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='收货地址表';


-- -----------------------------
-- Table structure for `ey_shop_cart`
-- -----------------------------
DROP TABLE IF EXISTS `ey_shop_cart`;
CREATE TABLE `ey_shop_cart` (
  `cart_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '购物车表',
  `users_id` int(10) unsigned DEFAULT '0' COMMENT '会员id',
  `product_id` int(10) unsigned DEFAULT '0' COMMENT '产品id',
  `product_num` int(10) unsigned DEFAULT '0' COMMENT '购买数量',
  `spec_value_id` varchar(100) DEFAULT '' COMMENT '规格值ID',
  `selected` tinyint(1) DEFAULT '1' COMMENT '购物车选中状态：0未选中，1选中',
  `lang` varchar(30) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) DEFAULT '0' COMMENT '加入购物车的时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  `discount_active_id` int(11) DEFAULT '0' COMMENT '限时折扣ID,用来区分购物车的商品哪些是限时折扣活动的',
  PRIMARY KEY (`cart_id`),
  KEY `users_id` (`users_id`,`product_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='购物车表';


-- -----------------------------
-- Table structure for `ey_shop_coupon`
-- -----------------------------
DROP TABLE IF EXISTS `ey_shop_coupon`;
CREATE TABLE `ey_shop_coupon` (
  `coupon_id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `coupon_code` varchar(100) NOT NULL DEFAULT '' COMMENT '优惠券编号',
  `coupon_name` varchar(100) NOT NULL DEFAULT '' COMMENT '优惠券名称',
  `coupon_color` varchar(25) NOT NULL DEFAULT '' COMMENT '优惠券颜色',
  `coupon_form` tinyint(1) NOT NULL DEFAULT '1' COMMENT '优惠券类型 1-满减券',
  `coupon_type` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '可使用商品(1全站通用，2指定商品，3指定商品分类)',
  `product_id` varchar(255) NOT NULL DEFAULT '' COMMENT '指定商品ID，在coupon_type=2时使用',
  `arctype_id` varchar(255) NOT NULL DEFAULT '' COMMENT '指定商品分类ID，在coupon_type=3时使用',
  `coupon_price` decimal(10,0) NOT NULL DEFAULT '0' COMMENT '优惠券金额，例如10',
  `conditions_use` decimal(10,0) NOT NULL DEFAULT '0' COMMENT '优惠券使用条件，例如300',
  `coupon_stock` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '优惠券库存，例如100',
  `redeem_points` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '兑换优惠券所需积分，为0则表示免费兑换',
  `redeem_authority` varchar(10) NOT NULL DEFAULT '' COMMENT '兑换权限，存入多个会员等级组ID',
  `valid_days` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '有效天数，例如30',
  `start_date` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '优惠券开放领取时间',
  `end_date` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '优惠券结束领取时间',
  `sort_order` int(11) unsigned NOT NULL DEFAULT '100' COMMENT '规格排序号',
  `status` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '优惠券状态(0=关闭，1=开启)',
  `use_type` int(1) NOT NULL DEFAULT '1' COMMENT '使用期限 \r\n1-固定日期\r\n 2-领取后当天开始N(valid_days)天内有效\r\n 2-领取后次日开始N(valid_days)天内有效',
  `use_start_time` int(11) NOT NULL COMMENT '使用期限开始时间',
  `use_end_time` int(11) NOT NULL COMMENT '使用期限结束时间',
  `is_del` tinyint(1) DEFAULT '0' COMMENT '0-未删除 1-已删除',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`coupon_id`),
  KEY `product_id` (`product_id`) USING BTREE,
  KEY `arctype_id` (`arctype_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='优惠券主表';


-- -----------------------------
-- Table structure for `ey_shop_coupon_use`
-- -----------------------------
DROP TABLE IF EXISTS `ey_shop_coupon_use`;
CREATE TABLE `ey_shop_coupon_use` (
  `use_id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `users_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '会员ID',
  `coupon_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '优惠券ID',
  `coupon_code` varchar(100) NOT NULL DEFAULT '' COMMENT '优惠券编号',
  `get_ip` varchar(15) NOT NULL DEFAULT '' COMMENT '领取时的IP地址',
  `get_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '优惠券领取时的时间',
  `use_status` tinyint(4) unsigned NOT NULL DEFAULT '1' COMMENT '优惠券使用状态(0未使用，1已使用，2已过期，3已冻结)',
  `use_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '优惠券使用时的时间',
  `start_time` int(10) NOT NULL DEFAULT '0' COMMENT '优惠券有效开始时间',
  `end_time` int(10) NOT NULL DEFAULT '0' COMMENT '优惠券有效结束时间',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`use_id`),
  KEY `coupon_id` (`coupon_id`) USING BTREE,
  KEY `coupon_code` (`coupon_code`) USING BTREE,
  KEY `users_id` (`users_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='优惠券-领取记录表';


-- -----------------------------
-- Table structure for `ey_shop_express`
-- -----------------------------
DROP TABLE IF EXISTS `ey_shop_express`;
CREATE TABLE `ey_shop_express` (
  `express_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增id',
  `express_code` varchar(32) NOT NULL DEFAULT '' COMMENT '物流code',
  `express_name` varchar(32) NOT NULL DEFAULT '' COMMENT '物流名称',
  `express_lnitials` varchar(5) NOT NULL DEFAULT '' COMMENT '首字母',
  `is_choose` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '快递公司是否选中(0=否，1=是)',
  `sort_order` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '排序号',
  `add_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`express_id`)
) ENGINE=MyISAM AUTO_INCREMENT=599 DEFAULT CHARSET=utf8 COMMENT='快递公司表';

-- -----------------------------
-- Records of `ey_shop_express`
-- -----------------------------
INSERT INTO `ey_shop_express` VALUES ('1', 'yuantong', '圆通快递', 'Y', '1', '97', '1553911076', '1554974797');
INSERT INTO `ey_shop_express` VALUES ('2', 'shentong', '申通快递', 'S', '1', '98', '1553911076', '1554974707');
INSERT INTO `ey_shop_express` VALUES ('3', 'shunfeng', '顺丰快递', 'S', '1', '98', '1553911076', '1554974710');
INSERT INTO `ey_shop_express` VALUES ('4', 'yunda', '韵达快递', 'Y', '1', '99', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('5', 'debangwuliu', '德邦快递', 'D', '1', '99', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('6', 'zhongtong', '中通快递', 'Z', '1', '99', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('7', 'huitongkuaidi', '百世快递', 'B', '1', '99', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('8', 'youzhengguonei', '邮政包裹', 'Y', '1', '99', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('9', 'ems', 'EMS', 'E', '1', '99', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('10', 'youzhengguoji', '邮政国际', 'Y', '1', '99', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('11', 'aolau', 'AOL澳通速递', 'A', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('12', 'a2u', 'A2U速递', 'A', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('13', 'aae', 'AAE快递', 'A', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('14', 'annengwuliu', '安能物流', 'A', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('15', 'anxl', '安迅物流', 'A', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('16', 'auexpress', '澳邮中国快运', 'A', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('17', 'exfresh', '安鲜达', 'A', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('18', 'anjie88', '安捷物流', 'A', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('19', 'adodoxm', '澳多多国际速递', 'A', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('20', 'ariesfar', '艾瑞斯远', 'A', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('21', 'qdants', 'ANTS EXPRESS', 'A', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('22', 'astexpress', '安世通快递', 'A', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('23', 'gda', '安的快递', 'A', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('24', 'ausexpress', '澳世速递', 'A', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('25', 'ibuy8', '爱拜物流', 'A', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('26', 'aplusex', 'Aplus物流', 'A', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('27', 'adapost', '安达速递', 'A', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('28', 'adiexpress', '安达易国际速递', 'A', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('29', 'maxeedexpress', '澳洲迈速快递', 'A', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('30', 'onway', '昂威物流', 'A', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('31', 'bcwelt', 'BCWELT', 'B', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('32', 'balunzhi', '巴伦支快递', 'B', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('33', 'xiaohongmao', '北青小红帽', 'B', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('34', 'bfdf', '百福东方物流', 'B', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('35', 'bangsongwuliu', '邦送物流', 'B', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('36', 'lbbk', '宝凯物流', 'B', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('37', 'bqcwl', '百千诚物流', 'B', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('38', 'idada', '百成大达物流', 'B', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('39', 'baishiwuliu', '百世快运', 'B', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('40', 'baitengwuliu', '百腾物流', 'B', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('41', 'birdex', '笨鸟海淘', 'B', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('42', 'bsht', '百事亨通', 'B', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('43', 'benteng', '奔腾物流', 'B', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('44', 'cuckooexpess', '布谷鸟速递', 'B', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('45', 'bgky100', '邦工快运', 'B', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('46', 'bosind', '堡昕德速递', 'B', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('47', 'banma', '斑马物联网', 'B', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('48', 'polarisexpress', '北极星快运', 'B', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('49', 'beijingfengyue', '北京丰越供应链', 'B', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('50', 'europe8', '败欧洲', 'B', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('51', 'bmlchina', '标杆物流', 'B', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('52', 'comexpress', '邦通国际', 'B', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('53', 'baotongkd', '宝通快递', 'B', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('54', 'beckygo', '佰麒快递', 'B', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('55', 'boyol', '贝业物流', 'B', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('56', 'bdatong', '八达通快递', 'B', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('57', 'bangbangpost', '帮帮发', 'B', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('58', 'baoxianda', '报通快递', 'B', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('59', 'coe', '中国东方(COE)', 'Z', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('60', 'cloudexpress', 'CE易欧通国际速递', 'C', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('61', 'city100', '城市100', 'C', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('62', 'chuanxiwuliu', '传喜物流', 'C', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('63', 'chengjisudi', '城际速递', 'C', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('64', 'lijisong', '立即送', 'L', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('65', 'chukou1', '出口易', 'C', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('66', 'nanjingshengbang', '晟邦物流', 'C', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('67', 'flyway', '程光快递', 'C', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('68', 'cbo56', '钏博物流', 'C', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('69', 'cex', '城铁速递', 'C', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('70', 'cnup', 'CNUP 中联邮', 'C', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('71', 'clsp', 'CL日中速运', 'C', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('72', 'cnair', 'CNAIR', 'C', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('73', 'cangspeed', '仓鼠快递', 'C', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('74', 'spring56', '春风物流', 'C', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('75', 'cunto', '村通快递', 'C', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('76', 'longvast', '长风物流', 'C', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('77', 'changjiang', '长江国际速递', 'C', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('78', 'cncexp', 'C&C国际速递', 'C', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('79', 'parcelchina', '诚一物流', 'C', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('80', 'chengtong', '城通物流', 'C', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('81', 'otpexpress', '承诺达', 'C', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('82', 'sfpost', '曹操到', 'C', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('83', 'changwooair', '昌宇国际', 'C', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('84', 'dhl', 'DHL快递（中国件）', 'D', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('85', 'dhlen', 'DHL（国际件）', 'D', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('86', 'dhlde', 'DHL（德国件）', 'D', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('87', 'dtwl', '大田物流', 'D', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('88', 'disifang', '递四方', 'D', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('89', 'dayangwuliu', '大洋物流', 'D', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('90', 'dechuangwuliu', '德创物流', 'D', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('91', 'dskd', 'D速物流', 'D', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('92', 'donghanwl', '东瀚物流', 'D', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('93', 'dfpost', '达方物流', 'D', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('94', 'dongjun', '东骏快捷物流', 'D', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('95', 'dindon', '叮咚澳洲转运', 'D', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('96', 'dazhong', '大众佐川急便', 'D', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('97', 'ahdf', '德方物流', 'D', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('98', 'dehaoyi', '德豪驿', 'D', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('99', 'dhlpaket', 'DHL Paket', 'D', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('100', 'ubuy', '德国优拜物流', 'D', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('101', 'adlerlogi', '德国雄鹰速递', 'D', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('102', 'yunexpress', '德国云快递', 'D', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('103', 'di5pll', '递五方云仓', 'D', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('104', 'deguo8elog', '德国八易转运', 'D', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('105', 'camekong', '到了港', 'D', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('106', 'dbstation', 'db-station', 'D', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('107', 'dadaoex', '大道物流', 'D', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('108', 'dekuncn', '德坤物流', 'D', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('109', 'twkd56', '缔惠盛合', 'D', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('110', 'gslexpress', '德尚国际速递', 'D', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('111', 'eucpost', '德国 EUC POST', 'D', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('112', 'est365', '东方汇', 'D', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('113', 'ecotransite', '东西E全运', 'D', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('114', 'euexpress', 'EU-EXPRESS', 'E', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('115', 'emsguoji', 'EMS国际快递查询', 'E', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('116', 'eshunda', '俄顺达', 'E', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('117', 'ewe', 'EWE全球快递', 'E', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('118', 'easyexpress', 'EASYEXPRESS国际速递', 'E', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('119', 'edtexpress', 'e直运', 'E', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('120', 'ecallturn', 'E跨通', 'E', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('121', 'fedex', 'FedEx快递查询', 'F', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('122', 'fedexus', 'FedEx（美国）', 'F', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('123', 'fox', 'FOX国际速递', 'F', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('124', 'rufengda', '如风达快递', 'R', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('125', 'fkd', '飞康达物流', 'F', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('126', 'feibaokuaidi', '飞豹快递', 'F', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('127', 'fandaguoji', '颿达国际', 'F', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('128', 'feiyuanvipshop', '飞远配送', 'F', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('129', 'hnfy', '飞鹰物流', 'F', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('130', 'fengxingtianxia', '风行天下', 'F', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('131', 'flysman', '飞力士物流', 'F', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('132', 'fbkd', '飞邦快递', 'F', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('133', 'sccod', '丰程物流', 'F', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('134', 'crazyexpress', '疯狂快递', 'F', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('135', 'ftlexpress', '法翔速运', 'F', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('136', 'ftd', '富腾达快递', 'F', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('137', 'arkexpress', '方舟国际速递', 'F', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('138', 'fedroad', 'FedRoad 联邦转运', 'F', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('139', 'freakyquick', 'FQ狂派速递', 'F', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('140', 'fecobv', '丰客物流', 'F', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('141', 'fyex', '飞云快递系统', 'F', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('142', 'beebird', '锋鸟物流', 'F', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('143', 'shipgce', '飞洋快递', 'F', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('144', 'koali', '番薯国际货运', 'F', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('145', 'epanex', '泛捷国际速递', 'F', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('146', 'gaticn', 'GATI快递', 'G', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('147', 'gts', 'GTS快递', 'G', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('148', 'guotongkuaidi', '国通快递', 'G', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('149', 'ndkd', '能达速递', 'N', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('150', 'gongsuda', '共速达', 'G', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('151', 'gtongsudi', '广通速递（山东）', 'G', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('152', 'suteng', '速腾物流', 'S', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('153', 'gdkd', '港快速递', 'G', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('154', 'hre', '高铁速递', 'G', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('155', 'gscq365', '哥士传奇速递', 'G', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('156', 'gjwl', '冠捷物流', 'G', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('157', 'xdshipping', '国晶物流', 'G', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('158', 'ge2d', 'GE2D跨境物流', 'G', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('159', 'gaotieex', '高铁快运', 'G', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('160', 'gansuandi', '甘肃安的快递', 'G', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('161', 'gdct56', '广东诚通物流', 'G', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('162', 'ghtexpress', 'GHT物流', 'G', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('163', 'goldjet', '高捷快运', 'G', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('164', 'gtgogo', 'GT国际快运', 'G', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('165', 'gxwl', '光线速递', 'G', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('166', 'tdhy', '华宇物流', 'H', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('167', 'hl', '恒路物流', 'H', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('168', 'hlyex', '好来运快递', 'H', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('169', 'hebeijianhua', '河北建华', 'H', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('170', 'huaqikuaiyun', '华企快运', 'H', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('171', 'haosheng', '昊盛物流', 'H', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('172', 'hutongwuliu', '户通物流', 'H', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('173', 'hzpl', '华航快递', 'H', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('174', 'huangmajia', '黄马甲快递', 'H', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('175', 'ucs', '合众速递（UCS）', 'H', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('176', 'pfcexpress', '皇家物流', 'H', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('177', 'huoban', '伙伴物流', 'H', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('178', 'nedahm', '红马速递', 'H', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('179', 'huiwen', '汇文配送', 'H', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('180', 'nmhuahe', '华赫物流', 'H', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('181', 'hjs', '猴急送', 'H', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('182', 'hangyu', '航宇快递', 'H', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('183', 'huilian', '辉联物流', 'H', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('184', 'huanqiu', '环球速运', 'H', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('185', 'htwd', '华通务达物流', 'H', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('186', 'hipito', '海派通', 'H', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('187', 'hqtd', '环球通达', 'H', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('188', 'airgtc', '航空快递', 'H', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('189', 'haoyoukuai', '好又快物流', 'H', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('190', 'ccd', '河南次晨达', 'H', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('191', 'hfwuxi', '和丰同城', 'H', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('192', 'higo', '黑狗物流', 'H', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('193', 'hyytes', '恒宇运通', 'H', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('194', 'hengrui56', '恒瑞物流', 'H', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('195', 'hangrui', '上海航瑞货运', 'S', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('196', 'ghl', '环创物流', 'H', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('197', 'hnqst', '河南全速通', 'H', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('198', 'hitaoe', 'Hi淘易快递', 'H', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('199', 'hhair56', '华瀚快递', 'H', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('200', 'haimibuy', '海米派物流', 'H', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('201', 'ht22', '海淘物流', 'H', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('202', 'hivewms', '海沧无忧', 'H', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('203', 'hnht56', '鸿泰物流', 'H', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('204', 'hsgtsd', '海硕高铁速递', 'H', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('205', 'hltop', '海联快递', 'H', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('206', 'hlkytj', '互联快运', 'H', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('207', 'haidaibao', '海带宝转运', 'H', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('208', 'flowerkd', '花瓣转运', 'H', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('209', 'heimao56', '黑猫速运', 'H', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('210', 'logistics', '華信物流WTO', 'H', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('211', 'hgy56', '环国运物流', 'H', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('212', 'iparcel', 'i-parcel', 'I', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('213', 'jjwl', '佳吉物流', 'J', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('214', 'jywl', '佳怡物流', 'J', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('215', 'jymwl', '加运美快递', 'J', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('216', 'jxd', '急先达物流', 'J', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('217', 'jgsd', '京广速递快件', 'J', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('218', 'jykd', '晋越快递', 'J', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('219', 'jd', '京东物流', 'J', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('220', 'jietekuaidi', '捷特快递', 'J', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('221', 'jiuyicn', '久易快递', 'J', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('222', 'jiuyescm', '九曳供应链', 'J', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('223', 'junfengguoji', '骏丰国际速递', 'J', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('224', 'jiajiatong56', '佳家通', 'J', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('225', 'jrypex', '吉日优派', 'J', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('226', 'jinchengwuliu', '锦程国际物流', 'J', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('227', 'jgwl', '景光物流', 'J', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('228', 'pzhjst', '急顺通', 'J', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('229', 'ruexp', '捷网俄全通', 'J', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('230', 'jialidatong', '嘉里大通', 'J', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('231', 'jmjss', '金马甲', 'J', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('232', 'jiacheng', '佳成快递', 'J', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('233', 'jsexpress', '骏绅物流', 'J', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('234', 'hrex', '锦程快递', 'J', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('235', 'jieanda', '捷安达国际速递', 'J', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('236', 'newsway', '家家通快递', 'J', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('237', 'mapleexpress', '今枫国际快运', 'J', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('238', 'jixiangyouau', '吉祥邮（澳洲）', 'J', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('239', 'jjx888', '佳捷翔物流', 'J', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('240', 'polarexpress', '极地快递', 'J', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('241', 'jiazhoumao', '加州猫速递', 'J', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('242', 'juzhongda', '聚中大', 'J', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('243', 'jieborne', '捷邦物流', 'J', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('244', 'jxfex', '集先锋速递', 'J', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('245', 'jiugong', '九宫物流', 'J', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('246', 'jiujiuwl', '久久物流', 'J', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('247', 'jintongkd', '劲通快递', 'J', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('248', 'jcsuda', '嘉诚速达', 'J', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('249', 'jingshun', '景顺物流', 'J', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('250', 'fastontime', '加拿大联通快运', 'J', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('251', 'khzto', '柬埔寨中通', 'J', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('252', 'kjkd', '快捷快递', 'K', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('253', 'kangliwuliu', '康力物流', 'K', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('254', 'kuayue', '跨越速运', 'K', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('255', 'kuaiyouda', '快优达速递', 'K', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('256', 'happylink', '开心快递', 'K', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('257', 'ksudi', '快速递', 'K', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('258', 'kyue', '跨跃国际', 'K', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('259', 'kfwnet', '快服务', 'K', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('260', 'kuai8', '快8速运', 'K', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('261', 'kuaidawuliu', '快达物流', 'K', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('262', 'lianb', '联邦快递（国内）', 'L', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('263', 'lhtwl', '联昊通物流', 'L', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('264', 'lb', '龙邦速递', 'L', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('265', 'lejiedi', '乐捷递', 'L', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('266', 'lanhukuaidi', '蓝弧快递', 'L', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('267', 'ltexp', '乐天速递', 'L', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('268', 'lutong', '鲁通快运', 'L', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('269', 'ledii', '乐递供应链', 'L', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('270', 'lundao', '论道国际物流', 'L', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('271', 'lasy56', '林安物流', 'L', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('272', 'lsexpress', '6LS EXPRESS', 'L', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('273', 'szuem', '联运通物流', 'L', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('274', 'blueskyexpress', '蓝天国际航空快递', 'L', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('275', 'lfexpress', '龙枫国际速递', 'L', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('276', 'gslhkd', '联合快递', 'L', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('277', 'longfx', '龙飞祥快递', 'L', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('278', 'luben', '陆本速递 LUBEN EXPRESS', 'L', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('279', 'unitedex', '联合速运', 'L', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('280', 'lbex', '龙邦物流', 'L', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('281', 'ltparcel', '联通快递', 'L', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('282', 'macroexpressco', 'ME物流', 'M', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('283', 'mh', '民航快递', 'M', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('284', 'meiguokuaidi', '美国快递', 'M', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('285', 'menduimen', '门对门', 'M', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('286', 'mingliangwuliu', '明亮物流', 'M', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('287', 'minbangsudi', '民邦速递', 'M', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('288', 'minshengkuaidi', '闽盛快递', 'M', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('289', 'yundaexus', '美国韵达', 'M', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('290', 'mchy', '木春货运', 'M', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('291', 'meiquick', '美快国际物流', 'M', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('292', 'valueway', '美通快递', 'M', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('293', 'cnmcpl', '马珂博逻', 'M', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('294', 'mailongdy', '迈隆递运', 'M', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('295', 'zsmhwl', '明辉物流', 'M', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('296', 'mosuda', '魔速达', 'M', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('297', 'meibang', '美邦国际快递', 'M', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('298', 'nuoyaao', '偌亚奥国际', 'N', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('299', 'nuoer', '诺尔国际物流', 'N', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('300', 'nell', '尼尔快递', 'N', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('301', 'ndwl', '南方传媒物流', 'N', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('302', 'canhold', '能装能送', 'N', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('303', 'wanjiatong', '宁夏万家通', 'N', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('304', 'nlebv', '欧亚专线', 'O', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('305', 'oborexpress', 'OBOR Express', 'O', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('306', 'pcaexpress', 'PCA Express', 'P', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('307', 'pingandatengfei', '平安达腾飞', 'P', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('308', 'peixingwuliu', '陪行物流', 'P', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('309', 'pengyuanexpress', '鹏远国际速递', 'P', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('310', 'postelbe', 'PostElbe', 'P', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('311', 'papascm', '啪啪供应链', 'P', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('312', 'bazirim', '皮牙子快递', 'P', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('313', 'qfkd', '全峰快递', 'Q', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('314', 'qy', '全一快递', 'Q', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('315', 'qrt', '全日通快递', 'Q', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('316', 'qckd', '全晨快递', 'Q', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('317', 'sevendays', '7天连锁物流', 'Q', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('318', 'qbexpress', '秦邦快运', 'Q', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('319', 'quanxintong', '全信通快递', 'Q', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('320', 'quansutong', '全速通国际快递', 'Q', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('321', 'qinyuan', '秦远物流', 'Q', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('322', 'qichen', '启辰国际物流', 'Q', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('323', 'quansu', '全速快运', 'Q', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('324', 'qzx56', '全之鑫物流', 'Q', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('325', 'qskdyxgs', '千顺快递', 'Q', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('326', 'zqlwl', '青旅物流', 'Q', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('327', 'quanchuan56', '全川物流', 'Q', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('328', 'quantwl', '全通快运', 'Q', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('329', 'yatexpress', '乾坤物流', 'Q', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('330', 'guexp', '全联速运', 'Q', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('331', 'bjqywl', '青云物流', 'Q', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('332', 'signedexpress', '签收快递', 'Q', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('333', 'express7th', '7号速递', 'Q', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('334', 'riyuwuliu', '日昱物流', 'R', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('335', 'rfsd', '瑞丰速递', 'R', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('336', 'rrs', '日日顺物流', 'R', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('337', 'rytsd', '日益通速递', 'R', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('338', 'rrskx', '日日顺快线', 'R', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('339', 'gdrz58', '容智快运', 'R', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('340', 'rrthk', '日日通国际', 'R', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('341', 'homecourier', '如家国际快递', 'R', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('342', 'sewl', '速尔快递', 'S', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('343', 'haihongwangsong', '山东海红', 'S', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('344', 'sh', '盛辉物流', 'S', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('345', 'sfwl', '盛丰物流', 'S', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('346', 'shiyunkuaidi', '世运快递', 'S', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('347', 'shangda', '上大物流', 'S', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('348', 'stsd', '三态速递', 'S', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('349', 'saiaodi', '赛澳递', 'S', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('350', 'ewl', '申通E物流', 'S', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('351', 'shenganwuliu', '圣安物流', 'S', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('352', 'sxhongmajia', '山西红马甲', 'S', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('353', 'suijiawuliu', '穗佳物流', 'S', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('354', 'syjiahuier', '沈阳佳惠尔', 'S', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('355', 'shlindao', '上海林道货运', 'S', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('356', 'sfift', '十方通物流', 'S', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('357', 'shunjiefengda', '顺捷丰达', 'S', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('358', 'subida', '速必达物流', 'S', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('359', 'stcd', '速通成达物流', 'S', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('360', 'stkd', '顺通快递', 'S', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('361', 'sendtochina', '速递中国', 'S', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('362', 'sihaiet', '四海快递', 'S', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('363', 'staky', '首通快运', 'S', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('364', 'hnssd56', '顺时达物流', 'S', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('365', 'superb', 'Superb Grace', 'S', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('366', 'sfjhd', '圣飞捷快递', 'S', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('367', 'sofast56', '嗖一下同城快递', 'S', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('368', 's2c', 'S2C', 'S', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('369', 'chinasqk', 'SQK国际速递', 'S', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('370', 'shunshid', '顺士达速运', 'S', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('371', 'synship', 'SYNSHIP快递', 'S', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('372', 'shandiantu', '闪电兔', 'S', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('373', 'sdsy888', '首达速运', 'S', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('374', 'sczpds', '速呈宅配', 'S', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('375', 'sureline', 'Sureline冠泰', 'S', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('376', 'stosolution', '申通国际', 'S', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('377', 'sycawl', '狮爱高铁物流', 'S', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('378', 'sxexpress', '三象速递', 'S', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('379', 'shangqiao56', '商桥物流', 'S', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('380', 'shd56', '商海德物流', 'S', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('381', 'shenma', '神马快递', 'S', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('382', 'sihiexpress', '四海捷运', 'S', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('383', 'superoz', '速配鸥翼', 'S', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('384', 'fastgoexpress', '速派快递', 'S', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('385', 'zjstky', '苏通快运', 'S', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('386', 'suning', '苏宁物流', 'S', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('387', 'shaoke', '捎客物流', 'S', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('388', 'sdto', '速达通跨境物流', 'S', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('389', 'sut56', '速通物流', 'S', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('390', 'sundarexpress', '顺达快递', 'S', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('391', 'sxjdfreight', '顺心捷达', 'S', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('392', 'shengtongscm', '盛通快递', 'S', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('393', 'tnt', 'TNT快递', 'T', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('394', 'tt', '天天快递', 'T', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('395', 'tianzong', '天纵物流', 'T', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('396', 'chinatzx', '同舟行物流', 'T', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('397', 'nntengda', '腾达速递', 'T', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('398', 'sd138', '泰国138', 'T', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('399', 'tongdaxing', '通达兴物流', 'T', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('400', 'tlky', '天联快运', 'T', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('401', 'ibenben', '途鲜物流', 'T', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('402', 'krtao', '淘韩国际快递', 'T', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('403', 'lntjs', '特急送', 'T', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('404', 'tny', 'TNY物流', 'T', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('405', 'djy56', '天翔东捷运', 'T', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('406', 'guoeryue', '天天快物流', 'T', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('407', 'tianma', '天马迅达', 'T', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('408', 'surpassgo', '天越物流', 'T', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('409', 'tianxiang', '天翔快递', 'T', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('410', 'tywl99', '天翼物流', 'T', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('411', 'shpost', '同城快寄', 'T', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('412', 'humpline', '驼峰国际', 'T', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('413', 'transrush', 'TransRush', 'T', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('414', 'tstexp', 'TST速运通', 'T', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('415', 'ctoexp', '泰国中通CTO', 'T', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('416', 'thaizto', '泰国中通ZTO', 'T', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('417', 'tswlcloud', '天使物流云', 'T', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('418', 'tzky', '铁中快运', 'T', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('419', 'tcxbthai', 'TCXB国际物流', 'T', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('420', 'taimek', '天美快递', 'T', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('421', 'taoplus', '淘布斯国际物流', 'T', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('422', 'ups', 'UPS快递查询', 'U', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('423', 'yskd', '优速快递', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('424', 'usps', 'USPS美国邮政', 'U', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('425', 'ueq', 'UEQ快递', 'U', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('426', 'uex', 'UEX国际物流', 'U', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('427', 'utaoscm', 'UTAO 优到', 'U', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('428', 'wxwl', '万象物流', 'W', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('429', 'weitepai', '微特派', 'W', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('430', 'wjwl', '万家物流', 'W', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('431', 'wanboex', '万博快递', 'W', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('432', 'wtdchina', '威时沛运', 'W', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('433', 'wzhaunyun', '微转运', 'W', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('434', 'gswtkd', '万通快递', 'W', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('435', 'wandougongzhu', '豌豆物流', 'W', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('436', 'wjkwl', '万家康物流', 'W', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('437', 'vps', '维普恩物流', 'W', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('438', 'wykjt', '51跨境通', 'W', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('439', 'wherexpess', '威盛快递', 'W', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('440', 'weilaimingtian', '未来明天快递', 'W', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('441', 'wdm', '万达美', 'W', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('442', 'wto56kj', '温通物流', 'W', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('443', '56kuaiyun', '五六快运', 'W', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('444', 'wowvip', '沃埃家', 'W', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('445', 'grivertek', '潍鸿', 'W', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('446', 'xbwl', '新邦物流', 'X', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('447', 'xfwl', '信丰物流', 'X', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('448', 'newegg', '新蛋物流', 'X', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('449', 'xianglongyuntong', '祥龙运通物流', 'X', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('450', 'xianchengliansudi', '西安城联速递', 'X', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('451', 'xilaikd', '喜来快递', 'X', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('452', 'xsrd', '鑫世锐达', 'X', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('453', 'xtb', '鑫通宝物流', 'X', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('454', 'xintianjie', '信天捷快递', 'X', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('455', 'xaetc', '西安胜峰', 'X', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('456', 'xianfeng', '先锋快递', 'X', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('457', 'sunspeedy', '新速航', 'X', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('458', 'xipost', '西邮寄', 'X', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('459', 'sinatone', '信联通', 'X', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('460', 'sunjex', '新杰物流', 'X', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('461', 'alog', '心怡物流', 'X', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('462', 'csxss', '新时速物流', 'X', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('463', 'xiangteng', '翔腾物流', 'X', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('464', 'westwing', '西翼物流', 'X', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('465', 'littlebearbear', '小熊物流', 'X', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('466', 'huanqiuabc', '中国香港环球快运', 'Z', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('467', 'xinning', '新宁物流', 'X', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('468', 'wlwex', '星空国际', 'X', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('469', 'yyexp', '西安运逸快递', 'X', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('470', 'xiyoug', '西游寄', 'X', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('471', 'xlobo', 'xLobo', 'X', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('472', 'xunsuexpress', '迅速快递', 'X', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('473', 'whgjkd', '香港伟豪国际物流', 'X', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('474', 'xyd666', '鑫远东速运', 'X', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('475', 'xdexpress', '迅达速递', 'X', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('476', 'ytkd', '运通快递', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('477', 'ycwl', '远成物流', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('478', 'yfsd', '亚风速递', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('479', 'yishunhang', '亿顺航', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('480', 'yfwl', '越丰物流', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('481', 'yad', '源安达快递', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('482', 'yfh', '原飞航物流', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('483', 'yinjiesudi', '银捷速递', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('484', 'yitongfeihong', '一统飞鸿', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('485', 'yuxinwuliu', '宇鑫物流', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('486', 'yitongda', '易通达', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('487', 'youbijia', '邮必佳', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('488', 'yiqiguojiwuliu', '一柒物流', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('489', 'yinsu', '音素快运', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('490', 'yilingsuyun', '亿领速运', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('491', 'yujiawuliu', '煜嘉物流', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('492', 'gml', '英脉物流', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('493', 'leopard', '云豹国际货运', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('494', 'czwlyn', '云南中诚', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('495', 'sdyoupei', '优配速运', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('496', 'yongchang', '永昌物流', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('497', 'yufeng', '御风速运', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('498', 'yousutongda', '优速通达', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('499', 'yongwangda', '永旺达快递', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('500', 'yingchao', '英超物流', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('501', 'edlogistics', '益递物流', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('502', 'yjxlm', '宜家行', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('503', 'onehcang', '一号仓', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('504', 'ycgky', '远成快运', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('505', 'yunfeng56', '韵丰物流', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('506', 'iyoungspeed', '驿扬国际速运', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('507', 'zgyzt', '一站通快递', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('508', 'eupackage', '易优包裹', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('509', 'ydglobe', '云达通', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('510', 'el56', 'YLTD', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('511', 'yundx', '运东西', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('512', 'yangbaoguo', '洋包裹', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('513', 'uluckex', '优联吉运', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('514', 'ecmscn', '易客满', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('515', 'ubonex', '优邦速运', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('516', 'yue777', '玥玛速运', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('517', 'ywexpress', '远为快递', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('518', 'ezhuanyuan', '易转运', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('519', 'yiqisong', '一起送', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('520', 'yongbangwuliu', '永邦国际物流', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('521', 'yyox', '邮客全球速递', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('522', 'yihangmall', '易航物流', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('523', 'yiouzhou', '易欧洲国际物流', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('524', 'ykouan', '洋口岸', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('525', 'youyou', '优优速递', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('526', 'ytky168', '运通快运', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('527', 'sixroad', '易普递', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('528', 'yourscm', '雅澳物流', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('529', 'euguoji', '易邮国际', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('530', 'uscbexpress', '易境达国际物流', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('531', 'yfsuyun', '驭丰速运', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('532', 'yimidida', '壹米滴答', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('533', 'ugoexpress', '邮鸽速运', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('534', 'youban', '邮邦国际', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('535', 'hkems', '云邮跨境快递', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('536', 'youlai', '邮来速递', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('537', 'eta100', '易达国际速递', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('538', 'yatfai', '一辉物流', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('539', 'yzswuliu', '亚洲顺物流', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('540', 'yifankd', '艺凡快递', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('541', 'mantoo', '优能物流', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('542', 'vctrans', '越中国际物流', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('543', 'yhtlogistics', '宇航通物流', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('544', 'ycgglobal', 'YCG物流', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('545', 'yidihui', '驿递汇速递', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('546', 'yuanhhk', '远航国际快运', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('547', 'yiyou', '易邮速运', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('548', 'eusacn', '优莎速运', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('549', 'uhi', '优海国际速递', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('550', 'zjs', '宅急送', 'Z', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('551', 'ztky', '中铁快运', 'Z', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('552', 'ztwl', '中铁物流', 'Z', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('553', 'zywl', '中邮物流', 'Z', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('554', 'zhimakaimen', '芝麻开门', 'Z', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('555', 'zhengzhoujianhua', '郑州建华', 'Z', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('556', 'zhongsukuaidi', '中速快件', 'Z', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('557', 'zhongtianwanyun', '中天万运', 'Z', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('558', 'zhongruisudi', '中睿速递', 'Z', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('559', 'zhongwaiyun', '中外运速递', 'Z', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('560', 'zengyisudi', '增益速递', 'Z', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('561', 'sujievip', '郑州速捷', 'Z', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('562', 'ztong', '智通物流', 'Z', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('563', 'zhichengtongda', '至诚通达快递', 'Z', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('564', 'zhdwl', '众辉达物流', 'Z', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('565', 'kuachangwuliu', '直邮易', 'Z', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('566', 'topspeedex', '中运全速', 'Z', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('567', 'otobv', '中欧快运', 'Z', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('568', 'zsky123', '准实快运', 'Z', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('569', 'cnws', '中国翼', 'Z', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('570', 'zytdscm', '中宇天地', 'Z', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('571', 'zhuanyunsifang', '转运四方', 'Z', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('572', 'hrbzykd', '卓烨快递', 'Z', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('573', 'zhuoshikuaiyun', '卓实快运', 'Z', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('574', 'chinaicip', '卓志速运', 'Z', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('575', 'ynztsy', '纵通速运', 'Z', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('576', 'zdepost', '直德邮', 'Z', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('577', 'chinapostcb', '中邮电商', 'Z', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('578', 'chunghwa56', '中骅物流', 'Z', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('579', 'cosco', '中远e环球', 'Z', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('580', 'zf365', '珠峰速运', 'Z', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('581', 'zhongtongkuaiyun', '中通快运', 'Z', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('582', 'eucnrail', '中欧国际物流', 'Z', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('583', 'chnexp', '中翼国际物流', 'Z', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('584', 'cccc58', '中集冷云', 'Z', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('585', 'auvanda', '中联速递', 'Z', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('586', 'zyzoom', '增速跨境', 'Z', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('587', 'zhpex', '众派速递', 'Z', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('588', 'byht', '展勤快递', 'Z', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('589', 'zhongchuan', '众川国际', 'Z', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('590', 'zhonghuanus', '中环转运', 'Z', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('591', 'zhonghuan', '中环快递', 'Z', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('592', 'uszcn', '转运中国', 'Z', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('593', 'zhitengwuliu', '志腾物流', 'Z', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('594', 'zsda56', '转瞬达集运', 'Z', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('595', 'zjgj56', '振捷国际货运', 'Z', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('596', 'jtexpress', '极兔速递', 'J', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('598', 'fengwang', '丰网速运', 'F', '1', '100', '1553911076', '1647484768');

-- -----------------------------
-- Table structure for `ey_shop_order`
-- -----------------------------
DROP TABLE IF EXISTS `ey_shop_order`;
CREATE TABLE `ey_shop_order` (
  `order_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '订单id',
  `order_code` varchar(50) NOT NULL DEFAULT '' COMMENT '订单编号',
  `users_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '会员id',
  `merchant_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '多商家ID',
  `order_status` tinyint(1) NOT NULL DEFAULT '0' COMMENT '订单状态：0未付款(已下单)，1已付款(待发货)，2已发货(待收货)，3已完成(确认收货)，-1订单取消(已关闭)，4订单过期',
  `payment_method` tinyint(1) DEFAULT '0' COMMENT '订单支付方式，0为在线支付，1为货到付款，默认0',
  `pay_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '支付时间',
  `pay_name` varchar(20) NOT NULL DEFAULT '' COMMENT '支付方式名称',
  `wechat_pay_type` varchar(20) NOT NULL DEFAULT '' COMMENT '微信支付时，标记使用的支付类型（扫码支付，微信内部，微信H5页面）',
  `order_terminal` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '订单终端(1=电脑端、2=手机端、3微信小程序)',
  `contains_virtual` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '订单是否包含虚拟商品(1=不包含、2=包含)',
  `manual_refund` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '订单是否被手动关闭并退款',
  `refund_note` varchar(500) NOT NULL DEFAULT '' COMMENT '订单手动退款原因',
  `pay_details` text COMMENT '支付时返回的数据，以serialize序列化后存入，用于后续查询。',
  `express_order` varchar(50) DEFAULT '' COMMENT '发货物流单号',
  `express_name` varchar(32) DEFAULT '' COMMENT '发货物流名称',
  `express_code` varchar(32) DEFAULT '' COMMENT '发货物流code',
  `express_time` int(11) DEFAULT '0' COMMENT '发货时间',
  `consignee` varchar(30) NOT NULL DEFAULT '' COMMENT '收货人',
  `confirm_time` int(11) DEFAULT '0' COMMENT '收货确认时间',
  `allow_service` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '订单是否允许申请售后维权，0=允许申请维权，1=不允许申请维权',
  `obtain_scores` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '消费获得积分数',
  `is_obtain_scores` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '该订单是否已赠送积分，0=未赠送，1=已赠送',
  `shipping_fee` decimal(10,2) DEFAULT '0.00' COMMENT '订单运费',
  `order_total_amount` decimal(10,2) DEFAULT '0.00' COMMENT '订单总价',
  `order_amount` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '应付款金额',
  `order_total_num` int(10) DEFAULT '0' COMMENT '订单总数',
  `country` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '国家',
  `province` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '省份',
  `city` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '城市',
  `district` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '县区',
  `address` varchar(500) NOT NULL DEFAULT '' COMMENT '收货地址',
  `mobile` varchar(20) DEFAULT '' COMMENT '手机',
  `prom_type` tinyint(1) unsigned DEFAULT '0' COMMENT '订单类型：0普通订单，1虚拟订单,2-核销订单(单次)',
  `virtual_delivery` text COMMENT '虚拟订单时，卖家发货给买家的回复',
  `admin_note` text COMMENT '管理员操作备注',
  `is_comment` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否已评论，0为否，1为是，默认0',
  `user_note` text COMMENT '会员备注',
  `group` varchar(50) DEFAULT '' COMMENT '订单分组',
  `order_md5` varchar(50) DEFAULT '' COMMENT '订单标识串，删除未付款的重复订单',
  `order_source` tinyint(3) DEFAULT '10' COMMENT '10-普通订单 20-秒杀订单',
  `order_source_id` int(10) DEFAULT '0' COMMENT '来源id(秒杀订单:active_time_id)',
  `lang` varchar(30) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) unsigned DEFAULT '0' COMMENT '下单时间',
  `update_time` int(11) unsigned DEFAULT '0' COMMENT '更新时间',
  `coupon_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '优惠券数据表ID',
  `use_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '会员的优惠券数据表ID',
  `coupon_price` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '使用的优惠券金额',
  PRIMARY KEY (`order_id`),
  UNIQUE KEY `order_code` (`order_code`),
  KEY `users_id` (`users_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='订单主表';


-- -----------------------------
-- Table structure for `ey_shop_order_comment`
-- -----------------------------
DROP TABLE IF EXISTS `ey_shop_order_comment`;
CREATE TABLE `ey_shop_order_comment` (
  `comment_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `users_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '会员ID',
  `order_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '订单ID',
  `order_code` varchar(50) NOT NULL DEFAULT '' COMMENT '订单编号',
  `details_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '订单明细表ID',
  `product_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '商品ID',
  `total_score` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '总评分，1：好评，2中评，3差评',
  `content` varchar(1000) NOT NULL DEFAULT '' COMMENT '评论内容',
  `upload_img` varchar(3000) NOT NULL DEFAULT '' COMMENT '晒单图片',
  `admin_reply` varchar(1000) NOT NULL DEFAULT '' COMMENT '管理员回复',
  `ip_address` varchar(15) NOT NULL DEFAULT '' COMMENT 'IP地址',
  `is_show` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '是否显示：0否，1是',
  `is_anonymous` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否匿名评价：0否，1是',
  `is_new_comment` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否新版评价：0否，1是',
  `lang` varchar(30) NOT NULL DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '添加时间',
  `update_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`comment_id`),
  KEY `users_id` (`users_id`),
  KEY `order_id` (`order_id`),
  KEY `details_id` (`details_id`),
  KEY `product_id` (`product_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='商品评价表';


-- -----------------------------
-- Table structure for `ey_shop_order_details`
-- -----------------------------
DROP TABLE IF EXISTS `ey_shop_order_details`;
CREATE TABLE `ey_shop_order_details` (
  `details_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增id',
  `order_id` int(10) NOT NULL DEFAULT '0' COMMENT '订单ID',
  `users_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '会员id',
  `product_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '产品id',
  `product_name` varchar(100) NOT NULL DEFAULT '' COMMENT '产品名称',
  `num` int(10) NOT NULL DEFAULT '0' COMMENT '单个产品数量',
  `data` text COMMENT '序列化额外数据',
  `product_price` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '产品单价',
  `prom_type` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '产品类型：0普通产品，1虚拟产品',
  `litpic` varchar(500) NOT NULL DEFAULT '' COMMENT '封面图片',
  `apply_service` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否申请退换货服务：0 未申请、1已申请',
  `is_comment` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否已评论，0为否，1为是，默认0',
  `lang` varchar(30) NOT NULL DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '下单时间',
  `update_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`details_id`),
  KEY `users_id` (`users_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='订单详情表';


-- -----------------------------
-- Table structure for `ey_shop_order_log`
-- -----------------------------
DROP TABLE IF EXISTS `ey_shop_order_log`;
CREATE TABLE `ey_shop_order_log` (
  `action_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增id',
  `order_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '订单ID',
  `users_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '会员ID',
  `action_user` int(10) DEFAULT '0' COMMENT '操作人；0:用户操作；1以上:管理员id',
  `order_status` tinyint(1) NOT NULL DEFAULT '0' COMMENT '订单状态，单条记录状态',
  `express_status` tinyint(1) NOT NULL DEFAULT '0' COMMENT '物流状态，0:未发货，1:已发货',
  `pay_status` tinyint(1) NOT NULL DEFAULT '0' COMMENT '支付状态，0:未支付，1:已支付',
  `action_desc` varchar(255) DEFAULT '' COMMENT '状态描述',
  `action_note` varchar(255) NOT NULL DEFAULT '' COMMENT '操作备注',
  `lang` varchar(30) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '操作时间',
  `update_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '操作时间',
  PRIMARY KEY (`action_id`),
  KEY `order_id` (`order_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='订单操作记录表';


-- -----------------------------
-- Table structure for `ey_shop_order_service`
-- -----------------------------
DROP TABLE IF EXISTS `ey_shop_order_service`;
CREATE TABLE `ey_shop_order_service` (
  `service_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `service_type` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '类型：1换货，2退货，3维修',
  `users_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '会员id',
  `merchant_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '多商家ID',
  `order_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '订单ID',
  `order_code` varchar(50) NOT NULL DEFAULT '' COMMENT '订单编号',
  `details_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '订单明细表ID',
  `product_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '产品ID',
  `product_name` varchar(200) NOT NULL DEFAULT '' COMMENT '产品名称',
  `product_spec` varchar(200) NOT NULL DEFAULT '' COMMENT '产品规格',
  `product_num` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '产品数量',
  `product_img` varchar(500) NOT NULL DEFAULT '' COMMENT '产品图片',
  `content` varchar(500) NOT NULL DEFAULT '' COMMENT '退换货描述',
  `upload_img` varchar(3000) NOT NULL DEFAULT '' COMMENT '上传的图片',
  `address` varchar(500) NOT NULL DEFAULT '' COMMENT '退货的收货地址',
  `consignee` varchar(30) NOT NULL DEFAULT '' COMMENT '收货人',
  `mobile` varchar(20) NOT NULL DEFAULT '' COMMENT '手机',
  `manual_refund` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '服务单是否被手动关闭并退款',
  `refund_note` varchar(500) NOT NULL DEFAULT '' COMMENT '服务单手动退款原因',
  `refund_price` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '退还金额',
  `refund_balance` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '退还余额',
  `refund_code` varchar(40) NOT NULL DEFAULT '' COMMENT '退款单号',
  `status` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '状态：1审核中 2审核通过 3审核不通过 4已发货 5已收货 6换货完成 7退款完成 8服务取消',
  `users_delivery` varchar(500) NOT NULL DEFAULT '' COMMENT '会员发货信息',
  `admin_delivery` varchar(500) NOT NULL DEFAULT '' COMMENT '管理员发货信息',
  `admin_note` varchar(1000) NOT NULL DEFAULT '' COMMENT '管理员操作备注',
  `lang` varchar(30) NOT NULL DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '申请时间',
  `update_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`service_id`),
  KEY `users_id` (`users_id`) USING BTREE,
  KEY `order_id` (`order_id`) USING BTREE,
  KEY `order_code` (`order_code`) USING BTREE,
  KEY `product_id` (`product_id`) USING BTREE,
  KEY `details_id` (`details_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='订单退换货服务表';


-- -----------------------------
-- Table structure for `ey_shop_order_service_log`
-- -----------------------------
DROP TABLE IF EXISTS `ey_shop_order_service_log`;
CREATE TABLE `ey_shop_order_service_log` (
  `log_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `service_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '服务表ID',
  `order_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '订单ID',
  `users_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '会员ID',
  `admin_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '管理员ID',
  `log_note` varchar(500) NOT NULL DEFAULT '' COMMENT '记录备注',
  `lang` varchar(30) NOT NULL DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '操作时间',
  `update_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '操作时间',
  PRIMARY KEY (`log_id`),
  KEY `service_id` (`service_id`) USING BTREE,
  KEY `order_id` (`order_id`) USING BTREE,
  KEY `users_id` (`users_id`) USING BTREE,
  KEY `admin_id` (`admin_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='订单退换货服务记录表';


-- -----------------------------
-- Table structure for `ey_shop_order_unified_pay`
-- -----------------------------
DROP TABLE IF EXISTS `ey_shop_order_unified_pay`;
CREATE TABLE `ey_shop_order_unified_pay` (
  `unified_id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '统一支付订单ID',
  `unified_number` varchar(30) NOT NULL DEFAULT '' COMMENT '统一支付订单编号',
  `unified_amount` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '统一支付订单应付款金额',
  `users_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '会员ID',
  `order_ids` text NOT NULL COMMENT '合并支付的订单ID，serialize序列化存储',
  `pay_status` tinyint(1) NOT NULL DEFAULT '0' COMMENT '统一支付订单状态：0未付款，1已付款',
  `pay_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '统一支付订单时间',
  `pay_name` varchar(20) NOT NULL DEFAULT '' COMMENT '统一支付订单方式名称',
  `wechat_pay_type` varchar(20) NOT NULL DEFAULT '' COMMENT '微信支付时，标记使用的支付类型（扫码支付，微信内部，微信H5页面）',
  `add_time` int(11) unsigned DEFAULT '0' COMMENT '下单时间',
  `update_time` int(11) unsigned DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`unified_id`),
  KEY `users_id` (`users_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;


-- -----------------------------
-- Table structure for `ey_shop_order_verify`
-- -----------------------------
DROP TABLE IF EXISTS `ey_shop_order_verify`;
CREATE TABLE `ey_shop_order_verify` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '订单核销信息表',
  `users_id` int(11) DEFAULT '0' COMMENT '用户id',
  `order_id` int(11) DEFAULT '0' COMMENT '订单id',
  `points_id` int(11) DEFAULT '0' COMMENT '提货点id',
  `verify_code` varchar(30) DEFAULT '' COMMENT '核销码',
  `status` tinyint(3) DEFAULT '1' COMMENT '核销状态 1-未核销 2-已核销',
  `add_time` int(10) DEFAULT '0',
  `update_time` int(10) DEFAULT NULL,
  `name` varchar(55) DEFAULT '' COMMENT '用户姓名',
  `mobile` varchar(25) DEFAULT '' COMMENT '联系方式',
  `verifier_id` int(11) DEFAULT '0' COMMENT '前台核销-核销员id',
  `admin_id` int(11) DEFAULT '0' COMMENT '后台核销-管理员id',
  `verify_time` int(10) DEFAULT '0' COMMENT '核销时间',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='订单核销表';


-- -----------------------------
-- Table structure for `ey_shop_product_attr`
-- -----------------------------
DROP TABLE IF EXISTS `ey_shop_product_attr`;
CREATE TABLE `ey_shop_product_attr` (
  `product_attr_id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '产品属性id自增',
  `aid` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '产品id',
  `attr_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '属性id',
  `attr_value` text NOT NULL COMMENT '属性值',
  `attr_price` varchar(255) DEFAULT '' COMMENT '属性价格',
  `is_custom` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否自定义参数(0否 1是)',
  `sort_order` int(11) unsigned NOT NULL DEFAULT '100' COMMENT '属性排序',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`product_attr_id`),
  KEY `aid` (`aid`) USING BTREE,
  KEY `attr_id` (`attr_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


-- -----------------------------
-- Table structure for `ey_shop_product_attribute`
-- -----------------------------
DROP TABLE IF EXISTS `ey_shop_product_attribute`;
CREATE TABLE `ey_shop_product_attribute` (
  `attr_id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '属性id',
  `attr_name` varchar(60) NOT NULL DEFAULT '' COMMENT '属性名称',
  `list_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '栏目id',
  `attr_index` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '0不需要检索 1关键字检索 2范围检索',
  `attr_input_type` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT ' 0=文本框，1=下拉框，2=多行文本框',
  `attr_values` text NOT NULL COMMENT '可选值列表',
  `status` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '状态(0=禁用，1=启用)',
  `sort_order` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '属性排序',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `is_del` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否已删除，0=否，1=是',
  `is_custom` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否自定义参数(0否 1是)',
  `add_time` int(11) NOT NULL DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`attr_id`),
  KEY `cat_id` (`list_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


-- -----------------------------
-- Table structure for `ey_shop_product_attrlist`
-- -----------------------------
DROP TABLE IF EXISTS `ey_shop_product_attrlist`;
CREATE TABLE `ey_shop_product_attrlist` (
  `list_id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '列表id',
  `list_name` varchar(60) NOT NULL DEFAULT '' COMMENT '列表名称',
  `status` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '状态(0=禁用，1=启用)',
  `attr_count` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '参数数量',
  `desc` text NOT NULL COMMENT '描述备注',
  `is_del` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否已删除，0=否，1=是',
  `sort_order` int(11) unsigned NOT NULL DEFAULT '100' COMMENT '列表排序',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`list_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


-- -----------------------------
-- Table structure for `ey_shop_shipping_template`
-- -----------------------------
DROP TABLE IF EXISTS `ey_shop_shipping_template`;
CREATE TABLE `ey_shop_shipping_template` (
  `template_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '运费模板ID',
  `template_region` varchar(255) NOT NULL DEFAULT '' COMMENT '模板运送区域',
  `template_money` decimal(10,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '模板运费',
  `province_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'region表id',
  `lang` varchar(30) DEFAULT 'cn' COMMENT '语言标识',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`template_id`)
) ENGINE=MyISAM AUTO_INCREMENT=36 DEFAULT CHARSET=utf8 COMMENT='运费模板表';

-- -----------------------------
-- Records of `ey_shop_shipping_template`
-- -----------------------------
INSERT INTO `ey_shop_shipping_template` VALUES ('1', '北京市', '0.00', '1', 'cn', '1554775610');
INSERT INTO `ey_shop_shipping_template` VALUES ('2', '天津市', '0.00', '338', 'cn', '1554775610');
INSERT INTO `ey_shop_shipping_template` VALUES ('3', '河北省', '0.00', '636', 'cn', '1554775610');
INSERT INTO `ey_shop_shipping_template` VALUES ('4', '山西省', '0.00', '3102', 'cn', '1554775610');
INSERT INTO `ey_shop_shipping_template` VALUES ('5', '内蒙古自治区', '0.00', '4670', 'cn', '1554775610');
INSERT INTO `ey_shop_shipping_template` VALUES ('6', '辽宁省', '0.00', '5827', 'cn', '1554775610');
INSERT INTO `ey_shop_shipping_template` VALUES ('7', '吉林省', '0.00', '7531', 'cn', '1554775921');
INSERT INTO `ey_shop_shipping_template` VALUES ('8', '黑龙江省', '0.00', '8558', 'cn', '1554775610');
INSERT INTO `ey_shop_shipping_template` VALUES ('9', '上海市', '0.00', '10543', 'cn', '1554775610');
INSERT INTO `ey_shop_shipping_template` VALUES ('10', '江苏省', '0.00', '10808', 'cn', '1554775610');
INSERT INTO `ey_shop_shipping_template` VALUES ('11', '浙江省', '0.00', '12596', 'cn', '1554775610');
INSERT INTO `ey_shop_shipping_template` VALUES ('12', '安徽省', '0.00', '14234', 'cn', '1554775610');
INSERT INTO `ey_shop_shipping_template` VALUES ('13', '福建省', '0.00', '16068', 'cn', '1554775610');
INSERT INTO `ey_shop_shipping_template` VALUES ('14', '江西省', '0.00', '17359', 'cn', '1554775962');
INSERT INTO `ey_shop_shipping_template` VALUES ('15', '山东省', '0.00', '19280', 'cn', '1554775610');
INSERT INTO `ey_shop_shipping_template` VALUES ('16', '河南省', '0.00', '21387', 'cn', '1554775610');
INSERT INTO `ey_shop_shipping_template` VALUES ('17', '湖北省', '0.00', '24022', 'cn', '1554775610');
INSERT INTO `ey_shop_shipping_template` VALUES ('18', '湖南省', '0.00', '25579', 'cn', '1554775610');
INSERT INTO `ey_shop_shipping_template` VALUES ('19', '广东省', '0.00', '28240', 'cn', '1554775610');
INSERT INTO `ey_shop_shipping_template` VALUES ('20', '广西壮族自治区', '0.00', '30164', 'cn', '1554775610');
INSERT INTO `ey_shop_shipping_template` VALUES ('21', '海南省', '0.00', '31563', 'cn', '1555483193');
INSERT INTO `ey_shop_shipping_template` VALUES ('22', '重庆市', '0.00', '31929', 'cn', '1554775610');
INSERT INTO `ey_shop_shipping_template` VALUES ('23', '四川省', '0.00', '33007', 'cn', '1554775610');
INSERT INTO `ey_shop_shipping_template` VALUES ('24', '贵州省', '0.00', '37906', 'cn', '1554775610');
INSERT INTO `ey_shop_shipping_template` VALUES ('25', '云南省', '0.00', '39556', 'cn', '1554775610');
INSERT INTO `ey_shop_shipping_template` VALUES ('26', '西藏自治区', '0.00', '41103', 'cn', '1554775610');
INSERT INTO `ey_shop_shipping_template` VALUES ('27', '陕西省', '0.00', '41877', 'cn', '1554775610');
INSERT INTO `ey_shop_shipping_template` VALUES ('28', '甘肃省', '0.00', '43776', 'cn', '1554775610');
INSERT INTO `ey_shop_shipping_template` VALUES ('29', '青海省', '0.00', '45286', 'cn', '1554775610');
INSERT INTO `ey_shop_shipping_template` VALUES ('30', '宁夏回族自治区', '0.00', '45753', 'cn', '1554775610');
INSERT INTO `ey_shop_shipping_template` VALUES ('31', '新疆维吾尔自治区', '0.00', '46047', 'cn', '1554775610');
INSERT INTO `ey_shop_shipping_template` VALUES ('32', '台湾省', '0.00', '47493', 'cn', '1554775610');
INSERT INTO `ey_shop_shipping_template` VALUES ('33', '香港特别行政区', '0.00', '47494', 'cn', '1554775610');
INSERT INTO `ey_shop_shipping_template` VALUES ('34', '澳门特别行政区', '0.00', '47495', 'cn', '1554775610');
INSERT INTO `ey_shop_shipping_template` VALUES ('35', '统一配送价格', '0.00', '100000', 'cn', '1556618311');

-- -----------------------------
-- Table structure for `ey_single_content`
-- -----------------------------
DROP TABLE IF EXISTS `ey_single_content`;
CREATE TABLE `ey_single_content` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `aid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '文档ID',
  `typeid` int(10) DEFAULT '0' COMMENT '栏目ID',
  `content` longtext COMMENT '内容详情',
  `content_ey_m` longtext COMMENT '手机端内容详情',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`),
  KEY `aid` (`aid`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

-- -----------------------------
-- Records of `ey_single_content`
-- -----------------------------
INSERT INTO `ey_single_content` VALUES ('1', '1', '1', '&lt;p&gt;广州市压路机机械设备有限公司，是国内领先的机械设备集研发、生产制造及销售于一体的生产厂家，其核心产品以：小型压路机、数控钢筋笼滚焊机、数控弯曲机、路面拌和机、路面刮平机、开沟机、挖坑机、铧式犁等机械设备为主。&lt;/p&gt;&lt;div&gt;公司始终坚持以“先做人，后做事”为核心价值观，以“儒商文化”为品牌文化，以“做今日品牌，创百年企业”为宗旨，以“实用为本、德行天下”为理念，铸造中国机械行业的百年品牌。公司依托与国内的分支机构与办事处、及专业的施工队伍，凭借行业内设备研发专家团队的强大创新能力、扎实的设备品质、完善的售后服务体系，赢得了全球客户的信任与合作。&lt;/div&gt;&lt;div&gt;济宁 天通，一如既往的目标是：更好的产品、更好的服务、更好的信誉。目前，济宁天通已在中铁、中交及各省路桥、路面工程等诸多施工单位工地取得辉煌成绩，完成众多的标准化施工配套服务，并且产品已远销至南美洲、东南亚、西亚、欧洲等地区。尽管天通取得一定的成绩，但是我们相信，没有最好，只有更好，所以天通努力的脚步会一直奔跑在路上！孔子曰：三人行，必有我师焉。择其善者而从之，其不善者而改之。所以，我们坚持不懈的结合工地实践情况及广大用户提出的宝贵建议，持续完善产品、服务，努力成为广大工程施工单位最可信赖的长期合作伙伴。&lt;/div&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;', '', '1533541630', '1533951919');
INSERT INTO `ey_single_content` VALUES ('2', '2', '8', '&lt;p&gt;地址：广东省广州市&lt;br style=&quot;transition: background-color 0.3s ease; -webkit-tap-highlight-color: rgba(255, 255, 255, 0); margin: 0px; color: rgb(85, 85, 85); font-family: &amp;quot;Microsoft Yahei&amp;quot;; font-size: 14px; text-align: justify; white-space: normal; background-color: rgb(255, 255, 255);&quot;/&gt;电话：020-88889999&lt;br style=&quot;transition: background-color 0.3s ease; -webkit-tap-highlight-color: rgba(255, 255, 255, 0); margin: 0px; color: rgb(85, 85, 85); font-family: &amp;quot;Microsoft Yahei&amp;quot;; font-size: 14px; text-align: justify; white-space: normal; background-color: rgb(255, 255, 255);&quot;/&gt;手机：13988889999&lt;br style=&quot;transition: background-color 0.3s ease; -webkit-tap-highlight-color: rgba(255, 255, 255, 0); margin: 0px; color: rgb(85, 85, 85); font-family: &amp;quot;Microsoft Yahei&amp;quot;; font-size: 14px; text-align: justify; white-space: normal; background-color: rgb(255, 255, 255);&quot;/&gt;QQ：88889999&lt;br style=&quot;transition: background-color 0.3s ease; -webkit-tap-highlight-color: rgba(255, 255, 255, 0); margin: 0px; color: rgb(85, 85, 85); font-family: &amp;quot;Microsoft Yahei&amp;quot;; font-size: 14px; text-align: justify; white-space: normal; background-color: rgb(255, 255, 255);&quot;/&gt;邮箱：admin@qq.com&lt;/p&gt;&lt;p&gt;&lt;iframe class=&quot;ueditor_baidumap&quot; src=&quot;/public/plugins/Ueditor/dialogs/map/show.html#center=113.271429,23.135336&amp;zoom=13&amp;width=530&amp;height=340&amp;markers=113.271429,23.135336&amp;markerStyles=l,A&quot; frameborder=&quot;0&quot; width=&quot;534&quot; height=&quot;344&quot;&gt;&lt;/iframe&gt;&lt;/p&gt;', '', '1686204361', '1686204361');

-- -----------------------------
-- Table structure for `ey_sms_log`
-- -----------------------------
DROP TABLE IF EXISTS `ey_sms_log`;
CREATE TABLE `ey_sms_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '表id',
  `source` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '发送来源，与场景ID对应：0=注册，1=绑定，2=登录密码，3=支付密码，4=找回密码',
  `sms_type` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '短信服务商类型，1---阿里云短信， 2---腾讯云短信',
  `mobile` varchar(11) NOT NULL DEFAULT '' COMMENT '手机号',
  `add_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '发送时间',
  `code` varchar(10) NOT NULL DEFAULT '' COMMENT '验证码',
  `status` int(1) unsigned NOT NULL DEFAULT '0' COMMENT '发送状态,1:成功,0:失败',
  `is_use` int(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否使用，1:是，0:否',
  `msg` varchar(255) NOT NULL DEFAULT '' COMMENT '短信内容',
  `ip` varchar(20) DEFAULT 'IP地址',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `error_msg` text NOT NULL COMMENT '发送短信异常内容',
  `update_time` int(11) NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='手机短信发送记录';


-- -----------------------------
-- Table structure for `ey_sms_template`
-- -----------------------------
DROP TABLE IF EXISTS `ey_sms_template`;
CREATE TABLE `ey_sms_template` (
  `tpl_id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `sms_type` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '短信服务商类型，1---阿里云短信， 2---腾讯云短信',
  `tpl_title` varchar(128) NOT NULL DEFAULT '' COMMENT '短信标题',
  `sms_sign` varchar(50) NOT NULL DEFAULT '' COMMENT '短信签名',
  `sms_tpl_code` varchar(100) NOT NULL DEFAULT '' COMMENT '短信模板ID',
  `tpl_content` varchar(1000) NOT NULL DEFAULT '' COMMENT '发送短信内容',
  `send_scene` varchar(100) NOT NULL DEFAULT '' COMMENT '短信发送场景',
  `is_open` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '是否开启使用这个模板，1为是，0为否。',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) NOT NULL COMMENT '添加时间',
  `update_time` int(11) NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`tpl_id`)
) ENGINE=MyISAM AUTO_INCREMENT=19 DEFAULT CHARSET=utf8 COMMENT='手机短信发送模板';

-- -----------------------------
-- Records of `ey_sms_template`
-- -----------------------------
INSERT INTO `ey_sms_template` VALUES ('1', '1', '账号注册', '', '', '验证码为 ${content} ，请在30分钟内输入验证。', '0', '1', 'cn', '1613980373', '1613980373');
INSERT INTO `ey_sms_template` VALUES ('2', '1', '手机绑定', '', '', '验证码为 ${content} ，请在30分钟内输入验证。', '1', '1', 'cn', '1613980373', '1613980373');
INSERT INTO `ey_sms_template` VALUES ('3', '1', '找回密码', '', '', '验证码为 ${content} ，请在30分钟内输入验证。', '4', '1', 'cn', '1613980373', '1613980373');
INSERT INTO `ey_sms_template` VALUES ('4', '1', '订单付款', '', '', '您有新的消息：您有新的${content}订单，请注意查收！', '5', '1', 'cn', '1613980373', '1667470612');
INSERT INTO `ey_sms_template` VALUES ('5', '2', '账号注册', '', '', '验证码为 {1} ，请在30分钟内输入验证。', '0', '1', 'cn', '1613980400', '1613980400');
INSERT INTO `ey_sms_template` VALUES ('6', '2', '手机绑定', '', '', '验证码为 {1} ，请在30分钟内输入验证。', '1', '1', 'cn', '1613980400', '1613980400');
INSERT INTO `ey_sms_template` VALUES ('7', '2', '找回密码', '', '', '验证码为 {1} ，请在30分钟内输入验证。', '4', '1', 'cn', '1613980400', '1613980400');
INSERT INTO `ey_sms_template` VALUES ('8', '2', '订单付款', '', '', '您有新的消息：您有新的{1}订单，请注意查收！', '5', '1', 'cn', '1613980400', '1667470612');
INSERT INTO `ey_sms_template` VALUES ('9', '1', '订单发货', '', '', '您有新的消息：您有新的${content}订单，请注意查收！', '6', '1', 'cn', '1613980373', '1667470612');
INSERT INTO `ey_sms_template` VALUES ('10', '2', '订单发货', '', '', '您有新的消息：您有新的{1}订单，请注意查收！', '6', '1', 'cn', '1613980400', '1667470612');
INSERT INTO `ey_sms_template` VALUES ('14', '1', '留言验证', '', '', '验证码为 ${content} ，请在30分钟内输入验证。', '7', '1', 'cn', '1613980373', '1613980373');
INSERT INTO `ey_sms_template` VALUES ('13', '1', '账号登录', '', '', '验证码为 ${content} ，请在30分钟内输入验证。', '2', '1', 'cn', '1613980373', '1613980373');
INSERT INTO `ey_sms_template` VALUES ('15', '2', '账号登录', '', '', '验证码为 {1} ，请在30分钟内输入验证。', '2', '1', 'cn', '1613980400', '1613980400');
INSERT INTO `ey_sms_template` VALUES ('16', '2', '留言验证', '', '', '验证码为 {1} ，请在30分钟内输入验证。', '7', '1', 'cn', '1613980400', '1613980400');
INSERT INTO `ey_sms_template` VALUES ('17', '1', '留言表单', '', '', '您有新的留言消息，请查收！', '11', '1', 'cn', '1613980373', '1613980373');
INSERT INTO `ey_sms_template` VALUES ('18', '2', '留言表单', '', '', '您有新的留言消息，请查收！', '11', '1', 'cn', '1613980400', '1613980400');

-- -----------------------------
-- Table structure for `ey_smtp_record`
-- -----------------------------
DROP TABLE IF EXISTS `ey_smtp_record`;
CREATE TABLE `ey_smtp_record` (
  `record_id` int(10) NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `source` tinyint(1) DEFAULT '0' COMMENT '来源，与场景ID对应：0=默认，2=注册，3=绑定邮箱，4=找回密码',
  `email` varchar(50) DEFAULT '' COMMENT '邮件地址',
  `users_id` int(10) DEFAULT '0' COMMENT '用户ID',
  `code` varchar(20) DEFAULT '' COMMENT '发送邮件内容',
  `status` tinyint(1) DEFAULT '0' COMMENT '是否使用，默认0，0为未使用，1为使用',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`record_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='邮件发送记录表';


-- -----------------------------
-- Table structure for `ey_smtp_tpl`
-- -----------------------------
DROP TABLE IF EXISTS `ey_smtp_tpl`;
CREATE TABLE `ey_smtp_tpl` (
  `tpl_id` int(10) NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `tpl_name` varchar(200) DEFAULT '' COMMENT '模板名称',
  `tpl_title` varchar(200) DEFAULT '' COMMENT '邮件标题',
  `tpl_content` text COMMENT '发送邮件内容',
  `send_scene` tinyint(1) DEFAULT '0' COMMENT '邮件发送场景(1=留言表单）',
  `is_open` tinyint(1) DEFAULT '0' COMMENT '是否开启使用这个模板，1为是，0为否。',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) DEFAULT '0' COMMENT '添加时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`tpl_id`)
) ENGINE=MyISAM AUTO_INCREMENT=7 DEFAULT CHARSET=utf8 COMMENT='邮件模板表';

-- -----------------------------
-- Records of `ey_smtp_tpl`
-- -----------------------------
INSERT INTO `ey_smtp_tpl` VALUES ('1', '留言表单', '您有新的留言消息，请查收！', '${content}', '1', '1', 'cn', '1544763495', '1552638302');
INSERT INTO `ey_smtp_tpl` VALUES ('2', '会员注册', '验证码已发送至您的邮箱，请登录邮箱查看验证码！', '${content}', '2', '1', 'cn', '1544763495', '1552667056');
INSERT INTO `ey_smtp_tpl` VALUES ('3', '绑定邮箱', '验证码已发送至您的邮箱，请登录邮箱查看验证码！', '${content}', '3', '1', 'cn', '1544763495', '1552667400');
INSERT INTO `ey_smtp_tpl` VALUES ('4', '找回密码', '验证码已发送至您的邮箱，请登录邮箱查看验证码！', '${content}', '4', '1', 'cn', '1544763495', '1552663577');
INSERT INTO `ey_smtp_tpl` VALUES ('5', '订单付款', '您有新的待发货订单消息，请到商城订单查看！', '${content}', '5', '1', 'cn', '1613980373', '1667470612');
INSERT INTO `ey_smtp_tpl` VALUES ('6', '订单发货', '您有新的待收货订单消息，请到会员订单查看！', '${content}', '6', '1', 'cn', '1667470612', '1667470612');

-- -----------------------------
-- Table structure for `ey_special_content`
-- -----------------------------
DROP TABLE IF EXISTS `ey_special_content`;
CREATE TABLE `ey_special_content` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `aid` int(10) DEFAULT '0' COMMENT '文档ID',
  `content` longtext COMMENT '内容详情',
  `content_ey_m` longtext COMMENT '手机端内容详情',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`),
  KEY `aid` (`aid`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='专题附加表';


-- -----------------------------
-- Table structure for `ey_special_node`
-- -----------------------------
DROP TABLE IF EXISTS `ey_special_node`;
CREATE TABLE `ey_special_node` (
  `node_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `aid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '文档ID',
  `title` varchar(50) NOT NULL DEFAULT '' COMMENT '节点名称',
  `code` varchar(50) NOT NULL DEFAULT '' COMMENT '节点标识',
  `isauto` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否自动获取文档',
  `keywords` varchar(200) NOT NULL DEFAULT '' COMMENT '关键字（多个中间用'',''分开）',
  `typeid` int(10) NOT NULL DEFAULT '0' COMMENT '栏目ID',
  `aidlist` text NOT NULL COMMENT '关联文章列表（多个中间用'',''分开）',
  `row` int(5) NOT NULL DEFAULT '10' COMMENT '文档数',
  `status` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '状态',
  `is_del` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `sort_order` int(11) DEFAULT '0' COMMENT '排序',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`node_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='专题节点表';


-- -----------------------------
-- Table structure for `ey_sql_cache_table`
-- -----------------------------
DROP TABLE IF EXISTS `ey_sql_cache_table`;
CREATE TABLE `ey_sql_cache_table` (
  `cache_id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `sql_name` varchar(60) NOT NULL DEFAULT '' COMMENT 'mysql语句的标识名称，目前由模型名称+模型ID组成',
  `sql_result` text NOT NULL COMMENT 'mysql执行结果',
  `sql_md5` varchar(60) NOT NULL DEFAULT '' COMMENT 'mysql语句MD5的值',
  `sql_query` text NOT NULL COMMENT '完整mysql语句',
  `add_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`cache_id`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COMMENT='mysql缓存表';

-- -----------------------------
-- Records of `ey_sql_cache_table`
-- -----------------------------
INSERT INTO `ey_sql_cache_table` VALUES ('1', 'ArchivesMaxID', '40', '494a17e43cff13eeb4b9c9837c29026c', 'SELECT MAX(aid) AS tp_max FROM `ey_archives` LIMIT 1', '1667470612', '1667470612');
INSERT INTO `ey_sql_cache_table` VALUES ('2', '|model|all|count|', '{\"1\":{\"channel\":1,\"total\":26},\"6\":{\"channel\":6,\"total\":2}}', 'd5ac17fe5649c6d04f4b174c42f2d535', 'SELECT channel, count(aid) as total FROM `ey_archives` WHERE  `lang` = \'cn\'  AND `status` = 1  AND `is_del` = 0  AND (  (users_id = 0 OR (users_id > 0 AND arcrank >= 0)) ) GROUP BY `channel`', '1667470612', '1667470612');
INSERT INTO `ey_sql_cache_table` VALUES ('3', '|arctype|all|count|', '{\"3\":{\"typeid\":3,\"num\":5},\"4\":{\"typeid\":4,\"num\":5},\"5\":{\"typeid\":5,\"num\":3},\"6\":{\"typeid\":6,\"num\":4},\"9\":{\"typeid\":9,\"num\":8},\"10\":{\"typeid\":10,\"num\":1}}', '177bb217bb5e0443a5ee349760a0aea7', 'SELECT typeid, count(typeid) as num FROM `ey_archives` WHERE  `channel` IN (1,2,3,4,5,7)  AND `lang` = \'cn\'  AND `is_del` = 0  AND (  (users_id = 0 OR (users_id > 0 AND arcrank >= 0)) ) GROUP BY `typeid`', '1686204335', '1686204335');

-- -----------------------------
-- Table structure for `ey_suibi_content`
-- -----------------------------
DROP TABLE IF EXISTS `ey_suibi_content`;
CREATE TABLE `ey_suibi_content` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `aid` int(10) DEFAULT '0' COMMENT '文档ID',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  `content` text COMMENT '内容详情',
  `pics` text COMMENT '配图|10001',
  PRIMARY KEY (`id`),
  KEY `aid` (`aid`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=16 DEFAULT CHARSET=utf8 COMMENT='附加表';

-- -----------------------------
-- Records of `ey_suibi_content`
-- -----------------------------
INSERT INTO `ey_suibi_content` VALUES ('11', '25', '1642167410', '1642167410', '那些喜欢看小说的人，一类人是正过着自己所向往的生活，闲下来打发时间而看的，另一类人，是正在迷茫着，羡慕小说里的人物叭。', 'a:1:{i:0;a:2:{s:9:\"image_url\";s:46:\"/uploads/allimg/20220114/1-220114213412504.jpg\";s:5:\"intro\";s:0:\"\";}}');
INSERT INTO `ey_suibi_content` VALUES ('12', '30', '1642169211', '1642169211', '盛开的花终有凋零的日子，\r\n而他的后嗣可以将其记忆延续:\r\n可是你啊，只专注于自己明亮的眼睛，\r\n宁肯用自己做燃料也要喂饱眼中的欲焰，\r\n与自己为敌，你把丰饶的田野变成荒原。', '');
INSERT INTO `ey_suibi_content` VALUES ('13', '37', '1642172247', '1642172247', '骆驼是很好奇的动物，它总是睁着大眼睛。那时，它住的地方，到处是草地和苹果树。有一天它离开了住的地方，到外地去流浪，最后它到了沙漠的边缘。骆驼非常惊讶，这里除了沙子没有别的，于是它走向第一座沙丘，并且经过沙丘。\r\n\r\n那后面除了另一座沙丘，什么也没有。骆驼继续往前走。那后面一定有别的东西！它想，于是它又走向第二座沙丘。那后面又是除了另一座沙丘，什么也没有。就这样骆驼经过了十座、一百座、一千座沙丘，它越走越深入沙漠。那后面一定有别的东西！它一直这样想。一定有别的东西，一定有别的东西，一定有……\r\n\r\n骆驼继续往前走。它越来越渴，越来越累，眼皮也越来越重，眼睛越来越小。当它看见最后一座沙丘时，已经丧失了最后的勇气。那后面一定什么东西也没有！它想。但是，在最后一座沙丘后面有树木，树荫下有泉水。骆驼走向泉水，开始狂饮。什么也没有！它想。骆驼喝着水，它的眼睛差不多快闭起来了。它还是想，那后面一定什么也没有，什么也没有。', '');
INSERT INTO `ey_suibi_content` VALUES ('14', '44', '1642172973', '1642172973', '支持两张图、四张图；\r\n支持六张图、九张图；\r\n而且不用打开详情页就可以放大~', 'a:6:{i:0;a:2:{s:9:\"image_url\";s:44:\"/uploads/allimg/20220114/1-220114230T2U1.jpg\";s:5:\"intro\";s:0:\"\";}i:1;a:2:{s:9:\"image_url\";s:45:\"/uploads/allimg/20220114/1-220114230T3117.jpg\";s:5:\"intro\";s:0:\"\";}i:2;a:2:{s:9:\"image_url\";s:45:\"/uploads/allimg/20220114/1-220114230T3505.jpg\";s:5:\"intro\";s:0:\"\";}i:3;a:2:{s:9:\"image_url\";s:44:\"/uploads/allimg/20220114/1-220114230T3Z6.jpg\";s:5:\"intro\";s:0:\"\";}i:4;a:2:{s:9:\"image_url\";s:44:\"/uploads/allimg/20220114/1-220114230T43L.jpg\";s:5:\"intro\";s:0:\"\";}i:5;a:2:{s:9:\"image_url\";s:45:\"/uploads/allimg/20220114/1-220114230T4939.jpg\";s:5:\"intro\";s:0:\"\";}}');
INSERT INTO `ey_suibi_content` VALUES ('15', '57', '1642175886', '1642175886', '午后甘甜、暮晚清冽的水泉，拂晓时分冰冷的溪流，波浪送来的海风，墙桅林立的海湾，浪声汩汩的岸边温暖，像夏日黎明一样美丽。', '');

-- -----------------------------
-- Table structure for `ey_tagindex`
-- -----------------------------
DROP TABLE IF EXISTS `ey_tagindex`;
CREATE TABLE `ey_tagindex` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `tag` varchar(50) NOT NULL DEFAULT '' COMMENT 'tag内容',
  `typeid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '栏目ID',
  `litpic` varchar(250) DEFAULT '' COMMENT '封面图',
  `seo_title` varchar(200) DEFAULT '' COMMENT 'SEO标题',
  `seo_keywords` varchar(200) DEFAULT '' COMMENT 'SEO关键词',
  `seo_description` text COMMENT 'SEO描述',
  `count` int(10) unsigned DEFAULT '0',
  `total` int(10) unsigned DEFAULT '0',
  `weekcc` int(10) unsigned DEFAULT '0',
  `monthcc` int(10) unsigned DEFAULT '0',
  `weekup` int(10) unsigned DEFAULT '0',
  `monthup` int(10) unsigned DEFAULT '0',
  `is_common` tinyint(1) DEFAULT '0' COMMENT '是否常用标签，0=否，1=是',
  `sort_order` int(10) DEFAULT '100' COMMENT '排序号',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(10) unsigned DEFAULT '0',
  `update_time` int(10) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`),
  KEY `typeid` (`typeid`) USING BTREE,
  KEY `count` (`count`,`total`,`weekcc`,`monthcc`,`weekup`,`monthup`,`add_time`) USING BTREE,
  KEY `tag` (`tag`) USING BTREE,
  KEY `lang` (`lang`,`add_time`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


-- -----------------------------
-- Table structure for `ey_taglist`
-- -----------------------------
DROP TABLE IF EXISTS `ey_taglist`;
CREATE TABLE `ey_taglist` (
  `tid` int(10) unsigned NOT NULL DEFAULT '0',
  `aid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '文章ID',
  `typeid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '栏目ID',
  `tag` varchar(50) DEFAULT '' COMMENT 'tag内容',
  `arcrank` tinyint(1) DEFAULT '0' COMMENT '阅读权限',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`tid`,`aid`),
  KEY `aid` (`aid`,`typeid`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='文章标签表';


-- -----------------------------
-- Table structure for `ey_tuadui_content`
-- -----------------------------
DROP TABLE IF EXISTS `ey_tuadui_content`;
CREATE TABLE `ey_tuadui_content` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `aid` int(10) DEFAULT '0' COMMENT '文档ID',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  `zhicheng1` varchar(200) NOT NULL DEFAULT '' COMMENT '职称一',
  `zhicheng2` varchar(200) NOT NULL DEFAULT '' COMMENT '职称二',
  `zhicheng3` varchar(200) NOT NULL DEFAULT '' COMMENT '职称三',
  `zhicheng4` varchar(200) NOT NULL DEFAULT '' COMMENT '职称四',
  `jianjie` longtext COMMENT '个人简介',
  `zhiwei` varchar(200) NOT NULL DEFAULT '' COMMENT '职位',
  PRIMARY KEY (`id`),
  KEY `aid` (`aid`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=9 DEFAULT CHARSET=utf8 COMMENT='附加表';

-- -----------------------------
-- Records of `ey_tuadui_content`
-- -----------------------------
INSERT INTO `ey_tuadui_content` VALUES ('1', '12', '1561625442', '1561625442', '高级专业会计硕士', '中国注册资产评估师', '中国注册会计师', '', '&lt;p&gt;会计师事务所股权合伙人，具有近30年执业经验，长期从事会计、审计行业积累了丰富的执业经验，使得他十分擅长于企业财务咨询、税收筹划、重组改制等业务，对现代独立审计和企业管理有着独到见解。&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;&lt;p&gt;联系电话：+86 123-4567&lt;/p&gt;&lt;p&gt;电子邮箱： admin@youweb.com&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;', '高级合伙人');
INSERT INTO `ey_tuadui_content` VALUES ('2', '13', '1561625619', '1561625619', '中国注册会计师', '中国注册资产评估师', '中国注册税务师', '高级专业会计硕士', '&lt;p&gt;会计师事务所股权合伙人，具有近30年执业经验，长期从事会计、审计行业积累了丰富的执业经验，使得他十分擅长于企业财务咨询、税收筹划、重组改制等业务，对现代独立审计和企业管理有着独到见解。&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;&lt;p&gt;联系电话：+86 123-4567&lt;/p&gt;&lt;p&gt;电子邮箱： admin@youweb.com&lt;/p&gt;', '高级合伙人');
INSERT INTO `ey_tuadui_content` VALUES ('3', '14', '1561625700', '1561625700', '中国注册会计师', '澳洲会计师公会会员', '美国注册会计师', '英国特许公认会计师公会资深会员', '&lt;p&gt;拥有二十年丰富的审计及财务咨询经验，曾服务包括香港及美国上市公司在内的不同类型的客户，善长于国际准则审计、商定程序的审计及相关服务。为全国注册会计师行业领军人才、英国特许公认会计师公会资深会员、澳洲会计师公会会员、《小型企业财务报表审计工作底稿编制指南》编写组成员。&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;&lt;p&gt;联系电话：+86 400-123-4567&lt;/p&gt;&lt;p&gt;电子邮箱：admin@youweb.com&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;', '高级合伙人');
INSERT INTO `ey_tuadui_content` VALUES ('4', '15', '1561625764', '1561625764', '中国注册会计师', '中国注册资产评估师', '中国注册税务师', '', '&lt;p&gt;执业超过二十五年，多年来致力于为外商投资企业和国有企业的客户提供专业服务，涉及行业包括制造、地产、交通运输、酒店及旅游等。她在会计、审计、税务、外汇、咨询方面具备丰富的实务经验。&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;&lt;p&gt;联系电话：+86 400-123-4567&lt;/p&gt;&lt;p&gt;电子邮箱：admin@youweb.com&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;', '合伙人');
INSERT INTO `ey_tuadui_content` VALUES ('5', '45', '1561689749', '1561689749', 'CICPA', 'CCPV', 'Master of Professional Accounting', '', '&lt;p&gt;Equity partners of accounting firms, with nearly 30 years of practice experience, have accumulated rich experience in accounting and auditing industry for a long time, which makes him very good at business such as enterprise financial consultation, tax planning, restructuring and restructuring, and has unique views on modern independent auditing and enterprise management.&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;&lt;p&gt;Contact number: +86 123-4567&lt;/p&gt;&lt;p&gt;E-mail: admin@youweb.com&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;', 'senior partner');
INSERT INTO `ey_tuadui_content` VALUES ('6', '46', '1561689834', '1561689834', 'CICPA', 'CCPV', 'CICTA', 'Master of Professional Accounting', '&lt;p&gt;Equity partners of accounting firms, with nearly 30 years of practice experience, have accumulated rich experience in accounting and auditing industry for a long time, which makes him very good at business such as enterprise financial consultation, tax planning, restructuring and restructuring, and has unique views on modern independent auditing and enterprise management.&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;&lt;p&gt;Contact number: +86 123-4567&lt;/p&gt;&lt;p&gt;E-mail: admin@youweb.com&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;', 'senior partner');
INSERT INTO `ey_tuadui_content` VALUES ('7', '47', '1561689943', '1561689943', 'CICPA', 'CCPV', 'CICTA', 'Master of Professional Accounting', '&lt;p&gt;Equity partners of accounting firms, with nearly 30 years of practice experience, have accumulated rich experience in accounting and auditing industry for a long time, which makes him very good at business such as enterprise financial consultation, tax planning, restructuring and restructuring, and has unique views on modern independent auditing and enterprise management.&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;&lt;p&gt;Contact number: +86 123-4567&lt;/p&gt;&lt;p&gt;E-mail: admin@youweb.com&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;', 'senior partner');
INSERT INTO `ey_tuadui_content` VALUES ('8', '48', '1561689988', '1561689988', 'CICPA', 'CCPV', 'Master of Professional Accounting', '', '&lt;p&gt;Equity partners of accounting firms, with nearly 30 years of practice experience, have accumulated rich experience in accounting and auditing industry for a long time, which makes him very good at business such as enterprise financial consultation, tax planning, restructuring and restructuring, and has unique views on modern independent auditing and enterprise management.&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;&lt;p&gt;Contact number: +86 123-4567&lt;/p&gt;&lt;p&gt;E-mail: admin@youweb.com&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;', 'Partner');

-- -----------------------------
-- Table structure for `ey_ui_config`
-- -----------------------------
DROP TABLE IF EXISTS `ey_ui_config`;
CREATE TABLE `ey_ui_config` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '表id',
  `md5key` varchar(100) NOT NULL DEFAULT '' COMMENT '唯一键值（由 theme_style、page、name）组成',
  `theme_style` varchar(200) DEFAULT 'pc' COMMENT '模板风格',
  `page` varchar(64) DEFAULT '' COMMENT '页面分组',
  `type` varchar(50) DEFAULT '' COMMENT '编辑类型',
  `name` varchar(50) DEFAULT '' COMMENT '与页面的e-id对应',
  `value` text COMMENT '页面美化的val值',
  `idcode` varchar(50) DEFAULT '' COMMENT '页面唯一id标识（由 标识符+栏目id或文档id等）组成',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`),
  UNIQUE KEY `md5key` (`md5key`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='页面美化参数设置';


-- -----------------------------
-- Table structure for `ey_uploads`
-- -----------------------------
DROP TABLE IF EXISTS `ey_uploads`;
CREATE TABLE `ey_uploads` (
  `img_id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `type_id` int(10) NOT NULL DEFAULT '0' COMMENT '分组ID',
  `aid` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT '文档ID',
  `title` varchar(500) DEFAULT '' COMMENT '文档标题',
  `image_url` varchar(255) DEFAULT '' COMMENT '文件存储路径',
  `intro` varchar(500) DEFAULT '' COMMENT '图集描述',
  `width` int(11) DEFAULT '0' COMMENT '图片宽度',
  `height` int(11) DEFAULT '0' COMMENT '图片高度',
  `filesize` int(11) unsigned DEFAULT '0' COMMENT '文件大小',
  `mime` varchar(50) DEFAULT '' COMMENT '图片类型',
  `users_id` int(11) DEFAULT '0' COMMENT '用户ID',
  `sort_order` smallint(5) DEFAULT '100' COMMENT '排序',
  `is_del` tinyint(1) DEFAULT '0' COMMENT '1已删除 0未删除',
  `add_time` int(10) unsigned DEFAULT '0' COMMENT '上传时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`img_id`),
  KEY `aid` (`aid`) USING BTREE,
  KEY `add_time` (`add_time`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COMMENT='上传记录表';

-- -----------------------------
-- Records of `ey_uploads`
-- -----------------------------
INSERT INTO `ey_uploads` VALUES ('1', '0', '0', 'weixin.jpg', '/uploads/allimg/20230608/1-23060Q405105G.jpg', '', '200', '200', '25048', 'image/jpeg', '0', '100', '0', '1686204310', '1686204310');

-- -----------------------------
-- Table structure for `ey_uploads_type`
-- -----------------------------
DROP TABLE IF EXISTS `ey_uploads_type`;
CREATE TABLE `ey_uploads_type` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `upload_type` varchar(50) NOT NULL DEFAULT '' COMMENT '名称',
  `add_time` int(10) NOT NULL DEFAULT '0' COMMENT '新增时间',
  `update_time` int(10) NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='上传分组表';


-- -----------------------------
-- Table structure for `ey_urls_content`
-- -----------------------------
DROP TABLE IF EXISTS `ey_urls_content`;
CREATE TABLE `ey_urls_content` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `aid` int(10) DEFAULT '0' COMMENT '文档ID',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  `pagePath` enum('首页','产品列表','信息公开','企业展播','龙凤美景','分销中心','购物车','个人中心','领取优惠券','新闻资讯','签到中心','地址管理','积分商城','砍价活动','拼团活动','我的收藏','我的优惠券','秒杀活动','我的足迹') DEFAULT '首页' COMMENT '跳转路径',
  PRIMARY KEY (`id`),
  KEY `aid` (`aid`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 COMMENT='附加表';

-- -----------------------------
-- Records of `ey_urls_content`
-- -----------------------------
INSERT INTO `ey_urls_content` VALUES ('1', '113', '1667196112', '1667196112', '新闻资讯');
INSERT INTO `ey_urls_content` VALUES ('2', '114', '1667196466', '1667196466', '个人中心');
INSERT INTO `ey_urls_content` VALUES ('3', '115', '1667198526', '1667198526', '我的足迹');
INSERT INTO `ey_urls_content` VALUES ('4', '116', '1667198828', '1667198828', '首页');

-- -----------------------------
-- Table structure for `ey_users`
-- -----------------------------
DROP TABLE IF EXISTS `ey_users`;
CREATE TABLE `ey_users` (
  `users_id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '表id',
  `username` varchar(30) NOT NULL DEFAULT '' COMMENT '用户名',
  `password` varchar(255) NOT NULL DEFAULT '' COMMENT '登录密码',
  `nickname` varchar(50) NOT NULL DEFAULT '' COMMENT '昵称',
  `is_mobile` tinyint(1) DEFAULT '0' COMMENT '绑定手机号，0为不绑定，1为绑定',
  `mobile` varchar(20) NOT NULL DEFAULT '' COMMENT '手机号码（仅用于登录）',
  `is_email` tinyint(1) DEFAULT '0' COMMENT '绑定邮箱，0为不绑定，1为绑定',
  `email` varchar(60) NOT NULL DEFAULT '' COMMENT '电子邮件（仅用于登录）',
  `paypwd` varchar(255) DEFAULT '' COMMENT '支付密码，暂时未用到，可保留。',
  `users_money` decimal(10,2) DEFAULT '0.00' COMMENT '用户金额',
  `frozen_money` decimal(10,2) DEFAULT '0.00' COMMENT '冻结金额',
  `scores` int(10) DEFAULT '0' COMMENT '积分',
  `devote` int(10) DEFAULT '0' COMMENT '贡献值',
  `reg_time` int(11) unsigned DEFAULT '0' COMMENT '注册时间',
  `last_login` int(11) unsigned DEFAULT '0' COMMENT '最后登录时间',
  `last_ip` varchar(15) DEFAULT '' COMMENT '最后登录ip',
  `login_count` int(11) DEFAULT '0' COMMENT '登陆次数',
  `head_pic` varchar(255) DEFAULT '' COMMENT '头像',
  `province` int(6) DEFAULT '0' COMMENT '省份',
  `city` int(6) DEFAULT '0' COMMENT '市区',
  `district` int(6) DEFAULT '0' COMMENT '县',
  `level` smallint(5) DEFAULT '0' COMMENT '会员等级',
  `open_level_time` int(11) unsigned DEFAULT '0' COMMENT '开通会员级别时间',
  `level_maturity_days` varchar(20) DEFAULT '' COMMENT '会员级别到期天数',
  `discount` decimal(10,2) DEFAULT '1.00' COMMENT '会员折扣，默认1不享受',
  `total_amount` decimal(10,2) DEFAULT '0.00' COMMENT '消费累计额度',
  `is_activation` tinyint(1) DEFAULT '1' COMMENT '是否激活，0否，1是。\r\n后台注册默认为1激活。\r\n前台注册时，当会员功能设置选择后台审核，需后台激活才可以登陆。',
  `register_place` tinyint(1) DEFAULT '2' COMMENT '注册位置。后台注册不受注册验证影响，1为后台注册，2为前台注册。默认为2。',
  `open_id` varchar(50) NOT NULL DEFAULT '' COMMENT '第三方唯一标识openid',
  `thirdparty` tinyint(1) DEFAULT '0' COMMENT '第三方注册类型：0=普通，1=微信，2=QQ',
  `is_lock` tinyint(1) DEFAULT '0' COMMENT '是否被锁定冻结',
  `admin_id` int(10) DEFAULT '0' COMMENT '关联管理员ID',
  `lang` varchar(20) DEFAULT 'cn' COMMENT '语言标识',
  `is_del` tinyint(1) DEFAULT '0' COMMENT '伪删除，1=是，0=否',
  `unread_notice_num` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '未读消息数量',
  `update_time` int(11) unsigned DEFAULT '0' COMMENT '更新时间',
  `sex` varchar(10) DEFAULT '保密' COMMENT '性别- 男,女,保密',
  `coin` int(11) unsigned DEFAULT '0' COMMENT '金币',
  `union_id` varchar(50) NOT NULL DEFAULT '' COMMENT '微信用户的unionId',
  PRIMARY KEY (`users_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='会员信息表';


-- -----------------------------
-- Table structure for `ey_users_bottom_menu`
-- -----------------------------
DROP TABLE IF EXISTS `ey_users_bottom_menu`;
CREATE TABLE `ey_users_bottom_menu` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `title` varchar(30) DEFAULT '' COMMENT '导航名称',
  `mca` varchar(50) DEFAULT '' COMMENT '分组/控制器/操作名',
  `icon` varchar(255) NOT NULL DEFAULT '' COMMENT '图标',
  `sort_order` int(10) DEFAULT '100' COMMENT '排序号',
  `status` tinyint(1) DEFAULT '1' COMMENT '功能开关状态，1=开启，0=关闭',
  `display` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '是否显示, 1--是, 0--否',
  `lang` varchar(20) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 COMMENT='会员中心移动端底部菜单表';

-- -----------------------------
-- Records of `ey_users_bottom_menu`
-- -----------------------------
INSERT INTO `ey_users_bottom_menu` VALUES ('1', '首页', 'home/Index/index', 'shouye', '100', '1', '1', 'cn', '1613980400', '1613980400');
INSERT INTO `ey_users_bottom_menu` VALUES ('2', '下载', 'user/Download/index', 'xiazai', '100', '1', '1', 'cn', '1613980400', '1613980400');
INSERT INTO `ey_users_bottom_menu` VALUES ('3', '发布', 'user/UsersRelease/article_add', 'fabu', '100', '1', '1', 'cn', '1613980400', '1613980400');
INSERT INTO `ey_users_bottom_menu` VALUES ('4', '我的', 'user/Users/centre', 'geren', '100', '1', '1', 'cn', '1613980400', '1613980400');

-- -----------------------------
-- Table structure for `ey_users_collection`
-- -----------------------------
DROP TABLE IF EXISTS `ey_users_collection`;
CREATE TABLE `ey_users_collection` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `users_id` int(10) DEFAULT '0',
  `aid` int(10) DEFAULT '0' COMMENT '文档id',
  `channel` int(10) DEFAULT '0' COMMENT '模型',
  `typeid` int(10) DEFAULT '0' COMMENT '栏目',
  `title` varchar(200) DEFAULT '' COMMENT '网站标题',
  `litpic` varchar(255) DEFAULT '' COMMENT '缩略图',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='我的收藏';


-- -----------------------------
-- Table structure for `ey_users_config`
-- -----------------------------
DROP TABLE IF EXISTS `ey_users_config`;
CREATE TABLE `ey_users_config` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '会员功能配置表ID',
  `name` varchar(50) DEFAULT '' COMMENT '配置的key键名',
  `value` text COMMENT '配置的value值',
  `desc` varchar(100) DEFAULT '' COMMENT '键名说明',
  `inc_type` varchar(64) DEFAULT '' COMMENT '配置分组',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=11 DEFAULT CHARSET=utf8 COMMENT='会员功能配置表';

-- -----------------------------
-- Records of `ey_users_config`
-- -----------------------------
INSERT INTO `ey_users_config` VALUES ('1', 'users_reg_notallow', 'www,bbs,ftp,mail,user,users,admin,administrator,eyoucms', '不允许注册的会员名', 'users', 'cn', '1547890773');
INSERT INTO `ey_users_config` VALUES ('2', 'score_signin_status', '1', '', 'score', 'cn', '1613980400');
INSERT INTO `ey_users_config` VALUES ('3', 'score_signin_score', '3', '', 'score', 'cn', '1613980400');
INSERT INTO `ey_users_config` VALUES ('4', 'shop_open', '0', '', 'shop', 'cn', '1651223558');
INSERT INTO `ey_users_config` VALUES ('5', 'pay_balance_open', '1', '', 'pay', 'cn', '1667470612');
INSERT INTO `ey_users_config` VALUES ('6', 'users_login_expiretime', '3600', '', 'users', 'cn', '1667470612');
INSERT INTO `ey_users_config` VALUES ('7', 'score_name', '积分', '', 'score', 'cn', '1667470862');
INSERT INTO `ey_users_config` VALUES ('8', 'score_intro', 'a) 积分不可兑现、不可转让,仅可在本平台使用;\r\nb) 您在本平台参加特定活动也可使用积分,详细使用规则以具体活动时的规则为准;\r\nc) 积分的数值精确到个位(小数点后全部舍弃,不进行四舍五入)\r\nd) 买家在完成该笔交易(订单状态为“已签收”)后才能得到此笔交易的相应积分,如购买商品参加店铺其他优惠,则优惠的金额部分不享受积分获取;', '', 'score', 'cn', '1667470862');
INSERT INTO `ey_users_config` VALUES ('9', 'memgift_open', '0', '', 'memgift', 'cn', '1667470862');
INSERT INTO `ey_users_config` VALUES ('10', 'order_right_protect_time', '7', '', 'order', 'cn', '1686204252');

-- -----------------------------
-- Table structure for `ey_users_focus`
-- -----------------------------
DROP TABLE IF EXISTS `ey_users_focus`;
CREATE TABLE `ey_users_focus` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `users_id` int(10) DEFAULT NULL,
  `usersname` varchar(255) DEFAULT NULL,
  `at_users_id` int(10) DEFAULT '0',
  `aid` int(10) DEFAULT '0' COMMENT '文档id',
  `channel` int(10) DEFAULT '0' COMMENT '模型',
  `typeid` int(10) DEFAULT '0' COMMENT '栏目',
  `title` varchar(50) DEFAULT '' COMMENT '网站标题',
  `litpic` varchar(255) DEFAULT '' COMMENT '缩略图',
  `images` varchar(255) DEFAULT NULL,
  `jobcount` int(10) DEFAULT '0',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=21 DEFAULT CHARSET=utf8 COMMENT='我的收藏';


-- -----------------------------
-- Table structure for `ey_users_footprint`
-- -----------------------------
DROP TABLE IF EXISTS `ey_users_footprint`;
CREATE TABLE `ey_users_footprint` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `channel` int(10) DEFAULT '0' COMMENT '频道模型',
  `typeid` int(10) DEFAULT '0' COMMENT '栏目id',
  `aid` int(10) DEFAULT '0' COMMENT '文档id',
  `title` varchar(100) DEFAULT '' COMMENT '网站标题',
  `litpic` varchar(255) DEFAULT '' COMMENT '缩略图',
  `users_id` int(10) DEFAULT '0',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `users_id` (`users_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='我的足迹';


-- -----------------------------
-- Table structure for `ey_users_forward`
-- -----------------------------
DROP TABLE IF EXISTS `ey_users_forward`;
CREATE TABLE `ey_users_forward` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `users_id` int(10) DEFAULT '0',
  `aid` int(10) DEFAULT '0' COMMENT '文档id',
  `channel` int(10) DEFAULT '0' COMMENT '模型',
  `typeid` int(10) DEFAULT '0' COMMENT '栏目',
  `title` varchar(200) DEFAULT '' COMMENT '网站标题',
  `litpic` varchar(255) DEFAULT '' COMMENT '缩略图',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='转发记录';


-- -----------------------------
-- Table structure for `ey_users_job`
-- -----------------------------
DROP TABLE IF EXISTS `ey_users_job`;
CREATE TABLE `ey_users_job` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `users_id` int(10) DEFAULT NULL,
  `moblie` varchar(200) DEFAULT '0',
  `at_users_id` int(10) NOT NULL DEFAULT '0',
  `aid` int(10) DEFAULT '0' COMMENT '文档id',
  `stutas` tinyint(1) NOT NULL DEFAULT '0' COMMENT '1合适,2不合适,3待定,4未接通',
  `channel` int(10) DEFAULT '0' COMMENT '模型',
  `typeid` int(10) DEFAULT '0' COMMENT '栏目',
  `title` varchar(50) DEFAULT '' COMMENT '网站标题',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=19 DEFAULT CHARSET=utf8 COMMENT='我的收藏';


-- -----------------------------
-- Table structure for `ey_users_level`
-- -----------------------------
DROP TABLE IF EXISTS `ey_users_level`;
CREATE TABLE `ey_users_level` (
  `level_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `level_name` varchar(30) DEFAULT '' COMMENT '级别名称',
  `level_value` int(10) DEFAULT '0' COMMENT '会员等级值',
  `is_system` tinyint(1) DEFAULT '0' COMMENT '类型，1=系统，0=用户',
  `amount` decimal(10,2) DEFAULT '0.00' COMMENT '消费额度',
  `down_count` int(10) DEFAULT '0' COMMENT '每天下载次数限制',
  `discount` float(10,2) DEFAULT '100.00' COMMENT '折扣率，初始值为100即100%，无折扣',
  `posts_count` int(10) DEFAULT '5' COMMENT '会员投稿次数限制',
  `ask_is_release` tinyint(1) DEFAULT '1' COMMENT '允许在问答中发布问题，1=是，0=否',
  `ask_is_review` tinyint(1) DEFAULT '0' COMMENT '在问答中发布问题或回答是否需要审核，1=是，0=否',
  `lang` varchar(20) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`level_id`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COMMENT='会员级别表';

-- -----------------------------
-- Records of `ey_users_level`
-- -----------------------------
INSERT INTO `ey_users_level` VALUES ('1', '注册会员', '10', '1', '0.00', '100', '100', '5', '1', '0', 'cn', '0', '1551151513');
INSERT INTO `ey_users_level` VALUES ('2', '中级会员', '50', '0', '0.00', '100', '100', '10', '1', '0', 'cn', '1613980347', '1613980347');
INSERT INTO `ey_users_level` VALUES ('3', '高级会员', '100', '0', '0.00', '100', '100', '20', '1', '0', 'cn', '1613980347', '1613980347');

-- -----------------------------
-- Table structure for `ey_users_like`
-- -----------------------------
DROP TABLE IF EXISTS `ey_users_like`;
CREATE TABLE `ey_users_like` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `users_id` int(10) DEFAULT '0',
  `aid` int(10) DEFAULT '0' COMMENT '文档id',
  `channel` int(10) DEFAULT '0' COMMENT '模型',
  `typeid` int(10) DEFAULT '0' COMMENT '栏目',
  `title` varchar(200) DEFAULT '' COMMENT '网站标题',
  `litpic` varchar(255) DEFAULT '' COMMENT '缩略图',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='我喜欢的';


-- -----------------------------
-- Table structure for `ey_users_list`
-- -----------------------------
DROP TABLE IF EXISTS `ey_users_list`;
CREATE TABLE `ey_users_list` (
  `list_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `users_id` int(10) NOT NULL DEFAULT '0' COMMENT '会员ID',
  `para_id` int(10) NOT NULL DEFAULT '0' COMMENT '属性ID',
  `info` text COMMENT '属性值',
  `lang` varchar(50) NOT NULL DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) NOT NULL DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`list_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='会员属性表(信息）';


-- -----------------------------
-- Table structure for `ey_users_login_log`
-- -----------------------------
DROP TABLE IF EXISTS `ey_users_login_log`;
CREATE TABLE `ey_users_login_log` (
  `log_id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '会员日志自增ID',
  `users_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '会员ID',
  `log_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '日志时间，年月日(例:20230406)',
  `log_count` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '日志次数',
  `add_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '创建时间',
  `update_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`log_id`),
  UNIQUE KEY `users_id` (`users_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='会员登录日志 - 用于登录赠送积分';


-- -----------------------------
-- Table structure for `ey_users_menu`
-- -----------------------------
DROP TABLE IF EXISTS `ey_users_menu`;
CREATE TABLE `ey_users_menu` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `title` varchar(30) DEFAULT '' COMMENT '导航名称',
  `version` varchar(10) DEFAULT 'weapp' COMMENT '分组',
  `mca` varchar(50) DEFAULT '' COMMENT '分组/控制器/操作名',
  `active_url` varchar(500) DEFAULT '' COMMENT '标记为选中的url',
  `is_userpage` tinyint(1) DEFAULT '0' COMMENT '默认会员首页',
  `sort_order` int(10) DEFAULT '0' COMMENT '排序号',
  `status` tinyint(1) DEFAULT '1' COMMENT '状态，1=显示，0=隐藏',
  `lang` varchar(20) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=12 DEFAULT CHARSET=utf8 COMMENT='会员菜单表';

-- -----------------------------
-- Records of `ey_users_menu`
-- -----------------------------
INSERT INTO `ey_users_menu` VALUES ('1', '个人信息', 'v1', 'user/Users/index', '', '1', '100', '1', 'cn', '1555904190', '1555917737');
INSERT INTO `ey_users_menu` VALUES ('2', '账户充值', 'v1', 'user/Pay/pay_consumer_details', '', '0', '100', '1', 'cn', '1555904190', '1555917761');
INSERT INTO `ey_users_menu` VALUES ('3', '商城中心', 'v1', 'user/Shop/shop_centre', '', '0', '100', '0', 'cn', '1555904190', '1555917761');
INSERT INTO `ey_users_menu` VALUES ('4', '会员升级', 'v1', 'user/Level/level_centre', '', '0', '100', '0', 'cn', '1555904190', '1555917761');
INSERT INTO `ey_users_menu` VALUES ('5', '会员投稿', 'v1', 'user/UsersRelease/release_centre', '', '0', '100', '0', 'cn', '1555904190', '1555917761');
INSERT INTO `ey_users_menu` VALUES ('6', '我的下载', 'v1', 'user/Download/index', '', '0', '100', '0', 'cn', '1590484667', '1613980400');
INSERT INTO `ey_users_menu` VALUES ('7', '个人中心', 'v2', 'user/Users/index', 'user/Users/index|user/Pay/pay_account_recharge|user/Users/footprint_index|user/Level/level_centre|user/Download/index|user/Users/media_index', '1', '100', '1', 'cn', '1608708057', '1609385363');
INSERT INTO `ey_users_menu` VALUES ('8', '我的信息', 'v2', 'user/Users/info', 'user/Users/info', '0', '100', '1', 'cn', '1608709100', '1609385363');
INSERT INTO `ey_users_menu` VALUES ('9', '我的收藏', 'v2', 'user/Users/collection_index', 'user/Users/collection_index', '0', '100', '1', 'cn', '1608708100', '1609385363');
INSERT INTO `ey_users_menu` VALUES ('10', '财务明细', 'v2', 'user/Pay/pay_consumer_details', 'user/Pay/pay_consumer_details|user/Users/score_index', '0', '100', '1', 'cn', '1608709000', '1609387813');
INSERT INTO `ey_users_menu` VALUES ('11', '我的收藏', 'v1', 'user/Users/collection_index', '', '0', '100', '1', 'cn', '1590484667', '1614651537');

-- -----------------------------
-- Table structure for `ey_users_mobilie`
-- -----------------------------
DROP TABLE IF EXISTS `ey_users_mobilie`;
CREATE TABLE `ey_users_mobilie` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `users_id` int(10) DEFAULT NULL,
  `usersname` varchar(255) DEFAULT NULL,
  `moblie` varchar(255) DEFAULT '0',
  `at_users_id` int(10) DEFAULT '0',
  `aid` int(10) DEFAULT '0' COMMENT '文档id',
  `channel` int(10) DEFAULT '0' COMMENT '模型',
  `typeid` int(10) DEFAULT '0' COMMENT '栏目',
  `title` varchar(50) DEFAULT '' COMMENT '网站标题',
  `litpic` varchar(255) DEFAULT '' COMMENT '缩略图',
  `images` varchar(255) DEFAULT NULL,
  `jobcount` int(10) DEFAULT '0',
  `pirce` decimal(10,2) DEFAULT '0.00',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=22 DEFAULT CHARSET=utf8 COMMENT='我的收藏';


-- -----------------------------
-- Table structure for `ey_users_money`
-- -----------------------------
DROP TABLE IF EXISTS `ey_users_money`;
CREATE TABLE `ey_users_money` (
  `moneyid` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '金额明细表ID',
  `users_id` int(10) DEFAULT '0' COMMENT '会员表ID',
  `money` decimal(10,2) DEFAULT '0.00' COMMENT '金额',
  `users_money` decimal(10,2) DEFAULT '0.00' COMMENT '此条记录的账户金额',
  `cause` text COMMENT '事由，暂时在升级消费中使用到，以serialize序列化后存入，用于后续查询。',
  `cause_type` tinyint(1) DEFAULT '0' COMMENT '数据类型,0-消费,1-充值,2-退款,3-订单支付,4-管理员添加,5-管理员减少',
  `status` tinyint(1) DEFAULT '1' COMMENT '是否成功，默认1，0失败，1未付款，2已付款，3已完成，4订单取消。',
  `pay_method` varchar(50) DEFAULT '' COMMENT '支付方式，wechat为微信支付，alipay为支付宝支付，balance为余额支付',
  `wechat_pay_type` varchar(20) NOT NULL DEFAULT '' COMMENT '微信支付时，标记使用的支付类型（扫码支付，微信内部，微信H5页面）',
  `pay_details` text COMMENT '支付时返回的数据，以serialize序列化后存入，用于后续查询。',
  `order_number` varchar(30) DEFAULT '' COMMENT '订单号',
  `level_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '会员升级时所升级的会员级别ID，默认0',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  `admin_id` int(10) DEFAULT '0' COMMENT '管理员表ID',
  PRIMARY KEY (`moneyid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='金额明细表';


-- -----------------------------
-- Table structure for `ey_users_notice`
-- -----------------------------
DROP TABLE IF EXISTS `ey_users_notice`;
CREATE TABLE `ey_users_notice` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(50) DEFAULT '' COMMENT '通知标题',
  `users_id` text NOT NULL COMMENT '用户id',
  `usernames` text NOT NULL COMMENT '用户名字符串',
  `remark` text COMMENT '通知信息',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='站内通知';


-- -----------------------------
-- Table structure for `ey_users_notice_read`
-- -----------------------------
DROP TABLE IF EXISTS `ey_users_notice_read`;
CREATE TABLE `ey_users_notice_read` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `users_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '用户id',
  `notice_id` int(10) DEFAULT NULL COMMENT '站内信id',
  `is_read` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否已读, 1---是, 0---否',
  `is_del` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否删除, 1---是, 0---否',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='用户已读站内通知';


-- -----------------------------
-- Table structure for `ey_users_notice_tpl`
-- -----------------------------
DROP TABLE IF EXISTS `ey_users_notice_tpl`;
CREATE TABLE `ey_users_notice_tpl` (
  `tpl_id` int(10) NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `tpl_name` varchar(200) DEFAULT '' COMMENT '模板名称',
  `tpl_title` varchar(200) DEFAULT '' COMMENT '站内信标题',
  `tpl_content` text COMMENT '发送内容',
  `send_scene` tinyint(1) DEFAULT '0' COMMENT '站内信发送场景(1=留言表单）',
  `is_open` tinyint(1) DEFAULT '0' COMMENT '是否开启使用这个模板，1为是，0为否。',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) DEFAULT '0' COMMENT '添加时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`tpl_id`)
) ENGINE=MyISAM AUTO_INCREMENT=7 DEFAULT CHARSET=utf8 COMMENT='站内信模板表';

-- -----------------------------
-- Records of `ey_users_notice_tpl`
-- -----------------------------
INSERT INTO `ey_users_notice_tpl` VALUES ('1', '留言表单', '您有新的留言消息，请到内容管理中查看！', '${content}', '1', '1', 'cn', '1667470612', '1667470612');
INSERT INTO `ey_users_notice_tpl` VALUES ('5', '订单付款', '您有新的待发货订单消息，请到商城订单查看！', '${content}', '5', '1', 'cn', '1667470612', '1667470612');
INSERT INTO `ey_users_notice_tpl` VALUES ('6', '订单发货', '您有新的待收货订单消息，请到会员订单查看！', '${content}', '6', '1', 'cn', '1667470612', '1667470612');

-- -----------------------------
-- Table structure for `ey_users_notice_tpl_content`
-- -----------------------------
DROP TABLE IF EXISTS `ey_users_notice_tpl_content`;
CREATE TABLE `ey_users_notice_tpl_content` (
  `content_id` int(10) NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `source` tinyint(1) DEFAULT '0' COMMENT '来源，对应 users_notice_tpl 表 send_scene 字段',
  `admin_id` int(10) DEFAULT '0' COMMENT '管理员ID，不为空则表示管理员接收信息',
  `users_id` int(10) DEFAULT '0' COMMENT '用户ID，不为空则表示会员接收信息，暂未使用',
  `content_title` varchar(200) DEFAULT '' COMMENT '通知标题',
  `content` text COMMENT '接收的通知内容',
  `is_read` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否已读，默认0，1是，0否',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`content_id`),
  KEY `admin_id` (`admin_id`) USING BTREE,
  KEY `users_id` (`users_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='站内信发送接收记录表';


-- -----------------------------
-- Table structure for `ey_users_parameter`
-- -----------------------------
DROP TABLE IF EXISTS `ey_users_parameter`;
CREATE TABLE `ey_users_parameter` (
  `para_id` int(10) NOT NULL AUTO_INCREMENT COMMENT 'id',
  `title` varchar(100) NOT NULL DEFAULT '' COMMENT '标题',
  `name` varchar(100) NOT NULL DEFAULT '' COMMENT '名称',
  `dtype` varchar(32) NOT NULL DEFAULT '' COMMENT '字段类型',
  `dfvalue` varchar(1000) NOT NULL DEFAULT '' COMMENT '默认值',
  `is_system` tinyint(1) DEFAULT '0' COMMENT '是否为系统属性，系统属性不可删除，1为是，0为否，默认0。',
  `is_hidden` tinyint(1) DEFAULT '0' COMMENT '是否禁用属性，1为是，0为否',
  `is_required` tinyint(1) DEFAULT '0' COMMENT '是否为必填属性，1为是，0为否，默认0。',
  `is_reg` tinyint(1) DEFAULT '1' COMMENT '是否为注册表单，1为是，0为否',
  `placeholder` varchar(255) DEFAULT '' COMMENT '提示文字',
  `sort_order` smallint(5) NOT NULL DEFAULT '0' COMMENT '排序',
  `lang` varchar(50) NOT NULL DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) NOT NULL DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`para_id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COMMENT='会员属性表(字段)';

-- -----------------------------
-- Records of `ey_users_parameter`
-- -----------------------------
INSERT INTO `ey_users_parameter` VALUES ('1', '手机号码', 'mobile_1', 'mobile', '', '1', '0', '0', '1', '', '1', 'cn', '0', '1613980400');
INSERT INTO `ey_users_parameter` VALUES ('2', '邮箱地址', 'email_2', 'email', '', '1', '0', '1', '1', '', '1', 'cn', '0', '1613980400');

-- -----------------------------
-- Table structure for `ey_users_score`
-- -----------------------------
DROP TABLE IF EXISTS `ey_users_score`;
CREATE TABLE `ey_users_score` (
  `id` int(10) NOT NULL AUTO_INCREMENT COMMENT '积分明细表',
  `type` tinyint(2) DEFAULT '1' COMMENT '类型:1-提问,2-回答,3-最佳答案4-悬赏退回,5-每日签到,6-管理员编辑,7-问题悬赏/获得悬赏,8-消费赠送积分,9-积分兑换/退回,10-登录赠送积分',
  `users_id` int(10) DEFAULT '0' COMMENT '用户id',
  `ask_id` int(10) DEFAULT '0' COMMENT '问题id',
  `reply_id` int(10) DEFAULT '0' COMMENT '回答id',
  `score` varchar(20) NOT NULL DEFAULT '' COMMENT '积分',
  `devote` int(10) DEFAULT '0' COMMENT '贡献值,同score',
  `money` decimal(8,2) NOT NULL DEFAULT '0.00' COMMENT '余额',
  `info` varchar(255) DEFAULT '' COMMENT '说明',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(10) DEFAULT '0' COMMENT '创建时间',
  `update_time` int(10) DEFAULT '0' COMMENT '更新时间',
  `current_score` int(10) DEFAULT '0' COMMENT '当前积分',
  `current_devote` int(10) DEFAULT '0' COMMENT '当前贡献值',
  `admin_id` int(10) DEFAULT '0' COMMENT '管理员表ID',
  `remark` varchar(255) DEFAULT '' COMMENT '备注',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='积分详情表';


-- -----------------------------
-- Table structure for `ey_users_signin`
-- -----------------------------
DROP TABLE IF EXISTS `ey_users_signin`;
CREATE TABLE `ey_users_signin` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `users_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '用户id',
  `lang` varchar(50) NOT NULL DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '签到时间',
  PRIMARY KEY (`id`),
  KEY `users_id` (`users_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='用户签到表';


-- -----------------------------
-- Table structure for `ey_users_type_manage`
-- -----------------------------
DROP TABLE IF EXISTS `ey_users_type_manage`;
CREATE TABLE `ey_users_type_manage` (
  `type_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `type_name` varchar(30) DEFAULT '' COMMENT '类型名称',
  `level_id` int(10) DEFAULT '0' COMMENT '会员等级ID',
  `price` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '价格',
  `limit_id` int(10) DEFAULT '0' COMMENT '会员期限限制，存储ID，值对应常量表的admin_member_limit_arr数组',
  `activity` varchar(30) DEFAULT '' COMMENT '活动文案',
  `sort_order` smallint(5) NOT NULL DEFAULT '0' COMMENT '排序',
  `lang` varchar(20) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`type_id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COMMENT='会员产品类型表';

-- -----------------------------
-- Records of `ey_users_type_manage`
-- -----------------------------
INSERT INTO `ey_users_type_manage` VALUES ('1', '升级为本站中级会员', '2', '100.00', '2', '', '100', 'cn', '1613980347', '1613980347');
INSERT INTO `ey_users_type_manage` VALUES ('2', '升级为本站高级会员', '3', '200.00', '3', '', '100', 'cn', '1613980347', '1613980347');

-- -----------------------------
-- Table structure for `ey_verifier`
-- -----------------------------
DROP TABLE IF EXISTS `ey_verifier`;
CREATE TABLE `ey_verifier` (
  `id` int(10) NOT NULL AUTO_INCREMENT COMMENT '核销员',
  `users_id` int(10) DEFAULT '0' COMMENT '用户id',
  `points_id` int(10) DEFAULT '0' COMMENT '所属提货点(pick_up_points表id)',
  `name` varchar(55) DEFAULT '' COMMENT '核销员名称',
  `mobile` varchar(55) DEFAULT '' COMMENT '手机号码',
  `status` tinyint(1) DEFAULT '0' COMMENT '核销状态 开启   关闭\r\n核销状态 开启   关闭\r\n核销状态,0-开启   1-关闭',
  `add_time` int(10) DEFAULT '0',
  `update_time` int(10) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='核销员表';


-- -----------------------------
-- Table structure for `ey_video_content`
-- -----------------------------
DROP TABLE IF EXISTS `ey_video_content`;
CREATE TABLE `ey_video_content` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `aid` int(10) DEFAULT '0' COMMENT '文档ID',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  `vdsrc` varchar(200) NOT NULL DEFAULT '' COMMENT '视频地址',
  PRIMARY KEY (`id`),
  KEY `aid` (`aid`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 COMMENT='附加表';

-- -----------------------------
-- Records of `ey_video_content`
-- -----------------------------
INSERT INTO `ey_video_content` VALUES ('1', '13', '1552364595', '1552364595', 'http://player.youku.com/embed/XMzU1NzU5MzM4MA==');
INSERT INTO `ey_video_content` VALUES ('2', '14', '1552364689', '1552364689', 'http://player.youku.com/embed/XMzYyOTQ2MjA5Mg==');
INSERT INTO `ey_video_content` VALUES ('3', '52', '1552382177', '1552382177', 'http://player.youku.com/embed/XMzU1NzU5MzM4MA==');
INSERT INTO `ey_video_content` VALUES ('4', '53', '1552382208', '1552382208', 'http://player.youku.com/embed/XMzYyOTQ2MjA5Mg==');

-- -----------------------------
-- Table structure for `ey_videos_content`
-- -----------------------------
DROP TABLE IF EXISTS `ey_videos_content`;
CREATE TABLE `ey_videos_content` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `aid` int(10) DEFAULT '0' COMMENT '文档ID',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  `video_pic` varchar(250) NOT NULL DEFAULT '' COMMENT '视频封面',
  `video_url` varchar(200) NOT NULL DEFAULT '' COMMENT '视频地址',
  `video_content` longtext COMMENT '视频内容',
  PRIMARY KEY (`id`),
  KEY `aid` (`aid`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COMMENT='附加表';

-- -----------------------------
-- Records of `ey_videos_content`
-- -----------------------------
INSERT INTO `ey_videos_content` VALUES ('2', '29', '1642169160', '1642169160', '/uploads/allimg/20220114/1-220114220523E7.jpg', '/uploads/media/20220114/1-220114220534Z1.mp4', '&lt;p&gt;我会披星戴月不辞万里&lt;/p&gt;&lt;p&gt;抛下世俗的一切奔向你&lt;/p&gt;');
INSERT INTO `ey_videos_content` VALUES ('3', '63', '1642176537', '1642176537', '/uploads/allimg/20220115/1-220115000545135.jpg', '/uploads/media/20220115/1-220115000433223.mp4', '&lt;p&gt;请给好运一点时间，一切都在变好的路上，加油！&lt;/p&gt;');

-- -----------------------------
-- Table structure for `ey_weapp`
-- -----------------------------
DROP TABLE IF EXISTS `ey_weapp`;
CREATE TABLE `ey_weapp` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `code` varchar(50) DEFAULT '' COMMENT '插件标识',
  `name` varchar(55) DEFAULT '' COMMENT '中文名字',
  `config` text COMMENT '配置信息',
  `data` text COMMENT '额外序列化存储数据，简单插件可以不创建表，存储这里即可',
  `status` tinyint(1) DEFAULT '0' COMMENT '状态：0=未安装，1=启用，-1=禁用',
  `tag_weapp` tinyint(1) DEFAULT '1' COMMENT '1=自动绑定，2=手工调用。关联模板标签weapp，自动调用内置的show钩子方法',
  `thorough` tinyint(1) DEFAULT '0' COMMENT '彻底卸载：0=是，1=否',
  `position` varchar(30) DEFAULT 'default' COMMENT '插件位置',
  `is_buy` tinyint(1) DEFAULT '0' COMMENT '0-本地,1-线上购买 2-线上购买,但已删除,不显示在我的插件列表',
  `is_upgrade` tinyint(1) DEFAULT '1' COMMENT '是否提示升级',
  `sort_order` int(10) DEFAULT '100' COMMENT '排序号',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  `quick_sort` int(10) DEFAULT '100' COMMENT '首页快捷菜单专用排序号',
  `checked` tinyint(4) DEFAULT '0' COMMENT '选中，0=否，1=是(首页快捷菜单用)',
  PRIMARY KEY (`id`),
  KEY `code` (`code`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COMMENT='插件应用表';


-- -----------------------------
-- Table structure for `ey_weapp_ask`
-- -----------------------------
DROP TABLE IF EXISTS `ey_weapp_ask`;
CREATE TABLE `ey_weapp_ask` (
  `ask_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `type_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '问题栏目ID',
  `users_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '会员ID',
  `ask_title` varchar(80) NOT NULL DEFAULT '' COMMENT '问题标题',
  `is_recom` tinyint(1) NOT NULL DEFAULT '0' COMMENT '问题是否推荐',
  `status` tinyint(1) NOT NULL DEFAULT '0' COMMENT '问题状态：0未解决，1已解决，2已关闭',
  `click` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '浏览点击量',
  `replies` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '问题回复量',
  `content` text NOT NULL COMMENT '问题内容',
  `url` varchar(255) NOT NULL DEFAULT '' COMMENT '问题网址',
  `users_ip` varchar(50) NOT NULL DEFAULT '' COMMENT '问题发布时IP地址',
  `is_review` tinyint(1) NOT NULL DEFAULT '1' COMMENT '问题是否审核，1是，0否',
  `follow` tinyint(1) NOT NULL DEFAULT '0' COMMENT '关注问题则表示有回复时发送邮件通知到问题发布人',
  `solve_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '解决时间(这个问题存在最佳答案则表示已解决)',
  `bestanswer_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '最佳答案',
  `sort_order` int(10) NOT NULL DEFAULT '100' COMMENT '排序号',
  `add_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '新增时间',
  `update_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  `money` int(10) NOT NULL DEFAULT '0' COMMENT '悬赏金额',
  `is_top` tinyint(1) DEFAULT '0' COMMENT '是否置顶',
  PRIMARY KEY (`ask_id`)
) ENGINE=MyISAM AUTO_INCREMENT=12 DEFAULT CHARSET=utf8 COMMENT='问题表';

-- -----------------------------
-- Records of `ey_weapp_ask`
-- -----------------------------
INSERT INTO `ey_weapp_ask` VALUES ('11', '5', '18', '龙东社区组织收看二十大开幕式', '1', '0', '63', '0', '&lt;p&gt;&lt;img src=&quot;/uploads/weapp/user/18/20221016/18-221016112JUC.jpg&quot; title=&quot;&quot; alt=&quot;微信图片_20221016112700.jpg&quot;/&gt;&lt;/p&gt;', '', '222.211.11.56', '1', '0', '0', '0', '100', '1665890889', '1667314953', '0', '0');
INSERT INTO `ey_weapp_ask` VALUES ('10', '14', '9', '涪江河畔', '1', '0', '69', '0', '&lt;p&gt;&lt;img src=&quot;/uploads/weapp/user/9/20221016/9-22101611220Y93.JPG&quot; title=&quot;&quot; alt=&quot;DJI_0147.JPG&quot;/&gt;&lt;/p&gt;', '', '222.211.11.56', '1', '0', '0', '0', '100', '1665890407', '1667286812', '0', '0');
INSERT INTO `ey_weapp_ask` VALUES ('8', '7', '9', '龙凤城乡环境综合提质', '1', '1', '89', '1', '&lt;p&gt;**村垃圾池垃圾较多，已经外溢请及时清理！&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;/uploads/weapp/user/9/20221014/9-2210141036041W.jpeg&quot; title=&quot;&quot; alt=&quot;aad2b602dc2e4e3ba8fabc78617987e8.jpeg&quot;/&gt;&lt;/p&gt;', '', '222.211.11.56', '1', '0', '1665715038', '19', '100', '1665714967', '1667328905', '0', '0');
INSERT INTO `ey_weapp_ask` VALUES ('9', '5', '9', '寻找有缘人（有奖励）', '1', '1', '184', '5', '&lt;p&gt;寻找此贴回帖人，第一个回帖者奖励500积分！（积分可升级会员，可以悬赏，可以兑现礼品！）&lt;/p&gt;&lt;p&gt;第10名回帖者奖励积分100&lt;/p&gt;&lt;p&gt;第20名回帖者奖励积分200&lt;/p&gt;&lt;p&gt;第30名回帖者奖励积分300&lt;/p&gt;&lt;p&gt;第40名回帖者奖励积分400&lt;/p&gt;&lt;p&gt;........&lt;/p&gt;&lt;p&gt;100名以后不再奖励&lt;/p&gt;&lt;p&gt;重复者以最高排名只奖励一次&lt;/p&gt;&lt;p&gt;依次类推.......&lt;/p&gt;', '', '183.223.44.47', '1', '0', '1665889723', '20', '100', '1665763763', '1667369420', '500', '0');

-- -----------------------------
-- Table structure for `ey_weapp_ask_answer`
-- -----------------------------
DROP TABLE IF EXISTS `ey_weapp_ask_answer`;
CREATE TABLE `ey_weapp_ask_answer` (
  `answer_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `ask_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '问题ID',
  `is_bestanswer` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否最佳答案，0否，1是',
  `is_review` tinyint(1) NOT NULL DEFAULT '1' COMMENT '问题是否审核，1是，0否',
  `type_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '问题栏目ID',
  `users_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '用户ID',
  `username` varchar(50) NOT NULL DEFAULT '' COMMENT '用户名',
  `click_like` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '点赞量',
  `users_ip` varchar(30) NOT NULL DEFAULT '' COMMENT '用户IP地址',
  `content` text NOT NULL COMMENT '内容',
  `ifcheck` tinyint(1) NOT NULL DEFAULT '1',
  `answer_pid` int(10) NOT NULL DEFAULT '0' COMMENT '子答案的父答案',
  `at_users_id` int(10) NOT NULL DEFAULT '0' COMMENT '被@的用户ID',
  `at_answer_id` int(10) NOT NULL DEFAULT '0' COMMENT '@答案ID',
  `add_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '新增时间',
  `update_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`answer_id`)
) ENGINE=MyISAM AUTO_INCREMENT=25 DEFAULT CHARSET=utf8 COMMENT='答案表';

-- -----------------------------
-- Records of `ey_weapp_ask_answer`
-- -----------------------------
INSERT INTO `ey_weapp_ask_answer` VALUES ('19', '8', '1', '1', '7', '9', 'jymjzx', '1', '222.211.11.56', '&lt;p&gt;我们已收到，即将组织村社区落实清理！&lt;/p&gt;', '1', '0', '0', '0', '1665714996', '1665715041');
INSERT INTO `ey_weapp_ask_answer` VALUES ('20', '9', '1', '1', '5', '16', 'lqxyklsy', '1', '101.206.166.237', '&lt;p&gt;……&lt;/p&gt;', '1', '0', '0', '0', '1665877741', '1665889721');
INSERT INTO `ey_weapp_ask_answer` VALUES ('21', '9', '0', '1', '5', '9', 'jymjzx', '0', '222.211.11.56', '你的积分已到账', '1', '20', '0', '0', '1665890616', '1665890624');
INSERT INTO `ey_weapp_ask_answer` VALUES ('22', '9', '0', '1', '5', '23', '涛哥哥', '0', '110.186.60.154', '这个帖子是啥意思？', '1', '20', '0', '0', '1666573753', '1666574116');
INSERT INTO `ey_weapp_ask_answer` VALUES ('24', '9', '0', '1', '5', '9', 'jymjzx', '0', '222.211.11.56', '积分奖励贴，以后积分可以累计有奖励哦', '1', '20', '0', '0', '1666574276', '1666574283');

-- -----------------------------
-- Table structure for `ey_weapp_ask_answer_like`
-- -----------------------------
DROP TABLE IF EXISTS `ey_weapp_ask_answer_like`;
CREATE TABLE `ey_weapp_ask_answer_like` (
  `like_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `ask_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '问题ID',
  `answer_id` int(10) NOT NULL DEFAULT '0' COMMENT '答案ID',
  `users_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '用户ID',
  `click_like` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '点赞',
  `users_ip` varchar(30) NOT NULL DEFAULT '' COMMENT '用户IP地址',
  `add_time` int(10) unsigned NOT NULL DEFAULT '0',
  `update_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`like_id`)
) ENGINE=MyISAM AUTO_INCREMENT=8 DEFAULT CHARSET=utf8 COMMENT='答案点赞表';

-- -----------------------------
-- Records of `ey_weapp_ask_answer_like`
-- -----------------------------
INSERT INTO `ey_weapp_ask_answer_like` VALUES ('6', '8', '19', '9', '1', '222.211.11.56', '1665715041', '1665715041');
INSERT INTO `ey_weapp_ask_answer_like` VALUES ('7', '9', '20', '9', '1', '222.211.11.56', '1665889721', '1665889721');

-- -----------------------------
-- Table structure for `ey_weapp_ask_type`
-- -----------------------------
DROP TABLE IF EXISTS `ey_weapp_ask_type`;
CREATE TABLE `ey_weapp_ask_type` (
  `type_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '栏目自增',
  `type_name` varchar(100) NOT NULL DEFAULT '' COMMENT '栏目名称',
  `parent_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '上级ID',
  `seo_title` varchar(200) NOT NULL DEFAULT '',
  `seo_keywords` varchar(200) NOT NULL DEFAULT '',
  `seo_description` varchar(500) NOT NULL DEFAULT '',
  `sort_order` int(10) unsigned NOT NULL DEFAULT '100' COMMENT '排序号',
  `add_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '新增时间',
  `update_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`type_id`)
) ENGINE=MyISAM AUTO_INCREMENT=15 DEFAULT CHARSET=utf8 COMMENT='问题栏目分类表';

-- -----------------------------
-- Records of `ey_weapp_ask_type`
-- -----------------------------
INSERT INTO `ey_weapp_ask_type` VALUES ('1', '新人报道', '0', '', '', '', '100', '1565770890', '1665714452');
INSERT INTO `ey_weapp_ask_type` VALUES ('2', '我要举报', '0', '', '', '', '100', '1565770890', '1665714452');
INSERT INTO `ey_weapp_ask_type` VALUES ('3', '我要写信', '0', '', '', '', '100', '1565770890', '1665714452');
INSERT INTO `ey_weapp_ask_type` VALUES ('4', '留言区', '1', '', '', '', '100', '1565771021', '1665714452');
INSERT INTO `ey_weapp_ask_type` VALUES ('5', '灌水区', '1', '', '', '', '100', '1565771021', '1665714452');
INSERT INTO `ey_weapp_ask_type` VALUES ('6', '信访举报', '2', '', '', '', '100', '1665714336', '1665714452');
INSERT INTO `ey_weapp_ask_type` VALUES ('7', '城乡环境综合提质举报', '2', '', '', '', '100', '1665714336', '1665714452');
INSERT INTO `ey_weapp_ask_type` VALUES ('8', '不文明现象举报', '2', '', '', '', '100', '1665714336', '1665714452');
INSERT INTO `ey_weapp_ask_type` VALUES ('9', '乱停乱放举报', '2', '', '', '', '100', '1665714336', '1665714452');
INSERT INTO `ey_weapp_ask_type` VALUES ('10', '其他举报', '2', '', '', '', '100', '1665714336', '1665714452');
INSERT INTO `ey_weapp_ask_type` VALUES ('11', '书记信箱', '3', '', '', '', '100', '1665714394', '1665714452');
INSERT INTO `ey_weapp_ask_type` VALUES ('12', '镇长信箱', '3', '', '', '', '100', '1665714394', '1665714452');
INSERT INTO `ey_weapp_ask_type` VALUES ('13', '意见建议', '0', '', '', '', '100', '1665714452', '1665714452');
INSERT INTO `ey_weapp_ask_type` VALUES ('14', '龙凤美景图集', '0', '', '', '', '100', '1665714452', '1665714452');

-- -----------------------------
-- Table structure for `ey_weapp_ask_users_level`
-- -----------------------------
DROP TABLE IF EXISTS `ey_weapp_ask_users_level`;
CREATE TABLE `ey_weapp_ask_users_level` (
  `level_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `level_name` varchar(30) DEFAULT '' COMMENT '级别名称',
  `level_value` int(10) DEFAULT '0' COMMENT '会员等级值',
  `ask_count` int(10) DEFAULT '5' COMMENT '发布问答次数限制',
  `answer_count` int(10) DEFAULT '0' COMMENT '回复问答次数限制',
  `ask_is_release` tinyint(1) DEFAULT '1' COMMENT '允许在问答中发布问题，1=是，0=否',
  `ask_is_review` tinyint(1) DEFAULT '0' COMMENT '在问答中发布问题或回答是否需要审核，1=是，0=否',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`level_id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 COMMENT='上传记录表';

-- -----------------------------
-- Records of `ey_weapp_ask_users_level`
-- -----------------------------
INSERT INTO `ey_weapp_ask_users_level` VALUES ('1', '注册会员', '10', '2', '5', '1', '1', '0', '1665889844');
INSERT INTO `ey_weapp_ask_users_level` VALUES ('2', '中级会员', '50', '3', '5', '1', '1', '0', '1665889849');
INSERT INTO `ey_weapp_ask_users_level` VALUES ('3', '高级会员', '100', '5', '5', '1', '1', '0', '1665889856');
INSERT INTO `ey_weapp_ask_users_level` VALUES ('4', '荣誉会员', '1000', '10', '5', '1', '1', '0', '1665889838');

-- -----------------------------
-- Table structure for `ey_weapp_bshoucang`
-- -----------------------------
DROP TABLE IF EXISTS `ey_weapp_bshoucang`;
CREATE TABLE `ey_weapp_bshoucang` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(50) DEFAULT '' COMMENT '网站标题',
  `url` varchar(100) DEFAULT '' COMMENT '网站地址',
  `logo` varchar(255) DEFAULT '' COMMENT '网站LOGO',
  `sort_order` int(11) DEFAULT '0' COMMENT '排序号',
  `target` tinyint(1) DEFAULT '0' COMMENT '是否开启浏览器新窗口',
  `intro` text COMMENT '网站简况',
  `status` tinyint(1) DEFAULT '1' COMMENT '状态(1=显示，0=屏蔽)',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=6 DEFAULT CHARSET=utf8;


-- -----------------------------
-- Table structure for `ey_weapp_collection`
-- -----------------------------
DROP TABLE IF EXISTS `ey_weapp_collection`;
CREATE TABLE `ey_weapp_collection` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `users_id` int(10) DEFAULT NULL,
  `title` varchar(50) DEFAULT '' COMMENT '网站标题',
  `url` varchar(100) DEFAULT '' COMMENT '网站地址',
  `lang` varchar(50) DEFAULT '' COMMENT '语言标识',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

-- -----------------------------
-- Records of `ey_weapp_collection`
-- -----------------------------
INSERT INTO `ey_weapp_collection` VALUES ('2', '2', '袋式除尘器处理风量是怎么计算', '29', 'cn', '1609829251', '1609829251');

-- -----------------------------
-- Table structure for `ey_weapp_comment`
-- -----------------------------
DROP TABLE IF EXISTS `ey_weapp_comment`;
CREATE TABLE `ey_weapp_comment` (
  `comment_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `aid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '文档ID',
  `is_bestanswer` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否最佳答案，0否，1是',
  `is_review` tinyint(1) NOT NULL DEFAULT '1' COMMENT '问题是否审核，1是，0否',
  `users_id` int(10) NOT NULL DEFAULT '0' COMMENT '评论用户ID',
  `username` varchar(50) NOT NULL DEFAULT '' COMMENT '评论用户名',
  `click_like` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '点赞量',
  `users_ip` varchar(30) NOT NULL DEFAULT '' COMMENT '用户IP地址',
  `content` text NOT NULL COMMENT '内容',
  `pid` int(10) NOT NULL DEFAULT '0' COMMENT '子评论的父评论',
  `at_users_id` int(10) NOT NULL DEFAULT '0' COMMENT '被@的用户ID',
  `at_comment_id` int(10) NOT NULL DEFAULT '0' COMMENT '@答案ID',
  `add_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '新增时间',
  `update_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  `provider` varchar(50) NOT NULL DEFAULT '' COMMENT '服务商标识，比如：weixin、baidu',
  PRIMARY KEY (`comment_id`),
  KEY `aid` (`aid`),
  KEY `users_id` (`users_id`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COMMENT='文档评论回复表';

-- -----------------------------
-- Records of `ey_weapp_comment`
-- -----------------------------
INSERT INTO `ey_weapp_comment` VALUES ('1', '62', '0', '1', '9', 'jymjzx', '1', '222.211.11.56', '&lt;p&gt;点赞！&lt;/p&gt;', '0', '0', '0', '1665729258', '1665729305', '');
INSERT INTO `ey_weapp_comment` VALUES ('2', '62', '0', '1', '9', 'jymjzx', '0', '222.211.11.56', '支持', '1', '0', '0', '1665729282', '1665729293', '');
INSERT INTO `ey_weapp_comment` VALUES ('3', '83', '0', '0', '13', 'fzl2002', '0', '183.223.44.47', '&lt;p&gt;爱路护路，保障平安！&lt;/p&gt;', '0', '0', '0', '1666274118', '1666274118', '');

-- -----------------------------
-- Table structure for `ey_weapp_comment_level`
-- -----------------------------
DROP TABLE IF EXISTS `ey_weapp_comment_level`;
CREATE TABLE `ey_weapp_comment_level` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `users_level_id` int(10) NOT NULL DEFAULT '0' COMMENT '会员级别ID',
  `is_comment` tinyint(1) NOT NULL DEFAULT '1' COMMENT '是否允许评论文档',
  `is_review` tinyint(1) NOT NULL DEFAULT '0' COMMENT '评论是否需要审核',
  `add_time` int(10) NOT NULL DEFAULT '0' COMMENT '新增时间',
  `update_time` int(10) NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=6 DEFAULT CHARSET=utf8 COMMENT='评论级别表';

-- -----------------------------
-- Records of `ey_weapp_comment_level`
-- -----------------------------
INSERT INTO `ey_weapp_comment_level` VALUES ('1', '0', '0', '1', '1572418214', '1572418214');
INSERT INTO `ey_weapp_comment_level` VALUES ('2', '1', '1', '1', '1665729050', '1665729238');
INSERT INTO `ey_weapp_comment_level` VALUES ('3', '2', '1', '1', '1665729050', '1665729239');
INSERT INTO `ey_weapp_comment_level` VALUES ('4', '3', '1', '1', '1665729050', '1665729240');
INSERT INTO `ey_weapp_comment_level` VALUES ('5', '4', '1', '0', '1665804469', '0');

-- -----------------------------
-- Table structure for `ey_weapp_comment_like`
-- -----------------------------
DROP TABLE IF EXISTS `ey_weapp_comment_like`;
CREATE TABLE `ey_weapp_comment_like` (
  `like_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `aid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '文档ID',
  `comment_id` int(10) NOT NULL DEFAULT '0' COMMENT '评论ID',
  `users_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '点赞用户ID',
  `click_like` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '点赞',
  `users_ip` varchar(20) NOT NULL DEFAULT '' COMMENT '用户IP地址',
  `add_time` int(10) unsigned NOT NULL DEFAULT '0',
  `update_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`like_id`),
  KEY `aid` (`aid`,`comment_id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COMMENT='文档评论点赞表';

-- -----------------------------
-- Records of `ey_weapp_comment_like`
-- -----------------------------
INSERT INTO `ey_weapp_comment_like` VALUES ('1', '62', '1', '9', '1', '222.211.11.56', '1665729305', '1665729305');

-- -----------------------------
-- Table structure for `ey_weapp_demo`
-- -----------------------------
DROP TABLE IF EXISTS `ey_weapp_demo`;
CREATE TABLE `ey_weapp_demo` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `typeid` tinyint(1) DEFAULT '1' COMMENT '类型：1=文字链接，2=图片链接',
  `title` varchar(50) DEFAULT '' COMMENT '网站标题',
  `url` varchar(100) DEFAULT '' COMMENT '网站地址',
  `logo` varchar(255) DEFAULT '' COMMENT '网站LOGO',
  `sort_order` int(11) DEFAULT '0' COMMENT '排序号',
  `target` tinyint(1) DEFAULT '0' COMMENT '是否开启浏览器新窗口',
  `email` varchar(50) DEFAULT NULL,
  `intro` text COMMENT '网站简况',
  `status` tinyint(1) DEFAULT '1' COMMENT '状态(1=显示，0=屏蔽)',
  `delete_time` int(11) DEFAULT '0' COMMENT '软删除时间',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=6 DEFAULT CHARSET=utf8;

-- -----------------------------
-- Records of `ey_weapp_demo`
-- -----------------------------
INSERT INTO `ey_weapp_demo` VALUES ('2', '1', '易优CMS', 'http://www.eyoucms.com', '', '100', '1', '', '', '1', '0', '1524975826', '0');
INSERT INTO `ey_weapp_demo` VALUES ('3', '2', '织梦58', 'http://www.dede58.com', 'http://www.eyoucms.dev/public/upload/system/2018/04/29/814ece093a0ba636209255dc20bd6e62.png', '100', '0', '', '', '1', '0', '1524976095', '1524976135');
INSERT INTO `ey_weapp_demo` VALUES ('4', '1', 'ThinkPHP官网', 'http://www.thinkphp.cn', '', '100', '1', '', '', '1', '0', '1525266497', '1525266608');
INSERT INTO `ey_weapp_demo` VALUES ('5', '1', '微信小程序开发教程', 'http://www.yiyongtong.com', '', '100', '1', '', '', '1', '0', '1525748425', '0');

-- -----------------------------
-- Table structure for `ey_weapp_diyminipro_mall`
-- -----------------------------
DROP TABLE IF EXISTS `ey_weapp_diyminipro_mall`;
CREATE TABLE `ey_weapp_diyminipro_mall` (
  `mini_id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '模板ID',
  `categoryid` int(11) NOT NULL DEFAULT '0' COMMENT '分类ID',
  `name` varchar(100) NOT NULL DEFAULT '' COMMENT '模板标题',
  `litpic` varchar(250) NOT NULL DEFAULT '' COMMENT '封面图',
  `component` text NOT NULL COMMENT '组件库',
  `mchid` varchar(50) NOT NULL DEFAULT '' COMMENT '微信支付商户号',
  `apikey` varchar(250) NOT NULL DEFAULT '' COMMENT '微信支付密钥',
  `status` tinyint(1) NOT NULL DEFAULT '0' COMMENT '状态：4=审核中，5=发布',
  `cloud_id` int(10) NOT NULL DEFAULT '0' COMMENT '云ID',
  `config` text NOT NULL COMMENT '相关序列化信息',
  `is_del` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '伪删除，1=是，0=否',
  `lang` varchar(10) NOT NULL DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`mini_id`)
) ENGINE=MyISAM AUTO_INCREMENT=6 DEFAULT CHARSET=utf8 COMMENT='微信小程序记录表';

-- -----------------------------
-- Records of `ey_weapp_diyminipro_mall`
-- -----------------------------
INSERT INTO `ey_weapp_diyminipro_mall` VALUES ('3', '39', '购物商城', 'https://service.eyysz.cn/uploads/allimg/20200514/1-200514103G4249.png', 'f1f0UQFSAwMDAwEJUgYFAgBWAAoIAQ8DU1BTVVFWC1dBAloPVBAfWl5SVlwxDFlRDwZJUFkMWQBDGhVfXlELThkCQRVYAV9WH1ReVgYWG0AKBwBdFBFSBENVChpeWhBQVgYfD1AUcVJBH0NQAQ1jUxsXSUFdEEEMUlNOWVZTDVpcAl8gUgFcRl1HHVsOBFldTwQQW1wHGwlYQAcaXFwSXHkKQBUdAVxGQ1xfFRENVkQTJApdXBEbBl5YFldZWwFLdxZHFV4MH1BcXUVYCwtSRCoOBFVdTlQKX0IDX15QFm1QG0c', '', '', '0', '58', 'eyJjb3B5cmlnaHQiOjEsIm1lYWxfdHlwZSI6MH0=', '0', 'cn', '1589423797', '1666759073');
INSERT INTO `ey_weapp_diyminipro_mall` VALUES ('4', '1', '默认商城风格', 'https://service.eyysz.cn/uploads/allimg/20200514/1-200514103G4249.png', '8d9bBlFRVQYIVgkJAg5VAAcEAVNWAVdWWVNSUwZUVQwLVEAaFggLUlcRFVhATAwFDlcVQF0BBglNFwQEEFVcTgteRl8CBElYWRB7WEAUFw8BWm1TTBFPFQQWFwwBUxgACVBcXU0GEF9cAxVeXVcBFQ', '', '', '0', '2', '', '0', 'zh', '1666758479', '1666758479');
INSERT INTO `ey_weapp_diyminipro_mall` VALUES ('5', '1', '默认商城风格', 'https://service.eyysz.cn/uploads/allimg/20200514/1-200514103G4249.png', '8d9bBlFRVQYIVgkJAg5VAAcEAVNWAVdWWVNSUwZUVQwLVEAaFggLUlcRFVhATAwFDlcVQF0BBglNFwQEEFVcTgteRl8CBElYWRB7WEAUFw8BWm1TTBFPFQQWFwwBUxgACVBcXU0GEF9cAxVeXVcBFQ', '', '', '0', '2', '', '0', 'en', '1666758559', '1666758559');

-- -----------------------------
-- Table structure for `ey_weapp_diyminipro_mall_page`
-- -----------------------------
DROP TABLE IF EXISTS `ey_weapp_diyminipro_mall_page`;
CREATE TABLE `ey_weapp_diyminipro_mall_page` (
  `page_id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '页面id',
  `page_type` tinyint(3) NOT NULL DEFAULT '-1' COMMENT '页面类型(1首页 -1自定义页)',
  `page_name` varchar(255) NOT NULL DEFAULT '' COMMENT '页面名称',
  `page_data` longtext NOT NULL COMMENT '页面数据',
  `mini_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '微信小程序id',
  `is_home` tinyint(1) NOT NULL DEFAULT '0' COMMENT '设为首页：0=否，1=是',
  `is_system` tinyint(1) NOT NULL DEFAULT '0' COMMENT '系统内置',
  `is_show` tinyint(1) NOT NULL DEFAULT '1' COMMENT '是否显示：1=显示，0=隐藏',
  `is_del` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '伪删除，1=是，0=否',
  `lang` varchar(10) NOT NULL DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`page_id`),
  KEY `mini_id` (`mini_id`,`lang`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=27 DEFAULT CHARSET=utf8 COMMENT='微信小程序diy页面表';

-- -----------------------------
-- Records of `ey_weapp_diyminipro_mall_page`
-- -----------------------------
INSERT INTO `ey_weapp_diyminipro_mall_page` VALUES ('18', '7', '会员中心', '{\"page\":{\"type\":\"page\",\"name\":\"\\u9875\\u9762\\u8bbe\\u7f6e\",\"params\":{\"title\":\"\\u4f1a\\u5458\\u4e2d\\u5fc3\",\"share_title\":\"\\u5206\\u4eab\\u6807\\u9898\"}},\"items\":[{\"name\":\"\\u4f1a\\u5458\\u4e2d\\u5fc3\",\"type\":\"userCenter\",\"params\":{\"recomNum\":6,\"recomShow\":\"1\",\"titleArr\":[\"\\u4e0d\\u663e\\u793a\",\"\\u6700\\u65b0\",\"\\u63a8\\u8350\",\"\\u6700\\u70ed\"],\"recomTitle\":\"\\u53ef\\u80fd\\u4f60\\u8fd8\\u60f3\\u8981\"},\"style\":{\"show_type\":10,\"background\":\"#ffffff\"},\"defaultData\":[{\"title\":\"\\u6b64\\u5904\\u663e\\u793a\\u5546\\u54c1\\u540d\\u79f0\",\"litpic\":\"https:\\/\\/service.eyysz.cn\\/public\\/static\\/common\\/diyminipro\\/img\\/diy\\/goods\\/01.png\",\"users_price\":\"99.00\",\"old_price\":\"139.00\",\"seo_description\":\"\\u6b64\\u6b3e\\u5546\\u54c1\\u7f8e\\u89c2\\u5927\\u65b9 \\u4e0d\\u5bb9\\u9519\\u8fc7\",\"stock_count\":\"100\",\"sales_num\":\"10\"},{\"title\":\"\\u6b64\\u5904\\u663e\\u793a\\u5546\\u54c1\\u540d\\u79f0\",\"litpic\":\"https:\\/\\/service.eyysz.cn\\/public\\/static\\/common\\/diyminipro\\/img\\/diy\\/goods\\/01.png\",\"users_price\":\"99.00\",\"old_price\":\"139.00\",\"seo_description\":\"\\u6b64\\u6b3e\\u5546\\u54c1\\u7f8e\\u89c2\\u5927\\u65b9 \\u4e0d\\u5bb9\\u9519\\u8fc7\",\"stock_count\":\"100\",\"sales_num\":\"10\"},{\"title\":\"\\u6b64\\u5904\\u663e\\u793a\\u5546\\u54c1\\u540d\\u79f0\",\"litpic\":\"https:\\/\\/service.eyysz.cn\\/public\\/static\\/common\\/diyminipro\\/img\\/diy\\/goods\\/01.png\",\"users_price\":\"99.00\",\"old_price\":\"139.00\",\"seo_description\":\"\\u6b64\\u6b3e\\u5546\\u54c1\\u7f8e\\u89c2\\u5927\\u65b9 \\u4e0d\\u5bb9\\u9519\\u8fc7\",\"stock_count\":\"100\",\"sales_num\":\"10\"},{\"title\":\"\\u6b64\\u5904\\u663e\\u793a\\u5546\\u54c1\\u540d\\u79f0\",\"litpic\":\"https:\\/\\/service.eyysz.cn\\/public\\/static\\/common\\/diyminipro\\/img\\/diy\\/goods\\/01.png\",\"users_price\":\"99.00\",\"old_price\":\"139.00\",\"seo_description\":\"\\u6b64\\u6b3e\\u5546\\u54c1\\u7f8e\\u89c2\\u5927\\u65b9 \\u4e0d\\u5bb9\\u9519\\u8fc7\",\"stock_count\":\"100\",\"sales_num\":\"10\"},{\"title\":\"\\u6b64\\u5904\\u663e\\u793a\\u5546\\u54c1\\u540d\\u79f0\",\"litpic\":\"https:\\/\\/service.eyysz.cn\\/public\\/static\\/common\\/diyminipro\\/img\\/diy\\/goods\\/01.png\",\"users_price\":\"99.00\",\"old_price\":\"139.00\",\"seo_description\":\"\\u6b64\\u6b3e\\u5546\\u54c1\\u7f8e\\u89c2\\u5927\\u65b9 \\u4e0d\\u5bb9\\u9519\\u8fc7\",\"stock_count\":\"100\",\"sales_num\":\"10\"},{\"title\":\"\\u6b64\\u5904\\u663e\\u793a\\u5546\\u54c1\\u540d\\u79f0\",\"litpic\":\"https:\\/\\/service.eyysz.cn\\/public\\/static\\/common\\/diyminipro\\/img\\/diy\\/goods\\/01.png\",\"users_price\":\"99.00\",\"old_price\":\"139.00\",\"seo_description\":\"\\u6b64\\u6b3e\\u5546\\u54c1\\u7f8e\\u89c2\\u5927\\u65b9 \\u4e0d\\u5bb9\\u9519\\u8fc7\",\"stock_count\":\"100\",\"sales_num\":\"10\"}]}],\"tabbar\":{\"name\":\"\\u5e95\\u90e8\\u83dc\\u5355\\u7ec4\",\"type\":\"tabBar\",\"style\":{\"color\":\"#666666\",\"selectedColor\":\"#e93b3d\",\"background\":\"#ffffff\"},\"adddata\":{\"pagePath\":\"\\/pages\\/index\\/index\",\"text\":\"\\u9996\\u9875\",\"iconPath\":\"https:\\/\\/service.eyysz.cn\\/public\\/static\\/common\\/diyminipro\\/img\\/tabbar\\/custom.png\",\"selectedIconPath\":\"https:\\/\\/service.eyysz.cn\\/public\\/static\\/common\\/diyminipro\\/img\\/tabbar\\/custom-active.png\",\"color\":\"\",\"selectedColor\":\"\",\"url\":\"\",\"pathconf\":{\"index\":\"index_index\",\"value\":\"\",\"is_vars\":0}},\"data\":[{\"pagePath\":\"\\/pages\\/index\\/index\",\"text\":\"\\u9996\\u9875\",\"iconPath\":\"https:\\/\\/service.eyysz.cn\\/public\\/static\\/common\\/diyminipro\\/img\\/tabbar\\/home.png\",\"selectedIconPath\":\"https:\\/\\/service.eyysz.cn\\/uploads\\/allimg\\/20200518\\/1-20051Q059363L.png\",\"color\":\"\",\"selectedColor\":\"\",\"url\":\"\",\"pathconf\":{\"index\":\"index_index\",\"value\":\"\",\"is_vars\":0}},{\"pagePath\":\"\\/pages\\/category\\/index\",\"text\":\"\\u5206\\u7c7b\",\"iconPath\":\"https:\\/\\/service.eyysz.cn\\/public\\/static\\/common\\/diyminipro\\/img\\/tabbar\\/cate.png\",\"selectedIconPath\":\"https:\\/\\/service.eyysz.cn\\/uploads\\/allimg\\/20200518\\/1-20051Q05945328.png\",\"color\":\"\",\"selectedColor\":\"\",\"url\":\"\",\"pathconf\":{\"index\":\"category_index\",\"value\":\"\",\"is_vars\":0}},{\"pagePath\":\"\\/pages\\/flow\\/index\",\"text\":\"\\u8d2d\\u7269\\u8f66\",\"iconPath\":\"https:\\/\\/service.eyysz.cn\\/public\\/static\\/common\\/diyminipro\\/img\\/tabbar\\/flow.png\",\"selectedIconPath\":\"https:\\/\\/service.eyysz.cn\\/uploads\\/allimg\\/20200518\\/1-20051Q10215415.png\",\"color\":\"\",\"selectedColor\":\"\",\"url\":\"\",\"pathconf\":{\"index\":\"flow_index\",\"value\":\"\",\"is_vars\":0}},{\"pagePath\":\"\\/pages\\/user\\/index\",\"text\":\"\\u6211\\u7684\",\"iconPath\":\"https:\\/\\/service.eyysz.cn\\/public\\/static\\/common\\/diyminipro\\/img\\/tabbar\\/user.png\",\"selectedIconPath\":\"https:\\/\\/service.eyysz.cn\\/uploads\\/allimg\\/20200518\\/1-20051Q10223462.png\",\"color\":\"\",\"selectedColor\":\"\",\"url\":\"\",\"pathconf\":{\"index\":\"user_index\",\"value\":\"\",\"is_vars\":0}}],\"id\":4},\"diyStyle\":{\"titleModel\":{\"style\":4,\"text\":{\"source\":\"default\",\"default\":{\"size\":15,\"color\":\"#000000\"},\"custom\":{\"size\":15,\"color\":\"#000000\"}},\"linesbackground\":\"#00aeff\"},\"commonModel\":{\"background\":\"#f4f4f4\",\"navtitleTextColor\":\"black\",\"navtitleBackgroundColor\":\"#ffffff\"}}}', '3', '0', '1', '1', '0', 'cn', '1604452245', '1666062563');
INSERT INTO `ey_weapp_diyminipro_mall_page` VALUES ('19', '6', '购物车', '{\"page\":{\"type\":\"page\",\"name\":\"\\u9875\\u9762\\u8bbe\\u7f6e\",\"params\":{\"title\":\"\\u8d2d\\u7269\\u8f66\",\"share_title\":\"\\u5206\\u4eab\\u6807\\u9898\"}},\"items\":[{\"name\":\"\\u8d2d\\u7269\\u8f66\",\"type\":\"cart\",\"params\":{\"recomNum\":6,\"recomShow\":1,\"titleArr\":[\"\\u4e0d\\u663e\\u793a\",\"\\u6700\\u65b0\",\"\\u63a8\\u8350\",\"\\u6700\\u70ed\"],\"recomTitle\":\"\\u53ef\\u80fd\\u4f60\\u8fd8\\u60f3\\u8981\"},\"style\":{\"show_type\":10,\"background\":\"#ffffff\"},\"defaultData\":[{\"title\":\"\\u6b64\\u5904\\u663e\\u793a\\u5546\\u54c1\\u540d\\u79f0\",\"litpic\":\"https:\\/\\/service.eyysz.cn\\/public\\/static\\/common\\/diyminipro\\/img\\/diy\\/goods\\/01.png\",\"users_price\":\"99.00\",\"old_price\":\"139.00\",\"seo_description\":\"\\u6b64\\u6b3e\\u5546\\u54c1\\u7f8e\\u89c2\\u5927\\u65b9 \\u4e0d\\u5bb9\\u9519\\u8fc7\",\"stock_count\":\"100\",\"sales_num\":\"10\"},{\"title\":\"\\u6b64\\u5904\\u663e\\u793a\\u5546\\u54c1\\u540d\\u79f0\",\"litpic\":\"https:\\/\\/service.eyysz.cn\\/public\\/static\\/common\\/diyminipro\\/img\\/diy\\/goods\\/01.png\",\"users_price\":\"99.00\",\"old_price\":\"139.00\",\"seo_description\":\"\\u6b64\\u6b3e\\u5546\\u54c1\\u7f8e\\u89c2\\u5927\\u65b9 \\u4e0d\\u5bb9\\u9519\\u8fc7\",\"stock_count\":\"100\",\"sales_num\":\"10\"},{\"title\":\"\\u6b64\\u5904\\u663e\\u793a\\u5546\\u54c1\\u540d\\u79f0\",\"litpic\":\"https:\\/\\/service.eyysz.cn\\/public\\/static\\/common\\/diyminipro\\/img\\/diy\\/goods\\/01.png\",\"users_price\":\"99.00\",\"old_price\":\"139.00\",\"seo_description\":\"\\u6b64\\u6b3e\\u5546\\u54c1\\u7f8e\\u89c2\\u5927\\u65b9 \\u4e0d\\u5bb9\\u9519\\u8fc7\",\"stock_count\":\"100\",\"sales_num\":\"10\"},{\"title\":\"\\u6b64\\u5904\\u663e\\u793a\\u5546\\u54c1\\u540d\\u79f0\",\"litpic\":\"https:\\/\\/service.eyysz.cn\\/public\\/static\\/common\\/diyminipro\\/img\\/diy\\/goods\\/01.png\",\"users_price\":\"99.00\",\"old_price\":\"139.00\",\"seo_description\":\"\\u6b64\\u6b3e\\u5546\\u54c1\\u7f8e\\u89c2\\u5927\\u65b9 \\u4e0d\\u5bb9\\u9519\\u8fc7\",\"stock_count\":\"100\",\"sales_num\":\"10\"},{\"title\":\"\\u6b64\\u5904\\u663e\\u793a\\u5546\\u54c1\\u540d\\u79f0\",\"litpic\":\"https:\\/\\/service.eyysz.cn\\/public\\/static\\/common\\/diyminipro\\/img\\/diy\\/goods\\/01.png\",\"users_price\":\"99.00\",\"old_price\":\"139.00\",\"seo_description\":\"\\u6b64\\u6b3e\\u5546\\u54c1\\u7f8e\\u89c2\\u5927\\u65b9 \\u4e0d\\u5bb9\\u9519\\u8fc7\",\"stock_count\":\"100\",\"sales_num\":\"10\"},{\"title\":\"\\u6b64\\u5904\\u663e\\u793a\\u5546\\u54c1\\u540d\\u79f0\",\"litpic\":\"https:\\/\\/service.eyysz.cn\\/public\\/static\\/common\\/diyminipro\\/img\\/diy\\/goods\\/01.png\",\"users_price\":\"99.00\",\"old_price\":\"139.00\",\"seo_description\":\"\\u6b64\\u6b3e\\u5546\\u54c1\\u7f8e\\u89c2\\u5927\\u65b9 \\u4e0d\\u5bb9\\u9519\\u8fc7\",\"stock_count\":\"100\",\"sales_num\":\"10\"}]}],\"tabbar\":{\"name\":\"\\u5e95\\u90e8\\u83dc\\u5355\\u7ec4\",\"type\":\"tabBar\",\"style\":{\"color\":\"#666666\",\"selectedColor\":\"#e93b3d\",\"background\":\"#ffffff\"},\"adddata\":{\"pagePath\":\"\\/pages\\/index\\/index\",\"text\":\"\\u9996\\u9875\",\"iconPath\":\"https:\\/\\/service.eyysz.cn\\/public\\/static\\/common\\/diyminipro\\/img\\/tabbar\\/custom.png\",\"selectedIconPath\":\"https:\\/\\/service.eyysz.cn\\/public\\/static\\/common\\/diyminipro\\/img\\/tabbar\\/custom-active.png\",\"color\":\"\",\"selectedColor\":\"\",\"url\":\"\",\"pathconf\":{\"index\":\"index_index\",\"value\":\"\",\"is_vars\":0}},\"data\":[{\"pagePath\":\"\\/pages\\/index\\/index\",\"text\":\"\\u9996\\u9875\",\"iconPath\":\"https:\\/\\/service.eyysz.cn\\/public\\/static\\/common\\/diyminipro\\/img\\/tabbar\\/home.png\",\"selectedIconPath\":\"https:\\/\\/service.eyysz.cn\\/uploads\\/allimg\\/20200518\\/1-20051Q059363L.png\",\"color\":\"\",\"selectedColor\":\"\",\"url\":\"\",\"pathconf\":{\"index\":\"index_index\",\"value\":\"\",\"is_vars\":0}},{\"pagePath\":\"\\/pages\\/category\\/index\",\"text\":\"\\u5206\\u7c7b\",\"iconPath\":\"https:\\/\\/service.eyysz.cn\\/public\\/static\\/common\\/diyminipro\\/img\\/tabbar\\/cate.png\",\"selectedIconPath\":\"https:\\/\\/service.eyysz.cn\\/uploads\\/allimg\\/20200518\\/1-20051Q05945328.png\",\"color\":\"\",\"selectedColor\":\"\",\"url\":\"\",\"pathconf\":{\"index\":\"category_index\",\"value\":\"\",\"is_vars\":0}},{\"pagePath\":\"\\/pages\\/flow\\/index\",\"text\":\"\\u8d2d\\u7269\\u8f66\",\"iconPath\":\"https:\\/\\/service.eyysz.cn\\/public\\/static\\/common\\/diyminipro\\/img\\/tabbar\\/flow.png\",\"selectedIconPath\":\"https:\\/\\/service.eyysz.cn\\/uploads\\/allimg\\/20200518\\/1-20051Q10215415.png\",\"color\":\"\",\"selectedColor\":\"\",\"url\":\"\",\"pathconf\":{\"index\":\"flow_index\",\"value\":\"\",\"is_vars\":0}},{\"pagePath\":\"\\/pages\\/user\\/index\",\"text\":\"\\u6211\\u7684\",\"iconPath\":\"https:\\/\\/service.eyysz.cn\\/public\\/static\\/common\\/diyminipro\\/img\\/tabbar\\/user.png\",\"selectedIconPath\":\"https:\\/\\/service.eyysz.cn\\/uploads\\/allimg\\/20200518\\/1-20051Q10223462.png\",\"color\":\"\",\"selectedColor\":\"\",\"url\":\"\",\"pathconf\":{\"index\":\"user_index\",\"value\":\"\",\"is_vars\":0}}],\"id\":4},\"diyStyle\":{\"titleModel\":{\"style\":4,\"text\":{\"source\":\"default\",\"default\":{\"size\":15,\"color\":\"#000000\"},\"custom\":{\"size\":15,\"color\":\"#000000\"}},\"linesbackground\":\"#00aeff\"},\"commonModel\":{\"background\":\"#f4f4f4\",\"navtitleTextColor\":\"black\",\"navtitleBackgroundColor\":\"#ffffff\"}}}', '3', '0', '1', '1', '0', 'cn', '1604452245', '1666062563');
INSERT INTO `ey_weapp_diyminipro_mall_page` VALUES ('17', '4', '商品详情页', '{\"page\":{\"type\":\"page\",\"name\":\"\\u9875\\u9762\\u8bbe\\u7f6e\",\"params\":{\"title\":\"\\u5546\\u54c1\\u8be6\\u60c5\\u9875\",\"share_title\":\"\\u5206\\u4eab\\u6807\\u9898\"}},\"items\":[{\"name\":\"\\u5546\\u54c1\\u8be6\\u60c5\\u9875\",\"type\":\"goodsDetails\",\"params\":{\"type\":\"phone\",\"phone_num\":\"\",\"recomNum\":6,\"recomShow\":1,\"titleArr\":[\"\\u4e0d\\u663e\\u793a\",\"\\u6700\\u65b0\",\"\\u63a8\\u8350\",\"\\u6700\\u70ed\"],\"recomTitle\":\"\\u53ef\\u80fd\\u4f60\\u8fd8\\u60f3\\u8981\"},\"style\":{\"show_type\":10,\"background\":\"#ffffff\"},\"defaultData\":[{\"title\":\"\\u6b64\\u5904\\u663e\\u793a\\u5546\\u54c1\\u540d\\u79f0\",\"litpic\":\"https:\\/\\/service.eyysz.cn\\/public\\/static\\/common\\/diyminipro\\/img\\/diy\\/goods\\/01.png\",\"users_price\":\"99.00\",\"old_price\":\"139.00\",\"seo_description\":\"\\u6b64\\u6b3e\\u5546\\u54c1\\u7f8e\\u89c2\\u5927\\u65b9 \\u4e0d\\u5bb9\\u9519\\u8fc7\",\"stock_count\":\"100\",\"sales_num\":\"10\"},{\"title\":\"\\u6b64\\u5904\\u663e\\u793a\\u5546\\u54c1\\u540d\\u79f0\",\"litpic\":\"https:\\/\\/service.eyysz.cn\\/public\\/static\\/common\\/diyminipro\\/img\\/diy\\/goods\\/01.png\",\"users_price\":\"99.00\",\"old_price\":\"139.00\",\"seo_description\":\"\\u6b64\\u6b3e\\u5546\\u54c1\\u7f8e\\u89c2\\u5927\\u65b9 \\u4e0d\\u5bb9\\u9519\\u8fc7\",\"stock_count\":\"100\",\"sales_num\":\"10\"},{\"title\":\"\\u6b64\\u5904\\u663e\\u793a\\u5546\\u54c1\\u540d\\u79f0\",\"litpic\":\"https:\\/\\/service.eyysz.cn\\/public\\/static\\/common\\/diyminipro\\/img\\/diy\\/goods\\/01.png\",\"users_price\":\"99.00\",\"old_price\":\"139.00\",\"seo_description\":\"\\u6b64\\u6b3e\\u5546\\u54c1\\u7f8e\\u89c2\\u5927\\u65b9 \\u4e0d\\u5bb9\\u9519\\u8fc7\",\"stock_count\":\"100\",\"sales_num\":\"10\"},{\"title\":\"\\u6b64\\u5904\\u663e\\u793a\\u5546\\u54c1\\u540d\\u79f0\",\"litpic\":\"https:\\/\\/service.eyysz.cn\\/public\\/static\\/common\\/diyminipro\\/img\\/diy\\/goods\\/01.png\",\"users_price\":\"99.00\",\"old_price\":\"139.00\",\"seo_description\":\"\\u6b64\\u6b3e\\u5546\\u54c1\\u7f8e\\u89c2\\u5927\\u65b9 \\u4e0d\\u5bb9\\u9519\\u8fc7\",\"stock_count\":\"100\",\"sales_num\":\"10\"},{\"title\":\"\\u6b64\\u5904\\u663e\\u793a\\u5546\\u54c1\\u540d\\u79f0\",\"litpic\":\"https:\\/\\/service.eyysz.cn\\/public\\/static\\/common\\/diyminipro\\/img\\/diy\\/goods\\/01.png\",\"users_price\":\"99.00\",\"old_price\":\"139.00\",\"seo_description\":\"\\u6b64\\u6b3e\\u5546\\u54c1\\u7f8e\\u89c2\\u5927\\u65b9 \\u4e0d\\u5bb9\\u9519\\u8fc7\",\"stock_count\":\"100\",\"sales_num\":\"10\"},{\"title\":\"\\u6b64\\u5904\\u663e\\u793a\\u5546\\u54c1\\u540d\\u79f0\",\"litpic\":\"https:\\/\\/service.eyysz.cn\\/public\\/static\\/common\\/diyminipro\\/img\\/diy\\/goods\\/01.png\",\"users_price\":\"99.00\",\"old_price\":\"139.00\",\"seo_description\":\"\\u6b64\\u6b3e\\u5546\\u54c1\\u7f8e\\u89c2\\u5927\\u65b9 \\u4e0d\\u5bb9\\u9519\\u8fc7\",\"stock_count\":\"100\",\"sales_num\":\"10\"}]}],\"tabbar\":{\"name\":\"\\u5e95\\u90e8\\u83dc\\u5355\\u7ec4\",\"type\":\"tabBar\",\"style\":{\"color\":\"#666666\",\"selectedColor\":\"#e93b3d\",\"background\":\"#ffffff\"},\"adddata\":{\"pagePath\":\"\\/pages\\/index\\/index\",\"text\":\"\\u9996\\u9875\",\"iconPath\":\"https:\\/\\/service.eyysz.cn\\/public\\/static\\/common\\/diyminipro\\/img\\/tabbar\\/custom.png\",\"selectedIconPath\":\"https:\\/\\/service.eyysz.cn\\/public\\/static\\/common\\/diyminipro\\/img\\/tabbar\\/custom-active.png\",\"color\":\"\",\"selectedColor\":\"\",\"url\":\"\",\"pathconf\":{\"index\":\"index_index\",\"value\":\"\",\"is_vars\":0}},\"data\":[{\"pagePath\":\"\\/pages\\/index\\/index\",\"text\":\"\\u9996\\u9875\",\"iconPath\":\"https:\\/\\/service.eyysz.cn\\/public\\/static\\/common\\/diyminipro\\/img\\/tabbar\\/home.png\",\"selectedIconPath\":\"https:\\/\\/service.eyysz.cn\\/uploads\\/allimg\\/20200518\\/1-20051Q059363L.png\",\"color\":\"\",\"selectedColor\":\"\",\"url\":\"\",\"pathconf\":{\"index\":\"index_index\",\"value\":\"\",\"is_vars\":0}},{\"pagePath\":\"\\/pages\\/category\\/index\",\"text\":\"\\u5206\\u7c7b\",\"iconPath\":\"https:\\/\\/service.eyysz.cn\\/public\\/static\\/common\\/diyminipro\\/img\\/tabbar\\/cate.png\",\"selectedIconPath\":\"https:\\/\\/service.eyysz.cn\\/uploads\\/allimg\\/20200518\\/1-20051Q05945328.png\",\"color\":\"\",\"selectedColor\":\"\",\"url\":\"\",\"pathconf\":{\"index\":\"category_index\",\"value\":\"\",\"is_vars\":0}},{\"pagePath\":\"\\/pages\\/flow\\/index\",\"text\":\"\\u8d2d\\u7269\\u8f66\",\"iconPath\":\"https:\\/\\/service.eyysz.cn\\/public\\/static\\/common\\/diyminipro\\/img\\/tabbar\\/flow.png\",\"selectedIconPath\":\"https:\\/\\/service.eyysz.cn\\/uploads\\/allimg\\/20200518\\/1-20051Q10215415.png\",\"color\":\"\",\"selectedColor\":\"\",\"url\":\"\",\"pathconf\":{\"index\":\"flow_index\",\"value\":\"\",\"is_vars\":0}},{\"pagePath\":\"\\/pages\\/user\\/index\",\"text\":\"\\u6211\\u7684\",\"iconPath\":\"https:\\/\\/service.eyysz.cn\\/public\\/static\\/common\\/diyminipro\\/img\\/tabbar\\/user.png\",\"selectedIconPath\":\"https:\\/\\/service.eyysz.cn\\/uploads\\/allimg\\/20200518\\/1-20051Q10223462.png\",\"color\":\"\",\"selectedColor\":\"\",\"url\":\"\",\"pathconf\":{\"index\":\"user_index\",\"value\":\"\",\"is_vars\":0}}],\"id\":4},\"diyStyle\":{\"titleModel\":{\"style\":4,\"text\":{\"source\":\"default\",\"default\":{\"size\":15,\"color\":\"#000000\"},\"custom\":{\"size\":15,\"color\":\"#000000\"}},\"linesbackground\":\"#00aeff\"},\"commonModel\":{\"background\":\"#f4f4f4\",\"navtitleTextColor\":\"black\",\"navtitleBackgroundColor\":\"#ffffff\"}}}', '3', '0', '1', '1', '0', 'cn', '1604452245', '1666062563');
INSERT INTO `ey_weapp_diyminipro_mall_page` VALUES ('16', '3', '联系我们', '{\"page\":{\"type\":\"page\",\"name\":\"\\u9875\\u9762\\u8bbe\\u7f6e\",\"params\":{\"title\":\"\\u8054\\u7cfb\\u6211\\u4eec\",\"share_title\":\"\\u8054\\u7cfb\\u6211\\u4eec\"}},\"items\":[{\"name\":\"\\u8054\\u7cfb\\u6211\\u4eec\",\"type\":\"contact\",\"params\":{\"titleConf\":{\"text\":\"\\u6b64\\u5904\\u663e\\u793a\\u6807\\u9898\\u680f\\u540d\\u79f0\",\"showhide\":\"show\",\"url\":\"\",\"pathconf\":{\"index\":\"default\",\"value\":\"\",\"is_vars\":0}}},\"style\":{\"paddingTop\":\"10\",\"paddingLeft\":\"10\",\"background\":\"#ffffff\",\"borderBottomColor\":\"#eeeeee\"},\"data\":{\"logo\":\"https:\\/\\/service.eyysz.cn\\/public\\/static\\/common\\/diyminipro\\/img\\/diy\\/contact\\/logo.png\",\"banner\":\"https:\\/\\/service.eyysz.cn\\/public\\/static\\/common\\/diyminipro\\/img\\/diy\\/contact\\/banner.png\",\"web_name\":\"\\u67d0\\u67d0\\u7f51\\u7edc\\u79d1\\u6280\\u516c\\u53f8\",\"mobile\":\"13800000000\",\"weixin\":\"123456789\",\"qq\":\"10000\",\"email\":\"test@email.com\",\"address\":\"\\u6d77\\u5357\\u7701\\u6d77\\u53e3\\u5e02\",\"coordinate\":\"110.32552547126,20.044049439257\",\"nav_title\":\"\\u516c\\u53f8\\u7b80\\u4ecb\",\"content\":\"<p>&nbsp;&nbsp;&nbsp;&nbsp;\\u67d0\\u67d0\\u7f51\\u7edc\\u79d1\\u6280\\u6709\\u9650\\u516c\\u53f8\\u6210\\u7acb\\u4e8e2006\\u5e74\\uff0c\\u81f4\\u529b\\u884c\\u4e1a10\\u5e74\\uff0c\\u5f00\\u521b\\u667a\\u80fd\\u54cd\\u5e94\\u5f0f\\u5efa\\u7ad9\\u4e91\\u5e73\\u53f0\\uff0c\\u6253\\u9020\\u96c6\\u54cd\\u5e94\\u5f0f\\u7f51\\u7ad9\\u6280\\u672f\\u3001\\u4e91\\u7aef\\u67b6\\u6784\\u3001\\u6574\\u5408\\u8425\\u9500\\u4e3a\\u4e00\\u4f53\\u5546\\u4e1a\\u6a21\\u5f0f\\u3002\\u4f34\\u968f\\u7740\\u4e2d\\u56fd\\u4e92\\u8054\\u7f51\\u7684\\u6210\\u957f\\uff0c\\u7ecf\\u5386\\u4e86\\u4e92\\u8054\\u7f51\\u5feb\\u901f\\u53d1\\u5c55\\u768410\\u5e74\\uff0c\\u79ef\\u7d2f\\u4e86\\u96c4\\u539a\\u81ea\\u4e3b\\u7814\\u53d1\\u6280\\u672f\\u548c\\u4e30\\u5bcc\\u7684\\u54cd\\u5e94\\u5f0f\\u7f51\\u7ad9\\u5f00\\u53d1\\u6848\\u4f8b\\u3002<\\/p><p><br\\/><\\/p><p>&nbsp;&nbsp;&nbsp;&nbsp;\\u9762\\u5bf9\\u65e5\\u65b0\\u6708\\u5f02\\u7684\\u4e92\\u8054\\u7f51\\u8d8b\\u52bf\\uff0c2016\\u65d7\\u4e0b\\u201c\\u67d0\\u67d0\\u201c\\u54cd\\u5e94\\u5f0f\\u8425\\u9500\\u4e91\\u5e73\\u53f0\\uff0c\\u653b\\u514b\\u6280\\u672f\\u96be\\u9898\\uff0c\\u81ea\\u4e3b\\u6253\\u9020\\u4ee5SaaS\\u4e91\\u5e73\\u53f0\\u4e3a\\u6784\\u67b6\\uff0c\\u201c\\u5feb\\u901f\\u54cd\\u5e94\\u5f0f\\u5efa\\u7ad9+\\u5168\\u7ef4\\u5ea6\\u6574\\u5408\\u8425\\u9500\\u201d\\u4e3a\\u6838\\u5fc3\\uff0c\\u4ece\\u8fc7\\u53bb\\u5c40\\u9650\\u7684\\u5b9a\\u5236\\u5efa\\u7ad9\\u8fd0\\u8425\\u8f6c\\u53d8\\u4e3a\\u6574\\u5408\\u8425\\u9500\\u8fd0\\u8425\\uff0c\\u9886\\u5148\\u5b9e\\u73b0\\u667a\\u80fd\\u54cd\\u5e94\\u5f0f\\u6280\\u672f\\u548c\\u7f51\\u7ad9\\u53ef\\u89c6\\u5316\\u7f16\\u8f91\\u65b9\\u6848\\uff0c\\u4e0d\\u4ec5\\u63d0\\u4f9b\\u5168\\u8bbe\\u5907\\u667a\\u80fd\\u54cd\\u5e94\\u5f0f\\u7cfb\\u7edf\\u7684\\u529f\\u80fd\\uff0c\\u66f4\\u878d\\u5408\\u4e86\\u826f\\u597d\\u7684\\u7528\\u6237\\u4f53\\u9a8c\\u548c\\u591a\\u5c42\\u6b21\\u4f18\\u5316\\u6307\\u5bfc\\uff0c\\u6e17\\u900f\\u5230\\u4e92\\u8054\\u7f51+\\u7684\\u5168\\u7ef4\\u5ea6\\u6574\\u5408\\u8425\\u9500\\u8fd0\\u8425\\u7ba1\\u7406\\u4e2d\\uff0c\\u5176\\u521b\\u65b0\\u7684\\u5546\\u4e1a\\u6a21\\u5f0f\\u96c6\\u5408\\u4e86\\u4ea7\\u4e1a\\u94fe\\u7684\\u5173\\u952e\\u5143\\u7d20\\uff0c\\u771f\\u6b63\\u610f\\u4e49\\u4e0a\\u5177\\u5907\\u4e86\\u4f01\\u4e1a\\u53d1\\u5c55\\u9700\\u6c42\\u7684\\u6574\\u4f53\\u8425\\u9500\\uff0c\\u4e3a\\u4f01\\u4e1a\\u63d0\\u4f9b\\u591a\\u5143\\u3001\\u9ad8\\u6548\\u3001\\u6613\\u7528\\u7684\\u7f51\\u7ad9\\u7ba1\\u7406\\u65b9\\u5f0f\\uff0c\\u6ee1\\u8db3\\u4f01\\u4e1a\\u5404\\u4e2a\\u9636\\u6bb5\\u4e0d\\u540c\\u53d8\\u5316\\u7684\\u7cfb\\u7edf\\u5347\\u7ea7\\u3002<\\/p>\"}}],\"tabbar\":{\"name\":\"\\u5e95\\u90e8\\u83dc\\u5355\\u7ec4\",\"type\":\"tabBar\",\"style\":{\"color\":\"#666666\",\"selectedColor\":\"#e93b3d\",\"background\":\"#ffffff\"},\"adddata\":{\"pagePath\":\"\\/pages\\/index\\/index\",\"text\":\"\\u9996\\u9875\",\"iconPath\":\"https:\\/\\/service.eyysz.cn\\/public\\/static\\/common\\/diyminipro\\/img\\/tabbar\\/custom.png\",\"selectedIconPath\":\"https:\\/\\/service.eyysz.cn\\/public\\/static\\/common\\/diyminipro\\/img\\/tabbar\\/custom-active.png\",\"color\":\"\",\"selectedColor\":\"\",\"url\":\"\",\"pathconf\":{\"index\":\"index_index\",\"value\":\"\",\"is_vars\":0}},\"data\":[{\"pagePath\":\"\\/pages\\/index\\/index\",\"text\":\"\\u9996\\u9875\",\"iconPath\":\"https:\\/\\/service.eyysz.cn\\/public\\/static\\/common\\/diyminipro\\/img\\/tabbar\\/home.png\",\"selectedIconPath\":\"https:\\/\\/service.eyysz.cn\\/uploads\\/allimg\\/20200518\\/1-20051Q059363L.png\",\"color\":\"\",\"selectedColor\":\"\",\"url\":\"\",\"pathconf\":{\"index\":\"index_index\",\"value\":\"\",\"is_vars\":0}},{\"pagePath\":\"\\/pages\\/category\\/index\",\"text\":\"\\u5206\\u7c7b\",\"iconPath\":\"https:\\/\\/service.eyysz.cn\\/public\\/static\\/common\\/diyminipro\\/img\\/tabbar\\/cate.png\",\"selectedIconPath\":\"https:\\/\\/service.eyysz.cn\\/uploads\\/allimg\\/20200518\\/1-20051Q05945328.png\",\"color\":\"\",\"selectedColor\":\"\",\"url\":\"\",\"pathconf\":{\"index\":\"category_index\",\"value\":\"\",\"is_vars\":0}},{\"pagePath\":\"\\/pages\\/flow\\/index\",\"text\":\"\\u8d2d\\u7269\\u8f66\",\"iconPath\":\"https:\\/\\/service.eyysz.cn\\/public\\/static\\/common\\/diyminipro\\/img\\/tabbar\\/flow.png\",\"selectedIconPath\":\"https:\\/\\/service.eyysz.cn\\/uploads\\/allimg\\/20200518\\/1-20051Q10215415.png\",\"color\":\"\",\"selectedColor\":\"\",\"url\":\"\",\"pathconf\":{\"index\":\"flow_index\",\"value\":\"\",\"is_vars\":0}},{\"pagePath\":\"\\/pages\\/user\\/index\",\"text\":\"\\u6211\\u7684\",\"iconPath\":\"https:\\/\\/service.eyysz.cn\\/public\\/static\\/common\\/diyminipro\\/img\\/tabbar\\/user.png\",\"selectedIconPath\":\"https:\\/\\/service.eyysz.cn\\/uploads\\/allimg\\/20200518\\/1-20051Q10223462.png\",\"color\":\"\",\"selectedColor\":\"\",\"url\":\"\",\"pathconf\":{\"index\":\"user_index\",\"value\":\"\",\"is_vars\":0}}],\"id\":4},\"diyStyle\":{\"titleModel\":{\"style\":4,\"text\":{\"source\":\"default\",\"default\":{\"size\":15,\"color\":\"#000000\"},\"custom\":{\"size\":15,\"color\":\"#000000\"}},\"linesbackground\":\"#00aeff\"},\"commonModel\":{\"background\":\"#f4f4f4\",\"navtitleTextColor\":\"black\",\"navtitleBackgroundColor\":\"#ffffff\"}}}', '3', '0', '1', '1', '0', 'cn', '1589423797', '1666062563');
INSERT INTO `ey_weapp_diyminipro_mall_page` VALUES ('15', '2', '分类频道', '{\"page\":{\"type\":\"page\",\"name\":\"\\u9875\\u9762\\u8bbe\\u7f6e\",\"params\":{\"title\":\"\\u5206\\u7c7b\\u9891\\u9053\",\"share_title\":\"\\u5206\\u7c7b\\u9891\\u9053\"}},\"items\":[{\"name\":\"\\u5206\\u7c7b\\u9891\\u9053\",\"type\":\"category\",\"params\":{\"show_type\":\"10\"},\"style\":[]}],\"tabbar\":{\"name\":\"\\u5e95\\u90e8\\u83dc\\u5355\\u7ec4\",\"type\":\"tabBar\",\"style\":{\"color\":\"#666666\",\"selectedColor\":\"#e93b3d\",\"background\":\"#ffffff\"},\"adddata\":{\"pagePath\":\"\\/pages\\/index\\/index\",\"text\":\"\\u9996\\u9875\",\"iconPath\":\"https:\\/\\/service.eyysz.cn\\/public\\/static\\/common\\/diyminipro\\/img\\/tabbar\\/custom.png\",\"selectedIconPath\":\"https:\\/\\/service.eyysz.cn\\/public\\/static\\/common\\/diyminipro\\/img\\/tabbar\\/custom-active.png\",\"color\":\"\",\"selectedColor\":\"\",\"url\":\"\",\"pathconf\":{\"index\":\"index_index\",\"value\":\"\",\"is_vars\":0}},\"data\":[{\"pagePath\":\"\\/pages\\/index\\/index\",\"text\":\"\\u9996\\u9875\",\"iconPath\":\"https:\\/\\/service.eyysz.cn\\/public\\/static\\/common\\/diyminipro\\/img\\/tabbar\\/home.png\",\"selectedIconPath\":\"https:\\/\\/service.eyysz.cn\\/uploads\\/allimg\\/20200518\\/1-20051Q059363L.png\",\"color\":\"\",\"selectedColor\":\"\",\"url\":\"\",\"pathconf\":{\"index\":\"index_index\",\"value\":\"\",\"is_vars\":0}},{\"pagePath\":\"\\/pages\\/category\\/index\",\"text\":\"\\u5206\\u7c7b\",\"iconPath\":\"https:\\/\\/service.eyysz.cn\\/public\\/static\\/common\\/diyminipro\\/img\\/tabbar\\/cate.png\",\"selectedIconPath\":\"https:\\/\\/service.eyysz.cn\\/uploads\\/allimg\\/20200518\\/1-20051Q05945328.png\",\"color\":\"\",\"selectedColor\":\"\",\"url\":\"\",\"pathconf\":{\"index\":\"category_index\",\"value\":\"\",\"is_vars\":0}},{\"pagePath\":\"\\/pages\\/flow\\/index\",\"text\":\"\\u8d2d\\u7269\\u8f66\",\"iconPath\":\"https:\\/\\/service.eyysz.cn\\/public\\/static\\/common\\/diyminipro\\/img\\/tabbar\\/flow.png\",\"selectedIconPath\":\"https:\\/\\/service.eyysz.cn\\/uploads\\/allimg\\/20200518\\/1-20051Q10215415.png\",\"color\":\"\",\"selectedColor\":\"\",\"url\":\"\",\"pathconf\":{\"index\":\"flow_index\",\"value\":\"\",\"is_vars\":0}},{\"pagePath\":\"\\/pages\\/user\\/index\",\"text\":\"\\u6211\\u7684\",\"iconPath\":\"https:\\/\\/service.eyysz.cn\\/public\\/static\\/common\\/diyminipro\\/img\\/tabbar\\/user.png\",\"selectedIconPath\":\"https:\\/\\/service.eyysz.cn\\/uploads\\/allimg\\/20200518\\/1-20051Q10223462.png\",\"color\":\"\",\"selectedColor\":\"\",\"url\":\"\",\"pathconf\":{\"index\":\"user_index\",\"value\":\"\",\"is_vars\":0}}],\"id\":4},\"diyStyle\":{\"titleModel\":{\"style\":4,\"text\":{\"source\":\"default\",\"default\":{\"size\":15,\"color\":\"#000000\"},\"custom\":{\"size\":15,\"color\":\"#000000\"}},\"linesbackground\":\"#00aeff\"},\"commonModel\":{\"background\":\"#f4f4f4\",\"navtitleTextColor\":\"black\",\"navtitleBackgroundColor\":\"#ffffff\"}}}', '3', '0', '1', '1', '0', 'cn', '1589423797', '1666062563');
INSERT INTO `ey_weapp_diyminipro_mall_page` VALUES ('14', '1', '首页', '{\"page\":{\"type\":\"page\",\"name\":\"\\u9875\\u9762\\u8bbe\\u7f6e\",\"params\":{\"title\":\"\\u8d2d\\u7269\\u5546\\u57ce\",\"share_title\":\"\\u5206\\u4eab\\u6807\\u9898\"},\"id\":5},\"items\":[{\"name\":\"\\u56fe\\u7247\\u8f6e\\u64ad\",\"type\":\"banner\",\"style\":{\"btnColor\":\"#ffffff\",\"btnShape\":\"round\",\"imgHeights\":\"180\",\"show_type\":\"10\",\"imgHeightsType\":\"custom\"},\"params\":{\"interval\":\"2800\",\"titleConf\":{\"text\":\"\\u6b64\\u5904\\u663e\\u793a\\u6807\\u9898\\u680f\\u540d\\u79f0\",\"showhide\":\"hide\",\"url\":\"\",\"pathconf\":{\"index\":\"default\",\"value\":\"\",\"is_vars\":0}}},\"data\":[{\"litpic\":\"\\/uploads\\/allimg\\/20221016\\/1-221016091635D2.jpg\",\"url\":\"\",\"pathconf\":{\"index\":\"default\",\"value\":\"\",\"is_vars\":0}},{\"litpic\":\"\\/uploads\\/allimg\\/20221018\\/1-22101Q01052524.jpg\",\"url\":\"\",\"pathconf\":{\"index\":\"default\",\"value\":\"\",\"is_vars\":0}}]},{\"name\":\"\\u5bfc\\u822a\\u7ec4\",\"type\":\"navBar\",\"params\":{\"titleConf\":{\"text\":\"\\u6b64\\u5904\\u663e\\u793a\\u6807\\u9898\\u680f\\u540d\\u79f0\",\"showhide\":\"hide\",\"url\":\"\",\"pathconf\":{\"index\":\"default\",\"value\":\"\",\"is_vars\":0}}},\"style\":{\"background\":\"#ffffff\",\"rowsNum\":\"4\",\"show_type\":10},\"data\":[{\"litpic\":\"https:\\/\\/service.eyysz.cn\\/uploads\\/allimg\\/20200518\\/1-20051Q00Q3102.png\",\"imgName\":\"icon-1.png\",\"url\":\"\",\"text\":\"\\u70ed\\u9500\\u4ea7\\u54c1\",\"color\":\"#666666\",\"pathconf\":{\"index\":\"default\",\"value\":\"\",\"is_vars\":0},\"backgroundImage\":\"\\/weapp\\/DiyminiproMall\\/template\\/diyminipro\\/img\\/diy\\/navbar\\/03.png\",\"intro\":\"\\u526f\\u6587\\u672c1\",\"introcolor\":\"#666666\",\"background\":\"#ffffff\",\"bordercolor\":\"#eeeeee\"},{\"litpic\":\"https:\\/\\/service.eyysz.cn\\/uploads\\/allimg\\/20200518\\/1-20051Q00Q9B6.png\",\"imgName\":\"icon-2.jpg\",\"url\":\"\",\"text\":\"\\u4f18\\u60e0\\u5238\",\"color\":\"#666666\",\"pathconf\":{\"index\":\"default\",\"value\":\"\",\"is_vars\":0},\"backgroundImage\":\"\\/weapp\\/DiyminiproMall\\/template\\/diyminipro\\/img\\/diy\\/navbar\\/03.png\",\"intro\":\"\\u526f\\u6587\\u672c2\",\"introcolor\":\"#666666\",\"background\":\"#ffffff\",\"bordercolor\":\"#eeeeee\"},{\"litpic\":\"https:\\/\\/service.eyysz.cn\\/uploads\\/allimg\\/20200518\\/1-20051Q00RL44.png\",\"imgName\":\"icon-3.jpg\",\"url\":\"\",\"text\":\"\\u9650\\u65f6\\u62a2\\u8d2d\",\"color\":\"#666666\",\"pathconf\":{\"index\":\"default\",\"value\":\"\",\"is_vars\":0},\"backgroundImage\":\"\\/weapp\\/DiyminiproMall\\/template\\/diyminipro\\/img\\/diy\\/navbar\\/03.png\",\"intro\":\"\\u526f\\u6587\\u672c3\",\"introcolor\":\"#666666\",\"background\":\"#ffffff\",\"bordercolor\":\"#eeeeee\"},{\"litpic\":\"https:\\/\\/service.eyysz.cn\\/uploads\\/allimg\\/20200518\\/1-20051Q00S4364.png\",\"imgName\":\"icon-4.jpg\",\"url\":\"\",\"text\":\"\\u5355\\u54c1\\u79d2\\u6740\",\"color\":\"#666666\",\"pathconf\":{\"index\":\"default\",\"value\":\"\",\"is_vars\":0},\"backgroundImage\":\"\\/weapp\\/DiyminiproMall\\/template\\/diyminipro\\/img\\/diy\\/navbar\\/03.png\",\"intro\":\"\\u526f\\u6587\\u672c4\",\"introcolor\":\"#666666\",\"background\":\"#ffffff\",\"bordercolor\":\"#eeeeee\"},{\"litpic\":\"https:\\/\\/service.eyysz.cn\\/uploads\\/allimg\\/20200518\\/1-20051Q00T1123.png\",\"imgName\":\"icon-1.png\",\"url\":\"\",\"text\":\"\\u670d\\u88c5\\u57ce\",\"color\":\"#666666\",\"pathconf\":{\"index\":\"default\",\"value\":\"\",\"is_vars\":0},\"backgroundImage\":\"\\/weapp\\/DiyminiproMall\\/template\\/diyminipro\\/img\\/diy\\/navbar\\/03.png\",\"intro\":\"\\u526f\\u6587\\u672c5\",\"introcolor\":\"#666666\",\"background\":\"#ffffff\",\"bordercolor\":\"#eeeeee\"},{\"litpic\":\"https:\\/\\/service.eyysz.cn\\/uploads\\/allimg\\/20200518\\/1-20051Q00U2400.png\",\"imgName\":\"icon-1.png\",\"url\":\"\",\"text\":\"\\u7535\\u5668\\u57ce\",\"color\":\"#666666\",\"pathconf\":{\"index\":\"default\",\"value\":\"\",\"is_vars\":0},\"backgroundImage\":\"\\/weapp\\/DiyminiproMall\\/template\\/diyminipro\\/img\\/diy\\/navbar\\/03.png\",\"intro\":\"\\u526f\\u6587\\u672c6\",\"introcolor\":\"#666666\",\"background\":\"#ffffff\",\"bordercolor\":\"#eeeeee\"},{\"litpic\":\"https:\\/\\/service.eyysz.cn\\/uploads\\/allimg\\/20200518\\/1-20051Q00Z12M.png\",\"imgName\":\"icon-1.png\",\"url\":\"\",\"text\":\"\\u6bcd\\u5a74\\u4e13\\u533a\",\"color\":\"#666666\",\"pathconf\":{\"index\":\"default\",\"value\":\"\",\"is_vars\":0},\"backgroundImage\":\"\\/weapp\\/DiyminiproMall\\/template\\/diyminipro\\/img\\/diy\\/navbar\\/03.png\",\"intro\":\"\\u526f\\u6587\\u672c7\",\"introcolor\":\"#666666\",\"background\":\"#ffffff\",\"bordercolor\":\"#eeeeee\"},{\"litpic\":\"https:\\/\\/service.eyysz.cn\\/uploads\\/allimg\\/20200518\\/1-20051Q00ZB36.png\",\"imgName\":\"icon-1.png\",\"url\":\"\",\"text\":\"\\u5168\\u90e8\\u5206\\u7c7b\",\"color\":\"#666666\",\"pathconf\":{\"index\":\"default\",\"value\":\"\",\"is_vars\":0},\"backgroundImage\":\"\\/weapp\\/DiyminiproMall\\/template\\/diyminipro\\/img\\/diy\\/navbar\\/03.png\",\"intro\":\"\\u526f\\u6587\\u672c8\",\"introcolor\":\"#666666\",\"background\":\"#ffffff\",\"bordercolor\":\"#eeeeee\"}]},{\"name\":\"\\u56fe\\u7247\\u6a71\\u7a97\",\"type\":\"window\",\"params\":{\"titleConf\":{\"text\":\"\\u6b64\\u5904\\u663e\\u793a\\u6807\\u9898\\u680f\\u540d\\u79f0\",\"showhide\":\"hide\",\"url\":\"\",\"pathconf\":{\"index\":\"default\",\"value\":\"\",\"is_vars\":0}}},\"style\":{\"paddingTop\":\"0\",\"paddingLeft\":\"0\",\"background\":\"#ffffff\",\"layout\":\"3\"},\"data\":[{\"litpic\":\"https:\\/\\/service.eyysz.cn\\/uploads\\/allimg\\/20200518\\/1-20051Q0304X55.png\",\"url\":\"\\/pages\\/article\\/list?typeid=3\",\"pathconf\":{\"index\":\"article_list\",\"value\":\"3\",\"is_vars\":1}},{\"litpic\":\"https:\\/\\/service.eyysz.cn\\/uploads\\/allimg\\/20200518\\/1-20051Q03056248.png\",\"url\":\"\",\"pathconf\":{\"index\":\"default\",\"value\":\"\",\"is_vars\":0}},{\"litpic\":\"https:\\/\\/service.eyysz.cn\\/uploads\\/allimg\\/20200518\\/1-20051Q05JY44.png\",\"url\":\"\",\"pathconf\":{\"index\":\"default\",\"value\":\"\",\"is_vars\":0}}],\"dataNum\":4},{\"name\":\"\\u56fe\\u7247\\u6a71\\u7a97\",\"type\":\"window\",\"params\":{\"titleConf\":{\"text\":\"\\u6b64\\u5904\\u663e\\u793a\\u6807\\u9898\\u680f\\u540d\\u79f0\",\"showhide\":\"hide\",\"url\":\"\",\"pathconf\":{\"index\":\"default\",\"value\":\"\",\"is_vars\":0}}},\"style\":{\"paddingTop\":\"0\",\"paddingLeft\":\"0\",\"background\":\"#ffffff\",\"layout\":\"4\"},\"data\":[{\"litpic\":\"https:\\/\\/service.eyysz.cn\\/uploads\\/allimg\\/20200518\\/1-20051Q051551H.png\",\"url\":\"\",\"pathconf\":{\"index\":\"default\",\"value\":\"\",\"is_vars\":0}},{\"litpic\":\"https:\\/\\/service.eyysz.cn\\/uploads\\/allimg\\/20200518\\/1-20051Q05201Z3.png\",\"url\":\"\",\"pathconf\":{\"index\":\"default\",\"value\":\"\",\"is_vars\":0}},{\"litpic\":\"https:\\/\\/service.eyysz.cn\\/uploads\\/allimg\\/20200518\\/1-20051Q0520I23.png\",\"url\":\"\",\"pathconf\":{\"index\":\"default\",\"value\":\"\",\"is_vars\":0}},{\"litpic\":\"https:\\/\\/service.eyysz.cn\\/uploads\\/allimg\\/20200518\\/1-20051Q05214135.png\",\"url\":\"\",\"pathconf\":{\"index\":\"default\",\"value\":\"\",\"is_vars\":0}}],\"dataNum\":4},{\"name\":\"\\u8f85\\u52a9\\u7a7a\\u767d\",\"type\":\"blank\",\"style\":{\"height\":\"10\",\"background\":\"#f4f4f4\"}},{\"name\":\"\\u5546\\u54c1\\u7ec4\",\"type\":\"goods\",\"params\":{\"source\":\"auto\",\"auto\":{\"orderby\":\"default\",\"showNum\":6},\"choice\":[],\"titleConf\":{\"typeid\":0,\"text\":\"\\u4e3a\\u60a8\\u63a8\\u8350\",\"url\":\"\",\"showhide\":\"show\"}},\"style\":{\"background\":\"#ffffff\",\"display\":\"list\",\"column\":\"2\",\"show\":{\"title\":\"1\",\"usersPrice\":\"1\",\"oldPrice\":\"1\",\"seoDescription\":\"0\",\"stockCount\":\"0\",\"salesNum\":\"0\"}},\"defaultData\":[{\"title\":\"\\u6b64\\u5904\\u663e\\u793a\\u5546\\u54c1\\u540d\\u79f0\",\"litpic\":\"https:\\/\\/service.eyysz.cn\\/public\\/static\\/common\\/diyminipro\\/img\\/diy\\/goods\\/01.png\",\"users_price\":\"99.00\",\"old_price\":\"139.00\",\"seo_description\":\"\\u6b64\\u6b3e\\u5546\\u54c1\\u7f8e\\u89c2\\u5927\\u65b9 \\u4e0d\\u5bb9\\u9519\\u8fc7\",\"stock_count\":\"100\",\"sales_num\":\"10\"},{\"title\":\"\\u6b64\\u5904\\u663e\\u793a\\u5546\\u54c1\\u540d\\u79f0\",\"litpic\":\"https:\\/\\/service.eyysz.cn\\/public\\/static\\/common\\/diyminipro\\/img\\/diy\\/goods\\/01.png\",\"users_price\":\"99.00\",\"old_price\":\"139.00\",\"seo_description\":\"\\u6b64\\u6b3e\\u5546\\u54c1\\u7f8e\\u89c2\\u5927\\u65b9 \\u4e0d\\u5bb9\\u9519\\u8fc7\",\"stock_count\":\"100\",\"sales_num\":\"10\"},{\"title\":\"\\u6b64\\u5904\\u663e\\u793a\\u5546\\u54c1\\u540d\\u79f0\",\"litpic\":\"https:\\/\\/service.eyysz.cn\\/public\\/static\\/common\\/diyminipro\\/img\\/diy\\/goods\\/01.png\",\"users_price\":\"99.00\",\"old_price\":\"139.00\",\"seo_description\":\"\\u6b64\\u6b3e\\u5546\\u54c1\\u7f8e\\u89c2\\u5927\\u65b9 \\u4e0d\\u5bb9\\u9519\\u8fc7\",\"stock_count\":\"100\",\"sales_num\":\"10\"},{\"title\":\"\\u6b64\\u5904\\u663e\\u793a\\u5546\\u54c1\\u540d\\u79f0\",\"litpic\":\"https:\\/\\/service.eyysz.cn\\/public\\/static\\/common\\/diyminipro\\/img\\/diy\\/goods\\/01.png\",\"users_price\":\"99.00\",\"old_price\":\"139.00\",\"seo_description\":\"\\u6b64\\u6b3e\\u5546\\u54c1\\u7f8e\\u89c2\\u5927\\u65b9 \\u4e0d\\u5bb9\\u9519\\u8fc7\",\"stock_count\":\"100\",\"sales_num\":\"10\"},{\"title\":\"\\u6b64\\u5904\\u663e\\u793a\\u5546\\u54c1\\u540d\\u79f0\",\"litpic\":\"https:\\/\\/service.eyysz.cn\\/public\\/static\\/common\\/diyminipro\\/img\\/diy\\/goods\\/01.png\",\"users_price\":\"99.00\",\"old_price\":\"139.00\",\"seo_description\":\"\\u6b64\\u6b3e\\u5546\\u54c1\\u7f8e\\u89c2\\u5927\\u65b9 \\u4e0d\\u5bb9\\u9519\\u8fc7\",\"stock_count\":\"100\",\"sales_num\":\"10\"},{\"title\":\"\\u6b64\\u5904\\u663e\\u793a\\u5546\\u54c1\\u540d\\u79f0\",\"litpic\":\"https:\\/\\/service.eyysz.cn\\/public\\/static\\/common\\/diyminipro\\/img\\/diy\\/goods\\/01.png\",\"users_price\":\"99.00\",\"old_price\":\"139.00\",\"seo_description\":\"\\u6b64\\u6b3e\\u5546\\u54c1\\u7f8e\\u89c2\\u5927\\u65b9 \\u4e0d\\u5bb9\\u9519\\u8fc7\",\"stock_count\":\"100\",\"sales_num\":\"10\"}],\"data\":[]}],\"tabbar\":{\"name\":\"\\u5e95\\u90e8\\u83dc\\u5355\\u7ec4\",\"type\":\"tabBar\",\"style\":{\"color\":\"#666666\",\"selectedColor\":\"#e93b3d\",\"background\":\"#ffffff\"},\"adddata\":{\"pagePath\":\"\\/pages\\/index\\/index\",\"text\":\"\\u9996\\u9875\",\"iconPath\":\"https:\\/\\/service.eyysz.cn\\/public\\/static\\/common\\/diyminipro\\/img\\/tabbar\\/custom.png\",\"selectedIconPath\":\"https:\\/\\/service.eyysz.cn\\/public\\/static\\/common\\/diyminipro\\/img\\/tabbar\\/custom-active.png\",\"color\":\"\",\"selectedColor\":\"\",\"url\":\"\",\"pathconf\":{\"index\":\"index_index\",\"value\":\"\",\"is_vars\":0}},\"data\":[{\"pagePath\":\"\\/pages\\/index\\/index\",\"text\":\"\\u9996\\u9875\",\"iconPath\":\"https:\\/\\/service.eyysz.cn\\/public\\/static\\/common\\/diyminipro\\/img\\/tabbar\\/home.png\",\"selectedIconPath\":\"https:\\/\\/service.eyysz.cn\\/uploads\\/allimg\\/20200518\\/1-20051Q059363L.png\",\"color\":\"\",\"selectedColor\":\"\",\"url\":\"\",\"pathconf\":{\"index\":\"index_index\",\"value\":\"\",\"is_vars\":0}},{\"pagePath\":\"\\/pages\\/category\\/index\",\"text\":\"\\u5206\\u7c7b\",\"iconPath\":\"https:\\/\\/service.eyysz.cn\\/public\\/static\\/common\\/diyminipro\\/img\\/tabbar\\/cate.png\",\"selectedIconPath\":\"https:\\/\\/service.eyysz.cn\\/uploads\\/allimg\\/20200518\\/1-20051Q05945328.png\",\"color\":\"\",\"selectedColor\":\"\",\"url\":\"\",\"pathconf\":{\"index\":\"category_index\",\"value\":\"\",\"is_vars\":0}},{\"pagePath\":\"\\/pages\\/flow\\/index\",\"text\":\"\\u8d2d\\u7269\\u8f66\",\"iconPath\":\"https:\\/\\/service.eyysz.cn\\/public\\/static\\/common\\/diyminipro\\/img\\/tabbar\\/flow.png\",\"selectedIconPath\":\"https:\\/\\/service.eyysz.cn\\/uploads\\/allimg\\/20200518\\/1-20051Q10215415.png\",\"color\":\"\",\"selectedColor\":\"\",\"url\":\"\",\"pathconf\":{\"index\":\"flow_index\",\"value\":\"\",\"is_vars\":0}},{\"pagePath\":\"\\/pages\\/user\\/index\",\"text\":\"\\u6211\\u7684\",\"iconPath\":\"https:\\/\\/service.eyysz.cn\\/public\\/static\\/common\\/diyminipro\\/img\\/tabbar\\/user.png\",\"selectedIconPath\":\"https:\\/\\/service.eyysz.cn\\/uploads\\/allimg\\/20200518\\/1-20051Q10223462.png\",\"color\":\"\",\"selectedColor\":\"\",\"url\":\"\",\"pathconf\":{\"index\":\"user_index\",\"value\":\"\",\"is_vars\":0}}],\"id\":4},\"diyStyle\":{\"titleModel\":{\"style\":4,\"text\":{\"source\":\"default\",\"default\":{\"size\":15,\"color\":\"#000000\"},\"custom\":{\"size\":15,\"color\":\"#000000\"}},\"linesbackground\":\"#00aeff\"},\"commonModel\":{\"background\":\"#f4f4f4\",\"navtitleTextColor\":\"black\",\"navtitleBackgroundColor\":\"#ffffff\"}}}', '3', '1', '1', '1', '0', 'cn', '1589423797', '1666062563');
INSERT INTO `ey_weapp_diyminipro_mall_page` VALUES ('21', '1', '首页', '{\"page\":{\"type\":\"page\",\"name\":\"\\u9875\\u9762\\u8bbe\\u7f6e\",\"params\":{\"title\":\"\\u9875\\u9762\\u6807\\u9898\",\"share_title\":\"\\u5206\\u4eab\\u6807\\u9898\"}},\"items\":[]}', '4', '1', '1', '1', '0', 'zh', '1666758479', '1666758479');
INSERT INTO `ey_weapp_diyminipro_mall_page` VALUES ('22', '2', '分类频道', '{\"page\":{\"type\":\"page\",\"name\":\"\\u9875\\u9762\\u8bbe\\u7f6e\",\"params\":{\"title\":\"\\u5206\\u7c7b\\u9891\\u9053\",\"share_title\":\"\\u5206\\u7c7b\\u9891\\u9053\"}},\"items\":[{\"name\":\"\\u5206\\u7c7b\\u9891\\u9053\",\"type\":\"category\",\"params\":{\"show_type\":20},\"style\":[]}]}', '4', '0', '1', '1', '0', 'zh', '1666758479', '1666758479');
INSERT INTO `ey_weapp_diyminipro_mall_page` VALUES ('23', '3', '联系我们', '{\"page\":{\"type\":\"page\",\"name\":\"\\u9875\\u9762\\u8bbe\\u7f6e\",\"params\":{\"title\":\"\\u8054\\u7cfb\\u6211\\u4eec\",\"share_title\":\"\\u8054\\u7cfb\\u6211\\u4eec\"}},\"items\":[{\"name\":\"\\u8054\\u7cfb\\u6211\\u4eec\",\"type\":\"contact\",\"params\":{\"titleConf\":{\"text\":\"\\u6b64\\u5904\\u663e\\u793a\\u6807\\u9898\\u680f\\u540d\\u79f0\",\"showhide\":\"show\",\"url\":\"\",\"pathconf\":{\"index\":\"default\",\"value\":\"\",\"is_vars\":0}}},\"style\":{\"paddingTop\":\"10\",\"paddingLeft\":\"10\",\"background\":\"#ffffff\",\"borderBottomColor\":\"#eeeeee\"},\"data\":{\"logo\":\"\\/weapp\\/DiyminiproMall\\/template\\/diyminipro\\/img\\/diy\\/contact\\/logo.png\",\"banner\":\"\\/weapp\\/DiyminiproMall\\/template\\/diyminipro\\/img\\/diy\\/contact\\/banner.png\",\"web_name\":\"\\u67d0\\u67d0\\u7f51\\u7edc\\u79d1\\u6280\\u516c\\u53f8\",\"mobile\":\"13800000000\",\"weixin\":\"123456789\",\"qq\":\"10000\",\"email\":\"test@email.com\",\"address\":\"\\u6d77\\u5357\\u7701\\u6d77\\u53e3\\u5e02\",\"coordinate\":\"110.32552547126,20.044049439257\",\"nav_title\":\"\\u516c\\u53f8\\u7b80\\u4ecb\",\"content\":\"<p>&nbsp;&nbsp;&nbsp;&nbsp;\\u67d0\\u67d0\\u7f51\\u7edc\\u79d1\\u6280\\u6709\\u9650\\u516c\\u53f8\\u6210\\u7acb\\u4e8e2006\\u5e74\\uff0c\\u81f4\\u529b\\u884c\\u4e1a10\\u5e74\\uff0c\\u5f00\\u521b\\u667a\\u80fd\\u54cd\\u5e94\\u5f0f\\u5efa\\u7ad9\\u4e91\\u5e73\\u53f0\\uff0c\\u6253\\u9020\\u96c6\\u54cd\\u5e94\\u5f0f\\u7f51\\u7ad9\\u6280\\u672f\\u3001\\u4e91\\u7aef\\u67b6\\u6784\\u3001\\u6574\\u5408\\u8425\\u9500\\u4e3a\\u4e00\\u4f53\\u5546\\u4e1a\\u6a21\\u5f0f\\u3002\\u4f34\\u968f\\u7740\\u4e2d\\u56fd\\u4e92\\u8054\\u7f51\\u7684\\u6210\\u957f\\uff0c\\u7ecf\\u5386\\u4e86\\u4e92\\u8054\\u7f51\\u5feb\\u901f\\u53d1\\u5c55\\u768410\\u5e74\\uff0c\\u79ef\\u7d2f\\u4e86\\u96c4\\u539a\\u81ea\\u4e3b\\u7814\\u53d1\\u6280\\u672f\\u548c\\u4e30\\u5bcc\\u7684\\u54cd\\u5e94\\u5f0f\\u7f51\\u7ad9\\u5f00\\u53d1\\u6848\\u4f8b\\u3002<\\/p><p><br\\/><\\/p><p>&nbsp;&nbsp;&nbsp;&nbsp;\\u9762\\u5bf9\\u65e5\\u65b0\\u6708\\u5f02\\u7684\\u4e92\\u8054\\u7f51\\u8d8b\\u52bf\\uff0c2016\\u65d7\\u4e0b\\u201c\\u67d0\\u67d0\\u201c\\u54cd\\u5e94\\u5f0f\\u8425\\u9500\\u4e91\\u5e73\\u53f0\\uff0c\\u653b\\u514b\\u6280\\u672f\\u96be\\u9898\\uff0c\\u81ea\\u4e3b\\u6253\\u9020\\u4ee5SaaS\\u4e91\\u5e73\\u53f0\\u4e3a\\u6784\\u67b6\\uff0c\\u201c\\u5feb\\u901f\\u54cd\\u5e94\\u5f0f\\u5efa\\u7ad9+\\u5168\\u7ef4\\u5ea6\\u6574\\u5408\\u8425\\u9500\\u201d\\u4e3a\\u6838\\u5fc3\\uff0c\\u4ece\\u8fc7\\u53bb\\u5c40\\u9650\\u7684\\u5b9a\\u5236\\u5efa\\u7ad9\\u8fd0\\u8425\\u8f6c\\u53d8\\u4e3a\\u6574\\u5408\\u8425\\u9500\\u8fd0\\u8425\\uff0c\\u9886\\u5148\\u5b9e\\u73b0\\u667a\\u80fd\\u54cd\\u5e94\\u5f0f\\u6280\\u672f\\u548c\\u7f51\\u7ad9\\u53ef\\u89c6\\u5316\\u7f16\\u8f91\\u65b9\\u6848\\uff0c\\u4e0d\\u4ec5\\u63d0\\u4f9b\\u5168\\u8bbe\\u5907\\u667a\\u80fd\\u54cd\\u5e94\\u5f0f\\u7cfb\\u7edf\\u7684\\u529f\\u80fd\\uff0c\\u66f4\\u878d\\u5408\\u4e86\\u826f\\u597d\\u7684\\u7528\\u6237\\u4f53\\u9a8c\\u548c\\u591a\\u5c42\\u6b21\\u4f18\\u5316\\u6307\\u5bfc\\uff0c\\u6e17\\u900f\\u5230\\u4e92\\u8054\\u7f51+\\u7684\\u5168\\u7ef4\\u5ea6\\u6574\\u5408\\u8425\\u9500\\u8fd0\\u8425\\u7ba1\\u7406\\u4e2d\\uff0c\\u5176\\u521b\\u65b0\\u7684\\u5546\\u4e1a\\u6a21\\u5f0f\\u96c6\\u5408\\u4e86\\u4ea7\\u4e1a\\u94fe\\u7684\\u5173\\u952e\\u5143\\u7d20\\uff0c\\u771f\\u6b63\\u610f\\u4e49\\u4e0a\\u5177\\u5907\\u4e86\\u4f01\\u4e1a\\u53d1\\u5c55\\u9700\\u6c42\\u7684\\u6574\\u4f53\\u8425\\u9500\\uff0c\\u4e3a\\u4f01\\u4e1a\\u63d0\\u4f9b\\u591a\\u5143\\u3001\\u9ad8\\u6548\\u3001\\u6613\\u7528\\u7684\\u7f51\\u7ad9\\u7ba1\\u7406\\u65b9\\u5f0f\\uff0c\\u6ee1\\u8db3\\u4f01\\u4e1a\\u5404\\u4e2a\\u9636\\u6bb5\\u4e0d\\u540c\\u53d8\\u5316\\u7684\\u7cfb\\u7edf\\u5347\\u7ea7\\u3002<\\/p>\"}}]}', '4', '0', '1', '1', '0', 'zh', '1666758479', '1666758479');
INSERT INTO `ey_weapp_diyminipro_mall_page` VALUES ('24', '1', '首页', '{\"page\":{\"type\":\"page\",\"name\":\"\\u9875\\u9762\\u8bbe\\u7f6e\",\"params\":{\"title\":\"\\u9875\\u9762\\u6807\\u9898\",\"share_title\":\"\\u5206\\u4eab\\u6807\\u9898\"}},\"items\":[]}', '5', '1', '1', '1', '0', 'en', '1666758559', '1666758559');
INSERT INTO `ey_weapp_diyminipro_mall_page` VALUES ('25', '2', '分类频道', '{\"page\":{\"type\":\"page\",\"name\":\"\\u9875\\u9762\\u8bbe\\u7f6e\",\"params\":{\"title\":\"\\u5206\\u7c7b\\u9891\\u9053\",\"share_title\":\"\\u5206\\u7c7b\\u9891\\u9053\"}},\"items\":[{\"name\":\"\\u5206\\u7c7b\\u9891\\u9053\",\"type\":\"category\",\"params\":{\"show_type\":20},\"style\":[]}]}', '5', '0', '1', '1', '0', 'en', '1666758559', '1666758559');
INSERT INTO `ey_weapp_diyminipro_mall_page` VALUES ('26', '3', '联系我们', '{\"page\":{\"type\":\"page\",\"name\":\"\\u9875\\u9762\\u8bbe\\u7f6e\",\"params\":{\"title\":\"\\u8054\\u7cfb\\u6211\\u4eec\",\"share_title\":\"\\u8054\\u7cfb\\u6211\\u4eec\"}},\"items\":[{\"name\":\"\\u8054\\u7cfb\\u6211\\u4eec\",\"type\":\"contact\",\"params\":{\"titleConf\":{\"text\":\"\\u6b64\\u5904\\u663e\\u793a\\u6807\\u9898\\u680f\\u540d\\u79f0\",\"showhide\":\"show\",\"url\":\"\",\"pathconf\":{\"index\":\"default\",\"value\":\"\",\"is_vars\":0}}},\"style\":{\"paddingTop\":\"10\",\"paddingLeft\":\"10\",\"background\":\"#ffffff\",\"borderBottomColor\":\"#eeeeee\"},\"data\":{\"logo\":\"\\/weapp\\/DiyminiproMall\\/template\\/diyminipro\\/img\\/diy\\/contact\\/logo.png\",\"banner\":\"\\/weapp\\/DiyminiproMall\\/template\\/diyminipro\\/img\\/diy\\/contact\\/banner.png\",\"web_name\":\"\\u67d0\\u67d0\\u7f51\\u7edc\\u79d1\\u6280\\u516c\\u53f8\",\"mobile\":\"13800000000\",\"weixin\":\"123456789\",\"qq\":\"10000\",\"email\":\"test@email.com\",\"address\":\"\\u6d77\\u5357\\u7701\\u6d77\\u53e3\\u5e02\",\"coordinate\":\"110.32552547126,20.044049439257\",\"nav_title\":\"\\u516c\\u53f8\\u7b80\\u4ecb\",\"content\":\"<p>&nbsp;&nbsp;&nbsp;&nbsp;\\u67d0\\u67d0\\u7f51\\u7edc\\u79d1\\u6280\\u6709\\u9650\\u516c\\u53f8\\u6210\\u7acb\\u4e8e2006\\u5e74\\uff0c\\u81f4\\u529b\\u884c\\u4e1a10\\u5e74\\uff0c\\u5f00\\u521b\\u667a\\u80fd\\u54cd\\u5e94\\u5f0f\\u5efa\\u7ad9\\u4e91\\u5e73\\u53f0\\uff0c\\u6253\\u9020\\u96c6\\u54cd\\u5e94\\u5f0f\\u7f51\\u7ad9\\u6280\\u672f\\u3001\\u4e91\\u7aef\\u67b6\\u6784\\u3001\\u6574\\u5408\\u8425\\u9500\\u4e3a\\u4e00\\u4f53\\u5546\\u4e1a\\u6a21\\u5f0f\\u3002\\u4f34\\u968f\\u7740\\u4e2d\\u56fd\\u4e92\\u8054\\u7f51\\u7684\\u6210\\u957f\\uff0c\\u7ecf\\u5386\\u4e86\\u4e92\\u8054\\u7f51\\u5feb\\u901f\\u53d1\\u5c55\\u768410\\u5e74\\uff0c\\u79ef\\u7d2f\\u4e86\\u96c4\\u539a\\u81ea\\u4e3b\\u7814\\u53d1\\u6280\\u672f\\u548c\\u4e30\\u5bcc\\u7684\\u54cd\\u5e94\\u5f0f\\u7f51\\u7ad9\\u5f00\\u53d1\\u6848\\u4f8b\\u3002<\\/p><p><br\\/><\\/p><p>&nbsp;&nbsp;&nbsp;&nbsp;\\u9762\\u5bf9\\u65e5\\u65b0\\u6708\\u5f02\\u7684\\u4e92\\u8054\\u7f51\\u8d8b\\u52bf\\uff0c2016\\u65d7\\u4e0b\\u201c\\u67d0\\u67d0\\u201c\\u54cd\\u5e94\\u5f0f\\u8425\\u9500\\u4e91\\u5e73\\u53f0\\uff0c\\u653b\\u514b\\u6280\\u672f\\u96be\\u9898\\uff0c\\u81ea\\u4e3b\\u6253\\u9020\\u4ee5SaaS\\u4e91\\u5e73\\u53f0\\u4e3a\\u6784\\u67b6\\uff0c\\u201c\\u5feb\\u901f\\u54cd\\u5e94\\u5f0f\\u5efa\\u7ad9+\\u5168\\u7ef4\\u5ea6\\u6574\\u5408\\u8425\\u9500\\u201d\\u4e3a\\u6838\\u5fc3\\uff0c\\u4ece\\u8fc7\\u53bb\\u5c40\\u9650\\u7684\\u5b9a\\u5236\\u5efa\\u7ad9\\u8fd0\\u8425\\u8f6c\\u53d8\\u4e3a\\u6574\\u5408\\u8425\\u9500\\u8fd0\\u8425\\uff0c\\u9886\\u5148\\u5b9e\\u73b0\\u667a\\u80fd\\u54cd\\u5e94\\u5f0f\\u6280\\u672f\\u548c\\u7f51\\u7ad9\\u53ef\\u89c6\\u5316\\u7f16\\u8f91\\u65b9\\u6848\\uff0c\\u4e0d\\u4ec5\\u63d0\\u4f9b\\u5168\\u8bbe\\u5907\\u667a\\u80fd\\u54cd\\u5e94\\u5f0f\\u7cfb\\u7edf\\u7684\\u529f\\u80fd\\uff0c\\u66f4\\u878d\\u5408\\u4e86\\u826f\\u597d\\u7684\\u7528\\u6237\\u4f53\\u9a8c\\u548c\\u591a\\u5c42\\u6b21\\u4f18\\u5316\\u6307\\u5bfc\\uff0c\\u6e17\\u900f\\u5230\\u4e92\\u8054\\u7f51+\\u7684\\u5168\\u7ef4\\u5ea6\\u6574\\u5408\\u8425\\u9500\\u8fd0\\u8425\\u7ba1\\u7406\\u4e2d\\uff0c\\u5176\\u521b\\u65b0\\u7684\\u5546\\u4e1a\\u6a21\\u5f0f\\u96c6\\u5408\\u4e86\\u4ea7\\u4e1a\\u94fe\\u7684\\u5173\\u952e\\u5143\\u7d20\\uff0c\\u771f\\u6b63\\u610f\\u4e49\\u4e0a\\u5177\\u5907\\u4e86\\u4f01\\u4e1a\\u53d1\\u5c55\\u9700\\u6c42\\u7684\\u6574\\u4f53\\u8425\\u9500\\uff0c\\u4e3a\\u4f01\\u4e1a\\u63d0\\u4f9b\\u591a\\u5143\\u3001\\u9ad8\\u6548\\u3001\\u6613\\u7528\\u7684\\u7f51\\u7ad9\\u7ba1\\u7406\\u65b9\\u5f0f\\uff0c\\u6ee1\\u8db3\\u4f01\\u4e1a\\u5404\\u4e2a\\u9636\\u6bb5\\u4e0d\\u540c\\u53d8\\u5316\\u7684\\u7cfb\\u7edf\\u5347\\u7ea7\\u3002<\\/p>\"}}]}', '5', '0', '1', '1', '0', 'en', '1666758559', '1666758559');
INSERT INTO `ey_weapp_diyminipro_mall_page` VALUES ('20', '5', '直播列表', '{\"page\":{\"type\":\"page\",\"name\":\"\\u9875\\u9762\\u8bbe\\u7f6e\",\"params\":{\"title\":\"\\u76f4\\u64ad\\u5217\\u8868\",\"share_title\":\"\\u5206\\u4eab\\u6807\\u9898\"}},\"items\":[{\"name\":\"\\u76f4\\u64ad\\u5217\\u8868\\u9875\",\"type\":\"liveListp\",\"params\":{\"start\":1,\"showNum\":10,\"titleConf\":{\"text\":\"\\u76f4\\u64ad\\u5217\\u8868\\u9875\",\"showhide\":\"hide\",\"url\":\"\",\"pathconf\":{\"index\":\"default\",\"value\":\"\",\"is_vars\":0}}},\"style\":{\"background\":\"#ffffff\"},\"defaultData\":[{\"name\":\"\\u4e3b\\u64ad\\u540d\\u79f0\",\"live_status\":\"101\",\"live_status_text\":\"\\u76f4\\u64ad\\u4e2d\",\"title\":\"\\u76f4\\u64ad\\u95f4\\u6807\\u9898\",\"litpic\":\"https:\\/\\/service.eyysz.cn\\/public\\/static\\/common\\/diyminipro\\/img\\/diy\\/liveList\\/02.jpg\",\"goodsList\":[{\"litpic\":\"https:\\/\\/service.eyysz.cn\\/public\\/static\\/common\\/diyminipro\\/img\\/diy\\/liveList\\/demo1.jpg\",\"price\":23.9},{\"litpic\":\"https:\\/\\/service.eyysz.cn\\/public\\/static\\/common\\/diyminipro\\/img\\/diy\\/liveList\\/demo2.jpg\",\"price\":45}]},{\"name\":\"\\u4e3b\\u64ad\\u540d\\u79f0\",\"live_status\":\"102\",\"live_status_text\":\"\\u76f4\\u64ad\\u9884\\u544a\",\"title\":\"\\u76f4\\u64ad\\u95f4\\u6807\\u9898\",\"litpic\":\"https:\\/\\/service.eyysz.cn\\/public\\/static\\/common\\/diyminipro\\/img\\/diy\\/liveList\\/03.jpg\",\"goodsList\":[{\"litpic\":\"https:\\/\\/service.eyysz.cn\\/public\\/static\\/common\\/diyminipro\\/img\\/diy\\/liveList\\/demo1.jpg\",\"price\":2591.9},{\"litpic\":\"https:\\/\\/service.eyysz.cn\\/public\\/static\\/common\\/diyminipro\\/img\\/diy\\/liveList\\/demo2.jpg\",\"price\":4159}]},{\"name\":\"\\u4e3b\\u64ad\\u540d\\u79f0\",\"live_status\":\"103\",\"live_status_text\":\"\\u76f4\\u64ad\\u56de\\u653e\",\"title\":\"\\u76f4\\u64ad\\u95f4\\u6807\\u9898\",\"litpic\":\"https:\\/\\/service.eyysz.cn\\/public\\/static\\/common\\/diyminipro\\/img\\/diy\\/liveList\\/04.jpg\",\"goodsList\":[{\"litpic\":\"https:\\/\\/service.eyysz.cn\\/public\\/static\\/common\\/diyminipro\\/img\\/diy\\/liveList\\/demo1.jpg\",\"price\":425},{\"litpic\":\"https:\\/\\/service.eyysz.cn\\/public\\/static\\/common\\/diyminipro\\/img\\/diy\\/liveList\\/demo2.jpg\",\"price\":654}]}]}],\"tabbar\":{\"name\":\"\\u5e95\\u90e8\\u83dc\\u5355\\u7ec4\",\"type\":\"tabBar\",\"style\":{\"color\":\"#666666\",\"selectedColor\":\"#00aeff\",\"background\":\"#ffffff\"},\"adddata\":{\"pagePath\":\"\\/pages\\/index\\/index\",\"text\":\"\\u9996\\u9875\",\"iconPath\":\"https:\\/\\/service.eyysz.cn\\/public\\/static\\/common\\/diyminipro\\/img\\/tabbar\\/custom.png\",\"selectedIconPath\":\"https:\\/\\/service.eyysz.cn\\/public\\/static\\/common\\/diyminipro\\/img\\/tabbar\\/custom-active.png\",\"color\":\"\",\"selectedColor\":\"\",\"url\":\"\",\"pathconf\":{\"index\":\"index_index\",\"value\":\"\",\"is_vars\":0}},\"data\":[{\"pagePath\":\"\\/pages\\/index\\/index\",\"text\":\"\\u9996\\u9875\",\"iconPath\":\"https:\\/\\/service.eyysz.cn\\/public\\/static\\/common\\/diyminipro\\/img\\/tabbar\\/home.png\",\"selectedIconPath\":\"https:\\/\\/service.eyysz.cn\\/public\\/static\\/common\\/diyminipro\\/img\\/tabbar\\/home-active.png\",\"color\":\"\",\"selectedColor\":\"\",\"url\":\"\",\"pathconf\":{\"index\":\"index_index\",\"value\":\"\",\"is_vars\":0}},{\"pagePath\":\"\\/pages\\/category\\/index\",\"text\":\"\\u5206\\u7c7b\\u9875\",\"iconPath\":\"https:\\/\\/service.eyysz.cn\\/public\\/static\\/common\\/diyminipro\\/img\\/tabbar\\/cate.png\",\"selectedIconPath\":\"https:\\/\\/service.eyysz.cn\\/public\\/static\\/common\\/diyminipro\\/img\\/tabbar\\/cate-active.png\",\"color\":\"\",\"selectedColor\":\"\",\"url\":\"\",\"pathconf\":{\"index\":\"category_index\",\"value\":\"\",\"is_vars\":0}},{\"pagePath\":\"\\/pages\\/contact\\/index\",\"text\":\"\\u8054\\u7cfb\\u6211\\u4eec\",\"iconPath\":\"https:\\/\\/service.eyysz.cn\\/public\\/static\\/common\\/diyminipro\\/img\\/tabbar\\/contact.png\",\"selectedIconPath\":\"https:\\/\\/service.eyysz.cn\\/public\\/static\\/common\\/diyminipro\\/img\\/tabbar\\/contact-active.png\",\"color\":\"\",\"selectedColor\":\"\",\"url\":\"\",\"pathconf\":{\"index\":\"contact_view\",\"value\":\"\",\"is_vars\":0}},{\"pagePath\":\"\\/pages\\/flow\\/index\",\"text\":\"\\u8d2d\\u7269\\u8f66\",\"iconPath\":\"https:\\/\\/service.eyysz.cn\\/public\\/static\\/common\\/diyminipro\\/img\\/tabbar\\/flow.png\",\"selectedIconPath\":\"https:\\/\\/service.eyysz.cn\\/public\\/static\\/common\\/diyminipro\\/img\\/tabbar\\/flow-active.png\",\"color\":\"\",\"selectedColor\":\"\",\"url\":\"\",\"pathconf\":{\"index\":\"flow_index\",\"value\":\"\",\"is_vars\":0}},{\"pagePath\":\"\\/pages\\/user\\/index\",\"text\":\"\\u4f1a\\u5458\\u4e2d\\u5fc3\",\"iconPath\":\"https:\\/\\/service.eyysz.cn\\/public\\/static\\/common\\/diyminipro\\/img\\/tabbar\\/user.png\",\"selectedIconPath\":\"https:\\/\\/service.eyysz.cn\\/public\\/static\\/common\\/diyminipro\\/img\\/tabbar\\/user-active.png\",\"color\":\"\",\"selectedColor\":\"\",\"url\":\"\",\"pathconf\":{\"index\":\"user_index\",\"value\":\"\",\"is_vars\":0}}]},\"diyStyle\":{\"titleModel\":{\"style\":0,\"text\":{\"source\":\"default\",\"default\":{\"size\":15,\"color\":\"#000000\"},\"custom\":{\"size\":15,\"color\":\"#000000\"}},\"linesbackground\":\"#00aeff\"},\"commonModel\":{\"background\":\"#f4f4f4\",\"navtitleTextColor\":\"black\",\"navtitleBackgroundColor\":\"#ffffff\"}}}', '3', '0', '1', '1', '0', 'cn', '1604452245', '1604452245');

-- -----------------------------
-- Table structure for `ey_weapp_diyminipro_mall_setting`
-- -----------------------------
DROP TABLE IF EXISTS `ey_weapp_diyminipro_mall_setting`;
CREATE TABLE `ey_weapp_diyminipro_mall_setting` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `name` varchar(60) NOT NULL DEFAULT '' COMMENT '页面组',
  `value` text NOT NULL COMMENT '组装之后的值',
  `mini_id` int(11) NOT NULL DEFAULT '0' COMMENT '小程序ID',
  `lang` varchar(10) NOT NULL DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) NOT NULL DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`),
  KEY `type` (`name`) USING BTREE,
  KEY `mini_id` (`mini_id`,`lang`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COMMENT='微信小程序多功能配置表';

-- -----------------------------
-- Records of `ey_weapp_diyminipro_mall_setting`
-- -----------------------------
INSERT INTO `ey_weapp_diyminipro_mall_setting` VALUES ('1', 'setting', '{\"tcp\":\"http\",\"domain\":\"www.scvip.net.cn\",\"root_dir\":\"\",\"name\":\"setting\",\"nid\":\"DiyminiproMall\",\"intro\":\"\\u9f99\\u51e4\\u4fe1\\u606f\\u7f51\",\"mini_id\":3,\"email\":\"15898383@qq.com\",\"appId\":\"wx168903912112b207\",\"navTitle\":\"\\u9f99\\u51e4\\u4fe1\\u606f\\u7f51\",\"username\":\"\\u7ba1\\u7406\\u5458\",\"mobile\":\"\",\"appSecret\":\"119c8c037962100f06e611c228181ae8\",\"originalId\":\"\",\"wechatId\":\"\",\"online_mini_id\":0,\"webviewdomain\":\"\",\"minipro\":\"DiyminiproMall\",\"status\":1,\"domain_api\":0,\"reason\":\"\",\"addTime\":1666683126,\"createminiproTime\":1666683261,\"auditid\":\"\",\"auditTime\":0,\"auditstatus\":3,\"miniproStatus\":3,\"estimateTime\":604800,\"version\":\"v4.20\",\"releaseTime\":0,\"template\":\"DiyminiproMall\",\"templateId\":223,\"component_info\":\"006dBANVAwIAAgkEUwZTCgUMUQFVBwNdBV4DCVROGltZXRVbXQBdRm9TSUQKVkMIEEJLVwRSAVtTDlIHXFRaAFBRARYfR1BdXUJWWgZcFW1TVlBREkdoTV1TBF5GDxoOBG9dcQZQYGJVWElMK2sEVFFZcQ1VeAd\\/aww4CCFqAFJUCQB3VVV5f31EDXEqalZza3ZBQSxAbwpxdRhGUm0LXHlkNlZ5AHJLRQMKQgp0AlhaTVRmCmxDdEZQG10idl9uTkZIYXgMUn9CdFt6VwsScUUDf3EYU1MUZHQPRxxbbGtPfAhZUDMBcQlfD0JVdFBLQUZxYjlcdn5zdil6RhkaWUNEDVtBDElXQm1YVwBXEkFtQVxfBFoVAxAOU281ZAxtWkhUB0cKellBYFxWFmMCX1hNan0SQAZYQk0qYA9mQVtHQCFBRhVaAwgHbQMPfwlxZ0J+UjJdZGt0ejtpLQFdZ2FDEXV7AGkffB9abQ5WFVgffEtcCnt5dHZbTHINf3RzegEcQQoHYlVkegh1JFcCVFpWS14IVlAUBWJXfQxDbWtzVwd6egF2BXZEQGU6YzdTc3B3eCV9FUQ\",\"authorizerInfo\":{\"nick_name\":\"\\u9b45\\u529b\\u9f99\\u51e4\",\"head_img\":\"http:\\/\\/wx.qlogo.cn\\/mmopen\\/zuIr8icwRPWFmpCgFsZVt9PeXPo6mMArnbQicgYmpDzAOHChgrlxibPCVseA2xcDQiceGVyXHcK9V0JLiaBibC2jiaZLW4icofdvtW9a\\/0\",\"service_type_info\":{\"id\":0},\"verify_type_info\":{\"id\":0},\"user_name\":\"gh_07bc9a3aac62\",\"alias\":\"\",\"qrcode_url\":\"http:\\/\\/mmbiz.qpic.cn\\/mmbiz_jpg\\/R0STiadkveico1hUksDhD88AR04Ol2DCaCSxetuO9XxX4pZflE5rGYNwP93MFLflM2hTrQUp9U9DGZd3eMSLc2NA\\/0\",\"business_info\":{\"open_pay\":0,\"open_shake\":0,\"open_scan\":0,\"open_card\":0,\"open_store\":0},\"idc\":1,\"principal_name\":\"\\u6c5f\\u6cb9\\u5e02\\u9f99\\u51e4\\u9547\\u4eba\\u6c11\\u653f\\u5e9c\",\"signature\":\"\\u9f99\\u51e4\\u4fe1\\u606f\\u53d1\\u5e03\\u5e73\\u53f0\\uff0c\\u4ea4\\u6d41\\u5e73\\u53f0\",\"MiniProgramInfo\":{\"network\":{\"RequestDomain\":[\"https:\\/\\/gm.scvip.net.cn\",\"https:\\/\\/service.eyysz.cn\",\"https:\\/\\/www.scvip.net.cn\"],\"WsRequestDomain\":[\"wss:\\/\\/gm.scvip.net.cn\",\"wss:\\/\\/service.eyysz.cn\",\"wss:\\/\\/www.scvip.net.cn\"],\"UploadDomain\":[\"https:\\/\\/gm.scvip.net.cn\",\"https:\\/\\/service.eyysz.cn\",\"https:\\/\\/www.scvip.net.cn\"],\"DownloadDomain\":[\"https:\\/\\/gm.scvip.net.cn\",\"https:\\/\\/service.eyysz.cn\",\"https:\\/\\/www.scvip.net.cn\"],\"BizDomain\":[\"https:\\/\\/gm.scvip.net.cn\",\"https:\\/\\/www.scvip.net.cn\"],\"UDPDomain\":[\"udp:\\/\\/gm.scvip.net.cn\"],\"TCPDomain\":[\"tcp:\\/\\/gm.scvip.net.cn\"],\"PrefetchDNSDomain\":[],\"NewRequestDomain\":[],\"NewWsRequestDomain\":[],\"NewUploadDomain\":[],\"NewDownloadDomain\":[],\"NewBizDomain\":[],\"NewUDPDomain\":[],\"NewTCPDomain\":[],\"NewPrefetchDNSDomain\":[]},\"categories\":[{\"first\":\"\\u653f\\u52a1\\u6c11\\u751f\",\"second\":\"\\u515a\\/\\u56e2\\/\\u7ec4\\u7ec7\"}],\"visit_status\":0},\"register_type\":0,\"account_status\":1,\"basic_config\":{\"is_phone_configured\":true,\"is_email_configured\":true}},\"authorizerStatus\":1}', '3', 'cn', '1666058922', '1666759067');
INSERT INTO `ey_weapp_diyminipro_mall_setting` VALUES ('2', 'set_arctype', 'a:9:{i:0;s:1:\"3\";i:1;s:2:\"50\";i:2;s:1:\"2\";i:3;s:1:\"4\";i:4;s:2:\"10\";i:5;s:2:\"14\";i:6;s:2:\"15\";i:7;s:2:\"29\";i:8;s:1:\"1\";}', '3', 'cn', '1666058988', '1666058996');

-- -----------------------------
-- Table structure for `ey_weapp_diyminipro_mall_users`
-- -----------------------------
DROP TABLE IF EXISTS `ey_weapp_diyminipro_mall_users`;
CREATE TABLE `ey_weapp_diyminipro_mall_users` (
  `wxuser_id` int(11) NOT NULL AUTO_INCREMENT,
  `users_id` int(11) NOT NULL DEFAULT '0' COMMENT '用户id',
  `openid` varchar(100) NOT NULL DEFAULT '' COMMENT 'openid',
  `nickname` varchar(100) NOT NULL DEFAULT '' COMMENT '微信昵称',
  `headimgurl` varchar(200) NOT NULL DEFAULT '' COMMENT '头像',
  `add_time` int(11) NOT NULL DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`wxuser_id`),
  KEY `openid` (`openid`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='微信小程序用户表';


-- -----------------------------
-- Table structure for `ey_weapp_keywords`
-- -----------------------------
DROP TABLE IF EXISTS `ey_weapp_keywords`;
CREATE TABLE `ey_weapp_keywords` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `keywords` varchar(100) DEFAULT '' COMMENT '关键词',
  `keywordsseo` varchar(255) DEFAULT '' COMMENT '关键词SEO扩展',
  `url` varchar(255) DEFAULT '' COMMENT '链接',
  `djl` int(10) NOT NULL DEFAULT '0' COMMENT '访问次数',
  `zt` int(1) NOT NULL DEFAULT '0' COMMENT '搜索页有无结果',
  `ssrk` int(1) NOT NULL DEFAULT '0' COMMENT '是否是用户搜索入库',
  `baidupushzt` int(1) NOT NULL DEFAULT '0' COMMENT '百度推送状态',
  `shenmapushzt` int(1) NOT NULL DEFAULT '0' COMMENT '神马推送状态',
  `sogoupushzt` int(1) NOT NULL DEFAULT '0' COMMENT '搜狗推送状态',
  `toutiaopushzt` int(1) NOT NULL DEFAULT '0' COMMENT '头条推送状态',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=11 DEFAULT CHARSET=utf8;

-- -----------------------------
-- Records of `ey_weapp_keywords`
-- -----------------------------
INSERT INTO `ey_weapp_keywords` VALUES ('1', '百度', '', '', '0', '0', '0', '0', '0', '0', '0', '1524975826', '1537585074');
INSERT INTO `ey_weapp_keywords` VALUES ('2', '百度', '', '', '0', '0', '0', '0', '0', '0', '0', '1524975826', '1537585074');
INSERT INTO `ey_weapp_keywords` VALUES ('3', '百度', '', '', '0', '0', '0', '0', '0', '0', '0', '1524975826', '1537585074');
INSERT INTO `ey_weapp_keywords` VALUES ('4', '百度', '', '', '0', '0', '0', '0', '0', '0', '0', '1524975826', '1537585074');
INSERT INTO `ey_weapp_keywords` VALUES ('5', '百度', '', '', '0', '0', '0', '0', '0', '0', '0', '1524975826', '1537585074');
INSERT INTO `ey_weapp_keywords` VALUES ('6', '百度', '', '', '0', '0', '0', '0', '0', '0', '0', '1524975826', '1537585074');
INSERT INTO `ey_weapp_keywords` VALUES ('7', '百度', '', '', '0', '0', '0', '0', '0', '0', '0', '1524975826', '1537585074');
INSERT INTO `ey_weapp_keywords` VALUES ('8', '百度', '', '', '0', '0', '0', '0', '0', '0', '0', '1524975826', '1537585074');
INSERT INTO `ey_weapp_keywords` VALUES ('9', '百度', '', '', '0', '0', '0', '0', '0', '0', '0', '1524975826', '1537585074');
INSERT INTO `ey_weapp_keywords` VALUES ('10', '百度', '', '', '0', '0', '0', '0', '0', '0', '0', '1524975826', '1537585074');

-- -----------------------------
-- Table structure for `ey_weapp_linkkeyword`
-- -----------------------------
DROP TABLE IF EXISTS `ey_weapp_linkkeyword`;
CREATE TABLE `ey_weapp_linkkeyword` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `title` varchar(50) NOT NULL DEFAULT '' COMMENT '关键词',
  `url` varchar(200) NOT NULL DEFAULT '' COMMENT '链接地址',
  `target` tinyint(1) NOT NULL DEFAULT '0' COMMENT '新窗口',
  `sort_order` int(10) NOT NULL DEFAULT '0' COMMENT '排序号',
  `status` tinyint(1) NOT NULL DEFAULT '1' COMMENT '状态(1=启用，0=禁用)',
  `add_time` int(11) NOT NULL DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;


-- -----------------------------
-- Table structure for `ey_weapp_messages`
-- -----------------------------
DROP TABLE IF EXISTS `ey_weapp_messages`;
CREATE TABLE `ey_weapp_messages` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(50) DEFAULT '' COMMENT '通知标题',
  `users_id` text COMMENT '通知用户账号',
  `remark` text COMMENT '通知信息',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


-- -----------------------------
-- Table structure for `ey_weapp_messages_read`
-- -----------------------------
DROP TABLE IF EXISTS `ey_weapp_messages_read`;
CREATE TABLE `ey_weapp_messages_read` (
  `messages_id` int(11) NOT NULL AUTO_INCREMENT,
  `users_id` varchar(50) DEFAULT NULL COMMENT '用户账号',
  `id` int(10) DEFAULT NULL COMMENT '站内信id',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`messages_id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

-- -----------------------------
-- Records of `ey_weapp_messages_read`
-- -----------------------------
INSERT INTO `ey_weapp_messages_read` VALUES ('1', 'jymjzx', '1', '1665622323', '1665622323');

-- -----------------------------
-- Table structure for `ey_weapp_minicount`
-- -----------------------------
DROP TABLE IF EXISTS `ey_weapp_minicount`;
CREATE TABLE `ey_weapp_minicount` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `day` int(10) DEFAULT '0' COMMENT '今天流量',
  `total` int(10) DEFAULT '0' COMMENT '总流量',
  `dayline` int(10) DEFAULT '0',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`),
  KEY `users_id` (`dayline`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

-- -----------------------------
-- Records of `ey_weapp_minicount`
-- -----------------------------
INSERT INTO `ey_weapp_minicount` VALUES ('1', '3', '3', '1', '1524975826', '1600738692');

-- -----------------------------
-- Table structure for `ey_weapp_minicount_log`
-- -----------------------------
DROP TABLE IF EXISTS `ey_weapp_minicount_log`;
CREATE TABLE `ey_weapp_minicount_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `ip` varchar(20) DEFAULT '',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`),
  KEY `ip` (`ip`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

-- -----------------------------
-- Records of `ey_weapp_minicount_log`
-- -----------------------------
INSERT INTO `ey_weapp_minicount_log` VALUES ('1', '127.0.0.1', '1600738682', '1600738692');

-- -----------------------------
-- Table structure for `ey_weapp_minipro0001`
-- -----------------------------
DROP TABLE IF EXISTS `ey_weapp_minipro0001`;
CREATE TABLE `ey_weapp_minipro0001` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `type` varchar(100) DEFAULT '' COMMENT '页面组',
  `value` text COMMENT '组装之后的值',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`),
  KEY `type` (`type`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='插件小程序0001表';


-- -----------------------------
-- Table structure for `ey_weapp_minipro0002`
-- -----------------------------
DROP TABLE IF EXISTS `ey_weapp_minipro0002`;
CREATE TABLE `ey_weapp_minipro0002` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `type` varchar(100) DEFAULT '' COMMENT '页面组',
  `value` text COMMENT '组装之后的值',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`),
  KEY `type` (`type`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COMMENT='插件小程序0002表';

-- -----------------------------
-- Records of `ey_weapp_minipro0002`
-- -----------------------------
INSERT INTO `ey_weapp_minipro0002` VALUES ('1', 'minipro', '{\"username\":\"\\u8303\\u4e2d\\u6797\",\"email\":\"jymjzx@126.com\",\"mobile\":\"13990166543\",\"appId\":\"wx168903912112b207\",\"appSecret\":\"119c8c037962100f06e611c228181ae8\",\"originalId\":\"gh_07bc9a3aac62\",\"wechatId\":\"\",\"tcp\":\"https\",\"domain\":\"gm.scvip.net.cn\",\"mini_id\":0,\"online_mini_id\":0,\"root_dir\":\"\",\"webviewdomain\":\"gm.scvip.net.cn\",\"intro\":\"\\u9f99\\u51e4\\u4fe1\\u606f\\u7f51\",\"navTitle\":\"\\u9f99\\u51e4\\u4fe1\\u606f\\u7f51\",\"minipro\":\"Minipro0002\",\"status\":1,\"domain_api\":0,\"reason\":\"\",\"addTime\":1665983178,\"createminiproTime\":0,\"auditid\":\"\",\"auditTime\":0,\"auditstatus\":3,\"miniproStatus\":2,\"estimateTime\":604800,\"version\":\"\",\"releaseTime\":0,\"template\":\"Minipro0002\",\"templateId\":144,\"component_info\":\"5006BVIGVlVVUwAAVlUNUAtXBAJVBldQDFMBVFIeFFJXX0haDFMIEToCQEAPBxYIGhFKBVRUUlRUUldWCARUCV5TXBdOFAUKCBNfXgMNQG1ZBVEDQkE7QloPAQ8SXxQHCW1KVjZXPFwMIHgAP1RfClUtHzFuBjJFWzcQBUAOBUgKQ0B8OGkvPCI6AWkKLGxoDCcACnNhUGNUMgIsXyRCfgBYYgEGURYHAzdjRgFQa2ZnHF0DQmFUeWYvBilID1l5YXF9eSQBP1UAMHdDMlNgYF0RY1NUZFd5QAkONURXXFZ7elZlLWJVVAsAUn1REEBrejJ0NXZVJXd0My45EkkUUE1GUFoQXxwAFzxRUwUGR0FnEl0NVFxGDBdSVT50UWVnU1x6d1tlJyg6PFhIKS4ZURUtazF3cwUCVFJcVG8LAG4OXFcMKnUDVTQ3WnoIAWBKUTRxCkh0F2JYLgAnXgpHWGkfb18beARdElpvQlYkf0ABIwsLBlQgdFBUNFRYUn1iTB9LBhtiPBdTFgFqFSdfC3sHBxwCf11bACcwEQBIA3BUdEINBnISLQRXA1o+L3pbeSF2N3R1Rks\",\"authorizerInfo\":{\"nick_name\":\"\\u9b45\\u529b\\u9f99\\u51e4\",\"head_img\":\"http:\\/\\/wx.qlogo.cn\\/mmopen\\/zuIr8icwRPWFmpCgFsZVt9PeXPo6mMArnbQicgYmpDzAOHChgrlxibPCVseA2xcDQiceGVyXHcK9V0JLiaBibC2jiaZLW4icofdvtW9a\\/0\",\"service_type_info\":{\"id\":0},\"verify_type_info\":{\"id\":0},\"user_name\":\"gh_07bc9a3aac62\",\"alias\":\"\",\"qrcode_url\":\"http:\\/\\/mmbiz.qpic.cn\\/mmbiz_jpg\\/R0STiadkveico1hUksDhD88AR04Ol2DCaCSxetuO9XxX4pZflE5rGYNwP93MFLflM2hTrQUp9U9DGZd3eMSLc2NA\\/0\",\"business_info\":{\"open_pay\":0,\"open_shake\":0,\"open_scan\":0,\"open_card\":0,\"open_store\":0},\"idc\":1,\"principal_name\":\"\\u6c5f\\u6cb9\\u5e02\\u9f99\\u51e4\\u9547\\u4eba\\u6c11\\u653f\\u5e9c\",\"signature\":\"\\u9f99\\u51e4\\u4fe1\\u606f\\u53d1\\u5e03\\u5e73\\u53f0\\uff0c\\u4ea4\\u6d41\\u5e73\\u53f0\",\"MiniProgramInfo\":{\"network\":{\"RequestDomain\":[\"https:\\/\\/gm.scvip.net.cn\"],\"WsRequestDomain\":[\"wss:\\/\\/gm.scvip.net.cn\"],\"UploadDomain\":[\"https:\\/\\/gm.scvip.net.cn\"],\"DownloadDomain\":[\"https:\\/\\/gm.scvip.net.cn\"],\"BizDomain\":[],\"UDPDomain\":[\"udp:\\/\\/gm.scvip.net.cn\"],\"TCPDomain\":[\"tcp:\\/\\/gm.scvip.net.cn\"],\"PrefetchDNSDomain\":[],\"NewRequestDomain\":[],\"NewWsRequestDomain\":[],\"NewUploadDomain\":[],\"NewDownloadDomain\":[],\"NewBizDomain\":[],\"NewUDPDomain\":[],\"NewTCPDomain\":[],\"NewPrefetchDNSDomain\":[]},\"categories\":[{\"first\":\"\\u653f\\u52a1\\u6c11\\u751f\",\"second\":\"\\u515a\\/\\u56e2\\/\\u7ec4\\u7ec7\"}],\"visit_status\":0},\"register_type\":0,\"account_status\":1,\"basic_config\":{\"is_phone_configured\":true,\"is_email_configured\":true}},\"authorizerStatus\":1}', '1665983176', '1665983746');

-- -----------------------------
-- Table structure for `ey_weapp_multicity`
-- -----------------------------
DROP TABLE IF EXISTS `ey_weapp_multicity`;
CREATE TABLE `ey_weapp_multicity` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '表id',
  `topid` int(10) DEFAULT '0' COMMENT '顶级ID',
  `parent_id` int(10) DEFAULT '0' COMMENT '父id',
  `name` varchar(32) DEFAULT '' COMMENT '地区名称',
  `level` tinyint(4) DEFAULT '0' COMMENT '地区等级 分省市县区',
  `status` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '状态（1：开启，0：隐藏）',
  `is_hot` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否热门',
  `domain` varchar(50) NOT NULL DEFAULT '' COMMENT '城市目录',
  `seo_title` varchar(200) DEFAULT '' COMMENT 'SEO标题',
  `seo_keywords` varchar(200) DEFAULT '' COMMENT 'SEO关键词',
  `seo_description` text COMMENT 'SEO描述',
  `sort_order` int(6) unsigned NOT NULL DEFAULT '100' COMMENT '排序',
  `add_time` int(11) NOT NULL DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=404 DEFAULT CHARSET=utf8;

-- -----------------------------
-- Records of `ey_weapp_multicity`
-- -----------------------------
INSERT INTO `ey_weapp_multicity` VALUES ('31', '21', '21', '无锡市', '2', '1', '0', 'wuxi', '无锡市混凝土布料机厂家', '无锡市混凝土布料机价格,无锡混凝土布料机,无锡混凝土布料机厂家', '无锡市混凝土布料机专业生产厂家联系电话：17858811257', '100', '1652178546', '1655083631');
INSERT INTO `ey_weapp_multicity` VALUES ('30', '22', '22', '中山区', '3', '1', '0', 'zhongshan', '中山区', '中山区布料机价格,中山区液压布料机,中山区液压布料机厂家', '中山区布料机专业生产厂家联系电话：17858811257', '100', '1652178529', '1655083040');
INSERT INTO `ey_weapp_multicity` VALUES ('29', '22', '22', '玄武湖区', '3', '1', '0', 'xuanwuhuqu', '玄武湖区液压布料机厂家', '玄武湖区布料机价格,玄武湖区液压布料机,玄武湖区液压布料机厂家', '玄武湖区布料机专业生产厂家联系电话：17858811257', '100', '1652178510', '1655082644');
INSERT INTO `ey_weapp_multicity` VALUES ('28', '27', '27', '上海市', '2', '1', '0', 'shs', '上海液压布料机厂家', '上海布料机价格,上海液压布料机,上海液压布料机厂家', '上海布料机专业生产厂家联系电话：17858811257', '100', '1652178474', '1655099437');
INSERT INTO `ey_weapp_multicity` VALUES ('21', '0', '0', '江苏省', '1', '1', '0', 'jss', '江苏省液压布料机厂家', '江苏省布料机价格,江苏省液压布料机,江苏省液压布料机厂家', '江苏省布料机专业生产厂家联系电话：17858811257', '5', '1651929303', '1655099305');
INSERT INTO `ey_weapp_multicity` VALUES ('22', '21', '21', '南京市', '2', '1', '0', 'nanjingshi', '南京液压布料机厂家', '南京布料机价格,南京液压布料机,南京液压布料机厂家', '南京布料机专业生产厂家联系电话：17858811257', '100', '1651929318', '1655082152');
INSERT INTO `ey_weapp_multicity` VALUES ('23', '22', '22', '雨花台区', '3', '1', '0', 'yuhuataiqu', '雨花台液压布料机厂家', '雨花台布料机价格,雨花台液压布料机,雨花台液压布料机厂家', '雨花台布料机专业生产厂家联系电话：17858811257', '100', '1651929328', '1655082310');
INSERT INTO `ey_weapp_multicity` VALUES ('27', '0', '0', '上海市', '1', '1', '0', 'shanghai', '上海', '上海', '上海', '100', '1652008705', '1655080594');
INSERT INTO `ey_weapp_multicity` VALUES ('32', '0', '0', '安徽省', '1', '1', '0', 'ahs', '安徽省混凝土布料机厂家', '安徽省混凝土布料机价格,安徽省混凝土布料机,安徽省混凝土布料机厂家', '安徽省混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655078313', '1655099813');
INSERT INTO `ey_weapp_multicity` VALUES ('33', '32', '32', '合肥市', '2', '1', '0', 'hfs', '合肥市混凝土布料机厂家', '合肥市混凝土布料机价格,合肥市混凝土布料机,合肥市混凝土布料机厂家', '合肥市混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655078483', '1655099967');
INSERT INTO `ey_weapp_multicity` VALUES ('34', '21', '21', '徐州市', '2', '1', '0', 'xuzhoushi', '徐州液压布料机厂家', '徐州布料机价格,徐州液压布料机,徐州液压布料机厂家', '徐州布料机专业生产厂家联系电话：17858811257', '100', '1655078597', '1655083882');
INSERT INTO `ey_weapp_multicity` VALUES ('35', '21', '21', '常州市', '2', '1', '0', 'changzhoushi', '常州市混凝土布料机厂家', '常州混凝土布料机价格,常州混凝土布料机,常州混凝土布料机厂家', '常州混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655078620', '1655085638');
INSERT INTO `ey_weapp_multicity` VALUES ('36', '21', '21', '苏州市', '2', '1', '0', 'suzhoushi', '苏州液压布料机厂家', '苏州布料机价格,苏州液压布料机,苏州液压布料机厂家', '苏州布料机专业生产厂家联系电话：17858811257', '100', '1655078636', '1655085619');
INSERT INTO `ey_weapp_multicity` VALUES ('37', '21', '21', '南通市', '2', '1', '0', 'nantongshi', '南通混凝土布料机厂家', '南通混凝土布料机价格,南通混凝土布料机,南通混凝土布料机厂家', '南通混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655078656', '1655085015');
INSERT INTO `ey_weapp_multicity` VALUES ('38', '21', '21', '连云港市', '2', '1', '0', 'lianyungang', '连云港液压布料机厂家', '连云港布料机价格,连云港液压布料机,连云港液压布料机厂家', '连云港布料机专业生产厂家联系电话：17858811257', '100', '1655079160', '1655085085');
INSERT INTO `ey_weapp_multicity` VALUES ('39', '28', '28', '黄浦区', '3', '1', '0', 'hp', '黄浦区液压布料机厂家', '黄浦区布料机价格,黄浦区液压布料机,黄浦区液压布料机厂家', '黄浦区布料机专业生产厂家联系电话：17858811257', '100', '1655085561', '1655085561');
INSERT INTO `ey_weapp_multicity` VALUES ('40', '28', '28', '徐汇区', '3', '1', '0', 'xhq', '徐汇区混凝土布料机厂家', '徐汇混凝土布料机价格,徐汇混凝土布料机,徐汇混凝土布料机厂家', '徐汇区混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655085936', '1655085936');
INSERT INTO `ey_weapp_multicity` VALUES ('41', '28', '28', '长宁区', '3', '1', '0', 'clq', '长宁区液压布料机厂家', '长宁区布料机价格,长宁区液压布料机,长宁区液压布料机厂家', '长宁区布料机专业生产厂家联系电话：17858811257', '100', '1655086068', '1655086068');
INSERT INTO `ey_weapp_multicity` VALUES ('42', '28', '28', '静安区', '3', '1', '0', 'jaq', '静安区液压布料机厂家', '静安区布料机价格,静安区液压布料机,静安区液压布料机厂家', '静安区布料机专业生产厂家联系电话：17858811257', '100', '1655086482', '1655086482');
INSERT INTO `ey_weapp_multicity` VALUES ('43', '28', '28', '普陀区', '3', '1', '0', 'ptq', '普陀区液压布料机厂家', '普陀区布料机价格,普陀区液压布料机,普陀区液压布料机厂家', '普陀区布料机专业生产厂家联系电话：17858811257', '100', '1655086643', '1655086643');
INSERT INTO `ey_weapp_multicity` VALUES ('44', '28', '28', '虹口区', '3', '1', '0', 'hkq', '虹口区液压布料机厂家', '虹口区布料机价格,虹口区液压布料机,虹口区液压布料机厂家', '虹口区布料机专业生产厂家联系电话：17858811257', '100', '1655088752', '1655088752');
INSERT INTO `ey_weapp_multicity` VALUES ('47', '28', '28', '杨浦区', '3', '1', '0', 'yp', '杨浦区混凝土布料机厂家', '杨浦区混凝土布料机价格,杨浦区混凝土布料机,杨浦区混凝土布料机厂家', '杨浦区混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655089323', '1655089323');
INSERT INTO `ey_weapp_multicity` VALUES ('46', '28', '28', '浦东新区', '3', '1', '0', 'ptxq', '浦东新区液压布料机厂家', '浦东新区布料机价格,浦东新区液压布料机,浦东新区液压布料机厂家', '浦东新区布料机专业生产厂家联系电话：17858811257', '100', '1655089160', '1655089160');
INSERT INTO `ey_weapp_multicity` VALUES ('48', '28', '28', '闵行区', '3', '1', '0', 'mhq', '闵行区液压布料机厂家', '闵行区布料机价格,闵行区液压布料机,闵行区液压布料机厂家', '闵行区布料机专业生产厂家联系电话：17858811257', '100', '1655089457', '1655089457');
INSERT INTO `ey_weapp_multicity` VALUES ('49', '28', '28', '宝山区', '3', '1', '0', 'bsq', '宝山区混凝土布料机厂家', '宝山区混凝土布料机价格,宝山区混凝土布料机,宝山区混凝土布料机厂家', '宝山区混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655089724', '1655089724');
INSERT INTO `ey_weapp_multicity` VALUES ('50', '28', '28', '嘉定区', '3', '1', '0', 'jdq', '嘉定区液压布料机厂家', '嘉定区布料机价格,嘉定区液压布料机,嘉定区液压布料机厂家', '嘉定区布料机专业生产厂家联系电话：17858811257', '100', '1655089836', '1655089836');
INSERT INTO `ey_weapp_multicity` VALUES ('51', '28', '28', '金山区', '3', '1', '0', 'jsq', '金山区液压布料机厂家', '金山区布料机价格,金山区液压布料机,金山区液压布料机厂家', '金山区布料机专业生产厂家联系电话：17858811257', '100', '1655089938', '1655089938');
INSERT INTO `ey_weapp_multicity` VALUES ('52', '28', '28', '松江区', '3', '1', '0', 'sjq', '松江区液压布料机厂家', '松江区布料机价格,松江区液压布料机,松江区液压布料机厂家', '松江区布料机专业生产厂家联系电话：17858811257', '100', '1655090045', '1655090045');
INSERT INTO `ey_weapp_multicity` VALUES ('53', '28', '28', '青浦区', '3', '1', '0', 'qpq', '青浦区混凝土布料机厂家', '青浦区混凝土布料机价格,青浦区混凝土布料机,青浦区混凝土布料机厂家', '青浦区混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655090322', '1655090322');
INSERT INTO `ey_weapp_multicity` VALUES ('54', '28', '28', '奉贤区', '3', '1', '0', 'fxq', '奉贤区混凝土布料机厂家', '奉贤区混凝土布料机价格,奉贤区混凝土布料机,奉贤区混凝土布料机厂家', '奉贤区混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655090427', '1655090427');
INSERT INTO `ey_weapp_multicity` VALUES ('55', '28', '28', '崇明区', '3', '1', '0', 'cmq', '崇明区混凝土布料机厂家', '崇明区混凝土布料机价格,崇明区混凝土布料机,崇明区混凝土布料机厂家', '崇明区混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655090489', '1655090489');
INSERT INTO `ey_weapp_multicity` VALUES ('56', '21', '21', '淮安', '2', '1', '0', 'wa', '淮安市混凝土布料机厂家', '淮安市混凝土布料机价格,淮安市混凝土布料机,淮安市混凝土布料机厂家', '淮安市混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655097935', '1655097935');
INSERT INTO `ey_weapp_multicity` VALUES ('57', '21', '21', '盐城市', '2', '1', '0', 'yc', '盐城市液压布料机厂家', '盐城市布料机价格,盐城市液压布料机,盐城市液压布料机厂家', '盐城市布料机专业生产厂家联系电话：17858811257', '100', '1655098121', '1655098121');
INSERT INTO `ey_weapp_multicity` VALUES ('58', '21', '21', '扬州市', '2', '1', '0', 'yzs', '扬州市混凝土布料机厂家', '扬州市混凝土布料机价格,扬州市混凝土布料机,扬州市混凝土布料机厂家', '扬州市混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655098232', '1655098232');
INSERT INTO `ey_weapp_multicity` VALUES ('59', '21', '21', '镇江市', '2', '1', '0', 'zjs', '镇江市液压布料机厂家', '镇江市混凝土布料机价格,镇江市混凝土布料机,镇江市混凝土布料机厂家', '镇江市混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655098309', '1655098309');
INSERT INTO `ey_weapp_multicity` VALUES ('60', '21', '21', '泰州市', '2', '1', '0', 'tzs', '泰州市混凝土布料机厂家', '泰州市混凝土布料机价格,泰州市混凝土布料机,泰州市混凝土布料机厂家', '泰州市混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655098436', '1655098436');
INSERT INTO `ey_weapp_multicity` VALUES ('61', '21', '21', '宿迁市', '2', '1', '0', 'sqs', '宿迁市液压布料机厂家', '宿迁市布料机价格,宿迁市液压布料机,宿迁市液压布料机厂家', '宿迁市布料机专业生产厂家联系电话：17858811257', '100', '1655098681', '1655098681');
INSERT INTO `ey_weapp_multicity` VALUES ('62', '0', '0', '浙江省', '1', '1', '0', 'zj', '浙江省液压布料机厂家', '浙江省布料机价格,浙江省液压布料机,浙江省液压布料机厂家', '浙江省布料机专业生产厂家联系电话：17858811257', '100', '1655098805', '1655100142');
INSERT INTO `ey_weapp_multicity` VALUES ('63', '62', '62', '杭州市', '2', '1', '0', 'hzs', '杭州市混凝土布料机厂家', '杭州市混凝土布料机价格,杭州市混凝土布料机,杭州市混凝土布料机厂家', '杭州市混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655100230', '1655100230');
INSERT INTO `ey_weapp_multicity` VALUES ('64', '62', '62', '宁波市', '2', '1', '0', 'nbs', '宁波市液压布料机厂家', '宁波市布料机价格,宁波市液压布料机,宁波市液压布料机厂家', '宁波市布料机专业生产厂家联系电话：17858811257', '100', '1655101124', '1655101124');
INSERT INTO `ey_weapp_multicity` VALUES ('65', '62', '62', '温州市', '2', '1', '0', 'wzs', '温州市液压布料机厂家', '温州市布料机价格,温州市液压布料机,温州市液压布料机厂家', '温州市布料机专业生产厂家联系电话：17858811257', '100', '1655101203', '1655101203');
INSERT INTO `ey_weapp_multicity` VALUES ('66', '62', '62', '嘉兴市', '2', '1', '0', 'jxs', '嘉兴市混凝土布料机厂家', '嘉兴市混凝土布料机价格,嘉兴市混凝土布料机,嘉兴市混凝土布料机厂家', '嘉兴市混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655101307', '1655101307');
INSERT INTO `ey_weapp_multicity` VALUES ('67', '62', '62', '湖州市', '2', '1', '0', 'huzs', '湖州市液压布料机厂家', '湖州市布料机价格,湖州市液压布料机,湖州市液压布料机厂家', '湖州市布料机专业生产厂家联系电话：17858811257', '100', '1655101600', '1655101600');
INSERT INTO `ey_weapp_multicity` VALUES ('68', '62', '62', '绍兴市', '2', '1', '0', 'sxs', '绍兴市混凝土布料机厂家', '绍兴市混凝土布料机价格,绍兴市混凝土布料机,绍兴市混凝土布料机厂家', '绍兴市混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655102448', '1655102448');
INSERT INTO `ey_weapp_multicity` VALUES ('69', '62', '62', '金华市', '2', '1', '0', 'jhs', '金华市液压布料机厂家', '金华市布料机价格,金华市液压布料机,金华市液压布料机厂家', '金华市布料机专业生产厂家联系电话：17858811257', '100', '1655102558', '1655102558');
INSERT INTO `ey_weapp_multicity` VALUES ('70', '62', '62', '衢州市', '2', '1', '0', 'qzs', '衢州市混凝土布料机厂家', '衢州市混凝土布料机价格,衢州市混凝土布料机,衢州市混凝土布料机厂家', '衢州市混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655102650', '1655102650');
INSERT INTO `ey_weapp_multicity` VALUES ('71', '62', '62', '舟山市', '2', '1', '0', 'zss', '舟山市液压布料机厂家', '舟山市布料机价格,舟山市液压布料机,舟山市液压布料机厂家', '舟山市布料机专业生产厂家联系电话：17858811257', '100', '1655102723', '1655102723');
INSERT INTO `ey_weapp_multicity` VALUES ('72', '62', '62', '台州市', '2', '1', '0', 'tz', '台州市液压布料机厂家', '台州市布料机价格,台州市液压布料机,台州市液压布料机厂家', '台州市布料机专业生产厂家联系电话：17858811257', '100', '1655102796', '1655102796');
INSERT INTO `ey_weapp_multicity` VALUES ('73', '62', '62', '丽水市', '2', '1', '0', 'ls', '丽水市混凝土布料机厂家', '丽水市混凝土布料机价格,丽水市混凝土布料机,丽水市混凝土布料机厂家', '丽水市混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655102871', '1655102871');
INSERT INTO `ey_weapp_multicity` VALUES ('74', '32', '32', '马鞍山市', '2', '1', '0', 'mas', '马鞍山市混凝土布料机厂家', '马鞍山市混凝土布料机价格,马鞍山市混凝土布料机,马鞍山市混凝土布料机厂家', '马鞍山市混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655103721', '1655103762');
INSERT INTO `ey_weapp_multicity` VALUES ('75', '32', '32', '淮北市', '2', '1', '0', 'hb', '淮北市液压布料机厂家', '淮北市布料机价格,淮北市液压布料机,淮北市液压布料机厂家', '淮北市布料机专业生产厂家联系电话：17858811257', '100', '1655103919', '1655103961');
INSERT INTO `ey_weapp_multicity` VALUES ('76', '32', '32', '宿州市', '2', '1', '0', 'sz', '宿州市液压布料机厂家', '宿州市布料机价格,宿州市液压布料机,宿州市液压布料机厂家', '宿州市布料机专业生产厂家联系电话：17858811257', '100', '1655104042', '1655104042');
INSERT INTO `ey_weapp_multicity` VALUES ('77', '32', '32', '阜阳市', '2', '1', '0', 'fys', '阜阳市混凝土布料机厂家', '阜阳市混凝土布料机价格,阜阳市混凝土布料机,阜阳市混凝土布料机厂家', '阜阳市混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655105710', '1655105710');
INSERT INTO `ey_weapp_multicity` VALUES ('78', '32', '32', '蚌埠市', '2', '1', '0', 'bbs', '蚌埠市液压布料机厂家', '蚌埠市布料机价格,蚌埠市液压布料机,蚌埠市液压布料机厂家', '蚌埠市布料机专业生产厂家联系电话：17858811257', '100', '1655106025', '1655106025');
INSERT INTO `ey_weapp_multicity` VALUES ('79', '32', '32', '淮南市', '2', '1', '0', 'hns', '淮南市混凝土布料机厂家', '淮南市混凝土布料机价格,淮南市混凝土布料机,淮南市混凝土布料机厂家', '淮南市混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655106118', '1655106118');
INSERT INTO `ey_weapp_multicity` VALUES ('80', '32', '32', '滁州市', '2', '1', '0', 'czs', '滁州市混凝土布料机厂家', '滁州市混凝土布料机价格,滁州市混凝土布料机,滁州市混凝土布料机厂家', '滁州市混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655106243', '1655106243');
INSERT INTO `ey_weapp_multicity` VALUES ('81', '32', '32', '六安市', '2', '1', '0', 'las', '六安市液压布料机厂家', '六安市布料机价格,六安市液压布料机,六安市液压布料机厂家', '六安市布料机专业生产厂家联系电话：17858811257', '100', '1655106328', '1655106328');
INSERT INTO `ey_weapp_multicity` VALUES ('82', '32', '32', '巢湖市', '2', '1', '0', 'chs', '巢湖市混凝土布料机厂家', '巢湖市混凝土布料机价格,巢湖市混凝土布料机,巢湖市混凝土布料机厂家', '巢湖市混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655106705', '1655106705');
INSERT INTO `ey_weapp_multicity` VALUES ('83', '32', '32', '芜湖市', '2', '1', '0', 'whs', '芜湖市混凝土布料机厂家', '芜湖市混凝土布料机价格,芜湖市混凝土布料机,芜湖市混凝土布料机厂家', '芜湖市混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655106846', '1655106846');
INSERT INTO `ey_weapp_multicity` VALUES ('84', '32', '32', '亳州市', '2', '1', '0', 'hz', '亳州市混凝土布料机厂家', '亳州市混凝土布料机价格,亳州市混凝土布料机,亳州市混凝土布料机厂家', '亳州市混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655106978', '1655106978');
INSERT INTO `ey_weapp_multicity` VALUES ('85', '32', '32', '安庆市', '2', '1', '0', 'aqs', '安庆市液压布料机厂家', '安庆市布料机价格,安庆市液压布料机,安庆市液压布料机厂家', '安庆市布料机专业生产厂家联系电话：17858811257', '100', '1655107049', '1655107049');
INSERT INTO `ey_weapp_multicity` VALUES ('86', '32', '32', '池州市', '2', '1', '0', 'cz', '池州市液压布料机厂家', '池州市布料机价格,池州市液压布料机,池州市液压布料机厂家', '池州市布料机专业生产厂家联系电话：17858811257', '100', '1655107131', '1655107131');
INSERT INTO `ey_weapp_multicity` VALUES ('87', '32', '32', '铜陵市', '2', '1', '0', 'tls', '铜陵市混凝土布料机厂家', '铜陵市混凝土布料机价格,铜陵市混凝土布料机,铜陵市混凝土布料机厂家', '铜陵市混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655107636', '1655107636');
INSERT INTO `ey_weapp_multicity` VALUES ('88', '32', '32', '宣城市', '2', '1', '0', 'xcs', '宣城市液压布料机厂家', '宣城市布料机价格,宣城市液压布料机,宣城市液压布料机厂家', '宣城市布料机专业生产厂家联系电话：17858811257', '100', '1655107718', '1655107718');
INSERT INTO `ey_weapp_multicity` VALUES ('89', '32', '32', '黄山市', '2', '1', '0', 'hss', '黄山市液压布料机厂家', '黄山市布料机价格,黄山市液压布料机,黄山市液压布料机厂家', '黄山市布料机专业生产厂家联系电话：17858811257', '100', '1655107885', '1655107885');
INSERT INTO `ey_weapp_multicity` VALUES ('90', '0', '0', '广东省', '1', '1', '0', 'gds', '广东省液压布料机厂家', '广东省布料机价格,广东省液压布料机,广东省液压布料机厂家', '广东省布料机专业生产厂家联系电话：17858811257', '100', '1655108165', '1655108165');
INSERT INTO `ey_weapp_multicity` VALUES ('91', '90', '90', '广州市', '2', '1', '0', 'gzs', '广州液压布料机厂家', '广州布料机价格,广州液压布料机,广州液压布料机厂家', '广州布料机专业生产厂家联系电话：17858811257', '100', '1655108235', '1655108235');
INSERT INTO `ey_weapp_multicity` VALUES ('92', '90', '90', '深圳市', '2', '1', '0', 'szs', '深圳市混凝土布料机厂家', '深圳市混凝土布料机价格,深圳市混凝土布料机,深圳市混凝土布料机厂家', '深圳市混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655108360', '1655108360');
INSERT INTO `ey_weapp_multicity` VALUES ('93', '90', '90', '珠海市', '2', '1', '0', 'zhs', '珠海市液压布料机厂家', '珠海市布料机价格,珠海市液压布料机,珠海市液压布料机厂家', '珠海市布料机专业生产厂家联系电话：17858811257', '100', '1655108491', '1655108491');
INSERT INTO `ey_weapp_multicity` VALUES ('94', '90', '90', '汕头市', '2', '1', '0', 'sts', '汕头市混凝土布料机厂家', '汕头市混凝土布料机价格,汕头市混凝土布料机,汕头市混凝土布料机厂家', '汕头市混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655109162', '1655109162');
INSERT INTO `ey_weapp_multicity` VALUES ('95', '90', '90', '佛山市', '2', '1', '0', 'fss', '佛山液压布料机厂家', '佛山布料机价格,佛山液压布料机,佛山液压布料机厂家', '佛山布料机专业生产厂家联系电话：17858811257', '100', '1655109448', '1655109448');
INSERT INTO `ey_weapp_multicity` VALUES ('96', '90', '90', '韶关市', '2', '1', '0', 'sgs', '韶关混凝土布料机厂家', '韶关混凝土布料机价格,韶关混凝土布料机,韶关混凝土布料机厂家', '韶关混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655109637', '1655109637');
INSERT INTO `ey_weapp_multicity` VALUES ('97', '90', '90', '湛江市', '2', '1', '0', 'zanj', '湛江液压布料机厂家', '湛江布料机价格,湛江液压布料机,湛江液压布料机厂家', '湛江布料机专业生产厂家联系电话：17858811257', '100', '1655109903', '1655109903');
INSERT INTO `ey_weapp_multicity` VALUES ('98', '90', '90', '肇庆市', '2', '1', '0', 'zqs', '肇庆市混凝土布料机厂家', '肇庆市混凝土布料机价格,肇庆市混凝土布料机,肇庆市混凝土布料机厂家', '肇庆市混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655167284', '1655167284');
INSERT INTO `ey_weapp_multicity` VALUES ('99', '90', '90', '江门市', '2', '1', '0', 'jms', '江门市液压布料机厂家', '江门布料机价格,江门液压布料机,江门液压布料机厂家', '江门布料机专业生产厂家联系电话：17858811257', '100', '1655168283', '1655168283');
INSERT INTO `ey_weapp_multicity` VALUES ('100', '90', '90', '茂名市', '2', '1', '0', 'mms', '茂名市混凝土布料机厂家', '茂名混凝土布料机价格,茂名混凝土布料机,茂名混凝土布料机厂家', '茂名混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655168887', '1655168887');
INSERT INTO `ey_weapp_multicity` VALUES ('101', '90', '90', '惠州市', '2', '1', '0', 'huz', '惠州市液压布料机厂家', '惠州布料机价格,惠州液压布料机,惠州液压布料机厂家\r\n', '惠州布料机专业生产厂家联系电话：17858811257', '100', '1655168978', '1655168978');
INSERT INTO `ey_weapp_multicity` VALUES ('102', '90', '90', '梅州市', '2', '1', '0', 'mzs', '梅州市混凝土布料机厂家', '梅州市混凝土布料机价格,梅州混凝土布料机,梅州混凝土布料机厂家', '梅州市混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655170606', '1655170606');
INSERT INTO `ey_weapp_multicity` VALUES ('103', '90', '90', '汕尾市', '2', '1', '0', 'sw', '汕尾市液压布料机厂家', '汕尾布料机价格,汕尾液压布料机,汕尾液压布料机厂家', '汕尾市布料机专业生产厂家联系电话：17858811257', '100', '1655170776', '1655170776');
INSERT INTO `ey_weapp_multicity` VALUES ('105', '90', '90', '河源市', '2', '1', '0', 'hy', '河源市液压布料机厂家', '河源布料机价格,河源液压布料机,河源液压布料机厂家', '河源布料机专业生产厂家联系电话：17858811257', '100', '1655171593', '1655171593');
INSERT INTO `ey_weapp_multicity` VALUES ('106', '90', '90', '阳江市', '2', '1', '0', 'yjs', '阳江混凝土布料机厂家', '阳江混凝土布料机价格,阳江混凝土布料机,阳江混凝土布料机厂家', '阳江混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655172208', '1655172208');
INSERT INTO `ey_weapp_multicity` VALUES ('107', '90', '90', '清远市', '2', '1', '0', 'qy', '清远混凝土布料机厂家', '清远混凝土布料机价格,清远混凝土布料机,清远混凝土布料机厂家', '清远混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655172272', '1655172272');
INSERT INTO `ey_weapp_multicity` VALUES ('108', '90', '90', '东莞市', '2', '1', '0', 'dgs', '东莞市混凝土布料机厂家', '东莞市混凝土布料机价格,东莞市混凝土布料机,东莞市混凝土布料机厂家', '东莞市混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655172584', '1655172584');
INSERT INTO `ey_weapp_multicity` VALUES ('109', '90', '90', '中山市', '2', '1', '0', 'zs', '中山市液压布料机厂家', '中山市布料机价格,中山市液压布料机,中山市液压布料机厂家', '中山市布料机专业生产厂家联系电话：17858811257', '100', '1655172657', '1655172657');
INSERT INTO `ey_weapp_multicity` VALUES ('110', '90', '90', '潮州市', '2', '1', '0', 'caz', '潮州市混凝土布料机厂家', '潮州混凝土布料机价格,潮州混凝土布料机,潮州混凝土布料机厂家', '潮州混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655172723', '1655172723');
INSERT INTO `ey_weapp_multicity` VALUES ('111', '90', '90', '揭阳市', '2', '1', '0', 'jys', '揭阳市液压布料机厂家', '揭阳市布料机价格,揭阳市液压布料机,揭阳市液压布料机厂家', '揭阳市布料机专业生产厂家联系电话：17858811257', '100', '1655172787', '1655172787');
INSERT INTO `ey_weapp_multicity` VALUES ('112', '90', '90', '云浮市', '2', '1', '0', 'yfs', '云浮市混凝土布料机厂家', '云浮市混凝土布料机价格,云浮市混凝土布料机,云浮市混凝土布料机厂家', '云浮市混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655172854', '1655172854');
INSERT INTO `ey_weapp_multicity` VALUES ('113', '0', '0', '天津市', '1', '1', '0', 'tjs', '天津市液压布料机厂家', '天津市布料机价格,天津市液压布料机,天津市液压布料机厂家', '天津市布料机专业生产厂家联系电话：17858811257', '100', '1655173208', '1655173208');
INSERT INTO `ey_weapp_multicity` VALUES ('114', '0', '0', '重庆市', '1', '1', '0', 'cqs', '重庆市混凝土布料机厂家', '重庆市混凝土布料机价格,重庆市混凝土布料机,重庆市混凝土布料机厂家', '重庆市混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655173272', '1655173272');
INSERT INTO `ey_weapp_multicity` VALUES ('115', '0', '0', '湖北省', '1', '1', '0', 'hbs', '湖北省液压布料机厂家', '湖北省布料机价格,湖北省液压布料机,湖北省液压布料机厂家', '湖北省布料机专业生产厂家联系电话：17858811257', '100', '1655173362', '1655173362');
INSERT INTO `ey_weapp_multicity` VALUES ('116', '115', '115', '武汉市', '2', '1', '0', 'wh', '武汉市混凝土布料机厂家', '武汉市混凝土布料机价格,武汉市混凝土布料机,武汉市混凝土布料机厂家', '武汉市混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655173574', '1655173574');
INSERT INTO `ey_weapp_multicity` VALUES ('118', '115', '115', '黄石市', '2', '1', '0', 'hs', '黄石市混凝土布料机厂家', '黄石市混凝土布料机价格,黄石市混凝土布料机,黄石市混凝土布料机厂家', '黄石市混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655176082', '1655176082');
INSERT INTO `ey_weapp_multicity` VALUES ('119', '115', '115', '十堰市', '2', '1', '0', 'sy', '十堰市液压布料机厂家', '十堰布料机价格,十堰液压布料机,十堰液压布料机厂家', '十堰布料机专业生产厂家联系电话：17858811257', '100', '1655176138', '1655176138');
INSERT INTO `ey_weapp_multicity` VALUES ('120', '115', '115', '宜昌市', '2', '1', '0', 'ycs', '宜昌混凝土布料机厂家', '宜昌混凝土布料机价格,宜昌混凝土布料机,宜昌混凝土布料机厂家', '宜昌混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655183905', '1655183905');
INSERT INTO `ey_weapp_multicity` VALUES ('121', '115', '115', '襄阳市', '2', '1', '0', 'xys', '襄阳市液压布料机厂家', '襄阳市布料机价格,襄阳市液压布料机,襄阳市液压布料机厂家', '襄阳市布料机专业生产厂家联系电话：17858811257', '100', '1655183999', '1655183999');
INSERT INTO `ey_weapp_multicity` VALUES ('122', '115', '115', '鄂州市', '2', '1', '0', 'ezs', '鄂州市混凝土布料机厂家', '鄂州混凝土布料机价格,鄂州混凝土布料机,鄂州混凝土布料机厂家', '鄂州混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655184167', '1655184167');
INSERT INTO `ey_weapp_multicity` VALUES ('123', '115', '115', '荆门市', '2', '1', '0', 'jm', '荆门市液压布料机厂家', '荆门布料机价格,荆门液压布料机,荆门液压布料机厂家', '荆门布料机专业生产厂家联系电话：17858811257', '100', '1655184839', '1655184839');
INSERT INTO `ey_weapp_multicity` VALUES ('124', '115', '115', '孝感市', '2', '1', '0', 'xgs', '孝感市混凝土布料机厂家', '孝感混凝土布料机价格,孝感混凝土布料机,孝感混凝土布料机厂家', '孝感混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655185032', '1655185032');
INSERT INTO `ey_weapp_multicity` VALUES ('125', '115', '115', '荆州市', '2', '1', '0', 'jz', '荆州混凝土布料机厂家', '荆州混凝土布料机价格,荆州混凝土布料机,荆州混凝土布料机厂家', '荆州混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655185133', '1655185133');
INSERT INTO `ey_weapp_multicity` VALUES ('126', '115', '115', '黄冈市', '2', '1', '0', 'hgs', '黄冈液压布料机厂家', '黄冈布料机价格,黄冈液压布料机,黄冈液压布料机厂家', '黄冈布料机专业生产厂家联系电话：17858811257', '100', '1655185212', '1655185581');
INSERT INTO `ey_weapp_multicity` VALUES ('127', '115', '115', '咸宁市', '2', '1', '0', 'xn', '咸宁市混凝土布料机厂家', '咸宁市混凝土布料机价格,咸宁市混凝土布料机,咸宁市混凝土布料机厂家', '咸宁市混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655185272', '1655185272');
INSERT INTO `ey_weapp_multicity` VALUES ('128', '115', '115', '随州市', '2', '1', '0', 'suz', '随州市液压布料机厂家', '随州市布料机价格,随州市液压布料机,随州市液压布料机厂家', '随州市布料机专业生产厂家联系电话：17858811257', '100', '1655185901', '1655185901');
INSERT INTO `ey_weapp_multicity` VALUES ('129', '115', '115', '恩施土家族苗族自治州', '2', '1', '0', 'es', '恩施土家族苗族自治州液压布料机厂家', '恩施土家族苗族自治州布料机价格,恩施土家族苗族自治州液压布料机,恩施土家族苗族自治州液压布料机厂家', '恩施土家族苗族自治州布料机专业生产厂家联系电话：17858811257', '100', '1655185990', '1655185990');
INSERT INTO `ey_weapp_multicity` VALUES ('130', '0', '0', '河南省', '1', '1', '0', 'hn', '河南省液压布料机厂家', '河南省布料机价格,河南省液压布料机,河南省液压布料机厂家', '河南省布料机专业生产厂家联系电话：17858811257', '100', '1655186157', '1655186157');
INSERT INTO `ey_weapp_multicity` VALUES ('131', '130', '130', '郑州市', '2', '1', '0', 'zz', '郑州市混凝土布料机厂家', '郑州市混凝土布料机价格,郑州市混凝土布料机,郑州市混凝土布料机厂家', '郑州市混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655186220', '1655186220');
INSERT INTO `ey_weapp_multicity` VALUES ('132', '130', '130', '开封市', '2', '1', '0', 'kf', '开封市液压布料机厂家', '开封市布料机价格,开封市液压布料机,开封市液压布料机厂家', '开封市布料机专业生产厂家联系电话：17858811257', '100', '1655186315', '1655186315');
INSERT INTO `ey_weapp_multicity` VALUES ('133', '130', '130', '洛阳市', '2', '1', '0', 'ly', '洛阳市液压布料机厂家', '洛阳市布料机价格,洛阳市液压布料机,洛阳市液压布料机厂家', '洛阳市布料机专业生产厂家联系电话：17858811257', '100', '1655186399', '1655186399');
INSERT INTO `ey_weapp_multicity` VALUES ('134', '130', '130', '平顶山市', '2', '1', '0', 'pdss', '平顶山市液压布料机厂家', '平顶山市布料机价格,平顶山市液压布料机,平顶山市液压布料机厂家', '平顶山市布料机专业生产厂家联系电话：17858811257', '100', '1655191816', '1655191816');
INSERT INTO `ey_weapp_multicity` VALUES ('135', '130', '130', '焦作市', '2', '1', '0', 'jzs', '焦作市混凝土布料机厂家', '焦作市混凝土布料机价格,焦作市混凝土布料机,焦作市混凝土布料机厂家', '焦作市混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655191941', '1655191941');
INSERT INTO `ey_weapp_multicity` VALUES ('136', '130', '130', '鹤壁市', '2', '1', '0', 'hebi', '鹤壁市液压布料机厂家', '鹤壁市布料机价格,鹤壁市液压布料机,鹤壁市液压布料机厂家', '鹤壁市布料机专业生产厂家联系电话：17858811257', '100', '1655192147', '1655192147');
INSERT INTO `ey_weapp_multicity` VALUES ('137', '130', '130', '新乡市', '2', '1', '0', 'xxs', '新乡市混凝土布料机厂家', '新乡市混凝土布料机价格,新乡市混凝土布料机,新乡市混凝土布料机厂家', '新乡市混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655192225', '1655192225');
INSERT INTO `ey_weapp_multicity` VALUES ('138', '130', '130', '安阳市', '2', '1', '0', 'ays', '安阳市液压布料机厂家', '安阳市布料机价格,安阳市液压布料机,安阳市液压布料机厂家', '安阳市布料机专业生产厂家联系电话：17858811257', '100', '1655192342', '1655192342');
INSERT INTO `ey_weapp_multicity` VALUES ('139', '130', '130', '濮阳市', '2', '1', '0', 'pys', '濮阳市液压布料机厂家', '濮阳市布料机价格,濮阳市液压布料机,濮阳市液压布料机厂家', '濮阳市布料机专业生产厂家联系电话：17858811257', '100', '1655192495', '1655192495');
INSERT INTO `ey_weapp_multicity` VALUES ('140', '130', '130', '许昌市', '2', '1', '0', 'xc', '许昌市混凝土布料机厂家', '许昌市混凝土布料机价格,许昌市混凝土布料机,许昌市混凝土布料机厂家', '许昌市混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655192546', '1655192546');
INSERT INTO `ey_weapp_multicity` VALUES ('141', '130', '130', '漯河市', '2', '1', '0', 'lh', '漯河市混凝土布料机厂家', '漯河市混凝土布料机价格,漯河市混凝土布料机,漯河市混凝土布料机厂家', '漯河市混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655192610', '1655192610');
INSERT INTO `ey_weapp_multicity` VALUES ('142', '130', '130', '三门峡市', '2', '1', '0', 'smx', '三门峡市液压布料机厂家', '三门峡市布料机价格,三门峡市液压布料机,三门峡市液压布料机厂家', '三门峡市布料机专业生产厂家联系电话：17858811257', '100', '1655192713', '1655192713');
INSERT INTO `ey_weapp_multicity` VALUES ('143', '130', '130', '南阳市', '2', '1', '0', 'nys', '南阳市混凝土布料机厂家', '南阳市混凝土布料机价格,南阳市混凝土布料机,南阳市混凝土布料机厂家', '南阳市混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655192800', '1655192800');
INSERT INTO `ey_weapp_multicity` VALUES ('144', '130', '130', '商丘市', '2', '1', '0', 'sq', '商丘市液压布料机厂家', '商丘市布料机价格,商丘市液压布料机,商丘市液压布料机厂家', '商丘市布料机专业生产厂家联系电话：17858811257', '100', '1655192857', '1655192857');
INSERT INTO `ey_weapp_multicity` VALUES ('145', '130', '130', '信阳市', '2', '1', '0', 'xy', '信阳市液压布料机厂家', '信阳市布料机价格,信阳市液压布料机,信阳市液压布料机厂家', '信阳市布料机专业生产厂家联系电话：17858811257', '100', '1655192949', '1655192949');
INSERT INTO `ey_weapp_multicity` VALUES ('146', '130', '130', '周口市', '2', '1', '0', 'zk', '周口市液压布料机厂家', '周口市布料机价格,周口市液压布料机,周口市液压布料机厂家', '周口市布料机专业生产厂家联系电话：17858811257', '100', '1655193085', '1655193085');
INSERT INTO `ey_weapp_multicity` VALUES ('147', '130', '130', '驻马店市', '2', '1', '0', 'zmd', '驻马店市混凝土布料机厂家', '驻马店市混凝土布料机价格,驻马店市混凝土布料机,驻马店市混凝土布料机厂家', '驻马店市混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655193239', '1655193239');
INSERT INTO `ey_weapp_multicity` VALUES ('148', '130', '130', '济源市', '2', '1', '0', 'qys', '济源市液压布料机厂家', '济源市布料机价格,济源市液压布料机,济源市液压布料机厂家', '济源市布料机专业生产厂家联系电话：17858811257', '100', '1655193328', '1655193328');
INSERT INTO `ey_weapp_multicity` VALUES ('149', '0', '0', '福建省', '1', '1', '0', 'fjs', '福建液压布料机厂家', '福建布料机价格,福建液压布料机,福建液压布料机厂家', '福建布料机专业生产厂家联系电话：17858811257', '100', '1655252985', '1655252985');
INSERT INTO `ey_weapp_multicity` VALUES ('150', '149', '149', '福州市', '2', '1', '0', 'fzs', '福州液压布料机厂家', '福州布料机价格,福州液压布料机,福州液压布料机厂家', '福州布料机专业生产厂家联系电话：17858811257', '100', '1655253106', '1655253106');
INSERT INTO `ey_weapp_multicity` VALUES ('151', '149', '149', '莆田市', '2', '1', '0', 'pt', '莆田混凝土布料机厂家', '莆田混凝土布料机价格,莆田混凝土布料机,莆田混凝土布料机厂家', '莆田混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655253347', '1655253347');
INSERT INTO `ey_weapp_multicity` VALUES ('152', '149', '149', '泉州市', '2', '1', '0', 'qz', '泉州液压布料机厂家', '泉州布料机价格,泉州液压布料机,泉州液压布料机厂家', '泉州布料机专业生产厂家联系电话：17858811257', '100', '1655253639', '1655253639');
INSERT INTO `ey_weapp_multicity` VALUES ('153', '149', '149', '漳州市', '2', '1', '0', 'zzs', '漳州液压布料机厂家', '漳州布料机价格,漳州液压布料机,漳州液压布料机厂家', '漳州布料机专业生产厂家联系电话：17858811257', '100', '1655253810', '1655253810');
INSERT INTO `ey_weapp_multicity` VALUES ('154', '149', '149', '龙岩市', '2', '1', '0', 'lys', '龙岩混凝土布料机厂家', '龙岩混凝土布料机价格,龙岩混凝土布料机,龙岩混凝土布料机厂家', '龙岩混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655253969', '1655253969');
INSERT INTO `ey_weapp_multicity` VALUES ('155', '149', '149', '三明市', '2', '1', '0', 'sms', '三明液压布料机厂家', '三明布料机价格,三明液压布料机,三明液压布料机厂家', '三明布料机专业生产厂家联系电话：17858811257', '100', '1655254021', '1655254021');
INSERT INTO `ey_weapp_multicity` VALUES ('156', '149', '149', '南平市', '2', '1', '0', 'nps', '南平液压布料机厂家', '南平布料机价格,南平液压布料机,南平液压布料机厂家', '南平布料机专业生产厂家联系电话：17858811257', '100', '1655255346', '1655255346');
INSERT INTO `ey_weapp_multicity` VALUES ('157', '149', '149', '宁德市', '2', '1', '0', 'nds', '宁德市混凝土布料机厂家', '宁德市混凝土布料机价格,宁德市混凝土布料机,宁德市混凝土布料机厂家', '宁德市混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655255444', '1655255444');
INSERT INTO `ey_weapp_multicity` VALUES ('177', '168', '168', '沧州市', '2', '1', '0', 'cangzhou', '沧州液压布料机厂家', '沧州布料机价格,沧州液压布料机,沧州液压布料机厂家', '沧州布料机专业生产厂家联系电话：17858811257', '100', '1655261312', '1655261312');
INSERT INTO `ey_weapp_multicity` VALUES ('168', '0', '0', '河北省', '1', '1', '0', 'hebei', '河北液压布料机厂家', '河北布料机价格,河北液压布料机,河北液压布料机厂家', '河北省布料机专业生产厂家联系电话：17858811257', '100', '1655259373', '1655259373');
INSERT INTO `ey_weapp_multicity` VALUES ('169', '168', '168', '石家庄市', '2', '1', '0', 'sjzs', '石家庄混凝土布料机厂家', '石家庄混凝土布料机价格,石家庄混凝土布料机,石家庄混凝土布料机厂家', '石家庄混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655259882', '1655259882');
INSERT INTO `ey_weapp_multicity` VALUES ('170', '168', '168', '唐山市', '2', '1', '0', 'tss', '唐山市混凝土布料机厂家', '唐山市混凝土布料机价格,唐山市混凝土布料机,唐山市混凝土布料机厂家', '唐山市混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655260398', '1655260398');
INSERT INTO `ey_weapp_multicity` VALUES ('171', '168', '168', '秦皇岛市', '2', '1', '0', 'qhds', '秦皇岛市液压布料机厂家', '秦皇岛市布料机价格,秦皇岛市液压布料机,秦皇岛市液压布料机厂家', '秦皇岛市布料机专业生产厂家联系电话：17858811257', '100', '1655260796', '1655260796');
INSERT INTO `ey_weapp_multicity` VALUES ('172', '168', '168', '邯郸市', '2', '1', '0', 'hds', '邯郸市混凝土布料机厂家', '邯郸市混凝土布料机价格,邯郸市混凝土布料机,邯郸市混凝土布料机厂家', '邯郸市混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655260954', '1655260954');
INSERT INTO `ey_weapp_multicity` VALUES ('173', '168', '168', '邢台市', '2', '1', '0', 'xt', '邢台市液压布料机厂家', '邢台市布料机价格,邢台市液压布料机,邢台市液压布料机厂家', '邢台市布料机专业生产厂家联系电话：17858811257', '100', '1655261016', '1655261016');
INSERT INTO `ey_weapp_multicity` VALUES ('174', '168', '168', '保定市', '2', '1', '0', 'bds', '保定市液压布料机厂家', '保定市布料机价格,保定市液压布料机,保定市液压布料机厂家', '保定市布料机专业生产厂家联系电话：17858811257', '100', '1655261106', '1655261106');
INSERT INTO `ey_weapp_multicity` VALUES ('175', '168', '168', '张家口市', '2', '1', '0', 'zjk', '张家口市液压布料机厂家', '张家口市布料机价格,张家口市液压布料机,张家口市液压布料机厂家', '张家口市布料机专业生产厂家联系电话：17858811257', '100', '1655261197', '1655261197');
INSERT INTO `ey_weapp_multicity` VALUES ('176', '168', '168', '承德市', '2', '1', '0', 'cds', '承德市混凝土布料机厂家', '承德市混凝土布料机价格,承德市混凝土布料机,承德市混凝土布料机厂家', '承德市混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655261253', '1655261253');
INSERT INTO `ey_weapp_multicity` VALUES ('178', '168', '168', '廊坊市', '2', '1', '0', 'lfs', '廊坊市混凝土布料机厂家', '廊坊市混凝土布料机价格,廊坊市混凝土布料机,廊坊市混凝土布料机厂家', '廊坊市混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655261425', '1655261425');
INSERT INTO `ey_weapp_multicity` VALUES ('179', '168', '168', '衡水市', '2', '1', '0', 'hengshui', '衡水市液压布料机厂家', '衡水市布料机价格,衡水市液压布料机,v液压布料机厂家', '衡水市布料机专业生产厂家联系电话：17858811257', '100', '1655261490', '1655261490');
INSERT INTO `ey_weapp_multicity` VALUES ('180', '0', '0', '北京', '1', '1', '0', 'beijing', '北京液压布料机厂家', '北京布料机价格,北京液压布料机,北京液压布料机厂家', '北京布料机专业生产厂家联系电话：17858811257', '100', '1655261615', '1655261849');
INSERT INTO `ey_weapp_multicity` VALUES ('181', '0', '0', '山东省', '1', '1', '0', 'sds', '山东省液压布料机厂家', '山东布料机价格,山东液压布料机,山东液压布料机厂家', '山东布料机专业生产厂家联系电话：17858811257', '100', '1655262328', '1655262328');
INSERT INTO `ey_weapp_multicity` VALUES ('182', '181', '181', '济南市', '2', '1', '0', 'jns', '济南液压布料机厂家', '济南布料机价格,济南液压布料机,济南液压布料机厂家', '济南布料机专业生产厂家联系电话：17858811257', '100', '1655262522', '1655262522');
INSERT INTO `ey_weapp_multicity` VALUES ('184', '181', '181', '青岛市', '2', '1', '0', 'qds', '青岛混凝土布料机厂家', '青岛混凝土布料机价格,青岛混凝土布料机,青岛混凝土布料机厂家', '青岛混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655262686', '1655262686');
INSERT INTO `ey_weapp_multicity` VALUES ('185', '181', '181', '烟台市', '2', '1', '0', 'yts', '烟台市液压布料机厂家', '烟台布料机价格,烟台液压布料机,烟台液压布料机厂家', '烟台布料机专业生产厂家联系电话：17858811257', '100', '1655262753', '1655262753');
INSERT INTO `ey_weapp_multicity` VALUES ('186', '181', '181', '威海市', '2', '1', '0', 'weihai', '威海液压布料机厂家', '威海布料机价格,威海液压布料机,威海液压布料机厂家', '威海布料机专业生产厂家联系电话：17858811257', '100', '1655262894', '1655262894');
INSERT INTO `ey_weapp_multicity` VALUES ('187', '181', '181', '东营市', '2', '1', '0', 'dys', '东营混凝土布料机厂家', '东营混凝土布料机价格,东营混凝土布料机,东营混凝土布料机厂家', '东营混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655263074', '1655263074');
INSERT INTO `ey_weapp_multicity` VALUES ('188', '181', '181', '淄博市', '2', '1', '0', 'zbs', '淄博市液压布料机厂家', '淄博布料机价格,淄博液压布料机,淄博液压布料机厂家', '淄博布料机专业生产厂家联系电话：17858811257', '100', '1655263561', '1655263561');
INSERT INTO `ey_weapp_multicity` VALUES ('189', '181', '181', '潍坊市', '2', '1', '0', 'wfs', '潍坊市液压布料机厂家', '潍坊布料机价格,潍坊液压布料机,潍坊液压布料机厂家', '潍坊布料机专业生产厂家联系电话：17858811257', '100', '1655263696', '1655263696');
INSERT INTO `ey_weapp_multicity` VALUES ('190', '181', '181', '日照市', '2', '1', '0', 'rzs', '日照市液压布料机厂家', '日照市布料机价格,日照市液压布料机,日照市液压布料机厂家', '日照市布料机专业生产厂家联系电话：17858811257', '100', '1655269649', '1655269649');
INSERT INTO `ey_weapp_multicity` VALUES ('191', '181', '181', '莱芜市', '2', '1', '0', 'lw', '莱芜市液压布料机厂家', '莱芜市布料机价格,莱芜市液压布料机,莱芜市液压布料机厂家', '莱芜市布料机专业生产厂家联系电话：17858811257', '100', '1655269776', '1655269776');
INSERT INTO `ey_weapp_multicity` VALUES ('192', '181', '181', '菏泽市', '2', '1', '0', 'heze', '菏泽市混凝土布料机厂家', '菏泽市混凝土布料机价格,菏泽市混凝土布料机,菏泽市混凝土布料机厂家', '菏泽市混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655269860', '1655269860');
INSERT INTO `ey_weapp_multicity` VALUES ('193', '181', '181', '枣庄市', '2', '1', '0', 'zaozhuang', '枣庄市液压布料机厂家', '枣庄市布料机价格,枣庄市液压布料机,枣庄市液压布料机厂家', '枣庄市布料机专业生产厂家联系电话：17858811257', '100', '1655270569', '1655270569');
INSERT INTO `ey_weapp_multicity` VALUES ('194', '181', '181', '德州市', '2', '1', '0', 'dz', '德州市混凝土布料机厂家', '德州市混凝土布料机价格,德州市混凝土布料机,德州市混凝土布料机厂家', '德州市混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655270654', '1655270654');
INSERT INTO `ey_weapp_multicity` VALUES ('195', '181', '181', '滨州市', '2', '1', '0', 'bz', '滨州液压布料机厂家', '滨州布料机价格,滨州液压布料机,滨州液压布料机厂家', '滨州布料机专业生产厂家联系电话：17858811257', '100', '1655270777', '1655270777');
INSERT INTO `ey_weapp_multicity` VALUES ('196', '181', '181', '临沂市', '2', '1', '0', 'lq', '临沂混凝土布料机厂家', '临沂混凝土布料机价格,临沂混凝土布料机,临沂混凝土布料机厂家', '临沂混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655270841', '1655270841');
INSERT INTO `ey_weapp_multicity` VALUES ('197', '181', '181', '济宁市', '2', '1', '0', 'jn', '济宁液压布料机厂家', '济宁布料机价格,济宁液压布料机,济宁液压布料机厂家', '济宁布料机专业生产厂家联系电话：17858811257', '100', '1655270909', '1655270909');
INSERT INTO `ey_weapp_multicity` VALUES ('198', '181', '181', '聊城市', '2', '1', '0', 'lc', '聊城混凝土布料机厂家', '聊城混凝土布料机价格,聊城混凝土布料机,聊城混凝土布料机厂家', '聊城混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655270978', '1655270978');
INSERT INTO `ey_weapp_multicity` VALUES ('199', '181', '181', '泰安市', '2', '1', '0', 'ta', '泰安市液压布料机厂家', '泰安市布料机价格,泰安市液压布料机,泰安市液压布料机厂家', '泰安市布料机专业生产厂家联系电话：17858811257', '100', '1655271042', '1655271042');
INSERT INTO `ey_weapp_multicity` VALUES ('200', '0', '0', '湖南省', '1', '1', '0', 'hunan', '湖南省液压布料机厂家', '湖南省布料机价格,湖南省液压布料机,湖南省液压布料机厂家', '湖南省布料机专业生产厂家联系电话：17858811257', '100', '1655271212', '1655271521');
INSERT INTO `ey_weapp_multicity` VALUES ('201', '200', '200', '长沙市', '2', '1', '0', 'cs', '长沙液压布料机厂家', '长沙布料机价格,长沙液压布料机,长沙液压布料机厂家', '长沙布料机专业生产厂家联系电话：17858811257', '100', '1655279148', '1655279148');
INSERT INTO `ey_weapp_multicity` VALUES ('202', '200', '200', '湘潭市', '2', '1', '0', 'xts', '湘潭混凝土布料机厂家', '湘潭混凝土布料机价格,湘潭混凝土布料机,湘潭混凝土布料机厂家', '湘潭混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655279234', '1655279234');
INSERT INTO `ey_weapp_multicity` VALUES ('203', '200', '200', '株洲市', '2', '1', '0', 'zhuzhou', '株洲液压布料机厂家', '株洲布料机价格,株洲液压布料机,株洲液压布料机厂家', '株洲布料机专业生产厂家联系电话：17858811257', '100', '1655279317', '1655279317');
INSERT INTO `ey_weapp_multicity` VALUES ('204', '200', '200', '衡阳市', '2', '1', '0', 'hengyang', '衡阳液压布料机厂家', '衡阳布料机价格,衡阳液压布料机,衡阳液压布料机厂家', '衡阳布料机专业生产厂家联系电话：17858811257', '100', '1655279594', '1655279594');
INSERT INTO `ey_weapp_multicity` VALUES ('205', '200', '200', '邵阳市', '2', '1', '0', 'sys', '邵阳混凝土布料机厂家', '邵阳混凝土布料机价格,邵阳混凝土布料机,邵阳混凝土布料机厂家', '邵阳混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655279676', '1655279676');
INSERT INTO `ey_weapp_multicity` VALUES ('206', '200', '200', '岳阳市', '2', '1', '0', 'yys', '岳阳液压布料机厂家', '岳阳布料机价格,岳阳液压布料机,岳阳液压布料机厂家', '岳阳布料机专业生产厂家联系电话：17858811257', '100', '1655279790', '1655279790');
INSERT INTO `ey_weapp_multicity` VALUES ('207', '200', '200', '常德市', '2', '1', '0', 'cd', '常德混凝土布料机厂家', '常德混凝土布料机价格,常德混凝土布料机,常德混凝土布料机厂家', '常德混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655279951', '1655279951');
INSERT INTO `ey_weapp_multicity` VALUES ('208', '200', '200', '张家界市', '2', '1', '0', 'zjjs', '张家界液压布料机厂家', '张家界布料机价格,张家界液压布料机,张家界液压布料机厂家', '张家界布料机专业生产厂家联系电话：17858811257', '100', '1655280149', '1655280149');
INSERT INTO `ey_weapp_multicity` VALUES ('209', '200', '200', '郴州市', '2', '1', '0', 'chengzhou', '郴州混凝土布料机厂家', '郴州混凝土布料机价格,郴州混凝土布料机,郴州混凝土布料机厂家', '郴州混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655280236', '1655280236');
INSERT INTO `ey_weapp_multicity` VALUES ('210', '200', '200', '益阳市', '2', '1', '0', 'yy', '益阳混凝土布料机厂家', '益阳混凝土布料机价格,益阳混凝土布料机,益阳混凝土布料机厂家', '益阳混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655280341', '1655280341');
INSERT INTO `ey_weapp_multicity` VALUES ('211', '200', '200', '永州市', '2', '1', '0', 'yz', '永州液压布料机厂家', '永州布料机价格,永州液压布料机,永州液压布料机厂家', '永州布料机专业生产厂家联系电话：17858811257', '100', '1655280397', '1655280397');
INSERT INTO `ey_weapp_multicity` VALUES ('212', '200', '200', '怀化市', '2', '1', '0', 'hhs', '怀化混凝土布料机厂家', '怀化混凝土布料机价格,怀化混凝土布料机,怀化混凝土布料机厂家', '怀化混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655280464', '1655280464');
INSERT INTO `ey_weapp_multicity` VALUES ('213', '200', '200', '娄底市', '2', '1', '0', 'lds', '娄底液压布料机厂家', '娄底布料机价格,娄底液压布料机,娄底液压布料机厂家', '娄底布料机专业生产厂家联系电话：17858811257', '100', '1655280534', '1655280534');
INSERT INTO `ey_weapp_multicity` VALUES ('214', '200', '200', '湘西土家族苗族自治州', '2', '1', '0', 'xxz', '湘西州混凝土布料机厂家', '湘西州混凝土布料机价格,湘西州混凝土布料机,湘西州混凝土布料机厂家', '湘西州混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655280616', '1655280616');
INSERT INTO `ey_weapp_multicity` VALUES ('215', '0', '0', '四川省', '1', '1', '0', 'scs', '四川混凝土布料机厂家', '四川混凝土布料机价格,四川混凝土布料机,四川混凝土布料机厂家', '四川混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655281819', '1655281819');
INSERT INTO `ey_weapp_multicity` VALUES ('216', '215', '215', '成都市', '2', '1', '0', 'chengdushi', '成都市混凝土布料机厂家', '成都混凝土布料机价格,成都混凝土布料机,成都混凝土布料机厂家', '成都混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655281887', '1655281887');
INSERT INTO `ey_weapp_multicity` VALUES ('217', '215', '215', '绵阳市', '2', '1', '0', 'mys', '绵阳液压布料机厂家', '绵阳布料机价格,绵阳液压布料机,绵阳液压布料机厂家', '绵阳布料机专业生产厂家联系电话：17858811257', '100', '1655281965', '1655281965');
INSERT INTO `ey_weapp_multicity` VALUES ('218', '215', '215', '自贡市', '2', '1', '0', 'zgs', '自贡市混凝土布料机厂家', '自贡混凝土布料机价格,自贡混凝土布料机,自贡混凝土布料机厂家', '自贡混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655282032', '1655282032');
INSERT INTO `ey_weapp_multicity` VALUES ('219', '215', '215', '攀枝花市', '2', '1', '0', 'pzhs', '攀枝花液压布料机厂家', '攀枝花布料机价格,攀枝花液压布料机,攀枝花液压布料机厂家', '攀枝花布料机专业生产厂家联系电话：17858811257', '100', '1655282093', '1655282093');
INSERT INTO `ey_weapp_multicity` VALUES ('220', '215', '215', '泸州市', '2', '1', '0', 'lzs', '泸州市混凝土布料机厂家', '泸州混凝土布料机价格,泸州混凝土布料机,泸州混凝土布料机厂家', '泸州混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655282343', '1655282343');
INSERT INTO `ey_weapp_multicity` VALUES ('221', '215', '215', '德阳市', '2', '1', '0', 'deyang', '德阳混凝土布料机厂家', '德阳混凝土布料机价格,德阳混凝土布料机,德阳混凝土布料机厂家', '德阳混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655283164', '1655283164');
INSERT INTO `ey_weapp_multicity` VALUES ('222', '215', '215', '广元市', '2', '1', '0', 'gys', '广元混凝土布料机厂家', '广元混凝土布料机价格,广元混凝土布料机,广元混凝土布料机厂家', '广元混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655284129', '1655284129');
INSERT INTO `ey_weapp_multicity` VALUES ('223', '215', '215', '遂宁市', '2', '1', '0', 'sns', '遂宁液压布料机厂家', '遂宁布料机价格,遂宁液压布料机,遂宁液压布料机厂家', '遂宁布料机专业生产厂家联系电话：17858811257', '100', '1655284263', '1655284263');
INSERT INTO `ey_weapp_multicity` VALUES ('224', '215', '215', '内江市', '2', '1', '0', 'njs', '内江液压布料机厂家', '内江布料机价格,内江液压布料机,内江液压布料机厂家', '内江布料机专业生产厂家联系电话：17858811257', '100', '1655284412', '1655284412');
INSERT INTO `ey_weapp_multicity` VALUES ('225', '215', '215', '乐山市', '2', '1', '0', 'lss', '乐山混凝土布料机厂家', '乐山混凝土布料机价格,乐山混凝土布料机,乐山混凝土布料机厂家', '乐山混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655339495', '1655339495');
INSERT INTO `ey_weapp_multicity` VALUES ('226', '215', '215', '资阳市', '2', '1', '0', 'zy', '资阳市混凝土布料机厂家', '资阳市混凝土布料机价格,资阳市混凝土布料机,资阳市锡混凝土布料机厂家', '资阳市混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655339617', '1655339617');
INSERT INTO `ey_weapp_multicity` VALUES ('227', '215', '215', '宜宾市', '2', '1', '0', 'yb', '宜宾液压布料机厂家', '宜宾布料机价格,宜宾液压布料机,宜宾液压布料机厂家', '宜宾布料机专业生产厂家联系电话：17858811257', '100', '1655339797', '1655339797');
INSERT INTO `ey_weapp_multicity` VALUES ('228', '215', '215', '南充市', '2', '1', '0', 'ncs', '南充混凝土布料机厂家', '南充混凝土布料机价格,南充混凝土布料机,南充混凝土布料机厂家', '南充市混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655339893', '1655339893');
INSERT INTO `ey_weapp_multicity` VALUES ('229', '215', '215', '达州市', '2', '1', '0', 'dzs', '达州市混凝土布料机厂家', '达州市混凝土布料机价格,达州市混凝土布料机,达州市混凝土布料机厂家', '达州市混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655340103', '1655340103');
INSERT INTO `ey_weapp_multicity` VALUES ('230', '215', '215', '雅安市', '2', '1', '0', 'yas', '雅安液压布料机厂家', '雅安布料机价格,雅安液压布料机,雅安液压布料机厂家', '雅安布料机专业生产厂家联系电话：17858811257', '100', '1655340166', '1655340166');
INSERT INTO `ey_weapp_multicity` VALUES ('231', '215', '215', '广安市', '2', '1', '0', 'ga', '广安市液压布料机厂家', '广安市布料机价格,广安市液压布料机,广安市液压布料机厂家', '广安市布料机专业生产厂家联系电话：17858811257', '100', '1655340230', '1655340230');
INSERT INTO `ey_weapp_multicity` VALUES ('232', '215', '215', '巴中市', '2', '1', '0', 'bzs', '巴中混凝土布料机厂家', '巴中混凝土布料机价格,巴中混凝土布料机,巴中混凝土布料机厂家', '巴中混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655340386', '1655340386');
INSERT INTO `ey_weapp_multicity` VALUES ('233', '215', '215', '眉山市', '2', '1', '0', 'ms', '眉山液压布料机厂家', '眉山布料机价格,眉山液压布料机,眉山液压布料机厂家', '眉山布料机专业生产厂家联系电话：17858811257', '100', '1655340456', '1655340456');
INSERT INTO `ey_weapp_multicity` VALUES ('235', '0', '0', '江西省', '1', '1', '0', 'jx', '江西省混凝土布料机厂家', '江西省混凝土布料机价格,江西省混凝土布料机,江西省混凝土布料机厂家', '江西省混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655341875', '1655341875');
INSERT INTO `ey_weapp_multicity` VALUES ('236', '235', '235', '南昌市', '2', '1', '0', 'nc', '南昌混凝土布料机厂家', '南昌混凝土布料机价格,南昌混凝土布料机,南昌混凝土布料机厂家', '南昌混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655341946', '1655341946');
INSERT INTO `ey_weapp_multicity` VALUES ('237', '235', '235', '九江市', '2', '1', '0', 'jjs', '九江液压布料机厂家', '九江布料机价格,九江液压布料机,九江液压布料机厂家', '九江布料机专业生产厂家联系电话：17858811257', '100', '1655342206', '1655342206');
INSERT INTO `ey_weapp_multicity` VALUES ('238', '235', '235', '上饶市', '2', '1', '0', 'srs', '上饶液压布料机厂家', '上饶布料机价格,上饶液压布料机,上饶液压布料机厂家', '上饶布料机专业生产厂家联系电话：17858811257', '100', '1655342355', '1655342367');
INSERT INTO `ey_weapp_multicity` VALUES ('239', '235', '235', '抚州市', '2', '1', '0', 'wz', '抚州混凝土布料机厂家', '抚州混凝土布料机价格,抚州混凝土布料机,抚州混凝土布料机厂家', '抚州混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655342453', '1655342453');
INSERT INTO `ey_weapp_multicity` VALUES ('240', '235', '235', '宜春市', '2', '1', '0', 'yichun', '宜春混凝土布料机厂家', '宜春混凝土布料机价格,宜春混凝土布料机,宜春混凝土布料机厂家', '宜春混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655342570', '1655342570');
INSERT INTO `ey_weapp_multicity` VALUES ('241', '235', '235', '吉安市', '2', '1', '0', 'jas', '吉安液压布料机厂家', '吉安布料机价格,吉安液压布料机,吉安液压布料机厂家', '吉安布料机专业生产厂家联系电话：17858811257', '100', '1655342810', '1655342810');
INSERT INTO `ey_weapp_multicity` VALUES ('242', '235', '235', '赣州市', '2', '1', '0', 'gz', '赣州混凝土布料机厂家', '赣州混凝土布料机价格,赣州混凝土布料机,赣州混凝土布料机厂家', '赣州混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655343199', '1655343199');
INSERT INTO `ey_weapp_multicity` VALUES ('243', '235', '235', '景德镇市', '2', '1', '0', 'jdzs', '景德镇混凝土布料机专业生产厂家联系电话：17858811257', '景德镇混凝土布料机价格,景德镇混凝土布料机,景德镇混凝土布料机厂家', '景德镇混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655343303', '1655343303');
INSERT INTO `ey_weapp_multicity` VALUES ('244', '235', '235', '萍乡市', '2', '1', '0', 'pxs', '萍乡市混凝土布料机厂家', '萍乡市混凝土布料机价格,萍乡市混凝土布料机,萍乡市锡混凝土布料机厂家', '萍乡市混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655343533', '1655343533');
INSERT INTO `ey_weapp_multicity` VALUES ('245', '235', '235', '新余市', '2', '1', '0', 'xinyu', '新余液压布料机厂家', '新余布料机价格,新余液压布料机,新余液压布料机厂家', '新余布料机专业生产厂家联系电话：17858811257', '100', '1655343607', '1655343607');
INSERT INTO `ey_weapp_multicity` VALUES ('246', '235', '235', '鹰潭市', '2', '1', '0', 'yt', '鹰潭市混凝土布料机厂家', '鹰潭市混凝土布料机价格,鹰潭市混凝土布料机,鹰潭市混凝土布料机厂家', '鹰潭市混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655343664', '1655343664');
INSERT INTO `ey_weapp_multicity` VALUES ('247', '0', '0', '山西省', '1', '1', '0', 'sx', '山西液压布料机厂家', '山西布料机价格,山西液压布料机,山西液压布料机厂家', '山西布料机专业生产厂家联系电话：17858811257', '100', '1655344414', '1655344414');
INSERT INTO `ey_weapp_multicity` VALUES ('248', '247', '247', '太原市', '2', '1', '0', 'tys', '太原市液压布料机厂家', '太原市布料机价格,太原市液压布料机,太原市液压布料机厂家', '太原市布料机专业生产厂家联系电话：17858811257', '100', '1655344770', '1655344770');
INSERT INTO `ey_weapp_multicity` VALUES ('249', '247', '247', '临汾市', '2', '1', '0', 'lf', '临汾液压布料机厂家', '临汾布料机价格,临汾液压布料机,临汾液压布料机厂家', '临汾布料机专业生产厂家联系电话：17858811257', '100', '1655344896', '1655344896');
INSERT INTO `ey_weapp_multicity` VALUES ('250', '247', '247', '朔州市', '2', '1', '0', 'shuozhou', '朔州液压布料机厂家', '朔州布料机价格,朔州液压布料机,朔州液压布料机厂家', '朔州布料机专业生产厂家联系电话：17858811257', '100', '1655345000', '1655345000');
INSERT INTO `ey_weapp_multicity` VALUES ('251', '247', '247', '大同市', '2', '1', '0', 'dts', '大同市液压布料机厂家', '大同市布料机价格,大同市液压布料机,大同市液压布料机厂家', '大同市布料机专业生产厂家联系电话：17858811257', '100', '1655345061', '1655345061');
INSERT INTO `ey_weapp_multicity` VALUES ('252', '247', '247', '长治市', '2', '1', '0', 'changzhishi', '长治市液压布料机厂家', '长治布料机价格,长治液压布料机,长治液压布料机厂家', '长治布料机专业生产厂家联系电话：17858811257', '100', '1655345161', '1655345161');
INSERT INTO `ey_weapp_multicity` VALUES ('253', '247', '247', '吕梁市', '2', '1', '0', 'lls', '吕梁市混凝土布料机厂家', '吕梁混凝土布料机价格,吕梁混凝土布料机,吕梁混凝土布料机厂家', '吕梁混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655345289', '1655345289');
INSERT INTO `ey_weapp_multicity` VALUES ('254', '247', '247', '晋中市', '2', '1', '0', 'jinzhong', '晋中液压布料机厂家', '晋中布料机价格,晋中液压布料机,晋中液压布料机厂家', '晋中布料机专业生产厂家联系电话：17858811257', '100', '1655345379', '1655345379');
INSERT INTO `ey_weapp_multicity` VALUES ('255', '247', '247', '忻州市', '2', '1', '0', 'xinzhou', '忻州液压布料机厂家', '忻州布料机价格,忻州液压布料机,忻州液压布料机厂家', '忻州布料机专业生产厂家联系电话：17858811257', '100', '1655345655', '1655345655');
INSERT INTO `ey_weapp_multicity` VALUES ('256', '247', '247', '运城市', '2', '1', '0', 'yuncheng', '运城混凝土布料机厂家', '运城混凝土布料机价格,运城混凝土布料机,运城混凝土布料机厂家', '运城混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655345755', '1655345755');
INSERT INTO `ey_weapp_multicity` VALUES ('257', '247', '247', '阳泉市', '2', '1', '0', 'yangquan', '阳泉液压布料机厂家', '阳泉布料机价格,阳泉液压布料机,阳泉液压布料机厂家', '阳泉布料机专业生产厂家联系电话：17858811257', '100', '1655345853', '1655345853');
INSERT INTO `ey_weapp_multicity` VALUES ('258', '247', '247', '晋城市', '2', '1', '0', 'jincheng', '晋城混凝土布料机厂家', '晋城混凝土布料机价格,晋城混凝土布料机,晋城混凝土布料机厂家', '晋城混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655346149', '1655346149');
INSERT INTO `ey_weapp_multicity` VALUES ('259', '247', '247', '阳泉市', '2', '1', '0', 'yqs', '阳泉液压布料机厂家', '阳泉布料机价格,阳泉液压布料机,阳泉液压布料机厂家', '阳泉布料机专业生产厂家联系电话：17858811257', '100', '1655346233', '1655346233');
INSERT INTO `ey_weapp_multicity` VALUES ('260', '0', '0', '辽宁省', '1', '1', '0', 'lns', '辽宁省混凝土布料机厂家', '辽宁省混凝土布料机价格,辽宁省混凝土布料机,辽宁省混凝土布料机厂家', '辽宁省混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655346466', '1655346466');
INSERT INTO `ey_weapp_multicity` VALUES ('261', '260', '260', '沈阳市', '2', '1', '0', 'shengyangshi', '沈阳市混凝土布料机厂家', '沈阳混凝土布料机价格,沈阳混凝土布料机,沈阳混凝土布料机厂家', '沈阳混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655346602', '1655346602');
INSERT INTO `ey_weapp_multicity` VALUES ('262', '260', '260', '大连市', '2', '1', '0', 'dls', '大连液压布料机厂家', '大连布料机价格,大连液压布料机,大连液压布料机厂家', '大连布料机专业生产厂家联系电话：17858811257', '100', '1655346721', '1655346721');
INSERT INTO `ey_weapp_multicity` VALUES ('263', '260', '260', '鞍山市', '2', '1', '0', 'ass', '鞍山混凝土布料机厂家', '鞍山混凝土布料机价格,鞍山混凝土布料机,鞍山混凝土布料机厂家', '鞍山混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655346840', '1655346840');
INSERT INTO `ey_weapp_multicity` VALUES ('264', '260', '260', '抚顺市', '2', '1', '0', 'wss', '抚顺市液压布料机厂家', '抚顺布料机价格,抚顺液压布料机,抚顺液压布料机厂家', '抚顺布料机专业生产厂家联系电话：17858811257', '100', '1655346913', '1655346913');
INSERT INTO `ey_weapp_multicity` VALUES ('265', '260', '260', '本溪市', '2', '1', '0', 'bx', '本溪市混凝土布料机厂家', '本溪混凝土布料机价格,本溪混凝土布料机,本溪混凝土布料机厂家', '本溪混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655346996', '1655346996');
INSERT INTO `ey_weapp_multicity` VALUES ('266', '260', '260', '丹东市', '2', '1', '0', 'dds', '丹东市液压布料机厂家', '丹东布料机价格,丹东液压布料机,丹东液压布料机厂家', '丹东布料机专业生产厂家联系电话：17858811257', '100', '1655347071', '1655347071');
INSERT INTO `ey_weapp_multicity` VALUES ('267', '260', '260', '锦州市', '2', '1', '0', 'jinzhou', '锦州混凝土布料机厂家', '锦州混凝土布料机价格,锦州混凝土布料机,锦州混凝土布料机厂家', '锦州混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655347177', '1655347177');
INSERT INTO `ey_weapp_multicity` VALUES ('268', '260', '260', '营口市', '2', '1', '0', 'yks', '营口市液压布料机厂家', '营口布料机价格,营口液压布料机,营口液压布料机厂家', '营口布料机专业生产厂家联系电话：17858811257', '100', '1655347447', '1655347447');
INSERT INTO `ey_weapp_multicity` VALUES ('269', '260', '260', '阜新市', '2', '1', '0', 'fxs', '阜新液压布料机厂家', '阜新布料机价格,阜新液压布料机,阜新液压布料机厂家', '阜新布料机专业生产厂家联系电话：17858811257', '100', '1655347518', '1655347518');
INSERT INTO `ey_weapp_multicity` VALUES ('270', '260', '260', '辽阳市', '2', '1', '0', 'liaoyang', '辽阳混凝土布料机厂家', '辽阳混凝土布料机价格,辽阳混凝土布料机,辽阳混凝土布料机厂家', '辽阳混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655347623', '1655347623');
INSERT INTO `ey_weapp_multicity` VALUES ('271', '260', '260', '盘锦市', '2', '1', '0', 'pjs', '盘锦液压布料机厂家', '盘锦布料机价格,盘锦液压布料机,盘锦液压布料机厂家', '盘锦布料机专业生产厂家联系电话：17858811257', '100', '1655347677', '1655347677');
INSERT INTO `ey_weapp_multicity` VALUES ('272', '260', '260', '铁岭市', '2', '1', '0', 'tl', '铁岭液压布料机厂家', '铁岭布料机价格,铁岭液压布料机,铁岭液压布料机厂家', '铁岭布料机专业生产厂家联系电话：17858811257', '100', '1655347753', '1655347753');
INSERT INTO `ey_weapp_multicity` VALUES ('273', '260', '260', '朝阳市', '2', '1', '0', 'zhaoyang', '朝阳混凝土布料机厂家', '朝阳混凝土布料机价格,朝阳混凝土布料机,朝阳混凝土布料机厂家', '朝阳混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655347829', '1655347829');
INSERT INTO `ey_weapp_multicity` VALUES ('274', '260', '260', '葫芦岛市', '2', '1', '0', 'hld', '葫芦岛液压布料机厂家', '葫芦岛布料机价格,葫芦岛液压布料机,葫芦岛液压布料机厂家', '葫芦岛布料机专业生产厂家联系电话：17858811257', '100', '1655347897', '1655347897');
INSERT INTO `ey_weapp_multicity` VALUES ('275', '0', '0', '台湾省', '1', '1', '0', 'tianwansheng', '台湾省混凝土布料机厂家', '台湾混凝土布料机价格,台湾混凝土布料机,台湾混凝土布料机厂家', '台湾混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655349018', '1655357173');
INSERT INTO `ey_weapp_multicity` VALUES ('276', '275', '275', '台北市', '2', '1', '0', 'tbs', '台北市混凝土布料机厂家', '台北混凝土布料机价格,台北混凝土布料机,台北混凝土布料机厂家', '台北混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655349307', '1655349307');
INSERT INTO `ey_weapp_multicity` VALUES ('277', '275', '275', '新北市', '2', '1', '0', 'xbs', '新北液压布料机厂家', '新北布料机价格,新北液压布料机,新北液压布料机厂家', '新北布料机专业生产厂家联系电话：17858811257', '100', '1655349738', '1655349738');
INSERT INTO `ey_weapp_multicity` VALUES ('278', '275', '275', '桃园市', '2', '1', '0', 'ty', '桃园混凝土布料机厂家', '桃园混凝土布料机价格,桃园混凝土布料机,桃园混凝土布料机厂家', '桃园混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655349821', '1655349821');
INSERT INTO `ey_weapp_multicity` VALUES ('279', '275', '275', '台中市', '2', '1', '0', 'taizhong', '台中液压布料机厂家', '台中布料机价格,台中液压布料机,台中液压布料机厂家', '台中布料机专业生产厂家联系电话：17858811257', '100', '1655349896', '1655349896');
INSERT INTO `ey_weapp_multicity` VALUES ('280', '275', '275', '台南市', '2', '1', '0', 'tns', '台南混凝土布料机厂家', '台南混凝土布料机价格,台南混凝土布料机,台南混凝土布料机厂家', '台南混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655356543', '1655356543');
INSERT INTO `ey_weapp_multicity` VALUES ('281', '275', '275', '高雄市', '2', '1', '0', 'gxs', '高雄液压布料机厂家', '高雄布料机价格,高雄液压布料机,高雄液压布料机厂家', '高雄布料机专业生产厂家联系电话：17858811257', '100', '1655356621', '1655356621');
INSERT INTO `ey_weapp_multicity` VALUES ('282', '275', '275', '基隆市', '2', '1', '0', 'jls', '基隆液压布料机厂家', '基隆布料机价格,基隆液压布料机,基隆液压布料机厂家', '基隆布料机专业生产厂家联系电话：17858811257', '100', '1655356694', '1655356694');
INSERT INTO `ey_weapp_multicity` VALUES ('283', '275', '275', '新竹市', '2', '1', '0', 'xzs', '新竹液压布料机厂家', '新竹布料机价格,新竹液压布料机,新竹液压布料机厂家', '新竹布料机专业生产厂家联系电话：17858811257', '100', '1655356884', '1655356884');
INSERT INTO `ey_weapp_multicity` VALUES ('284', '275', '275', '嘉义市', '2', '1', '0', 'jiayi', '嘉义混凝土布料机厂家', '嘉义混凝土布料机价格,嘉义混凝土布料机,嘉义混凝土布料机厂家', '嘉义混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655356954', '1655356954');
INSERT INTO `ey_weapp_multicity` VALUES ('285', '0', '0', '陕西省', '1', '1', '0', 'shanxisheng', '陕西省混凝土布料机厂家', '陕西混凝土布料机价格,陕西混凝土布料机,陕西混凝土布料机厂家', '陕西混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655357159', '1655357159');
INSERT INTO `ey_weapp_multicity` VALUES ('286', '285', '285', '西安市', '2', '1', '0', 'xian', '西安混凝土布料机厂家', '西安混凝土布料机价格,西安混凝土布料机,西安混凝土布料机厂家', '西安混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655357370', '1655357370');
INSERT INTO `ey_weapp_multicity` VALUES ('287', '285', '285', '咸阳市', '2', '1', '0', 'xianyang', '咸阳液压布料机厂家', '咸阳布料机价格,咸阳液压布料机,咸阳液压布料机厂家', '咸阳布料机专业生产厂家联系电话：17858811257', '100', '1655357469', '1655357469');
INSERT INTO `ey_weapp_multicity` VALUES ('288', '285', '285', '宝鸡市', '2', '1', '0', 'baoji', '宝鸡混凝土布料机厂家', '宝鸡混凝土布料机价格,宝鸡混凝土布料机,宝鸡混凝土布料机厂家', '宝鸡混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655357605', '1655357605');
INSERT INTO `ey_weapp_multicity` VALUES ('289', '285', '285', '铜川市', '2', '1', '0', 'tongchuan', '铜川液压布料机厂家', '铜川布料机价格,铜川液压布料机,铜川液压布料机厂家', '铜川布料机专业生产厂家联系电话：17858811257', '100', '1655357712', '1655357712');
INSERT INTO `ey_weapp_multicity` VALUES ('290', '285', '285', '渭南市', '2', '1', '0', 'weinan', '渭南液压布料机厂家', '渭南布料机价格,渭南液压布料机,渭南液压布料机厂家', '渭南布料机专业生产厂家联系电话：17858811257', '100', '1655357824', '1655357824');
INSERT INTO `ey_weapp_multicity` VALUES ('291', '285', '285', '延安市', '2', '1', '0', 'yanan', '延安液压布料机厂家', '延安布料机价格,延安液压布料机,延安液压布料机厂家', '延安布料机专业生产厂家联系电话：17858811257', '100', '1655357909', '1655357909');
INSERT INTO `ey_weapp_multicity` VALUES ('292', '285', '285', '榆林市', '2', '1', '0', 'yl', '榆林液压布料机厂家', '榆林布料机价格,榆林液压布料机,榆林液压布料机厂家', '榆林布料机专业生产厂家联系电话：17858811257', '100', '1655358079', '1655358120');
INSERT INTO `ey_weapp_multicity` VALUES ('293', '285', '285', '汉中市', '2', '1', '0', 'hanzhong', '汉中液压布料机厂家', '汉中布料机价格,汉中液压布料机,汉中液压布料机厂家', '汉中布料机专业生产厂家联系电话：17858811257', '100', '1655358197', '1655358197');
INSERT INTO `ey_weapp_multicity` VALUES ('294', '285', '285', '安康市', '2', '1', '0', 'ankang', '安康混凝土布料机厂家', '安康混凝土布料机价格,安康混凝土布料机,安康混凝土布料机厂家', '安康混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655358260', '1655358260');
INSERT INTO `ey_weapp_multicity` VALUES ('295', '285', '285', '商洛市', '2', '1', '0', 'shangluo', '商洛混凝土布料机厂家', '商洛混凝土布料机价格,商洛混凝土布料机,商洛混凝土布料机厂家', '商洛混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655358363', '1655358363');
INSERT INTO `ey_weapp_multicity` VALUES ('296', '0', '0', '吉林省', '1', '1', '0', 'jilinsheng', '吉林混凝土布料机厂家', '吉林混凝土布料机价格,吉林混凝土布料机,吉林混凝土布料机厂家', '吉林混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655358470', '1655358470');
INSERT INTO `ey_weapp_multicity` VALUES ('297', '296', '296', '长春市', '2', '1', '0', 'ccs', '长春混凝土布料机厂家', '长春混凝土布料机价格,长春混凝土布料机,长春混凝土布料机厂家', '长春混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655358612', '1655358612');
INSERT INTO `ey_weapp_multicity` VALUES ('298', '296', '296', '吉林市', '2', '1', '0', 'jilin', '吉林液压布料机厂家', '吉林布料机价格,吉林液压布料机,吉林液压布料机厂家', '吉林布料机专业生产厂家联系电话：17858811257', '100', '1655358713', '1655358713');
INSERT INTO `ey_weapp_multicity` VALUES ('299', '296', '296', '四平市', '2', '1', '0', 'siping', '四平混凝土布料机厂家', '四平混凝土布料机价格,四平混凝土布料机,四平混凝土布料机厂家', '四平混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655358820', '1655358820');
INSERT INTO `ey_weapp_multicity` VALUES ('300', '296', '296', '辽源市', '2', '1', '0', 'liaoyuan', '辽源液压布料机厂家', '辽源布料机价格,辽源液压布料机,辽源液压布料机厂家', '辽源布料机专业生产厂家联系电话：17858811257', '100', '1655359567', '1655359567');
INSERT INTO `ey_weapp_multicity` VALUES ('301', '296', '296', '通化市', '2', '1', '0', 'tonghua', '通化混凝土布料机厂家', '通化混凝土布料机价格,通化混凝土布料机,通化混凝土布料机厂家', '通化混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655359640', '1655359640');
INSERT INTO `ey_weapp_multicity` VALUES ('302', '296', '296', '白山市', '2', '1', '0', 'baishan', '白山市液压布料机厂家', '白山布料机价格,白山液压布料机,白山液压布料机厂家', '白山布料机专业生产厂家联系电话：17858811257', '100', '1655359708', '1655359708');
INSERT INTO `ey_weapp_multicity` VALUES ('303', '296', '296', '松原市', '2', '1', '0', 'songyuan', '松原液压布料机厂家', '松原布料机价格,松原液压布料机,松原液压布料机厂家', '松原布料机专业生产厂家联系电话：17858811257', '100', '1655359811', '1655359811');
INSERT INTO `ey_weapp_multicity` VALUES ('304', '296', '296', '白城市', '2', '1', '0', 'baicheng', '白城液压布料机厂家', '白城布料机价格,白城液压布料机,白城液压布料机厂家', '白城布料机专业生产厂家联系电话：17858811257', '100', '1655359880', '1655359880');
INSERT INTO `ey_weapp_multicity` VALUES ('305', '0', '0', '黑龙江省', '1', '1', '0', 'hljs', '黑龙江混凝土布料机厂家', '黑龙江混凝土布料机价格,黑龙江混凝土布料机,黑龙江混凝土布料机厂家', '黑龙江混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655360653', '1655360653');
INSERT INTO `ey_weapp_multicity` VALUES ('306', '305', '305', '哈尔滨市', '2', '1', '0', 'hebs', '哈尔滨液压布料机厂家', '哈尔滨布料机价格,哈尔滨液压布料机,哈尔滨液压布料机厂家', '哈尔滨布料机专业生产厂家联系电话：17858811257', '100', '1655360862', '1655360862');
INSERT INTO `ey_weapp_multicity` VALUES ('307', '305', '305', '齐齐哈尔市', '2', '1', '0', 'qqhe', '齐齐哈尔混凝土布料机厂家', '齐齐哈尔混凝土布料机价格,齐齐哈尔混凝土布料机,齐齐哈尔混凝土布料机厂家', '齐齐哈尔混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655360944', '1655360944');
INSERT INTO `ey_weapp_multicity` VALUES ('308', '305', '305', '牡丹江市', '2', '1', '0', 'mdjs', '牡丹江液压布料机厂家', '牡丹江布料机价格,牡丹江液压布料机,牡丹江液压布料机厂家', '牡丹江布料机专业生产厂家联系电话：17858811257', '100', '1655361058', '1655361058');
INSERT INTO `ey_weapp_multicity` VALUES ('309', '305', '305', '佳木斯市', '2', '1', '0', 'jmss', '佳木斯液压布料机厂家', '佳木斯布料机价格,佳木斯液压布料机,佳木斯液压布料机厂家', '佳木斯布料机专业生产厂家联系电话：17858811257', '100', '1655361375', '1655361375');
INSERT INTO `ey_weapp_multicity` VALUES ('310', '305', '305', '大庆市', '2', '1', '0', 'dqs', '大庆液压布料机厂家', '大庆布料机价格,大庆液压布料机,大庆液压布料机厂家', '大庆布料机专业生产厂家联系电话：17858811257', '100', '1655362509', '1655365064');
INSERT INTO `ey_weapp_multicity` VALUES ('311', '305', '305', '鸡西市', '2', '1', '0', 'jixishi', '鸡西混凝土布料机厂家', '鸡西混凝土布料机价格,鸡西混凝土布料机,鸡西混凝土布料机厂家', '鸡西混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655362620', '1655362928');
INSERT INTO `ey_weapp_multicity` VALUES ('312', '305', '305', '双鸭山市', '2', '1', '0', 'syss', '双鸭山液压布料机厂家', '双鸭山布料机价格,双鸭山液压布料机,双鸭山液压布料机厂家', '双鸭山布料机专业生产厂家联系电话：17858811257', '100', '1655363051', '1655363051');
INSERT INTO `ey_weapp_multicity` VALUES ('313', '305', '305', '伊春市', '2', '1', '0', 'yichunshi', '伊春混凝土布料机厂家', '伊春混凝土布料机价格,伊春混凝土布料机,伊春混凝土布料机厂家', '伊春混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655363217', '1655363217');
INSERT INTO `ey_weapp_multicity` VALUES ('314', '305', '305', '七台河市', '2', '1', '0', 'qitaihe', '七台河液压布料机厂家', '七台河布料机价格,七台河液压布料机,七台河液压布料机厂家', '七台河布料机专业生产厂家联系电话：17858811257', '100', '1655363492', '1655363492');
INSERT INTO `ey_weapp_multicity` VALUES ('315', '305', '305', '鹤岗市', '2', '1', '0', 'hegangshi', '鹤岗液压布料机厂家', '鹤岗布料机价格,鹤岗液压布料机,鹤岗液压布料机厂家', '鹤岗布料机专业生产厂家联系电话：17858811257', '100', '1655363835', '1655363835');
INSERT INTO `ey_weapp_multicity` VALUES ('316', '305', '305', '黑河市', '2', '1', '0', 'heiheshi', '黑河混凝土布料机厂家', '黑河混凝土布料机价格,黑河混凝土布料机,黑河混凝土布料机厂家', '黑河混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655363941', '1655363941');
INSERT INTO `ey_weapp_multicity` VALUES ('317', '305', '305', '绥化市', '2', '1', '0', 'sss', '绥化液压布料机厂家', '绥化布料机价格,绥化液压布料机,绥化液压布料机厂家', '绥化布料机专业生产厂家联系电话：17858811257', '100', '1655364017', '1655364334');
INSERT INTO `ey_weapp_multicity` VALUES ('318', '305', '305', '大兴安岭', '2', '1', '0', 'dxal', '大兴安岭液压布料机厂家', '大兴安岭布料机价格,大兴安岭液压布料机,大兴安岭液压布料机厂家', '大兴安岭布料机专业生产厂家联系电话：17858811257', '100', '1655364688', '1655364688');
INSERT INTO `ey_weapp_multicity` VALUES ('319', '0', '0', '海南省', '1', '1', '0', 'hainansheng', '海南省混凝土布料机厂家', '海南混凝土布料机价格,海南混凝土布料机,海南混凝土布料机厂家', '海南混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655364793', '1655364793');
INSERT INTO `ey_weapp_multicity` VALUES ('320', '319', '319', '海口市', '2', '1', '0', 'hks', '海口混凝土布料机厂家', '海口混凝土布料机价格,海口混凝土布料机,海口混凝土布料机厂家', '海口混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655365503', '1655365503');
INSERT INTO `ey_weapp_multicity` VALUES ('321', '319', '319', '三亚市', '2', '1', '0', 'sanyashi', '三亚液压布料机厂家', '三亚布料机价格,三亚液压布料机,三亚液压布料机厂家', '三亚布料机专业生产厂家联系电话：17858811257', '100', '1655365693', '1655365788');
INSERT INTO `ey_weapp_multicity` VALUES ('322', '319', '319', '三沙市', '2', '1', '0', 'shansha', '三沙市液压布料机厂家', '三沙布料机价格,三沙液压布料机,三沙液压布料机厂家', '三沙布料机专业生产厂家联系电话：17858811257', '100', '1655365908', '1655365908');
INSERT INTO `ey_weapp_multicity` VALUES ('323', '319', '319', '儋州市', '2', '1', '0', 'danzhoushi', '儋州混凝土布料机厂家', '儋州混凝土布料机价格,儋州混凝土布料机,儋州混凝土布料机厂家', '儋州混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655366019', '1655366019');
INSERT INTO `ey_weapp_multicity` VALUES ('324', '0', '0', '贵州省', '1', '1', '0', 'guizhou', '贵州混凝土布料机厂家', '贵州混凝土布料机价格,贵州混凝土布料机,贵州混凝土布料机厂家', '贵州混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655367341', '1655367341');
INSERT INTO `ey_weapp_multicity` VALUES ('325', '324', '324', '贵阳市', '2', '1', '0', 'gy', '贵阳混凝土布料机厂家', '贵阳混凝土布料机价格,贵阳混凝土布料机,贵阳混凝土布料机厂家', '贵阳混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655367878', '1655367878');
INSERT INTO `ey_weapp_multicity` VALUES ('326', '324', '324', '遵义市', '2', '1', '0', 'zys', '遵义液压布料机厂家', '遵义布料机价格,遵义液压布料机,遵义液压布料机厂家', '遵义布料机专业生产厂家联系电话：17858811257', '100', '1655367999', '1655368056');
INSERT INTO `ey_weapp_multicity` VALUES ('327', '324', '324', '六盘水市', '2', '1', '0', 'lpss', '六盘水液压布料机厂家', '六盘水布料机价格,六盘水液压布料机,六盘水液压布料机厂家', '六盘水布料机专业生产厂家联系电话：17858811257', '100', '1655368313', '1655368313');
INSERT INTO `ey_weapp_multicity` VALUES ('328', '324', '324', '安顺市', '2', '1', '0', 'as', '安顺混凝土布料机厂家', '安顺混凝土布料机价格,安顺混凝土布料机,安顺混凝土布料机厂家', '安顺混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655368393', '1655368393');
INSERT INTO `ey_weapp_multicity` VALUES ('329', '324', '324', '毕节市', '2', '1', '0', 'bijie', '毕节液压布料机厂家', '毕节布料机价格,毕节液压布料机,毕节液压布料机厂家', '毕节布料机专业生产厂家联系电话：17858811257', '100', '1655368562', '1655368562');
INSERT INTO `ey_weapp_multicity` VALUES ('330', '324', '324', '铜仁市', '2', '1', '0', 'tr', '铜仁混凝土布料机厂家', '铜仁混凝土布料机价格,铜仁混凝土布料机,铜仁混凝土布料机厂家', '铜仁混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655368766', '1655368766');
INSERT INTO `ey_weapp_multicity` VALUES ('331', '324', '324', '凯里市', '2', '1', '0', 'kls', '凯里混凝土布料机厂家', '凯里混凝土布料机价格,凯里混凝土布料机,凯里混凝土布料机厂家', '凯里混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655369653', '1655369653');
INSERT INTO `ey_weapp_multicity` VALUES ('332', '324', '324', '都匀市', '2', '1', '0', 'dunjun', '都匀液压布料机厂家', '都匀布料机价格,都匀液压布料机,都匀液压布料机厂家', '都匀布料机专业生产厂家联系电话：17858811257', '100', '1655369851', '1655369862');
INSERT INTO `ey_weapp_multicity` VALUES ('333', '324', '324', '兴义市', '2', '1', '0', 'xinyi', '兴义混凝土布料机厂家', '兴义混凝土布料机价格,兴义混凝土布料机,兴义混凝土布料机厂家', '兴义混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655369935', '1655369935');
INSERT INTO `ey_weapp_multicity` VALUES ('334', '0', '0', '云南省', '1', '1', '0', 'yunan', '云南混凝土布料机厂家', '云南混凝土布料机价格,云南混凝土布料机,云南混凝土布料机厂家', '云南混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655425416', '1655425416');
INSERT INTO `ey_weapp_multicity` VALUES ('335', '334', '334', '昆明市', '2', '1', '0', 'kms', '昆明液压布料机厂家', '昆明布料机价格,昆明液压布料机,昆明液压布料机厂家', '昆明布料机专业生产厂家联系电话：17858811257', '100', '1655425647', '1655425647');
INSERT INTO `ey_weapp_multicity` VALUES ('336', '334', '334', '曲靖市', '2', '1', '0', 'qjs', '曲靖液压布料机厂家', '曲靖布料机价格,曲靖液压布料机,曲靖液压布料机厂家', '曲靖布料机专业生产厂家联系电话：17858811257', '100', '1655425935', '1655425935');
INSERT INTO `ey_weapp_multicity` VALUES ('337', '334', '334', '玉溪市', '2', '1', '0', 'ys', '玉溪混凝土布料机厂家', '玉溪混凝土布料机价格,玉溪混凝土布料机,玉溪混凝土布料机厂家', '玉溪混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655426018', '1655426018');
INSERT INTO `ey_weapp_multicity` VALUES ('338', '334', '334', '丽江市', '2', '1', '0', 'lijiang', '丽江市液压布料机厂家', '丽江布料机价格,丽江液压布料机,丽江液压布料机厂家', '丽江布料机专业生产厂家联系电话：17858811257', '100', '1655426499', '1655426499');
INSERT INTO `ey_weapp_multicity` VALUES ('339', '334', '334', '普洱市', '2', '1', '0', 'puershi', '普洱混凝土布料机厂家', '普洱混凝土布料机价格,普洱混凝土布料机,普洱混凝土布料机厂家', '普洱混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655426610', '1655426610');
INSERT INTO `ey_weapp_multicity` VALUES ('340', '334', '334', '保山市', '2', '1', '0', 'baoshan', '保山液压布料机厂家', '保山布料机价格,保山液压布料机,保山液压布料机厂家', '保山布料机专业生产厂家联系电话：17858811257', '100', '1655426723', '1655426723');
INSERT INTO `ey_weapp_multicity` VALUES ('341', '334', '334', '昭通市', '2', '1', '0', 'zts', '昭通混凝土布料机厂家', '昭通混凝土布料机价格,昭通混凝土布料机,昭通混凝土布料机厂家', '昭通混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655426879', '1655426879');
INSERT INTO `ey_weapp_multicity` VALUES ('342', '334', '334', '临沧市', '2', '1', '0', 'lincang', '临沧液压布料机厂家', '临沧布料机价格,临沧液压布料机,临沧液压布料机厂家', '临沧布料机专业生产厂家联系电话：17858811257', '100', '1655427017', '1655427017');
INSERT INTO `ey_weapp_multicity` VALUES ('343', '0', '0', '甘肃省', '1', '1', '0', 'ganshusheng', '甘肃省液压布料机厂家', '甘肃布料机价格,甘肃液压布料机,甘肃液压布料机厂家', '甘肃布料机专业生产厂家联系电话：17858811257', '100', '1655427225', '1655427225');
INSERT INTO `ey_weapp_multicity` VALUES ('344', '343', '343', '兰州市', '2', '1', '0', 'lanzhou', '兰州混凝土布料机厂家', '兰州混凝土布料机价格,兰州混凝土布料机,兰州混凝土布料机厂家', '兰州混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655427682', '1655427682');
INSERT INTO `ey_weapp_multicity` VALUES ('345', '343', '343', '嘉峪关市', '2', '1', '0', 'jiayuguan', '嘉峪关市液压布料机厂家', '嘉峪关市布料机价格,嘉峪关市液压布料机,嘉峪关市液压布料机厂家', '嘉峪关市布料机专业生产厂家联系电话：17858811257', '100', '1655427831', '1655427831');
INSERT INTO `ey_weapp_multicity` VALUES ('346', '343', '343', '金昌市', '2', '1', '0', 'jcs', '金昌液压布料机厂家', '金昌布料机价格,金昌液压布料机,金昌液压布料机厂家', '金昌布料机专业生产厂家联系电话：17858811257', '100', '1655428010', '1655428010');
INSERT INTO `ey_weapp_multicity` VALUES ('347', '343', '343', '白银市', '2', '1', '0', 'baiyin', '白银液压布料机厂家', '白银布料机价格,白银液压布料机,白银液压布料机厂家', '白银布料机专业生产厂家联系电话：17858811257', '100', '1655428094', '1655428094');
INSERT INTO `ey_weapp_multicity` VALUES ('348', '343', '343', '天水市', '2', '1', '0', 'tianshui', '天水混凝土布料机厂家', '天水混凝土布料机价格,天水混凝土布料机,天水混凝土布料机厂家', '天水混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655428339', '1655428339');
INSERT INTO `ey_weapp_multicity` VALUES ('349', '343', '343', '武威市', '2', '1', '0', 'wuwei', '武威混凝土布料机厂家', '武威混凝土布料机价格,武威混凝土布料机,武威混凝土布料机厂家', '武威混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655428429', '1655428429');
INSERT INTO `ey_weapp_multicity` VALUES ('350', '343', '343', '张掖市', '2', '1', '0', 'zhangye', '张掖液压布料机厂家', '张掖布料机价格,张掖液压布料机,张掖液压布料机厂家', '张掖布料机专业生产厂家联系电话：17858811257', '100', '1655428511', '1655428511');
INSERT INTO `ey_weapp_multicity` VALUES ('351', '343', '343', '平凉市', '2', '1', '0', 'pls', '平凉液压布料机厂家', '平凉布料机价格,平凉液压布料机,平凉液压布料机厂家', '平凉布料机专业生产厂家联系电话：17858811257', '100', '1655428610', '1655428610');
INSERT INTO `ey_weapp_multicity` VALUES ('352', '343', '343', '酒泉市', '2', '1', '0', 'jiuquan', '酒泉液压布料机厂家', '酒泉布料机价格,酒泉液压布料机,酒泉液压布料机厂家', '酒泉布料机专业生产厂家联系电话：17858811257', '100', '1655429398', '1655429398');
INSERT INTO `ey_weapp_multicity` VALUES ('353', '343', '343', '庆阳市', '2', '1', '0', 'qingyang', '庆阳混凝土布料机厂家', '庆阳混凝土布料机价格,庆阳混凝土布料机,庆阳混凝土布料机厂家', '庆阳混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655429487', '1655429487');
INSERT INTO `ey_weapp_multicity` VALUES ('354', '343', '343', '定西市', '2', '1', '0', 'dingxi', '定西混凝土布料机厂家', '定西混凝土布料机价格,定西混凝土布料机,定西混凝土布料机厂家', '定西混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655429599', '1655429599');
INSERT INTO `ey_weapp_multicity` VALUES ('355', '343', '343', '陇南市', '2', '1', '0', 'longnan', '陇南市液压布料机厂家', '陇南市布料机价格,陇南市液压布料机,陇南市液压布料机厂家', '陇南市布料机专业生产厂家联系电话：17858811257', '100', '1655429748', '1655429748');
INSERT INTO `ey_weapp_multicity` VALUES ('356', '0', '0', '青海省', '1', '1', '0', 'qinghaisheng', '青海省混凝土布料机厂家', '青海省混凝土布料机价格,青海省混凝土布料机,青海省混凝土布料机厂家', '青海省混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655429823', '1655429823');
INSERT INTO `ey_weapp_multicity` VALUES ('357', '356', '356', '西宁市', '2', '1', '0', 'xining', '西宁液压布料机厂家', '西宁布料机价格,西宁液压布料机,西宁液压布料机厂家', '西宁布料机专业生产厂家联系电话：17858811257', '100', '1655430430', '1655430430');
INSERT INTO `ey_weapp_multicity` VALUES ('358', '356', '356', '海东市', '2', '1', '0', 'haidong', '海东市混凝土布料机厂家', '海东市混凝土布料机价格,海东市混凝土布料机,海东市混凝土布料机厂家', '海东市混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655430581', '1655430581');
INSERT INTO `ey_weapp_multicity` VALUES ('359', '0', '0', '内蒙古自治区', '1', '1', '0', 'neimenggu', '内蒙古混凝土布料机厂家', '内蒙古混凝土布料机价格,内蒙古混凝土布料机,内蒙古混凝土布料机厂家', '内蒙古混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655430794', '1655430794');
INSERT INTO `ey_weapp_multicity` VALUES ('360', '359', '359', '呼和浩特市', '2', '1', '0', 'huhehaote', '呼和浩特混凝土布料机厂家', '呼和浩特混凝土布料机价格,呼和浩特混凝土布料机,呼和浩特混凝土布料机厂家', '呼和浩特混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655431592', '1655431592');
INSERT INTO `ey_weapp_multicity` VALUES ('361', '359', '359', '包头市', '2', '1', '0', 'bts', '包头液压布料机厂家', '包头布料机价格,包头液压布料机,包头液压布料机厂家', '包头布料机专业生产厂家联系电话：17858811257', '100', '1655431780', '1655431780');
INSERT INTO `ey_weapp_multicity` VALUES ('362', '359', '359', '乌海市', '2', '1', '0', 'wuhaishi', '乌海液压布料机厂家', '乌海布料机价格,乌海液压布料机,乌海液压布料机厂家', '乌海布料机专业生产厂家联系电话：17858811257', '100', '1655431945', '1655431945');
INSERT INTO `ey_weapp_multicity` VALUES ('363', '359', '359', '赤峰市', '2', '1', '0', 'chifengshi', '赤峰液压布料机厂家', '赤峰布料机价格,赤峰液压布料机,赤峰液压布料机厂家', '赤峰布料机专业生产厂家联系电话：17858811257', '100', '1655432072', '1655432072');
INSERT INTO `ey_weapp_multicity` VALUES ('364', '359', '359', '通辽市', '2', '1', '0', 'tongliao', '通辽市混凝土布料机厂家', '通辽市混凝土布料机价格,通辽市混凝土布料机,通辽市混凝土布料机厂家', '通辽市混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655432207', '1655432207');
INSERT INTO `ey_weapp_multicity` VALUES ('365', '359', '359', '鄂尔多斯市', '2', '1', '0', 'eeds', '鄂尔多斯混凝土布料机厂家', '鄂尔多斯混凝土布料机价格,鄂尔多斯混凝土布料机,鄂尔多斯混凝土布料机厂家', '鄂尔多斯混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655432333', '1655432333');
INSERT INTO `ey_weapp_multicity` VALUES ('366', '359', '359', '呼伦贝尔市', '2', '1', '0', 'hnbe', '呼伦贝尔液压布料机厂家', '呼伦贝尔布料机价格,呼伦贝尔液压布料机,呼伦贝尔液压布料机厂家', '呼伦贝尔布料机专业生产厂家联系电话：17858811257', '100', '1655432441', '1655432441');
INSERT INTO `ey_weapp_multicity` VALUES ('367', '359', '359', '巴彦淖尔市', '2', '1', '0', 'bayanzhuoer', '巴彦淖尔混凝土布料机厂家', '巴彦淖尔混凝土布料机价格,巴彦淖尔混凝土布料机,巴彦淖尔混凝土布料机厂家', '巴彦淖尔混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655432575', '1655432575');
INSERT INTO `ey_weapp_multicity` VALUES ('368', '359', '359', '乌兰察布市', '2', '1', '0', 'wlcb', '乌兰察布液压布料机厂家', '乌兰察布布料机价格,乌兰察布液压布料机,乌兰察布液压布料机厂家', '乌兰察布布料机专业生产厂家联系电话：17858811257', '100', '1655433709', '1655433709');
INSERT INTO `ey_weapp_multicity` VALUES ('369', '0', '0', '广西壮族自治区', '1', '1', '0', 'guangxizhuangzu', '广西壮族自治区混凝土布料机厂家', '广西壮族自治区混凝土布料机价格,广西壮族自治区混凝土布料机,广西壮族自治区混凝土布料机厂家', '广西壮族自治区混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655433838', '1655433838');
INSERT INTO `ey_weapp_multicity` VALUES ('370', '369', '369', '南宁市', '2', '1', '0', 'nanling', '南宁市混凝土布料机厂家', '南宁市混凝土布料机价格,南宁市混凝土布料机,南宁市混凝土布料机厂家', '南宁市混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655434130', '1655434130');
INSERT INTO `ey_weapp_multicity` VALUES ('371', '369', '369', '柳州市', '2', '1', '0', 'liuzhou', '柳州液压布料机厂家', '柳州布料机价格,柳州液压布料机,柳州液压布料机厂家', '柳州布料机专业生产厂家联系电话：17858811257', '100', '1655434221', '1655434221');
INSERT INTO `ey_weapp_multicity` VALUES ('372', '369', '369', '桂林市', '2', '1', '0', 'guilin', '桂林液压布料机厂家', '桂林布料机价格,桂林液压布料机,桂林液压布料机厂家', '桂林布料机专业生产厂家联系电话：17858811257', '100', '1655434333', '1655434355');
INSERT INTO `ey_weapp_multicity` VALUES ('373', '369', '369', '梧州市', '2', '1', '0', 'wuzhou', '梧州液压布料机厂家', '梧州布料机价格,梧州液压布料机,梧州液压布料机厂家', '梧州布料机专业生产厂家联系电话：17858811257', '100', '1655434664', '1655434664');
INSERT INTO `ey_weapp_multicity` VALUES ('374', '369', '369', '北海市', '2', '1', '0', 'beihai', '北海混凝土布料机厂家', '北海混凝土布料机价格,北海混凝土布料机,北海混凝土布料机厂家', '北海混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655434823', '1655434823');
INSERT INTO `ey_weapp_multicity` VALUES ('375', '369', '369', '防城港市', '2', '1', '0', 'fcgs', '防城港混凝土布料机厂家', '防城港混凝土布料机价格,防城港混凝土布料机,防城港混凝土布料机厂家', '防城港混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655434944', '1655434944');
INSERT INTO `ey_weapp_multicity` VALUES ('376', '369', '369', '钦州市', '2', '1', '0', 'qinzhou', '钦州市液压布料机厂家', '钦州市布料机价格,钦州市液压布料机,钦州市液压布料机厂家', '钦州市布料机专业生产厂家联系电话：17858811257', '100', '1655435039', '1655435039');
INSERT INTO `ey_weapp_multicity` VALUES ('377', '369', '369', '贵港市', '2', '1', '0', 'guigang', '贵港混凝土布料机厂家', '贵港混凝土布料机价格,贵港混凝土布料机,贵港混凝土布料机厂家', '贵港混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655435119', '1655435613');
INSERT INTO `ey_weapp_multicity` VALUES ('378', '369', '369', '玉林市', '2', '1', '0', 'yulin', '玉林混凝土布料机厂家', '玉林混凝土布料机价格,玉林混凝土布料机,玉林混凝土布料机厂家', '玉林混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655435732', '1655435732');
INSERT INTO `ey_weapp_multicity` VALUES ('379', '369', '369', '百色市', '2', '1', '0', 'bss', '百色液压布料机厂家', '百色布料机价格,百色液压布料机,百色液压布料机厂家', '百色布料机专业生产厂家联系电话：17858811257', '100', '1655435799', '1655435799');
INSERT INTO `ey_weapp_multicity` VALUES ('380', '369', '369', '贺州市', '2', '1', '0', 'hezhoushi', '贺州混凝土布料机厂家', '贺州混凝土布料机价格,贺州混凝土布料机,贺州混凝土布料机厂家', '贺州混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655435900', '1655435900');
INSERT INTO `ey_weapp_multicity` VALUES ('381', '369', '369', '河池市', '2', '1', '0', 'hechi', '河池液压布料机厂家', '河池布料机价格,河池液压布料机,河池液压布料机厂家', '河池布料机专业生产厂家联系电话：17858811257', '100', '1655436199', '1655436199');
INSERT INTO `ey_weapp_multicity` VALUES ('382', '369', '369', '来宾市', '2', '1', '0', 'laibing', '来宾液压布料机厂家', '来宾布料机价格,来宾液压布料机,来宾液压布料机厂家', '来宾布料机专业生产厂家联系电话：17858811257', '100', '1655442556', '1655442556');
INSERT INTO `ey_weapp_multicity` VALUES ('383', '369', '369', '崇左市', '2', '1', '0', 'chongzuo', '崇左混凝土布料机厂家', '崇左混凝土布料机价格,崇左混凝土布料机,崇左混凝土布料机厂家', '崇左混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655442635', '1655442635');
INSERT INTO `ey_weapp_multicity` VALUES ('384', '0', '0', '西藏自治区', '1', '1', '0', 'xizang', '西藏液压布料机厂家', '西藏布料机价格,西藏液压布料机,西藏液压布料机厂家', '西藏布料机专业生产厂家联系电话：17858811257', '100', '1655442717', '1655442717');
INSERT INTO `ey_weapp_multicity` VALUES ('385', '384', '384', '拉萨市', '2', '1', '0', 'lasa', '拉萨液压布料机厂家', '拉萨布料机价格,拉萨液压布料机,拉萨液压布料机厂家', '拉萨布料机专业生产厂家联系电话：17858811257', '100', '1655443531', '1655443531');
INSERT INTO `ey_weapp_multicity` VALUES ('386', '384', '384', '日喀则市', '2', '1', '0', 'rikaze', '日喀则混凝土布料机厂家', '日喀则混凝土布料机价格,日喀则混凝土布料机,日喀则混凝土布料机厂家', '日喀则混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655443634', '1655443634');
INSERT INTO `ey_weapp_multicity` VALUES ('387', '384', '384', '山南市', '2', '1', '0', 'shannan', '山南液压布料机厂家', '山南布料机价格,山南液压布料机,山南液压布料机厂家', '山南布料机专业生产厂家联系电话：17858811257', '100', '1655443742', '1655443742');
INSERT INTO `ey_weapp_multicity` VALUES ('388', '384', '384', '林芝市', '2', '1', '0', 'linzhi', '林芝液压布料机厂家', '林芝布料机价格,林芝液压布料机,林芝液压布料机厂家', '林芝布料机专业生产厂家联系电话：17858811257', '100', '1655444220', '1655444220');
INSERT INTO `ey_weapp_multicity` VALUES ('389', '384', '384', '昌都市', '2', '1', '0', 'changdu', '昌都混凝土布料机厂家', '昌都混凝土布料机价格,昌都混凝土布料机,昌都混凝土布料机厂家', '昌都混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655444376', '1655444376');
INSERT INTO `ey_weapp_multicity` VALUES ('390', '384', '384', '那曲市', '2', '1', '0', 'naqu', '那曲液压布料机厂家', '那曲布料机价格,那曲液压布料机,那曲液压布料机厂家', '那曲布料机专业生产厂家联系电话：17858811257', '100', '1655444458', '1655444458');
INSERT INTO `ey_weapp_multicity` VALUES ('391', '0', '0', '宁夏回族自治区', '1', '1', '0', 'ningxiahuizu', '宁夏混凝土布料机厂家', '宁夏混凝土布料机价格,宁夏混凝土布料机,宁夏混凝土布料机厂家', '宁夏市混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655444592', '1655444592');
INSERT INTO `ey_weapp_multicity` VALUES ('393', '391', '391', '银川市', '2', '1', '0', 'yinchuan', '银川液压布料机厂家', '银川布料机价格,银川液压布料机,银川液压布料机厂家', '银川布料机专业生产厂家联系电话：17858811257', '100', '1655444991', '1655444991');
INSERT INTO `ey_weapp_multicity` VALUES ('394', '391', '391', '石嘴山市', '2', '1', '0', 'shizuishan', '石嘴山混凝土布料机厂家', '石嘴山混凝土布料机价格,石嘴山混凝土布料机,石嘴山混凝土布料机厂家', '石嘴山混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655445081', '1655445081');
INSERT INTO `ey_weapp_multicity` VALUES ('395', '391', '391', '吴忠市', '2', '1', '0', 'wuzhong', '吴忠液压布料机厂家', '吴忠布料机价格,吴忠液压布料机,吴忠液压布料机厂家', '吴忠布料机专业生产厂家联系电话：17858811257', '100', '1655445206', '1655445206');
INSERT INTO `ey_weapp_multicity` VALUES ('396', '391', '391', '固原市', '2', '1', '0', 'guyuan', '固原液压布料机厂家', '固原布料机价格,固原液压布料机,固原液压布料机厂家', '固原布料机专业生产厂家联系电话：17858811257', '100', '1655445291', '1655445291');
INSERT INTO `ey_weapp_multicity` VALUES ('397', '391', '391', '中卫市', '2', '1', '0', 'zhongwei', '中卫混凝土布料机厂家', '中卫混凝土布料机价格,中卫混凝土布料机,中卫混凝土布料机厂家', '中卫混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655445372', '1655445372');
INSERT INTO `ey_weapp_multicity` VALUES ('398', '0', '0', '新疆维吾尔自治区', '1', '1', '0', 'xinjiang', '新疆混凝土布料机厂家', '新疆混凝土布料机价格,新疆混凝土布料机,新疆混凝土布料机厂家', '新疆混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655445482', '1655445482');
INSERT INTO `ey_weapp_multicity` VALUES ('399', '398', '398', '乌鲁木齐', '2', '1', '0', 'wulumuqi', '乌鲁木齐液压布料机厂家', '乌鲁木齐布料机价格,乌鲁木齐液压布料机,乌鲁木齐液压布料机厂家', '乌鲁木齐布料机专业生产厂家联系电话：17858811257', '100', '1655445694', '1655445694');
INSERT INTO `ey_weapp_multicity` VALUES ('400', '398', '398', '克拉玛依', '2', '1', '0', 'kelamayi', '克拉玛依混凝土布料机厂家', '克拉玛依混凝土布料机价格,克拉玛依混凝土布料机,克拉玛依混凝土布料机厂家', '克拉玛依混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655446070', '1655446070');
INSERT INTO `ey_weapp_multicity` VALUES ('401', '398', '398', '吐鲁番', '2', '1', '0', 'tulufan', '吐鲁番液压布料机厂家', '吐鲁番布料机价格,吐鲁番液压布料机,吐鲁番液压布料机厂家', '吐鲁番布料机专业生产厂家联系电话：17858811257', '100', '1655446375', '1655446375');
INSERT INTO `ey_weapp_multicity` VALUES ('402', '398', '398', '哈密市', '2', '1', '0', 'hami', '哈密混凝土布料机厂家', '哈密混凝土布料机价格,哈密混凝土布料机,哈密混凝土布料机厂家', '哈密混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655446477', '1655446477');
INSERT INTO `ey_weapp_multicity` VALUES ('403', '0', '0', '香港', '1', '1', '0', 'hk', '香港混凝土布料机厂家', '香港混凝土布料机价格,香港混凝土布料机,香港混凝土布料机厂家', '香港混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655448070', '1655448070');

-- -----------------------------
-- Table structure for `ey_weapp_picture_cleaning`
-- -----------------------------
DROP TABLE IF EXISTS `ey_weapp_picture_cleaning`;
CREATE TABLE `ey_weapp_picture_cleaning` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `table_of_ontents` varchar(50) DEFAULT '' COMMENT '移动的目录文件夹名称',
  `url` varchar(255) DEFAULT '' COMMENT '文件地址',
  `status` tinyint(1) DEFAULT '0' COMMENT '状态：0=正常，1=清理',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=120 DEFAULT CHARSET=utf8;

-- -----------------------------
-- Records of `ey_weapp_picture_cleaning`
-- -----------------------------
INSERT INTO `ey_weapp_picture_cleaning` VALUES ('46', '', '/uploads/allimg/20190124/4cd8beefd671dfc379c78a7ccc4413f7.jpg', '0', '1665811536', '1665811536');
INSERT INTO `ey_weapp_picture_cleaning` VALUES ('48', '', '/uploads/allimg/20190124/6c48048d7f45e455edaa67096da1216a11111.jpg', '0', '1665811536', '1665811536');
INSERT INTO `ey_weapp_picture_cleaning` VALUES ('49', '', '/uploads/allimg/20190124/6c48048d7f45e455edaa67096da1216a备份.jpg', '0', '1665811536', '1665811536');
INSERT INTO `ey_weapp_picture_cleaning` VALUES ('51', '', '/uploads/allimg/20190124/82bbb9495c1a4c0312b066cfb9716af5111.jpg', '0', '1665811536', '1665811536');
INSERT INTO `ey_weapp_picture_cleaning` VALUES ('52', '', '/uploads/allimg/20190124/82bbb9495c1a4c0312b066cfb9716af5备份.jpg', '0', '1665811536', '1665811536');
INSERT INTO `ey_weapp_picture_cleaning` VALUES ('53', '', '/uploads/allimg/20190124/a8a01f964ffa4cbffc395113c14fa98a.jpg', '0', '1665811536', '1665811536');
INSERT INTO `ey_weapp_picture_cleaning` VALUES ('54', '', '/uploads/allimg/20190124/b7dc628405bffc2ebf81b4b83630daf311.jpg', '0', '1665811536', '1665811536');
INSERT INTO `ey_weapp_picture_cleaning` VALUES ('55', '', '/uploads/allimg/20190124/b7dc628405bffc2ebf81b4b83630daf3备份.jpg', '0', '1665811536', '1665811536');
INSERT INTO `ey_weapp_picture_cleaning` VALUES ('57', '', '/uploads/allimg/20190124/ds.png', '0', '1665811536', '1665811536');
INSERT INTO `ey_weapp_picture_cleaning` VALUES ('60', '', '/uploads/allimg/20190124/f92783ede49faf07e4fdbe4e712f4c6e.jpg', '0', '1665811536', '1665811536');
INSERT INTO `ey_weapp_picture_cleaning` VALUES ('61', '', '/uploads/allimg/20190124/f92783ede49faf07e4fdbe4e712f4c6e111.jpg', '0', '1665811536', '1665811536');
INSERT INTO `ey_weapp_picture_cleaning` VALUES ('62', '', '/uploads/allimg/20190124/f92783ede49faf07e4fdbe4e712f4c6e备份.jpg', '0', '1665811536', '1665811536');
INSERT INTO `ey_weapp_picture_cleaning` VALUES ('66', '', '/uploads/allimg/20190125/a98b83618cd8de58eed632e92291fb8e.jpg', '0', '1665811536', '1665811536');
INSERT INTO `ey_weapp_picture_cleaning` VALUES ('71', '', '/uploads/allimg/20220515/wx-wx168903912112b207.png', '0', '1665811536', '1665811536');
INSERT INTO `ey_weapp_picture_cleaning` VALUES ('72', '', '/uploads/allimg/20220515/wx-wx433a8faad4a1afc3.png', '0', '1665811536', '1665811536');
INSERT INTO `ey_weapp_picture_cleaning` VALUES ('75', '', '/uploads/allimg/20221009/1-221009201259525.jpg', '0', '1665811536', '1665811536');
INSERT INTO `ey_weapp_picture_cleaning` VALUES ('76', '', '/uploads/allimg/20221009/1-22100920230L45.jpg', '0', '1665811536', '1665811536');
INSERT INTO `ey_weapp_picture_cleaning` VALUES ('77', '', '/uploads/allimg/20221009/1-221009202K4c9.jpg', '0', '1665811536', '1665811536');
INSERT INTO `ey_weapp_picture_cleaning` VALUES ('78', '', '/uploads/allimg/20221009/1-221009202ZO16.jpg', '0', '1665811536', '1665811536');
INSERT INTO `ey_weapp_picture_cleaning` VALUES ('79', '', '/uploads/allimg/20221009/1-2210092032092a.jpg', '0', '1665811536', '1665811536');
INSERT INTO `ey_weapp_picture_cleaning` VALUES ('80', '', '/uploads/allimg/20221009/1-22100920593E58.jpg', '0', '1665811536', '1665811536');
INSERT INTO `ey_weapp_picture_cleaning` VALUES ('81', '', '/uploads/allimg/20221009/1-22100921220H13.png', '0', '1665811536', '1665811536');
INSERT INTO `ey_weapp_picture_cleaning` VALUES ('82', '', '/uploads/allimg/20221009/1-221009213414150.jpg', '0', '1665811536', '1665811536');
INSERT INTO `ey_weapp_picture_cleaning` VALUES ('83', '', '/uploads/allimg/20221009/1-221009213414150备份.jpg', '0', '1665811536', '1665811536');
INSERT INTO `ey_weapp_picture_cleaning` VALUES ('84', '', '/uploads/allimg/20221009/1-2210092220413F.jpg', '0', '1665811536', '1665811536');
INSERT INTO `ey_weapp_picture_cleaning` VALUES ('85', '', '/uploads/allimg/20221009/1-2210092220491V.jpg', '0', '1665811536', '1665811536');
INSERT INTO `ey_weapp_picture_cleaning` VALUES ('86', '', '/uploads/allimg/20221009/1-221009222054P1.jpg', '0', '1665811536', '1665811536');
INSERT INTO `ey_weapp_picture_cleaning` VALUES ('87', '', '/uploads/allimg/20221010/1-221010123J5406.jpg', '0', '1665811536', '1665811536');
INSERT INTO `ey_weapp_picture_cleaning` VALUES ('88', '', '/uploads/allimg/20221012/1-221012164224391.jpg', '0', '1665811536', '1665811536');
INSERT INTO `ey_weapp_picture_cleaning` VALUES ('89', '', '/uploads/allimg/20221012/1-221012202315562.png', '0', '1665811536', '1665811536');
INSERT INTO `ey_weapp_picture_cleaning` VALUES ('90', '', '/uploads/allimg/20221012/1-221012202K1495.jpg', '0', '1665811536', '1665811536');
INSERT INTO `ey_weapp_picture_cleaning` VALUES ('91', '', '/uploads/allimg/20221012/1-221012203312951.jpg', '0', '1665811536', '1665811536');
INSERT INTO `ey_weapp_picture_cleaning` VALUES ('92', '', '/uploads/allimg/20221012/1-22101222495B12.jpg', '0', '1665811536', '1665811536');
INSERT INTO `ey_weapp_picture_cleaning` VALUES ('93', '', '/uploads/allimg/20221012/1-221012231204426.jpg', '0', '1665811536', '1665811536');
INSERT INTO `ey_weapp_picture_cleaning` VALUES ('94', '', '/uploads/allimg/20221013/1-2210130Z54W96.png', '0', '1665811536', '1665811536');
INSERT INTO `ey_weapp_picture_cleaning` VALUES ('95', '', '/uploads/allimg/20221014/4-22101411311HF.jpg', '0', '1665811536', '1665811536');
INSERT INTO `ey_weapp_picture_cleaning` VALUES ('96', '', '/uploads/allimg/20221014/4-22101411324bF.jpg', '0', '1665811536', '1665811536');
INSERT INTO `ey_weapp_picture_cleaning` VALUES ('97', '', '/uploads/allimg/20221014/4-2210141133095R.jpg', '0', '1665811536', '1665811536');
INSERT INTO `ey_weapp_picture_cleaning` VALUES ('98', '', '/uploads/allimg/20221014/4-221014113319331.jpg', '0', '1665811536', '1665811536');
INSERT INTO `ey_weapp_picture_cleaning` VALUES ('99', '', '/uploads/allimg/20221014/4-22101411332c32.jpg', '0', '1665811536', '1665811536');
INSERT INTO `ey_weapp_picture_cleaning` VALUES ('100', '', '/uploads/allimg/20221014/4-221014113401364.jpg', '0', '1665811536', '1665811536');
INSERT INTO `ey_weapp_picture_cleaning` VALUES ('101', '', '/uploads/allimg/20221014/4-22101411340A51.jpg', '0', '1665811536', '1665811536');
INSERT INTO `ey_weapp_picture_cleaning` VALUES ('102', '', '/uploads/allimg/20221014/4-221014113430217.jpg', '0', '1665811536', '1665811536');
INSERT INTO `ey_weapp_picture_cleaning` VALUES ('103', '', '/uploads/allimg/20221014/4-221014123109A9.jpg', '0', '1665811536', '1665811536');
INSERT INTO `ey_weapp_picture_cleaning` VALUES ('104', '', '/uploads/allimg/20221014/4-221014123259D5.jpg', '0', '1665811536', '1665811536');
INSERT INTO `ey_weapp_picture_cleaning` VALUES ('105', '', '/uploads/allimg/20221014/4-22101412333I40.jpg', '0', '1665811536', '1665811536');
INSERT INTO `ey_weapp_picture_cleaning` VALUES ('106', '', '/uploads/allimg/20221014/4-2210141310261c.jpg', '0', '1665811536', '1665811536');
INSERT INTO `ey_weapp_picture_cleaning` VALUES ('107', '', '/uploads/allimg/20221014/4-221014131422210.jpg', '0', '1665811536', '1665811536');
INSERT INTO `ey_weapp_picture_cleaning` VALUES ('108', '', '/uploads/allimg/20221014/4-221014153551233.jpg', '0', '1665811536', '1665811536');
INSERT INTO `ey_weapp_picture_cleaning` VALUES ('109', '', '/uploads/minicode/20221009/1-2210091K001H4.jpg', '0', '1665811536', '1665811536');
INSERT INTO `ey_weapp_picture_cleaning` VALUES ('110', '', '/uploads/minicode/20221011/1-2210111P449293.jpg', '0', '1665811536', '1665811536');
INSERT INTO `ey_weapp_picture_cleaning` VALUES ('111', '', '/uploads/remote/2022/10/14/6348fa21c8892.jpg', '0', '1665811536', '1665811536');
INSERT INTO `ey_weapp_picture_cleaning` VALUES ('112', '', '/uploads/remote/2022/10/14/63491543cf72e.jpg', '0', '1665811536', '1665811536');
INSERT INTO `ey_weapp_picture_cleaning` VALUES ('113', '', '/uploads/remote/2022/10/14/634916356dd73.jpg', '0', '1665811536', '1665811536');
INSERT INTO `ey_weapp_picture_cleaning` VALUES ('114', '', '/uploads/tmp/poster_6_43/product_2421fcb1263b9530df88f7f002e78ea5.png', '0', '1665811536', '1665811536');
INSERT INTO `ey_weapp_picture_cleaning` VALUES ('115', '', '/uploads/tmp/poster_6_43/qrcode_2421fcb1263b9530df88f7f002e78ea5.png', '0', '1665811536', '1665811536');
INSERT INTO `ey_weapp_picture_cleaning` VALUES ('116', '', '/uploads/tmp/poster_6_50/product_ff4d5fbbafdf976cfdc032e3bde78de5.png', '0', '1665811536', '1665811536');
INSERT INTO `ey_weapp_picture_cleaning` VALUES ('117', '', '/uploads/tmp/poster_6_50/qrcode_ff4d5fbbafdf976cfdc032e3bde78de5.png', '0', '1665811536', '1665811536');
INSERT INTO `ey_weapp_picture_cleaning` VALUES ('118', '', '/uploads/tmp/poster_7_42/product_18997733ec258a9fcaf239cc55d53363.png', '0', '1665811536', '1665811536');
INSERT INTO `ey_weapp_picture_cleaning` VALUES ('119', '', '/uploads/tmp/poster_7_42/qrcode_18997733ec258a9fcaf239cc55d53363.png', '0', '1665811536', '1665811536');

-- -----------------------------
-- Table structure for `ey_weapp_pushall`
-- -----------------------------
DROP TABLE IF EXISTS `ey_weapp_pushall`;
CREATE TABLE `ey_weapp_pushall` (
  `aid` int(100) NOT NULL COMMENT '文章ID',
  `baidupushzt` int(1) NOT NULL DEFAULT '0' COMMENT '百度推送状态',
  `shenmapushzt` int(1) NOT NULL DEFAULT '0' COMMENT '神马推送状态',
  `sogoupushzt` int(1) NOT NULL DEFAULT '0' COMMENT '搜狗推送状态',
  `toutiaopushzt` int(1) NOT NULL DEFAULT '0' COMMENT '头条推送状态',
  PRIMARY KEY (`aid`),
  UNIQUE KEY `aid` (`aid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


-- -----------------------------
-- Table structure for `ey_weapp_pushalltag`
-- -----------------------------
DROP TABLE IF EXISTS `ey_weapp_pushalltag`;
CREATE TABLE `ey_weapp_pushalltag` (
  `aid` int(100) NOT NULL COMMENT '文章ID',
  `baidupushzt` int(1) NOT NULL DEFAULT '0' COMMENT '百度推送状态',
  `shenmapushzt` int(1) NOT NULL DEFAULT '0' COMMENT '神马推送状态',
  `sogoupushzt` int(1) NOT NULL DEFAULT '0' COMMENT '搜狗推送状态',
  `toutiaopushzt` int(1) NOT NULL DEFAULT '0' COMMENT '头条推送状态',
  PRIMARY KEY (`aid`),
  UNIQUE KEY `aid` (`aid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


-- -----------------------------
-- Table structure for `ey_weapp_qqlogin`
-- -----------------------------
DROP TABLE IF EXISTS `ey_weapp_qqlogin`;
CREATE TABLE `ey_weapp_qqlogin` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `users_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '用户ID',
  `openid` varchar(100) NOT NULL DEFAULT '' COMMENT 'openid',
  `nickname` varchar(255) NOT NULL DEFAULT '' COMMENT 'QQ昵称',
  `add_time` int(11) NOT NULL DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) NOT NULL DEFAULT '0' COMMENT '更新时间',
  `sta` tinyint(1) NOT NULL DEFAULT '0' COMMENT '修改用户名或者绑定已有账号标识,0-未标记,1-已标记',
  PRIMARY KEY (`id`),
  KEY `openid` (`openid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='qq登陆记录表';


-- -----------------------------
-- Table structure for `ey_weapp_sitecollect`
-- -----------------------------
DROP TABLE IF EXISTS `ey_weapp_sitecollect`;
CREATE TABLE `ey_weapp_sitecollect` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(50) DEFAULT '' COMMENT '任务名称',
  `typeid` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '采集栏目',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  `is_desc` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否倒序采集',
  `is_status` tinyint(1) NOT NULL DEFAULT '1' COMMENT '入库状态(1=显示，0=屏蔽(草稿))',
  `is_litpic` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否获取第一张图片为封面',
  `is_filt_repet` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否过滤重复标题',
  `is_local` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '图片是否本地保存',
  `filt_iframe` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否过滤Iframe',
  `filt_js` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `filt_a` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `filt_style` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `filt_object` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `filt_note` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `filt_table` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `filt_img` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `filt_embed` tinyint(1) NOT NULL DEFAULT '0',
  `filt_param` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `filt_div_b` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `filt_div_e` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `get_style` tinyint(1) unsigned NOT NULL DEFAULT '2' COMMENT '获取方式，1：手工输入，2：批量生成',
  `url_rule` varchar(255) NOT NULL DEFAULT '' COMMENT '网址规则',
  `min_id` int(6) unsigned NOT NULL DEFAULT '1' COMMENT '最小值页码',
  `max_id` int(6) unsigned NOT NULL DEFAULT '0' COMMENT '最大值页码',
  `list_rule` varchar(255) NOT NULL DEFAULT '' COMMENT '列表规则',
  `a_rule` varchar(255) NOT NULL DEFAULT '' COMMENT '页面链接规则',
  `a_involve` varchar(100) NOT NULL DEFAULT '' COMMENT '必须包含',
  `a_exclusive` varchar(100) NOT NULL DEFAULT '' COMMENT '不能包含',
  `is_list_litpic` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '获取列表缩略图',
  `litpic_rule` varchar(255) NOT NULL DEFAULT '' COMMENT '列表缩略图规则',
  `is_page` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否文章分页',
  `page_a_rule` varchar(255) NOT NULL DEFAULT '' COMMENT '页面正则代码',
  `page_list_rule` varchar(255) NOT NULL DEFAULT '' COMMENT '分页正则代码',
  `sort_order` int(6) unsigned NOT NULL DEFAULT '100',
  `status` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '状态，1：启用，0：锁定',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 COMMENT='文章采集任务列表';

-- -----------------------------
-- Records of `ey_weapp_sitecollect`
-- -----------------------------
INSERT INTO `ey_weapp_sitecollect` VALUES ('1', '示例任务(示例网址：http://www.zzfrjt.com/nba/index_2.html)', '10', '1589179925', '1589179925', '1', '1', '1', '1', '1', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '2', 'http://www.zzfrjt.com/nba/index_{{id}}.html', '2', '3', '&lt;ul id=\'listNewsTimeLy\' class=&quot;listNewsTimeLy&quot;&gt;[内容]&lt;div class=&quot;pagnation&quot; id=&quot;pagnation&quot; style=&quot;padding-bottom:30px;&quot;&gt;', '&lt;a class=&quot;J-share-a&quot; href=&quot;[内容]&quot; target=&quot;_blank&quot;&gt;', '', '', '1', '&lt;img class=&quot;animation&quot; src=&quot;[内容]&quot;', '0', '', '', '100', '1');
INSERT INTO `ey_weapp_sitecollect` VALUES ('2', '电脑站模板采集', '13', '1589179954', '1589338310', '1', '0', '0', '1', '1', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', '', '1', '0', '&lt;ul class=&quot;blocks-2 blocks-lg-3 met-pager-ajax met-grid&quot;&gt;\r\n[内容]\r\n        &lt;/ul&gt;\r\n      &lt;/div&gt;\r\n    &lt;/div&gt;\r\n  &lt;/div&gt;\r\n&lt;/div&gt;\r\n', '&lt;figure class=&quot;widget-header cover&quot;&gt; &lt;a href=&quot;[内容]&quot;', '', '', '1', '&lt;img class=&quot;cover-image&quot; data-original=&quot;[内容]&quot;', '0', '', '', '100', '1');
INSERT INTO `ey_weapp_sitecollect` VALUES ('4', '新闻采集', '24', '1589330098', '1589330918', '1', '1', '0', '1', '1', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', 'https://www.shwlz.com/jzzx.html?pagesize=10&amp;p=3', '1', '0', '&lt;ul class=&quot;textlist&quot;&gt;[内容]&lt;/ul&gt;', '', '', '', '0', '', '0', '', '', '100', '1');

-- -----------------------------
-- Table structure for `ey_weapp_sitecollet_record`
-- -----------------------------
DROP TABLE IF EXISTS `ey_weapp_sitecollet_record`;
CREATE TABLE `ey_weapp_sitecollet_record` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `collectid` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '采集列表id',
  `title` varchar(255) NOT NULL DEFAULT '' COMMENT '标题',
  `url_list` text NOT NULL COMMENT '执行url集合（json格式）',
  `add_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`),
  KEY `collectid` (`collectid`)
) ENGINE=MyISAM AUTO_INCREMENT=46 DEFAULT CHARSET=utf8 COMMENT='文章采集记录列表';

-- -----------------------------
-- Records of `ey_weapp_sitecollet_record`
-- -----------------------------
INSERT INTO `ey_weapp_sitecollet_record` VALUES ('37', '2', '电脑站模板采集', '[\"https:\\/\\/www.eyoucms.com\\/moban\\/\"]', '1589186342', '1589186342');
INSERT INTO `ey_weapp_sitecollet_record` VALUES ('38', '3', '案例采集', '[\"https:\\/\\/www.eyoucms.com\\/anli\\/list_4_15.html\",\"https:\\/\\/www.eyoucms.com\\/anli\\/list_4_14.html\"]', '1589188627', '1589188627');
INSERT INTO `ey_weapp_sitecollet_record` VALUES ('39', '2', '电脑站模板采集', '[\"https:\\/\\/www.eyoucms.com\\/moban\\/list_3_2.html\"]', '1589251086', '1589251086');
INSERT INTO `ey_weapp_sitecollet_record` VALUES ('40', '4', '新闻采集', '[\"https:\\/\\/www.shwlz.com\\/jzzx.html?pagesize=10&amp;p=3\"]', '1589330331', '1589330331');
INSERT INTO `ey_weapp_sitecollet_record` VALUES ('41', '4', '新闻采集', '[\"https:\\/\\/www.shwlz.com\\/seo.html?pagesize=10&amp;p=1\"]', '1589330512', '1589330512');
INSERT INTO `ey_weapp_sitecollet_record` VALUES ('42', '4', '新闻采集', '[\"https:\\/\\/www.shwlz.com\\/wxyx.html\"]', '1589330764', '1589330764');
INSERT INTO `ey_weapp_sitecollet_record` VALUES ('43', '4', '新闻采集', '[\"https:\\/\\/www.shwlz.com\\/xwdt.html\"]', '1589330842', '1589330842');
INSERT INTO `ey_weapp_sitecollet_record` VALUES ('44', '4', '新闻采集', '[\"https:\\/\\/www.shwlz.com\\/faq.html?pagesize=20&amp;p=1\"]', '1589330945', '1589330945');
INSERT INTO `ey_weapp_sitecollet_record` VALUES ('45', '2', '电脑站模板采集', '[\"https:\\/\\/www.eyoucms.com\\/moban\\/list_3_21.html\"]', '1589338349', '1589338349');

-- -----------------------------
-- Table structure for `ey_weapp_sitecollet_rule`
-- -----------------------------
DROP TABLE IF EXISTS `ey_weapp_sitecollet_rule`;
CREATE TABLE `ey_weapp_sitecollet_rule` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `collectid` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '采集列表id',
  `name` varchar(50) NOT NULL DEFAULT '' COMMENT '字段名称',
  `title` varchar(50) NOT NULL DEFAULT '' COMMENT '字段别名（中文）',
  `rule` varchar(255) NOT NULL DEFAULT '' COMMENT '采集规则',
  `origin` varchar(255) NOT NULL DEFAULT '' COMMENT '初始字符串',
  `replace` varchar(255) NOT NULL DEFAULT '' COMMENT '替换字符串',
  `default` varchar(255) NOT NULL DEFAULT '' COMMENT '默认值（不采集）',
  `is_page` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否应用于分页',
  `add_time` int(11) unsigned DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) unsigned DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`),
  KEY `collectid` (`collectid`)
) ENGINE=MyISAM AUTO_INCREMENT=359 DEFAULT CHARSET=utf8 COMMENT='文章采集规则列表';

-- -----------------------------
-- Records of `ey_weapp_sitecollet_rule`
-- -----------------------------
INSERT INTO `ey_weapp_sitecollet_rule` VALUES ('37', '1', 'seo_description', 'SEO描述', '', '', '', '', '0', '1589179925', '1589179925');
INSERT INTO `ey_weapp_sitecollet_rule` VALUES ('38', '1', 'seo_keywords', 'SEO关键词', '', '', '', '', '0', '1589179925', '1589179925');
INSERT INTO `ey_weapp_sitecollet_rule` VALUES ('39', '1', 'seo_title', 'SEO标题', '', '', '', '', '0', '1589179925', '1589179925');
INSERT INTO `ey_weapp_sitecollet_rule` VALUES ('40', '1', 'litpic', '缩略图', '', '', '', '', '0', '1589179925', '1589179925');
INSERT INTO `ey_weapp_sitecollet_rule` VALUES ('41', '1', 'title', '标题', '&lt;h1&gt;&lt;span&gt;[内容]&lt;/span&gt;&lt;/h1&gt;', '', '', '', '0', '1589179925', '1589179925');
INSERT INTO `ey_weapp_sitecollet_rule` VALUES ('42', '1', 'content', '内容详情', '&lt;div class=&quot;J-contain_detail_cnt contain_detail_cnt&quot;&gt;[内容]&lt;p&gt;上一篇', '', '', '', '1', '1589179925', '1589179925');
INSERT INTO `ey_weapp_sitecollet_rule` VALUES ('43', '1', 'add_time', '新增时间', '', '', '', '', '0', '1589179925', '1589179925');
INSERT INTO `ey_weapp_sitecollet_rule` VALUES ('44', '1', 'duoxuan', '多选项测试', '', '', '', '', '0', '1589179925', '1589179925');
INSERT INTO `ey_weapp_sitecollet_rule` VALUES ('45', '1', 'xialakuang', '下拉框测试', '', '', '', '', '0', '1589179925', '1589179925');
INSERT INTO `ey_weapp_sitecollet_rule` VALUES ('46', '1', 'danxuan', '但选项测试', '', '', '', '', '0', '1589179925', '1589179925');
INSERT INTO `ey_weapp_sitecollet_rule` VALUES ('358', '2', 'users_price', '价格', '', '', '', '', '0', '1589338310', '1589338310');
INSERT INTO `ey_weapp_sitecollet_rule` VALUES ('356', '2', 'diy_mbbh', '模板编号', '&lt;dd&gt;模板编号：[内容]&lt;/dd&gt;', '', '', '', '0', '1589338310', '1589338310');
INSERT INTO `ey_weapp_sitecollet_rule` VALUES ('357', '2', 'diy_webewm', '网站二维码', '', '', '', '', '0', '1589338310', '1589338310');
INSERT INTO `ey_weapp_sitecollet_rule` VALUES ('355', '2', 'diy_pcys', '电脑站演示地址', '&lt;a id=&quot;collect-btn&quot; class=&quot;collect-btn nonofavV3&quot; href=&quot;[内容]&quot; target=&quot;_blank&quot;  rel=&quot;nofollow&quot;&gt;模板演示&lt;/a&gt;\r\n', '/plus/', 'https://www.eyoucms.com/plus/', '', '0', '1589338310', '1589338310');
INSERT INTO `ey_weapp_sitecollet_rule` VALUES ('354', '2', 'diy_mbys', '手机站演示地址', '&lt;a id=&quot;collect-btn&quot; class=&quot;collect-btn nonofavV3&quot; href=&quot;[内容]&quot; target=&quot;_blank&quot;  rel=&quot;nofollow&quot;&gt;模板演示&lt;/a&gt;\r\n', '/plus/', 'https://www.eyoucms.com/plus/', '', '0', '1589338310', '1589338310');
INSERT INTO `ey_weapp_sitecollet_rule` VALUES ('349', '2', 'seo_keywords', 'SEO关键词', '', '', '', '', '0', '1589338310', '1589338310');
INSERT INTO `ey_weapp_sitecollet_rule` VALUES ('352', '2', 'yanse', '颜色', '&lt;dd&gt;模板颜色：[内容]&lt;/dd&gt;', '', '', '', '0', '1589338310', '1589338310');
INSERT INTO `ey_weapp_sitecollet_rule` VALUES ('353', '2', 'sshy', '所属行业', 'class=&quot;cjzy&quot;&gt;[内容]&lt;/a&gt;', '', '', '', '0', '1589338310', '1589338310');
INSERT INTO `ey_weapp_sitecollet_rule` VALUES ('347', '2', 'litpic', '缩略图', '', '', '', '', '0', '1589338310', '1589338310');
INSERT INTO `ey_weapp_sitecollet_rule` VALUES ('348', '2', 'seo_title', 'SEO标题', '', '', '', '', '0', '1589338310', '1589338310');
INSERT INTO `ey_weapp_sitecollet_rule` VALUES ('302', '4', 'alwz', '案例网址', '', '', '', '', '0', '1589330918', '1589330918');
INSERT INTO `ey_weapp_sitecollet_rule` VALUES ('299', '4', 'seo_keywords', 'SEO关键词', '', '东莞建站公司,企业网站建设,公司网站定制,企业网站优化,网络', '企业网站建设', '', '0', '1589330918', '1589330918');
INSERT INTO `ey_weapp_sitecollet_rule` VALUES ('300', '4', 'seo_description', 'SEO描述', '', '', '', '', '0', '1589330918', '1589330918');
INSERT INTO `ey_weapp_sitecollet_rule` VALUES ('301', '4', 'add_time', '新增时间', '', '', '', '', '0', '1589330918', '1589330918');
INSERT INTO `ey_weapp_sitecollet_rule` VALUES ('297', '4', 'litpic', '缩略图', '', '', '', '', '0', '1589330918', '1589330918');
INSERT INTO `ey_weapp_sitecollet_rule` VALUES ('298', '4', 'seo_title', 'SEO标题', '', '', '', '', '0', '1589330918', '1589330918');
INSERT INTO `ey_weapp_sitecollet_rule` VALUES ('296', '4', 'content', '内容详情', '&lt;div class=&quot;InfoContent&quot;&gt;[内容]&lt;div class=&quot;Tag&quot;&gt;', '', '', '', '1', '1589330918', '1589330918');
INSERT INTO `ey_weapp_sitecollet_rule` VALUES ('295', '4', 'title', '标题', '&lt;div class=&quot;InfoTitle&quot;&gt;&lt;h1&gt;[内容]&lt;/h1&gt;&lt;/div&gt;\r\n', '东莞', '', '', '0', '1589330918', '1589330918');
INSERT INTO `ey_weapp_sitecollet_rule` VALUES ('351', '2', 'add_time', '新增时间', '', '', '', '', '0', '1589338310', '1589338310');
INSERT INTO `ey_weapp_sitecollet_rule` VALUES ('350', '2', 'seo_description', 'SEO描述', '', '', '', '', '0', '1589338310', '1589338310');
INSERT INTO `ey_weapp_sitecollet_rule` VALUES ('346', '2', 'content', '内容详情', '&lt;div class=&quot;clearfix&quot;&gt;[内容]&lt;/div&gt;\r\n', '', '', '', '1', '1589338310', '1589338310');
INSERT INTO `ey_weapp_sitecollet_rule` VALUES ('345', '2', 'title', '标题', '&lt;h1&gt;\r\n            [内容]\r\n            &lt;/h1&gt;', '', '', '', '0', '1589338310', '1589338310');

-- -----------------------------
-- Table structure for `ey_weapp_sitecollet_urllist`
-- -----------------------------
DROP TABLE IF EXISTS `ey_weapp_sitecollet_urllist`;
CREATE TABLE `ey_weapp_sitecollet_urllist` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `collectid` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '采集列表id',
  `url` varchar(512) NOT NULL DEFAULT '' COMMENT '文章url',
  `add_time` int(11) unsigned DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) unsigned DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`),
  KEY `collectid` (`collectid`)
) ENGINE=MyISAM AUTO_INCREMENT=63 DEFAULT CHARSET=utf8 COMMENT='文章采集链接列表';

-- -----------------------------
-- Records of `ey_weapp_sitecollet_urllist`
-- -----------------------------
INSERT INTO `ey_weapp_sitecollet_urllist` VALUES ('37', '1', 'http://www.zzfrjt.com/nba/index_3.html', '1589179925', '1589179925');
INSERT INTO `ey_weapp_sitecollet_urllist` VALUES ('38', '1', 'http://www.zzfrjt.com/nba/index_2.html', '1589179925', '1589179925');
INSERT INTO `ey_weapp_sitecollet_urllist` VALUES ('62', '2', 'https://www.eyoucms.com/moban/list_3_21.html', '1589338258', '1589338258');
INSERT INTO `ey_weapp_sitecollet_urllist` VALUES ('61', '4', 'https://www.shwlz.com/faq.html?pagesize=20&amp;p=1', '1589330889', '1589330889');

-- -----------------------------
-- Table structure for `ey_weapp_spider_tongji`
-- -----------------------------
DROP TABLE IF EXISTS `ey_weapp_spider_tongji`;
CREATE TABLE `ey_weapp_spider_tongji` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `spider` int(10) NOT NULL DEFAULT '0' COMMENT '蜘蛛分类',
  `total` int(10) NOT NULL DEFAULT '0' COMMENT '蜘蛛统计',
  `month` int(10) NOT NULL DEFAULT '0' COMMENT '最近30天',
  `week` int(10) NOT NULL DEFAULT '0' COMMENT '当周',
  `pre_week` int(10) NOT NULL DEFAULT '0' COMMENT '上一周',
  `day` int(10) NOT NULL DEFAULT '0' COMMENT '当天',
  `pre_day` int(10) NOT NULL DEFAULT '0' COMMENT '昨天',
  `add_time` int(11) NOT NULL DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`),
  KEY `spider` (`spider`)
) ENGINE=MyISAM AUTO_INCREMENT=7 DEFAULT CHARSET=utf8;

-- -----------------------------
-- Records of `ey_weapp_spider_tongji`
-- -----------------------------
INSERT INTO `ey_weapp_spider_tongji` VALUES ('1', '99', '536472', '3308', '3308', '0', '1017', '2291', '1646467881', '1656659087');
INSERT INTO `ey_weapp_spider_tongji` VALUES ('2', '6', '384487', '917', '917', '0', '634', '283', '1646467883', '1656658974');
INSERT INTO `ey_weapp_spider_tongji` VALUES ('3', '1', '51259', '631', '631', '0', '229', '402', '1646467901', '1656658421');
INSERT INTO `ey_weapp_spider_tongji` VALUES ('4', '3', '15035', '94', '94', '0', '52', '42', '1646468149', '1656656926');
INSERT INTO `ey_weapp_spider_tongji` VALUES ('5', '2', '15042', '63', '63', '0', '31', '32', '1646468700', '1656658417');
INSERT INTO `ey_weapp_spider_tongji` VALUES ('6', '4', '418', '2', '2', '0', '1', '1', '1646481145', '1656605147');

-- -----------------------------
-- Table structure for `ey_weapp_spider_visit`
-- -----------------------------
DROP TABLE IF EXISTS `ey_weapp_spider_visit`;
CREATE TABLE `ey_weapp_spider_visit` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `spider` int(10) DEFAULT '0' COMMENT '蜘蛛分类',
  `useragent` varchar(500) DEFAULT '' COMMENT '蜘蛛标识',
  `url` varchar(500) DEFAULT '' COMMENT '抓取的URL',
  `ip` varchar(20) DEFAULT '' COMMENT '蜘蛛ip',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`),
  KEY `spider` (`spider`)
) ENGINE=MyISAM AUTO_INCREMENT=1002715 DEFAULT CHARSET=utf8;

-- -----------------------------
-- Records of `ey_weapp_spider_visit`
-- -----------------------------
INSERT INTO `ey_weapp_spider_visit` VALUES ('1001648', '6', 'mozilla/5.0 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', '/?ccavp', '157.55.39.106', '1656630026', '0');
INSERT INTO `ey_weapp_spider_visit` VALUES ('1001655', '99', 'mozilla/5.0 (compatible; semrushbot/7~bl; +http://www.semrush.com/bot.html)', '/?6B7on', '185.191.171.38', '1656630283', '0');
INSERT INTO `ey_weapp_spider_visit` VALUES ('1001658', '6', 'mozilla/5.0 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', '/?aid=2811&amp;area=349248', '157.55.39.63', '1656630339', '0');
INSERT INTO `ey_weapp_spider_visit` VALUES ('1002634', '99', 'mozilla/5.0 (linux; android 7.0;) applewebkit/537.36 (khtml, like gecko) mobile safari/537.36 (compatible; petalbot;+https://webmaster.petalsearch.com/site/petalbot)', '/xxzl/1820.html', '114.119.153.191', '1656657093', '0');
INSERT INTO `ey_weapp_spider_visit` VALUES ('1002636', '99', 'mozilla/5.0 (compatible; semrushbot/7~bl; +http://www.semrush.com/bot.html)', '/?QL4Wk', '185.191.171.12', '1656657257', '0');
INSERT INTO `ey_weapp_spider_visit` VALUES ('1001908', '6', 'mozilla/5.0 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', '/?comid=263729', '157.55.39.106', '1656637365', '0');
INSERT INTO `ey_weapp_spider_visit` VALUES ('1001912', '6', 'mozilla/5.0 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', '/?comid=598470', '157.55.39.63', '1656637500', '0');
INSERT INTO `ey_weapp_spider_visit` VALUES ('1001913', '6', 'mozilla/5.0 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', '/ckdy/2536.html', '207.46.13.7', '1656637521', '0');
INSERT INTO `ey_weapp_spider_visit` VALUES ('1001626', '99', 'mozilla/5.0 (compatible; semrushbot/7~bl; +http://www.semrush.com/bot.html)', '/?jfsAr', '185.191.171.6', '1656629570', '0');
INSERT INTO `ey_weapp_spider_visit` VALUES ('1002658', '99', 'mozilla/5.0 (compatible; semrushbot/7~bl; +http://www.semrush.com/bot.html)', '/ckdy/1625.html', '185.191.171.13', '1656657700', '0');
INSERT INTO `ey_weapp_spider_visit` VALUES ('1002659', '99', 'mozilla/5.0 (compatible; semrushbot/7~bl; +http://www.semrush.com/bot.html)', '/?ibxFC', '185.191.171.11', '1656657711', '0');
INSERT INTO `ey_weapp_spider_visit` VALUES ('1002662', '99', 'mozilla/5.0 (compatible; semrushbot/7~bl; +http://www.semrush.com/bot.html)', '/bylw/864.html', '185.191.171.22', '1656657805', '0');
INSERT INTO `ey_weapp_spider_visit` VALUES ('1002664', '6', 'mozilla/5.0 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', '/?news266507.html', '40.77.167.68', '1656657868', '0');
INSERT INTO `ey_weapp_spider_visit` VALUES ('1001694', '6', 'mozilla/5.0 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', '/?comid=835716', '157.55.39.106', '1656631456', '0');
INSERT INTO `ey_weapp_spider_visit` VALUES ('1001700', '6', 'mozilla/5.0 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', '/?tq6dg5-436557.html', '40.77.167.68', '1656631577', '0');
INSERT INTO `ey_weapp_spider_visit` VALUES ('1001871', '99', 'mozilla/5.0 (compatible; semrushbot/7~bl; +http://www.semrush.com/bot.html)', '/ckdy/3024.html', '185.191.171.21', '1656636341', '0');
INSERT INTO `ey_weapp_spider_visit` VALUES ('1002052', '3', 'sogou web spider/4.0(+http://www.sogou.com/docs/help/webmasters.htm#07)', '/ckdy/3590.html', '49.7.20.138', '1656641627', '0');
INSERT INTO `ey_weapp_spider_visit` VALUES ('1002139', '6', 'mozilla/5.0 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', '/?b=show&amp;id=861716', '207.46.13.159', '1656644173', '0');
INSERT INTO `ey_weapp_spider_visit` VALUES ('1002029', '6', 'mozilla/5.0 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', '/?bdgdt=737663', '207.46.13.7', '1656641006', '0');
INSERT INTO `ey_weapp_spider_visit` VALUES ('1002046', '99', 'mozilla/5.0 (compatible; semrushbot/7~bl; +http://www.semrush.com/bot.html)', '/ckdy/2084.html', '185.191.171.6', '1656641509', '0');
INSERT INTO `ey_weapp_spider_visit` VALUES ('1001874', '6', 'mozilla/5.0 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', '/?comid=377846', '157.55.39.63', '1656636398', '0');
INSERT INTO `ey_weapp_spider_visit` VALUES ('1001876', '6', 'mozilla/5.0 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', '/?comid=345017', '40.77.167.68', '1656636454', '0');
INSERT INTO `ey_weapp_spider_visit` VALUES ('1002009', '6', 'mozilla/5.0 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', '/lnzt/', '157.55.39.63', '1656640424', '0');
INSERT INTO `ey_weapp_spider_visit` VALUES ('1000588', '99', 'mozilla/5.0 (compatible; semrushbot/7~bl; +http://www.semrush.com/bot.html)', '/ckdy/1519.html', '185.191.171.17', '1656599392', '0');
INSERT INTO `ey_weapp_spider_visit` VALUES ('1000566', '99', 'mozilla/5.0 (linux; android 7.0;) applewebkit/537.36 (khtml, like gecko) mobile safari/537.36 (compatible; petalbot;+https://webmaster.petalsearch.com/site/petalbot)', '/ckdy/1621.html', '114.119.153.161', '1656598410', '0');
INSERT INTO `ey_weapp_spider_visit` VALUES ('1000568', '99', 'mozilla/5.0 (compatible; semrushbot/7~bl; +http://www.semrush.com/bot.html)', '/kszc/2231.html', '185.191.171.44', '1656598498', '0');
INSERT INTO `ey_weapp_spider_visit` VALUES ('1000570', '99', 'mozilla/5.0 (compatible; semrushbot/7~bl; +http://www.semrush.com/bot.html)', '/?msROl', '185.191.171.25', '1656598618', '0');
INSERT INTO `ey_weapp_spider_visit` VALUES ('998107', '99', 'mozilla/5.0 (compatible; semrushbot/7~bl; +http://www.semrush.com/bot.html)', '/?W8qLu', '185.191.171.13', '1656579821', '0');
INSERT INTO `ey_weapp_spider_visit` VALUES ('998108', '99', 'mozilla/5.0 (compatible; semrushbot/7~bl; +http://www.semrush.com/bot.html)', '/?wn6v1', '185.191.171.9', '1656579966', '0');
INSERT INTO `ey_weapp_spider_visit` VALUES ('1000908', '99', 'mozilla/5.0 (compatible; semrushbot/7~bl; +http://www.semrush.com/bot.html)', '/?I29Cx', '185.191.171.19', '1656611302', '0');
INSERT INTO `ey_weapp_spider_visit` VALUES ('1000900', '6', 'mozilla/5.0 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', '/search.html?submit=%E6%90%9C%E7%B4%A2&amp;keywords=2023', '207.46.13.7', '1656610739', '0');
INSERT INTO `ey_weapp_spider_visit` VALUES ('1000902', '1', 'mozilla/5.0 (linux; android 6.0.1; nexus 5x build/mmb29p) applewebkit/537.36 (khtml, like gecko) chrome/103.0.5060.53 mobile safari/537.36 (compatible; googlebot/2.1; +http://www.google.com/bot.html)', '/?e68hf', '66.249.75.37', '1656610864', '0');
INSERT INTO `ey_weapp_spider_visit` VALUES ('1000542', '2', 'mozilla/5.0 (compatible; baiduspider/2.0; +http://www.baidu.com/search/spider.html)', '/guojia/1853.html', '220.181.108.165', '1656597834', '0');
INSERT INTO `ey_weapp_spider_visit` VALUES ('1000544', '6', 'mozilla/5.0 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', '/?258611yfxnb.html', '157.55.39.63', '1656597847', '0');
INSERT INTO `ey_weapp_spider_visit` VALUES ('1000545', '99', 'mozilla/5.0 (compatible; semrushbot/7~bl; +http://www.semrush.com/bot.html)', '/?bMzRJ', '185.191.171.4', '1656597893', '0');
INSERT INTO `ey_weapp_spider_visit` VALUES ('1000546', '99', 'mozilla/5.0 (compatible; semrushbot/7~bl; +http://www.semrush.com/bot.html)', '/?I2GjU', '185.191.171.11', '1656597908', '0');
INSERT INTO `ey_weapp_spider_visit` VALUES ('1000552', '6', 'mozilla/5.0 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', '/?d=show&amp;id=192312', '40.77.167.68', '1656597992', '0');
INSERT INTO `ey_weapp_spider_visit` VALUES ('1000560', '1', 'mozilla/5.0 (compatible; googlebot/2.1; +http://www.google.com/bot.html)', '/', '66.249.75.40', '1656598206', '0');
INSERT INTO `ey_weapp_spider_visit` VALUES ('1000734', '99', 'mozilla/5.0 (compatible; semrushbot/7~bl; +http://www.semrush.com/bot.html)', '/ckdy/2546.html', '185.191.171.13', '1656604249', '0');
INSERT INTO `ey_weapp_spider_visit` VALUES ('1000520', '6', 'mozilla/5.0 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', '/?hs53z=289699', '40.77.167.68', '1656597171', '0');
INSERT INTO `ey_weapp_spider_visit` VALUES ('1000579', '99', 'mozilla/5.0 (compatible; semrushbot/7~bl; +http://www.semrush.com/bot.html)', '/gdds/5419.html', '185.191.171.1', '1656599084', '0');
INSERT INTO `ey_weapp_spider_visit` VALUES ('1000533', '6', 'mozilla/5.0 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', '/?ld0uvf-639826.html', '207.46.13.159', '1656597597', '0');
INSERT INTO `ey_weapp_spider_visit` VALUES ('1000537', '6', 'mozilla/5.0 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', '/?gg5s1=473671', '40.77.167.68', '1656597741', '0');
INSERT INTO `ey_weapp_spider_visit` VALUES ('1000860', '99', 'mozilla/5.0 (compatible; semrushbot/7~bl; +http://www.semrush.com/bot.html)', '/gdds/4389.html', '185.191.171.8', '1656608972', '0');
INSERT INTO `ey_weapp_spider_visit` VALUES ('1001020', '1', 'mozilla/5.0 (linux; android 6.0.1; nexus 5x build/mmb29p) applewebkit/537.36 (khtml, like gecko) chrome/103.0.5060.53 mobile safari/537.36 (compatible; googlebot/2.1; +http://www.google.com/bot.html)', '/jyqj/1173.html', '66.249.75.34', '1656615216', '0');
INSERT INTO `ey_weapp_spider_visit` VALUES ('1001021', '1', 'mozilla/5.0 (linux; android 6.0.1; nexus 5x build/mmb29p) applewebkit/537.36 (khtml, like gecko) chrome/103.0.5060.53 mobile safari/537.36 (compatible; googlebot/2.1; +http://www.google.com/bot.html)', '/ckdy/1425.html', '66.249.75.37', '1656615248', '0');
INSERT INTO `ey_weapp_spider_visit` VALUES ('1001032', '99', 'mozilla/5.0 (compatible; semrushbot/7~bl; +http://www.semrush.com/bot.html)', '/?JL9aq', '185.191.171.12', '1656615762', '0');
INSERT INTO `ey_weapp_spider_visit` VALUES ('1001057', '99', 'mozilla/5.0 (linux; android 7.0;) applewebkit/537.36 (khtml, like gecko) mobile safari/537.36 (compatible; petalbot;+https://webmaster.petalsearch.com/site/petalbot)', '/gdds/5783.html', '114.119.153.160', '1656616303', '0');
INSERT INTO `ey_weapp_spider_visit` VALUES ('1001073', '1', 'mozilla/5.0 (linux; android 6.0.1; nexus 5x build/mmb29p) applewebkit/537.36 (khtml, like gecko) chrome/103.0.5060.53 mobile safari/537.36 (compatible; googlebot/2.1; +http://www.google.com/bot.html)', '/xxzl/2935.html', '66.249.75.37', '1656616627', '0');
INSERT INTO `ey_weapp_spider_visit` VALUES ('1000367', '1', 'mozilla/5.0 (linux; android 6.0.1; nexus 5x build/mmb29p) applewebkit/537.36 (khtml, like gecko) chrome/103.0.5060.53 mobile safari/537.36 (compatible; googlebot/2.1; +http://www.google.com/bot.html)', '/gdds/5473.html', '66.249.75.37', '1656594289', '0');
INSERT INTO `ey_weapp_spider_visit` VALUES ('1000369', '99', 'mozilla/5.0 (compatible; semrushbot/7~bl; +http://www.semrush.com/bot.html)', '/?pjRmV', '185.191.171.10', '1656594309', '0');
INSERT INTO `ey_weapp_spider_visit` VALUES ('1000382', '1', 'mozilla/5.0 (linux; android 6.0.1; nexus 5x build/mmb29p) applewebkit/537.36 (khtml, like gecko) chrome/103.0.5060.53 mobile safari/537.36 (compatible; googlebot/2.1; +http://www.google.com/bot.html)', '/gdds/5053.html', '66.249.75.37', '1656594551', '0');
INSERT INTO `ey_weapp_spider_visit` VALUES ('1000393', '1', 'mozilla/5.0 (linux; android 6.0.1; nexus 5x build/mmb29p) applewebkit/537.36 (khtml, like gecko) chrome/103.0.5060.53 mobile safari/537.36 (compatible; googlebot/2.1; +http://www.google.com/bot.html)', '/gdds/5446.html', '66.249.75.40', '1656594735', '0');
INSERT INTO `ey_weapp_spider_visit` VALUES ('1000348', '1', 'mozilla/5.0 (linux; android 6.0.1; nexus 5x build/mmb29p) applewebkit/537.36 (khtml, like gecko) chrome/103.0.5060.53 mobile safari/537.36 (compatible; googlebot/2.1; +http://www.google.com/bot.html)', '/gdds/5661.html', '66.249.75.34', '1656593947', '0');
INSERT INTO `ey_weapp_spider_visit` VALUES ('1000352', '6', 'mozilla/5.0 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', '/ckdy/3836.html', '157.55.39.63', '1656594000', '0');
INSERT INTO `ey_weapp_spider_visit` VALUES ('1000444', '6', 'mozilla/5.0 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', '/?b=show&amp;id=806031', '157.55.39.63', '1656595472', '0');
INSERT INTO `ey_weapp_spider_visit` VALUES ('998264', '6', 'mozilla/5.0 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', '/?105800si0m0.html', '157.55.39.63', '1656585798', '0');
INSERT INTO `ey_weapp_spider_visit` VALUES ('998269', '6', 'mozilla/5.0 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', '/?5gshm', '207.46.13.7', '1656586060', '0');
INSERT INTO `ey_weapp_spider_visit` VALUES ('998272', '6', 'mozilla/5.0 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', '/?r=show&amp;id=683681', '40.77.167.68', '1656586124', '0');
INSERT INTO `ey_weapp_spider_visit` VALUES ('998233', '6', 'mozilla/5.0 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', '/?news506048.html', '207.46.13.7', '1656584917', '0');
INSERT INTO `ey_weapp_spider_visit` VALUES ('998238', '99', 'mozilla/5.0 (linux; android 7.0;) applewebkit/537.36 (khtml, like gecko) mobile safari/537.36 (compatible; petalbot;+https://webmaster.petalsearch.com/site/petalbot)', '/xxzl/2248.html', '114.119.153.160', '1656585008', '0');
INSERT INTO `ey_weapp_spider_visit` VALUES ('998241', '3', 'sogou web spider/4.0(+http://www.sogou.com/docs/help/webmasters.htm#07)', '/ckdy/1083.html', '58.250.125.109', '1656585131', '0');
INSERT INTO `ey_weapp_spider_visit` VALUES ('998252', '6', 'mozilla/5.0 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', '/?comid=868843', '40.77.167.68', '1656585434', '0');
INSERT INTO `ey_weapp_spider_visit` VALUES ('998253', '99', 'mozilla/5.0 (compatible; semrushbot/7~bl; +http://www.semrush.com/bot.html)', '/?KcAZJ', '185.191.171.22', '1656585479', '0');
INSERT INTO `ey_weapp_spider_visit` VALUES ('1001819', '99', 'mozilla/5.0 (compatible; semrushbot/7~bl; +http://www.semrush.com/bot.html)', '/?ALKea', '185.191.171.1', '1656634848', '0');
INSERT INTO `ey_weapp_spider_visit` VALUES ('1001821', '99', 'mozilla/5.0 (compatible; semrushbot/7~bl; +http://www.semrush.com/bot.html)', '/?BdXy7', '185.191.171.1', '1656634969', '0');
INSERT INTO `ey_weapp_spider_visit` VALUES ('1001827', '6', 'mozilla/5.0 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', '/?8lwhw', '40.77.167.68', '1656635173', '0');
INSERT INTO `ey_weapp_spider_visit` VALUES ('1001419', '99', 'mozilla/5.0 (compatible; semrushbot/7~bl; +http://www.semrush.com/bot.html)', '/?EK58g', '185.191.171.44', '1656624678', '0');
INSERT INTO `ey_weapp_spider_visit` VALUES ('1001417', '99', 'mozilla/5.0 (compatible; semrushbot/7~bl; +http://www.semrush.com/bot.html)', '/?GulYS', '185.191.171.21', '1656624664', '0');
INSERT INTO `ey_weapp_spider_visit` VALUES ('1001472', '6', 'mozilla/5.0 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', '/?wgn44', '207.46.13.159', '1656625573', '0');
INSERT INTO `ey_weapp_spider_visit` VALUES ('1001654', '6', 'mozilla/5.0 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', '/?comid=093834', '207.46.13.7', '1656630249', '0');
INSERT INTO `ey_weapp_spider_visit` VALUES ('1002637', '99', 'mozilla/5.0 (linux; android 7.0;) applewebkit/537.36 (khtml, like gecko) mobile safari/537.36 (compatible; petalbot;+https://webmaster.petalsearch.com/site/petalbot)', '/ckzy/853.html', '114.119.142.42', '1656657292', '0');
INSERT INTO `ey_weapp_spider_visit` VALUES ('1001660', '6', 'mozilla/5.0 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', '/?comid=190700', '40.77.167.16', '1656630409', '0');
INSERT INTO `ey_weapp_spider_visit` VALUES ('999359', '1', 'mozilla/5.0 (linux; android 6.0.1; nexus 5x build/mmb29p) applewebkit/537.36 (khtml, like gecko) chrome/103.0.5060.53 mobile safari/537.36 (compatible; googlebot/2.1; +http://www.google.com/bot.html)', '/gdds/5085.html', '66.249.75.37', '1656590295', '0');
INSERT INTO `ey_weapp_spider_visit` VALUES ('999358', '99', 'mozilla/5.0 (compatible; blexbot/1.0; +http://webmeup-crawler.com/)', '/gdds/5299.html', '116.202.128.228', '1656590295', '0');
INSERT INTO `ey_weapp_spider_visit` VALUES ('999362', '99', 'mozilla/5.0 (compatible; blexbot/1.0; +http://webmeup-crawler.com/)', '/gdds/5303.html', '116.202.128.228', '1656590308', '0');
INSERT INTO `ey_weapp_spider_visit` VALUES ('999363', '99', 'mozilla/5.0 (compatible; blexbot/1.0; +http://webmeup-crawler.com/)', '/gdds/5306.html', '116.202.128.228', '1656590312', '0');
INSERT INTO `ey_weapp_spider_visit` VALUES ('1000511', '99', 'mozilla/5.0 (compatible; semrushbot/7~bl; +http://www.semrush.com/bot.html)', '/?uRocl', '185.191.171.22', '1656596839', '0');
INSERT INTO `ey_weapp_spider_visit` VALUES ('1000526', '99', 'mozilla/5.0 (compatible; semrushbot/7~bl; +http://www.semrush.com/bot.html)', '/ckdy/3458.html', '185.191.171.35', '1656597399', '0');
INSERT INTO `ey_weapp_spider_visit` VALUES ('1000527', '99', 'mozilla/5.0 (compatible; semrushbot/7~bl; +http://www.semrush.com/bot.html)', '/ckdy/3822.html', '185.191.171.12', '1656597401', '0');
INSERT INTO `ey_weapp_spider_visit` VALUES ('1000531', '3', 'sogou web spider/4.0(+http://www.sogou.com/docs/help/webmasters.htm#07)', '/ckdy/2465.html', '123.125.109.85', '1656597547', '0');
INSERT INTO `ey_weapp_spider_visit` VALUES ('1000553', '6', 'mozilla/5.0 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', '/?ehkz9', '40.77.167.68', '1656597994', '0');
INSERT INTO `ey_weapp_spider_visit` VALUES ('997979', '1', 'mozilla/5.0 (linux; android 6.0.1; nexus 5x build/mmb29p) applewebkit/537.36 (khtml, like gecko) chrome/103.0.5060.53 mobile safari/537.36 (compatible; googlebot/2.1; +http://www.google.com/bot.html)', '/gdds/4456.html', '66.249.75.40', '1656575726', '0');
INSERT INTO `ey_weapp_spider_visit` VALUES ('997980', '99', 'mozilla/5.0 (compatible; semrushbot/7~bl; +http://www.semrush.com/bot.html)', '/?UXaVk', '185.191.171.25', '1656575800', '0');
INSERT INTO `ey_weapp_spider_visit` VALUES ('1000589', '99', 'mozilla/5.0 (compatible; semrushbot/7~bl; +http://www.semrush.com/bot.html)', '/ckdy/2442.html', '185.191.171.44', '1656599477', '0');
INSERT INTO `ey_weapp_spider_visit` VALUES ('1000592', '3', 'sogou web spider/4.0(+http://www.sogou.com/docs/help/webmasters.htm#07)', '/ckzy/839.html', '58.250.125.92', '1656599550', '0');
INSERT INTO `ey_weapp_spider_visit` VALUES ('1000586', '99', 'mozilla/5.0 (compatible; semrushbot/7~bl; +http://www.semrush.com/bot.html)', '/?QgPsv', '185.191.171.1', '1656599249', '0');
INSERT INTO `ey_weapp_spider_visit` VALUES ('1000594', '99', 'mozilla/5.0 (compatible; semrushbot/7~bl; +http://www.semrush.com/bot.html)', '/ckdy/3384.html', '185.191.171.8', '1656599561', '0');
INSERT INTO `ey_weapp_spider_visit` VALUES ('1000596', '6', 'mozilla/5.0 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', '/zxbm/', '157.55.39.106', '1656599623', '0');
INSERT INTO `ey_weapp_spider_visit` VALUES ('1001289', '1', 'mozilla/5.0 (linux; android 6.0.1; nexus 5x build/mmb29p) applewebkit/537.36 (khtml, like gecko) chrome/103.0.5060.53 mobile safari/537.36 (compatible; googlebot/2.1; +http://www.google.com/bot.html)', '/gdds/5300.html', '66.249.75.34', '1656621778', '0');
INSERT INTO `ey_weapp_spider_visit` VALUES ('1001292', '6', 'mozilla/5.0 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', '/?jesp5s-933161.html', '40.77.167.68', '1656621811', '0');
INSERT INTO `ey_weapp_spider_visit` VALUES ('1000671', '99', 'mozilla/5.0 (compatible; semrushbot/7~bl; +http://www.semrush.com/bot.html)', '/ckdy/3363.html', '185.191.171.25', '1656602165', '0');
INSERT INTO `ey_weapp_spider_visit` VALUES ('1000680', '6', 'mozilla/5.0 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', '/?dgng0', '40.77.167.68', '1656602380', '0');
INSERT INTO `ey_weapp_spider_visit` VALUES ('1000695', '99', 'mozilla/5.0 (compatible; semrushbot/7~bl; +http://www.semrush.com/bot.html)', '/?DXl0i', '185.191.171.38', '1656602808', '0');
INSERT INTO `ey_weapp_spider_visit` VALUES ('1000699', '99', 'mozilla/5.0 (compatible; semrushbot/7~bl; +http://www.semrush.com/bot.html)', '/xxzl/2761.html', '185.191.171.14', '1656603038', '0');
INSERT INTO `ey_weapp_spider_visit` VALUES ('1000701', '6', 'mozilla/5.0 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', '/', '157.55.39.106', '1656603131', '0');
INSERT INTO `ey_weapp_spider_visit` VALUES ('1000649', '6', 'mozilla/5.0 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', '/?comid=635478', '157.55.39.63', '1656601141', '0');
INSERT INTO `ey_weapp_spider_visit` VALUES ('1000656', '6', 'mozilla/5.0 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', '/?comid=632661', '157.55.39.63', '1656601414', '0');
INSERT INTO `ey_weapp_spider_visit` VALUES ('1000661', '99', 'mozilla/5.0 (compatible; semrushbot/7~bl; +http://www.semrush.com/bot.html)', '/?nylRP', '185.191.171.34', '1656601728', '0');
INSERT INTO `ey_weapp_spider_visit` VALUES ('1000669', '3', 'sogou web spider/4.0(+http://www.sogou.com/docs/help/webmasters.htm#07)', '/ckdy/1393.html', '58.250.125.123', '1656602062', '0');
INSERT INTO `ey_weapp_spider_visit` VALUES ('1000672', '6', 'mozilla/5.0 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', '/?comid=981863', '157.55.39.63', '1656602196', '0');
INSERT INTO `ey_weapp_spider_visit` VALUES ('1000682', '6', 'mozilla/5.0 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', '/?comid=326741', '157.55.39.63', '1656602395', '0');
INSERT INTO `ey_weapp_spider_visit` VALUES ('1001180', '99', 'mozilla/5.0 (compatible; semrushbot/7~bl; +http://www.semrush.com/bot.html)', '/?9Ix6s', '185.191.171.6', '1656619409', '0');
INSERT INTO `ey_weapp_spider_visit` VALUES ('1001182', '99', 'mozilla/5.0 (linux; android 7.0;) applewebkit/537.36 (khtml, like gecko) mobile safari/537.36 (compatible; petalbot;+https://webmaster.petalsearch.com/site/petalbot)', '/gdds/5194.html', '114.119.153.186', '1656619467', '0');
INSERT INTO `ey_weapp_spider_visit` VALUES ('1001184', '6', 'mozilla/5.0 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', '/?vLjRL', '13.66.139.3', '1656619527', '0');
INSERT INTO `ey_weapp_spider_visit` VALUES ('1000850', '99', 'mozilla/5.0 (compatible; semrushbot/7~bl; +http://www.semrush.com/bot.html)', '/?yBSJ3', '185.191.171.35', '1656608510', '0');
INSERT INTO `ey_weapp_spider_visit` VALUES ('1001559', '99', 'mozilla/5.0 (compatible; semrushbot/7~bl; +http://www.semrush.com/bot.html)', '/ckdy/3649.html', '185.191.171.23', '1656627649', '0');
INSERT INTO `ey_weapp_spider_visit` VALUES ('1001563', '6', 'mozilla/5.0 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', '/?ocdgx', '207.46.13.159', '1656627807', '0');
INSERT INTO `ey_weapp_spider_visit` VALUES ('1001584', '6', 'mozilla/5.0 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', '/?comid=596247', '40.77.167.16', '1656628516', '0');
INSERT INTO `ey_weapp_spider_visit` VALUES ('1001589', '99', 'mozilla/5.0 (compatible; semrushbot/7~bl; +http://www.semrush.com/bot.html)', '/?NE0sx', '185.191.171.19', '1656628594', '0');
INSERT INTO `ey_weapp_spider_visit` VALUES ('1001944', '1', 'mozilla/5.0 (linux; android 6.0.1; nexus 5x build/mmb29p) applewebkit/537.36 (khtml, like gecko) chrome/103.0.5060.53 mobile safari/537.36 (compatible; googlebot/2.1; +http://www.google.com/bot.html)', '/xxzl/1728.html', '66.249.75.37', '1656638492', '0');
INSERT INTO `ey_weapp_spider_visit` VALUES ('998468', '99', 'mozilla/5.0 (compatible; blexbot/1.0; +http://webmeup-crawler.com/)', '/ckdy/1428.html', '116.202.128.228', '1656588501', '0');
INSERT INTO `ey_weapp_spider_visit` VALUES ('1001947', '1', 'mozilla/5.0 (linux; android 6.0.1; nexus 5x build/mmb29p) applewebkit/537.36 (khtml, like gecko) chrome/103.0.5060.53 mobile safari/537.36 (compatible; googlebot/2.1; +http://www.google.com/bot.html)', '/gdds/829.html', '66.249.75.37', '1656638539', '0');
INSERT INTO `ey_weapp_spider_visit` VALUES ('1000451', '1', 'mozilla/5.0 (linux; android 6.0.1; nexus 5x build/mmb29p) applewebkit/537.36 (khtml, like gecko) chrome/103.0.5060.53 mobile safari/537.36 (compatible; googlebot/2.1; +http://www.google.com/bot.html)', '/ckdy/5819.html', '66.249.75.37', '1656595576', '0');
INSERT INTO `ey_weapp_spider_visit` VALUES ('1000483', '1', 'mozilla/5.0 (linux; android 6.0.1; nexus 5x build/mmb29p) applewebkit/537.36 (khtml, like gecko) chrome/103.0.5060.53 mobile safari/537.36 (compatible; googlebot/2.1; +http://www.google.com/bot.html)', '/gdds/4386.html', '66.249.75.34', '1656596102', '0');
INSERT INTO `ey_weapp_spider_visit` VALUES ('1000474', '1', 'mozilla/5.0 (linux; android 6.0.1; nexus 5x build/mmb29p) applewebkit/537.36 (khtml, like gecko) chrome/103.0.5060.53 mobile safari/537.36 (compatible; googlebot/2.1; +http://www.google.com/bot.html)', '/gdds/5180.html', '66.249.75.34', '1656595970', '0');
INSERT INTO `ey_weapp_spider_visit` VALUES ('1000475', '6', 'mozilla/5.0 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', '/?comid=379204', '157.55.39.106', '1656595979', '0');
INSERT INTO `ey_weapp_spider_visit` VALUES ('1000494', '99', 'mozilla/5.0 (compatible; semrushbot/7~bl; +http://www.semrush.com/bot.html)', '/gdds/4423.html', '185.191.171.40', '1656596254', '0');
INSERT INTO `ey_weapp_spider_visit` VALUES ('1000505', '99', 'mozilla/5.0 (compatible; semrushbot/7~bl; +http://www.semrush.com/bot.html)', '/?9Bv4g', '185.191.171.34', '1656596524', '0');
INSERT INTO `ey_weapp_spider_visit` VALUES ('1000747', '99', 'mozilla/5.0 (compatible; semrushbot/7~bl; +http://www.semrush.com/bot.html)', '/gdds/5422.html', '185.191.171.4', '1656604711', '0');
INSERT INTO `ey_weapp_spider_visit` VALUES ('1000766', '99', 'mozilla/5.0 (compatible; semrushbot/7~bl; +http://www.semrush.com/bot.html)', '/jyqj/1214.html', '185.191.171.8', '1656605553', '0');
INSERT INTO `ey_weapp_spider_visit` VALUES ('1000754', '99', 'mozilla/5.0 (compatible; semrushbot/7~bl; +http://www.semrush.com/bot.html)', '/?U8y87', '185.191.171.36', '1656605082', '0');
INSERT INTO `ey_weapp_spider_visit` VALUES ('1000759', '99', 'mozilla/5.0 (compatible; semrushbot/7~bl; +http://www.semrush.com/bot.html)', '/ckdy/5862.html', '185.191.171.2', '1656605231', '0');
INSERT INTO `ey_weapp_spider_visit` VALUES ('1000762', '6', 'mozilla/5.0 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', '/', '157.55.39.106', '1656605414', '0');
INSERT INTO `ey_weapp_spider_visit` VALUES ('1000710', '6', 'mozilla/5.0 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', '/ckdy/2628.html', '207.46.13.7', '1656603347', '0');
INSERT INTO `ey_weapp_spider_visit` VALUES ('1000733', '99', 'mozilla/5.0 (linux; android 7.0;) applewebkit/537.36 (khtml, like gecko) mobile safari/537.36 (compatible; petalbot;+https://webmaster.petalsearch.com/site/petalbot)', '/ckdy/1293.html', '114.119.153.160', '1656604196', '0');
INSERT INTO `ey_weapp_spider_visit` VALUES ('1000729', '99', 'mozilla/5.0 (compatible; semrushbot/7~bl; +http://www.semrush.com/bot.html)', '/?eWbC5', '185.191.171.5', '1656603821', '0');
INSERT INTO `ey_weapp_spider_visit` VALUES ('1000723', '99', 'mozilla/5.0 (compatible; semrushbot/7~bl; +http://www.semrush.com/bot.html)', '/ckdy/2093.html', '185.191.171.22', '1656603717', '0');
INSERT INTO `ey_weapp_spider_visit` VALUES ('1000724', '99', 'mozilla/5.0 (compatible; semrushbot/7~bl; +http://www.semrush.com/bot.html)', '/bylw/3019.html', '185.191.171.9', '1656603740', '0');
INSERT INTO `ey_weapp_spider_visit` VALUES ('1000500', '99', 'mozilla/5.0 (compatible; semrushbot/7~bl; +http://www.semrush.com/bot.html)', '/ckdy/3438.html', '185.191.171.23', '1656596434', '0');
INSERT INTO `ey_weapp_spider_visit` VALUES ('1000499', '99', 'mozilla/5.0 (compatible; semrushbot/7~bl; +http://www.semrush.com/bot.html)', '/?XF0Wl', '185.191.171.10', '1656596416', '0');
INSERT INTO `ey_weapp_spider_visit` VALUES ('1000485', '99', 'mozilla/5.0 (compatible; semrushbot/7~bl; +http://www.semrush.com/bot.html)', '/?DXssT', '185.191.171.33', '1656596115', '0');
INSERT INTO `ey_weapp_spider_visit` VALUES ('1000508', '6', 'mozilla/5.0 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', '/?0=show&amp;id=544747', '207.46.13.159', '1656596724', '0');
INSERT INTO `ey_weapp_spider_visit` VALUES ('1000773', '99', 'mozilla/5.0 (compatible; semrushbot/7~bl; +http://www.semrush.com/bot.html)', '/?OuEqU', '185.191.171.7', '1656605654', '0');
INSERT INTO `ey_weapp_spider_visit` VALUES ('1000791', '99', 'mozilla/5.0 (compatible; semrushbot/7~bl; +http://www.semrush.com/bot.html)', '/ckdy/3974.html', '185.191.171.9', '1656606282', '0');
INSERT INTO `ey_weapp_spider_visit` VALUES ('1000793', '99', 'mozilla/5.0 (compatible; semrushbot/7~bl; +http://www.semrush.com/bot.html)', '/ckdy/2557.html', '185.191.171.38', '1656606388', '0');
INSERT INTO `ey_weapp_spider_visit` VALUES ('1000697', '99', 'mozilla/5.0 (compatible; semrushbot/7~bl; +http://www.semrush.com/bot.html)', '/gdds/4253.html', '185.191.171.16', '1656602973', '0');
INSERT INTO `ey_weapp_spider_visit` VALUES ('1000738', '6', 'mozilla/5.0 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', '/?n9audh-262577.html', '40.77.167.68', '1656604382', '0');
INSERT INTO `ey_weapp_spider_visit` VALUES ('1000755', '99', 'mozilla/5.0 (compatible; semrushbot/7~bl; +http://www.semrush.com/bot.html)', '/?hou8n', '185.191.171.4', '1656605113', '0');
INSERT INTO `ey_weapp_spider_visit` VALUES ('1000756', '4', 'mozilla/5.0 (windows nt 6.1; wow64) applewebkit/537.36 (khtml, like gecko) chrome/50.0.2661.102 safari/537.36; 360spider', '/', '180.163.220.60', '1656605147', '0');
INSERT INTO `ey_weapp_spider_visit` VALUES ('1000745', '99', 'mozilla/5.0 (linux; android 7.0;) applewebkit/537.36 (khtml, like gecko) mobile safari/537.36 (compatible; petalbot;+https://webmaster.petalsearch.com/site/petalbot)', '/ckdy/3925.html', '114.119.153.171', '1656604651', '0');
INSERT INTO `ey_weapp_spider_visit` VALUES ('1000749', '1', 'mozilla/5.0 (compatible; googlebot/2.1; +http://www.google.com/bot.html)', '/ckdy/1532.html', '66.249.75.34', '1656604729', '0');
INSERT INTO `ey_weapp_spider_visit` VALUES ('1000525', '6', 'mozilla/5.0 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', '/?comid=782853', '207.46.13.7', '1656597396', '0');
INSERT INTO `ey_weapp_spider_visit` VALUES ('1000528', '6', 'mozilla/5.0 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', '/?news427105.html', '207.46.13.7', '1656597447', '0');
INSERT INTO `ey_weapp_spider_visit` VALUES ('1000767', '99', 'mozilla/5.0 (linux; android 7.0;) applewebkit/537.36 (khtml, like gecko) mobile safari/537.36 (compatible; petalbot;+https://webmaster.petalsearch.com/site/petalbot)', '/gdds/1012.html', '114.119.153.160', '1656605568', '0');
INSERT INTO `ey_weapp_spider_visit` VALUES ('1000770', '99', 'mozilla/5.0 (compatible; semrushbot/7~bl; +http://www.semrush.com/bot.html)', '/?J5Z9J', '185.191.171.24', '1656605607', '0');
INSERT INTO `ey_weapp_spider_visit` VALUES ('1001115', '1', 'mozilla/5.0 (linux; android 6.0.1; nexus 5x build/mmb29p) applewebkit/537.36 (khtml, like gecko) chrome/103.0.5060.53 mobile safari/537.36 (compatible; googlebot/2.1; +http://www.google.com/bot.html)', '/ckyx/756.html', '66.249.75.34', '1656617493', '0');
INSERT INTO `ey_weapp_spider_visit` VALUES ('1001119', '99', 'mozilla/5.0 (compatible; semrushbot/7~bl; +http://www.semrush.com/bot.html)', '/gdds/4936.html', '185.191.171.34', '1656617578', '0');
INSERT INTO `ey_weapp_spider_visit` VALUES ('1001124', '99', 'mozilla/5.0 (compatible; semrushbot/7~bl; +http://www.semrush.com/bot.html)', '/ckdy/2063.html', '185.191.171.15', '1656617640', '0');
INSERT INTO `ey_weapp_spider_visit` VALUES ('1001133', '99', 'mozilla/5.0 (linux; android 7.0;) applewebkit/537.36 (khtml, like gecko) mobile safari/537.36 (compatible; petalbot;+https://webmaster.petalsearch.com/site/petalbot)', '/ckdy/3916.html', '114.119.153.191', '1656618015', '0');
INSERT INTO `ey_weapp_spider_visit` VALUES ('1000576', '99', 'mozilla/5.0 (compatible; semrushbot/7~bl; +http://www.semrush.com/bot.html)', '/gdds/5004.html', '185.191.171.14', '1656598921', '0');
INSERT INTO `ey_weapp_spider_visit` VALUES ('1000593', '3', 'sogou web spider/4.0(+http://www.sogou.com/docs/help/webmasters.htm#07)', '/zbdt/2749.html', '58.250.125.154', '1656599558', '0');
INSERT INTO `ey_weapp_spider_visit` VALUES ('1000573', '6', 'mozilla/5.0 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', '/?comid=319964', '207.46.13.159', '1656598809', '0');
INSERT INTO `ey_weapp_spider_visit` VALUES ('1000583', '99', 'mozilla/5.0 (compatible; semrushbot/7~bl; +http://www.semrush.com/bot.html)', '/xxzl/1763.html', '185.191.171.38', '1656599217', '0');
INSERT INTO `ey_weapp_spider_visit` VALUES ('998579', '99', 'mozilla/5.0 (compatible; blexbot/1.0; +http://webmeup-crawler.com/)', '/ckdy/1274.html', '116.202.128.228', '1656588633', '0');
INSERT INTO `ey_weapp_spider_visit` VALUES ('998588', '99', 'mozilla/5.0 (compatible; blexbot/1.0; +http://webmeup-crawler.com/)', '/ckdy/1278.html', '116.202.128.228', '1656588644', '0');
INSERT INTO `ey_weapp_spider_visit` VALUES ('998612', '99', 'mozilla/5.0 (compatible; blexbot/1.0; +http://webmeup-crawler.com/)', '/gdds/1013.html', '116.202.128.228', '1656588674', '0');
INSERT INTO `ey_weapp_spider_visit` VALUES ('998619', '99', 'mozilla/5.0 (compatible; blexbot/1.0; +http://webmeup-crawler.com/)', '/gdds/1018.html', '116.202.128.228', '1656588691', '0');
INSERT INTO `ey_weapp_spider_visit` VALUES ('998623', '99', 'mozilla/5.0 (compatible; blexbot/1.0; +http://webmeup-crawler.com/)', '/gdds/1034.html', '116.202.128.228', '1656588710', '0');
INSERT INTO `ey_weapp_spider_visit` VALUES ('998624', '99', 'mozilla/5.0 (compatible; blexbot/1.0; +http://webmeup-crawler.com/)', '/gdds/1035.html', '116.202.128.228', '1656588714', '0');
INSERT INTO `ey_weapp_spider_visit` VALUES ('1001383', '99', 'mozilla/5.0 (compatible; semrushbot/7~bl; +http://www.semrush.com/bot.html)', '/?HKjoZ', '185.191.171.5', '1656623962', '0');
INSERT INTO `ey_weapp_spider_visit` VALUES ('998737', '99', 'mozilla/5.0 (compatible; blexbot/1.0; +http://webmeup-crawler.com/)', '/ckdy/1352.html', '116.202.128.228', '1656588883', '0');
INSERT INTO `ey_weapp_spider_visit` VALUES ('998743', '99', 'mozilla/5.0 (compatible; blexbot/1.0; +http://webmeup-crawler.com/)', '/ckdy/1354.html', '116.202.128.228', '1656588890', '0');
INSERT INTO `ey_weapp_spider_visit` VALUES ('998747', '99', 'mozilla/5.0 (compatible; semrushbot/7~bl; +http://www.semrush.com/bot.html)', '/gdds/4741.html', '185.191.171.4', '1656588894', '0');
INSERT INTO `ey_weapp_spider_visit` VALUES ('998394', '99', 'mozilla/5.0 (compatible; blexbot/1.0; +http://webmeup-crawler.com/)', '/bylw/3011.html', '116.202.128.228', '1656588401', '0');
INSERT INTO `ey_weapp_spider_visit` VALUES ('1000518', '99', 'mozilla/5.0 (compatible; semrushbot/7~bl; +http://www.semrush.com/bot.html)', '/jyqj/1963.html', '185.191.171.26', '1656597153', '0');
INSERT INTO `ey_weapp_spider_visit` VALUES ('1000521', '6', 'mozilla/5.0 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', '/?tq76un-737232.html', '157.55.39.63', '1656597236', '0');
INSERT INTO `ey_weapp_spider_visit` VALUES ('1000524', '99', 'mozilla/5.0 (compatible; semrushbot/7~bl; +http://www.semrush.com/bot.html)', '/?Liiwd', '185.191.171.33', '1656597366', '0');
INSERT INTO `ey_weapp_spider_visit` VALUES ('1000539', '99', 'mozilla/5.0 (compatible; semrushbot/7~bl; +http://www.semrush.com/bot.html)', '/bylw/863.html', '185.191.171.15', '1656597751', '0');
INSERT INTO `ey_weapp_spider_visit` VALUES ('1000543', '2', 'mozilla/5.0 (compatible; baiduspider/2.0; +http://www.baidu.com/search/spider.html)', '/ckdy/', '220.181.108.82', '1656597834', '0');
INSERT INTO `ey_weapp_spider_visit` VALUES ('1000548', '6', 'mozilla/5.0 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', '/?comid=761469', '157.55.39.63', '1656597946', '0');
INSERT INTO `ey_weapp_spider_visit` VALUES ('1000541', '99', 'mozilla/5.0 (linux; android 7.0;) applewebkit/537.36 (khtml, like gecko) mobile safari/537.36 (compatible; petalbot;+https://webmaster.petalsearch.com/site/petalbot)', '/xxzl/1701.html', '114.119.153.186', '1656597815', '0');
INSERT INTO `ey_weapp_spider_visit` VALUES ('1000547', '99', 'mozilla/5.0 (compatible; semrushbot/7~bl; +http://www.semrush.com/bot.html)', '/gdds/4352.html', '185.191.171.37', '1656597926', '0');
INSERT INTO `ey_weapp_spider_visit` VALUES ('1000540', '6', 'mozilla/5.0 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', '/?pc3590-397664.html', '40.77.167.16', '1656597806', '0');
INSERT INTO `ey_weapp_spider_visit` VALUES ('999266', '99', 'mozilla/5.0 (compatible; blexbot/1.0; +http://webmeup-crawler.com/)', '/gdds/5174.html', '116.202.128.228', '1656590013', '0');
INSERT INTO `ey_weapp_spider_visit` VALUES ('999274', '99', 'mozilla/5.0 (compatible; blexbot/1.0; +http://webmeup-crawler.com/)', '/gdds/5186.html', '116.202.128.228', '1656590044', '0');
INSERT INTO `ey_weapp_spider_visit` VALUES ('999268', '99', 'mozilla/5.0 (compatible; blexbot/1.0; +http://webmeup-crawler.com/)', '/gdds/5177.html', '116.202.128.228', '1656590024', '0');
INSERT INTO `ey_weapp_spider_visit` VALUES ('999264', '1', 'mozilla/5.0 (linux; android 6.0.1; nexus 5x build/mmb29p) applewebkit/537.36 (khtml, like gecko) chrome/103.0.5060.53 mobile safari/537.36 (compatible; googlebot/2.1; +http://www.google.com/bot.html)', '/gdds/5632.html', '66.249.75.40', '1656590006', '0');
INSERT INTO `ey_weapp_spider_visit` VALUES ('999278', '99', 'mozilla/5.0 (compatible; blexbot/1.0; +http://webmeup-crawler.com/)', '/gdds/5189.html', '116.202.128.228', '1656590059', '0');
INSERT INTO `ey_weapp_spider_visit` VALUES ('999280', '99', 'mozilla/5.0 (compatible; blexbot/1.0; +http://webmeup-crawler.com/)', '/gdds/5190.html', '116.202.128.228', '1656590064', '0');
INSERT INTO `ey_weapp_spider_visit` VALUES ('999438', '99', 'mozilla/5.0 (compatible; blexbot/1.0; +http://webmeup-crawler.com/)', '/gdds/5420.html', '116.202.128.228', '1656590565', '0');
INSERT INTO `ey_weapp_spider_visit` VALUES ('999443', '99', 'mozilla/5.0 (compatible; blexbot/1.0; +http://webmeup-crawler.com/)', '/gdds/5424.html', '116.202.128.228', '1656590582', '0');
INSERT INTO `ey_weapp_spider_visit` VALUES ('999444', '99', 'mozilla/5.0 (compatible; blexbot/1.0; +http://webmeup-crawler.com/)', '/gdds/5425.html', '116.202.128.228', '1656590587', '0');
INSERT INTO `ey_weapp_spider_visit` VALUES ('999446', '99', 'mozilla/5.0 (compatible; blexbot/1.0; +http://webmeup-crawler.com/)', '/gdds/5431.html', '116.202.128.228', '1656590595', '0');
INSERT INTO `ey_weapp_spider_visit` VALUES ('998311', '99', 'mozilla/5.0 (linux; android 7.0;) applewebkit/537.36 (khtml, like gecko) mobile safari/537.36 (compatible; petalbot;+https://webmaster.petalsearch.com/site/petalbot)', '/ckdy/1136.html', '114.119.153.188', '1656587059', '0');
INSERT INTO `ey_weapp_spider_visit` VALUES ('998313', '99', 'mozilla/5.0 (compatible; semrushbot/7~bl; +http://www.semrush.com/bot.html)', '/?joSXa', '185.191.171.41', '1656587096', '0');
INSERT INTO `ey_weapp_spider_visit` VALUES ('998321', '99', 'mozilla/5.0 (compatible; semrushbot/7~bl; +http://www.semrush.com/bot.html)', '/?Iblsq', '185.191.171.9', '1656587324', '0');
INSERT INTO `ey_weapp_spider_visit` VALUES ('998323', '6', 'mozilla/5.0 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', '/?comid=679134', '207.46.13.159', '1656587435', '0');
INSERT INTO `ey_weapp_spider_visit` VALUES ('998361', '99', 'mozilla/5.0 (compatible; blexbot/1.0; +http://webmeup-crawler.com/)', '/bylw/2509.html', '116.202.128.228', '1656588359', '0');
INSERT INTO `ey_weapp_spider_visit` VALUES ('1001082', '1', 'mozilla/5.0 (linux; android 6.0.1; nexus 5x build/mmb29p) applewebkit/537.36 (khtml, like gecko) chrome/103.0.5060.53 mobile safari/537.36 (compatible; googlebot/2.1; +http://www.google.com/bot.html)', '/gdds/5421.html', '66.249.75.37', '1656616820', '0');
INSERT INTO `ey_weapp_spider_visit` VALUES ('1001088', '1', 'mozilla/5.0 (linux; android 6.0.1; nexus 5x build/mmb29p) applewebkit/537.36 (khtml, like gecko) chrome/103.0.5060.53 mobile safari/537.36 (compatible; googlebot/2.1; +http://www.google.com/bot.html)', '/zbtd/1675.html', '66.249.75.34', '1656616948', '0');
INSERT INTO `ey_weapp_spider_visit` VALUES ('1001098', '1', 'mozilla/5.0 (linux; android 6.0.1; nexus 5x build/mmb29p) applewebkit/537.36 (khtml, like gecko) chrome/103.0.5060.53 mobile safari/537.36 (compatible; googlebot/2.1; +http://www.google.com/bot.html)', '/lnzt/936.html', '66.249.75.34', '1656617141', '0');
INSERT INTO `ey_weapp_spider_visit` VALUES ('1001092', '99', 'mozilla/5.0 (compatible; semrushbot/7~bl; +http://www.semrush.com/bot.html)', '/?tml7R', '185.191.171.15', '1656617035', '0');
INSERT INTO `ey_weapp_spider_visit` VALUES ('1001099', '3', 'sogou web spider/4.0(+http://www.sogou.com/docs/help/webmasters.htm#07)', '/jyqj/3602.html', '49.7.20.138', '1656617153', '0');
INSERT INTO `ey_weapp_spider_visit` VALUES ('1001096', '99', 'mozilla/5.0 (linux; android 7.0;) applewebkit/537.36 (khtml, like gecko) mobile safari/537.36 (compatible; petalbot;+https://webmaster.petalsearch.com/site/petalbot)', '/ckdy/1362.html', '114.119.153.191', '1656617058', '0');
INSERT INTO `ey_weapp_spider_visit` VALUES ('1001097', '6', 'mozilla/5.0 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', '/?ahbqj', '40.77.167.16', '1656617127', '0');
INSERT INTO `ey_weapp_spider_visit` VALUES ('1001273', '99', 'mozilla/5.0 (compatible; semrushbot/7~bl; +http://www.semrush.com/bot.html)', '/?lFG13', '185.191.171.44', '1656621486', '0');
INSERT INTO `ey_weapp_spider_visit` VALUES ('1001241', '6', 'mozilla/5.0 (compatible; 