-- ----------------------------------------
-- EyouCms MySQL Data Transfer 
-- 
-- Server         : 127.0.0.1_3306
-- Server Version : 5.7.26
-- Host           : 127.0.0.1:3306
-- Database       : c6
-- 
-- Part : #1
-- Version : #v1.6.7
-- Date : 2024-07-18 09:08:23
-- -----------------------------------------

SET FOREIGN_KEY_CHECKS = 0;


-- -----------------------------
-- Table structure for `ey_ad`
-- -----------------------------
DROP TABLE IF EXISTS `ey_ad`;
CREATE TABLE `ey_ad` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '广告id',
  `pid` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '广告位置ID',
  `media_type` tinyint(1) DEFAULT '0' COMMENT '广告类型',
  `title` varchar(60) DEFAULT '' COMMENT '广告名称',
  `links` varchar(255) DEFAULT '' COMMENT '广告链接',
  `litpic` varchar(255) DEFAULT '' COMMENT '图片地址',
  `start_time` int(11) DEFAULT '0' COMMENT '投放时间',
  `end_time` int(11) DEFAULT '0' COMMENT '结束时间',
  `intro` text COMMENT '描述',
  `link_man` varchar(60) DEFAULT '' COMMENT '添加人',
  `link_email` varchar(60) DEFAULT '' COMMENT '添加人邮箱',
  `link_phone` varchar(60) DEFAULT '' COMMENT '添加人联系电话',
  `click` int(11) DEFAULT '0' COMMENT '点击量',
  `bgcolor` varchar(30) DEFAULT '' COMMENT '背景颜色',
  `status` tinyint(1) unsigned DEFAULT '1' COMMENT '1=显示，0=屏蔽',
  `sort_order` int(11) DEFAULT '0' COMMENT '排序',
  `target` varchar(50) DEFAULT '' COMMENT '是否开启浏览器新窗口',
  `admin_id` int(10) DEFAULT '0' COMMENT '管理员ID',
  `is_del` tinyint(1) DEFAULT '0' COMMENT '伪删除，1=是，0=否',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '多语言',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`),
  KEY `position_id` (`pid`) USING BTREE,
  KEY `status` (`status`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=19 DEFAULT CHARSET=utf8 COMMENT='广告表';

-- -----------------------------
-- Records of `ey_ad`
-- -----------------------------
INSERT INTO `ey_ad` VALUES ('1', '1', '1', '', '', '/eyou/uploads/allimg/161108/1-16110Q422380-L.jpg', '0', '0', '', '', '', '', '0', '', '1', '1', '0', '1', '0', 'cn', '1649642885', '1649642885');
INSERT INTO `ey_ad` VALUES ('2', '2', '1', 'en', '', '/eyou/uploads/allimg/161108/1-16110Q422380-L.jpg', '0', '0', '', '', '', '', '0', '', '1', '1', '0', '1', '0', 'en', '1649642885', '1649673015');
INSERT INTO `ey_ad` VALUES ('3', '1', '1', '', '', '/eyou/uploads/allimg/161108/1-16110Q422500-L.jpg', '0', '0', '', '', '', '', '0', '', '1', '2', '0', '1', '0', 'cn', '1649642885', '1649642885');
INSERT INTO `ey_ad` VALUES ('4', '2', '1', 'en', '', '/eyou/uploads/allimg/161108/1-16110Q422500-L.jpg', '0', '0', '', '', '', '', '0', '', '1', '2', '0', '1', '0', 'en', '1649642885', '1649673015');
INSERT INTO `ey_ad` VALUES ('5', '3', '1', '', '', '/eyou/uploads/161110/1-161110101235226.jpg', '0', '0', '', '', '', '', '0', '', '1', '1', '0', '1', '0', 'cn', '1649645330', '1649645330');
INSERT INTO `ey_ad` VALUES ('6', '4', '1', 'en', '', '/eyou/uploads/161110/1-161110101235226.jpg', '0', '0', '', '', '', '', '0', '', '1', '1', '0', '1', '0', 'en', '1649645330', '1649673005');
INSERT INTO `ey_ad` VALUES ('7', '3', '1', '', '', '/eyou/uploads/161110/1-1611101012593I.jpg', '0', '0', '', '', '', '', '0', '', '1', '2', '0', '1', '0', 'cn', '1649645330', '1649645330');
INSERT INTO `ey_ad` VALUES ('8', '4', '1', 'en', '', '/eyou/uploads/161110/1-1611101012593I.jpg', '0', '0', '', '', '', '', '0', '', '1', '2', '0', '1', '0', 'en', '1649645330', '1649673005');
INSERT INTO `ey_ad` VALUES ('9', '3', '1', '', '', '/eyou/uploads/161110/1-16111010131U49.jpg', '0', '0', '', '', '', '', '0', '', '1', '3', '0', '1', '0', 'cn', '1649645330', '1649645330');
INSERT INTO `ey_ad` VALUES ('10', '4', '1', 'en', '', '/eyou/uploads/161110/1-16111010131U49.jpg', '0', '0', '', '', '', '', '0', '', '1', '3', '0', '1', '0', 'en', '1649645330', '1649673005');
INSERT INTO `ey_ad` VALUES ('11', '3', '1', '', '', '/eyou/uploads/allimg/161110/1-1611101013360-L.jpg', '0', '0', '', '', '', '', '0', '', '1', '4', '0', '1', '0', 'cn', '1649645330', '1649645330');
INSERT INTO `ey_ad` VALUES ('12', '4', '1', 'en', '', '/eyou/uploads/allimg/161110/1-1611101013360-L.jpg', '0', '0', '', '', '', '', '0', '', '1', '4', '0', '1', '0', 'en', '1649645330', '1649673005');
INSERT INTO `ey_ad` VALUES ('13', '3', '1', '', '', '/eyou/uploads/allimg/161110/1-1611101013520-L.jpg', '0', '0', '', '', '', '', '0', '', '1', '5', '0', '1', '0', 'cn', '1649645330', '1649645330');
INSERT INTO `ey_ad` VALUES ('14', '4', '1', 'en', '', '/eyou/uploads/allimg/161110/1-1611101013520-L.jpg', '0', '0', '', '', '', '', '0', '', '1', '5', '0', '1', '0', 'en', '1649645330', '1649673005');
INSERT INTO `ey_ad` VALUES ('15', '3', '1', '', '', '/eyou/uploads/allimg/161110/1-1611101014080-L.jpg', '0', '0', '', '', '', '', '0', '', '1', '6', '0', '1', '0', 'cn', '1649645330', '1649645330');
INSERT INTO `ey_ad` VALUES ('16', '4', '1', 'en', '', '/eyou/uploads/allimg/161110/1-1611101014080-L.jpg', '0', '0', '', '', '', '', '0', '', '1', '6', '0', '1', '0', 'en', '1649645330', '1649673005');
INSERT INTO `ey_ad` VALUES ('17', '5', '1', '', '', '/eyou/uploads/allimg/20220411/1-220411105201X8.jpg', '0', '0', '', '', '', '', '0', '', '1', '1', '0', '1', '0', 'cn', '1649645524', '1649645524');
INSERT INTO `ey_ad` VALUES ('18', '6', '1', 'en', '', '/eyou/uploads/allimg/20220411/1-220411105201X8.jpg', '0', '0', '', '', '', '', '0', '', '1', '1', '0', '1', '0', 'en', '1649645524', '1649672993');

-- -----------------------------
-- Table structure for `ey_ad_position`
-- -----------------------------
DROP TABLE IF EXISTS `ey_ad_position`;
CREATE TABLE `ey_ad_position` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(60) NOT NULL DEFAULT '' COMMENT '广告位置名称',
  `type` tinyint(1) NOT NULL DEFAULT '1' COMMENT '广告展示类型，1图片类型，2媒体类型，3HTML代码',
  `width` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT '广告位宽度',
  `height` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT '广告位高度',
  `intro` text NOT NULL COMMENT '广告描述',
  `status` tinyint(1) NOT NULL DEFAULT '1' COMMENT '0关闭1开启',
  `lang` varchar(50) NOT NULL DEFAULT 'cn' COMMENT '多语言',
  `admin_id` int(10) NOT NULL DEFAULT '0' COMMENT '管理员ID',
  `is_del` tinyint(1) NOT NULL DEFAULT '0' COMMENT '伪删除，1=是，0=否',
  `add_time` int(11) NOT NULL DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=7 DEFAULT CHARSET=utf8 COMMENT='广告位置表';

-- -----------------------------
-- Records of `ey_ad_position`
-- -----------------------------
INSERT INTO `ey_ad_position` VALUES ('1', 'PC端首页幻灯', '1', '0', '0', '', '1', 'cn', '1', '0', '1649642885', '1649642885');
INSERT INTO `ey_ad_position` VALUES ('2', '英文PC端首页幻灯', '1', '0', '0', '', '1', 'en', '1', '0', '1649642885', '1649673015');
INSERT INTO `ey_ad_position` VALUES ('3', 'PC端首页产品优势大图', '1', '0', '0', '', '1', 'cn', '1', '0', '1649645330', '1649645330');
INSERT INTO `ey_ad_position` VALUES ('4', '英文PC端首页产品优势大图', '1', '0', '0', '', '1', 'en', '1', '0', '1649645330', '1649673005');
INSERT INTO `ey_ad_position` VALUES ('5', '首页关于我们大图', '1', '0', '0', '', '1', 'cn', '1', '0', '1649645524', '1649645524');
INSERT INTO `ey_ad_position` VALUES ('6', '英文首页关于我们大图', '1', '0', '0', '', '1', 'en', '1', '0', '1649645524', '1649672993');

-- -----------------------------
-- Table structure for `ey_addon17_content`
-- -----------------------------
DROP TABLE IF EXISTS `ey_addon17_content`;
CREATE TABLE `ey_addon17_content` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `aid` int(10) DEFAULT '0' COMMENT '文档ID',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  `zw` varchar(251) NOT NULL DEFAULT '' COMMENT '职位名称',
  `lx` varchar(251) NOT NULL DEFAULT '' COMMENT '职位类型',
  `jy` varchar(251) NOT NULL DEFAULT '' COMMENT '工作经验',
  `xl` varchar(251) NOT NULL DEFAULT '' COMMENT '学历要求',
  `rs` varchar(251) NOT NULL DEFAULT '' COMMENT '招聘人数',
  `ms` longtext COMMENT '工作描述',
  PRIMARY KEY (`id`),
  KEY `aid` (`aid`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=7 DEFAULT CHARSET=utf8 COMMENT='附加表';

-- -----------------------------
-- Records of `ey_addon17_content`
-- -----------------------------
INSERT INTO `ey_addon17_content` VALUES ('1', '3', '1634518497', '1634518497', '采购', '全职', '3年以上', '高中', '1', '本公司招聘采购一名，负责采购业务。');
INSERT INTO `ey_addon17_content` VALUES ('2', '70', '1634518497', '1634518497', '助理', '全职', '无经验', '本科', '1', '本公司招聘助理一名，负责经理助理事宜。');
INSERT INTO `ey_addon17_content` VALUES ('3', '71', '1634518497', '1634518497', '销售工程师', '全职', '无经验', '高中', '1', '本公司招聘销售工程师一名，负责国销售业务。');
INSERT INTO `ey_addon17_content` VALUES ('4', '72', '1634518497', '1634518497', '销售工程师', '全职', '1年以上', '大专', '10', '本公司招聘销售工程师一名，负责国销售业务。');
INSERT INTO `ey_addon17_content` VALUES ('5', '73', '1634518497', '1634518497', '销售工程师', '全职', '3年以上', '本科', '1', '本公司招聘销售工程师一名，负责国销售业务。');
INSERT INTO `ey_addon17_content` VALUES ('6', '74', '1634518497', '1634518497', '塑化部活性炭销售', '全职', '3年以上', '本科', '5', '本公司招聘活性炭销售一名，负责国内卡博特NORIT活性炭销售业务。');

-- -----------------------------
-- Table structure for `ey_admin`
-- -----------------------------
DROP TABLE IF EXISTS `ey_admin`;
CREATE TABLE `ey_admin` (
  `admin_id` smallint(5) unsigned NOT NULL AUTO_INCREMENT COMMENT '用户id',
  `user_name` varchar(20) NOT NULL DEFAULT '' COMMENT '用户名',
  `pen_name` varchar(50) DEFAULT '' COMMENT '笔名（发布文章后显示责任编辑的名字）',
  `true_name` varchar(20) DEFAULT '' COMMENT '真实姓名',
  `mobile` varchar(11) DEFAULT '' COMMENT '手机号码',
  `email` varchar(60) DEFAULT '' COMMENT 'email',
  `password` varchar(255) NOT NULL DEFAULT '' COMMENT '密码',
  `head_pic` varchar(255) DEFAULT '' COMMENT '头像',
  `last_login` int(11) DEFAULT '0' COMMENT '最后登录时间',
  `last_ip` varchar(15) DEFAULT '' COMMENT '最后登录ip',
  `login_cnt` int(11) DEFAULT '0' COMMENT '登录次数',
  `session_id` varchar(50) DEFAULT '' COMMENT 'session_id',
  `parent_id` int(10) DEFAULT '0' COMMENT '父管理员ID',
  `role_id` int(10) NOT NULL DEFAULT '-1' COMMENT '角色组ID（-1表示超级管理员）',
  `mark_lang` varchar(50) DEFAULT 'cn' COMMENT '当前语言标识',
  `status` tinyint(1) DEFAULT '1' COMMENT '状态(0=屏蔽，1=正常)',
  `syn_users_id` int(10) DEFAULT '0' COMMENT '同步注册到会员表',
  `desc` varchar(500) DEFAULT '' COMMENT '工作内容',
  `wechat_appid` varchar(50) DEFAULT '' COMMENT '公众号appid',
  `wechat_followed` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '记录是否关注了微信公众号，默认0；0=未关注、1=已关注',
  `wechat_open_id` varchar(50) NOT NULL DEFAULT '' COMMENT 'open_id，关注微信公众号后存入',
  `union_id` varchar(50) DEFAULT '' COMMENT '微信用户的unionId',
  `add_time` int(11) DEFAULT '0' COMMENT '添加时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`admin_id`),
  KEY `user_name` (`user_name`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COMMENT='管理员表';

-- -----------------------------
-- Records of `ey_admin`
-- -----------------------------
INSERT INTO `ey_admin` VALUES ('1', 'admin', '', 'admin', '', '', 'abc6c098e614e07de84f88a10edf7c5e', '', '1721264809', '127.0.0.1', '2', 'luis0dasi67lmtbqr4bmvb0vdj', '0', '-1', 'cn', '1', '0', '', '', '0', '', '', '1721264799', '0');

-- -----------------------------
-- Table structure for `ey_admin_log`
-- -----------------------------
DROP TABLE IF EXISTS `ey_admin_log`;
CREATE TABLE `ey_admin_log` (
  `log_id` bigint(16) unsigned NOT NULL AUTO_INCREMENT COMMENT '表id',
  `admin_id` int(10) NOT NULL DEFAULT '-1' COMMENT '管理员id',
  `log_info` text COMMENT '日志描述',
  `log_ip` varchar(30) DEFAULT '' COMMENT 'ip地址',
  `log_url` varchar(255) DEFAULT '' COMMENT 'url',
  `log_time` int(11) DEFAULT '0' COMMENT '日志时间',
  PRIMARY KEY (`log_id`),
  KEY `admin_id` (`admin_id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=269 DEFAULT CHARSET=utf8 COMMENT='管理员操作日志表';

-- -----------------------------
-- Records of `ey_admin_log`
-- -----------------------------
INSERT INTO `ey_admin_log` VALUES ('268', '1', '系统在线升级：v1.6.6 -&gt; v1.6.7', '127.0.0.1', '/login.php', '1721264820');
INSERT INTO `ey_admin_log` VALUES ('267', '1', '后台登录', '127.0.0.1', '/login.php', '1721264809');

-- -----------------------------
-- Table structure for `ey_admin_menu`
-- -----------------------------
DROP TABLE IF EXISTS `ey_admin_menu`;
CREATE TABLE `ey_admin_menu` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `menu_id` int(11) DEFAULT '0',
  `title` varchar(100) DEFAULT '' COMMENT '导航名称',
  `controller_name` varchar(50) DEFAULT '' COMMENT '控制器',
  `action_name` varchar(50) DEFAULT '' COMMENT '方法名',
  `param` varchar(255) DEFAULT '' COMMENT '参数',
  `icon` varchar(50) DEFAULT 'iconfont e-lanmuguanli' COMMENT '图标',
  `is_menu` tinyint(1) DEFAULT '0' COMMENT '是否显示为左侧菜单',
  `is_switch` tinyint(1) DEFAULT '0' COMMENT '是否显示在switch_map页面中',
  `target` varchar(50) DEFAULT 'workspace' COMMENT '链接打开方式',
  `sort_order` int(10) DEFAULT '100' COMMENT '排序号',
  `status` tinyint(1) DEFAULT '1' COMMENT '状态，1=显示，0=隐藏',
  `lang` varchar(20) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`),
  UNIQUE KEY `menu_id` (`menu_id`)
) ENGINE=MyISAM AUTO_INCREMENT=15 DEFAULT CHARSET=utf8 COMMENT='外挂功能地图菜单表';

-- -----------------------------
-- Records of `ey_admin_menu`
-- -----------------------------
INSERT INTO `ey_admin_menu` VALUES ('1', '1005', '欢迎页', 'Index', 'welcome', '', 'fa fa-user', '0', '1', 'workspace', '100', '1', 'cn', '1648864596', '1648864596');
INSERT INTO `ey_admin_menu` VALUES ('2', '1001', '栏目管理', 'Arctype', 'index', '|mt20|1', 'iconfont e-lanmuguanli', '1', '1', 'workspace', '100', '1', 'cn', '1648864596', '1648864596');
INSERT INTO `ey_admin_menu` VALUES ('3', '1002', '内容管理', 'Archives', 'index', '', 'iconfont e-neirongwendang', '1', '1', 'workspace', '100', '1', 'cn', '1648864596', '1648864596');
INSERT INTO `ey_admin_menu` VALUES ('4', '1004', '待审文档', 'Archives', 'index_draft', '|menu|1', 'iconfont e-tougao', '0', '1', 'workspace', '100', '1', 'cn', '1648864596', '1648864596');
INSERT INTO `ey_admin_menu` VALUES ('5', '1003', '广告管理', 'AdPosition', 'index', '', 'iconfont e-guanggao', '1', '1', 'workspace', '100', '1', 'cn', '1648864596', '1648864596');
INSERT INTO `ey_admin_menu` VALUES ('6', '2001', '基本信息', 'System', 'web', '', 'iconfont e-shezhi', '1', '1', 'workspace', '100', '1', 'cn', '1648864596', '1648864596');
INSERT INTO `ey_admin_menu` VALUES ('7', '2002', '可视编辑', 'Uiset', 'ui_index', '', 'iconfont e-keshihuabianji', '0', '1', 'workspace', '100', '1', 'cn', '1648864596', '1648864596');
INSERT INTO `ey_admin_menu` VALUES ('8', '2003', 'SEO模块', 'Seo', 'seo', '', 'iconfont e-seo', '1', '1', 'workspace', '100', '1', 'cn', '1648864596', '1648864596');
INSERT INTO `ey_admin_menu` VALUES ('9', '2004', '功能地图', 'Index', 'switch_map', '', 'iconfont e-caidangongneng', '1', '0', 'workspace', '10000', '1', 'cn', '1648864596', '1648864596');
INSERT INTO `ey_admin_menu` VALUES ('10', '2005', '插件应用', 'Weapp', 'index', '', 'iconfont e-chajian', '1', '1', 'workspace', '100', '1', 'cn', '1648864596', '1649638243');
INSERT INTO `ey_admin_menu` VALUES ('11', '2006', '会员中心', 'Member', 'users_index', '', 'iconfont e-gerenzhongxin', '0', '1', 'workspace', '100', '1', 'cn', '1648864596', '1648864596');
INSERT INTO `ey_admin_menu` VALUES ('12', '2008', '商城中心', 'Shop', 'home', '', 'iconfont e-shangcheng', '1', '1', 'workspace', '100', '1', 'cn', '1648864596', '1649638228');
INSERT INTO `ey_admin_menu` VALUES ('13', '2009', '可视化小程序', 'Diyminipro', 'page_edit', '', 'fa fa-code', '0', '1', 'workspace', '100', '1', 'cn', '1648864596', '1648864596');
INSERT INTO `ey_admin_menu` VALUES ('14', '2004018', '留言中心', 'Form', 'index', '', 'iconfont e-biaodanguanli', '0', '1', 'workspace', '100', '1', 'cn', '1677037793', '1677146423');

-- -----------------------------
-- Table structure for `ey_admin_theme`
-- -----------------------------
DROP TABLE IF EXISTS `ey_admin_theme`;
CREATE TABLE `ey_admin_theme` (
  `theme_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `theme_type` tinyint(1) DEFAULT '0' COMMENT '主题类型：1=登录页，2=欢迎页',
  `theme_title` varchar(50) DEFAULT '' COMMENT '主题标题',
  `theme_pic` varchar(255) DEFAULT '' COMMENT '主题效果图',
  `theme_color_model` varchar(10) DEFAULT '' COMMENT '主题颜色模式',
  `theme_main_color` varchar(20) DEFAULT '' COMMENT '主题主色',
  `theme_assist_color` varchar(20) DEFAULT '' COMMENT '主题辅色',
  `login_logo` varchar(255) DEFAULT '' COMMENT '登录图标',
  `login_bgimg_model` varchar(10) DEFAULT '' COMMENT '登录背景图模式',
  `login_bgimg` varchar(255) DEFAULT '' COMMENT '登录背景图',
  `login_tplname` varchar(100) DEFAULT '' COMMENT '登录页自定义模板',
  `admin_logo` varchar(255) DEFAULT '' COMMENT '后台Logo',
  `welcome_tplname` varchar(100) DEFAULT '' COMMENT '欢迎页自定义模板',
  `is_system` tinyint(1) DEFAULT '0' COMMENT '内置主题',
  `sort_order` int(10) DEFAULT '100' COMMENT '排序号',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`theme_id`)
) ENGINE=MyISAM AUTO_INCREMENT=101 DEFAULT CHARSET=utf8 COMMENT='后台主题风格表';

-- -----------------------------
-- Records of `ey_admin_theme`
-- -----------------------------
INSERT INTO `ey_admin_theme` VALUES ('1', '1', '经典蓝主题', '/public/static/admin/images/theme/theme_pic_1.png', '1', '#3398cc', '#2189be', '/public/static/admin/login/login-logo_ey.png', '1', '/public/static/admin/loginbg/login-bg-1.png', '', '/public/static/admin/logo/logo_ey.png', '', '1', '100', '1681200988', '1681200988');
INSERT INTO `ey_admin_theme` VALUES ('2', '1', '易优橙主题', '/public/static/admin/images/theme/theme_pic_2.png', 'custom', '#197971', '#fa921b', '/public/static/admin/login/login-logo.png', '2', '/public/static/admin/loginbg/login-bg-1.png', '', '/public/static/admin/logo/logo.png', '', '1', '100', '1681866512', '1681866512');
INSERT INTO `ey_admin_theme` VALUES ('4', '2', '商城欢迎页', '/public/static/admin/images/theme/theme_pic_4.png', '', '', '', '', '', '', '', '', 'welcome_shop.htm', '1', '100', '1681200988', '1681200988');
INSERT INTO `ey_admin_theme` VALUES ('5', '2', '任务流欢迎页', '/public/static/admin/images/theme/theme_pic_5.png', '', '', '', '', '', '', '', '', 'welcome_taskflow.htm', '1', '100', '1681200988', '1681200988');
INSERT INTO `ey_admin_theme` VALUES ('3', '2', '默认欢迎页', '/public/static/admin/images/theme/theme_pic_default.png', '', '', '', '', '', '', '', '', '', '1', '100', '1681200988', '1681200988');
INSERT INTO `ey_admin_theme` VALUES ('100', '1', '默认主题', '/public/static/admin/images/theme/theme_pic_default.png', '1', '#3398cc', '#2189be', '/public/static/admin/images/login-logo_zy.png', '1', '/public/static/admin/images/login-bg.jpg', '', '/public/static/admin/images/logo.png', '', '0', '100', '1713172677', '1713172677');

-- -----------------------------
-- Table structure for `ey_admin_wxlogin`
-- -----------------------------
DROP TABLE IF EXISTS `ey_admin_wxlogin`;
CREATE TABLE `ey_admin_wxlogin` (
  `wx_id` int(11) NOT NULL AUTO_INCREMENT,
  `type` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '1=官方公众号，2=微信应用',
  `admin_id` int(11) NOT NULL DEFAULT '0' COMMENT '用户id',
  `openid` varchar(50) NOT NULL DEFAULT '' COMMENT 'openid',
  `nickname` varchar(100) NOT NULL DEFAULT '' COMMENT '微信昵称',
  `unionid` varchar(200) NOT NULL DEFAULT '' COMMENT 'unionid',
  `headimgurl` varchar(200) NOT NULL DEFAULT '' COMMENT '头像',
  `add_time` int(11) NOT NULL DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`wx_id`) USING BTREE,
  KEY `openid` (`openid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='后台微信登录记录表';


-- -----------------------------
-- Table structure for `ey_anli_content`
-- -----------------------------
DROP TABLE IF EXISTS `ey_anli_content`;
CREATE TABLE `ey_anli_content` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `aid` int(10) DEFAULT '0' COMMENT '文档ID',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  `xinghao` varchar(200) NOT NULL DEFAULT '' COMMENT '产品型号',
  `body` longtext COMMENT '内容',
  PRIMARY KEY (`id`),
  KEY `aid` (`aid`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 COMMENT='附加表';

-- -----------------------------
-- Records of `ey_anli_content`
-- -----------------------------
INSERT INTO `ey_anli_content` VALUES ('1', '3', '1550193208', '1550193208', 'YS-BLM6256', '&lt;p style=&quot;text-align: center;&quot;&gt;&lt;img src=&quot;/uploads/ueditor/20190215/713cd23751c0e7fe62bbf1e5191f2152.png&quot; title=&quot;713cd23751c0e7fe62bbf1e5191f2152.png&quot; alt=&quot;713cd23751c0e7fe62bbf1e5191f2152.png&quot;/&gt;&lt;/p&gt;&lt;p style=&quot;text-align: center;&quot;&gt;这里是案例展示的内容。&lt;/p&gt;');
INSERT INTO `ey_anli_content` VALUES ('2', '4', '1550193197', '1550193197', 'YS-BLM5769', '&lt;p style=&quot;text-align: center;&quot;&gt;&lt;span style=&quot;text-align: center;&quot;&gt;&lt;img src=&quot;/uploads/ueditor/20190215/dee87fce7eb58059bed81a1f7cce81b0.png&quot; title=&quot;dee87fce7eb58059bed81a1f7cce81b0.png&quot; alt=&quot;dee87fce7eb58059bed81a1f7cce81b0.png&quot;/&gt;&lt;/span&gt;&lt;/p&gt;&lt;p style=&quot;text-align: center;&quot;&gt;&lt;span style=&quot;text-align: center;&quot;&gt;这里是案例展示的内容。&lt;/span&gt;&lt;/p&gt;');
INSERT INTO `ey_anli_content` VALUES ('3', '5', '1550193179', '1550193179', 'YS-BLM5616', '&lt;p style=&quot;text-align: center;&quot;&gt;&lt;img src=&quot;/uploads/ueditor/20190215/d345a633a2d6f69507e6881fdf20d568.png&quot; title=&quot;d345a633a2d6f69507e6881fdf20d568.png&quot; alt=&quot;d345a633a2d6f69507e6881fdf20d568.png&quot;/&gt;&lt;/p&gt;&lt;p style=&quot;text-align: center;&quot;&gt;这里是案例展示的内容。&lt;/p&gt;');
INSERT INTO `ey_anli_content` VALUES ('4', '6', '1550193145', '1550193145', 'YS-BLM8649', '&lt;p style=&quot;text-align: center;&quot;&gt;&lt;img src=&quot;/uploads/ueditor/20190215/18f42e633e075f417df9b68df41a072f.png&quot; title=&quot;18f42e633e075f417df9b68df41a072f.png&quot; alt=&quot;18f42e633e075f417df9b68df41a072f.png&quot;/&gt;&lt;/p&gt;&lt;p style=&quot;text-align: center;&quot;&gt;这里是案例展示的内容。&lt;br/&gt;&lt;/p&gt;');

-- -----------------------------
-- Table structure for `ey_appletstyle_content`
-- -----------------------------
DROP TABLE IF EXISTS `ey_appletstyle_content`;
CREATE TABLE `ey_appletstyle_content` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `aid` int(10) DEFAULT '0' COMMENT '文档ID',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  `color` enum('red','blue','golden','black') DEFAULT 'red' COMMENT '背景色',
  PRIMARY KEY (`id`),
  KEY `aid` (`aid`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COMMENT='附加表';

-- -----------------------------
-- Records of `ey_appletstyle_content`
-- -----------------------------
INSERT INTO `ey_appletstyle_content` VALUES ('1', '110', '1666943946', '1666943946', 'black');

-- -----------------------------
-- Table structure for `ey_archives`
-- -----------------------------
DROP TABLE IF EXISTS `ey_archives`;
CREATE TABLE `ey_archives` (
  `aid` int(10) NOT NULL AUTO_INCREMENT,
  `typeid` int(10) NOT NULL DEFAULT '0' COMMENT '当前栏目',
  `stypeid` varchar(90) DEFAULT '' COMMENT '副栏目ID集合',
  `channel` int(10) NOT NULL DEFAULT '0' COMMENT '模型ID',
  `is_b` tinyint(1) DEFAULT '0' COMMENT '加粗',
  `title` varchar(200) DEFAULT '' COMMENT '文档标题',
  `subtitle` varchar(200) DEFAULT '' COMMENT '副标题',
  `litpic` varchar(250) DEFAULT '' COMMENT '封面图片',
  `is_head` tinyint(1) DEFAULT '0' COMMENT '头条（0=否，1=是）',
  `is_special` tinyint(1) DEFAULT '0' COMMENT '特荐（0=否，1=是）',
  `is_top` tinyint(1) DEFAULT '0' COMMENT '置顶（0=否，1=是）',
  `is_recom` tinyint(1) DEFAULT '0' COMMENT '推荐（0=否，1=是）',
  `is_jump` tinyint(1) DEFAULT '0' COMMENT '跳转链接（0=否，1=是）',
  `is_litpic` tinyint(1) DEFAULT '0' COMMENT '图片（0=否，1=是）',
  `is_roll` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '滚动（0=否，1=是）',
  `is_slide` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '幻灯（0=否，1=是）',
  `is_diyattr` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '自定义（0=否，1=是）',
  `origin` varchar(200) DEFAULT '' COMMENT '来源',
  `author` varchar(200) DEFAULT '' COMMENT '作者',
  `click` int(10) DEFAULT '0' COMMENT '点击数',
  `arcrank` int(10) DEFAULT '0' COMMENT '阅读权限：0=开放浏览，-1=待审核稿件',
  `jumplinks` varchar(255) DEFAULT '' COMMENT '跳转网址',
  `ismake` tinyint(1) DEFAULT '0' COMMENT '是否静态页面（0=动态，1=静态）',
  `seo_title` varchar(200) DEFAULT '' COMMENT 'SEO标题',
  `seo_keywords` varchar(200) DEFAULT '' COMMENT 'SEO关键词',
  `seo_description` text COMMENT 'SEO描述',
  `attrlist_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '参数列表ID',
  `merchant_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '多商家ID',
  `free_shipping` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '商品是否包邮(1包邮(免运费)  0跟随系统)',
  `users_price` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '会员价',
  `crossed_price` decimal(10,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '商品划线价',
  `users_discount_type` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '产品会员折扣类型(0:系统默认折扣; 1:指定会员级别; 2:不参与折扣;)',
  `users_free` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否会员免费，默认0不免费，1为免费',
  `old_price` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '产品旧价',
  `sales_num` int(10) NOT NULL DEFAULT '0' COMMENT '总销售量',
  `virtual_sales` int(10) DEFAULT '0' COMMENT '商品虚拟销售量',
  `sales_all` int(10) DEFAULT '0' COMMENT '虚拟总销量',
  `stock_count` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '商品库存量',
  `stock_show` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '商品库存在产品详情页是否显示，1为显示，0为不显示',
  `prom_type` tinyint(1) unsigned DEFAULT '0' COMMENT '产品类型：0=普通产品，1=虚拟(默认手动发货)，2=虚拟(网盘)，3=虚拟(自定义文本) 4-核销',
  `logistics_type` varchar(100) DEFAULT '1' COMMENT '商品物流支持类型(1: 物流配送; 2: 到店核销)',
  `tempview` varchar(200) DEFAULT '' COMMENT '文档模板',
  `status` tinyint(1) DEFAULT '1' COMMENT '状态(0=屏蔽，1=正常)',
  `sort_order` int(10) DEFAULT '0' COMMENT '排序号',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `admin_id` int(10) DEFAULT '0' COMMENT '管理员ID',
  `users_id` int(10) DEFAULT '0' COMMENT '会员ID',
  `arc_level_id` int(10) DEFAULT '0' COMMENT '文档会员权限ID',
  `restric_type` tinyint(1) DEFAULT '0' COMMENT '限制模式，0=免费，1=付费，2=会员专享，3=会员付费',
  `is_del` tinyint(1) DEFAULT '0' COMMENT '伪删除，1=是，0=否',
  `del_method` tinyint(1) DEFAULT '0' COMMENT '伪删除状态，1为主动删除，2为跟随上级栏目被动删除',
  `joinaid` int(10) DEFAULT '0' COMMENT '关联文档ID',
  `downcount` int(10) DEFAULT '0' COMMENT '下载次数',
  `appraise` int(10) DEFAULT '0' COMMENT '评价数',
  `collection` int(10) DEFAULT '0' COMMENT '收藏数',
  `htmlfilename` varchar(500) DEFAULT '' COMMENT '自定义文件名',
  `province_id` int(10) DEFAULT '0' COMMENT '省份',
  `city_id` int(10) DEFAULT '0' COMMENT '所在城市',
  `area_id` int(10) DEFAULT '0' COMMENT '所在区域',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  `no_vip_pay` tinyint(3) DEFAULT '0' COMMENT 'restric_type = 2 时,会员专享,非会员可付费使用,0-关闭,1-开启',
  `editor_remote_img_local` tinyint(1) DEFAULT '1' COMMENT '远程图片本地化',
  `editor_img_clear_link` tinyint(1) DEFAULT '1' COMMENT '清除非本站链接',
  `reason` text COMMENT '退回原因',
  PRIMARY KEY (`aid`),
  KEY `add_time` (`add_time`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=165 DEFAULT CHARSET=utf8 COMMENT='文档主表';

-- -----------------------------
-- Records of `ey_archives`
-- -----------------------------
INSERT INTO `ey_archives` VALUES ('9', '17', '', '1', '0', '荣誉证书4', '', '/uploads/allimg/161109/1-1611091023000-L.jpg', '0', '0', '0', '0', '0', '1', '0', '0', '0', '', 'admin', '73', '0', '', '0', '', '荣誉证书,荣誉证书,', '', '0', '0', '0', '0.00', '0.00', '0', '0', '0.00', '0', '0', '0', '0', '1', '0', '1', '', '1', '100', 'cn', '1', '1', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1478658186', '1478658173', '0', '1', '1', '');
INSERT INTO `ey_archives` VALUES ('8', '17', '', '1', '0', '荣誉证书3', '', '/uploads/allimg/161109/1-1611091021170-L.jpg', '0', '0', '0', '0', '0', '1', '0', '0', '0', '', 'admin', '57', '0', '', '0', '', '荣誉证书,荣誉证书,', '', '0', '0', '0', '0.00', '0.00', '0', '0', '0.00', '0', '0', '0', '0', '1', '0', '1', '', '1', '100', 'cn', '1', '1', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1478658082', '1478658070', '0', '1', '1', '');
INSERT INTO `ey_archives` VALUES ('7', '17', '', '1', '0', '荣誉证书2', '', '/uploads/allimg/161109/1-161109101Z80-L.jpg', '0', '0', '0', '0', '0', '1', '0', '0', '0', '', 'admin', '174', '0', '', '0', '', '荣誉证书,荣誉证书,', '', '0', '0', '0', '0.00', '0.00', '0', '0', '0.00', '0', '0', '0', '0', '1', '0', '1', '', '1', '100', 'cn', '1', '1', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1478657953', '1478657940', '0', '1', '1', '');
INSERT INTO `ey_archives` VALUES ('6', '17', '', '1', '0', '荣誉证书1', '', '/uploads/allimg/161109/1-161109101Q50-L.jpg', '0', '0', '0', '0', '0', '1', '0', '0', '0', '', 'admin', '90', '0', '', '0', '', '荣誉证书,荣誉证书,', '', '0', '0', '0', '0.00', '0.00', '0', '0', '0.00', '0', '0', '0', '0', '1', '0', '1', '', '1', '100', 'cn', '1', '1', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1478657899', '1478657884', '0', '1', '1', '');
INSERT INTO `ey_archives` VALUES ('134', '52', '', '1', '0', 'Certificate of honor 4', '', '/eyou/uploads/allimg/161109/1-1611091026180-L.jpg', '0', '0', '0', '0', '0', '1', '0', '0', '0', '网络', '小编', '919', '0', '', '0', '', '', '', '0', '0', '0', '0.00', '0.00', '0', '0', '0.00', '0', '0', '0', '0', '1', '0', '1', '', '1', '100', 'en', '1', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1649670970', '1649670970', '0', '1', '1', '');
INSERT INTO `ey_archives` VALUES ('133', '52', '', '1', '0', 'Certificate of honor 3', '', '/eyou/uploads/allimg/161109/1-1611091026060-L.jpg', '0', '0', '0', '0', '0', '1', '0', '0', '0', '网络', '小编', '853', '0', '', '0', '', '', '', '0', '0', '0', '0.00', '0.00', '0', '0', '0.00', '0', '0', '0', '0', '1', '0', '1', '', '1', '100', 'en', '1', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1649670956', '1649670956', '0', '1', '1', '');
INSERT INTO `ey_archives` VALUES ('130', '52', '', '1', '0', 'Certificate of honor 5', '', '/eyou/uploads/allimg/161109/1-1611091025030-L.jpg', '0', '0', '0', '0', '0', '1', '0', '0', '0', '网络', '小编', '774', '0', '', '0', '', '', '', '0', '0', '0', '0.00', '0.00', '0', '0', '0.00', '0', '0', '0', '0', '1', '0', '1', '', '1', '100', 'en', '1', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1649670877', '1649670933', '0', '1', '1', '');
INSERT INTO `ey_archives` VALUES ('131', '52', '', '1', '0', 'Certificate of honor 1', '', '/eyou/uploads/allimg/161109/1-1611091025300-L.jpg', '0', '0', '0', '0', '0', '1', '0', '0', '0', '网络', '小编', '738', '0', '', '0', '', '', '', '0', '0', '0', '0.00', '0.00', '0', '0', '0.00', '0', '0', '0', '0', '1', '0', '1', '', '1', '100', 'en', '1', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1649670896', '1649670896', '0', '1', '1', '');
INSERT INTO `ey_archives` VALUES ('132', '52', '', '1', '0', 'Certificate of honor 2', '', '/eyou/uploads/allimg/161109/1-1611091025440-L.jpg', '0', '0', '0', '0', '0', '1', '0', '0', '0', '网络', '小编', '661', '0', '', '0', '', '', '', '0', '0', '0', '0.00', '0.00', '0', '0', '0.00', '0', '0', '0', '0', '1', '0', '1', '', '1', '100', 'en', '1', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1649670934', '1649670934', '0', '1', '1', '');
INSERT INTO `ey_archives` VALUES ('10', '17', '', '1', '0', '荣誉证书5', '', '/uploads/allimg/161109/1-1611091023160-L.jpg', '0', '0', '0', '0', '0', '1', '0', '0', '0', '', 'admin', '123', '0', '', '0', '', '荣誉证书,荣誉证书,', '', '0', '0', '0', '0.00', '0.00', '0', '0', '0.00', '0', '0', '0', '0', '1', '0', '1', '', '1', '100', 'cn', '1', '1', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1478658201', '1478658189', '0', '1', '1', '');
INSERT INTO `ey_archives` VALUES ('16', '19', '', '1', '0', '30年大红袍', '', '/uploads/allimg/161109/1-161109102S70-L.png', '0', '0', '0', '0', '0', '1', '0', '0', '0', '', 'admin', '192', '0', '', '0', '', '30年,大,红袍,来自,福建,武夷山,原产,香气,', '来自福建武夷山原产，香气馥郁有兰花香，香高而持久，岩韵明显，耐冲泡。', '0', '0', '0', '0.00', '0.00', '0', '0', '0.00', '0', '0', '0', '0', '1', '0', '1', '', '1', '100', 'cn', '1', '1', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1478658543', '1478658503', '0', '1', '1', '');
INSERT INTO `ey_archives` VALUES ('19', '19', '', '1', '0', '20年大红袍', '', '/uploads/allimg/161109/1-1611091035150-L.png', '0', '0', '0', '0', '0', '1', '0', '0', '0', '', 'admin', '92', '0', '', '0', '', '20年,大,红袍,来自,福建,武夷山,原产,香气,', '来自福建武夷山原产，香气馥郁有兰花香，香高而持久，岩韵明显，耐冲泡。', '0', '0', '0', '0.00', '0.00', '0', '0', '0.00', '0', '0', '0', '0', '1', '0', '1', '', '1', '100', 'cn', '1', '1', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1478658962', '1478658895', '0', '1', '1', '');
INSERT INTO `ey_archives` VALUES ('21', '19', '', '1', '0', '碧螺春香', '', '/uploads/allimg/161109/1-1611091036150-L.png', '0', '0', '0', '0', '0', '1', '0', '0', '0', '', 'admin', '170', '0', '', '0', '', '碧螺春,香,茶叶,外型,细小,紧秀,金,、,黄,黑,', '茶叶外型细小紧秀，金、黄、黑相间，开汤汤色金黄，入喉甘甜。其水、香、味似果、蜜、花、薯等综合香型，滋味鲜活甘爽，喉韵悠长', '0', '0', '0', '0.00', '0.00', '0', '0', '0.00', '0', '0', '0', '0', '1', '0', '1', '', '1', '100', 'cn', '1', '1', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1478659011', '1478658966', '0', '1', '1', '');
INSERT INTO `ey_archives` VALUES ('23', '19', '', '1', '0', '龙井3000', '', '/uploads/allimg/161109/1-161109103G10-L.png', '0', '0', '0', '0', '0', '1', '0', '0', '0', '', 'admin', '169', '0', '', '0', '', '龙井,3000,原料,精选,云,南大,叶种,细嫩,晒青,', '原料精选云南大叶种细嫩晒青毛茶，条索壮实，芽头肥硕显毫，发酵成度适中，汤色红尚浓，滋味醇厚回甘，苦涩味转化适度，香气纯正，显幽幽的茶香。', '0', '0', '0', '0.00', '0.00', '0', '0', '0.00', '0', '0', '0', '0', '1', '0', '1', '', '1', '100', 'cn', '1', '1', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1478659151', '1478659021', '0', '1', '1', '');
INSERT INTO `ey_archives` VALUES ('24', '19', '', '1', '0', '龙井6000', '', '/uploads/allimg/161109/1-1611091039240-L.png', '0', '0', '0', '0', '0', '1', '0', '0', '0', '', 'admin', '82', '0', '', '0', '', '龙井,6000,茶叶,外型,细小,紧秀,金,、,黄,黑,', '茶叶外型细小紧秀，金、黄、黑相间，开汤汤色金黄，入喉甘甜。其水、香、味似果、蜜、花、薯等综合香型，滋味鲜活甘爽，喉韵悠长', '0', '0', '0', '0.00', '0.00', '0', '0', '0.00', '0', '0', '0', '0', '1', '0', '1', '', '1', '100', 'cn', '1', '1', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1478659176', '1478659158', '0', '1', '1', '');
INSERT INTO `ey_archives` VALUES ('27', '20', '', '1', '0', '荷香', '', '/uploads/allimg/161109/1-1611091040360-L.png', '0', '0', '0', '0', '0', '1', '0', '0', '0', '', 'admin', '182', '0', '', '0', '', '荷香,原料,精选,云,南大,叶种,细嫩,晒青,毛茶,', '原料精选云南大叶种细嫩晒青毛茶，条索壮实，芽头肥硕显毫，发酵成度适中，汤色红尚浓，滋味醇厚回甘，苦涩味转化适度，香气纯正，显幽幽的茶香。', '0', '0', '0', '0.00', '0.00', '0', '0', '0.00', '0', '0', '0', '0', '1', '0', '1', '', '1', '100', 'cn', '1', '1', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1478659275', '1478659193', '0', '1', '1', '');
INSERT INTO `ey_archives` VALUES ('28', '20', '', '1', '0', '兰香', '', '/uploads/allimg/161109/1-1611091041250-L.png', '0', '0', '0', '0', '0', '1', '0', '0', '0', '', 'admin', '188', '0', '', '0', '', '兰香,原料,精选,云,南大,叶种,细嫩,晒青,毛茶,', '原料精选云南大叶种细嫩晒青毛茶，条索壮实，芽头肥硕显毫，发酵成度适中，汤色红尚浓，滋味醇厚回甘，苦涩味转化适度，香气纯正，显幽幽的茶香。', '0', '0', '0', '0.00', '0.00', '0', '0', '0.00', '0', '0', '0', '0', '1', '0', '1', '', '1', '100', 'cn', '1', '1', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1478659299', '1478659280', '0', '1', '1', '');
INSERT INTO `ey_archives` VALUES ('30', '20', '', '1', '0', '青樟香', '', '/uploads/allimg/161109/1-1611091042060-L.png', '0', '0', '0', '0', '0', '1', '0', '0', '0', '', 'admin', '187', '0', '', '0', '', '青,樟香,原料,精选,云,南大,叶种,细嫩,晒青,', '原料精选云南大叶种细嫩晒青毛茶，条索壮实，芽头肥硕显毫，发酵成度适中，汤色红尚浓，滋味醇厚回甘，苦涩味转化适度，香气纯正，显幽幽的茶香。', '0', '0', '0', '0.00', '0.00', '0', '0', '0.00', '0', '0', '0', '0', '1', '0', '1', '', '1', '100', 'cn', '1', '1', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1478659345', '1478659323', '0', '1', '1', '');
INSERT INTO `ey_archives` VALUES ('32', '20', '', '1', '0', '野樟香', '', '/uploads/allimg/161109/1-1611091042530-L.png', '0', '0', '0', '0', '0', '1', '0', '0', '0', '', 'admin', '97', '0', '', '0', '', '野樟,香,原料,精选,云,南大,叶种,细嫩,晒青,', '原料精选云南大叶种细嫩晒青毛茶，条索壮实，芽头肥硕显毫，发酵成度适中，汤色红尚浓，滋味醇厚回甘，苦涩味转化适度，香气纯正，显幽幽的茶香。', '0', '0', '0', '0.00', '0.00', '0', '0', '0.00', '0', '0', '0', '0', '1', '0', '1', '', '1', '100', 'cn', '1', '1', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1478659541', '1478659362', '0', '1', '1', '');
INSERT INTO `ey_archives` VALUES ('34', '21', '', '1', '0', '正山小种', '', '/uploads/allimg/161109/1-1611091046350-L.png', '0', '0', '0', '0', '0', '1', '0', '0', '0', '', 'admin', '75', '0', '', '0', '', '正山,小种,茶叶,外型,细小,紧秀,金,、,黄,黑,', '茶叶外型细小紧秀，金、黄、黑相间，开汤汤色金黄，入喉甘甜。其水、香、味似果、蜜、花、薯等综合香型，滋味鲜活甘爽，喉韵悠长', '0', '0', '0', '0.00', '0.00', '0', '0', '0.00', '0', '0', '0', '0', '1', '0', '1', '', '1', '100', 'cn', '1', '1', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1478659613', '1478659556', '0', '1', '1', '');
INSERT INTO `ey_archives` VALUES ('36', '21', '', '1', '0', '滇红', '', '/uploads/allimg/161109/1-161109104K40-L.png', '0', '0', '0', '0', '0', '1', '0', '0', '0', '', 'admin', '186', '0', '', '0', '', '滇红,茶叶,外型,细小,紧秀,金,、,黄,黑,相间,', '茶叶外型细小紧秀，金、黄、黑相间，开汤汤色金黄，入喉甘甜。其水、香、味似果、蜜、花、薯等综合香型，滋味鲜活甘爽，喉韵悠长', '0', '0', '0', '0.00', '0.00', '0', '0', '0.00', '0', '0', '0', '0', '1', '0', '1', '', '1', '100', 'cn', '1', '1', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1478659787', '1478659628', '0', '1', '1', '');
INSERT INTO `ey_archives` VALUES ('38', '21', '', '1', '0', '金骏眉', '', '/uploads/allimg/161109/1-1611091050110-L.png', '0', '0', '0', '0', '0', '1', '0', '0', '0', '', 'admin', '113', '0', '', '0', '', '金骏眉,茶叶,外型,细小,紧秀,金,、,黄,黑,', '茶叶外型细小紧秀，金、黄、黑相间，开汤汤色金黄，入喉甘甜。其水、香、味似果、蜜、花、薯等综合香型，滋味鲜活甘爽，喉韵悠长', '0', '0', '0', '0.00', '0.00', '0', '0', '0.00', '0', '0', '0', '0', '1', '0', '1', '', '1', '100', 'cn', '1', '1', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1478659828', '1478659807', '0', '1', '1', '');
INSERT INTO `ey_archives` VALUES ('40', '21', '', '1', '0', '枣香', '', '/uploads/allimg/161109/1-1611091050550-L.png', '0', '0', '0', '0', '0', '1', '0', '0', '0', '', 'admin', '98', '0', '', '0', '', '枣香,原料,精选,云,南大,叶种,细嫩,晒青,毛茶,', '原料精选云南大叶种细嫩晒青毛茶，条索壮实，芽头肥硕显毫，发酵成度适中，汤色红尚浓，滋味醇厚回甘，苦涩味转化适度，香气纯正，显幽幽的茶香。', '0', '0', '0', '0.00', '0.00', '0', '0', '0.00', '0', '0', '0', '0', '1', '0', '1', '', '1', '100', 'cn', '1', '1', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1478659866', '1478659851', '0', '1', '1', '');
INSERT INTO `ey_archives` VALUES ('42', '26', '', '1', '0', '要整容，不如先整心', '', '', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', 'admin', '64', '0', '', '0', '', '要,整容,不如,先整,心,看到,新加坡,的,一则,', '看到新加坡的一则消息，有个叫沈罗连的医生拼命替女人拍照片，从18岁到40岁，已经拍了10000个。 沈医生是为了他的职业而这么做的，他是位整容专家，但是要求女人让他拍照时还是有', '0', '0', '0', '0.00', '0.00', '0', '0', '0.00', '0', '0', '0', '0', '1', '0', '1', '', '1', '100', 'cn', '1', '1', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1478663092', '1478663079', '0', '1', '1', '');
INSERT INTO `ey_archives` VALUES ('45', '26', '', '1', '0', '常低头看看', '', '', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', 'admin', '199', '0', '', '0', '', '常低头,常,低头,看看,人们,平常,看世界,的,', '人们平常看世界的角度，主要可分为仰视、平视、俯视三种。 平视，是最正常和最舒服的眼光，发自于从容的平常心，蕴含着成熟与自信，不卑不亢，不急不躁，有利于稳步前行，不容', '0', '0', '0', '0.00', '0.00', '0', '0', '0.00', '0', '0', '0', '0', '1', '0', '1', '', '1', '100', 'cn', '1', '1', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1478663187', '1478663146', '0', '1', '1', '');
INSERT INTO `ey_archives` VALUES ('46', '26', '', '1', '0', '对豁达人生的最好报答', '', '', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', 'admin', '138', '0', '', '0', '', '对,豁达,人,生的,最好,报答,因为,想吃,煮,', '因为想吃煮玉米，就一个人慢慢地走到超市去。路上经过公园，看到很多人在放风筝，忍不住停下前行脚步，转而走进公园。 公园里，卖风筝和放风筝的人都很多，当然还有卖花的，卖', '0', '0', '0', '0.00', '0.00', '0', '0', '0.00', '0', '0', '0', '0', '1', '0', '1', '', '1', '100', 'cn', '1', '1', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1478663212', '1478663192', '0', '1', '1', '');
INSERT INTO `ey_archives` VALUES ('49', '26', '', '1', '0', '戒贪', '', '', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', 'admin', '179', '0', '', '0', '', '戒贪,电视,上,又在,报道,关于,二,套房,、,三,', '电视上，又在报道关于二套房、三套房贷款的问题。有钱人就是好啊，可以买二套房、三套房，而很多小老百姓，连首套房子也买不起。 也是电视上报道，说北京很多小区，入住率还不', '0', '0', '0', '0.00', '0.00', '0', '0', '0.00', '0', '0', '0', '0', '1', '0', '1', '', '1', '100', 'cn', '1', '1', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1478663325', '1478663225', '0', '1', '1', '');
INSERT INTO `ey_archives` VALUES ('51', '26', '', '1', '0', '如此善良的坏人', '', '', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', 'admin', '107', '0', '', '0', '', '如此,善良,的,坏人,朋友,的,表姐,是,开,', '朋友的表姐是开出租车的。 那天她不幸被四个强悍的歹徒绑架到一个荒僻、偏远的地方。寒冬、深夜敌我力量的反差，情况之危急可想而知。 朋友的表姐一边慢慢和歹徒周旋，一边想', '0', '0', '0', '0.00', '0.00', '0', '0', '0.00', '0', '0', '0', '0', '1', '0', '1', '', '1', '100', 'cn', '1', '1', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1478663385', '1478663329', '0', '1', '1', '');
INSERT INTO `ey_archives` VALUES ('52', '26', '', '1', '0', '藏，是懂得最深的慈悲', '', '/uploads/161110/1-161110104U6320.png', '0', '0', '0', '0', '0', '1', '0', '0', '0', '', 'admin', '119', '0', '', '0', '', '藏,是,懂得,最,深的,慈悲,裁,一帛,光阴,写,', '裁一帛光阴，写一阕旧词，字里行间，蕴着清风明月的境，含了幽篁篱菊的情，读在眼眸里，便是一段故事，读在往事中，便是一曲心音，读在岁月里，便是一林静好。 红尘漫漫，吹不', '0', '0', '0', '0.00', '0.00', '0', '0', '0.00', '0', '0', '0', '0', '1', '0', '1', '', '1', '100', 'cn', '1', '1', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1478663481', '1478746131', '0', '1', '1', '');
INSERT INTO `ey_archives` VALUES ('55', '27', '', '1', '0', '你的人生需要明白的', '', '', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', 'admin', '129', '0', '', '0', '', '你的,人生,需要,明,白的,人,活的,之所以,累,', '人活的之所以累，是放不下架子、撕不开面子、解不开情节（原因很简单） 你的人生需要明白的站在自己的立场上不是每个人都符合你的胃口；站在别的立场上，你又何尝能够所有人的', '0', '0', '0', '0.00', '0.00', '0', '0', '0.00', '0', '0', '0', '0', '1', '0', '1', '', '1', '100', 'cn', '1', '1', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1478663570', '1478663488', '0', '1', '1', '');
INSERT INTO `ey_archives` VALUES ('56', '27', '', '1', '0', '人的一生有三件事情不能等', '', '', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', 'admin', '56', '0', '', '0', '', '人的,一,生有,三件,事情,不能,等,第,一是,', '第一是贫穷 贫穷不能等，因为一但时间久了，你将习惯贫穷，到时不但无法突破自我，甚至会抹杀了自己的梦想，而庸庸碌碌的过一辈子 第二是梦想 梦想不能等，因为人生不同的阶段', '0', '0', '0', '0.00', '0.00', '0', '0', '0.00', '0', '0', '0', '0', '1', '0', '1', '', '1', '100', 'cn', '1', '1', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1478663596', '1478663577', '0', '1', '1', '');
INSERT INTO `ey_archives` VALUES ('58', '27', '', '1', '0', '脸小乾坤大', '', '', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', 'admin', '152', '0', '', '0', '', '脸小,乾坤,大,夏日,的,黄昏,里,我与,一个,', '夏日的黄昏里，我与一个老中医坐在清风徐徐的河边闲聊。突然，老人家盯着我的脸端详了好一会儿没有出声。我被他看得心里有些发虚，问道：老人家，你这么关注我的脸，是不是看', '0', '0', '0', '0.00', '0.00', '0', '0', '0.00', '0', '0', '0', '0', '1', '0', '1', '', '1', '100', 'cn', '1', '1', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1478664400', '1478664375', '0', '1', '1', '');
INSERT INTO `ey_archives` VALUES ('61', '27', '', '1', '0', '调慢生命的时钟', '', '', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', 'admin', '165', '0', '', '0', '', '调慢,生命,的,时钟,生命,是,时间,长,河里,', '生命是时间长河里转瞬即逝的刹那，人类千方百计想方设法地追求天长地久永生不老，却没有想到，事实上只要把自己的脚步放慢，心态放平，活在当下，那么人生自然会变得绵长悠远', '0', '0', '0', '0.00', '0.00', '0', '0', '0.00', '0', '0', '0', '0', '1', '0', '1', '', '1', '100', 'cn', '1', '1', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1478664451', '1478664414', '0', '1', '1', '');
INSERT INTO `ey_archives` VALUES ('63', '27', '', '1', '0', '关上尘世的耳朵', '', '', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', 'admin', '50', '0', '', '0', '', '关上,尘世,的,耳朵,床,大概,是最,消耗,生命,', '床大概是最消耗生命时光的地方了！一天除了三分之一的睡觉时间，另外的很多时光，居然也可以在床上度过。 溜狗回来，煮了一杯茶，半躺在床上，居然一觉睡到九点多了！起来吃点', '0', '0', '0', '0.00', '0.00', '0', '0', '0.00', '0', '0', '0', '0', '1', '0', '1', '', '1', '100', 'cn', '1', '1', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1478664574', '1478664457', '0', '1', '1', '');
INSERT INTO `ey_archives` VALUES ('128', '58', '', '6', '0', 'Joining', '', '', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '', '0', '0', '', '0', '', '', '', '0', '0', '0', '0.00', '0.00', '0', '0', '0.00', '0', '0', '0', '0', '1', '0', '1', '', '1', '100', 'en', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1649669769', '1649674095', '0', '1', '1', '');
INSERT INTO `ey_archives` VALUES ('126', '7', '', '6', '0', '服务中心', '', '', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '', '0', '0', '', '0', '', '', '', '0', '0', '0', '0.00', '0.00', '0', '0', '0.00', '0', '0', '0', '0', '1', '0', '1', '', '1', '100', 'cn', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1649662428', '1649670365', '0', '1', '1', '');
INSERT INTO `ey_archives` VALUES ('127', '49', '', '6', '0', 'About', '', '', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '', '0', '0', '', '0', '', '', '', '0', '0', '0', '0.00', '0.00', '0', '0', '0.00', '0', '0', '0', '0', '1', '0', '1', '', '1', '100', 'en', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1649669671', '1649673997', '0', '1', '1', '');
INSERT INTO `ey_archives` VALUES ('76', '30', '', '1', '0', '孕妇、儿童能否喝茶?', '', '', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', 'admin', '110', '0', '', '0', '', '孕妇,、,儿童,能否,喝茶,孕妇,、,儿童,一般,', '孕妇、儿童一般都不宜喝浓茶，因过浓的茶水中过量的咖啡因会使孕妇心动过速，对胎儿也会带来过分的刺激，儿童也是如此。因此一般主张孕妇、儿童宜饮淡茶，通过饮些淡茶，可以', '0', '0', '0', '0.00', '0.00', '0', '0', '0.00', '0', '0', '0', '0', '1', '0', '1', '', '1', '100', 'cn', '1', '1', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1478665095', '1478665083', '0', '1', '1', '');
INSERT INTO `ey_archives` VALUES ('77', '30', '', '1', '0', '为什么有人喜欢用枸杞子、西洋参、白菊花、桔', '', '', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', 'admin', '176', '0', '', '0', '', '为什么,有人,喜欢,用,枸杞子,、,西洋参,用,', '用枸杞子泡茶，有滋补抗衰的作用。《本草经疏》对枸杞子之功效作过较全面的论述：枸杞子，润而滋补，兼能退热，而专于补肾、润肺、生津、益气，为肝肾真阴不足、劳乏内热补益', '0', '0', '0', '0.00', '0.00', '0', '0', '0.00', '0', '0', '0', '0', '1', '0', '1', '', '1', '100', 'cn', '1', '1', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1478665109', '1478665100', '0', '1', '1', '');
INSERT INTO `ey_archives` VALUES ('78', '30', '', '1', '0', '如何调制牛奶红茶？', '', '', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', 'admin', '134', '0', '', '0', '', '如何,调制,牛奶,红茶,很多,年轻人,喜欢,饮用,', '很多年轻人喜欢饮用美味可口的牛奶红茶，冲泡配制方法是，先将适量红茶放入茶壶中，茶叶用量比清饮稍多些，然后冲入热开水,约5分钟后，从壶咀倒出茶汤放在咖啡杯中；如果是红茶', '0', '0', '0', '0.00', '0.00', '0', '0', '0.00', '0', '0', '0', '0', '1', '0', '1', '', '1', '100', 'cn', '1', '1', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1478665137', '1478665114', '0', '1', '1', '');
INSERT INTO `ey_archives` VALUES ('79', '30', '', '1', '0', '家中有多种茶叶，如何安排饮用?', '', '', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', 'admin', '112', '0', '', '0', '', '家,中有,多种,茶叶,如何,安排,饮用,有些,人,', '有些人在一天之中，不同时间饮用不同的茶叶，清晨喝一杯淡淡的高级绿茶，醒脑清心；上午喝一杯茉莉花茶，芬芳怡人，可提高工作效率；午后喝一杯红茶，解困提神；下午工间休息', '0', '0', '0', '0.00', '0.00', '0', '0', '0.00', '0', '0', '0', '0', '1', '0', '1', '', '1', '100', 'cn', '1', '1', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1478665161', '1478665142', '0', '1', '1', '');
INSERT INTO `ey_archives` VALUES ('80', '30', '', '1', '0', '茶叶化学成分及其对人体的保健作用', '', '', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', 'admin', '112', '0', '', '0', '', '茶叶,化学,成分,及其,对,人体,的,保健,作用,', '茶叶的化学成分是由3.5-7.0% 的无机物和93～96.5%的有机物组成。茶叶中的无机矿质元素约有27种，包括磷、钾、硫、镁、锰、氟、铝、钙、钠、铁、铜、锌、硒等多种。茶叶中的有机化合', '0', '0', '0', '0.00', '0.00', '0', '0', '0.00', '0', '0', '0', '0', '1', '0', '1', '', '1', '100', 'cn', '1', '1', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1478665173', '1478665166', '0', '1', '1', '');
INSERT INTO `ey_archives` VALUES ('81', '30', '', '1', '0', '正常人一天宜饮多少茶？', '', '', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', 'admin', '114', '0', '', '0', '', '正常人,一天,宜饮,多少,茶,饮茶,量,的,多少,', '饮茶量的多少决定于饮茶习惯、年龄、健康状况、生活环境、风俗等因素。一般健康的成年人，平时又有饮茶习惯的，一日饮茶12克左右，分3-4次冲泡是适宜的。对于体力劳动量大、消耗', '0', '0', '0', '0.00', '0.00', '0', '0', '0.00', '0', '0', '0', '0', '1', '0', '1', '', '1', '100', 'cn', '1', '1', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1478665185', '1478665178', '0', '1', '1', '');
INSERT INTO `ey_archives` VALUES ('129', '67', '', '6', '0', 'Service', '', '', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '', '0', '0', '', '0', '', '', '', '0', '0', '0', '0.00', '0.00', '0', '0', '0.00', '0', '0', '0', '0', '1', '0', '1', '', '1', '100', 'en', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1649669858', '1649674048', '0', '1', '1', '');
INSERT INTO `ey_archives` VALUES ('124', '3', '', '6', '0', '关于我们', '', '', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '', '0', '0', '', '0', '', '', '', '0', '0', '0', '0.00', '0.00', '0', '0', '0.00', '0', '0', '0', '0', '1', '0', '1', '', '1', '100', 'cn', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1649645446', '1649670169', '0', '1', '1', '');
INSERT INTO `ey_archives` VALUES ('125', '5', '', '6', '0', '招商加盟', '', '', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '', '0', '0', '', '0', '', '', '', '0', '0', '0', '0.00', '0.00', '0', '0', '0.00', '0', '0', '0', '0', '1', '0', '1', '', '1', '100', 'cn', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1649658304', '1649670333', '0', '1', '1', '');
INSERT INTO `ey_archives` VALUES ('105', '50', '', '6', '0', 'Company introduction', '', '', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '', '0', '0', '', '0', '', '', '', '0', '0', '0', '0.00', '0.00', '0', '0', '0.00', '0', '0', '0', '0', '1', '0', '1', '', '1', '100', 'en', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1649638737', '1649674154', '0', '1', '1', '');
INSERT INTO `ey_archives` VALUES ('87', '8', '', '6', '0', '联系我们', '', '', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '', '0', '0', '', '0', '', '', '', '0', '0', '0', '0.00', '0.00', '0', '0', '0.00', '0', '0', '0', '0', '1', '0', '1', '', '1', '100', 'cn', '1', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1649638273', '1649662271', '0', '1', '1', '');
INSERT INTO `ey_archives` VALUES ('89', '15', '', '6', '0', '公司介绍', '', '', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '', '0', '0', '', '0', '', '', '', '0', '0', '0', '0.00', '0.00', '0', '0', '0.00', '0', '0', '0', '0', '1', '0', '1', '', '1', '100', 'cn', '1', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1649638273', '1649670182', '0', '1', '1', '');
INSERT INTO `ey_archives` VALUES ('90', '16', '', '6', '0', '企业文化', '', '', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '', '0', '0', '', '0', '', '', '', '0', '0', '0', '0.00', '0.00', '0', '0', '0.00', '0', '0', '0', '0', '1', '0', '1', '', '1', '100', 'cn', '1', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1649638273', '1649638273', '0', '1', '1', '');
INSERT INTO `ey_archives` VALUES ('91', '18', '', '6', '0', '人才招聘', '', '', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '', '0', '0', '', '0', '', '', '', '0', '0', '0', '0.00', '0.00', '0', '0', '0.00', '0', '0', '0', '0', '1', '0', '1', '', '1', '100', 'cn', '1', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1649638273', '1649638273', '0', '1', '1', '');
INSERT INTO `ey_archives` VALUES ('92', '22', '', '6', '0', '加盟优势', '', '', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '', '0', '0', '', '0', '', '', '', '0', '0', '0', '0.00', '0.00', '0', '0', '0.00', '0', '0', '0', '0', '1', '0', '1', '', '1', '100', 'cn', '1', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1649638273', '1649670339', '0', '1', '1', '');
INSERT INTO `ey_archives` VALUES ('93', '23', '', '6', '0', '加盟流程', '', '', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '', '0', '0', '', '0', '', '', '', '0', '0', '0', '0.00', '0.00', '0', '0', '0.00', '0', '0', '0', '0', '1', '0', '1', '', '1', '100', 'cn', '1', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1649638273', '1649638273', '0', '1', '1', '');
INSERT INTO `ey_archives` VALUES ('94', '24', '', '6', '0', '加盟条件', '', '', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '', '0', '0', '', '0', '', '', '', '0', '0', '0', '0.00', '0.00', '0', '0', '0.00', '0', '0', '0', '0', '1', '0', '1', '', '1', '100', 'cn', '1', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1649638273', '1649638273', '0', '1', '1', '');
INSERT INTO `ey_archives` VALUES ('95', '25', '', '6', '0', '加盟政策', '', '', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '', '0', '0', '', '0', '', '', '', '0', '0', '0', '0.00', '0.00', '0', '0', '0.00', '0', '0', '0', '0', '1', '0', '1', '', '1', '100', 'cn', '1', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1649638273', '1649638273', '0', '1', '1', '');
INSERT INTO `ey_archives` VALUES ('96', '29', '', '6', '0', '服务理念', '', '', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '', '0', '0', '', '0', '', '', '', '0', '0', '0', '0.00', '0.00', '0', '0', '0.00', '0', '0', '0', '0', '1', '0', '1', '', '1', '100', 'cn', '1', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1649638273', '1649670372', '0', '1', '1', '');
INSERT INTO `ey_archives` VALUES ('106', '51', '', '6', '0', 'Enterprise Culture', '', '', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '', '0', '0', '', '0', '', '', '', '0', '0', '0', '0.00', '0.00', '0', '0', '0.00', '0', '0', '0', '0', '1', '0', '1', '', '1', '100', 'en', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1649638737', '1649674160', '0', '1', '1', '');
INSERT INTO `ey_archives` VALUES ('107', '53', '', '6', '0', 'Talent Recruitment', '', '', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '', '0', '0', '', '0', '', '', '', '0', '0', '0', '0.00', '0.00', '0', '0', '0.00', '0', '0', '0', '0', '1', '0', '1', '', '1', '100', 'en', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1649638737', '1649674173', '0', '1', '1', '');
INSERT INTO `ey_archives` VALUES ('108', '59', '', '6', '0', 'Advantages joining', '', '', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '', '0', '0', '', '0', '', '', '', '0', '0', '0', '0.00', '0.00', '0', '0', '0.00', '0', '0', '0', '0', '1', '0', '1', '', '1', '100', 'en', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1649638737', '1649674102', '0', '1', '1', '');
INSERT INTO `ey_archives` VALUES ('109', '60', '', '6', '0', 'Join process', '', '', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '', '0', '0', '', '0', '', '', '', '0', '0', '0', '0.00', '0.00', '0', '0', '0.00', '0', '0', '0', '0', '1', '0', '1', '', '1', '100', 'en', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1649638737', '1649674110', '0', '1', '1', '');
INSERT INTO `ey_archives` VALUES ('110', '61', '', '6', '0', 'Join conditions', '', '', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '', '0', '0', '', '0', '', '', '', '0', '0', '0', '0.00', '0.00', '0', '0', '0.00', '0', '0', '0', '0', '1', '0', '1', '', '1', '100', 'en', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1649638737', '1649674116', '0', '1', '1', '');
INSERT INTO `ey_archives` VALUES ('111', '62', '', '6', '0', 'Alliance policy', '', '', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '', '0', '0', '', '0', '', '', '', '0', '0', '0', '0.00', '0.00', '0', '0', '0.00', '0', '0', '0', '0', '1', '0', '1', '', '1', '100', 'en', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1649638737', '1649674122', '0', '1', '1', '');
INSERT INTO `ey_archives` VALUES ('112', '68', '', '6', '0', 'Service Concept', '', '', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '', '0', '0', '', '0', '', '', '', '0', '0', '0', '0.00', '0.00', '0', '0', '0.00', '0', '0', '0', '0', '1', '0', '1', '', '1', '100', 'en', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1649638737', '1649674056', '0', '1', '1', '');
INSERT INTO `ey_archives` VALUES ('113', '70', '', '6', '0', 'Contact', '', '', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '', '0', '0', '', '0', '', '', '', '0', '0', '0', '0.00', '0.00', '0', '0', '0.00', '0', '0', '0', '0', '1', '0', '1', '', '1', '100', 'en', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1649638737', '1649674043', '0', '1', '1', '');
INSERT INTO `ey_archives` VALUES ('135', '69', '', '1', '0', 'Pregnant women, children can drink tea?', '', '', '0', '0', '0', '0', '0', '0', '0', '0', '0', '网络', '小编', '586', '0', '', '0', '', '', 'Pregnant women, children generally do not drink tea, due to too much too much caffeine in tea causes tachycardia in pregnant women, the fetus will bring too much stimulus, children as well. Therefore ', '0', '0', '0', '0.00', '0.00', '0', '0', '0.00', '0', '0', '0', '0', '1', '0', '1', '', '1', '100', 'en', '1', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1649671040', '1649671040', '0', '1', '1', '');
INSERT INTO `ey_archives` VALUES ('136', '69', '', '1', '0', 'Why people like to use, American ginseng, medlar and white c', '', '', '0', '0', '0', '0', '0', '0', '0', '0', '0', '网络', '小编', '993', '0', '', '0', '', '', 'Medlar tea, nourishing effect of rejuvenation. The Materia Shu made a more comprehensive discussion on effect of wolfberry fruit: &quot;wolfberry, moistening and nourishing, and fever, while specializ', '0', '0', '0', '0.00', '0.00', '0', '0', '0.00', '0', '0', '0', '0', '1', '0', '1', '', '1', '100', 'en', '1', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1649671053', '1649671053', '0', '1', '1', '');
INSERT INTO `ey_archives` VALUES ('137', '69', '', '1', '0', 'How to modulate the milk te', '', '', '0', '0', '0', '0', '0', '0', '0', '0', '0', '网络', '小编', '769', '0', '', '0', '', '', 'Many young like drinking delicious of milk tea, rushed bubble preparation method is, first will amount tea into teapot in the, tea dosage than clear drink slightly more some, then rushed into hot wate', '0', '0', '0', '0.00', '0.00', '0', '0', '0.00', '0', '0', '0', '0', '1', '0', '1', '', '1', '100', 'en', '1', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1649671065', '1649671065', '0', '1', '1', '');
INSERT INTO `ey_archives` VALUES ('138', '69', '', '1', '0', 'There are a variety of teas, what to drink?', '', '', '0', '0', '0', '0', '0', '0', '0', '0', '0', '网络', '小编', '704', '0', '', '0', '', '', 'Some people in a days among, different time drinking different of tea, morning drink a cup light of senior green tea, woke up brain pure; morning drink a cup Jasmine tea, fragrance Yi people, can impr', '0', '0', '0', '0.00', '0.00', '0', '0', '0.00', '0', '0', '0', '0', '1', '0', '1', '', '1', '100', 'en', '1', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1649671076', '1649671076', '0', '1', '1', '');
INSERT INTO `ey_archives` VALUES ('139', '69', '', '1', '0', 'Chemical composition of tea and its health effects on humans', '', '', '0', '0', '0', '0', '0', '0', '0', '0', '0', '网络', '小编', '957', '0', '', '0', '', '', 'The chemical composition of tea is made up of inorganic and organic composition of 93~96.5% of 3.5-7.0%. About 27 of the inorganic mineral elements in tea, including phosphorus, potassium, sulfur, mag', '0', '0', '0', '0.00', '0.00', '0', '0', '0.00', '0', '0', '0', '0', '1', '0', '1', '', '1', '100', 'en', '1', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1649671087', '1649671087', '0', '1', '1', '');
INSERT INTO `ey_archives` VALUES ('140', '69', '', '1', '0', 'Normal day should be drinking tea?', '', '', '0', '0', '0', '0', '0', '0', '0', '0', '0', '网络', '小编', '815', '0', '', '0', '', '', 'Tea depends on the amount of tea drinking habits, age, State of health, living conditions, customs, and other factors. Generally healthy adults usually have tea-drinking habit, tea about 12 grams a da', '0', '0', '0', '0.00', '0.00', '0', '0', '0.00', '0', '0', '0', '0', '1', '0', '1', '', '1', '100', 'en', '1', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1649671099', '1649671099', '0', '1', '1', '');
INSERT INTO `ey_archives` VALUES ('141', '64', '', '1', '0', 'To plastic surgery, as the first heart', '', '', '0', '0', '0', '0', '0', '0', '0', '0', '0', '网络', '小编', '537', '0', '', '0', '', '', 'See Singapore, a message, a man named Shen Luo even doctors trying to take pictures of women, from 18 years old to 40 years old, has taken 10,000.   Dr. Shen is a cosmetic specialist, but asked the wo', '0', '0', '0', '0.00', '0.00', '0', '0', '0.00', '0', '0', '0', '0', '1', '0', '1', '', '1', '100', 'en', '1', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1649671133', '1649671133', '0', '1', '1', '');
INSERT INTO `ey_archives` VALUES ('142', '64', '', '1', '0', 'Often look down', '', '', '0', '0', '0', '0', '0', '0', '0', '0', '0', '网络', '小编', '848', '0', '', '0', '', '', 'People usually see the world&#39;s point of view, can be divided into looking up, head-up, overlooking the three. Heads-up, is the most normal and most comfortable vision, from the calm of the sense o', '0', '0', '0', '0.00', '0.00', '0', '0', '0.00', '0', '0', '0', '0', '1', '0', '1', '', '1', '100', 'en', '1', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1649671144', '1649671144', '0', '1', '1', '');
INSERT INTO `ey_archives` VALUES ('143', '64', '', '1', '0', 'Open-minded life of the best reward', '', '', '0', '0', '0', '0', '0', '0', '0', '0', '0', '网络', '小编', '576', '0', '', '0', '', '', 'Because want to eat boiled corn, a person slowly went to the supermarket. On the road through the park, to see a lot of people in the kite-flying, could not help but stop the footsteps, turn into the ', '0', '0', '0', '0.00', '0.00', '0', '0', '0.00', '0', '0', '0', '0', '1', '0', '1', '', '1', '100', 'en', '1', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1649671154', '1649671154', '0', '1', '1', '');
INSERT INTO `ey_archives` VALUES ('144', '64', '', '1', '0', 'Quit corruption', '', '', '0', '0', '0', '0', '0', '0', '0', '0', '0', '网络', '小编', '690', '0', '', '0', '', '', 'TV, and in the report on the two suites, three suites loans. The rich is good, you can buy two suites, three suites, and many small people, even the first set of houses can not afford. Is also reporte', '0', '0', '0', '0.00', '0.00', '0', '0', '0.00', '0', '0', '0', '0', '1', '0', '1', '', '1', '100', 'en', '1', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1649671164', '1649671164', '0', '1', '1', '');
INSERT INTO `ey_archives` VALUES ('145', '64', '', '1', '0', 'Such a good villain', '', '', '0', '0', '0', '0', '0', '0', '0', '0', '0', '网络', '小编', '927', '0', '', '0', '', '', 'Friends of the cousin is a taxi. That day she was unfortunate by four powerful criminals kidnapped to a remote, remote place. Winter, the strength of the enemy at night, the contrast, the situation ca', '0', '0', '0', '0.00', '0.00', '0', '0', '0.00', '0', '0', '0', '0', '1', '0', '1', '', '1', '100', 'en', '1', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1649671175', '1649671175', '0', '1', '1', '');
INSERT INTO `ey_archives` VALUES ('146', '64', '', '1', '0', 'Tibetan, is to understand the deepest compassion', '', '/eyou/uploads/161110/1-161110124235L6.png', '0', '0', '0', '0', '0', '1', '0', '0', '0', '网络', '小编', '998', '0', '', '0', '', '', 'A copy of the time, write a tie the old words, between the lines, the breeze with the breeze of the moon scene, with the quiet Huang Lei Ju situation, read in the eyes, is a story, read in the past, i', '0', '0', '0', '0.00', '0.00', '0', '0', '0.00', '0', '0', '0', '0', '1', '0', '1', '', '1', '100', 'en', '1', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1649671188', '1649671188', '0', '1', '1', '');
INSERT INTO `ey_archives` VALUES ('147', '65', '', '1', '0', 'Close the earth \'s ears', '', '', '0', '0', '0', '0', '0', '0', '0', '0', '0', '网络', '小编', '764', '0', '', '0', '', '', 'Bed is probably the most consumption life time place! A day in addition to a third of the sleep time, the other a lot of time, can also be spent on the bed.Dog back, made a cup of tea and half lying i', '0', '0', '0', '0.00', '0.00', '0', '0', '0.00', '0', '0', '0', '0', '1', '0', '1', '', '1', '100', 'en', '1', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1649671202', '1649671202', '0', '1', '1', '');
INSERT INTO `ey_archives` VALUES ('148', '65', '', '1', '0', 'Slow down the clock of life', '', '', '0', '0', '0', '0', '0', '0', '0', '0', '0', '网络', '小编', '567', '0', '', '0', '', '', 'Life is a fleeting moment in the river of time, mankind do everything possible to seek forever and everlasting, but did not think, in fact, as long as the pace of their own slow down mentality flat, l', '0', '0', '0', '0.00', '0.00', '0', '0', '0.00', '0', '0', '0', '0', '1', '0', '1', '', '1', '100', 'en', '1', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1649671229', '1649671229', '0', '1', '1', '');
INSERT INTO `ey_archives` VALUES ('149', '65', '', '1', '0', 'Face a small universe', '', '', '0', '0', '0', '0', '0', '0', '0', '0', '0', '网络', '小编', '681', '0', '', '0', '', '', 'Summer dusk, I sit with an old Chinese medicine in the breeze slowly chatting the river. Suddenly, the old man stared at my face for a moment and did not say anything. I was his heart to see some hair', '0', '0', '0', '0.00', '0.00', '0', '0', '0.00', '0', '0', '0', '0', '1', '0', '1', '', '1', '100', 'en', '1', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1649671240', '1649671240', '0', '1', '1', '');
INSERT INTO `ey_archives` VALUES ('150', '65', '', '1', '0', 'There are three things that one can not wait for in one\'s li', '', '', '0', '0', '0', '0', '0', '0', '0', '0', '0', '网络', '小编', '881', '0', '', '0', '', '', 'The first is &quot;poverty&quot;   Poverty can not wait, because a long time, you will be used to poverty, when not only can not break through the self, or even obliterate their dreams, and mediocre o', '0', '0', '0', '0.00', '0.00', '0', '0', '0.00', '0', '0', '0', '0', '1', '0', '1', '', '1', '100', 'en', '1', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1649671250', '1649671250', '0', '1', '1', '');
INSERT INTO `ey_archives` VALUES ('151', '65', '', '1', '0', 'Your life needs to understand', '', '', '0', '0', '0', '0', '0', '0', '0', '0', '0', '网络', '小编', '856', '0', '', '0', '', '', 'The reason why people live tired, is not fit the shelf, tear can not open face, untied plot (the reason is very simple)   Your life needs to understand the stand in their own position, not everyone is', '0', '0', '0', '0.00', '0.00', '0', '0', '0.00', '0', '0', '0', '0', '1', '0', '1', '', '1', '100', 'en', '1', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1649671260', '1649671260', '0', '1', '1', '');
INSERT INTO `ey_archives` VALUES ('152', '55', '', '1', '0', '30 red robe', '', '/eyou/uploads/allimg/161109/1-161109102S70-L.png', '0', '0', '0', '0', '0', '1', '0', '0', '0', '网络', '小编', '548', '0', '', '0', '', '', 'From Wuyi Mountain, Fujian native, aroma fragrance Orchid fragrance, flavor and good and lasting, &quot;rock and rhyme&quot; apparently, resistant to brew.', '0', '0', '0', '0.00', '0.00', '0', '0', '0.00', '0', '0', '0', '0', '1', '0', '1', '', '1', '100', 'en', '1', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1649671944', '1649671944', '0', '1', '1', '');
INSERT INTO `ey_archives` VALUES ('153', '55', '', '1', '0', '20 Red robe', '', '/eyou/uploads/allimg/161109/1-1611091035150-L.png', '0', '0', '0', '0', '0', '1', '0', '0', '0', '网络', '小编', '786', '0', '', '0', '', '', 'From Wuyi Mountain, Fujian native, aroma fragrance Orchid fragrance, flavor and good and lasting, &quot;rock and rhyme&quot; apparently, resistant to brew.', '0', '0', '0', '0.00', '0.00', '0', '0', '0.00', '0', '0', '0', '0', '1', '0', '1', '', '1', '100', 'en', '1', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1649671971', '1649671971', '0', '1', '1', '');
INSERT INTO `ey_archives` VALUES ('154', '55', '', '1', '0', 'Green tea incense', '', '/eyou/uploads/allimg/161109/1-1611091036150-L.png', '0', '0', '0', '0', '0', '1', '0', '0', '0', '网络', '小编', '852', '0', '', '0', '', '', 'Tea-small tight and slender, gold and yellow, black and white, open flood-color golden yellow, sweet into the throat. The water, smell and taste like fruit, honey, flowers, potato chips and other inte', '0', '0', '0', '0.00', '0.00', '0', '0', '0.00', '0', '0', '0', '0', '1', '0', '1', '', '1', '100', 'en', '1', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1649671989', '1649671989', '0', '1', '1', '');
INSERT INTO `ey_archives` VALUES ('155', '55', '', '1', '0', 'Longjing 3000', '', '/eyou/uploads/allimg/161109/1-161109103G10-L.png', '0', '0', '0', '0', '0', '1', '0', '0', '0', '网络', '小编', '861', '0', '', '0', '', '', 'Raw material selection of Sun Yunnan big leaves and delicate green tea, cable sturdy, Bud stout tippy, fermented into moderate color red is still strong, mellow taste sweet, bitter taste into moderati', '0', '0', '0', '0.00', '0.00', '0', '0', '0.00', '0', '0', '0', '0', '1', '0', '1', '', '1', '100', 'en', '1', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1649672007', '1649672007', '0', '1', '1', '');
INSERT INTO `ey_archives` VALUES ('156', '55', '', '1', '0', 'Longjing 6000', '', '/eyou/uploads/allimg/161109/1-1611091039240-L.png', '0', '0', '0', '0', '0', '1', '0', '0', '0', '网络', '小编', '513', '0', '', '0', '', '', 'Tea-small tight and slender, gold and yellow, black and white, open flood-color golden yellow, sweet into the throat. The water, smell and taste like fruit, honey, flowers, potato chips and other inte', '0', '0', '0', '0.00', '0.00', '0', '0', '0.00', '0', '0', '0', '0', '1', '0', '1', '', '1', '100', 'en', '1', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1649672029', '1649672029', '0', '1', '1', '');
INSERT INTO `ey_archives` VALUES ('157', '56', '', '1', '0', 'Mr Zhang Xiang', '', '/eyou/uploads/allimg/161109/1-1611091042530-L.png', '0', '0', '0', '0', '0', '1', '0', '0', '0', '网络', '小编', '921', '0', '', '0', '', '', 'Raw material selection of Sun Yunnan big leaves and delicate green tea, cable sturdy, Bud stout tippy, fermented into moderate color red is still strong, mellow taste sweet, bitter taste into moderati', '0', '0', '0', '0.00', '0.00', '0', '0', '0.00', '0', '0', '0', '0', '1', '0', '1', '', '1', '100', 'en', '1', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1649672046', '1649672046', '0', '1', '1', '');
INSERT INTO `ey_archives` VALUES ('158', '56', '', '1', '0', 'Qing Zhang Xiang', '', '/eyou/uploads/allimg/161109/1-1611091042060-L.png', '0', '0', '0', '0', '0', '1', '0', '0', '0', '网络', '小编', '502', '0', '', '0', '', '', 'Raw material selection of Sun Yunnan big leaves and delicate green tea, cable sturdy, Bud stout tippy, fermented into moderate color red is still strong, mellow taste sweet, bitter taste into moderati', '0', '0', '0', '0.00', '0.00', '0', '0', '0.00', '0', '0', '0', '0', '1', '0', '1', '', '1', '100', 'en', '1', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1649672083', '1649672083', '0', '1', '1', '');
INSERT INTO `ey_archives` VALUES ('159', '56', '', '1', '0', 'Orchid', '', '/eyou/uploads/allimg/161109/1-1611091041250-L.png', '0', '0', '0', '0', '0', '1', '0', '0', '0', '网络', '小编', '902', '0', '', '0', '', '', 'Raw material selection of Sun Yunnan big leaves and delicate green tea, cable sturdy, Bud stout tippy, fermented into moderate color red is still strong, mellow taste sweet, bitter taste into moderati', '0', '0', '0', '0.00', '0.00', '0', '0', '0.00', '0', '0', '0', '0', '1', '0', '1', '', '1', '100', 'en', '1', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1649672100', '1649672100', '0', '1', '1', '');
INSERT INTO `ey_archives` VALUES ('160', '56', '', '1', '0', 'Lotus', '', '/eyou/uploads/allimg/161109/1-1611091040360-L.png', '0', '0', '0', '0', '0', '1', '0', '0', '0', '网络', '小编', '703', '0', '', '0', '', '', 'Raw material selection of Sun Yunnan big leaves and delicate green tea, cable sturdy, Bud stout tippy, fermented into moderate color red is still strong, mellow taste sweet, bitter taste into moderati', '0', '0', '0', '0.00', '0.00', '0', '0', '0.00', '0', '0', '0', '0', '1', '0', '1', '', '1', '100', 'en', '1', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1649672119', '1649672119', '0', '1', '1', '');
INSERT INTO `ey_archives` VALUES ('161', '57', '', '1', '0', 'Jujube fragrance', '', '/eyou/uploads/allimg/161109/1-1611091050550-L.png', '0', '0', '0', '0', '0', '1', '0', '0', '0', '网络', '小编', '651', '0', '', '0', '', '', 'Raw material selection of Sun Yunnan big leaves and delicate green tea, cable sturdy, Bud stout tippy, fermented into moderate color red is still strong, mellow taste sweet, bitter taste into moderati', '0', '0', '0', '0.00', '0.00', '0', '0', '0.00', '0', '0', '0', '0', '1', '0', '1', '', '1', '100', 'en', '1', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1649672132', '1649672132', '0', '1', '1', '');
INSERT INTO `ey_archives` VALUES ('162', '57', '', '1', '0', 'Jin Jun Mei', '', '/eyou/uploads/allimg/161109/1-1611091050110-L.png', '0', '0', '0', '0', '0', '1', '0', '0', '0', '网络', '小编', '521', '0', '', '0', '', '', 'Tea-small tight and slender, gold and yellow, black and white, open flood-color golden yellow, sweet into the throat. The water, smell and taste like fruit, honey, flowers, potato chips and other inte', '0', '0', '0', '0.00', '0.00', '0', '0', '0.00', '0', '0', '0', '0', '1', '0', '1', '', '1', '100', 'en', '1', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1649672164', '1649672164', '0', '1', '1', '');
INSERT INTO `ey_archives` VALUES ('163', '57', '', '1', '0', 'Dianhong', '', '/eyou/uploads/allimg/161109/1-161109104K40-L.png', '0', '0', '0', '0', '0', '1', '0', '0', '0', '网络', '小编', '873', '0', '', '0', '', '', 'Tea-small tight and slender, gold and yellow, black and white, open flood-color golden yellow, sweet into the throat. The water, smell and taste like fruit, honey, flowers, potato chips and other inte', '0', '0', '0', '0.00', '0.00', '0', '0', '0.00', '0', '0', '0', '0', '1', '0', '1', '', '1', '100', 'en', '1', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1649672182', '1649672182', '0', '1', '1', '');
INSERT INTO `ey_archives` VALUES ('164', '57', '', '1', '0', 'Mountain race', '', '/eyou/uploads/allimg/161109/1-1611091046350-L.png', '0', '0', '0', '0', '0', '1', '0', '0', '0', '网络', '小编', '717', '0', '', '0', '', '', 'Tea-small tight and slender, gold and yellow, black and white, open flood-color golden yellow, sweet into the throat. The water, smell and taste like fruit, honey, flowers, potato chips and other inte', '0', '0', '0', '0.00', '0.00', '0', '0', '0.00', '0', '0', '0', '0', '1', '0', '1', '', '1', '100', 'en', '1', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1649672202', '1649672202', '0', '1', '1', '');

-- -----------------------------
-- Table structure for `ey_archives_flag`
-- -----------------------------
DROP TABLE IF EXISTS `ey_archives_flag`;
CREATE TABLE `ey_archives_flag` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `flag_name` varchar(255) NOT NULL DEFAULT '' COMMENT '文档属性名称',
  `flag_attr` varchar(10) NOT NULL DEFAULT '' COMMENT '属性值',
  `flag_fieldname` varchar(255) NOT NULL DEFAULT '' COMMENT '字段名',
  `status` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '状态， 1---显示， 0---隐藏',
  `sort_order` int(11) unsigned NOT NULL DEFAULT '0',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`),
  UNIQUE KEY `flag_attr` (`flag_attr`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=10 DEFAULT CHARSET=utf8 COMMENT='文档属性配置表';

-- -----------------------------
-- Records of `ey_archives_flag`
-- -----------------------------
INSERT INTO `ey_archives_flag` VALUES ('1', '头条', 'h', 'is_head', '1', '1', 'cn', '1606272350', '1606272350');
INSERT INTO `ey_archives_flag` VALUES ('2', '推荐', 'c', 'is_recom', '1', '2', 'cn', '1606272350', '1606272350');
INSERT INTO `ey_archives_flag` VALUES ('3', '加推', 'a', 'is_special', '1', '3', 'cn', '1606272350', '1606272350');
INSERT INTO `ey_archives_flag` VALUES ('4', '标粗', 'b', 'is_b', '1', '4', 'cn', '1606272350', '1606272350');
INSERT INTO `ey_archives_flag` VALUES ('5', '有图', 'p', 'is_litpic', '1', '5', 'cn', '1606272350', '1606272350');
INSERT INTO `ey_archives_flag` VALUES ('6', '外链', 'j', 'is_jump', '1', '6', 'cn', '1606272350', '1606272350');
INSERT INTO `ey_archives_flag` VALUES ('7', '轮播', 's', 'is_slide', '0', '7', 'cn', '1606272350', '1606272350');
INSERT INTO `ey_archives_flag` VALUES ('8', '滚动', 'r', 'is_roll', '0', '8', 'cn', '1606272350', '1606272350');
INSERT INTO `ey_archives_flag` VALUES ('9', '热文', 'd', 'is_diyattr', '0', '9', 'cn', '1606272350', '1606272350');

-- -----------------------------
-- Table structure for `ey_arcmulti`
-- -----------------------------
DROP TABLE IF EXISTS `ey_arcmulti`;
CREATE TABLE `ey_arcmulti` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `tagid` varchar(60) NOT NULL DEFAULT '' COMMENT '标签ID',
  `tagname` varchar(60) NOT NULL DEFAULT '' COMMENT '标签名',
  `innertext` text NOT NULL COMMENT '标签模板代码',
  `pagesize` int(10) NOT NULL DEFAULT '0' COMMENT '分页列表',
  `querysql` text NOT NULL COMMENT '完整SQL',
  `ordersql` varchar(200) DEFAULT '' COMMENT '排序SQL',
  `addfieldsSql` varchar(255) DEFAULT '' COMMENT '附加字段SQL',
  `addtableName` varchar(50) DEFAULT '' COMMENT '附加字段的数据表，不包含表前缀',
  `attstr` text COMMENT '属性字符串',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='多页标记存储数据表';


-- -----------------------------
-- Table structure for `ey_arcrank`
-- -----------------------------
DROP TABLE IF EXISTS `ey_arcrank`;
CREATE TABLE `ey_arcrank` (
  `id` smallint(5) unsigned NOT NULL AUTO_INCREMENT COMMENT '权限ID',
  `rank` smallint(6) DEFAULT '0' COMMENT '权限值',
  `name` char(20) DEFAULT '' COMMENT '会员名称',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='文档阅读权限表';

-- -----------------------------
-- Records of `ey_arcrank`
-- -----------------------------
INSERT INTO `ey_arcrank` VALUES ('1', '0', '开放浏览', 'cn', '0', '1552376880');
INSERT INTO `ey_arcrank` VALUES ('2', '-1', '待审核稿件', 'cn', '0', '1552376880');
INSERT INTO `ey_arcrank` VALUES ('3', '0', '开放浏览', 'en', '0', '1552376880');
INSERT INTO `ey_arcrank` VALUES ('4', '-1', '待审核稿件', 'en', '0', '1552376880');

-- -----------------------------
-- Table structure for `ey_arctype`
-- -----------------------------
DROP TABLE IF EXISTS `ey_arctype`;
CREATE TABLE `ey_arctype` (
  `id` int(10) NOT NULL AUTO_INCREMENT COMMENT '栏目ID',
  `channeltype` int(10) DEFAULT '0' COMMENT '栏目顶级模型ID',
  `current_channel` int(10) DEFAULT '0' COMMENT '栏目当前模型ID',
  `parent_id` int(10) DEFAULT '0' COMMENT '栏目上级ID',
  `topid` int(10) DEFAULT '0' COMMENT '顶级栏目ID',
  `typename` varchar(200) DEFAULT '' COMMENT '栏目名称',
  `dirname` varchar(200) DEFAULT '' COMMENT '目录英文名',
  `dirpath` varchar(200) DEFAULT '' COMMENT '目录存放HTML路径',
  `diy_dirpath` varchar(200) DEFAULT '' COMMENT '列表静态文件存放规则',
  `rulelist` varchar(200) DEFAULT '' COMMENT '列表静态文件存放规则',
  `ruleview` varchar(200) DEFAULT '' COMMENT '文档静态文件存放规则',
  `englist_name` varchar(200) DEFAULT '' COMMENT '栏目英文名',
  `grade` tinyint(1) DEFAULT '0' COMMENT '栏目等级',
  `typelink` varchar(200) DEFAULT '' COMMENT '栏目链接',
  `litpic` varchar(250) DEFAULT '' COMMENT '栏目图片',
  `templist` varchar(200) DEFAULT '' COMMENT '列表模板文件名',
  `tempview` varchar(200) DEFAULT '' COMMENT '文档模板文件名',
  `seo_title` varchar(200) DEFAULT '' COMMENT 'SEO标题',
  `seo_keywords` varchar(200) DEFAULT '' COMMENT 'seo关键字',
  `seo_description` text COMMENT 'seo描述',
  `sort_order` int(10) DEFAULT '0' COMMENT '排序号',
  `is_hidden` tinyint(1) DEFAULT '0' COMMENT '是否隐藏栏目：0=显示，1=隐藏',
  `is_part` tinyint(1) DEFAULT '0' COMMENT '栏目属性：0=内容栏目，1=外部链接',
  `admin_id` int(10) DEFAULT '0' COMMENT '管理员ID',
  `is_del` tinyint(1) DEFAULT '0' COMMENT '伪删除，1=是，0=否',
  `del_method` tinyint(1) DEFAULT '0' COMMENT '伪删除状态，1为主动删除，2为跟随上级栏目被动删除',
  `status` tinyint(1) DEFAULT '1' COMMENT '启用 (1=正常，0=屏蔽)',
  `is_release` tinyint(1) DEFAULT '0' COMMENT '栏目是否应用于会员投稿发布，1是，0否',
  `weapp_code` varchar(50) DEFAULT '' COMMENT '插件栏目唯一标识',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  `target` tinyint(1) DEFAULT '0' COMMENT '新窗口打开',
  `nofollow` tinyint(1) DEFAULT '0' COMMENT '防抓取',
  `typearcrank` int(10) DEFAULT '0' COMMENT '阅读权限：0=开放浏览，-1=待审核稿件',
  `empty_logic` tinyint(1) DEFAULT '0' COMMENT '空内容逻辑',
  `page_limit` varchar(10) DEFAULT '0' COMMENT '限制页面 1-栏目页面 0-文档页面',
  `total_arc` int(10) DEFAULT '0' COMMENT '栏目下文档数量',
  PRIMARY KEY (`id`),
  UNIQUE KEY `dirname` (`dirname`,`lang`) USING BTREE,
  KEY `parent_id` (`channeltype`,`parent_id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=96 DEFAULT CHARSET=utf8 COMMENT='文档栏目表';

-- -----------------------------
-- Records of `ey_arctype`
-- -----------------------------
INSERT INTO `ey_arctype` VALUES ('49', '6', '6', '0', '0', 'About', 'guanyuwomen', '/guanyuwomen', '/a/gongsijieshao', '{栏目目录}/index.html', '{栏目目录}/{Y}{M}{D}/{aid}.html', '', '0', '', '/eyou/uploads/allimg/20220411/1-220411111311316.jpg', 'lists_single.htm', '', 'About', '', '', '1', '0', '0', '1', '0', '0', '1', '1', '', 'en', '1649638273', '1649673997', '0', '0', '0', '1', '0', '0');
INSERT INTO `ey_arctype` VALUES ('3', '6', '6', '0', '0', '关于我们', 'guanyuwomen', '/guanyuwomen', '/a/gongsijieshao', '{栏目目录}/index.html', '{栏目目录}/{Y}{M}{D}/{aid}.html', '', '0', '', '/eyou/uploads/allimg/20220411/1-220411111311316.jpg', 'lists_single.htm', '', '关于我们', '', '', '1', '0', '0', '1', '0', '0', '1', '1', '', 'cn', '1649638273', '1649673997', '0', '0', '0', '1', '0', '0');
INSERT INTO `ey_arctype` VALUES ('4', '6', '1', '0', '0', '产品中心', 'chanpinzhongxin', '/chanpinzhongxin', '/a/lvcha', '{栏目目录}/list_{tid}_{page}.html', '{栏目目录}/{Y}{M}{D}/{aid}.html', 'Product', '0', '', '/eyou/uploads/allimg/20220411/1-220411144925449.jpg', 'lists_article_pic.htm', 'view_article_pic.htm', '产品中心', '', '', '2', '0', '0', '1', '0', '0', '1', '1', '', 'cn', '1649638273', '1649674020', '0', '0', '0', '0', '0', '13');
INSERT INTO `ey_arctype` VALUES ('5', '6', '6', '0', '0', '招商加盟', 'zhaoshangjiameng', '/zhaoshangjiameng', '/a/jiamengyoushi', '{栏目目录}/index.html', '{栏目目录}/{Y}{M}{D}/{aid}.html', '', '0', '', '/eyou/uploads/allimg/20220411/1-2204111515033H.jpg', 'lists_single.htm', '', '招商加盟', '', '', '3', '0', '0', '1', '0', '0', '1', '1', '', 'cn', '1649638273', '1649674095', '0', '0', '0', '1', '0', '0');
INSERT INTO `ey_arctype` VALUES ('6', '6', '1', '0', '0', '新闻资讯', 'xinwenzixun', '/xinwenzixun', '/a/gongsixinwen', '{栏目目录}/list_{tid}_{page}.html', '{栏目目录}/{Y}{M}{D}/{aid}.html', 'News', '0', '', '/eyou/uploads/allimg/20220411/1-220411151525G1.jpg', 'lists_article.htm', 'view_article.htm', '新闻资讯', '', '', '4', '0', '0', '1', '0', '0', '1', '1', '', 'cn', '1649638273', '1649674071', '0', '0', '0', '0', '0', '11');
INSERT INTO `ey_arctype` VALUES ('7', '6', '6', '0', '0', '服务中心', 'fuwuzhongxin', '/fuwuzhongxin', '/a/fuwulinian', '{栏目目录}/index.html', '{栏目目录}/{Y}{M}{D}/{aid}.html', '', '0', '', '/eyou/uploads/allimg/20220411/1-22041115332a00.jpg', 'lists_single.htm', '', '服务中心', '', '', '5', '0', '0', '1', '0', '0', '1', '1', '', 'cn', '1649638273', '1649674048', '0', '0', '0', '1', '0', '0');
INSERT INTO `ey_arctype` VALUES ('8', '6', '6', '0', '0', '联系我们', 'lianxiwomen', '/lianxiwomen', '/a/lianxiwomen', '{栏目目录}/index.html', '{栏目目录}/{Y}{M}{D}/{aid}.html', '', '0', '', '/eyou/uploads/allimg/20220411/1-2204111515033H.jpg', 'lists_single_contact.htm', '', '联系我们', '', '', '6', '0', '0', '1', '0', '0', '1', '1', '', 'cn', '1649638273', '1649674043', '0', '0', '0', '1', '0', '0');
INSERT INTO `ey_arctype` VALUES ('15', '6', '6', '3', '3', '公司介绍', 'gongsijieshao', '/guanyuwomen/gongsijieshao', '/a/gongsijieshao/gongsijieshao872', '{栏目目录}/index.html', '{栏目目录}/{Y}{M}{D}/{aid}.html', '', '1', '', '', 'lists_single.htm', '', '公司介绍', '', '', '1', '0', '0', '1', '0', '0', '1', '1', '', 'cn', '1649638273', '1649674154', '0', '0', '0', '1', '0', '0');
INSERT INTO `ey_arctype` VALUES ('16', '6', '6', '3', '3', '企业文化', 'qiyewenhua', '/guanyuwomen/qiyewenhua', '/a/gongsijieshao/qiyewenhua', '{栏目目录}/list_{tid}_{page}.html', '{栏目目录}/{Y}{M}{D}/{aid}.html', '', '1', '', '', 'lists_single.htm', '', '企业文化', '', '', '2', '0', '0', '1', '0', '0', '1', '1', '', 'cn', '1649638273', '1649674160', '0', '0', '0', '1', '0', '0');
INSERT INTO `ey_arctype` VALUES ('17', '6', '1', '3', '3', '企业荣誉', 'qiyerongyu', '/guanyuwomen/qiyerongyu', '/a/gongsijieshao/qiyerongyu', '{栏目目录}/list_{tid}_{page}.html', '{栏目目录}/{Y}{M}{D}/{aid}.html', '', '1', '', '', 'lists_article_img.htm', 'view_article.htm', '企业荣誉', '', '', '3', '0', '0', '1', '0', '0', '1', '1', '', 'cn', '1649638273', '1649674167', '0', '0', '0', '0', '0', '5');
INSERT INTO `ey_arctype` VALUES ('18', '6', '6', '3', '3', '人才招聘', 'rencaizhaopin', '/guanyuwomen/rencaizhaopin', '/a/gongsijieshao/rencaizhaopin', '{栏目目录}/list_{tid}_{page}.html', '{栏目目录}/{Y}{M}{D}/{aid}.html', '', '1', '', '', 'lists_single.htm', '', '人才招聘', '', '', '4', '0', '0', '1', '0', '0', '1', '1', '', 'cn', '1649638273', '1649674173', '0', '0', '0', '1', '0', '0');
INSERT INTO `ey_arctype` VALUES ('19', '6', '1', '4', '4', '绿茶', 'lvcha', '/chanpinzhongxin/lvcha', '/a/lvcha/lvcha888', '{栏目目录}/list_{tid}_{page}.html', '{栏目目录}/{Y}{M}{D}/{aid}.html', '', '1', '', '', 'lists_article_pic.htm', 'view_article_pic.htm', '绿茶', '', '', '1', '0', '0', '1', '0', '0', '1', '1', '', 'cn', '1649638273', '1649674130', '0', '0', '0', '0', '0', '5');
INSERT INTO `ey_arctype` VALUES ('20', '6', '1', '4', '4', '红茶', 'hongcha', '/chanpinzhongxin/hongcha', '/a/lvcha/hongcha', '{栏目目录}/list_{tid}_{page}.html', '{栏目目录}/{Y}{M}{D}/{aid}.html', '', '1', '', '', 'lists_article_pic.htm', 'view_article_pic.htm', '红茶', '', '', '2', '0', '0', '1', '0', '0', '1', '1', '', 'cn', '1649638273', '1649674136', '0', '0', '0', '0', '0', '4');
INSERT INTO `ey_arctype` VALUES ('21', '6', '1', '4', '4', '花茶', 'huacha', '/chanpinzhongxin/huacha', '/a/lvcha/huacha', '{栏目目录}/list_{tid}_{page}.html', '{栏目目录}/{Y}{M}{D}/{aid}.html', '', '1', '', '', 'lists_article_pic.htm', 'view_article_pic.htm', '花茶', '', '', '3', '0', '0', '1', '0', '0', '1', '1', '', 'cn', '1649638273', '1649674142', '0', '0', '0', '0', '0', '4');
INSERT INTO `ey_arctype` VALUES ('22', '6', '6', '5', '5', '加盟优势', 'jiamengyoushi', '/zhaoshangjiameng/jiamengyoushi', '/a/jiamengyoushi/jiamengyoushi929', '{栏目目录}/index.html', '{栏目目录}/{Y}{M}{D}/{aid}.html', '', '1', '', '', 'lists_single.htm', '', '加盟优势', '', '', '1', '0', '0', '1', '0', '0', '1', '1', '', 'cn', '1649638273', '1649674102', '0', '0', '0', '1', '0', '0');
INSERT INTO `ey_arctype` VALUES ('23', '6', '6', '5', '5', '加盟流程', 'jiamengliucheng', '/zhaoshangjiameng/jiamengliucheng', '/a/jiamengyoushi/jiamengliucheng', '{栏目目录}/list_{tid}_{page}.html', '{栏目目录}/{Y}{M}{D}/{aid}.html', '', '1', '', '', 'lists_single.htm', '', '加盟流程', '', '', '2', '0', '0', '1', '0', '0', '1', '1', '', 'cn', '1649638273', '1649674110', '0', '0', '0', '1', '0', '0');
INSERT INTO `ey_arctype` VALUES ('24', '6', '6', '5', '5', '加盟条件', 'jiamengtiaojian', '/zhaoshangjiameng/jiamengtiaojian', '/a/jiamengyoushi/jiamengtiaojian', '{栏目目录}/list_{tid}_{page}.html', '{栏目目录}/{Y}{M}{D}/{aid}.html', '', '1', '', '', 'lists_single.htm', '', '加盟条件', '', '', '3', '0', '0', '1', '0', '0', '1', '1', '', 'cn', '1649638273', '1649674116', '0', '0', '0', '1', '0', '0');
INSERT INTO `ey_arctype` VALUES ('25', '6', '6', '5', '5', '加盟政策', 'jiamengzhengce', '/zhaoshangjiameng/jiamengzhengce', '/a/jiamengyoushi/jiamengzhengce', '{栏目目录}/list_{tid}_{page}.html', '{栏目目录}/{Y}{M}{D}/{aid}.html', '', '1', '', '', 'lists_single.htm', '', '加盟政策', '', '', '4', '0', '0', '1', '0', '0', '1', '1', '', 'cn', '1649638273', '1649674122', '0', '0', '0', '1', '0', '0');
INSERT INTO `ey_arctype` VALUES ('26', '6', '1', '6', '6', '公司新闻', 'gongsixinwen', '/xinwenzixun/gongsixinwen', '/a/gongsixinwen/gongsixinwen231', '{栏目目录}/list_{tid}_{page}.html', '{栏目目录}/{Y}{M}{D}/{aid}.html', '', '1', '', '', 'lists_article.htm', 'view_article.htm', '公司新闻', '', '', '1', '0', '0', '1', '0', '0', '1', '1', '', 'cn', '1649638273', '1649674079', '0', '0', '0', '0', '0', '6');
INSERT INTO `ey_arctype` VALUES ('27', '6', '1', '6', '6', '行业动态', 'xingyedongtai', '/xinwenzixun/xingyedongtai', '/a/gongsixinwen/xingyedongtai', '{栏目目录}/list_{tid}_{page}.html', '{栏目目录}/{Y}{M}{D}/{aid}.html', '', '1', '', '', 'lists_article.htm', 'view_article.htm', '行业动态', '', '', '2', '0', '0', '1', '0', '0', '1', '1', '', 'cn', '1649638273', '1649674086', '0', '0', '0', '0', '0', '5');
INSERT INTO `ey_arctype` VALUES ('29', '6', '6', '7', '7', '服务理念', 'fuwulinian', '/fuwuzhongxin/fuwulinian', '/a/fuwulinian/fuwulinian468', '{栏目目录}/index.html', '{栏目目录}/{Y}{M}{D}/{aid}.html', '', '1', '', '', 'lists_single.htm', '', '服务理念', '', '', '1', '0', '0', '1', '0', '0', '1', '1', '', 'cn', '1649638273', '1649674056', '0', '0', '0', '1', '0', '0');
INSERT INTO `ey_arctype` VALUES ('30', '6', '1', '7', '7', '常见问题', 'changjianwenti', '/fuwuzhongxin/changjianwenti', '/a/fuwulinian/changjianwenti', '{栏目目录}/list_{tid}_{page}.html', '{栏目目录}/{Y}{M}{D}/{aid}.html', '', '1', '', '', 'lists_article_wenti.htm', 'view_article_news.htm', '常见问题', '', '', '2', '0', '0', '1', '0', '0', '1', '1', '', 'cn', '1649638273', '1649674063', '0', '0', '0', '0', '0', '6');
INSERT INTO `ey_arctype` VALUES ('50', '6', '6', '49', '49', 'Company introduction', 'gongsijieshao', '/guanyuwomen/gongsijieshao', '/a/gongsijieshao/gongsijieshao872', '{栏目目录}/index.html', '{栏目目录}/{Y}{M}{D}/{aid}.html', '', '1', '', '', 'lists_single.htm', '', 'Company introduction', '', '', '1', '0', '0', '1', '0', '0', '1', '1', '', 'en', '1649638273', '1649674154', '0', '0', '0', '1', '0', '0');
INSERT INTO `ey_arctype` VALUES ('51', '6', '6', '49', '49', 'Enterprise Culture', 'qiyewenhua', '/guanyuwomen/qiyewenhua', '/a/gongsijieshao/qiyewenhua', '{栏目目录}/index.html', '{栏目目录}/{Y}{M}{D}/{aid}.html', '', '1', '', '', 'lists_single.htm', '', 'Enterprise Culture', '', '', '2', '0', '0', '1', '0', '0', '1', '1', '', 'en', '1649638273', '1649674160', '0', '0', '0', '1', '0', '0');
INSERT INTO `ey_arctype` VALUES ('52', '6', '1', '49', '49', 'Enterprise Honor', 'qiyerongyu', '/guanyuwomen/qiyerongyu', '/a/gongsijieshao/qiyerongyu', '{栏目目录}/list_{tid}_{page}.html', '{栏目目录}/{Y}{M}{D}/{aid}.html', '', '1', '', '', 'lists_article_img.htm', 'view_article.htm', 'Enterprise Honor', '', '', '3', '0', '0', '1', '0', '0', '1', '1', '', 'en', '1649638273', '1649674167', '0', '0', '0', '0', '0', '0');
INSERT INTO `ey_arctype` VALUES ('53', '6', '6', '49', '49', 'Talent Recruitment', 'rencaizhaopin', '/guanyuwomen/rencaizhaopin', '/a/gongsijieshao/rencaizhaopin', '{栏目目录}/index.html', '{栏目目录}/{Y}{M}{D}/{aid}.html', '', '1', '', '', 'lists_single.htm', '', 'Talent Recruitment', '', '', '4', '0', '0', '1', '0', '0', '1', '1', '', 'en', '1649638273', '1649674173', '0', '0', '0', '1', '0', '0');
INSERT INTO `ey_arctype` VALUES ('54', '6', '1', '0', '0', 'Product', 'chanpinzhongxin', '/chanpinzhongxin', '/a/lvcha', '{栏目目录}/list_{tid}_{page}.html', '{栏目目录}/{Y}{M}{D}/{aid}.html', '', '0', '', '/eyou/uploads/allimg/20220411/1-220411144925449.jpg', 'lists_article_pic.htm', 'view_article_pic.htm', 'Product', '', '', '2', '0', '0', '1', '0', '0', '1', '1', '', 'en', '1649638273', '1649674020', '0', '0', '0', '0', '0', '0');
INSERT INTO `ey_arctype` VALUES ('55', '6', '1', '54', '54', 'Green tea', 'lvcha', '/chanpinzhongxin/lvcha', '/a/lvcha/lvcha888', '{栏目目录}/list_{tid}_{page}.html', '{栏目目录}/{Y}{M}{D}/{aid}.html', '', '1', '', '', 'lists_article_pic.htm', 'view_article_pic.htm', 'Green tea', '', '', '1', '0', '0', '1', '0', '0', '1', '1', '', 'en', '1649638273', '1649674130', '0', '0', '0', '0', '0', '0');
INSERT INTO `ey_arctype` VALUES ('56', '6', '1', '54', '54', 'Black tea', 'hongcha', '/chanpinzhongxin/hongcha', '/a/lvcha/hongcha', '{栏目目录}/list_{tid}_{page}.html', '{栏目目录}/{Y}{M}{D}/{aid}.html', '', '1', '', '', 'lists_article_pic.htm', 'view_article_pic.htm', 'Black tea', '', '', '2', '0', '0', '1', '0', '0', '1', '1', '', 'en', '1649638273', '1649674136', '0', '0', '0', '0', '0', '0');
INSERT INTO `ey_arctype` VALUES ('57', '6', '1', '54', '54', 'Jasmine tea', 'huacha', '/chanpinzhongxin/huacha', '/a/lvcha/huacha', '{栏目目录}/list_{tid}_{page}.html', '{栏目目录}/{Y}{M}{D}/{aid}.html', '', '1', '', '', 'lists_article_pic.htm', 'view_article_pic.htm', 'Jasmine tea', '', '', '3', '0', '0', '1', '0', '0', '1', '1', '', 'en', '1649638273', '1649674142', '0', '0', '0', '0', '0', '0');
INSERT INTO `ey_arctype` VALUES ('58', '6', '6', '0', '0', 'Joining', 'zhaoshangjiameng', '/zhaoshangjiameng', '/a/jiamengyoushi', '{栏目目录}/index.html', '{栏目目录}/{Y}{M}{D}/{aid}.html', '', '0', '', '/eyou/uploads/allimg/20220411/1-2204111515033H.jpg', 'lists_single.htm', '', 'Joining', '', '', '3', '0', '0', '1', '0', '0', '1', '1', '', 'en', '1649638273', '1649674095', '0', '0', '0', '1', '0', '0');
INSERT INTO `ey_arctype` VALUES ('59', '6', '6', '58', '58', 'Advantages joining', 'jiamengyoushi', '/zhaoshangjiameng/jiamengyoushi', '/a/jiamengyoushi/jiamengyoushi929', '{栏目目录}/index.html', '{栏目目录}/{Y}{M}{D}/{aid}.html', '', '1', '', '', 'lists_single.htm', '', 'Advantages joining', '', '', '1', '0', '0', '1', '0', '0', '1', '1', '', 'en', '1649638273', '1649674102', '0', '0', '0', '1', '0', '0');
INSERT INTO `ey_arctype` VALUES ('60', '6', '6', '58', '58', 'Join process', 'jiamengliucheng', '/zhaoshangjiameng/jiamengliucheng', '/a/jiamengyoushi/jiamengliucheng', '{栏目目录}/index.html', '{栏目目录}/{Y}{M}{D}/{aid}.html', '', '1', '', '', 'lists_single.htm', '', 'Join process', '', '', '2', '0', '0', '1', '0', '0', '1', '1', '', 'en', '1649638273', '1649674110', '0', '0', '0', '1', '0', '0');
INSERT INTO `ey_arctype` VALUES ('61', '6', '6', '58', '58', 'Join conditions', 'jiamengtiaojian', '/zhaoshangjiameng/jiamengtiaojian', '/a/jiamengyoushi/jiamengtiaojian', '{栏目目录}/index.html', '{栏目目录}/{Y}{M}{D}/{aid}.html', '', '1', '', '', 'lists_single.htm', '', 'Join conditions', '', '', '3', '0', '0', '1', '0', '0', '1', '1', '', 'en', '1649638273', '1649674116', '0', '0', '0', '1', '0', '0');
INSERT INTO `ey_arctype` VALUES ('62', '6', '6', '58', '58', 'Alliance policy', 'jiamengzhengce', '/zhaoshangjiameng/jiamengzhengce', '/a/jiamengyoushi/jiamengzhengce', '{栏目目录}/index.html', '{栏目目录}/{Y}{M}{D}/{aid}.html', '', '1', '', '', 'lists_single.htm', '', 'Alliance policy', '', '', '4', '0', '0', '1', '0', '0', '1', '1', '', 'en', '1649638273', '1649674122', '0', '0', '0', '1', '0', '0');
INSERT INTO `ey_arctype` VALUES ('63', '6', '1', '0', '0', 'News', 'xinwenzixun', '/xinwenzixun', '/a/gongsixinwen', '{栏目目录}/list_{tid}_{page}.html', '{栏目目录}/{Y}{M}{D}/{aid}.html', '', '0', '', '/eyou/uploads/allimg/20220411/1-220411151525G1.jpg', 'lists_article.htm', 'view_article.htm', 'News', '', '', '4', '0', '0', '1', '0', '0', '1', '1', '', 'en', '1649638273', '1649674071', '0', '0', '0', '0', '0', '0');
INSERT INTO `ey_arctype` VALUES ('64', '6', '1', '63', '63', 'Company News', 'gongsixinwen', '/xinwenzixun/gongsixinwen', '/a/gongsixinwen/gongsixinwen231', '{栏目目录}/list_{tid}_{page}.html', '{栏目目录}/{Y}{M}{D}/{aid}.html', '', '1', '', '', 'lists_article.htm', 'view_article.htm', 'Company News', '', '', '1', '0', '0', '1', '0', '0', '1', '1', '', 'en', '1649638273', '1649674079', '0', '0', '0', '0', '0', '0');
INSERT INTO `ey_arctype` VALUES ('65', '6', '1', '63', '63', 'Industry News', 'xingyedongtai', '/xinwenzixun/xingyedongtai', '/a/gongsixinwen/xingyedongtai', '{栏目目录}/list_{tid}_{page}.html', '{栏目目录}/{Y}{M}{D}/{aid}.html', '', '1', '', '', 'lists_article.htm', 'view_article.htm', 'Industry News', '', '', '2', '0', '0', '1', '0', '0', '1', '1', '', 'en', '1649638273', '1649674086', '0', '0', '0', '0', '0', '0');
INSERT INTO `ey_arctype` VALUES ('67', '6', '6', '0', '0', 'Service', 'fuwuzhongxin', '/fuwuzhongxin', '/a/fuwulinian', '{栏目目录}/index.html', '{栏目目录}/{Y}{M}{D}/{aid}.html', '', '0', '', '/eyou/uploads/allimg/20220411/1-22041115332a00.jpg', 'lists_single.htm', '', 'Service', '', '', '5', '0', '0', '1', '0', '0', '1', '1', '', 'en', '1649638273', '1649674048', '0', '0', '0', '1', '0', '0');
INSERT INTO `ey_arctype` VALUES ('68', '6', '6', '67', '67', 'Service Concept', 'fuwulinian', '/fuwuzhongxin/fuwulinian', '/a/fuwulinian/fuwulinian468', '{栏目目录}/index.html', '{栏目目录}/{Y}{M}{D}/{aid}.html', '', '1', '', '', 'lists_single.htm', '', 'Service Concept', '', '', '1', '0', '0', '1', '0', '0', '1', '1', '', 'en', '1649638273', '1649674056', '0', '0', '0', '1', '0', '0');
INSERT INTO `ey_arctype` VALUES ('69', '6', '1', '67', '67', 'FAQ', 'changjianwenti', '/fuwuzhongxin/changjianwenti', '/a/fuwulinian/changjianwenti', '{栏目目录}/list_{tid}_{page}.html', '{栏目目录}/{Y}{M}{D}/{aid}.html', '', '1', '', '', 'lists_article_wenti.htm', 'view_article.htm', 'FAQ', '', '', '2', '0', '0', '1', '0', '0', '1', '1', '', 'en', '1649638273', '1649674063', '0', '0', '0', '0', '0', '0');
INSERT INTO `ey_arctype` VALUES ('70', '6', '6', '0', '0', 'Contact', 'lianxiwomen', '/lianxiwomen', '/a/lianxiwomen', '{栏目目录}/index.html', '{栏目目录}/{Y}{M}{D}/{aid}.html', '', '0', '', '/eyou/uploads/allimg/20220411/1-2204111515033H.jpg', 'lists_single_contact.htm', '', 'Contact', '', '', '6', '0', '0', '1', '0', '0', '1', '1', '', 'en', '1649638273', '1649674043', '0', '0', '0', '1', '0', '0');

-- -----------------------------
-- Table structure for `ey_article17_content`
-- -----------------------------
DROP TABLE IF EXISTS `ey_article17_content`;
CREATE TABLE `ey_article17_content` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `aid` int(10) DEFAULT '0' COMMENT '文档ID',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  `content` longtext COMMENT '文章内容',
  `vrdz` varchar(251) NOT NULL DEFAULT '' COMMENT '全景地址',
  PRIMARY KEY (`id`),
  KEY `aid` (`aid`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=9 DEFAULT CHARSET=utf8 COMMENT='附加表';

-- -----------------------------
-- Records of `ey_article17_content`
-- -----------------------------
INSERT INTO `ey_article17_content` VALUES ('1', '34', '1635217270', '1635217270', '富力湾海南富力湾与夏威夷、加勒比海、巴厘岛这些世界著名的旅游胜地同在一条黄金北纬18&amp;deg;上，是富力集团在海南布局的唯一一个高端热带滨海休闲度假社区，且紧邻亚洲大型海洋主题公园-富力湾海洋欢乐世界，轻松享有休闲惬意的度假生活。', 'https://720yun.com/t/83vkuwrw01w?scene_id=40544503');
INSERT INTO `ey_article17_content` VALUES ('2', '35', '1635217270', '1635217270', '合景汀澜海岸凝萃合景泰富17年国际豪宅开发经验而倾力打造的旅游地产新作，抢占国际旅游岛未来高端的珍珠海岸核心区位，荟萃众多奢侈度假配套。更携手大师团队定制一线海幕豪宅，在这里找到如塞舌尔般的私密海岸天堂。', 'https://720yun.com/t/80vkc72wdpe?scene_id=64311939');
INSERT INTO `ey_article17_content` VALUES ('3', '36', '1635217270', '1635217270', '&amp;ldquo;海棠华着&amp;rdquo;位于中国三亚海棠湾-中国国家海岸，三亚海棠湾海棠北路18号（凯宾斯基酒店旁），项目占地面积为29.3万平米，容积率0.4，绿化率62.2%，地上建筑面积约12万平米，一共分为三期开发，一期为174套别墅产品，主力户型为约300-400平米（使用面积）的院落别墅户型，是三亚一线临海别墅群，配建拥有百年历史的华尔道夫酒店，该酒店素有&amp;ldquo;总统行宫&amp;rdquo;的称号。', 'https://720yun.com/t/58vkc72l5iq?scene_id=64260374');
INSERT INTO `ey_article17_content` VALUES ('4', '37', '1635217270', '1635217270', '融创日月湾，拥有目前海南的北纬 18&amp;deg;绝品度假双岛。日月湾旅游度假区总规划面积约3.45万亩，，日月岛合计约 1492 亩，其中日岛约 840亩，总建筑面积约 76 万㎡，建筑密度 16.5%，绿化率高达 52%。从日月湾高速出口至项目1500米路程，途经滨海大道，可以一览日月湾迷人的滨海风光。经过与陆地连接的日岛跨海大桥，可以领略别样的海岛风情。&amp;nbsp;', 'https://720yun.com/t/83vkuwrw01w?scene_id=40544503');
INSERT INTO `ey_article17_content` VALUES ('5', '38', '1635217270', '1635217270', '臻园一期&amp;bull;洋房概况：前期共推出108套洋房，总高6层，一梯两户，建筑面积75平，2房2厅一厨一卫两阳台，得房率高，性价比高。板楼设计，通透户型，双阳台设计，带品质精装，满足你的度假、投资的双重需求。海南第一个温泉度假区，东南亚异域风情小镇，侨乡之城，享受成熟的商业配套和淳朴的小镇风情。', 'https://720yun.com/t/3fvkumqh5ib?scene_id=42183767');
INSERT INTO `ey_article17_content` VALUES ('6', '39', '1635217270', '1635217270', '万科海上大都会左岸项目位于三亚市城央湾区三亚湾，南临20公里椰梦长廊，步行200米即可畅享沙滩大海。三亚湾路和新城路围绕在项目南北两侧，与三亚市核心干道凤凰路、规划核心干道三横路毗邻。导航距离凤凰机场约6公里，导航距离三亚动车站约8公里。周边有多条公交及旅游线路，直达海棠湾免税城，亚龙湾，大小洞天，城市乐园等，交通四通八达，非常便利。', 'https://720yun.com/t/2fvkc7phzr9?scene_id=64241384');
INSERT INTO `ey_article17_content` VALUES ('7', '40', '1635217270', '1635217270', '梦幻不夜城，蜈支洲岛，南田温泉，水稻国家公园，海中海高尔夫，亚特兰蒂斯水上乐园等。', 'https://720yun.com/t/05vku72b7ql?scene_id=40965268');
INSERT INTO `ey_article17_content` VALUES ('8', '41', '1635217270', '1635217270', '龙栖海岸位于海南&amp;middot;大三亚&amp;middot;龙栖湾，龙栖湾滨海旅游度假区，由海南中城投开发建设。北纬18&amp;deg;以南，307亩观海大城，南北通透两梯两户。56㎡海豚大阳台，拥16公里龙栖湾首栖霞海岸，观海阅山，不负盛景。邻南中国海上文旅基地、南繁基地、万豪酒店。项目釆用两梯两户纯板式洋房设计，户型设计合理，全明格局，公摊少、采光足、南北通透，电梯入户。', 'https://720yun.com/t/5bvkcy1ygdl?scene_id=62651738');

-- -----------------------------
-- Table structure for `ey_article_content`
-- -----------------------------
DROP TABLE IF EXISTS `ey_article_content`;
CREATE TABLE `ey_article_content` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `aid` int(10) DEFAULT '0' COMMENT '文档ID',
  `content` longtext COMMENT '内容详情',
  `content_ey_m` longtext COMMENT '手机端内容详情',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`),
  KEY `news_id` (`aid`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=120 DEFAULT CHARSET=utf8 COMMENT='资讯内容表_存储正常内容';

-- -----------------------------
-- Records of `ey_article_content`
-- -----------------------------
INSERT INTO `ey_article_content` VALUES ('6', '6', '', '', '1649638274', '1649638274');
INSERT INTO `ey_article_content` VALUES ('7', '7', '', '', '1649638274', '1649638274');
INSERT INTO `ey_article_content` VALUES ('8', '8', '', '', '1649638274', '1649638274');
INSERT INTO `ey_article_content` VALUES ('9', '9', '', '', '1649638274', '1649638274');
INSERT INTO `ey_article_content` VALUES ('10', '10', '', '', '1649638274', '1649638274');
INSERT INTO `ey_article_content` VALUES ('16', '16', '来自福建武夷山原产，香气馥郁有兰花香，香高而持久，&amp;ldquo;岩韵&amp;rdquo;明显，耐冲泡。', '', '1649638274', '1649638274');
INSERT INTO `ey_article_content` VALUES ('19', '19', '来自福建武夷山原产，香气馥郁有兰花香，香高而持久，&amp;ldquo;岩韵&amp;rdquo;明显，耐冲泡。', '', '1649638274', '1649638274');
INSERT INTO `ey_article_content` VALUES ('21', '21', '茶叶外型细小紧秀，金、黄、黑相间，开汤汤色金黄，入喉甘甜。其水、香、味似果、蜜、花、薯等综合香型，滋味鲜活甘爽，喉韵悠长', '', '1649638274', '1649638274');
INSERT INTO `ey_article_content` VALUES ('23', '23', '原料精选云南大叶种细嫩晒青毛茶，条索壮实，芽头肥硕显毫，发酵成度适中，汤色红尚浓，滋味醇厚回甘，苦涩味转化适度，香气纯正，显幽幽的茶香。', '', '1649638274', '1649638274');
INSERT INTO `ey_article_content` VALUES ('24', '24', '茶叶外型细小紧秀，金、黄、黑相间，开汤汤色金黄，入喉甘甜。其水、香、味似果、蜜、花、薯等综合香型，滋味鲜活甘爽，喉韵悠长', '', '1649638274', '1649638274');
INSERT INTO `ey_article_content` VALUES ('27', '27', '原料精选云南大叶种细嫩晒青毛茶，条索壮实，芽头肥硕显毫，发酵成度适中，汤色红尚浓，滋味醇厚回甘，苦涩味转化适度，香气纯正，显幽幽的茶香。', '', '1649638274', '1649638274');
INSERT INTO `ey_article_content` VALUES ('28', '28', '原料精选云南大叶种细嫩晒青毛茶，条索壮实，芽头肥硕显毫，发酵成度适中，汤色红尚浓，滋味醇厚回甘，苦涩味转化适度，香气纯正，显幽幽的茶香。', '', '1649638274', '1649638274');
INSERT INTO `ey_article_content` VALUES ('30', '30', '原料精选云南大叶种细嫩晒青毛茶，条索壮实，芽头肥硕显毫，发酵成度适中，汤色红尚浓，滋味醇厚回甘，苦涩味转化适度，香气纯正，显幽幽的茶香。', '', '1649638274', '1649638274');
INSERT INTO `ey_article_content` VALUES ('32', '32', '原料精选云南大叶种细嫩晒青毛茶，条索壮实，芽头肥硕显毫，发酵成度适中，汤色红尚浓，滋味醇厚回甘，苦涩味转化适度，香气纯正，显幽幽的茶香。', '', '1649638274', '1649638274');
INSERT INTO `ey_article_content` VALUES ('34', '34', '茶叶外型细小紧秀，金、黄、黑相间，开汤汤色金黄，入喉甘甜。其水、香、味似果、蜜、花、薯等综合香型，滋味鲜活甘爽，喉韵悠长', '', '1649638274', '1649638274');
INSERT INTO `ey_article_content` VALUES ('36', '36', '茶叶外型细小紧秀，金、黄、黑相间，开汤汤色金黄，入喉甘甜。其水、香、味似果、蜜、花、薯等综合香型，滋味鲜活甘爽，喉韵悠长', '', '1649638274', '1649638274');
INSERT INTO `ey_article_content` VALUES ('38', '38', '茶叶外型细小紧秀，金、黄、黑相间，开汤汤色金黄，入喉甘甜。其水、香、味似果、蜜、花、薯等综合香型，滋味鲜活甘爽，喉韵悠长', '', '1649638274', '1649638274');
INSERT INTO `ey_article_content` VALUES ('40', '40', '原料精选云南大叶种细嫩晒青毛茶，条索壮实，芽头肥硕显毫，发酵成度适中，汤色红尚浓，滋味醇厚回甘，苦涩味转化适度，香气纯正，显幽幽的茶香。', '', '1649638274', '1649638274');
INSERT INTO `ey_article_content` VALUES ('42', '42', '&lt;p&gt;\r\n	看到新加坡的一则消息，有个叫沈罗连的医生拼命替女人拍照片，从18岁到40岁，已经拍了10000个。&lt;/p&gt;\r\n&lt;p&gt;\r\n	&amp;nbsp;&lt;/p&gt;\r\n&lt;p&gt;\r\n	沈医生是为了他的职业而这么做的，他是位整容专家，但是要求女人让他拍照时还是有困难的，他说：&amp;ldquo;她们带怀疑的眼光看着我，把我当成色狼。&amp;rdquo;&lt;/p&gt;\r\n&lt;p&gt;\r\n	&amp;nbsp;&lt;/p&gt;\r\n&lt;p&gt;\r\n	好在，有个女学习医师帮他的忙，先代他搭路才顺利地完成任务。他认为把新加坡女子的面貌综合起来，找出一个理想的样子，好过模仿西方女人。&lt;/p&gt;\r\n&lt;p&gt;\r\n	&amp;nbsp;&lt;/p&gt;\r\n&lt;p&gt;\r\n	&amp;ldquo;我们的女子双眼之间隔得太开，&amp;rdquo;沈医生说，&amp;ldquo;鼻子太大又太扁，额头太凸。但是这些缺点调和起来，还是有东方味道，如果根据洋妞去改，反而是四不像。&amp;rdquo;&lt;/p&gt;\r\n&lt;p&gt;\r\n	&amp;nbsp;&lt;/p&gt;\r\n&lt;p&gt;\r\n	一般上，新加坡人认为电视明星郑惠玉的样子相当的理想，但是能有多少个郑惠玉呢？稀少才觉得珍贵呀，大家都像郑惠玉，那么新加坡人就会欣赏那些额头小、双眼间宽、鼻子大的女人了。我认为自然还是可爱的。&lt;/p&gt;\r\n&lt;p&gt;\r\n	&amp;nbsp;&lt;/p&gt;\r\n&lt;p&gt;\r\n	沈医生有不同的见解，他说：&amp;ldquo;其他的整容医生对双眼太宽的解救方法是把鼻子弄高，将鼻孔改窄，但这么做便不像一个东方女子。我的方法是将鼻端弄得更尖。&amp;rdquo;&lt;/p&gt;\r\n&lt;p&gt;\r\n	&amp;nbsp;&lt;/p&gt;\r\n&lt;p&gt;\r\n	哈，尖了还不是那个鬼样？&lt;/p&gt;\r\n&lt;p&gt;\r\n	&amp;nbsp;&lt;/p&gt;\r\n&lt;p&gt;\r\n	整容的女人，是没有自信心的女人。整过之后，一生便永远戴个假东西在脸上。何必呢！而且整失败的话永不翻身。如果成功，那更糟，会上瘾的，这里整整，那里整整，又跑出个黄夏蕙来。&lt;/p&gt;\r\n&lt;p&gt;\r\n	&amp;nbsp;&lt;/p&gt;\r\n&lt;p&gt;\r\n	美，的确占便宜。但是短暂得很，不会做人的话，一下子便生厌。有些女人一看平凡，但是愈聊愈觉得她们有味道，这完全是脑筋问题。&lt;/p&gt;\r\n&lt;p&gt;\r\n	&amp;nbsp;&lt;/p&gt;\r\n&lt;p&gt;\r\n	把钱花在增广学识上，或多旅行令心胸广阔，这是基本。要整容，不如先整心。&lt;/p&gt;\r\n', '', '1649638274', '1649638274');
INSERT INTO `ey_article_content` VALUES ('45', '45', '&lt;p&gt;\r\n	人们平常看世界的角度，主要可分为仰视、平视、俯视三种。&lt;/p&gt;\r\n&lt;p&gt;\r\n	平视，是最正常和最舒服的眼光，发自于从容的平常心，蕴含着成熟与自信，不卑不亢，不急不躁，有利于稳步前行，不容易摔跤出事。仰视，是用来看比我们高大的人和物的眼光角度，即所谓高山仰止。经常仰视，从好处来说，让我们知道天外有天，人外有人，学有榜样，比有标杆，不会如同井底之蛙，妄自尊大；从副作用来看，仰视久了，不仅会脖子酸疼，还往往会让我们心生自卑，觉得自己很渺小，事事处处不如人，总处于压抑状态。&lt;/p&gt;\r\n&lt;p&gt;\r\n	俯视，&amp;ldquo;一览众山小&amp;rdquo;，则是用来看比我们低的人和物的眼光角度。有些人成就不如我们，名气不如我们，社会地位不如我们，那么，当目光转向他们时，眼里就不免带有鄙视、势利也有怜悯。大多数时间里，我们常常会忽视他们，对其熟视无睹，因为，我们羡慕的眼光一直在盯着那些比我们更高的成功人士，忙着和那些巨富、名流比较高低，看得眼红心酸，比得筋疲力尽。&lt;/p&gt;\r\n&lt;p&gt;\r\n	从自然规律来看，一般来说，青年人喜欢仰视，&amp;ldquo;少年心事当拿云&amp;rdquo;，在他们眼里，没有几个能看得上的人，只有那些声名显赫的名家巨擘才会进入他们的视野。像刘邦看见秦始皇，就敢说&amp;ldquo;大丈夫当如是&amp;rdquo;，项羽比他还牛：&amp;ldquo;彼可取而代之。&amp;rdquo;人到中年，心态平和了，锋芒收敛了，也知道世道不易了，就会逐渐把眼光放平，不疾不徐地走在路上，有条不紊地奔向自己的目标。进入老态后，饱经风霜，阅人无数，&amp;ldquo;见惯秋月春风&amp;rdquo;，已不再迷恋功成名就、灯红酒绿，再加上腰驼了，背弯了，眼花了，自然不自然地就把俯视当成了习惯。&lt;/p&gt;\r\n&lt;p&gt;\r\n	当然，因人而异，也有的人一生都在仰视，一生都在瞄准更高目标。他可能活得很排场，很光鲜，但肯定也活得很疲惫，很仓促，只顾得一个个攻城拔寨，却来不及浏览风光，享受生活，其实他这一辈子也很冤枉。所以，当我们仰视得很累的时候，不妨低头看看，看看那些生活在社会底层的人们，他们虽然和我们是一样的人，但学历比我们低，收入比我们少，房子比我们小，工作不如我们体面，社会地位也逊于我们，永远默默无闻，在他们面前，我们常常有一种优越感，平时很有些不屑一顾，很少把眼光瞥向他们。&lt;/p&gt;\r\n&lt;p&gt;\r\n	其实，他们的生存智慧和社会价值并不比我们低，他们的贡献和劳动并不比我们少，我们没有什么高高在上的骄傲理由。而且，常和他们接触，还会有意想不到的收获。如果一个白领在职场拼搏得身心交瘁时，在市场竞争得你死我活时，利用喘息之际，低头看看街头的补鞋匠、修车人，走街串巷的小货郎、拾荒汉，你就会觉得，你即使再退十步、百步，也比他的生活水准高，何必还要再去为那些身外之物争得不亦乐乎呢？&lt;/p&gt;\r\n&lt;p&gt;\r\n	推而广之，一个官员正在为仕途不畅没有更上层楼而苦恼时，不妨低头看看属下百姓的日子，到他们家里坐坐，听听他们有什么难处，有什么期望；一个赚钱赚到手疼却还在为赚更多的钱而焦虑的老板，也可屈尊到手下的员工家里坐坐，看看他们都在想些什么，何苦何乐；一个为制定作战计划而绞尽脑汁的将军，不妨忙里偷闲，到士兵的大帐里转转，听听他们的想法和建议，一定会不虚此行。常低头看看，可能会让我们转变思路，也可能会使我们浮躁的心灵得到抚慰，会使我们狂热的欲望得到冷却，变成一个心理正常的人，而不是一台挣钱机器，一个职场狂人，一介钻营之徒。&lt;/p&gt;\r\n&lt;p&gt;\r\n	常低头看看，是休息也是放松，是充电也是减压，实乃智者之举。&lt;/p&gt;\r\n', '', '1649638274', '1649638274');
INSERT INTO `ey_article_content` VALUES ('46', '46', '&lt;p&gt;\r\n	因为想吃煮玉米，就一个人慢慢地走到超市去。路上经过公园，看到很多人在放风筝，忍不住停下前行脚步，转而走进公园。&lt;/p&gt;\r\n&lt;p&gt;\r\n	公园里，卖风筝和放风筝的人都很多，当然还有卖花的，卖孔明灯的，卖字画的，卖糖葫芦和各种小吃的... ...人来人往，好不热闹，只有在这里，才能体会到一点年的味道，感觉到一些春天的气息。&lt;/p&gt;\r\n&lt;p&gt;\r\n	公园里卖金鱼的摊位多了好几个，我一个一个地看过，忽然想起家里新添了一盆富贵竹，正好在那个透明的瓶子里，养两条小金鱼。&lt;/p&gt;\r\n&lt;p&gt;\r\n	我提了金鱼要走的时候，老板向我推荐鱼食，我这才想起这金鱼，还要吃东西的。想想以前养的那些金鱼，一个个都因为吃而死于非命，很有些后悔，但这金鱼已经付了钱了，我也只能拿着了。&lt;/p&gt;\r\n&lt;p&gt;\r\n	到超市买了煮玉米，一路走回家去。路过那条小河的时候，我把金鱼放生到河水里。到家的时候，两个女儿正在玩电脑，看到我，小女儿问：&lt;/p&gt;\r\n&lt;p&gt;\r\n	&amp;ldquo;妈妈，你怎么回来这么晚？&amp;rdquo;&lt;/p&gt;\r\n&lt;p&gt;\r\n	&amp;ldquo;我买了两条小金鱼，拿到河里去放生了。&amp;rdquo;&lt;/p&gt;\r\n&lt;p&gt;\r\n	&amp;ldquo;放生？金鱼？妈妈你没毛病吧？金鱼是不能放生的，它们是人工训化的观赏鱼，到了天然的河水里，是必死无疑的！&amp;rdquo;&lt;/p&gt;\r\n&lt;p&gt;\r\n	&amp;ldquo;耸人听闻！&amp;rdquo;我不相信，坐到电脑前上网查询。真的如女儿所说，金鱼是不能放生的。心里说不出是什么滋味，如果不是我一片好心，这金鱼兴许还能多活几天，这下可好，说不定一天就死了。&lt;/p&gt;\r\n&lt;p&gt;\r\n	然后我向女儿说我放生金鱼的时候，还想着会有一天，我到河边游玩时，河里到处都是红色的小金鱼。&lt;/p&gt;\r\n&lt;p&gt;\r\n	&amp;ldquo;妈妈，曾经有一个这样的故事，说的是二战时期，一个小女孩逃生的时候，匆忙间把自己喂养的金鱼，放生到河水里去。二战后她回到家乡的时候，河里满是小金鱼，从此衣食无着的小女孩，就以卖金鱼为生。&amp;rdquo;&lt;/p&gt;\r\n&lt;p&gt;\r\n	&amp;ldquo;你无意间的一点善举，也会带给你很多意外的惊喜，这个故事真好。&amp;rdquo;&lt;/p&gt;\r\n&lt;p&gt;\r\n	&amp;ldquo;其实，这个故事想说的是一种豁达的人生态度，那满河红色的小金鱼，就是对豁达人生的最好报答！&amp;rdquo;&lt;/p&gt;\r\n&lt;p&gt;\r\n	&amp;ldquo;对豁达人生的最好报答？&amp;rdquo;&lt;/p&gt;\r\n&lt;p&gt;\r\n	&amp;ldquo;是啊，老师说积德行善，是不求回报的，而豁达的人生态度，是一定会有回报的，而且那回报，也一定是出乎意料的丰厚！&amp;rdquo;&lt;/p&gt;\r\n&lt;p&gt;\r\n	&amp;ldquo;什么是豁达的人生态度呢？你老师告诉你了吗？&amp;rdquo;&lt;/p&gt;\r\n&lt;p&gt;\r\n	&amp;ldquo;没有，不过我觉得所谓的豁达，就是无论你身处何种境遇，心里永远充满希望！&amp;rdquo;&lt;/p&gt;\r\n&lt;p&gt;\r\n	谈话到此为止，我却呆呆地坐在电脑前，陷入了沉思。&lt;/p&gt;\r\n', '', '1649638274', '1649638274');
INSERT INTO `ey_article_content` VALUES ('49', '49', '&lt;p&gt;\r\n	电视上，又在报道关于二套房、三套房贷款的问题。有钱人就是好啊，可以买二套房、三套房，而很多小老百姓，连首套房子也买不起。&lt;/p&gt;\r\n&lt;p&gt;\r\n	也是电视上报道，说北京很多小区，入住率还不到30%。不仅仅是北京，我们这儿有一个别墅群，入住率几乎是0，除了警卫室里亮着灯，其它的地方，黑呼呼的一片，看着就觉得很吓人。&lt;/p&gt;\r\n&lt;p&gt;\r\n	贪，是人的天性，是所有人的天性！&lt;/p&gt;\r\n&lt;p&gt;\r\n	在网络上，经常转载别人的文章，看到许多人的空间里，转载的文章已经有好多，却还在不停地转载。开始的时候，我也这样，看到好内容、好题目、好图片，转载到自己的空间，想着有一天时间充足了，再慢慢地品味。可是，这些转载的文章，我们几乎是不看的。一是我们总是没有充足的时间，再说，我们也失去了从容淡定的心情，变得干什么都急于求成，都急功近利，都唯利是图，所以，那些文章基本上就是白转！但很多人还是忍不住转载、再转载&amp;middot;&amp;middot;&amp;middot;&amp;middot;&amp;middot;只觉得转到自己的空间，就是自己的了。&lt;/p&gt;\r\n&lt;p&gt;\r\n	其实，有些东西并不是你拥有了，就是你的了。转载了文章你不学习、不利用，是你的和不是你的，有什么区别呢？因而。后来再看到好东西，我就不转了。其实我们只为得到更多，只注重了拥有，却恰恰忘记了享用自己的所有！&lt;/p&gt;\r\n&lt;p&gt;\r\n	有了房子，却整天不回家，有了车却又懒得出门了。总觉得什么地方，只要想去就能长驱直入，因而那些曾经梦想着要去的地方，也变得不那么渴望了。&lt;/p&gt;\r\n&lt;p&gt;\r\n	没有了渴望，也没有了惊喜的日子，让人觉得生活是静止的。波澜不惊的生活，让很多人变得麻木、变得茫然、变得也无生趣！&lt;/p&gt;\r\n&lt;p&gt;\r\n	现代人，拥有越来越丰富的物质生活，却缺乏越来越丰美的心灵世界。&lt;/p&gt;\r\n&lt;p&gt;\r\n	侄女出国去了迪拜的帆船酒店。才刚刚两个月，就怎么都呆不下去了。问其原因，她痛心地说：&lt;/p&gt;\r\n&lt;p&gt;\r\n	&amp;ldquo;实在不忍心，每天看中国人在这儿丢脸！&amp;rdquo;&lt;/p&gt;\r\n&lt;p&gt;\r\n	中国人去了那儿，总是一路走一路问，不知道尊重工作人员，不懂得起码的礼貌，只觉得自己花钱了，就要可劲地折腾，总觉得自己花钱就可以高高在上，这不满意、那也不满意，折腾来折腾去，还常常不给人家小费。&lt;/p&gt;\r\n&lt;p&gt;\r\n	一边是吃住上的万分小气，一边是购物上的万分大方。他们常常一个团队要一套住房，常常连地板上都睡了人。而当地购物节的时候，除了工作人员，看到的几乎都是中国人。因此侄女常常有一种错觉：觉得自己是在中国，而不是在迪拜。到那儿的每个人都很疯狂，那种一掷千金的气势，真是活脱脱的暴发户形像啊！&lt;/p&gt;\r\n&lt;p&gt;\r\n	仅此也就罢了，更重要的是，每当酒店的东西，摔了或者坏了，总有人很大声地说： Made in China ！言语间充满了嫌弃和不屑。作为中国人，她觉得很丢脸，所以想回到自己的国家。&lt;/p&gt;\r\n&lt;p&gt;\r\n	我能说什么呢？中国人一边是经济的快速发展，一边是道德上的停滞不前，使得自身修养的速度，总是跟不上经济发展的速度。但细细想想，每个国家都是这样发展过来的，就连美丽的泰晤士河，也曾经被污染得鱼死虾亡，惨不忍睹啊！&lt;/p&gt;\r\n&lt;p&gt;\r\n	每个国家的经济发展，都得有个过程，要慢慢来。相信我们的国家和我们的国民，在一步步走上经济发达的同时，道德修养也一定会得到快速发展。&lt;/p&gt;\r\n&lt;p&gt;\r\n	所以我告诉侄女，忧国忧民你还做不到，但做好你自己总可以吧？你好好做你的本职工作，要让他们对中国人刮目相看，而不是嗤之以鼻！&lt;/p&gt;\r\n&lt;p&gt;\r\n	为什么总是中国制造的东西坏了？这样不仅浪费资源，还自毁声誉。&lt;/p&gt;\r\n&lt;p&gt;\r\n	因为我们只贪图数量，而忽略了质量啊！为什么我们很多人，追捧国外的名牌产品？因为他们的东西耐用，买的时候是贵了，可用的时候，才知道很便宜也很放心！更重要的是，买这样的奢侈品，不仅有脸面，还很有品位！&lt;/p&gt;\r\n&lt;p&gt;\r\n	是你的内心世界，照亮了你周围的世界，要想让人家对中国人刮目相看，我们要真正地从内心的修行做起啊！就像你想给别人温暖，你自己首先要是温暖的！&lt;/p&gt;\r\n&lt;p&gt;\r\n	孔子日，君子有三戒：&amp;ldquo;少之时，血气未定，戒之在色；及其壮也，血气方刚，戒之在斗；及其老矣，血气既衰，戒之在得。&amp;rdquo;然而我觉得，每个人在每个时候，都要戒这个&amp;lsquo;贪&amp;rsquo;字。&lt;/p&gt;\r\n&lt;p&gt;\r\n	无论什么时候，贪婪和侥幸都是人生之大敌！&lt;/p&gt;\r\n', '', '1649638274', '1649638274');
INSERT INTO `ey_article_content` VALUES ('51', '51', '&lt;p&gt;\r\n	朋友的表姐是开出租车的。&lt;/p&gt;\r\n&lt;p&gt;\r\n	那天她不幸被四个强悍的歹徒绑架到一个荒僻、偏远的地方。寒冬、深夜敌我力量的反差，情况之危急可想而知。&lt;/p&gt;\r\n&lt;p&gt;\r\n	朋友的表姐一边慢慢和歹徒周旋，一边想着脱身之计。&lt;/p&gt;\r\n&lt;p&gt;\r\n	钱、首饰、手机都主动交了出去，可歹徒还是没有放人的意思。她只好耐着性子，和歹徒说话，话里话外、明里暗里，表示对他们的行为很理解，这几个歹徒终于动了恻隐之心，把她推下车，临走还说：&lt;/p&gt;\r\n&lt;p&gt;\r\n	&amp;ldquo;赶紧找地方打电话，让家里人来接你，深更半夜别冻死了！&amp;rdquo;歹徒走了，朋友的表姐走了好远，才找到一个小村庄。&lt;/p&gt;\r\n&lt;p&gt;\r\n	终于获救了！&lt;/p&gt;\r\n&lt;p&gt;\r\n	朋友的表姐每次说起这件事，末了总忘不了来一句：&lt;/p&gt;\r\n&lt;p&gt;\r\n	&amp;ldquo;世上还有这样善良的坏人啊！&amp;rdquo;听起来真让人啼笑皆非。&lt;/p&gt;\r\n&lt;p&gt;\r\n	无独有偶，也是拦路抢劫，也是把车劫走了，歹徒把被劫持者逼到一个机井房里，扒去外衣，绑住了手脚，蒙了眼睛封了嘴，最后连鞋子也给脱了，不知扔到了什么地方！&lt;/p&gt;\r\n&lt;p&gt;\r\n	那歹徒走的时候告诫被劫持者：&lt;/p&gt;\r\n&lt;p&gt;\r\n	&amp;ldquo;你千万不要轻举妄动，因为你身后就是机井！&amp;rdquo;&lt;/p&gt;\r\n&lt;p&gt;\r\n	最后被劫持者是怎么获救我已经忘记了，只记得每当说起这事，他的妈妈总会非常感谢地说：&lt;/p&gt;\r\n&lt;p&gt;\r\n	&amp;ldquo;世上还是好人多啊！车没了就算了，有人在什么都会有的！要不是那人临走提醒一句，我儿子哪还有活命啊！&amp;rdquo;&lt;/p&gt;\r\n&lt;p&gt;\r\n	是啊，人在世界就在！一个人就是一个世界啊！真正到了生死攸关的时候，钱和物又算得了什么？&lt;/p&gt;\r\n&lt;p&gt;\r\n	&amp;lsquo;人之初，性本善&amp;rsquo;，我坚信每个人都是善良的，我也坚信不是迫不得已，没有人心甘情愿去偷、去抢... ...再说上世无冤今世无仇的，一旦财物得手，谁也不忍伤害人的性命！古人云&amp;lsquo;盗亦有道&amp;lsquo;，如此而已。&lt;/p&gt;\r\n&lt;p&gt;\r\n	因为这些小小的举动，就让这些可恨的强盗，也有了一些可爱之处！&lt;/p&gt;\r\n&lt;p&gt;\r\n	前天又听说一个更好笑的。老两口养了一群羊。夜里来了四个歹徒，两个看着老两口，两个把羊往车里装。末了老太太恳求说：&lt;/p&gt;\r\n&lt;p&gt;\r\n	&amp;ldquo;你给我们留下一个小羊吧！马上开春了... ...&amp;rdquo;&lt;/p&gt;\r\n&lt;p&gt;\r\n	&amp;ldquo;别了大娘，你老人家这么大岁数了，以后就不要再养羊了，免得我们还老惦记。&amp;rdquo;&lt;/p&gt;\r\n&lt;p&gt;\r\n	就这样，歹徒们扬长而去，剩下这老两口抱头痛哭。 老头一边给老太太抹眼泪，一边说：&lt;/p&gt;\r\n&lt;p&gt;\r\n	&amp;ldquo;你哭啥呀，人家说了，我们老了，不能再养羊了！&amp;rdquo;老太太说：&amp;ldquo;我是哭这世上，咋还有这样好的坏人啊！&amp;rdquo;&lt;/p&gt;\r\n&lt;p&gt;\r\n	... ...&lt;/p&gt;\r\n&lt;p&gt;\r\n	是啊，世上怎么还有如此善良的坏人啊！&lt;/p&gt;\r\n&lt;p&gt;\r\n	有人说生活就像洋葱，一片一片剥开，总有一片，辛辣得会让你流泪！我说生活就像唱戏，每一个角色都有他特定的使命！好人也好，歹人也罢，缺少了哪个角色，这个世界都不能算是完美！&lt;/p&gt;\r\n', '', '1649638274', '1649638274');
INSERT INTO `ey_article_content` VALUES ('52', '52', '&lt;div&gt;\r\n	&lt;div&gt;\r\n		&lt;div&gt;\r\n			裁一帛光阴，写一阕旧词，字里行间，蕴着清风明月的境，含了幽篁篱菊的情，读在眼眸里，便是一段故事，读在往事中，便是一曲心音，读在岁月里，便是一林静好。&lt;/div&gt;\r\n		&lt;div&gt;\r\n			&amp;nbsp;&lt;/div&gt;\r\n		&lt;div&gt;\r\n			红尘漫漫，吹不尽的忧伤最易迷眼，翻不尽的章节最易断肠，天高云淡，极目远眺，谁人相忆在江楼。是谁，独自守着窗儿，蘸了盈袖的暗香，研了梧桐黄昏细雨，落下瘦比黄花的文字，欲说还休？是谁，秋风悲画扇，以三更的落梅横笛，在断肠声里忆念平生？是谁，因了懂得，披了一袭的慈悲，因了安好，从尘埃里开了一朵花，又从这一朵花里开了一生的寂寞？&lt;/div&gt;\r\n		&lt;div&gt;\r\n			&amp;nbsp;&lt;/div&gt;\r\n		&lt;div&gt;\r\n			远去了，那些藤蔓一样生长的忧伤，那些近乎心碎的眺望。但光阴，悄然地留下那一尊尊诗的背影，在每一行黯然神伤的诗句后，浇开了一路芬芳，筑就了一堤风景。风景是光阴精心酿制的一壶酒，需要在一个恰当的时候恰当的地方打开，才会醇香满怀。是的，对于四季递嬗的节奏，一个人，常常习惯了那一季里开场的欣喜，花开春暖，踏雪寻梅，习惯了那一场渐入佳境的悠扬与繁盛，月色荷塘，晚照枫林，而最不可忽略的往往是那令人沉醉的一朵寂静，一片留白，甚至只是一个休止符的默然憩息，一曲轻音乐的余音袅袅，因为它们不只是在吸引，更是在撩拨，撩拨那溪水般潺潺的心动，撩拨那藏在岁月深处的一幅幅生动。&lt;/div&gt;\r\n		&lt;div&gt;\r\n			&amp;nbsp;&lt;/div&gt;\r\n	&lt;/div&gt;\r\n&lt;/div&gt;\r\n&lt;br /&gt;\r\n', '', '1649638274', '1649638274');
INSERT INTO `ey_article_content` VALUES ('55', '55', '&lt;p&gt;\r\n	人活的之所以累，是放不下架子、撕不开面子、解不开情节（原因很简单）&lt;/p&gt;\r\n&lt;p&gt;\r\n	&amp;nbsp;&lt;/p&gt;\r\n&lt;p&gt;\r\n	你的人生需要明白的站在自己的立场上不是每个人都符合你的胃口；站在别的立场上，你又何尝能够所有人的胃口？（宽容待人）&lt;/p&gt;\r\n&lt;p&gt;\r\n	&amp;nbsp;&lt;/p&gt;\r\n&lt;p&gt;\r\n	能把复杂问题简单化的人是人才，能把简单问题复杂化的是蠢才。（人们往往愿意当蠢才）&lt;/p&gt;\r\n&lt;p&gt;\r\n	&amp;nbsp;&lt;/p&gt;\r\n&lt;p&gt;\r\n	女人最欣赏男人有才气，最讨厌男人太小气，最怕男人不争气。（男人就怕女人老生气）&lt;/p&gt;\r\n&lt;p&gt;\r\n	&amp;nbsp;&lt;/p&gt;\r\n&lt;p&gt;\r\n	痒有时比痛还难受，恨往往比爱更容易（人生悖论）&lt;/p&gt;\r\n&lt;p&gt;\r\n	&amp;nbsp;&lt;/p&gt;\r\n&lt;p&gt;\r\n	机会对每个人都是平等的，你可以没有开枪的机会，但机会来时，你不可以没有子弹（干事业就是要这样）&lt;/p&gt;\r\n&lt;p&gt;\r\n	&amp;nbsp;&lt;/p&gt;\r\n&lt;p&gt;\r\n	爱情就象天花，我们每个人都要经历那么一次，而且正如天花那样，我们一生只会得一次，你永远不用担心会得到第二次（谈爱情）。&lt;/p&gt;\r\n&lt;p&gt;\r\n	&amp;nbsp;&lt;/p&gt;\r\n&lt;p&gt;\r\n	古代爱情故事多，当代爱情事故多（时代不同了）。&lt;/p&gt;\r\n&lt;p&gt;\r\n	&amp;nbsp;&lt;/p&gt;\r\n&lt;p&gt;\r\n	一个不犯错误的人通常不能成就任何事业，没有缺点的人，往往优点也很少（林肯的经验）。&lt;/p&gt;\r\n&lt;p&gt;\r\n	&amp;nbsp;&lt;/p&gt;\r\n&lt;p&gt;\r\n	商人是&amp;ldquo;可以商量的人&amp;rdquo;，生意人则是&amp;ldquo;可以生出主意的人&amp;rdquo;。（另类解释）&lt;/p&gt;\r\n&lt;p&gt;\r\n	&amp;nbsp;&lt;/p&gt;\r\n&lt;p&gt;\r\n	贤人有七德：一是不班门弄斧，二是不打断别的的话，三是不急于求成，四是提问要有针对性，五是解答要符合情理，六是谈话要有始有终，七是要立足于实际。（古犹太箴言）。&lt;/p&gt;\r\n&lt;p&gt;\r\n	&amp;nbsp;&lt;/p&gt;\r\n&lt;p&gt;\r\n	单位天天加班；家务从来不沾；手机回家就关；短信看完就删；上床呼噜震天；内裤经常反穿。（有外遇的六大症状）。&lt;/p&gt;\r\n&lt;p&gt;\r\n	&amp;nbsp;&lt;/p&gt;\r\n&lt;p&gt;\r\n	做一些你认为根本做不到的事（心有多大，路有多远）。&lt;/p&gt;\r\n&lt;p&gt;\r\n	&amp;nbsp;&lt;/p&gt;\r\n&lt;p&gt;\r\n	心脏是一座两间卧室的房子，一间住着痛苦，一间住着快乐。人不能笑得太响，否则笑声就会吵醒隔壁的痛苦。（避免乐极生悲）。&lt;/p&gt;\r\n&lt;p&gt;\r\n	&amp;nbsp;&lt;/p&gt;\r\n&lt;p&gt;\r\n	如果娶到一个聪明又贤慧的妻子，你会得到幸福；如果娶到一个轻浮的泼妇，你会成为哲学家。（结婚有益）。&lt;/p&gt;\r\n&lt;p&gt;\r\n	&amp;nbsp;&lt;/p&gt;\r\n&lt;p&gt;\r\n	说不出的，哭不出的，才是最苦的（生命体现）。&lt;/p&gt;\r\n&lt;p&gt;\r\n	&amp;nbsp;&lt;/p&gt;\r\n&lt;p&gt;\r\n	在哪里摔倒，就在哪里躺下（某些悲观者）。&lt;/p&gt;\r\n&lt;p&gt;\r\n	&amp;nbsp;&lt;/p&gt;\r\n&lt;p&gt;\r\n	真正的问题，不在于配偶是不是最佳人选，而在于你是不是努力成为配偶的最佳人选（幸福婚姻圣经）。&lt;/p&gt;\r\n&lt;p&gt;\r\n	&amp;nbsp;&lt;/p&gt;\r\n&lt;p&gt;\r\n	说真话的唯一好处，就是不必记住你说了一些什么（网友语录）。&lt;/p&gt;\r\n&lt;p&gt;\r\n	&amp;nbsp;&lt;/p&gt;\r\n&lt;p&gt;\r\n	你可以得罪忙人，因为他们没有时间与你计较；你千万不能得罪闲人，因为他们有时间跟你周旋。（千万别得罪闲人）。&lt;/p&gt;\r\n&lt;p&gt;\r\n	&amp;nbsp;&lt;/p&gt;\r\n&lt;p&gt;\r\n	如果你不能改变你的容貌，那么你就改变你的表情吧（不漂亮，也可以很可爱）。&lt;/p&gt;\r\n&lt;p&gt;\r\n	&amp;nbsp;&lt;/p&gt;\r\n&lt;p&gt;\r\n	比洗澡、洗桑拿更重要的是洗脑，澡不洗会散发臭气，脑不洗会被时代淘汰（我们经常忘记这一点）。&lt;/p&gt;\r\n&lt;p&gt;\r\n	&amp;nbsp;&lt;/p&gt;\r\n&lt;p&gt;\r\n	不要那么相信自己的回忆，里面的那个人，不一定同样想念你（带着回忆上路，而不是抱着回忆生活）。&lt;/p&gt;\r\n&lt;p&gt;\r\n	&amp;nbsp;&lt;/p&gt;\r\n&lt;p&gt;\r\n	应该有更好的方式开始新的一天，而不是千篇一律地在每个上午醒来（上班族哲思）。&lt;/p&gt;\r\n&lt;p&gt;\r\n	&amp;nbsp;&lt;/p&gt;\r\n&lt;p&gt;\r\n	癞蛤蟆想吃天鹅肉，好样的，小东西有志气（要这样教育下一代）。&lt;/p&gt;\r\n&lt;p&gt;\r\n	&amp;nbsp;&lt;/p&gt;\r\n&lt;p&gt;\r\n	富有并非拥有得多，而是奢求得少。(新的财富观)。&lt;/p&gt;\r\n', '', '1649638274', '1649638274');
INSERT INTO `ey_article_content` VALUES ('56', '56', '&lt;p&gt;\r\n	第一是&amp;ldquo;贫穷&amp;rdquo;&lt;/p&gt;\r\n&lt;p&gt;\r\n	&amp;nbsp;&lt;/p&gt;\r\n&lt;p&gt;\r\n	贫穷不能等，因为一但时间久了，你将习惯贫穷，到时不但无法突破自我，甚至会抹杀了自己的梦想，而庸庸碌碌的过一辈子&amp;hellip;&amp;hellip;&lt;/p&gt;\r\n&lt;p&gt;\r\n	&amp;nbsp;&lt;/p&gt;\r\n&lt;p&gt;\r\n	第二是&amp;ldquo;梦想&amp;rdquo;&lt;/p&gt;\r\n&lt;p&gt;\r\n	&amp;nbsp;&lt;/p&gt;\r\n&lt;p&gt;\r\n	梦想不能等，因为人生不同的阶段，会有不同的历练和想法，试想一个问题： 如果你20岁时的梦想，在60岁的时候才得以实现，那会是什么样的一个情况？&lt;/p&gt;\r\n&lt;p&gt;\r\n	&amp;nbsp;&lt;/p&gt;\r\n&lt;p&gt;\r\n	譬如说你20岁时的梦想是希望能买到一辆法拉利的跑车，然后周游我国的大好河山。你一直努力工作，好不容易到60岁了，总算买的起跑车了，但要实现年轻时的梦想，恐怕也是心有余而力不足吧&amp;hellip;&amp;hellip;&lt;/p&gt;\r\n&lt;p&gt;\r\n	&amp;nbsp;&lt;/p&gt;\r\n&lt;p&gt;\r\n	第三是&amp;ldquo;家人&amp;rdquo;&lt;/p&gt;\r\n&lt;p&gt;\r\n	&amp;nbsp;&lt;/p&gt;\r\n&lt;p&gt;\r\n	家人不能等，或许我们还年轻，未来有很多的时间可以让我们摸索、打拼，但是家人有吗？他们还有时间等我们成功吗？还有时间等我们赚到钱，让他们过好日子，让他们以我们为荣？&lt;/p&gt;\r\n&lt;p&gt;\r\n	&amp;nbsp;&lt;/p&gt;\r\n&lt;p&gt;\r\n	树欲静而风不止，子欲养而亲不待。这是很多人的痛，也是很多人一辈子的遗憾!&lt;/p&gt;\r\n', '', '1649638274', '1649638274');
INSERT INTO `ey_article_content` VALUES ('58', '58', '&lt;p&gt;\r\n	夏日的黄昏里，我与一个老中医坐在清风徐徐的河边闲聊。突然，老人家盯着我的脸端详了好一会儿没有出声。我被他看得心里有些发虚，问道：&amp;ldquo;老人家，你这么关注我的脸，是不是看出了点什么啊？&amp;rdquo;&lt;/p&gt;\r\n&lt;p&gt;\r\n	老人家笑了笑，说：&amp;ldquo;我从小学医的时候，老师就一再告诉我，&amp;lsquo;人心险平，看眼；寿命长短，看脸&amp;rsquo;。从医一辈子，养成习惯了，呵呵，与人在一起，就总想往脸上多瞅几眼。&amp;rdquo;&lt;/p&gt;\r\n&lt;p&gt;\r\n	我说：&amp;ldquo;老人家，都知道眼睛是心灵的窗口，这第一句话我能理解，可要说&amp;lsquo;寿命长短，看脸&amp;rsquo;，我就有些不解了。人的寿命，怎么会写在脸上呢？&amp;rdquo;&lt;/p&gt;\r\n&lt;p&gt;\r\n	老人家说：&amp;ldquo;脸小乾坤大啊。看脸，其实，我就只看脸上两处，一个是眉间，一个是嘴边。若一个人总是愁肠内结，心境忧郁，思虑过度，多疑寡断，看不到生活的希望和人生的美好，那么，眉间必然形成深深的&amp;lsquo;八&amp;rsquo;纹。&amp;lsquo;八&amp;rsquo;纹，乃挤压扭曲所致，属阴。阴气过于浓重，则心境难爽，便会郁积于腑脏；久阴则毒生，腑脏不堪其腐蚀，必然发而为病；有病在身，必然将进一步恶化心绪。人若一旦陷于心与病相互摧残的恶性循环之中，健康不存，哪里还会有长寿之理？眉间&amp;lsquo;八&amp;rsquo;纹，实为割寿之刀啊。所以，我的老师就曾不止一次地对我说过，&amp;lsquo;眉头常皱，必然折寿&amp;rsquo;！小兄弟，你可要当心哟。&amp;rdquo;&lt;/p&gt;\r\n&lt;p&gt;\r\n	老人家的话，让我心头暗惊，平时不太注意的眉间&amp;lsquo;八&amp;rsquo;纹，竟然蕴含着如此大的学问。我禁不住好奇心的驱使，又接着问道：&amp;ldquo;那嘴边能看出什么呢？&amp;rdquo;&lt;/p&gt;\r\n&lt;p&gt;\r\n	老人家说：&amp;ldquo;一个人如果常常忍俊不禁，心中的喜悦漫溢，必然口角上挑，便会在嘴边形成一个小&amp;lsquo;括号&amp;rsquo;；一个人若是爽朗畅快，常常大笑不止，牙齿常晒太阳，那么，这个&amp;lsquo;括号&amp;rsquo;更是弧度飞扬，犹如相对而出的两轮半月，镶在脸颊之上，奕奕的神采，灿然生光。从它形成的原因上我们便可以看到，括号者，实乃舒心畅意、气贯神通之映照，当然属阳；因为&amp;lsquo;括号&amp;rsquo;是在嘴的两边，又象征着阴阳的平衡，因此，它括住的是身体的健康、精神的疏朗、生命的活力、悠然而乐的心境和对人生绵延不绝的希望。处于这样的生活和精神状态的人，你说他能不健康长寿吗？&amp;rdquo;&lt;/p&gt;\r\n&lt;p&gt;\r\n	真是听君一席话，胜读十年书，心里好不畅快啊。原来我们的脸上，还真的透露着我们的心态优劣、人生沧桑和生命状态等重要信息啊。因此，我们平时还是常常照镜子，看看脸上正在增加或不断加深的：是眉间&amp;ldquo;八&amp;rdquo;纹，还是嘴边&amp;ldquo;括号&amp;rdquo;吧！&lt;/p&gt;\r\n', '', '1649638274', '1649638274');
INSERT INTO `ey_article_content` VALUES ('61', '61', '&lt;div&gt;\r\n	&lt;div&gt;\r\n		&lt;p&gt;\r\n			生命是时间长河里转瞬即逝的刹那，人类千方百计想方设法地追求天长地久永生不老，却没有想到，事实上只要把自己的脚步放慢，心态放平，活在当下，那么人生自然会变得绵长悠远。&lt;/p&gt;\r\n		&lt;p&gt;\r\n			以前没给杂志写稿时，我不知道原来在这一行里，时间是提前来过的。一月已经预备三月甚至四月的稿。在约稿论坛上一边看一边心惊肉跳，自己的一年尚未结束，也没有做出一点成绩，那边人家的工作已经过了一年，直逼年底。岁月在这里，竟是以迫不及待望尘莫及的速度飞逝，怎不叫人心生恐慌？&lt;/p&gt;\r\n		&lt;p&gt;\r\n			时间的长度本是人类自己定义出来的。一年三百六十五天，分四季，十二个月。可在这里，人们总是你追我赶的比赛似的，看谁能把一年过成一日。先人有知，如果把十年定成一年，我们还会这样心急吗？&lt;/p&gt;\r\n		&lt;p&gt;\r\n			日子不用过，只能用来追。自我无意走进这扇门，就掉进了这样湍急的漩涡。日历和钟表上的数字永远只能代表过去，因为今天要做的，已经是将来的事。明明是春天，但手下已经在马不停蹄做着秋天的事了。&lt;/p&gt;\r\n		&lt;p&gt;\r\n			没有什么值得欣喜的，无端的青春硬是比别人短了一大截似的。走在前面有什么用，时间都落在后面了，徒然催老了心灵和容颜而已。&lt;/p&gt;\r\n		&lt;p&gt;\r\n			现代人的快节奏，无非是调快了生命的时钟，自己给自己压力和逼迫的一种方式，只为了更充分地榨出生命的汁液获得价值名利。但我看到的却是更快更不留余地的消耗与飞逝。试问，一吨金子可换得回哪怕一秒的光阴？&lt;/p&gt;\r\n		&lt;p&gt;\r\n			美国人总是跑在世界的前面，连花钱都是今天花明天的，结果呢？金融危机终于打碎了这种提前消费的神话，惩罚所有悖离自然规律的活动。&lt;/p&gt;\r\n		&lt;p&gt;\r\n			北京人的话，悠着点儿。人活一世，草木一春，是多么短暂而又美好的时光。如果能漫步，为什么要急跑，错过一路的风景？须知前面不是另一个春天，而是一直等你接近的生命的终点。&lt;/p&gt;\r\n		&lt;p&gt;\r\n			明天的事今天做，明年的事今年完成。如此超前卓越的成绩和努力，不过是一种提前预支生命的结果。&lt;/p&gt;\r\n		&lt;p&gt;\r\n			何谓一入江湖岁月催，少年子弟江湖老？这是生命的无奈而非享受。&lt;/p&gt;\r\n	&lt;/div&gt;\r\n&lt;/div&gt;\r\n&lt;div&gt;\r\n	&amp;nbsp;&lt;/div&gt;\r\n', '', '1649638274', '1649638274');
INSERT INTO `ey_article_content` VALUES ('63', '63', '&lt;p&gt;\r\n	床大概是最消耗生命时光的地方了！一天除了三分之一的睡觉时间，另外的很多时光，居然也可以在床上度过。&lt;/p&gt;\r\n&lt;p&gt;\r\n	溜狗回来，煮了一杯茶，半躺在床上，居然一觉睡到九点多了！起来吃点东西，东走走西看看，已经十点了，再过半个多小时，又要出门了。&lt;/p&gt;\r\n&lt;p&gt;\r\n	屋后的操场上，正在进行秋季运动会的彩排。音乐声口号声，偶尔还有一两声训斥声，充塞着满屋满耳，连个躲避的地方也没有。&lt;/p&gt;\r\n&lt;p&gt;\r\n	现在的人，想清静一会儿，真是太难了。在家有电脑、电视、手机。这些东西无论用不用，通常都是开着的。我有个朋友，他家电视基本上没关过：做饭的时候开着，吃饭的时候开着 ，甚至睡觉的时候，电视也是开着的。问他为什么这样，他说习惯了，觉得家里没有一点动静，很空虚很无聊。&lt;/p&gt;\r\n&lt;p&gt;\r\n	出了家门，这样那样的叫卖声以及做广告的宣传车，满大街都是。商家为了牟取暴利，在宣传上从来都是不惜血本的。除了流动的宣传车和不停的叫卖，还有花样繁多的广告纸。从听觉到视觉，全方位无死角地宣传，所以，哪个超市搞特价，你想不知道都难呢！另外各个门市部，都有自己的音响，都放着自己喜欢的歌曲，特别那个卖糖葫芦的小店，一天到晚，把《冰糖葫芦》这首歌，不厌其烦地单曲循环... ...&lt;/p&gt;\r\n&lt;p&gt;\r\n	所以，现在的人想清静，要有很深的修行。你要有能力，关上你尘世的耳朵，打开你心灵的空间，才能独享一份内心的清凉。只是这样的机会，也是不多的。这样那样的琐事，总是把你的心抄扯得很满很乱。多想有一颗清静空灵的心啊！把自己的灵魂安放在那里，再不受那些尘事的牵扰。&lt;/p&gt;\r\n&lt;p&gt;\r\n	家里所有的水果，都没有了，却怎么都不愿出门去买。虽然每天出门的时候，都要经过四五家水果店。不是忘记带钱了，就是带了钱又忘记买了。总是在回到家打开门的那一刻，才轰然想起。然而此时，鞋子已经踢掉了，包也被我扔到沙发深处... ...&lt;/p&gt;\r\n&lt;p&gt;\r\n	等下次吧，可每次都是如此。&lt;/p&gt;\r\n&lt;p&gt;\r\n	习惯了开着电脑，不厌其烦地听着越剧。心情好的时候，觉得那是天籁，心情不好的时候，那就是我发呆犯傻的背景音乐。&lt;/p&gt;\r\n&lt;p&gt;\r\n	快到爱人的生日了，女儿们想给爸爸买块手表，在网上逛了好长时间，还是不能确定。表盘大都是有刻度没数字的，这样的表我是怎么都看不上的，女儿因此很生气：&lt;/p&gt;\r\n&lt;p&gt;\r\n	&amp;ldquo;妈妈，你当所有人都像你啊，看表只会看电子表，还得是12时制的。&amp;rdquo;&lt;/p&gt;\r\n&lt;p&gt;\r\n	&amp;ldquo;当然不都像我，可你爸爸一天比一天老了，说不定哪一天，他还不如我了呢！所以，一定要买表盘上带数字的，设计简单大方、最好还是国产的。&amp;rdquo;&lt;/p&gt;\r\n&lt;p&gt;\r\n	&amp;ldquo;国产的？机械的还是石英的？要什么牌子的？&amp;rdquo;&lt;/p&gt;\r\n&lt;p&gt;\r\n	&amp;ldquo;要石英的吧，不用天天上弦，牌子要海鸥的就行。&amp;rdquo;&lt;/p&gt;\r\n&lt;p&gt;\r\n	&amp;ldquo;海鸥的？没听说过。&amp;rdquo;&lt;/p&gt;\r\n&lt;p&gt;\r\n	&amp;ldquo;上网查去，作为中国人，居然不知道海鸥手表？&amp;rdquo;&lt;/p&gt;\r\n&lt;p&gt;\r\n	一会儿女儿又打电话过来：&lt;/p&gt;\r\n&lt;p&gt;\r\n	&amp;ldquo;想用国产海鸥的手表，你女儿暂时还买不起，都是好几千好几万的。&amp;rdquo;&lt;/p&gt;\r\n&lt;p&gt;\r\n	然后，女儿在QQ上，发了一个链接给我，我打开一看，可不是吗？还整天让支持国货，就这样的价格，让我们这小老百姓，怎么支持？结婚那会儿，买了块海鸥手表，还不到200块钱呢。&lt;/p&gt;\r\n&lt;p&gt;\r\n	爱人下班回来了，说给他听。看我不以为然的样子，他看着我说：&lt;/p&gt;\r\n&lt;p&gt;\r\n	&amp;ldquo;你还不到200块，我当时月工资还不到120块钱呢！一个多月的工资，折合到现在，还不正经好几千啊！&amp;rdquo;&lt;/p&gt;\r\n&lt;p&gt;\r\n	&amp;ldquo;时代不同了，那时候花200块钱买块手表，也没觉得怎样，怎么现在反而不舍得了呢？&amp;rdquo;&lt;/p&gt;\r\n&lt;p&gt;\r\n	&amp;ldquo;没觉得怎样，那是没花你的钱。&amp;rdquo;&lt;/p&gt;\r\n&lt;p&gt;\r\n	&amp;ldquo;你别说你给我买了块手表，到现在你还心疼着！&amp;rdquo;&lt;/p&gt;\r\n&lt;p&gt;\r\n	只是，我们只顾争吵呢，忘记电脑还开着语音通话呢，两个女儿在那边气得大叫：&lt;/p&gt;\r\n&lt;p&gt;\r\n	&amp;ldquo;怎么又吵？妈妈，你把电脑让给我爸爸，让我爸说要石英的还是机械的。&amp;rdquo;我起来，把电脑让给爱人。&lt;/p&gt;\r\n&lt;p&gt;\r\n	&amp;ldquo;我要机械的，价格别太高，没钱我给你汇。&amp;rdquo;&lt;/p&gt;\r\n&lt;p&gt;\r\n	&amp;ldquo;表盘呢？要数字的还是刻度的？颜色要黑白的还是天灰白的？&amp;rdquo;&lt;/p&gt;\r\n&lt;p&gt;\r\n	&amp;ldquo;数字的刻度的都行，颜色要黑白的。&amp;rdquo;&lt;/p&gt;\r\n&lt;p&gt;\r\n	&amp;ldquo;哎呀，不就是个手表吗？计较可真多！&amp;rdquo;我在旁边忍不住插嘴道。&lt;/p&gt;\r\n&lt;p&gt;\r\n	&amp;ldquo;爸爸，你确定了？&amp;rdquo;&lt;/p&gt;\r\n&lt;p&gt;\r\n	&amp;ldquo;确定了，你妈急着上网呢！&amp;rdquo;&lt;/p&gt;\r\n&lt;p&gt;\r\n	&amp;ldquo;别急啊，表盒有两种颜色，一红一黑你要哪种？&amp;rdquo;&lt;/p&gt;\r\n&lt;p&gt;\r\n	&amp;ldquo;表盒什么样的都行，反正只戴手表又不戴表盒。&amp;rdquo;我又插了一句嘴。&lt;/p&gt;\r\n&lt;p&gt;\r\n	&amp;ldquo;妈妈，我们给爸爸买生日礼物，当然要买我爸爸中意的，你别老插嘴好不好。&amp;rdquo;&lt;/p&gt;\r\n&lt;p&gt;\r\n	&amp;ldquo;表盒你们喜欢什么颜色，就要什么颜色吧！手机写你妈妈的，她整天在家，快递来了方便去拿。&amp;rdquo;&lt;/p&gt;\r\n&lt;p&gt;\r\n	这个买表事件，终于敲定了，爱人开始浏览新闻。&lt;/p&gt;\r\n&lt;p&gt;\r\n	&amp;ldquo;你把耳机带上，我想清静一会儿。&amp;rdquo;&lt;/p&gt;\r\n&lt;p&gt;\r\n	&amp;ldquo;还想清静，你晚饭做了吗？&amp;rdquo;是啊，只顾和女儿讨论手表的事儿了，怎么忘记做晚饭了呢？&lt;/p&gt;\r\n&lt;p&gt;\r\n	你看，这想清静一会儿，还真难呢！你就是能关上尘世的耳朵，你关不上尘世的胃口啊！还是乖乖做饭去吧！于是，刀和菜板的碰撞声，杯盘的叮当声，再加上油烟机的轰鸣声，一首厨房交响曲又开始了！&lt;/p&gt;\r\n&lt;p&gt;\r\n	&amp;ldquo;关上厨房门，吵死了。&amp;rdquo;爱人吼了一句，我关了厨房的门。忽然想起那只偶然成功的青蛙：一群青蛙举行攀登梯子的比赛，观众们一边看一边说不可能，青蛙捉害虫还可以，爬上这么高的梯子，根本就不可能。于是一只青蛙放弃了，两只青蛙放弃了，最后只剩下一只青蛙，成功地爬到了梯子的顶端！&lt;/p&gt;\r\n&lt;p&gt;\r\n	它成功了，所有的青蛙都来向它道贺，这时候大家才知道，这只青蛙是个聋子！&lt;/p&gt;\r\n&lt;p&gt;\r\n	因为它根本听不到那些负面的声音，所以，它才独自坚持到了最后，获得了成功！&lt;/p&gt;\r\n&lt;p&gt;\r\n	所以，我们也要试着，关上我们尘世的耳朵，不让那些负面的声音，影响我们积极向上的雄心壮志！当你心里只有你的坚持、眼里只有你的目标的时候，全世界都会为你的成功让路！&lt;/p&gt;\r\n', '', '1649638274', '1649638274');
INSERT INTO `ey_article_content` VALUES ('85', '130', '', '', '1649670933', '1649670933');
INSERT INTO `ey_article_content` VALUES ('86', '131', '', '', '1649670913', '1649670913');
INSERT INTO `ey_article_content` VALUES ('87', '132', '', '', '1649670948', '1649670948');
INSERT INTO `ey_article_content` VALUES ('88', '133', '', '', '1649670965', '1649670965');
INSERT INTO `ey_article_content` VALUES ('89', '134', '', '', '1649670981', '1649670981');
INSERT INTO `ey_article_content` VALUES ('90', '135', '&lt;p&gt;Pregnant women, children generally do not drink tea, due to too much too much caffeine in tea causes tachycardia in pregnant women, the fetus will bring too much stimulus, children as well. Therefore generally advocates for pregnant women, children should drink weak tea, through some weak tea, can take some vitamin supplements and minerals such as potassium, zinc nutrition. Child amount of tea can strengthen the intestinal peristalsis, helping digestion; tea heat effect of fire, avoid children&amp;#39;s stool causes anal fissures. In addition, the children drinking tea or gargling with tea can also prevent dental caries.&lt;/p&gt;', '', '1649671047', '1649671047');
INSERT INTO `ey_article_content` VALUES ('76', '76', '孕妇、儿童一般都不宜喝浓茶，因过浓的茶水中过量的咖啡因会使孕妇心动过速，对胎儿也会带来过分的刺激，儿童也是如此。因此一般主张孕妇、儿童宜饮淡茶，通过饮些淡茶，可以补充一些维生素和钾、锌等矿物质营养成分。儿童适量饮茶，可加强胃肠蠕动，帮助消化；饮茶有清热降火之功效，避免儿童大便干结造成肛裂。另外，儿童饮茶或用茶水漱口还可以预防龋齿。', '', '1649638274', '1649638274');
INSERT INTO `ey_article_content` VALUES ('77', '77', '&lt;div&gt;\r\n	用枸杞子泡茶，有滋补抗衰的作用。《本草经疏》对枸杞子之功效作过较全面的论述：&amp;ldquo;枸杞子，润而滋补，兼能退热，而专于补肾、润肺、生津、益气，为肝肾真阴不足、劳乏内热补益之要药。老人阴虚十之七八，故服食多为益精明目之上品&amp;rdquo;。枸杞子泡茶喝，不但对肝肾阴虚所致的头晕目眩、视力减退、腰膝酸软、遗精等久服甚效，而且对高血脂、高血压、动脉硬化、糖尿病等也有一定的疗效。&amp;nbsp;&lt;/div&gt;\r\n&lt;div&gt;\r\n	　　用西洋参片泡茶喝，可以利用西洋参味甘辛凉的性质，调整茶味，而且西洋参补阴虚效果甚佳。这种西洋参茶常有良好的益肺养胃、滋阴津、清虚火、去低热的功效。&amp;nbsp;&lt;/div&gt;\r\n&lt;div&gt;\r\n	用白菊花泡茶喝，可发挥白菊花平肝潜阳、疏风清热、凉血明目的功效，而且白菊花清香味甘，泡茶喝可增进茶汤香味，适口性好。&amp;nbsp;&lt;/div&gt;\r\n&lt;div&gt;\r\n	　　用桔皮泡茶喝，可以利用桔皮宽中理气、消痰止咳的功效，桔皮泡绿茶，可去热解痰、抗菌消炎，故咳嗽多痰者饮之有益。&amp;nbsp;&lt;/div&gt;\r\n&lt;div&gt;\r\n	　　用薄荷泡茶喝，可以利用薄荷中薄荷醇、薄荷酮的疏风清热作用，而且泡茶喝之有清凉感，是清热利尿的良药。&amp;nbsp;&lt;/div&gt;\r\n', '', '1649638274', '1649638274');
INSERT INTO `ey_article_content` VALUES ('78', '78', '很多年轻人喜欢饮用美味可口的牛奶红茶，冲泡配制方法是，先将适量红茶放入茶壶中，茶叶用量比清饮稍多些，然后冲入热开水,约5分钟后，从壶咀倒出茶汤放在咖啡杯中；如果是红茶袋泡茶，可将一袋茶连袋放在咖啡杯中，用热开水冲泡5分钟，弃去茶袋。 然后往茶杯中加入适量牛奶和方糖，牛奶用量以调制成的奶茶呈桔红、黄红色为度。奶量过多，汤色灰白，茶香味淡薄，奶量过少，失去奶茶风味，糖的用量因人而易，以适口为度。&amp;nbsp;', '', '1649638274', '1649638274');
INSERT INTO `ey_article_content` VALUES ('79', '79', '有些人在一天之中，不同时间饮用不同的茶叶，清晨喝一杯淡淡的高级绿茶，醒脑清心；上午喝一杯茉莉花茶，芬芳怡人，可提高工作效率；午后喝一杯红茶，解困提神；下午工间休息时喝一杯牛奶红茶或喝一杯高级绿茶加点点心、果品，补充营养；晚上可以找几位朋友或家人团聚一起，泡上一壶乌龙茶，边谈心边喝茶，别有一番情趣。这种一日饮茶巧安排，你如果有兴趣，不妨也可试一试。&amp;nbsp;', '', '1649638274', '1649638274');
INSERT INTO `ey_article_content` VALUES ('80', '80', '茶叶的化学成分是由3.5-7.0% 的无机物和93～96.5%的有机物组成。茶叶中的无机矿质元素约有27种，包括磷、钾、硫、镁、锰、氟、铝、钙、钠、铁、铜、锌、硒等多种。茶叶中的有机化合物主要有蛋白质、脂质、碳水化合物、氨基酸、生物碱、茶多酚、有机酸、色素、香气成分、维生素、皂苷、甾醇等。&amp;nbsp;', '', '1649638274', '1649638274');
INSERT INTO `ey_article_content` VALUES ('81', '81', '饮茶量的多少决定于饮茶习惯、年龄、健康状况、生活环境、风俗等因素。一般健康的成年人，平时又有饮茶习惯的，一日饮茶12克左右，分3-4次冲泡是适宜的。对于体力劳动量大、消耗多、进食量也大的人，尤其是高温环境、接触毒害物质较多的人，一日饮茶20克左右也是适宜的。油腻食物较多、烟酒量大的人也可适当增加茶叶用量。孕妇和儿童、神经衰弱者、心动过速者，饮茶量应适当减少。&amp;nbsp;', '', '1649638274', '1649638274');
INSERT INTO `ey_article_content` VALUES ('91', '136', '&lt;div style=&quot;white-space: normal;&quot;&gt;Medlar tea, nourishing effect of rejuvenation. The Materia Shu made a more comprehensive discussion on effect of wolfberry fruit: &amp;quot;wolfberry, moistening and nourishing, and fever, while specializing in kidney, lungs, saliva, Qi, for liver and kidney Yin deficiency, again heat and nourishing to medicine. Old Yin deficiency and seven or eight of the ten, so taking more invigorating eyesight greatly cherished &amp;quot;. Wolfberry tea drink, not only for Yin deficiency of liver and kidney induced by dizziness, decreased Visual acuity, lumbar debility, emission and long clothes very efficient and high blood cholesterol, high blood pressure, arteriosclerosis, diabetes, also have a certain effect.&amp;nbsp;&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;　　Tea with ginseng drink, can make use of American ginseng-flavored hypersensitive nature of cool, adjust the taste and effect of tonifying yin of American Ginseng is really good. This American ginseng tea very good benefit lung stomach, Yin Jin and Qing deficiency, low heating effect.&amp;nbsp;&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;White chrysanthemum tea drink, can play a white Chrysanthemum pinggan Qian Yang, the effect of wind-dispersing heat, cooling blood for improving eyesight and white Daisy clear fragrance is sweet, tea drinks can enhance tea flavor, palatability.&amp;nbsp;&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;　　Drink tea with orange peel, you can use orange peel Qi and eliminating phlegm of effects in the wide, orange peel green tea, can go to the pyrolysis of phlegm, anti-inflammatory, so coughing phlegm decoction of useful.&amp;nbsp;&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;　　Drink tea with Mint, menthol, menthol in the Peppermint wind-dispersing heat, and brewing up a sense of cool, is the effect of Diuretic medicine.&amp;nbsp;&lt;/div&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;', '', '1649671059', '1649671059');
INSERT INTO `ey_article_content` VALUES ('92', '137', '&lt;p&gt;Many young like drinking delicious of milk tea, rushed bubble preparation method is, first will amount tea into teapot in the, tea dosage than clear drink slightly more some, then rushed into hot water, about 5 minutes Hou, from pot Tsui pour out tea put in coffee cup in the; if is tea bags tea, can will a bags tea even bags put in coffee cup in the, with hot water rushed bubble 5 minutes, abandoned to tea bags. Then added the right amount of milk and the cup of sugar, milk to milk tea was made from Orange, yellow and red. Too much milk, soup color Grey tea flavor is weak, too little milk, lose tea flavor, sugar consumption is easy because of the people, to taste for the degree.&lt;/p&gt;', '', '1649671069', '1649671069');
INSERT INTO `ey_article_content` VALUES ('93', '138', '&lt;p&gt;Some people in a days among, different time drinking different of tea, morning drink a cup light of senior green tea, woke up brain pure; morning drink a cup Jasmine tea, fragrance Yi people, can improve efficiency; afternoon drink a cup tea, relief refreshing; afternoon breaks rest Shi drink a cup milk tea or drink a cup senior green tea add snack, and fruit, added nutrition; night can find several friends or family reunion with, bubble Shang a pot oolong tea, side talk side tea, don&amp;#39;t has a taste. This day tea arrangements if you are interested, may as well give it a try.&amp;nbsp;&lt;/p&gt;', '', '1649671081', '1649671081');
INSERT INTO `ey_article_content` VALUES ('94', '139', '&lt;p&gt;The chemical composition of tea is made up of inorganic and organic composition of 93~96.5% of 3.5-7.0%. About 27 of the inorganic mineral elements in tea, including phosphorus, potassium, sulfur, magnesium, manganese, fluoride, aluminum, calcium, sodium, iron, copper, zinc, selenium and other. Organic compounds in tea mainly proteins, lipids, carbohydrates, amino acids, alkaloids, polyphenols, organic acid, pigment, fragrance ingredients, vitamins, saponins, sterols, and so on.&lt;/p&gt;', '', '1649671092', '1649671092');
INSERT INTO `ey_article_content` VALUES ('95', '140', '&lt;p&gt;Tea depends on the amount of tea drinking habits, age, State of health, living conditions, customs, and other factors. Generally healthy adults usually have tea-drinking habit, tea about 12 grams a day, 3-4 BREW is appropriate. For large amount of manual labor, people who consumed, food intake, especially people with high temperature environments, exposure to toxic substances, day 20 grams of tea drinking is also appropriate. Greasy food more, smoke, alcohol can also increase tea consumption. Pregnant women and children, neurasthenia, tachycardia, tea consumption should be reduced.&lt;/p&gt;', '', '1649671104', '1649671104');
INSERT INTO `ey_article_content` VALUES ('96', '141', '&lt;div style=&quot;white-space: normal;&quot;&gt;See Singapore, a message, a man named Shen Luo even doctors trying to take pictures of women, from 18 years old to 40 years old, has taken 10,000.&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;nbsp;&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;nbsp;&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;nbsp;&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;Dr. Shen is a cosmetic specialist, but asked the woman to take pictures with him. &amp;quot;They looked at me with suspicion and looked at me as satyr,&amp;quot; he said.&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;nbsp;&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;nbsp;&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;nbsp;&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;Fortunately, there is a female learning physician to help him busy, first on his behalf before the smooth completion of the task. He believes that the Singapore woman&amp;#39;s face together, to find an ideal look, better than imitation of Western women.&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;nbsp;&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;nbsp;&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;nbsp;&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;quot;Our women&amp;#39;s eyes are too far apart,&amp;quot; Dr. Shen said, &amp;quot;the nose is too big and too flat, his forehead is too convex, but these shortcomings to reconcile, or oriental taste, according to foreign girl to change, &amp;quot;&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;nbsp;&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;nbsp;&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;nbsp;&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;Generally speaking, Singaporeans think TV star Zheng Huiyu looks quite ideal, but how many Zheng Huiyu it? Scarce precious feel it, we all like Zheng Huiyu, then the Singaporeans will appreciate those small forehead, wide eyes, nose big woman. I think nature is still lovely.&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;nbsp;&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;nbsp;&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;nbsp;&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;Dr. Shen said, &amp;quot;The other cosmetic surgeon is too wide to save his nose by raising his nose and narrowing the nostrils, but this is not like an oriental woman. My method is to put the nose Made more sharp. &amp;quot;&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;nbsp;&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;nbsp;&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;nbsp;&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;Ha, a sharp is not the kind of ghost?&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;nbsp;&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;nbsp;&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;nbsp;&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;Cosmetic woman, is not a woman of self-confidence. After the whole, life will always wear a fake things in the face. Why bother! And the failure of the whole never turn around. If successful, it is even worse, will be addictive, here a whole, where the whole, they ran out of a yellow summer Hui.&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;nbsp;&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;nbsp;&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;nbsp;&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;The United States, indeed take advantage of. But very short, not a man, then all of a sudden annoying. Some women look ordinary, but the more talk they feel the more taste, this is completely brains.&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;nbsp;&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;nbsp;&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;nbsp;&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;It is basic to spend money on augmented knowledge, or more travel to make the mind broad. To plastic surgery, as the first heart.&lt;/div&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;', '', '1649671138', '1649671138');
INSERT INTO `ey_article_content` VALUES ('97', '142', '&lt;div style=&quot;white-space: normal;&quot;&gt;People usually see the world&amp;#39;s point of view, can be divided into looking up, head-up, overlooking the three.&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;nbsp;&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;Heads-up, is the most normal and most comfortable vision, from the calm of the sense of balance, contains a mature and confident, neither overbearing nor impatient, is not conducive to steady forward, not easy wrestling accident. Look up, is used to look tall than us and the perspective of the object, the so-called Takayama Yangzhi. Often looking up, from the benefits, let us know that there are days, people outside, learn from example, than a benchmark, not as a bottom frog, arrogant; from the side view, look up for a long time, not only neck pain, but also tend to Let us feel inferior heart, feel very small, everything is better than people, always in a state of repression.&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;nbsp;&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;Overlooking the &amp;quot;list of small hills,&amp;quot; is used to look at people and things lower than our point of view. Some people are not as good as we are, we are not as fame as we are, and our social status is not as good as ours. When we turn our eyes to them, our eyes can not help but despise, snobbery and compassion. Most of the time, we often ignore them, turn a blind eye to them, because we envy the eyes have been staring at those who are higher than our successful people, busy and those wealthy, celebrities relatively high and low, see jealous, Than was exhausted.&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;nbsp;&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;From the natural law point of view, in general, young people like to look up, &amp;quot;young mind when taking cloud&amp;quot;, in their eyes, few can see the people, only those famous masters will enter the famous field of vision . Like Liu Bang to see the emperor, dare to say &amp;quot;when a real man,&amp;quot; Xiang Yu than he also cattle: &amp;quot;he can be replaced.&amp;quot; Middle-aged, peace of mind, edge convergence, and also know that troubled world, Flat, do not hesitate to walk on the road, in an orderly manner toward their own goals. Into the old state, the weather-beaten, read countless people, &amp;quot;see the moon in spring&amp;quot;, is no longer obsessed with fame, feasting, coupled with waist camel, and back bend, vertigo, naturally unnatural look down as a habit .&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;nbsp;&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;Of course, vary, and some people are looking up in life, life is aimed at a higher goal. He may live a very pomp, very bright, but certainly live very tired, very hasty, just get one city, but no time to browse the scenery, enjoy life, in fact, his life is very wrong. Therefore, when we look up very tired, may wish to look down and see those who live in the bottom of society people, although they and we are the same people, but education is lower than us, income less than us, the house than we are small , Work as we are decent, social status is inferior to us, always unknown to them, in front of them, we often have a sense of superiority, usually very dismissive, rarely glance to them.&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;nbsp;&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;In fact, their survival wisdom and social value is not lower than us, their contribution and labor is not less than us, we do not have any high reason for pride. And often contact with them, there will be unexpected gains. If a white-collar workers in the workplace struggle to be physically and mentally exhausted, in the market competition was life and death, the occasion of the use of breathing, bow down to see the cobbler street repair car, street lane, scavenger, you will Think, even if you retreat ten steps, hundred paces, but also higher than his standard of living, why should go for those things outside the contentious to win it?&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;nbsp;&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;By extension, an official for the poor career is no better than the upper floors and distress, may wish to look down at the people under the day to sit at their home, listen to what they have difficulties, what expectations; To the hand pain is still to make more money and anxiety of the boss, but also condescension to the hands of the staff home to sit and see what they are thinking, why He Le; a battle plan for the development of racking their brains General, may wish to sneak in to the soldiers of the big account in the turn, listen to their ideas and suggestions, will be a worthwhile trip. Often look down, may let us change thinking, may also make our impetuous mind to be soothing, will make our frenzy of desire to be cooled, into a normal psychological person, not a money machine, a workplace Madman, a disciple of the camp.&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;nbsp;&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;Often look down, is the rest is relaxed, is charging is decompression, it is wise move.&lt;/div&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;', '', '1649671149', '1649671149');
INSERT INTO `ey_article_content` VALUES ('98', '143', '&lt;div style=&quot;white-space: normal;&quot;&gt;Because want to eat boiled corn, a person slowly went to the supermarket. On the road through the park, to see a lot of people in the kite-flying, could not help but stop the footsteps, turn into the park.&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;nbsp;&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;There are a lot of people selling kites and kites in the park, of course, selling flowers, selling lanterns, selling calligraphy and painting, selling candied fruit and various snacks ... people coming and going, Here, in order to appreciate the taste of a little year, feel the breath of some spring.&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;nbsp;&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;Park selling goldfish stalls more than a few, I read one by one, I suddenly remembered the family added a pot of wealth and bamboo, just in that transparent bottle, raising two small goldfish.&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;nbsp;&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;I mention the goldfish to go when the boss recommended to me fish food, I then think of this goldfish, but also to eat. Think of the goldfish raised before, one by one because of eating and died in non-life, it is some regret, but the goldfish have paid the money, I can only hold.&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;nbsp;&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;To the supermarket to buy a boiled corn, go home all the way to go. When I passed the river, I released the goldfish into the river. At home, two daughters are playing computer, see me, my daughter asked:&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;nbsp;&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;quot;Mom, how come you&amp;#39;re so late?&amp;quot;&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;nbsp;&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;quot;I bought two small goldfish, get the river to release.&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;nbsp;&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;Goldfish can not be released, they are artificially trained ornamental fish, to the natural river, is certain death!&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;nbsp;&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;quot;Sensational!&amp;quot; I do not believe, sit on the computer before the Internet query. Really as the daughter said, goldfish can not be released. Heart can not tell what is the taste, if not my kind, this goldfish may also be able to live a few days, which may well, maybe one day died.&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;nbsp;&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;Then I said to my daughter when I release goldfish, I also think there will be one day, I went to the river to play, the river is full of red little goldfish.&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;nbsp;&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;quot;Mom, there was a story that says that during World War II, when a little girl escaped, she rushed her goldfish to the river, and when she returned home after World War II, the river was full of Little goldfish, from the food and clothing of the little girl, to sell goldfish to make a living.&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;nbsp;&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;quot;You have no intention of a little charity, will bring you a lot of unexpected surprises, this story is good.&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;nbsp;&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;quot;In fact, the story to say is an open - minded attitude towards life, that the river full of red goldfish, is the best reward for open - minded life!&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;nbsp;&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;quot;The best reward for open - minded life?&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;nbsp;&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;quot;Yes ah, the teacher said Jide good, is not seeking return, and open - minded attitude to life, there must be a return, and that return, it must be surprisingly rich!&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;nbsp;&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;quot;What is an open - minded attitude to life, and is your teacher telling you?&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;nbsp;&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;quot;No, but I think the so - called open - minded, is no matter where you are in the situation, the heart is always full of hope!&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;nbsp;&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;Talk to this point, I was sitting in front of the computer, lost in thought.&lt;/div&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;', '', '1649671159', '1649671159');
INSERT INTO `ey_article_content` VALUES ('99', '144', '&lt;div style=&quot;white-space: normal;&quot;&gt;TV, and in the report on the two suites, three suites loans. The rich is good, you can buy two suites, three suites, and many small people, even the first set of houses can not afford.&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;nbsp;&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;Is also reported on television, said a lot of Beijing district, occupancy rate of less than 30%. Not only Beijing, we have a villa group here, the occupancy rate is almost 0, in addition to the guard room lit the lights, the other places, a black whirring, looking to feel very scary.&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;nbsp;&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;Greed, is human nature, is the nature of all people!&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;nbsp;&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;In the network, often reproduced in other people&amp;#39;s articles, see the space of many people, the article has been reproduced a lot, but still kept reproduced. At the beginning, I also see good content, good topics, good pictures, reproduced to their own space, thinking that one day time enough, and then slowly taste. However, these reproduced articles, we almost do not see. First, we always do not have enough time, say, we have lost calmly calm mood, become anxious to do, are quick success, are mercenary, so those articles is basically a white turn! But many people still could not help but reproduced, and then reproduced only think to go to their own space, is their own.&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;nbsp;&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;In fact, some things are not you have, is yours. Reprinted articles you do not learn, do not use, is your and not you, what is the difference? thus. Later to see good things, I will not turn. In fact, we only get more, only focus on the owner, but just forget to enjoy their own all!&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;nbsp;&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;With the house, but do not go home all day, with the car but too lazy to go out. Always feel where, as long as you want to be able to drive straight, so those who have dreamed of going places, but also become less eager.&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;nbsp;&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;There is no desire, there is no surprise of the day, people feel that life is still. Placid life, so many people become numb, become at a loss, become no interest!&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;nbsp;&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;Modern people, with more and more rich material life, but the lack of more and more beautiful heart of the world.&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;nbsp;&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;The niece went abroad to sailboat hotel in Dubai. Just two months, how can not stay on. Asked the reason, she said sadly:&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;nbsp;&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;quot;It is not bear to see the Chinese people here every day ashamed!&amp;quot;&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;nbsp;&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;Chinese people go there, always go all the way to ask, do not know respect for staff, do not know how to at least courtesy, just feel that they spend money, we must be able to toss, Satisfied, it is not satisfied, toss to toss, but also often do not give people tips.&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;nbsp;&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;On one side is the extremely stingy room and board, while shopping is extremely generous. They often have a team to a house, often even the floor to sleep. The local shopping festival, in addition to the staff, to see almost all Chinese. So the niece often has an illusion: feel that they are in China, rather than in Dubai. Everyone out there is crazy, the kind of momentum to spend billions of dollars, really just look like a nouveau riche ah!&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;nbsp;&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;Only this also fills, more importantly, whenever the hotel&amp;#39;s stuff, fell or broke, someone always loudly said: Made in China! Words filled with disgust and disdain. As a Chinese, she felt very ashamed, so want to go back to their country.&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;nbsp;&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;What can I say? The Chinese side is the rapid economic development, while moral stagnation, making the speed of self-cultivation, always keep up with the pace of economic development. But think about it, each country is so developed, and even the beautiful Thames, has also been contaminated fish dead shrimp dead, appalling ah!&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;nbsp;&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;Every country&amp;#39;s economic development, there must be a process, to slowly. I believe that our country and our people, in a step by step onto the economic development at the same time, moral cultivation will certainly be rapid development.&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;nbsp;&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;So I told my niece, worry about the country you can not do, but you can always do your own right? You do your own work, let them on the Chinese people with admiration, rather than scoff!&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;nbsp;&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;Why is always made in China something bad? This is not only a waste of resources, but also self-destructive reputation.&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;nbsp;&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;Because we only seek the number, while ignoring the quality of ah! Why do we many people, sought after foreign brand-name products? Because of their durable stuff, when you buy is expensive, available, know very cheap and very assured! More importantly, buy such a luxury, not only the face, but also very taste!&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;nbsp;&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;Is your inner world, illuminating the world around you, to let people on the Chinese people with admiration, we must really start from the inner practice ah! Like you want to give others warm, you first if the warm!&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;nbsp;&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;Confucius, the gentleman has three ring: &amp;quot;less time, the blood gas is not set, quit the color; and strong also, blood gas just, quit the bucket; and its old men, the blood gas is bad, quit in.&amp;quot; Feel that everyone at each time, should quit the &amp;#39;greed&amp;#39; word.&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;nbsp;&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;No matter when, greed and luck are the enemy of life!&lt;/div&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;', '', '1649671169', '1649671169');
INSERT INTO `ey_article_content` VALUES ('100', '145', '&lt;div style=&quot;white-space: normal;&quot;&gt;Friends of the cousin is a taxi.&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;nbsp;&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;That day she was unfortunate by four powerful criminals kidnapped to a remote, remote place. Winter, the strength of the enemy at night, the contrast, the situation can be imagined critical.&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;nbsp;&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;Friends of the cousin side and slowly deal with criminals, while thinking out of the plan.&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;nbsp;&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;Money, jewelry, mobile phones are automatically handed out, but criminals still did not release the meaning. She had to endure the temper, and the criminals to speak, then outside, clear in the dark, that their behavior is very understanding, these criminals finally moved sympathy, pushed her off, leaving, said:&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;nbsp;&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;quot;Quickly find a place to call, let the family to pick you up, do not freeze at the middle of the night!&amp;quot; Criminals away, a friend&amp;#39;s cousin to go far, only to find a small village.&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;nbsp;&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;Finally rescued!&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;nbsp;&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;Friends of the cousin every time I talk about this matter, the last always forget to one:&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;nbsp;&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;quot;There are such good bad people in the world ah!&amp;quot; Sounds really ridiculous.&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;nbsp;&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;Coincidentally, but also highway robbery, but also the car was robbed, the criminals to be hijacked into a machine well room, Pa to coat, tie the hands and feet, blinded his eyes closed mouth, and finally to the shoes off, I do not know Thrown to what place!&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;nbsp;&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;The gangsters warn the hijackers when they go:&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;nbsp;&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;quot;You must not act rashly, because you are behind the engine well!&amp;quot;&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;nbsp;&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;Finally, how to be rescued hijacked I have forgotten, just remember that whenever it comes to this matter, his mother will always be very grateful to say:&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;nbsp;&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;quot;The world is still a good man ah! Even if the car did not, and some people will have! If it was not the man to leave a reminder, which my son, there are alive ah!&amp;quot;&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;nbsp;&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;Yeah, man in the world! A person is a world ah! Really to life and death when money and things and what is it?&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;nbsp;&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;I am convinced that everyone is good, and I firmly believe that is not compelling, no one willing to steal, to grab ... ... say no evil in the world this world without injustice, and once the property Succeeded, who could not bear to hurt people&amp;#39;s lives! The ancients cloud &amp;#39;Pirates have a way&amp;#39;, that&amp;#39;s all.&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;nbsp;&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;Because of these small moves, let these hateful robbers, also has some lovely!&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;nbsp;&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;The day before yesterday and heard a more funny. Old couple raised a flock of sheep. The night came four criminals, two looked at the old couple, the two sheep to the car loaded. At the end of the old lady pleaded:&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;nbsp;&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;quot;You leave us a lamb!&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;nbsp;&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;quot;Do not aunt, your old age so much, and then do not go sheep, so we are still thinking about.&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;nbsp;&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;In this way, criminals sped away, leaving the old couple cried. Old man to the old lady while wiping tears, while saying:&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;nbsp;&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;quot;You cry, what people say, we are old, can not be a sheep!&amp;quot; The old lady said: &amp;quot;I cry this world, ye have such a good bad man ah!&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;nbsp;&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;...&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;nbsp;&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;Yes ah, how the world there are so good bad guys ah!&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;nbsp;&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;Some people say that life is like onions, a piece of a peel, there is always a spicy will make you cry! I say life is like singing, every role has his specific mission! Good or bad people worth mentioning, the lack of which role, the world can not be regarded as perfect!&lt;/div&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;', '', '1649671180', '1649671180');
INSERT INTO `ey_article_content` VALUES ('101', '146', '&lt;div style=&quot;white-space: normal;&quot;&gt;A copy of the time, write a tie the old words, between the lines, the breeze with the breeze of the moon scene, with the quiet Huang Lei Ju situation, read in the eyes, is a story, read in the past, is a heart sound , Read in the years, is a forest Jing Hao.&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;nbsp;&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;Red is long, blowing endless sadness most likely to fans, turning chapter of the most vulnerable to heartbroken, high clear sky, Jimuyuantiao, who Xiang Yi in the river floor. Who, alone guarding the window children, dipped in surplus sleeve of the subtle fragrance, the research of the Indus twilight drizzle, falling thin than the yellow text, saying that still? Who is the autumn wind tragic fan, to three of the plum blossom, in the heartbroken voice in the memory of his life? Who, because of the know, Phi dressed in compassion, because of the good, from the dust in the open a flower, but also from the flowers in a lifetime of loneliness?&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;nbsp;&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;Far away, those vine-like growth of sadness, those near-heartbreak of the view. But time, quietly left behind a statue of the statue of the back, in every line dejected poem, pouring all the way to open fragrance, built on a dike scenery. The scenery is carefully brewed a pot of wine, need to be a suitable place to open at the right time, will mellow full. Yes, for the rhythm of the four seasons handed down, a person is often used to the opening season of joy, bloom spring, snow search for plum, accustomed to a gradually getting better and melodious and prosperous, moonlight Hawthorn, late According to Maple, and the most can not be overlooked is often the one intoxicated silence, a blank, or even just a rest rest in silence, a light music sound curl, because they are not only in attracting, but also in the Spun deeply, that deeply gurgling stream that heart, that deeply hidden in the depths of the years of a vivid picture.&lt;/div&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;', '', '1649671200', '1649671200');
INSERT INTO `ey_article_content` VALUES ('102', '147', '&lt;p style=&quot;white-space: normal;&quot;&gt;Bed is probably the most consumption life time place! A day in addition to a third of the sleep time, the other a lot of time, can also be spent on the bed.&lt;/p&gt;&lt;p style=&quot;white-space: normal;&quot;&gt;Dog back, made a cup of tea and half lying in the bed, was sleeping until nine o &amp;#39;clock! Go up and get something to eat, the east west look, already ten o &amp;#39;clock, in half an hour, going out again.&lt;/p&gt;&lt;p style=&quot;white-space: normal;&quot;&gt;Back on the playground, the ongoing autumn sports meeting of rehearsal. Musical sound of chanting, occasionally there are one or two sound scold sound, dominates the room filled with ears, no place to escape even.&lt;/p&gt;&lt;p style=&quot;white-space: normal;&quot;&gt;Person, want to quiet for a while now, it&amp;#39;s too difficult. Have a computer, television, mobile phone at home. These things no matter use, is usually open. I have a friend, his television basically never shut: cooking time open, open, when you eat and sleep, TV is also open. Asked him why, he said habit, feel no movement, in the home very emptiness is very boring.&lt;/p&gt;&lt;p style=&quot;white-space: normal;&quot;&gt;Out of the house, such as cries and advertising vehicle, all over the street. Merchants in order to seek exorbitant profits, has always been poured on advertising. In addition to the flow of vehicle and selling, and advertising paper in a wide range of designs. From hearing to visual, omni-directional propaganda no dead Angle, so which supermarket specials, you don&amp;#39;t know is difficult! In addition the salesroom, has its own sound, his favorite songs and special shops that sell sugar-coated berry, day and night, put the song ice-sugar gourd, weary of single loop... ...&lt;/p&gt;&lt;p style=&quot;white-space: normal;&quot;&gt;So, now the people want to quiet, to have deep spiritual practice. You must have the ability, close your ears to the world, space, open your heart to enjoy a cool and refreshing. Just such an opportunity, but also not much. Such and such things, always copy your heart very full is a mess. Many want to have a heart quiet ethereal! Put yourself in the place where the soul of, don&amp;#39;t those ChenShi interference.&lt;/p&gt;&lt;p style=&quot;white-space: normal;&quot;&gt;All the fruit in the home, all have no, but how to don&amp;#39;t want to go out to buy. Although every day when you go out, go through four or five home fruit store. Not forget to take money, is to bring the money and forget to buy it. Home is always open the door of that a moment, before crashing. At this point, however, shoes has been kicked off, package was I throw to the depths of the sofa... ...&lt;/p&gt;&lt;p style=&quot;white-space: normal;&quot;&gt;And so next time, may is so every time.&lt;/p&gt;&lt;p style=&quot;white-space: normal;&quot;&gt;Used to open the computer, the trouble to listen to the shaoxing opera. In a good mood, think it is the music, in a bad mood, that is, I be silly stunned the background music.&lt;/p&gt;&lt;p style=&quot;white-space: normal;&quot;&gt;For a lover&amp;#39;s birthday, the girls want to give my father to buy a watch, in online shopping for a long time, still not sure. Figures is mostly have scale didn&amp;#39;t dial, so watch how do I not up, daughter so angry:&lt;/p&gt;&lt;p style=&quot;white-space: normal;&quot;&gt;&amp;quot;Mom, when all the people are like you, you see table will only see electronic watch, also is 12 system.&amp;quot;&lt;/p&gt;&lt;p style=&quot;white-space: normal;&quot;&gt;&amp;quot;Of course not all like me, but your dad every day old, someday, he is not as good as my! So, must buy with Numbers on the dial, design is simple and easy, it is better to domestic.&amp;quot;&lt;/p&gt;&lt;p style=&quot;white-space: normal;&quot;&gt;&amp;quot;Domestic mechanical or quartz? What brand do you want?&amp;quot;&lt;/p&gt;&lt;p style=&quot;white-space: normal;&quot;&gt;&amp;quot;To quartz, need not everyday winding, brand to the seagull.&amp;quot;&lt;/p&gt;&lt;p style=&quot;white-space: normal;&quot;&gt;&amp;quot;Gull? Never heard of.&amp;quot;&lt;/p&gt;&lt;p style=&quot;white-space: normal;&quot;&gt;&amp;quot;The Internet, as a Chinese, incredibly don&amp;#39;t know the seagull watch?&amp;quot;&lt;/p&gt;&lt;p style=&quot;white-space: normal;&quot;&gt;A daughter called me again:&lt;/p&gt;&lt;p style=&quot;white-space: normal;&quot;&gt;&amp;quot;Want to use domestic seagull watch, temporarily can&amp;#39;t afford one, your daughter is thousands of tens of thousands of.&amp;quot;&lt;/p&gt;&lt;p style=&quot;white-space: normal;&quot;&gt;Then, my daughter on QQ, send me a link, I open on see, isn&amp;#39;t it? Also to support the Chinese all day, so the price, let us the little people, how to support? A newlywed, bought a watch the seagulls, less than 200 dollars.&lt;/p&gt;&lt;p style=&quot;white-space: normal;&quot;&gt;Love came back from work, said to him. See I wasn&amp;#39;t impressed, he looked at me and said:&lt;/p&gt;&lt;p style=&quot;white-space: normal;&quot;&gt;&amp;quot;You are less than 200 pieces, I was monthly salary less than 120 yuan! For more than a month of wages, or to the present, not thousands of useful!&amp;quot;&lt;/p&gt;&lt;p style=&quot;white-space: normal;&quot;&gt;&amp;quot;Times are different, then spend 200 dollars to buy a watch, also did not think how, how now but not willing to give up?&amp;quot;&lt;/p&gt;&lt;p style=&quot;white-space: normal;&quot;&gt;&amp;quot;Don&amp;#39;t think that way, that was didn&amp;#39;t spend your money.&amp;quot;&lt;/p&gt;&lt;p style=&quot;white-space: normal;&quot;&gt;&amp;quot;You don&amp;#39;t say you bought me a watch, to now you still love dearly!&amp;quot;&lt;/p&gt;&lt;p style=&quot;white-space: normal;&quot;&gt;Just, we quarrel, forget the computer was still on voice calls, two girls over there spirit shout loudly:&lt;/p&gt;&lt;p style=&quot;white-space: normal;&quot;&gt;&amp;quot;How noisy again? Mom, you give the computer to my father, let my dad said he&amp;#39;d quartz or mechanical.&amp;quot; , I put my computer to lover.&lt;/p&gt;&lt;p style=&quot;white-space: normal;&quot;&gt;&amp;quot;I want to mechanical, don&amp;#39;t be too high price, didn&amp;#39;t I give you remit money.&amp;quot;&lt;/p&gt;&lt;p style=&quot;white-space: normal;&quot;&gt;&amp;quot;Dial? Digital or graduated? Color should be black and white or grey days?&amp;quot;&lt;/p&gt;&lt;p style=&quot;white-space: normal;&quot;&gt;&amp;quot;Digital calibration, color should be black and white.&amp;quot;&lt;/p&gt;&lt;p style=&quot;white-space: normal;&quot;&gt;&amp;quot;Oh, is it not a watch? Things are!&amp;quot; I can&amp;#39;t help by chimed in.&lt;/p&gt;&lt;p style=&quot;white-space: normal;&quot;&gt;&amp;quot;Dad, are you sure?&amp;quot;&lt;/p&gt;&lt;p style=&quot;white-space: normal;&quot;&gt;&amp;quot;Sure, your mother rush to surf the Internet!&amp;quot;&lt;/p&gt;&lt;p style=&quot;white-space: normal;&quot;&gt;&amp;quot;Don&amp;#39;t worry, table boxes, there are two kinds of color, a red and black which one would you like?&amp;quot;&lt;/p&gt;&lt;p style=&quot;white-space: normal;&quot;&gt;&amp;quot;It doesn&amp;#39;t matter what kind of watch box, anyway just wear a watch and don&amp;#39;t wear a watch box.&amp;quot; And I say a word of mouth.&lt;/p&gt;&lt;p style=&quot;white-space: normal;&quot;&gt;&amp;quot;Mother, we buy birthday gift for dad, want to buy my father favorite, of course, you don&amp;#39;t interrupt, ok.&amp;quot;&lt;/p&gt;&lt;p style=&quot;white-space: normal;&quot;&gt;&amp;quot;What color do you like table box, what colour will! Phone write your mother, she was at home all day, express to convenient to take.&amp;quot;&lt;/p&gt;&lt;p style=&quot;white-space: normal;&quot;&gt;Buy this table events, finally hammered out, love start browsing for news.&lt;/p&gt;&lt;p style=&quot;white-space: normal;&quot;&gt;&amp;quot;Take headphones to you, I want to quiet for a while.&amp;quot;&lt;/p&gt;&lt;p style=&quot;white-space: normal;&quot;&gt;&amp;quot;Want to quiet, what did you do for dinner?&amp;quot; Yeah, just and daughter discuss watch things, how to forget to do dinner?&lt;/p&gt;&lt;p style=&quot;white-space: normal;&quot;&gt;You see, this want to quiet for a moment, really difficult! You can close the earth is the ear, you don&amp;#39;t shut the appetite of the world! Darling still cooking go to! Then, the clash of knife and cutting board, the tinkle of the cup and the dish, plus the roar of lampblack machine, a kitchen symphony again!&lt;/p&gt;&lt;p style=&quot;white-space: normal;&quot;&gt;&amp;quot;Shut the kitchen door, noisy dead.&amp;quot; Lover to roar, I closed the door of the kitchen. Suddenly remind of the accidental success frog: a group of frogs held a climbing the ladder of the game, the audience see say impossible, frog pests, can also climb such a high ladder, it is impossible. So a frog gave up, two frogs to give up, finally only a frog, successfully climbed to the top of the ladder!&lt;/p&gt;&lt;p style=&quot;white-space: normal;&quot;&gt;It is successful, all the frogs congratulations to it, then you know, the frog was deaf!&lt;/p&gt;&lt;p style=&quot;white-space: normal;&quot;&gt;Because it simply couldn&amp;#39;t hear the negative voice, so, in the end, it keep a success!&lt;/p&gt;&lt;p style=&quot;white-space: normal;&quot;&gt;So, we also want to try, closed our earthly ears, don&amp;#39;t let the negative voice, affect our positive ambition! When your in the mind only you insist on, eyes only your goals, the world will make way for your success!&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;', '', '1649671223', '1649671223');
INSERT INTO `ey_article_content` VALUES ('103', '148', '&lt;div style=&quot;white-space: normal;&quot;&gt;Life is a fleeting moment in the river of time, mankind do everything possible to seek forever and everlasting, but did not think, in fact, as long as the pace of their own slow down mentality flat, live in the present, then life will naturally become long and distant .&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;nbsp;&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;When I did not write a magazine before, I did not know that the time had come in advance. A draft of March or even April has been prepared in January. In the draft of the forum while watching the side gripped, his year has not yet ended, did not make a point, there people work has been a year, almost equal to the end. Years here, was actually can not wait to catch up with the speed of flight, how to make people panic?&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;nbsp;&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;The length of time is defined by man himself. 365 days a year, divided into four seasons, twelve months. Here, people always catch up with me like the game, to see who can one day into a day. Our ancestors know, if the decade into a year, we will so impatient it?&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;nbsp;&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;Days not used, can only be used to recover. Self has no intention to enter this door, it fell into such a turbulent swirl. Calendars and clocks on the numbers can only represent the past, because today to do, is already the future. Obviously is the spring, but the men have been doing non-stop fall thing.&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;nbsp;&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;There is nothing worthy of gratification, no reason for youth just a short length of a bit like others. What is the use of walking in front, time falls behind, urging the old soul and face it in vain.&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;nbsp;&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;The fast pace of modern people, nothing more than to speed up the clock of life, their own pressure and persecution of a way, only to more fully squeeze the juice of life to obtain value and fame. But I see it is faster and more leave no room for the consumption and flight. How, a ton of gold can be exchanged for even a second time?&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;nbsp;&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;Americans always run in front of the world, even spend today are tomorrow, the result? The financial crisis has finally shattered this myth of early consumption, punish all activities contrary to the laws of nature.&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;nbsp;&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;Beijing, then, a little leisurely. People live I, a spring vegetation, how short and beautiful time. If you can walk, why should anxious to run, miss the scenery all the way? Note that the front is not another spring, but has been waiting for you to close the end of life.&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;nbsp;&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;Tomorrow&amp;#39;s thing is done today, and next year&amp;#39;s event is finished this year. So ahead of the outstanding achievements and efforts, but is a result of the advance of life.&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;nbsp;&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;What is a rivers and lakes years reminder, juvenile children rivers and lakes old? This is the helplessness of life rather than enjoyment.&lt;/div&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;', '', '1649671234', '1649671234');
INSERT INTO `ey_article_content` VALUES ('104', '149', '&lt;div style=&quot;white-space: normal;&quot;&gt;Summer dusk, I sit with an old Chinese medicine in the breeze slowly chatting the river. Suddenly, the old man stared at my face for a moment and did not say anything. I was his heart to see some hair, asked: &amp;quot;The elderly, you are so concerned about my face, is not something to see ah?&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;nbsp;&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;Old man smiled and said: &amp;quot;I am from primary school medicine, the teacher told me again and again, &amp;#39;people peace of mind level, see the eyes; life span, look at the face&amp;#39; medical life, develop habits, and Oh, and people Together, they always want to look at his face more glances.&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;nbsp;&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;I said: &amp;quot;The elderly, all know that the eyes are the soul of the window, the first sentence I can understand, you can say &amp;#39;life span, look at the face&amp;#39;, I am a little puzzled.Human life, how to write in the face What about it? &amp;quot;&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;nbsp;&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;If a person is always sad intestine knot, mood melancholy, over-thinking, suspicious of the old man said: \\ look at the face, in fact, I look at his face two, one eyebrow, Indecisive, can not see the hope of life and the good life, then, between the eyebrow must form a deep &amp;#39;eight&amp;#39; pattern.&amp;#39;8 &amp;#39;pattern, is caused by squeezing distortion, Yin is too strong, the mood Difficult to cool, it will stagnate in the organs; Jiuyin poisonous, viscera unbearable corrosion, must be made for the disease; sick in the body, is bound to further deteriorate the mood.People once caught in the heart and the destruction of each other malignant disease Circle among the health does not exist, where there will be longevity of the reason? Eyebrow between the &amp;#39;eight&amp;#39; pattern, in fact, cut the knife of life, so my teacher had more than once said to me, &amp;#39;brow wrinkled, You must be careful yo. &amp;quot;&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;nbsp;&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;The elderly, then let my heart anxious, usually not pay attention to the eyebrow between the &amp;#39;eight&amp;#39; pattern, even with such a large knowledge. I could not help but curiosity driven, and then asked: &amp;quot;That mouth can see what?&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;nbsp;&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;A person if the hearty and fun, often laughing more than, the teeth often in the sun, then, in order to make the mouth a little bit, The &amp;#39;brackets&amp;#39; is radian, as if the relative out of the two and a half months, set in the cheek on top of the vivid expression of light from the formation of the reasons we can see, brackets who are really comfortable Because the &amp;#39;brackets&amp;#39; on both sides of the mouth, but also a symbol of the balance of yin and yang, therefore, it is encompassed by the health of the body, the spirit of the sparse, the vitality of life, leisurely and carefree, The music of the state of mind and the endless hope of life in such a life and mental state of the people, you say he can not live longer?&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;nbsp;&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;Really listen to Jun words, read the book a decade, my heart is not good fun ah. It turned out that our face, really reveal the mentality of our strengths and weaknesses, the vicissitudes of life and life status and other important information ah. Therefore, we usually still often look in the mirror to see if his face is increasing or deepening: the eyebrow between the &amp;quot;eight&amp;quot; pattern, or the mouth &amp;quot;brackets&amp;quot; it!&lt;/div&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;', '', '1649671245', '1649671245');
INSERT INTO `ey_article_content` VALUES ('105', '150', '&lt;div style=&quot;white-space: normal;&quot;&gt;The first is &amp;quot;poverty&amp;quot;&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;nbsp;&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;nbsp;&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;nbsp;&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;Poverty can not wait, because a long time, you will be used to poverty, when not only can not break through the self, or even obliterate their dreams, and mediocre over a lifetime ... ...&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;nbsp;&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;nbsp;&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;nbsp;&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;The second is &amp;quot;dream&amp;quot;&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;nbsp;&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;nbsp;&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;nbsp;&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;Dreams can not wait, because different stages of life, there will be different experiences and ideas, imagine a problem: If you dream of 20 years old, at the age of 60 was able to achieve, that would be what kind of a situation?&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;nbsp;&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;nbsp;&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;nbsp;&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;For example, your 20-year-old dream is to buy a Ferrari sports car, and then traveled to China&amp;#39;s great rivers and mountains. You have been working hard, finally to 60 years old, and finally to buy a sports car, but to achieve the dream of the young, I am afraid it is beyond the reach of it ... ...&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;nbsp;&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;nbsp;&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;nbsp;&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;The third is &amp;quot;family&amp;quot;&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;nbsp;&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;nbsp;&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;nbsp;&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;Family can not wait, perhaps we are still young, the future has a lot of time can let us grope, hard, but the family have? They still have time for us to succeed? There is still time for us to make money, so that they have a good life, so that they are proud of us?&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;nbsp;&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;nbsp;&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;nbsp;&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;Trees for static and wind, the child wants to support and pro-not wait. This is a lot of people&amp;#39;s pain, but also a lot of people a lifetime of regret!&lt;/div&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;', '', '1649671255', '1649671255');
INSERT INTO `ey_article_content` VALUES ('106', '151', '&lt;div style=&quot;white-space: normal;&quot;&gt;The reason why people live tired, is not fit the shelf, tear can not open face, untied plot (the reason is very simple)&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;nbsp;&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;nbsp;&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;nbsp;&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;Your life needs to understand the stand in their own position, not everyone is in line with your appetite; standing in other positions, you can also to all the appetite? (Tolerance of others)&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;nbsp;&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;nbsp;&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;nbsp;&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;People who can simplify complex problems are talented people, and it is silly to complicate simple problems. (People are often willing to be a fool)&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;nbsp;&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;nbsp;&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;nbsp;&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;A woman most admired men talented, most hated men are too stingy, most afraid of men do not live up to expectations. (Men afraid of the old woman angry)&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;nbsp;&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;nbsp;&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;nbsp;&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;Itching sometimes worse than pain, hate is often easier than love (paradox of life)&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;nbsp;&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;nbsp;&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;nbsp;&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;The opportunity for everyone is equal, you can not shoot the chance, but the opportunity comes when you can not do without bullets (doing business is to do this)&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;nbsp;&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;nbsp;&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;nbsp;&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;Love is like a smallpox, and each of us has to go through it once, and, as with smallpox, we will only get once in a lifetime. You never have to worry about getting a second time.&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;nbsp;&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;nbsp;&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;nbsp;&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;Ancient love stories and more contemporary love accident (different times).&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;nbsp;&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;nbsp;&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;nbsp;&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;A person who does not make mistakes usually can not accomplish anything, and there are no shortcomings, often with little merit (Lincoln&amp;#39;s experience).&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;nbsp;&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;nbsp;&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;nbsp;&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;Businessmen are &amp;quot;people who can talk,&amp;quot; businessmen are &amp;quot;people who can give birth to ideas.&amp;quot; (Alternative explanation)&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;nbsp;&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;nbsp;&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;nbsp;&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;There are seven virtues: First, do not get the ax, the second is not to interrupt other words, the third is not anxious for success, four questions should be targeted, five answers to meet the reasonable, six is to have a beginning and end, seven is to Based on reality. (Ancient Jewish Proverbs).&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;nbsp;&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;nbsp;&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;nbsp;&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;Unit to work overtime every day; home never stick; mobile phone home to close; SMS reading on the delete; go to bed snoring shaking; underwear often wear back. (With an affair of the six symptoms).&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;nbsp;&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;nbsp;&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;nbsp;&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;Do what you think can not do (how much heart, how far the road).&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;nbsp;&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;nbsp;&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;nbsp;&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;The heart is a two-bedroom house, one is suffering, one is happy. People can not laugh too loud, or laughter will wake up next to the pain. (To avoid very happy).&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;nbsp;&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;nbsp;&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;nbsp;&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;If you marry a wise and virtuous wife, you will be happy; if you marry a frivolous bitch, you will become a philosopher. (Marriage useful).&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;nbsp;&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;nbsp;&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;nbsp;&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;Can not tell, can not cry, is the most bitter (life reflected).&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;nbsp;&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;nbsp;&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;nbsp;&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;Where to fall, just lie down (some pessimists).&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;nbsp;&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;nbsp;&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;nbsp;&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;The real question is not whether the spouse is the best person, but whether you are trying to be the best person for your spouse (the Happy Marriage Bible).&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;nbsp;&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;nbsp;&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;nbsp;&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;The only advantage of telling the truth is that you do not have to remember what you said (Quotations User).&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;nbsp;&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;nbsp;&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;nbsp;&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;You can offend busy people, because they do not have time to care about you; you must not offend idlers, because they have time to deal with you. (Do not offend idlers).&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;nbsp;&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;nbsp;&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;nbsp;&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;If you can not change your face, then you change your face (not beautiful, it can be very cute).&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;nbsp;&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;nbsp;&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;nbsp;&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;Than bathing, washing the sauna is more important is the brainwashing, bath does not wash will be distributed odor, brain wash will be eliminated by the times (we often forget this).&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;nbsp;&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;nbsp;&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;nbsp;&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;Do not believe your memories, the person inside, not necessarily the same miss you (with memories of the road, rather than holding the memories of life).&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;nbsp;&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;nbsp;&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;nbsp;&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;There should be a better way to start a new day than waking up every morning (office worker philosopher).&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;nbsp;&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;nbsp;&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;nbsp;&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;Toad want to eat swan, good kind, small things with ambition (to educate the next generation).&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;nbsp;&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;nbsp;&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;&amp;nbsp;&lt;/div&gt;&lt;div style=&quot;white-space: normal;&quot;&gt;Rich does not have much, but less luxury. (New view of wealth).&lt;/div&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;', '', '1649671265', '1649671265');
INSERT INTO `ey_article_content` VALUES ('107', '152', '&lt;p&gt;From Wuyi Mountain, Fujian native, aroma fragrance Orchid fragrance, flavor and good and lasting, &amp;quot;rock and rhyme&amp;quot; apparently, resistant to brew.&lt;/p&gt;', '', '1649671958', '1649671958');
INSERT INTO `ey_article_content` VALUES ('108', '153', '&lt;p&gt;From Wuyi Mountain, Fujian native, aroma fragrance Orchid fragrance, flavor and good and lasting, &amp;quot;rock and rhyme&amp;quot; apparently, resistant to brew.&lt;/p&gt;', '', '1649671983', '1649671983');
INSERT INTO `ey_article_content` VALUES ('109', '154', '&lt;p&gt;Tea-small tight and slender, gold and yellow, black and white, open flood-color golden yellow, sweet into the throat. The water, smell and taste like fruit, honey, flowers, potato chips and other integrated flavor, taste fresh and sweet, and throats a long&lt;/p&gt;', '', '1649672002', '1649672002');
INSERT INTO `ey_article_content` VALUES ('110', '155', '&lt;p&gt;Raw material selection of Sun Yunnan big leaves and delicate green tea, cable sturdy, Bud stout tippy, fermented into moderate color red is still strong, mellow taste sweet, bitter taste into moderation, pure aroma, faint fragrance.&lt;/p&gt;', '', '1649672024', '1649672024');
INSERT INTO `ey_article_content` VALUES ('111', '156', '&lt;p&gt;Tea-small tight and slender, gold and yellow, black and white, open flood-color golden yellow, sweet into the throat. The water, smell and taste like fruit, honey, flowers, potato chips and other integrated flavor, taste fresh and sweet, and throats a long&lt;/p&gt;', '', '1649672045', '1649672045');
INSERT INTO `ey_article_content` VALUES ('112', '157', '&lt;p&gt;Raw material selection of Sun Yunnan big leaves and delicate green tea, cable sturdy, Bud stout tippy, fermented into moderate color red is still strong, mellow taste sweet, bitter taste into moderation, pure aroma, faint fragrance.&lt;/p&gt;', '', '1649672078', '1649672078');
INSERT INTO `ey_article_content` VALUES ('113', '158', '&lt;p&gt;Raw material selection of Sun Yunnan big leaves and delicate green tea, cable sturdy, Bud stout tippy, fermented into moderate color red is still strong, mellow taste sweet, bitter taste into moderation, pure aroma, faint fragrance.&lt;/p&gt;', '', '1649672095', '1649672095');
INSERT INTO `ey_article_content` VALUES ('114', '159', '&lt;p&gt;Raw material selection of Sun Yunnan big leaves and delicate green tea, cable sturdy, Bud stout tippy, fermented into moderate color red is still strong, mellow taste sweet, bitter taste into moderation, pure aroma, faint fragrance.&lt;/p&gt;', '', '1649672113', '1649672113');
INSERT INTO `ey_article_content` VALUES ('115', '160', '&lt;p&gt;Raw material selection of Sun Yunnan big leaves and delicate green tea, cable sturdy, Bud stout tippy, fermented into moderate color red is still strong, mellow taste sweet, bitter taste into moderation, pure aroma, faint fragrance.&lt;/p&gt;', '', '1649672131', '1649672131');
INSERT INTO `ey_article_content` VALUES ('116', '161', '&lt;p&gt;Raw material selection of Sun Yunnan big leaves and delicate green tea, cable sturdy, Bud stout tippy, fermented into moderate color red is still strong, mellow taste sweet, bitter taste into moderation, pure aroma, faint fragrance.&lt;/p&gt;', '', '1649672158', '1649672158');
INSERT INTO `ey_article_content` VALUES ('117', '162', '&lt;p&gt;Tea-small tight and slender, gold and yellow, black and white, open flood-color golden yellow, sweet into the throat. The water, smell and taste like fruit, honey, flowers, potato chips and other integrated flavor, taste fresh and sweet, and throats a long&lt;/p&gt;', '', '1649672176', '1649672176');
INSERT INTO `ey_article_content` VALUES ('118', '163', '&lt;p&gt;Tea-small tight and slender, gold and yellow, black and white, open flood-color golden yellow, sweet into the throat. The water, smell and taste like fruit, honey, flowers, potato chips and other integrated flavor, taste fresh and sweet, and throats a long&lt;/p&gt;', '', '1649672196', '1649672196');
INSERT INTO `ey_article_content` VALUES ('119', '164', '&lt;p&gt;Tea-small tight and slender, gold and yellow, black and white, open flood-color golden yellow, sweet into the throat. The water, smell and taste like fruit, honey, flowers, potato chips and other integrated flavor, taste fresh and sweet, and throats a long&lt;/p&gt;', '', '1649672214', '1649672214');

-- -----------------------------
-- Table structure for `ey_article_order`
-- -----------------------------
DROP TABLE IF EXISTS `ey_article_order`;
CREATE TABLE `ey_article_order` (
  `order_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '文章订单ID',
  `order_code` varchar(50) NOT NULL DEFAULT '' COMMENT '媒体订单编号',
  `users_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '会员ID',
  `order_status` tinyint(1) NOT NULL DEFAULT '0' COMMENT '订单状态：0未付款，1已付款',
  `order_amount` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '订单应付总金额',
  `pay_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '支付时间',
  `pay_name` varchar(20) NOT NULL DEFAULT '' COMMENT '支付方式名称',
  `wechat_pay_type` varchar(20) NOT NULL DEFAULT '' COMMENT '微信支付时，标记使用的支付类型（扫码支付，微信内部，微信H5页面）',
  `pay_details` text COMMENT '支付时返回的数据，以serialize序列化后存入，用于后续查询。',
  `product_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '视频文档ID',
  `product_name` varchar(100) DEFAULT '' COMMENT '视频文档名称',
  `product_litpic` varchar(500) DEFAULT '' COMMENT '视频文档封面图片',
  `lang` varchar(30) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) unsigned DEFAULT '0' COMMENT '下单时间',
  `update_time` int(11) unsigned DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`order_id`),
  UNIQUE KEY `order_code` (`order_code`) USING BTREE,
  KEY `users_id` (`users_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='文章订单表';


-- -----------------------------
-- Table structure for `ey_article_pay`
-- -----------------------------
DROP TABLE IF EXISTS `ey_article_pay`;
CREATE TABLE `ey_article_pay` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `aid` int(11) DEFAULT '0',
  `part_free` tinyint(1) DEFAULT '0' COMMENT '是否试看 0-否 1-是',
  `size` varchar(50) DEFAULT '1' COMMENT 'KB',
  `free_content` longtext COMMENT '试看内容',
  `add_time` int(11) DEFAULT '0',
  `update_time` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='文章付费预览表';


-- -----------------------------
-- Table structure for `ey_ask`
-- -----------------------------
DROP TABLE IF EXISTS `ey_ask`;
CREATE TABLE `ey_ask` (
  `ask_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `type_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '问题栏目ID',
  `users_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '会员ID',
  `ask_title` varchar(200) NOT NULL DEFAULT '' COMMENT '问题标题',
  `is_recom` tinyint(1) NOT NULL DEFAULT '0' COMMENT '问题是否推荐',
  `status` tinyint(1) NOT NULL DEFAULT '0' COMMENT '问题状态：0未解决，1已解决，2已关闭',
  `click` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '浏览点击量',
  `replies` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '问题回复量',
  `content` text NOT NULL COMMENT '问题内容',
  `url` varchar(255) NOT NULL DEFAULT '' COMMENT '问题网址',
  `users_ip` varchar(50) NOT NULL DEFAULT '' COMMENT '问题发布时IP地址',
  `is_review` tinyint(1) NOT NULL DEFAULT '1' COMMENT '问题是否审核，1是，0否',
  `follow` tinyint(1) NOT NULL DEFAULT '0' COMMENT '关注问题则表示有回复时发送邮件通知到问题发布人',
  `solve_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '解决时间(这个问题存在最佳答案则表示已解决)',
  `bestanswer_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '最佳答案',
  `sort_order` int(10) NOT NULL DEFAULT '100' COMMENT '排序号',
  `add_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '新增时间',
  `update_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  `money` decimal(8,2) NOT NULL DEFAULT '0.00' COMMENT '悬赏金额',
  `is_del` tinyint(1) DEFAULT '0' COMMENT '1-删除',
  PRIMARY KEY (`ask_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='问题表';


-- -----------------------------
-- Table structure for `ey_ask_answer`
-- -----------------------------
DROP TABLE IF EXISTS `ey_ask_answer`;
CREATE TABLE `ey_ask_answer` (
  `answer_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `ask_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '问题ID',
  `is_bestanswer` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否最佳答案，0否，1是',
  `is_review` tinyint(1) NOT NULL DEFAULT '1' COMMENT '问题是否审核，1是，0否',
  `type_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '问题栏目ID',
  `users_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '用户ID',
  `username` varchar(50) NOT NULL DEFAULT '' COMMENT '用户名',
  `click_like` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '点赞量',
  `users_ip` varchar(30) NOT NULL DEFAULT '' COMMENT '用户IP地址',
  `content` text NOT NULL COMMENT '内容',
  `ifcheck` tinyint(1) NOT NULL DEFAULT '1',
  `answer_pid` int(10) NOT NULL DEFAULT '0' COMMENT '子答案的父答案',
  `at_users_id` int(10) NOT NULL DEFAULT '0' COMMENT '被@的用户ID',
  `at_answer_id` int(10) NOT NULL DEFAULT '0' COMMENT '@答案ID',
  `add_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '新增时间',
  `update_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  `is_del` tinyint(1) NOT NULL DEFAULT '0' COMMENT '1-删除',
  PRIMARY KEY (`answer_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='答案表';


-- -----------------------------
-- Table structure for `ey_ask_answer_like`
-- -----------------------------
DROP TABLE IF EXISTS `ey_ask_answer_like`;
CREATE TABLE `ey_ask_answer_like` (
  `like_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `ask_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '问题ID',
  `answer_id` int(10) NOT NULL DEFAULT '0' COMMENT '答案ID',
  `users_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '用户ID',
  `click_like` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '点赞',
  `like_source` tinyint(1) unsigned NOT NULL DEFAULT '2' COMMENT '点赞来源，1=点赞提问(ask_id)，2=点赞评论(answer_id)，3=点赞回复(answer_id)，默认值为2，兼容以前的那些评论数据',
  `users_ip` varchar(30) NOT NULL DEFAULT '' COMMENT '用户IP地址',
  `add_time` int(10) unsigned NOT NULL DEFAULT '0',
  `update_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`like_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='答案点赞表';


-- -----------------------------
-- Table structure for `ey_ask_score_level`
-- -----------------------------
DROP TABLE IF EXISTS `ey_ask_score_level`;
CREATE TABLE `ey_ask_score_level` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `name` varchar(55) DEFAULT '',
  `min` mediumint(8) DEFAULT '0',
  `max` mediumint(8) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 COMMENT='积分等级表';

-- -----------------------------
-- Records of `ey_ask_score_level`
-- -----------------------------
INSERT INTO `ey_ask_score_level` VALUES ('1', '青铜', '0', '1000');
INSERT INTO `ey_ask_score_level` VALUES ('2', '白银', '1001', '5000');
INSERT INTO `ey_ask_score_level` VALUES ('3', '黄金', '5001', '20000');
INSERT INTO `ey_ask_score_level` VALUES ('4', '王者', '20001', '0');

-- -----------------------------
-- Table structure for `ey_ask_type`
-- -----------------------------
DROP TABLE IF EXISTS `ey_ask_type`;
CREATE TABLE `ey_ask_type` (
  `type_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '栏目自增',
  `type_name` varchar(100) NOT NULL DEFAULT '' COMMENT '栏目名称',
  `parent_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '上级ID',
  `seo_title` varchar(200) DEFAULT '' COMMENT 'SEO标题',
  `seo_keywords` varchar(200) DEFAULT '' COMMENT 'seo关键字',
  `seo_description` text COMMENT 'seo描述',
  `sort_order` int(10) unsigned NOT NULL DEFAULT '100' COMMENT '排序号',
  `add_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '新增时间',
  `update_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`type_id`)
) ENGINE=MyISAM AUTO_INCREMENT=6 DEFAULT CHARSET=utf8 COMMENT='问题栏目分类表';

-- -----------------------------
-- Records of `ey_ask_type`
-- -----------------------------
INSERT INTO `ey_ask_type` VALUES ('1', '问题求助', '0', '', '', '', '100', '1565770890', '1611910466');
INSERT INTO `ey_ask_type` VALUES ('2', '功能建议', '0', '', '', '', '100', '1565770890', '1611910466');
INSERT INTO `ey_ask_type` VALUES ('3', 'BUG反馈', '1', '', '', '', '100', '1565771021', '1611910466');
INSERT INTO `ey_ask_type` VALUES ('4', '其他问题', '1', '', '', '', '100', '1565771021', '1611910466');
INSERT INTO `ey_ask_type` VALUES ('5', '业务咨询', '0', '', '', '', '100', '1611910466', '1611910466');

-- -----------------------------
-- Table structure for `ey_auth_access`
-- -----------------------------
DROP TABLE IF EXISTS `ey_auth_access`;
CREATE TABLE `ey_auth_access` (
  `role_id` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT '角色ID',
  `rule_id` int(11) NOT NULL DEFAULT '0' COMMENT '权限ID',
  KEY `role_id` (`role_id`) USING BTREE,
  KEY `rule_id` (`rule_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='权限授权表';

-- -----------------------------
-- Records of `ey_auth_access`
-- -----------------------------
INSERT INTO `ey_auth_access` VALUES ('12', '176');
INSERT INTO `ey_auth_access` VALUES ('12', '177');
INSERT INTO `ey_auth_access` VALUES ('12', '178');
INSERT INTO `ey_auth_access` VALUES ('12', '179');
INSERT INTO `ey_auth_access` VALUES ('12', '180');
INSERT INTO `ey_auth_access` VALUES ('12', '181');
INSERT INTO `ey_auth_access` VALUES ('12', '182');
INSERT INTO `ey_auth_access` VALUES ('12', '183');
INSERT INTO `ey_auth_access` VALUES ('12', '184');
INSERT INTO `ey_auth_access` VALUES ('12', '185');
INSERT INTO `ey_auth_access` VALUES ('12', '186');
INSERT INTO `ey_auth_access` VALUES ('12', '187');
INSERT INTO `ey_auth_access` VALUES ('12', '188');
INSERT INTO `ey_auth_access` VALUES ('12', '189');
INSERT INTO `ey_auth_access` VALUES ('12', '190');
INSERT INTO `ey_auth_access` VALUES ('12', '191');
INSERT INTO `ey_auth_access` VALUES ('12', '192');
INSERT INTO `ey_auth_access` VALUES ('12', '193');
INSERT INTO `ey_auth_access` VALUES ('12', '194');
INSERT INTO `ey_auth_access` VALUES ('12', '195');
INSERT INTO `ey_auth_access` VALUES ('12', '196');
INSERT INTO `ey_auth_access` VALUES ('12', '197');
INSERT INTO `ey_auth_access` VALUES ('12', '198');
INSERT INTO `ey_auth_access` VALUES ('12', '81');
INSERT INTO `ey_auth_access` VALUES ('12', '62');
INSERT INTO `ey_auth_access` VALUES ('12', '61');
INSERT INTO `ey_auth_access` VALUES ('12', '8');
INSERT INTO `ey_auth_access` VALUES ('12', '70');
INSERT INTO `ey_auth_access` VALUES ('12', '71');
INSERT INTO `ey_auth_access` VALUES ('12', '72');
INSERT INTO `ey_auth_access` VALUES ('11', '176');
INSERT INTO `ey_auth_access` VALUES ('11', '177');
INSERT INTO `ey_auth_access` VALUES ('11', '178');
INSERT INTO `ey_auth_access` VALUES ('11', '179');
INSERT INTO `ey_auth_access` VALUES ('11', '180');
INSERT INTO `ey_auth_access` VALUES ('11', '181');
INSERT INTO `ey_auth_access` VALUES ('11', '182');
INSERT INTO `ey_auth_access` VALUES ('11', '184');
INSERT INTO `ey_auth_access` VALUES ('11', '185');
INSERT INTO `ey_auth_access` VALUES ('11', '186');
INSERT INTO `ey_auth_access` VALUES ('11', '187');
INSERT INTO `ey_auth_access` VALUES ('11', '188');
INSERT INTO `ey_auth_access` VALUES ('11', '189');
INSERT INTO `ey_auth_access` VALUES ('11', '191');
INSERT INTO `ey_auth_access` VALUES ('11', '192');
INSERT INTO `ey_auth_access` VALUES ('11', '193');
INSERT INTO `ey_auth_access` VALUES ('11', '194');
INSERT INTO `ey_auth_access` VALUES ('11', '195');
INSERT INTO `ey_auth_access` VALUES ('11', '196');
INSERT INTO `ey_auth_access` VALUES ('11', '197');
INSERT INTO `ey_auth_access` VALUES ('11', '198');
INSERT INTO `ey_auth_access` VALUES ('11', '199');
INSERT INTO `ey_auth_access` VALUES ('11', '200');
INSERT INTO `ey_auth_access` VALUES ('11', '201');
INSERT INTO `ey_auth_access` VALUES ('11', '202');
INSERT INTO `ey_auth_access` VALUES ('11', '203');
INSERT INTO `ey_auth_access` VALUES ('11', '204');
INSERT INTO `ey_auth_access` VALUES ('11', '205');
INSERT INTO `ey_auth_access` VALUES ('11', '206');
INSERT INTO `ey_auth_access` VALUES ('11', '207');
INSERT INTO `ey_auth_access` VALUES ('11', '208');
INSERT INTO `ey_auth_access` VALUES ('11', '209');
INSERT INTO `ey_auth_access` VALUES ('11', '210');
INSERT INTO `ey_auth_access` VALUES ('11', '211');
INSERT INTO `ey_auth_access` VALUES ('11', '125');
INSERT INTO `ey_auth_access` VALUES ('11', '126');
INSERT INTO `ey_auth_access` VALUES ('11', '127');
INSERT INTO `ey_auth_access` VALUES ('11', '62');
INSERT INTO `ey_auth_access` VALUES ('11', '136');
INSERT INTO `ey_auth_access` VALUES ('11', '137');
INSERT INTO `ey_auth_access` VALUES ('11', '138');
INSERT INTO `ey_auth_access` VALUES ('11', '139');
INSERT INTO `ey_auth_access` VALUES ('11', '140');
INSERT INTO `ey_auth_access` VALUES ('11', '141');
INSERT INTO `ey_auth_access` VALUES ('11', '142');
INSERT INTO `ey_auth_access` VALUES ('11', '143');
INSERT INTO `ey_auth_access` VALUES ('11', '61');
INSERT INTO `ey_auth_access` VALUES ('11', '212');
INSERT INTO `ey_auth_access` VALUES ('11', '8');
INSERT INTO `ey_auth_access` VALUES ('11', '70');
INSERT INTO `ey_auth_access` VALUES ('11', '71');
INSERT INTO `ey_auth_access` VALUES ('11', '72');
INSERT INTO `ey_auth_access` VALUES ('11', '9');
INSERT INTO `ey_auth_access` VALUES ('11', '77');
INSERT INTO `ey_auth_access` VALUES ('11', '78');
INSERT INTO `ey_auth_access` VALUES ('11', '79');
INSERT INTO `ey_auth_access` VALUES ('11', '148');
INSERT INTO `ey_auth_access` VALUES ('11', '149');
INSERT INTO `ey_auth_access` VALUES ('11', '150');
INSERT INTO `ey_auth_access` VALUES ('11', '151');
INSERT INTO `ey_auth_access` VALUES ('11', '144');
INSERT INTO `ey_auth_access` VALUES ('11', '145');
INSERT INTO `ey_auth_access` VALUES ('11', '146');
INSERT INTO `ey_auth_access` VALUES ('11', '147');
INSERT INTO `ey_auth_access` VALUES ('11', '155');
INSERT INTO `ey_auth_access` VALUES ('11', '156');
INSERT INTO `ey_auth_access` VALUES ('11', '157');
INSERT INTO `ey_auth_access` VALUES ('11', '158');
INSERT INTO `ey_auth_access` VALUES ('11', '159');

-- -----------------------------
-- Table structure for `ey_auth_modular`
-- -----------------------------
DROP TABLE IF EXISTS `ey_auth_modular`;
CREATE TABLE `ey_auth_modular` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `parent_id` int(11) DEFAULT '0' COMMENT '父级ID',
  `name` varchar(50) DEFAULT '' COMMENT '名称',
  `controller` varchar(50) DEFAULT '' COMMENT '控制器',
  `action` varchar(50) DEFAULT '' COMMENT '操作名',
  `grade` tinyint(1) DEFAULT '0' COMMENT '级别',
  `url` varchar(200) DEFAULT '' COMMENT '链接',
  `sort_order` int(11) DEFAULT '0' COMMENT '排序号',
  `is_menu` tinyint(1) DEFAULT '1' COMMENT '显示菜单(1=是，0=否)',
  `status` tinyint(1) DEFAULT '1' COMMENT '状态(1=正常，0=屏蔽)',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`),
  KEY `parent_id` (`parent_id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=515 DEFAULT CHARSET=utf8;

-- -----------------------------
-- Records of `ey_auth_modular`
-- -----------------------------
INSERT INTO `ey_auth_modular` VALUES ('513', '481', 'SEO优化', 'Seo', 'index', '2', '', '100', '1', '1', '1524208193', '0');
INSERT INTO `ey_auth_modular` VALUES ('9', '514', '高级选项', '', '', '1', '', '0', '1', '1', '1503301507', '1527306955');
INSERT INTO `ey_auth_modular` VALUES ('12', '514', '基本信息', 'System', 'index', '1', '', '1', '1', '1', '0', '1527306913');
INSERT INTO `ey_auth_modular` VALUES ('13', '9', '修改密码', 'Admin', 'admin_pwd', '2', '', '3', '1', '1', '1503301723', '0');
INSERT INTO `ey_auth_modular` VALUES ('14', '9', '管理员列表', 'Admin', 'index', '2', '', '0', '1', '1', '1503301765', '1527306984');
INSERT INTO `ey_auth_modular` VALUES ('15', '9', '角色列表', 'Admin', 'role', '2', '', '0', '1', '1', '1503301781', '1527307009');
INSERT INTO `ey_auth_modular` VALUES ('16', '9', '模块列表', 'Admin', 'modular', '2', '', '0', '1', '1', '1503301793', '1527307006');
INSERT INTO `ey_auth_modular` VALUES ('17', '9', '权限列表', 'Admin', 'rule', '2', '', '0', '1', '1', '1503301805', '1527307004');
INSERT INTO `ey_auth_modular` VALUES ('18', '9', '日志列表', 'Admin', 'log', '2', '', '0', '1', '1', '1503301840', '1527306999');
INSERT INTO `ey_auth_modular` VALUES ('19', '9', '数据备份', 'Tools', 'index', '2', '', '0', '1', '1', '1503301857', '1527307033');
INSERT INTO `ey_auth_modular` VALUES ('21', '9', '数据还原', 'Tools', 'restore', '2', '', '0', '1', '1', '1503302091', '1527307044');
INSERT INTO `ey_auth_modular` VALUES ('22', '9', '地区列表', 'System', 'region', '2', '', '2', '0', '1', '1505441023', '0');
INSERT INTO `ey_auth_modular` VALUES ('23', '0', '常规', '', '', '0', '', '0', '1', '1', '1503308630', '1503367345');
INSERT INTO `ey_auth_modular` VALUES ('27', '514', '调试外观', '', '', '1', '', '1', '1', '1', '0', '1527306927');
INSERT INTO `ey_auth_modular` VALUES ('28', '27', '电脑版', 'Uiset', 'pc', '2', '/index.php/home/Index/index.html?ui_set=on', '0', '1', '1', '1503368313', '1523432343');
INSERT INTO `ey_auth_modular` VALUES ('30', '27', '手机版', 'Uiset', 'mobile', '2', '', '0', '1', '1', '1503368589', '1509093563');
INSERT INTO `ey_auth_modular` VALUES ('35', '9', '清除缓存', 'System', 'clearCache', '2', '', '20', '1', '1', '1503655673', '0');
INSERT INTO `ey_auth_modular` VALUES ('41', '23', '设置栏目', 'Arctype', 'index', '1', '', '0', '1', '1', '1503999661', '1527307162');
INSERT INTO `ey_auth_modular` VALUES ('62', '9', '邮件模板', 'EmailTemplate', 'index', '2', '', '5', '1', '1', '1505204834', '1509090070');
INSERT INTO `ey_auth_modular` VALUES ('64', '9', '短信模板', 'SmsTemplate', 'index', '2', '', '4', '1', '1', '1505204889', '1509086592');
INSERT INTO `ey_auth_modular` VALUES ('470', '23', '发布文档', 'Channeltype', 'index', '1', '', '0', '1', '1', '1505726990', '1527307178');
INSERT INTO `ey_auth_modular` VALUES ('480', '481', '友情链接', 'Links', 'index', '2', '', '7', '1', '1', '1505803829', '1522996913');
INSERT INTO `ey_auth_modular` VALUES ('481', '514', '营销设置', '', '', '1', '', '0', '1', '1', '1505873468', '1527306945');
INSERT INTO `ey_auth_modular` VALUES ('482', '481', '广告列表', 'Ad', 'index', '2', '', '0', '1', '1', '1505873498', '0');
INSERT INTO `ey_auth_modular` VALUES ('483', '481', '广告位置', 'AdPosition', 'index', '2', '', '0', '1', '1', '1505873675', '0');
INSERT INTO `ey_auth_modular` VALUES ('514', '0', '设置', '', '', '0', '', '100', '1', '1', '1527306892', '0');

-- -----------------------------
-- Table structure for `ey_auth_role`
-- -----------------------------
DROP TABLE IF EXISTS `ey_auth_role`;
CREATE TABLE `ey_auth_role` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) DEFAULT '' COMMENT '角色名',
  `pid` int(10) DEFAULT '0' COMMENT '父角色ID',
  `remark` text COMMENT '备注信息',
  `grade` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT '级别',
  `language` text COMMENT '多语言权限',
  `online_update` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '在线升级',
  `switch_map` tinyint(1) DEFAULT '0' COMMENT '功能地图',
  `only_oneself` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '只看自己发布',
  `check_oneself` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '发布文档自动通过审核，1--是，0--否',
  `cud` varchar(255) DEFAULT '' COMMENT '增改删',
  `permission` longtext COMMENT '已允许的权限',
  `built_in` tinyint(1) DEFAULT '0' COMMENT '内置用户组，1表示内置',
  `sort_order` int(10) DEFAULT '0' COMMENT '排序号',
  `status` tinyint(1) DEFAULT '1' COMMENT '状态(1=正常，0=屏蔽)',
  `admin_id` int(10) DEFAULT '0' COMMENT '操作管理员ID',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COMMENT='管理员角色表';

-- -----------------------------
-- Records of `ey_auth_role`
-- -----------------------------
INSERT INTO `ey_auth_role` VALUES ('1', '优化推广员', '0', '', '0', '', '0', '1', '1', '1', 'a:3:{i:0;s:3:\"add\";i:1;s:4:\"edit\";i:2;s:3:\"del\";}', 'a:2:{s:5:\"rules\";a:8:{i:0;s:1:\"1\";i:1;s:1:\"3\";i:2;s:1:\"4\";i:3;s:1:\"8\";i:4;s:1:\"9\";i:5;s:2:\"10\";i:6;s:2:\"14\";i:7;i:2;}s:7:\"arctype\";a:75:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";i:3;s:1:\"4\";i:4;s:1:\"5\";i:5;s:1:\"6\";i:6;s:2:\"33\";i:7;s:2:\"34\";i:8;s:2:\"35\";i:9;s:1:\"8\";i:10;s:2:\"32\";i:11;s:1:\"9\";i:12;s:2:\"30\";i:13;s:2:\"31\";i:14;s:2:\"11\";i:15;s:2:\"12\";i:16;s:2:\"13\";i:17;s:2:\"23\";i:18;s:2:\"20\";i:19;s:2:\"24\";i:20;s:2:\"25\";i:21;s:2:\"21\";i:22;s:2:\"26\";i:23;s:2:\"22\";i:24;s:2:\"27\";i:25;s:2:\"28\";i:26;s:2:\"29\";i:27;s:1:\"1\";i:28;s:2:\"49\";i:29;s:2:\"50\";i:30;s:2:\"51\";i:31;s:2:\"52\";i:32;s:2:\"53\";i:33;s:2:\"54\";i:34;s:2:\"55\";i:35;s:2:\"56\";i:36;s:2:\"57\";i:37;s:2:\"58\";i:38;s:2:\"59\";i:39;s:2:\"60\";i:40;s:2:\"61\";i:41;s:2:\"62\";i:42;s:2:\"63\";i:43;s:2:\"64\";i:44;s:2:\"65\";i:45;s:2:\"66\";i:46;s:2:\"67\";i:47;s:2:\"68\";i:48;s:2:\"69\";i:49;s:2:\"70\";i:50;s:2:\"71\";i:51;s:2:\"72\";i:52;s:2:\"73\";i:53;s:2:\"74\";i:54;s:2:\"75\";i:55;s:2:\"76\";i:56;s:2:\"77\";i:57;s:2:\"78\";i:58;s:2:\"79\";i:59;s:2:\"80\";i:60;s:2:\"81\";i:61;s:2:\"82\";i:62;s:2:\"83\";i:63;s:2:\"84\";i:64;s:2:\"85\";i:65;s:2:\"86\";i:66;s:2:\"87\";i:67;s:2:\"88\";i:68;s:2:\"89\";i:69;s:2:\"90\";i:70;s:2:\"91\";i:71;s:2:\"92\";i:72;s:2:\"93\";i:73;s:2:\"94\";i:74;s:2:\"95\";}}', '1', '100', '1', '0', '1541058693', '1541058693');
INSERT INTO `ey_auth_role` VALUES ('2', '内容管理员', '0', '', '0', '', '0', '1', '1', '1', 'a:3:{i:0;s:3:\"add\";i:1;s:4:\"edit\";i:2;s:3:\"del\";}', 'a:2:{s:5:\"rules\";a:4:{i:0;s:1:\"1\";i:1;s:2:\"10\";i:2;s:2:\"14\";i:3;i:2;}s:7:\"arctype\";a:75:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";i:3;s:1:\"4\";i:4;s:1:\"5\";i:5;s:1:\"6\";i:6;s:2:\"33\";i:7;s:2:\"34\";i:8;s:2:\"35\";i:9;s:1:\"8\";i:10;s:2:\"32\";i:11;s:1:\"9\";i:12;s:2:\"30\";i:13;s:2:\"31\";i:14;s:2:\"11\";i:15;s:2:\"12\";i:16;s:2:\"13\";i:17;s:2:\"23\";i:18;s:2:\"20\";i:19;s:2:\"24\";i:20;s:2:\"25\";i:21;s:2:\"21\";i:22;s:2:\"26\";i:23;s:2:\"22\";i:24;s:2:\"27\";i:25;s:2:\"28\";i:26;s:2:\"29\";i:27;s:1:\"1\";i:28;s:2:\"49\";i:29;s:2:\"50\";i:30;s:2:\"51\";i:31;s:2:\"52\";i:32;s:2:\"53\";i:33;s:2:\"54\";i:34;s:2:\"55\";i:35;s:2:\"56\";i:36;s:2:\"57\";i:37;s:2:\"58\";i:38;s:2:\"59\";i:39;s:2:\"60\";i:40;s:2:\"61\";i:41;s:2:\"62\";i:42;s:2:\"63\";i:43;s:2:\"64\";i:44;s:2:\"65\";i:45;s:2:\"66\";i:46;s:2:\"67\";i:47;s:2:\"68\";i:48;s:2:\"69\";i:49;s:2:\"70\";i:50;s:2:\"71\";i:51;s:2:\"72\";i:52;s:2:\"73\";i:53;s:2:\"74\";i:54;s:2:\"75\";i:55;s:2:\"76\";i:56;s:2:\"77\";i:57;s:2:\"78\";i:58;s:2:\"79\";i:59;s:2:\"80\";i:60;s:2:\"81\";i:61;s:2:\"82\";i:62;s:2:\"83\";i:63;s:2:\"84\";i:64;s:2:\"85\";i:65;s:2:\"86\";i:66;s:2:\"87\";i:67;s:2:\"88\";i:68;s:2:\"89\";i:69;s:2:\"90\";i:70;s:2:\"91\";i:71;s:2:\"92\";i:72;s:2:\"93\";i:73;s:2:\"94\";i:74;s:2:\"95\";}}', '1', '100', '1', '0', '1541059290', '1541059290');

-- -----------------------------
-- Table structure for `ey_auth_role_admin`
-- -----------------------------
DROP TABLE IF EXISTS `ey_auth_role_admin`;
CREATE TABLE `ey_auth_role_admin` (
  `role_id` int(11) DEFAULT '0' COMMENT '角色 id',
  `admin_id` int(11) DEFAULT '0' COMMENT '用户id',
  KEY `role_id` (`role_id`) USING BTREE,
  KEY `admin_id` (`admin_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='用户角色对应表';

-- -----------------------------
-- Records of `ey_auth_role_admin`
-- -----------------------------
INSERT INTO `ey_auth_role_admin` VALUES ('-1', '1');
INSERT INTO `ey_auth_role_admin` VALUES ('11', '22');
INSERT INTO `ey_auth_role_admin` VALUES ('12', '17');
INSERT INTO `ey_auth_role_admin` VALUES ('12', '16');

-- -----------------------------
-- Table structure for `ey_auth_rule`
-- -----------------------------
DROP TABLE IF EXISTS `ey_auth_rule`;
CREATE TABLE `ey_auth_rule` (
  `id` smallint(6) unsigned NOT NULL AUTO_INCREMENT,
  `modular_id` int(11) DEFAULT '0' COMMENT '所属模块',
  `name` varchar(50) DEFAULT '' COMMENT '权限名字',
  `right` text COMMENT '权限码(控制器+操作)',
  `remark` varchar(255) DEFAULT '' COMMENT '备注',
  `is_del` tinyint(1) DEFAULT '0' COMMENT '删除状态 1删除,0正常',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  `sort_order` int(11) DEFAULT '0' COMMENT '排序号',
  `is_menu` tinyint(1) DEFAULT '1' COMMENT '是否为菜单(1=是，0=否)',
  `group` varchar(20) DEFAULT '' COMMENT '应用名称app',
  `status` tinyint(1) DEFAULT '1' COMMENT '显示(1=正常，0=屏蔽)',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=213 DEFAULT CHARSET=utf8 COMMENT='后台权限菜单表';

-- -----------------------------
-- Records of `ey_auth_rule`
-- -----------------------------
INSERT INTO `ey_auth_rule` VALUES ('6', '17', '权限列表', 'Admin@rule', '', '0', '0', '1503390907', '0', '1', 'system', '1');
INSERT INTO `ey_auth_rule` VALUES ('8', '14', '管理员列表', 'Admin@index', '', '0', '0', '1503392270', '0', '1', 'system', '1');
INSERT INTO `ey_auth_rule` VALUES ('9', '15', '角色列表', 'Admin@role', '', '0', '0', '1503392666', '0', '1', 'system', '1');
INSERT INTO `ey_auth_rule` VALUES ('38', '19', '数据备份列表', 'Tools@index', '', '0', '0', '1504515434', '0', '1', 'tools', '1');
INSERT INTO `ey_auth_rule` VALUES ('39', '21', '数据还原列表', 'Tools@restore', '', '0', '0', '1504515452', '0', '1', 'tools', '1');
INSERT INTO `ey_auth_rule` VALUES ('49', '18', '管理员日志', 'Admin@log', '', '0', '0', '1504485820', '0', '1', 'system', '1');
INSERT INTO `ey_auth_rule` VALUES ('61', '35', '清除页面缓存', 'System@clearCache,System@clearHtmlCache', '', '0', '0', '1519357846', '0', '1', 'system', '1');
INSERT INTO `ey_auth_rule` VALUES ('62', '13', '修改管理员密码', 'Admin@admin_pwd', '', '0', '0', '1504485678', '0', '1', 'system', '1');
INSERT INTO `ey_auth_rule` VALUES ('65', '17', '新增权限', 'Admin@rule_add', '', '0', '1503390930', '1503391981', '0', '1', '', '1');
INSERT INTO `ey_auth_rule` VALUES ('66', '17', '编辑权限', 'Admin@rule_edit,Index@changeTableVal', '', '0', '1503390947', '1503392474', '0', '1', '', '1');
INSERT INTO `ey_auth_rule` VALUES ('67', '17', '删除权限', 'Admin@rule_del', '', '0', '1503390965', '0', '0', '1', '', '1');
INSERT INTO `ey_auth_rule` VALUES ('70', '14', '新增管理员', 'Admin@admin_add', '', '0', '1503392290', '0', '0', '1', '', '1');
INSERT INTO `ey_auth_rule` VALUES ('71', '14', '编辑管理员', 'Admin@admin_edit,Index@changeTableVal', '', '0', '1503392302', '1517986419', '0', '1', '', '1');
INSERT INTO `ey_auth_rule` VALUES ('72', '14', '删除管理员', 'Admin@admin_del', '', '0', '1503392315', '1504578385', '0', '1', '', '1');
INSERT INTO `ey_auth_rule` VALUES ('73', '16', '模块列表', 'Admin@modular', '', '0', '1503392570', '0', '0', '1', '', '1');
INSERT INTO `ey_auth_rule` VALUES ('74', '16', '新增模块', 'Admin@modular_add', '', '0', '1503392591', '0', '0', '1', '', '1');
INSERT INTO `ey_auth_rule` VALUES ('75', '16', '编辑模块', 'Admin@modular_edit,Index@changeTableVal', '', '0', '1503392610', '0', '0', '1', '', '1');
INSERT INTO `ey_auth_rule` VALUES ('76', '16', '删除模块', 'Admin@modular_del', '', '0', '1503392626', '0', '0', '1', '', '1');
INSERT INTO `ey_auth_rule` VALUES ('77', '15', '新增角色', 'Admin@role_add', '', '0', '1503392691', '0', '0', '1', '', '1');
INSERT INTO `ey_auth_rule` VALUES ('78', '15', '编辑角色', 'Admin@role_edit,Index@changeTableVal', '', '0', '1503392718', '1517986448', '0', '1', '', '1');
INSERT INTO `ey_auth_rule` VALUES ('79', '15', '删除角色', 'Admin@role_del', '', '0', '1503392736', '0', '0', '1', '', '1');
INSERT INTO `ey_auth_rule` VALUES ('81', '12', '平台设置', 'System@index,System@handle', '', '0', '1504486050', '0', '0', '1', '', '1');
INSERT INTO `ey_auth_rule` VALUES ('117', '19', '备份数据', 'Tools@export', '', '0', '1504514716', '0', '0', '1', '', '1');
INSERT INTO `ey_auth_rule` VALUES ('118', '19', '优化数据', 'Tools@optimize', '', '0', '1504514788', '0', '0', '1', '', '1');
INSERT INTO `ey_auth_rule` VALUES ('119', '19', '修复数据', 'Tools@repair', '', '0', '1504514809', '0', '0', '1', '', '1');
INSERT INTO `ey_auth_rule` VALUES ('120', '21', '导入sql文件', 'Tools@restoreUpload', '', '0', '1504515139', '0', '0', '1', '', '1');
INSERT INTO `ey_auth_rule` VALUES ('121', '21', '恢复数据 ', 'Tools@import', '', '0', '1504515184', '0', '0', '1', '', '1');
INSERT INTO `ey_auth_rule` VALUES ('122', '21', '下载数据', 'Tools@downFile', '', '0', '1504515311', '0', '0', '1', '', '1');
INSERT INTO `ey_auth_rule` VALUES ('123', '21', '删除数据', 'Tools@del', '', '0', '1504515399', '0', '0', '1', '', '1');
INSERT INTO `ey_auth_rule` VALUES ('128', '64', '短信模板列表', 'SmsTemplate@index', '', '0', '1517987270', '0', '0', '1', '', '1');
INSERT INTO `ey_auth_rule` VALUES ('129', '64', '新增短信模板', 'SmsTemplate@add', '', '0', '1517987289', '0', '0', '1', '', '1');
INSERT INTO `ey_auth_rule` VALUES ('130', '64', '编辑短信模板', 'SmsTemplate@edit,Index@changeTableVal', '', '0', '1517987336', '0', '0', '1', '', '1');
INSERT INTO `ey_auth_rule` VALUES ('131', '64', '删除短信模板', 'SmsTemplate@del', '', '0', '1517987359', '0', '0', '1', '', '1');
INSERT INTO `ey_auth_rule` VALUES ('132', '62', '邮件模板列表', 'EmailTemplate@index', '', '0', '1517987387', '0', '0', '1', '', '1');
INSERT INTO `ey_auth_rule` VALUES ('133', '62', '新增邮件模板', 'EmailTemplate@add', '', '0', '1517994951', '0', '0', '1', '', '1');
INSERT INTO `ey_auth_rule` VALUES ('134', '62', '编辑邮件模板', 'EmailTemplate@edit,Index@changeTableVal', '', '0', '1517994976', '0', '0', '1', '', '1');
INSERT INTO `ey_auth_rule` VALUES ('135', '62', '删除邮件模板', 'EmailTemplate@del', '', '0', '1517995005', '0', '0', '1', '', '1');
INSERT INTO `ey_auth_rule` VALUES ('140', '480', '友情链接列表', 'Links@index', '', '0', '1517995297', '0', '0', '1', '', '1');
INSERT INTO `ey_auth_rule` VALUES ('141', '480', '新增友情链接', 'Links@add', '', '0', '1517995311', '0', '0', '1', '', '1');
INSERT INTO `ey_auth_rule` VALUES ('142', '480', '编辑友情链接', 'Links@edit,Index@changeTableVal', '', '0', '1517995329', '0', '0', '1', '', '1');
INSERT INTO `ey_auth_rule` VALUES ('143', '480', '删除友情链接', 'Links@del', '', '0', '1517995344', '0', '0', '1', '', '1');
INSERT INTO `ey_auth_rule` VALUES ('144', '483', '广告位列表', 'AdPosition@index', '', '0', '1517995508', '0', '0', '1', '', '1');
INSERT INTO `ey_auth_rule` VALUES ('145', '483', '新增广告位', 'AdPosition@add', '', '0', '1517995525', '0', '0', '1', '', '1');
INSERT INTO `ey_auth_rule` VALUES ('146', '483', '编辑广告位', 'AdPosition@edit,Index@changeTableVal', '', '0', '1517995544', '0', '0', '1', '', '1');
INSERT INTO `ey_auth_rule` VALUES ('147', '483', '删除广告位', 'AdPosition@del', '', '0', '1517995556', '0', '0', '1', '', '1');
INSERT INTO `ey_auth_rule` VALUES ('148', '482', '广告列表', 'Ad@index', '', '0', '1517995581', '0', '0', '1', '', '1');
INSERT INTO `ey_auth_rule` VALUES ('149', '482', '新增广告', 'Ad@add', '', '0', '1517995595', '0', '0', '1', '', '1');
INSERT INTO `ey_auth_rule` VALUES ('150', '482', '编辑广告', 'Ad@edit,Index@changeTableVal', '', '0', '1517995612', '0', '0', '1', '', '1');
INSERT INTO `ey_auth_rule` VALUES ('151', '482', '删除广告', 'Ad@del', '', '0', '1517995626', '0', '0', '1', '', '1');
INSERT INTO `ey_auth_rule` VALUES ('212', '35', '清除数据缓存', 'System@clearCache,System@clearSystemCache,System@fastClearCache', '', '0', '1519357889', '0', '0', '1', '', '1');

-- -----------------------------
-- Table structure for `ey_channelfield`
-- -----------------------------
DROP TABLE IF EXISTS `ey_channelfield`;
CREATE TABLE `ey_channelfield` (
  `id` int(10) NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `name` varchar(32) NOT NULL DEFAULT '' COMMENT '字段名称',
  `channel_id` int(10) NOT NULL DEFAULT '0' COMMENT '所属文档模型id',
  `title` varchar(250) NOT NULL DEFAULT '' COMMENT '字段标题',
  `dtype` varchar(32) NOT NULL DEFAULT '' COMMENT '字段类型',
  `define` text NOT NULL COMMENT '字段定义',
  `maxlength` int(10) NOT NULL DEFAULT '0' COMMENT '最大长度，文本数据必须填写，大于255为text类型',
  `dfvalue` text NOT NULL COMMENT '默认值',
  `dfvalue_unit` varchar(50) NOT NULL DEFAULT '' COMMENT '数值单位',
  `remark` varchar(256) NOT NULL DEFAULT '' COMMENT '提示说明',
  `is_screening` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否应用于条件筛选',
  `is_release` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否应用于会员投稿发布',
  `ifeditable` tinyint(1) NOT NULL DEFAULT '1' COMMENT '是否在编辑页显示',
  `ifrequire` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否必填',
  `ifsystem` tinyint(1) NOT NULL DEFAULT '0' COMMENT '字段分类，1=系统(不可修改)，0=自定义',
  `ifmain` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否主表字段',
  `ifcontrol` tinyint(1) NOT NULL DEFAULT '1' COMMENT '状态，控制该条数据是否允许被控制，1为不允许控制，0为允许控制',
  `sort_order` int(5) NOT NULL DEFAULT '100' COMMENT '排序',
  `status` tinyint(1) NOT NULL DEFAULT '1' COMMENT '状态',
  `add_time` int(11) NOT NULL DEFAULT '0' COMMENT '创建时间',
  `update_time` int(11) NOT NULL DEFAULT '0' COMMENT '更新时间',
  `set_type` tinyint(3) DEFAULT '0' COMMENT '区域选择时使用是否为三级联动,1-是',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=475 DEFAULT CHARSET=utf8 COMMENT='自定义字段表';

-- -----------------------------
-- Records of `ey_channelfield`
-- -----------------------------
INSERT INTO `ey_channelfield` VALUES ('1', 'add_time', '0', '新增时间', 'datetime', 'int(11)', '250', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533091575', '1533091575', '0');
INSERT INTO `ey_channelfield` VALUES ('2', 'update_time', '0', '更新时间', 'datetime', 'int(11)', '250', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533091601', '1533091601', '0');
INSERT INTO `ey_channelfield` VALUES ('3', 'aid', '0', '文档ID', 'int', 'int(11)', '250', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533091624', '1533091624', '0');
INSERT INTO `ey_channelfield` VALUES ('4', 'typeid', '0', '当前栏目ID', 'int', 'int(11)', '250', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533091930', '1533091930', '0');
INSERT INTO `ey_channelfield` VALUES ('5', 'channel', '0', '模型ID', 'int', 'int(11)', '250', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533092214', '1533092214', '0');
INSERT INTO `ey_channelfield` VALUES ('6', 'is_b', '0', '是否加粗', 'switch', 'tinyint(1)', '250', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533092246', '1533092246', '0');
INSERT INTO `ey_channelfield` VALUES ('7', 'title', '0', '文档标题', 'text', 'varchar(250)', '250', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533092381', '1533092381', '0');
INSERT INTO `ey_channelfield` VALUES ('8', 'litpic', '0', '缩略图', 'img', 'varchar(250)', '250', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533092398', '1533092398', '0');
INSERT INTO `ey_channelfield` VALUES ('9', 'is_head', '0', '是否头条', 'switch', 'tinyint(1)', '250', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533092420', '1533092420', '0');
INSERT INTO `ey_channelfield` VALUES ('10', 'is_special', '0', '是否特荐', 'switch', 'tinyint(1)', '250', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533092439', '1533092439', '0');
INSERT INTO `ey_channelfield` VALUES ('11', 'is_top', '0', '是否置顶', 'switch', 'tinyint(1)', '250', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533092454', '1533092454', '0');
INSERT INTO `ey_channelfield` VALUES ('12', 'is_recom', '0', '是否推荐', 'switch', 'tinyint(1)', '250', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533092468', '1533092468', '0');
INSERT INTO `ey_channelfield` VALUES ('13', 'is_jump', '0', '是否跳转', 'switch', 'tinyint(1)', '250', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533092484', '1533092484', '0');
INSERT INTO `ey_channelfield` VALUES ('14', 'author', '0', '作者', 'text', 'varchar(250)', '250', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533092498', '1533092498', '0');
INSERT INTO `ey_channelfield` VALUES ('15', 'click', '0', '浏览量', 'int', 'int(11)', '250', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533092512', '1533092512', '0');
INSERT INTO `ey_channelfield` VALUES ('16', 'arcrank', '0', '阅读权限', 'select', 'tinyint(1)', '250', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533092534', '1533092534', '0');
INSERT INTO `ey_channelfield` VALUES ('17', 'jumplinks', '0', '跳转链接', 'text', 'varchar(250)', '250', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533092553', '1533092553', '0');
INSERT INTO `ey_channelfield` VALUES ('18', 'ismake', '0', '是否静态页面', 'switch', 'tinyint(1)', '250', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533092698', '1533092698', '0');
INSERT INTO `ey_channelfield` VALUES ('19', 'seo_title', '0', 'SEO标题', 'text', 'varchar(250)', '250', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533092713', '1533092713', '0');
INSERT INTO `ey_channelfield` VALUES ('20', 'seo_keywords', '0', 'SEO关键词', 'text', 'varchar(250)', '250', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533092725', '1533092725', '0');
INSERT INTO `ey_channelfield` VALUES ('21', 'seo_description', '0', 'SEO描述', 'text', 'varchar(250)', '250', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533092739', '1533092739', '0');
INSERT INTO `ey_channelfield` VALUES ('22', 'status', '0', '状态', 'switch', 'tinyint(1)', '250', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533092753', '1533092753', '0');
INSERT INTO `ey_channelfield` VALUES ('23', 'sort_order', '0', '排序号', 'int', 'int(11)', '250', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533092766', '1533092766', '0');
INSERT INTO `ey_channelfield` VALUES ('24', 'content', '2', '内容详情', 'htmltext', 'longtext', '250', '', '', '', '0', '1', '1', '0', '1', '0', '0', '100', '1', '1533359739', '1533359739', '0');
INSERT INTO `ey_channelfield` VALUES ('25', 'content', '3', '内容详情', 'htmltext', 'longtext', '250', '', '', '', '0', '1', '1', '0', '1', '0', '0', '100', '1', '1533359588', '1533359588', '0');
INSERT INTO `ey_channelfield` VALUES ('26', 'content', '4', '内容详情', 'htmltext', 'longtext', '250', '', '', '', '0', '1', '1', '0', '1', '0', '0', '100', '1', '1533359752', '1533359752', '0');
INSERT INTO `ey_channelfield` VALUES ('27', 'content', '6', '内容详情', 'htmltext', 'longtext', '250', '', '', '', '0', '1', '1', '0', '1', '0', '0', '100', '1', '1533464715', '1533464715', '0');
INSERT INTO `ey_channelfield` VALUES ('29', 'content', '1', '内容详情', 'htmltext', 'longtext', '250', '', '', '', '0', '1', '1', '0', '1', '0', '0', '100', '1', '1533464713', '1533464713', '0');
INSERT INTO `ey_channelfield` VALUES ('30', 'update_time', '-99', '更新时间', 'datetime', 'int(11)', '11', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533524780', '1533524780', '0');
INSERT INTO `ey_channelfield` VALUES ('31', 'add_time', '-99', '新增时间', 'datetime', 'int(11)', '11', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533524780', '1533524780', '0');
INSERT INTO `ey_channelfield` VALUES ('32', 'status', '-99', '启用 (1=正常，0=屏蔽)', 'switch', 'tinyint(1)', '1', '1', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533524780', '1533524780', '0');
INSERT INTO `ey_channelfield` VALUES ('33', 'is_part', '-99', '栏目属性：0=内容栏目，1=外部链接', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533524780', '1533524780', '0');
INSERT INTO `ey_channelfield` VALUES ('34', 'is_hidden', '-99', '是否隐藏栏目：0=显示，1=隐藏', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533524780', '1533524780', '0');
INSERT INTO `ey_channelfield` VALUES ('35', 'sort_order', '-99', '排序号', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533524780', '1533524780', '0');
INSERT INTO `ey_channelfield` VALUES ('36', 'seo_description', '-99', 'seo描述', 'multitext', 'text', '0', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533524780', '1533524780', '0');
INSERT INTO `ey_channelfield` VALUES ('37', 'seo_keywords', '-99', 'seo关键字', 'text', 'varchar(200)', '200', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533524780', '1533524780', '0');
INSERT INTO `ey_channelfield` VALUES ('38', 'seo_title', '-99', 'SEO标题', 'text', 'varchar(200)', '200', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533524780', '1533524780', '0');
INSERT INTO `ey_channelfield` VALUES ('39', 'tempview', '-99', '文档模板文件名', 'text', 'varchar(200)', '200', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533524780', '1533524780', '0');
INSERT INTO `ey_channelfield` VALUES ('40', 'templist', '-99', '列表模板文件名', 'text', 'varchar(200)', '200', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533524780', '1533524780', '0');
INSERT INTO `ey_channelfield` VALUES ('41', 'litpic', '-99', '栏目图片', 'img', 'varchar(250)', '250', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533524780', '1533524780', '0');
INSERT INTO `ey_channelfield` VALUES ('42', 'typelink', '-99', '栏目链接', 'text', 'varchar(200)', '200', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533524780', '1533524780', '0');
INSERT INTO `ey_channelfield` VALUES ('43', 'grade', '-99', '栏目等级', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533524780', '1533524780', '0');
INSERT INTO `ey_channelfield` VALUES ('44', 'englist_name', '-99', '栏目英文名', 'text', 'varchar(200)', '200', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533524780', '1533524780', '0');
INSERT INTO `ey_channelfield` VALUES ('45', 'dirpath', '-99', '目录存放HTML路径', 'text', 'varchar(200)', '200', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533524780', '1533524780', '0');
INSERT INTO `ey_channelfield` VALUES ('46', 'dirname', '-99', '目录英文名', 'text', 'varchar(200)', '200', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533524780', '1533524780', '0');
INSERT INTO `ey_channelfield` VALUES ('47', 'typename', '-99', '栏目名称', 'text', 'varchar(200)', '200', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533524780', '1533524780', '0');
INSERT INTO `ey_channelfield` VALUES ('48', 'parent_id', '-99', '栏目上级ID', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533524780', '1533524780', '0');
INSERT INTO `ey_channelfield` VALUES ('49', 'current_channel', '-99', '栏目当前模型ID', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533524780', '1533524780', '0');
INSERT INTO `ey_channelfield` VALUES ('50', 'channeltype', '-99', '栏目顶级模型ID', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533524780', '1533524780', '0');
INSERT INTO `ey_channelfield` VALUES ('51', 'id', '-99', '栏目ID', 'int', 'int(10)', '10', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533524780', '1533524780', '0');
INSERT INTO `ey_channelfield` VALUES ('52', 'del_method', '-99', '伪删除状态，1为主动删除，2为跟随上级栏目被动删除', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1547890773', '1547890773', '0');
INSERT INTO `ey_channelfield` VALUES ('53', 'is_del', '0', '伪删除，1=是，0=否', 'switch', 'tinyint(1)', '250', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1547890773', '1547890773', '0');
INSERT INTO `ey_channelfield` VALUES ('54', 'del_method', '0', '伪删除状态，1为主动删除，2为跟随上级栏目被动删除', 'switch', 'tinyint(1)', '250', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1547890773', '1547890773', '0');
INSERT INTO `ey_channelfield` VALUES ('55', 'admin_id', '0', '管理员ID', 'int', 'int(10)', '250', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1547890773', '1547890773', '0');
INSERT INTO `ey_channelfield` VALUES ('56', 'lang', '0', '语言标识', 'text', 'varchar(250)', '250', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1547890773', '1547890773', '0');
INSERT INTO `ey_channelfield` VALUES ('57', 'prom_type', '0', '产品类型：0普通产品，1虚拟产品', 'switch', 'tinyint(1) unsigned', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1557042574', '1557042574', '0');
INSERT INTO `ey_channelfield` VALUES ('58', 'users_price', '0', '价格', 'decimal', 'decimal(10,2)', '10', '0.00', '', '', '0', '0', '1', '0', '1', '1', '0', '100', '1', '1557042574', '1557042574', '0');
INSERT INTO `ey_channelfield` VALUES ('59', 'prom_type', '2', '产品类型：0普通产品，1虚拟产品', 'switch', 'tinyint(1) unsigned', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1557042574', '1557042574', '0');
INSERT INTO `ey_channelfield` VALUES ('60', 'users_price', '2', '价格', 'decimal', 'decimal(10,2)', '10', '0.00', '', '', '0', '0', '1', '0', '1', '1', '0', '100', '1', '1557042574', '1557042574', '0');
INSERT INTO `ey_channelfield` VALUES ('61', 'users_id', '0', '会员ID', 'int', 'int(11)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1557042574', '1557042574', '0');
INSERT INTO `ey_channelfield` VALUES ('62', 'arc_level_id', '0', '文档会员权限ID', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1557042574', '1557042574', '0');
INSERT INTO `ey_channelfield` VALUES ('63', 'arc_level_id', '4', '文档会员权限ID', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1557042574', '1557042574', '0');
INSERT INTO `ey_channelfield` VALUES ('64', 'weapp_code', '-99', '插件栏目唯一标识', 'text', 'varchar(200)', '200', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1557042574', '1557042574', '0');
INSERT INTO `ey_channelfield` VALUES ('65', 'is_release', '-99', '栏目是否应用于会员投稿发布，1是，0否', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1557042574', '1557042574', '0');
INSERT INTO `ey_channelfield` VALUES ('66', 'old_price', '0', '产品旧价', 'decimal', 'decimal(10,2)', '10', '0.00', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1557042574', '1557042574', '0');
INSERT INTO `ey_channelfield` VALUES ('67', 'stock_count', '0', '商品库存量', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1557042574', '1557042574', '0');
INSERT INTO `ey_channelfield` VALUES ('68', 'stock_show', '0', '商品库存在产品详情页是否显示，1为显示，0为不显示', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1557042574', '1557042574', '0');
INSERT INTO `ey_channelfield` VALUES ('69', 'joinaid', '0', '关联文档ID', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1557042574', '1557042574', '0');
INSERT INTO `ey_channelfield` VALUES ('70', 'downcount', '0', '下载次数', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1557042574', '1557042574', '0');
INSERT INTO `ey_channelfield` VALUES ('71', 'downcount', '4', '下载次数', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1557042574', '1557042574', '0');
INSERT INTO `ey_channelfield` VALUES ('72', 'htmlfilename', '0', '自定义文件名', 'text', 'varchar(50)', '50', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1557042574', '1557042574', '0');
INSERT INTO `ey_channelfield` VALUES ('73', 'htmlfilename', '1', '自定义文件名', 'text', 'varchar(50)', '50', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1557042574', '1557042574', '0');
INSERT INTO `ey_channelfield` VALUES ('74', 'htmlfilename', '2', '自定义文件名', 'text', 'varchar(50)', '50', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1557042574', '1557042574', '0');
INSERT INTO `ey_channelfield` VALUES ('75', 'htmlfilename', '3', '自定义文件名', 'text', 'varchar(50)', '50', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1557042574', '1557042574', '0');
INSERT INTO `ey_channelfield` VALUES ('76', 'htmlfilename', '4', '自定义文件名', 'text', 'varchar(50)', '50', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1557042574', '1557042574', '0');
INSERT INTO `ey_channelfield` VALUES ('77', 'htmlfilename', '6', '自定义文件名', 'text', 'varchar(50)', '50', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1557042574', '1557042574', '0');
INSERT INTO `ey_channelfield` VALUES ('78', 'attrlist_id', '0', '参数列表ID', 'int', 'int(10) unsigned', '10', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533091930', '1533091930', '0');
INSERT INTO `ey_channelfield` VALUES ('79', 'sales_num', '0', '销售量', 'int', 'int(10) unsigned', '10', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533091930', '1533091930', '0');
INSERT INTO `ey_channelfield` VALUES ('81', 'topid', '-99', '顶级栏目ID', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1557042574', '1557042574', '0');
INSERT INTO `ey_channelfield` VALUES ('82', 'is_slide', '0', '是否幻灯', 'switch', 'tinyint(1)', '250', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533092420', '1533092420', '0');
INSERT INTO `ey_channelfield` VALUES ('83', 'is_roll', '0', '是否幻灯', 'switch', 'tinyint(1)', '250', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533092420', '1533092420', '0');
INSERT INTO `ey_channelfield` VALUES ('84', 'is_diyattr', '0', '是否自定义', 'switch', 'tinyint(1)', '250', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533092420', '1533092420', '0');
INSERT INTO `ey_channelfield` VALUES ('85', 'update_time', '5', '更新时间', 'datetime', 'int(11)', '11', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1616293251', '1616293251', '0');
INSERT INTO `ey_channelfield` VALUES ('86', 'add_time', '5', '新增时间', 'datetime', 'int(11)', '11', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1616293251', '1616293251', '0');
INSERT INTO `ey_channelfield` VALUES ('87', 'htmlfilename', '5', '自定义文件名', 'text', 'varchar(50)', '50', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1616293251', '1616293251', '0');
INSERT INTO `ey_channelfield` VALUES ('88', 'downcount', '5', '下载次数', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1616293251', '1616293251', '0');
INSERT INTO `ey_channelfield` VALUES ('89', 'joinaid', '5', '关联文档ID', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1616293251', '1616293251', '0');
INSERT INTO `ey_channelfield` VALUES ('90', 'del_method', '5', '伪删除状态，1为主动删除，2为跟随上级栏目被动删除', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1616293251', '1616293251', '0');
INSERT INTO `ey_channelfield` VALUES ('91', 'is_del', '5', '伪删除，1=是，0=否', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1616293251', '1616293251', '0');
INSERT INTO `ey_channelfield` VALUES ('92', 'arc_level_id', '5', '文档会员权限ID', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1616293251', '1616293251', '0');
INSERT INTO `ey_channelfield` VALUES ('93', 'users_id', '5', '会员ID', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1616293251', '1616293251', '0');
INSERT INTO `ey_channelfield` VALUES ('94', 'admin_id', '5', '管理员ID', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1616293251', '1616293251', '0');
INSERT INTO `ey_channelfield` VALUES ('95', 'lang', '5', '语言标识', 'text', 'varchar(50)', '50', 'cn', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1616293251', '1616293251', '0');
INSERT INTO `ey_channelfield` VALUES ('96', 'sort_order', '5', '排序号', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1616293251', '1616293251', '0');
INSERT INTO `ey_channelfield` VALUES ('97', 'status', '5', '状态(0=屏蔽，1=正常)', 'switch', 'tinyint(1)', '1', '1', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1616293251', '1616293251', '0');
INSERT INTO `ey_channelfield` VALUES ('98', 'tempview', '5', '文档模板文件名', 'text', 'varchar(200)', '200', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1616293251', '1616293251', '0');
INSERT INTO `ey_channelfield` VALUES ('99', 'prom_type', '5', '产品类型：0=普通产品，1=虚拟(默认手动发货)，2=虚拟(网盘', 'switch', 'tinyint(1) unsigned', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1616293251', '1616293251', '0');
INSERT INTO `ey_channelfield` VALUES ('100', 'stock_show', '5', '商品库存在产品详情页是否显示，1为显示，0为不显示', 'switch', 'tinyint(1) unsigned', '1', '1', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1616293251', '1616293251', '0');
INSERT INTO `ey_channelfield` VALUES ('101', 'stock_count', '5', '商品库存量', 'int', 'int(10) unsigned', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1616293251', '1616293251', '0');
INSERT INTO `ey_channelfield` VALUES ('102', 'sales_num', '5', '销售量', 'int', 'int(10) unsigned', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1616293251', '1616293251', '0');
INSERT INTO `ey_channelfield` VALUES ('103', 'old_price', '5', '产品旧价', 'decimal', 'decimal(10,2)', '10', '0.00', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1616293251', '1616293251', '0');
INSERT INTO `ey_channelfield` VALUES ('104', 'users_free', '5', '是否会员免费，默认0不免费，1为免费', 'switch', 'tinyint(1) unsigned', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1616293251', '1616293251', '0');
INSERT INTO `ey_channelfield` VALUES ('105', 'users_price', '5', '会员价', 'decimal', 'decimal(10,2)', '10', '0.00', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1616293251', '1616293251', '0');
INSERT INTO `ey_channelfield` VALUES ('106', 'attrlist_id', '5', '参数列表ID', 'int', 'int(10) unsigned', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1616293251', '1616293251', '0');
INSERT INTO `ey_channelfield` VALUES ('107', 'seo_description', '5', 'SEO描述', 'multitext', 'text', '0', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1616293251', '1616293251', '0');
INSERT INTO `ey_channelfield` VALUES ('108', 'seo_keywords', '5', 'SEO关键词', 'text', 'varchar(200)', '200', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1616293251', '1616293251', '0');
INSERT INTO `ey_channelfield` VALUES ('109', 'seo_title', '5', 'SEO标题', 'text', 'varchar(200)', '200', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1616293251', '1616293251', '0');
INSERT INTO `ey_channelfield` VALUES ('110', 'ismake', '5', '是否静态页面（0=动态，1=静态）', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1616293251', '1616293251', '0');
INSERT INTO `ey_channelfield` VALUES ('111', 'jumplinks', '5', '外链跳转', 'text', 'varchar(200)', '200', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1616293251', '1616293251', '0');
INSERT INTO `ey_channelfield` VALUES ('112', 'arcrank', '5', '阅读权限：0=开放浏览，-1=待审核稿件', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1616293251', '1616293251', '0');
INSERT INTO `ey_channelfield` VALUES ('113', 'click', '5', '浏览量', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1616293251', '1616293251', '0');
INSERT INTO `ey_channelfield` VALUES ('114', 'author', '5', '作者', 'text', 'varchar(200)', '200', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1616293251', '1616293251', '0');
INSERT INTO `ey_channelfield` VALUES ('115', 'is_diyattr', '5', '自定义（0=否，1=是）', 'switch', 'tinyint(1) unsigned', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1616293251', '1616293251', '0');
INSERT INTO `ey_channelfield` VALUES ('116', 'is_slide', '5', '幻灯（0=否，1=是）', 'switch', 'tinyint(1) unsigned', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1616293251', '1616293251', '0');
INSERT INTO `ey_channelfield` VALUES ('117', 'is_roll', '5', '滚动（0=否，1=是）', 'switch', 'tinyint(1) unsigned', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1616293251', '1616293251', '0');
INSERT INTO `ey_channelfield` VALUES ('118', 'is_litpic', '5', '图片（0=否，1=是）', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1616293251', '1616293251', '0');
INSERT INTO `ey_channelfield` VALUES ('119', 'is_jump', '5', '跳转链接（0=否，1=是）', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1616293251', '1616293251', '0');
INSERT INTO `ey_channelfield` VALUES ('120', 'is_recom', '5', '推荐（0=否，1=是）', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1616293251', '1616293251', '0');
INSERT INTO `ey_channelfield` VALUES ('121', 'is_top', '5', '置顶（0=否，1=是）', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1616293251', '1616293251', '0');
INSERT INTO `ey_channelfield` VALUES ('122', 'is_special', '5', '特荐（0=否，1=是）', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1616293251', '1616293251', '0');
INSERT INTO `ey_channelfield` VALUES ('123', 'is_head', '5', '头条（0=否，1=是）', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1616293251', '1616293251', '0');
INSERT INTO `ey_channelfield` VALUES ('124', 'litpic', '5', '缩略图', 'img', 'varchar(250)', '250', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1616293251', '1616293251', '0');
INSERT INTO `ey_channelfield` VALUES ('125', 'title', '5', '标题', 'text', 'varchar(200)', '200', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1616293251', '1616293251', '0');
INSERT INTO `ey_channelfield` VALUES ('126', 'is_b', '5', '加粗', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1616293251', '1616293251', '0');
INSERT INTO `ey_channelfield` VALUES ('127', 'channel', '5', '模型ID', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1616293251', '1616293251', '0');
INSERT INTO `ey_channelfield` VALUES ('128', 'typeid', '5', '当前栏目', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1616293251', '1616293251', '0');
INSERT INTO `ey_channelfield` VALUES ('129', 'aid', '5', 'aid', 'int', 'int(10)', '10', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1616293251', '1616293251', '0');
INSERT INTO `ey_channelfield` VALUES ('130', 'content', '5', '内容详情', 'htmltext', 'longtext', '0', '', '', '', '0', '1', '1', '0', '1', '0', '0', '100', '1', '1616293251', '1616293251', '0');
INSERT INTO `ey_channelfield` VALUES ('131', 'courseware', '5', '课件地址', 'text', 'varchar(200)', '200', '', '', '', '0', '1', '0', '0', '1', '0', '1', '100', '1', '1616293251', '1616293251', '0');
INSERT INTO `ey_channelfield` VALUES ('132', 'courseware_free', '5', '课件收费', 'select', 'enum(\'免费\',\'收费\')', '0', '免费,收费', '', '', '0', '1', '0', '0', '1', '0', '1', '100', '1', '1616293251', '1616293251', '0');
INSERT INTO `ey_channelfield` VALUES ('133', 'total_duration', '5', '视频总时长', 'int', 'int(10)', '10', '0', '', '', '0', '1', '0', '0', '1', '0', '1', '100', '1', '1616293251', '1616293251', '0');
INSERT INTO `ey_channelfield` VALUES ('134', 'total_video', '5', '视频数', 'int', 'int(10)', '10', '0', '', '', '0', '1', '0', '0', '1', '0', '1', '100', '1', '1616293251', '1616293251', '0');
INSERT INTO `ey_channelfield` VALUES ('135', 'update_time', '7', '更新时间', 'datetime', 'int(11)', '11', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1616293251', '1616293251', '0');
INSERT INTO `ey_channelfield` VALUES ('136', 'add_time', '7', '新增时间', 'datetime', 'int(11)', '11', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1616293251', '1616293251', '0');
INSERT INTO `ey_channelfield` VALUES ('137', 'htmlfilename', '7', '自定义文件名', 'text', 'varchar(50)', '50', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1616293251', '1616293251', '0');
INSERT INTO `ey_channelfield` VALUES ('138', 'downcount', '7', '下载次数', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1616293251', '1616293251', '0');
INSERT INTO `ey_channelfield` VALUES ('139', 'joinaid', '7', '关联文档ID', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1616293251', '1616293251', '0');
INSERT INTO `ey_channelfield` VALUES ('140', 'del_method', '7', '伪删除状态，1为主动删除，2为跟随上级栏目被动删除', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1616293251', '1616293251', '0');
INSERT INTO `ey_channelfield` VALUES ('141', 'is_del', '7', '伪删除，1=是，0=否', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1616293251', '1616293251', '0');
INSERT INTO `ey_channelfield` VALUES ('142', 'arc_level_id', '7', '文档会员权限ID', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1616293251', '1616293251', '0');
INSERT INTO `ey_channelfield` VALUES ('143', 'users_id', '7', '会员ID', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1616293251', '1616293251', '0');
INSERT INTO `ey_channelfield` VALUES ('144', 'admin_id', '7', '管理员ID', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1616293251', '1616293251', '0');
INSERT INTO `ey_channelfield` VALUES ('145', 'lang', '7', '语言标识', 'text', 'varchar(50)', '50', 'cn', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1616293251', '1616293251', '0');
INSERT INTO `ey_channelfield` VALUES ('146', 'sort_order', '7', '排序号', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1616293251', '1616293251', '0');
INSERT INTO `ey_channelfield` VALUES ('147', 'status', '7', '状态(0=屏蔽，1=正常)', 'switch', 'tinyint(1)', '1', '1', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1616293251', '1616293251', '0');
INSERT INTO `ey_channelfield` VALUES ('148', 'tempview', '7', '文档模板文件名', 'text', 'varchar(200)', '200', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1616293251', '1616293251', '0');
INSERT INTO `ey_channelfield` VALUES ('149', 'prom_type', '7', '产品类型：0=普通产品，1=虚拟(默认手动发货)，2=虚拟(网盘', 'switch', 'tinyint(1) unsigned', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1616293251', '1616293251', '0');
INSERT INTO `ey_channelfield` VALUES ('150', 'stock_show', '7', '商品库存在产品详情页是否显示，1为显示，0为不显示', 'switch', 'tinyint(1) unsigned', '1', '1', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1616293251', '1616293251', '0');
INSERT INTO `ey_channelfield` VALUES ('151', 'stock_count', '7', '商品库存量', 'int', 'int(10) unsigned', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1616293251', '1616293251', '0');
INSERT INTO `ey_channelfield` VALUES ('152', 'sales_num', '7', '销售量', 'int', 'int(10) unsigned', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1616293251', '1616293251', '0');
INSERT INTO `ey_channelfield` VALUES ('153', 'old_price', '7', '产品旧价', 'decimal', 'decimal(10,2)', '10', '0.00', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1616293251', '1616293251', '0');
INSERT INTO `ey_channelfield` VALUES ('154', 'users_free', '7', '是否会员免费，默认0不免费，1为免费', 'switch', 'tinyint(1) unsigned', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1616293251', '1616293251', '0');
INSERT INTO `ey_channelfield` VALUES ('155', 'users_price', '7', '会员价', 'decimal', 'decimal(10,2)', '10', '0.00', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1616293251', '1616293251', '0');
INSERT INTO `ey_channelfield` VALUES ('156', 'attrlist_id', '7', '参数列表ID', 'int', 'int(10) unsigned', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1616293251', '1616293251', '0');
INSERT INTO `ey_channelfield` VALUES ('157', 'seo_description', '7', 'SEO描述', 'multitext', 'text', '0', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1616293251', '1616293251', '0');
INSERT INTO `ey_channelfield` VALUES ('158', 'seo_keywords', '7', 'SEO关键词', 'text', 'varchar(200)', '200', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1616293251', '1616293251', '0');
INSERT INTO `ey_channelfield` VALUES ('159', 'seo_title', '7', 'SEO标题', 'text', 'varchar(200)', '200', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1616293251', '1616293251', '0');
INSERT INTO `ey_channelfield` VALUES ('160', 'ismake', '7', '是否静态页面（0=动态，1=静态）', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1616293251', '1616293251', '0');
INSERT INTO `ey_channelfield` VALUES ('161', 'jumplinks', '7', '外链跳转', 'text', 'varchar(200)', '200', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1616293251', '1616293251', '0');
INSERT INTO `ey_channelfield` VALUES ('162', 'arcrank', '7', '阅读权限：0=开放浏览，-1=待审核稿件', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1616293251', '1616293251', '0');
INSERT INTO `ey_channelfield` VALUES ('163', 'click', '7', '浏览量', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1616293251', '1616293251', '0');
INSERT INTO `ey_channelfield` VALUES ('164', 'author', '7', '作者', 'text', 'varchar(200)', '200', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1616293251', '1616293251', '0');
INSERT INTO `ey_channelfield` VALUES ('165', 'is_diyattr', '7', '自定义（0=否，1=是）', 'switch', 'tinyint(1) unsigned', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1616293251', '1616293251', '0');
INSERT INTO `ey_channelfield` VALUES ('166', 'is_slide', '7', '幻灯（0=否，1=是）', 'switch', 'tinyint(1) unsigned', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1616293251', '1616293251', '0');
INSERT INTO `ey_channelfield` VALUES ('167', 'is_roll', '7', '滚动（0=否，1=是）', 'switch', 'tinyint(1) unsigned', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1616293251', '1616293251', '0');
INSERT INTO `ey_channelfield` VALUES ('168', 'is_litpic', '7', '图片（0=否，1=是）', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1616293251', '1616293251', '0');
INSERT INTO `ey_channelfield` VALUES ('169', 'is_jump', '7', '跳转链接（0=否，1=是）', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1616293251', '1616293251', '0');
INSERT INTO `ey_channelfield` VALUES ('170', 'is_recom', '7', '推荐（0=否，1=是）', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1616293251', '1616293251', '0');
INSERT INTO `ey_channelfield` VALUES ('171', 'is_top', '7', '置顶（0=否，1=是）', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1616293251', '1616293251', '0');
INSERT INTO `ey_channelfield` VALUES ('172', 'is_special', '7', '特荐（0=否，1=是）', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1616293251', '1616293251', '0');
INSERT INTO `ey_channelfield` VALUES ('173', 'is_head', '7', '头条（0=否，1=是）', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1616293251', '1616293251', '0');
INSERT INTO `ey_channelfield` VALUES ('174', 'litpic', '7', '缩略图', 'img', 'varchar(250)', '250', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1616293251', '1616293251', '0');
INSERT INTO `ey_channelfield` VALUES ('175', 'title', '7', '标题', 'text', 'varchar(200)', '200', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1616293251', '1616293251', '0');
INSERT INTO `ey_channelfield` VALUES ('176', 'is_b', '7', '加粗', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1616293251', '1616293251', '0');
INSERT INTO `ey_channelfield` VALUES ('177', 'channel', '7', '模型ID', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1616293251', '1616293251', '0');
INSERT INTO `ey_channelfield` VALUES ('178', 'typeid', '7', '当前栏目', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1616293251', '1616293251', '0');
INSERT INTO `ey_channelfield` VALUES ('179', 'aid', '7', 'aid', 'int', 'int(10)', '10', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1616293251', '1616293251', '0');
INSERT INTO `ey_channelfield` VALUES ('180', 'content', '7', '内容详情', 'htmltext', 'longtext', '0', '', '', '', '0', '1', '1', '0', '1', '0', '0', '100', '1', '1616293251', '1616293251', '0');
INSERT INTO `ey_channelfield` VALUES ('181', 'restric_type', '0', '限制模式，0=免费，1=付费，2=会员专享，3=会员付费', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1616293251', '1616293251', '0');
INSERT INTO `ey_channelfield` VALUES ('182', 'diy_dirpath', '-99', '自定义HTML保存路径', 'text', 'varchar(200)', '200', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533524780', '1533524780', '0');
INSERT INTO `ey_channelfield` VALUES ('183', 'rulelist', '-99', '列表静态文件存放规则', 'text', 'varchar(200)', '200', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533524780', '1533524780', '0');
INSERT INTO `ey_channelfield` VALUES ('184', 'ruleview', '-99', '文档静态文件存放规则', 'text', 'varchar(200)', '200', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533524780', '1533524780', '0');
INSERT INTO `ey_channelfield` VALUES ('185', 'subtitle', '0', '副标题', 'text', 'varchar(200)', '200', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1636338535', '1636338535', '0');
INSERT INTO `ey_channelfield` VALUES ('186', 'origin', '0', '来源', 'text', 'varchar(30)', '30', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1636338535', '1636338535', '0');
INSERT INTO `ey_channelfield` VALUES ('187', 'stypeid', '0', '副栏目', 'text', 'varchar(90)', '90', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1636338535', '1636338535', '0');
INSERT INTO `ey_channelfield` VALUES ('188', 'update_time', '1', '更新时间', 'datetime', 'int(11)', '11', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862075', '1641862075', '0');
INSERT INTO `ey_channelfield` VALUES ('189', 'add_time', '1', '新增时间', 'datetime', 'int(11)', '11', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862075', '1641862075', '0');
INSERT INTO `ey_channelfield` VALUES ('190', 'area_id', '1', '所在区域', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862075', '1641862075', '0');
INSERT INTO `ey_channelfield` VALUES ('191', 'city_id', '1', '所在城市', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862075', '1641862075', '0');
INSERT INTO `ey_channelfield` VALUES ('192', 'province_id', '1', '省份', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862075', '1641862075', '0');
INSERT INTO `ey_channelfield` VALUES ('193', 'collection', '1', '收藏数', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862075', '1641862075', '0');
INSERT INTO `ey_channelfield` VALUES ('194', 'appraise', '1', '评价数', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862075', '1641862075', '0');
INSERT INTO `ey_channelfield` VALUES ('195', 'downcount', '1', '下载次数', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862075', '1641862075', '0');
INSERT INTO `ey_channelfield` VALUES ('196', 'joinaid', '1', '关联文档ID', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862075', '1641862075', '0');
INSERT INTO `ey_channelfield` VALUES ('197', 'del_method', '1', '伪删除状态，1为主动删除，2为跟随上级栏目被动删除', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862075', '1641862075', '0');
INSERT INTO `ey_channelfield` VALUES ('198', 'is_del', '1', '伪删除，1=是，0=否', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862075', '1641862075', '0');
INSERT INTO `ey_channelfield` VALUES ('199', 'restric_type', '1', '限制模式，0=免费，1=付费，2=会员专享，3=会员付费', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862075', '1641862075', '0');
INSERT INTO `ey_channelfield` VALUES ('200', 'arc_level_id', '1', '文档会员权限ID', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862075', '1641862075', '0');
INSERT INTO `ey_channelfield` VALUES ('201', 'users_id', '1', '会员ID', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862075', '1641862075', '0');
INSERT INTO `ey_channelfield` VALUES ('202', 'admin_id', '1', '管理员ID', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862075', '1641862075', '0');
INSERT INTO `ey_channelfield` VALUES ('203', 'lang', '1', '语言标识', 'text', 'varchar(50)', '50', 'cn', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862075', '1641862075', '0');
INSERT INTO `ey_channelfield` VALUES ('204', 'sort_order', '1', '排序号', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862075', '1641862075', '0');
INSERT INTO `ey_channelfield` VALUES ('205', 'status', '1', '状态(0=屏蔽，1=正常)', 'switch', 'tinyint(1)', '1', '1', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862075', '1641862075', '0');
INSERT INTO `ey_channelfield` VALUES ('206', 'tempview', '1', '文档模板文件名', 'text', 'varchar(200)', '200', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862075', '1641862075', '0');
INSERT INTO `ey_channelfield` VALUES ('207', 'prom_type', '1', '产品类型：0=普通产品，1=虚拟(默认手动发货)，2=虚拟(网盘)，3=虚拟(自定义文本)', 'switch', 'tinyint(1) unsigned', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862075', '1641862075', '0');
INSERT INTO `ey_channelfield` VALUES ('208', 'stock_show', '1', '商品库存在产品详情页是否显示，1为显示，0为不显示', 'switch', 'tinyint(1) unsigned', '1', '1', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862075', '1641862075', '0');
INSERT INTO `ey_channelfield` VALUES ('209', 'stock_count', '1', '商品库存量', 'int', 'int(10) unsigned', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862075', '1641862075', '0');
INSERT INTO `ey_channelfield` VALUES ('210', 'sales_num', '1', '销售量', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862075', '1641862075', '0');
INSERT INTO `ey_channelfield` VALUES ('211', 'old_price', '1', '产品旧价', 'decimal', 'decimal(10,2)', '10', '0.00', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862075', '1641862075', '0');
INSERT INTO `ey_channelfield` VALUES ('212', 'users_free', '1', '是否会员免费，默认0不免费，1为免费', 'switch', 'tinyint(1) unsigned', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862075', '1641862075', '0');
INSERT INTO `ey_channelfield` VALUES ('213', 'users_price', '1', '会员价', 'decimal', 'decimal(10,2)', '10', '0.00', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862075', '1641862075', '0');
INSERT INTO `ey_channelfield` VALUES ('214', 'attrlist_id', '1', '参数列表ID', 'int', 'int(10) unsigned', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862075', '1641862075', '0');
INSERT INTO `ey_channelfield` VALUES ('215', 'seo_description', '1', 'SEO描述', 'multitext', 'text', '0', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862075', '1641862075', '0');
INSERT INTO `ey_channelfield` VALUES ('216', 'seo_keywords', '1', 'SEO关键词', 'text', 'varchar(200)', '200', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862075', '1641862075', '0');
INSERT INTO `ey_channelfield` VALUES ('217', 'seo_title', '1', 'SEO标题', 'text', 'varchar(200)', '200', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862075', '1641862075', '0');
INSERT INTO `ey_channelfield` VALUES ('218', 'ismake', '1', '是否静态页面（0=动态，1=静态）', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862075', '1641862075', '0');
INSERT INTO `ey_channelfield` VALUES ('219', 'jumplinks', '1', '外链跳转', 'text', 'varchar(255)', '255', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862075', '1641862075', '0');
INSERT INTO `ey_channelfield` VALUES ('220', 'arcrank', '1', '阅读权限：0=开放浏览，-1=待审核稿件', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862075', '1641862075', '0');
INSERT INTO `ey_channelfield` VALUES ('221', 'click', '1', '浏览量', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862075', '1641862075', '0');
INSERT INTO `ey_channelfield` VALUES ('222', 'author', '1', '作者', 'text', 'varchar(200)', '200', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862075', '1641862075', '0');
INSERT INTO `ey_channelfield` VALUES ('223', 'origin', '1', '来源', 'text', 'varchar(30)', '30', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862075', '1641862075', '0');
INSERT INTO `ey_channelfield` VALUES ('224', 'is_diyattr', '1', '自定义（0=否，1=是）', 'switch', 'tinyint(1) unsigned', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862075', '1641862075', '0');
INSERT INTO `ey_channelfield` VALUES ('225', 'is_slide', '1', '幻灯（0=否，1=是）', 'switch', 'tinyint(1) unsigned', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862075', '1641862075', '0');
INSERT INTO `ey_channelfield` VALUES ('226', 'is_roll', '1', '滚动（0=否，1=是）', 'switch', 'tinyint(1) unsigned', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862075', '1641862075', '0');
INSERT INTO `ey_channelfield` VALUES ('227', 'is_litpic', '1', '图片（0=否，1=是）', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862075', '1641862075', '0');
INSERT INTO `ey_channelfield` VALUES ('228', 'is_jump', '1', '跳转链接（0=否，1=是）', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862075', '1641862075', '0');
INSERT INTO `ey_channelfield` VALUES ('229', 'is_recom', '1', '推荐（0=否，1=是）', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862075', '1641862075', '0');
INSERT INTO `ey_channelfield` VALUES ('230', 'is_top', '1', '置顶（0=否，1=是）', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862075', '1641862075', '0');
INSERT INTO `ey_channelfield` VALUES ('231', 'is_special', '1', '特荐（0=否，1=是）', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862075', '1641862075', '0');
INSERT INTO `ey_channelfield` VALUES ('232', 'is_head', '1', '头条（0=否，1=是）', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862075', '1641862075', '0');
INSERT INTO `ey_channelfield` VALUES ('233', 'litpic', '1', '缩略图', 'img', 'varchar(250)', '250', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862075', '1641862075', '0');
INSERT INTO `ey_channelfield` VALUES ('234', 'subtitle', '1', '副标题', 'text', 'varchar(200)', '200', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862075', '1641862075', '0');
INSERT INTO `ey_channelfield` VALUES ('235', 'title', '1', '标题', 'text', 'varchar(200)', '200', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862075', '1641862075', '0');
INSERT INTO `ey_channelfield` VALUES ('236', 'is_b', '1', '加粗', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862075', '1641862075', '0');
INSERT INTO `ey_channelfield` VALUES ('237', 'channel', '1', '模型ID', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862075', '1641862075', '0');
INSERT INTO `ey_channelfield` VALUES ('238', 'stypeid', '1', '副栏目ID集合', 'text', 'varchar(90)', '90', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862075', '1641862075', '0');
INSERT INTO `ey_channelfield` VALUES ('239', 'typeid', '1', '当前栏目', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862075', '1641862075', '0');
INSERT INTO `ey_channelfield` VALUES ('240', 'aid', '1', 'aid', 'int', 'int(10)', '10', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862075', '1641862075', '0');
INSERT INTO `ey_channelfield` VALUES ('241', 'update_time', '2', '更新时间', 'datetime', 'int(11)', '11', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862078', '1641862078', '0');
INSERT INTO `ey_channelfield` VALUES ('242', 'add_time', '2', '新增时间', 'datetime', 'int(11)', '11', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862078', '1641862078', '0');
INSERT INTO `ey_channelfield` VALUES ('243', 'area_id', '2', '所在区域', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862078', '1641862078', '0');
INSERT INTO `ey_channelfield` VALUES ('244', 'city_id', '2', '所在城市', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862078', '1641862078', '0');
INSERT INTO `ey_channelfield` VALUES ('245', 'province_id', '2', '省份', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862078', '1641862078', '0');
INSERT INTO `ey_channelfield` VALUES ('246', 'collection', '2', '收藏数', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862078', '1641862078', '0');
INSERT INTO `ey_channelfield` VALUES ('247', 'appraise', '2', '评价数', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862078', '1641862078', '0');
INSERT INTO `ey_channelfield` VALUES ('248', 'downcount', '2', '下载次数', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862078', '1641862078', '0');
INSERT INTO `ey_channelfield` VALUES ('249', 'joinaid', '2', '关联文档ID', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862078', '1641862078', '0');
INSERT INTO `ey_channelfield` VALUES ('250', 'del_method', '2', '伪删除状态，1为主动删除，2为跟随上级栏目被动删除', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862078', '1641862078', '0');
INSERT INTO `ey_channelfield` VALUES ('251', 'is_del', '2', '伪删除，1=是，0=否', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862078', '1641862078', '0');
INSERT INTO `ey_channelfield` VALUES ('252', 'restric_type', '2', '限制模式，0=免费，1=付费，2=会员专享，3=会员付费', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862078', '1641862078', '0');
INSERT INTO `ey_channelfield` VALUES ('253', 'arc_level_id', '2', '文档会员权限ID', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862078', '1641862078', '0');
INSERT INTO `ey_channelfield` VALUES ('254', 'users_id', '2', '会员ID', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862078', '1641862078', '0');
INSERT INTO `ey_channelfield` VALUES ('255', 'admin_id', '2', '管理员ID', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862078', '1641862078', '0');
INSERT INTO `ey_channelfield` VALUES ('256', 'lang', '2', '语言标识', 'text', 'varchar(50)', '50', 'cn', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862078', '1641862078', '0');
INSERT INTO `ey_channelfield` VALUES ('257', 'sort_order', '2', '排序号', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862078', '1641862078', '0');
INSERT INTO `ey_channelfield` VALUES ('258', 'status', '2', '状态(0=屏蔽，1=正常)', 'switch', 'tinyint(1)', '1', '1', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862078', '1641862078', '0');
INSERT INTO `ey_channelfield` VALUES ('259', 'tempview', '2', '文档模板文件名', 'text', 'varchar(200)', '200', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862078', '1641862078', '0');
INSERT INTO `ey_channelfield` VALUES ('260', 'stock_show', '2', '商品库存在产品详情页是否显示，1为显示，0为不显示', 'switch', 'tinyint(1) unsigned', '1', '1', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862078', '1641862078', '0');
INSERT INTO `ey_channelfield` VALUES ('261', 'stock_count', '2', '商品库存量', 'int', 'int(10) unsigned', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862078', '1641862078', '0');
INSERT INTO `ey_channelfield` VALUES ('262', 'sales_num', '2', '销售量', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862078', '1641862078', '0');
INSERT INTO `ey_channelfield` VALUES ('263', 'old_price', '2', '产品旧价', 'decimal', 'decimal(10,2)', '10', '0.00', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862078', '1641862078', '0');
INSERT INTO `ey_channelfield` VALUES ('264', 'users_free', '2', '是否会员免费，默认0不免费，1为免费', 'switch', 'tinyint(1) unsigned', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862078', '1641862078', '0');
INSERT INTO `ey_channelfield` VALUES ('265', 'attrlist_id', '2', '参数列表ID', 'int', 'int(10) unsigned', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862078', '1641862078', '0');
INSERT INTO `ey_channelfield` VALUES ('266', 'seo_description', '2', 'SEO描述', 'multitext', 'text', '0', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862078', '1641862078', '0');
INSERT INTO `ey_channelfield` VALUES ('267', 'seo_keywords', '2', 'SEO关键词', 'text', 'varchar(200)', '200', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862078', '1641862078', '0');
INSERT INTO `ey_channelfield` VALUES ('268', 'seo_title', '2', 'SEO标题', 'text', 'varchar(200)', '200', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862078', '1641862078', '0');
INSERT INTO `ey_channelfield` VALUES ('269', 'ismake', '2', '是否静态页面（0=动态，1=静态）', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862078', '1641862078', '0');
INSERT INTO `ey_channelfield` VALUES ('270', 'jumplinks', '2', '外链跳转', 'text', 'varchar(255)', '255', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862078', '1641862078', '0');
INSERT INTO `ey_channelfield` VALUES ('271', 'arcrank', '2', '阅读权限：0=开放浏览，-1=待审核稿件', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862078', '1641862078', '0');
INSERT INTO `ey_channelfield` VALUES ('272', 'click', '2', '浏览量', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862078', '1641862078', '0');
INSERT INTO `ey_channelfield` VALUES ('273', 'author', '2', '作者', 'text', 'varchar(200)', '200', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862078', '1641862078', '0');
INSERT INTO `ey_channelfield` VALUES ('274', 'origin', '2', '来源', 'text', 'varchar(30)', '30', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862078', '1641862078', '0');
INSERT INTO `ey_channelfield` VALUES ('275', 'is_diyattr', '2', '自定义（0=否，1=是）', 'switch', 'tinyint(1) unsigned', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862078', '1641862078', '0');
INSERT INTO `ey_channelfield` VALUES ('276', 'is_slide', '2', '幻灯（0=否，1=是）', 'switch', 'tinyint(1) unsigned', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862078', '1641862078', '0');
INSERT INTO `ey_channelfield` VALUES ('277', 'is_roll', '2', '滚动（0=否，1=是）', 'switch', 'tinyint(1) unsigned', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862078', '1641862078', '0');
INSERT INTO `ey_channelfield` VALUES ('278', 'is_litpic', '2', '图片（0=否，1=是）', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862078', '1641862078', '0');
INSERT INTO `ey_channelfield` VALUES ('279', 'is_jump', '2', '跳转链接（0=否，1=是）', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862078', '1641862078', '0');
INSERT INTO `ey_channelfield` VALUES ('280', 'is_recom', '2', '推荐（0=否，1=是）', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862078', '1641862078', '0');
INSERT INTO `ey_channelfield` VALUES ('281', 'is_top', '2', '置顶（0=否，1=是）', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862078', '1641862078', '0');
INSERT INTO `ey_channelfield` VALUES ('282', 'is_special', '2', '特荐（0=否，1=是）', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862078', '1641862078', '0');
INSERT INTO `ey_channelfield` VALUES ('283', 'is_head', '2', '头条（0=否，1=是）', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862078', '1641862078', '0');
INSERT INTO `ey_channelfield` VALUES ('284', 'litpic', '2', '缩略图', 'img', 'varchar(250)', '250', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862078', '1641862078', '0');
INSERT INTO `ey_channelfield` VALUES ('285', 'subtitle', '2', '副标题', 'text', 'varchar(200)', '200', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862078', '1641862078', '0');
INSERT INTO `ey_channelfield` VALUES ('286', 'title', '2', '标题', 'text', 'varchar(200)', '200', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862078', '1641862078', '0');
INSERT INTO `ey_channelfield` VALUES ('287', 'is_b', '2', '加粗', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862078', '1641862078', '0');
INSERT INTO `ey_channelfield` VALUES ('288', 'channel', '2', '模型ID', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862078', '1641862078', '0');
INSERT INTO `ey_channelfield` VALUES ('289', 'stypeid', '2', '副栏目ID集合', 'text', 'varchar(90)', '90', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862078', '1641862078', '0');
INSERT INTO `ey_channelfield` VALUES ('290', 'typeid', '2', '当前栏目', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862078', '1641862078', '0');
INSERT INTO `ey_channelfield` VALUES ('291', 'aid', '2', 'aid', 'int', 'int(10)', '10', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862078', '1641862078', '0');
INSERT INTO `ey_channelfield` VALUES ('292', 'update_time', '3', '更新时间', 'datetime', 'int(11)', '11', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862080', '1641862080', '0');
INSERT INTO `ey_channelfield` VALUES ('293', 'add_time', '3', '新增时间', 'datetime', 'int(11)', '11', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862080', '1641862080', '0');
INSERT INTO `ey_channelfield` VALUES ('294', 'area_id', '3', '所在区域', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862080', '1641862080', '0');
INSERT INTO `ey_channelfield` VALUES ('295', 'city_id', '3', '所在城市', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862080', '1641862080', '0');
INSERT INTO `ey_channelfield` VALUES ('296', 'province_id', '3', '省份', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862080', '1641862080', '0');
INSERT INTO `ey_channelfield` VALUES ('297', 'collection', '3', '收藏数', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862080', '1641862080', '0');
INSERT INTO `ey_channelfield` VALUES ('298', 'appraise', '3', '评价数', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862080', '1641862080', '0');
INSERT INTO `ey_channelfield` VALUES ('299', 'downcount', '3', '下载次数', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862080', '1641862080', '0');
INSERT INTO `ey_channelfield` VALUES ('300', 'joinaid', '3', '关联文档ID', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862080', '1641862080', '0');
INSERT INTO `ey_channelfield` VALUES ('301', 'del_method', '3', '伪删除状态，1为主动删除，2为跟随上级栏目被动删除', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862080', '1641862080', '0');
INSERT INTO `ey_channelfield` VALUES ('302', 'is_del', '3', '伪删除，1=是，0=否', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862080', '1641862080', '0');
INSERT INTO `ey_channelfield` VALUES ('303', 'restric_type', '3', '限制模式，0=免费，1=付费，2=会员专享，3=会员付费', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862080', '1641862080', '0');
INSERT INTO `ey_channelfield` VALUES ('304', 'arc_level_id', '3', '文档会员权限ID', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862080', '1641862080', '0');
INSERT INTO `ey_channelfield` VALUES ('305', 'users_id', '3', '会员ID', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862080', '1641862080', '0');
INSERT INTO `ey_channelfield` VALUES ('306', 'admin_id', '3', '管理员ID', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862080', '1641862080', '0');
INSERT INTO `ey_channelfield` VALUES ('307', 'lang', '3', '语言标识', 'text', 'varchar(50)', '50', 'cn', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862080', '1641862080', '0');
INSERT INTO `ey_channelfield` VALUES ('308', 'sort_order', '3', '排序号', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862080', '1641862080', '0');
INSERT INTO `ey_channelfield` VALUES ('309', 'status', '3', '状态(0=屏蔽，1=正常)', 'switch', 'tinyint(1)', '1', '1', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862080', '1641862080', '0');
INSERT INTO `ey_channelfield` VALUES ('310', 'tempview', '3', '文档模板文件名', 'text', 'varchar(200)', '200', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862080', '1641862080', '0');
INSERT INTO `ey_channelfield` VALUES ('311', 'prom_type', '3', '产品类型：0=普通产品，1=虚拟(默认手动发货)，2=虚拟(网盘)，3=虚拟(自定义文本)', 'switch', 'tinyint(1) unsigned', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862080', '1641862080', '0');
INSERT INTO `ey_channelfield` VALUES ('312', 'stock_show', '3', '商品库存在产品详情页是否显示，1为显示，0为不显示', 'switch', 'tinyint(1) unsigned', '1', '1', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862080', '1641862080', '0');
INSERT INTO `ey_channelfield` VALUES ('313', 'stock_count', '3', '商品库存量', 'int', 'int(10) unsigned', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862080', '1641862080', '0');
INSERT INTO `ey_channelfield` VALUES ('314', 'sales_num', '3', '销售量', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862080', '1641862080', '0');
INSERT INTO `ey_channelfield` VALUES ('315', 'old_price', '3', '产品旧价', 'decimal', 'decimal(10,2)', '10', '0.00', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862080', '1641862080', '0');
INSERT INTO `ey_channelfield` VALUES ('316', 'users_free', '3', '是否会员免费，默认0不免费，1为免费', 'switch', 'tinyint(1) unsigned', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862080', '1641862080', '0');
INSERT INTO `ey_channelfield` VALUES ('317', 'users_price', '3', '会员价', 'decimal', 'decimal(10,2)', '10', '0.00', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862080', '1641862080', '0');
INSERT INTO `ey_channelfield` VALUES ('318', 'attrlist_id', '3', '参数列表ID', 'int', 'int(10) unsigned', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862080', '1641862080', '0');
INSERT INTO `ey_channelfield` VALUES ('319', 'seo_description', '3', 'SEO描述', 'multitext', 'text', '0', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862080', '1641862080', '0');
INSERT INTO `ey_channelfield` VALUES ('320', 'seo_keywords', '3', 'SEO关键词', 'text', 'varchar(200)', '200', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862080', '1641862080', '0');
INSERT INTO `ey_channelfield` VALUES ('321', 'seo_title', '3', 'SEO标题', 'text', 'varchar(200)', '200', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862080', '1641862080', '0');
INSERT INTO `ey_channelfield` VALUES ('322', 'ismake', '3', '是否静态页面（0=动态，1=静态）', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862080', '1641862080', '0');
INSERT INTO `ey_channelfield` VALUES ('323', 'jumplinks', '3', '外链跳转', 'text', 'varchar(255)', '255', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862080', '1641862080', '0');
INSERT INTO `ey_channelfield` VALUES ('324', 'arcrank', '3', '阅读权限：0=开放浏览，-1=待审核稿件', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862080', '1641862080', '0');
INSERT INTO `ey_channelfield` VALUES ('325', 'click', '3', '浏览量', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862080', '1641862080', '0');
INSERT INTO `ey_channelfield` VALUES ('326', 'author', '3', '作者', 'text', 'varchar(200)', '200', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862080', '1641862080', '0');
INSERT INTO `ey_channelfield` VALUES ('327', 'origin', '3', '来源', 'text', 'varchar(30)', '30', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862080', '1641862080', '0');
INSERT INTO `ey_channelfield` VALUES ('328', 'is_diyattr', '3', '自定义（0=否，1=是）', 'switch', 'tinyint(1) unsigned', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862080', '1641862080', '0');
INSERT INTO `ey_channelfield` VALUES ('329', 'is_slide', '3', '幻灯（0=否，1=是）', 'switch', 'tinyint(1) unsigned', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862080', '1641862080', '0');
INSERT INTO `ey_channelfield` VALUES ('330', 'is_roll', '3', '滚动（0=否，1=是）', 'switch', 'tinyint(1) unsigned', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862080', '1641862080', '0');
INSERT INTO `ey_channelfield` VALUES ('331', 'is_litpic', '3', '图片（0=否，1=是）', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862080', '1641862080', '0');
INSERT INTO `ey_channelfield` VALUES ('332', 'is_jump', '3', '跳转链接（0=否，1=是）', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862080', '1641862080', '0');
INSERT INTO `ey_channelfield` VALUES ('333', 'is_recom', '3', '推荐（0=否，1=是）', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862080', '1641862080', '0');
INSERT INTO `ey_channelfield` VALUES ('334', 'is_top', '3', '置顶（0=否，1=是）', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862080', '1641862080', '0');
INSERT INTO `ey_channelfield` VALUES ('335', 'is_special', '3', '特荐（0=否，1=是）', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862080', '1641862080', '0');
INSERT INTO `ey_channelfield` VALUES ('336', 'is_head', '3', '头条（0=否，1=是）', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862080', '1641862080', '0');
INSERT INTO `ey_channelfield` VALUES ('337', 'litpic', '3', '缩略图', 'img', 'varchar(250)', '250', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862080', '1641862080', '0');
INSERT INTO `ey_channelfield` VALUES ('338', 'subtitle', '3', '副标题', 'text', 'varchar(200)', '200', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862080', '1641862080', '0');
INSERT INTO `ey_channelfield` VALUES ('339', 'title', '3', '标题', 'text', 'varchar(200)', '200', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862080', '1641862080', '0');
INSERT INTO `ey_channelfield` VALUES ('340', 'is_b', '3', '加粗', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862080', '1641862080', '0');
INSERT INTO `ey_channelfield` VALUES ('341', 'channel', '3', '模型ID', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862080', '1641862080', '0');
INSERT INTO `ey_channelfield` VALUES ('342', 'stypeid', '3', '副栏目ID集合', 'text', 'varchar(90)', '90', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862080', '1641862080', '0');
INSERT INTO `ey_channelfield` VALUES ('343', 'typeid', '3', '当前栏目', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862080', '1641862080', '0');
INSERT INTO `ey_channelfield` VALUES ('344', 'aid', '3', 'aid', 'int', 'int(10)', '10', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862080', '1641862080', '0');
INSERT INTO `ey_channelfield` VALUES ('345', 'update_time', '4', '更新时间', 'datetime', 'int(11)', '11', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862083', '1641862083', '0');
INSERT INTO `ey_channelfield` VALUES ('346', 'add_time', '4', '新增时间', 'datetime', 'int(11)', '11', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862083', '1641862083', '0');
INSERT INTO `ey_channelfield` VALUES ('347', 'area_id', '4', '所在区域', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862083', '1641862083', '0');
INSERT INTO `ey_channelfield` VALUES ('348', 'city_id', '4', '所在城市', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862083', '1641862083', '0');
INSERT INTO `ey_channelfield` VALUES ('349', 'province_id', '4', '省份', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862083', '1641862083', '0');
INSERT INTO `ey_channelfield` VALUES ('350', 'collection', '4', '收藏数', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862083', '1641862083', '0');
INSERT INTO `ey_channelfield` VALUES ('351', 'appraise', '4', '评价数', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862083', '1641862083', '0');
INSERT INTO `ey_channelfield` VALUES ('352', 'joinaid', '4', '关联文档ID', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862083', '1641862083', '0');
INSERT INTO `ey_channelfield` VALUES ('353', 'del_method', '4', '伪删除状态，1为主动删除，2为跟随上级栏目被动删除', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862083', '1641862083', '0');
INSERT INTO `ey_channelfield` VALUES ('354', 'is_del', '4', '伪删除，1=是，0=否', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862083', '1641862083', '0');
INSERT INTO `ey_channelfield` VALUES ('355', 'restric_type', '4', '限制模式，0=免费，1=付费，2=会员专享，3=会员付费', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862083', '1641862083', '0');
INSERT INTO `ey_channelfield` VALUES ('356', 'users_id', '4', '会员ID', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862083', '1641862083', '0');
INSERT INTO `ey_channelfield` VALUES ('357', 'admin_id', '4', '管理员ID', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862083', '1641862083', '0');
INSERT INTO `ey_channelfield` VALUES ('358', 'lang', '4', '语言标识', 'text', 'varchar(50)', '50', 'cn', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862083', '1641862083', '0');
INSERT INTO `ey_channelfield` VALUES ('359', 'sort_order', '4', '排序号', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862083', '1641862083', '0');
INSERT INTO `ey_channelfield` VALUES ('360', 'status', '4', '状态(0=屏蔽，1=正常)', 'switch', 'tinyint(1)', '1', '1', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862083', '1641862083', '0');
INSERT INTO `ey_channelfield` VALUES ('361', 'tempview', '4', '文档模板文件名', 'text', 'varchar(200)', '200', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862083', '1641862083', '0');
INSERT INTO `ey_channelfield` VALUES ('362', 'prom_type', '4', '产品类型：0=普通产品，1=虚拟(默认手动发货)，2=虚拟(网盘)，3=虚拟(自定义文本)', 'switch', 'tinyint(1) unsigned', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862083', '1641862083', '0');
INSERT INTO `ey_channelfield` VALUES ('363', 'stock_show', '4', '商品库存在产品详情页是否显示，1为显示，0为不显示', 'switch', 'tinyint(1) unsigned', '1', '1', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862083', '1641862083', '0');
INSERT INTO `ey_channelfield` VALUES ('364', 'stock_count', '4', '商品库存量', 'int', 'int(10) unsigned', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862083', '1641862083', '0');
INSERT INTO `ey_channelfield` VALUES ('365', 'sales_num', '4', '销售量', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862083', '1641862083', '0');
INSERT INTO `ey_channelfield` VALUES ('366', 'old_price', '4', '产品旧价', 'decimal', 'decimal(10,2)', '10', '0.00', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862083', '1641862083', '0');
INSERT INTO `ey_channelfield` VALUES ('367', 'users_free', '4', '是否会员免费，默认0不免费，1为免费', 'switch', 'tinyint(1) unsigned', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862083', '1641862083', '0');
INSERT INTO `ey_channelfield` VALUES ('368', 'users_price', '4', '会员价', 'decimal', 'decimal(10,2)', '10', '0.00', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862083', '1641862083', '0');
INSERT INTO `ey_channelfield` VALUES ('369', 'attrlist_id', '4', '参数列表ID', 'int', 'int(10) unsigned', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862083', '1641862083', '0');
INSERT INTO `ey_channelfield` VALUES ('370', 'seo_description', '4', 'SEO描述', 'multitext', 'text', '0', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862083', '1641862083', '0');
INSERT INTO `ey_channelfield` VALUES ('371', 'seo_keywords', '4', 'SEO关键词', 'text', 'varchar(200)', '200', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862083', '1641862083', '0');
INSERT INTO `ey_channelfield` VALUES ('372', 'seo_title', '4', 'SEO标题', 'text', 'varchar(200)', '200', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862083', '1641862083', '0');
INSERT INTO `ey_channelfield` VALUES ('373', 'ismake', '4', '是否静态页面（0=动态，1=静态）', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862083', '1641862083', '0');
INSERT INTO `ey_channelfield` VALUES ('374', 'jumplinks', '4', '外链跳转', 'text', 'varchar(255)', '255', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862083', '1641862083', '0');
INSERT INTO `ey_channelfield` VALUES ('375', 'arcrank', '4', '阅读权限：0=开放浏览，-1=待审核稿件', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862083', '1641862083', '0');
INSERT INTO `ey_channelfield` VALUES ('376', 'click', '4', '浏览量', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862083', '1641862083', '0');
INSERT INTO `ey_channelfield` VALUES ('377', 'author', '4', '作者', 'text', 'varchar(200)', '200', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862083', '1641862083', '0');
INSERT INTO `ey_channelfield` VALUES ('378', 'origin', '4', '来源', 'text', 'varchar(30)', '30', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862083', '1641862083', '0');
INSERT INTO `ey_channelfield` VALUES ('379', 'is_diyattr', '4', '自定义（0=否，1=是）', 'switch', 'tinyint(1) unsigned', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862083', '1641862083', '0');
INSERT INTO `ey_channelfield` VALUES ('380', 'is_slide', '4', '幻灯（0=否，1=是）', 'switch', 'tinyint(1) unsigned', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862083', '1641862083', '0');
INSERT INTO `ey_channelfield` VALUES ('381', 'is_roll', '4', '滚动（0=否，1=是）', 'switch', 'tinyint(1) unsigned', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862083', '1641862083', '0');
INSERT INTO `ey_channelfield` VALUES ('382', 'is_litpic', '4', '图片（0=否，1=是）', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862083', '1641862083', '0');
INSERT INTO `ey_channelfield` VALUES ('383', 'is_jump', '4', '跳转链接（0=否，1=是）', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862083', '1641862083', '0');
INSERT INTO `ey_channelfield` VALUES ('384', 'is_recom', '4', '推荐（0=否，1=是）', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862083', '1641862083', '0');
INSERT INTO `ey_channelfield` VALUES ('385', 'is_top', '4', '置顶（0=否，1=是）', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862083', '1641862083', '0');
INSERT INTO `ey_channelfield` VALUES ('386', 'is_special', '4', '特荐（0=否，1=是）', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862083', '1641862083', '0');
INSERT INTO `ey_channelfield` VALUES ('387', 'is_head', '4', '头条（0=否，1=是）', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862083', '1641862083', '0');
INSERT INTO `ey_channelfield` VALUES ('388', 'litpic', '4', '缩略图', 'img', 'varchar(250)', '250', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862083', '1641862083', '0');
INSERT INTO `ey_channelfield` VALUES ('389', 'subtitle', '4', '副标题', 'text', 'varchar(200)', '200', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862083', '1641862083', '0');
INSERT INTO `ey_channelfield` VALUES ('390', 'title', '4', '标题', 'text', 'varchar(200)', '200', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862083', '1641862083', '0');
INSERT INTO `ey_channelfield` VALUES ('391', 'is_b', '4', '加粗', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862083', '1641862083', '0');
INSERT INTO `ey_channelfield` VALUES ('392', 'channel', '4', '模型ID', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862083', '1641862083', '0');
INSERT INTO `ey_channelfield` VALUES ('393', 'stypeid', '4', '副栏目ID集合', 'text', 'varchar(90)', '90', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862083', '1641862083', '0');
INSERT INTO `ey_channelfield` VALUES ('394', 'typeid', '4', '当前栏目', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862083', '1641862083', '0');
INSERT INTO `ey_channelfield` VALUES ('395', 'aid', '4', 'aid', 'int', 'int(10)', '10', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862083', '1641862083', '0');
INSERT INTO `ey_channelfield` VALUES ('396', 'update_time', '6', '更新时间', 'datetime', 'int(11)', '11', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862087', '1641862087', '0');
INSERT INTO `ey_channelfield` VALUES ('397', 'add_time', '6', '新增时间', 'datetime', 'int(11)', '11', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862087', '1641862087', '0');
INSERT INTO `ey_channelfield` VALUES ('398', 'area_id', '6', '所在区域', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862087', '1641862087', '0');
INSERT INTO `ey_channelfield` VALUES ('399', 'city_id', '6', '所在城市', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862087', '1641862087', '0');
INSERT INTO `ey_channelfield` VALUES ('400', 'province_id', '6', '省份', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862087', '1641862087', '0');
INSERT INTO `ey_channelfield` VALUES ('401', 'collection', '6', '收藏数', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862087', '1641862087', '0');
INSERT INTO `ey_channelfield` VALUES ('402', 'appraise', '6', '评价数', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862087', '1641862087', '0');
INSERT INTO `ey_channelfield` VALUES ('403', 'downcount', '6', '下载次数', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862087', '1641862087', '0');
INSERT INTO `ey_channelfield` VALUES ('404', 'joinaid', '6', '关联文档ID', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862087', '1641862087', '0');
INSERT INTO `ey_channelfield` VALUES ('405', 'del_method', '6', '伪删除状态，1为主动删除，2为跟随上级栏目被动删除', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862087', '1641862087', '0');
INSERT INTO `ey_channelfield` VALUES ('406', 'is_del', '6', '伪删除，1=是，0=否', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862087', '1641862087', '0');
INSERT INTO `ey_channelfield` VALUES ('407', 'restric_type', '6', '限制模式，0=免费，1=付费，2=会员专享，3=会员付费', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862087', '1641862087', '0');
INSERT INTO `ey_channelfield` VALUES ('408', 'arc_level_id', '6', '文档会员权限ID', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862087', '1641862087', '0');
INSERT INTO `ey_channelfield` VALUES ('409', 'users_id', '6', '会员ID', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862087', '1641862087', '0');
INSERT INTO `ey_channelfield` VALUES ('410', 'admin_id', '6', '管理员ID', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862087', '1641862087', '0');
INSERT INTO `ey_channelfield` VALUES ('411', 'lang', '6', '语言标识', 'text', 'varchar(50)', '50', 'cn', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862087', '1641862087', '0');
INSERT INTO `ey_channelfield` VALUES ('412', 'sort_order', '6', '排序号', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862087', '1641862087', '0');
INSERT INTO `ey_channelfield` VALUES ('413', 'status', '6', '状态(0=屏蔽，1=正常)', 'switch', 'tinyint(1)', '1', '1', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862087', '1641862087', '0');
INSERT INTO `ey_channelfield` VALUES ('414', 'tempview', '6', '文档模板文件名', 'text', 'varchar(200)', '200', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862087', '1641862087', '0');
INSERT INTO `ey_channelfield` VALUES ('415', 'prom_type', '6', '产品类型：0=普通产品，1=虚拟(默认手动发货)，2=虚拟(网盘)，3=虚拟(自定义文本)', 'switch', 'tinyint(1) unsigned', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862087', '1641862087', '0');
INSERT INTO `ey_channelfield` VALUES ('416', 'stock_show', '6', '商品库存在产品详情页是否显示，1为显示，0为不显示', 'switch', 'tinyint(1) unsigned', '1', '1', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862087', '1641862087', '0');
INSERT INTO `ey_channelfield` VALUES ('417', 'stock_count', '6', '商品库存量', 'int', 'int(10) unsigned', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862087', '1641862087', '0');
INSERT INTO `ey_channelfield` VALUES ('418', 'sales_num', '6', '销售量', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862087', '1641862087', '0');
INSERT INTO `ey_channelfield` VALUES ('419', 'old_price', '6', '产品旧价', 'decimal', 'decimal(10,2)', '10', '0.00', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862087', '1641862087', '0');
INSERT INTO `ey_channelfield` VALUES ('420', 'users_free', '6', '是否会员免费，默认0不免费，1为免费', 'switch', 'tinyint(1) unsigned', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862087', '1641862087', '0');
INSERT INTO `ey_channelfield` VALUES ('421', 'users_price', '6', '会员价', 'decimal', 'decimal(10,2)', '10', '0.00', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862087', '1641862087', '0');
INSERT INTO `ey_channelfield` VALUES ('422', 'attrlist_id', '6', '参数列表ID', 'int', 'int(10) unsigned', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862087', '1641862087', '0');
INSERT INTO `ey_channelfield` VALUES ('423', 'seo_description', '6', 'SEO描述', 'multitext', 'text', '0', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862087', '1641862087', '0');
INSERT INTO `ey_channelfield` VALUES ('424', 'seo_keywords', '6', 'SEO关键词', 'text', 'varchar(200)', '200', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862087', '1641862087', '0');
INSERT INTO `ey_channelfield` VALUES ('425', 'seo_title', '6', 'SEO标题', 'text', 'varchar(200)', '200', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862087', '1641862087', '0');
INSERT INTO `ey_channelfield` VALUES ('426', 'ismake', '6', '是否静态页面（0=动态，1=静态）', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862087', '1641862087', '0');
INSERT INTO `ey_channelfield` VALUES ('427', 'jumplinks', '6', '外链跳转', 'text', 'varchar(255)', '255', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862087', '1641862087', '0');
INSERT INTO `ey_channelfield` VALUES ('428', 'arcrank', '6', '阅读权限：0=开放浏览，-1=待审核稿件', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862087', '1641862087', '0');
INSERT INTO `ey_channelfield` VALUES ('429', 'click', '6', '浏览量', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862087', '1641862087', '0');
INSERT INTO `ey_channelfield` VALUES ('430', 'author', '6', '作者', 'text', 'varchar(200)', '200', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862087', '1641862087', '0');
INSERT INTO `ey_channelfield` VALUES ('431', 'origin', '6', '来源', 'text', 'varchar(30)', '30', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862087', '1641862087', '0');
INSERT INTO `ey_channelfield` VALUES ('432', 'is_diyattr', '6', '自定义（0=否，1=是）', 'switch', 'tinyint(1) unsigned', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862087', '1641862087', '0');
INSERT INTO `ey_channelfield` VALUES ('433', 'is_slide', '6', '幻灯（0=否，1=是）', 'switch', 'tinyint(1) unsigned', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862087', '1641862087', '0');
INSERT INTO `ey_channelfield` VALUES ('434', 'is_roll', '6', '滚动（0=否，1=是）', 'switch', 'tinyint(1) unsigned', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862087', '1641862087', '0');
INSERT INTO `ey_channelfield` VALUES ('435', 'is_litpic', '6', '图片（0=否，1=是）', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862087', '1641862087', '0');
INSERT INTO `ey_channelfield` VALUES ('436', 'is_jump', '6', '跳转链接（0=否，1=是）', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862087', '1641862087', '0');
INSERT INTO `ey_channelfield` VALUES ('437', 'is_recom', '6', '推荐（0=否，1=是）', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862087', '1641862087', '0');
INSERT INTO `ey_channelfield` VALUES ('438', 'is_top', '6', '置顶（0=否，1=是）', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862087', '1641862087', '0');
INSERT INTO `ey_channelfield` VALUES ('439', 'is_special', '6', '特荐（0=否，1=是）', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862087', '1641862087', '0');
INSERT INTO `ey_channelfield` VALUES ('440', 'is_head', '6', '头条（0=否，1=是）', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862087', '1641862087', '0');
INSERT INTO `ey_channelfield` VALUES ('441', 'litpic', '6', '缩略图', 'img', 'varchar(250)', '250', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862087', '1641862087', '0');
INSERT INTO `ey_channelfield` VALUES ('442', 'subtitle', '6', '副标题', 'text', 'varchar(200)', '200', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862087', '1641862087', '0');
INSERT INTO `ey_channelfield` VALUES ('443', 'title', '6', '标题', 'text', 'varchar(200)', '200', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862087', '1641862087', '0');
INSERT INTO `ey_channelfield` VALUES ('444', 'is_b', '6', '加粗', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862087', '1641862087', '0');
INSERT INTO `ey_channelfield` VALUES ('445', 'channel', '6', '模型ID', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862087', '1641862087', '0');
INSERT INTO `ey_channelfield` VALUES ('446', 'stypeid', '6', '副栏目ID集合', 'text', 'varchar(90)', '90', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862087', '1641862087', '0');
INSERT INTO `ey_channelfield` VALUES ('447', 'typeid', '6', '当前栏目', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862087', '1641862087', '0');
INSERT INTO `ey_channelfield` VALUES ('448', 'aid', '6', 'aid', 'int', 'int(10)', '10', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862087', '1641862087', '0');
INSERT INTO `ey_channelfield` VALUES ('449', 'area_id', '7', '所在区域', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862089', '1641862089', '0');
INSERT INTO `ey_channelfield` VALUES ('450', 'city_id', '7', '所在城市', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862089', '1641862089', '0');
INSERT INTO `ey_channelfield` VALUES ('451', 'province_id', '7', '省份', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862089', '1641862089', '0');
INSERT INTO `ey_channelfield` VALUES ('452', 'collection', '7', '收藏数', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862089', '1641862089', '0');
INSERT INTO `ey_channelfield` VALUES ('453', 'appraise', '7', '评价数', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862089', '1641862089', '0');
INSERT INTO `ey_channelfield` VALUES ('454', 'restric_type', '7', '限制模式，0=免费，1=付费，2=会员专享，3=会员付费', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862089', '1641862089', '0');
INSERT INTO `ey_channelfield` VALUES ('455', 'origin', '7', '来源', 'text', 'varchar(30)', '30', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862089', '1641862089', '0');
INSERT INTO `ey_channelfield` VALUES ('456', 'subtitle', '7', '副标题', 'text', 'varchar(200)', '200', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862089', '1641862089', '0');
INSERT INTO `ey_channelfield` VALUES ('457', 'stypeid', '7', '副栏目ID集合', 'text', 'varchar(90)', '90', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862089', '1641862089', '0');
INSERT INTO `ey_channelfield` VALUES ('458', 'lang', '-99', '语言标识', 'text', 'varchar(50)', '50', 'cn', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862097', '1641862097', '0');
INSERT INTO `ey_channelfield` VALUES ('459', 'is_del', '-99', '伪删除，1=是，0=否', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862097', '1641862097', '0');
INSERT INTO `ey_channelfield` VALUES ('460', 'admin_id', '-99', '管理员ID', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1641862097', '1641862097', '0');
INSERT INTO `ey_channelfield` VALUES ('461', 'target', '-99', '新窗口打开', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1547890773', '1547890773', '0');
INSERT INTO `ey_channelfield` VALUES ('462', 'nofollow', '-99', '防抓取', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1547890773', '1547890773', '0');
INSERT INTO `ey_channelfield` VALUES ('463', 'content_ey_m', '1', '手机端内容详情', 'htmltext', 'longtext', '250', '', '', '', '0', '1', '1', '0', '1', '0', '0', '100', '1', '1533464713', '1623047123', '0');
INSERT INTO `ey_channelfield` VALUES ('464', 'content_ey_m', '2', '手机端内容详情', 'htmltext', 'longtext', '250', '', '', '', '0', '1', '1', '0', '1', '0', '0', '100', '1', '1645086030', '1645086039', '0');
INSERT INTO `ey_channelfield` VALUES ('465', 'content_ey_m', '3', '手机端内容详情', 'htmltext', 'longtext', '250', '', '', '', '0', '1', '1', '0', '1', '0', '0', '100', '1', '1533359588', '1533359588', '0');
INSERT INTO `ey_channelfield` VALUES ('466', 'content_ey_m', '4', '手机端内容详情', 'htmltext', 'longtext', '250', '', '', '', '0', '1', '1', '0', '1', '0', '0', '100', '1', '1533359752', '1533359752', '0');
INSERT INTO `ey_channelfield` VALUES ('467', 'content_ey_m', '5', '手机端内容详情', 'htmltext', 'longtext', '250', '', '', '', '0', '1', '1', '0', '1', '0', '0', '100', '1', '1591957363', '1591957363', '0');
INSERT INTO `ey_channelfield` VALUES ('468', 'content_ey_m', '6', '手机端内容详情', 'htmltext', 'longtext', '250', '', '', '', '0', '1', '1', '0', '1', '0', '0', '100', '1', '1533464715', '1533464715', '0');
INSERT INTO `ey_channelfield` VALUES ('469', 'content_ey_m', '7', '手机端内容详情', 'htmltext', 'longtext', '250', '', '', '', '0', '1', '1', '0', '1', '0', '0', '100', '1', '1602320145', '1602320145', '0');
INSERT INTO `ey_channelfield` VALUES ('470', 'typearcrank', '-99', '阅读权限：0=开放浏览，-1=待审核稿件', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1547890773', '1547890773', '0');
INSERT INTO `ey_channelfield` VALUES ('471', 'empty_logic', '-99', '空内容逻辑', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533524780', '1533524780', '0');
INSERT INTO `ey_channelfield` VALUES ('472', 'users_discount_type', '0', '产品会员折扣类型(0:系统默认折扣; 1:指定会员级别; 2:不参与折扣;)', 'switch', 'tinyint(1) unsigned', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1683873488', '1683873488', '0');
INSERT INTO `ey_channelfield` VALUES ('473', 'logistics_type', '0', '商品物流支持类型(1: 物流配送; 2: 到店核销)', 'text', 'varchar(100)', '100', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1690364521', '1690364521', '0');
INSERT INTO `ey_channelfield` VALUES ('474', 'total_arc', '-99', '栏目下文档数量', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1711942240', '1711942240', '0');

-- -----------------------------
-- Table structure for `ey_channelfield_bind`
-- -----------------------------
DROP TABLE IF EXISTS `ey_channelfield_bind`;
CREATE TABLE `ey_channelfield_bind` (
  `id` int(10) NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `typeid` int(10) DEFAULT '0' COMMENT '栏目ID',
  `field_id` int(10) DEFAULT '0' COMMENT '自定义字段ID',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=12 DEFAULT CHARSET=utf8 COMMENT='栏目与自定义字段绑定表';


-- -----------------------------
-- Table structure for `ey_channelfield_log`
-- -----------------------------
DROP TABLE IF EXISTS `ey_channelfield_log`;
CREATE TABLE `ey_channelfield_log` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) DEFAULT '' COMMENT '字段名称',
  `channel_id` int(10) DEFAULT '0' COMMENT '模型ID',
  `dtype` varchar(32) DEFAULT '' COMMENT '字段类型',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='自定义字段日志表';


-- -----------------------------
-- Table structure for `ey_channeltype`
-- -----------------------------
DROP TABLE IF EXISTS `ey_channeltype`;
CREATE TABLE `ey_channeltype` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `nid` varchar(50) NOT NULL DEFAULT '' COMMENT '识别id',
  `title` varchar(30) DEFAULT '' COMMENT '名称',
  `ntitle` varchar(30) DEFAULT '' COMMENT '左侧菜单名称',
  `table` varchar(50) DEFAULT '' COMMENT '表名',
  `ctl_name` varchar(50) DEFAULT '' COMMENT '控制器名称（区分大小写）',
  `status` tinyint(1) DEFAULT '1' COMMENT '状态(1=启用，0=屏蔽)',
  `ifsystem` tinyint(1) DEFAULT '0' COMMENT '字段分类，1=系统(不可修改)，0=自定义',
  `is_repeat_title` tinyint(1) DEFAULT '1' COMMENT '文档标题重复，1=允许，0=不允许',
  `is_release` tinyint(1) DEFAULT '0' COMMENT '模型是否允许应用于会员投稿发布，1是，0否',
  `is_litpic_users_release` tinyint(1) DEFAULT '1' COMMENT '缩略图是否应用于会员投稿，1=允许，0=不允许',
  `data` text COMMENT '额外序列化存储数据',
  `is_del` tinyint(1) DEFAULT '0' COMMENT '伪删除，1=是，0=否',
  `sort_order` smallint(6) DEFAULT '50' COMMENT '排序',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idention` (`nid`) USING BTREE,
  UNIQUE KEY `ctl_name` (`ctl_name`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=101 DEFAULT CHARSET=utf8 COMMENT='系统模型表';

-- -----------------------------
-- Records of `ey_channeltype`
-- -----------------------------
INSERT INTO `ey_channeltype` VALUES ('1', 'article', '文章模型', '文章', 'article', 'Article', '1', '1', '1', '1', '1', '', '0', '1', '0', '1531800410');
INSERT INTO `ey_channeltype` VALUES ('4', 'download', '下载模型', '下载', 'download', 'Download', '1', '1', '1', '1', '1', '', '0', '4', '0', '1531800410');
INSERT INTO `ey_channeltype` VALUES ('2', 'product', '产品模型', '产品', 'product', 'Product', '1', '1', '1', '1', '1', '', '0', '2', '0', '1531800410');
INSERT INTO `ey_channeltype` VALUES ('8', 'guestbook', '留言模型', '留言', 'guestbook', 'Guestbook', '1', '1', '1', '1', '1', '', '0', '8', '1509197711', '1531800410');
INSERT INTO `ey_channeltype` VALUES ('6', 'single', '单页模型', '单页', 'single', 'Single', '1', '1', '1', '1', '1', '', '0', '6', '1523091961', '1531800410');
INSERT INTO `ey_channeltype` VALUES ('3', 'images', '图集模型', '图集', 'images', 'Images', '1', '1', '1', '1', '1', '', '0', '3', '1523929121', '1531800410');
INSERT INTO `ey_channeltype` VALUES ('5', 'media', '视频模型', '视频', 'media', 'Media', '0', '1', '1', '1', '1', '', '0', '5', '1509197711', '1564532747');
INSERT INTO `ey_channeltype` VALUES ('7', 'special', '专题模型', '专题', 'special', 'Special', '0', '1', '1', '1', '1', '', '0', '7', '1509197711', '1564532747');
INSERT INTO `ey_channeltype` VALUES ('51', 'ask', '问答模型', '问答', 'ask', 'Ask', '0', '1', '1', '1', '1', '', '1', '9', '1509197711', '1713172677');

-- -----------------------------
-- Table structure for `ey_citysite`
-- -----------------------------
DROP TABLE IF EXISTS `ey_citysite`;
CREATE TABLE `ey_citysite` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '表id',
  `name` varchar(32) DEFAULT '' COMMENT '地区名称',
  `level` tinyint(4) DEFAULT '0' COMMENT '地区等级 分省市县区',
  `parent_id` int(10) DEFAULT '0' COMMENT '父id',
  `topid` int(10) DEFAULT '0' COMMENT '顶级ID',
  `initial` varchar(5) DEFAULT '' COMMENT '首字母',
  `status` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '状态（1：开启，0：隐藏）',
  `is_hot` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否热门',
  `domain` varchar(50) NOT NULL DEFAULT '' COMMENT '二级域名',
  `is_open` tinyint(1) DEFAULT '0' COMMENT '二级域名开启状态，0=否，1=是',
  `seoset` tinyint(1) DEFAULT '0' COMMENT 'SEO设置，0=使用主站，1=自定义',
  `seo_title` varchar(200) DEFAULT '' COMMENT 'SEO标题',
  `seo_keywords` varchar(200) DEFAULT '' COMMENT 'SEO关键词',
  `seo_description` text COMMENT 'SEO描述',
  `sort_order` int(6) unsigned NOT NULL DEFAULT '100' COMMENT '排序',
  `add_time` int(11) NOT NULL DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) NOT NULL DEFAULT '0' COMMENT '更新时间',
  `showall` tinyint(3) DEFAULT '1' COMMENT '是否显示主站信息',
  PRIMARY KEY (`id`),
  KEY `domain` (`domain`) USING BTREE,
  KEY `level` (`level`,`status`) USING BTREE,
  KEY `initial` (`initial`,`sort_order`,`id`) USING BTREE,
  KEY `parent_id` (`parent_id`,`status`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='城市分站表';


-- -----------------------------
-- Table structure for `ey_common_pic`
-- -----------------------------
DROP TABLE IF EXISTS `ey_common_pic`;
CREATE TABLE `ey_common_pic` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '常用图片ID',
  `pic_path` varchar(255) NOT NULL DEFAULT '' COMMENT '图片地址',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '多语言',
  `add_time` int(11) NOT NULL DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=26 DEFAULT CHARSET=utf8 COMMENT='常用图片';

-- -----------------------------
-- Records of `ey_common_pic`
-- -----------------------------
INSERT INTO `ey_common_pic` VALUES ('1', '/eyou/uploads/allimg/20220411/1-2204110UAIB.png', 'cn', '1649638619', '1649638619');
INSERT INTO `ey_common_pic` VALUES ('2', '/eyou/uploads/allimg/161108/1-16110Q422500-L.jpg', 'cn', '1649642884', '1649642884');
INSERT INTO `ey_common_pic` VALUES ('3', '/eyou/uploads/allimg/161108/1-16110Q422380-L.jpg', 'cn', '1649642884', '1649642884');
INSERT INTO `ey_common_pic` VALUES ('4', '/eyou/uploads/allimg/161110/1-1611101014080-L.jpg', 'cn', '1649645284', '1649645284');
INSERT INTO `ey_common_pic` VALUES ('5', '/eyou/uploads/allimg/161110/1-1611101013520-L.jpg', 'cn', '1649645284', '1649645284');
INSERT INTO `ey_common_pic` VALUES ('6', '/eyou/uploads/allimg/161110/1-1611101013360-L.jpg', 'cn', '1649645284', '1649645284');
INSERT INTO `ey_common_pic` VALUES ('7', '/eyou/uploads/161110/1-16111010131U49.jpg', 'cn', '1649645328', '1649645328');
INSERT INTO `ey_common_pic` VALUES ('8', '/eyou/uploads/161110/1-1611101012593I.jpg', 'cn', '1649645328', '1649645328');
INSERT INTO `ey_common_pic` VALUES ('9', '/eyou/uploads/161110/1-161110101235226.jpg', 'cn', '1649645328', '1649645328');
INSERT INTO `ey_common_pic` VALUES ('10', '/eyou/uploads/allimg/20220411/1-220411105201X8.jpg', 'cn', '1649645523', '1649645523');
INSERT INTO `ey_common_pic` VALUES ('17', '/eyou/uploads/allimg/20220411/1-220411111311316.jpg', 'en', '1649670678', '1649670678');
INSERT INTO `ey_common_pic` VALUES ('18', '/eyou/uploads/allimg/20220411/1-220411144925449.jpg', 'en', '1649670686', '1649670686');
INSERT INTO `ey_common_pic` VALUES ('22', '/eyou/uploads/allimg/20220411/1-2204111515033H.jpg', 'en', '1649670727', '1649670727');
INSERT INTO `ey_common_pic` VALUES ('20', '/eyou/uploads/allimg/20220411/1-220411151525G1.jpg', 'en', '1649670708', '1649670708');
INSERT INTO `ey_common_pic` VALUES ('21', '/eyou/uploads/allimg/20220411/1-22041115332a00.jpg', 'en', '1649670716', '1649670716');
INSERT INTO `ey_common_pic` VALUES ('23', '/eyou/uploads/allimg/20220411/1-2204111R546317.png', 'en', '1649672747', '1649672747');
INSERT INTO `ey_common_pic` VALUES ('24', '/eyou/uploads/allimg/20220411/1-2204111RS0264.png', 'en', '1649672912', '1649672912');
INSERT INTO `ey_common_pic` VALUES ('25', '/eyou/uploads/allimg/20220411/1-2204111R910354.png', 'en', '1649672958', '1649672958');

-- -----------------------------
-- Table structure for `ey_config`
-- -----------------------------
DROP TABLE IF EXISTS `ey_config`;
CREATE TABLE `ey_config` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) DEFAULT '' COMMENT '配置的key键名',
  `value` text,
  `inc_type` varchar(64) DEFAULT '' COMMENT '配置分组',
  `desc` varchar(50) DEFAULT '' COMMENT '描述',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `is_del` tinyint(1) DEFAULT '0' COMMENT '是否已删除，0=否，1=是',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=405 DEFAULT CHARSET=utf8 COMMENT='系统配置表';

-- -----------------------------
-- Records of `ey_config`
-- -----------------------------
INSERT INTO `ey_config` VALUES ('1', 'is_mark', '0', 'water', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('2', 'mark_txt', '易优Cms', 'water', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('3', 'mark_img', '/public/upload/water/2018/05/08/93806077e5a4c4e12ceed30df5cde761.png', 'water', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('4', 'mark_width', '200', 'water', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('5', 'mark_height', '50', 'water', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('6', 'mark_degree', '54', 'water', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('7', 'mark_quality', '56', 'water', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('8', 'mark_sel', '9', 'water', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('9', 'sms_time_out', '120', 'sms', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('10', 'theme_style', '1', 'basic', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('11', 'file_size', '100', 'basic', '', 'cn', '0', '1649673833');
INSERT INTO `ey_config` VALUES ('12', 'image_type', '', 'basic', '', 'cn', '0', '1649673602');
INSERT INTO `ey_config` VALUES ('13', 'file_type', '', 'basic', '', 'cn', '0', '1649673602');
INSERT INTO `ey_config` VALUES ('14', 'media_type', '', 'basic', '', 'cn', '0', '1649673602');
INSERT INTO `ey_config` VALUES ('15', 'web_keywords', '', 'web', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('17', 'sms_platform', '1', 'sms', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('18', 'seo_viewtitle_format', '2', 'seo', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('19', 'smtp_server', 'smtp.qq.com', 'smtp', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('20', 'smtp_port', '25', 'smtp', '', 'cn', '0', '1649638272');
INSERT INTO `ey_config` VALUES ('21', 'smtp_user', 'desdev@vip.qq.com', 'smtp', '', 'cn', '0', '1649638272');
INSERT INTO `ey_config` VALUES ('22', 'smtp_pwd', '7260444huxiao', 'smtp', '', 'cn', '0', '1649638272');
INSERT INTO `ey_config` VALUES ('23', 'inc_type', 'smtp', 'smtp', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('24', 'mark_type', 'img', 'water', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('25', 'mark_txt_size', '30', 'water', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('26', 'mark_txt_color', '#000000', 'water', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('27', 'oss_switch', '0', 'oss', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('28', 'web_name', '响应式中英双语茶叶茶道网站模板', 'web', '', 'cn', '0', '1649638607');
INSERT INTO `ey_config` VALUES ('29', 'web_logo', '/uploads/allimg/20220411/1-2204110UAIB.png', 'web', '', 'cn', '0', '1713172730');
INSERT INTO `ey_config` VALUES ('30', 'web_ico', '/favicon.ico', 'web', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('31', 'web_basehost', 'http://yy.eyou.hk', 'web', '', 'cn', '0', '1649638557');
INSERT INTO `ey_config` VALUES ('32', 'web_description', '', 'web', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('79', 'web_recordnum', 'ICP备********号', 'web', '', 'cn', '0', '1649638272');
INSERT INTO `ey_config` VALUES ('33', 'web_copyright', 'Copyright © 2014-2024 某某茶叶有限公司 版权所有', 'web', '', 'cn', '0', '1713172730');
INSERT INTO `ey_config` VALUES ('34', 'web_thirdcode_pc', '', 'web', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('35', 'web_thirdcode_wap', '', 'web', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('39', 'seo_arcdir', '/html', 'seo', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('40', 'seo_pseudo', '1', 'seo', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('41', 'list_symbol', '>', 'basic', '', 'cn', '0', '1649638272');
INSERT INTO `ey_config` VALUES ('42', 'sitemap_auto', '1', 'sitemap', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('43', 'sitemap_not1', '0', 'sitemap', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('44', 'sitemap_not2', '1', 'sitemap', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('45', 'sitemap_xml', '1', 'sitemap', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('46', 'sitemap_txt', '0', 'sitemap', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('47', 'sitemap_zzbaidutoken', '', 'sitemap', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('48', 'seo_expires_in', '7200', 'seo', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('55', 'web_title', '响应式中英双语茶叶茶道网站模板', 'web', '', 'cn', '0', '1649638607');
INSERT INTO `ey_config` VALUES ('56', 'smtp_test_eamil', 'xxxxxxxx@qq.com', 'smtp', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('57', 'web_authortoken', '1b41ffe0a29e06c62fc79356f4a58bbe', 'web', '', 'cn', '0', '1713172643');
INSERT INTO `ey_config` VALUES ('62', 'seo_inlet', '1', 'seo', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('63', 'web_cmspath', '', 'web', '', 'cn', '0', '1649638228');
INSERT INTO `ey_config` VALUES ('64', 'web_sqldatapath', '/data/sqldata_gzih9sD8CeJLmxCtSJdE', 'web', '', 'cn', '0', '1721264813');
INSERT INTO `ey_config` VALUES ('65', 'web_cmsurl', '', 'web', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('66', 'web_templets_dir', '/template', 'web', '', 'cn', '0', '1649638561');
INSERT INTO `ey_config` VALUES ('67', 'web_templeturl', '/template', 'web', '', 'cn', '0', '1649638561');
INSERT INTO `ey_config` VALUES ('68', 'web_templets_pc', '/template/pc', 'web', '', 'cn', '0', '1649638561');
INSERT INTO `ey_config` VALUES ('69', 'web_templets_m', '/template/mobile', 'web', '', 'cn', '0', '1649638561');
INSERT INTO `ey_config` VALUES ('70', 'web_eyoucms', 'http://www.eyoucms.com', 'web', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('78', '_cmscopyright', 'jdFbzvsEHAAzE6PfTTropP7s', 'php', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('76', 'seo_liststitle_format', '2', 'seo', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('77', 'web_status', '0', 'web', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('80', 'web_is_authortoken', '0', 'web', '', 'cn', '0', '1713172646');
INSERT INTO `ey_config` VALUES ('81', 'web_adminbasefile', '/login.php', 'web', '', 'cn', '0', '1668480395');
INSERT INTO `ey_config` VALUES ('82', 'seo_rewrite_format', '1', 'seo', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('83', 'web_cmsmode', '2', 'web', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('84', 'web_htmlcache_expires_in', '7200', 'web', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('85', 'web_show_popup_upgrade', '1', 'web', '', 'cn', '0', '1713172574');
INSERT INTO `ey_config` VALUES ('86', 'web_weapp_switch', '-1', 'web', '', 'cn', '0', '1649638531');
INSERT INTO `ey_config` VALUES ('88', 'seo_dynamic_format', '1', 'seo', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('89', 'system_sql_mode', 'ONLY_FULL_GROUP_BY,STRICT_TRANS_TABLES,NO_ZERO_IN_DATE,NO_ZERO_DATE,ERROR_FOR_DIVISION_BY_ZERO,NO_AUTO_CREATE_USER,NO_ENGINE_SUBSTITUTION', 'system', '', 'cn', '0', '1668480394');
INSERT INTO `ey_config` VALUES ('90', 'system_home_default_lang', 'cn', 'system', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('91', 'system_langnum', '2', 'system', '', 'cn', '0', '1649638737');
INSERT INTO `ey_config` VALUES ('92', 'system_auth_code', 'tpAfUYRaQXt1c0gbyM3T', 'system', '', 'cn', '0', '1611053262');
INSERT INTO `ey_config` VALUES ('93', 'system_robots_edit', '1', 'system', '', 'cn', '0', '1611053268');
INSERT INTO `ey_config` VALUES ('94', 'system_synleveldata', '1', 'system', '', 'cn', '0', '1611053268');
INSERT INTO `ey_config` VALUES ('95', 'system_upgrade_filelist', 'Y29yZS9oZWxwZXIucGhwPGJyPmNvcmUvbGlicmFyeS90aGluay9CYWNrdXAucGhwPGJyPmNvcmUvbGlicmFyeS90aGluay9iZWhhdmlvci9hZG1pbi9WYWxpZGF0ZUJlaGF2aW9yLnBocDxicj5jb3JlL2xpYnJhcnkvdGhpbmsvY29uc29sZS9vdXRwdXQvRGVzY3JpcHRvci5waHA8YnI+Y29yZS9saWJyYXJ5L3RoaW5rL2NvbnNvbGUvb3V0cHV0L0Fzay5waHA8YnI+Y29yZS9saWJyYXJ5L3RoaW5rL2xvZy9kcml2ZXIvRmlsZS5waHA8YnI+Y29yZS9saWJyYXJ5L3RoaW5rL0xhbmcucGhwPGJyPmNvcmUvbGlicmFyeS90aGluay9SZXF1ZXN0LnBocDxicj5jb3JlL2xpYnJhcnkvdGhpbmsvdGVtcGxhdGUvdGFnbGliL0V5b3UucGhwPGJyPmNvcmUvbGlicmFyeS90aGluay90ZW1wbGF0ZS90YWdsaWIvYXBpL1RhZ0xpc3QucGhwPGJyPmNvcmUvbGlicmFyeS90aGluay90ZW1wbGF0ZS90YWdsaWIvYXBpL0Jhc2UucGhwPGJyPmNvcmUvbGlicmFyeS90aGluay90ZW1wbGF0ZS90YWdsaWIvYXBpL1RhZ1NlYXJjaC5waHA8YnI+Y29yZS9saWJyYXJ5L3RoaW5rL3RlbXBsYXRlL3RhZ2xpYi9hcGkvVGFnQXJjbGlzdC5waHA8YnI+Y29yZS9saWJyYXJ5L3RoaW5rL3RlbXBsYXRlL3RhZ2xpYi9leW91L1RhZ0FkLnBocDxicj5jb3JlL2xpYnJhcnkvdGhpbmsvdGVtcGxhdGUvdGFnbGliL2V5b3UvVGFnU3RhdGljLnBocDxicj5jb3JlL2xpYnJhcnkvdGhpbmsvdGVtcGxhdGUvdGFnbGliL2V5b3UvVGFnU3BvcmRlci5waHA8YnI+Y29yZS9saWJyYXJ5L3RoaW5rL3RlbXBsYXRlL3RhZ2xpYi9leW91L1RhZ0F0dHJpYnV0ZS5waHA8YnI+Y29yZS9saWJyYXJ5L3RoaW5rL3RlbXBsYXRlL3RhZ2xpYi9leW91L1RhZ0d1ZXN0Ym9va2Zvcm0ucGhwPGJyPmNvcmUvbGlicmFyeS90aGluay90ZW1wbGF0ZS90YWdsaWIvZXlvdS9UYWdGaWVsZC5waHA8YnI+Y29yZS9saWJyYXJ5L3RoaW5rL3RlbXBsYXRlL3RhZ2xpYi9leW91L1RhZ0hvdHdvcmRzLnBocDxicj5jb3JlL2xpYnJhcnkvdGhpbmsvdGVtcGxhdGUvdGFnbGliL2V5b3UvVGFnVXNlci5waHA8YnI+Y29yZS9saWJyYXJ5L3RoaW5rL3RlbXBsYXRlL3RhZ2xpYi9leW91L1RhZ1Nwb3JkZXJsaXN0LnBocDxicj5jb3JlL2xpYnJhcnkvdGhpbmsvcHJvY2Vzcy9waXBlcy9XaW5kb3dzLnBocDxicj5jb3JlL2xpYnJhcnkvdGhpbmsvcHJvY2Vzcy9iaHZjb3JlL0JodnVzZXJBQmVnaW4ucGhwPGJyPmNvcmUvbGlicmFyeS90aGluay9wcm9jZXNzL2JodmNvcmUvQmh2YWRtaW5BRW5kLnBocDxicj5jb3JlL2xpYnJhcnkvdGhpbmsvcHJvY2Vzcy9iaHZjb3JlL0JodmhvbWVNSW5pdC5waHA8YnI+Y29yZS9saWJyYXJ5L3RoaW5rL3Byb2Nlc3MvYmh2Y29yZS9CaHZhZG1pbk1Jbml0LnBocDxicj5jb3JlL2xpYnJhcnkvdGhpbmsvcHJvY2Vzcy9iaHZjb3JlL0JodmFkbWluQUJlZ2luLnBocDxicj5jb3JlL2xpYnJhcnkvdGhpbmsvQ29udHJvbGxlci5waHA8YnI+Y29yZS9saWJyYXJ5L3RoaW5rL3Nlc3Npb24vZHJpdmVyL1JlZGlzLnBocDxicj5jb3JlL2xpYnJhcnkvdGhpbmsvY2FjaGUvZHJpdmVyL1JlZGlzLnBocDxicj5jb3JlL2xpYnJhcnkvdGhpbmsvZGIvUXVlcnkucGhwPGJyPmNvcmUvbGlicmFyeS90aGluay9kYi9kcml2ZXIvRHJpdmVyLnBocDxicj5jb3JlL2xpYnJhcnkvdGhpbmsvZGIvQnVpbGRlci5waHA8YnI+YXBwbGljYXRpb24vaG9tZS9iZWhhdmlvci9WaWV3RmlsdGVyQmVoYXZpb3IucGhwPGJyPmFwcGxpY2F0aW9uL2hvbWUvbW9kZWwvQXNrLnBocDxicj5hcHBsaWNhdGlvbi9ob21lL2xvZ2ljL0ZpZWxkTG9naWMucGhwPGJyPmFwcGxpY2F0aW9uL2hvbWUvY29udHJvbGxlci9CdWlsZGh0bWwucGhwPGJyPmFwcGxpY2F0aW9uL2hvbWUvY29udHJvbGxlci9WaWV3LnBocDxicj5hcHBsaWNhdGlvbi9ob21lL2NvbnRyb2xsZXIvQmFzZS5waHA8YnI+YXBwbGljYXRpb24vaG9tZS9jb250cm9sbGVyL0FqYXgucGhwPGJyPmFwcGxpY2F0aW9uL2hvbWUvY29udHJvbGxlci9JbmRleC5waHA8YnI+YXBwbGljYXRpb24vcm91dGUucGhwPGJyPmFwcGxpY2F0aW9uL2Z1bmN0aW9uLnBocDxicj5hcHBsaWNhdGlvbi9hcGkvbW9kZWwvdjEvUG9zdGVyLnBocDxicj5hcHBsaWNhdGlvbi9hcGkvbW9kZWwvdjEvVXNlci5waHA8YnI+YXBwbGljYXRpb24vYXBpL21vZGVsL3YxL1Nob3AucGhwPGJyPmFwcGxpY2F0aW9uL2FwaS9tb2RlbC92MS9BcGkucGhwPGJyPmFwcGxpY2F0aW9uL2FwaS9tb2RlbC92MS9CYXNlLnBocDxicj5hcHBsaWNhdGlvbi9hcGkvbW9kZWwvdjEvQXNrLnBocDxicj5hcHBsaWNhdGlvbi9hcGkvY29tbW9uLnBocDxicj5hcHBsaWNhdGlvbi9hcGkvbG9naWMvdjEvQXBpTG9naWMucGhwPGJyPmFwcGxpY2F0aW9uL2FwaS9sb2dpYy92MS9XZWNoYXRMb2dpYy5waHA8YnI+YXBwbGljYXRpb24vYXBpL2NvbnRyb2xsZXIvRGl5YWpheC5waHA8YnI+YXBwbGljYXRpb24vYXBpL2NvbnRyb2xsZXIvdjEvVXNlcnMucGhw', 'system', '', 'cn', '0', '1721264812');
INSERT INTO `ey_config` VALUES ('387', 'seo_uphtml_after_home13', '1', 'seo', '', 'cn', '0', '1713172699');
INSERT INTO `ey_config` VALUES ('388', 'seo_uphtml_after_channel13', '1', 'seo', '', 'cn', '0', '1713172699');
INSERT INTO `ey_config` VALUES ('385', 'web_theme_styleid', '100', 'web', '', 'cn', '0', '1713172677');
INSERT INTO `ey_config` VALUES ('386', 'web_theme_styleid', '100', 'web', '', 'en', '0', '1713172677');
INSERT INTO `ey_config` VALUES ('371', 'php_websensitive', '5aix5LmQfOWNmuW9qXzkuJbnlYzmna985aSc5bqXfOi1jOWNmnzmnqrmlK986aOO5pq0fGJvYnzmirzms6h8OyZhbXA7I3xh54mHfOWkp+eJh3zmrKfnvo58KOS4reWbvSl877yI5Lit5Zu977yJfOWNiuWym8K35L2T6IKy', 'php', '', 'cn', '0', '1713172646');
INSERT INTO `ey_config` VALUES ('381', 'web_anti_brushing', '0', 'web', '', 'cn', '0', '1713172632');
INSERT INTO `ey_config` VALUES ('382', 'web_anti_brushing', '0', 'web', '', 'en', '0', '1713172632');
INSERT INTO `ey_config` VALUES ('369', 'absolute_path_open', '0', 'web', '', 'cn', '0', '1713172574');
INSERT INTO `ey_config` VALUES ('370', 'absolute_path_open', '0', 'web', '', 'en', '0', '1713172574');
INSERT INTO `ey_config` VALUES ('372', 'php_atqueryrequest', 'eyIwIjp7ImV4cGlyZV90aW1lIjoyNTkyMDAwfSwiMSI6eyJleHBpcmVfdGltZSI6MTI5NjAwMH0sIjEuNSI6eyJleHBpcmVfdGltZSI6MTI5NjAwMH0sIjIiOnsiZXhwaXJlX3RpbWUiOjEyOTYwMDB9fQ==', 'php', '', 'cn', '0', '1713172628');
INSERT INTO `ey_config` VALUES ('373', 'php_websensitive', '5aix5LmQfOWNmuW9qXzkuJbnlYzmna985aSc5bqXfOi1jOWNmnzmnqrmlK986aOO5pq0fGJvYnzmirzms6h8OyZhbXA7I3xh54mHfOWkp+eJh3zmrKfnvo58KOS4reWbvSl877yI5Lit5Zu977yJfOWNiuWym8K35L2T6IKy', 'php', '', 'en', '0', '1713172646');
INSERT INTO `ey_config` VALUES ('379', 'search_tabu_words', '<\r\n>\r\n\"\r\n;\r\n,\r\n@\r\n&\r\n#\r\n\\\r\n*', 'search', '', 'cn', '0', '1713172632');
INSERT INTO `ey_config` VALUES ('380', 'search_tabu_words', '<\r\n>\r\n\"\r\n;\r\n,\r\n@\r\n&\r\n#\r\n\\\r\n*', 'search', '', 'en', '0', '1713172632');
INSERT INTO `ey_config` VALUES ('374', 'php_atqueryrequest', 'eyIwIjp7ImV4cGlyZV90aW1lIjoyNTkyMDAwfSwiMSI6eyJleHBpcmVfdGltZSI6MTI5NjAwMH0sIjEuNSI6eyJleHBpcmVfdGltZSI6MTI5NjAwMH0sIjIiOnsiZXhwaXJlX3RpbWUiOjEyOTYwMDB9fQ==', 'php', '', 'en', '0', '1713172628');
INSERT INTO `ey_config` VALUES ('375', 'php_allow_service_os', 'eyJjb2RlIjoxLCJtc2ciOiJcdTY4YzBcdTZkNGJcdTUyMzBcdTY1YjBcdTcyNDhcdTY3MmMiLCJtc2cxIjoiXHU1NTQ2XHU3NTI4XHU3MjQ4XHU2NzJjXHU2NTJmXHU2MzAxXHU1NzI4XHU3ZWJmXHU2NmY0XHU2NWIwIn0=', 'php', '', 'cn', '0', '1713172628');
INSERT INTO `ey_config` VALUES ('376', 'php_atqueryrequest_time', '0', 'php', '', 'cn', '0', '1721264903');
INSERT INTO `ey_config` VALUES ('377', 'php_allow_service_os', 'eyJjb2RlIjoxLCJtc2ciOiJcdTY4YzBcdTZkNGJcdTUyMzBcdTY1YjBcdTcyNDhcdTY3MmMiLCJtc2cxIjoiXHU1NTQ2XHU3NTI4XHU3MjQ4XHU2NzJjXHU2NTJmXHU2MzAxXHU1NzI4XHU3ZWJmXHU2NmY0XHU2NWIwIn0=', 'php', '', 'en', '0', '1713172628');
INSERT INTO `ey_config` VALUES ('378', 'php_atqueryrequest_time', '0', 'php', '', 'en', '0', '1721264903');
INSERT INTO `ey_config` VALUES ('383', 'php_atqueryrequest_time2', '0', 'php', '', 'cn', '0', '1721264903');
INSERT INTO `ey_config` VALUES ('384', 'php_atqueryrequest_time2', '0', 'php', '', 'en', '0', '1721264903');
INSERT INTO `ey_config` VALUES ('389', 'seo_uphtml_after_pernext13', '1', 'seo', '', 'cn', '0', '1713172699');
INSERT INTO `ey_config` VALUES ('390', 'seo_uphtml_after_home13', '1', 'seo', '', 'en', '0', '1713172699');
INSERT INTO `ey_config` VALUES ('391', 'seo_uphtml_after_channel13', '1', 'seo', '', 'en', '0', '1713172699');
INSERT INTO `ey_config` VALUES ('392', 'seo_uphtml_after_pernext13', '1', 'seo', '', 'en', '0', '1713172699');
INSERT INTO `ey_config` VALUES ('393', 'web_recycle_switch', '1', 'web', '', 'cn', '0', '1713172699');
INSERT INTO `ey_config` VALUES ('394', 'web_recycle_switch', '1', 'web', '', 'en', '0', '1713172699');
INSERT INTO `ey_config` VALUES ('395', 'seo_uphtml_editafter_home', '0', 'seo', '', 'cn', '0', '1713172723');
INSERT INTO `ey_config` VALUES ('396', 'seo_uphtml_editafter_channel', '0', 'seo', '', 'cn', '0', '1713172723');
INSERT INTO `ey_config` VALUES ('397', 'seo_uphtml_editafter_pernext', '1', 'seo', '', 'cn', '0', '1713172723');
INSERT INTO `ey_config` VALUES ('398', 'seo_uphtml_editafter_home', '0', 'seo', '', 'en', '0', '1713172723');
INSERT INTO `ey_config` VALUES ('399', 'seo_uphtml_editafter_channel', '0', 'seo', '', 'en', '0', '1713172723');
INSERT INTO `ey_config` VALUES ('400', 'seo_uphtml_editafter_pernext', '1', 'seo', '', 'en', '0', '1713172723');
INSERT INTO `ey_config` VALUES ('401', 'web_status_mode', '0', 'web', '', 'cn', '0', '1713172730');
INSERT INTO `ey_config` VALUES ('402', 'web_status_text', '网站暂时关闭，维护中……', 'web', '', 'cn', '0', '1713172730');
INSERT INTO `ey_config` VALUES ('150', 'seo_uphtml_after_home', '0', 'seo', '', 'cn', '0', '1641862059');
INSERT INTO `ey_config` VALUES ('151', 'seo_uphtml_after_channel', '1', 'seo', '', 'cn', '0', '1641862059');
INSERT INTO `ey_config` VALUES ('152', 'seo_uphtml_after_pernext', '1', 'seo', '', 'cn', '0', '1641862059');
INSERT INTO `ey_config` VALUES ('153', 'seo_html_templet', 'index.htm', 'seo', '', 'cn', '0', '1641862059');
INSERT INTO `ey_config` VALUES ('154', 'seo_html_position', '../index.html', 'seo', '', 'cn', '0', '1641862059');
INSERT INTO `ey_config` VALUES ('155', 'seo_showmod', '1', 'seo', '', 'cn', '0', '1641862059');
INSERT INTO `ey_config` VALUES ('156', 'seo_maxpagesize', '50', 'seo', '', 'cn', '0', '1641862059');
INSERT INTO `ey_config` VALUES ('157', 'seo_upnext', '1', 'seo', '', 'cn', '0', '1641862059');
INSERT INTO `ey_config` VALUES ('158', 'seo_pagesize', '20', 'seo', '', 'cn', '0', '1641862059');
INSERT INTO `ey_config` VALUES ('159', 'basic_img_auto_wh', '0', 'basic', '', 'cn', '0', '1641862059');
INSERT INTO `ey_config` VALUES ('160', 'basic_img_alt', '0', 'basic', '', 'cn', '0', '1641862059');
INSERT INTO `ey_config` VALUES ('161', 'basic_img_title', '0', 'basic', '', 'cn', '0', '1641862059');
INSERT INTO `ey_config` VALUES ('162', 'system_correctarctypedirpath', '1', 'system', '', 'cn', '0', '1641862070');
INSERT INTO `ey_config` VALUES ('96', 'smtp_syn_weapp', '1', 'smtp', '', 'cn', '0', '1611053270');
INSERT INTO `ey_config` VALUES ('111', 'syn_admin_logic_arctype_topid2', '1', 'syn', '', 'cn', '0', '1611055150');
INSERT INTO `ey_config` VALUES ('112', 'syn_admin_logic_check_oneself', '1', 'syn', '', 'cn', '0', '1611055150');
INSERT INTO `ey_config` VALUES ('113', 'syn_admin_logic_links_group', '1', 'syn', '', 'cn', '0', '1611055150');
INSERT INTO `ey_config` VALUES ('114', 'sms_type', '1', 'sms', '', 'cn', '0', '1611055150');
INSERT INTO `ey_config` VALUES ('115', 'syn_admin_logic_1608189503', '1', 'syn', '', 'cn', '0', '1611055150');
INSERT INTO `ey_config` VALUES ('116', 'download_select_servername', 'a:6:{i:0;s:12:\"立即下载\";i:1;s:15:\"本地服务器\";i:2;s:15:\"远程服务器\";i:3;s:12:\"百度网盘\";i:4;s:15:\"七牛云存储\";i:5;s:12:\"腾讯网盘\";}', 'download', '', 'cn', '0', '1611055150');
INSERT INTO `ey_config` VALUES ('117', 'syn_admin_logic_1608191377', '1', 'syn', '', 'cn', '0', '1611055150');
INSERT INTO `ey_config` VALUES ('118', 'system_paginate_pagesize', '20', 'system', '', 'cn', '0', '1611055150');
INSERT INTO `ey_config` VALUES ('119', 'web_theme_color', '#3398cc', 'web', '', 'cn', '0', '1611055150');
INSERT INTO `ey_config` VALUES ('120', 'web_assist_color', '#2189be', 'web', '', 'cn', '0', '1611055150');
INSERT INTO `ey_config` VALUES ('121', 'web_loginbgimg', '/public/static/admin/images/login-bg.jpg', 'web', '', 'cn', '0', '1611055150');
INSERT INTO `ey_config` VALUES ('122', 'syn_admin_logic_1609039608', '1', 'syn', '', 'cn', '0', '1611055150');
INSERT INTO `ey_config` VALUES ('123', 'syn_admin_logic_1609291091', '1', 'syn', '', 'cn', '0', '1611055150');
INSERT INTO `ey_config` VALUES ('124', 'admin_logic_1610086647', '1', 'syn', '', 'cn', '0', '1611055150');
INSERT INTO `ey_config` VALUES ('125', 'php_eyou_blacklist', '', 'php', '', 'cn', '0', '1611055155');
INSERT INTO `ey_config` VALUES ('126', 'php_serviceinfo', '24a8AwIBVFZWUwhWVgoGX18EA1QPAFVdB1oDBw1KExUABEVWXEINEg8VXURcEAEHD00AKltiBXdlLAgQYwhAOh8NQ3lQXwg/HA5WB18KAQc1VgAER2sFd1tTDypjf1wMHwtYQkBcCC1fWw4HKX0BFhcFUyF8RTpWSA8MF05cQlQNXnlKaFkGPidUcVUeWgFSC31TKWFYExNXKA1WTlxDKQMIQFwHCS8pNVdKAzFQQjUKDQJRT3pWdFsWUD9BCAZVHCxQfGV/DRMxGlVeLQEBKlRhAy99SkEUEAMQEVxeQwQMClNeQVZGXEQ/TV4EVAM6EwAHVQZvFg1QW105QQZXV1Q6QwdXAQY6E1teUQJuQVIDBAY6QwcGCVM+EFIGBQk+EFAFCwptEVBRVws6EwQBXlFpQFJTVVVkRwQDVQUTHUAEE0JbXUMJFQFSGlxEbkFeBFAAOkMGUQFUPhBdBFdVPhBSU1AHbRFfUFYIOhMEB15eaUBQAQdQZEdXUgFSbURXUVZSb0dXAlZXQRREB0dADglHWBVRAUECED4QXVZUBD4QUwQKVG0RXlYFXDoTBlEFU2lAXwAGU2RHVgBUB21EVgBXV29HBlZSXj9NUFUKDDoTAwJSBW8WDQUGAzlBBAVSATpDVVQBVURKQVkTElpbFAtGUlcYBkECED4QXVZUBD4QUwQKVG0RXlYFXDoTBlEFU2lAXwAGU2RHVgBUB21EVgBXV29HBlZSXj9NUFUKDDoTAwJSBW8WDQUGAzlBBAVSATpDVVQBVURKQVkSF0dRFB9HUBdDVhBMEFhHAE14RisPFgF6X2dQBSEPQTwwCwQHMQRZL1xcGnZmCRwocHBGBDYRX35heFIDHylUAy5wRAULY1MCcV8XYmErUyhgeAQsDydBfnoBFy8MJk0oNXsCAx9/WQN+cRNbXzQDAXNdRTg2LwB+ZnhRKAwiTysuAkcvDHxcKVhACmJqChIEbHtdOlY0RlFlZA0pDCZBKTJrQysidwwAZw5eGh5ADAEWCwdORwJZXlNYCkRcQV0fCUcaDg0XGURVXAddEFhHVFYFAAQDAwZSAAgBVlAADlQAUQNfVQADAAJSVgBQAABHGBNUGhUPRFZBbg0IRFkISkRGRh8JQEE5QloOXRBYVUkWUl0NFgNpRFdTRlxWTxoRA1NEFjlFWRNRWg1nXRIACxYLAE5HFl9XEAtWSkQKSzkJXlBEXAUZREVHAkxHEUdfBR0TEg0WaVJeXQsRORBdFBBbVwM5WkZEDBEGQXgIB1dmXXgICh56cHhFB1QFCncPLFFQMj8BbBx0UAdsaAkrIn5SVTYwH3tJcFIAMj9SYQwkUVAyBUx7Il5QB2xrUSgIeVh9IS8SVQFRSS0MCQpgLjMDejI3B20uYwAtbHtWPS1hAnwINFJue2cDKhwsCWAuMwB6MixYbS5jAS5Ccxo9LWEAfxgsUm57ZwI+MSwOYC4zAHoLPwVtLmMBLW97FSwLBAwTHw', 'php', '', 'cn', '0', '1721264820');
INSERT INTO `ey_config` VALUES ('127', 'php_servicecode', '1b41ffe0a29e06c62fc79356f4a58bbe', 'php', '', 'cn', '0', '1713172628');
INSERT INTO `ey_config` VALUES ('109', 'syn_admin_logic_special_addfields', '5', 'syn', '', 'cn', '0', '1616293251');
INSERT INTO `ey_config` VALUES ('110', 'syn_admin_logic_session_conf', '1', 'syn', '', 'cn', '0', '1611055054');
INSERT INTO `ey_config` VALUES ('108', 'syn_admin_logic_users_download', '1', 'syn', '', 'cn', '0', '1611054964');
INSERT INTO `ey_config` VALUES ('105', 'syn_admin_logic_video_addfields', '5', 'syn', '', 'cn', '0', '1616293251');
INSERT INTO `ey_config` VALUES ('106', 'syn_admin_logic_add_tag', '1', 'syn', '', 'cn', '0', '1611054872');
INSERT INTO `ey_config` VALUES ('107', 'syn_admin_logic_users_parameter', '1', 'syn', '', 'cn', '0', '1611054872');
INSERT INTO `ey_config` VALUES ('99', 'syn_admin_logic_sms_template', '1', 'syn', '', 'cn', '0', '1611054772');
INSERT INTO `ey_config` VALUES ('100', 'php_weapp_plugin_open', '1', 'php', '', 'cn', '0', '1713172676');
INSERT INTO `ey_config` VALUES ('101', 'syn_admin_logic_unlink', '1', 'syn', '', 'cn', '0', '1611054772');
INSERT INTO `ey_config` VALUES ('102', 'syn_admin_logic_update_basic', '1', 'syn', '', 'cn', '0', '1611054772');
INSERT INTO `ey_config` VALUES ('103', 'syn_admin_logic_update_tag', '1', 'syn', '', 'cn', '0', '1611054772');
INSERT INTO `ey_config` VALUES ('104', 'syn_admin_logic_update_arctype', '1', 'syn', '', 'cn', '0', '1611054772');
INSERT INTO `ey_config` VALUES ('98', 'system_smtp_tpl_5', '1', 'system', '', 'cn', '0', '1611054608');
INSERT INTO `ey_config` VALUES ('97', 'syn_gb_attribute_showlist', '1', 'syn', '', 'cn', '0', '1611054521');
INSERT INTO `ey_config` VALUES ('128', 'other_arcclick', '500|1000', 'other', '', 'cn', '0', '1611057171');
INSERT INTO `ey_config` VALUES ('129', 'php_servicemeal', '2', 'php', '', 'cn', '0', '1713172628');
INSERT INTO `ey_config` VALUES ('130', 'syn_admin_logic_video_addfields_2', '1', 'syn', '', 'cn', '0', '1616293251');
INSERT INTO `ey_config` VALUES ('131', 'syn_admin_logic_1608884981_2', '1', 'syn', '', 'cn', '0', '1616293251');
INSERT INTO `ey_config` VALUES ('132', 'system_version', 'v1.6.7', 'system', '', 'cn', '0', '1721264819');
INSERT INTO `ey_config` VALUES ('133', 'syn_admin_logic_arctype_topid', '2', 'syn', '', 'cn', '0', '1616293292');
INSERT INTO `ey_config` VALUES ('134', 'syn_admin_logic_balance_pay', '1', 'syn', '', 'cn', '0', '1616293292');
INSERT INTO `ey_config` VALUES ('135', 'basic_img_style_wh', '0', 'basic', '', 'cn', '0', '1616293292');
INSERT INTO `ey_config` VALUES ('136', 'syn_admin_logic_1610086648', '1', 'syn', '', 'cn', '0', '1616293292');
INSERT INTO `ey_config` VALUES ('137', 'syn_admin_logic_1614829120', '1', 'syn', '', 'cn', '0', '1616293292');
INSERT INTO `ey_config` VALUES ('138', 'syn_admin_logic_1616123192', '1', 'syn', '', 'cn', '0', '1616293292');
INSERT INTO `ey_config` VALUES ('139', 'web_adminlogo', '', 'web', '', 'cn', '0', '1623814141');
INSERT INTO `ey_config` VALUES ('140', 'web_loginlogo', '', 'web', '', 'cn', '0', '1623814141');
INSERT INTO `ey_config` VALUES ('141', 'syn_admin_logic_1608884981', '1', 'syn', '', 'cn', '0', '1623814141');
INSERT INTO `ey_config` VALUES ('142', 'syn_admin_logic_1614829121', '1', 'syn', '', 'cn', '0', '1623814141');
INSERT INTO `ey_config` VALUES ('143', 'syn_admin_logic_ask_answer_like', '1', 'syn', '', 'cn', '0', '1623814141');
INSERT INTO `ey_config` VALUES ('144', 'syn_admin_logic_archives_1618279798', '1', 'syn', '', 'cn', '0', '1623814141');
INSERT INTO `ey_config` VALUES ('145', 'syn_admin_logic_1623036205', '1', 'syn', '', 'cn', '0', '1623814141');
INSERT INTO `ey_config` VALUES ('146', 'admin_logic_1623055490', '1', 'syn', '', 'cn', '0', '1623814141');
INSERT INTO `ey_config` VALUES ('147', 'system_use_language', '0', 'system', '', 'cn', '0', '1623814141');
INSERT INTO `ey_config` VALUES ('148', 'admin_logic_1623133485', '1', 'syn', '', 'cn', '0', '1623814141');
INSERT INTO `ey_config` VALUES ('149', 'other_pcwapjs', '0', 'other', '', 'cn', '0', '1639021937');
INSERT INTO `ey_config` VALUES ('163', 'system_crypt_auth_code', '$2y$11$2d9da8656debd311fc3628e', 'system', '', 'cn', '0', '1648864537');
INSERT INTO `ey_config` VALUES ('164', 'web_citysite_open', '0', 'web', '', 'cn', '0', '1648864596');
INSERT INTO `ey_config` VALUES ('165', 'admin_logic_1_1648775669', '1', 'syn', '', 'cn', '0', '1648864596');
INSERT INTO `ey_config` VALUES ('166', 'system_usecodelist', '505dUQlVBAIAAVMCAAABAwhcUAIBAAFSB1MDV1duElkFAFQ3eAZzZ2FaIGcBIXt2cX48JV99eCAIdy92BVJ3elBYNyMILHlzZnQ1Y2UpY2NcVyMkcWVhICFwIHIFd1V8YTQoNggVY2RbdzdhXANqdWYAKjJ2BGo1Ngc2cSR4emlfFQQmfz9tdgBrKWBhB3tvXEwrIgJiYSZVfDxwI11qfWY7PyJeVXxkcV0gdQAhe2Z1AQcgZUJsPktBVlYQflZpRxMyJlE5G1xnGjl5fFVoBXFSCQd5XEkHIgUURzdffl5TUylXch9bBWdCKmpkCERBYgE/C3dcWiEuXk5xMF9DcGYSOU56L154A2VRe3soWEFYeiQwemlhNzZWJ2QScGd6cSwgGXAuZ0pYcyVZBAdwX1hgNDBifWg3FGAhZBViYQllIDczWjNsVWp5MAJXKHdmCHAxIHp1eyVUcyFZGmNRfW4yICd0NHZeSHkhYHoUZVAJbyIwR3N7DTBYDGwlQlphWiYUVUsIQHNHaCJzSD16ZmlxMhEDEmQ', 'system', '', 'cn', '0', '1649638287');
INSERT INTO `ey_config` VALUES ('167', 'basic_indexname', '主页', 'basic', '', 'cn', '0', '1649638272');
INSERT INTO `ey_config` VALUES ('168', 'seo_html_arcdir', 'html', 'seo', '', 'cn', '0', '1713172505');
INSERT INTO `ey_config` VALUES ('169', 'seo_force_inlet', '0', 'seo', '', 'cn', '0', '1649638272');
INSERT INTO `ey_config` VALUES ('170', 'sitemap_archives_num', '100', 'sitemap', '', 'cn', '0', '1649638272');
INSERT INTO `ey_config` VALUES ('171', 'sitemap_tags_num', '200', 'sitemap', '', 'cn', '0', '1649638272');
INSERT INTO `ey_config` VALUES ('172', 'smtp_from_eamil', 'desdev@vip.qq.com', 'smtp', '', 'cn', '0', '1649638272');
INSERT INTO `ey_config` VALUES ('176', 'web_attr_4', '13988889999', 'web', '', 'cn', '0', '1649670111');
INSERT INTO `ey_config` VALUES ('367', 'max_sizeunit', 'MB', 'basic', '', 'en', '0', '1649673602');
INSERT INTO `ey_config` VALUES ('365', 'other_arcdownload', '500|1000', 'other', '', 'cn', '0', '1649673602');
INSERT INTO `ey_config` VALUES ('181', 'web_tpl_theme', '', 'web', '', 'cn', '0', '1649638561');
INSERT INTO `ey_config` VALUES ('182', 'web_language_switch', '0', 'web', '', 'cn', '0', '1721264897');
INSERT INTO `ey_config` VALUES ('192', 'is_mark', '0', 'water', '', 'en', '0', '0');
INSERT INTO `ey_config` VALUES ('183', 'web_status_url', '', 'web', '', 'cn', '0', '1649638557');
INSERT INTO `ey_config` VALUES ('184', 'web_status_tpl', 'http://e13.eyou.hk/public/close.html', 'web', '', 'cn', '0', '1713172677');
INSERT INTO `ey_config` VALUES ('185', 'web_recordnum_mode', '0', 'web', '', 'cn', '0', '1649638557');
INSERT INTO `ey_config` VALUES ('186', 'web_garecordnum', '', 'web', '', 'cn', '0', '1649638557');
INSERT INTO `ey_config` VALUES ('187', 'web_garecordnum_mode', '0', 'web', '', 'cn', '0', '1649638557');
INSERT INTO `ey_config` VALUES ('188', 'web_mobile_domain_open', '0', 'web', '', 'cn', '0', '1649638561');
INSERT INTO `ey_config` VALUES ('189', 'web_is_https', '0', 'web', '', 'cn', '0', '1649638561');
INSERT INTO `ey_config` VALUES ('190', 'recycle_switch', '1', 'web', '', 'cn', '0', '1649638567');
INSERT INTO `ey_config` VALUES ('191', 'web_stypeid_open', '0', 'web', '', 'cn', '0', '1649638561');
INSERT INTO `ey_config` VALUES ('193', 'mark_txt', '易优Cms', 'water', '', 'en', '0', '0');
INSERT INTO `ey_config` VALUES ('194', 'mark_img', '/public/upload/water/2018/05/08/93806077e5a4c4e12ceed30df5cde761.png', 'water', '', 'en', '0', '0');
INSERT INTO `ey_config` VALUES ('195', 'mark_width', '200', 'water', '', 'en', '0', '0');
INSERT INTO `ey_config` VALUES ('196', 'mark_height', '50', 'water', '', 'en', '0', '0');
INSERT INTO `ey_config` VALUES ('197', 'mark_degree', '54', 'water', '', 'en', '0', '0');
INSERT INTO `ey_config` VALUES ('198', 'mark_quality', '56', 'water', '', 'en', '0', '0');
INSERT INTO `ey_config` VALUES ('199', 'mark_sel', '9', 'water', '', 'en', '0', '0');
INSERT INTO `ey_config` VALUES ('200', 'sms_time_out', '120', 'sms', '', 'en', '0', '0');
INSERT INTO `ey_config` VALUES ('201', 'theme_style', '1', 'basic', '', 'en', '0', '0');
INSERT INTO `ey_config` VALUES ('202', 'file_size', '100', 'basic', '', 'en', '0', '1649673833');
INSERT INTO `ey_config` VALUES ('203', 'image_type', '', 'basic', '', 'en', '0', '1649673602');
INSERT INTO `ey_config` VALUES ('204', 'file_type', '', 'basic', '', 'en', '0', '1649673602');
INSERT INTO `ey_config` VALUES ('205', 'media_type', '', 'basic', '', 'en', '0', '1649673602');
INSERT INTO `ey_config` VALUES ('206', 'web_keywords', '', 'web', '', 'en', '0', '0');
INSERT INTO `ey_config` VALUES ('207', 'sms_platform', '1', 'sms', '', 'en', '0', '0');
INSERT INTO `ey_config` VALUES ('208', 'seo_viewtitle_format', '2', 'seo', '', 'en', '0', '0');
INSERT INTO `ey_config` VALUES ('209', 'smtp_server', 'smtp.qq.com', 'smtp', '', 'en', '0', '0');
INSERT INTO `ey_config` VALUES ('210', 'smtp_port', '25', 'smtp', '', 'en', '0', '1649638272');
INSERT INTO `ey_config` VALUES ('211', 'smtp_user', 'desdev@vip.qq.com', 'smtp', '', 'en', '0', '1649638272');
INSERT INTO `ey_config` VALUES ('212', 'smtp_pwd', '7260444huxiao', 'smtp', '', 'en', '0', '1649638272');
INSERT INTO `ey_config` VALUES ('213', 'inc_type', 'smtp', 'smtp', '', 'en', '0', '0');
INSERT INTO `ey_config` VALUES ('214', 'mark_type', 'img', 'water', '', 'en', '0', '0');
INSERT INTO `ey_config` VALUES ('215', 'mark_txt_size', '30', 'water', '', 'en', '0', '0');
INSERT INTO `ey_config` VALUES ('216', 'mark_txt_color', '#000000', 'water', '', 'en', '0', '0');
INSERT INTO `ey_config` VALUES ('217', 'oss_switch', '0', 'oss', '', 'en', '0', '0');
INSERT INTO `ey_config` VALUES ('218', 'web_name', '响应式中英双语茶叶茶道网站模板', 'web', '', 'en', '0', '1649669899');
INSERT INTO `ey_config` VALUES ('219', 'web_logo', '/eyou/uploads/allimg/20220411/1-2204111R910354.png', 'web', '', 'en', '0', '1649672960');
INSERT INTO `ey_config` VALUES ('220', 'web_ico', '/favicon.ico', 'web', '', 'en', '0', '0');
INSERT INTO `ey_config` VALUES ('221', 'web_basehost', 'http://yy.eyou.hk', 'web', '', 'en', '0', '1649638557');
INSERT INTO `ey_config` VALUES ('222', 'web_description', '', 'web', '', 'en', '0', '0');
INSERT INTO `ey_config` VALUES ('223', 'web_copyright', 'Copyright © 2014-2022 MouMouTea Company Limited All rights reserved', 'web', '', 'en', '0', '1649670056');
INSERT INTO `ey_config` VALUES ('224', 'web_thirdcode_pc', '', 'web', '', 'en', '0', '0');
INSERT INTO `ey_config` VALUES ('225', 'web_thirdcode_wap', '', 'web', '', 'en', '0', '0');
INSERT INTO `ey_config` VALUES ('226', 'seo_arcdir', '/html', 'seo', '', 'en', '0', '0');
INSERT INTO `ey_config` VALUES ('227', 'seo_pseudo', '1', 'seo', '', 'en', '0', '0');
INSERT INTO `ey_config` VALUES ('228', 'list_symbol', '>', 'basic', '', 'en', '0', '1649638272');
INSERT INTO `ey_config` VALUES ('229', 'sitemap_auto', '1', 'sitemap', '', 'en', '0', '0');
INSERT INTO `ey_config` VALUES ('230', 'sitemap_not1', '0', 'sitemap', '', 'en', '0', '0');
INSERT INTO `ey_config` VALUES ('231', 'sitemap_not2', '1', 'sitemap', '', 'en', '0', '0');
INSERT INTO `ey_config` VALUES ('232', 'sitemap_xml', '1', 'sitemap', '', 'en', '0', '0');
INSERT INTO `ey_config` VALUES ('233', 'sitemap_txt', '0', 'sitemap', '', 'en', '0', '0');
INSERT INTO `ey_config` VALUES ('234', 'sitemap_zzbaidutoken', '', 'sitemap', '', 'en', '0', '0');
INSERT INTO `ey_config` VALUES ('235', 'seo_expires_in', '7200', 'seo', '', 'en', '0', '0');
INSERT INTO `ey_config` VALUES ('236', 'web_title', '响应式中英双语茶叶茶道网站模板', 'web', '', 'en', '0', '1649638607');
INSERT INTO `ey_config` VALUES ('237', 'smtp_test_eamil', 'xxxxxxxx@qq.com', 'smtp', '', 'en', '0', '0');
INSERT INTO `ey_config` VALUES ('238', 'web_authortoken', '1b41ffe0a29e06c62fc79356f4a58bbe', 'web', '', 'en', '0', '1713172643');
INSERT INTO `ey_config` VALUES ('239', 'seo_inlet', '1', 'seo', '', 'en', '0', '0');
INSERT INTO `ey_config` VALUES ('240', 'web_cmspath', '', 'web', '', 'en', '0', '1649638228');
INSERT INTO `ey_config` VALUES ('241', 'web_sqldatapath', '/data/sqldata_gzih9sD8CeJLmxCtSJdE', 'web', '', 'en', '0', '1721264813');
INSERT INTO `ey_config` VALUES ('242', 'web_cmsurl', '', 'web', '', 'en', '0', '0');
INSERT INTO `ey_config` VALUES ('243', 'web_templets_dir', '/template', 'web', '', 'en', '0', '1649638561');
INSERT INTO `ey_config` VALUES ('244', 'web_templeturl', '/template', 'web', '', 'en', '0', '1649638561');
INSERT INTO `ey_config` VALUES ('245', 'web_templets_pc', '/template/pc', 'web', '', 'en', '0', '1649638561');
INSERT INTO `ey_config` VALUES ('246', 'web_templets_m', '/template/mobile', 'web', '', 'en', '0', '1649638561');
INSERT INTO `ey_config` VALUES ('247', 'web_eyoucms', 'http://www.eyoucms.com', 'web', '', 'en', '0', '0');
INSERT INTO `ey_config` VALUES ('248', 'seo_liststitle_format', '2', 'seo', '', 'en', '0', '0');
INSERT INTO `ey_config` VALUES ('249', 'web_status', '0', 'web', '', 'en', '0', '0');
INSERT INTO `ey_config` VALUES ('250', '_cmscopyright', 'jdFbzvsEHAAzE6PfTTropP7s', 'php', '', 'en', '0', '0');
INSERT INTO `ey_config` VALUES ('251', 'web_recordnum', 'ICP prepared ******** number', 'web', '', 'en', '0', '1649670056');
INSERT INTO `ey_config` VALUES ('252', 'web_is_authortoken', '0', 'web', '', 'en', '0', '1713172646');
INSERT INTO `ey_config` VALUES ('253', 'web_adminbasefile', '/login.php', 'web', '', 'en', '0', '1668480395');
INSERT INTO `ey_config` VALUES ('254', 'seo_rewrite_format', '1', 'seo', '', 'en', '0', '0');
INSERT INTO `ey_config` VALUES ('255', 'web_cmsmode', '2', 'web', '', 'en', '0', '0');
INSERT INTO `ey_config` VALUES ('256', 'web_htmlcache_expires_in', '7200', 'web', '', 'en', '0', '0');
INSERT INTO `ey_config` VALUES ('257', 'web_show_popup_upgrade', '1', 'web', '', 'en', '0', '1713172574');
INSERT INTO `ey_config` VALUES ('258', 'web_weapp_switch', '-1', 'web', '', 'en', '0', '1649638531');
INSERT INTO `ey_config` VALUES ('259', 'seo_dynamic_format', '1', 'seo', '', 'en', '0', '0');
INSERT INTO `ey_config` VALUES ('260', 'system_sql_mode', 'ONLY_FULL_GROUP_BY,STRICT_TRANS_TABLES,NO_ZERO_IN_DATE,NO_ZERO_DATE,ERROR_FOR_DIVISION_BY_ZERO,NO_AUTO_CREATE_USER,NO_ENGINE_SUBSTITUTION', 'system', '', 'en', '0', '1668480394');
INSERT INTO `ey_config` VALUES ('261', 'system_home_default_lang', 'cn', 'system', '', 'en', '0', '0');
INSERT INTO `ey_config` VALUES ('262', 'system_langnum', '2', 'system', '', 'en', '0', '1649638737');
INSERT INTO `ey_config` VALUES ('263', 'system_auth_code', 'tpAfUYRaQXt1c0gbyM3T', 'system', '', 'en', '0', '1611053262');
INSERT INTO `ey_config` VALUES ('264', 'system_robots_edit', '1', 'system', '', 'en', '0', '1611053268');
INSERT INTO `ey_config` VALUES ('265', 'system_synleveldata', '1', 'system', '', 'en', '0', '1611053268');
INSERT INTO `ey_config` VALUES ('266', 'system_upgrade_filelist', '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', 'system', '', 'en', '0', '1648864505');
INSERT INTO `ey_config` VALUES ('267', 'smtp_syn_weapp', '1', 'smtp', '', 'en', '0', '1611053270');
INSERT INTO `ey_config` VALUES ('268', 'syn_gb_attribute_showlist', '1', 'syn', '', 'en', '0', '1611054521');
INSERT INTO `ey_config` VALUES ('269', 'system_smtp_tpl_5', '1', 'system', '', 'en', '0', '1611054608');
INSERT INTO `ey_config` VALUES ('270', 'syn_admin_logic_sms_template', '1', 'syn', '', 'en', '0', '1611054772');
INSERT INTO `ey_config` VALUES ('271', 'php_weapp_plugin_open', '1', 'php', '', 'en', '0', '1713172676');
INSERT INTO `ey_config` VALUES ('272', 'syn_admin_logic_unlink', '1', 'syn', '', 'en', '0', '1611054772');
INSERT INTO `ey_config` VALUES ('273', 'syn_admin_logic_update_basic', '1', 'syn', '', 'en', '0', '1611054772');
INSERT INTO `ey_config` VALUES ('274', 'syn_admin_logic_update_tag', '1', 'syn', '', 'en', '0', '1611054772');
INSERT INTO `ey_config` VALUES ('275', 'syn_admin_logic_update_arctype', '1', 'syn', '', 'en', '0', '1611054772');
INSERT INTO `ey_config` VALUES ('276', 'syn_admin_logic_video_addfields', '5', 'syn', '', 'en', '0', '1616293251');
INSERT INTO `ey_config` VALUES ('277', 'syn_admin_logic_add_tag', '1', 'syn', '', 'en', '0', '1611054872');
INSERT INTO `ey_config` VALUES ('278', 'syn_admin_logic_users_parameter', '1', 'syn', '', 'en', '0', '1611054872');
INSERT INTO `ey_config` VALUES ('279', 'syn_admin_logic_users_download', '1', 'syn', '', 'en', '0', '1611054964');
INSERT INTO `ey_config` VALUES ('280', 'syn_admin_logic_special_addfields', '5', 'syn', '', 'en', '0', '1616293251');
INSERT INTO `ey_config` VALUES ('281', 'syn_admin_logic_session_conf', '1', 'syn', '', 'en', '0', '1611055054');
INSERT INTO `ey_config` VALUES ('282', 'syn_admin_logic_arctype_topid2', '1', 'syn', '', 'en', '0', '1611055150');
INSERT INTO `ey_config` VALUES ('283', 'syn_admin_logic_check_oneself', '1', 'syn', '', 'en', '0', '1611055150');
INSERT INTO `ey_config` VALUES ('284', 'syn_admin_logic_links_group', '1', 'syn', '', 'en', '0', '1611055150');
INSERT INTO `ey_config` VALUES ('285', 'sms_type', '1', 'sms', '', 'en', '0', '1611055150');
INSERT INTO `ey_config` VALUES ('286', 'syn_admin_logic_1608189503', '1', 'syn', '', 'en', '0', '1611055150');
INSERT INTO `ey_config` VALUES ('287', 'download_select_servername', 'a:6:{i:0;s:12:\"立即下载\";i:1;s:15:\"本地服务器\";i:2;s:15:\"远程服务器\";i:3;s:12:\"百度网盘\";i:4;s:15:\"七牛云存储\";i:5;s:12:\"腾讯网盘\";}', 'download', '', 'en', '0', '1611055150');
INSERT INTO `ey_config` VALUES ('288', 'syn_admin_logic_1608191377', '1', 'syn', '', 'en', '0', '1611055150');
INSERT INTO `ey_config` VALUES ('289', 'system_paginate_pagesize', '20', 'system', '', 'en', '0', '1611055150');
INSERT INTO `ey_config` VALUES ('290', 'web_theme_color', '#3398cc', 'web', '', 'en', '0', '1611055150');
INSERT INTO `ey_config` VALUES ('291', 'web_assist_color', '#2189be', 'web', '', 'en', '0', '1611055150');
INSERT INTO `ey_config` VALUES ('292', 'web_loginbgimg', '/public/static/admin/images/login-bg.jpg', 'web', '', 'en', '0', '1611055150');
INSERT INTO `ey_config` VALUES ('293', 'syn_admin_logic_1609039608', '1', 'syn', '', 'en', '0', '1611055150');
INSERT INTO `ey_config` VALUES ('294', 'syn_admin_logic_1609291091', '1', 'syn', '', 'en', '0', '1611055150');
INSERT INTO `ey_config` VALUES ('295', 'admin_logic_1610086647', '1', 'syn', '', 'en', '0', '1611055150');
INSERT INTO `ey_config` VALUES ('296', 'php_eyou_blacklist', '', 'php', '', 'en', '0', '1611055155');
INSERT INTO `ey_config` VALUES ('297', 'php_serviceinfo', '24a8AwIBVFZWUwhWVgoGX18EA1QPAFVdB1oDBw1KExUABEVWXEINEg8VXURcEAEHD00AKltiBXdlLAgQYwhAOh8NQ3lQXwg/HA5WB18KAQc1VgAER2sFd1tTDypjf1wMHwtYQkBcCC1fWw4HKX0BFhcFUyF8RTpWSA8MF05cQlQNXnlKaFkGPidUcVUeWgFSC31TKWFYExNXKA1WTlxDKQMIQFwHCS8pNVdKAzFQQjUKDQJRT3pWdFsWUD9BCAZVHCxQfGV/DRMxGlVeLQEBKlRhAy99SkEUEAMQEVxeQwQMClNeQVZGXEQ/TV4EVAM6EwAHVQZvFg1QW105QQZXV1Q6QwdXAQY6E1teUQJuQVIDBAY6QwcGCVM+EFIGBQk+EFAFCwptEVBRVws6EwQBXlFpQFJTVVVkRwQDVQUTHUAEE0JbXUMJFQFSGlxEbkFeBFAAOkMGUQFUPhBdBFdVPhBSU1AHbRFfUFYIOhMEB15eaUBQAQdQZEdXUgFSbURXUVZSb0dXAlZXQRREB0dADglHWBVRAUECED4QXVZUBD4QUwQKVG0RXlYFXDoTBlEFU2lAXwAGU2RHVgBUB21EVgBXV29HBlZSXj9NUFUKDDoTAwJSBW8WDQUGAzlBBAVSATpDVVQBVURKQVkTElpbFAtGUlcYBkECED4QXVZUBD4QUwQKVG0RXlYFXDoTBlEFU2lAXwAGU2RHVgBUB21EVgBXV29HBlZSXj9NUFUKDDoTAwJSBW8WDQUGAzlBBAVSATpDVVQBVURKQVkSF0dRFB9HUBdDVhBMEFhHAE14RisPFgF6X2dQBSEPQTwwCwQHMQRZL1xcGnZmCRwocHBGBDYRX35heFIDHylUAy5wRAULY1MCcV8XYmErUyhgeAQsDydBfnoBFy8MJk0oNXsCAx9/WQN+cRNbXzQDAXNdRTg2LwB+ZnhRKAwiTysuAkcvDHxcKVhACmJqChIEbHtdOlY0RlFlZA0pDCZBKTJrQysidwwAZw5eGh5ADAEWCwdORwJZXlNYCkRcQV0fCUcaDg0XGURVXAddEFhHVFYFAAQDAwZSAAgBVlAADlQAUQNfVQADAAJSVgBQAABHGBNUGhUPRFZBbg0IRFkISkRGRh8JQEE5QloOXRBYVUkWUl0NFgNpRFdTRlxWTxoRA1NEFjlFWRNRWg1nXRIACxYLAE5HFl9XEAtWSkQKSzkJXlBEXAUZREVHAkxHEUdfBR0TEg0WaVJeXQsRORBdFBBbVwM5WkZEDBEGQXgIB1dmXXgICh56cHhFB1QFCncPLFFQMj8BbBx0UAdsaAkrIn5SVTYwH3tJcFIAMj9SYQwkUVAyBUx7Il5QB2xrUSgIeVh9IS8SVQFRSS0MCQpgLjMDejI3B20uYwAtbHtWPS1hAnwINFJue2cDKhwsCWAuMwB6MixYbS5jAS5Ccxo9LWEAfxgsUm57ZwI+MSwOYC4zAHoLPwVtLmMBLW97FSwLBAwTHw', 'php', '', 'en', '0', '1721264820');
INSERT INTO `ey_config` VALUES ('298', 'php_servicecode', '1b41ffe0a29e06c62fc79356f4a58bbe', 'php', '', 'en', '0', '1713172628');
INSERT INTO `ey_config` VALUES ('299', 'other_arcclick', '500|1000', 'other', '', 'en', '0', '1611057171');
INSERT INTO `ey_config` VALUES ('300', 'php_servicemeal', '2', 'php', '', 'en', '0', '1713172628');
INSERT INTO `ey_config` VALUES ('301', 'syn_admin_logic_video_addfields_2', '1', 'syn', '', 'en', '0', '1616293251');
INSERT INTO `ey_config` VALUES ('302', 'syn_admin_logic_1608884981_2', '1', 'syn', '', 'en', '0', '1616293251');
INSERT INTO `ey_config` VALUES ('303', 'system_version', 'v1.6.7', 'system', '', 'en', '0', '1721264819');
INSERT INTO `ey_config` VALUES ('304', 'syn_admin_logic_arctype_topid', '2', 'syn', '', 'en', '0', '1616293292');
INSERT INTO `ey_config` VALUES ('305', 'syn_admin_logic_balance_pay', '1', 'syn', '', 'en', '0', '1616293292');
INSERT INTO `ey_config` VALUES ('306', 'basic_img_style_wh', '0', 'basic', '', 'en', '0', '1616293292');
INSERT INTO `ey_config` VALUES ('307', 'syn_admin_logic_1610086648', '1', 'syn', '', 'en', '0', '1616293292');
INSERT INTO `ey_config` VALUES ('308', 'syn_admin_logic_1614829120', '1', 'syn', '', 'en', '0', '1616293292');
INSERT INTO `ey_config` VALUES ('309', 'syn_admin_logic_1616123192', '1', 'syn', '', 'en', '0', '1616293292');
INSERT INTO `ey_config` VALUES ('310', 'web_adminlogo', '', 'web', '', 'en', '0', '1623814141');
INSERT INTO `ey_config` VALUES ('311', 'web_loginlogo', '', 'web', '', 'en', '0', '1623814141');
INSERT INTO `ey_config` VALUES ('312', 'syn_admin_logic_1608884981', '1', 'syn', '', 'en', '0', '1623814141');
INSERT INTO `ey_config` VALUES ('313', 'syn_admin_logic_1614829121', '1', 'syn', '', 'en', '0', '1623814141');
INSERT INTO `ey_config` VALUES ('314', 'syn_admin_logic_ask_answer_like', '1', 'syn', '', 'en', '0', '1623814141');
INSERT INTO `ey_config` VALUES ('315', 'syn_admin_logic_archives_1618279798', '1', 'syn', '', 'en', '0', '1623814141');
INSERT INTO `ey_config` VALUES ('316', 'syn_admin_logic_1623036205', '1', 'syn', '', 'en', '0', '1623814141');
INSERT INTO `ey_config` VALUES ('317', 'admin_logic_1623055490', '1', 'syn', '', 'en', '0', '1623814141');
INSERT INTO `ey_config` VALUES ('318', 'system_use_language', '0', 'system', '', 'en', '0', '1623814141');
INSERT INTO `ey_config` VALUES ('319', 'admin_logic_1623133485', '1', 'syn', '', 'en', '0', '1623814141');
INSERT INTO `ey_config` VALUES ('320', 'other_pcwapjs', '0', 'other', '', 'en', '0', '1639021937');
INSERT INTO `ey_config` VALUES ('321', 'seo_uphtml_after_home', '0', 'seo', '', 'en', '0', '1641862059');
INSERT INTO `ey_config` VALUES ('322', 'seo_uphtml_after_channel', '1', 'seo', '', 'en', '0', '1641862059');
INSERT INTO `ey_config` VALUES ('323', 'seo_uphtml_after_pernext', '1', 'seo', '', 'en', '0', '1641862059');
INSERT INTO `ey_config` VALUES ('324', 'seo_html_templet', 'index.htm', 'seo', '', 'en', '0', '1641862059');
INSERT INTO `ey_config` VALUES ('325', 'seo_html_position', '../index.html', 'seo', '', 'en', '0', '1641862059');
INSERT INTO `ey_config` VALUES ('326', 'seo_showmod', '1', 'seo', '', 'en', '0', '1641862059');
INSERT INTO `ey_config` VALUES ('327', 'seo_maxpagesize', '50', 'seo', '', 'en', '0', '1641862059');
INSERT INTO `ey_config` VALUES ('328', 'seo_upnext', '1', 'seo', '', 'en', '0', '1641862059');
INSERT INTO `ey_config` VALUES ('329', 'seo_pagesize', '20', 'seo', '', 'en', '0', '1641862059');
INSERT INTO `ey_config` VALUES ('330', 'basic_img_auto_wh', '0', 'basic', '', 'en', '0', '1641862059');
INSERT INTO `ey_config` VALUES ('331', 'basic_img_alt', '0', 'basic', '', 'en', '0', '1641862059');
INSERT INTO `ey_config` VALUES ('332', 'basic_img_title', '0', 'basic', '', 'en', '0', '1641862059');
INSERT INTO `ey_config` VALUES ('333', 'system_correctarctypedirpath', '1', 'system', '', 'en', '0', '1641862070');
INSERT INTO `ey_config` VALUES ('334', 'system_crypt_auth_code', '$2y$11$2d9da8656debd311fc3628e', 'system', '', 'en', '0', '1648864537');
INSERT INTO `ey_config` VALUES ('335', 'web_citysite_open', '0', 'web', '', 'en', '0', '1648864596');
INSERT INTO `ey_config` VALUES ('336', 'admin_logic_1_1648775669', '1', 'syn', '', 'en', '0', '1648864596');
INSERT INTO `ey_config` VALUES ('337', 'system_usecodelist', '505dUQlVBAIAAVMCAAABAwhcUAIBAAFSB1MDV1duElkFAFQ3eAZzZ2FaIGcBIXt2cX48JV99eCAIdy92BVJ3elBYNyMILHlzZnQ1Y2UpY2NcVyMkcWVhICFwIHIFd1V8YTQoNggVY2RbdzdhXANqdWYAKjJ2BGo1Ngc2cSR4emlfFQQmfz9tdgBrKWBhB3tvXEwrIgJiYSZVfDxwI11qfWY7PyJeVXxkcV0gdQAhe2Z1AQcgZUJsPktBVlYQflZpRxMyJlE5G1xnGjl5fFVoBXFSCQd5XEkHIgUURzdffl5TUylXch9bBWdCKmpkCERBYgE/C3dcWiEuXk5xMF9DcGYSOU56L154A2VRe3soWEFYeiQwemlhNzZWJ2QScGd6cSwgGXAuZ0pYcyVZBAdwX1hgNDBifWg3FGAhZBViYQllIDczWjNsVWp5MAJXKHdmCHAxIHp1eyVUcyFZGmNRfW4yICd0NHZeSHkhYHoUZVAJbyIwR3N7DTBYDGwlQlphWiYUVUsIQHNHaCJzSD16ZmlxMhEDEmQ', 'system', '', 'en', '0', '1649638287');
INSERT INTO `ey_config` VALUES ('338', 'basic_indexname', 'HOME', 'basic', '', 'en', '0', '1649673602');
INSERT INTO `ey_config` VALUES ('339', 'seo_html_arcdir', 'html', 'seo', '', 'en', '0', '1713172505');
INSERT INTO `ey_config` VALUES ('340', 'seo_force_inlet', '0', 'seo', '', 'en', '0', '1649638272');
INSERT INTO `ey_config` VALUES ('341', 'sitemap_archives_num', '100', 'sitemap', '', 'en', '0', '1649638272');
INSERT INTO `ey_config` VALUES ('342', 'sitemap_tags_num', '200', 'sitemap', '', 'en', '0', '1649638272');
INSERT INTO `ey_config` VALUES ('343', 'smtp_from_eamil', 'desdev@vip.qq.com', 'smtp', '', 'en', '0', '1649638272');
INSERT INTO `ey_config` VALUES ('347', 'web_attr_4', '13988889999', 'web', '', 'en', '0', '1649670126');
INSERT INTO `ey_config` VALUES ('368', 'other_arcdownload', '500|1000', 'other', '', 'en', '0', '1649673602');
INSERT INTO `ey_config` VALUES ('366', 'max_filesize', '100', 'basic', '', 'en', '0', '1649673602');
INSERT INTO `ey_config` VALUES ('364', 'max_sizeunit', 'MB', 'basic', '', 'cn', '0', '1649673602');
INSERT INTO `ey_config` VALUES ('363', 'max_filesize', '100', 'basic', '', 'cn', '0', '1649673602');
INSERT INTO `ey_config` VALUES ('352', 'web_tpl_theme', '', 'web', '', 'en', '0', '1649638561');
INSERT INTO `ey_config` VALUES ('353', 'web_language_switch', '0', 'web', '', 'en', '0', '1721264897');
INSERT INTO `ey_config` VALUES ('354', 'web_status_url', '', 'web', '', 'en', '0', '1649638557');
INSERT INTO `ey_config` VALUES ('355', 'web_status_tpl', 'http://e13.eyou.hk/public/close.html', 'web', '', 'en', '0', '1713172677');
INSERT INTO `ey_config` VALUES ('356', 'web_recordnum_mode', '0', 'web', '', 'en', '0', '1649638557');
INSERT INTO `ey_config` VALUES ('357', 'web_garecordnum', '', 'web', '', 'en', '0', '1649638557');
INSERT INTO `ey_config` VALUES ('358', 'web_garecordnum_mode', '0', 'web', '', 'en', '0', '1649638557');
INSERT INTO `ey_config` VALUES ('359', 'web_mobile_domain_open', '0', 'web', '', 'en', '0', '1649638561');
INSERT INTO `ey_config` VALUES ('360', 'web_is_https', '0', 'web', '', 'en', '0', '1649638561');
INSERT INTO `ey_config` VALUES ('361', 'recycle_switch', '1', 'web', '', 'en', '0', '1649638567');
INSERT INTO `ey_config` VALUES ('362', 'web_stypeid_open', '0', 'web', '', 'en', '0', '1649638561');
INSERT INTO `ey_config` VALUES ('403', 'wechat_push_notice_open', '0', 'wechat', '', 'cn', '0', '1721264855');
INSERT INTO `ey_config` VALUES ('404', 'wechat_push_notice_open', '0', 'wechat', '', 'en', '0', '1721264855');

-- -----------------------------
-- Table structure for `ey_config_attribute`
-- -----------------------------
DROP TABLE IF EXISTS `ey_config_attribute`;
CREATE TABLE `ey_config_attribute` (
  `attr_id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '表单id',
  `inc_type` varchar(20) DEFAULT '' COMMENT '变量分组',
  `type_id` int(11) unsigned DEFAULT '1',
  `attr_name` varchar(60) DEFAULT '' COMMENT '变量标题',
  `attr_var_name` varchar(50) DEFAULT '' COMMENT '变量名',
  `attr_input_type` tinyint(1) unsigned DEFAULT '0' COMMENT ' 0=文本框，1=下拉框，2=多行文本框，3=上传图片',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`attr_id`)
) ENGINE=MyISAM AUTO_INCREMENT=17 DEFAULT CHARSET=utf8 COMMENT='自定义变量表';

-- -----------------------------
-- Records of `ey_config_attribute`
-- -----------------------------
INSERT INTO `ey_config_attribute` VALUES ('4', 'web', '1', '联系电话', 'web_attr_4', '0', 'cn', '1649638272', '1649670111');
INSERT INTO `ey_config_attribute` VALUES ('12', 'web', '1', '联系电话', 'web_attr_4', '0', 'en', '1649638272', '1649670126');

-- -----------------------------
-- Table structure for `ey_config_type`
-- -----------------------------
DROP TABLE IF EXISTS `ey_config_type`;
CREATE TABLE `ey_config_type` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `type_name` varchar(255) DEFAULT '' COMMENT '分组名称',
  `status` tinyint(1) DEFAULT '1',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  `sort_order` int(11) DEFAULT '100' COMMENT '排序',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COMMENT='自定义变量分组表';

-- -----------------------------
-- Records of `ey_config_type`
-- -----------------------------
INSERT INTO `ey_config_type` VALUES ('1', '默认分组', '1', 'cn', '1650271499', '1650271499', '100');

-- -----------------------------
-- Table structure for `ey_construction_content`
-- -----------------------------
DROP TABLE IF EXISTS `ey_construction_content`;
CREATE TABLE `ey_construction_content` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `aid` int(10) DEFAULT '0' COMMENT '文档ID',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  `xmjl` varchar(200) NOT NULL DEFAULT '' COMMENT '项目经理',
  `jgjl` varchar(200) NOT NULL DEFAULT '' COMMENT '监管经理',
  `mianji` varchar(200) NOT NULL DEFAULT '' COMMENT '房屋面积',
  `sslp` varchar(200) NOT NULL DEFAULT '' COMMENT '所属楼盘',
  `gczj` varchar(200) NOT NULL DEFAULT '' COMMENT '工程造价',
  `sgtp` varchar(10001) NOT NULL DEFAULT '' COMMENT '施工图片',
  `jgtp` varchar(10001) NOT NULL DEFAULT '' COMMENT '竣工图片',
  `sgjd` enum('前期','中期','后期','竣工验收') DEFAULT '前期' COMMENT '施工进度',
  `sgjdt` enum('25%','50%','75%','100%') DEFAULT '25%' COMMENT '施工进度条',
  PRIMARY KEY (`id`),
  KEY `aid` (`aid`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=7 DEFAULT CHARSET=utf8 COMMENT='附加表';

-- -----------------------------
-- Records of `ey_construction_content`
-- -----------------------------
INSERT INTO `ey_construction_content` VALUES ('1', '37', '1612667100', '1612667100', '项目经理一', '监管经理一', '120', '颐华城', '50万', 'a:4:{i:0;a:2:{s:9:\"image_url\";s:61:\"/uploads/allimg/20190821/89f0c82aec37fe785accd9b1c849b7fc.jpg\";s:5:\"intro\";s:0:\"\";}i:1;a:2:{s:9:\"image_url\";s:61:\"/uploads/allimg/20190821/15c26e7705c3e126e44994f6bcb95ca1.jpg\";s:5:\"intro\";s:0:\"\";}i:2;a:2:{s:9:\"image_url\";s:61:\"/uploads/allimg/20190821/6061c5ef4d165de31d3ad75170c05040.jpg\";s:5:\"intro\";s:0:\"\";}i:3;a:2:{s:9:\"image_url\";s:61:\"/uploads/allimg/20190821/af7ea339d7f941db7610ddc3ada82244.jpg\";s:5:\"intro\";s:0:\"\";}}', 'a:4:{i:0;a:2:{s:9:\"image_url\";s:61:\"/uploads/allimg/20190821/27b082df485571f2b85060442fea0e7a.jpg\";s:5:\"intro\";s:0:\"\";}i:1;a:2:{s:9:\"image_url\";s:61:\"/uploads/allimg/20190821/3b10ec7e8abc1b909e0463c916c1e0b4.jpg\";s:5:\"intro\";s:0:\"\";}i:2;a:2:{s:9:\"image_url\";s:61:\"/uploads/allimg/20190821/23f41846027c615919f73d88793d9efd.png\";s:5:\"intro\";s:0:\"\";}i:3;a:2:{s:9:\"image_url\";s:61:\"/uploads/allimg/20190821/8e439bbdc8915c802c0cb7b38227128b.png\";s:5:\"intro\";s:0:\"\";}}', '前期', '25%');
INSERT INTO `ey_construction_content` VALUES ('2', '38', '1612667091', '1612667091', '项目经理二', '监管经理二', '186', '太原邸', '80万', 'a:4:{i:0;a:2:{s:9:\"image_url\";s:61:\"/uploads/allimg/20190821/f73b3a59cd5e0f45a11caf37a41dee56.jpg\";s:5:\"intro\";s:0:\"\";}i:1;a:2:{s:9:\"image_url\";s:61:\"/uploads/allimg/20190821/0ca10a4c5702f3eab2da5cd915aeeab0.jpg\";s:5:\"intro\";s:0:\"\";}i:2;a:2:{s:9:\"image_url\";s:61:\"/uploads/allimg/20190821/385ccfc88bcb3e9dcc60310bab5b607e.png\";s:5:\"intro\";s:0:\"\";}i:3;a:2:{s:9:\"image_url\";s:61:\"/uploads/allimg/20190821/507f3005c9bbd13bf6953c70fd9f42af.jpg\";s:5:\"intro\";s:0:\"\";}}', 'a:4:{i:0;a:2:{s:9:\"image_url\";s:61:\"/uploads/allimg/20190821/1fbe4157571be9c106c025476edfc042.jpg\";s:5:\"intro\";s:0:\"\";}i:1;a:2:{s:9:\"image_url\";s:61:\"/uploads/allimg/20190821/db3f8e498a8e753fac88c36125f3e795.png\";s:5:\"intro\";s:0:\"\";}i:2;a:2:{s:9:\"image_url\";s:61:\"/uploads/allimg/20190821/8e5849a44c7f90592edac0cbc69f59dc.png\";s:5:\"intro\";s:0:\"\";}i:3;a:2:{s:9:\"image_url\";s:61:\"/uploads/allimg/20190821/c18c33df873e1eb56b5414571f059fcf.jpg\";s:5:\"intro\";s:0:\"\";}}', '中期', '50%');
INSERT INTO `ey_construction_content` VALUES ('3', '39', '1612667084', '1612667084', '项目经理三', '监管经理三', '190', '新汇公寓', '100万', 'a:4:{i:0;a:2:{s:9:\"image_url\";s:61:\"/uploads/allimg/20190821/b5315d32a4b49a19ace22576a9438536.jpg\";s:5:\"intro\";s:0:\"\";}i:1;a:2:{s:9:\"image_url\";s:61:\"/uploads/allimg/20190821/a0ef3785eb8420d2a78135f6946a6bfa.jpg\";s:5:\"intro\";s:0:\"\";}i:2;a:2:{s:9:\"image_url\";s:61:\"/uploads/allimg/20190821/7aa1981180be71ef97daa5384fc5290e.jpg\";s:5:\"intro\";s:0:\"\";}i:3;a:2:{s:9:\"image_url\";s:61:\"/uploads/allimg/20190821/6e53d91ccce1de04d18a12568ee318dd.jpg\";s:5:\"intro\";s:0:\"\";}}', 'a:4:{i:0;a:2:{s:9:\"image_url\";s:61:\"/uploads/allimg/20190821/e93dbd9fd20f04149a2f214fe6f30adc.jpg\";s:5:\"intro\";s:0:\"\";}i:1;a:2:{s:9:\"image_url\";s:61:\"/uploads/allimg/20190821/91dacea44df66572bc2834742131da2c.jpg\";s:5:\"intro\";s:0:\"\";}i:2;a:2:{s:9:\"image_url\";s:61:\"/uploads/allimg/20190821/470b68bfd6e16d623641ff19eb60eda0.jpg\";s:5:\"intro\";s:0:\"\";}i:3;a:2:{s:9:\"image_url\";s:61:\"/uploads/allimg/20190821/fbdf4033ceca36c6eb50ae3922c82671.jpg\";s:5:\"intro\";s:0:\"\";}}', '中期', '50%');
INSERT INTO `ey_construction_content` VALUES ('4', '40', '1612667077', '1612667077', '项目经理四', '监管经理四', '203', '富力湾', '90万', 'a:4:{i:0;a:2:{s:9:\"image_url\";s:61:\"/uploads/allimg/20190821/3e00a1513ebd809732a7ff685d704b5c.jpg\";s:5:\"intro\";s:0:\"\";}i:1;a:2:{s:9:\"image_url\";s:61:\"/uploads/allimg/20190821/c38d1ffe54be3d43797c13b6f4b28cd1.png\";s:5:\"intro\";s:0:\"\";}i:2;a:2:{s:9:\"image_url\";s:61:\"/uploads/allimg/20190821/6bc91fb4e61936b3696c4f488fd83e9d.jpg\";s:5:\"intro\";s:0:\"\";}i:3;a:2:{s:9:\"image_url\";s:61:\"/uploads/allimg/20190821/51dc72f4c69b632aa9a2992ad9628eb3.jpg\";s:5:\"intro\";s:0:\"\";}}', 'a:4:{i:0;a:2:{s:9:\"image_url\";s:61:\"/uploads/allimg/20190821/7224f8abb13952a1e80bccdb169b4f1a.jpg\";s:5:\"intro\";s:0:\"\";}i:1;a:2:{s:9:\"image_url\";s:61:\"/uploads/allimg/20190821/2dcaf98c1723212f4457e1238ab12754.jpg\";s:5:\"intro\";s:0:\"\";}i:2;a:2:{s:9:\"image_url\";s:61:\"/uploads/allimg/20190821/7f906beeddc14861391e58f795f23b8d.jpg\";s:5:\"intro\";s:0:\"\";}i:3;a:2:{s:9:\"image_url\";s:61:\"/uploads/allimg/20190821/37ff775c35c85c5edddbb13fc956711d.jpg\";s:5:\"intro\";s:0:\"\";}}', '后期', '75%');
INSERT INTO `ey_construction_content` VALUES ('5', '41', '1612667059', '1612667059', '项目经理五', '监管经理五', '109', '飘鹰东方花园', '108万', 'a:4:{i:0;a:2:{s:9:\"image_url\";s:61:\"/uploads/allimg/20190821/3b18fbf5cbeaf7d915ce736090fd166a.jpg\";s:5:\"intro\";s:0:\"\";}i:1;a:2:{s:9:\"image_url\";s:61:\"/uploads/allimg/20190821/39a9064812dd5a6ac77eae2ab4ef9a89.png\";s:5:\"intro\";s:0:\"\";}i:2;a:2:{s:9:\"image_url\";s:61:\"/uploads/allimg/20190821/76585b5f9a4b2f0a396b5ad1224cb33a.jpg\";s:5:\"intro\";s:0:\"\";}i:3;a:2:{s:9:\"image_url\";s:61:\"/uploads/allimg/20190821/21048663ee3a520c0431a83cbc43e5af.png\";s:5:\"intro\";s:0:\"\";}}', 'a:4:{i:0;a:2:{s:9:\"image_url\";s:61:\"/uploads/allimg/20190821/0e7f4b8b4483154998128047b3a311d7.jpg\";s:5:\"intro\";s:0:\"\";}i:1;a:2:{s:9:\"image_url\";s:61:\"/uploads/allimg/20190821/47a21a3a342d5b4168b32d446dad2055.jpg\";s:5:\"intro\";s:0:\"\";}i:2;a:2:{s:9:\"image_url\";s:61:\"/uploads/allimg/20190821/d62a5eec5a231f4f2d01123aa56f5bf8.jpg\";s:5:\"intro\";s:0:\"\";}i:3;a:2:{s:9:\"image_url\";s:61:\"/uploads/allimg/20190821/4d0b1a6efc1740a23bcf32518341b250.jpg\";s:5:\"intro\";s:0:\"\";}}', '后期', '75%');
INSERT INTO `ey_construction_content` VALUES ('6', '42', '1612667017', '1612667017', '项目经理六', '监管经理六', '300', '城开珑庭', '200万', 'a:4:{i:0;a:2:{s:9:\"image_url\";s:61:\"/uploads/allimg/20190821/5d2b4f32c7647d67171a5f66e9fed156.jpg\";s:5:\"intro\";s:0:\"\";}i:1;a:2:{s:9:\"image_url\";s:61:\"/uploads/allimg/20190821/6a13c9ab5a06c05b9f42672c08c34ecb.png\";s:5:\"intro\";s:0:\"\";}i:2;a:2:{s:9:\"image_url\";s:61:\"/uploads/allimg/20190821/35d491928f6d6d5de584099040502c61.jpg\";s:5:\"intro\";s:0:\"\";}i:3;a:2:{s:9:\"image_url\";s:61:\"/uploads/allimg/20190821/40f45c66412c392752f5b2a8bef50dd1.jpg\";s:5:\"intro\";s:0:\"\";}}', 'a:4:{i:0;a:2:{s:9:\"image_url\";s:61:\"/uploads/allimg/20190821/d3788290b4c6374bdddce70197961cd2.jpg\";s:5:\"intro\";s:0:\"\";}i:1;a:2:{s:9:\"image_url\";s:61:\"/uploads/allimg/20190821/027b94d15a4be486e1aae409b915fe1c.jpg\";s:5:\"intro\";s:0:\"\";}i:2;a:2:{s:9:\"image_url\";s:61:\"/uploads/allimg/20190821/f58f1994ab5bbe67641efd6eb7cd0b1c.jpg\";s:5:\"intro\";s:0:\"\";}i:3;a:2:{s:9:\"image_url\";s:61:\"/uploads/allimg/20190821/b6f38f07a06a4d4df7952b9d965c9385.jpg\";s:5:\"intro\";s:0:\"\";}}', '竣工验收', '100%');

-- -----------------------------
-- Table structure for `ey_cp_content`
-- -----------------------------
DROP TABLE IF EXISTS `ey_cp_content`;
CREATE TABLE `ey_cp_content` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `aid` int(10) DEFAULT '0' COMMENT '文档ID',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  `content` longtext COMMENT '内容详情',
  PRIMARY KEY (`id`),
  KEY `aid` (`aid`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=19 DEFAULT CHARSET=utf8 COMMENT='附加表';

-- -----------------------------
-- Records of `ey_cp_content`
-- -----------------------------
INSERT INTO `ey_cp_content` VALUES ('1', '15', '1555053555', '1555053555', '&lt;p style=&quot;text-align: center;&quot;&gt;&lt;img src=&quot;/uploads/ueditor/20190412/bcd617212957c9dc6a5412c58c7446d5.jpg&quot; title=&quot;bcd617212957c9dc6a5412c58c7446d5.jpg&quot; alt=&quot;bcd617212957c9dc6a5412c58c7446d5.jpg&quot;/&gt;&lt;/p&gt;');
INSERT INTO `ey_cp_content` VALUES ('2', '16', '1555053579', '1555053579', '&lt;p style=&quot;text-align: center;&quot;&gt;&lt;img src=&quot;/uploads/ueditor/20190412/85ff99bfd9efbd4e1ae17dc2ead76035.jpg&quot; title=&quot;85ff99bfd9efbd4e1ae17dc2ead76035.jpg&quot; alt=&quot;85ff99bfd9efbd4e1ae17dc2ead76035.jpg&quot;/&gt;&lt;/p&gt;');
INSERT INTO `ey_cp_content` VALUES ('3', '17', '1555053594', '1555053594', '&lt;p style=&quot;text-align: center;&quot;&gt;&lt;img src=&quot;/uploads/ueditor/20190412/1c763a29611a28b4b5f9f000b3481a0c.jpg&quot; title=&quot;1c763a29611a28b4b5f9f000b3481a0c.jpg&quot; alt=&quot;1c763a29611a28b4b5f9f000b3481a0c.jpg&quot;/&gt;&lt;/p&gt;');
INSERT INTO `ey_cp_content` VALUES ('4', '18', '1555053608', '1555053608', '&lt;p style=&quot;text-align: center;&quot;&gt;&lt;img src=&quot;/uploads/ueditor/20190412/98763fb03fa81c201889ea0c26e7490e.jpg&quot; title=&quot;98763fb03fa81c201889ea0c26e7490e.jpg&quot; alt=&quot;98763fb03fa81c201889ea0c26e7490e.jpg&quot;/&gt;&lt;/p&gt;');
INSERT INTO `ey_cp_content` VALUES ('5', '19', '1555053624', '1555053624', '&lt;p style=&quot;text-align: center;&quot;&gt;&lt;img src=&quot;/uploads/ueditor/20190412/ee4dff6a00936118779ae001f252725e.jpg&quot; title=&quot;ee4dff6a00936118779ae001f252725e.jpg&quot; alt=&quot;ee4dff6a00936118779ae001f252725e.jpg&quot;/&gt;&lt;/p&gt;');
INSERT INTO `ey_cp_content` VALUES ('6', '20', '1555053639', '1555053639', '&lt;p style=&quot;text-align: center;&quot;&gt;&lt;img src=&quot;/uploads/ueditor/20190412/6d8a523e021f2229eee481b33e1bf54c.jpg&quot; title=&quot;6d8a523e021f2229eee481b33e1bf54c.jpg&quot; alt=&quot;6d8a523e021f2229eee481b33e1bf54c.jpg&quot;/&gt;&lt;/p&gt;');
INSERT INTO `ey_cp_content` VALUES ('7', '21', '1555053764', '1555053764', '&lt;p style=&quot;text-align: center;&quot;&gt;&lt;img src=&quot;/uploads/ueditor/20190412/261db2db709dc3c012a18d88c6844159.png&quot; title=&quot;261db2db709dc3c012a18d88c6844159.png&quot; alt=&quot;261db2db709dc3c012a18d88c6844159.png&quot;/&gt;&lt;/p&gt;');
INSERT INTO `ey_cp_content` VALUES ('8', '22', '1555053778', '1555053778', '&lt;p style=&quot;text-align: center;&quot;&gt;&lt;img src=&quot;/uploads/ueditor/20190412/ae58acdec7b6e9585ee2beba5d14a652.png&quot; title=&quot;ae58acdec7b6e9585ee2beba5d14a652.png&quot; alt=&quot;ae58acdec7b6e9585ee2beba5d14a652.png&quot;/&gt;&lt;/p&gt;');
INSERT INTO `ey_cp_content` VALUES ('9', '23', '1555053794', '1555053794', '&lt;p style=&quot;text-align: center;&quot;&gt;&lt;img src=&quot;/uploads/ueditor/20190412/82eb83d1842cfbed36c1c1700faf3b68.png&quot; title=&quot;82eb83d1842cfbed36c1c1700faf3b68.png&quot; alt=&quot;82eb83d1842cfbed36c1c1700faf3b68.png&quot;/&gt;&lt;/p&gt;');
INSERT INTO `ey_cp_content` VALUES ('10', '24', '1555053920', '1555053920', '&lt;p style=&quot;text-align: center;&quot;&gt;&lt;img src=&quot;/uploads/ueditor/20190412/19f0405d149bcd41ec20b2dbb089f004.png&quot; title=&quot;19f0405d149bcd41ec20b2dbb089f004.png&quot; alt=&quot;19f0405d149bcd41ec20b2dbb089f004.png&quot;/&gt;&lt;/p&gt;');
INSERT INTO `ey_cp_content` VALUES ('11', '25', '1555053934', '1555053934', '&lt;p style=&quot;text-align: center;&quot;&gt;&lt;img src=&quot;/uploads/ueditor/20190412/a6c87d8626dc0763ec0a29e886957442.png&quot; title=&quot;a6c87d8626dc0763ec0a29e886957442.png&quot; alt=&quot;a6c87d8626dc0763ec0a29e886957442.png&quot;/&gt;&lt;/p&gt;');
INSERT INTO `ey_cp_content` VALUES ('12', '26', '1555053950', '1555053950', '&lt;p style=&quot;text-align: center;&quot;&gt;&lt;img src=&quot;/uploads/ueditor/20190412/df517acf1c9cc0c7ce64cf4d4acd6007.png&quot; title=&quot;df517acf1c9cc0c7ce64cf4d4acd6007.png&quot; alt=&quot;df517acf1c9cc0c7ce64cf4d4acd6007.png&quot;/&gt;&lt;/p&gt;');
INSERT INTO `ey_cp_content` VALUES ('13', '27', '1555054000', '1555054000', '&lt;p style=&quot;text-align: center;&quot;&gt;&lt;img src=&quot;/uploads/ueditor/20190412/d3db198cedafd09ff66d32f7a021c3d9.png&quot; title=&quot;d3db198cedafd09ff66d32f7a021c3d9.png&quot; alt=&quot;d3db198cedafd09ff66d32f7a021c3d9.png&quot;/&gt;&lt;/p&gt;');
INSERT INTO `ey_cp_content` VALUES ('14', '28', '1555054012', '1555054012', '&lt;p style=&quot;text-align: center;&quot;&gt;&lt;img src=&quot;/uploads/ueditor/20190412/2ee2205244719343d6e10ed6d0ee347f.png&quot; title=&quot;2ee2205244719343d6e10ed6d0ee347f.png&quot; alt=&quot;2ee2205244719343d6e10ed6d0ee347f.png&quot;/&gt;&lt;/p&gt;');
INSERT INTO `ey_cp_content` VALUES ('15', '29', '1555054025', '1555054025', '&lt;p style=&quot;text-align: center;&quot;&gt;&lt;img src=&quot;/uploads/ueditor/20190412/316a0cd9a5a644cc9a4eff69291c065c.png&quot; title=&quot;316a0cd9a5a644cc9a4eff69291c065c.png&quot; alt=&quot;316a0cd9a5a644cc9a4eff69291c065c.png&quot;/&gt;&lt;/p&gt;');
INSERT INTO `ey_cp_content` VALUES ('16', '30', '1555054039', '1555054039', '&lt;p style=&quot;text-align: center;&quot;&gt;&lt;img src=&quot;/uploads/ueditor/20190412/132289025f8a3c3e156605143b2d81d7.png&quot; title=&quot;132289025f8a3c3e156605143b2d81d7.png&quot; alt=&quot;132289025f8a3c3e156605143b2d81d7.png&quot;/&gt;&lt;/p&gt;');
INSERT INTO `ey_cp_content` VALUES ('17', '31', '1555054204', '1555054204', '&lt;p style=&quot;text-align: center;&quot;&gt;&lt;img src=&quot;/uploads/ueditor/20190412/a9a301b263d459d02328394d11762573.png&quot; title=&quot;a9a301b263d459d02328394d11762573.png&quot; alt=&quot;a9a301b263d459d02328394d11762573.png&quot;/&gt;&lt;/p&gt;');
INSERT INTO `ey_cp_content` VALUES ('18', '32', '1555054216', '1555054216', '&lt;p style=&quot;text-align: center;&quot;&gt;&lt;img src=&quot;/uploads/ueditor/20190412/65137ee3f9b70f15fa3b11cfaac0da5a.png&quot; title=&quot;65137ee3f9b70f15fa3b11cfaac0da5a.png&quot; alt=&quot;65137ee3f9b70f15fa3b11cfaac0da5a.png&quot;/&gt;&lt;/p&gt;');

-- -----------------------------
-- Table structure for `ey_cs_content`
-- -----------------------------
DROP TABLE IF EXISTS `ey_cs_content`;
CREATE TABLE `ey_cs_content` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `aid` int(10) DEFAULT '0' COMMENT '文档ID',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  `wzwz` varchar(200) NOT NULL DEFAULT '' COMMENT '网址',
  `ico` varchar(250) NOT NULL DEFAULT '' COMMENT '图标',
  PRIMARY KEY (`id`),
  KEY `aid` (`aid`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COMMENT='附加表';

-- -----------------------------
-- Records of `ey_cs_content`
-- -----------------------------
INSERT INTO `ey_cs_content` VALUES ('1', '27', '1614155119', '1614155119', 'https://www.bt.cn/', '/uploads/allimg/20190228/339b80f3d43d9a348a98746c502e28a1.jpg');

-- -----------------------------
-- Table structure for `ey_custom_content`
-- -----------------------------
DROP TABLE IF EXISTS `ey_custom_content`;
CREATE TABLE `ey_custom_content` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `aid` int(10) DEFAULT '0' COMMENT '文档ID',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  `miaoshu` text COMMENT '文章描述',
  PRIMARY KEY (`id`),
  KEY `aid` (`aid`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 COMMENT='附加表';

-- -----------------------------
-- Records of `ey_custom_content`
-- -----------------------------
INSERT INTO `ey_custom_content` VALUES ('1', '6', '1551752806', '1551752806', '适用于大型、中型、小型以及快速成长型企业的解决方案');
INSERT INTO `ey_custom_content` VALUES ('2', '7', '1551752824', '1551752824', '适用于大型、中型、小型以及快速成长型企业的解决方案');
INSERT INTO `ey_custom_content` VALUES ('3', '8', '1551752838', '1551752838', '适用于大型、中型、小型以及快速成长型企业的解决方案');
INSERT INTO `ey_custom_content` VALUES ('4', '9', '1551752853', '1551752853', '适用于大型、中型、小型以及快速成长型企业的解决方案');

-- -----------------------------
-- Table structure for `ey_ddos_log`
-- -----------------------------
DROP TABLE IF EXISTS `ey_ddos_log`;
CREATE TABLE `ey_ddos_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `md5key` varchar(50) DEFAULT '' COMMENT 'md5值',
  `file_name` varchar(500) DEFAULT '' COMMENT '文件名',
  `file_num` int(10) DEFAULT '0' COMMENT '已扫描数',
  `file_total` int(10) DEFAULT '0' COMMENT '总文件数',
  `file_num_ky` int(10) DEFAULT '0' COMMENT '可疑恶意文件数',
  `is_suspicious` tinyint(1) DEFAULT '0' COMMENT '是否可疑',
  `html` text,
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='ddos查杀进度记录表';


-- -----------------------------
-- Table structure for `ey_discount_active`
-- -----------------------------
DROP TABLE IF EXISTS `ey_discount_active`;
CREATE TABLE `ey_discount_active` (
  `active_id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '活动会场ID',
  `active_name` varchar(255) DEFAULT '' COMMENT '活动名称',
  `start_date` int(11) unsigned DEFAULT '0' COMMENT '活动开始时间',
  `end_date` int(11) DEFAULT '0' COMMENT '活动结束时间',
  `limit_type` tinyint(3) unsigned DEFAULT '1' COMMENT '限购类型 1-不限购,2-活动期内每人最多购买n件,3-活动期内每人每天最多购买n件',
  `limit` int(11) unsigned DEFAULT '0' COMMENT '限购数量',
  `preheat` tinyint(3) DEFAULT '0' COMMENT '是否开启预热 0-关闭 1-开启',
  `preheat_time` int(11) DEFAULT '0' COMMENT '预热时间,不能大于开启时间',
  `status` tinyint(3) unsigned NOT NULL DEFAULT '1' COMMENT '活动状态(0禁用 1启用)',
  `is_del` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '是否删除',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '创建时间',
  `update_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`active_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='限时折扣-活动会场表';


-- -----------------------------
-- Table structure for `ey_discount_active_goods`
-- -----------------------------
DROP TABLE IF EXISTS `ey_discount_active_goods`;
CREATE TABLE `ey_discount_active_goods` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键ID',
  `active_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '活动ID',
  `aid` int(11) NOT NULL DEFAULT '0' COMMENT '文档id',
  `discount_goods_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '秒杀商品ID',
  `sales_actual` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '实际销量',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '创建时间',
  `update_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='限时折扣-活动会场与商品关联表';


-- -----------------------------
-- Table structure for `ey_discount_goods`
-- -----------------------------
DROP TABLE IF EXISTS `ey_discount_goods`;
CREATE TABLE `ey_discount_goods` (
  `discount_gid` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '限时折扣商品ID',
  `aid` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '商品ID->aid',
  `discount_stock` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '限时折扣商品库存总量',
  `discount_price` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '限时折扣价格',
  `sales` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '累积销量',
  `virtual_sales` int(11) NOT NULL DEFAULT '0' COMMENT '虚拟销量',
  `sort_order` int(11) unsigned NOT NULL DEFAULT '100' COMMENT '商品排序(数字越小越靠前)',
  `status` tinyint(3) unsigned NOT NULL DEFAULT '1' COMMENT '商品状态(0下架 1上架)',
  `is_del` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '是否删除',
  `is_sku` tinyint(1) NOT NULL DEFAULT '0' COMMENT '1-多规格商品',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '创建时间',
  `update_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`discount_gid`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='限时折扣-商品表';


-- -----------------------------
-- Table structure for `ey_diyminipro`
-- -----------------------------
DROP TABLE IF EXISTS `ey_diyminipro`;
CREATE TABLE `ey_diyminipro` (
  `mini_id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '模板ID',
  `categoryid` int(11) NOT NULL DEFAULT '0' COMMENT '分类ID',
  `name` varchar(100) NOT NULL DEFAULT '' COMMENT '模板标题',
  `litpic` varchar(250) NOT NULL DEFAULT '' COMMENT '封面图',
  `component` text NOT NULL COMMENT '组件库',
  `status` tinyint(1) NOT NULL DEFAULT '0' COMMENT '状态：4=审核中，5=发布',
  `cloud_id` int(10) NOT NULL DEFAULT '0' COMMENT '云ID',
  `config` text NOT NULL COMMENT '相关序列化信息',
  `is_del` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '伪删除，1=是，0=否',
  `lang` varchar(10) NOT NULL DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`mini_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='微信小程序记录表';


-- -----------------------------
-- Table structure for `ey_diyminipro_page`
-- -----------------------------
DROP TABLE IF EXISTS `ey_diyminipro_page`;
CREATE TABLE `ey_diyminipro_page` (
  `page_id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '页面id',
  `page_type` tinyint(3) NOT NULL DEFAULT '-1' COMMENT '页面类型(1首页 -1自定义页)',
  `page_name` varchar(255) NOT NULL DEFAULT '' COMMENT '页面名称',
  `page_data` longtext NOT NULL COMMENT '页面数据',
  `mini_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '微信小程序id',
  `is_home` tinyint(1) NOT NULL DEFAULT '0' COMMENT '设为首页：0=否，1=是',
  `is_system` tinyint(1) NOT NULL DEFAULT '0' COMMENT '系统内置',
  `is_show` tinyint(1) NOT NULL DEFAULT '1' COMMENT '是否显示：1=显示，0=隐藏',
  `is_del` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '伪删除，1=是，0=否',
  `lang` varchar(10) NOT NULL DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`page_id`),
  KEY `mini_id` (`mini_id`,`lang`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='微信小程序diy页面表';


-- -----------------------------
-- Table structure for `ey_diyminipro_setting`
-- -----------------------------
DROP TABLE IF EXISTS `ey_diyminipro_setting`;
CREATE TABLE `ey_diyminipro_setting` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `name` varchar(60) NOT NULL DEFAULT '' COMMENT '页面组',
  `value` text NOT NULL COMMENT '组装之后的值',
  `mini_id` int(11) NOT NULL DEFAULT '0' COMMENT '小程序ID',
  `lang` varchar(10) NOT NULL DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) NOT NULL DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`),
  KEY `type` (`name`) USING BTREE,
  KEY `mini_id` (`mini_id`,`lang`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='微信小程序多功能配置表';


-- -----------------------------
-- Table structure for `ey_download_attr_field`
-- -----------------------------
DROP TABLE IF EXISTS `ey_download_attr_field`;
CREATE TABLE `ey_download_attr_field` (
  `field_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `field_name` varchar(32) DEFAULT '' COMMENT '字段名称',
  `field_title` varchar(32) DEFAULT '' COMMENT '字段标题',
  `field_use` tinyint(1) DEFAULT '0' COMMENT '字段是否使用，0未使用，1为使用',
  `sort_order` smallint(5) DEFAULT '0' COMMENT '排序',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) unsigned DEFAULT '0' COMMENT '上传时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`field_id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COMMENT='上传文件属性表';

-- -----------------------------
-- Records of `ey_download_attr_field`
-- -----------------------------
INSERT INTO `ey_download_attr_field` VALUES ('1', 'extract_code', '提取码', '1', '1', 'cn', '1561001807', '1561024954');
INSERT INTO `ey_download_attr_field` VALUES ('2', 'server_name', '服务器名称', '1', '2', 'cn', '1561001807', '1561078673');

-- -----------------------------
-- Table structure for `ey_download_content`
-- -----------------------------
DROP TABLE IF EXISTS `ey_download_content`;
CREATE TABLE `ey_download_content` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `aid` int(10) DEFAULT '0' COMMENT '文档ID',
  `content` longtext COMMENT '内容详情',
  `content_ey_m` longtext COMMENT '手机端内容详情',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`),
  KEY `news_id` (`aid`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='资讯内容表_存储正常内容';


-- -----------------------------
-- Table structure for `ey_download_file`
-- -----------------------------
DROP TABLE IF EXISTS `ey_download_file`;
CREATE TABLE `ey_download_file` (
  `file_id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `aid` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT '产品ID',
  `title` varchar(200) DEFAULT '' COMMENT '产品标题',
  `file_url` varchar(255) DEFAULT '' COMMENT '文件存储路径',
  `extract_code` varchar(20) DEFAULT '' COMMENT '文件提取码',
  `file_size` varchar(255) DEFAULT '' COMMENT '文件大小',
  `file_ext` varchar(50) DEFAULT '' COMMENT '文件后缀名',
  `file_name` varchar(200) DEFAULT '' COMMENT '文件名',
  `server_name` varchar(200) DEFAULT '' COMMENT '服务器名称',
  `file_mime` varchar(200) DEFAULT '' COMMENT '文件类型',
  `uhash` varchar(200) DEFAULT '' COMMENT '自定义的一种加密方式，用于文件下载权限验证',
  `md5file` varchar(200) DEFAULT '' COMMENT 'md5_file加密，可以检测上传/下载的文件包是否损坏',
  `is_remote` tinyint(1) DEFAULT '0' COMMENT '是否远程',
  `downcount` int(10) DEFAULT '0' COMMENT '下载次数',
  `sort_order` smallint(5) DEFAULT '0' COMMENT '排序',
  `add_time` int(10) unsigned DEFAULT '0' COMMENT '上传时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`file_id`),
  KEY `arcid` (`aid`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='下载附件表';


-- -----------------------------
-- Table structure for `ey_download_log`
-- -----------------------------
DROP TABLE IF EXISTS `ey_download_log`;
CREATE TABLE `ey_download_log` (
  `log_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `users_id` int(10) DEFAULT '0' COMMENT '用户ID',
  `aid` int(10) DEFAULT '0' COMMENT '文档ID',
  `file_id` int(10) DEFAULT '0' COMMENT '附件ID',
  `ip` varchar(20) DEFAULT '' COMMENT 'ip',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '编辑时间',
  PRIMARY KEY (`log_id`),
  KEY `file_id` (`file_id`,`aid`,`users_id`) USING BTREE,
  KEY `aid` (`aid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='下载记录表';


-- -----------------------------
-- Table structure for `ey_download_order`
-- -----------------------------
DROP TABLE IF EXISTS `ey_download_order`;
CREATE TABLE `ey_download_order` (
  `order_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '文章订单ID',
  `order_code` varchar(50) NOT NULL DEFAULT '' COMMENT '媒体订单编号',
  `users_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '会员ID',
  `order_status` tinyint(1) NOT NULL DEFAULT '0' COMMENT '订单状态：0未付款，1已付款',
  `order_amount` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '订单应付总金额',
  `pay_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '支付时间',
  `pay_name` varchar(20) NOT NULL DEFAULT '' COMMENT '支付方式名称',
  `wechat_pay_type` varchar(20) NOT NULL DEFAULT '' COMMENT '微信支付时，标记使用的支付类型（扫码支付，微信内部，微信H5页面）',
  `pay_details` text COMMENT '支付时返回的数据，以serialize序列化后存入，用于后续查询。',
  `product_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '视频文档ID',
  `product_name` varchar(100) DEFAULT '' COMMENT '视频文档名称',
  `product_litpic` varchar(500) DEFAULT '' COMMENT '视频文档封面图片',
  `lang` varchar(30) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) unsigned DEFAULT '0' COMMENT '下单时间',
  `update_time` int(11) unsigned DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`order_id`),
  UNIQUE KEY `order_code` (`order_code`) USING BTREE,
  KEY `users_id` (`users_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;


-- -----------------------------
-- Table structure for `ey_email_template`
-- -----------------------------
DROP TABLE IF EXISTS `ey_email_template`;
CREATE TABLE `ey_email_template` (
  `tpl_id` mediumint(8) NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `tpl_title` varchar(100) DEFAULT '' COMMENT '邮件标题',
  `tpl_content` text COMMENT '发送邮件内容',
  `send_scene` varchar(100) DEFAULT '' COMMENT '邮件发送场景',
  `add_time` int(11) DEFAULT NULL COMMENT '添加时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`tpl_id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

-- -----------------------------
-- Records of `ey_email_template`
-- -----------------------------
INSERT INTO `ey_email_template` VALUES ('1', '您有新的邮件，请注意查收！', '<p>亲爱的会员：</p><p>${content}</p>', '1', '1509268284', '1509281095');

-- -----------------------------
-- Table structure for `ey_field_type`
-- -----------------------------
DROP TABLE IF EXISTS `ey_field_type`;
CREATE TABLE `ey_field_type` (
  `name` varchar(32) NOT NULL DEFAULT '' COMMENT '字段类型',
  `title` varchar(64) NOT NULL DEFAULT '' COMMENT '中文类型名',
  `ifoption` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否需要设置选项',
  `sort_order` int(10) NOT NULL DEFAULT '0' COMMENT '排序',
  `add_time` int(11) NOT NULL DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`name`),
  UNIQUE KEY `name` (`name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='字段类型表';

-- -----------------------------
-- Records of `ey_field_type`
-- -----------------------------
INSERT INTO `ey_field_type` VALUES ('text', '单行文本', '0', '1', '1532485708', '1532485708');
INSERT INTO `ey_field_type` VALUES ('checkbox', '多选项', '1', '5', '1532485708', '1532485708');
INSERT INTO `ey_field_type` VALUES ('multitext', '多行文本', '0', '2', '1532485708', '1532485708');
INSERT INTO `ey_field_type` VALUES ('radio', '单选项', '1', '4', '1532485708', '1532485708');
INSERT INTO `ey_field_type` VALUES ('switch', '开关', '0', '13', '1532485708', '1532485708');
INSERT INTO `ey_field_type` VALUES ('select', '下拉框', '1', '6', '1532485708', '1532485708');
INSERT INTO `ey_field_type` VALUES ('img', '单张图', '0', '10', '1532485708', '1532485708');
INSERT INTO `ey_field_type` VALUES ('int', '整数类型', '0', '7', '1532485708', '1532485708');
INSERT INTO `ey_field_type` VALUES ('datetime', '日期和时间', '0', '12', '1532485708', '1532485708');
INSERT INTO `ey_field_type` VALUES ('htmltext', 'HTML文本', '0', '3', '1532485708', '1532485708');
INSERT INTO `ey_field_type` VALUES ('imgs', '多张图', '0', '11', '1532485708', '1532485708');
INSERT INTO `ey_field_type` VALUES ('decimal', '金额类型', '0', '9', '1532485708', '1532485708');
INSERT INTO `ey_field_type` VALUES ('float', '小数类型', '0', '8', '1532485708', '1532485708');
INSERT INTO `ey_field_type` VALUES ('region', '区域类型', '1', '6', '1532485708', '1532485708');
INSERT INTO `ey_field_type` VALUES ('file', '附件类型', '0', '11', '1532485708', '1532485708');
INSERT INTO `ey_field_type` VALUES ('media', '多媒体类型', '0', '11', '1532485708', '1532485708');

-- -----------------------------
-- Table structure for `ey_foreign_pack`
-- -----------------------------
DROP TABLE IF EXISTS `ey_foreign_pack`;
CREATE TABLE `ey_foreign_pack` (
  `id` int(10) NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `type` int(4) DEFAULT '0' COMMENT '分类：1=列表，2=留言',
  `name` varchar(50) NOT NULL DEFAULT '' COMMENT '变量名',
  `value` text NOT NULL COMMENT '变量值',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `sort_order` int(10) DEFAULT '0' COMMENT '排序号',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=183 DEFAULT CHARSET=utf8 COMMENT='外贸助手语言包变量';

-- -----------------------------
-- Records of `ey_foreign_pack`
-- -----------------------------
INSERT INTO `ey_foreign_pack` VALUES ('1', '1', 'page1', '首页', 'cn', '100', '1543890216', '1543890216');
INSERT INTO `ey_foreign_pack` VALUES ('2', '1', 'page2', '上一页', 'cn', '100', '1543890216', '1543890216');
INSERT INTO `ey_foreign_pack` VALUES ('3', '1', 'page3', '下一页', 'cn', '100', '1543890216', '1543890216');
INSERT INTO `ey_foreign_pack` VALUES ('4', '1', 'page4', '末页', 'cn', '100', '1543890216', '1543890216');
INSERT INTO `ey_foreign_pack` VALUES ('5', '1', 'page5', '共<strong>%s</strong>页 <strong>%s</strong>条', 'cn', '100', '1543890216', '1543890216');
INSERT INTO `ey_foreign_pack` VALUES ('6', '1', 'page1', 'Home', 'en', '100', '1543890216', '1543890216');
INSERT INTO `ey_foreign_pack` VALUES ('7', '1', 'page2', 'Pre', 'en', '100', '1543890216', '1543890216');
INSERT INTO `ey_foreign_pack` VALUES ('8', '1', 'page3', 'Next', 'en', '100', '1543890216', '1543890216');
INSERT INTO `ey_foreign_pack` VALUES ('9', '1', 'page4', 'Last', 'en', '100', '1543890216', '1543890216');
INSERT INTO `ey_foreign_pack` VALUES ('10', '1', 'page5', 'Road <strong>%s</strong> page <strong>%s</strong> strip', 'en', '100', '1543890216', '1543890216');
INSERT INTO `ey_foreign_pack` VALUES ('11', '2', 'gbook1', '操作成功', 'cn', '100', '1543890216', '1543890216');
INSERT INTO `ey_foreign_pack` VALUES ('12', '2', 'gbook1', 'success', 'en', '100', '1543890216', '1543890216');
INSERT INTO `ey_foreign_pack` VALUES ('14', '2', 'gbook2', 'The same IP cannot be submitted repeatedly within %s seconds!', 'en', '100', '1543890216', '1543890216');
INSERT INTO `ey_foreign_pack` VALUES ('13', '2', 'gbook2', '同一个IP在%s秒之内不能重复提交！', 'cn', '100', '1543890216', '1543890216');
INSERT INTO `ey_foreign_pack` VALUES ('15', '2', 'gbook3', '%s不能为空！', 'cn', '100', '1543890216', '1543890216');
INSERT INTO `ey_foreign_pack` VALUES ('16', '2', 'gbook3', '%s Cannot be empty!', 'en', '100', '1543890216', '1543890216');
INSERT INTO `ey_foreign_pack` VALUES ('17', '2', 'gbook4', '%s格式不正确！', 'cn', '100', '1543890216', '1543890216');
INSERT INTO `ey_foreign_pack` VALUES ('18', '2', 'gbook4', '%s Incorrect format!', 'en', '100', '1543890216', '1543890216');
INSERT INTO `ey_foreign_pack` VALUES ('19', '2', 'gbook5', '图片验证码不能为空！', 'cn', '100', '1543890216', '1543890216');
INSERT INTO `ey_foreign_pack` VALUES ('20', '2', 'gbook5', 'Picture verification code cannot be empty!', 'en', '100', '1543890216', '1543890216');
INSERT INTO `ey_foreign_pack` VALUES ('21', '2', 'gbook6', '图片验证码不正确！', 'cn', '100', '1543890216', '1543890216');
INSERT INTO `ey_foreign_pack` VALUES ('22', '2', 'gbook6', 'The picture verification code is incorrect!', 'en', '100', '1543890216', '1543890216');
INSERT INTO `ey_foreign_pack` VALUES ('23', '2', 'gbook7', '请输入手机号码！', 'cn', '100', '1543890216', '1543890216');
INSERT INTO `ey_foreign_pack` VALUES ('24', '2', 'gbook7', 'Please enter your mobile number!', 'en', '100', '1543890216', '1543890216');
INSERT INTO `ey_foreign_pack` VALUES ('25', '2', 'gbook8', '手机号码和手机验证码不一致，请重新输入！', 'cn', '100', '1543890216', '1543890216');
INSERT INTO `ey_foreign_pack` VALUES ('26', '2', 'gbook8', 'Mobile phone number and mobile phone verification code are inconsistent, please re-enter!', 'en', '100', '1543890216', '1543890216');
INSERT INTO `ey_foreign_pack` VALUES ('27', '2', 'gbook9', '手机验证码已被使用或超时，请重新发送！', 'cn', '100', '1543890216', '1543890216');
INSERT INTO `ey_foreign_pack` VALUES ('28', '2', 'gbook9', 'The mobile phone verification code has been used or timed out. Please resend it!', 'en', '100', '1543890216', '1543890216');
INSERT INTO `ey_foreign_pack` VALUES ('29', '2', 'gbook10', '请输入手机验证码！', 'cn', '100', '1543890216', '1543890216');
INSERT INTO `ey_foreign_pack` VALUES ('30', '2', 'gbook10', 'Please enter the mobile phone verification code!', 'en', '100', '1543890216', '1543890216');
INSERT INTO `ey_foreign_pack` VALUES ('31', '2', 'gbook11', '表单缺少标签属性{$field.hidden}', 'cn', '100', '1543890216', '1543890216');
INSERT INTO `ey_foreign_pack` VALUES ('32', '2', 'gbook11', 'The form is missing label attribute {$field.hidden}', 'en', '100', '1543890216', '1543890216');
INSERT INTO `ey_foreign_pack` VALUES ('33', '2', 'gbook12', '页面自动 %s跳转%s 等待时间：', 'cn', '100', '1543890216', '1543890216');
INSERT INTO `ey_foreign_pack` VALUES ('34', '2', 'gbook12', 'Page automatic %sjump%s waiting time：', 'en', '100', '1543890216', '1543890216');
INSERT INTO `ey_foreign_pack` VALUES ('35', '2', 'gbook13', '%s至少选择一项！', 'cn', '100', '1543890216', '1543890216');
INSERT INTO `ey_foreign_pack` VALUES ('36', '2', 'gbook13', 'Select at least one item to %s', 'en', '100', '1543890216', '1543890216');
INSERT INTO `ey_foreign_pack` VALUES ('37', '2', 'gbook14', '请选择%s', 'cn', '100', '1543890216', '1543890216');
INSERT INTO `ey_foreign_pack` VALUES ('38', '2', 'gbook14', 'Please select %s', 'en', '100', '1543890216', '1543890216');
INSERT INTO `ey_foreign_pack` VALUES ('39', '2', 'gbook15', '请输入正确的手机号码！', 'cn', '100', '1543890216', '1543890216');
INSERT INTO `ey_foreign_pack` VALUES ('40', '2', 'gbook15', 'Please enter the correct mobile number！', 'en', '100', '1543890216', '1543890216');
INSERT INTO `ey_foreign_pack` VALUES ('41', '2', 'gbook16', '图片验证码', 'cn', '100', '1543890216', '1543890216');
INSERT INTO `ey_foreign_pack` VALUES ('42', '2', 'gbook16', 'Picture verification code', 'en', '100', '1543890216', '1543890216');
INSERT INTO `ey_foreign_pack` VALUES ('43', '2', 'gbook17', '手机验证码', 'cn', '100', '1543890216', '1543890216');
INSERT INTO `ey_foreign_pack` VALUES ('44', '2', 'gbook17', 'Mobile verification code', 'en', '100', '1543890216', '1543890216');
INSERT INTO `ey_foreign_pack` VALUES ('45', '2', 'gbook18', '获取验证码', 'cn', '100', '1543890216', '1543890216');
INSERT INTO `ey_foreign_pack` VALUES ('46', '2', 'gbook18', 'Get verification code', 'en', '100', '1543890216', '1543890216');
INSERT INTO `ey_foreign_pack` VALUES ('47', '2', 'gbook19', '看不清？点击更换验证码', 'cn', '100', '1543890216', '1543890216');
INSERT INTO `ey_foreign_pack` VALUES ('48', '2', 'gbook19', 'Can\'t see clearly? Click to change the verification code', 'en', '100', '1543890216', '1543890216');
INSERT INTO `ey_foreign_pack` VALUES ('49', '2', 'gbook20', '看不清？%s点击更换%s', 'cn', '100', '1543890216', '1543890216');
INSERT INTO `ey_foreign_pack` VALUES ('50', '2', 'gbook20', 'Can\'t see clearly? %sClick to replace%s', 'en', '100', '1543890216', '1543890216');
INSERT INTO `ey_foreign_pack` VALUES ('51', '1', 'page6', '第%s页', 'cn', '100', '1543890216', '1543890216');
INSERT INTO `ey_foreign_pack` VALUES ('52', '1', 'page6', '%s', 'en', '100', '1543890216', '1543890216');
INSERT INTO `ey_foreign_pack` VALUES ('53', '3', 'system1', '图', 'cn', '100', '1543890216', '1543890216');
INSERT INTO `ey_foreign_pack` VALUES ('54', '3', 'system1', 'pic', 'en', '100', '1543890216', '1543890216');
INSERT INTO `ey_foreign_pack` VALUES ('55', '3', 'system2', '确定', 'cn', '100', '1543890216', '1704164971');
INSERT INTO `ey_foreign_pack` VALUES ('56', '3', 'system2', 'ok', 'en', '100', '1543890216', '1706859563');
INSERT INTO `ey_foreign_pack` VALUES ('57', '3', 'system3', '取消', 'cn', '100', '1543890216', '1704164971');
INSERT INTO `ey_foreign_pack` VALUES ('58', '3', 'system3', 'cancel', 'en', '100', '1543890216', '1704164971');
INSERT INTO `ey_foreign_pack` VALUES ('59', '4', 'users1', '您的购物车还没有商品！', 'cn', '100', '1543890216', '1704164971');
INSERT INTO `ey_foreign_pack` VALUES ('60', '4', 'users1', 'Your shopping cart doesn\'t have any products yet!', 'en', '100', '1543890216', '1704164971');
INSERT INTO `ey_foreign_pack` VALUES ('61', '3', 'system4', '提示', 'cn', '100', '1543890216', '1704164971');
INSERT INTO `ey_foreign_pack` VALUES ('62', '3', 'system4', 'prompt', 'en', '100', '1543890216', '1704164971');
INSERT INTO `ey_foreign_pack` VALUES ('63', '4', 'users2', '%s不能为空！', 'cn', '100', '1543890216', '1543890216');
INSERT INTO `ey_foreign_pack` VALUES ('64', '4', 'users2', '%s cannot be empty!', 'en', '100', '1543890216', '1706580800');
INSERT INTO `ey_foreign_pack` VALUES ('65', '4', 'users3', '%s格式不正确！', 'cn', '100', '1543890216', '1543890216');
INSERT INTO `ey_foreign_pack` VALUES ('66', '4', 'users3', '%s Incorrect format!', 'en', '100', '1543890216', '1706580800');
INSERT INTO `ey_foreign_pack` VALUES ('67', '4', 'users4', '邮箱验证码已被使用或超时，请重新发送！', 'cn', '100', '1543890216', '1543890216');
INSERT INTO `ey_foreign_pack` VALUES ('68', '4', 'users4', 'The email verification code has been used or timed out. Please resend it!', 'en', '100', '1543890216', '1706580800');
INSERT INTO `ey_foreign_pack` VALUES ('69', '4', 'users5', '邮箱验证码不正确，请重新输入！', 'cn', '100', '1543890216', '1543890216');
INSERT INTO `ey_foreign_pack` VALUES ('70', '4', 'users5', 'The email verification code is incorrect, please re-enter!', 'en', '100', '1543890216', '1706580800');
INSERT INTO `ey_foreign_pack` VALUES ('71', '4', 'users6', '短信验证码不正确，请重新输入！', 'cn', '100', '1543890216', '1543890216');
INSERT INTO `ey_foreign_pack` VALUES ('72', '4', 'users6', 'The SMS verification code is incorrect, please re-enter!', 'en', '100', '1543890216', '1706580800');
INSERT INTO `ey_foreign_pack` VALUES ('73', '4', 'users7', '%s已存在！', 'cn', '100', '1543890216', '1543890216');
INSERT INTO `ey_foreign_pack` VALUES ('74', '4', 'users7', '%s already exists!', 'en', '100', '1543890216', '1706580800');
INSERT INTO `ey_foreign_pack` VALUES ('75', '3', 'system5', '是', 'cn', '100', '1543890216', '1543890216');
INSERT INTO `ey_foreign_pack` VALUES ('76', '3', 'system5', 'yes', 'en', '100', '1543890216', '1706580800');
INSERT INTO `ey_foreign_pack` VALUES ('77', '3', 'system6', '否', 'cn', '100', '1543890216', '1543890216');
INSERT INTO `ey_foreign_pack` VALUES ('78', '3', 'system6', 'no', 'en', '100', '1543890216', '1706580800');
INSERT INTO `ey_foreign_pack` VALUES ('79', '4', 'users8', '签到成功', 'cn', '100', '1543890216', '1543890216');
INSERT INTO `ey_foreign_pack` VALUES ('80', '4', 'users8', 'Successful check-in', 'en', '100', '1543890216', '1706580800');
INSERT INTO `ey_foreign_pack` VALUES ('81', '4', 'users9', '今日已签过到', 'cn', '100', '1543890216', '1543890216');
INSERT INTO `ey_foreign_pack` VALUES ('82', '4', 'users9', 'Signed in today', 'en', '100', '1543890216', '1706580800');
INSERT INTO `ey_foreign_pack` VALUES ('83', '3', 'system7', '请至少选择一项！', 'cn', '100', '1543890216', '1543890216');
INSERT INTO `ey_foreign_pack` VALUES ('84', '3', 'system7', 'Please select at least one item!', 'en', '100', '1543890216', '1706580800');
INSERT INTO `ey_foreign_pack` VALUES ('85', '4', 'users10', '是否删除该收藏？', 'cn', '100', '1543890216', '1543890216');
INSERT INTO `ey_foreign_pack` VALUES ('86', '4', 'users10', 'Do you want to delete this collection?', 'en', '100', '1543890216', '1706580800');
INSERT INTO `ey_foreign_pack` VALUES ('87', '4', 'users11', '确认批量删除收藏？', 'cn', '100', '1543890216', '1543890216');
INSERT INTO `ey_foreign_pack` VALUES ('88', '4', 'users11', 'Confirm bulk deletion of favorites?', 'en', '100', '1543890216', '1706580800');
INSERT INTO `ey_foreign_pack` VALUES ('89', '3', 'system8', '正在处理', 'cn', '100', '1543890216', '1543890216');
INSERT INTO `ey_foreign_pack` VALUES ('90', '3', 'system8', 'Processing', 'en', '100', '1543890216', '1706580800');
INSERT INTO `ey_foreign_pack` VALUES ('91', '3', 'system9', '请勿刷新页面', 'cn', '100', '1543890216', '1543890216');
INSERT INTO `ey_foreign_pack` VALUES ('92', '3', 'system9', 'Do not refresh', 'en', '100', '1543890216', '1706580800');
INSERT INTO `ey_foreign_pack` VALUES ('93', '4', 'users12', '每日签到', 'cn', '100', '1543890216', '1543890216');
INSERT INTO `ey_foreign_pack` VALUES ('94', '4', 'users12', 'Daily Attendance', 'en', '100', '1543890216', '1706580800');
INSERT INTO `ey_foreign_pack` VALUES ('95', '3', 'system10', '上传成功', 'cn', '100', '1543890216', '1543890216');
INSERT INTO `ey_foreign_pack` VALUES ('96', '3', 'system10', 'Upload successful', 'en', '100', '1543890216', '1706580800');
INSERT INTO `ey_foreign_pack` VALUES ('97', '4', 'users13', '充值金额不能为空！', 'cn', '100', '1543890216', '1543890216');
INSERT INTO `ey_foreign_pack` VALUES ('98', '4', 'users13', 'Recharge amount cannot be empty!', 'en', '100', '1543890216', '1706580800');
INSERT INTO `ey_foreign_pack` VALUES ('99', '4', 'users14', '请输入正确的充值金额！', 'cn', '100', '1543890216', '1543890216');
INSERT INTO `ey_foreign_pack` VALUES ('100', '4', 'users14', 'Please enter the correct recharge amount!', 'en', '100', '1543890216', '1706580800');
INSERT INTO `ey_foreign_pack` VALUES ('101', '4', 'users15', '请选择支付方式！', 'cn', '100', '1543890216', '1543890216');
INSERT INTO `ey_foreign_pack` VALUES ('102', '4', 'users15', 'Please choose a payment method!', 'en', '100', '1543890216', '1706580800');
INSERT INTO `ey_foreign_pack` VALUES ('103', '4', 'users16', '用户名不能为空！', 'cn', '100', '1543890216', '1543890216');
INSERT INTO `ey_foreign_pack` VALUES ('104', '4', 'users16', 'The username cannot be empty!', 'en', '100', '1543890216', '1706580800');
INSERT INTO `ey_foreign_pack` VALUES ('105', '4', 'users17', '用户名不正确！', 'cn', '100', '1543890216', '1543890216');
INSERT INTO `ey_foreign_pack` VALUES ('106', '4', 'users17', 'The username is incorrect!', 'en', '100', '1543890216', '1706580800');
INSERT INTO `ey_foreign_pack` VALUES ('107', '4', 'users18', '密码不能为空！', 'cn', '100', '1543890216', '1543890216');
INSERT INTO `ey_foreign_pack` VALUES ('108', '4', 'users18', 'Password cannot be empty!', 'en', '100', '1543890216', '1706580800');
INSERT INTO `ey_foreign_pack` VALUES ('109', '4', 'users19', '图片验证码不能为空！', 'cn', '100', '1543890216', '1543890216');
INSERT INTO `ey_foreign_pack` VALUES ('110', '4', 'users19', 'The image verification code cannot be empty!', 'en', '100', '1543890216', '1706580800');
INSERT INTO `ey_foreign_pack` VALUES ('111', '4', 'users20', '图片验证码错误', 'cn', '100', '1543890216', '1543890216');
INSERT INTO `ey_foreign_pack` VALUES ('112', '4', 'users20', 'Image verification code error', 'en', '100', '1543890216', '1706580800');
INSERT INTO `ey_foreign_pack` VALUES ('113', '4', 'users21', '前台禁止管理员登录！', 'cn', '100', '1543890216', '1543890216');
INSERT INTO `ey_foreign_pack` VALUES ('114', '4', 'users21', 'The front desk prohibits administrators from logging in!', 'en', '100', '1543890216', '1706580800');
INSERT INTO `ey_foreign_pack` VALUES ('115', '4', 'users22', '该会员尚未激活，请联系管理员！', 'cn', '100', '1543890216', '1543890216');
INSERT INTO `ey_foreign_pack` VALUES ('116', '4', 'users22', 'This member has not been activated yet. Please contact the administrator!', 'en', '100', '1543890216', '1706580800');
INSERT INTO `ey_foreign_pack` VALUES ('117', '4', 'users23', '管理员审核中，请稍等！', 'cn', '100', '1543890216', '1543890216');
INSERT INTO `ey_foreign_pack` VALUES ('118', '4', 'users23', 'Administrator review in progress, please wait!', 'en', '100', '1543890216', '1706580800');
INSERT INTO `ey_foreign_pack` VALUES ('119', '4', 'users24', '登录成功', 'cn', '100', '1543890216', '1543890216');
INSERT INTO `ey_foreign_pack` VALUES ('120', '4', 'users24', 'Login succeeded', 'en', '100', '1543890216', '1706580800');
INSERT INTO `ey_foreign_pack` VALUES ('121', '4', 'users25', '密码不正确！', 'cn', '100', '1543890216', '1543890216');
INSERT INTO `ey_foreign_pack` VALUES ('122', '4', 'users25', 'The password is incorrect!', 'en', '100', '1543890216', '1706580800');
INSERT INTO `ey_foreign_pack` VALUES ('123', '4', 'users26', '该用户名不存在，请注册！', 'cn', '100', '1543890216', '1543890216');
INSERT INTO `ey_foreign_pack` VALUES ('124', '4', 'users26', 'The username does not exist, please register!', 'en', '100', '1543890216', '1706580800');
INSERT INTO `ey_foreign_pack` VALUES ('125', '4', 'users27', '看不清？点击更换验证码', 'cn', '100', '1543890216', '1543890216');
INSERT INTO `ey_foreign_pack` VALUES ('126', '4', 'users27', 'Can\'t see clearly? Click to change the verification code', 'en', '100', '1543890216', '1706580800');
INSERT INTO `ey_foreign_pack` VALUES ('127', '4', 'users28', '手机号码不能为空！', 'cn', '100', '1543890216', '1543890216');
INSERT INTO `ey_foreign_pack` VALUES ('128', '4', 'users28', 'Mobile phone number cannot be empty!', 'en', '100', '1543890216', '1706580800');
INSERT INTO `ey_foreign_pack` VALUES ('129', '4', 'users29', '手机号码格式不正确！', 'cn', '100', '1543890216', '1543890216');
INSERT INTO `ey_foreign_pack` VALUES ('130', '4', 'users29', 'The phone number format is incorrect!', 'en', '100', '1543890216', '1706580800');
INSERT INTO `ey_foreign_pack` VALUES ('131', '4', 'users30', '手机验证码不能为空！', 'cn', '100', '1543890216', '1543890216');
INSERT INTO `ey_foreign_pack` VALUES ('132', '4', 'users30', 'Mobile verification code cannot be empty!', 'en', '100', '1543890216', '1706580800');
INSERT INTO `ey_foreign_pack` VALUES ('133', '4', 'users31', '手机验证码已失效！', 'cn', '100', '1543890216', '1543890216');
INSERT INTO `ey_foreign_pack` VALUES ('134', '4', 'users31', 'The mobile verification code has expired!', 'en', '100', '1543890216', '1706580800');
INSERT INTO `ey_foreign_pack` VALUES ('135', '4', 'users32', '手机号码已经注册！', 'cn', '100', '1543890216', '1543890216');
INSERT INTO `ey_foreign_pack` VALUES ('136', '4', 'users32', 'The phone number has been registered!', 'en', '100', '1543890216', '1706580800');
INSERT INTO `ey_foreign_pack` VALUES ('137', '4', 'users33', '用户名为系统禁止注册！', 'cn', '100', '1543890216', '1543890216');
INSERT INTO `ey_foreign_pack` VALUES ('138', '4', 'users33', 'The username is prohibited from registration by the system!', 'en', '100', '1543890216', '1706580800');
INSERT INTO `ey_foreign_pack` VALUES ('139', '4', 'users34', '请输入2-30位的汉字、英文、数字、下划线等组合', 'cn', '100', '1543890216', '1543890216');
INSERT INTO `ey_foreign_pack` VALUES ('140', '4', 'users34', 'Please enter a combination of Chinese characters, English characters, numbers, underscores, etc. that are 2-30 digits long', 'en', '100', '1543890216', '1706580800');
INSERT INTO `ey_foreign_pack` VALUES ('141', '4', 'users35', '登录密码不能为空！', 'cn', '100', '1543890216', '1543890216');
INSERT INTO `ey_foreign_pack` VALUES ('142', '4', 'users35', 'Login password cannot be empty!', 'en', '100', '1543890216', '1706580800');
INSERT INTO `ey_foreign_pack` VALUES ('143', '4', 'users36', '重复密码不能为空！', 'cn', '100', '1543890216', '1543890216');
INSERT INTO `ey_foreign_pack` VALUES ('144', '4', 'users36', 'The duplicate password cannot be empty!', 'en', '100', '1543890216', '1706580800');
INSERT INTO `ey_foreign_pack` VALUES ('145', '4', 'users37', '用户名已存在', 'cn', '100', '1543890216', '1543890216');
INSERT INTO `ey_foreign_pack` VALUES ('146', '4', 'users37', 'The username already exists', 'en', '100', '1543890216', '1706580800');
INSERT INTO `ey_foreign_pack` VALUES ('147', '4', 'users38', '两次密码输入不一致！', 'cn', '100', '1543890216', '1543890216');
INSERT INTO `ey_foreign_pack` VALUES ('148', '4', 'users38', 'The two password inputs are inconsistent!', 'en', '100', '1543890216', '1706580800');
INSERT INTO `ey_foreign_pack` VALUES ('149', '4', 'users39', '注册成功，正在跳转中……', 'cn', '100', '1543890216', '1543890216');
INSERT INTO `ey_foreign_pack` VALUES ('150', '4', 'users39', 'Registration successful, jumping in progress……', 'en', '100', '1543890216', '1706580800');
INSERT INTO `ey_foreign_pack` VALUES ('151', '4', 'users40', '注册成功，等管理员激活才能登录！', 'cn', '100', '1543890216', '1543890216');
INSERT INTO `ey_foreign_pack` VALUES ('152', '4', 'users40', 'Registration successful, wait for administrator activation before logging in!', 'en', '100', '1543890216', '1706580800');
INSERT INTO `ey_foreign_pack` VALUES ('153', '4', 'users41', '注册成功，请登录！', 'cn', '100', '1543890216', '1543890216');
INSERT INTO `ey_foreign_pack` VALUES ('154', '4', 'users41', 'Registration successful, please log in!', 'en', '100', '1543890216', '1706580800');
INSERT INTO `ey_foreign_pack` VALUES ('155', '3', 'system11', '操作失败', 'cn', '100', '1543890216', '1543890216');
INSERT INTO `ey_foreign_pack` VALUES ('156', '3', 'system11', 'Operation failed', 'en', '100', '1543890216', '1706580800');
INSERT INTO `ey_foreign_pack` VALUES ('157', '3', 'system12', '操作成功', 'cn', '100', '1543890216', '1543890216');
INSERT INTO `ey_foreign_pack` VALUES ('158', '3', 'system12', 'Operation successful', 'en', '100', '1543890216', '1706580800');
INSERT INTO `ey_foreign_pack` VALUES ('159', '4', 'users42', '昵称不可为纯空格', 'cn', '100', '1543890216', '1543890216');
INSERT INTO `ey_foreign_pack` VALUES ('160', '4', 'users42', 'Nicknames cannot be pure spaces', 'en', '100', '1543890216', '1706580800');
INSERT INTO `ey_foreign_pack` VALUES ('161', '4', 'users43', '原密码不能为空！', 'cn', '100', '1543890216', '1543890216');
INSERT INTO `ey_foreign_pack` VALUES ('162', '4', 'users43', 'The original password cannot be empty!', 'en', '100', '1543890216', '1706580800');
INSERT INTO `ey_foreign_pack` VALUES ('163', '4', 'users44', '新密码不能为空！', 'cn', '100', '1543890216', '1543890216');
INSERT INTO `ey_foreign_pack` VALUES ('164', '4', 'users44', 'The new password cannot be empty!', 'en', '100', '1543890216', '1706580800');
INSERT INTO `ey_foreign_pack` VALUES ('165', '4', 'users45', '手机号码不存在，不能找回密码！', 'cn', '100', '1543890216', '1543890216');
INSERT INTO `ey_foreign_pack` VALUES ('166', '4', 'users45', 'Mobile phone number does not exist, password cannot be retrieved!', 'en', '100', '1543890216', '1706580800');
INSERT INTO `ey_foreign_pack` VALUES ('167', '4', 'users46', '手机号码未绑定，不能找回密码！', 'cn', '100', '1543890216', '1543890216');
INSERT INTO `ey_foreign_pack` VALUES ('168', '4', 'users46', 'Mobile phone number is not bound, password cannot be retrieved!', 'en', '100', '1543890216', '1706580800');
INSERT INTO `ey_foreign_pack` VALUES ('169', '4', 'users47', '手机验证码已被使用或超时，请重新发送！', 'cn', '100', '1543890216', '1543890216');
INSERT INTO `ey_foreign_pack` VALUES ('170', '4', 'users47', 'The mobile verification code has been used or timed out. Please resend it!', 'en', '100', '1543890216', '1706580800');
INSERT INTO `ey_foreign_pack` VALUES ('171', '4', 'users48', '晚上好～', 'cn', '100', '1543890216', '1706580800');
INSERT INTO `ey_foreign_pack` VALUES ('172', '4', 'users48', 'Good evening~', 'en', '100', '1543890216', '1706580800');
INSERT INTO `ey_foreign_pack` VALUES ('173', '4', 'users49', '早上好～', 'cn', '100', '1543890216', '1706580800');
INSERT INTO `ey_foreign_pack` VALUES ('174', '4', 'users49', 'Good morning~', 'en', '100', '1543890216', '1706580800');
INSERT INTO `ey_foreign_pack` VALUES ('175', '4', 'users50', '下午好～', 'cn', '100', '1543890216', '1706580800');
INSERT INTO `ey_foreign_pack` VALUES ('176', '4', 'users50', 'Good afternoon~', 'en', '100', '1543890216', '1706580800');
INSERT INTO `ey_foreign_pack` VALUES ('177', '3', 'system13', '含有敏感词，禁止搜索！', 'cn', '100', '1543890216', '1706580800');
INSERT INTO `ey_foreign_pack` VALUES ('178', '3', 'system13', 'Contains sensitive words, search prohibited!', 'en', '100', '1543890216', '1706580800');
INSERT INTO `ey_foreign_pack` VALUES ('179', '3', 'system14', '过度频繁搜索，离解禁还有%s分钟！', 'cn', '100', '1543890216', '1706580800');
INSERT INTO `ey_foreign_pack` VALUES ('180', '3', 'system14', 'Excessive frequent searches, with %s minutes left before lifting the ban!', 'en', '100', '1543890216', '1706580800');
INSERT INTO `ey_foreign_pack` VALUES ('181', '3', 'system15', '关键词不能为空！', 'cn', '100', '1543890216', '1706580800');
INSERT INTO `ey_foreign_pack` VALUES ('182', '3', 'system15', 'Keywords cannot be empty!', 'en', '100', '1543890216', '1706580800');

-- -----------------------------
-- Table structure for `ey_form`
-- -----------------------------
DROP TABLE IF EXISTS `ey_form`;
CREATE TABLE `ey_form` (
  `form_id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增表单ID',
  `form_name` varchar(255) NOT NULL DEFAULT '' COMMENT '表单名称',
  `intro` text NOT NULL COMMENT '表单描述，预留',
  `status` tinyint(1) NOT NULL DEFAULT '1' COMMENT '表单状态，0关闭，1开启',
  `attr_auto` tinyint(1) DEFAULT '0' COMMENT '自动标签：0=否，1=是',
  `lang` varchar(10) NOT NULL DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) NOT NULL DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) NOT NULL DEFAULT '0' COMMENT '更新时间',
  `open_reply` tinyint(1) DEFAULT '0' COMMENT '是否开启回复 0-未开启,1-开启',
  `open_examine` tinyint(1) DEFAULT '0' COMMENT '是否开启审核 0-不审核,1-审核',
  PRIMARY KEY (`form_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='表单管理表';


-- -----------------------------
-- Table structure for `ey_form_field`
-- -----------------------------
DROP TABLE IF EXISTS `ey_form_field`;
CREATE TABLE `ey_form_field` (
  `field_id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增字段ID',
  `form_id` int(11) unsigned DEFAULT '0' COMMENT '表单管理表ID',
  `field_name` varchar(60) DEFAULT '' COMMENT '字段名称',
  `field_type` varchar(32) DEFAULT '' COMMENT '字段类型',
  `field_value` text COMMENT '可选值列表',
  `is_fill` tinyint(1) unsigned DEFAULT '0' COMMENT '是否必填字段，0非必填，1必填，预留',
  `is_default` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否默认字段，0非默认，1默认，预留',
  `sort_order` int(11) unsigned DEFAULT '100' COMMENT '字段排序，预留',
  `lang` varchar(10) NOT NULL DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`field_id`),
  KEY `form_id` (`form_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='表单字段表';


-- -----------------------------
-- Table structure for `ey_form_list`
-- -----------------------------
DROP TABLE IF EXISTS `ey_form_list`;
CREATE TABLE `ey_form_list` (
  `list_id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增字段ID',
  `form_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '表单管理ID',
  `ip` varchar(255) NOT NULL DEFAULT '' COMMENT 'IP地址',
  `city` varchar(255) NOT NULL DEFAULT '' COMMENT 'IP所在城市',
  `come_from` varchar(100) NOT NULL DEFAULT '' COMMENT '来源页面标题',
  `come_url` varchar(500) NOT NULL DEFAULT '' COMMENT '来源页面链接',
  `is_read` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否已读，预留',
  `lang` varchar(10) NOT NULL DEFAULT 'cn' COMMENT '语言标识',
  `aid` int(11) NOT NULL DEFAULT '0',
  `add_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  `md5data` varchar(50) DEFAULT '' COMMENT '数据序列化之后的MD5加密，提交内容的唯一性',
  PRIMARY KEY (`list_id`),
  KEY `form_id` (`form_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='表单数据主表';


-- -----------------------------
-- Table structure for `ey_form_value`
-- -----------------------------
DROP TABLE IF EXISTS `ey_form_value`;
CREATE TABLE `ey_form_value` (
  `value_id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增字段ID',
  `list_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '表单数据主表ID',
  `form_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '表单管理ID',
  `field_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '表单字段表ID',
  `field_value` text NOT NULL COMMENT '表单数据内容表字段值',
  `lang` varchar(10) NOT NULL DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`value_id`),
  KEY `list_id` (`list_id`) USING BTREE,
  KEY `form_id` (`form_id`) USING BTREE,
  KEY `field_id` (`field_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='表单数据内容表';


-- -----------------------------
-- Table structure for `ey_fuwu_content`
-- -----------------------------
DROP TABLE IF EXISTS `ey_fuwu_content`;
CREATE TABLE `ey_fuwu_content` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `aid` int(10) DEFAULT '0' COMMENT '文档ID',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`),
  KEY `aid` (`aid`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='附加表';


-- -----------------------------
-- Table structure for `ey_guestbook`
-- -----------------------------
DROP TABLE IF EXISTS `ey_guestbook`;
CREATE TABLE `ey_guestbook` (
  `aid` int(11) NOT NULL AUTO_INCREMENT,
  `form_type` tinyint(1) DEFAULT '0' COMMENT '数据分类：0=留言模型，1=自由表单',
  `typeid` int(11) DEFAULT '0' COMMENT '栏目ID/表单ID',
  `channel` smallint(5) DEFAULT '0' COMMENT '模型ID',
  `users_id` int(11) DEFAULT '0' COMMENT '用户id',
  `md5data` varchar(50) DEFAULT '' COMMENT '数据序列化之后的MD5加密，提交内容的唯一性',
  `ip` varchar(255) DEFAULT '' COMMENT 'ip地址',
  `is_read` tinyint(1) DEFAULT '0' COMMENT '0=未读，1=已读',
  `is_star` tinyint(1) DEFAULT '0' COMMENT '标记星号',
  `source` tinyint(1) DEFAULT '0' COMMENT '提交来源：1=电脑端，2=手机端',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  `reply` varchar(1000) DEFAULT '' COMMENT '留言回复内容',
  `admin_id` int(11) DEFAULT '0' COMMENT '回复管理员ID',
  `reply_time` int(11) DEFAULT '0' COMMENT '回复时间',
  `examine` tinyint(1) DEFAULT '1' COMMENT '0-未审核 1-审核通过 2-审核不通过',
  PRIMARY KEY (`aid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='留言主表';


-- -----------------------------
-- Table structure for `ey_guestbook_attr`
-- -----------------------------
DROP TABLE IF EXISTS `ey_guestbook_attr`;
CREATE TABLE `ey_guestbook_attr` (
  `guest_attr_id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '留言表单id自增',
  `aid` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT '留言id',
  `form_type` tinyint(1) DEFAULT '0' COMMENT '数据分类：0=留言模型，1=自由表单',
  `attr_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '表单id',
  `attr_value` text COMMENT '表单值',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`guest_attr_id`),
  KEY `attr_id` (`attr_id`) USING BTREE,
  KEY `guest_id` (`aid`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='留言表单属性值';


-- -----------------------------
-- Table structure for `ey_guestbook_attribute`
-- -----------------------------
DROP TABLE IF EXISTS `ey_guestbook_attribute`;
CREATE TABLE `ey_guestbook_attribute` (
  `attr_id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '表单id',
  `attr_name` varchar(60) DEFAULT '' COMMENT '表单名称',
  `typeid` int(11) unsigned DEFAULT '0' COMMENT '栏目ID/表单ID',
  `form_type` tinyint(1) DEFAULT '0' COMMENT '数据分类：0=留言模型，1=自由表单',
  `attr_input_type` tinyint(1) unsigned DEFAULT '0' COMMENT ' 0=文本框，1=下拉框，2=多行文本框',
  `attr_values` text COMMENT '可选值列表',
  `is_showlist` tinyint(1) DEFAULT '0' COMMENT '在列表显示 0=隐藏，1=显示',
  `required` tinyint(1) DEFAULT '0' COMMENT '必填 0=否，1=是',
  `validate_type` smallint(5) DEFAULT '0' COMMENT '验证格式，0=不验证，1=手机，2=Email',
  `real_validate` tinyint(1) unsigned DEFAULT '0' COMMENT '是否进行真实验证，0=不验证，1=真实验证',
  `sort_order` int(11) unsigned DEFAULT '0' COMMENT '表单排序',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `is_del` tinyint(1) DEFAULT '0' COMMENT '是否已删除，0=否，1=是',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`attr_id`),
  KEY `guest_id` (`typeid`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='留言表单属性';


-- -----------------------------
-- Table structure for `ey_guwen_content`
-- -----------------------------
DROP TABLE IF EXISTS `ey_guwen_content`;
CREATE TABLE `ey_guwen_content` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `aid` int(10) DEFAULT '0' COMMENT '文档ID',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  `diy_cyjy` varchar(200) NOT NULL DEFAULT '' COMMENT '从业经验',
  `diy_cgal` varchar(200) NOT NULL DEFAULT '' COMMENT '成功案例',
  `diy_dh` varchar(200) NOT NULL DEFAULT '' COMMENT '电话',
  `content` longtext COMMENT '详情',
  PRIMARY KEY (`id`),
  KEY `aid` (`aid`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=18 DEFAULT CHARSET=utf8 COMMENT='附加表';

-- -----------------------------
-- Records of `ey_guwen_content`
-- -----------------------------
INSERT INTO `ey_guwen_content` VALUES ('1', '101', '1622787976', '1622787976', '4', '56', '13812345678', '&lt;p&gt;优秀的人，无论生活和工作给他人展示的总是一个态度，即做事踏实和用心。&lt;/p&gt;');
INSERT INTO `ey_guwen_content` VALUES ('3', '103', '1622788158', '1622788158', '5', '76', '13812345678', '&lt;p&gt;做透，揭示了“细中见精”、“小中见大”、“伟大与平凡”的真理。&lt;/p&gt;');
INSERT INTO `ey_guwen_content` VALUES ('2', '102', '1622787971', '1622787971', '3', '58', '13812345678', '&lt;p&gt;优秀的人，无论生活和工作给他人展示的总是一个态度，即做事踏实和用心&lt;/p&gt;');
INSERT INTO `ey_guwen_content` VALUES ('4', '104', '1622788475', '1622788475', '6', '67', '13812345678', '&lt;p&gt;生活和工作给他人展示的总是一个态度，即做事踏实和用心。&lt;/p&gt;');
INSERT INTO `ey_guwen_content` VALUES ('5', '105', '1622788225', '1622788225', '5', '86', '13812345678', '&lt;p&gt;无论生活和工作给他人展示的总是一个态度，即做事踏实和用心。&lt;/p&gt;');
INSERT INTO `ey_guwen_content` VALUES ('6', '106', '1622788253', '1622788253', '5', '58', '13812345678', '&lt;p&gt;无论生活和工作给他人展示的总是一个态度。&lt;/p&gt;');
INSERT INTO `ey_guwen_content` VALUES ('7', '107', '1622788281', '1622788281', '4', '46', '13812345678', '&lt;p&gt;不论做什么工作，都要重视小事、关注细节，把小事做细、做透，揭示了“细中见精”、“小中见大”、“伟大与平凡”的真理。&lt;/p&gt;');
INSERT INTO `ey_guwen_content` VALUES ('8', '108', '1622788320', '1622788320', '6', '72', '13812345678', '&lt;p&gt;公司经营范围为股权投资、债权投资、项目投资、资产管理、企业并购重组、投资管理及咨询和理财信息咨询。 金融作为联想控股成员企业，把为中小企业融资融智，推动实体经济发展。&lt;/p&gt;');
INSERT INTO `ey_guwen_content` VALUES ('9', '109', '1622788354', '1622788354', '6', '113', '13812345678', '&lt;p&gt;优秀的人，无论生活和工作给他人展示的总是一个态度，即做事踏实和用心。不论做什么工作，都要重视小事、关注细节，把小事做细、做透，揭示了“细中见精”、“小中见大”、“伟大与平凡”的真理。&lt;/p&gt;');
INSERT INTO `ey_guwen_content` VALUES ('10', '110', '1622788394', '1622788394', '6', '164', '13812345678', '&lt;p&gt;优秀的人，无论生活和工作给他人展示的总是一个态度，即做事踏实和用心。不论做什么工作，都要重视小事、关注细节，把小事做细、做透，揭示了“细中见精”、“小中见大”、“伟大与平凡”的真理。&lt;/p&gt;');
INSERT INTO `ey_guwen_content` VALUES ('11', '111', '1622788422', '1622788422', '4', '76', '13812345678', '&lt;p&gt;工作给他人展示的总是一个态度，即做事踏实和用心。不论做什么工作，都要重视小事、关注细节，把小事做细、做透，揭示了“细中见精”、“小中见大”、“伟大与平凡”的真理。&lt;/p&gt;');
INSERT INTO `ey_guwen_content` VALUES ('12', '112', '1622788459', '1622788459', '5', '96', '13812345678', '&lt;p&gt;无论生活和工作给他人展示的总是一个态度，即做事踏实和用心。不论做什么工作，都要重视小事、关注细节.&lt;/p&gt;');
INSERT INTO `ey_guwen_content` VALUES ('13', '113', '1622788664', '1622788664', '6', '135', '13812345678', '&lt;p&gt;优秀的人，无论生活和工作给他人展示的总是一个态度，即做事踏实和用心。不论做什么工作，都要重视小事、关注细节，把小事做细、做透，揭示了“细中见精”、“小中见大”、“伟大与平凡”的真理。&lt;/p&gt;');
INSERT INTO `ey_guwen_content` VALUES ('14', '114', '1622788722', '1622788722', '3', '76', '13812345678', '&lt;p&gt;优秀的人，无论生活和工作给他人展示的总是一个态度，即做事踏实和用心。不论做什么工作，都要重视小事、关注细节，把小事做细、做透，揭示了“细中见精”、“小中见大”、“伟大与平凡”的真理。&lt;/p&gt;');
INSERT INTO `ey_guwen_content` VALUES ('15', '115', '1622788750', '1622788750', '9', '352', '13812345678', '&lt;p&gt;优秀的人，无论生活和工作给他人展示的总是一个态度，即做事踏实和用心。不论做什么工作，都要重视小事、关注细节，把小事做细、做透，揭示了“细中见精”、“小中见大”、“伟大与平凡”的真理。&lt;/p&gt;');
INSERT INTO `ey_guwen_content` VALUES ('16', '116', '1622788814', '1622788814', '5', '287', '13812345678', '&lt;p&gt;无论生活和工作给他人展示的总是一个态度，即做事踏实和用心。不论做什么工作，都要重视小事、关注细节，把小事做细、做透，揭示了“细中见精”、“小中见大”、“伟大与平凡”的真理。&lt;/p&gt;');
INSERT INTO `ey_guwen_content` VALUES ('17', '117', '1622788851', '1622788851', '6', '276', '13812345678', '&lt;p&gt;不论做什么工作，都要重视小事、关注细节，把小事做细、做透，揭示了“细中见精”、“小中见大”、“伟大与平凡”的真理。&lt;/p&gt;');

-- -----------------------------
-- Table structure for `ey_hezuo_content`
-- -----------------------------
DROP TABLE IF EXISTS `ey_hezuo_content`;
CREATE TABLE `ey_hezuo_content` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `aid` int(10) DEFAULT '0' COMMENT '文档ID',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`),
  KEY `aid` (`aid`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=9 DEFAULT CHARSET=utf8 COMMENT='附加表';

-- -----------------------------
-- Records of `ey_hezuo_content`
-- -----------------------------
INSERT INTO `ey_hezuo_content` VALUES ('1', '66', '1599636856', '1599636856');
INSERT INTO `ey_hezuo_content` VALUES ('2', '67', '1599636870', '1599636870');
INSERT INTO `ey_hezuo_content` VALUES ('3', '68', '1599636881', '1599636881');
INSERT INTO `ey_hezuo_content` VALUES ('4', '69', '1599636893', '1599636893');
INSERT INTO `ey_hezuo_content` VALUES ('5', '70', '1599636904', '1599636904');
INSERT INTO `ey_hezuo_content` VALUES ('6', '71', '1599636918', '1599636918');
INSERT INTO `ey_hezuo_content` VALUES ('7', '72', '1599636930', '1599636930');
INSERT INTO `ey_hezuo_content` VALUES ('8', '73', '1599636943', '1599636943');

-- -----------------------------
-- Table structure for `ey_hooks`
-- -----------------------------
DROP TABLE IF EXISTS `ey_hooks`;
CREATE TABLE `ey_hooks` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键',
  `name` varchar(50) NOT NULL DEFAULT '' COMMENT '钩子名称',
  `description` text COMMENT '描述',
  `module` varchar(50) DEFAULT '' COMMENT '钩子挂载的插件',
  `status` tinyint(1) unsigned DEFAULT '1' COMMENT '状态：0=无效，1=有效',
  `add_time` int(10) DEFAULT NULL,
  `update_time` int(10) unsigned DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`),
  KEY `name` (`name`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='插件钩子表';


-- -----------------------------
-- Table structure for `ey_images17_content`
-- -----------------------------
DROP TABLE IF EXISTS `ey_images17_content`;
CREATE TABLE `ey_images17_content` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `aid` int(10) DEFAULT '0' COMMENT '文档ID',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  `imgurls` text COMMENT '图片集合|10001',
  `content` longtext COMMENT '图集内容',
  PRIMARY KEY (`id`),
  KEY `aid` (`aid`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=7 DEFAULT CHARSET=utf8 COMMENT='附加表';

-- -----------------------------
-- Records of `ey_images17_content`
-- -----------------------------
INSERT INTO `ey_images17_content` VALUES ('1', '1', '1636426759', '1636426759', 'a:2:{i:0;a:2:{s:9:\"image_url\";s:39:\"/uploads/allimg/200730/1-200I01A107.jpg\";s:5:\"intro\";s:0:\"\";}i:1;a:2:{s:9:\"image_url\";s:39:\"/uploads/allimg/200730/1-200I01A112.jpg\";s:5:\"intro\";s:0:\"\";}}', '');
INSERT INTO `ey_images17_content` VALUES ('2', '2', '1636426759', '1636426759', 'a:4:{i:0;a:2:{s:9:\"image_url\";s:39:\"/uploads/allimg/200730/1-200I01G441.jpg\";s:5:\"intro\";s:0:\"\";}i:1;a:2:{s:9:\"image_url\";s:39:\"/uploads/allimg/200730/1-200I01G443.jpg\";s:5:\"intro\";s:0:\"\";}i:2;a:2:{s:9:\"image_url\";s:39:\"/uploads/allimg/200730/1-200I01G445.jpg\";s:5:\"intro\";s:0:\"\";}i:3;a:2:{s:9:\"image_url\";s:39:\"/uploads/allimg/200730/1-200I01G447.jpg\";s:5:\"intro\";s:0:\"\";}}', '');
INSERT INTO `ey_images17_content` VALUES ('3', '3', '1636426759', '1636426759', 'a:2:{i:0;a:2:{s:9:\"image_url\";s:39:\"/uploads/allimg/200730/1-200I01H912.jpg\";s:5:\"intro\";s:0:\"\";}i:1;a:2:{s:9:\"image_url\";s:39:\"/uploads/allimg/200730/1-200I01H914.jpg\";s:5:\"intro\";s:0:\"\";}}', '');
INSERT INTO `ey_images17_content` VALUES ('4', '4', '1636426759', '1636426759', 'a:2:{i:0;a:2:{s:9:\"image_url\";s:39:\"/uploads/allimg/200730/1-200I01I011.jpg\";s:5:\"intro\";s:0:\"\";}i:1;a:2:{s:9:\"image_url\";s:39:\"/uploads/allimg/200730/1-200I01I013.jpg\";s:5:\"intro\";s:0:\"\";}}', '');
INSERT INTO `ey_images17_content` VALUES ('5', '5', '1636426759', '1636426759', 'a:2:{i:0;a:2:{s:9:\"image_url\";s:39:\"/uploads/allimg/200730/1-200I01I059.jpg\";s:5:\"intro\";s:0:\"\";}i:1;a:2:{s:9:\"image_url\";s:39:\"/uploads/allimg/200730/1-200I01I101.jpg\";s:5:\"intro\";s:0:\"\";}}', '');
INSERT INTO `ey_images17_content` VALUES ('6', '6', '1636426759', '1636426759', 'a:2:{i:0;a:2:{s:9:\"image_url\";s:39:\"/uploads/allimg/200730/1-200I01I206.jpg\";s:5:\"intro\";s:0:\"\";}i:1;a:2:{s:9:\"image_url\";s:39:\"/uploads/allimg/200730/1-200I01I208.jpg\";s:5:\"intro\";s:0:\"\";}}', '');

-- -----------------------------
-- Table structure for `ey_images18_content`
-- -----------------------------
DROP TABLE IF EXISTS `ey_images18_content`;
CREATE TABLE `ey_images18_content` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `aid` int(10) DEFAULT '0' COMMENT '文档ID',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  `imgurls` text COMMENT '图片集合|10001',
  `content` longtext COMMENT '图集内容',
  `dizhi` varchar(251) NOT NULL DEFAULT '' COMMENT '地址',
  `jingdu` varchar(251) NOT NULL DEFAULT '' COMMENT '地图经度',
  `weidu` varchar(251) NOT NULL DEFAULT '' COMMENT '地图维度',
  PRIMARY KEY (`id`),
  KEY `aid` (`aid`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 COMMENT='附加表';

-- -----------------------------
-- Records of `ey_images18_content`
-- -----------------------------
INSERT INTO `ey_images18_content` VALUES ('1', '18', '1637133079', '1637133079', 'a:4:{i:0;a:2:{s:9:\"image_url\";s:40:\"/uploads/allimg/200603/1-2006031Q134.jpg\";s:5:\"intro\";s:0:\"\";}i:1;a:2:{s:9:\"image_url\";s:40:\"/uploads/allimg/200603/1-2006031Q135.jpg\";s:5:\"intro\";s:0:\"\";}i:2;a:2:{s:9:\"image_url\";s:40:\"/uploads/allimg/200603/1-2006031Q136.jpg\";s:5:\"intro\";s:0:\"\";}i:3;a:2:{s:9:\"image_url\";s:40:\"/uploads/allimg/200603/1-2006031Q138.jpg\";s:5:\"intro\";s:0:\"\";}}', '&lt;p&gt;\r\n	北京市八宝山殡仪馆是全市规模最大、设施齐全的殡仪服务单位，承担着本市城近郊区市民、已故党和国家领导人、海外侨胞、国际友人的殡仪服务业务。每年承办告别活动6000余场，接待来宾近百万人次，年火化量2万多具。本馆坚持&amp;ldquo;服务第一，丧家至上&amp;rdquo;的宗旨，不断推行科学管理，提高服务质量，受到社会好评，连续多次被评为&amp;ldquo;首都精神文明单位&amp;rdquo;、&amp;ldquo;全国殡葬改革先进单位&amp;rdquo;、&amp;ldquo;北京市花园市单位&amp;rdquo;，2004年被国家民政部评为全国民政基层行风建设先进集体。&lt;/p&gt;\r\n&lt;p&gt;\r\n	　　八宝山殡仪馆始建于1958年，是北京历史上较早的殡仪馆之一。多年来，几经大规模建设改造，已经形成一整套独特的建设风格和服务体系，&amp;ldquo;八宝山&amp;rdquo;因此而成为中国殡葬业的代名词。&lt;/p&gt;\r\n&lt;p&gt;\r\n	　　服务标准：殡仪服务人员要统一着装，仪表端庄，语言文明，挂牌服务；各岗位职责明确，规范服务；遵守职业道德，拒收馈赠，杜绝索取财物。执行国家物价部门规定的收费标准。&lt;/p&gt;\r\n&lt;p&gt;\r\n	　　1、&amp;ldquo;一条龙&amp;rdquo;车辆调度室服务员：使用文明用语，服务态度热情，耐心解答询问，准确叮嘱家属等车时间、地点、注意事项。&lt;/p&gt;\r\n&lt;p&gt;\r\n	　　2、灵车司机：服从调度室安排，准时到达接运遗体地点；文明驾驶，保证车辆平稳不颠簸，转弯和过路口时照顾家属车辆，不甩车。&lt;/p&gt;\r\n&lt;p&gt;\r\n	　　3、引导服务员（接尸工）：接运遗体轻抬轻放；尊重亡者，脱穿衣文明；主动服务，满足要求；排忧解难，耐心周到。&lt;/p&gt;\r\n&lt;p&gt;\r\n	　　4、整容工：一般整容化妆着色均匀、自然、神态安祥、衣着整齐。特殊整容力求恢复原貌达到亡者家属满意。&lt;/p&gt;\r\n&lt;p&gt;\r\n	　　5、告别室服务员：尊重家属要求，协助布置会场；提供必要服务。&lt;/p&gt;\r\n&lt;p&gt;\r\n	　　6、火化工：遵守操作规程，保证骨灰质量。&lt;/p&gt;\r\n&lt;p&gt;\r\n	　　7、售盒服务员：服务态度和蔼，熟悉商品特点，主动介绍商品，满足不同层次的需要。&lt;/p&gt;\r\n&lt;p&gt;\r\n	　　8、刻字工：按要求逐字刻印，字迹清楚，准确无误。&lt;/p&gt;\r\n&lt;p&gt;\r\n	　　9、收银员：认真审核收费项目，填写标据字迹清楚，收款时唱收唱付。&lt;/p&gt;\r\n&lt;p&gt;\r\n	　　10、发灰员：严格按照发灰手续办理，凭火化证发放骨灰。尊重逝者，双手递送，杜绝差错。&lt;/p&gt;\r\n&lt;p&gt;\r\n	　　11、骨灰堂服务员：填写卡片字迹清楚，准确无误；陪同家属到达存骨灰堂室。&lt;/p&gt;\r\n&lt;p&gt;\r\n	　　服务时限：1、全天候二十四小时提供殡仪服务。2、按照丧家要求准时到达接运遗体地点。3、以遗体进入火化车间为准，四小时内取灰。&lt;/p&gt;\r\n&lt;p&gt;\r\n	　　向社会各界郑重承诺：&lt;/p&gt;\r\n&lt;p&gt;\r\n	　　1、加强廉政建设，纠正行业不正之风，严格遵守职业道德规范，不得接受丧家馈增的烟、酒、钱、物。&lt;/p&gt;\r\n&lt;p&gt;\r\n	　　2、坚持优质服务，文明用语，礼貌待人，主动热情，严格按照殡仪服务规范进行工作。&lt;/p&gt;\r\n&lt;p&gt;\r\n	　　3、严格执行国家物价部门规定的收费标准。&lt;/p&gt;\r\n&lt;p&gt;\r\n	　　4、实行面对全市各区县和国内、国际的二十四小时全天候&amp;ldquo;一条龙&amp;rdquo;服务，并保证灵车随叫随到接运遗体（四小时之内）。&lt;/p&gt;\r\n&lt;p&gt;\r\n	　　5、火化遗体保证文明操作，一炉一尸，保证当天取灰（四小时）之内。&lt;/p&gt;\r\n', '北京市石景山区石景山路9号', '113.269251', '23.201809');
INSERT INTO `ey_images18_content` VALUES ('2', '19', '1637133079', '1637133079', 'a:3:{i:0;a:2:{s:9:\"image_url\";s:39:\"/uploads/allimg/200603/1-2006031SS0.jpg\";s:5:\"intro\";s:0:\"\";}i:1;a:2:{s:9:\"image_url\";s:39:\"/uploads/allimg/200603/1-2006031SS3.jpg\";s:5:\"intro\";s:0:\"\";}i:2;a:2:{s:9:\"image_url\";s:39:\"/uploads/allimg/200603/1-2006031SS6.jpg\";s:5:\"intro\";s:0:\"\";}}', '&lt;p&gt;\r\n	北京市八宝山殡仪馆是全市规模最大、设施齐全的殡仪服务单位，承担着本市城近郊区市民、已故党和国家领导人、海外侨胞、国际友人的殡仪服务业务。每年承办告别活动6000余场，接待来宾近百万人次，年火化量2万多具。本馆坚持&amp;ldquo;服务第一，丧家至上&amp;rdquo;的宗旨，不断推行科学管理，提高服务质量，受到社会好评，连续多次被评为&amp;ldquo;首都精神文明单位&amp;rdquo;、&amp;ldquo;全国殡葬改革先进单位&amp;rdquo;、&amp;ldquo;北京市花园市单位&amp;rdquo;，2004年被国家民政部评为全国民政基层行风建设先进集体。&lt;/p&gt;\r\n&lt;p&gt;\r\n	　　八宝山殡仪馆始建于1958年，是北京历史上较早的殡仪馆之一。多年来，几经大规模建设改造，已经形成一整套独特的建设风格和服务体系，&amp;ldquo;八宝山&amp;rdquo;因此而成为中国殡葬业的代名词。&lt;/p&gt;\r\n&lt;p&gt;\r\n	　　服务标准：殡仪服务人员要统一着装，仪表端庄，语言文明，挂牌服务；各岗位职责明确，规范服务；遵守职业道德，拒收馈赠，杜绝索取财物。执行国家物价部门规定的收费标准。&lt;/p&gt;\r\n', '广州市平谷区西峪水库东岸', '113.269251', '23.201809');
INSERT INTO `ey_images18_content` VALUES ('3', '20', '1637133079', '1637133079', 'a:3:{i:0;a:2:{s:9:\"image_url\";s:40:\"/uploads/allimg/200603/1-2006031S923.jpg\";s:5:\"intro\";s:0:\"\";}i:1;a:2:{s:9:\"image_url\";s:40:\"/uploads/allimg/200603/1-2006031S926.jpg\";s:5:\"intro\";s:0:\"\";}i:2;a:2:{s:9:\"image_url\";s:40:\"/uploads/allimg/200603/1-2006031S929.jpg\";s:5:\"intro\";s:0:\"\";}}', '&lt;p&gt;\r\n	北京市八宝山殡仪馆是全市规模最大、设施齐全的殡仪服务单位，承担着本市城近郊区市民、已故党和国家领导人、海外侨胞、国际友人的殡仪服务业务。每年承办告别活动6000余场，接待来宾近百万人次，年火化量2万多具。本馆坚持&amp;ldquo;服务第一，丧家至上&amp;rdquo;的宗旨，不断推行科学管理，提高服务质量，受到社会好评，连续多次被评为&amp;ldquo;首都精神文明单位&amp;rdquo;、&amp;ldquo;全国殡葬改革先进单位&amp;rdquo;、&amp;ldquo;北京市花园市单位&amp;rdquo;，2004年被国家民政部评为全国民政基层行风建设先进集体。&lt;/p&gt;\r\n&lt;p&gt;\r\n	　　八宝山殡仪馆始建于1958年，是北京历史上较早的殡仪馆之一。多年来，几经大规模建设改造，已经形成一整套独特的建设风格和服务体系，&amp;ldquo;八宝山&amp;rdquo;因此而成为中国殡葬业的代名词。&lt;/p&gt;\r\n&lt;p&gt;\r\n	　　服务标准：殡仪服务人员要统一着装，仪表端庄，语言文明，挂牌服务；各岗位职责明确，规范服务；遵守职业道德，拒收馈赠，杜绝索取财物。执行国家物价部门规定的收费标准。&lt;/p&gt;\r\n&lt;p&gt;\r\n	　　1、&amp;ldquo;一条龙&amp;rdquo;车辆调度室服务员：使用文明用语，服务态度热情，耐心解答询问，准确叮嘱家属等车时间、地点、注意事项。&lt;/p&gt;\r\n&lt;p&gt;\r\n	　　2、灵车司机：服从调度室安排，准时到达接运遗体地点；文明驾驶，保证车辆平稳不颠簸，转弯和过路口时照顾家属车辆，不甩车。&lt;/p&gt;\r\n&lt;p&gt;\r\n	　　3、引导服务员（接尸工）：接运遗体轻抬轻放；尊重亡者，脱穿衣文明；主动服务，满足要求；排忧解难，耐心周到。&lt;/p&gt;\r\n&lt;p&gt;\r\n	　　4、整容工：一般整容化妆着色均匀、自然、神态安祥、衣着整齐。特殊整容力求恢复原貌达到亡者家属满意。&lt;/p&gt;\r\n', '广州市平谷区西峪水库东岸', '113.269251', '23.201809');
INSERT INTO `ey_images18_content` VALUES ('4', '21', '1637133079', '1637133079', 'a:3:{i:0;a:2:{s:9:\"image_url\";s:40:\"/uploads/allimg/200603/1-2006031T021.jpg\";s:5:\"intro\";s:0:\"\";}i:1;a:2:{s:9:\"image_url\";s:40:\"/uploads/allimg/200603/1-2006031T024.jpg\";s:5:\"intro\";s:0:\"\";}i:2;a:2:{s:9:\"image_url\";s:40:\"/uploads/allimg/200603/1-2006031T027.jpg\";s:5:\"intro\";s:0:\"\";}}', '&lt;p&gt;\r\n	北京市八宝山殡仪馆是全市规模最大、设施齐全的殡仪服务单位，承担着本市城近郊区市民、已故党和国家领导人、海外侨胞、国际友人的殡仪服务业务。每年承办告别活动6000余场，接待来宾近百万人次，年火化量2万多具。本馆坚持&amp;ldquo;服务第一，丧家至上&amp;rdquo;的宗旨，不断推行科学管理，提高服务质量，受到社会好评，连续多次被评为&amp;ldquo;首都精神文明单位&amp;rdquo;、&amp;ldquo;全国殡葬改革先进单位&amp;rdquo;、&amp;ldquo;北京市花园市单位&amp;rdquo;，2004年被国家民政部评为全国民政基层行风建设先进集体。&lt;/p&gt;\r\n&lt;p&gt;\r\n	　　八宝山殡仪馆始建于1958年，是北京历史上较早的殡仪馆之一。多年来，几经大规模建设改造，已经形成一整套独特的建设风格和服务体系，&amp;ldquo;八宝山&amp;rdquo;因此而成为中国殡葬业的代名词。&lt;/p&gt;\r\n&lt;p&gt;\r\n	　　服务标准：殡仪服务人员要统一着装，仪表端庄，语言文明，挂牌服务；各岗位职责明确，规范服务；遵守职业道德，拒收馈赠，杜绝索取财物。执行国家物价部门规定的收费标准。&lt;/p&gt;\r\n&lt;p&gt;\r\n	　　1、&amp;ldquo;一条龙&amp;rdquo;车辆调度室服务员：使用文明用语，服务态度热情，耐心解答询问，准确叮嘱家属等车时间、地点、注意事项。&lt;/p&gt;\r\n&lt;p&gt;\r\n	　　2、灵车司机：服从调度室安排，准时到达接运遗体地点；文明驾驶，保证车辆平稳不颠簸，转弯和过路口时照顾家属车辆，不甩车。&lt;/p&gt;\r\n&lt;p&gt;\r\n	　　3、引导服务员（接尸工）：接运遗体轻抬轻放；尊重亡者，脱穿衣文明；主动服务，满足要求；排忧解难，耐心周到。&lt;/p&gt;\r\n&lt;p&gt;\r\n	　　4、整容工：一般整容化妆着色均匀、自然、神态安祥、衣着整齐。特殊整容力求恢复原貌达到亡者家属满意。&lt;/p&gt;\r\n&lt;p&gt;\r\n	　　5、告别室服务员：尊重家属要求，协助布置会场；提供必要服务。&lt;/p&gt;\r\n&lt;p&gt;\r\n	　　6、火化工：遵守操作规程，保证骨灰质量。&lt;/p&gt;\r\n&lt;p&gt;\r\n	　　7、售盒服务员：服务态度和蔼，熟悉商品特点，主动介绍商品，满足不同层次的需要。&lt;/p&gt;\r\n&lt;p&gt;\r\n	　　8、刻字工：按要求逐字刻印，字迹清楚，准确无误。&lt;/p&gt;\r\n&lt;p&gt;\r\n	　　9、收银员：认真审核收费项目，填写标据字迹清楚，收款时唱收唱付。&lt;/p&gt;\r\n', '广州市平谷区西峪水库东岸', '113.269251', '23.201809');

-- -----------------------------
-- Table structure for `ey_images_content`
-- -----------------------------
DROP TABLE IF EXISTS `ey_images_content`;
CREATE TABLE `ey_images_content` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `aid` int(10) DEFAULT '0' COMMENT '文档ID',
  `content` longtext COMMENT '内容详情',
  `content_ey_m` longtext COMMENT '手机端内容详情',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`),
  KEY `news_id` (`aid`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='资讯内容表_存储正常内容';


-- -----------------------------
-- Table structure for `ey_images_upload`
-- -----------------------------
DROP TABLE IF EXISTS `ey_images_upload`;
CREATE TABLE `ey_images_upload` (
  `img_id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `aid` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT '图集ID',
  `title` varchar(200) DEFAULT '' COMMENT '产品标题',
  `image_url` varchar(255) DEFAULT '' COMMENT '文件存储路径',
  `intro` varchar(2000) DEFAULT '' COMMENT '图集描述',
  `width` int(11) DEFAULT '0' COMMENT '图片宽度',
  `height` int(11) DEFAULT '0' COMMENT '图片高度',
  `filesize` mediumint(8) unsigned DEFAULT '0' COMMENT '文件大小',
  `mime` varchar(50) DEFAULT '' COMMENT '图片类型',
  `sort_order` smallint(5) DEFAULT '0' COMMENT '排序',
  `add_time` int(10) unsigned DEFAULT '0' COMMENT '上传时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`img_id`),
  KEY `arcid` (`aid`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='图集图片表';


-- -----------------------------
-- Table structure for `ey_language`
-- -----------------------------
DROP TABLE IF EXISTS `ey_language`;
CREATE TABLE `ey_language` (
  `id` int(10) NOT NULL AUTO_INCREMENT COMMENT '信息ID，自增',
  `title` varchar(100) NOT NULL DEFAULT '' COMMENT '语言名称',
  `mark` varchar(50) NOT NULL DEFAULT '' COMMENT '语言标识（唯一）',
  `url` varchar(200) NOT NULL DEFAULT '' COMMENT '单独域名(外部链接)',
  `target` tinyint(1) NOT NULL DEFAULT '0' COMMENT '新窗口打开，0=否，1=是',
  `is_home_default` tinyint(1) DEFAULT '0' COMMENT '默认前台语言，1=是，0=否',
  `is_admin_default` tinyint(1) DEFAULT '0' COMMENT '默认后台语言，1=是，0=否',
  `syn_pack_id` int(10) DEFAULT '0' COMMENT '最后一次同步官方语言包ID',
  `status` tinyint(1) NOT NULL DEFAULT '0' COMMENT '语言状态，0=关闭，1=开启',
  `sort_order` int(10) DEFAULT '0' COMMENT '排序号',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COMMENT='多语言主表';

-- -----------------------------
-- Records of `ey_language`
-- -----------------------------
INSERT INTO `ey_language` VALUES ('1', '简体中文', 'cn', '', '0', '1', '1', '24', '1', '100', '1541583096', '1543890743');
INSERT INTO `ey_language` VALUES ('2', 'English', 'en', '', '0', '0', '0', '24', '1', '100', '1649638737', '1649638740');

-- -----------------------------
-- Table structure for `ey_language_attr`
-- -----------------------------
DROP TABLE IF EXISTS `ey_language_attr`;
CREATE TABLE `ey_language_attr` (
  `id` int(10) NOT NULL AUTO_INCREMENT COMMENT '信息ID，自增',
  `attr_name` varchar(200) NOT NULL DEFAULT '' COMMENT '来自ey_weapp_language_attr表的attr_name',
  `attr_value` text NOT NULL COMMENT '变量值',
  `attr_group` varchar(50) DEFAULT '' COMMENT '分组，以表名划分（不含表前缀）',
  `lang` varchar(50) NOT NULL DEFAULT '' COMMENT '所属语言',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`),
  KEY `attr_value` (`attr_name`,`lang`)
) ENGINE=MyISAM AUTO_INCREMENT=135 DEFAULT CHARSET=utf8 COMMENT='多语言模板变量关联绑定表';

-- -----------------------------
-- Records of `ey_language_attr`
-- -----------------------------
INSERT INTO `ey_language_attr` VALUES ('1', 'tid2', '2', 'arctype', 'cn', '1649638717', '1649638717');
INSERT INTO `ey_language_attr` VALUES ('2', 'tid3', '3', 'arctype', 'cn', '1649638717', '1649638717');
INSERT INTO `ey_language_attr` VALUES ('3', 'tid4', '4', 'arctype', 'cn', '1649638717', '1649638717');
INSERT INTO `ey_language_attr` VALUES ('4', 'tid5', '5', 'arctype', 'cn', '1649638717', '1649638717');
INSERT INTO `ey_language_attr` VALUES ('5', 'tid6', '6', 'arctype', 'cn', '1649638717', '1649638717');
INSERT INTO `ey_language_attr` VALUES ('6', 'tid7', '7', 'arctype', 'cn', '1649638717', '1649638717');
INSERT INTO `ey_language_attr` VALUES ('7', 'tid8', '8', 'arctype', 'cn', '1649638717', '1649638717');
INSERT INTO `ey_language_attr` VALUES ('8', 'tid9', '9', 'arctype', 'cn', '1649638717', '1649638717');
INSERT INTO `ey_language_attr` VALUES ('9', 'tid10', '10', 'arctype', 'cn', '1649638717', '1649638717');
INSERT INTO `ey_language_attr` VALUES ('10', 'tid11', '11', 'arctype', 'cn', '1649638717', '1649638717');
INSERT INTO `ey_language_attr` VALUES ('11', 'tid12', '12', 'arctype', 'cn', '1649638717', '1649638717');
INSERT INTO `ey_language_attr` VALUES ('12', 'tid13', '13', 'arctype', 'cn', '1649638717', '1649638717');
INSERT INTO `ey_language_attr` VALUES ('13', 'tid14', '14', 'arctype', 'cn', '1649638717', '1649638717');
INSERT INTO `ey_language_attr` VALUES ('14', 'tid15', '15', 'arctype', 'cn', '1649638717', '1649638717');
INSERT INTO `ey_language_attr` VALUES ('15', 'tid16', '16', 'arctype', 'cn', '1649638717', '1649638717');
INSERT INTO `ey_language_attr` VALUES ('16', 'tid17', '17', 'arctype', 'cn', '1649638717', '1649638717');
INSERT INTO `ey_language_attr` VALUES ('17', 'tid18', '18', 'arctype', 'cn', '1649638717', '1649638717');
INSERT INTO `ey_language_attr` VALUES ('18', 'tid19', '19', 'arctype', 'cn', '1649638717', '1649638717');
INSERT INTO `ey_language_attr` VALUES ('19', 'tid20', '20', 'arctype', 'cn', '1649638717', '1649638717');
INSERT INTO `ey_language_attr` VALUES ('20', 'tid21', '21', 'arctype', 'cn', '1649638717', '1649638717');
INSERT INTO `ey_language_attr` VALUES ('21', 'tid22', '22', 'arctype', 'cn', '1649638717', '1649638717');
INSERT INTO `ey_language_attr` VALUES ('22', 'tid23', '23', 'arctype', 'cn', '1649638717', '1649638717');
INSERT INTO `ey_language_attr` VALUES ('23', 'tid24', '24', 'arctype', 'cn', '1649638717', '1649638717');
INSERT INTO `ey_language_attr` VALUES ('24', 'tid25', '25', 'arctype', 'cn', '1649638717', '1649638717');
INSERT INTO `ey_language_attr` VALUES ('25', 'tid26', '26', 'arctype', 'cn', '1649638717', '1649638717');
INSERT INTO `ey_language_attr` VALUES ('26', 'tid27', '27', 'arctype', 'cn', '1649638717', '1649638717');
INSERT INTO `ey_language_attr` VALUES ('27', 'tid28', '28', 'arctype', 'cn', '1649638717', '1649638717');
INSERT INTO `ey_language_attr` VALUES ('28', 'tid29', '29', 'arctype', 'cn', '1649638717', '1649638717');
INSERT INTO `ey_language_attr` VALUES ('29', 'tid30', '30', 'arctype', 'cn', '1649638717', '1649638717');
INSERT INTO `ey_language_attr` VALUES ('30', 'tid31', '31', 'arctype', 'cn', '1649638717', '1649638717');
INSERT INTO `ey_language_attr` VALUES ('31', 'tid32', '32', 'arctype', 'cn', '1649638717', '1649638717');
INSERT INTO `ey_language_attr` VALUES ('32', 'tid33', '33', 'arctype', 'cn', '1649638717', '1649638717');
INSERT INTO `ey_language_attr` VALUES ('33', 'tid34', '34', 'arctype', 'cn', '1649638717', '1649638717');
INSERT INTO `ey_language_attr` VALUES ('34', 'tid35', '35', 'arctype', 'cn', '1649638717', '1649638717');
INSERT INTO `ey_language_attr` VALUES ('35', 'tid36', '36', 'arctype', 'cn', '1649638717', '1649638717');
INSERT INTO `ey_language_attr` VALUES ('36', 'tid37', '37', 'arctype', 'cn', '1649638717', '1649638717');
INSERT INTO `ey_language_attr` VALUES ('37', 'tid38', '38', 'arctype', 'cn', '1649638717', '1649638717');
INSERT INTO `ey_language_attr` VALUES ('38', 'tid39', '39', 'arctype', 'cn', '1649638717', '1649638717');
INSERT INTO `ey_language_attr` VALUES ('39', 'tid40', '40', 'arctype', 'cn', '1649638717', '1649638717');
INSERT INTO `ey_language_attr` VALUES ('40', 'tid41', '41', 'arctype', 'cn', '1649638717', '1649638717');
INSERT INTO `ey_language_attr` VALUES ('41', 'tid42', '42', 'arctype', 'cn', '1649638717', '1649638717');
INSERT INTO `ey_language_attr` VALUES ('42', 'tid43', '43', 'arctype', 'cn', '1649638717', '1649638717');
INSERT INTO `ey_language_attr` VALUES ('43', 'tid44', '44', 'arctype', 'cn', '1649638717', '1649638717');
INSERT INTO `ey_language_attr` VALUES ('44', 'tid45', '45', 'arctype', 'cn', '1649638717', '1649638717');
INSERT INTO `ey_language_attr` VALUES ('45', 'tid46', '46', 'arctype', 'cn', '1649638717', '1649638717');
INSERT INTO `ey_language_attr` VALUES ('46', 'tid47', '47', 'arctype', 'cn', '1649638717', '1649638717');
INSERT INTO `ey_language_attr` VALUES ('47', 'tid48', '48', 'arctype', 'cn', '1649638717', '1649638717');
INSERT INTO `ey_language_attr` VALUES ('48', 'tid3', '49', 'arctype', 'en', '1649638737', '1649638737');
INSERT INTO `ey_language_attr` VALUES ('49', 'tid15', '50', 'arctype', 'en', '1649638737', '1649638737');
INSERT INTO `ey_language_attr` VALUES ('50', 'tid16', '51', 'arctype', 'en', '1649638737', '1649638737');
INSERT INTO `ey_language_attr` VALUES ('51', 'tid17', '52', 'arctype', 'en', '1649638737', '1649638737');
INSERT INTO `ey_language_attr` VALUES ('52', 'tid18', '53', 'arctype', 'en', '1649638737', '1649638737');
INSERT INTO `ey_language_attr` VALUES ('53', 'tid4', '54', 'arctype', 'en', '1649638737', '1649638737');
INSERT INTO `ey_language_attr` VALUES ('54', 'tid19', '55', 'arctype', 'en', '1649638737', '1649638737');
INSERT INTO `ey_language_attr` VALUES ('55', 'tid20', '56', 'arctype', 'en', '1649638737', '1649638737');
INSERT INTO `ey_language_attr` VALUES ('56', 'tid21', '57', 'arctype', 'en', '1649638737', '1649638737');
INSERT INTO `ey_language_attr` VALUES ('57', 'tid5', '58', 'arctype', 'en', '1649638737', '1649638737');
INSERT INTO `ey_language_attr` VALUES ('58', 'tid22', '59', 'arctype', 'en', '1649638737', '1649638737');
INSERT INTO `ey_language_attr` VALUES ('59', 'tid23', '60', 'arctype', 'en', '1649638737', '1649638737');
INSERT INTO `ey_language_attr` VALUES ('60', 'tid24', '61', 'arctype', 'en', '1649638737', '1649638737');
INSERT INTO `ey_language_attr` VALUES ('61', 'tid25', '62', 'arctype', 'en', '1649638737', '1649638737');
INSERT INTO `ey_language_attr` VALUES ('62', 'tid6', '63', 'arctype', 'en', '1649638737', '1649638737');
INSERT INTO `ey_language_attr` VALUES ('63', 'tid26', '64', 'arctype', 'en', '1649638737', '1649638737');
INSERT INTO `ey_language_attr` VALUES ('64', 'tid27', '65', 'arctype', 'en', '1649638737', '1649638737');
INSERT INTO `ey_language_attr` VALUES ('65', 'tid28', '66', 'arctype', 'en', '1649638737', '1649638737');
INSERT INTO `ey_language_attr` VALUES ('66', 'tid7', '67', 'arctype', 'en', '1649638737', '1649638737');
INSERT INTO `ey_language_attr` VALUES ('67', 'tid29', '68', 'arctype', 'en', '1649638737', '1649638737');
INSERT INTO `ey_language_attr` VALUES ('68', 'tid30', '69', 'arctype', 'en', '1649638737', '1649638737');
INSERT INTO `ey_language_attr` VALUES ('69', 'tid8', '70', 'arctype', 'en', '1649638737', '1649638737');
INSERT INTO `ey_language_attr` VALUES ('70', 'tid2', '71', 'arctype', 'en', '1649638737', '1649638737');
INSERT INTO `ey_language_attr` VALUES ('71', 'tid9', '72', 'arctype', 'en', '1649638737', '1649638737');
INSERT INTO `ey_language_attr` VALUES ('72', 'tid31', '73', 'arctype', 'en', '1649638737', '1649638737');
INSERT INTO `ey_language_attr` VALUES ('73', 'tid32', '74', 'arctype', 'en', '1649638737', '1649638737');
INSERT INTO `ey_language_attr` VALUES ('74', 'tid33', '75', 'arctype', 'en', '1649638737', '1649638737');
INSERT INTO `ey_language_attr` VALUES ('75', 'tid34', '76', 'arctype', 'en', '1649638737', '1649638737');
INSERT INTO `ey_language_attr` VALUES ('76', 'tid10', '77', 'arctype', 'en', '1649638737', '1649638737');
INSERT INTO `ey_language_attr` VALUES ('77', 'tid35', '78', 'arctype', 'en', '1649638737', '1649638737');
INSERT INTO `ey_language_attr` VALUES ('78', 'tid36', '79', 'arctype', 'en', '1649638737', '1649638737');
INSERT INTO `ey_language_attr` VALUES ('79', 'tid37', '80', 'arctype', 'en', '1649638737', '1649638737');
INSERT INTO `ey_language_attr` VALUES ('80', 'tid11', '81', 'arctype', 'en', '1649638737', '1649638737');
INSERT INTO `ey_language_attr` VALUES ('81', 'tid38', '82', 'arctype', 'en', '1649638737', '1649638737');
INSERT INTO `ey_language_attr` VALUES ('82', 'tid39', '83', 'arctype', 'en', '1649638737', '1649638737');
INSERT INTO `ey_language_attr` VALUES ('83', 'tid40', '84', 'arctype', 'en', '1649638737', '1649638737');
INSERT INTO `ey_language_attr` VALUES ('84', 'tid41', '85', 'arctype', 'en', '1649638737', '1649638737');
INSERT INTO `ey_language_attr` VALUES ('85', 'tid12', '86', 'arctype', 'en', '1649638737', '1649638737');
INSERT INTO `ey_language_attr` VALUES ('86', 'tid42', '87', 'arctype', 'en', '1649638737', '1649638737');
INSERT INTO `ey_language_attr` VALUES ('87', 'tid43', '88', 'arctype', 'en', '1649638737', '1649638737');
INSERT INTO `ey_language_attr` VALUES ('88', 'tid44', '89', 'arctype', 'en', '1649638737', '1649638737');
INSERT INTO `ey_language_attr` VALUES ('89', 'tid13', '90', 'arctype', 'en', '1649638737', '1649638737');
INSERT INTO `ey_language_attr` VALUES ('90', 'tid45', '91', 'arctype', 'en', '1649638737', '1649638737');
INSERT INTO `ey_language_attr` VALUES ('91', 'tid46', '92', 'arctype', 'en', '1649638737', '1649638737');
INSERT INTO `ey_language_attr` VALUES ('92', 'tid14', '93', 'arctype', 'en', '1649638737', '1649638737');
INSERT INTO `ey_language_attr` VALUES ('93', 'tid47', '94', 'arctype', 'en', '1649638737', '1649638737');
INSERT INTO `ey_language_attr` VALUES ('94', 'tid48', '95', 'arctype', 'en', '1649638737', '1649638737');
INSERT INTO `ey_language_attr` VALUES ('95', 'linksgroup1', '9', 'links_group', 'en', '1649638737', '1649638737');
INSERT INTO `ey_language_attr` VALUES ('96', 'linksgroup2', '10', 'links_group', 'en', '1649638737', '1649638737');
INSERT INTO `ey_language_attr` VALUES ('97', 'linksgroup3', '11', 'links_group', 'en', '1649638737', '1649638737');
INSERT INTO `ey_language_attr` VALUES ('98', 'linksgroup4', '12', 'links_group', 'en', '1649638737', '1649638737');
INSERT INTO `ey_language_attr` VALUES ('99', 'linksgroup5', '13', 'links_group', 'en', '1649638737', '1649638737');
INSERT INTO `ey_language_attr` VALUES ('100', 'linksgroup6', '14', 'links_group', 'en', '1649638737', '1649638737');
INSERT INTO `ey_language_attr` VALUES ('101', 'linksgroup7', '15', 'links_group', 'en', '1649638737', '1649638737');
INSERT INTO `ey_language_attr` VALUES ('102', 'linksgroup8', '16', 'links_group', 'en', '1649638737', '1649638737');
INSERT INTO `ey_language_attr` VALUES ('103', 'adp1', '1', 'ad_position', 'cn', '1649642885', '1649642885');
INSERT INTO `ey_language_attr` VALUES ('104', 'adp1', '2', 'ad_position', 'en', '1649642885', '1649642885');
INSERT INTO `ey_language_attr` VALUES ('105', 'ad1', '1', 'ad', 'cn', '1649642885', '1649642885');
INSERT INTO `ey_language_attr` VALUES ('106', 'ad1', '2', 'ad', 'en', '1649642885', '1649642885');
INSERT INTO `ey_language_attr` VALUES ('107', 'ad3', '3', 'ad', 'cn', '1649642885', '1649642885');
INSERT INTO `ey_language_attr` VALUES ('108', 'ad3', '4', 'ad', 'en', '1649642885', '1649642885');
INSERT INTO `ey_language_attr` VALUES ('109', 'adp3', '3', 'ad_position', 'cn', '1649645330', '1649645330');
INSERT INTO `ey_language_attr` VALUES ('110', 'adp3', '4', 'ad_position', 'en', '1649645330', '1649645330');
INSERT INTO `ey_language_attr` VALUES ('111', 'ad5', '5', 'ad', 'cn', '1649645330', '1649645330');
INSERT INTO `ey_language_attr` VALUES ('112', 'ad5', '6', 'ad', 'en', '1649645330', '1649645330');
INSERT INTO `ey_language_attr` VALUES ('113', 'ad7', '7', 'ad', 'cn', '1649645330', '1649645330');
INSERT INTO `ey_language_attr` VALUES ('114', 'ad7', '8', 'ad', 'en', '1649645330', '1649645330');
INSERT INTO `ey_language_attr` VALUES ('115', 'ad9', '9', 'ad', 'cn', '1649645330', '1649645330');
INSERT INTO `ey_language_attr` VALUES ('116', 'ad9', '10', 'ad', 'en', '1649645330', '1649645330');
INSERT INTO `ey_language_attr` VALUES ('117', 'ad11', '11', 'ad', 'cn', '1649645330', '1649645330');
INSERT INTO `ey_language_attr` VALUES ('118', 'ad11', '12', 'ad', 'en', '1649645330', '1649645330');
INSERT INTO `ey_language_attr` VALUES ('119', 'ad13', '13', 'ad', 'cn', '1649645330', '1649645330');
INSERT INTO `ey_language_attr` VALUES ('120', 'ad13', '14', 'ad', 'en', '1649645330', '1649645330');
INSERT INTO `ey_language_attr` VALUES ('121', 'ad15', '15', 'ad', 'cn', '1649645330', '1649645330');
INSERT INTO `ey_language_attr` VALUES ('122', 'ad15', '16', 'ad', 'en', '1649645330', '1649645330');
INSERT INTO `ey_language_attr` VALUES ('123', 'adp5', '5', 'ad_position', 'cn', '1649645524', '1649645524');
INSERT INTO `ey_language_attr` VALUES ('124', 'adp5', '6', 'ad_position', 'en', '1649645524', '1649645524');
INSERT INTO `ey_language_attr` VALUES ('125', 'ad17', '17', 'ad', 'cn', '1649645524', '1649645524');
INSERT INTO `ey_language_attr` VALUES ('126', 'ad17', '18', 'ad', 'en', '1649645524', '1649645524');
INSERT INTO `ey_language_attr` VALUES ('127', 'linksgroup1', '1', 'links_group', 'cn', '1713172699', '1713172699');
INSERT INTO `ey_language_attr` VALUES ('128', 'linksgroup2', '2', 'links_group', 'cn', '1713172699', '1713172699');
INSERT INTO `ey_language_attr` VALUES ('129', 'linksgroup3', '3', 'links_group', 'cn', '1713172699', '1713172699');
INSERT INTO `ey_language_attr` VALUES ('130', 'linksgroup4', '4', 'links_group', 'cn', '1713172699', '1713172699');
INSERT INTO `ey_language_attr` VALUES ('131', 'linksgroup5', '5', 'links_group', 'cn', '1713172699', '1713172699');
INSERT INTO `ey_language_attr` VALUES ('132', 'linksgroup6', '6', 'links_group', 'cn', '1713172699', '1713172699');
INSERT INTO `ey_language_attr` VALUES ('133', 'linksgroup7', '7', 'links_group', 'cn', '1713172699', '1713172699');
INSERT INTO `ey_language_attr` VALUES ('134', 'linksgroup8', '8', 'links_group', 'cn', '1713172699', '1713172699');

-- -----------------------------
-- Table structure for `ey_language_attribute`
-- -----------------------------
DROP TABLE IF EXISTS `ey_language_attribute`;
CREATE TABLE `ey_language_attribute` (
  `attr_id` int(10) NOT NULL AUTO_INCREMENT COMMENT '信息ID，自增',
  `attr_title` varchar(200) NOT NULL DEFAULT '' COMMENT '变量标题',
  `attr_name` varchar(200) NOT NULL DEFAULT '' COMMENT '变量名称',
  `attr_group` varchar(50) DEFAULT '' COMMENT '分组，以表名划分（不含表前缀）',
  `is_del` tinyint(1) DEFAULT '0' COMMENT '伪删除，0=否，1=是',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`attr_id`)
) ENGINE=MyISAM AUTO_INCREMENT=68 DEFAULT CHARSET=utf8 COMMENT='多语言模板变量表';

-- -----------------------------
-- Records of `ey_language_attribute`
-- -----------------------------
INSERT INTO `ey_language_attribute` VALUES ('1', 'English', 'tid2', 'arctype', '1', '1649638717', '1649672251');
INSERT INTO `ey_language_attribute` VALUES ('2', '关于我们', 'tid3', 'arctype', '0', '1649638717', '1649638717');
INSERT INTO `ey_language_attribute` VALUES ('3', '产品中心', 'tid4', 'arctype', '0', '1649638717', '1649638717');
INSERT INTO `ey_language_attribute` VALUES ('4', '招商加盟', 'tid5', 'arctype', '0', '1649638717', '1649638717');
INSERT INTO `ey_language_attribute` VALUES ('5', '新闻资讯', 'tid6', 'arctype', '0', '1649638717', '1649638717');
INSERT INTO `ey_language_attribute` VALUES ('6', '服务中心', 'tid7', 'arctype', '0', '1649638717', '1649638717');
INSERT INTO `ey_language_attribute` VALUES ('7', '联系我们', 'tid8', 'arctype', '0', '1649638717', '1649638717');
INSERT INTO `ey_language_attribute` VALUES ('8', 'About', 'tid9', 'arctype', '1', '1649638717', '1649672251');
INSERT INTO `ey_language_attribute` VALUES ('9', 'Product', 'tid10', 'arctype', '1', '1649638717', '1649672251');
INSERT INTO `ey_language_attribute` VALUES ('10', 'Joining', 'tid11', 'arctype', '1', '1649638717', '1649672251');
INSERT INTO `ey_language_attribute` VALUES ('11', 'News', 'tid12', 'arctype', '1', '1649638717', '1649672251');
INSERT INTO `ey_language_attribute` VALUES ('12', 'Service', 'tid13', 'arctype', '1', '1649638717', '1649672251');
INSERT INTO `ey_language_attribute` VALUES ('13', 'Contact', 'tid14', 'arctype', '1', '1649638717', '1649672251');
INSERT INTO `ey_language_attribute` VALUES ('14', '公司介绍', 'tid15', 'arctype', '0', '1649638717', '1649638717');
INSERT INTO `ey_language_attribute` VALUES ('15', '企业文化', 'tid16', 'arctype', '0', '1649638717', '1649638717');
INSERT INTO `ey_language_attribute` VALUES ('16', '企业荣誉', 'tid17', 'arctype', '0', '1649638717', '1649638717');
INSERT INTO `ey_language_attribute` VALUES ('17', '人才招聘', 'tid18', 'arctype', '0', '1649638717', '1649638717');
INSERT INTO `ey_language_attribute` VALUES ('18', '绿茶', 'tid19', 'arctype', '0', '1649638717', '1649638717');
INSERT INTO `ey_language_attribute` VALUES ('19', '红茶', 'tid20', 'arctype', '0', '1649638717', '1649638717');
INSERT INTO `ey_language_attribute` VALUES ('20', '花茶', 'tid21', 'arctype', '0', '1649638717', '1649638717');
INSERT INTO `ey_language_attribute` VALUES ('21', '加盟优势', 'tid22', 'arctype', '0', '1649638717', '1649638717');
INSERT INTO `ey_language_attribute` VALUES ('22', '加盟流程', 'tid23', 'arctype', '0', '1649638717', '1649638717');
INSERT INTO `ey_language_attribute` VALUES ('23', '加盟条件', 'tid24', 'arctype', '0', '1649638717', '1649638717');
INSERT INTO `ey_language_attribute` VALUES ('24', '加盟政策', 'tid25', 'arctype', '0', '1649638717', '1649638717');
INSERT INTO `ey_language_attribute` VALUES ('25', '公司新闻', 'tid26', 'arctype', '0', '1649638717', '1649638717');
INSERT INTO `ey_language_attribute` VALUES ('26', '行业动态', 'tid27', 'arctype', '0', '1649638717', '1649638717');
INSERT INTO `ey_language_attribute` VALUES ('27', '视频中心', 'tid28', 'arctype', '1', '1649638717', '1649661666');
INSERT INTO `ey_language_attribute` VALUES ('28', '服务理念', 'tid29', 'arctype', '0', '1649638717', '1649638717');
INSERT INTO `ey_language_attribute` VALUES ('29', '常见问题', 'tid30', 'arctype', '0', '1649638717', '1649638717');
INSERT INTO `ey_language_attribute` VALUES ('30', 'Company introduction', 'tid31', 'arctype', '1', '1649638717', '1649672251');
INSERT INTO `ey_language_attribute` VALUES ('31', 'Enterprise Culture', 'tid32', 'arctype', '1', '1649638717', '1649672251');
INSERT INTO `ey_language_attribute` VALUES ('32', 'Enterprise Honor', 'tid33', 'arctype', '1', '1649638717', '1649672251');
INSERT INTO `ey_language_attribute` VALUES ('33', 'Talent Recruitment', 'tid34', 'arctype', '1', '1649638717', '1649672251');
INSERT INTO `ey_language_attribute` VALUES ('34', 'Green tea', 'tid35', 'arctype', '1', '1649638717', '1649672251');
INSERT INTO `ey_language_attribute` VALUES ('35', 'Black tea', 'tid36', 'arctype', '1', '1649638717', '1649672251');
INSERT INTO `ey_language_attribute` VALUES ('36', 'Jasmine tea', 'tid37', 'arctype', '1', '1649638717', '1649672251');
INSERT INTO `ey_language_attribute` VALUES ('37', 'Advantages joining', 'tid38', 'arctype', '1', '1649638717', '1649672251');
INSERT INTO `ey_language_attribute` VALUES ('38', 'Join process', 'tid39', 'arctype', '1', '1649638717', '1649672251');
INSERT INTO `ey_language_attribute` VALUES ('39', 'Join conditions', 'tid40', 'arctype', '1', '1649638717', '1649672251');
INSERT INTO `ey_language_attribute` VALUES ('40', 'Alliance policy', 'tid41', 'arctype', '1', '1649638717', '1649672251');
INSERT INTO `ey_language_attribute` VALUES ('41', 'Company News', 'tid42', 'arctype', '1', '1649638717', '1649672251');
INSERT INTO `ey_language_attribute` VALUES ('42', 'Industry News', 'tid43', 'arctype', '1', '1649638717', '1649672251');
INSERT INTO `ey_language_attribute` VALUES ('43', 'Viedo', 'tid44', 'arctype', '1', '1649638717', '1649672251');
INSERT INTO `ey_language_attribute` VALUES ('44', 'Service Concept', 'tid45', 'arctype', '1', '1649638717', '1649672251');
INSERT INTO `ey_language_attribute` VALUES ('45', 'FAQ', 'tid46', 'arctype', '1', '1649638717', '1649672251');
INSERT INTO `ey_language_attribute` VALUES ('46', '首页幻灯', 'tid47', 'arctype', '1', '1649638717', '1649642938');
INSERT INTO `ey_language_attribute` VALUES ('47', '首页中部幻灯', 'tid48', 'arctype', '1', '1649638717', '1649645386');
INSERT INTO `ey_language_attribute` VALUES ('48', 'PC端首页幻灯', 'adp1', 'ad_position', '0', '1649642885', '1649642885');
INSERT INTO `ey_language_attribute` VALUES ('49', '', 'ad1', 'ad', '0', '1649642885', '1649642885');
INSERT INTO `ey_language_attribute` VALUES ('50', '', 'ad3', 'ad', '0', '1649642885', '1649642885');
INSERT INTO `ey_language_attribute` VALUES ('51', 'PC端首页产品优势大图', 'adp3', 'ad_position', '0', '1649645330', '1649645330');
INSERT INTO `ey_language_attribute` VALUES ('52', '', 'ad5', 'ad', '0', '1649645330', '1649645330');
INSERT INTO `ey_language_attribute` VALUES ('53', '', 'ad7', 'ad', '0', '1649645330', '1649645330');
INSERT INTO `ey_language_attribute` VALUES ('54', '', 'ad9', 'ad', '0', '1649645330', '1649645330');
INSERT INTO `ey_language_attribute` VALUES ('55', '', 'ad11', 'ad', '0', '1649645330', '1649645330');
INSERT INTO `ey_language_attribute` VALUES ('56', '', 'ad13', 'ad', '0', '1649645330', '1649645330');
INSERT INTO `ey_language_attribute` VALUES ('57', '', 'ad15', 'ad', '0', '1649645330', '1649645330');
INSERT INTO `ey_language_attribute` VALUES ('58', '首页关于我们大图', 'adp5', 'ad_position', '0', '1649645524', '1649645524');
INSERT INTO `ey_language_attribute` VALUES ('59', '', 'ad17', 'ad', '0', '1649645524', '1649645524');
INSERT INTO `ey_language_attribute` VALUES ('60', '综合网站', 'linksgroup1', 'links_group', '0', '1713172699', '1713172699');
INSERT INTO `ey_language_attribute` VALUES ('61', '娱乐类', 'linksgroup2', 'links_group', '0', '1713172699', '1713172699');
INSERT INTO `ey_language_attribute` VALUES ('62', '教育类', 'linksgroup3', 'links_group', '0', '1713172699', '1713172699');
INSERT INTO `ey_language_attribute` VALUES ('63', '计算机类', 'linksgroup4', 'links_group', '0', '1713172699', '1713172699');
INSERT INTO `ey_language_attribute` VALUES ('64', '电子商务', 'linksgroup5', 'links_group', '0', '1713172699', '1713172699');
INSERT INTO `ey_language_attribute` VALUES ('65', '网上信息', 'linksgroup6', 'links_group', '0', '1713172699', '1713172699');
INSERT INTO `ey_language_attribute` VALUES ('66', '论坛类', 'linksgroup7', 'links_group', '0', '1713172699', '1713172699');
INSERT INTO `ey_language_attribute` VALUES ('67', '其它类型', 'linksgroup8', 'links_group', '0', '1713172699', '1713172699');

-- -----------------------------
-- Table structure for `ey_language_mark`
-- -----------------------------
DROP TABLE IF EXISTS `ey_language_mark`;
CREATE TABLE `ey_language_mark` (
  `id` int(10) NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `title` varchar(50) NOT NULL DEFAULT '' COMMENT '国家语言名称',
  `cn_title` varchar(50) NOT NULL DEFAULT '' COMMENT '中文名称',
  `mark` varchar(50) DEFAULT '' COMMENT '多语言标识',
  `pinyin` varchar(100) DEFAULT '' COMMENT '拼音',
  `sort_order` int(10) NOT NULL DEFAULT '0' COMMENT '排序号',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=58 DEFAULT CHARSET=utf8 COMMENT='国家语言表';

-- -----------------------------
-- Records of `ey_language_mark`
-- -----------------------------
INSERT INTO `ey_language_mark` VALUES ('1', '简体中文', '简体中文', 'cn', 'zhongwenjianti', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('2', 'Vietnamese', '越南语', 'vi', 'yuenanyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('3', '繁体中文', '繁体中文', 'zh', 'zhongwenfanti', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('4', 'English', '英语', 'en', 'yingyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('5', 'Indonesian', '印尼语', 'id', 'yinniyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('6', 'Urdu', '乌尔都语', 'ur', 'wuerduyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('7', 'Yiddish', '意第绪语', 'yi', 'yidixuyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('8', 'Italian', '意大利语', 'it', 'yidaliyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('9', 'Greek', '希腊语', 'el', 'xilayu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('10', 'Spanish Basque', '西班牙的巴斯克语', 'eu', 'xibanyadebasikeyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('11', 'Spanish', '西班牙语', 'es', 'xibanyayu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('12', 'Hungarian', '匈牙利语', 'hu', 'xiongyaliyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('13', 'Hebrew', '希伯来语', 'iw', 'xibolaiyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('14', 'Ukrainian', '乌克兰语', 'uk', 'wukelanyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('15', 'Welsh', '威尔士语', 'cy', 'weiershiyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('16', 'Thai', '泰语', 'th', 'taiyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('17', 'Turkish', '土耳其语', 'tr', 'tuerqiyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('18', 'Swahili', '斯瓦希里语', 'sw', 'siwaxiliyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('19', 'Japanese', '日语', 'ja', 'riyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('20', 'Swedish', '瑞典语', 'sv', 'ruidianyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('21', 'Serbian', '塞尔维亚语', 'sr', 'saierweiyayu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('22', 'Slovak', '斯洛伐克语', 'sk', 'siluofakeyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('23', 'Slovenian', '斯洛文尼亚语', 'sl', 'siluowenniyayu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('24', 'Portuguese', '葡萄牙语', 'pt', 'putaoyayu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('25', 'Norwegian', '挪威语', 'no', 'nuoweiyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('26', 'Macedonian', '马其顿语', 'mk', 'maqidunyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('27', 'Malay', '马来语', 'ms', 'malaiyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('28', 'Maltese', '马耳他语', 'mt', 'maertayu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('29', 'Romanian', '罗马尼亚语', 'ro', 'luomaniyayu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('30', 'Lithuanian', '立陶宛语', 'lt', 'litaowanyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('31', 'Latvian', '拉脱维亚语', 'lv', 'latuoweiyayu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('32', 'Latin', '拉丁语', 'la', 'ladingyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('33', 'Croatian', '克罗地亚语', 'hr', 'keluodiyayu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('34', 'Czech', '捷克语', 'cs', 'jiekeyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('35', 'Catalan', '加泰罗尼亚语', 'ca', 'jiatailuoniyayu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('36', 'Galician', '加利西亚语', 'gl', 'jialixiyayu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('37', 'Dutch', '荷兰语', 'nl', 'helanyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('38', 'Korean', '韩语', 'ko', 'hanyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('39', 'Haitian Creole', '海地克里奥尔语', 'ht', 'haidikeliaoeryu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('40', 'Finnish', '芬兰语', 'fi', 'fenlanyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('41', 'Filipino', '菲律宾语', 'tl', 'feilvbinyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('42', 'Russian', '俄语', 'ru', 'eyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('43', 'Boolean (Afrikaans)', '布尔语(南非荷兰语)', 'af', 'bueryunanfeihelanyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('44', 'French', '法语', 'fr', 'fayu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('45', 'Danish', '丹麦语', 'da', 'danmaiyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('46', 'German', '德语', 'de', 'deyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('47', 'Azerbaijani', '阿塞拜疆语', 'az', 'asaibaijiangyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('48', 'Irish', '爱尔兰语', 'ga', 'aierlanyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('49', 'Estonian', '爱沙尼亚语', 'et', 'aishaniyayu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('50', 'Belarusian', '白俄罗斯语', 'be', 'baieluosiyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('51', 'Bulgarian', '保加利亚语', 'bg', 'baojialiyayu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('52', 'Icelandic', '冰岛语', 'is', 'bingdaoyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('53', 'Polish', '波兰语', 'pl', 'bolanyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('54', 'Persian', '波斯语', 'fa', 'bosiyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('55', 'Arabic', '阿拉伯语', 'ar', 'alaboyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('56', 'Albanian', '阿尔巴尼亚语', 'sq', 'aerbaniyayu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('57', 'Uyghur', '维吾尔族语', 'ug', 'weiwuerzuyu', '100', '0', '1541583096');

-- -----------------------------
-- Table structure for `ey_language_pack`
-- -----------------------------
DROP TABLE IF EXISTS `ey_language_pack`;
CREATE TABLE `ey_language_pack` (
  `id` int(10) NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `name` varchar(50) NOT NULL DEFAULT '' COMMENT '变量名',
  `value` text NOT NULL COMMENT '变量值',
  `is_syn` tinyint(1) DEFAULT '0' COMMENT '同步官方语言包：0=否，1=是',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `sort_order` int(10) DEFAULT '0' COMMENT '排序号',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=41 DEFAULT CHARSET=utf8 COMMENT='模板语言包变量';

-- -----------------------------
-- Records of `ey_language_pack`
-- -----------------------------
INSERT INTO `ey_language_pack` VALUES ('1', 'sys1', '首页', '1', 'cn', '100', '1543890216', '1543890216');
INSERT INTO `ey_language_pack` VALUES ('2', 'sys2', '上一页', '1', 'cn', '100', '1543890216', '1543890216');
INSERT INTO `ey_language_pack` VALUES ('3', 'sys3', '下一页', '1', 'cn', '100', '1543890216', '1543890216');
INSERT INTO `ey_language_pack` VALUES ('4', 'sys4', '末页', '1', 'cn', '100', '1543890216', '1543890216');
INSERT INTO `ey_language_pack` VALUES ('5', 'sys5', '共<strong>%s</strong>页 <strong>%s</strong>条', '1', 'cn', '100', '1543890216', '1543890216');
INSERT INTO `ey_language_pack` VALUES ('6', 'sys6', '全部', '1', 'cn', '100', '1543890216', '1543890216');
INSERT INTO `ey_language_pack` VALUES ('7', 'sys7', '搜索', '1', 'cn', '100', '1543890216', '1543890216');
INSERT INTO `ey_language_pack` VALUES ('8', 'sys8', '查看详情', '1', 'cn', '100', '1543890216', '1543890216');
INSERT INTO `ey_language_pack` VALUES ('9', 'sys9', '网站首页', '1', 'cn', '100', '1543890216', '1543890216');
INSERT INTO `ey_language_pack` VALUES ('10', 'sys10', '暂无', '1', 'cn', '100', '1543890216', '1543890216');
INSERT INTO `ey_language_pack` VALUES ('11', 'sys11', '上一篇', '1', 'cn', '100', '1543890216', '1543890216');
INSERT INTO `ey_language_pack` VALUES ('12', 'sys12', '下一篇', '1', 'cn', '100', '1543890216', '1543890216');
INSERT INTO `ey_language_pack` VALUES ('13', 'sys1', 'Home', '1', 'en', '100', '1649638739', '1649638739');
INSERT INTO `ey_language_pack` VALUES ('14', 'sys2', 'Previous', '1', 'en', '100', '1649638739', '1649638739');
INSERT INTO `ey_language_pack` VALUES ('15', 'sys3', 'Next', '1', 'en', '100', '1649638739', '1649638739');
INSERT INTO `ey_language_pack` VALUES ('16', 'sys4', 'Last', '1', 'en', '100', '1649638739', '1649638739');
INSERT INTO `ey_language_pack` VALUES ('17', 'sys5', 'Road <strong>%s</strong> page <strong>%s</strong> strip', '1', 'en', '100', '1649638739', '1649638739');
INSERT INTO `ey_language_pack` VALUES ('18', 'sys6', 'All', '1', 'en', '100', '1649638739', '1649638739');
INSERT INTO `ey_language_pack` VALUES ('19', 'sys7', 'Search', '1', 'en', '100', '1649638739', '1649638739');
INSERT INTO `ey_language_pack` VALUES ('20', 'sys8', 'View details', '1', 'en', '100', '1649638739', '1649638739');
INSERT INTO `ey_language_pack` VALUES ('21', 'sys9', 'Home', '1', 'en', '100', '1649638739', '1649638739');
INSERT INTO `ey_language_pack` VALUES ('22', 'sys10', 'No time', '1', 'en', '100', '1649638739', '1649638739');
INSERT INTO `ey_language_pack` VALUES ('23', 'sys11', 'Previous', '1', 'en', '100', '1649638739', '1649638739');
INSERT INTO `ey_language_pack` VALUES ('24', 'sys12', 'Next', '1', 'en', '100', '1649638739', '1649638739');
INSERT INTO `ey_language_pack` VALUES ('25', 'zy1', '更多', '0', 'cn', '100', '1649673110', '1649673110');
INSERT INTO `ey_language_pack` VALUES ('26', 'zy1', 'MORE', '0', 'en', '100', '1649673110', '1649673110');
INSERT INTO `ey_language_pack` VALUES ('27', 'zy2', '查看更多', '0', 'cn', '100', '1649673191', '1649673191');
INSERT INTO `ey_language_pack` VALUES ('28', 'zy2', 'To view more', '0', 'en', '100', '1649673191', '1649673191');
INSERT INTO `ey_language_pack` VALUES ('29', 'zy3', '产品优势', '0', 'cn', '100', '1649673353', '1649673353');
INSERT INTO `ey_language_pack` VALUES ('30', 'zy3', 'Product advantage', '0', 'en', '100', '1649673353', '1649673353');
INSERT INTO `ey_language_pack` VALUES ('31', 'zy4', '质量安全  放心求真', '0', 'cn', '100', '1649673384', '1649673384');
INSERT INTO `ey_language_pack` VALUES ('32', 'zy4', 'Quality and safety are assured', '0', 'en', '100', '1649673384', '1649673384');
INSERT INTO `ey_language_pack` VALUES ('33', 'zy5', '当前位置', '0', 'cn', '100', '1649673511', '1649673511');
INSERT INTO `ey_language_pack` VALUES ('34', 'zy5', 'The current position', '0', 'en', '100', '1649673511', '1649673511');
INSERT INTO `ey_language_pack` VALUES ('35', 'zy6', '所属分类', '0', 'cn', '100', '1649673734', '1649673734');
INSERT INTO `ey_language_pack` VALUES ('36', 'zy6', 'Classification', '0', 'en', '100', '1649673734', '1649673734');
INSERT INTO `ey_language_pack` VALUES ('37', 'zy7', '发布时间', '0', 'cn', '100', '1649673809', '1649673809');
INSERT INTO `ey_language_pack` VALUES ('38', 'zy7', 'Release time', '0', 'en', '100', '1649673809', '1649673809');
INSERT INTO `ey_language_pack` VALUES ('39', 'zy8', '一键拨打', '0', 'cn', '100', '1649674286', '1649674286');
INSERT INTO `ey_language_pack` VALUES ('40', 'zy8', 'Call', '0', 'en', '100', '1649674286', '1649674286');

-- -----------------------------
-- Table structure for `ey_links`
-- -----------------------------
DROP TABLE IF EXISTS `ey_links`;
CREATE TABLE `ey_links` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `typeid` tinyint(1) DEFAULT '1' COMMENT '类型：1=文字链接，2=图片链接',
  `groupid` int(11) unsigned NOT NULL DEFAULT '1' COMMENT '分组id， 默认分组值为1',
  `title` varchar(50) DEFAULT '' COMMENT '网站标题',
  `url` varchar(100) DEFAULT '' COMMENT '网站地址',
  `logo` varchar(255) DEFAULT '' COMMENT '网站LOGO',
  `sort_order` int(11) DEFAULT '0' COMMENT '排序号',
  `target` tinyint(1) DEFAULT '0' COMMENT '是否开启浏览器新窗口',
  `nofollow` tinyint(1) DEFAULT '0',
  `email` varchar(50) DEFAULT NULL,
  `intro` text COMMENT '网站简况',
  `status` tinyint(1) DEFAULT '1' COMMENT '状态(1=显示，0=屏蔽)',
  `province_id` int(10) DEFAULT '0' COMMENT '省份',
  `city_id` int(10) DEFAULT '0' COMMENT '所在城市',
  `area_id` int(10) DEFAULT '0' COMMENT '所在区域',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `delete_time` int(11) DEFAULT '0' COMMENT '软删除时间',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=17 DEFAULT CHARSET=utf8 COMMENT='友情链接表';

-- -----------------------------
-- Records of `ey_links`
-- -----------------------------
INSERT INTO `ey_links` VALUES ('2', '1', '1', '优酷', 'http://www.youku.com/', '', '1', '0', '0', '', '', '1', '0', '0', '0', 'cn', '0', '1226375403', '1649728760');
INSERT INTO `ey_links` VALUES ('8', '1', '1', '腾讯', 'http://www.qq.com/', '', '2', '0', '0', '', '', '1', '0', '0', '0', 'cn', '0', '1227772703', '1649728795');
INSERT INTO `ey_links` VALUES ('9', '1', '1', '京东', 'http://www.jd.com/', '', '3', '0', '0', '', '', '1', '0', '0', '0', 'cn', '0', '1227772717', '1649728807');
INSERT INTO `ey_links` VALUES ('10', '1', '1', '微博', 'https://weibo.com/', '', '1', '0', '0', '', '', '1', '0', '0', '0', 'cn', '0', '1478868078', '1649728772');
INSERT INTO `ey_links` VALUES ('11', '1', '1', '新浪', 'https://www.sina.com.cn/', '', '1', '0', '0', '', '', '1', '0', '0', '0', 'cn', '0', '1478868087', '1649728786');
INSERT INTO `ey_links` VALUES ('12', '1', '9', 'en织梦58', 'http://www.dede58.com', '', '1', '0', '0', '', '', '1', '0', '0', '0', 'en', '0', '1226375403', '1226375403');
INSERT INTO `ey_links` VALUES ('13', '1', '9', 'endiscuz模板', 'http://www.discuz58.com', '', '2', '0', '0', '', '', '1', '0', '0', '0', 'en', '0', '1227772703', '1227772703');
INSERT INTO `ey_links` VALUES ('14', '1', '9', 'en织梦主机', 'http://www.dede58.com/host', '', '3', '0', '0', '', '', '1', '0', '0', '0', 'en', '0', '1227772717', '1227772717');
INSERT INTO `ey_links` VALUES ('15', '1', '9', 'en织梦模板', 'http://www.dede58.com', '', '1', '0', '0', '', '', '1', '0', '0', '0', 'en', '0', '1478868078', '1478868078');
INSERT INTO `ey_links` VALUES ('16', '1', '9', 'en响应式织梦模板', 'http://www.adashuo.com/', '', '1', '0', '0', '', '', '1', '0', '0', '0', 'en', '0', '1478868087', '1478868087');

-- -----------------------------
-- Table structure for `ey_links_group`
-- -----------------------------
DROP TABLE IF EXISTS `ey_links_group`;
CREATE TABLE `ey_links_group` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `group_name` varchar(255) NOT NULL DEFAULT '' COMMENT '分组名称',
  `status` tinyint(2) unsigned NOT NULL DEFAULT '1' COMMENT '状态(1=显示，0=屏蔽)',
  `sort_order` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '排序号',
  `lang` varchar(50) NOT NULL DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(10) unsigned NOT NULL DEFAULT '0',
  `update_time` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=17 DEFAULT CHARSET=utf8 COMMENT='友情链接分组';

-- -----------------------------
-- Records of `ey_links_group`
-- -----------------------------
INSERT INTO `ey_links_group` VALUES ('1', '综合网站', '1', '100', 'cn', '1649638272', '1649638272');
INSERT INTO `ey_links_group` VALUES ('2', '娱乐类', '1', '100', 'cn', '1649638272', '1649638272');
INSERT INTO `ey_links_group` VALUES ('3', '教育类', '1', '100', 'cn', '1649638272', '1649638272');
INSERT INTO `ey_links_group` VALUES ('4', '计算机类', '1', '100', 'cn', '1649638272', '1649638272');
INSERT INTO `ey_links_group` VALUES ('5', '电子商务', '1', '100', 'cn', '1649638272', '1649638272');
INSERT INTO `ey_links_group` VALUES ('6', '网上信息', '1', '100', 'cn', '1649638272', '1649638272');
INSERT INTO `ey_links_group` VALUES ('7', '论坛类', '1', '100', 'cn', '1649638272', '1649638272');
INSERT INTO `ey_links_group` VALUES ('8', '其它类型', '1', '100', 'cn', '1649638272', '1649638272');
INSERT INTO `ey_links_group` VALUES ('9', 'en综合网站', '1', '100', 'en', '1649638272', '1649638272');
INSERT INTO `ey_links_group` VALUES ('10', 'en娱乐类', '1', '100', 'en', '1649638272', '1649638272');
INSERT INTO `ey_links_group` VALUES ('11', 'en教育类', '1', '100', 'en', '1649638272', '1649638272');
INSERT INTO `ey_links_group` VALUES ('12', 'en计算机类', '1', '100', 'en', '1649638272', '1649638272');
INSERT INTO `ey_links_group` VALUES ('13', 'en电子商务', '1', '100', 'en', '1649638272', '1649638272');
INSERT INTO `ey_links_group` VALUES ('14', 'en网上信息', '1', '100', 'en', '1649638272', '1649638272');
INSERT INTO `ey_links_group` VALUES ('15', 'en论坛类', '1', '100', 'en', '1649638272', '1649638272');
INSERT INTO `ey_links_group` VALUES ('16', 'en其它类型', '1', '100', 'en', '1649638272', '1649638272');

-- -----------------------------
-- Table structure for `ey_media_content`
-- -----------------------------
DROP TABLE IF EXISTS `ey_media_content`;
CREATE TABLE `ey_media_content` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `aid` int(10) NOT NULL DEFAULT '0' COMMENT '文档ID',
  `content` longtext COMMENT '内容详情',
  `content_ey_m` longtext COMMENT '手机端内容详情',
  `courseware` varchar(200) NOT NULL DEFAULT '' COMMENT '课件地址',
  `courseware_free` enum('免费','收费') NOT NULL DEFAULT '免费' COMMENT '课件收费',
  `total_duration` int(10) NOT NULL DEFAULT '0' COMMENT '视频总时长',
  `total_video` int(10) NOT NULL DEFAULT '0' COMMENT '视频数',
  `add_time` int(11) NOT NULL DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `aid` (`aid`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='视频附加表';


-- -----------------------------
-- Table structure for `ey_media_file`
-- -----------------------------
DROP TABLE IF EXISTS `ey_media_file`;
CREATE TABLE `ey_media_file` (
  `file_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '视频模型文件表',
  `aid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '文档ID',
  `title` varchar(200) NOT NULL DEFAULT '' COMMENT '文档标题',
  `file_name` varchar(200) NOT NULL DEFAULT '' COMMENT '文件名称',
  `file_title` varchar(200) NOT NULL DEFAULT '' COMMENT '选集标题',
  `file_url` text NOT NULL COMMENT '存储路径',
  `file_time` int(8) NOT NULL DEFAULT '0' COMMENT '文件时长',
  `file_ext` varchar(50) NOT NULL DEFAULT '' COMMENT '文件后缀名',
  `file_size` varchar(255) NOT NULL DEFAULT '' COMMENT '文件大小',
  `file_mime` varchar(200) NOT NULL DEFAULT '' COMMENT '文件类型',
  `uhash` varchar(200) NOT NULL DEFAULT '' COMMENT '自定义的一种加密方式，用于视频播放的权限验证',
  `md5file` varchar(200) NOT NULL DEFAULT '' COMMENT 'md5_file加密，可以检测上传/播放的视频文件是否损坏',
  `is_remote` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否远程 1-远程',
  `playcount` int(10) NOT NULL DEFAULT '0' COMMENT '播放次数',
  `gratis` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否试看，0不试看，1试看',
  `sort_order` smallint(5) NOT NULL DEFAULT '0' COMMENT '排序',
  `add_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '上传时间',
  `update_time` int(11) NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`file_id`) USING BTREE,
  KEY `aid` (`aid`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='视频附件表';


-- -----------------------------
-- Table structure for `ey_media_log`
-- -----------------------------
DROP TABLE IF EXISTS `ey_media_log`;
CREATE TABLE `ey_media_log` (
  `log_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `users_id` int(10) DEFAULT '0' COMMENT '用户ID',
  `aid` int(10) DEFAULT '0' COMMENT '文档ID',
  `file_id` int(10) DEFAULT '0' COMMENT '视频ID',
  `ip` varchar(20) DEFAULT '' COMMENT 'ip',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '编辑时间',
  PRIMARY KEY (`log_id`),
  KEY `file_id` (`file_id`,`aid`,`users_id`) USING BTREE,
  KEY `aid` (`aid`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='视频日志表';


-- -----------------------------
-- Table structure for `ey_media_order`
-- -----------------------------
DROP TABLE IF EXISTS `ey_media_order`;
CREATE TABLE `ey_media_order` (
  `order_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '媒体订单ID',
  `order_code` varchar(50) NOT NULL DEFAULT '' COMMENT '媒体订单编号',
  `users_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '会员ID',
  `mobile` varchar(20) DEFAULT '' COMMENT '手机',
  `order_status` tinyint(1) NOT NULL DEFAULT '0' COMMENT '订单状态：0未付款，1已付款',
  `order_amount` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '订单应付总金额',
  `pay_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '支付时间',
  `pay_name` varchar(20) NOT NULL DEFAULT '' COMMENT '支付方式名称',
  `wechat_pay_type` varchar(20) NOT NULL DEFAULT '' COMMENT '微信支付时，标记使用的支付类型（扫码支付，微信内部，微信H5页面）',
  `pay_details` text COMMENT '支付时返回的数据，以serialize序列化后存入，用于后续查询。',
  `product_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '视频文档ID',
  `product_name` varchar(100) DEFAULT '' COMMENT '视频文档名称',
  `product_litpic` varchar(500) DEFAULT '' COMMENT '视频文档封面图片',
  `lang` varchar(30) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) unsigned DEFAULT '0' COMMENT '下单时间',
  `update_time` int(11) unsigned DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`order_id`),
  UNIQUE KEY `order_code` (`order_code`) USING BTREE,
  KEY `users_id` (`users_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='视频订单表';


-- -----------------------------
-- Table structure for `ey_media_play_record`
-- -----------------------------
DROP TABLE IF EXISTS `ey_media_play_record`;
CREATE TABLE `ey_media_play_record` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `users_id` int(10) DEFAULT '0' COMMENT '用户id',
  `aid` int(10) DEFAULT '0' COMMENT '课程id',
  `file_id` int(10) DEFAULT '0' COMMENT '文件id',
  `play_time` int(10) DEFAULT '0' COMMENT '播放时间',
  `add_time` int(10) DEFAULT '0' COMMENT '添加时间',
  `update_time` int(10) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='视频播放时长表';


-- -----------------------------
-- Table structure for `ey_memgift`
-- -----------------------------
DROP TABLE IF EXISTS `ey_memgift`;
CREATE TABLE `ey_memgift` (
  `gift_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '礼品列表',
  `type` tinyint(3) NOT NULL DEFAULT '1' COMMENT '-1-实物,2-会员产品',
  `type_id` int(10) DEFAULT '0' COMMENT '类型为会员产品时的会员产品类型(users_type_manage)type_id',
  `score` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '所需积分',
  `litpic` varchar(250) NOT NULL DEFAULT '',
  `giftname` varchar(60) NOT NULL DEFAULT '',
  `num` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT '兑换次数',
  `content` longtext COMMENT '礼品详情',
  `stock` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '库存总数',
  `is_del` tinyint(3) NOT NULL DEFAULT '0' COMMENT '0-正常,1-删除',
  `status` tinyint(2) NOT NULL DEFAULT '1' COMMENT '礼品状态：1=显示，0=隐藏',
  `add_time` int(10) DEFAULT '0',
  `update_time` int(10) DEFAULT '0',
  `sort_order` int(10) DEFAULT '100' COMMENT '排序',
  PRIMARY KEY (`gift_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;


-- -----------------------------
-- Table structure for `ey_memgiftget`
-- -----------------------------
DROP TABLE IF EXISTS `ey_memgiftget`;
CREATE TABLE `ey_memgiftget` (
  `gid` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `giftname` char(60) NOT NULL DEFAULT '',
  `gift_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '礼品ID',
  `score` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '积分',
  `users_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `status` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '状态,0-待发货,1-已发货,2-退回,3-重发',
  `name` varchar(255) NOT NULL DEFAULT '' COMMENT '姓名',
  `mobile` varchar(55) NOT NULL DEFAULT '' COMMENT '手机',
  `address` varchar(255) NOT NULL DEFAULT '' COMMENT '地址',
  `add_time` int(10) DEFAULT '0',
  `update_time` int(10) DEFAULT '0',
  `type_id` int(11) DEFAULT '0' COMMENT '兑换会员产品时,会员产品套餐(表::users_type_manage)type_id',
  PRIMARY KEY (`gid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;


-- -----------------------------
-- Table structure for `ey_nav_list`
-- -----------------------------
DROP TABLE IF EXISTS `ey_nav_list`;
CREATE TABLE `ey_nav_list` (
  `nav_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '导航ID',
  `nav_name` varchar(200) NOT NULL DEFAULT '' COMMENT '导航名称',
  `parent_id` int(10) NOT NULL DEFAULT '0' COMMENT '上级菜单id',
  `topid` int(10) NOT NULL DEFAULT '0' COMMENT '顶级菜单id',
  `en_name` varchar(200) NOT NULL DEFAULT '' COMMENT '英文名称',
  `nav_url` varchar(200) NOT NULL DEFAULT '' COMMENT '导航链接',
  `position_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '导航位置',
  `arctype_sync` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否与栏目同步',
  `type_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '同步栏目的ID',
  `nav_pic` varchar(255) NOT NULL DEFAULT '' COMMENT '导航图片',
  `is_remote` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否远程图片',
  `target` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否打开新窗口，1=是，0=否',
  `nofollow` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否使用nofollow，1=是，0=否',
  `status` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '启用 (1=正常，0=停用)',
  `is_del` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '伪删除，1=是，0=否',
  `sort_order` int(10) unsigned NOT NULL DEFAULT '100' COMMENT '排序号',
  `add_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`nav_id`) USING BTREE,
  KEY `position_id` (`position_id`) USING BTREE,
  KEY `type_id` (`type_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='导航列表';


-- -----------------------------
-- Table structure for `ey_nav_position`
-- -----------------------------
DROP TABLE IF EXISTS `ey_nav_position`;
CREATE TABLE `ey_nav_position` (
  `position_id` int(10) NOT NULL AUTO_INCREMENT COMMENT '导航列表ID',
  `position_name` varchar(200) DEFAULT '' COMMENT '导航列表名称',
  `sort_order` int(10) DEFAULT '0' COMMENT '排序号',
  `is_del` tinyint(1) DEFAULT '0' COMMENT '伪删除，1=是，0=否',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`position_id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=7 DEFAULT CHARSET=utf8 COMMENT='导航位置表';

-- -----------------------------
-- Records of `ey_nav_position`
-- -----------------------------
INSERT INTO `ey_nav_position` VALUES ('1', 'PC端主导航', '100', '0', '0', '1624861478');
INSERT INTO `ey_nav_position` VALUES ('2', 'PC端顶部导航', '100', '0', '0', '1624861478');
INSERT INTO `ey_nav_position` VALUES ('3', 'PC端中部导航', '100', '0', '0', '1624861478');
INSERT INTO `ey_nav_position` VALUES ('4', 'PC端底部导航', '100', '0', '0', '1624861478');
INSERT INTO `ey_nav_position` VALUES ('5', '移动端中部导航', '100', '0', '0', '1624861478');
INSERT INTO `ey_nav_position` VALUES ('6', '移动端底部导航', '100', '0', '0', '1624861478');

-- -----------------------------
-- Table structure for `ey_nzsm_content`
-- -----------------------------
DROP TABLE IF EXISTS `ey_nzsm_content`;
CREATE TABLE `ey_nzsm_content` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `aid` int(10) DEFAULT '0' COMMENT '文档ID',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  `zdy` varchar(200) NOT NULL DEFAULT '' COMMENT '字段一',
  `zde` varchar(200) NOT NULL DEFAULT '' COMMENT '字段二',
  `zdsa` varchar(200) NOT NULL DEFAULT '' COMMENT '字段三',
  `zdsi` varchar(200) NOT NULL DEFAULT '' COMMENT '字段四',
  `zdw` varchar(200) NOT NULL DEFAULT '' COMMENT '字段五',
  PRIMARY KEY (`id`),
  KEY `aid` (`aid`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 COMMENT='附加表';

-- -----------------------------
-- Records of `ey_nzsm_content`
-- -----------------------------
INSERT INTO `ey_nzsm_content` VALUES ('1', '8', '1589159107', '1589159107', '短信接口', '企业邮局', '云服务器', '主机租用', '域名注册');
INSERT INTO `ey_nzsm_content` VALUES ('2', '9', '1589159121', '1589159121', '', '手机商城', '小程序商城', '微商城', 'B2C商城');
INSERT INTO `ey_nzsm_content` VALUES ('3', '10', '1589159131', '1589159131', '', 'APP开发', '微信公众平台开发', '手机网站', '小程序开发');
INSERT INTO `ey_nzsm_content` VALUES ('4', '11', '1589159145', '1589159145', 'B2C商城网站建设', '新闻门户网站建设', '营销网站建设', '品牌网站建设', '企业网站建设');

-- -----------------------------
-- Table structure for `ey_pay_api_config`
-- -----------------------------
DROP TABLE IF EXISTS `ey_pay_api_config`;
CREATE TABLE `ey_pay_api_config` (
  `pay_id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '支付接口配置ID，自增',
  `pay_name` varchar(64) NOT NULL DEFAULT '' COMMENT '支付接口配置名称，微信支付，支付宝支付...',
  `pay_mark` varchar(64) NOT NULL DEFAULT '' COMMENT '支付接口配置标识，wechat，alipay...',
  `pay_info` text NOT NULL COMMENT '支付接口配置信息，数组以序列化存储',
  `pay_terminal` varchar(100) NOT NULL DEFAULT '' COMMENT '支付时的终端，暂时预留',
  `system_built` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否属于系统内置，0否，1是',
  `status` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '状态(0=关闭，1=开启)',
  `lang` varchar(30) NOT NULL DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '添加时间',
  `update_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`pay_id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COMMENT='支付接口配置表';

-- -----------------------------
-- Records of `ey_pay_api_config`
-- -----------------------------
INSERT INTO `ey_pay_api_config` VALUES ('1', '微信支付', 'wechat', '', 'a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}', '1', '1', 'cn', '1590111253', '1590661409');
INSERT INTO `ey_pay_api_config` VALUES ('2', '支付宝支付', 'alipay', '', 'a:2:{i:0;s:1:\"1\";i:1;s:1:\"2\";}', '1', '1', 'cn', '1590111253', '1590662059');

-- -----------------------------
-- Table structure for `ey_plugin`
-- -----------------------------
DROP TABLE IF EXISTS `ey_plugin`;
CREATE TABLE `ey_plugin` (
  `code` varchar(13) DEFAULT NULL COMMENT '插件编码',
  `name` varchar(55) DEFAULT NULL COMMENT '中文名字',
  `version` varchar(255) DEFAULT NULL COMMENT '插件的版本',
  `author` varchar(30) DEFAULT NULL COMMENT '插件作者',
  `config` text COMMENT '配置信息',
  `config_value` text COMMENT '配置值信息',
  `desc` varchar(255) DEFAULT NULL COMMENT '插件描述',
  `status` tinyint(1) DEFAULT '0' COMMENT '是否启用',
  `type` varchar(50) DEFAULT NULL COMMENT '插件类型 payment支付 login 登陆 shipping物流',
  `icon` varchar(255) DEFAULT NULL COMMENT '图标',
  `bank_code` text COMMENT '网银配置信息',
  `scene` tinyint(1) DEFAULT '0' COMMENT '使用场景 0PC+手机 1手机 2PC 3APP 4小程序',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间'
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- -----------------------------
-- Records of `ey_plugin`
-- -----------------------------
INSERT INTO `ey_plugin` VALUES ('alipayMobile', '手机网站支付宝', '1.0', '宇宙人', 'a:6:{i:0;a:4:{s:4:\"name\";s:14:\"alipay_account\";s:5:\"label\";s:15:\"支付宝帐户\";s:4:\"type\";s:4:\"text\";s:5:\"value\";s:0:\"\";}i:1;a:4:{s:4:\"name\";s:10:\"alipay_key\";s:5:\"label\";s:21:\"交易安全校验码\";s:4:\"type\";s:4:\"text\";s:5:\"value\";s:0:\"\";}i:2;a:4:{s:4:\"name\";s:14:\"alipay_partner\";s:5:\"label\";s:17:\"合作者身份ID\";s:4:\"type\";s:4:\"text\";s:5:\"value\";s:0:\"\";}i:3;a:4:{s:4:\"name\";s:18:\"alipay_private_key\";s:5:\"label\";s:6:\"秘钥\";s:4:\"type\";s:8:\"textarea\";s:5:\"value\";s:0:\"\";}i:4;a:4:{s:4:\"name\";s:17:\"alipay_pay_method\";s:5:\"label\";s:19:\" 选择接口类型\";s:4:\"type\";s:6:\"select\";s:6:\"option\";a:2:{i:0;s:24:\"使用担保交易接口\";i:1;s:30:\"使用即时到帐交易接口\";}}i:5;a:4:{s:4:\"name\";s:7:\"is_bank\";s:5:\"label\";s:18:\"是否开通网银\";s:4:\"type\";s:6:\"select\";s:6:\"option\";a:2:{i:0;s:3:\"否\";i:1;s:3:\"是\";}}}', '', '手机端网站支付宝 ', '0', 'payment', 'logo.jpg', 'N;', '1', '0');
INSERT INTO `ey_plugin` VALUES ('cod', '到货付款', '1.0', 'IT宇宙人', 'a:1:{i:0;a:4:{s:4:\"name\";s:9:\"code_desc\";s:5:\"label\";s:12:\"配送描述\";s:4:\"type\";s:4:\"text\";s:5:\"value\";s:0:\"\";}}', '', '货到付款插件 ', '0', 'payment', 'logo.jpg', 'N;', '0', '0');
INSERT INTO `ey_plugin` VALUES ('miniAppPay', '微信小程序支付', '1.0', 'lhb', 'a:4:{i:0;a:5:{s:4:\"name\";s:5:\"appid\";s:5:\"label\";s:20:\"绑定支付的APPID\";s:4:\"type\";s:4:\"text\";s:5:\"value\";s:0:\"\";s:4:\"hint\";s:0:\"\";}i:1;a:4:{s:4:\"name\";s:5:\"mchid\";s:5:\"label\";s:9:\"商户号\";s:4:\"type\";s:4:\"text\";s:5:\"value\";s:0:\"\";}i:2;a:4:{s:4:\"name\";s:3:\"key\";s:5:\"label\";s:18:\"商户支付密钥\";s:4:\"type\";s:4:\"text\";s:5:\"value\";s:0:\"\";}i:3;a:4:{s:4:\"name\";s:9:\"appsecret\";s:5:\"label\";s:15:\"小程序secret\";s:4:\"type\";s:4:\"text\";s:5:\"value\";s:0:\"\";}}', '', '微信小程序支付信息', '0', 'payment', 'logo.jpg', 'N;', '4', '0');
INSERT INTO `ey_plugin` VALUES ('appWeixinPay', 'App微信支付', '1.0', 'wangqh', 'a:3:{i:0;a:5:{s:4:\"name\";s:5:\"appid\";s:5:\"label\";s:20:\"绑定支付的APPID\";s:4:\"type\";s:4:\"text\";s:5:\"value\";s:0:\"\";s:4:\"hint\";s:0:\"\";}i:1;a:4:{s:4:\"name\";s:5:\"mchid\";s:5:\"label\";s:9:\"商户号\";s:4:\"type\";s:4:\"text\";s:5:\"value\";s:0:\"\";}i:2;a:4:{s:4:\"name\";s:3:\"key\";s:5:\"label\";s:18:\"商户支付密钥\";s:4:\"type\";s:4:\"text\";s:5:\"value\";s:0:\"\";}}', '', '微信开放平台支付信息', '0', 'payment', 'logo.jpg', 'N;', '3', '0');
INSERT INTO `ey_plugin` VALUES ('tenpay', 'PC端财付通', '1.0', 'IT宇宙人', 'a:2:{i:0;a:4:{s:4:\"name\";s:7:\"partner\";s:5:\"label\";s:7:\"partner\";s:4:\"type\";s:4:\"text\";s:5:\"value\";s:0:\"\";}i:1;a:4:{s:4:\"name\";s:3:\"key\";s:5:\"label\";s:3:\"key\";s:4:\"type\";s:4:\"text\";s:5:\"value\";s:0:\"\";}}', '', 'PC端财付通插件 ', '0', 'payment', 'logo.jpg', 'N;', '2', '0');
INSERT INTO `ey_plugin` VALUES ('alipay', 'PC端支付宝', '1.0', 'jy_pwn', 'a:6:{i:0;a:4:{s:4:\"name\";s:14:\"alipay_account\";s:5:\"label\";s:15:\"支付宝帐户\";s:4:\"type\";s:4:\"text\";s:5:\"value\";s:0:\"\";}i:1;a:4:{s:4:\"name\";s:10:\"alipay_key\";s:5:\"label\";s:21:\"交易安全校验码\";s:4:\"type\";s:4:\"text\";s:5:\"value\";s:0:\"\";}i:2;a:4:{s:4:\"name\";s:14:\"alipay_partner\";s:5:\"label\";s:17:\"合作者身份ID\";s:4:\"type\";s:4:\"text\";s:5:\"value\";s:0:\"\";}i:3;a:4:{s:4:\"name\";s:18:\"alipay_private_key\";s:5:\"label\";s:6:\"秘钥\";s:4:\"type\";s:8:\"textarea\";s:5:\"value\";s:0:\"\";}i:4;a:4:{s:4:\"name\";s:17:\"alipay_pay_method\";s:5:\"label\";s:19:\" 选择接口类型\";s:4:\"type\";s:6:\"select\";s:6:\"option\";a:2:{i:0;s:24:\"使用担保交易接口\";i:1;s:30:\"使用即时到帐交易接口\";}}i:5;a:4:{s:4:\"name\";s:7:\"is_bank\";s:5:\"label\";s:18:\"是否开通网银\";s:4:\"type\";s:6:\"select\";s:6:\"option\";a:2:{i:0;s:3:\"否\";i:1;s:3:\"是\";}}}', '', 'PC端支付宝插件 ', '0', 'payment', 'logo.jpg', 'a:8:{s:12:\"招商银行\";s:9:\"CMB-DEBIT\";s:18:\"中国工商银行\";s:10:\"ICBC-DEBIT\";s:12:\"交通银行\";s:10:\"COMM-DEBIT\";s:18:\"中国建设银行\";s:9:\"CCB-DEBIT\";s:18:\"中国民生银行\";s:4:\"CMBC\";s:12:\"中国银行\";s:9:\"BOC-DEBIT\";s:18:\"中国农业银行\";s:3:\"ABC\";s:12:\"上海银行\";s:6:\"SHBANK\";}', '2', '0');
INSERT INTO `ey_plugin` VALUES ('unionpay', '银联在线支付', '1.0', '奇闻科技', 'a:4:{i:0;a:4:{s:4:\"name\";s:12:\"unionpay_mid\";s:5:\"label\";s:9:\"商户号\";s:4:\"type\";s:4:\"text\";s:5:\"value\";s:15:\"777290058130619\";}i:1;a:4:{s:4:\"name\";s:21:\"unionpay_cer_password\";s:5:\"label\";s:25:\" 商户私钥证书密码\";s:4:\"type\";s:4:\"text\";s:5:\"value\";s:6:\"000000\";}i:2;a:4:{s:4:\"name\";s:13:\"unionpay_user\";s:5:\"label\";s:19:\" 企业网银账号\";s:4:\"type\";s:4:\"text\";s:5:\"value\";s:12:\"123456789001\";}i:3;a:4:{s:4:\"name\";s:17:\"unionpay_password\";s:5:\"label\";s:19:\" 企业网银密码\";s:4:\"type\";s:4:\"text\";s:5:\"value\";s:6:\"789001\";}}', '', '银联在线支付插件 ', '0', 'payment', 'logo.jpg', 'N;', '0', '0');
INSERT INTO `ey_plugin` VALUES ('weixin', '微信支付', '1.0', 'IT宇宙人', 'a:5:{i:0;a:4:{s:4:\"name\";s:5:\"appid\";s:5:\"label\";s:20:\"绑定支付的APPID\";s:4:\"type\";s:4:\"text\";s:5:\"value\";s:0:\"\";}i:1;a:4:{s:4:\"name\";s:5:\"mchid\";s:5:\"label\";s:9:\"商户号\";s:4:\"type\";s:4:\"text\";s:5:\"value\";s:0:\"\";}i:2;a:4:{s:4:\"name\";s:3:\"key\";s:5:\"label\";s:18:\"商户支付密钥\";s:4:\"type\";s:4:\"text\";s:5:\"value\";s:0:\"\";}i:3;a:4:{s:4:\"name\";s:9:\"appsecret\";s:5:\"label\";s:57:\"公众帐号secert（仅JSAPI支付的时候需要配置)\";s:4:\"type\";s:4:\"text\";s:5:\"value\";s:0:\"\";}i:4;a:4:{s:4:\"name\";s:6:\"smchid\";s:5:\"label\";s:48:\"服务商商户号，企业在线付款需用到\";s:4:\"type\";s:4:\"text\";s:5:\"value\";s:0:\"\";}}', '', 'PC端+微信公众号支付', '0', 'payment', 'logo.jpg', 'N;', '0', '0');
INSERT INTO `ey_plugin` VALUES ('helloworld', 'HelloWorld插件', 'v2.0.5,v2.0.7', '惹妹子生气了', '', '', '适合v2.0.5 , v2.0.7', '0', 'function', 'logo.jpg', 'N;', '0', '0');
INSERT INTO `ey_plugin` VALUES ('weixin', '微信登录', '1.0', '彭老师', 'a:3:{i:0;a:4:{s:4:\"name\";s:5:\"appid\";s:5:\"label\";s:17:\"开放平台appid\";s:4:\"type\";s:4:\"text\";s:5:\"value\";s:0:\"\";}i:1;a:4:{s:4:\"name\";s:6:\"secret\";s:5:\"label\";s:18:\"开放平台secret\";s:4:\"type\";s:4:\"text\";s:5:\"value\";s:0:\"\";}i:2;a:4:{s:4:\"name\";s:10:\"return_url\";s:5:\"label\";s:9:\"回调URL\";s:4:\"type\";s:4:\"text\";s:5:\"value\";s:0:\"\";}}', 'a:3:{s:5:\"appid\";s:18:\"wx0f0ff39efd386c42\";s:6:\"secret\";s:32:\"fc878c9641346adc9b7d7e299572ba42\";s:10:\"return_url\";s:67:\"http://www.lvxing1788.com/index/LoginApi/callback/oauth/weixin.html\";}', '微信扫码登录插件 ', '1', 'login', 'logo.jpg', 'N;', '0', '1513556648');
INSERT INTO `ey_plugin` VALUES ('qq', 'QQ登录', '1.0', '彭老师', 'a:3:{i:0;a:4:{s:4:\"name\";s:6:\"app_id\";s:5:\"label\";s:6:\"app_id\";s:4:\"type\";s:4:\"text\";s:5:\"value\";s:0:\"\";}i:1;a:4:{s:4:\"name\";s:10:\"app_secret\";s:5:\"label\";s:10:\"app_secret\";s:4:\"type\";s:4:\"text\";s:5:\"value\";s:0:\"\";}i:2;a:4:{s:4:\"name\";s:10:\"return_url\";s:5:\"label\";s:9:\"回调URL\";s:4:\"type\";s:4:\"text\";s:5:\"value\";s:0:\"\";}}', '', 'QQ登录插件 ', '1', 'login', 'logo.jpg', 'N;', '0', '0');

-- -----------------------------
-- Table structure for `ey_product_attr`
-- -----------------------------
DROP TABLE IF EXISTS `ey_product_attr`;
CREATE TABLE `ey_product_attr` (
  `product_attr_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '产品属性id自增',
  `aid` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT '产品id',
  `attr_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '属性id',
  `attr_value` text COMMENT '属性值',
  `attr_price` varchar(255) DEFAULT '' COMMENT '属性价格',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`product_attr_id`),
  KEY `aid` (`aid`) USING BTREE,
  KEY `attr_id` (`attr_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='产品表单属性值';


-- -----------------------------
-- Table structure for `ey_product_attribute`
-- -----------------------------
DROP TABLE IF EXISTS `ey_product_attribute`;
CREATE TABLE `ey_product_attribute` (
  `attr_id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '属性id',
  `attr_name` varchar(60) DEFAULT '' COMMENT '属性名称',
  `typeid` int(11) unsigned DEFAULT '0' COMMENT '栏目id',
  `attr_index` tinyint(1) unsigned DEFAULT '0' COMMENT '0不需要检索 1关键字检索 2范围检索',
  `attr_input_type` tinyint(1) unsigned DEFAULT '0' COMMENT ' 0=文本框，1=下拉框，2=多行文本框',
  `attr_values` text COMMENT '可选值列表',
  `sort_order` int(11) unsigned DEFAULT '0' COMMENT '属性排序',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `is_del` tinyint(1) DEFAULT '0' COMMENT '是否已删除，0=否，1=是',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`attr_id`),
  KEY `cat_id` (`typeid`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='产品表单属性表';


-- -----------------------------
-- Table structure for `ey_product_content`
-- -----------------------------
DROP TABLE IF EXISTS `ey_product_content`;
CREATE TABLE `ey_product_content` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `aid` int(10) DEFAULT '0' COMMENT '文档ID',
  `content` longtext COMMENT '内容详情',
  `content_ey_m` longtext COMMENT '手机端内容详情',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`),
  KEY `news_id` (`aid`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='资讯内容表_存储正常内容';


-- -----------------------------
-- Table structure for `ey_product_custom_param`
-- -----------------------------
DROP TABLE IF EXISTS `ey_product_custom_param`;
CREATE TABLE `ey_product_custom_param` (
  `param_id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '参数ID',
  `aid` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '参数ID',
  `param_name` varchar(60) NOT NULL DEFAULT '' COMMENT '参数名称',
  `param_value` varchar(200) NOT NULL DEFAULT '' COMMENT '参数值',
  `sort_order` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '属性排序',
  `add_time` int(11) NOT NULL DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`param_id`),
  KEY `aid` (`aid`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;


-- -----------------------------
-- Table structure for `ey_product_img`
-- -----------------------------
DROP TABLE IF EXISTS `ey_product_img`;
CREATE TABLE `ey_product_img` (
  `img_id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `aid` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT '产品ID',
  `title` varchar(200) DEFAULT '' COMMENT '产品标题',
  `image_url` varchar(255) DEFAULT '' COMMENT '文件存储路径',
  `intro` varchar(2000) DEFAULT '' COMMENT '图集描述',
  `width` int(11) DEFAULT '0' COMMENT '图片宽度',
  `height` int(11) DEFAULT '0' COMMENT '图片高度',
  `filesize` varchar(255) DEFAULT '' COMMENT '文件大小',
  `mime` varchar(50) DEFAULT '' COMMENT '图片类型',
  `sort_order` smallint(5) DEFAULT '0' COMMENT '排序',
  `add_time` int(10) unsigned DEFAULT '0' COMMENT '上传时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`img_id`),
  KEY `arcid` (`aid`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='产品图片表';


-- -----------------------------
-- Table structure for `ey_product_netdisk`
-- -----------------------------
DROP TABLE IF EXISTS `ey_product_netdisk`;
CREATE TABLE `ey_product_netdisk` (
  `nd_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '网盘商品id',
  `aid` int(10) DEFAULT '0' COMMENT '产品ID',
  `netdisk_url` varchar(255) NOT NULL DEFAULT '' COMMENT '网盘地址',
  `netdisk_pwd` varchar(50) NOT NULL DEFAULT '' COMMENT '提取码',
  `unzip_pwd` varchar(50) NOT NULL DEFAULT '' COMMENT '解压密码',
  `text_content` text NOT NULL COMMENT '文本内容',
  `lang` varchar(10) NOT NULL DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`nd_id`) USING BTREE,
  KEY `aid` (`aid`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='产品虚拟表';


-- -----------------------------
-- Table structure for `ey_product_spec_data`
-- -----------------------------
DROP TABLE IF EXISTS `ey_product_spec_data`;
CREATE TABLE `ey_product_spec_data` (
  `spec_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `aid` int(10) DEFAULT '0' COMMENT '产品ID',
  `spec_mark_id` int(10) DEFAULT '0' COMMENT '规格标记ID',
  `spec_name` varchar(255) DEFAULT '' COMMENT '规格名称',
  `spec_value_id` int(10) DEFAULT '0' COMMENT '规格值ID',
  `spec_value` varchar(255) DEFAULT '' COMMENT '规格值',
  `spec_is_select` tinyint(1) DEFAULT '0' COMMENT '是否选中（0=否，1=是）',
  `open_image` tinyint(1) unsigned DEFAULT '0' COMMENT '规格是否开启图片',
  `spec_image` varchar(255) DEFAULT '' COMMENT '规格图片',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`spec_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='产品规格数据表';


-- -----------------------------
-- Table structure for `ey_product_spec_data_handle`
-- -----------------------------
DROP TABLE IF EXISTS `ey_product_spec_data_handle`;
CREATE TABLE `ey_product_spec_data_handle` (
  `handle_id` int(10) NOT NULL AUTO_INCREMENT,
  `spec_id` int(10) DEFAULT '0' COMMENT '对应 product_spec_data 数据表',
  `aid` int(10) DEFAULT '0' COMMENT '对应 product_spec_data 数据表',
  `spec_mark_id` int(10) DEFAULT '0' COMMENT '对应 product_spec_data 数据表',
  `spec_name` varchar(255) DEFAULT '' COMMENT '对应 product_spec_data 数据表',
  `spec_value_id` int(10) DEFAULT '0' COMMENT '对应 product_spec_data 数据表',
  `spec_value` varchar(255) DEFAULT '' COMMENT '对应 product_spec_data 数据表',
  `spec_is_select` tinyint(1) DEFAULT '0' COMMENT '对应 product_spec_data 数据表',
  `open_image` tinyint(1) unsigned DEFAULT '0' COMMENT '规格是否开启图片',
  `spec_image` varchar(255) DEFAULT '' COMMENT '规格图片',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '对应 product_spec_data 数据表',
  `add_time` int(11) DEFAULT '0' COMMENT '对应 product_spec_data 数据表',
  `update_time` int(11) DEFAULT '0' COMMENT '对应 product_spec_data 数据表',
  PRIMARY KEY (`handle_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='商品规格表(product_spec_data)预处理规格数据表';


-- -----------------------------
-- Table structure for `ey_product_spec_preset`
-- -----------------------------
DROP TABLE IF EXISTS `ey_product_spec_preset`;
CREATE TABLE `ey_product_spec_preset` (
  `preset_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `preset_mark_id` int(10) DEFAULT '0' COMMENT '预设参数标记ID',
  `preset_name` varchar(100) DEFAULT '' COMMENT '规格名称',
  `preset_value` varchar(100) DEFAULT '' COMMENT '规格值',
  `spec_sync` tinyint(1) unsigned DEFAULT '0' COMMENT '是否同步到已发布的商品规格：0否，1是。',
  `sort_order` int(10) DEFAULT '100' COMMENT '排序号',
  `merchant_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '多商家ID',
  `product_add` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否在商品添加或编辑页添加的规格信息，0否，1是，默认0',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`preset_id`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COMMENT='产品规格预设表';

-- -----------------------------
-- Records of `ey_product_spec_preset`
-- -----------------------------
INSERT INTO `ey_product_spec_preset` VALUES ('1', '1', '产品颜色', '红', '0', '100', '0', '0', 'cn', '1565752372', '1565752623');
INSERT INTO `ey_product_spec_preset` VALUES ('2', '1', '产品颜色', '蓝', '0', '100', '0', '0', 'cn', '1565752372', '1565752623');
INSERT INTO `ey_product_spec_preset` VALUES ('3', '1', '产品颜色', '黄', '0', '100', '0', '0', 'cn', '1565752372', '1565752623');

-- -----------------------------
-- Table structure for `ey_product_spec_value`
-- -----------------------------
DROP TABLE IF EXISTS `ey_product_spec_value`;
CREATE TABLE `ey_product_spec_value` (
  `value_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `aid` int(10) NOT NULL DEFAULT '0' COMMENT '产品ID',
  `spec_value_id` varchar(100) NOT NULL DEFAULT '' COMMENT '规格值ID',
  `spec_price` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '规格价格',
  `spec_crossed_price` decimal(10,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '商品规格划线价',
  `spec_stock` int(10) NOT NULL DEFAULT '0' COMMENT '规格库存',
  `spec_sales_num` int(10) NOT NULL DEFAULT '0' COMMENT '销售量',
  `seckill_price` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '秒杀价格',
  `seckill_stock` int(10) NOT NULL DEFAULT '0' COMMENT '秒杀库存(独立库存，与spec_stock/限时折扣库存不同步)',
  `seckill_sales_num` int(10) NOT NULL DEFAULT '0' COMMENT '秒杀销售量',
  `is_seckill` tinyint(1) NOT NULL DEFAULT '0' COMMENT '0-普通 1-秒杀',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  `discount_price` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '限时折扣价格',
  `discount_stock` int(10) NOT NULL DEFAULT '0' COMMENT '限时折扣库存(独立库存，与spec_stock/秒杀库存不同步)',
  `discount_sales_num` int(10) NOT NULL DEFAULT '0' COMMENT '限时折扣销售量',
  `is_discount` tinyint(1) NOT NULL DEFAULT '0' COMMENT '0-普通 1-限时折扣',
  PRIMARY KEY (`value_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='产品多规格组装表';


-- -----------------------------
-- Table structure for `ey_product_spec_value_handle`
-- -----------------------------
DROP TABLE IF EXISTS `ey_product_spec_value_handle`;
CREATE TABLE `ey_product_spec_value_handle` (
  `value_id` int(20) NOT NULL DEFAULT '0' COMMENT '对应 product_spec_value 数据表',
  `aid` int(10) NOT NULL DEFAULT '0' COMMENT '对应 product_spec_value 数据表',
  `spec_value_id` varchar(100) NOT NULL DEFAULT '' COMMENT '对应 product_spec_value 数据表',
  `spec_price` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '对应 product_spec_value 数据表',
  `spec_crossed_price` decimal(10,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '对应 product_spec_value 数据表',
  `spec_stock` int(10) NOT NULL DEFAULT '0' COMMENT '对应 product_spec_value 数据表',
  `spec_sales_num` int(10) NOT NULL DEFAULT '0' COMMENT '对应 product_spec_value 数据表',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '对应 product_spec_value 数据表',
  `add_time` int(11) DEFAULT '0' COMMENT '对应 product_spec_value 数据表',
  `update_time` int(11) DEFAULT '0' COMMENT '对应 product_spec_value 数据表',
  `seckill_price` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '对应 product_spec_value 数据表',
  `seckill_stock` int(10) NOT NULL DEFAULT '0' COMMENT '对应 product_spec_value 数据表',
  `seckill_sales_num` int(10) NOT NULL DEFAULT '0' COMMENT '对应 product_spec_value 数据表',
  `is_seckill` tinyint(1) NOT NULL DEFAULT '0' COMMENT '对应 product_spec_value 数据表',
  `discount_price` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '对应 product_spec_value 数据表',
  `discount_stock` int(10) NOT NULL DEFAULT '0' COMMENT '对应 product_spec_value 数据表',
  `discount_sales_num` int(10) NOT NULL DEFAULT '0' COMMENT '对应 product_spec_value 数据表',
  `is_discount` tinyint(1) NOT NULL DEFAULT '0' COMMENT '对应 product_spec_value 数据表',
  PRIMARY KEY (`value_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='商品规格价格表(product_spec_value)预处理规格价格表';


-- -----------------------------
-- Table structure for `ey_product_users_discount`
-- -----------------------------
DROP TABLE IF EXISTS `ey_product_users_discount`;
CREATE TABLE `ey_product_users_discount` (
  `users_discount_id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `aid` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '产品ID',
  `level_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '会员等级ID',
  `users_discount_price` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '会员等级价格',
  `add_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '下单时间',
  `update_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`users_discount_id`),
  KEY `aid` (`aid`) USING BTREE,
  KEY `level_id` (`level_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='产品指定会员等级折扣列表';


-- -----------------------------
-- Table structure for `ey_quickentry`
-- -----------------------------
DROP TABLE IF EXISTS `ey_quickentry`;
CREATE TABLE `ey_quickentry` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `title` varchar(20) DEFAULT '' COMMENT '名称',
  `laytext` varchar(50) DEFAULT '' COMMENT '完整标题',
  `type` smallint(5) DEFAULT '0' COMMENT '归类，1=快捷入口，2=内容统计',
  `controller` varchar(50) DEFAULT '' COMMENT '控制器名',
  `action` varchar(20) DEFAULT '' COMMENT '操作名',
  `vars` varchar(100) DEFAULT '' COMMENT 'URL参数字符串',
  `groups` smallint(5) DEFAULT '0' COMMENT '分组，1=模型',
  `checked` tinyint(4) DEFAULT '0' COMMENT '选中，0=否，1=是',
  `litpic` varchar(100) DEFAULT '',
  `statistics_type` int(5) DEFAULT '0' COMMENT 'statistics_data表对应的type值',
  `status` tinyint(1) DEFAULT '1' COMMENT '状态，1=有效，0=无效',
  `sort_order` int(10) DEFAULT '0' COMMENT '排序',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`),
  KEY `type` (`type`,`status`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=67 DEFAULT CHARSET=utf8 COMMENT='快捷入口表';

-- -----------------------------
-- Records of `ey_quickentry`
-- -----------------------------
INSERT INTO `ey_quickentry` VALUES ('1', '产品', '产品列表', '1', 'Product', 'index', 'channel=2', '1', '0', '', '0', '1', '3', '1569232484', '1721264855');
INSERT INTO `ey_quickentry` VALUES ('2', '下载', '下载列表', '1', 'Download', 'index', 'channel=4', '1', '0', '', '0', '1', '4', '1569232484', '1721264855');
INSERT INTO `ey_quickentry` VALUES ('3', '文章', '文章列表', '1', 'Article', 'index', 'channel=1', '1', '0', '', '0', '1', '6', '1569232484', '1721264855');
INSERT INTO `ey_quickentry` VALUES ('4', '图集', '图集列表', '1', 'Images', 'index', 'channel=3', '1', '0', '', '0', '1', '7', '1569232484', '1721264855');
INSERT INTO `ey_quickentry` VALUES ('5', '内容管理', '内容列表', '1', 'Archives', 'index', '', '0', '0', '', '0', '1', '13', '1569232484', '1571893529');
INSERT INTO `ey_quickentry` VALUES ('7', '回收站', '回收站', '1', 'RecycleBin', 'archives_index', '', '0', '1', '', '0', '1', '4', '1569232484', '1571893529');
INSERT INTO `ey_quickentry` VALUES ('8', '栏目管理', '栏目管理', '1', 'Arctype', 'index', '', '0', '0', '', '0', '1', '5', '1569232484', '1571893529');
INSERT INTO `ey_quickentry` VALUES ('9', '留言', '留言管理', '1', 'Form', 'index', '', '1', '0', '', '0', '1', '6', '1569232484', '1713172596');
INSERT INTO `ey_quickentry` VALUES ('10', '网站信息', '网站信息', '1', 'System', 'web', '', '0', '0', '', '0', '1', '7', '1569232484', '1571893529');
INSERT INTO `ey_quickentry` VALUES ('11', '水印配置', '水印配置', '1', 'System', 'water', '', '0', '1', '', '0', '1', '8', '1569232484', '1571893529');
INSERT INTO `ey_quickentry` VALUES ('12', '缩略图配置', '缩略图配置', '1', 'System', 'thumb', '', '0', '1', '', '0', '1', '9', '1569232484', '1571893529');
INSERT INTO `ey_quickentry` VALUES ('13', '数据备份', '数据备份', '1', 'Tools', 'index', '', '0', '0', '', '0', '1', '11', '1569232484', '1571893529');
INSERT INTO `ey_quickentry` VALUES ('14', 'URL配置', 'URL配置', '1', 'Seo', 'seo', '', '0', '1', '', '0', '1', '1', '1569232484', '1571893529');
INSERT INTO `ey_quickentry` VALUES ('15', '模板管理', '模板管理', '1', 'Filemanager', 'index', '', '0', '1', '', '0', '1', '6', '1569232484', '1571893529');
INSERT INTO `ey_quickentry` VALUES ('16', 'SiteMap', 'SiteMap', '1', 'Sitemap', 'index', '', '0', '1', '', '0', '1', '12', '1569232484', '1571893529');
INSERT INTO `ey_quickentry` VALUES ('17', '频道模型', '频道模型', '1', 'Channeltype', 'index', '', '0', '1', '', '0', '1', '2', '1569232484', '1571893529');
INSERT INTO `ey_quickentry` VALUES ('18', '广告管理', '广告管理', '1', 'AdPosition', 'index', '', '0', '0', '', '0', '1', '3', '1569232484', '1571893529');
INSERT INTO `ey_quickentry` VALUES ('19', '友情链接', '友情链接', '1', 'Links', 'index', '', '0', '0', '', '0', '1', '10', '1569232484', '1571893529');
INSERT INTO `ey_quickentry` VALUES ('20', 'Tags管理', 'Tags管理', '1', 'Tags', 'index', '', '0', '1', '', '0', '1', '14', '1569232484', '1571893529');
INSERT INTO `ey_quickentry` VALUES ('21', '管理员管理', '管理员管理', '1', 'Admin', 'index', '', '0', '0', '', '0', '1', '15', '1569232484', '1571893529');
INSERT INTO `ey_quickentry` VALUES ('22', '接口配置', '接口配置', '1', 'System', 'api_conf', '', '0', '1', '', '0', '1', '16', '1569232484', '1571893529');
INSERT INTO `ey_quickentry` VALUES ('23', '文章', '文章列表', '2', 'Article', 'index', 'channel=1', '1', '1', '', '0', '1', '1', '1569310798', '1721264855');
INSERT INTO `ey_quickentry` VALUES ('24', '产品', '产品列表', '2', 'Product', 'index', 'channel=2', '1', '0', '', '0', '1', '2', '1569310798', '1721264855');
INSERT INTO `ey_quickentry` VALUES ('25', '下载', '下载列表', '2', 'Download', 'index', 'channel=4', '1', '0', '', '0', '1', '4', '1569310798', '1721264855');
INSERT INTO `ey_quickentry` VALUES ('26', '图集', '图集列表', '2', 'Images', 'index', 'channel=3', '1', '0', '', '0', '1', '3', '1569310798', '1721264855');
INSERT INTO `ey_quickentry` VALUES ('27', '留言', '留言管理', '2', 'Form', 'index', '', '1', '0', '', '0', '1', '5', '1569310798', '1713172596');
INSERT INTO `ey_quickentry` VALUES ('28', '广告', '广告管理', '2', 'AdPosition', 'index', '', '0', '1', '', '0', '1', '8', '1569232484', '1571898872');
INSERT INTO `ey_quickentry` VALUES ('29', '友情链接', '友情链接', '2', 'Links', 'index', '', '0', '1', '', '0', '1', '9', '1569232484', '1571898872');
INSERT INTO `ey_quickentry` VALUES ('30', 'Tags标签', 'Tags管理', '2', 'Tags', 'index', '', '0', '1', '', '0', '1', '10', '1569232484', '1571898872');
INSERT INTO `ey_quickentry` VALUES ('31', '会员', '会员管理', '2', 'Member', 'users_index', '', '0', '0', '', '0', '0', '7', '1569232484', '1721264855');
INSERT INTO `ey_quickentry` VALUES ('32', '插件应用', '插件应用', '1', 'Weapp', 'index', '', '0', '0', '', '0', '0', '17', '1569232484', '1721264855');
INSERT INTO `ey_quickentry` VALUES ('33', '会员中心', '会员中心', '1', 'Member', 'users_index', '', '0', '0', '', '0', '0', '18', '1569232484', '1721264855');
INSERT INTO `ey_quickentry` VALUES ('34', '商城中心', '商城中心', '1', 'Shop', 'index', '', '0', '0', '', '0', '0', '19', '1569232484', '1721264855');
INSERT INTO `ey_quickentry` VALUES ('35', '订单', '订单管理', '2', 'Shop', 'index', '', '0', '0', '', '0', '0', '6', '1569232484', '1721264855');
INSERT INTO `ey_quickentry` VALUES ('37', '专题', '专题列表', '2', 'Special', 'index', 'channel=7', '1', '0', '', '0', '0', '7', '1600078966', '1721264855');
INSERT INTO `ey_quickentry` VALUES ('39', '视频', '视频列表', '2', 'Media', 'index', 'channel=5', '1', '0', '', '0', '0', '4', '1569310798', '1721264855');
INSERT INTO `ey_quickentry` VALUES ('40', '商品数', '商品总数', '21', 'ShopProduct', 'index', '', '1', '1', '', '6', '1', '1', '1569232484', '1681436771');
INSERT INTO `ey_quickentry` VALUES ('41', '充值金额', '充值总额', '21', 'Member', 'money_index', 'status=2', '1', '0', '', '5', '1', '5', '1569232484', '1681436771');
INSERT INTO `ey_quickentry` VALUES ('42', '会员数', '会员总数', '21', 'Member', 'users_index', '', '1', '0', '', '4', '1', '6', '1569232484', '1681436771');
INSERT INTO `ey_quickentry` VALUES ('43', '销售额', '销售总额', '21', 'Statistics', 'index', 'conceal=1', '1', '1', '', '3', '1', '3', '1569232484', '1681436771');
INSERT INTO `ey_quickentry` VALUES ('44', '订单数', '订单总数', '21', 'Order', 'index', '', '1', '1', '', '2', '1', '2', '1569232484', '1681436771');
INSERT INTO `ey_quickentry` VALUES ('45', '浏览量', '总浏览量', '21', '', '', '', '1', '1', '', '1', '1', '4', '1569232484', '1681436771');
INSERT INTO `ey_quickentry` VALUES ('46', '浏览量', '总浏览量', '31', '', '', '', '1', '1', '', '1', '1', '5', '1569232484', '1681461467');
INSERT INTO `ey_quickentry` VALUES ('47', '订单数', '订单总数', '31', 'Order', 'index', '', '1', '1', '', '2', '1', '3', '1569232484', '1681461467');
INSERT INTO `ey_quickentry` VALUES ('48', '销售额', '销售总额', '31', 'Statistics', 'index', 'conceal=1', '1', '1', '', '3', '1', '4', '1569232484', '1681461467');
INSERT INTO `ey_quickentry` VALUES ('49', '会员数', '会员总数', '31', 'Member', 'users_index', '', '1', '1', '', '4', '1', '1', '1569232484', '1681461467');
INSERT INTO `ey_quickentry` VALUES ('50', '充值金额', '充值总额', '31', 'Member', 'money_index', 'status=2', '1', '1', '', '5', '1', '6', '1569232484', '1681461467');
INSERT INTO `ey_quickentry` VALUES ('51', '商品数', '商品总数', '31', 'ShopProduct', 'index', '', '1', '1', '', '6', '1', '2', '1569232484', '1681461467');
INSERT INTO `ey_quickentry` VALUES ('52', '文章数', '文章总数', '31', 'Article', 'index', '', '1', '1', '', '7', '1', '7', '1569232484', '1681461467');
INSERT INTO `ey_quickentry` VALUES ('53', 'TAG标签数', 'TAG标签总数', '31', 'Tags', 'index', '', '1', '1', '', '8', '1', '8', '1569232484', '1681461467');
INSERT INTO `ey_quickentry` VALUES ('54', '待审文档', '待审总数', '31', 'Archives', 'index_draft', 'menu=1', '1', '1', '', '9', '1', '9', '1569232484', '1681461467');
INSERT INTO `ey_quickentry` VALUES ('55', '充值订单', '充值订单', '11', 'Member', 'money_index', 'status=2', '0', '1', '/public/static/admin/images/theme/survey_chongzhi.png', '0', '1', '7', '1569232484', '1681436759');
INSERT INTO `ey_quickentry` VALUES ('56', '订单查询', '订单查询', '11', 'Order', 'index', '', '0', '1', '/public/static/admin/images/theme/survey_dingdan.png', '0', '1', '2', '1569232484', '1681436759');
INSERT INTO `ey_quickentry` VALUES ('57', '发布商品', '发布商品', '11', 'ShopProduct', 'add', 'firstrun=1', '0', '1', '/public/static/admin/images/theme/survey_fabu.png', '0', '1', '1', '1569232484', '1681436759');
INSERT INTO `ey_quickentry` VALUES ('58', '前往发货', '前往发货', '11', 'Shop', 'index', 'order_status=1', '0', '1', '/public/static/admin/images/theme/survey_fahuo.png', '0', '1', '2', '1569232484', '1669604332');
INSERT INTO `ey_quickentry` VALUES ('59', '会员管理', '会员管理', '11', 'Member', 'users_index', '', '0', '1', '/public/static/admin/images/theme/survey_huiyuan.png', '0', '1', '5', '1569232484', '1681436759');
INSERT INTO `ey_quickentry` VALUES ('60', '主题风格', '主题风格', '11', 'Index', 'theme_index', '', '0', '0', '/public/static/admin/images/theme/survey_pifu.png', '0', '1', '10', '1569232484', '1681436759');
INSERT INTO `ey_quickentry` VALUES ('61', '评价管理', '评价管理', '11', 'ShopComment', 'comment_index', '', '0', '1', '/public/static/admin/images/theme/survey_pingjia.png', '0', '1', '4', '1569232484', '1681436759');
INSERT INTO `ey_quickentry` VALUES ('62', '售后维权', '售后维权', '11', 'ShopService', 'after_service', '', '0', '1', '/public/static/admin/images/theme/survey_weiquan.png', '0', '1', '3', '1569232484', '1681436759');
INSERT INTO `ey_quickentry` VALUES ('63', '优惠券', '优惠券', '11', 'Coupon', 'index', '', '0', '1', '/public/static/admin/images/theme/survey_youhuiquan.png', '0', '1', '9', '1569232484', '1681436759');
INSERT INTO `ey_quickentry` VALUES ('64', '运费模板', '运费模板', '11', 'Shop', 'shipping_template', '', '0', '1', '/public/static/admin/images/theme/survey_yunfei.png', '0', '1', '8', '1569232484', '1681436759');
INSERT INTO `ey_quickentry` VALUES ('65', '支付设置', '支付设置', '11', 'System', 'api_conf', '', '0', '1', '/public/static/admin/images/theme/survey_zhifu.png', '0', '1', '6', '1569232484', '1681436759');
INSERT INTO `ey_quickentry` VALUES ('66', '提货设置', '提货设置', '11', 'OrderVerify', 'drive_list', '', '0', '0', '/public/static/admin/images/theme/survey_ziti.png', '0', '1', '11', '1569232484', '1681436759');

-- -----------------------------
-- Table structure for `ey_recruit_content`
-- -----------------------------
DROP TABLE IF EXISTS `ey_recruit_content`;
CREATE TABLE `ey_recruit_content` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `aid` int(10) DEFAULT '0' COMMENT '文档ID',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  `gzdd` varchar(200) NOT NULL DEFAULT '' COMMENT '工作地点',
  `xlyq` varchar(200) NOT NULL DEFAULT '' COMMENT '学历要求',
  `xzdy` varchar(200) NOT NULL DEFAULT '' COMMENT '薪资待遇',
  `gzxz` varchar(200) NOT NULL DEFAULT '' COMMENT '工作性质',
  `gznx` varchar(200) NOT NULL DEFAULT '' COMMENT '工作年限',
  `zprs` varchar(200) NOT NULL DEFAULT '' COMMENT '招聘人数',
  `nnxq` longtext COMMENT '内容详情',
  PRIMARY KEY (`id`),
  KEY `aid` (`aid`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=7 DEFAULT CHARSET=utf8 COMMENT='附加表';

-- -----------------------------
-- Records of `ey_recruit_content`
-- -----------------------------
INSERT INTO `ey_recruit_content` VALUES ('1', '82', '1563528211', '1563528211', '广州市', '中专以上学历', '5000-10000元', '全职', '1年以上', '若干', '&lt;p&gt;工作内容：&lt;br style=&quot;outline: 0px; text-size-adjust: none; -webkit-tap-highlight-color: rgba(0, 0, 0, 0.05); color: rgb(46, 52, 59); font-family: &amp;quot;Microsoft YaHei&amp;quot;, &amp;quot;Hiragino Sans GB&amp;quot;, 微软雅黑, arial, Tahoma, SimSun, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);&quot;/&gt;1、负责公司手机游戏产品的在线推广；&lt;br style=&quot;outline: 0px; text-size-adjust: none; -webkit-tap-highlight-color: rgba(0, 0, 0, 0.05); color: rgb(46, 52, 59); font-family: &amp;quot;Microsoft YaHei&amp;quot;, &amp;quot;Hiragino Sans GB&amp;quot;, 微软雅黑, arial, Tahoma, SimSun, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);&quot;/&gt;2、做好每天的推广统计，定制有效的投放策略并执行；&lt;br style=&quot;outline: 0px; text-size-adjust: none; -webkit-tap-highlight-color: rgba(0, 0, 0, 0.05); color: rgb(46, 52, 59); font-family: &amp;quot;Microsoft YaHei&amp;quot;, &amp;quot;Hiragino Sans GB&amp;quot;, 微软雅黑, arial, Tahoma, SimSun, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);&quot;/&gt;3、完成每天的业绩要求，只要你努力，月入过万不是梦&lt;br style=&quot;outline: 0px; text-size-adjust: none; -webkit-tap-highlight-color: rgba(0, 0, 0, 0.05); color: rgb(46, 52, 59); font-family: &amp;quot;Microsoft YaHei&amp;quot;, &amp;quot;Hiragino Sans GB&amp;quot;, 微软雅黑, arial, Tahoma, SimSun, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);&quot;/&gt;职位要求：&lt;br style=&quot;outline: 0px; text-size-adjust: none; -webkit-tap-highlight-color: rgba(0, 0, 0, 0.05); color: rgb(46, 52, 59); font-family: &amp;quot;Microsoft YaHei&amp;quot;, &amp;quot;Hiragino Sans GB&amp;quot;, 微软雅黑, arial, Tahoma, SimSun, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);&quot;/&gt;1学历不限，欢迎优秀应届生（优秀者可放宽）；男女不限，19~24岁&lt;br style=&quot;outline: 0px; text-size-adjust: none; -webkit-tap-highlight-color: rgba(0, 0, 0, 0.05); color: rgb(46, 52, 59); font-family: &amp;quot;Microsoft YaHei&amp;quot;, &amp;quot;Hiragino Sans GB&amp;quot;, 微软雅黑, arial, Tahoma, SimSun, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);&quot;/&gt;2.亲和力强、沟通流畅、重点突出；&lt;br style=&quot;outline: 0px; text-size-adjust: none; -webkit-tap-highlight-color: rgba(0, 0, 0, 0.05); color: rgb(46, 52, 59); font-family: &amp;quot;Microsoft YaHei&amp;quot;, &amp;quot;Hiragino Sans GB&amp;quot;, 微软雅黑, arial, Tahoma, SimSun, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);&quot;/&gt;3.个性开朗、反应敏捷，有较强的服务意识和责任心；&lt;br style=&quot;outline: 0px; text-size-adjust: none; -webkit-tap-highlight-color: rgba(0, 0, 0, 0.05); color: rgb(46, 52, 59); font-family: &amp;quot;Microsoft YaHei&amp;quot;, &amp;quot;Hiragino Sans GB&amp;quot;, 微软雅黑, arial, Tahoma, SimSun, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);&quot;/&gt;4.能熟练运用QQ及微信聊天软件，懂得电脑的基本操作，打字速度不限&lt;br style=&quot;outline: 0px; text-size-adjust: none; -webkit-tap-highlight-color: rgba(0, 0, 0, 0.05); color: rgb(46, 52, 59); font-family: &amp;quot;Microsoft YaHei&amp;quot;, &amp;quot;Hiragino Sans GB&amp;quot;, 微软雅黑, arial, Tahoma, SimSun, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);&quot;/&gt;我们期待怀揣梦想的你加入我们！&lt;br style=&quot;outline: 0px; text-size-adjust: none; -webkit-tap-highlight-color: rgba(0, 0, 0, 0.05); color: rgb(46, 52, 59); font-family: &amp;quot;Microsoft YaHei&amp;quot;, &amp;quot;Hiragino Sans GB&amp;quot;, 微软雅黑, arial, Tahoma, SimSun, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);&quot;/&gt;5、有经验者优先考虑！！！！！&lt;/p&gt;');
INSERT INTO `ey_recruit_content` VALUES ('2', '83', '1563528292', '1563528292', '广州市', '中专以上学历', '5000-8000元', '全职', '2年以上', '2位', '&lt;p&gt;&lt;span style=&quot;color: rgb(46, 52, 59); font-family: &amp;quot;Microsoft YaHei&amp;quot;, &amp;quot;Hiragino Sans GB&amp;quot;, 微软雅黑, arial, Tahoma, SimSun, sans-serif; font-size: 14px; background-color: rgb(255, 255, 255);&quot;&gt;岗位职责：&lt;/span&gt;&lt;br style=&quot;outline: 0px; text-size-adjust: none; -webkit-tap-highlight-color: rgba(0, 0, 0, 0.05); color: rgb(46, 52, 59); font-family: &amp;quot;Microsoft YaHei&amp;quot;, &amp;quot;Hiragino Sans GB&amp;quot;, 微软雅黑, arial, Tahoma, SimSun, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);&quot;/&gt;&lt;span style=&quot;color: rgb(46, 52, 59); font-family: &amp;quot;Microsoft YaHei&amp;quot;, &amp;quot;Hiragino Sans GB&amp;quot;, 微软雅黑, arial, Tahoma, SimSun, sans-serif; font-size: 14px; background-color: rgb(255, 255, 255);&quot;&gt;1、负责网站相关栏目、信息的搜集、编辑、发布等工作。&lt;/span&gt;&lt;br style=&quot;outline: 0px; text-size-adjust: none; -webkit-tap-highlight-color: rgba(0, 0, 0, 0.05); color: rgb(46, 52, 59); font-family: &amp;quot;Microsoft YaHei&amp;quot;, &amp;quot;Hiragino Sans GB&amp;quot;, 微软雅黑, arial, Tahoma, SimSun, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);&quot;/&gt;&lt;span style=&quot;color: rgb(46, 52, 59); font-family: &amp;quot;Microsoft YaHei&amp;quot;, &amp;quot;Hiragino Sans GB&amp;quot;, 微软雅黑, arial, Tahoma, SimSun, sans-serif; font-size: 14px; background-color: rgb(255, 255, 255);&quot;&gt;2、完成信息内容的策划和日常信息的更新与维护。&lt;/span&gt;&lt;br style=&quot;outline: 0px; text-size-adjust: none; -webkit-tap-highlight-color: rgba(0, 0, 0, 0.05); color: rgb(46, 52, 59); font-family: &amp;quot;Microsoft YaHei&amp;quot;, &amp;quot;Hiragino Sans GB&amp;quot;, 微软雅黑, arial, Tahoma, SimSun, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);&quot;/&gt;&lt;span style=&quot;color: rgb(46, 52, 59); font-family: &amp;quot;Microsoft YaHei&amp;quot;, &amp;quot;Hiragino Sans GB&amp;quot;, 微软雅黑, arial, Tahoma, SimSun, sans-serif; font-size: 14px; background-color: rgb(255, 255, 255);&quot;&gt;3、编写网站宣传资料及相关产品信息。&lt;/span&gt;&lt;br style=&quot;outline: 0px; text-size-adjust: none; -webkit-tap-highlight-color: rgba(0, 0, 0, 0.05); color: rgb(46, 52, 59); font-family: &amp;quot;Microsoft YaHei&amp;quot;, &amp;quot;Hiragino Sans GB&amp;quot;, 微软雅黑, arial, Tahoma, SimSun, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);&quot;/&gt;&lt;span style=&quot;color: rgb(46, 52, 59); font-family: &amp;quot;Microsoft YaHei&amp;quot;, &amp;quot;Hiragino Sans GB&amp;quot;, 微软雅黑, arial, Tahoma, SimSun, sans-serif; font-size: 14px; background-color: rgb(255, 255, 255);&quot;&gt;4、配合部门编辑策划推广活动。&lt;/span&gt;&lt;br style=&quot;outline: 0px; text-size-adjust: none; -webkit-tap-highlight-color: rgba(0, 0, 0, 0.05); color: rgb(46, 52, 59); font-family: &amp;quot;Microsoft YaHei&amp;quot;, &amp;quot;Hiragino Sans GB&amp;quot;, 微软雅黑, arial, Tahoma, SimSun, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);&quot;/&gt;&lt;span style=&quot;color: rgb(46, 52, 59); font-family: &amp;quot;Microsoft YaHei&amp;quot;, &amp;quot;Hiragino Sans GB&amp;quot;, 微软雅黑, arial, Tahoma, SimSun, sans-serif; font-size: 14px; background-color: rgb(255, 255, 255);&quot;&gt;5、部门总监下发的其他任务。&lt;/span&gt;&lt;br style=&quot;outline: 0px; text-size-adjust: none; -webkit-tap-highlight-color: rgba(0, 0, 0, 0.05); color: rgb(46, 52, 59); font-family: &amp;quot;Microsoft YaHei&amp;quot;, &amp;quot;Hiragino Sans GB&amp;quot;, 微软雅黑, arial, Tahoma, SimSun, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);&quot;/&gt;&lt;span style=&quot;color: rgb(46, 52, 59); font-family: &amp;quot;Microsoft YaHei&amp;quot;, &amp;quot;Hiragino Sans GB&amp;quot;, 微软雅黑, arial, Tahoma, SimSun, sans-serif; font-size: 14px; background-color: rgb(255, 255, 255);&quot;&gt;任职资格：&lt;/span&gt;&lt;br style=&quot;outline: 0px; text-size-adjust: none; -webkit-tap-highlight-color: rgba(0, 0, 0, 0.05); color: rgb(46, 52, 59); font-family: &amp;quot;Microsoft YaHei&amp;quot;, &amp;quot;Hiragino Sans GB&amp;quot;, 微软雅黑, arial, Tahoma, SimSun, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);&quot;/&gt;&lt;span style=&quot;color: rgb(46, 52, 59); font-family: &amp;quot;Microsoft YaHei&amp;quot;, &amp;quot;Hiragino Sans GB&amp;quot;, 微软雅黑, arial, Tahoma, SimSun, sans-serif; font-size: 14px; background-color: rgb(255, 255, 255);&quot;&gt;1、编辑、新闻、中文等相关专业优先，大专及以上学历。&lt;/span&gt;&lt;br style=&quot;outline: 0px; text-size-adjust: none; -webkit-tap-highlight-color: rgba(0, 0, 0, 0.05); color: rgb(46, 52, 59); font-family: &amp;quot;Microsoft YaHei&amp;quot;, &amp;quot;Hiragino Sans GB&amp;quot;, 微软雅黑, arial, Tahoma, SimSun, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);&quot;/&gt;&lt;span style=&quot;color: rgb(46, 52, 59); font-family: &amp;quot;Microsoft YaHei&amp;quot;, &amp;quot;Hiragino Sans GB&amp;quot;, 微软雅黑, arial, Tahoma, SimSun, sans-serif; font-size: 14px; background-color: rgb(255, 255, 255);&quot;&gt;2、有编辑或从事相关工作经验优先。&lt;/span&gt;&lt;br style=&quot;outline: 0px; text-size-adjust: none; -webkit-tap-highlight-color: rgba(0, 0, 0, 0.05); color: rgb(46, 52, 59); font-family: &amp;quot;Microsoft YaHei&amp;quot;, &amp;quot;Hiragino Sans GB&amp;quot;, 微软雅黑, arial, Tahoma, SimSun, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);&quot;/&gt;&lt;span style=&quot;color: rgb(46, 52, 59); font-family: &amp;quot;Microsoft YaHei&amp;quot;, &amp;quot;Hiragino Sans GB&amp;quot;, 微软雅黑, arial, Tahoma, SimSun, sans-serif; font-size: 14px; background-color: rgb(255, 255, 255);&quot;&gt;3、熟练使用网页制作软件和网络搜索工具，了解网站运行、维护相关知识。&lt;/span&gt;&lt;br style=&quot;outline: 0px; text-size-adjust: none; -webkit-tap-highlight-color: rgba(0, 0, 0, 0.05); color: rgb(46, 52, 59); font-family: &amp;quot;Microsoft YaHei&amp;quot;, &amp;quot;Hiragino Sans GB&amp;quot;, 微软雅黑, arial, Tahoma, SimSun, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);&quot;/&gt;&lt;span style=&quot;color: rgb(46, 52, 59); font-family: &amp;quot;Microsoft YaHei&amp;quot;, &amp;quot;Hiragino Sans GB&amp;quot;, 微软雅黑, arial, Tahoma, SimSun, sans-serif; font-size: 14px; background-color: rgb(255, 255, 255);&quot;&gt;4、良好的文字功底，信息采编能力。&lt;/span&gt;&lt;br style=&quot;outline: 0px; text-size-adjust: none; -webkit-tap-highlight-color: rgba(0, 0, 0, 0.05); color: rgb(46, 52, 59); font-family: &amp;quot;Microsoft YaHei&amp;quot;, &amp;quot;Hiragino Sans GB&amp;quot;, 微软雅黑, arial, Tahoma, SimSun, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);&quot;/&gt;&lt;span style=&quot;color: rgb(46, 52, 59); font-family: &amp;quot;Microsoft YaHei&amp;quot;, &amp;quot;Hiragino Sans GB&amp;quot;, 微软雅黑, arial, Tahoma, SimSun, sans-serif; font-size: 14px; background-color: rgb(255, 255, 255);&quot;&gt;5、欢迎应届毕业生来应聘。&lt;/span&gt;&lt;/p&gt;');
INSERT INTO `ey_recruit_content` VALUES ('3', '94', '1565225547', '1565225547', '广州市', '专科以上学历', '5000-8000元', '全职', '2年以上', '若干', '&lt;p&gt;1、负责客户开发、提供客户服务、公司服务的推广、建立与维护客户关系；&lt;/p&gt;&lt;p&gt;2、根据市场营销计划和个人销售目标，完成各阶段销售目标；&lt;/p&gt;&lt;p&gt;3、进行市场调研，确定目标市场，收集分析竞争对象信息，制订、执行销售对策；&lt;/p&gt;&lt;p&gt;4、与内部相关部门建立并维持良好的协作关系，以客户和市场为导向，协调各方面关系，确保合同的顺利执行。&lt;/p&gt;&lt;p&gt;【岗位要求】&lt;/p&gt;&lt;p&gt;1、专科学历，有一定客户服务工作经验或销售经验，有一定的客户服务知识和能力。&lt;/p&gt;&lt;p&gt;2、计算机操作熟练，office办公软件使用熟练，有一定的网络基础知识，熟练使用Photoshop等制图工具着优先考虑。&lt;/p&gt;&lt;p&gt;3、要求一定要有“客户优先”的服务精神，一切从帮助客户、满足客户角度出发。&lt;/p&gt;&lt;p&gt;4、性格要求沉稳、隐忍，善于倾听，有同理心，乐观、积极。普通话标准、流利，反应灵敏。&lt;/p&gt;&lt;p&gt;5、热爱工作，敬业、勤恳、乐于思考，具有自我发展的主观的主题愿望和自我学习能力。可适当加班者优先。&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;');
INSERT INTO `ey_recruit_content` VALUES ('4', '95', '1565225608', '1565225608', '广州市', '专科以上学历', '5000-10000元', '全职', '2年以上', '若干', '&lt;p&gt;岗位职责：1、利用网络进行公司产品的销售及推广2、了解网络销售，有信心和良好的学习能力3、完成团队目标4、通过网络进行渠道开发和业务拓展5、熟悉互联网络，熟练使用网络交流工具和各种办公软件6、有较强的沟通能力&lt;/p&gt;&lt;p&gt;任职要求：1、年龄18～25之间，有空杯心态者优先2、性格开朗，喜欢与人沟通，表达流畅，普通话标准3、具备一定的客户服务精神，准确把握客户需求4、认真细致，能接受挑战性任务5、有无销售经验均可，欢迎应届毕业生应聘&lt;/p&gt;&lt;p&gt;薪资待遇：底薪+高抽成+奖金+年底双薪+生日聚餐，不定期的聚会和旅游等&lt;/p&gt;&lt;p&gt;晋升空间：业务基础—精英业务员—销售组长—销售主管—核心主管&lt;/p&gt;&lt;p&gt;销售激励：礼品奖励、现金奖金、出单奖励、周业绩奖励、月销售前三奖励。依法享受法定节假日（带薪旅游、带薪年假、婚假。、产假、员工生日庆祝）&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;');
INSERT INTO `ey_recruit_content` VALUES ('5', '96', '1565225638', '1565225638', '广州市', '专科以上学历', '5000-10000元', '全职', '2年以上', '若干', '&lt;p&gt;任职要求： 1、年龄25-35岁，本科及以上学历，网络安全相关专业，持网络安全证书，2年以上同岗位工作经验； 2、熟知防火墙、入侵检测、网络流量识别控制等信息安全产品相关技术；熟悉网络协议、网络编程及相关网络产品开发技术； 3、具备良好的安全意识能力、语言表达能力、逻辑思维能力、执行力、责任心、团队协作能力。 岗位职责： 1、安全设备的日常监控与维护，及时进行安全设备策略的变更与调整；安全运维的结果文档、技术资料、设备日志，配置信息等相关资料的管理及维护； 2、定期关注安全设备系统的升级补丁，合适准确性后及时更新补丁，完成安全设备系统升级； 3、安全设备的健康检查、健康检查表、基线统计、流量统计、特殊事件报告、日报、周报等日常工作； 4、参与信息安全事件的分析工作和应急处理工作；定期安全评估、扫描和加固，协助进行安全加固； 5、协助制定网络安全规范与方案，优化现有网络安全架构，定期评估网络安全风险，负责针对运行故障、安全事件开展分析和总结，定期开展运行维护、故障处理及安全事件分析； 6、完成上级领导交办的其他任务，并做好与其他部门的协调配合工作。&lt;/p&gt;');
INSERT INTO `ey_recruit_content` VALUES ('6', '97', '1565225697', '1565225697', '广州市', '专科以上学历', '5000-8000元', '全职', '1年以上', '2位', '&lt;p&gt;岗位职责1、组织参与重要项目的创意构思、文案及客户提案, 给予前期提案、设计创意说明及后期结案报告等服务；2、执行并监督所负责项目的创意构思和文案；3、稿件思路清晰，能够完成稿件写作思路规划；4、协助领导进行创意提案，保证工作的顺利推进；5、独立撰写各类稿件（新闻稿、综述稿、评论稿、专访稿等）、策划方案、报告等任职资格1、大专及以上学历；2、一年以上市场策划及文案工作经验；3、能够准确捕捉产品亮点，具备恰如其分的文字表现能力；4、熟悉专业创意方法，思维敏捷，洞察力强，文字功底扎实，语言表达能力强；福利待遇：1.公司为员工提供以市场标杆，以能力、绩效为标准，具有市场竞争力的薪资待遇；2.为员工缴纳社会保险和办理住房公积金、带薪年假、法定节假日、小暑假；3.员工享有专业持续的提升培训机制、不定期的拓展福利、稳健的晋升机制；4.生日福利、传统节日福利、年终奖、年终分红等多种特色福利；试用期工资3500职能类别：网站&lt;/p&gt;');

-- -----------------------------
-- Table structure for `ey_region`
-- -----------------------------
DROP TABLE IF EXISTS `ey_region`;
CREATE TABLE `ey_region` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '表id',
  `name` varchar(32) DEFAULT '' COMMENT '地区名称',
  `level` tinyint(4) DEFAULT '0' COMMENT '地区等级 分省市县区',
  `parent_id` int(10) DEFAULT '0' COMMENT '父id',
  `initial` varchar(5) DEFAULT '' COMMENT '首字母',
  PRIMARY KEY (`id`),
  KEY `parent_id` (`parent_id`) USING BTREE,
  KEY `level` (`level`) USING BTREE,
  KEY `initial` (`initial`)
) ENGINE=MyISAM AUTO_INCREMENT=47990 DEFAULT CHARSET=utf8 COMMENT='区域表';

-- -----------------------------
-- Records of `ey_region`
-- -----------------------------
INSERT INTO `ey_region` VALUES ('1', '北京市', '1', '0', 'B');
INSERT INTO `ey_region` VALUES ('2', '北京市', '2', '1', 'B');
INSERT INTO `ey_region` VALUES ('3', '东城区', '3', '2', 'D');
INSERT INTO `ey_region` VALUES ('14', '西城区', '3', '2', 'X');
INSERT INTO `ey_region` VALUES ('22', '崇文区', '3', '2', 'C');
INSERT INTO `ey_region` VALUES ('30', '宣武区', '3', '2', 'X');
INSERT INTO `ey_region` VALUES ('39', '朝阳区', '3', '2', 'C');
INSERT INTO `ey_region` VALUES ('83', '丰台区', '3', '2', 'F');
INSERT INTO `ey_region` VALUES ('105', '石景山区', '3', '2', 'S');
INSERT INTO `ey_region` VALUES ('115', '海淀区', '3', '2', 'H');
INSERT INTO `ey_region` VALUES ('145', '门头沟区', '3', '2', 'M');
INSERT INTO `ey_region` VALUES ('159', '房山区', '3', '2', 'F');
INSERT INTO `ey_region` VALUES ('188', '通州区', '3', '2', 'T');
INSERT INTO `ey_region` VALUES ('204', '顺义区', '3', '2', 'S');
INSERT INTO `ey_region` VALUES ('227', '昌平区', '3', '2', 'C');
INSERT INTO `ey_region` VALUES ('245', '大兴区', '3', '2', 'D');
INSERT INTO `ey_region` VALUES ('264', '怀柔区', '3', '2', 'H');
INSERT INTO `ey_region` VALUES ('281', '平谷区', '3', '2', 'P');
INSERT INTO `ey_region` VALUES ('301', '密云区', '3', '2', 'M');
INSERT INTO `ey_region` VALUES ('322', '延庆区', '3', '2', 'Y');
INSERT INTO `ey_region` VALUES ('338', '天津市', '1', '0', 'T');
INSERT INTO `ey_region` VALUES ('339', '天津市', '2', '338', 'T');
INSERT INTO `ey_region` VALUES ('340', '和平区', '3', '339', 'H');
INSERT INTO `ey_region` VALUES ('347', '河东区', '3', '339', 'H');
INSERT INTO `ey_region` VALUES ('361', '河西区', '3', '339', 'H');
INSERT INTO `ey_region` VALUES ('375', '南开区', '3', '339', 'N');
INSERT INTO `ey_region` VALUES ('388', '河北区', '3', '339', 'H');
INSERT INTO `ey_region` VALUES ('399', '红桥区', '3', '339', 'H');
INSERT INTO `ey_region` VALUES ('410', '塘沽区', '3', '339', 'T');
INSERT INTO `ey_region` VALUES ('425', '汉沽区', '3', '339', 'H');
INSERT INTO `ey_region` VALUES ('435', '大港区', '3', '339', 'D');
INSERT INTO `ey_region` VALUES ('445', '东丽区', '3', '339', 'D');
INSERT INTO `ey_region` VALUES ('460', '西青区', '3', '339', 'X');
INSERT INTO `ey_region` VALUES ('473', '津南区', '3', '339', 'J');
INSERT INTO `ey_region` VALUES ('488', '北辰区', '3', '339', 'B');
INSERT INTO `ey_region` VALUES ('504', '武清区', '3', '339', 'W');
INSERT INTO `ey_region` VALUES ('538', '宝坻区', '3', '339', 'B');
INSERT INTO `ey_region` VALUES ('570', '宁河区', '3', '339', 'N');
INSERT INTO `ey_region` VALUES ('586', '静海区', '3', '339', 'J');
INSERT INTO `ey_region` VALUES ('608', '蓟州区', '3', '339', 'J');
INSERT INTO `ey_region` VALUES ('636', '河北省', '1', '0', 'H');
INSERT INTO `ey_region` VALUES ('637', '石家庄市', '2', '636', 'S');
INSERT INTO `ey_region` VALUES ('638', '市辖区', '3', '637', 'S');
INSERT INTO `ey_region` VALUES ('639', '长安区', '3', '637', 'C');
INSERT INTO `ey_region` VALUES ('651', '桥东区', '3', '637', 'Q');
INSERT INTO `ey_region` VALUES ('662', '桥西区', '3', '637', 'Q');
INSERT INTO `ey_region` VALUES ('675', '新华区', '3', '637', 'X');
INSERT INTO `ey_region` VALUES ('691', '井陉矿区', '3', '637', 'J');
INSERT INTO `ey_region` VALUES ('697', '裕华区', '3', '637', 'Y');
INSERT INTO `ey_region` VALUES ('708', '井陉县', '3', '637', 'J');
INSERT INTO `ey_region` VALUES ('726', '正定县', '3', '637', 'Z');
INSERT INTO `ey_region` VALUES ('736', '栾城县', '3', '637', 'L');
INSERT INTO `ey_region` VALUES ('745', '行唐县', '3', '637', 'X');
INSERT INTO `ey_region` VALUES ('761', '灵寿县', '3', '637', 'L');
INSERT INTO `ey_region` VALUES ('777', '高邑县', '3', '637', 'G');
INSERT INTO `ey_region` VALUES ('783', '深泽县', '3', '637', 'S');
INSERT INTO `ey_region` VALUES ('790', '赞皇县', '3', '637', 'Z');
INSERT INTO `ey_region` VALUES ('802', '无极县', '3', '637', 'W');
INSERT INTO `ey_region` VALUES ('814', '平山县', '3', '637', 'P');
INSERT INTO `ey_region` VALUES ('838', '元氏县', '3', '637', 'Y');
INSERT INTO `ey_region` VALUES ('854', '赵县', '3', '637', 'Z');
INSERT INTO `ey_region` VALUES ('866', '辛集市', '3', '637', 'X');
INSERT INTO `ey_region` VALUES ('882', '藁城市', '3', '637', 'G');
INSERT INTO `ey_region` VALUES ('898', '晋州市', '3', '637', 'J');
INSERT INTO `ey_region` VALUES ('909', '新乐市', '3', '637', 'X');
INSERT INTO `ey_region` VALUES ('922', '鹿泉市', '3', '637', 'L');
INSERT INTO `ey_region` VALUES ('936', '唐山市', '2', '636', 'T');
INSERT INTO `ey_region` VALUES ('937', '市辖区', '3', '936', 'S');
INSERT INTO `ey_region` VALUES ('938', '路南区', '3', '936', 'L');
INSERT INTO `ey_region` VALUES ('952', '路北区', '3', '936', 'L');
INSERT INTO `ey_region` VALUES ('965', '古冶区', '3', '936', 'G');
INSERT INTO `ey_region` VALUES ('977', '开平区', '3', '936', 'K');
INSERT INTO `ey_region` VALUES ('989', '丰南区', '3', '936', 'F');
INSERT INTO `ey_region` VALUES ('1007', '丰润区', '3', '936', 'F');
INSERT INTO `ey_region` VALUES ('1034', '滦县', '3', '936', 'L');
INSERT INTO `ey_region` VALUES ('1048', '滦南县', '3', '936', 'L');
INSERT INTO `ey_region` VALUES ('1067', '乐亭县', '3', '936', 'L');
INSERT INTO `ey_region` VALUES ('1085', '迁西县', '3', '936', 'Q');
INSERT INTO `ey_region` VALUES ('1104', '玉田县', '3', '936', 'Y');
INSERT INTO `ey_region` VALUES ('1125', '唐海县', '3', '936', 'T');
INSERT INTO `ey_region` VALUES ('1140', '遵化市', '3', '936', 'Z');
INSERT INTO `ey_region` VALUES ('1168', '迁安市', '3', '936', 'Q');
INSERT INTO `ey_region` VALUES ('1188', '秦皇岛市', '2', '636', 'Q');
INSERT INTO `ey_region` VALUES ('1189', '市辖区', '3', '1188', 'S');
INSERT INTO `ey_region` VALUES ('1190', '海港区', '3', '1188', 'H');
INSERT INTO `ey_region` VALUES ('1208', '山海关区', '3', '1188', 'S');
INSERT INTO `ey_region` VALUES ('1218', '北戴河区', '3', '1188', 'B');
INSERT INTO `ey_region` VALUES ('1223', '青龙县', '3', '1188', 'Q');
INSERT INTO `ey_region` VALUES ('1249', '昌黎县', '3', '1188', 'C');
INSERT INTO `ey_region` VALUES ('1266', '抚宁县', '3', '1188', 'F');
INSERT INTO `ey_region` VALUES ('1278', '卢龙县', '3', '1188', 'L');
INSERT INTO `ey_region` VALUES ('1291', '邯郸市', '2', '636', 'H');
INSERT INTO `ey_region` VALUES ('1292', '市辖区', '3', '1291', 'S');
INSERT INTO `ey_region` VALUES ('1293', '邯山区', '3', '1291', 'H');
INSERT INTO `ey_region` VALUES ('1307', '丛台区', '3', '1291', 'C');
INSERT INTO `ey_region` VALUES ('1319', '复兴区', '3', '1291', 'F');
INSERT INTO `ey_region` VALUES ('1329', '峰峰矿区', '3', '1291', 'F');
INSERT INTO `ey_region` VALUES ('1339', '邯郸县', '3', '1291', 'H');
INSERT INTO `ey_region` VALUES ('1350', '临漳县', '3', '1291', 'L');
INSERT INTO `ey_region` VALUES ('1365', '成安县', '3', '1291', 'C');
INSERT INTO `ey_region` VALUES ('1375', '大名县', '3', '1291', 'D');
INSERT INTO `ey_region` VALUES ('1396', '涉县', '3', '1291', 'S');
INSERT INTO `ey_region` VALUES ('1414', '磁县', '3', '1291', 'C');
INSERT INTO `ey_region` VALUES ('1434', '肥乡县', '3', '1291', 'F');
INSERT INTO `ey_region` VALUES ('1444', '永年县', '3', '1291', 'Y');
INSERT INTO `ey_region` VALUES ('1465', '邱县', '3', '1291', 'Q');
INSERT INTO `ey_region` VALUES ('1473', '鸡泽县', '3', '1291', 'J');
INSERT INTO `ey_region` VALUES ('1481', '广平县', '3', '1291', 'G');
INSERT INTO `ey_region` VALUES ('1489', '馆陶县', '3', '1291', 'G');
INSERT INTO `ey_region` VALUES ('1498', '魏县', '3', '1291', 'W');
INSERT INTO `ey_region` VALUES ('1520', '曲周县', '3', '1291', 'Q');
INSERT INTO `ey_region` VALUES ('1531', '武安市', '3', '1291', 'W');
INSERT INTO `ey_region` VALUES ('1554', '邢台市', '2', '636', 'X');
INSERT INTO `ey_region` VALUES ('1555', '市辖区', '3', '1554', 'S');
INSERT INTO `ey_region` VALUES ('1556', '桥东区', '3', '1554', 'Q');
INSERT INTO `ey_region` VALUES ('1564', '桥西区', '3', '1554', 'Q');
INSERT INTO `ey_region` VALUES ('1572', '邢台县', '3', '1554', 'X');
INSERT INTO `ey_region` VALUES ('1593', '临城县', '3', '1554', 'L');
INSERT INTO `ey_region` VALUES ('1602', '内邱县', '3', '1554', 'N');
INSERT INTO `ey_region` VALUES ('1612', '柏乡县', '3', '1554', 'B');
INSERT INTO `ey_region` VALUES ('1619', '隆尧县', '3', '1554', 'L');
INSERT INTO `ey_region` VALUES ('1633', '任县', '3', '1554', 'R');
INSERT INTO `ey_region` VALUES ('1642', '南和县', '3', '1554', 'N');
INSERT INTO `ey_region` VALUES ('1651', '宁晋县', '3', '1554', 'N');
INSERT INTO `ey_region` VALUES ('1669', '巨鹿县', '3', '1554', 'J');
INSERT INTO `ey_region` VALUES ('1680', '新河县', '3', '1554', 'X');
INSERT INTO `ey_region` VALUES ('1687', '广宗县', '3', '1554', 'G');
INSERT INTO `ey_region` VALUES ('1696', '平乡县', '3', '1554', 'P');
INSERT INTO `ey_region` VALUES ('1704', '威县', '3', '1554', 'W');
INSERT INTO `ey_region` VALUES ('1721', '清河县', '3', '1554', 'Q');
INSERT INTO `ey_region` VALUES ('1728', '临西县', '3', '1554', 'L');
INSERT INTO `ey_region` VALUES ('1738', '南宫市', '3', '1554', 'N');
INSERT INTO `ey_region` VALUES ('1754', '沙河市', '3', '1554', 'S');
INSERT INTO `ey_region` VALUES ('1772', '保定市', '2', '636', 'B');
INSERT INTO `ey_region` VALUES ('1773', '市辖区', '3', '1772', 'S');
INSERT INTO `ey_region` VALUES ('1774', '新市区', '3', '1772', 'X');
INSERT INTO `ey_region` VALUES ('1787', '北市区', '3', '1772', 'B');
INSERT INTO `ey_region` VALUES ('1796', '南市区', '3', '1772', 'N');
INSERT INTO `ey_region` VALUES ('1806', '满城区', '3', '1772', 'M');
INSERT INTO `ey_region` VALUES ('1820', '清苑区', '3', '1772', 'Q');
INSERT INTO `ey_region` VALUES ('1839', '涞水县', '3', '1772', 'L');
INSERT INTO `ey_region` VALUES ('1856', '阜平县', '3', '1772', 'F');
INSERT INTO `ey_region` VALUES ('1870', '徐水区', '3', '1772', 'X');
INSERT INTO `ey_region` VALUES ('1885', '定兴县', '3', '1772', 'D');
INSERT INTO `ey_region` VALUES ('1902', '唐县', '3', '1772', 'T');
INSERT INTO `ey_region` VALUES ('1923', '高阳县', '3', '1772', 'G');
INSERT INTO `ey_region` VALUES ('1933', '容城县', '3', '1772', 'R');
INSERT INTO `ey_region` VALUES ('1942', '涞源县', '3', '1772', 'L');
INSERT INTO `ey_region` VALUES ('1960', '望都县', '3', '1772', 'W');
INSERT INTO `ey_region` VALUES ('1969', '安新县', '3', '1772', 'A');
INSERT INTO `ey_region` VALUES ('1982', '易县', '3', '1772', 'Y');
INSERT INTO `ey_region` VALUES ('2010', '曲阳县', '3', '1772', 'Q');
INSERT INTO `ey_region` VALUES ('2029', '蠡县', '3', '1772', 'L');
INSERT INTO `ey_region` VALUES ('2043', '顺平县', '3', '1772', 'S');
INSERT INTO `ey_region` VALUES ('2054', '博野县', '3', '1772', 'B');
INSERT INTO `ey_region` VALUES ('2062', '雄县', '3', '1772', 'X');
INSERT INTO `ey_region` VALUES ('2072', '涿州市', '3', '1772', 'Z');
INSERT INTO `ey_region` VALUES ('2088', '定州市', '3', '1772', 'D');
INSERT INTO `ey_region` VALUES ('2114', '安国市', '3', '1772', 'A');
INSERT INTO `ey_region` VALUES ('2126', '高碑店市', '3', '1772', 'G');
INSERT INTO `ey_region` VALUES ('2142', '张家口市', '2', '636', 'Z');
INSERT INTO `ey_region` VALUES ('2143', '市辖区', '3', '2142', 'S');
INSERT INTO `ey_region` VALUES ('2144', '桥东区', '3', '2142', 'Q');
INSERT INTO `ey_region` VALUES ('2154', '桥西区', '3', '2142', 'Q');
INSERT INTO `ey_region` VALUES ('2164', '宣化区', '3', '2142', 'X');
INSERT INTO `ey_region` VALUES ('2176', '下花园区', '3', '2142', 'X');
INSERT INTO `ey_region` VALUES ('2183', '宣化县', '3', '2142', 'X');
INSERT INTO `ey_region` VALUES ('2198', '张北县', '3', '2142', 'Z');
INSERT INTO `ey_region` VALUES ('2220', '康保县', '3', '2142', 'K');
INSERT INTO `ey_region` VALUES ('2237', '沽源县', '3', '2142', 'G');
INSERT INTO `ey_region` VALUES ('2256', '尚义县', '3', '2142', 'S');
INSERT INTO `ey_region` VALUES ('2271', '蔚县', '3', '2142', 'W');
INSERT INTO `ey_region` VALUES ('2294', '阳原县', '3', '2142', 'Y');
INSERT INTO `ey_region` VALUES ('2309', '怀安县', '3', '2142', 'H');
INSERT INTO `ey_region` VALUES ('2321', '万全县', '3', '2142', 'W');
INSERT INTO `ey_region` VALUES ('2333', '怀来县', '3', '2142', 'H');
INSERT INTO `ey_region` VALUES ('2351', '涿鹿县', '3', '2142', 'Z');
INSERT INTO `ey_region` VALUES ('2369', '赤城县', '3', '2142', 'C');
INSERT INTO `ey_region` VALUES ('2388', '崇礼县', '3', '2142', 'C');
INSERT INTO `ey_region` VALUES ('2400', '承德市', '2', '636', 'C');
INSERT INTO `ey_region` VALUES ('2401', '市辖区', '3', '2400', 'S');
INSERT INTO `ey_region` VALUES ('2402', '双桥区', '3', '2400', 'S');
INSERT INTO `ey_region` VALUES ('2415', '双滦区', '3', '2400', 'S');
INSERT INTO `ey_region` VALUES ('2422', '鹰手营子矿区', '3', '2400', 'Y');
INSERT INTO `ey_region` VALUES ('2427', '承德县', '3', '2400', 'C');
INSERT INTO `ey_region` VALUES ('2453', '兴隆县', '3', '2400', 'X');
INSERT INTO `ey_region` VALUES ('2474', '平泉县', '3', '2400', 'P');
INSERT INTO `ey_region` VALUES ('2494', '滦平县', '3', '2400', 'L');
INSERT INTO `ey_region` VALUES ('2517', '隆化县', '3', '2400', 'L');
INSERT INTO `ey_region` VALUES ('2543', '丰宁县', '3', '2400', 'F');
INSERT INTO `ey_region` VALUES ('2570', '宽城县', '3', '2400', 'K');
INSERT INTO `ey_region` VALUES ('2589', '围场县', '3', '2400', 'W');
INSERT INTO `ey_region` VALUES ('2629', '沧州市', '2', '636', 'C');
INSERT INTO `ey_region` VALUES ('2630', '市辖区', '3', '2629', 'S');
INSERT INTO `ey_region` VALUES ('2631', '新华区', '3', '2629', 'X');
INSERT INTO `ey_region` VALUES ('2639', '运河区', '3', '2629', 'Y');
INSERT INTO `ey_region` VALUES ('2648', '沧县', '3', '2629', 'C');
INSERT INTO `ey_region` VALUES ('2668', '青县', '3', '2629', 'Q');
INSERT INTO `ey_region` VALUES ('2680', '东光县', '3', '2629', 'D');
INSERT INTO `ey_region` VALUES ('2690', '海兴县', '3', '2629', 'H');
INSERT INTO `ey_region` VALUES ('2701', '盐山县', '3', '2629', 'Y');
INSERT INTO `ey_region` VALUES ('2714', '肃宁县', '3', '2629', 'S');
INSERT INTO `ey_region` VALUES ('2724', '南皮县', '3', '2629', 'N');
INSERT INTO `ey_region` VALUES ('2734', '吴桥县', '3', '2629', 'W');
INSERT INTO `ey_region` VALUES ('2745', '献县', '3', '2629', 'X');
INSERT INTO `ey_region` VALUES ('2765', '孟村县', '3', '2629', 'M');
INSERT INTO `ey_region` VALUES ('2772', '泊头市', '3', '2629', 'B');
INSERT INTO `ey_region` VALUES ('2788', '任邱市', '3', '2629', 'R');
INSERT INTO `ey_region` VALUES ('2809', '黄骅市', '3', '2629', 'H');
INSERT INTO `ey_region` VALUES ('2828', '河间市', '3', '2629', 'H');
INSERT INTO `ey_region` VALUES ('2849', '廊坊市', '2', '636', 'L');
INSERT INTO `ey_region` VALUES ('2850', '市辖区', '3', '2849', 'S');
INSERT INTO `ey_region` VALUES ('2851', '安次区', '3', '2849', 'A');
INSERT INTO `ey_region` VALUES ('2862', '广阳区', '3', '2849', 'G');
INSERT INTO `ey_region` VALUES ('2873', '固安县', '3', '2849', 'G');
INSERT INTO `ey_region` VALUES ('2883', '永清县', '3', '2849', 'Y');
INSERT INTO `ey_region` VALUES ('2895', '香河县', '3', '2849', 'X');
INSERT INTO `ey_region` VALUES ('2906', '大城县', '3', '2849', 'D');
INSERT INTO `ey_region` VALUES ('2918', '文安县', '3', '2849', 'W');
INSERT INTO `ey_region` VALUES ('2932', '大厂县', '3', '2849', 'D');
INSERT INTO `ey_region` VALUES ('2939', '霸州市', '3', '2849', 'B');
INSERT INTO `ey_region` VALUES ('2953', '三河市', '3', '2849', 'S');
INSERT INTO `ey_region` VALUES ('2968', '衡水市', '2', '636', 'H');
INSERT INTO `ey_region` VALUES ('2969', '市辖区', '3', '2968', 'S');
INSERT INTO `ey_region` VALUES ('2970', '桃城区', '3', '2968', 'T');
INSERT INTO `ey_region` VALUES ('2983', '枣强县', '3', '2968', 'Z');
INSERT INTO `ey_region` VALUES ('2995', '武邑县', '3', '2968', 'W');
INSERT INTO `ey_region` VALUES ('3005', '武强县', '3', '2968', 'W');
INSERT INTO `ey_region` VALUES ('3012', '饶阳县', '3', '2968', 'R');
INSERT INTO `ey_region` VALUES ('3020', '安平县', '3', '2968', 'A');
INSERT INTO `ey_region` VALUES ('3029', '故城县', '3', '2968', 'G');
INSERT INTO `ey_region` VALUES ('3043', '景县', '3', '2968', 'J');
INSERT INTO `ey_region` VALUES ('3060', '阜城县', '3', '2968', 'F');
INSERT INTO `ey_region` VALUES ('3071', '冀州市', '3', '2968', 'J');
INSERT INTO `ey_region` VALUES ('3083', '深州市', '3', '2968', 'S');
INSERT INTO `ey_region` VALUES ('3102', '山西省', '1', '0', 'S');
INSERT INTO `ey_region` VALUES ('3103', '太原市', '2', '3102', 'T');
INSERT INTO `ey_region` VALUES ('3104', '市辖区', '3', '3103', 'S');
INSERT INTO `ey_region` VALUES ('3105', '小店区(人口含高新经济区)', '3', '3103', 'X');
INSERT INTO `ey_region` VALUES ('3117', '迎泽区', '3', '3103', 'Y');
INSERT INTO `ey_region` VALUES ('3126', '杏花岭区', '3', '3103', 'X');
INSERT INTO `ey_region` VALUES ('3140', '尖草坪区', '3', '3103', 'J');
INSERT INTO `ey_region` VALUES ('3155', '万柏林区', '3', '3103', 'W');
INSERT INTO `ey_region` VALUES ('3171', '晋源区', '3', '3103', 'J');
INSERT INTO `ey_region` VALUES ('3178', '清徐县', '3', '3103', 'Q');
INSERT INTO `ey_region` VALUES ('3188', '阳曲县', '3', '3103', 'Y');
INSERT INTO `ey_region` VALUES ('3200', '娄烦县', '3', '3103', 'L');
INSERT INTO `ey_region` VALUES ('3209', '古交市', '3', '3103', 'G');
INSERT INTO `ey_region` VALUES ('3224', '大同市', '2', '3102', 'D');
INSERT INTO `ey_region` VALUES ('3225', '市辖区', '3', '3224', 'S');
INSERT INTO `ey_region` VALUES ('3226', '大同市城区', '3', '3224', 'D');
INSERT INTO `ey_region` VALUES ('3241', '矿区', '3', '3224', 'K');
INSERT INTO `ey_region` VALUES ('3266', '南郊区', '3', '3224', 'N');
INSERT INTO `ey_region` VALUES ('3277', '新荣区', '3', '3224', 'X');
INSERT INTO `ey_region` VALUES ('3286', '阳高县', '3', '3224', 'Y');
INSERT INTO `ey_region` VALUES ('3300', '天镇县', '3', '3224', 'T');
INSERT INTO `ey_region` VALUES ('3312', '广灵县', '3', '3224', 'G');
INSERT INTO `ey_region` VALUES ('3322', '灵丘县', '3', '3224', 'L');
INSERT INTO `ey_region` VALUES ('3335', '浑源县', '3', '3224', 'H');
INSERT INTO `ey_region` VALUES ('3354', '左云县', '3', '3224', 'Z');
INSERT INTO `ey_region` VALUES ('3364', '大同县', '3', '3224', 'D');
INSERT INTO `ey_region` VALUES ('3379', '阳泉市', '2', '3102', 'Y');
INSERT INTO `ey_region` VALUES ('3380', '市辖区', '3', '3379', 'S');
INSERT INTO `ey_region` VALUES ('3381', '城区', '3', '3379', 'C');
INSERT INTO `ey_region` VALUES ('3388', '矿区', '3', '3379', 'K');
INSERT INTO `ey_region` VALUES ('3395', '郊区', '3', '3379', 'J');
INSERT INTO `ey_region` VALUES ('3405', '平定县', '3', '3379', 'P');
INSERT INTO `ey_region` VALUES ('3416', '盂县', '3', '3379', 'Y');
INSERT INTO `ey_region` VALUES ('3431', '长治市', '2', '3102', 'C');
INSERT INTO `ey_region` VALUES ('3432', '市辖区', '3', '3431', 'S');
INSERT INTO `ey_region` VALUES ('3433', '长治市城区', '3', '3431', 'C');
INSERT INTO `ey_region` VALUES ('3445', '长治市郊区', '3', '3431', 'C');
INSERT INTO `ey_region` VALUES ('3454', '长治县', '3', '3431', 'C');
INSERT INTO `ey_region` VALUES ('3466', '襄垣县', '3', '3431', 'X');
INSERT INTO `ey_region` VALUES ('3478', '屯留县', '3', '3431', 'T');
INSERT INTO `ey_region` VALUES ('3493', '平顺县', '3', '3431', 'P');
INSERT INTO `ey_region` VALUES ('3506', '黎城县', '3', '3431', 'L');
INSERT INTO `ey_region` VALUES ('3516', '壶关县', '3', '3431', 'H');
INSERT INTO `ey_region` VALUES ('3530', '长子县', '3', '3431', 'C');
INSERT INTO `ey_region` VALUES ('3543', '武乡县', '3', '3431', 'W');
INSERT INTO `ey_region` VALUES ('3558', '沁县', '3', '3431', 'Q');
INSERT INTO `ey_region` VALUES ('3572', '沁源县', '3', '3431', 'Q');
INSERT INTO `ey_region` VALUES ('3587', '潞城市', '3', '3431', 'L');
INSERT INTO `ey_region` VALUES ('3597', '晋城市', '2', '3102', 'J');
INSERT INTO `ey_region` VALUES ('3598', '市辖区', '3', '3597', 'S');
INSERT INTO `ey_region` VALUES ('3599', '晋城市城区', '3', '3597', 'J');
INSERT INTO `ey_region` VALUES ('3608', '沁水县', '3', '3597', 'Q');
INSERT INTO `ey_region` VALUES ('3623', '阳城县', '3', '3597', 'Y');
INSERT INTO `ey_region` VALUES ('3642', '陵川县', '3', '3597', 'L');
INSERT INTO `ey_region` VALUES ('3655', '泽州县', '3', '3597', 'Z');
INSERT INTO `ey_region` VALUES ('3673', '高平市', '3', '3597', 'G');
INSERT INTO `ey_region` VALUES ('3690', '朔州市', '2', '3102', 'S');
INSERT INTO `ey_region` VALUES ('3691', '市辖区', '3', '3690', 'S');
INSERT INTO `ey_region` VALUES ('3692', '朔城区', '3', '3690', 'S');
INSERT INTO `ey_region` VALUES ('3709', '平鲁区', '3', '3690', 'P');
INSERT INTO `ey_region` VALUES ('3723', '山阴县', '3', '3690', 'S');
INSERT INTO `ey_region` VALUES ('3739', '应县', '3', '3690', 'Y');
INSERT INTO `ey_region` VALUES ('3752', '右玉县', '3', '3690', 'Y');
INSERT INTO `ey_region` VALUES ('3763', '怀仁县', '3', '3690', 'H');
INSERT INTO `ey_region` VALUES ('3776', '晋中市', '2', '3102', 'J');
INSERT INTO `ey_region` VALUES ('3777', '市辖区', '3', '3776', 'S');
INSERT INTO `ey_region` VALUES ('3778', '榆次区', '3', '3776', 'Y');
INSERT INTO `ey_region` VALUES ('3799', '榆社县', '3', '3776', 'Y');
INSERT INTO `ey_region` VALUES ('3810', '左权县', '3', '3776', 'Z');
INSERT INTO `ey_region` VALUES ('3822', '和顺县', '3', '3776', 'H');
INSERT INTO `ey_region` VALUES ('3833', '昔阳县', '3', '3776', 'X');
INSERT INTO `ey_region` VALUES ('3846', '寿阳县', '3', '3776', 'S');
INSERT INTO `ey_region` VALUES ('3861', '太谷县', '3', '3776', 'T');
INSERT INTO `ey_region` VALUES ('3871', '祁县', '3', '3776', 'Q');
INSERT INTO `ey_region` VALUES ('3880', '平遥县', '3', '3776', 'P');
INSERT INTO `ey_region` VALUES ('3895', '灵石县', '3', '3776', 'L');
INSERT INTO `ey_region` VALUES ('3908', '介休市', '3', '3776', 'J');
INSERT INTO `ey_region` VALUES ('3925', '运城市', '2', '3102', 'Y');
INSERT INTO `ey_region` VALUES ('3926', '市辖区', '3', '3925', 'S');
INSERT INTO `ey_region` VALUES ('3927', '盐湖区', '3', '3925', 'Y');
INSERT INTO `ey_region` VALUES ('3950', '临猗县', '3', '3925', 'L');
INSERT INTO `ey_region` VALUES ('3967', '万荣县', '3', '3925', 'W');
INSERT INTO `ey_region` VALUES ('3982', '闻喜县', '3', '3925', 'W');
INSERT INTO `ey_region` VALUES ('3996', '稷山县', '3', '3925', 'J');
INSERT INTO `ey_region` VALUES ('4004', '新绛县', '3', '3925', 'X');
INSERT INTO `ey_region` VALUES ('4013', '绛县', '3', '3925', 'J');
INSERT INTO `ey_region` VALUES ('4024', '垣曲县', '3', '3925', 'Y');
INSERT INTO `ey_region` VALUES ('4036', '夏县', '3', '3925', 'X');
INSERT INTO `ey_region` VALUES ('4048', '平陆县', '3', '3925', 'P');
INSERT INTO `ey_region` VALUES ('4059', '芮城县', '3', '3925', 'R');
INSERT INTO `ey_region` VALUES ('4070', '永济市', '3', '3925', 'Y');
INSERT INTO `ey_region` VALUES ('4082', '河津市', '3', '3925', 'H');
INSERT INTO `ey_region` VALUES ('4093', '忻州市', '2', '3102', 'X');
INSERT INTO `ey_region` VALUES ('4094', '市辖区', '3', '4093', 'S');
INSERT INTO `ey_region` VALUES ('4095', '忻府区', '3', '4093', 'X');
INSERT INTO `ey_region` VALUES ('4116', '定襄县', '3', '4093', 'D');
INSERT INTO `ey_region` VALUES ('4126', '五台县', '3', '4093', 'W');
INSERT INTO `ey_region` VALUES ('4146', '代县', '3', '4093', 'D');
INSERT INTO `ey_region` VALUES ('4158', '繁峙县', '3', '4093', 'F');
INSERT INTO `ey_region` VALUES ('4172', '宁武县', '3', '4093', 'N');
INSERT INTO `ey_region` VALUES ('4189', '静乐县', '3', '4093', 'J');
INSERT INTO `ey_region` VALUES ('4204', '神池县', '3', '4093', 'S');
INSERT INTO `ey_region` VALUES ('4215', '五寨县', '3', '4093', 'W');
INSERT INTO `ey_region` VALUES ('4228', '岢岚县', '3', '4093', 'K');
INSERT INTO `ey_region` VALUES ('4241', '河曲县', '3', '4093', 'H');
INSERT INTO `ey_region` VALUES ('4255', '保德县', '3', '4093', 'B');
INSERT INTO `ey_region` VALUES ('4269', '偏关县', '3', '4093', 'P');
INSERT INTO `ey_region` VALUES ('4280', '原平市', '3', '4093', 'Y');
INSERT INTO `ey_region` VALUES ('4304', '临汾市', '2', '3102', 'L');
INSERT INTO `ey_region` VALUES ('4305', '市辖区', '3', '4304', 'S');
INSERT INTO `ey_region` VALUES ('4306', '尧都区', '3', '4304', 'Y');
INSERT INTO `ey_region` VALUES ('4333', '曲沃县', '3', '4304', 'Q');
INSERT INTO `ey_region` VALUES ('4341', '翼城县', '3', '4304', 'Y');
INSERT INTO `ey_region` VALUES ('4352', '襄汾县', '3', '4304', 'X');
INSERT INTO `ey_region` VALUES ('4366', '洪洞县', '3', '4304', 'H');
INSERT INTO `ey_region` VALUES ('4383', '古县', '3', '4304', 'G');
INSERT INTO `ey_region` VALUES ('4391', '安泽县', '3', '4304', 'A');
INSERT INTO `ey_region` VALUES ('4399', '浮山县', '3', '4304', 'F');
INSERT INTO `ey_region` VALUES ('4409', '吉县', '3', '4304', 'J');
INSERT INTO `ey_region` VALUES ('4418', '乡宁县', '3', '4304', 'X');
INSERT INTO `ey_region` VALUES ('4429', '大宁县', '3', '4304', 'D');
INSERT INTO `ey_region` VALUES ('4436', '隰县', '3', '4304', 'X');
INSERT INTO `ey_region` VALUES ('4445', '永和县', '3', '4304', 'Y');
INSERT INTO `ey_region` VALUES ('4453', '蒲县', '3', '4304', 'P');
INSERT INTO `ey_region` VALUES ('4463', '汾西县', '3', '4304', 'F');
INSERT INTO `ey_region` VALUES ('4472', '侯马市', '3', '4304', 'H');
INSERT INTO `ey_region` VALUES ('4481', '霍州市', '3', '4304', 'H');
INSERT INTO `ey_region` VALUES ('4494', '吕梁市', '2', '3102', 'L');
INSERT INTO `ey_region` VALUES ('4495', '市辖区', '3', '4494', 'S');
INSERT INTO `ey_region` VALUES ('4496', '离石区', '3', '4494', 'L');
INSERT INTO `ey_region` VALUES ('4509', '文水县', '3', '4494', 'W');
INSERT INTO `ey_region` VALUES ('4522', '交城县', '3', '4494', 'J');
INSERT INTO `ey_region` VALUES ('4533', '兴县', '3', '4494', 'X');
INSERT INTO `ey_region` VALUES ('4551', '临县', '3', '4494', 'L');
INSERT INTO `ey_region` VALUES ('4575', '柳林县', '3', '4494', 'L');
INSERT INTO `ey_region` VALUES ('4591', '石楼县', '3', '4494', 'S');
INSERT INTO `ey_region` VALUES ('4601', '岚县', '3', '4494', 'L');
INSERT INTO `ey_region` VALUES ('4614', '方山县', '3', '4494', 'F');
INSERT INTO `ey_region` VALUES ('4622', '中阳县', '3', '4494', 'Z');
INSERT INTO `ey_region` VALUES ('4630', '交口县', '3', '4494', 'J');
INSERT INTO `ey_region` VALUES ('4638', '孝义市', '3', '4494', 'X');
INSERT INTO `ey_region` VALUES ('4655', '汾阳市', '3', '4494', 'F');
INSERT INTO `ey_region` VALUES ('4670', '内蒙古自治区', '1', '0', 'N');
INSERT INTO `ey_region` VALUES ('4671', '呼和浩特市', '2', '4670', 'H');
INSERT INTO `ey_region` VALUES ('4672', '市辖区', '3', '4671', 'S');
INSERT INTO `ey_region` VALUES ('4673', '新城区', '3', '4671', 'X');
INSERT INTO `ey_region` VALUES ('4684', '回民区', '3', '4671', 'H');
INSERT INTO `ey_region` VALUES ('4693', '玉泉区', '3', '4671', 'Y');
INSERT INTO `ey_region` VALUES ('4702', '赛罕区', '3', '4671', 'S');
INSERT INTO `ey_region` VALUES ('4715', '土左旗', '3', '4671', 'T');
INSERT INTO `ey_region` VALUES ('4727', '托克托县', '3', '4671', 'T');
INSERT INTO `ey_region` VALUES ('4733', '和林格尔县', '3', '4671', 'H');
INSERT INTO `ey_region` VALUES ('4742', '清水河县', '3', '4671', 'Q');
INSERT INTO `ey_region` VALUES ('4749', '武川县', '3', '4671', 'W');
INSERT INTO `ey_region` VALUES ('4759', '包头市', '2', '4670', 'B');
INSERT INTO `ey_region` VALUES ('4760', '市辖区', '3', '4759', 'S');
INSERT INTO `ey_region` VALUES ('4761', '东河区', '3', '4759', 'D');
INSERT INTO `ey_region` VALUES ('4775', '昆都仑区', '3', '4759', 'K');
INSERT INTO `ey_region` VALUES ('4791', '青山区', '3', '4759', 'Q');
INSERT INTO `ey_region` VALUES ('4803', '石拐区', '3', '4759', 'S');
INSERT INTO `ey_region` VALUES ('4810', '白云鄂博矿区', '3', '4759', 'B');
INSERT INTO `ey_region` VALUES ('4813', '九原区', '3', '4759', 'J');
INSERT INTO `ey_region` VALUES ('4823', '土默特右旗', '3', '4759', 'T');
INSERT INTO `ey_region` VALUES ('4833', '固阳县', '3', '4759', 'G');
INSERT INTO `ey_region` VALUES ('4840', '达茂联合旗', '3', '4759', 'D');
INSERT INTO `ey_region` VALUES ('4849', '乌海市', '2', '4670', 'W');
INSERT INTO `ey_region` VALUES ('4850', '乌海市辖区', '3', '4849', 'W');
INSERT INTO `ey_region` VALUES ('4851', '海勃湾区', '3', '4849', 'H');
INSERT INTO `ey_region` VALUES ('4859', '海南区', '3', '4849', 'H');
INSERT INTO `ey_region` VALUES ('4865', '乌达区', '3', '4849', 'W');
INSERT INTO `ey_region` VALUES ('4874', '赤峰市', '2', '4670', 'C');
INSERT INTO `ey_region` VALUES ('4875', '市辖区', '3', '4874', 'S');
INSERT INTO `ey_region` VALUES ('4876', '红山区', '3', '4874', 'H');
INSERT INTO `ey_region` VALUES ('4888', '元宝山区', '3', '4874', 'Y');
INSERT INTO `ey_region` VALUES ('4896', '松山区', '3', '4874', 'S');
INSERT INTO `ey_region` VALUES ('4919', '阿鲁科尔沁旗', '3', '4874', 'A');
INSERT INTO `ey_region` VALUES ('4932', '巴林左旗', '3', '4874', 'B');
INSERT INTO `ey_region` VALUES ('4944', '巴林右旗', '3', '4874', 'B');
INSERT INTO `ey_region` VALUES ('4953', '林西县', '3', '4874', 'L');
INSERT INTO `ey_region` VALUES ('4963', '克什克腾旗', '3', '4874', 'K');
INSERT INTO `ey_region` VALUES ('4975', '翁牛特旗', '3', '4874', 'W');
INSERT INTO `ey_region` VALUES ('4988', '喀喇沁旗', '3', '4874', 'K');
INSERT INTO `ey_region` VALUES ('4999', '宁城县', '3', '4874', 'N');
INSERT INTO `ey_region` VALUES ('5013', '敖汉旗', '3', '4874', 'A');
INSERT INTO `ey_region` VALUES ('5029', '通辽市', '2', '4670', 'T');
INSERT INTO `ey_region` VALUES ('5030', '市辖区', '3', '5029', 'S');
INSERT INTO `ey_region` VALUES ('5031', '科尔沁区', '3', '5029', 'K');
INSERT INTO `ey_region` VALUES ('5062', '科尔沁左翼中旗', '3', '5029', 'K');
INSERT INTO `ey_region` VALUES ('5079', '科左后旗', '3', '5029', 'K');
INSERT INTO `ey_region` VALUES ('5104', '开鲁县', '3', '5029', 'K');
INSERT INTO `ey_region` VALUES ('5118', '库伦旗', '3', '5029', 'K');
INSERT INTO `ey_region` VALUES ('5125', '奈曼旗', '3', '5029', 'N');
INSERT INTO `ey_region` VALUES ('5139', '扎鲁特旗', '3', '5029', 'Z');
INSERT INTO `ey_region` VALUES ('5155', '霍林郭勒市', '3', '5029', 'H');
INSERT INTO `ey_region` VALUES ('5162', '鄂尔多斯市', '2', '4670', 'E');
INSERT INTO `ey_region` VALUES ('5163', '东胜区', '3', '5162', 'D');
INSERT INTO `ey_region` VALUES ('5176', '达拉特旗', '3', '5162', 'D');
INSERT INTO `ey_region` VALUES ('5185', '准格尔旗', '3', '5162', 'Z');
INSERT INTO `ey_region` VALUES ('5195', '鄂托克前旗', '3', '5162', 'E');
INSERT INTO `ey_region` VALUES ('5201', '鄂托克旗', '3', '5162', 'E');
INSERT INTO `ey_region` VALUES ('5210', '杭锦旗', '3', '5162', 'H');
INSERT INTO `ey_region` VALUES ('5219', '乌审旗', '3', '5162', 'W');
INSERT INTO `ey_region` VALUES ('5228', '伊金霍洛旗', '3', '5162', 'Y');
INSERT INTO `ey_region` VALUES ('5236', '呼伦贝尔市', '2', '4670', 'H');
INSERT INTO `ey_region` VALUES ('5237', '市辖区', '3', '5236', 'S');
INSERT INTO `ey_region` VALUES ('5238', '海拉尔区', '3', '5236', 'H');
INSERT INTO `ey_region` VALUES ('5249', '阿荣旗', '3', '5236', 'A');
INSERT INTO `ey_region` VALUES ('5262', '莫力达瓦旗', '3', '5236', 'M');
INSERT INTO `ey_region` VALUES ('5277', '鄂伦春旗', '3', '5236', 'E');
INSERT INTO `ey_region` VALUES ('5303', '鄂温旗', '3', '5236', 'E');
INSERT INTO `ey_region` VALUES ('5314', '陈巴尔虎旗镇', '3', '5236', 'C');
INSERT INTO `ey_region` VALUES ('5323', '新巴尔虎左旗', '3', '5236', 'X');
INSERT INTO `ey_region` VALUES ('5330', '新巴尔虎右旗', '3', '5236', 'X');
INSERT INTO `ey_region` VALUES ('5337', '满洲里市', '3', '5236', 'M');
INSERT INTO `ey_region` VALUES ('5354', '牙克石市', '3', '5236', 'Y');
INSERT INTO `ey_region` VALUES ('5371', '扎兰屯市', '3', '5236', 'Z');
INSERT INTO `ey_region` VALUES ('5397', '额尔古纳市', '3', '5236', 'E');
INSERT INTO `ey_region` VALUES ('5410', '根河市', '3', '5236', 'G');
INSERT INTO `ey_region` VALUES ('5418', '巴彦淖尔市', '2', '4670', 'B');
INSERT INTO `ey_region` VALUES ('5419', '市辖区', '3', '5418', 'S');
INSERT INTO `ey_region` VALUES ('5420', '临河区', '3', '5418', 'L');
INSERT INTO `ey_region` VALUES ('5440', '五原县', '3', '5418', 'W');
INSERT INTO `ey_region` VALUES ('5450', '磴口县', '3', '5418', 'D');
INSERT INTO `ey_region` VALUES ('5461', '乌拉特前旗', '3', '5418', 'W');
INSERT INTO `ey_region` VALUES ('5477', '乌拉特中旗', '3', '5418', 'W');
INSERT INTO `ey_region` VALUES ('5489', '乌拉特后旗', '3', '5418', 'W');
INSERT INTO `ey_region` VALUES ('5495', '杭锦后旗', '3', '5418', 'H');
INSERT INTO `ey_region` VALUES ('5505', '乌兰察布市', '2', '4670', 'W');
INSERT INTO `ey_region` VALUES ('5506', '市辖区', '3', '5505', 'S');
INSERT INTO `ey_region` VALUES ('5507', '集宁区', '3', '5505', 'J');
INSERT INTO `ey_region` VALUES ('5518', '卓资县', '3', '5505', 'Z');
INSERT INTO `ey_region` VALUES ('5526', '化德县', '3', '5505', 'H');
INSERT INTO `ey_region` VALUES ('5532', '商都县', '3', '5505', 'S');
INSERT INTO `ey_region` VALUES ('5542', '兴和县', '3', '5505', 'X');
INSERT INTO `ey_region` VALUES ('5551', '凉城县', '3', '5505', 'L');
INSERT INTO `ey_region` VALUES ('5562', '察哈尔右翼前旗', '3', '5505', 'C');
INSERT INTO `ey_region` VALUES ('5571', '察右中旗', '3', '5505', 'C');
INSERT INTO `ey_region` VALUES ('5582', '察哈尔右翼后旗', '3', '5505', 'C');
INSERT INTO `ey_region` VALUES ('5590', '四子王旗', '3', '5505', 'S');
INSERT INTO `ey_region` VALUES ('5603', '丰镇市', '3', '5505', 'F');
INSERT INTO `ey_region` VALUES ('5616', '兴安盟', '2', '4670', 'X');
INSERT INTO `ey_region` VALUES ('5617', '乌兰浩特市', '3', '5616', 'W');
INSERT INTO `ey_region` VALUES ('5629', '阿尔山市', '3', '5616', 'A');
INSERT INTO `ey_region` VALUES ('5636', '科右前旗', '3', '5616', 'K');
INSERT INTO `ey_region` VALUES ('5655', '科右中旗', '3', '5616', 'K');
INSERT INTO `ey_region` VALUES ('5677', '扎赉特旗', '3', '5616', 'Z');
INSERT INTO `ey_region` VALUES ('5692', '突泉县', '3', '5616', 'T');
INSERT INTO `ey_region` VALUES ('5702', '锡林郭勒盟', '2', '4670', 'X');
INSERT INTO `ey_region` VALUES ('5703', '二连浩特市', '3', '5702', 'E');
INSERT INTO `ey_region` VALUES ('5709', '锡林浩特市', '3', '5702', 'X');
INSERT INTO `ey_region` VALUES ('5723', '阿巴嘎旗', '3', '5702', 'A');
INSERT INTO `ey_region` VALUES ('5731', '苏尼特左旗', '3', '5702', 'S');
INSERT INTO `ey_region` VALUES ('5738', '苏尼特右旗', '3', '5702', 'S');
INSERT INTO `ey_region` VALUES ('5745', '东乌珠穆沁旗', '3', '5702', 'D');
INSERT INTO `ey_region` VALUES ('5758', '西乌珠穆沁旗', '3', '5702', 'X');
INSERT INTO `ey_region` VALUES ('5766', '太仆寺旗', '3', '5702', 'T');
INSERT INTO `ey_region` VALUES ('5774', '镶黄旗', '3', '5702', 'X');
INSERT INTO `ey_region` VALUES ('5778', '正镶白旗', '3', '5702', 'Z');
INSERT INTO `ey_region` VALUES ('5785', '正蓝旗', '3', '5702', 'Z');
INSERT INTO `ey_region` VALUES ('5794', '多伦县', '3', '5702', 'D');
INSERT INTO `ey_region` VALUES ('5799', '阿拉善盟', '2', '4670', 'A');
INSERT INTO `ey_region` VALUES ('5800', '阿拉善左旗', '3', '5799', 'A');
INSERT INTO `ey_region` VALUES ('5814', '阿拉善右旗', '3', '5799', 'A');
INSERT INTO `ey_region` VALUES ('5820', '额济纳旗', '3', '5799', 'E');
INSERT INTO `ey_region` VALUES ('5827', '辽宁省', '1', '0', 'L');
INSERT INTO `ey_region` VALUES ('5828', '沈阳市', '2', '5827', 'S');
INSERT INTO `ey_region` VALUES ('5829', '市辖区', '3', '5828', 'S');
INSERT INTO `ey_region` VALUES ('5830', '和平区', '3', '5828', 'H');
INSERT INTO `ey_region` VALUES ('5848', '沈河区', '3', '5828', 'S');
INSERT INTO `ey_region` VALUES ('5859', '大东区', '3', '5828', 'D');
INSERT INTO `ey_region` VALUES ('5873', '皇姑区', '3', '5828', 'H');
INSERT INTO `ey_region` VALUES ('5894', '铁西区', '3', '5828', 'T');
INSERT INTO `ey_region` VALUES ('5909', '苏家屯区', '3', '5828', 'S');
INSERT INTO `ey_region` VALUES ('5934', '东陵区', '3', '5828', 'D');
INSERT INTO `ey_region` VALUES ('5954', '新城子区', '3', '5828', 'X');
INSERT INTO `ey_region` VALUES ('5975', '于洪区', '3', '5828', 'Y');
INSERT INTO `ey_region` VALUES ('5998', '辽中县', '3', '5828', 'L');
INSERT INTO `ey_region` VALUES ('6020', '康平县', '3', '5828', 'K');
INSERT INTO `ey_region` VALUES ('6038', '法库县', '3', '5828', 'F');
INSERT INTO `ey_region` VALUES ('6058', '新民市', '3', '5828', 'X');
INSERT INTO `ey_region` VALUES ('6088', '大连市', '2', '5827', 'D');
INSERT INTO `ey_region` VALUES ('6089', '市辖区', '3', '6088', 'S');
INSERT INTO `ey_region` VALUES ('6090', '中山区', '3', '6088', 'Z');
INSERT INTO `ey_region` VALUES ('6099', '西岗区', '3', '6088', 'X');
INSERT INTO `ey_region` VALUES ('6107', '沙河口区', '3', '6088', 'S');
INSERT INTO `ey_region` VALUES ('6117', '甘井子区', '3', '6088', 'G');
INSERT INTO `ey_region` VALUES ('6137', '旅顺口区', '3', '6088', 'L');
INSERT INTO `ey_region` VALUES ('6153', '金州区', '3', '6088', 'J');
INSERT INTO `ey_region` VALUES ('6178', '长海县', '3', '6088', 'C');
INSERT INTO `ey_region` VALUES ('6184', '瓦房店市', '3', '6088', 'W');
INSERT INTO `ey_region` VALUES ('6217', '普兰店市', '3', '6088', 'P');
INSERT INTO `ey_region` VALUES ('6239', '庄河市', '3', '6088', 'Z');
INSERT INTO `ey_region` VALUES ('6266', '鞍山市', '2', '5827', 'A');
INSERT INTO `ey_region` VALUES ('6267', '市辖区', '3', '6266', 'S');
INSERT INTO `ey_region` VALUES ('6268', '铁东区', '3', '6266', 'T');
INSERT INTO `ey_region` VALUES ('6282', '铁西区', '3', '6266', 'T');
INSERT INTO `ey_region` VALUES ('6293', '立山区', '3', '6266', 'L');
INSERT INTO `ey_region` VALUES ('6303', '千山区', '3', '6266', 'Q');
INSERT INTO `ey_region` VALUES ('6316', '台安县', '3', '6266', 'T');
INSERT INTO `ey_region` VALUES ('6331', '岫岩县', '3', '6266', 'X');
INSERT INTO `ey_region` VALUES ('6354', '海城市', '3', '6266', 'H');
INSERT INTO `ey_region` VALUES ('6384', '抚顺市', '2', '5827', 'F');
INSERT INTO `ey_region` VALUES ('6385', '市辖区', '3', '6384', 'S');
INSERT INTO `ey_region` VALUES ('6386', '新抚区', '3', '6384', 'X');
INSERT INTO `ey_region` VALUES ('6395', '东洲区', '3', '6384', 'D');
INSERT INTO `ey_region` VALUES ('6409', '望花区', '3', '6384', 'W');
INSERT INTO `ey_region` VALUES ('6422', '顺城区', '3', '6384', 'S');
INSERT INTO `ey_region` VALUES ('6432', '抚顺县', '3', '6384', 'F');
INSERT INTO `ey_region` VALUES ('6445', '新宾县', '3', '6384', 'X');
INSERT INTO `ey_region` VALUES ('6461', '清原县', '3', '6384', 'Q');
INSERT INTO `ey_region` VALUES ('6476', '本溪市', '2', '5827', 'B');
INSERT INTO `ey_region` VALUES ('6477', '市辖区', '3', '6476', 'S');
INSERT INTO `ey_region` VALUES ('6478', '平山区', '3', '6476', 'P');
INSERT INTO `ey_region` VALUES ('6488', '溪湖区', '3', '6476', 'X');
INSERT INTO `ey_region` VALUES ('6499', '明山区', '3', '6476', 'M');
INSERT INTO `ey_region` VALUES ('6509', '南芬区', '3', '6476', 'N');
INSERT INTO `ey_region` VALUES ('6515', '本溪县', '3', '6476', 'B');
INSERT INTO `ey_region` VALUES ('6528', '桓仁县', '3', '6476', 'H');
INSERT INTO `ey_region` VALUES ('6542', '丹东市', '2', '5827', 'D');
INSERT INTO `ey_region` VALUES ('6543', '市辖区', '3', '6542', 'S');
INSERT INTO `ey_region` VALUES ('6544', '元宝区', '3', '6542', 'Y');
INSERT INTO `ey_region` VALUES ('6552', '振兴区', '3', '6542', 'Z');
INSERT INTO `ey_region` VALUES ('6563', '振安区', '3', '6542', 'Z');
INSERT INTO `ey_region` VALUES ('6573', '宽甸县', '3', '6542', 'K');
INSERT INTO `ey_region` VALUES ('6596', '东港市', '3', '6542', 'D');
INSERT INTO `ey_region` VALUES ('6621', '凤城市', '3', '6542', 'F');
INSERT INTO `ey_region` VALUES ('6643', '锦州市', '2', '5827', 'J');
INSERT INTO `ey_region` VALUES ('6644', '市辖区', '3', '6643', 'S');
INSERT INTO `ey_region` VALUES ('6645', '古塔区', '3', '6643', 'G');
INSERT INTO `ey_region` VALUES ('6655', '凌河区', '3', '6643', 'L');
INSERT INTO `ey_region` VALUES ('6668', '太和区', '3', '6643', 'T');
INSERT INTO `ey_region` VALUES ('6683', '黑山县', '3', '6643', 'H');
INSERT INTO `ey_region` VALUES ('6706', '义县', '3', '6643', 'Y');
INSERT INTO `ey_region` VALUES ('6725', '凌海市', '3', '6643', 'L');
INSERT INTO `ey_region` VALUES ('6750', '北镇市', '3', '6643', 'B');
INSERT INTO `ey_region` VALUES ('6771', '营口市', '2', '5827', 'Y');
INSERT INTO `ey_region` VALUES ('6772', '市辖区', '3', '6771', 'S');
INSERT INTO `ey_region` VALUES ('6773', '站前区', '3', '6771', 'Z');
INSERT INTO `ey_region` VALUES ('6781', '西市区', '3', '6771', 'X');
INSERT INTO `ey_region` VALUES ('6789', '鲅鱼圈区', '3', '6771', 'B');
INSERT INTO `ey_region` VALUES ('6797', '老边区', '3', '6771', 'L');
INSERT INTO `ey_region` VALUES ('6804', '盖州市', '3', '6771', 'G');
INSERT INTO `ey_region` VALUES ('6832', '大石桥市', '3', '6771', 'D');
INSERT INTO `ey_region` VALUES ('6851', '阜新市', '2', '5827', 'F');
INSERT INTO `ey_region` VALUES ('6852', '市辖区', '3', '6851', 'S');
INSERT INTO `ey_region` VALUES ('6853', '海州区', '3', '6851', 'H');
INSERT INTO `ey_region` VALUES ('6865', '新邱区', '3', '6851', 'X');
INSERT INTO `ey_region` VALUES ('6871', '太平区', '3', '6851', 'T');
INSERT INTO `ey_region` VALUES ('6878', '清河门区', '3', '6851', 'Q');
INSERT INTO `ey_region` VALUES ('6885', '细河区', '3', '6851', 'X');
INSERT INTO `ey_region` VALUES ('6893', '阜新县', '3', '6851', 'F');
INSERT INTO `ey_region` VALUES ('6930', '彰武县', '3', '6851', 'Z');
INSERT INTO `ey_region` VALUES ('6955', '辽阳市', '2', '5827', 'L');
INSERT INTO `ey_region` VALUES ('6956', '市辖区', '3', '6955', 'S');
INSERT INTO `ey_region` VALUES ('6957', '白塔区', '3', '6955', 'B');
INSERT INTO `ey_region` VALUES ('6964', '文圣区', '3', '6955', 'W');
INSERT INTO `ey_region` VALUES ('6971', '宏伟区', '3', '6955', 'H');
INSERT INTO `ey_region` VALUES ('6977', '弓长岭区', '3', '6955', 'G');
INSERT INTO `ey_region` VALUES ('6983', '太子河区', '3', '6955', 'T');
INSERT INTO `ey_region` VALUES ('6989', '辽阳县', '3', '6955', 'L');
INSERT INTO `ey_region` VALUES ('7007', '灯塔市', '3', '6955', 'D');
INSERT INTO `ey_region` VALUES ('7024', '盘锦市', '2', '5827', 'P');
INSERT INTO `ey_region` VALUES ('7025', '市辖区', '3', '7024', 'S');
INSERT INTO `ey_region` VALUES ('7026', '双台子区', '3', '7024', 'S');
INSERT INTO `ey_region` VALUES ('7036', '兴隆台区', '3', '7024', 'X');
INSERT INTO `ey_region` VALUES ('7055', '大洼县', '3', '7024', 'D');
INSERT INTO `ey_region` VALUES ('7072', '盘山县', '3', '7024', 'P');
INSERT INTO `ey_region` VALUES ('7088', '铁岭市', '2', '5827', 'T');
INSERT INTO `ey_region` VALUES ('7089', '市辖区', '3', '7088', 'S');
INSERT INTO `ey_region` VALUES ('7090', '银州区', '3', '7088', 'Y');
INSERT INTO `ey_region` VALUES ('7099', '清河区', '3', '7088', 'Q');
INSERT INTO `ey_region` VALUES ('7105', '铁岭县', '3', '7088', 'T');
INSERT INTO `ey_region` VALUES ('7121', '西丰县', '3', '7088', 'X');
INSERT INTO `ey_region` VALUES ('7140', '昌图县', '3', '7088', 'C');
INSERT INTO `ey_region` VALUES ('7180', '调兵山市', '3', '7088', 'D');
INSERT INTO `ey_region` VALUES ('7186', '开原市', '3', '7088', 'K');
INSERT INTO `ey_region` VALUES ('7208', '朝阳市', '2', '5827', 'C');
INSERT INTO `ey_region` VALUES ('7209', '市辖区', '3', '7208', 'S');
INSERT INTO `ey_region` VALUES ('7210', '双塔区', '3', '7208', 'S');
INSERT INTO `ey_region` VALUES ('7225', '龙城区', '3', '7208', 'L');
INSERT INTO `ey_region` VALUES ('7238', '朝阳县', '3', '7208', 'C');
INSERT INTO `ey_region` VALUES ('7267', '建平县', '3', '7208', 'J');
INSERT INTO `ey_region` VALUES ('7299', '喀喇沁左翼县', '3', '7208', 'K');
INSERT INTO `ey_region` VALUES ('7322', '北票市', '3', '7208', 'B');
INSERT INTO `ey_region` VALUES ('7360', '凌源市', '3', '7208', 'L');
INSERT INTO `ey_region` VALUES ('7391', '葫芦岛市', '2', '5827', 'H');
INSERT INTO `ey_region` VALUES ('7392', '市辖区', '3', '7391', 'S');
INSERT INTO `ey_region` VALUES ('7393', '连山区', '3', '7391', 'L');
INSERT INTO `ey_region` VALUES ('7419', '龙港区', '3', '7391', 'L');
INSERT INTO `ey_region` VALUES ('7433', '南票区', '3', '7391', 'N');
INSERT INTO `ey_region` VALUES ('7446', '绥中县', '3', '7391', 'S');
INSERT INTO `ey_region` VALUES ('7474', '建昌县', '3', '7391', 'J');
INSERT INTO `ey_region` VALUES ('7503', '兴城市', '3', '7391', 'X');
INSERT INTO `ey_region` VALUES ('7531', '吉林省', '1', '0', 'J');
INSERT INTO `ey_region` VALUES ('7532', '长春市', '2', '7531', 'C');
INSERT INTO `ey_region` VALUES ('7533', '长春市辖区', '3', '7532', 'C');
INSERT INTO `ey_region` VALUES ('7534', '南关区', '3', '7532', 'N');
INSERT INTO `ey_region` VALUES ('7552', '宽城区', '3', '7532', 'K');
INSERT INTO `ey_region` VALUES ('7569', '朝阳区', '3', '7532', 'C');
INSERT INTO `ey_region` VALUES ('7582', '二道区', '3', '7532', 'E');
INSERT INTO `ey_region` VALUES ('7597', '绿园区', '3', '7532', 'L');
INSERT INTO `ey_region` VALUES ('7610', '双阳区', '3', '7532', 'S');
INSERT INTO `ey_region` VALUES ('7619', '农安县', '3', '7532', 'N');
INSERT INTO `ey_region` VALUES ('7642', '九台市', '3', '7532', 'J');
INSERT INTO `ey_region` VALUES ('7658', '榆树市', '3', '7532', 'Y');
INSERT INTO `ey_region` VALUES ('7687', '德惠市', '3', '7532', 'D');
INSERT INTO `ey_region` VALUES ('7706', '吉林市', '2', '7531', 'J');
INSERT INTO `ey_region` VALUES ('7707', '吉林市辖区', '3', '7706', 'J');
INSERT INTO `ey_region` VALUES ('7708', '昌邑区', '3', '7706', 'C');
INSERT INTO `ey_region` VALUES ('7731', '龙潭区', '3', '7706', 'L');
INSERT INTO `ey_region` VALUES ('7752', '船营区', '3', '7706', 'C');
INSERT INTO `ey_region` VALUES ('7768', '丰满区', '3', '7706', 'F');
INSERT INTO `ey_region` VALUES ('7781', '永吉县', '3', '7706', 'Y');
INSERT INTO `ey_region` VALUES ('7792', '蛟河市', '3', '7706', 'J');
INSERT INTO `ey_region` VALUES ('7810', '桦甸市', '3', '7706', 'H');
INSERT INTO `ey_region` VALUES ('7828', '舒兰市', '3', '7706', 'S');
INSERT INTO `ey_region` VALUES ('7849', '磐石市', '3', '7706', 'P');
INSERT INTO `ey_region` VALUES ('7868', '四平市', '2', '7531', 'S');
INSERT INTO `ey_region` VALUES ('7869', '四平市辖区', '3', '7868', 'S');
INSERT INTO `ey_region` VALUES ('7870', '铁西区', '3', '7868', 'T');
INSERT INTO `ey_region` VALUES ('7878', '铁东区', '3', '7868', 'T');
INSERT INTO `ey_region` VALUES ('7892', '梨树县', '3', '7868', 'L');
INSERT INTO `ey_region` VALUES ('7916', '伊通县', '3', '7868', 'Y');
INSERT INTO `ey_region` VALUES ('7933', '公主岭市', '3', '7868', 'G');
INSERT INTO `ey_region` VALUES ('7964', '双辽市', '3', '7868', 'S');
INSERT INTO `ey_region` VALUES ('7986', '辽源市', '2', '7531', 'L');
INSERT INTO `ey_region` VALUES ('7987', '辽源市辖区', '3', '7986', 'L');
INSERT INTO `ey_region` VALUES ('7988', '龙山区', '3', '7986', 'L');
INSERT INTO `ey_region` VALUES ('8000', '西安区', '3', '7986', 'X');
INSERT INTO `ey_region` VALUES ('8008', '东丰县', '3', '7986', 'D');
INSERT INTO `ey_region` VALUES ('8023', '东辽县', '3', '7986', 'D');
INSERT INTO `ey_region` VALUES ('8037', '通化市', '2', '7531', 'T');
INSERT INTO `ey_region` VALUES ('8038', '通化市辖区', '3', '8037', 'T');
INSERT INTO `ey_region` VALUES ('8039', '东昌区', '3', '8037', 'D');
INSERT INTO `ey_region` VALUES ('8051', '二道江区', '3', '8037', 'E');
INSERT INTO `ey_region` VALUES ('8058', '通化县', '3', '8037', 'T');
INSERT INTO `ey_region` VALUES ('8076', '辉南县', '3', '8037', 'H');
INSERT INTO `ey_region` VALUES ('8088', '柳河县', '3', '8037', 'L');
INSERT INTO `ey_region` VALUES ('8104', '梅河口市', '3', '8037', 'M');
INSERT INTO `ey_region` VALUES ('8129', '集安市', '3', '8037', 'J');
INSERT INTO `ey_region` VALUES ('8144', '白山市', '2', '7531', 'B');
INSERT INTO `ey_region` VALUES ('8145', '白山市辖区', '3', '8144', 'B');
INSERT INTO `ey_region` VALUES ('8146', '八道江区', '3', '8144', 'B');
INSERT INTO `ey_region` VALUES ('8159', '江源区', '3', '8144', 'J');
INSERT INTO `ey_region` VALUES ('8168', '抚松县', '3', '8144', 'F');
INSERT INTO `ey_region` VALUES ('8183', '靖宇县', '3', '8144', 'J');
INSERT INTO `ey_region` VALUES ('8192', '长白县', '3', '8144', 'C');
INSERT INTO `ey_region` VALUES ('8202', '临江市', '3', '8144', 'L');
INSERT INTO `ey_region` VALUES ('8216', '松原市', '2', '7531', 'S');
INSERT INTO `ey_region` VALUES ('8217', '松原市辖区', '3', '8216', 'S');
INSERT INTO `ey_region` VALUES ('8218', '宁江区', '3', '8216', 'N');
INSERT INTO `ey_region` VALUES ('8239', '前郭县', '3', '8216', 'Q');
INSERT INTO `ey_region` VALUES ('8266', '长岭县', '3', '8216', 'C');
INSERT INTO `ey_region` VALUES ('8300', '乾安县', '3', '8216', 'Q');
INSERT INTO `ey_region` VALUES ('8311', '扶余县', '3', '8216', 'F');
INSERT INTO `ey_region` VALUES ('8333', '白城市', '2', '7531', 'B');
INSERT INTO `ey_region` VALUES ('8334', '白城市辖区', '3', '8333', 'B');
INSERT INTO `ey_region` VALUES ('8335', '洮北区', '3', '8333', 'T');
INSERT INTO `ey_region` VALUES ('8362', '镇赉县', '3', '8333', 'Z');
INSERT INTO `ey_region` VALUES ('8375', '通榆县', '3', '8333', 'T');
INSERT INTO `ey_region` VALUES ('8393', '洮南市', '3', '8333', 'T');
INSERT INTO `ey_region` VALUES ('8420', '大安市', '3', '8333', 'D');
INSERT INTO `ey_region` VALUES ('8445', '延边州', '2', '7531', 'Y');
INSERT INTO `ey_region` VALUES ('8446', '延吉市', '3', '8445', 'Y');
INSERT INTO `ey_region` VALUES ('8456', '图们市', '3', '8445', 'T');
INSERT INTO `ey_region` VALUES ('8464', '敦化市', '3', '8445', 'D');
INSERT INTO `ey_region` VALUES ('8489', '珲春市', '3', '8445', 'H');
INSERT INTO `ey_region` VALUES ('8504', '龙井市', '3', '8445', 'L');
INSERT INTO `ey_region` VALUES ('8515', '和龙市', '3', '8445', 'H');
INSERT INTO `ey_region` VALUES ('8530', '汪清县', '3', '8445', 'W');
INSERT INTO `ey_region` VALUES ('8545', '安图县', '3', '8445', 'A');
INSERT INTO `ey_region` VALUES ('8558', '黑龙江省', '1', '0', 'H');
INSERT INTO `ey_region` VALUES ('8559', '哈尔滨市', '2', '8558', 'H');
INSERT INTO `ey_region` VALUES ('8560', '市辖区', '3', '8559', 'S');
INSERT INTO `ey_region` VALUES ('8561', '道里区', '3', '8559', 'D');
INSERT INTO `ey_region` VALUES ('8585', '南岗区', '3', '8559', 'N');
INSERT INTO `ey_region` VALUES ('8606', '道外区', '3', '8559', 'D');
INSERT INTO `ey_region` VALUES ('8633', '平房区', '3', '8559', 'P');
INSERT INTO `ey_region` VALUES ('8642', '松北区', '3', '8559', 'S');
INSERT INTO `ey_region` VALUES ('8650', '香坊区', '3', '8559', 'X');
INSERT INTO `ey_region` VALUES ('8676', '呼兰区', '3', '8559', 'H');
INSERT INTO `ey_region` VALUES ('8694', '阿城区', '3', '8559', 'A');
INSERT INTO `ey_region` VALUES ('8714', '依兰县', '3', '8559', 'Y');
INSERT INTO `ey_region` VALUES ('8729', '方正县', '3', '8559', 'F');
INSERT INTO `ey_region` VALUES ('8740', '宾县', '3', '8559', 'B');
INSERT INTO `ey_region` VALUES ('8758', '巴彦县', '3', '8559', 'B');
INSERT INTO `ey_region` VALUES ('8778', '木兰县', '3', '8559', 'M');
INSERT INTO `ey_region` VALUES ('8788', '通河县', '3', '8559', 'T');
INSERT INTO `ey_region` VALUES ('8800', '延寿县', '3', '8559', 'Y');
INSERT INTO `ey_region` VALUES ('8812', '双城市', '3', '8559', 'S');
INSERT INTO `ey_region` VALUES ('8838', '尚志市', '3', '8559', 'S');
INSERT INTO `ey_region` VALUES ('8858', '五常市', '3', '8559', 'W');
INSERT INTO `ey_region` VALUES ('8884', '齐齐哈尔市', '2', '8558', 'Q');
INSERT INTO `ey_region` VALUES ('8885', '市辖区', '3', '8884', 'S');
INSERT INTO `ey_region` VALUES ('8886', '龙沙区', '3', '8884', 'L');
INSERT INTO `ey_region` VALUES ('8894', '建华区', '3', '8884', 'J');
INSERT INTO `ey_region` VALUES ('8901', '铁锋区', '3', '8884', 'T');
INSERT INTO `ey_region` VALUES ('8911', '昂昂溪区', '3', '8884', 'A');
INSERT INTO `ey_region` VALUES ('8918', '富拉尔基区', '3', '8884', 'F');
INSERT INTO `ey_region` VALUES ('8928', '碾子山区', '3', '8884', 'N');
INSERT INTO `ey_region` VALUES ('8934', '梅里斯达斡尔族区', '3', '8884', 'M');
INSERT INTO `ey_region` VALUES ('8943', '龙江县', '3', '8884', 'L');
INSERT INTO `ey_region` VALUES ('8958', '依安县', '3', '8884', 'Y');
INSERT INTO `ey_region` VALUES ('8976', '泰来县', '3', '8884', 'T');
INSERT INTO `ey_region` VALUES ('8998', '甘南县', '3', '8884', 'G');
INSERT INTO `ey_region` VALUES ('9011', '富裕县', '3', '8884', 'F');
INSERT INTO `ey_region` VALUES ('9024', '克山县', '3', '8884', 'K');
INSERT INTO `ey_region` VALUES ('9048', '克东县', '3', '8884', 'K');
INSERT INTO `ey_region` VALUES ('9067', '拜泉县', '3', '8884', 'B');
INSERT INTO `ey_region` VALUES ('9084', '讷河市', '3', '8884', 'N');
INSERT INTO `ey_region` VALUES ('9117', '鸡西市', '2', '8558', 'J');
INSERT INTO `ey_region` VALUES ('9118', '市辖区', '3', '9117', 'S');
INSERT INTO `ey_region` VALUES ('9119', '鸡冠区', '3', '9117', 'J');
INSERT INTO `ey_region` VALUES ('9129', '恒山区', '3', '9117', 'H');
INSERT INTO `ey_region` VALUES ('9139', '滴道区', '3', '9117', 'D');
INSERT INTO `ey_region` VALUES ('9146', '梨树区', '3', '9117', 'L');
INSERT INTO `ey_region` VALUES ('9153', '城子河区', '3', '9117', 'C');
INSERT INTO `ey_region` VALUES ('9161', '麻山区', '3', '9117', 'M');
INSERT INTO `ey_region` VALUES ('9164', '鸡东县', '3', '9117', 'J');
INSERT INTO `ey_region` VALUES ('9178', '虎林市', '3', '9117', 'H');
INSERT INTO `ey_region` VALUES ('9199', '密山市', '3', '9117', 'M');
INSERT INTO `ey_region` VALUES ('9222', '鹤岗市', '2', '8558', 'H');
INSERT INTO `ey_region` VALUES ('9223', '市辖区', '3', '9222', 'S');
INSERT INTO `ey_region` VALUES ('9224', '向阳区', '3', '9222', 'X');
INSERT INTO `ey_region` VALUES ('9230', '工农区', '3', '9222', 'G');
INSERT INTO `ey_region` VALUES ('9237', '南山区', '3', '9222', 'N');
INSERT INTO `ey_region` VALUES ('9244', '兴安区', '3', '9222', 'X');
INSERT INTO `ey_region` VALUES ('9250', '东山区', '3', '9222', 'D');
INSERT INTO `ey_region` VALUES ('9261', '兴山区', '3', '9222', 'X');
INSERT INTO `ey_region` VALUES ('9266', '萝北县', '3', '9222', 'L');
INSERT INTO `ey_region` VALUES ('9283', '绥滨县', '3', '9222', 'S');
INSERT INTO `ey_region` VALUES ('9296', '双鸭山市', '2', '8558', 'S');
INSERT INTO `ey_region` VALUES ('9297', '市辖区', '3', '9296', 'S');
INSERT INTO `ey_region` VALUES ('9298', '尖山区', '3', '9296', 'J');
INSERT INTO `ey_region` VALUES ('9307', '岭东区', '3', '9296', 'L');
INSERT INTO `ey_region` VALUES ('9317', '四方台区', '3', '9296', 'S');
INSERT INTO `ey_region` VALUES ('9323', '宝山区', '3', '9296', 'B');
INSERT INTO `ey_region` VALUES ('9335', '集贤县', '3', '9296', 'J');
INSERT INTO `ey_region` VALUES ('9356', '友谊县', '3', '9296', 'Y');
INSERT INTO `ey_region` VALUES ('9370', '宝清县', '3', '9296', 'B');
INSERT INTO `ey_region` VALUES ('9393', '饶河县', '3', '9296', 'R');
INSERT INTO `ey_region` VALUES ('9419', '大庆市', '2', '8558', 'D');
INSERT INTO `ey_region` VALUES ('9420', '市辖区', '3', '9419', 'S');
INSERT INTO `ey_region` VALUES ('9421', '萨尔图区', '3', '9419', 'S');
INSERT INTO `ey_region` VALUES ('9431', '龙凤区', '3', '9419', 'L');
INSERT INTO `ey_region` VALUES ('9440', '让胡路区', '3', '9419', 'R');
INSERT INTO `ey_region` VALUES ('9451', '红岗区', '3', '9419', 'H');
INSERT INTO `ey_region` VALUES ('9458', '大同区', '3', '9419', 'D');
INSERT INTO `ey_region` VALUES ('9474', '肇州县', '3', '9419', 'Z');
INSERT INTO `ey_region` VALUES ('9489', '肇源县', '3', '9419', 'Z');
INSERT INTO `ey_region` VALUES ('9514', '林甸县', '3', '9419', 'L');
INSERT INTO `ey_region` VALUES ('9527', '杜尔伯特县', '3', '9419', 'D');
INSERT INTO `ey_region` VALUES ('9553', '伊春市', '2', '8558', 'Y');
INSERT INTO `ey_region` VALUES ('9554', '市辖区', '3', '9553', 'S');
INSERT INTO `ey_region` VALUES ('9555', '伊春区', '3', '9553', 'Y');
INSERT INTO `ey_region` VALUES ('9561', '南岔区', '3', '9553', 'N');
INSERT INTO `ey_region` VALUES ('9581', '友好区', '3', '9553', 'Y');
INSERT INTO `ey_region` VALUES ('9599', '西林区', '3', '9553', 'X');
INSERT INTO `ey_region` VALUES ('9603', '翠峦区', '3', '9553', 'C');
INSERT INTO `ey_region` VALUES ('9614', '新青区', '3', '9553', 'X');
INSERT INTO `ey_region` VALUES ('9631', '美溪区', '3', '9553', 'M');
INSERT INTO `ey_region` VALUES ('9647', '金山屯区', '3', '9553', 'J');
INSERT INTO `ey_region` VALUES ('9660', '五营区', '3', '9553', 'W');
INSERT INTO `ey_region` VALUES ('9671', '乌马河区', '3', '9553', 'W');
INSERT INTO `ey_region` VALUES ('9685', '汤旺河区', '3', '9553', 'T');
INSERT INTO `ey_region` VALUES ('9702', '带岭区', '3', '9553', 'D');
INSERT INTO `ey_region` VALUES ('9715', '乌伊岭区', '3', '9553', 'W');
INSERT INTO `ey_region` VALUES ('9729', '红星区', '3', '9553', 'H');
INSERT INTO `ey_region` VALUES ('9742', '上甘岭区', '3', '9553', 'S');
INSERT INTO `ey_region` VALUES ('9756', '嘉荫县', '3', '9553', 'J');
INSERT INTO `ey_region` VALUES ('9772', '铁力市', '3', '9553', 'T');
INSERT INTO `ey_region` VALUES ('9785', '佳木斯市', '2', '8558', 'J');
INSERT INTO `ey_region` VALUES ('9786', '市辖区', '3', '9785', 'S');
INSERT INTO `ey_region` VALUES ('9787', '向阳区', '3', '9785', 'X');
INSERT INTO `ey_region` VALUES ('9795', '前进区', '3', '9785', 'Q');
INSERT INTO `ey_region` VALUES ('9802', '东风区', '3', '9785', 'D');
INSERT INTO `ey_region` VALUES ('9810', '郊区', '3', '9785', 'J');
INSERT INTO `ey_region` VALUES ('9825', '桦南县', '3', '9785', 'H');
INSERT INTO `ey_region` VALUES ('9839', '桦川县', '3', '9785', 'H');
INSERT INTO `ey_region` VALUES ('9851', '汤原县', '3', '9785', 'T');
INSERT INTO `ey_region` VALUES ('9866', '抚远县', '3', '9785', 'F');
INSERT INTO `ey_region` VALUES ('9879', '同江市', '3', '9785', 'T');
INSERT INTO `ey_region` VALUES ('9907', '富锦市', '3', '9785', 'F');
INSERT INTO `ey_region` VALUES ('9930', '七台河市', '2', '8558', 'Q');
INSERT INTO `ey_region` VALUES ('9931', '市辖区', '3', '9930', 'S');
INSERT INTO `ey_region` VALUES ('9932', '新兴区', '3', '9930', 'X');
INSERT INTO `ey_region` VALUES ('9944', '桃山区', '3', '9930', 'T');
INSERT INTO `ey_region` VALUES ('9952', '茄子河区', '3', '9930', 'Q');
INSERT INTO `ey_region` VALUES ('9962', '勃利县', '3', '9930', 'B');
INSERT INTO `ey_region` VALUES ('9981', '牡丹江市', '2', '8558', 'M');
INSERT INTO `ey_region` VALUES ('9982', '市辖区', '3', '9981', 'S');
INSERT INTO `ey_region` VALUES ('9983', '东安区', '3', '9981', 'D');
INSERT INTO `ey_region` VALUES ('9989', '阳明区', '3', '9981', 'Y');
INSERT INTO `ey_region` VALUES ('9996', '爱民区', '3', '9981', 'A');
INSERT INTO `ey_region` VALUES ('10005', '西安区', '3', '9981', 'X');
INSERT INTO `ey_region` VALUES ('10014', '东宁县', '3', '9981', 'D');
INSERT INTO `ey_region` VALUES ('10022', '林口县', '3', '9981', 'L');
INSERT INTO `ey_region` VALUES ('10036', '绥芬河市', '3', '9981', 'S');
INSERT INTO `ey_region` VALUES ('10039', '海林市', '3', '9981', 'H');
INSERT INTO `ey_region` VALUES ('10056', '宁安市', '3', '9981', 'N');
INSERT INTO `ey_region` VALUES ('10072', '穆棱市', '3', '9981', 'M');
INSERT INTO `ey_region` VALUES ('10084', '黑河市', '2', '8558', 'H');
INSERT INTO `ey_region` VALUES ('10085', '市辖区', '3', '10084', 'S');
INSERT INTO `ey_region` VALUES ('10086', '爱辉区', '3', '10084', 'A');
INSERT INTO `ey_region` VALUES ('10122', '嫩江县', '3', '10084', 'N');
INSERT INTO `ey_region` VALUES ('10150', '逊克县', '3', '10084', 'X');
INSERT INTO `ey_region` VALUES ('10168', '孙吴县', '3', '10084', 'S');
INSERT INTO `ey_region` VALUES ('10192', '北安市', '3', '10084', 'B');
INSERT INTO `ey_region` VALUES ('10214', '五大连池市', '3', '10084', 'W');
INSERT INTO `ey_region` VALUES ('10252', '绥化市', '2', '8558', 'S');
INSERT INTO `ey_region` VALUES ('10253', '市辖区', '3', '10252', 'S');
INSERT INTO `ey_region` VALUES ('10254', '北林区', '3', '10252', 'B');
INSERT INTO `ey_region` VALUES ('10281', '望奎县', '3', '10252', 'W');
INSERT INTO `ey_region` VALUES ('10301', '兰西县', '3', '10252', 'L');
INSERT INTO `ey_region` VALUES ('10320', '青冈县', '3', '10252', 'Q');
INSERT INTO `ey_region` VALUES ('10342', '庆安县', '3', '10252', 'Q');
INSERT INTO `ey_region` VALUES ('10360', '明水县', '3', '10252', 'M');
INSERT INTO `ey_region` VALUES ('10380', '绥棱县', '3', '10252', 'S');
INSERT INTO `ey_region` VALUES ('10401', '安达市', '3', '10252', 'A');
INSERT INTO `ey_region` VALUES ('10425', '肇东市', '3', '10252', 'Z');
INSERT INTO `ey_region` VALUES ('10452', '海伦市', '3', '10252', 'H');
INSERT INTO `ey_region` VALUES ('10483', '大兴安岭地区', '2', '8558', 'D');
INSERT INTO `ey_region` VALUES ('10484', '加格达奇区', '3', '10483', 'J');
INSERT INTO `ey_region` VALUES ('10495', '松岭区', '3', '10483', 'S');
INSERT INTO `ey_region` VALUES ('10500', '新林区', '3', '10483', 'X');
INSERT INTO `ey_region` VALUES ('10509', '呼中区', '3', '10483', 'H');
INSERT INTO `ey_region` VALUES ('10515', '呼玛县', '3', '10483', 'H');
INSERT INTO `ey_region` VALUES ('10525', '塔河县', '3', '10483', 'T');
INSERT INTO `ey_region` VALUES ('10534', '漠河县', '3', '10483', 'M');
INSERT INTO `ey_region` VALUES ('10543', '上海市', '1', '0', 'S');
INSERT INTO `ey_region` VALUES ('10544', '上海市', '2', '10543', 'S');
INSERT INTO `ey_region` VALUES ('10545', '黄浦区', '3', '10544', 'H');
INSERT INTO `ey_region` VALUES ('10555', '卢湾区', '3', '10544', 'L');
INSERT INTO `ey_region` VALUES ('10560', '徐汇区', '3', '10544', 'X');
INSERT INTO `ey_region` VALUES ('10575', '长宁区', '3', '10544', 'C');
INSERT INTO `ey_region` VALUES ('10586', '静安区', '3', '10544', 'J');
INSERT INTO `ey_region` VALUES ('10592', '普陀区', '3', '10544', 'P');
INSERT INTO `ey_region` VALUES ('10602', '闸北区', '3', '10544', 'Z');
INSERT INTO `ey_region` VALUES ('10612', '虹口区', '3', '10544', 'H');
INSERT INTO `ey_region` VALUES ('10623', '杨浦区', '3', '10544', 'Y');
INSERT INTO `ey_region` VALUES ('10636', '闵行区', '3', '10544', 'M');
INSERT INTO `ey_region` VALUES ('10650', '宝山区', '3', '10544', 'B');
INSERT INTO `ey_region` VALUES ('10664', '嘉定区', '3', '10544', 'J');
INSERT INTO `ey_region` VALUES ('10678', '浦东新区', '3', '10544', 'P');
INSERT INTO `ey_region` VALUES ('10704', '金山区', '3', '10544', 'J');
INSERT INTO `ey_region` VALUES ('10715', '松江区', '3', '10544', 'S');
INSERT INTO `ey_region` VALUES ('10735', '青浦区', '3', '10544', 'Q');
INSERT INTO `ey_region` VALUES ('10747', '南汇区', '3', '10544', 'N');
INSERT INTO `ey_region` VALUES ('10765', '奉贤区', '3', '10544', 'F');
INSERT INTO `ey_region` VALUES ('10780', '崇明区', '3', '10544', 'C');
INSERT INTO `ey_region` VALUES ('10808', '江苏省', '1', '0', 'J');
INSERT INTO `ey_region` VALUES ('10809', '南京市', '2', '10808', 'N');
INSERT INTO `ey_region` VALUES ('10810', '市辖区', '3', '10809', 'S');
INSERT INTO `ey_region` VALUES ('10811', '玄武区', '3', '10809', 'X');
INSERT INTO `ey_region` VALUES ('10820', '白下区', '3', '10809', 'B');
INSERT INTO `ey_region` VALUES ('10831', '秦淮区', '3', '10809', 'Q');
INSERT INTO `ey_region` VALUES ('10837', '建邺区', '3', '10809', 'J');
INSERT INTO `ey_region` VALUES ('10845', '鼓楼区', '3', '10809', 'G');
INSERT INTO `ey_region` VALUES ('10853', '下关区', '3', '10809', 'X');
INSERT INTO `ey_region` VALUES ('10860', '浦口区', '3', '10809', 'P');
INSERT INTO `ey_region` VALUES ('10876', '栖霞区', '3', '10809', 'Q');
INSERT INTO `ey_region` VALUES ('10894', '雨花台区', '3', '10809', 'Y');
INSERT INTO `ey_region` VALUES ('10903', '江宁区', '3', '10809', 'J');
INSERT INTO `ey_region` VALUES ('10916', '六合区', '3', '10809', 'L');
INSERT INTO `ey_region` VALUES ('10937', '溧水县', '3', '10809', 'L');
INSERT INTO `ey_region` VALUES ('10947', '高淳县', '3', '10809', 'G');
INSERT INTO `ey_region` VALUES ('10960', '无锡市', '2', '10808', 'W');
INSERT INTO `ey_region` VALUES ('10961', '新吴区', '3', '10960', 'X');
INSERT INTO `ey_region` VALUES ('10962', '梁溪区', '3', '10960', 'L');
INSERT INTO `ey_region` VALUES ('47973', '济源市', '2', '21387', 'J');
INSERT INTO `ey_region` VALUES ('47972', '龙港市', '3', '12974', 'L');
INSERT INTO `ey_region` VALUES ('10981', '锡山区', '3', '10960', 'X');
INSERT INTO `ey_region` VALUES ('10990', '惠山区', '3', '10960', 'H');
INSERT INTO `ey_region` VALUES ('10999', '滨湖区', '3', '10960', 'B');
INSERT INTO `ey_region` VALUES ('11018', '江阴市', '3', '10960', 'J');
INSERT INTO `ey_region` VALUES ('11039', '宜兴市', '3', '10960', 'Y');
INSERT INTO `ey_region` VALUES ('11067', '徐州市', '2', '10808', 'X');
INSERT INTO `ey_region` VALUES ('11068', '市辖区', '3', '11067', 'S');
INSERT INTO `ey_region` VALUES ('11069', '鼓楼区', '3', '11067', 'G');
INSERT INTO `ey_region` VALUES ('11081', '云龙区', '3', '11067', 'Y');
INSERT INTO `ey_region` VALUES ('11089', '九里区', '3', '11067', 'J');
INSERT INTO `ey_region` VALUES ('11103', '贾汪区', '3', '11067', 'J');
INSERT INTO `ey_region` VALUES ('11115', '泉山区', '3', '11067', 'Q');
INSERT INTO `ey_region` VALUES ('11126', '丰县', '3', '11067', 'F');
INSERT INTO `ey_region` VALUES ('11142', '沛县', '3', '11067', 'P');
INSERT INTO `ey_region` VALUES ('11160', '铜山县', '3', '11067', 'T');
INSERT INTO `ey_region` VALUES ('11182', '睢宁县', '3', '11067', 'S');
INSERT INTO `ey_region` VALUES ('11200', '新沂市', '3', '11067', 'X');
INSERT INTO `ey_region` VALUES ('11218', '邳州市', '3', '11067', 'P');
INSERT INTO `ey_region` VALUES ('11245', '常州市', '2', '10808', 'C');
INSERT INTO `ey_region` VALUES ('11246', '常州市区', '3', '11245', 'C');
INSERT INTO `ey_region` VALUES ('11247', '天宁区', '3', '11245', 'T');
INSERT INTO `ey_region` VALUES ('11254', '钟楼区', '3', '11245', 'Z');
INSERT INTO `ey_region` VALUES ('11262', '戚墅堰区', '3', '11245', 'Q');
INSERT INTO `ey_region` VALUES ('11266', '新北区', '3', '11245', 'X');
INSERT INTO `ey_region` VALUES ('11276', '武进区', '3', '11245', 'W');
INSERT INTO `ey_region` VALUES ('11311', '溧阳市', '3', '11245', 'L');
INSERT INTO `ey_region` VALUES ('11331', '金坛市', '3', '11245', 'J');
INSERT INTO `ey_region` VALUES ('11348', '苏州市', '2', '10808', 'S');
INSERT INTO `ey_region` VALUES ('11349', '市辖区', '3', '11348', 'S');
INSERT INTO `ey_region` VALUES ('11350', '沧浪区', '3', '11348', 'C');
INSERT INTO `ey_region` VALUES ('11357', '平江区', '3', '11348', 'P');
INSERT INTO `ey_region` VALUES ('11368', '金阊区', '3', '11348', 'J');
INSERT INTO `ey_region` VALUES ('11374', '苏州高新区虎丘区', '3', '11348', 'S');
INSERT INTO `ey_region` VALUES ('11387', '吴中区', '3', '11348', 'W');
INSERT INTO `ey_region` VALUES ('11409', '相城区', '3', '11348', 'X');
INSERT INTO `ey_region` VALUES ('11419', '常熟市', '3', '11348', 'C');
INSERT INTO `ey_region` VALUES ('11433', '张家港市', '3', '11348', 'Z');
INSERT INTO `ey_region` VALUES ('11448', '昆山市', '3', '11348', 'K');
INSERT INTO `ey_region` VALUES ('11460', '吴江市', '3', '11348', 'W');
INSERT INTO `ey_region` VALUES ('11472', '太仓市', '3', '11348', 'T');
INSERT INTO `ey_region` VALUES ('11482', '南通市', '2', '10808', 'N');
INSERT INTO `ey_region` VALUES ('11483', '市辖区', '3', '11482', 'S');
INSERT INTO `ey_region` VALUES ('11484', '崇川区', '3', '11482', 'C');
INSERT INTO `ey_region` VALUES ('11502', '港闸区', '3', '11482', 'G');
INSERT INTO `ey_region` VALUES ('11510', '海安县', '3', '11482', 'H');
INSERT INTO `ey_region` VALUES ('11526', '如东', '3', '11482', 'R');
INSERT INTO `ey_region` VALUES ('11542', '启东市', '3', '11482', 'Q');
INSERT INTO `ey_region` VALUES ('11568', '如皋市', '3', '11482', 'R');
INSERT INTO `ey_region` VALUES ('11600', '通州市', '3', '11482', 'T');
INSERT INTO `ey_region` VALUES ('11627', '海门市', '3', '11482', 'H');
INSERT INTO `ey_region` VALUES ('11663', '连云港市', '2', '10808', 'L');
INSERT INTO `ey_region` VALUES ('11664', '市辖区', '3', '11663', 'S');
INSERT INTO `ey_region` VALUES ('11665', '连云区', '3', '11663', 'L');
INSERT INTO `ey_region` VALUES ('11678', '新浦区', '3', '11663', 'X');
INSERT INTO `ey_region` VALUES ('11692', '海州区', '3', '11663', 'H');
INSERT INTO `ey_region` VALUES ('11699', '赣榆县', '3', '11663', 'G');
INSERT INTO `ey_region` VALUES ('11722', '东海县', '3', '11663', 'D');
INSERT INTO `ey_region` VALUES ('11747', '灌云县', '3', '11663', 'G');
INSERT INTO `ey_region` VALUES ('11771', '灌南县', '3', '11663', 'G');
INSERT INTO `ey_region` VALUES ('11786', '淮安市', '2', '10808', 'H');
INSERT INTO `ey_region` VALUES ('11787', '市辖区', '3', '11786', 'S');
INSERT INTO `ey_region` VALUES ('11788', '清河区', '3', '11786', 'Q');
INSERT INTO `ey_region` VALUES ('11801', '楚州区', '3', '11786', 'C');
INSERT INTO `ey_region` VALUES ('11830', '淮阴区', '3', '11786', 'H');
INSERT INTO `ey_region` VALUES ('11853', '清浦区', '3', '11786', 'Q');
INSERT INTO `ey_region` VALUES ('11863', '涟水县', '3', '11786', 'L');
INSERT INTO `ey_region` VALUES ('11896', '洪泽县', '3', '11786', 'H');
INSERT INTO `ey_region` VALUES ('11909', '盱眙县', '3', '11786', 'X');
INSERT INTO `ey_region` VALUES ('11931', '金湖县', '3', '11786', 'J');
INSERT INTO `ey_region` VALUES ('11947', '盐城市', '2', '10808', 'Y');
INSERT INTO `ey_region` VALUES ('11948', '市辖区', '3', '11947', 'S');
INSERT INTO `ey_region` VALUES ('11949', '亭湖区', '3', '11947', 'T');
INSERT INTO `ey_region` VALUES ('11967', '盐都区', '3', '11947', 'Y');
INSERT INTO `ey_region` VALUES ('11982', '响水县', '3', '11947', 'X');
INSERT INTO `ey_region` VALUES ('11998', '滨海县', '3', '11947', 'B');
INSERT INTO `ey_region` VALUES ('12017', '阜宁县', '3', '11947', 'F');
INSERT INTO `ey_region` VALUES ('12040', '射阳县', '3', '11947', 'S');
INSERT INTO `ey_region` VALUES ('12066', '建湖县', '3', '11947', 'J');
INSERT INTO `ey_region` VALUES ('12083', '东台市', '3', '11947', 'D');
INSERT INTO `ey_region` VALUES ('12117', '大丰市', '3', '11947', 'D');
INSERT INTO `ey_region` VALUES ('12135', '扬州市', '2', '10808', 'Y');
INSERT INTO `ey_region` VALUES ('12136', '市辖区', '3', '12135', 'S');
INSERT INTO `ey_region` VALUES ('12137', '广陵区', '3', '12135', 'G');
INSERT INTO `ey_region` VALUES ('12144', '邗江区', '3', '12135', 'H');
INSERT INTO `ey_region` VALUES ('12160', '维扬区', '3', '12135', 'W');
INSERT INTO `ey_region` VALUES ('12175', '宝应县', '3', '12135', 'B');
INSERT INTO `ey_region` VALUES ('12191', '仪征市', '3', '12135', 'Y');
INSERT INTO `ey_region` VALUES ('12212', '高邮市', '3', '12135', 'G');
INSERT INTO `ey_region` VALUES ('12235', '江都市', '3', '12135', 'J');
INSERT INTO `ey_region` VALUES ('12249', '镇江市', '2', '10808', 'Z');
INSERT INTO `ey_region` VALUES ('12250', '市区', '3', '12249', 'S');
INSERT INTO `ey_region` VALUES ('12251', '京口区', '3', '12249', 'J');
INSERT INTO `ey_region` VALUES ('12265', '润州区', '3', '12249', 'R');
INSERT INTO `ey_region` VALUES ('12273', '丹徒区', '3', '12249', 'D');
INSERT INTO `ey_region` VALUES ('12282', '丹阳市', '3', '12249', 'D');
INSERT INTO `ey_region` VALUES ('12300', '扬中市', '3', '12249', 'Y');
INSERT INTO `ey_region` VALUES ('12312', '句容市', '3', '12249', 'J');
INSERT INTO `ey_region` VALUES ('12343', '泰州市', '2', '10808', 'T');
INSERT INTO `ey_region` VALUES ('12344', '市辖区', '3', '12343', 'S');
INSERT INTO `ey_region` VALUES ('12345', '海陵区', '3', '12343', 'H');
INSERT INTO `ey_region` VALUES ('12362', '高港区', '3', '12343', 'G');
INSERT INTO `ey_region` VALUES ('12370', '兴化市', '3', '12343', 'X');
INSERT INTO `ey_region` VALUES ('12407', '靖江市', '3', '12343', 'J');
INSERT INTO `ey_region` VALUES ('12423', '泰兴市', '3', '12343', 'T');
INSERT INTO `ey_region` VALUES ('12450', '姜堰市', '3', '12343', 'J');
INSERT INTO `ey_region` VALUES ('12475', '宿迁市', '2', '10808', 'S');
INSERT INTO `ey_region` VALUES ('12476', '市辖区', '3', '12475', 'S');
INSERT INTO `ey_region` VALUES ('12477', '宿城区', '3', '12475', 'S');
INSERT INTO `ey_region` VALUES ('12496', '宿豫区', '3', '12475', 'S');
INSERT INTO `ey_region` VALUES ('12515', '沭阳县', '3', '12475', 'S');
INSERT INTO `ey_region` VALUES ('12551', '泗阳县', '3', '12475', 'S');
INSERT INTO `ey_region` VALUES ('12570', '泗洪县', '3', '12475', 'S');
INSERT INTO `ey_region` VALUES ('12596', '浙江省', '1', '0', 'Z');
INSERT INTO `ey_region` VALUES ('12597', '杭州市', '2', '12596', 'H');
INSERT INTO `ey_region` VALUES ('12598', '市辖区', '3', '12597', 'S');
INSERT INTO `ey_region` VALUES ('12599', '上城区', '3', '12597', 'S');
INSERT INTO `ey_region` VALUES ('12606', '下城区', '3', '12597', 'X');
INSERT INTO `ey_region` VALUES ('12615', '江干区', '3', '12597', 'J');
INSERT INTO `ey_region` VALUES ('12626', '拱墅区', '3', '12597', 'G');
INSERT INTO `ey_region` VALUES ('12637', '西湖区', '3', '12597', 'X');
INSERT INTO `ey_region` VALUES ('12652', '滨江区', '3', '12597', 'B');
INSERT INTO `ey_region` VALUES ('12656', '萧山区', '3', '12597', 'X');
INSERT INTO `ey_region` VALUES ('12685', '余杭区', '3', '12597', 'Y');
INSERT INTO `ey_region` VALUES ('12705', '桐庐县', '3', '12597', 'T');
INSERT INTO `ey_region` VALUES ('12719', '淳安县', '3', '12597', 'C');
INSERT INTO `ey_region` VALUES ('12743', '建德市', '3', '12597', 'J');
INSERT INTO `ey_region` VALUES ('12760', '富阳市', '3', '12597', 'F');
INSERT INTO `ey_region` VALUES ('12786', '临安市', '3', '12597', 'L');
INSERT INTO `ey_region` VALUES ('12813', '宁波市', '2', '12596', 'N');
INSERT INTO `ey_region` VALUES ('12814', '市辖区', '3', '12813', 'S');
INSERT INTO `ey_region` VALUES ('12815', '海曙区', '3', '12813', 'H');
INSERT INTO `ey_region` VALUES ('12824', '江东区', '3', '12813', 'J');
INSERT INTO `ey_region` VALUES ('12832', '江北区', '3', '12813', 'J');
INSERT INTO `ey_region` VALUES ('12841', '北仑区', '3', '12813', 'B');
INSERT INTO `ey_region` VALUES ('12851', '镇海区', '3', '12813', 'Z');
INSERT INTO `ey_region` VALUES ('12858', '鄞州区', '3', '12813', 'Y');
INSERT INTO `ey_region` VALUES ('12881', '象山县', '3', '12813', 'X');
INSERT INTO `ey_region` VALUES ('12900', '宁海县', '3', '12813', 'N');
INSERT INTO `ey_region` VALUES ('12919', '余姚市', '3', '12813', 'Y');
INSERT INTO `ey_region` VALUES ('12941', '慈溪市', '3', '12813', 'C');
INSERT INTO `ey_region` VALUES ('12962', '奉化市', '3', '12813', 'F');
INSERT INTO `ey_region` VALUES ('12974', '温州市', '2', '12596', 'W');
INSERT INTO `ey_region` VALUES ('12975', '市辖区', '3', '12974', 'S');
INSERT INTO `ey_region` VALUES ('12976', '鹿城区', '3', '12974', 'L');
INSERT INTO `ey_region` VALUES ('12998', '龙湾区', '3', '12974', 'L');
INSERT INTO `ey_region` VALUES ('13009', '瓯海区', '3', '12974', 'O');
INSERT INTO `ey_region` VALUES ('13023', '洞头县', '3', '12974', 'D');
INSERT INTO `ey_region` VALUES ('13030', '永嘉县', '3', '12974', 'Y');
INSERT INTO `ey_region` VALUES ('13069', '平阳县', '3', '12974', 'P');
INSERT INTO `ey_region` VALUES ('13101', '苍南县', '3', '12974', 'C');
INSERT INTO `ey_region` VALUES ('13138', '文成县', '3', '12974', 'W');
INSERT INTO `ey_region` VALUES ('13172', '泰顺县', '3', '12974', 'T');
INSERT INTO `ey_region` VALUES ('13209', '瑞安市', '3', '12974', 'R');
INSERT INTO `ey_region` VALUES ('13248', '乐清市', '3', '12974', 'L');
INSERT INTO `ey_region` VALUES ('13280', '嘉兴市', '2', '12596', 'J');
INSERT INTO `ey_region` VALUES ('13281', '市辖区', '3', '13280', 'S');
INSERT INTO `ey_region` VALUES ('13282', '南湖区', '3', '13280', 'N');
INSERT INTO `ey_region` VALUES ('13295', '秀洲区', '3', '13280', 'X');
INSERT INTO `ey_region` VALUES ('13304', '嘉善县', '3', '13280', 'J');
INSERT INTO `ey_region` VALUES ('13316', '海盐县', '3', '13280', 'H');
INSERT INTO `ey_region` VALUES ('13325', '海宁市', '3', '13280', 'H');
INSERT INTO `ey_region` VALUES ('13339', '平湖市', '3', '13280', 'P');
INSERT INTO `ey_region` VALUES ('13350', '桐乡市', '3', '13280', 'T');
INSERT INTO `ey_region` VALUES ('13364', '湖州市', '2', '12596', 'H');
INSERT INTO `ey_region` VALUES ('13365', '市辖区', '3', '13364', 'S');
INSERT INTO `ey_region` VALUES ('13366', '吴兴区', '3', '13364', 'W');
INSERT INTO `ey_region` VALUES ('13382', '南浔区', '3', '13364', 'N');
INSERT INTO `ey_region` VALUES ('13392', '德清县', '3', '13364', 'D');
INSERT INTO `ey_region` VALUES ('13404', '长兴县', '3', '13364', 'C');
INSERT INTO `ey_region` VALUES ('13421', '安吉县', '3', '13364', 'A');
INSERT INTO `ey_region` VALUES ('13437', '绍兴市', '2', '12596', 'S');
INSERT INTO `ey_region` VALUES ('13438', '市辖区', '3', '13437', 'S');
INSERT INTO `ey_region` VALUES ('13439', '越城区', '3', '13437', 'Y');
INSERT INTO `ey_region` VALUES ('13453', '绍兴县', '3', '13437', 'S');
INSERT INTO `ey_region` VALUES ('13473', '新昌县', '3', '13437', 'X');
INSERT INTO `ey_region` VALUES ('13490', '诸暨市', '3', '13437', 'Z');
INSERT INTO `ey_region` VALUES ('13518', '上虞市', '3', '13437', 'S');
INSERT INTO `ey_region` VALUES ('13542', '嵊州市', '3', '13437', 'S');
INSERT INTO `ey_region` VALUES ('13564', '金华市', '2', '12596', 'J');
INSERT INTO `ey_region` VALUES ('13565', '市辖区', '3', '13564', 'S');
INSERT INTO `ey_region` VALUES ('13566', '婺城区', '3', '13564', 'W');
INSERT INTO `ey_region` VALUES ('13594', '金东区', '3', '13564', 'J');
INSERT INTO `ey_region` VALUES ('13606', '武义县', '3', '13564', 'W');
INSERT INTO `ey_region` VALUES ('13625', '浦江县', '3', '13564', 'P');
INSERT INTO `ey_region` VALUES ('13641', '磐安县', '3', '13564', 'P');
INSERT INTO `ey_region` VALUES ('13662', '兰溪市', '3', '13564', 'L');
INSERT INTO `ey_region` VALUES ('13678', '义乌市', '3', '13564', 'Y');
INSERT INTO `ey_region` VALUES ('13692', '东阳市', '3', '13564', 'D');
INSERT INTO `ey_region` VALUES ('13711', '永康市', '3', '13564', 'Y');
INSERT INTO `ey_region` VALUES ('13726', '衢州市', '2', '12596', 'Q');
INSERT INTO `ey_region` VALUES ('13727', '市辖区', '3', '13726', 'S');
INSERT INTO `ey_region` VALUES ('13728', '柯城区', '3', '13726', 'K');
INSERT INTO `ey_region` VALUES ('13746', '衢江区', '3', '13726', 'Q');
INSERT INTO `ey_region` VALUES ('13768', '常山县', '3', '13726', 'C');
INSERT INTO `ey_region` VALUES ('13783', '开化县', '3', '13726', 'K');
INSERT INTO `ey_region` VALUES ('13802', '龙游县', '3', '13726', 'L');
INSERT INTO `ey_region` VALUES ('13818', '江山市', '3', '13726', 'J');
INSERT INTO `ey_region` VALUES ('13840', '舟山市', '2', '12596', 'Z');
INSERT INTO `ey_region` VALUES ('13841', '市辖区', '3', '13840', 'S');
INSERT INTO `ey_region` VALUES ('13842', '定海区', '3', '13840', 'D');
INSERT INTO `ey_region` VALUES ('13859', '普陀区', '3', '13840', 'P');
INSERT INTO `ey_region` VALUES ('13874', '岱山县', '3', '13840', 'D');
INSERT INTO `ey_region` VALUES ('13882', '嵊泗县', '3', '13840', 'S');
INSERT INTO `ey_region` VALUES ('13890', '台州市', '2', '12596', 'T');
INSERT INTO `ey_region` VALUES ('13891', '市辖区', '3', '13890', 'S');
INSERT INTO `ey_region` VALUES ('13892', '椒江区', '3', '13890', 'J');
INSERT INTO `ey_region` VALUES ('13903', '黄岩区', '3', '13890', 'H');
INSERT INTO `ey_region` VALUES ('13923', '路桥区', '3', '13890', 'L');
INSERT INTO `ey_region` VALUES ('13934', '玉环县', '3', '13890', 'Y');
INSERT INTO `ey_region` VALUES ('13944', '三门县', '3', '13890', 'S');
INSERT INTO `ey_region` VALUES ('13959', '天台县', '3', '13890', 'T');
INSERT INTO `ey_region` VALUES ('13975', '仙居县', '3', '13890', 'X');
INSERT INTO `ey_region` VALUES ('13996', '温岭市', '3', '13890', 'W');
INSERT INTO `ey_region` VALUES ('14013', '临海市', '3', '13890', 'L');
INSERT INTO `ey_region` VALUES ('14033', '丽水市', '2', '12596', 'L');
INSERT INTO `ey_region` VALUES ('14034', '市辖区', '3', '14033', 'S');
INSERT INTO `ey_region` VALUES ('14035', '莲都区', '3', '14033', 'L');
INSERT INTO `ey_region` VALUES ('14054', '青田县', '3', '14033', 'Q');
INSERT INTO `ey_region` VALUES ('14086', '缙云县', '3', '14033', 'J');
INSERT INTO `ey_region` VALUES ('14111', '遂昌县', '3', '14033', 'S');
INSERT INTO `ey_region` VALUES ('14132', '松阳县', '3', '14033', 'S');
INSERT INTO `ey_region` VALUES ('14153', '云和县', '3', '14033', 'Y');
INSERT INTO `ey_region` VALUES ('14168', '庆元县', '3', '14033', 'Q');
INSERT INTO `ey_region` VALUES ('14189', '景宁县', '3', '14033', 'J');
INSERT INTO `ey_region` VALUES ('14214', '龙泉市', '3', '14033', 'L');
INSERT INTO `ey_region` VALUES ('14234', '安徽省', '1', '0', 'A');
INSERT INTO `ey_region` VALUES ('14235', '合肥市', '2', '14234', 'H');
INSERT INTO `ey_region` VALUES ('14236', '市辖区', '3', '14235', 'S');
INSERT INTO `ey_region` VALUES ('14237', '瑶海区', '3', '14235', 'Y');
INSERT INTO `ey_region` VALUES ('14254', '庐阳区', '3', '14235', 'L');
INSERT INTO `ey_region` VALUES ('14269', '蜀山区', '3', '14235', 'S');
INSERT INTO `ey_region` VALUES ('14286', '包河区', '3', '14235', 'B');
INSERT INTO `ey_region` VALUES ('14297', '长丰县', '3', '14235', 'C');
INSERT INTO `ey_region` VALUES ('14314', '肥东县', '3', '14235', 'F');
INSERT INTO `ey_region` VALUES ('14334', '肥西县', '3', '14235', 'F');
INSERT INTO `ey_region` VALUES ('14351', '芜湖市', '2', '14234', 'W');
INSERT INTO `ey_region` VALUES ('14352', '市辖区', '3', '14351', 'S');
INSERT INTO `ey_region` VALUES ('14353', '镜湖区', '3', '14351', 'J');
INSERT INTO `ey_region` VALUES ('14366', '弋江区', '3', '14351', 'Y');
INSERT INTO `ey_region` VALUES ('14374', '鸠江区', '3', '14351', 'J');
INSERT INTO `ey_region` VALUES ('14382', '三山区', '3', '14351', 'S');
INSERT INTO `ey_region` VALUES ('14387', '芜湖县', '3', '14351', 'W');
INSERT INTO `ey_region` VALUES ('14394', '繁昌县', '3', '14351', 'F');
INSERT INTO `ey_region` VALUES ('14401', '南陵县', '3', '14351', 'N');
INSERT INTO `ey_region` VALUES ('14410', '蚌埠市', '2', '14234', 'B');
INSERT INTO `ey_region` VALUES ('14411', '市辖区', '3', '14410', 'S');
INSERT INTO `ey_region` VALUES ('14412', '龙子湖区', '3', '14410', 'L');
INSERT INTO `ey_region` VALUES ('14422', '蚌山区', '3', '14410', 'B');
INSERT INTO `ey_region` VALUES ('14434', '禹会区', '3', '14410', 'Y');
INSERT INTO `ey_region` VALUES ('14443', '淮上区', '3', '14410', 'H');
INSERT INTO `ey_region` VALUES ('14449', '怀远县', '3', '14410', 'H');
INSERT INTO `ey_region` VALUES ('14471', '五河县', '3', '14410', 'W');
INSERT INTO `ey_region` VALUES ('14487', '固镇县', '3', '14410', 'G');
INSERT INTO `ey_region` VALUES ('14500', '淮南市', '2', '14234', 'H');
INSERT INTO `ey_region` VALUES ('14501', '市辖区', '3', '14500', 'S');
INSERT INTO `ey_region` VALUES ('14502', '大通区', '3', '14500', 'D');
INSERT INTO `ey_region` VALUES ('14508', '田家庵区', '3', '14500', 'T');
INSERT INTO `ey_region` VALUES ('14523', '谢家集区', '3', '14500', 'X');
INSERT INTO `ey_region` VALUES ('14535', '八公山区', '3', '14500', 'B');
INSERT INTO `ey_region` VALUES ('14542', '潘集区', '3', '14500', 'P');
INSERT INTO `ey_region` VALUES ('14554', '凤台县', '3', '14500', 'F');
INSERT INTO `ey_region` VALUES ('14575', '马鞍山市', '2', '14234', 'M');
INSERT INTO `ey_region` VALUES ('14576', '市辖区', '3', '14575', 'S');
INSERT INTO `ey_region` VALUES ('14577', '金家庄区', '3', '14575', 'J');
INSERT INTO `ey_region` VALUES ('14583', '花山区', '3', '14575', 'H');
INSERT INTO `ey_region` VALUES ('14589', '雨山区', '3', '14575', 'Y');
INSERT INTO `ey_region` VALUES ('14597', '当涂县', '3', '14575', 'D');
INSERT INTO `ey_region` VALUES ('14612', '淮北市', '2', '14234', 'H');
INSERT INTO `ey_region` VALUES ('14613', '市辖区', '3', '14612', 'S');
INSERT INTO `ey_region` VALUES ('14614', '杜集区', '3', '14612', 'D');
INSERT INTO `ey_region` VALUES ('14620', '相山区', '3', '14612', 'X');
INSERT INTO `ey_region` VALUES ('14632', '烈山区', '3', '14612', 'L');
INSERT INTO `ey_region` VALUES ('14641', '濉溪县', '3', '14612', 'S');
INSERT INTO `ey_region` VALUES ('14653', '铜陵市', '2', '14234', 'T');
INSERT INTO `ey_region` VALUES ('14654', '市辖区', '3', '14653', 'S');
INSERT INTO `ey_region` VALUES ('14655', '铜官山区', '3', '14653', 'T');
INSERT INTO `ey_region` VALUES ('14663', '狮子山区', '3', '14653', 'S');
INSERT INTO `ey_region` VALUES ('14671', '铜陵市郊区', '3', '14653', 'T');
INSERT INTO `ey_region` VALUES ('14678', '铜陵县', '3', '14653', 'T');
INSERT INTO `ey_region` VALUES ('14687', '安庆市', '2', '14234', 'A');
INSERT INTO `ey_region` VALUES ('14688', '市辖区', '3', '14687', 'S');
INSERT INTO `ey_region` VALUES ('14689', '迎江区', '3', '14687', 'Y');
INSERT INTO `ey_region` VALUES ('14700', '大观区', '3', '14687', 'D');
INSERT INTO `ey_region` VALUES ('14712', '宜秀区', '3', '14687', 'Y');
INSERT INTO `ey_region` VALUES ('14720', '怀宁县', '3', '14687', 'H');
INSERT INTO `ey_region` VALUES ('14741', '枞阳县', '3', '14687', 'C');
INSERT INTO `ey_region` VALUES ('14764', '潜山县', '3', '14687', 'Q');
INSERT INTO `ey_region` VALUES ('14782', '太湖县', '3', '14687', 'T');
INSERT INTO `ey_region` VALUES ('14798', '宿松县', '3', '14687', 'S');
INSERT INTO `ey_region` VALUES ('14823', '望江县', '3', '14687', 'W');
INSERT INTO `ey_region` VALUES ('14834', '岳西县', '3', '14687', 'Y');
INSERT INTO `ey_region` VALUES ('14859', '桐城市', '3', '14687', 'T');
INSERT INTO `ey_region` VALUES ('14887', '黄山市', '2', '14234', 'H');
INSERT INTO `ey_region` VALUES ('14888', '市辖区', '3', '14887', 'S');
INSERT INTO `ey_region` VALUES ('14889', '屯溪区', '3', '14887', 'T');
INSERT INTO `ey_region` VALUES ('14900', '黄山区', '3', '14887', 'H');
INSERT INTO `ey_region` VALUES ('14917', '徽州区', '3', '14887', 'H');
INSERT INTO `ey_region` VALUES ('14926', '歙县', '3', '14887', 'S');
INSERT INTO `ey_region` VALUES ('14955', '休宁县', '3', '14887', 'X');
INSERT INTO `ey_region` VALUES ('14977', '黟县', '3', '14887', 'Y');
INSERT INTO `ey_region` VALUES ('14986', '祁门县', '3', '14887', 'Q');
INSERT INTO `ey_region` VALUES ('15005', '滁州市', '2', '14234', 'C');
INSERT INTO `ey_region` VALUES ('15006', '市辖区', '3', '15005', 'S');
INSERT INTO `ey_region` VALUES ('15007', '琅琊区', '3', '15005', 'L');
INSERT INTO `ey_region` VALUES ('15016', '南谯区', '3', '15005', 'N');
INSERT INTO `ey_region` VALUES ('15034', '来安县', '3', '15005', 'L');
INSERT INTO `ey_region` VALUES ('15053', '全椒县', '3', '15005', 'Q');
INSERT INTO `ey_region` VALUES ('15071', '定远县', '3', '15005', 'D');
INSERT INTO `ey_region` VALUES ('15109', '凤阳县', '3', '15005', 'F');
INSERT INTO `ey_region` VALUES ('15136', '天长市', '3', '15005', 'T');
INSERT INTO `ey_region` VALUES ('15166', '明光市', '3', '15005', 'M');
INSERT INTO `ey_region` VALUES ('15194', '阜阳市', '2', '14234', 'F');
INSERT INTO `ey_region` VALUES ('15195', '市辖区', '3', '15194', 'S');
INSERT INTO `ey_region` VALUES ('15196', '颍州区', '3', '15194', 'Y');
INSERT INTO `ey_region` VALUES ('15211', '颍东区', '3', '15194', 'Y');
INSERT INTO `ey_region` VALUES ('15224', '颍泉区', '3', '15194', 'Y');
INSERT INTO `ey_region` VALUES ('15231', '临泉县', '3', '15194', 'L');
INSERT INTO `ey_region` VALUES ('15264', '太和县', '3', '15194', 'T');
INSERT INTO `ey_region` VALUES ('15296', '阜南县', '3', '15194', 'F');
INSERT INTO `ey_region` VALUES ('15328', '颍上县', '3', '15194', 'Y');
INSERT INTO `ey_region` VALUES ('15359', '界首市', '3', '15194', 'J');
INSERT INTO `ey_region` VALUES ('15378', '宿州市', '2', '14234', 'S');
INSERT INTO `ey_region` VALUES ('15379', '市辖区', '3', '15378', 'S');
INSERT INTO `ey_region` VALUES ('15380', '墉桥区', '3', '15378', 'Y');
INSERT INTO `ey_region` VALUES ('15417', '砀山县', '3', '15378', 'D');
INSERT INTO `ey_region` VALUES ('15437', '萧县', '3', '15378', 'X');
INSERT INTO `ey_region` VALUES ('15461', '灵璧县', '3', '15378', 'L');
INSERT INTO `ey_region` VALUES ('15482', '泗县', '3', '15378', 'S');
INSERT INTO `ey_region` VALUES ('15499', '巢湖市', '2', '14234', 'C');
INSERT INTO `ey_region` VALUES ('15500', '市辖区', '3', '15499', 'S');
INSERT INTO `ey_region` VALUES ('15501', '居巢区', '3', '15499', 'J');
INSERT INTO `ey_region` VALUES ('15520', '庐江县', '3', '15499', 'L');
INSERT INTO `ey_region` VALUES ('15542', '无为县', '3', '15499', 'W');
INSERT INTO `ey_region` VALUES ('15566', '含山县', '3', '15499', 'H');
INSERT INTO `ey_region` VALUES ('15575', '和县', '3', '15499', 'H');
INSERT INTO `ey_region` VALUES ('15586', '六安市', '2', '14234', 'L');
INSERT INTO `ey_region` VALUES ('15587', '市辖区', '3', '15586', 'S');
INSERT INTO `ey_region` VALUES ('15588', '金安区', '3', '15586', 'J');
INSERT INTO `ey_region` VALUES ('15612', '裕安区', '3', '15586', 'Y');
INSERT INTO `ey_region` VALUES ('15635', '寿县', '3', '15586', 'S');
INSERT INTO `ey_region` VALUES ('15662', '霍邱县', '3', '15586', 'H');
INSERT INTO `ey_region` VALUES ('15698', '舒城县', '3', '15586', 'S');
INSERT INTO `ey_region` VALUES ('15720', '金寨县', '3', '15586', 'J');
INSERT INTO `ey_region` VALUES ('15747', '霍山县', '3', '15586', 'H');
INSERT INTO `ey_region` VALUES ('15764', '亳州市', '2', '14234', 'H');
INSERT INTO `ey_region` VALUES ('15765', '市辖区', '3', '15764', 'S');
INSERT INTO `ey_region` VALUES ('15766', '谯城区', '3', '15764', 'Q');
INSERT INTO `ey_region` VALUES ('15795', '涡阳县', '3', '15764', 'W');
INSERT INTO `ey_region` VALUES ('15823', '蒙城县', '3', '15764', 'M');
INSERT INTO `ey_region` VALUES ('15843', '利辛县', '3', '15764', 'L');
INSERT INTO `ey_region` VALUES ('15871', '池州市', '2', '14234', 'C');
INSERT INTO `ey_region` VALUES ('15872', '市辖区', '3', '15871', 'S');
INSERT INTO `ey_region` VALUES ('15873', '贵池区', '3', '15871', 'G');
INSERT INTO `ey_region` VALUES ('15900', '东至县', '3', '15871', 'D');
INSERT INTO `ey_region` VALUES ('15930', '石台县', '3', '15871', 'S');
INSERT INTO `ey_region` VALUES ('15944', '青阳县', '3', '15871', 'Q');
INSERT INTO `ey_region` VALUES ('15958', '宣城市', '2', '14234', 'X');
INSERT INTO `ey_region` VALUES ('15959', '市辖区', '3', '15958', 'S');
INSERT INTO `ey_region` VALUES ('15960', '宣州区', '3', '15958', 'X');
INSERT INTO `ey_region` VALUES ('15987', '郎溪县', '3', '15958', 'L');
INSERT INTO `ey_region` VALUES ('16001', '广德县', '3', '15958', 'G');
INSERT INTO `ey_region` VALUES ('16013', '泾县', '3', '15958', 'J');
INSERT INTO `ey_region` VALUES ('16025', '绩溪县', '3', '15958', 'J');
INSERT INTO `ey_region` VALUES ('16037', '旌德县', '3', '15958', 'J');
INSERT INTO `ey_region` VALUES ('16048', '宁国市', '3', '15958', 'N');
INSERT INTO `ey_region` VALUES ('16068', '福建省', '1', '0', 'F');
INSERT INTO `ey_region` VALUES ('16069', '福州市', '2', '16068', 'F');
INSERT INTO `ey_region` VALUES ('16070', '市辖区', '3', '16069', 'S');
INSERT INTO `ey_region` VALUES ('16071', '鼓楼区', '3', '16069', 'G');
INSERT INTO `ey_region` VALUES ('16082', '台江区', '3', '16069', 'T');
INSERT INTO `ey_region` VALUES ('16093', '仓山区', '3', '16069', 'C');
INSERT INTO `ey_region` VALUES ('16108', '马尾区', '3', '16069', 'M');
INSERT INTO `ey_region` VALUES ('16113', '晋安区', '3', '16069', 'J');
INSERT INTO `ey_region` VALUES ('16123', '闽侯县', '3', '16069', 'M');
INSERT INTO `ey_region` VALUES ('16140', '连江县', '3', '16069', 'L');
INSERT INTO `ey_region` VALUES ('16164', '罗源县', '3', '16069', 'L');
INSERT INTO `ey_region` VALUES ('16177', '闽清县', '3', '16069', 'M');
INSERT INTO `ey_region` VALUES ('16194', '永泰县', '3', '16069', 'Y');
INSERT INTO `ey_region` VALUES ('16216', '平潭县', '3', '16069', 'P');
INSERT INTO `ey_region` VALUES ('16232', '福清市', '3', '16069', 'F');
INSERT INTO `ey_region` VALUES ('16259', '长乐市', '3', '16069', 'C');
INSERT INTO `ey_region` VALUES ('16278', '厦门市', '2', '16068', 'X');
INSERT INTO `ey_region` VALUES ('16279', '市辖区', '3', '16278', 'S');
INSERT INTO `ey_region` VALUES ('16280', '思明区', '3', '16278', 'S');
INSERT INTO `ey_region` VALUES ('16294', '海沧区', '3', '16278', 'H');
INSERT INTO `ey_region` VALUES ('16303', '湖里区', '3', '16278', 'H');
INSERT INTO `ey_region` VALUES ('16315', '集美区', '3', '16278', 'J');
INSERT INTO `ey_region` VALUES ('16326', '同安区', '3', '16278', 'T');
INSERT INTO `ey_region` VALUES ('16341', '翔安区', '3', '16278', 'X');
INSERT INTO `ey_region` VALUES ('16348', '莆田市', '2', '16068', 'P');
INSERT INTO `ey_region` VALUES ('16349', '市辖区', '3', '16348', 'S');
INSERT INTO `ey_region` VALUES ('16350', '城厢区', '3', '16348', 'C');
INSERT INTO `ey_region` VALUES ('16358', '涵江区', '3', '16348', 'H');
INSERT INTO `ey_region` VALUES ('16372', '荔城区', '3', '16348', 'L');
INSERT INTO `ey_region` VALUES ('16379', '秀屿区', '3', '16348', 'X');
INSERT INTO `ey_region` VALUES ('16393', '仙游县', '3', '16348', 'X');
INSERT INTO `ey_region` VALUES ('16412', '三明市', '2', '16068', 'S');
INSERT INTO `ey_region` VALUES ('16413', '市辖区', '3', '16412', 'S');
INSERT INTO `ey_region` VALUES ('16414', '梅列区', '3', '16412', 'M');
INSERT INTO `ey_region` VALUES ('16421', '三元区', '3', '16412', 'S');
INSERT INTO `ey_region` VALUES ('16430', '明溪县', '3', '16412', 'M');
INSERT INTO `ey_region` VALUES ('16440', '清流县', '3', '16412', 'Q');
INSERT INTO `ey_region` VALUES ('16455', '宁化县', '3', '16412', 'N');
INSERT INTO `ey_region` VALUES ('16472', '大田县', '3', '16412', 'D');
INSERT INTO `ey_region` VALUES ('16492', '尤溪县', '3', '16412', 'Y');
INSERT INTO `ey_region` VALUES ('16508', '沙县', '3', '16412', 'S');
INSERT INTO `ey_region` VALUES ('16521', '将乐县', '3', '16412', 'J');
INSERT INTO `ey_region` VALUES ('16535', '泰宁县', '3', '16412', 'T');
INSERT INTO `ey_region` VALUES ('16545', '建宁县', '3', '16412', 'J');
INSERT INTO `ey_region` VALUES ('16556', '永安市', '3', '16412', 'Y');
INSERT INTO `ey_region` VALUES ('16572', '泉州市', '2', '16068', 'Q');
INSERT INTO `ey_region` VALUES ('16573', '市辖区', '3', '16572', 'S');
INSERT INTO `ey_region` VALUES ('16574', '鲤城区', '3', '16572', 'L');
INSERT INTO `ey_region` VALUES ('16584', '丰泽区', '3', '16572', 'F');
INSERT INTO `ey_region` VALUES ('16593', '洛江区', '3', '16572', 'L');
INSERT INTO `ey_region` VALUES ('16600', '泉港区', '3', '16572', 'Q');
INSERT INTO `ey_region` VALUES ('16608', '惠安县', '3', '16572', 'H');
INSERT INTO `ey_region` VALUES ('16625', '安溪县', '3', '16572', 'A');
INSERT INTO `ey_region` VALUES ('16650', '永春县', '3', '16572', 'Y');
INSERT INTO `ey_region` VALUES ('16673', '德化县', '3', '16572', 'D');
INSERT INTO `ey_region` VALUES ('16692', '金门县', '3', '16572', 'J');
INSERT INTO `ey_region` VALUES ('16693', '石狮市', '3', '16572', 'S');
INSERT INTO `ey_region` VALUES ('16703', '晋江市', '3', '16572', 'J');
INSERT INTO `ey_region` VALUES ('16726', '南安市', '3', '16572', 'N');
INSERT INTO `ey_region` VALUES ('16754', '漳州市', '2', '16068', 'Z');
INSERT INTO `ey_region` VALUES ('16755', '市辖区', '3', '16754', 'S');
INSERT INTO `ey_region` VALUES ('16756', '芗城区', '3', '16754', 'X');
INSERT INTO `ey_region` VALUES ('16772', '龙文区', '3', '16754', 'L');
INSERT INTO `ey_region` VALUES ('16778', '云霄县', '3', '16754', 'Y');
INSERT INTO `ey_region` VALUES ('16790', '漳浦县', '3', '16754', 'Z');
INSERT INTO `ey_region` VALUES ('16821', '诏安县', '3', '16754', 'Z');
INSERT INTO `ey_region` VALUES ('16842', '长泰县', '3', '16754', 'C');
INSERT INTO `ey_region` VALUES ('16852', '东山县', '3', '16754', 'D');
INSERT INTO `ey_region` VALUES ('16860', '南靖县', '3', '16754', 'N');
INSERT INTO `ey_region` VALUES ('16872', '平和县', '3', '16754', 'P');
INSERT INTO `ey_region` VALUES ('16889', '华安县', '3', '16754', 'H');
INSERT INTO `ey_region` VALUES ('16899', '龙海市', '3', '16754', 'L');
INSERT INTO `ey_region` VALUES ('16924', '南平市', '2', '16068', 'N');
INSERT INTO `ey_region` VALUES ('16925', '市辖区', '3', '16924', 'S');
INSERT INTO `ey_region` VALUES ('16926', '延平区', '3', '16924', 'Y');
INSERT INTO `ey_region` VALUES ('16948', '顺昌县', '3', '16924', 'S');
INSERT INTO `ey_region` VALUES ('16961', '浦城县', '3', '16924', 'P');
INSERT INTO `ey_region` VALUES ('16982', '光泽县', '3', '16924', 'G');
INSERT INTO `ey_region` VALUES ('16991', '松溪县', '3', '16924', 'S');
INSERT INTO `ey_region` VALUES ('17001', '政和县', '3', '16924', 'Z');
INSERT INTO `ey_region` VALUES ('17012', '邵武市', '3', '16924', 'S');
INSERT INTO `ey_region` VALUES ('17033', '武夷山市', '3', '16924', 'W');
INSERT INTO `ey_region` VALUES ('17044', '建瓯市', '3', '16924', 'J');
INSERT INTO `ey_region` VALUES ('17063', '建阳市', '3', '16924', 'J');
INSERT INTO `ey_region` VALUES ('17077', '龙岩市', '2', '16068', 'L');
INSERT INTO `ey_region` VALUES ('17078', '市辖区', '3', '17077', 'S');
INSERT INTO `ey_region` VALUES ('17079', '新罗区', '3', '17077', 'X');
INSERT INTO `ey_region` VALUES ('17099', '长汀县', '3', '17077', 'C');
INSERT INTO `ey_region` VALUES ('17118', '永定县', '3', '17077', 'Y');
INSERT INTO `ey_region` VALUES ('17143', '上杭县', '3', '17077', 'S');
INSERT INTO `ey_region` VALUES ('17166', '武平县', '3', '17077', 'W');
INSERT INTO `ey_region` VALUES ('17184', '连城县', '3', '17077', 'L');
INSERT INTO `ey_region` VALUES ('17202', '漳平市', '3', '17077', 'Z');
INSERT INTO `ey_region` VALUES ('17219', '宁德市　', '2', '16068', 'N');
INSERT INTO `ey_region` VALUES ('17220', '市辖区', '3', '17219', 'S');
INSERT INTO `ey_region` VALUES ('17221', '蕉城区', '3', '17219', 'J');
INSERT INTO `ey_region` VALUES ('17239', '霞浦县', '3', '17219', 'X');
INSERT INTO `ey_region` VALUES ('17254', '古田县', '3', '17219', 'G');
INSERT INTO `ey_region` VALUES ('17269', '屏南县', '3', '17219', 'P');
INSERT INTO `ey_region` VALUES ('17281', '寿宁县', '3', '17219', 'S');
INSERT INTO `ey_region` VALUES ('17296', '周宁县', '3', '17219', 'Z');
INSERT INTO `ey_region` VALUES ('17306', '柘荣县', '3', '17219', 'Z');
INSERT INTO `ey_region` VALUES ('17316', '福安市', '3', '17219', 'F');
INSERT INTO `ey_region` VALUES ('17341', '福鼎市', '3', '17219', 'F');
INSERT INTO `ey_region` VALUES ('17359', '江西省', '1', '0', 'J');
INSERT INTO `ey_region` VALUES ('17360', '南昌市', '2', '17359', 'N');
INSERT INTO `ey_region` VALUES ('17361', '市辖区', '3', '17360', 'S');
INSERT INTO `ey_region` VALUES ('17362', '东湖区', '3', '17360', 'D');
INSERT INTO `ey_region` VALUES ('17374', '西湖区', '3', '17360', 'X');
INSERT INTO `ey_region` VALUES ('17387', '青云谱区', '3', '17360', 'Q');
INSERT INTO `ey_region` VALUES ('17395', '湾里区', '3', '17360', 'W');
INSERT INTO `ey_region` VALUES ('17402', '青山湖区', '3', '17360', 'Q');
INSERT INTO `ey_region` VALUES ('17420', '南昌县', '3', '17360', 'N');
INSERT INTO `ey_region` VALUES ('17443', '新建县', '3', '17360', 'X');
INSERT INTO `ey_region` VALUES ('17471', '安义县', '3', '17360', 'A');
INSERT INTO `ey_region` VALUES ('17485', '进贤县', '3', '17360', 'J');
INSERT INTO `ey_region` VALUES ('17508', '景德镇市', '2', '17359', 'J');
INSERT INTO `ey_region` VALUES ('17509', '市辖区', '3', '17508', 'S');
INSERT INTO `ey_region` VALUES ('17510', '昌江区', '3', '17508', 'C');
INSERT INTO `ey_region` VALUES ('17534', '珠山区', '3', '17508', 'Z');
INSERT INTO `ey_region` VALUES ('17545', '浮梁县', '3', '17508', 'F');
INSERT INTO `ey_region` VALUES ('17568', '乐平市', '3', '17508', 'L');
INSERT INTO `ey_region` VALUES ('17589', '萍乡市', '2', '17359', 'P');
INSERT INTO `ey_region` VALUES ('17590', '市辖区', '3', '17589', 'S');
INSERT INTO `ey_region` VALUES ('17591', '安源区', '3', '17589', 'A');
INSERT INTO `ey_region` VALUES ('17604', '湘东区', '3', '17589', 'X');
INSERT INTO `ey_region` VALUES ('17616', '莲花县', '3', '17589', 'L');
INSERT INTO `ey_region` VALUES ('17630', '上栗县', '3', '17589', 'S');
INSERT INTO `ey_region` VALUES ('17640', '芦溪县', '3', '17589', 'L');
INSERT INTO `ey_region` VALUES ('17651', '九江市', '2', '17359', 'J');
INSERT INTO `ey_region` VALUES ('17652', '市辖区', '3', '17651', 'S');
INSERT INTO `ey_region` VALUES ('17653', '庐山区', '3', '17651', 'L');
INSERT INTO `ey_region` VALUES ('17667', '浔阳区', '3', '17651', 'X');
INSERT INTO `ey_region` VALUES ('17676', '九江县', '3', '17651', 'J');
INSERT INTO `ey_region` VALUES ('17693', '武宁县', '3', '17651', 'W');
INSERT INTO `ey_region` VALUES ('17714', '修水县', '3', '17651', 'X');
INSERT INTO `ey_region` VALUES ('17751', '永修县', '3', '17651', 'Y');
INSERT INTO `ey_region` VALUES ('17773', '德安县', '3', '17651', 'D');
INSERT INTO `ey_region` VALUES ('17792', '星子县', '3', '17651', 'X');
INSERT INTO `ey_region` VALUES ('17807', '都昌县', '3', '17651', 'D');
INSERT INTO `ey_region` VALUES ('17834', '湖口县', '3', '17651', 'H');
INSERT INTO `ey_region` VALUES ('17849', '彭泽县', '3', '17651', 'P');
INSERT INTO `ey_region` VALUES ('17872', '瑞昌市', '3', '17651', 'R');
INSERT INTO `ey_region` VALUES ('17894', '新余市', '2', '17359', 'X');
INSERT INTO `ey_region` VALUES ('17895', '市辖区', '3', '17894', 'S');
INSERT INTO `ey_region` VALUES ('17896', '渝水区', '3', '17894', 'Y');
INSERT INTO `ey_region` VALUES ('17917', '分宜县', '3', '17894', 'F');
INSERT INTO `ey_region` VALUES ('17934', '鹰潭市', '2', '17359', 'Y');
INSERT INTO `ey_region` VALUES ('17935', '市辖区', '3', '17934', 'S');
INSERT INTO `ey_region` VALUES ('17936', '月湖区', '3', '17934', 'Y');
INSERT INTO `ey_region` VALUES ('17945', '余江县', '3', '17934', 'Y');
INSERT INTO `ey_region` VALUES ('17966', '贵溪市', '3', '17934', 'G');
INSERT INTO `ey_region` VALUES ('17999', '赣州市', '2', '17359', 'G');
INSERT INTO `ey_region` VALUES ('18000', '市辖区', '3', '17999', 'S');
INSERT INTO `ey_region` VALUES ('18001', '章贡区', '3', '17999', 'Z');
INSERT INTO `ey_region` VALUES ('18016', '赣县', '3', '17999', 'G');
INSERT INTO `ey_region` VALUES ('18037', '信丰县', '3', '17999', 'X');
INSERT INTO `ey_region` VALUES ('18055', '大余县', '3', '17999', 'D');
INSERT INTO `ey_region` VALUES ('18068', '上犹县', '3', '17999', 'S');
INSERT INTO `ey_region` VALUES ('18084', '崇义县', '3', '17999', 'C');
INSERT INTO `ey_region` VALUES ('18102', '安远县', '3', '17999', 'A');
INSERT INTO `ey_region` VALUES ('18122', '龙南县', '3', '17999', 'L');
INSERT INTO `ey_region` VALUES ('18139', '定南县', '3', '17999', 'D');
INSERT INTO `ey_region` VALUES ('18148', '全南县', '3', '17999', 'Q');
INSERT INTO `ey_region` VALUES ('18161', '宁都县', '3', '17999', 'N');
INSERT INTO `ey_region` VALUES ('18187', '于都县', '3', '17999', 'Y');
INSERT INTO `ey_region` VALUES ('18212', '兴国县', '3', '17999', 'X');
INSERT INTO `ey_region` VALUES ('18239', '会昌县', '3', '17999', 'H');
INSERT INTO `ey_region` VALUES ('18260', '寻乌县', '3', '17999', 'X');
INSERT INTO `ey_region` VALUES ('18276', '石城县', '3', '17999', 'S');
INSERT INTO `ey_region` VALUES ('18287', '瑞金市', '3', '17999', 'R');
INSERT INTO `ey_region` VALUES ('18306', '南康市', '3', '17999', 'N');
INSERT INTO `ey_region` VALUES ('18330', '吉安市', '2', '17359', 'J');
INSERT INTO `ey_region` VALUES ('18331', '市辖区', '3', '18330', 'S');
INSERT INTO `ey_region` VALUES ('18332', '吉州区', '3', '18330', 'J');
INSERT INTO `ey_region` VALUES ('18345', '青原区', '3', '18330', 'Q');
INSERT INTO `ey_region` VALUES ('18356', '吉安县', '3', '18330', 'J');
INSERT INTO `ey_region` VALUES ('18378', '吉水县', '3', '18330', 'J');
INSERT INTO `ey_region` VALUES ('18398', '峡江县', '3', '18330', 'X');
INSERT INTO `ey_region` VALUES ('18411', '新干县', '3', '18330', 'X');
INSERT INTO `ey_region` VALUES ('18429', '永丰县', '3', '18330', 'Y');
INSERT INTO `ey_region` VALUES ('18454', '泰和县', '3', '18330', 'T');
INSERT INTO `ey_region` VALUES ('18483', '遂川县', '3', '18330', 'S');
INSERT INTO `ey_region` VALUES ('18510', '万安县', '3', '18330', 'W');
INSERT INTO `ey_region` VALUES ('18529', '安福县', '3', '18330', 'A');
INSERT INTO `ey_region` VALUES ('18550', '永新县', '3', '18330', 'Y');
INSERT INTO `ey_region` VALUES ('18575', '井冈山市', '3', '18330', 'J');
INSERT INTO `ey_region` VALUES ('18598', '宜春市', '2', '17359', 'Y');
INSERT INTO `ey_region` VALUES ('18599', '市辖区', '3', '18598', 'S');
INSERT INTO `ey_region` VALUES ('18600', '袁州区', '3', '18598', 'Y');
INSERT INTO `ey_region` VALUES ('18639', '奉新县', '3', '18598', 'F');
INSERT INTO `ey_region` VALUES ('18659', '万载县', '3', '18598', 'W');
INSERT INTO `ey_region` VALUES ('18678', '上高县', '3', '18598', 'S');
INSERT INTO `ey_region` VALUES ('18696', '宜丰县', '3', '18598', 'Y');
INSERT INTO `ey_region` VALUES ('18714', '靖安县', '3', '18598', 'J');
INSERT INTO `ey_region` VALUES ('18727', '铜鼓县', '3', '18598', 'T');
INSERT INTO `ey_region` VALUES ('18741', '丰城市', '3', '18598', 'F');
INSERT INTO `ey_region` VALUES ('18777', '樟树市', '3', '18598', 'Z');
INSERT INTO `ey_region` VALUES ('18799', '高安市', '3', '18598', 'G');
INSERT INTO `ey_region` VALUES ('18829', '抚州市', '2', '17359', 'F');
INSERT INTO `ey_region` VALUES ('18830', '市辖区', '3', '18829', 'S');
INSERT INTO `ey_region` VALUES ('18831', '临川区', '3', '18829', 'L');
INSERT INTO `ey_region` VALUES ('18869', '南城县', '3', '18829', 'N');
INSERT INTO `ey_region` VALUES ('18882', '黎川县', '3', '18829', 'L');
INSERT INTO `ey_region` VALUES ('18900', '南丰县', '3', '18829', 'N');
INSERT INTO `ey_region` VALUES ('18915', '崇仁县', '3', '18829', 'C');
INSERT INTO `ey_region` VALUES ('18931', '乐安县', '3', '18829', 'L');
INSERT INTO `ey_region` VALUES ('18949', '宜黄县', '3', '18829', 'Y');
INSERT INTO `ey_region` VALUES ('18965', '金溪县', '3', '18829', 'J');
INSERT INTO `ey_region` VALUES ('18980', '资溪县', '3', '18829', 'Z');
INSERT INTO `ey_region` VALUES ('18988', '东乡县', '3', '18829', 'D');
INSERT INTO `ey_region` VALUES ('19010', '广昌县', '3', '18829', 'G');
INSERT INTO `ey_region` VALUES ('19024', '上饶市', '2', '17359', 'S');
INSERT INTO `ey_region` VALUES ('19025', '市辖区', '3', '19024', 'S');
INSERT INTO `ey_region` VALUES ('19026', '信州区', '3', '19024', 'X');
INSERT INTO `ey_region` VALUES ('19038', '上饶县', '3', '19024', 'S');
INSERT INTO `ey_region` VALUES ('19062', '广丰县', '3', '19024', 'G');
INSERT INTO `ey_region` VALUES ('19088', '玉山县', '3', '19024', 'Y');
INSERT INTO `ey_region` VALUES ('19108', '铅山县', '3', '19024', 'Q');
INSERT INTO `ey_region` VALUES ('19136', '横峰县', '3', '19024', 'H');
INSERT INTO `ey_region` VALUES ('19151', '弋阳县', '3', '19024', 'Y');
INSERT INTO `ey_region` VALUES ('19171', '余干县', '3', '19024', 'Y');
INSERT INTO `ey_region` VALUES ('19202', '鄱阳县', '3', '19024', 'P');
INSERT INTO `ey_region` VALUES ('19234', '万年县', '3', '19024', 'W');
INSERT INTO `ey_region` VALUES ('19248', '婺源县', '3', '19024', 'W');
INSERT INTO `ey_region` VALUES ('19265', '德兴市', '3', '19024', 'D');
INSERT INTO `ey_region` VALUES ('19280', '山东省', '1', '0', 'S');
INSERT INTO `ey_region` VALUES ('19281', '济南市', '2', '19280', 'J');
INSERT INTO `ey_region` VALUES ('19282', '市辖区', '3', '19281', 'S');
INSERT INTO `ey_region` VALUES ('19283', '历下区', '3', '19281', 'L');
INSERT INTO `ey_region` VALUES ('19295', '市中区', '3', '19281', 'S');
INSERT INTO `ey_region` VALUES ('19311', '槐荫区', '3', '19281', 'H');
INSERT INTO `ey_region` VALUES ('19326', '天桥区', '3', '19281', 'T');
INSERT INTO `ey_region` VALUES ('19342', '历城区', '3', '19281', 'L');
INSERT INTO `ey_region` VALUES ('19359', '长清区', '3', '19281', 'C');
INSERT INTO `ey_region` VALUES ('19370', '平阴县', '3', '19281', 'P');
INSERT INTO `ey_region` VALUES ('19378', '济阳县', '3', '19281', 'J');
INSERT INTO `ey_region` VALUES ('19387', '商河县', '3', '19281', 'S');
INSERT INTO `ey_region` VALUES ('19400', '章丘市', '3', '19281', 'Z');
INSERT INTO `ey_region` VALUES ('19421', '青岛市', '2', '19280', 'Q');
INSERT INTO `ey_region` VALUES ('19422', '市辖区', '3', '19421', 'S');
INSERT INTO `ey_region` VALUES ('19423', '市南区', '3', '19421', 'S');
INSERT INTO `ey_region` VALUES ('19438', '市北区', '3', '19421', 'S');
INSERT INTO `ey_region` VALUES ('19456', '四方区', '3', '19421', 'S');
INSERT INTO `ey_region` VALUES ('19464', '黄岛区', '3', '19421', 'H');
INSERT INTO `ey_region` VALUES ('19471', '崂山区', '3', '19421', 'L');
INSERT INTO `ey_region` VALUES ('19476', '李沧区', '3', '19421', 'L');
INSERT INTO `ey_region` VALUES ('19488', '城阳区', '3', '19421', 'C');
INSERT INTO `ey_region` VALUES ('19497', '胶州市', '3', '19421', 'J');
INSERT INTO `ey_region` VALUES ('19516', '即墨市', '3', '19421', 'J');
INSERT INTO `ey_region` VALUES ('19540', '平度市', '3', '19421', 'P');
INSERT INTO `ey_region` VALUES ('19572', '胶南市', '3', '19421', 'J');
INSERT INTO `ey_region` VALUES ('19590', '莱西市', '3', '19421', 'L');
INSERT INTO `ey_region` VALUES ('19608', '淄博市', '2', '19280', 'Z');
INSERT INTO `ey_region` VALUES ('19609', '市辖区', '3', '19608', 'S');
INSERT INTO `ey_region` VALUES ('19610', '淄川区', '3', '19608', 'Z');
INSERT INTO `ey_region` VALUES ('19632', '张店区', '3', '19608', 'Z');
INSERT INTO `ey_region` VALUES ('19649', '博山区', '3', '19608', 'B');
INSERT INTO `ey_region` VALUES ('19663', '临淄区', '3', '19608', 'L');
INSERT INTO `ey_region` VALUES ('19678', '周村区', '3', '19608', 'Z');
INSERT INTO `ey_region` VALUES ('19688', '桓台县', '3', '19608', 'H');
INSERT INTO `ey_region` VALUES ('19700', '高青县', '3', '19608', 'G');
INSERT INTO `ey_region` VALUES ('19710', '沂源县', '3', '19608', 'Y');
INSERT INTO `ey_region` VALUES ('19724', '枣庄市', '2', '19280', 'Z');
INSERT INTO `ey_region` VALUES ('19725', '市辖区', '3', '19724', 'S');
INSERT INTO `ey_region` VALUES ('19726', '市中区', '3', '19724', 'S');
INSERT INTO `ey_region` VALUES ('19738', '薛城区', '3', '19724', 'X');
INSERT INTO `ey_region` VALUES ('19748', '峄城区', '3', '19724', 'Y');
INSERT INTO `ey_region` VALUES ('19756', '台儿庄区', '3', '19724', 'T');
INSERT INTO `ey_region` VALUES ('19763', '山亭区', '3', '19724', 'S');
INSERT INTO `ey_region` VALUES ('19774', '滕州市', '3', '19724', 'T');
INSERT INTO `ey_region` VALUES ('19796', '东营市', '2', '19280', 'D');
INSERT INTO `ey_region` VALUES ('19797', '市辖区', '3', '19796', 'S');
INSERT INTO `ey_region` VALUES ('19798', '东营区', '3', '19796', 'D');
INSERT INTO `ey_region` VALUES ('19809', '河口区', '3', '19796', 'H');
INSERT INTO `ey_region` VALUES ('19817', '垦利县', '3', '19796', 'K');
INSERT INTO `ey_region` VALUES ('19825', '利津县', '3', '19796', 'L');
INSERT INTO `ey_region` VALUES ('19835', '广饶县', '3', '19796', 'G');
INSERT INTO `ey_region` VALUES ('19846', '烟台市', '2', '19280', 'Y');
INSERT INTO `ey_region` VALUES ('19847', '市辖区', '3', '19846', 'S');
INSERT INTO `ey_region` VALUES ('19848', '芝罘区', '3', '19846', 'Z');
INSERT INTO `ey_region` VALUES ('19861', '福山区', '3', '19846', 'F');
INSERT INTO `ey_region` VALUES ('19873', '牟平区', '3', '19846', 'M');
INSERT INTO `ey_region` VALUES ('19887', '莱山区', '3', '19846', 'L');
INSERT INTO `ey_region` VALUES ('19893', '长岛县', '3', '19846', 'C');
INSERT INTO `ey_region` VALUES ('19902', '龙口市', '3', '19846', 'L');
INSERT INTO `ey_region` VALUES ('19916', '莱阳市', '3', '19846', 'L');
INSERT INTO `ey_region` VALUES ('19935', '莱州市', '3', '19846', 'L');
INSERT INTO `ey_region` VALUES ('19952', '蓬莱市', '3', '19846', 'P');
INSERT INTO `ey_region` VALUES ('19965', '招远市', '3', '19846', 'Z');
INSERT INTO `ey_region` VALUES ('19980', '栖霞市', '3', '19846', 'Q');
INSERT INTO `ey_region` VALUES ('19996', '海阳市', '3', '19846', 'H');
INSERT INTO `ey_region` VALUES ('20012', '潍坊市', '2', '19280', 'W');
INSERT INTO `ey_region` VALUES ('20013', '市辖区', '3', '20012', 'S');
INSERT INTO `ey_region` VALUES ('20014', '潍城区', '3', '20012', 'W');
INSERT INTO `ey_region` VALUES ('20023', '寒亭区', '3', '20012', 'H');
INSERT INTO `ey_region` VALUES ('20034', '坊子区', '3', '20012', 'F');
INSERT INTO `ey_region` VALUES ('20043', '奎文区', '3', '20012', 'K');
INSERT INTO `ey_region` VALUES ('20055', '临朐县', '3', '20012', 'L');
INSERT INTO `ey_region` VALUES ('20074', '昌乐县', '3', '20012', 'C');
INSERT INTO `ey_region` VALUES ('20091', '青州市', '3', '20012', 'Q');
INSERT INTO `ey_region` VALUES ('20113', '诸城市', '3', '20012', 'Z');
INSERT INTO `ey_region` VALUES ('20137', '寿光市', '3', '20012', 'S');
INSERT INTO `ey_region` VALUES ('20155', '安丘市', '3', '20012', 'A');
INSERT INTO `ey_region` VALUES ('20179', '高密市', '3', '20012', 'G');
INSERT INTO `ey_region` VALUES ('20200', '昌邑市', '3', '20012', 'C');
INSERT INTO `ey_region` VALUES ('20216', '济宁市', '2', '19280', 'J');
INSERT INTO `ey_region` VALUES ('20217', '市辖区', '3', '20216', 'S');
INSERT INTO `ey_region` VALUES ('20218', '市中区', '3', '20216', 'S');
INSERT INTO `ey_region` VALUES ('20227', '任城区', '3', '20216', 'R');
INSERT INTO `ey_region` VALUES ('20257', '鱼台县', '3', '20216', 'Y');
INSERT INTO `ey_region` VALUES ('20268', '金乡县', '3', '20216', 'J');
INSERT INTO `ey_region` VALUES ('20282', '嘉祥县', '3', '20216', 'J');
INSERT INTO `ey_region` VALUES ('20298', '汶上县', '3', '20216', 'W');
INSERT INTO `ey_region` VALUES ('20313', '泗水县', '3', '20216', 'S');
INSERT INTO `ey_region` VALUES ('20327', '梁山县', '3', '20216', 'L');
INSERT INTO `ey_region` VALUES ('20342', '曲阜市', '3', '20216', 'Q');
INSERT INTO `ey_region` VALUES ('20355', '兖州市', '3', '20216', 'Y');
INSERT INTO `ey_region` VALUES ('20368', '邹城市', '3', '20216', 'Z');
INSERT INTO `ey_region` VALUES ('20386', '泰安市', '2', '19280', 'T');
INSERT INTO `ey_region` VALUES ('20387', '市辖区', '3', '20386', 'S');
INSERT INTO `ey_region` VALUES ('20388', '泰山区', '3', '20386', 'T');
INSERT INTO `ey_region` VALUES ('20397', '岱岳区', '3', '20386', 'D');
INSERT INTO `ey_region` VALUES ('20416', '宁阳县', '3', '20386', 'N');
INSERT INTO `ey_region` VALUES ('20429', '东平县', '3', '20386', 'D');
INSERT INTO `ey_region` VALUES ('20444', '新泰市', '3', '20386', 'X');
INSERT INTO `ey_region` VALUES ('20465', '肥城市', '3', '20386', 'F');
INSERT INTO `ey_region` VALUES ('20480', '威海市', '2', '19280', 'W');
INSERT INTO `ey_region` VALUES ('20481', '市辖区', '3', '20480', 'S');
INSERT INTO `ey_region` VALUES ('20482', '环翠区', '3', '20480', 'H');
INSERT INTO `ey_region` VALUES ('20500', '文登市', '3', '20480', 'W');
INSERT INTO `ey_region` VALUES ('20519', '荣成市', '3', '20480', 'R');
INSERT INTO `ey_region` VALUES ('20542', '乳山市', '3', '20480', 'R');
INSERT INTO `ey_region` VALUES ('20558', '日照市', '2', '19280', 'R');
INSERT INTO `ey_region` VALUES ('20559', '市辖区', '3', '20558', 'S');
INSERT INTO `ey_region` VALUES ('20560', '东港区', '3', '20558', 'D');
INSERT INTO `ey_region` VALUES ('20573', '岚山区', '3', '20558', 'L');
INSERT INTO `ey_region` VALUES ('20583', '五莲县', '3', '20558', 'W');
INSERT INTO `ey_region` VALUES ('20596', '莒县', '3', '20558', 'J');
INSERT INTO `ey_region` VALUES ('20618', '莱芜市', '2', '19280', 'L');
INSERT INTO `ey_region` VALUES ('20619', '市辖区', '3', '20618', 'S');
INSERT INTO `ey_region` VALUES ('20620', '莱城区', '3', '20618', 'L');
INSERT INTO `ey_region` VALUES ('20636', '钢城区', '3', '20618', 'G');
INSERT INTO `ey_region` VALUES ('20642', '临沂市', '2', '19280', 'L');
INSERT INTO `ey_region` VALUES ('20643', '临沂市辖区', '3', '20642', 'L');
INSERT INTO `ey_region` VALUES ('20644', '兰山区', '3', '20642', 'L');
INSERT INTO `ey_region` VALUES ('20656', '罗庄区', '3', '20642', 'L');
INSERT INTO `ey_region` VALUES ('20665', '河东区', '3', '20642', 'H');
INSERT INTO `ey_region` VALUES ('20678', '沂南县', '3', '20642', 'Y');
INSERT INTO `ey_region` VALUES ('20696', '郯城县', '3', '20642', 'T');
INSERT INTO `ey_region` VALUES ('20714', '沂水县', '3', '20642', 'Y');
INSERT INTO `ey_region` VALUES ('20734', '苍山县', '3', '20642', 'C');
INSERT INTO `ey_region` VALUES ('20756', '费县', '3', '20642', 'F');
INSERT INTO `ey_region` VALUES ('20775', '平邑县', '3', '20642', 'P');
INSERT INTO `ey_region` VALUES ('20792', '莒南县', '3', '20642', 'J');
INSERT INTO `ey_region` VALUES ('20811', '蒙阴县', '3', '20642', 'M');
INSERT INTO `ey_region` VALUES ('20823', '临沭县', '3', '20642', 'L');
INSERT INTO `ey_region` VALUES ('20836', '德州市', '2', '19280', 'D');
INSERT INTO `ey_region` VALUES ('20837', '市辖区', '3', '20836', 'S');
INSERT INTO `ey_region` VALUES ('20838', '德城区', '3', '20836', 'D');
INSERT INTO `ey_region` VALUES ('20850', '陵县', '3', '20836', 'L');
INSERT INTO `ey_region` VALUES ('20864', '宁津县', '3', '20836', 'N');
INSERT INTO `ey_region` VALUES ('20876', '庆云县', '3', '20836', 'Q');
INSERT INTO `ey_region` VALUES ('20886', '临邑县', '3', '20836', 'L');
INSERT INTO `ey_region` VALUES ('20899', '齐河县', '3', '20836', 'Q');
INSERT INTO `ey_region` VALUES ('20914', '平原县', '3', '20836', 'P');
INSERT INTO `ey_region` VALUES ('20927', '夏津县', '3', '20836', 'X');
INSERT INTO `ey_region` VALUES ('20942', '武城县', '3', '20836', 'W');
INSERT INTO `ey_region` VALUES ('20952', '乐陵市', '3', '20836', 'L');
INSERT INTO `ey_region` VALUES ('20969', '禹城市', '3', '20836', 'Y');
INSERT INTO `ey_region` VALUES ('20981', '聊城市', '2', '19280', 'L');
INSERT INTO `ey_region` VALUES ('20982', '市辖区', '3', '20981', 'S');
INSERT INTO `ey_region` VALUES ('20983', '东昌府区', '3', '20981', 'D');
INSERT INTO `ey_region` VALUES ('21004', '阳谷县', '3', '20981', 'Y');
INSERT INTO `ey_region` VALUES ('21023', '莘县', '3', '20981', 'S');
INSERT INTO `ey_region` VALUES ('21046', '茌平县', '3', '20981', 'C');
INSERT INTO `ey_region` VALUES ('21063', '东阿县', '3', '20981', 'D');
INSERT INTO `ey_region` VALUES ('21075', '冠县', '3', '20981', 'G');
INSERT INTO `ey_region` VALUES ('21093', '高唐县', '3', '20981', 'G');
INSERT INTO `ey_region` VALUES ('21106', '临清市', '3', '20981', 'L');
INSERT INTO `ey_region` VALUES ('21123', '滨州市', '2', '19280', 'B');
INSERT INTO `ey_region` VALUES ('21124', '市辖区', '3', '21123', 'S');
INSERT INTO `ey_region` VALUES ('21125', '滨城区', '3', '21123', 'B');
INSERT INTO `ey_region` VALUES ('21141', '惠民县', '3', '21123', 'H');
INSERT INTO `ey_region` VALUES ('21156', '阳信县', '3', '21123', 'Y');
INSERT INTO `ey_region` VALUES ('21166', '无棣县', '3', '21123', 'W');
INSERT INTO `ey_region` VALUES ('21178', '沾化县', '3', '21123', 'Z');
INSERT INTO `ey_region` VALUES ('21190', '博兴县', '3', '21123', 'B');
INSERT INTO `ey_region` VALUES ('21201', '邹平县', '3', '21123', 'Z');
INSERT INTO `ey_region` VALUES ('21218', '菏泽市', '2', '19280', 'H');
INSERT INTO `ey_region` VALUES ('21219', '市辖区', '3', '21218', 'S');
INSERT INTO `ey_region` VALUES ('21220', '牡丹区', '3', '21218', 'M');
INSERT INTO `ey_region` VALUES ('21245', '曹县', '3', '21218', 'C');
INSERT INTO `ey_region` VALUES ('21271', '单县', '3', '21218', 'D');
INSERT INTO `ey_region` VALUES ('21292', '成武县', '3', '21218', 'C');
INSERT INTO `ey_region` VALUES ('21305', '巨野县', '3', '21218', 'J');
INSERT INTO `ey_region` VALUES ('21322', '郓城县', '3', '21218', 'Y');
INSERT INTO `ey_region` VALUES ('21344', '鄄城县', '3', '21218', 'J');
INSERT INTO `ey_region` VALUES ('21361', '定陶县', '3', '21218', 'D');
INSERT INTO `ey_region` VALUES ('21373', '东明县', '3', '21218', 'D');
INSERT INTO `ey_region` VALUES ('21387', '河南省', '1', '0', 'H');
INSERT INTO `ey_region` VALUES ('21388', '郑州市', '2', '21387', 'Z');
INSERT INTO `ey_region` VALUES ('21389', '市辖区', '3', '21388', 'S');
INSERT INTO `ey_region` VALUES ('21390', '中原区', '3', '21388', 'Z');
INSERT INTO `ey_region` VALUES ('21404', '二七区', '3', '21388', 'E');
INSERT INTO `ey_region` VALUES ('21420', '管城回族区', '3', '21388', 'G');
INSERT INTO `ey_region` VALUES ('21435', '金水区', '3', '21388', 'J');
INSERT INTO `ey_region` VALUES ('21453', '上街区', '3', '21388', 'S');
INSERT INTO `ey_region` VALUES ('21460', '惠济区', '3', '21388', 'H');
INSERT INTO `ey_region` VALUES ('21469', '中牟县', '3', '21388', 'Z');
INSERT INTO `ey_region` VALUES ('21487', '巩义市', '3', '21388', 'G');
INSERT INTO `ey_region` VALUES ('21508', '荥阳市', '3', '21388', 'X');
INSERT INTO `ey_region` VALUES ('21523', '新密市', '3', '21388', 'X');
INSERT INTO `ey_region` VALUES ('21542', '新郑市', '3', '21388', 'X');
INSERT INTO `ey_region` VALUES ('21558', '登封市', '3', '21388', 'D');
INSERT INTO `ey_region` VALUES ('21575', '开封市', '2', '21387', 'K');
INSERT INTO `ey_region` VALUES ('21576', '市辖区', '3', '21575', 'S');
INSERT INTO `ey_region` VALUES ('21577', '龙亭区', '3', '21575', 'L');
INSERT INTO `ey_region` VALUES ('21584', '顺河区', '3', '21575', 'S');
INSERT INTO `ey_region` VALUES ('21593', '鼓楼区', '3', '21575', 'G');
INSERT INTO `ey_region` VALUES ('21602', '禹王台区', '3', '21575', 'Y');
INSERT INTO `ey_region` VALUES ('21610', '金明区', '3', '21575', 'J');
INSERT INTO `ey_region` VALUES ('21618', '杞县', '3', '21575', 'Q');
INSERT INTO `ey_region` VALUES ('21640', '通许县', '3', '21575', 'T');
INSERT INTO `ey_region` VALUES ('21653', '尉氏县', '3', '21575', 'W');
INSERT INTO `ey_region` VALUES ('21671', '开封县', '3', '21575', 'K');
INSERT INTO `ey_region` VALUES ('21687', '兰考县', '3', '21575', 'L');
INSERT INTO `ey_region` VALUES ('21711', '洛阳市', '2', '21387', 'L');
INSERT INTO `ey_region` VALUES ('21712', '市辖区', '3', '21711', 'S');
INSERT INTO `ey_region` VALUES ('21713', '老城区', '3', '21711', 'L');
INSERT INTO `ey_region` VALUES ('21722', '西工区', '3', '21711', 'X');
INSERT INTO `ey_region` VALUES ('21733', '廛河回族区', '3', '21711', 'C');
INSERT INTO `ey_region` VALUES ('21742', '涧西区', '3', '21711', 'J');
INSERT INTO `ey_region` VALUES ('21758', '吉利区', '3', '21711', 'J');
INSERT INTO `ey_region` VALUES ('21761', '洛龙区', '3', '21711', 'L');
INSERT INTO `ey_region` VALUES ('21770', '孟津县', '3', '21711', 'M');
INSERT INTO `ey_region` VALUES ('21781', '新安县', '3', '21711', 'X');
INSERT INTO `ey_region` VALUES ('21794', '栾川县', '3', '21711', 'L');
INSERT INTO `ey_region` VALUES ('21809', '嵩县', '3', '21711', 'S');
INSERT INTO `ey_region` VALUES ('21829', '汝阳县', '3', '21711', 'R');
INSERT INTO `ey_region` VALUES ('21844', '宜阳县', '3', '21711', 'Y');
INSERT INTO `ey_region` VALUES ('21862', '洛宁县', '3', '21711', 'L');
INSERT INTO `ey_region` VALUES ('21881', '伊川县', '3', '21711', 'Y');
INSERT INTO `ey_region` VALUES ('21896', '偃师市', '3', '21711', 'Y');
INSERT INTO `ey_region` VALUES ('21913', '平顶山市', '2', '21387', 'P');
INSERT INTO `ey_region` VALUES ('21914', '市辖区', '3', '21913', 'S');
INSERT INTO `ey_region` VALUES ('21915', '新华区', '3', '21913', 'X');
INSERT INTO `ey_region` VALUES ('21928', '卫东区', '3', '21913', 'W');
INSERT INTO `ey_region` VALUES ('21940', '石龙区', '3', '21913', 'S');
INSERT INTO `ey_region` VALUES ('21945', '湛河区', '3', '21913', 'Z');
INSERT INTO `ey_region` VALUES ('21954', '宝丰县', '3', '21913', 'B');
INSERT INTO `ey_region` VALUES ('21968', '叶  县', '3', '21913', 'Y');
INSERT INTO `ey_region` VALUES ('21987', '鲁山县', '3', '21913', 'L');
INSERT INTO `ey_region` VALUES ('22009', '郏  县', '3', '21913', 'J');
INSERT INTO `ey_region` VALUES ('22024', '舞钢市', '3', '21913', 'W');
INSERT INTO `ey_region` VALUES ('22037', '汝州市', '3', '21913', 'R');
INSERT INTO `ey_region` VALUES ('22058', '安阳市', '2', '21387', 'A');
INSERT INTO `ey_region` VALUES ('22059', '市辖区', '3', '22058', 'S');
INSERT INTO `ey_region` VALUES ('22060', '文峰区', '3', '22058', 'W');
INSERT INTO `ey_region` VALUES ('22080', '北关区', '3', '22058', 'B');
INSERT INTO `ey_region` VALUES ('22090', '殷都区', '3', '22058', 'Y');
INSERT INTO `ey_region` VALUES ('22101', '龙安区', '3', '22058', 'L');
INSERT INTO `ey_region` VALUES ('22111', '安阳县', '3', '22058', 'A');
INSERT INTO `ey_region` VALUES ('22133', '汤阴县', '3', '22058', 'T');
INSERT INTO `ey_region` VALUES ('22144', '滑县', '3', '22058', 'H');
INSERT INTO `ey_region` VALUES ('22167', '内黄县', '3', '22058', 'N');
INSERT INTO `ey_region` VALUES ('22185', '林州市', '3', '22058', 'L');
INSERT INTO `ey_region` VALUES ('22206', '鹤壁市', '2', '21387', 'H');
INSERT INTO `ey_region` VALUES ('22207', '市辖区', '3', '22206', 'S');
INSERT INTO `ey_region` VALUES ('22208', '鹤山区', '3', '22206', 'H');
INSERT INTO `ey_region` VALUES ('22216', '山城区', '3', '22206', 'S');
INSERT INTO `ey_region` VALUES ('22224', '淇滨区', '3', '22206', 'Q');
INSERT INTO `ey_region` VALUES ('22232', '浚县', '3', '22206', 'J');
INSERT INTO `ey_region` VALUES ('22243', '淇县', '3', '22206', 'Q');
INSERT INTO `ey_region` VALUES ('22251', '新乡市', '2', '21387', 'X');
INSERT INTO `ey_region` VALUES ('22252', '市辖区', '3', '22251', 'S');
INSERT INTO `ey_region` VALUES ('22253', '红旗区', '3', '22251', 'H');
INSERT INTO `ey_region` VALUES ('22264', '卫滨区', '3', '22251', 'W');
INSERT INTO `ey_region` VALUES ('22273', '凤泉区', '3', '22251', 'F');
INSERT INTO `ey_region` VALUES ('22279', '牧野区', '3', '22251', 'M');
INSERT INTO `ey_region` VALUES ('22290', '新乡县', '3', '22251', 'X');
INSERT INTO `ey_region` VALUES ('22299', '获嘉县', '3', '22251', 'H');
INSERT INTO `ey_region` VALUES ('22312', '原阳县', '3', '22251', 'Y');
INSERT INTO `ey_region` VALUES ('22330', '延津县', '3', '22251', 'Y');
INSERT INTO `ey_region` VALUES ('22347', '封丘县', '3', '22251', 'F');
INSERT INTO `ey_region` VALUES ('22367', '长垣县', '3', '22251', 'C');
INSERT INTO `ey_region` VALUES ('22386', '卫辉市', '3', '22251', 'W');
INSERT INTO `ey_region` VALUES ('22400', '辉县市', '3', '22251', 'H');
INSERT INTO `ey_region` VALUES ('22423', '焦作市', '2', '21387', 'J');
INSERT INTO `ey_region` VALUES ('22424', '市辖区', '3', '22423', 'S');
INSERT INTO `ey_region` VALUES ('22425', '解放区', '3', '22423', 'J');
INSERT INTO `ey_region` VALUES ('22435', '中站区', '3', '22423', 'Z');
INSERT INTO `ey_region` VALUES ('22446', '马村区', '3', '22423', 'M');
INSERT INTO `ey_region` VALUES ('22454', '山阳区', '3', '22423', 'S');
INSERT INTO `ey_region` VALUES ('22465', '修武县', '3', '22423', 'X');
INSERT INTO `ey_region` VALUES ('22475', '博爱县', '3', '22423', 'B');
INSERT INTO `ey_region` VALUES ('22487', '武陟县', '3', '22423', 'W');
INSERT INTO `ey_region` VALUES ('22503', '温县', '3', '22423', 'W');
INSERT INTO `ey_region` VALUES ('22515', '济源市', '3', '22423', 'J');
INSERT INTO `ey_region` VALUES ('22532', '沁阳市', '3', '22423', 'Q');
INSERT INTO `ey_region` VALUES ('22546', '孟州市', '3', '22423', 'M');
INSERT INTO `ey_region` VALUES ('22558', '濮阳市', '2', '21387', 'P');
INSERT INTO `ey_region` VALUES ('22559', '市辖区', '3', '22558', 'S');
INSERT INTO `ey_region` VALUES ('22560', '华龙区', '3', '22558', 'H');
INSERT INTO `ey_region` VALUES ('22578', '清丰县', '3', '22558', 'Q');
INSERT INTO `ey_region` VALUES ('22596', '南乐县', '3', '22558', 'N');
INSERT INTO `ey_region` VALUES ('22609', '范县', '3', '22558', 'F');
INSERT INTO `ey_region` VALUES ('22622', '台前县', '3', '22558', 'T');
INSERT INTO `ey_region` VALUES ('22632', '濮阳县', '3', '22558', 'P');
INSERT INTO `ey_region` VALUES ('22655', '许昌市', '2', '21387', 'X');
INSERT INTO `ey_region` VALUES ('22656', '市辖区', '3', '22655', 'S');
INSERT INTO `ey_region` VALUES ('22657', '魏都区', '3', '22655', 'W');
INSERT INTO `ey_region` VALUES ('22671', '许昌县', '3', '22655', 'X');
INSERT INTO `ey_region` VALUES ('22688', '鄢陵县', '3', '22655', 'Y');
INSERT INTO `ey_region` VALUES ('22701', '襄城县', '3', '22655', 'X');
INSERT INTO `ey_region` VALUES ('22718', '禹州市', '3', '22655', 'Y');
INSERT INTO `ey_region` VALUES ('22745', '长葛市', '3', '22655', 'C');
INSERT INTO `ey_region` VALUES ('22762', '漯河市', '2', '21387', 'L');
INSERT INTO `ey_region` VALUES ('22763', '市辖区', '3', '22762', 'S');
INSERT INTO `ey_region` VALUES ('22764', '源汇区', '3', '22762', 'Y');
INSERT INTO `ey_region` VALUES ('22773', '郾城区', '3', '22762', 'Y');
INSERT INTO `ey_region` VALUES ('22783', '召陵区', '3', '22762', 'Z');
INSERT INTO `ey_region` VALUES ('22793', '舞阳县', '3', '22762', 'W');
INSERT INTO `ey_region` VALUES ('22808', '临颖县', '3', '22762', 'L');
INSERT INTO `ey_region` VALUES ('22824', '三门峡市', '2', '21387', 'S');
INSERT INTO `ey_region` VALUES ('22825', '市辖区', '3', '22824', 'S');
INSERT INTO `ey_region` VALUES ('22826', '湖滨区', '3', '22824', 'H');
INSERT INTO `ey_region` VALUES ('22838', '渑池县', '3', '22824', 'M');
INSERT INTO `ey_region` VALUES ('22851', '陕县', '3', '22824', 'S');
INSERT INTO `ey_region` VALUES ('22865', '卢氏县', '3', '22824', 'L');
INSERT INTO `ey_region` VALUES ('22885', '义马市', '3', '22824', 'Y');
INSERT INTO `ey_region` VALUES ('22893', '灵宝市', '3', '22824', 'L');
INSERT INTO `ey_region` VALUES ('22910', '南阳市', '2', '21387', 'N');
INSERT INTO `ey_region` VALUES ('22911', '市辖区', '3', '22910', 'S');
INSERT INTO `ey_region` VALUES ('22912', '宛城区', '3', '22910', 'W');
INSERT INTO `ey_region` VALUES ('22930', '卧龙区', '3', '22910', 'W');
INSERT INTO `ey_region` VALUES ('22951', '南召县', '3', '22910', 'N');
INSERT INTO `ey_region` VALUES ('22973', '方城县', '3', '22910', 'F');
INSERT INTO `ey_region` VALUES ('22992', '西峡县', '3', '22910', 'X');
INSERT INTO `ey_region` VALUES ('23013', '镇平县', '3', '22910', 'Z');
INSERT INTO `ey_region` VALUES ('23036', '内乡县', '3', '22910', 'N');
INSERT INTO `ey_region` VALUES ('23053', '淅川县', '3', '22910', 'X');
INSERT INTO `ey_region` VALUES ('23071', '社旗县', '3', '22910', 'S');
INSERT INTO `ey_region` VALUES ('23087', '唐河县', '3', '22910', 'T');
INSERT INTO `ey_region` VALUES ('23108', '新野县', '3', '22910', 'X');
INSERT INTO `ey_region` VALUES ('23123', '桐柏县', '3', '22910', 'T');
INSERT INTO `ey_region` VALUES ('23140', '邓州市', '3', '22910', 'D');
INSERT INTO `ey_region` VALUES ('23170', '商丘市', '2', '21387', 'S');
INSERT INTO `ey_region` VALUES ('23171', '市辖区', '3', '23170', 'S');
INSERT INTO `ey_region` VALUES ('23172', '梁园区', '3', '23170', 'L');
INSERT INTO `ey_region` VALUES ('23192', '睢阳区', '3', '23170', 'S');
INSERT INTO `ey_region` VALUES ('23211', '民权县', '3', '23170', 'M');
INSERT INTO `ey_region` VALUES ('23232', '睢县', '3', '23170', 'S');
INSERT INTO `ey_region` VALUES ('23253', '宁陵县', '3', '23170', 'N');
INSERT INTO `ey_region` VALUES ('23268', '柘城县', '3', '23170', 'Z');
INSERT INTO `ey_region` VALUES ('23290', '虞城县', '3', '23170', 'Y');
INSERT INTO `ey_region` VALUES ('23317', '夏邑县', '3', '23170', 'X');
INSERT INTO `ey_region` VALUES ('23342', '永城市', '3', '23170', 'Y');
INSERT INTO `ey_region` VALUES ('23372', '信阳市', '2', '21387', 'X');
INSERT INTO `ey_region` VALUES ('23373', '市辖区', '3', '23372', 'S');
INSERT INTO `ey_region` VALUES ('23374', '浉河区', '3', '23372', 'S');
INSERT INTO `ey_region` VALUES ('23393', '平桥区', '3', '23372', 'P');
INSERT INTO `ey_region` VALUES ('23414', '罗山县', '3', '23372', 'L');
INSERT INTO `ey_region` VALUES ('23435', '光山县', '3', '23372', 'G');
INSERT INTO `ey_region` VALUES ('23455', '新县', '3', '23372', 'X');
INSERT INTO `ey_region` VALUES ('23471', '商城县', '3', '23372', 'S');
INSERT INTO `ey_region` VALUES ('23492', '固始县', '3', '23372', 'G');
INSERT INTO `ey_region` VALUES ('23525', '潢川县', '3', '23372', 'H');
INSERT INTO `ey_region` VALUES ('23549', '淮滨县', '3', '23372', 'H');
INSERT INTO `ey_region` VALUES ('23567', '息县', '3', '23372', 'X');
INSERT INTO `ey_region` VALUES ('23589', '周口市', '2', '21387', 'Z');
INSERT INTO `ey_region` VALUES ('23590', '市辖区', '3', '23589', 'S');
INSERT INTO `ey_region` VALUES ('23591', '川汇区', '3', '23589', 'C');
INSERT INTO `ey_region` VALUES ('23604', '扶沟县', '3', '23589', 'F');
INSERT INTO `ey_region` VALUES ('23621', '西华县', '3', '23589', 'X');
INSERT INTO `ey_region` VALUES ('23647', '商水县', '3', '23589', 'S');
INSERT INTO `ey_region` VALUES ('23672', '沈丘县', '3', '23589', 'S');
INSERT INTO `ey_region` VALUES ('23695', '郸城县', '3', '23589', 'D');
INSERT INTO `ey_region` VALUES ('23716', '淮阳县', '3', '23589', 'H');
INSERT INTO `ey_region` VALUES ('23736', '太康县', '3', '23589', 'T');
INSERT INTO `ey_region` VALUES ('23766', '鹿邑县', '3', '23589', 'L');
INSERT INTO `ey_region` VALUES ('23796', '项城市', '3', '23589', 'X');
INSERT INTO `ey_region` VALUES ('23818', '驻马店市', '2', '21387', 'Z');
INSERT INTO `ey_region` VALUES ('23819', '市辖区', '3', '23818', 'S');
INSERT INTO `ey_region` VALUES ('23820', '驿城区', '3', '23818', 'Y');
INSERT INTO `ey_region` VALUES ('23840', '西平县', '3', '23818', 'X');
INSERT INTO `ey_region` VALUES ('23861', '上蔡县', '3', '23818', 'S');
INSERT INTO `ey_region` VALUES ('23886', '平舆县', '3', '23818', 'P');
INSERT INTO `ey_region` VALUES ('23905', '正阳县', '3', '23818', 'Z');
INSERT INTO `ey_region` VALUES ('23926', '确山县', '3', '23818', 'Q');
INSERT INTO `ey_region` VALUES ('23940', '泌阳县', '3', '23818', 'M');
INSERT INTO `ey_region` VALUES ('23965', '汝南县', '3', '23818', 'R');
INSERT INTO `ey_region` VALUES ('23983', '遂平县', '3', '23818', 'S');
INSERT INTO `ey_region` VALUES ('23999', '新蔡县', '3', '23818', 'X');
INSERT INTO `ey_region` VALUES ('24022', '湖北省', '1', '0', 'H');
INSERT INTO `ey_region` VALUES ('24023', '武汉市', '2', '24022', 'W');
INSERT INTO `ey_region` VALUES ('24024', '市辖区', '3', '24023', 'S');
INSERT INTO `ey_region` VALUES ('24025', '江岸区', '3', '24023', 'J');
INSERT INTO `ey_region` VALUES ('24043', '江汉区', '3', '24023', 'J');
INSERT INTO `ey_region` VALUES ('24057', '硚口区', '3', '24023', 'Q');
INSERT INTO `ey_region` VALUES ('24069', '汉阳区', '3', '24023', 'H');
INSERT INTO `ey_region` VALUES ('24082', '武昌区', '3', '24023', 'W');
INSERT INTO `ey_region` VALUES ('24098', '青山区', '3', '24023', 'Q');
INSERT INTO `ey_region` VALUES ('24111', '洪山区', '3', '24023', 'H');
INSERT INTO `ey_region` VALUES ('24129', '东西湖区', '3', '24023', 'D');
INSERT INTO `ey_region` VALUES ('24142', '汉南区', '3', '24023', 'H');
INSERT INTO `ey_region` VALUES ('24150', '蔡甸区', '3', '24023', 'C');
INSERT INTO `ey_region` VALUES ('24165', '江夏区', '3', '24023', 'J');
INSERT INTO `ey_region` VALUES ('24185', '黄陂区', '3', '24023', 'H');
INSERT INTO `ey_region` VALUES ('24205', '武汉市新洲区', '3', '24023', 'W');
INSERT INTO `ey_region` VALUES ('24224', '黄石市', '2', '24022', 'H');
INSERT INTO `ey_region` VALUES ('24225', '市辖区', '3', '24224', 'S');
INSERT INTO `ey_region` VALUES ('24226', '黄石港区', '3', '24224', 'H');
INSERT INTO `ey_region` VALUES ('24233', '西塞山区', '3', '24224', 'X');
INSERT INTO `ey_region` VALUES ('24242', '下陆区', '3', '24224', 'X');
INSERT INTO `ey_region` VALUES ('24247', '铁山区', '3', '24224', 'T');
INSERT INTO `ey_region` VALUES ('24250', '阳新县', '3', '24224', 'Y');
INSERT INTO `ey_region` VALUES ('24273', '大冶市', '3', '24224', 'D');
INSERT INTO `ey_region` VALUES ('24291', '十堰市', '2', '24022', 'S');
INSERT INTO `ey_region` VALUES ('24292', '市辖区', '3', '24291', 'S');
INSERT INTO `ey_region` VALUES ('24293', '茅箭区', '3', '24291', 'M');
INSERT INTO `ey_region` VALUES ('24302', '张湾区', '3', '24291', 'Z');
INSERT INTO `ey_region` VALUES ('24314', '郧县', '3', '24291', 'Y');
INSERT INTO `ey_region` VALUES ('24335', '郧西县', '3', '24291', 'Y');
INSERT INTO `ey_region` VALUES ('24354', '竹山县', '3', '24291', 'Z');
INSERT INTO `ey_region` VALUES ('24374', '竹溪县', '3', '24291', 'Z');
INSERT INTO `ey_region` VALUES ('24405', '房县', '3', '24291', 'F');
INSERT INTO `ey_region` VALUES ('24435', '丹江口市', '3', '24291', 'D');
INSERT INTO `ey_region` VALUES ('24453', '宜昌市', '2', '24022', 'Y');
INSERT INTO `ey_region` VALUES ('24454', '市辖区', '3', '24453', 'S');
INSERT INTO `ey_region` VALUES ('24455', '西陵区', '3', '24453', 'X');
INSERT INTO `ey_region` VALUES ('24465', '伍家岗区', '3', '24453', 'W');
INSERT INTO `ey_region` VALUES ('24471', '点军区', '3', '24453', 'D');
INSERT INTO `ey_region` VALUES ('24477', '猇亭区', '3', '24453', 'X');
INSERT INTO `ey_region` VALUES ('24481', '夷陵区', '3', '24453', 'Y');
INSERT INTO `ey_region` VALUES ('24495', '远安县', '3', '24453', 'Y');
INSERT INTO `ey_region` VALUES ('24503', '兴山县', '3', '24453', 'X');
INSERT INTO `ey_region` VALUES ('24512', '秭归县', '3', '24453', 'Z');
INSERT INTO `ey_region` VALUES ('24525', '长阳县', '3', '24453', 'C');
INSERT INTO `ey_region` VALUES ('24537', '五峰县', '3', '24453', 'W');
INSERT INTO `ey_region` VALUES ('24546', '宜都市', '3', '24453', 'Y');
INSERT INTO `ey_region` VALUES ('24559', '当阳市', '3', '24453', 'D');
INSERT INTO `ey_region` VALUES ('24570', '枝江市', '3', '24453', 'Z');
INSERT INTO `ey_region` VALUES ('24580', '襄樊市', '2', '24022', 'X');
INSERT INTO `ey_region` VALUES ('24581', '市辖区', '3', '24580', 'S');
INSERT INTO `ey_region` VALUES ('24582', '襄城区', '3', '24580', 'X');
INSERT INTO `ey_region` VALUES ('24591', '樊城区', '3', '24580', 'F');
INSERT INTO `ey_region` VALUES ('24608', '襄阳区', '3', '24580', 'X');
INSERT INTO `ey_region` VALUES ('24623', '南漳县', '3', '24580', 'N');
INSERT INTO `ey_region` VALUES ('24635', '谷城县', '3', '24580', 'G');
INSERT INTO `ey_region` VALUES ('24647', '保康县', '3', '24580', 'B');
INSERT INTO `ey_region` VALUES ('24659', '老河口市', '3', '24580', 'L');
INSERT INTO `ey_region` VALUES ('24674', '枣阳市', '3', '24580', 'Z');
INSERT INTO `ey_region` VALUES ('24692', '宜城市', '3', '24580', 'Y');
INSERT INTO `ey_region` VALUES ('24706', '鄂州市', '2', '24022', 'E');
INSERT INTO `ey_region` VALUES ('24707', '市辖区', '3', '24706', 'S');
INSERT INTO `ey_region` VALUES ('24708', '粱子湖区', '3', '24706', 'L');
INSERT INTO `ey_region` VALUES ('24714', '华容区', '3', '24706', 'H');
INSERT INTO `ey_region` VALUES ('24722', '鄂城区', '3', '24706', 'E');
INSERT INTO `ey_region` VALUES ('24737', '荆门市', '2', '24022', 'J');
INSERT INTO `ey_region` VALUES ('24738', '市辖区', '3', '24737', 'S');
INSERT INTO `ey_region` VALUES ('24739', '东宝区', '3', '24737', 'D');
INSERT INTO `ey_region` VALUES ('24749', '掇刀区', '3', '24737', 'D');
INSERT INTO `ey_region` VALUES ('24755', '京山县', '3', '24737', 'J');
INSERT INTO `ey_region` VALUES ('24778', '沙洋县', '3', '24737', 'S');
INSERT INTO `ey_region` VALUES ('24794', '钟祥市', '3', '24737', 'Z');
INSERT INTO `ey_region` VALUES ('24816', '孝感市', '2', '24022', 'X');
INSERT INTO `ey_region` VALUES ('24817', '市辖区', '3', '24816', 'S');
INSERT INTO `ey_region` VALUES ('24818', '孝南区', '3', '24816', 'X');
INSERT INTO `ey_region` VALUES ('24838', '孝昌县', '3', '24816', 'X');
INSERT INTO `ey_region` VALUES ('24853', '大悟县', '3', '24816', 'D');
INSERT INTO `ey_region` VALUES ('24871', '云梦县', '3', '24816', 'Y');
INSERT INTO `ey_region` VALUES ('24885', '应城市', '3', '24816', 'Y');
INSERT INTO `ey_region` VALUES ('24903', '安陆市', '3', '24816', 'A');
INSERT INTO `ey_region` VALUES ('24920', '汉川市', '3', '24816', 'H');
INSERT INTO `ey_region` VALUES ('24949', '荆州市', '2', '24022', 'J');
INSERT INTO `ey_region` VALUES ('24950', '市辖区', '3', '24949', 'S');
INSERT INTO `ey_region` VALUES ('24951', '沙市区', '3', '24949', 'S');
INSERT INTO `ey_region` VALUES ('24965', '荆州区', '3', '24949', 'J');
INSERT INTO `ey_region` VALUES ('24978', '公安县', '3', '24949', 'G');
INSERT INTO `ey_region` VALUES ('24995', '监利县', '3', '24949', 'J');
INSERT INTO `ey_region` VALUES ('25019', '江陵县', '3', '24949', 'J');
INSERT INTO `ey_region` VALUES ('25032', '石首市', '3', '24949', 'S');
INSERT INTO `ey_region` VALUES ('25048', '洪湖市', '3', '24949', 'H');
INSERT INTO `ey_region` VALUES ('25069', '松滋市', '3', '24949', 'S');
INSERT INTO `ey_region` VALUES ('25086', '黄冈市', '2', '24022', 'H');
INSERT INTO `ey_region` VALUES ('25087', '市辖区', '3', '25086', 'S');
INSERT INTO `ey_region` VALUES ('25088', '黄州区', '3', '25086', 'H');
INSERT INTO `ey_region` VALUES ('25099', '团风县', '3', '25086', 'T');
INSERT INTO `ey_region` VALUES ('25112', '红安县', '3', '25086', 'H');
INSERT INTO `ey_region` VALUES ('25126', '罗田县', '3', '25086', 'L');
INSERT INTO `ey_region` VALUES ('25143', '英山县', '3', '25086', 'Y');
INSERT INTO `ey_region` VALUES ('25158', '浠水县', '3', '25086', 'X');
INSERT INTO `ey_region` VALUES ('25175', '蕲春县', '3', '25086', 'Q');
INSERT INTO `ey_region` VALUES ('25192', '黄梅县', '3', '25086', 'H');
INSERT INTO `ey_region` VALUES ('25211', '麻城市', '3', '25086', 'M');
INSERT INTO `ey_region` VALUES ('25235', '武穴市', '3', '25086', 'W');
INSERT INTO `ey_region` VALUES ('25249', '咸宁市', '2', '24022', 'X');
INSERT INTO `ey_region` VALUES ('25250', '市辖区', '3', '25249', 'S');
INSERT INTO `ey_region` VALUES ('25251', '咸安区', '3', '25249', 'X');
INSERT INTO `ey_region` VALUES ('25266', '嘉鱼县', '3', '25249', 'J');
INSERT INTO `ey_region` VALUES ('25276', '通城县', '3', '25249', 'T');
INSERT INTO `ey_region` VALUES ('25290', '崇阳县', '3', '25249', 'C');
INSERT INTO `ey_region` VALUES ('25303', '通山县', '3', '25249', 'T');
INSERT INTO `ey_region` VALUES ('25317', '赤壁市', '3', '25249', 'C');
INSERT INTO `ey_region` VALUES ('25335', '随州市', '2', '24022', 'S');
INSERT INTO `ey_region` VALUES ('25336', '市辖区', '3', '25335', 'S');
INSERT INTO `ey_region` VALUES ('25337', '曾都区', '3', '25335', 'Z');
INSERT INTO `ey_region` VALUES ('25367', '广水市', '3', '25335', 'G');
INSERT INTO `ey_region` VALUES ('25388', '恩施州', '2', '24022', 'E');
INSERT INTO `ey_region` VALUES ('25389', '恩施市', '3', '25388', 'E');
INSERT INTO `ey_region` VALUES ('25406', '利川市', '3', '25388', 'L');
INSERT INTO `ey_region` VALUES ('25422', '建始县', '3', '25388', 'J');
INSERT INTO `ey_region` VALUES ('25433', '巴东县', '3', '25388', 'B');
INSERT INTO `ey_region` VALUES ('25446', '宣恩县', '3', '25388', 'X');
INSERT INTO `ey_region` VALUES ('25456', '咸丰县', '3', '25388', 'X');
INSERT INTO `ey_region` VALUES ('25467', '来凤县', '3', '25388', 'L');
INSERT INTO `ey_region` VALUES ('25476', '鹤峰县', '3', '25388', 'H');
INSERT INTO `ey_region` VALUES ('25487', '省直辖行政单位', '2', '24022', 'S');
INSERT INTO `ey_region` VALUES ('25488', '仙桃市', '3', '25487', 'X');
INSERT INTO `ey_region` VALUES ('25516', '潜江市', '3', '25487', 'Q');
INSERT INTO `ey_region` VALUES ('25541', '天门市', '3', '25487', 'T');
INSERT INTO `ey_region` VALUES ('25570', '神农架林区', '3', '25487', 'S');
INSERT INTO `ey_region` VALUES ('25579', '湖南省', '1', '0', 'H');
INSERT INTO `ey_region` VALUES ('25580', '长沙市', '2', '25579', 'C');
INSERT INTO `ey_region` VALUES ('25581', '市辖区', '3', '25580', 'S');
INSERT INTO `ey_region` VALUES ('25582', '芙蓉区', '3', '25580', 'F');
INSERT INTO `ey_region` VALUES ('25596', '天心区', '3', '25580', 'T');
INSERT INTO `ey_region` VALUES ('25607', '岳麓区', '3', '25580', 'Y');
INSERT INTO `ey_region` VALUES ('25620', '开福区', '3', '25580', 'K');
INSERT INTO `ey_region` VALUES ('25634', '雨花区', '3', '25580', 'Y');
INSERT INTO `ey_region` VALUES ('25645', '长沙县', '3', '25580', 'C');
INSERT INTO `ey_region` VALUES ('25666', '望城县', '3', '25580', 'W');
INSERT INTO `ey_region` VALUES ('25686', '宁乡县', '3', '25580', 'N');
INSERT INTO `ey_region` VALUES ('25720', '浏阳市', '3', '25580', 'L');
INSERT INTO `ey_region` VALUES ('25758', '株洲市', '2', '25579', 'Z');
INSERT INTO `ey_region` VALUES ('25759', '市辖区', '3', '25758', 'S');
INSERT INTO `ey_region` VALUES ('25760', '荷塘区', '3', '25758', 'H');
INSERT INTO `ey_region` VALUES ('25768', '芦淞区', '3', '25758', 'L');
INSERT INTO `ey_region` VALUES ('25777', '石峰区', '3', '25758', 'S');
INSERT INTO `ey_region` VALUES ('25785', '天元区', '3', '25758', 'T');
INSERT INTO `ey_region` VALUES ('25791', '株洲县', '3', '25758', 'Z');
INSERT INTO `ey_region` VALUES ('25810', '攸县', '3', '25758', 'Y');
INSERT INTO `ey_region` VALUES ('25836', '茶陵县', '3', '25758', 'C');
INSERT INTO `ey_region` VALUES ('25863', '炎陵县', '3', '25758', 'Y');
INSERT INTO `ey_region` VALUES ('25881', '醴陵市', '3', '25758', 'L');
INSERT INTO `ey_region` VALUES ('25912', '湘潭市', '2', '25579', 'X');
INSERT INTO `ey_region` VALUES ('25913', '市辖区', '3', '25912', 'S');
INSERT INTO `ey_region` VALUES ('25914', '雨湖区', '3', '25912', 'Y');
INSERT INTO `ey_region` VALUES ('25929', '岳塘区', '3', '25912', 'Y');
INSERT INTO `ey_region` VALUES ('25947', '湘潭县', '3', '25912', 'X');
INSERT INTO `ey_region` VALUES ('25970', '湘乡市', '3', '25912', 'X');
INSERT INTO `ey_region` VALUES ('25993', '韶山市', '3', '25912', 'S');
INSERT INTO `ey_region` VALUES ('26001', '衡阳市', '2', '25579', 'H');
INSERT INTO `ey_region` VALUES ('26002', '市辖区', '3', '26001', 'S');
INSERT INTO `ey_region` VALUES ('26003', '珠晖区', '3', '26001', 'Z');
INSERT INTO `ey_region` VALUES ('26019', '雁峰区', '3', '26001', 'Y');
INSERT INTO `ey_region` VALUES ('26028', '石鼓区', '3', '26001', 'S');
INSERT INTO `ey_region` VALUES ('26037', '蒸湘区', '3', '26001', 'Z');
INSERT INTO `ey_region` VALUES ('26045', '南岳区', '3', '26001', 'N');
INSERT INTO `ey_region` VALUES ('26051', '衡阳县', '3', '26001', 'H');
INSERT INTO `ey_region` VALUES ('26080', '衡南县', '3', '26001', 'H');
INSERT INTO `ey_region` VALUES ('26112', '衡山县', '3', '26001', 'H');
INSERT INTO `ey_region` VALUES ('26130', '衡东县', '3', '26001', 'H');
INSERT INTO `ey_region` VALUES ('26155', '祁东县', '3', '26001', 'Q');
INSERT INTO `ey_region` VALUES ('26179', '耒阳市', '3', '26001', 'L');
INSERT INTO `ey_region` VALUES ('26215', '常宁市', '3', '26001', 'C');
INSERT INTO `ey_region` VALUES ('26242', '邵阳市', '2', '25579', 'S');
INSERT INTO `ey_region` VALUES ('26243', '市辖区', '3', '26242', 'S');
INSERT INTO `ey_region` VALUES ('26244', '双清区', '3', '26242', 'S');
INSERT INTO `ey_region` VALUES ('26257', '大祥区', '3', '26242', 'D');
INSERT INTO `ey_region` VALUES ('26272', '北塔区', '3', '26242', 'B');
INSERT INTO `ey_region` VALUES ('26279', '邵东县', '3', '26242', 'S');
INSERT INTO `ey_region` VALUES ('26306', '新邵县', '3', '26242', 'X');
INSERT INTO `ey_region` VALUES ('26322', '邵阳县', '3', '26242', 'S');
INSERT INTO `ey_region` VALUES ('26348', '隆回县', '3', '26242', 'L');
INSERT INTO `ey_region` VALUES ('26375', '洞口县', '3', '26242', 'D');
INSERT INTO `ey_region` VALUES ('26399', '绥宁县', '3', '26242', 'S');
INSERT INTO `ey_region` VALUES ('26425', '新宁县', '3', '26242', 'X');
INSERT INTO `ey_region` VALUES ('26444', '城步县', '3', '26242', 'C');
INSERT INTO `ey_region` VALUES ('26465', '武冈市', '3', '26242', 'W');
INSERT INTO `ey_region` VALUES ('26485', '岳阳市', '2', '25579', 'Y');
INSERT INTO `ey_region` VALUES ('26486', '市辖区', '3', '26485', 'S');
INSERT INTO `ey_region` VALUES ('26487', '岳阳楼区', '3', '26485', 'Y');
INSERT INTO `ey_region` VALUES ('26511', '云溪区', '3', '26485', 'Y');
INSERT INTO `ey_region` VALUES ('26521', '君山区', '3', '26485', 'J');
INSERT INTO `ey_region` VALUES ('26529', '岳阳县', '3', '26485', 'Y');
INSERT INTO `ey_region` VALUES ('26551', '华容县', '3', '26485', 'H');
INSERT INTO `ey_region` VALUES ('26572', '湘阴县', '3', '26485', 'X');
INSERT INTO `ey_region` VALUES ('26592', '平江县', '3', '26485', 'P');
INSERT INTO `ey_region` VALUES ('26620', '汩罗市', '3', '26485', 'G');
INSERT INTO `ey_region` VALUES ('26657', '临湘市', '3', '26485', 'L');
INSERT INTO `ey_region` VALUES ('26683', '常德市', '2', '25579', 'C');
INSERT INTO `ey_region` VALUES ('26684', '市辖区', '3', '26683', 'S');
INSERT INTO `ey_region` VALUES ('26685', '武陵区', '3', '26683', 'W');
INSERT INTO `ey_region` VALUES ('26702', '鼎城区', '3', '26683', 'D');
INSERT INTO `ey_region` VALUES ('26741', '安乡县', '3', '26683', 'A');
INSERT INTO `ey_region` VALUES ('26762', '汉寿县', '3', '26683', 'H');
INSERT INTO `ey_region` VALUES ('26793', '澧县', '3', '26683', 'L');
INSERT INTO `ey_region` VALUES ('26826', '临澧县', '3', '26683', 'L');
INSERT INTO `ey_region` VALUES ('26844', '桃源县', '3', '26683', 'T');
INSERT INTO `ey_region` VALUES ('26885', '石门县', '3', '26683', 'S');
INSERT INTO `ey_region` VALUES ('26912', '津市市', '3', '26683', 'J');
INSERT INTO `ey_region` VALUES ('26925', '张家界市', '2', '25579', 'Z');
INSERT INTO `ey_region` VALUES ('26926', '市辖区', '3', '26925', 'S');
INSERT INTO `ey_region` VALUES ('26927', '永定区', '3', '26925', 'Y');
INSERT INTO `ey_region` VALUES ('26959', '武陵源区', '3', '26925', 'W');
INSERT INTO `ey_region` VALUES ('26966', '慈利县', '3', '26925', 'C');
INSERT INTO `ey_region` VALUES ('26998', '桑植县', '3', '26925', 'S');
INSERT INTO `ey_region` VALUES ('27038', '益阳市', '2', '25579', 'Y');
INSERT INTO `ey_region` VALUES ('27039', '市辖区', '3', '27038', 'S');
INSERT INTO `ey_region` VALUES ('27040', '资阳区', '3', '27038', 'Z');
INSERT INTO `ey_region` VALUES ('27049', '赫山区', '3', '27038', 'H');
INSERT INTO `ey_region` VALUES ('27069', '南县', '3', '27038', 'N');
INSERT INTO `ey_region` VALUES ('27087', '桃江县', '3', '27038', 'T');
INSERT INTO `ey_region` VALUES ('27106', '安化县', '3', '27038', 'A');
INSERT INTO `ey_region` VALUES ('27130', '沅江市', '3', '27038', 'Y');
INSERT INTO `ey_region` VALUES ('27147', '郴州市', '2', '25579', 'C');
INSERT INTO `ey_region` VALUES ('27148', '市辖区', '3', '27147', 'S');
INSERT INTO `ey_region` VALUES ('27149', '北湖区', '3', '27147', 'B');
INSERT INTO `ey_region` VALUES ('27168', '苏仙区', '3', '27147', 'S');
INSERT INTO `ey_region` VALUES ('27188', '桂阳县', '3', '27147', 'G');
INSERT INTO `ey_region` VALUES ('27228', '宜章县', '3', '27147', 'Y');
INSERT INTO `ey_region` VALUES ('27256', '永兴县', '3', '27147', 'Y');
INSERT INTO `ey_region` VALUES ('27282', '嘉禾县', '3', '27147', 'J');
INSERT INTO `ey_region` VALUES ('27300', '临武县', '3', '27147', 'L');
INSERT INTO `ey_region` VALUES ('27323', '汝城县', '3', '27147', 'R');
INSERT INTO `ey_region` VALUES ('27347', '桂东县', '3', '27147', 'G');
INSERT INTO `ey_region` VALUES ('27367', '安仁县', '3', '27147', 'A');
INSERT INTO `ey_region` VALUES ('27389', '资兴市', '3', '27147', 'Z');
INSERT INTO `ey_region` VALUES ('27418', '永州市', '2', '25579', 'Y');
INSERT INTO `ey_region` VALUES ('27419', '市辖区', '3', '27418', 'S');
INSERT INTO `ey_region` VALUES ('27420', '零陵区', '3', '27418', 'L');
INSERT INTO `ey_region` VALUES ('27437', '冷水滩区', '3', '27418', 'L');
INSERT INTO `ey_region` VALUES ('27459', '祁阳县', '3', '27418', 'Q');
INSERT INTO `ey_region` VALUES ('27492', '东安县', '3', '27418', 'D');
INSERT INTO `ey_region` VALUES ('27511', '双牌县', '3', '27418', 'S');
INSERT INTO `ey_region` VALUES ('27527', '道县', '3', '27418', 'D');
INSERT INTO `ey_region` VALUES ('27554', '江永县', '3', '27418', 'J');
INSERT INTO `ey_region` VALUES ('27567', '宁远县', '3', '27418', 'N');
INSERT INTO `ey_region` VALUES ('27585', '蓝山县', '3', '27418', 'L');
INSERT INTO `ey_region` VALUES ('27606', '新田县', '3', '27418', 'X');
INSERT INTO `ey_region` VALUES ('27626', '江华县', '3', '27418', 'J');
INSERT INTO `ey_region` VALUES ('27650', '怀化市', '2', '25579', 'H');
INSERT INTO `ey_region` VALUES ('27651', '市辖区', '3', '27650', 'S');
INSERT INTO `ey_region` VALUES ('27652', '鹤城区', '3', '27650', 'H');
INSERT INTO `ey_region` VALUES ('27667', '中方县', '3', '27650', 'Z');
INSERT INTO `ey_region` VALUES ('27690', '沅陵县', '3', '27650', 'Y');
INSERT INTO `ey_region` VALUES ('27714', '辰溪县', '3', '27650', 'C');
INSERT INTO `ey_region` VALUES ('27745', '溆浦县', '3', '27650', 'X');
INSERT INTO `ey_region` VALUES ('27789', '会同县', '3', '27650', 'H');
INSERT INTO `ey_region` VALUES ('27815', '麻阳县', '3', '27650', 'M');
INSERT INTO `ey_region` VALUES ('27839', '新晃县', '3', '27650', 'X');
INSERT INTO `ey_region` VALUES ('27863', '芷江县', '3', '27650', 'Z');
INSERT INTO `ey_region` VALUES ('27892', '靖州苗族侗族县', '3', '27650', 'J');
INSERT INTO `ey_region` VALUES ('27906', '通道县', '3', '27650', 'T');
INSERT INTO `ey_region` VALUES ('27930', '洪江市', '3', '27650', 'H');
INSERT INTO `ey_region` VALUES ('27963', '娄底市', '2', '25579', 'L');
INSERT INTO `ey_region` VALUES ('27964', '市辖区', '3', '27963', 'S');
INSERT INTO `ey_region` VALUES ('27965', '娄星区', '3', '27963', 'L');
INSERT INTO `ey_region` VALUES ('27980', '双峰县', '3', '27963', 'S');
INSERT INTO `ey_region` VALUES ('27997', '新化县', '3', '27963', 'X');
INSERT INTO `ey_region` VALUES ('28027', '冷水江市', '3', '27963', 'L');
INSERT INTO `ey_region` VALUES ('28044', '涟源市', '3', '27963', 'L');
INSERT INTO `ey_region` VALUES ('28065', '湘西州', '2', '25579', 'X');
INSERT INTO `ey_region` VALUES ('28066', '吉首市', '3', '28065', 'J');
INSERT INTO `ey_region` VALUES ('28082', '泸溪县', '3', '28065', 'L');
INSERT INTO `ey_region` VALUES ('28099', '凤凰县', '3', '28065', 'F');
INSERT INTO `ey_region` VALUES ('28124', '花垣县', '3', '28065', 'H');
INSERT INTO `ey_region` VALUES ('28143', '保靖县', '3', '28065', 'B');
INSERT INTO `ey_region` VALUES ('28161', '古丈县', '3', '28065', 'G');
INSERT INTO `ey_region` VALUES ('28174', '永顺县', '3', '28065', 'Y');
INSERT INTO `ey_region` VALUES ('28205', '龙山县', '3', '28065', 'L');
INSERT INTO `ey_region` VALUES ('28240', '广东省', '1', '0', 'G');
INSERT INTO `ey_region` VALUES ('28241', '广州市', '2', '28240', 'G');
INSERT INTO `ey_region` VALUES ('28242', '市辖区', '3', '28241', 'S');
INSERT INTO `ey_region` VALUES ('28243', '荔湾区', '3', '28241', 'L');
INSERT INTO `ey_region` VALUES ('28266', '越秀区', '3', '28241', 'Y');
INSERT INTO `ey_region` VALUES ('28289', '海珠区', '3', '28241', 'H');
INSERT INTO `ey_region` VALUES ('28308', '天河区', '3', '28241', 'T');
INSERT INTO `ey_region` VALUES ('28330', '白云区', '3', '28241', 'B');
INSERT INTO `ey_region` VALUES ('28349', '黄埔区', '3', '28241', 'H');
INSERT INTO `ey_region` VALUES ('28359', '番禺区', '3', '28241', 'F');
INSERT INTO `ey_region` VALUES ('28377', '花都区', '3', '28241', 'H');
INSERT INTO `ey_region` VALUES ('28386', '南沙区', '3', '28241', 'N');
INSERT INTO `ey_region` VALUES ('28392', '萝岗区', '3', '28241', 'L');
INSERT INTO `ey_region` VALUES ('28399', '增城市', '3', '28241', 'Z');
INSERT INTO `ey_region` VALUES ('28409', '从化市', '3', '28241', 'C');
INSERT INTO `ey_region` VALUES ('28421', '韶关市', '2', '28240', 'S');
INSERT INTO `ey_region` VALUES ('28422', '市辖区', '3', '28421', 'S');
INSERT INTO `ey_region` VALUES ('28423', '武江区', '3', '28421', 'W');
INSERT INTO `ey_region` VALUES ('28431', '浈江区', '3', '28421', 'Z');
INSERT INTO `ey_region` VALUES ('28448', '曲江区', '3', '28421', 'Q');
INSERT INTO `ey_region` VALUES ('28463', '始兴县', '3', '28421', 'S');
INSERT INTO `ey_region` VALUES ('28475', '仁化县', '3', '28421', 'R');
INSERT INTO `ey_region` VALUES ('28488', '翁源县', '3', '28421', 'W');
INSERT INTO `ey_region` VALUES ('28497', '乳源县', '3', '28421', 'R');
INSERT INTO `ey_region` VALUES ('28509', '新丰县', '3', '28421', 'X');
INSERT INTO `ey_region` VALUES ('28517', '乐昌市', '3', '28421', 'L');
INSERT INTO `ey_region` VALUES ('28539', '南雄市', '3', '28421', 'N');
INSERT INTO `ey_region` VALUES ('28558', '深圳市', '2', '28240', 'S');
INSERT INTO `ey_region` VALUES ('28559', '市辖区', '3', '28558', 'S');
INSERT INTO `ey_region` VALUES ('28560', '罗湖区', '3', '28558', 'L');
INSERT INTO `ey_region` VALUES ('28571', '福田区', '3', '28558', 'F');
INSERT INTO `ey_region` VALUES ('28581', '南山区', '3', '28558', 'N');
INSERT INTO `ey_region` VALUES ('28590', '宝安区', '3', '28558', 'B');
INSERT INTO `ey_region` VALUES ('28604', '龙岗区', '3', '28558', 'L');
INSERT INTO `ey_region` VALUES ('28619', '盐田区', '3', '28558', 'Y');
INSERT INTO `ey_region` VALUES ('28626', '珠海市', '2', '28240', 'Z');
INSERT INTO `ey_region` VALUES ('28627', '市辖区', '3', '28626', 'S');
INSERT INTO `ey_region` VALUES ('28628', '香洲区', '3', '28626', 'X');
INSERT INTO `ey_region` VALUES ('28646', '斗门区', '3', '28626', 'D');
INSERT INTO `ey_region` VALUES ('28654', '金湾区', '3', '28626', 'J');
INSERT INTO `ey_region` VALUES ('28659', '汕头市', '2', '28240', 'S');
INSERT INTO `ey_region` VALUES ('28660', '市辖区', '3', '28659', 'S');
INSERT INTO `ey_region` VALUES ('28661', '龙湖区', '3', '28659', 'L');
INSERT INTO `ey_region` VALUES ('28669', '金平区', '3', '28659', 'J');
INSERT INTO `ey_region` VALUES ('28687', '濠江区', '3', '28659', 'H');
INSERT INTO `ey_region` VALUES ('28695', '潮阳区', '3', '28659', 'C');
INSERT INTO `ey_region` VALUES ('28709', '潮南区', '3', '28659', 'C');
INSERT INTO `ey_region` VALUES ('28721', '澄海区', '3', '28659', 'C');
INSERT INTO `ey_region` VALUES ('28733', '南澳县', '3', '28659', 'N');
INSERT INTO `ey_region` VALUES ('28737', '佛山市', '2', '28240', 'F');
INSERT INTO `ey_region` VALUES ('28738', '市辖区', '3', '28737', 'S');
INSERT INTO `ey_region` VALUES ('28739', '禅城区', '3', '28737', 'C');
INSERT INTO `ey_region` VALUES ('28744', '南海区', '3', '28737', 'N');
INSERT INTO `ey_region` VALUES ('28753', '顺德区', '3', '28737', 'S');
INSERT INTO `ey_region` VALUES ('28764', '三水区', '3', '28737', 'S');
INSERT INTO `ey_region` VALUES ('28776', '高明区', '3', '28737', 'G');
INSERT INTO `ey_region` VALUES ('28785', '江门市', '2', '28240', 'J');
INSERT INTO `ey_region` VALUES ('28786', '市辖区', '3', '28785', 'S');
INSERT INTO `ey_region` VALUES ('28787', '蓬江区', '3', '28785', 'P');
INSERT INTO `ey_region` VALUES ('28797', '江海区', '3', '28785', 'J');
INSERT INTO `ey_region` VALUES ('28803', '新会区', '3', '28785', 'X');
INSERT INTO `ey_region` VALUES ('28818', '台山市', '3', '28785', 'T');
INSERT INTO `ey_region` VALUES ('28837', '开平市', '3', '28785', 'K');
INSERT INTO `ey_region` VALUES ('28853', '鹤山市', '3', '28785', 'H');
INSERT INTO `ey_region` VALUES ('28867', '恩平市', '3', '28785', 'E');
INSERT INTO `ey_region` VALUES ('28880', '湛江市', '2', '28240', 'Z');
INSERT INTO `ey_region` VALUES ('28881', '市辖区', '3', '28880', 'S');
INSERT INTO `ey_region` VALUES ('28882', '湛江市赤坎区', '3', '28880', 'Z');
INSERT INTO `ey_region` VALUES ('28891', '湛江市霞山区', '3', '28880', 'Z');
INSERT INTO `ey_region` VALUES ('28904', '湛江市坡头区', '3', '28880', 'Z');
INSERT INTO `ey_region` VALUES ('28914', '湛江市麻章区', '3', '28880', 'Z');
INSERT INTO `ey_region` VALUES ('28923', '遂溪县', '3', '28880', 'S');
INSERT INTO `ey_region` VALUES ('28941', '徐闻县', '3', '28880', 'X');
INSERT INTO `ey_region` VALUES ('28962', '廉江市', '3', '28880', 'L');
INSERT INTO `ey_region` VALUES ('28984', '雷州市', '3', '28880', 'L');
INSERT INTO `ey_region` VALUES ('29010', '吴川市', '3', '28880', 'W');
INSERT INTO `ey_region` VALUES ('29026', '茂名市', '2', '28240', 'M');
INSERT INTO `ey_region` VALUES ('29027', '市辖区', '3', '29026', 'S');
INSERT INTO `ey_region` VALUES ('29028', '茂南区', '3', '29026', 'M');
INSERT INTO `ey_region` VALUES ('29045', '茂港区', '3', '29026', 'M');
INSERT INTO `ey_region` VALUES ('29053', '电白县', '3', '29026', 'D');
INSERT INTO `ey_region` VALUES ('29075', '高州市', '3', '29026', 'G');
INSERT INTO `ey_region` VALUES ('29107', '化州市', '3', '29026', 'H');
INSERT INTO `ey_region` VALUES ('29138', '信宜市', '3', '29026', 'X');
INSERT INTO `ey_region` VALUES ('29159', '肇庆市', '2', '28240', 'Z');
INSERT INTO `ey_region` VALUES ('29160', '市辖区', '3', '29159', 'S');
INSERT INTO `ey_region` VALUES ('29161', '端州区', '3', '29159', 'D');
INSERT INTO `ey_region` VALUES ('29169', '鼎湖区', '3', '29159', 'D');
INSERT INTO `ey_region` VALUES ('29178', '广宁县', '3', '29159', 'G');
INSERT INTO `ey_region` VALUES ('29196', '怀集县', '3', '29159', 'H');
INSERT INTO `ey_region` VALUES ('29217', '封开县', '3', '29159', 'F');
INSERT INTO `ey_region` VALUES ('29234', '德庆县', '3', '29159', 'D');
INSERT INTO `ey_region` VALUES ('29248', '高要市', '3', '29159', 'G');
INSERT INTO `ey_region` VALUES ('29266', '四会市', '3', '29159', 'S');
INSERT INTO `ey_region` VALUES ('29282', '惠州市', '2', '28240', 'H');
INSERT INTO `ey_region` VALUES ('29283', '市辖区', '3', '29282', 'S');
INSERT INTO `ey_region` VALUES ('29284', '惠城区', '3', '29282', 'H');
INSERT INTO `ey_region` VALUES ('29304', '惠阳区', '3', '29282', 'H');
INSERT INTO `ey_region` VALUES ('29317', '博罗县', '3', '29282', 'B');
INSERT INTO `ey_region` VALUES ('29335', '惠东县', '3', '29282', 'H');
INSERT INTO `ey_region` VALUES ('29355', '龙门县', '3', '29282', 'L');
INSERT INTO `ey_region` VALUES ('29371', '梅州市', '2', '28240', 'M');
INSERT INTO `ey_region` VALUES ('29372', '市辖区', '3', '29371', 'S');
INSERT INTO `ey_region` VALUES ('29373', '梅江区', '3', '29371', 'M');
INSERT INTO `ey_region` VALUES ('29380', '梅县', '3', '29371', 'M');
INSERT INTO `ey_region` VALUES ('29400', '大埔县', '3', '29371', 'D');
INSERT INTO `ey_region` VALUES ('29418', '丰顺县', '3', '29371', 'F');
INSERT INTO `ey_region` VALUES ('29436', '五华县', '3', '29371', 'W');
INSERT INTO `ey_region` VALUES ('29453', '平远县', '3', '29371', 'P');
INSERT INTO `ey_region` VALUES ('29466', '蕉岭县', '3', '29371', 'J');
INSERT INTO `ey_region` VALUES ('29477', '兴宁市', '3', '29371', 'X');
INSERT INTO `ey_region` VALUES ('29498', '汕尾市', '2', '28240', 'S');
INSERT INTO `ey_region` VALUES ('29499', '市辖区', '3', '29498', 'S');
INSERT INTO `ey_region` VALUES ('29500', '城区', '3', '29498', 'C');
INSERT INTO `ey_region` VALUES ('29511', '海丰县', '3', '29498', 'H');
INSERT INTO `ey_region` VALUES ('29529', '陆河县', '3', '29498', 'L');
INSERT INTO `ey_region` VALUES ('29538', '陆丰市', '3', '29498', 'L');
INSERT INTO `ey_region` VALUES ('29568', '河源市', '2', '28240', 'H');
INSERT INTO `ey_region` VALUES ('29569', '市辖区', '3', '29568', 'S');
INSERT INTO `ey_region` VALUES ('29570', '源城区', '3', '29568', 'Y');
INSERT INTO `ey_region` VALUES ('29578', '紫金县', '3', '29568', 'Z');
INSERT INTO `ey_region` VALUES ('29599', '龙川县', '3', '29568', 'L');
INSERT INTO `ey_region` VALUES ('29625', '连平县', '3', '29568', 'L');
INSERT INTO `ey_region` VALUES ('29639', '和平县', '3', '29568', 'H');
INSERT INTO `ey_region` VALUES ('29657', '东源县', '3', '29568', 'D');
INSERT INTO `ey_region` VALUES ('29679', '阳江市', '2', '28240', 'Y');
INSERT INTO `ey_region` VALUES ('29680', '市辖区', '3', '29679', 'S');
INSERT INTO `ey_region` VALUES ('29681', '江城区', '3', '29679', 'J');
INSERT INTO `ey_region` VALUES ('29698', '阳西县', '3', '29679', 'Y');
INSERT INTO `ey_region` VALUES ('29709', '阳东县', '3', '29679', 'Y');
INSERT INTO `ey_region` VALUES ('29729', '阳春市', '3', '29679', 'Y');
INSERT INTO `ey_region` VALUES ('29755', '清远市', '2', '28240', 'Q');
INSERT INTO `ey_region` VALUES ('29756', '市辖区', '3', '29755', 'S');
INSERT INTO `ey_region` VALUES ('29757', '清城区', '3', '29755', 'Q');
INSERT INTO `ey_region` VALUES ('29766', '佛冈县', '3', '29755', 'F');
INSERT INTO `ey_region` VALUES ('29773', '阳山县', '3', '29755', 'Y');
INSERT INTO `ey_region` VALUES ('29787', '连山县', '3', '29755', 'L');
INSERT INTO `ey_region` VALUES ('29797', '连南县', '3', '29755', 'L');
INSERT INTO `ey_region` VALUES ('29805', '清新县', '3', '29755', 'Q');
INSERT INTO `ey_region` VALUES ('29816', '英德市', '3', '29755', 'Y');
INSERT INTO `ey_region` VALUES ('29842', '连州市', '3', '29755', 'L');
INSERT INTO `ey_region` VALUES ('29855', '东莞市', '2', '28240', 'D');
INSERT INTO `ey_region` VALUES ('29890', '中山市', '2', '28240', 'Z');
INSERT INTO `ey_region` VALUES ('29915', '潮州市', '2', '28240', 'C');
INSERT INTO `ey_region` VALUES ('29916', '市辖区', '3', '29915', 'S');
INSERT INTO `ey_region` VALUES ('29917', '潮州市湘桥区', '3', '29915', 'C');
INSERT INTO `ey_region` VALUES ('29930', '潮州市潮安县', '3', '29915', 'C');
INSERT INTO `ey_region` VALUES ('29954', '潮州市饶平县', '3', '29915', 'C');
INSERT INTO `ey_region` VALUES ('29977', '揭阳市', '2', '28240', 'J');
INSERT INTO `ey_region` VALUES ('29978', '市辖区', '3', '29977', 'S');
INSERT INTO `ey_region` VALUES ('29979', '榕城区', '3', '29977', 'R');
INSERT INTO `ey_region` VALUES ('29990', '揭东县', '3', '29977', 'J');
INSERT INTO `ey_region` VALUES ('30008', '揭西县', '3', '29977', 'J');
INSERT INTO `ey_region` VALUES ('30032', '惠来县', '3', '29977', 'H');
INSERT INTO `ey_region` VALUES ('30054', '普宁市', '3', '29977', 'P');
INSERT INTO `ey_region` VALUES ('30086', '云浮市', '2', '28240', 'Y');
INSERT INTO `ey_region` VALUES ('30087', '市辖区', '3', '30086', 'S');
INSERT INTO `ey_region` VALUES ('30088', '云城区', '3', '30086', 'Y');
INSERT INTO `ey_region` VALUES ('30096', '新兴县', '3', '30086', 'X');
INSERT INTO `ey_region` VALUES ('30112', '郁南县', '3', '30086', 'Y');
INSERT INTO `ey_region` VALUES ('30132', '云安县', '3', '30086', 'Y');
INSERT INTO `ey_region` VALUES ('30141', '罗定市', '3', '30086', 'L');
INSERT INTO `ey_region` VALUES ('30164', '广西壮族自治区', '1', '0', 'G');
INSERT INTO `ey_region` VALUES ('30165', '南宁市', '2', '30164', 'N');
INSERT INTO `ey_region` VALUES ('30166', '市辖区', '3', '30165', 'S');
INSERT INTO `ey_region` VALUES ('30167', '兴宁区', '3', '30165', 'X');
INSERT INTO `ey_region` VALUES ('30174', '青秀区', '3', '30165', 'Q');
INSERT INTO `ey_region` VALUES ('30186', '江南区', '3', '30165', 'J');
INSERT INTO `ey_region` VALUES ('30196', '西乡塘区', '3', '30165', 'X');
INSERT INTO `ey_region` VALUES ('30214', '良庆区', '3', '30165', 'L');
INSERT INTO `ey_region` VALUES ('30222', '邕宁区', '3', '30165', 'Y');
INSERT INTO `ey_region` VALUES ('30228', '武鸣县', '3', '30165', 'W');
INSERT INTO `ey_region` VALUES ('30245', '隆安县', '3', '30165', 'L');
INSERT INTO `ey_region` VALUES ('30257', '马山县', '3', '30165', 'M');
INSERT INTO `ey_region` VALUES ('30270', '上林县', '3', '30165', 'S');
INSERT INTO `ey_region` VALUES ('30282', '宾阳县', '3', '30165', 'B');
INSERT INTO `ey_region` VALUES ('30300', '横县', '3', '30165', 'H');
INSERT INTO `ey_region` VALUES ('30319', '柳州市', '2', '30164', 'L');
INSERT INTO `ey_region` VALUES ('30320', '市辖区', '3', '30319', 'S');
INSERT INTO `ey_region` VALUES ('30321', '城中区', '3', '30319', 'C');
INSERT INTO `ey_region` VALUES ('30329', '鱼峰区', '3', '30319', 'Y');
INSERT INTO `ey_region` VALUES ('30338', '柳南区', '3', '30319', 'L');
INSERT INTO `ey_region` VALUES ('30348', '柳北区', '3', '30319', 'L');
INSERT INTO `ey_region` VALUES ('30361', '柳江县', '3', '30319', 'L');
INSERT INTO `ey_region` VALUES ('30374', '柳城县', '3', '30319', 'L');
INSERT INTO `ey_region` VALUES ('30387', '鹿寨县', '3', '30319', 'L');
INSERT INTO `ey_region` VALUES ('30398', '融安县', '3', '30319', 'R');
INSERT INTO `ey_region` VALUES ('30411', '融水县', '3', '30319', 'R');
INSERT INTO `ey_region` VALUES ('30432', '三江县', '3', '30319', 'S');
INSERT INTO `ey_region` VALUES ('30448', '桂林市', '2', '30164', 'G');
INSERT INTO `ey_region` VALUES ('30449', '市辖区', '3', '30448', 'S');
INSERT INTO `ey_region` VALUES ('30450', '秀峰区', '3', '30448', 'X');
INSERT INTO `ey_region` VALUES ('30454', '叠彩区', '3', '30448', 'D');
INSERT INTO `ey_region` VALUES ('30458', '象山区', '3', '30448', 'X');
INSERT INTO `ey_region` VALUES ('30463', '七星区', '3', '30448', 'Q');
INSERT INTO `ey_region` VALUES ('30469', '雁山区', '3', '30448', 'Y');
INSERT INTO `ey_region` VALUES ('30475', '阳朔县', '3', '30448', 'Y');
INSERT INTO `ey_region` VALUES ('30485', '临桂县', '3', '30448', 'L');
INSERT INTO `ey_region` VALUES ('30497', '灵川县', '3', '30448', 'L');
INSERT INTO `ey_region` VALUES ('30509', '全州县', '3', '30448', 'Q');
INSERT INTO `ey_region` VALUES ('30528', '兴安县', '3', '30448', 'X');
INSERT INTO `ey_region` VALUES ('30539', '永福县', '3', '30448', 'Y');
INSERT INTO `ey_region` VALUES ('30549', '灌阳县', '3', '30448', 'G');
INSERT INTO `ey_region` VALUES ('30559', '龙胜县', '3', '30448', 'L');
INSERT INTO `ey_region` VALUES ('30570', '资源县', '3', '30448', 'Z');
INSERT INTO `ey_region` VALUES ('30578', '平乐县', '3', '30448', 'P');
INSERT INTO `ey_region` VALUES ('30589', '荔浦县', '3', '30448', 'L');
INSERT INTO `ey_region` VALUES ('30603', '恭城县', '3', '30448', 'G');
INSERT INTO `ey_region` VALUES ('30613', '梧州市', '2', '30164', 'W');
INSERT INTO `ey_region` VALUES ('30614', '市辖区', '3', '30613', 'S');
INSERT INTO `ey_region` VALUES ('30615', '万秀区', '3', '30613', 'W');
INSERT INTO `ey_region` VALUES ('30622', '蝶山区', '3', '30613', 'D');
INSERT INTO `ey_region` VALUES ('30628', '长洲区', '3', '30613', 'C');
INSERT INTO `ey_region` VALUES ('30633', '苍梧县', '3', '30613', 'C');
INSERT INTO `ey_region` VALUES ('30646', '藤县', '3', '30613', 'T');
INSERT INTO `ey_region` VALUES ('30663', '蒙山县', '3', '30613', 'M');
INSERT INTO `ey_region` VALUES ('30673', '岑溪市', '3', '30613', 'C');
INSERT INTO `ey_region` VALUES ('30688', '北海市', '2', '30164', 'B');
INSERT INTO `ey_region` VALUES ('30689', '市辖区', '3', '30688', 'S');
INSERT INTO `ey_region` VALUES ('30690', '海城区', '3', '30688', 'H');
INSERT INTO `ey_region` VALUES ('30699', '银海区', '3', '30688', 'Y');
INSERT INTO `ey_region` VALUES ('30704', '铁山港区', '3', '30688', 'T');
INSERT INTO `ey_region` VALUES ('30708', '合浦县', '3', '30688', 'H');
INSERT INTO `ey_region` VALUES ('30724', '防城港市', '2', '30164', 'F');
INSERT INTO `ey_region` VALUES ('30725', '市辖区', '3', '30724', 'S');
INSERT INTO `ey_region` VALUES ('30726', '港口区', '3', '30724', 'G');
INSERT INTO `ey_region` VALUES ('30732', '防城区', '3', '30724', 'F');
INSERT INTO `ey_region` VALUES ('30748', '上思县', '3', '30724', 'S');
INSERT INTO `ey_region` VALUES ('30758', '东兴市', '3', '30724', 'D');
INSERT INTO `ey_region` VALUES ('30762', '钦州市', '2', '30164', 'Q');
INSERT INTO `ey_region` VALUES ('30763', '市辖区', '3', '30762', 'S');
INSERT INTO `ey_region` VALUES ('30764', '钦南区', '3', '30762', 'Q');
INSERT INTO `ey_region` VALUES ('30783', '钦北区', '3', '30762', 'Q');
INSERT INTO `ey_region` VALUES ('30796', '灵山县', '3', '30762', 'L');
INSERT INTO `ey_region` VALUES ('30817', '浦北县', '3', '30762', 'P');
INSERT INTO `ey_region` VALUES ('30834', '贵港市', '2', '30164', 'G');
INSERT INTO `ey_region` VALUES ('30835', '市辖区', '3', '30834', 'S');
INSERT INTO `ey_region` VALUES ('30836', '港北区', '3', '30834', 'G');
INSERT INTO `ey_region` VALUES ('30845', '港南区', '3', '30834', 'G');
INSERT INTO `ey_region` VALUES ('30855', '覃塘区', '3', '30834', 'Q');
INSERT INTO `ey_region` VALUES ('30866', '平南县', '3', '30834', 'P');
INSERT INTO `ey_region` VALUES ('30888', '桂平市', '3', '30834', 'G');
INSERT INTO `ey_region` VALUES ('30915', '玉林市', '2', '30164', 'Y');
INSERT INTO `ey_region` VALUES ('30916', '市辖区', '3', '30915', 'S');
INSERT INTO `ey_region` VALUES ('30917', '玉州区', '3', '30915', 'Y');
INSERT INTO `ey_region` VALUES ('30933', '容县', '3', '30915', 'R');
INSERT INTO `ey_region` VALUES ('30949', '陆川县', '3', '30915', 'L');
INSERT INTO `ey_region` VALUES ('30964', '博白县', '3', '30915', 'B');
INSERT INTO `ey_region` VALUES ('30993', '兴业县', '3', '30915', 'X');
INSERT INTO `ey_region` VALUES ('31007', '北流市', '3', '30915', 'B');
INSERT INTO `ey_region` VALUES ('31033', '百色市', '2', '30164', 'B');
INSERT INTO `ey_region` VALUES ('31034', '市辖区', '3', '31033', 'S');
INSERT INTO `ey_region` VALUES ('31035', '右江区', '3', '31033', 'Y');
INSERT INTO `ey_region` VALUES ('31045', '田阳县', '3', '31033', 'T');
INSERT INTO `ey_region` VALUES ('31056', '田东县', '3', '31033', 'T');
INSERT INTO `ey_region` VALUES ('31067', '平果县', '3', '31033', 'P');
INSERT INTO `ey_region` VALUES ('31081', '德保县', '3', '31033', 'D');
INSERT INTO `ey_region` VALUES ('31095', '靖西县', '3', '31033', 'J');
INSERT INTO `ey_region` VALUES ('31115', '那坡县', '3', '31033', 'N');
INSERT INTO `ey_region` VALUES ('31125', '凌云县', '3', '31033', 'L');
INSERT INTO `ey_region` VALUES ('31134', '乐业县', '3', '31033', 'L');
INSERT INTO `ey_region` VALUES ('31143', '田林县', '3', '31033', 'T');
INSERT INTO `ey_region` VALUES ('31158', '西林县', '3', '31033', 'X');
INSERT INTO `ey_region` VALUES ('31167', '隆林县', '3', '31033', 'L');
INSERT INTO `ey_region` VALUES ('31184', '贺州市', '2', '30164', 'H');
INSERT INTO `ey_region` VALUES ('31185', '市辖区', '3', '31184', 'S');
INSERT INTO `ey_region` VALUES ('31186', '八步区', '3', '31184', 'B');
INSERT INTO `ey_region` VALUES ('31208', '昭平县', '3', '31184', 'Z');
INSERT INTO `ey_region` VALUES ('31221', '钟山县', '3', '31184', 'Z');
INSERT INTO `ey_region` VALUES ('31236', '富川县', '3', '31184', 'F');
INSERT INTO `ey_region` VALUES ('31249', '河池市', '2', '30164', 'H');
INSERT INTO `ey_region` VALUES ('31250', '市辖区', '3', '31249', 'S');
INSERT INTO `ey_region` VALUES ('31251', '金城江区', '3', '31249', 'J');
INSERT INTO `ey_region` VALUES ('31264', '南丹县', '3', '31249', 'N');
INSERT INTO `ey_region` VALUES ('31276', '天峨县', '3', '31249', 'T');
INSERT INTO `ey_region` VALUES ('31286', '凤山县', '3', '31249', 'F');
INSERT INTO `ey_region` VALUES ('31296', '东兰县', '3', '31249', 'D');
INSERT INTO `ey_region` VALUES ('31311', '罗城县', '3', '31249', 'L');
INSERT INTO `ey_region` VALUES ('31323', '环江县', '3', '31249', 'H');
INSERT INTO `ey_region` VALUES ('31336', '巴马县', '3', '31249', 'B');
INSERT INTO `ey_region` VALUES ('31347', '都安县', '3', '31249', 'D');
INSERT INTO `ey_region` VALUES ('31367', '大化县', '3', '31249', 'D');
INSERT INTO `ey_region` VALUES ('31384', '宜州市', '3', '31249', 'Y');
INSERT INTO `ey_region` VALUES ('31401', '来宾市', '2', '30164', 'L');
INSERT INTO `ey_region` VALUES ('31402', '市辖区', '3', '31401', 'S');
INSERT INTO `ey_region` VALUES ('31403', '兴宾区', '3', '31401', 'X');
INSERT INTO `ey_region` VALUES ('31427', '忻城县', '3', '31401', 'X');
INSERT INTO `ey_region` VALUES ('31440', '象州县', '3', '31401', 'X');
INSERT INTO `ey_region` VALUES ('31452', '武宣县', '3', '31401', 'W');
INSERT INTO `ey_region` VALUES ('31463', '金秀县', '3', '31401', 'J');
INSERT INTO `ey_region` VALUES ('31474', '合山市', '3', '31401', 'H');
INSERT INTO `ey_region` VALUES ('31478', '崇左市', '2', '30164', 'C');
INSERT INTO `ey_region` VALUES ('31479', '市辖区', '3', '31478', 'S');
INSERT INTO `ey_region` VALUES ('31480', '江州区', '3', '31478', 'J');
INSERT INTO `ey_region` VALUES ('31490', '扶绥县', '3', '31478', 'F');
INSERT INTO `ey_region` VALUES ('31502', '宁明县', '3', '31478', 'N');
INSERT INTO `ey_region` VALUES ('31516', '龙州县', '3', '31478', 'L');
INSERT INTO `ey_region` VALUES ('31529', '大新县', '3', '31478', 'D');
INSERT INTO `ey_region` VALUES ('31544', '天等县', '3', '31478', 'T');
INSERT INTO `ey_region` VALUES ('31558', '凭祥市', '3', '31478', 'P');
INSERT INTO `ey_region` VALUES ('31563', '海南省', '1', '0', 'H');
INSERT INTO `ey_region` VALUES ('31564', '海口市', '2', '31563', 'H');
INSERT INTO `ey_region` VALUES ('31565', '市辖区', '3', '31564', 'S');
INSERT INTO `ey_region` VALUES ('31566', '秀英区', '3', '31564', 'X');
INSERT INTO `ey_region` VALUES ('31575', '龙华区', '3', '31564', 'L');
INSERT INTO `ey_region` VALUES ('31587', '琼山区', '3', '31564', 'Q');
INSERT INTO `ey_region` VALUES ('31601', '美兰区', '3', '31564', 'M');
INSERT INTO `ey_region` VALUES ('31618', '三亚市', '2', '31563', 'S');
INSERT INTO `ey_region` VALUES ('47964', '海棠区', '3', '31618', 'H');
INSERT INTO `ey_region` VALUES ('31634', '五指山市', '2', '31563', 'W');
INSERT INTO `ey_region` VALUES ('31635', '冲山镇', '3', '31634', 'C');
INSERT INTO `ey_region` VALUES ('31636', '南圣镇', '3', '31634', 'N');
INSERT INTO `ey_region` VALUES ('31637', '毛阳镇', '3', '31634', 'M');
INSERT INTO `ey_region` VALUES ('31638', '番阳镇', '3', '31634', 'F');
INSERT INTO `ey_region` VALUES ('31639', '畅好乡', '3', '31634', 'C');
INSERT INTO `ey_region` VALUES ('31640', '毛道乡', '3', '31634', 'M');
INSERT INTO `ey_region` VALUES ('31641', '水满乡', '3', '31634', 'S');
INSERT INTO `ey_region` VALUES ('31642', '国营畅好农场', '3', '31634', 'G');
INSERT INTO `ey_region` VALUES ('31643', '琼海市', '2', '31563', 'Q');
INSERT INTO `ey_region` VALUES ('31644', '嘉积镇', '3', '31643', 'J');
INSERT INTO `ey_region` VALUES ('31645', '万泉镇', '3', '31643', 'W');
INSERT INTO `ey_region` VALUES ('31646', '石壁镇', '3', '31643', 'S');
INSERT INTO `ey_region` VALUES ('31647', '中原镇', '3', '31643', 'Z');
INSERT INTO `ey_region` VALUES ('31648', '博敖镇', '3', '31643', 'B');
INSERT INTO `ey_region` VALUES ('31649', '阳江镇', '3', '31643', 'Y');
INSERT INTO `ey_region` VALUES ('31650', '龙江镇', '3', '31643', 'L');
INSERT INTO `ey_region` VALUES ('31651', '潭门镇', '3', '31643', 'T');
INSERT INTO `ey_region` VALUES ('31652', '塔洋镇', '3', '31643', 'T');
INSERT INTO `ey_region` VALUES ('31653', '长坡镇', '3', '31643', 'C');
INSERT INTO `ey_region` VALUES ('31654', '大路镇', '3', '31643', 'D');
INSERT INTO `ey_region` VALUES ('31655', '会山镇', '3', '31643', 'H');
INSERT INTO `ey_region` VALUES ('31656', '国营东太农场', '3', '31643', 'G');
INSERT INTO `ey_region` VALUES ('31657', '国营东平农场', '3', '31643', 'G');
INSERT INTO `ey_region` VALUES ('31658', '国营东红农场', '3', '31643', 'G');
INSERT INTO `ey_region` VALUES ('31659', '国营东升农场', '3', '31643', 'G');
INSERT INTO `ey_region` VALUES ('31660', '国营南俸农场', '3', '31643', 'G');
INSERT INTO `ey_region` VALUES ('31661', '彬村山华侨农场', '3', '31643', 'B');
INSERT INTO `ey_region` VALUES ('31662', '儋州市', '2', '31563', 'D');
INSERT INTO `ey_region` VALUES ('31663', '那大镇', '3', '31662', 'N');
INSERT INTO `ey_region` VALUES ('31664', '和庆镇', '3', '31662', 'H');
INSERT INTO `ey_region` VALUES ('31665', '南丰镇', '3', '31662', 'N');
INSERT INTO `ey_region` VALUES ('31666', '大成镇', '3', '31662', 'D');
INSERT INTO `ey_region` VALUES ('31667', '雅星镇', '3', '31662', 'Y');
INSERT INTO `ey_region` VALUES ('31668', '兰洋镇', '3', '31662', 'L');
INSERT INTO `ey_region` VALUES ('31669', '光村镇', '3', '31662', 'G');
INSERT INTO `ey_region` VALUES ('31670', '木棠镇', '3', '31662', 'M');
INSERT INTO `ey_region` VALUES ('31671', '海头镇', '3', '31662', 'H');
INSERT INTO `ey_region` VALUES ('31672', '峨蔓镇', '3', '31662', 'E');
INSERT INTO `ey_region` VALUES ('31673', '三都镇', '3', '31662', 'S');
INSERT INTO `ey_region` VALUES ('31674', '王五镇', '3', '31662', 'W');
INSERT INTO `ey_region` VALUES ('31675', '白马井镇', '3', '31662', 'B');
INSERT INTO `ey_region` VALUES ('31676', '中和镇', '3', '31662', 'Z');
INSERT INTO `ey_region` VALUES ('31677', '排浦镇', '3', '31662', 'P');
INSERT INTO `ey_region` VALUES ('31678', '东成镇', '3', '31662', 'D');
INSERT INTO `ey_region` VALUES ('31679', '新州镇', '3', '31662', 'X');
INSERT INTO `ey_region` VALUES ('31680', '国营西培农场', '3', '31662', 'G');
INSERT INTO `ey_region` VALUES ('31681', '国营西华农场', '3', '31662', 'G');
INSERT INTO `ey_region` VALUES ('31682', '国营西庆农场', '3', '31662', 'G');
INSERT INTO `ey_region` VALUES ('31683', '国营西流农场', '3', '31662', 'G');
INSERT INTO `ey_region` VALUES ('31684', '国营西联农场', '3', '31662', 'G');
INSERT INTO `ey_region` VALUES ('31685', '国营蓝洋农场', '3', '31662', 'G');
INSERT INTO `ey_region` VALUES ('31686', '国营新盈农场', '3', '31662', 'G');
INSERT INTO `ey_region` VALUES ('31687', '国营八一农场东山分场', '3', '31662', 'G');
INSERT INTO `ey_region` VALUES ('31688', '国营八一农场金川分场', '3', '31662', 'G');
INSERT INTO `ey_region` VALUES ('31689', '国营八一农场长岭分场', '3', '31662', 'G');
INSERT INTO `ey_region` VALUES ('31690', '国营八一农场英岛分场', '3', '31662', 'G');
INSERT INTO `ey_region` VALUES ('31691', '国营八一农场春江分场', '3', '31662', 'G');
INSERT INTO `ey_region` VALUES ('31692', '国营八一农场强打管区', '3', '31662', 'G');
INSERT INTO `ey_region` VALUES ('31693', '国营龙山农场', '3', '31662', 'G');
INSERT INTO `ey_region` VALUES ('31694', '国营红岭农场', '3', '31662', 'G');
INSERT INTO `ey_region` VALUES ('31695', '洋浦经济开发区', '3', '31662', 'Y');
INSERT INTO `ey_region` VALUES ('31696', '华南热作学院', '3', '31662', 'H');
INSERT INTO `ey_region` VALUES ('31697', '文昌市', '2', '31563', 'W');
INSERT INTO `ey_region` VALUES ('31698', '文城镇', '3', '31697', 'W');
INSERT INTO `ey_region` VALUES ('31699', '重兴镇', '3', '31697', 'Z');
INSERT INTO `ey_region` VALUES ('31700', '蓬莱镇', '3', '31697', 'P');
INSERT INTO `ey_region` VALUES ('31701', '会文镇', '3', '31697', 'H');
INSERT INTO `ey_region` VALUES ('31702', '东路镇', '3', '31697', 'D');
INSERT INTO `ey_region` VALUES ('31703', '潭牛镇', '3', '31697', 'T');
INSERT INTO `ey_region` VALUES ('31704', '东阁镇', '3', '31697', 'D');
INSERT INTO `ey_region` VALUES ('31705', '文教镇', '3', '31697', 'W');
INSERT INTO `ey_region` VALUES ('31706', '东郊镇', '3', '31697', 'D');
INSERT INTO `ey_region` VALUES ('31707', '龙楼镇', '3', '31697', 'L');
INSERT INTO `ey_region` VALUES ('31708', '昌洒镇', '3', '31697', 'C');
INSERT INTO `ey_region` VALUES ('31709', '翁田镇', '3', '31697', 'W');
INSERT INTO `ey_region` VALUES ('31710', '抱罗镇', '3', '31697', 'B');
INSERT INTO `ey_region` VALUES ('31711', '冯坡镇', '3', '31697', 'F');
INSERT INTO `ey_region` VALUES ('31712', '锦山镇', '3', '31697', 'J');
INSERT INTO `ey_region` VALUES ('31713', '铺前镇', '3', '31697', 'P');
INSERT INTO `ey_region` VALUES ('31714', '国营东路农场', '3', '31697', 'G');
INSERT INTO `ey_region` VALUES ('31715', '国营南阳农场', '3', '31697', 'G');
INSERT INTO `ey_region` VALUES ('31716', '国营罗豆农场', '3', '31697', 'G');
INSERT INTO `ey_region` VALUES ('31717', '国营文昌橡胶研究所', '3', '31697', 'G');
INSERT INTO `ey_region` VALUES ('31718', '万宁市', '2', '31563', 'W');
INSERT INTO `ey_region` VALUES ('31719', '万城镇', '3', '31718', 'W');
INSERT INTO `ey_region` VALUES ('31720', '龙滚镇', '3', '31718', 'L');
INSERT INTO `ey_region` VALUES ('31721', '和乐镇', '3', '31718', 'H');
INSERT INTO `ey_region` VALUES ('31722', '后安镇', '3', '31718', 'H');
INSERT INTO `ey_region` VALUES ('31723', '大茂镇', '3', '31718', 'D');
INSERT INTO `ey_region` VALUES ('31724', '东澳镇', '3', '31718', 'D');
INSERT INTO `ey_region` VALUES ('31725', '礼纪镇', '3', '31718', 'L');
INSERT INTO `ey_region` VALUES ('31726', '长丰镇', '3', '31718', 'C');
INSERT INTO `ey_region` VALUES ('31727', '山根镇', '3', '31718', 'S');
INSERT INTO `ey_region` VALUES ('31728', '北大镇', '3', '31718', 'B');
INSERT INTO `ey_region` VALUES ('31729', '南桥镇', '3', '31718', 'N');
INSERT INTO `ey_region` VALUES ('31730', '三更罗镇', '3', '31718', 'S');
INSERT INTO `ey_region` VALUES ('31731', '国营东兴农场', '3', '31718', 'G');
INSERT INTO `ey_region` VALUES ('31732', '国营东和农场', '3', '31718', 'G');
INSERT INTO `ey_region` VALUES ('31733', '国营东岭农场', '3', '31718', 'G');
INSERT INTO `ey_region` VALUES ('31734', '国营南林农场', '3', '31718', 'G');
INSERT INTO `ey_region` VALUES ('31735', '国营新中农场', '3', '31718', 'G');
INSERT INTO `ey_region` VALUES ('31736', '兴隆华侨农场', '3', '31718', 'X');
INSERT INTO `ey_region` VALUES ('31737', '地方国营六连林场', '3', '31718', 'D');
INSERT INTO `ey_region` VALUES ('31738', '东方市', '2', '31563', 'D');
INSERT INTO `ey_region` VALUES ('31739', '八所镇', '3', '31738', 'B');
INSERT INTO `ey_region` VALUES ('31740', '东河镇', '3', '31738', 'D');
INSERT INTO `ey_region` VALUES ('31741', '大田镇', '3', '31738', 'D');
INSERT INTO `ey_region` VALUES ('31742', '感城镇', '3', '31738', 'G');
INSERT INTO `ey_region` VALUES ('31743', '板桥镇', '3', '31738', 'B');
INSERT INTO `ey_region` VALUES ('31744', '三家镇', '3', '31738', 'S');
INSERT INTO `ey_region` VALUES ('31745', '四更镇', '3', '31738', 'S');
INSERT INTO `ey_region` VALUES ('31746', '新龙镇', '3', '31738', 'X');
INSERT INTO `ey_region` VALUES ('31747', '天安乡', '3', '31738', 'T');
INSERT INTO `ey_region` VALUES ('31748', '江边乡', '3', '31738', 'J');
INSERT INTO `ey_region` VALUES ('31749', '国营广坝农场', '3', '31738', 'G');
INSERT INTO `ey_region` VALUES ('31750', '国营公爱农场', '3', '31738', 'G');
INSERT INTO `ey_region` VALUES ('31751', '国营红泉农场', '3', '31738', 'G');
INSERT INTO `ey_region` VALUES ('31752', '省国营东方华侨农场', '3', '31738', 'S');
INSERT INTO `ey_region` VALUES ('31753', '定安县', '2', '31563', 'D');
INSERT INTO `ey_region` VALUES ('31754', '定城镇', '3', '31753', 'D');
INSERT INTO `ey_region` VALUES ('31755', '新竹镇', '3', '31753', 'X');
INSERT INTO `ey_region` VALUES ('31756', '龙湖镇', '3', '31753', 'L');
INSERT INTO `ey_region` VALUES ('31757', '黄竹镇', '3', '31753', 'H');
INSERT INTO `ey_region` VALUES ('31758', '雷鸣镇', '3', '31753', 'L');
INSERT INTO `ey_region` VALUES ('31759', '龙门镇', '3', '31753', 'L');
INSERT INTO `ey_region` VALUES ('31760', '龙河镇', '3', '31753', 'L');
INSERT INTO `ey_region` VALUES ('31761', '岭口镇', '3', '31753', 'L');
INSERT INTO `ey_region` VALUES ('31762', '翰林镇', '3', '31753', 'H');
INSERT INTO `ey_region` VALUES ('31763', '富文镇', '3', '31753', 'F');
INSERT INTO `ey_region` VALUES ('31764', '国营中瑞农场', '3', '31753', 'G');
INSERT INTO `ey_region` VALUES ('31765', '国营南海农场', '3', '31753', 'G');
INSERT INTO `ey_region` VALUES ('31766', '国营金鸡岭农场', '3', '31753', 'G');
INSERT INTO `ey_region` VALUES ('31767', '定安热作研究所', '3', '31753', 'D');
INSERT INTO `ey_region` VALUES ('31768', '屯昌县', '2', '31563', 'T');
INSERT INTO `ey_region` VALUES ('31769', '屯城镇', '3', '31768', 'T');
INSERT INTO `ey_region` VALUES ('31770', '新兴镇', '3', '31768', 'X');
INSERT INTO `ey_region` VALUES ('31771', '枫木镇', '3', '31768', 'F');
INSERT INTO `ey_region` VALUES ('31772', '乌坡镇', '3', '31768', 'W');
INSERT INTO `ey_region` VALUES ('31773', '南吕镇', '3', '31768', 'N');
INSERT INTO `ey_region` VALUES ('31774', '南坤镇', '3', '31768', 'N');
INSERT INTO `ey_region` VALUES ('31775', '坡心镇', '3', '31768', 'P');
INSERT INTO `ey_region` VALUES ('31776', '西昌镇', '3', '31768', 'X');
INSERT INTO `ey_region` VALUES ('31777', '国营中建农场', '3', '31768', 'G');
INSERT INTO `ey_region` VALUES ('31778', '国营中坤农场', '3', '31768', 'G');
INSERT INTO `ey_region` VALUES ('31779', '国营黄岭农场', '3', '31768', 'G');
INSERT INTO `ey_region` VALUES ('31780', '国营南吕农场', '3', '31768', 'G');
INSERT INTO `ey_region` VALUES ('31781', '国营广青农场', '3', '31768', 'G');
INSERT INTO `ey_region` VALUES ('31782', '国营晨星农场', '3', '31768', 'G');
INSERT INTO `ey_region` VALUES ('31783', '澄迈县', '2', '31563', 'C');
INSERT INTO `ey_region` VALUES ('31784', '金江镇', '3', '31783', 'J');
INSERT INTO `ey_region` VALUES ('31785', '老城镇', '3', '31783', 'L');
INSERT INTO `ey_region` VALUES ('31786', '瑞溪镇', '3', '31783', 'R');
INSERT INTO `ey_region` VALUES ('31787', '永发镇', '3', '31783', 'Y');
INSERT INTO `ey_region` VALUES ('31788', '加乐镇', '3', '31783', 'J');
INSERT INTO `ey_region` VALUES ('31789', '文儒镇', '3', '31783', 'W');
INSERT INTO `ey_region` VALUES ('31790', '中兴镇', '3', '31783', 'Z');
INSERT INTO `ey_region` VALUES ('31791', '仁兴镇', '3', '31783', 'R');
INSERT INTO `ey_region` VALUES ('31792', '福山镇', '3', '31783', 'F');
INSERT INTO `ey_region` VALUES ('31793', '桥头镇', '3', '31783', 'Q');
INSERT INTO `ey_region` VALUES ('31794', '国营红光农场', '3', '31783', 'G');
INSERT INTO `ey_region` VALUES ('31795', '国营红岗农场', '3', '31783', 'G');
INSERT INTO `ey_region` VALUES ('31796', '国营西达农场', '3', '31783', 'G');
INSERT INTO `ey_region` VALUES ('31797', '国营昆仑农场', '3', '31783', 'G');
INSERT INTO `ey_region` VALUES ('31798', '国营和岭农场', '3', '31783', 'G');
INSERT INTO `ey_region` VALUES ('31799', '国营金安农场', '3', '31783', 'G');
INSERT INTO `ey_region` VALUES ('31800', '澄迈县华侨农场', '3', '31783', 'C');
INSERT INTO `ey_region` VALUES ('31801', '临高县', '2', '31563', 'L');
INSERT INTO `ey_region` VALUES ('31802', '临城镇', '3', '31801', 'L');
INSERT INTO `ey_region` VALUES ('31803', '波莲镇', '3', '31801', 'B');
INSERT INTO `ey_region` VALUES ('31804', '东英镇', '3', '31801', 'D');
INSERT INTO `ey_region` VALUES ('31805', '博厚镇', '3', '31801', 'B');
INSERT INTO `ey_region` VALUES ('31806', '皇桐镇', '3', '31801', 'H');
INSERT INTO `ey_region` VALUES ('31807', '多文镇', '3', '31801', 'D');
INSERT INTO `ey_region` VALUES ('31808', '和舍镇', '3', '31801', 'H');
INSERT INTO `ey_region` VALUES ('31809', '南宝镇', '3', '31801', 'N');
INSERT INTO `ey_region` VALUES ('31810', '新盈镇', '3', '31801', 'X');
INSERT INTO `ey_region` VALUES ('31811', '调楼镇', '3', '31801', 'D');
INSERT INTO `ey_region` VALUES ('31812', '国营红华农场', '3', '31801', 'G');
INSERT INTO `ey_region` VALUES ('31813', '国营加来农场', '3', '31801', 'G');
INSERT INTO `ey_region` VALUES ('31814', '白沙县', '2', '31563', 'B');
INSERT INTO `ey_region` VALUES ('31815', '牙叉镇', '3', '31814', 'Y');
INSERT INTO `ey_region` VALUES ('31816', '七坊镇', '3', '31814', 'Q');
INSERT INTO `ey_region` VALUES ('31817', '邦溪镇', '3', '31814', 'B');
INSERT INTO `ey_region` VALUES ('31818', '打安镇', '3', '31814', 'D');
INSERT INTO `ey_region` VALUES ('31819', '细水乡', '3', '31814', 'X');
INSERT INTO `ey_region` VALUES ('31820', '元门乡', '3', '31814', 'Y');
INSERT INTO `ey_region` VALUES ('31821', '南开乡', '3', '31814', 'N');
INSERT INTO `ey_region` VALUES ('31822', '阜龙乡', '3', '31814', 'F');
INSERT INTO `ey_region` VALUES ('31823', '青松乡', '3', '31814', 'Q');
INSERT INTO `ey_region` VALUES ('31824', '金波乡', '3', '31814', 'J');
INSERT INTO `ey_region` VALUES ('31825', '荣邦乡', '3', '31814', 'R');
INSERT INTO `ey_region` VALUES ('31826', '国营金波农场', '3', '31814', 'G');
INSERT INTO `ey_region` VALUES ('31827', '国营白沙农场', '3', '31814', 'G');
INSERT INTO `ey_region` VALUES ('31828', '国营牙叉农场', '3', '31814', 'G');
INSERT INTO `ey_region` VALUES ('31829', '国营卫星农场', '3', '31814', 'G');
INSERT INTO `ey_region` VALUES ('31830', '国营龙江农场', '3', '31814', 'G');
INSERT INTO `ey_region` VALUES ('31831', '国营珠碧江农场', '3', '31814', 'G');
INSERT INTO `ey_region` VALUES ('31832', '国营芙蓉田农场', '3', '31814', 'G');
INSERT INTO `ey_region` VALUES ('31833', '国营大岭农场', '3', '31814', 'G');
INSERT INTO `ey_region` VALUES ('31834', '国营邦溪农场', '3', '31814', 'G');
INSERT INTO `ey_region` VALUES ('31835', '昌江县', '2', '31563', 'C');
INSERT INTO `ey_region` VALUES ('31836', '石碌镇', '3', '31835', 'S');
INSERT INTO `ey_region` VALUES ('31837', '叉河镇', '3', '31835', 'C');
INSERT INTO `ey_region` VALUES ('31838', '十月田镇', '3', '31835', 'S');
INSERT INTO `ey_region` VALUES ('31839', '乌烈镇', '3', '31835', 'W');
INSERT INTO `ey_region` VALUES ('31840', '昌化镇', '3', '31835', 'C');
INSERT INTO `ey_region` VALUES ('31841', '海尾镇', '3', '31835', 'H');
INSERT INTO `ey_region` VALUES ('31842', '七叉镇', '3', '31835', 'Q');
INSERT INTO `ey_region` VALUES ('31843', '王下乡', '3', '31835', 'W');
INSERT INTO `ey_region` VALUES ('31844', '国营红田农场', '3', '31835', 'G');
INSERT INTO `ey_region` VALUES ('31845', '国营红林农场', '3', '31835', 'G');
INSERT INTO `ey_region` VALUES ('31846', '国营坝王岭林场', '3', '31835', 'G');
INSERT INTO `ey_region` VALUES ('31847', '海南钢铁公司', '3', '31835', 'H');
INSERT INTO `ey_region` VALUES ('31848', '乐东县', '2', '31563', 'L');
INSERT INTO `ey_region` VALUES ('31849', '抱由镇', '3', '31848', 'B');
INSERT INTO `ey_region` VALUES ('31850', '万冲镇', '3', '31848', 'W');
INSERT INTO `ey_region` VALUES ('31851', '大安镇', '3', '31848', 'D');
INSERT INTO `ey_region` VALUES ('31852', '志仲镇', '3', '31848', 'Z');
INSERT INTO `ey_region` VALUES ('31853', '千家镇', '3', '31848', 'Q');
INSERT INTO `ey_region` VALUES ('31854', '九所镇', '3', '31848', 'J');
INSERT INTO `ey_region` VALUES ('31855', '利国镇', '3', '31848', 'L');
INSERT INTO `ey_region` VALUES ('31856', '黄流镇', '3', '31848', 'H');
INSERT INTO `ey_region` VALUES ('31857', '佛罗镇', '3', '31848', 'F');
INSERT INTO `ey_region` VALUES ('31858', '尖峰镇', '3', '31848', 'J');
INSERT INTO `ey_region` VALUES ('31859', '莺歌海镇', '3', '31848', 'Y');
INSERT INTO `ey_region` VALUES ('31860', '国营乐中农场', '3', '31848', 'G');
INSERT INTO `ey_region` VALUES ('31861', '国营山荣农场', '3', '31848', 'G');
INSERT INTO `ey_region` VALUES ('31862', '国营乐光农场', '3', '31848', 'G');
INSERT INTO `ey_region` VALUES ('31863', '国营报伦农场', '3', '31848', 'G');
INSERT INTO `ey_region` VALUES ('31864', '国营福报农场', '3', '31848', 'G');
INSERT INTO `ey_region` VALUES ('31865', '国营保国农场', '3', '31848', 'G');
INSERT INTO `ey_region` VALUES ('31866', '国营保显农场', '3', '31848', 'G');
INSERT INTO `ey_region` VALUES ('31867', '国营尖峰岭林业公司', '3', '31848', 'G');
INSERT INTO `ey_region` VALUES ('31868', '国营莺歌海盐场', '3', '31848', 'G');
INSERT INTO `ey_region` VALUES ('31869', '陵水县', '2', '31563', 'L');
INSERT INTO `ey_region` VALUES ('31870', '椰林镇', '3', '31869', 'Y');
INSERT INTO `ey_region` VALUES ('31871', '光坡镇', '3', '31869', 'G');
INSERT INTO `ey_region` VALUES ('31872', '三才镇', '3', '31869', 'S');
INSERT INTO `ey_region` VALUES ('31873', '英州镇', '3', '31869', 'Y');
INSERT INTO `ey_region` VALUES ('31874', '隆广镇', '3', '31869', 'L');
INSERT INTO `ey_region` VALUES ('31875', '文罗镇', '3', '31869', 'W');
INSERT INTO `ey_region` VALUES ('31876', '本号镇', '3', '31869', 'B');
INSERT INTO `ey_region` VALUES ('31877', '新村镇', '3', '31869', 'X');
INSERT INTO `ey_region` VALUES ('31878', '黎安镇', '3', '31869', 'L');
INSERT INTO `ey_region` VALUES ('31879', '提蒙乡', '3', '31869', 'T');
INSERT INTO `ey_region` VALUES ('31880', '群英乡', '3', '31869', 'Q');
INSERT INTO `ey_region` VALUES ('31881', '国营岭门农场', '3', '31869', 'G');
INSERT INTO `ey_region` VALUES ('31882', '国营南平农场', '3', '31869', 'G');
INSERT INTO `ey_region` VALUES ('31883', '国营吊罗山林业公司', '3', '31869', 'G');
INSERT INTO `ey_region` VALUES ('31884', '保亭县', '2', '31563', 'B');
INSERT INTO `ey_region` VALUES ('31885', '保城镇', '3', '31884', 'B');
INSERT INTO `ey_region` VALUES ('31886', '什玲镇', '3', '31884', 'S');
INSERT INTO `ey_region` VALUES ('31887', '加茂镇', '3', '31884', 'J');
INSERT INTO `ey_region` VALUES ('31888', '响水镇', '3', '31884', 'X');
INSERT INTO `ey_region` VALUES ('31889', '新政镇', '3', '31884', 'X');
INSERT INTO `ey_region` VALUES ('31890', '三道镇', '3', '31884', 'S');
INSERT INTO `ey_region` VALUES ('31891', '六弓乡', '3', '31884', 'L');
INSERT INTO `ey_region` VALUES ('31892', '南林乡', '3', '31884', 'N');
INSERT INTO `ey_region` VALUES ('31893', '毛感乡', '3', '31884', 'M');
INSERT INTO `ey_region` VALUES ('31894', '国营五指山茶场', '3', '31884', 'G');
INSERT INTO `ey_region` VALUES ('31895', '国营新星农场', '3', '31884', 'G');
INSERT INTO `ey_region` VALUES ('31896', '国营保亭热作所', '3', '31884', 'G');
INSERT INTO `ey_region` VALUES ('31897', '国营金江农场', '3', '31884', 'G');
INSERT INTO `ey_region` VALUES ('31898', '国营南茂农场', '3', '31884', 'G');
INSERT INTO `ey_region` VALUES ('31899', '国营三道农场', '3', '31884', 'G');
INSERT INTO `ey_region` VALUES ('31900', '琼中县', '2', '31563', 'Q');
INSERT INTO `ey_region` VALUES ('31901', '营根镇', '3', '31900', 'Y');
INSERT INTO `ey_region` VALUES ('31902', '湾岭镇', '3', '31900', 'W');
INSERT INTO `ey_region` VALUES ('31903', '黎母山镇', '3', '31900', 'L');
INSERT INTO `ey_region` VALUES ('31904', '和平镇', '3', '31900', 'H');
INSERT INTO `ey_region` VALUES ('31905', '长征镇', '3', '31900', 'C');
INSERT INTO `ey_region` VALUES ('31906', '红毛镇', '3', '31900', 'H');
INSERT INTO `ey_region` VALUES ('31907', '中平镇', '3', '31900', 'Z');
INSERT INTO `ey_region` VALUES ('31908', '吊罗山乡', '3', '31900', 'D');
INSERT INTO `ey_region` VALUES ('31909', '上安乡', '3', '31900', 'S');
INSERT INTO `ey_region` VALUES ('31910', '什运乡', '3', '31900', 'S');
INSERT INTO `ey_region` VALUES ('31911', '国营新进农场', '3', '31900', 'G');
INSERT INTO `ey_region` VALUES ('31912', '国营大丰农场', '3', '31900', 'G');
INSERT INTO `ey_region` VALUES ('31913', '国营阳江农场', '3', '31900', 'G');
INSERT INTO `ey_region` VALUES ('31914', '国营乌石农场', '3', '31900', 'G');
INSERT INTO `ey_region` VALUES ('31915', '国营南方农场', '3', '31900', 'G');
INSERT INTO `ey_region` VALUES ('31916', '国营岭头农场', '3', '31900', 'G');
INSERT INTO `ey_region` VALUES ('31917', '国营加钗农场', '3', '31900', 'G');
INSERT INTO `ey_region` VALUES ('31918', '国营长征农场', '3', '31900', 'G');
INSERT INTO `ey_region` VALUES ('31919', '国营乘坡农场', '3', '31900', 'G');
INSERT INTO `ey_region` VALUES ('31920', '国营太平农场', '3', '31900', 'G');
INSERT INTO `ey_region` VALUES ('31921', '国营新伟农场', '3', '31900', 'G');
INSERT INTO `ey_region` VALUES ('31922', '国营黎母山林业公司', '3', '31900', 'G');
INSERT INTO `ey_region` VALUES ('31923', '西沙群岛', '3', '31924', 'X');
INSERT INTO `ey_region` VALUES ('31924', '三沙市', '2', '31563', 'S');
INSERT INTO `ey_region` VALUES ('31925', '南沙群岛', '3', '31924', 'N');
INSERT INTO `ey_region` VALUES ('47499', '香港岛', '2', '47494', 'X');
INSERT INTO `ey_region` VALUES ('31927', '中沙群岛的岛礁及其海域', '3', '31924', 'Z');
INSERT INTO `ey_region` VALUES ('47498', '九龙', '2', '47494', 'J');
INSERT INTO `ey_region` VALUES ('31929', '重庆市', '1', '0', 'Z');
INSERT INTO `ey_region` VALUES ('31930', '重庆市', '2', '31929', 'C');
INSERT INTO `ey_region` VALUES ('31931', '万州区', '3', '31930', 'W');
INSERT INTO `ey_region` VALUES ('31984', '涪陵区', '3', '31930', 'F');
INSERT INTO `ey_region` VALUES ('32031', '渝中区', '3', '31930', 'Y');
INSERT INTO `ey_region` VALUES ('32044', '大渡口区', '3', '31930', 'D');
INSERT INTO `ey_region` VALUES ('32053', '江北区', '3', '31930', 'J');
INSERT INTO `ey_region` VALUES ('32066', '沙坪坝区', '3', '31930', 'S');
INSERT INTO `ey_region` VALUES ('32093', '九龙坡区', '3', '31930', 'J');
INSERT INTO `ey_region` VALUES ('32112', '南岸区', '3', '31930', 'N');
INSERT INTO `ey_region` VALUES ('32127', '北碚区', '3', '31930', 'B');
INSERT INTO `ey_region` VALUES ('32145', '万盛区', '3', '31930', 'W');
INSERT INTO `ey_region` VALUES ('32156', '双桥区', '3', '31930', 'S');
INSERT INTO `ey_region` VALUES ('32160', '渝北区', '3', '31930', 'Y');
INSERT INTO `ey_region` VALUES ('32191', '巴南区', '3', '31930', 'B');
INSERT INTO `ey_region` VALUES ('32213', '黔江区', '3', '31930', 'Q');
INSERT INTO `ey_region` VALUES ('32244', '长寿区', '3', '31930', 'C');
INSERT INTO `ey_region` VALUES ('32263', '江津区', '3', '31930', 'J');
INSERT INTO `ey_region` VALUES ('32291', '合川区', '3', '31930', 'H');
INSERT INTO `ey_region` VALUES ('32322', '永川区', '3', '31930', 'Y');
INSERT INTO `ey_region` VALUES ('32345', '南川区', '3', '31930', 'N');
INSERT INTO `ey_region` VALUES ('32380', '县', '2', '31929', 'X');
INSERT INTO `ey_region` VALUES ('32381', '綦江县', '3', '32380', 'Q');
INSERT INTO `ey_region` VALUES ('32401', '潼南县', '3', '32380', 'T');
INSERT INTO `ey_region` VALUES ('32424', '铜梁县', '3', '32380', 'T');
INSERT INTO `ey_region` VALUES ('32453', '大足县', '3', '32380', 'D');
INSERT INTO `ey_region` VALUES ('32478', '荣昌县', '3', '32380', 'R');
INSERT INTO `ey_region` VALUES ('32499', '璧山县', '3', '32380', 'B');
INSERT INTO `ey_region` VALUES ('32513', '梁平县', '3', '32380', 'L');
INSERT INTO `ey_region` VALUES ('32549', '城口县', '3', '32380', 'C');
INSERT INTO `ey_region` VALUES ('32574', '丰都县', '3', '32380', 'F');
INSERT INTO `ey_region` VALUES ('32606', '垫江县', '3', '32380', 'D');
INSERT INTO `ey_region` VALUES ('32632', '武隆县', '3', '32380', 'W');
INSERT INTO `ey_region` VALUES ('32659', '忠县', '3', '32380', 'Z');
INSERT INTO `ey_region` VALUES ('32688', '开县', '3', '32380', 'K');
INSERT INTO `ey_region` VALUES ('32727', '云阳县', '3', '32380', 'Y');
INSERT INTO `ey_region` VALUES ('32771', '奉节县', '3', '32380', 'F');
INSERT INTO `ey_region` VALUES ('32802', '巫山县', '3', '32380', 'W');
INSERT INTO `ey_region` VALUES ('32829', '巫溪县', '3', '32380', 'W');
INSERT INTO `ey_region` VALUES ('32861', '石柱县', '3', '32380', 'S');
INSERT INTO `ey_region` VALUES ('32894', '秀山县', '3', '32380', 'X');
INSERT INTO `ey_region` VALUES ('32927', '酉阳县', '3', '32380', 'Y');
INSERT INTO `ey_region` VALUES ('32967', '彭水县', '3', '32380', 'P');
INSERT INTO `ey_region` VALUES ('33007', '四川省', '1', '0', 'S');
INSERT INTO `ey_region` VALUES ('33008', '成都市', '2', '33007', 'C');
INSERT INTO `ey_region` VALUES ('33009', '市辖区', '3', '33008', 'S');
INSERT INTO `ey_region` VALUES ('33010', '锦江区', '3', '33008', 'J');
INSERT INTO `ey_region` VALUES ('33027', '青羊区', '3', '33008', 'Q');
INSERT INTO `ey_region` VALUES ('33042', '金牛区', '3', '33008', 'J');
INSERT INTO `ey_region` VALUES ('33058', '武侯区', '3', '33008', 'W');
INSERT INTO `ey_region` VALUES ('33076', '成华区', '3', '33008', 'C');
INSERT INTO `ey_region` VALUES ('33091', '龙泉驿区', '3', '33008', 'L');
INSERT INTO `ey_region` VALUES ('33104', '青白江区', '3', '33008', 'Q');
INSERT INTO `ey_region` VALUES ('33116', '新都区', '3', '33008', 'X');
INSERT INTO `ey_region` VALUES ('33130', '温江区', '3', '33008', 'W');
INSERT INTO `ey_region` VALUES ('33141', '金堂县', '3', '33008', 'J');
INSERT INTO `ey_region` VALUES ('33163', '双流县', '3', '33008', 'S');
INSERT INTO `ey_region` VALUES ('33189', '郫县', '3', '33008', 'P');
INSERT INTO `ey_region` VALUES ('33205', '大邑县', '3', '33008', 'D');
INSERT INTO `ey_region` VALUES ('33226', '蒲江县', '3', '33008', 'P');
INSERT INTO `ey_region` VALUES ('33239', '新津县', '3', '33008', 'X');
INSERT INTO `ey_region` VALUES ('33252', '都江堰市', '3', '33008', 'D');
INSERT INTO `ey_region` VALUES ('33272', '彭州市', '3', '33008', 'P');
INSERT INTO `ey_region` VALUES ('33293', '邛崃市', '3', '33008', 'Q');
INSERT INTO `ey_region` VALUES ('33318', '崇州市', '3', '33008', 'C');
INSERT INTO `ey_region` VALUES ('33344', '自贡市', '2', '33007', 'Z');
INSERT INTO `ey_region` VALUES ('33345', '市辖区', '3', '33344', 'S');
INSERT INTO `ey_region` VALUES ('33346', '自流井区', '3', '33344', 'Z');
INSERT INTO `ey_region` VALUES ('33360', '贡井区', '3', '33344', 'G');
INSERT INTO `ey_region` VALUES ('33374', '大安区', '3', '33344', 'D');
INSERT INTO `ey_region` VALUES ('33391', '沿滩区', '3', '33344', 'Y');
INSERT INTO `ey_region` VALUES ('33405', '荣县', '3', '33344', 'R');
INSERT INTO `ey_region` VALUES ('33433', '富顺县', '3', '33344', 'F');
INSERT INTO `ey_region` VALUES ('33460', '攀枝花市', '2', '33007', 'P');
INSERT INTO `ey_region` VALUES ('33461', '市辖区', '3', '33460', 'S');
INSERT INTO `ey_region` VALUES ('33462', '攀枝花东区', '3', '33460', 'P');
INSERT INTO `ey_region` VALUES ('33473', '西区', '3', '33460', 'X');
INSERT INTO `ey_region` VALUES ('33481', '仁和区', '3', '33460', 'R');
INSERT INTO `ey_region` VALUES ('33497', '米易县', '3', '33460', 'M');
INSERT INTO `ey_region` VALUES ('33511', '盐边县', '3', '33460', 'Y');
INSERT INTO `ey_region` VALUES ('33528', '泸州市', '2', '33007', 'L');
INSERT INTO `ey_region` VALUES ('33529', '市辖区', '3', '33528', 'S');
INSERT INTO `ey_region` VALUES ('33530', '江阳区', '3', '33528', 'J');
INSERT INTO `ey_region` VALUES ('33548', '纳溪区', '3', '33528', 'N');
INSERT INTO `ey_region` VALUES ('33563', '龙马潭区', '3', '33528', 'L');
INSERT INTO `ey_region` VALUES ('33577', '泸县', '3', '33528', 'L');
INSERT INTO `ey_region` VALUES ('33597', '合江县', '3', '33528', 'H');
INSERT INTO `ey_region` VALUES ('33625', '叙永县', '3', '33528', 'X');
INSERT INTO `ey_region` VALUES ('33654', '古蔺县', '3', '33528', 'G');
INSERT INTO `ey_region` VALUES ('33681', '德阳市', '2', '33007', 'D');
INSERT INTO `ey_region` VALUES ('33682', '市辖区', '3', '33681', 'S');
INSERT INTO `ey_region` VALUES ('33683', '旌阳区', '3', '33681', 'J');
INSERT INTO `ey_region` VALUES ('33701', '中江县', '3', '33681', 'Z');
INSERT INTO `ey_region` VALUES ('33747', '罗江县', '3', '33681', 'L');
INSERT INTO `ey_region` VALUES ('33758', '广汉市', '3', '33681', 'G');
INSERT INTO `ey_region` VALUES ('33778', '什邡市', '3', '33681', 'S');
INSERT INTO `ey_region` VALUES ('33795', '绵竹市', '3', '33681', 'M');
INSERT INTO `ey_region` VALUES ('33817', '绵阳市', '2', '33007', 'M');
INSERT INTO `ey_region` VALUES ('33818', '市辖区', '3', '33817', 'S');
INSERT INTO `ey_region` VALUES ('33819', '涪城区', '3', '33817', 'F');
INSERT INTO `ey_region` VALUES ('33844', '游仙区', '3', '33817', 'Y');
INSERT INTO `ey_region` VALUES ('33873', '三台县', '3', '33817', 'S');
INSERT INTO `ey_region` VALUES ('33937', '盐亭县', '3', '33817', 'Y');
INSERT INTO `ey_region` VALUES ('33974', '安县', '3', '33817', 'A');
INSERT INTO `ey_region` VALUES ('33995', '梓潼县', '3', '33817', 'Z');
INSERT INTO `ey_region` VALUES ('34028', '北川县', '3', '33817', 'B');
INSERT INTO `ey_region` VALUES ('34049', '平武县', '3', '33817', 'P');
INSERT INTO `ey_region` VALUES ('34075', '江油市', '3', '33817', 'J');
INSERT INTO `ey_region` VALUES ('34120', '广元市', '2', '33007', 'G');
INSERT INTO `ey_region` VALUES ('34121', '市辖区', '3', '34120', 'S');
INSERT INTO `ey_region` VALUES ('34122', '市中区', '3', '34120', 'S');
INSERT INTO `ey_region` VALUES ('34143', '元坝区', '3', '34120', 'Y');
INSERT INTO `ey_region` VALUES ('34173', '朝天区', '3', '34120', 'C');
INSERT INTO `ey_region` VALUES ('34199', '旺苍县', '3', '34120', 'W');
INSERT INTO `ey_region` VALUES ('34238', '青川县', '3', '34120', 'Q');
INSERT INTO `ey_region` VALUES ('34276', '剑阁县', '3', '34120', 'J');
INSERT INTO `ey_region` VALUES ('34334', '苍溪县', '3', '34120', 'C');
INSERT INTO `ey_region` VALUES ('34376', '遂宁市', '2', '33007', 'S');
INSERT INTO `ey_region` VALUES ('34377', '市辖区', '3', '34376', 'S');
INSERT INTO `ey_region` VALUES ('34378', '船山区', '3', '34376', 'C');
INSERT INTO `ey_region` VALUES ('34404', '安居区', '3', '34376', 'A');
INSERT INTO `ey_region` VALUES ('34426', '蓬溪县', '3', '34376', 'P');
INSERT INTO `ey_region` VALUES ('34458', '射洪县', '3', '34376', 'S');
INSERT INTO `ey_region` VALUES ('34489', '大英县', '3', '34376', 'D');
INSERT INTO `ey_region` VALUES ('34501', '内江市', '2', '33007', 'N');
INSERT INTO `ey_region` VALUES ('34502', '市辖区', '3', '34501', 'S');
INSERT INTO `ey_region` VALUES ('34503', '市中区', '3', '34501', 'S');
INSERT INTO `ey_region` VALUES ('34524', '东兴区', '3', '34501', 'D');
INSERT INTO `ey_region` VALUES ('34554', '威远县', '3', '34501', 'W');
INSERT INTO `ey_region` VALUES ('34575', '资中县', '3', '34501', 'Z');
INSERT INTO `ey_region` VALUES ('34609', '隆昌县', '3', '34501', 'L');
INSERT INTO `ey_region` VALUES ('34628', '乐山市', '2', '33007', 'L');
INSERT INTO `ey_region` VALUES ('34629', '市辖区', '3', '34628', 'S');
INSERT INTO `ey_region` VALUES ('34630', '市中区', '3', '34628', 'S');
INSERT INTO `ey_region` VALUES ('34661', '沙湾区', '3', '34628', 'S');
INSERT INTO `ey_region` VALUES ('34676', '五通桥区', '3', '34628', 'W');
INSERT INTO `ey_region` VALUES ('34689', '金口河区', '3', '34628', 'J');
INSERT INTO `ey_region` VALUES ('34696', '犍为县', '3', '34628', 'Q');
INSERT INTO `ey_region` VALUES ('34727', '井研县', '3', '34628', 'J');
INSERT INTO `ey_region` VALUES ('34755', '夹江县', '3', '34628', 'J');
INSERT INTO `ey_region` VALUES ('34778', '沐川县', '3', '34628', 'M');
INSERT INTO `ey_region` VALUES ('34799', '峨边县', '3', '34628', 'E');
INSERT INTO `ey_region` VALUES ('34819', '马边县', '3', '34628', 'M');
INSERT INTO `ey_region` VALUES ('34840', '峨眉山市', '3', '34628', 'E');
INSERT INTO `ey_region` VALUES ('34859', '南充市', '2', '33007', 'N');
INSERT INTO `ey_region` VALUES ('34860', '市辖区', '3', '34859', 'S');
INSERT INTO `ey_region` VALUES ('34861', '顺庆区', '3', '34859', 'S');
INSERT INTO `ey_region` VALUES ('34890', '高坪区', '3', '34859', 'G');
INSERT INTO `ey_region` VALUES ('34923', '嘉陵区', '3', '34859', 'J');
INSERT INTO `ey_region` VALUES ('34967', '南部县', '3', '34859', 'N');
INSERT INTO `ey_region` VALUES ('35040', '营山县', '3', '34859', 'Y');
INSERT INTO `ey_region` VALUES ('35094', '蓬安县', '3', '34859', 'P');
INSERT INTO `ey_region` VALUES ('35134', '仪陇县', '3', '34859', 'Y');
INSERT INTO `ey_region` VALUES ('35193', '西充县', '3', '34859', 'X');
INSERT INTO `ey_region` VALUES ('35238', '阆中市', '3', '34859', 'L');
INSERT INTO `ey_region` VALUES ('35288', '眉山市', '2', '33007', 'M');
INSERT INTO `ey_region` VALUES ('35289', '市辖区', '3', '35288', 'S');
INSERT INTO `ey_region` VALUES ('35290', '东坡区', '3', '35288', 'D');
INSERT INTO `ey_region` VALUES ('35317', '仁寿县', '3', '35288', 'R');
INSERT INTO `ey_region` VALUES ('35378', '彭山县', '3', '35288', 'P');
INSERT INTO `ey_region` VALUES ('35392', '洪雅县', '3', '35288', 'H');
INSERT INTO `ey_region` VALUES ('35408', '丹棱县', '3', '35288', 'D');
INSERT INTO `ey_region` VALUES ('35416', '青神县', '3', '35288', 'Q');
INSERT INTO `ey_region` VALUES ('35427', '宜宾市', '2', '33007', 'Y');
INSERT INTO `ey_region` VALUES ('35428', '市辖区', '3', '35427', 'S');
INSERT INTO `ey_region` VALUES ('35429', '翠屏区', '3', '35427', 'C');
INSERT INTO `ey_region` VALUES ('35454', '宜宾县', '3', '35427', 'Y');
INSERT INTO `ey_region` VALUES ('35481', '南溪县', '3', '35427', 'N');
INSERT INTO `ey_region` VALUES ('35497', '江安县', '3', '35427', 'J');
INSERT INTO `ey_region` VALUES ('35516', '长宁县', '3', '35427', 'C');
INSERT INTO `ey_region` VALUES ('35535', '高县', '3', '35427', 'G');
INSERT INTO `ey_region` VALUES ('35555', '珙县', '3', '35427', 'G');
INSERT INTO `ey_region` VALUES ('35573', '筠连县', '3', '35427', 'J');
INSERT INTO `ey_region` VALUES ('35592', '兴文县', '3', '35427', 'X');
INSERT INTO `ey_region` VALUES ('35608', '屏山县', '3', '35427', 'P');
INSERT INTO `ey_region` VALUES ('35625', '广安市', '2', '33007', 'G');
INSERT INTO `ey_region` VALUES ('35626', '市辖区', '3', '35625', 'S');
INSERT INTO `ey_region` VALUES ('35627', '广安区', '3', '35625', 'G');
INSERT INTO `ey_region` VALUES ('35677', '岳池县', '3', '35625', 'Y');
INSERT INTO `ey_region` VALUES ('35721', '武胜县', '3', '35625', 'W');
INSERT INTO `ey_region` VALUES ('35753', '邻水县', '3', '35625', 'L');
INSERT INTO `ey_region` VALUES ('35799', '华蓥市', '3', '35625', 'H');
INSERT INTO `ey_region` VALUES ('35813', '达州市', '2', '33007', 'D');
INSERT INTO `ey_region` VALUES ('35814', '市辖区', '3', '35813', 'S');
INSERT INTO `ey_region` VALUES ('35815', '通川区', '3', '35813', 'T');
INSERT INTO `ey_region` VALUES ('35829', '达县', '3', '35813', 'D');
INSERT INTO `ey_region` VALUES ('35894', '宣汉县', '3', '35813', 'X');
INSERT INTO `ey_region` VALUES ('35949', '开江县', '3', '35813', 'K');
INSERT INTO `ey_region` VALUES ('35970', '大竹县', '3', '35813', 'D');
INSERT INTO `ey_region` VALUES ('36021', '渠县', '3', '35813', 'Q');
INSERT INTO `ey_region` VALUES ('36082', '万源市', '3', '35813', 'W');
INSERT INTO `ey_region` VALUES ('36136', '雅安市', '2', '33007', 'Y');
INSERT INTO `ey_region` VALUES ('36137', '市辖区', '3', '36136', 'S');
INSERT INTO `ey_region` VALUES ('36138', '雨城区', '3', '36136', 'Y');
INSERT INTO `ey_region` VALUES ('36161', '名山县', '3', '36136', 'M');
INSERT INTO `ey_region` VALUES ('36182', '荥经县', '3', '36136', 'Y');
INSERT INTO `ey_region` VALUES ('36204', '汉源县', '3', '36136', 'H');
INSERT INTO `ey_region` VALUES ('36245', '石棉县', '3', '36136', 'S');
INSERT INTO `ey_region` VALUES ('36263', '天全县', '3', '36136', 'T');
INSERT INTO `ey_region` VALUES ('36279', '芦山县', '3', '36136', 'L');
INSERT INTO `ey_region` VALUES ('36289', '宝兴县', '3', '36136', 'B');
INSERT INTO `ey_region` VALUES ('36299', '巴中市', '2', '33007', 'B');
INSERT INTO `ey_region` VALUES ('36300', '市辖区', '3', '36299', 'S');
INSERT INTO `ey_region` VALUES ('36301', '巴州区', '3', '36299', 'B');
INSERT INTO `ey_region` VALUES ('36354', '通江县', '3', '36299', 'T');
INSERT INTO `ey_region` VALUES ('36404', '南江县', '3', '36299', 'N');
INSERT INTO `ey_region` VALUES ('36453', '平昌县', '3', '36299', 'P');
INSERT INTO `ey_region` VALUES ('36497', '资阳市', '2', '33007', 'Z');
INSERT INTO `ey_region` VALUES ('36498', '市辖区', '3', '36497', 'S');
INSERT INTO `ey_region` VALUES ('36499', '雁江区', '3', '36497', 'Y');
INSERT INTO `ey_region` VALUES ('36527', '安岳县', '3', '36497', 'A');
INSERT INTO `ey_region` VALUES ('36597', '乐至县', '3', '36497', 'L');
INSERT INTO `ey_region` VALUES ('36623', '简阳市', '3', '36497', 'J');
INSERT INTO `ey_region` VALUES ('36679', '阿坝州', '2', '33007', 'A');
INSERT INTO `ey_region` VALUES ('36680', '汶川县', '3', '36679', 'W');
INSERT INTO `ey_region` VALUES ('36694', '理县', '3', '36679', 'L');
INSERT INTO `ey_region` VALUES ('36708', '茂县', '3', '36679', 'M');
INSERT INTO `ey_region` VALUES ('36731', '松潘县', '3', '36679', 'S');
INSERT INTO `ey_region` VALUES ('36759', '九寨沟县', '3', '36679', 'J');
INSERT INTO `ey_region` VALUES ('36778', '金川县', '3', '36679', 'J');
INSERT INTO `ey_region` VALUES ('36802', '小金县', '3', '36679', 'X');
INSERT INTO `ey_region` VALUES ('36824', '黑水县', '3', '36679', 'H');
INSERT INTO `ey_region` VALUES ('36842', '马尔康县', '3', '36679', 'M');
INSERT INTO `ey_region` VALUES ('36858', '壤塘县', '3', '36679', 'R');
INSERT INTO `ey_region` VALUES ('36871', '阿坝县', '3', '36679', 'A');
INSERT INTO `ey_region` VALUES ('36893', '若尔盖县', '3', '36679', 'R');
INSERT INTO `ey_region` VALUES ('36914', '红原县', '3', '36679', 'H');
INSERT INTO `ey_region` VALUES ('36926', '甘孜州', '2', '33007', 'G');
INSERT INTO `ey_region` VALUES ('36927', '康定县', '3', '36926', 'K');
INSERT INTO `ey_region` VALUES ('36949', '泸定县', '3', '36926', 'L');
INSERT INTO `ey_region` VALUES ('36962', '丹巴县', '3', '36926', 'D');
INSERT INTO `ey_region` VALUES ('36978', '九龙县', '3', '36926', 'J');
INSERT INTO `ey_region` VALUES ('36997', '雅江县', '3', '36926', 'Y');
INSERT INTO `ey_region` VALUES ('37015', '道孚县', '3', '36926', 'D');
INSERT INTO `ey_region` VALUES ('37038', '炉霍县', '3', '36926', 'L');
INSERT INTO `ey_region` VALUES ('37055', '甘孜县', '3', '36926', 'G');
INSERT INTO `ey_region` VALUES ('37078', '新龙县', '3', '36926', 'X');
INSERT INTO `ey_region` VALUES ('37098', '德格县', '3', '36926', 'D');
INSERT INTO `ey_region` VALUES ('37125', '白玉县', '3', '36926', 'B');
INSERT INTO `ey_region` VALUES ('37143', '石渠县', '3', '36926', 'S');
INSERT INTO `ey_region` VALUES ('37166', '色达县', '3', '36926', 'S');
INSERT INTO `ey_region` VALUES ('37184', '理塘县', '3', '36926', 'L');
INSERT INTO `ey_region` VALUES ('37209', '巴塘县', '3', '36926', 'B');
INSERT INTO `ey_region` VALUES ('37229', '乡城县', '3', '36926', 'X');
INSERT INTO `ey_region` VALUES ('37242', '稻城县', '3', '36926', 'D');
INSERT INTO `ey_region` VALUES ('37257', '得荣县', '3', '36926', 'D');
INSERT INTO `ey_region` VALUES ('37270', '凉山州', '2', '33007', 'L');
INSERT INTO `ey_region` VALUES ('37271', '西昌市', '3', '37270', 'X');
INSERT INTO `ey_region` VALUES ('37315', '木里县', '3', '37270', 'M');
INSERT INTO `ey_region` VALUES ('37345', '盐源县', '3', '37270', 'Y');
INSERT INTO `ey_region` VALUES ('37380', '德昌', '3', '37270', 'D');
INSERT INTO `ey_region` VALUES ('37404', '会理县', '3', '37270', 'H');
INSERT INTO `ey_region` VALUES ('37455', '会东县', '3', '37270', 'H');
INSERT INTO `ey_region` VALUES ('37509', '宁南县', '3', '37270', 'N');
INSERT INTO `ey_region` VALUES ('37535', '普格县', '3', '37270', 'P');
INSERT INTO `ey_region` VALUES ('37570', '布拖县', '3', '37270', 'B');
INSERT INTO `ey_region` VALUES ('37601', '金阳县', '3', '37270', 'J');
INSERT INTO `ey_region` VALUES ('37636', '昭觉县', '3', '37270', 'Z');
INSERT INTO `ey_region` VALUES ('37684', '喜德县', '3', '37270', 'X');
INSERT INTO `ey_region` VALUES ('37709', '冕宁县', '3', '37270', 'M');
INSERT INTO `ey_region` VALUES ('37748', '越西县', '3', '37270', 'Y');
INSERT INTO `ey_region` VALUES ('37790', '甘洛县', '3', '37270', 'G');
INSERT INTO `ey_region` VALUES ('37819', '美姑县', '3', '37270', 'M');
INSERT INTO `ey_region` VALUES ('37856', '雷波县', '3', '37270', 'L');
INSERT INTO `ey_region` VALUES ('37906', '贵州省', '1', '0', 'G');
INSERT INTO `ey_region` VALUES ('37907', '贵阳市', '2', '37906', 'G');
INSERT INTO `ey_region` VALUES ('37908', '市辖区', '3', '37907', 'S');
INSERT INTO `ey_region` VALUES ('37909', '南明区', '3', '37907', 'N');
INSERT INTO `ey_region` VALUES ('37927', '云岩区', '3', '37907', 'Y');
INSERT INTO `ey_region` VALUES ('37944', '花溪区', '3', '37907', 'H');
INSERT INTO `ey_region` VALUES ('37961', '乌当区', '3', '37907', 'W');
INSERT INTO `ey_region` VALUES ('37977', '白云区', '3', '37907', 'B');
INSERT INTO `ey_region` VALUES ('37987', '小河区', '3', '37907', 'X');
INSERT INTO `ey_region` VALUES ('37991', '开阳县', '3', '37907', 'K');
INSERT INTO `ey_region` VALUES ('38008', '息烽县', '3', '37907', 'X');
INSERT INTO `ey_region` VALUES ('38019', '修文县', '3', '37907', 'X');
INSERT INTO `ey_region` VALUES ('38030', '清镇市', '3', '37907', 'Q');
INSERT INTO `ey_region` VALUES ('38042', '六盘水市', '2', '37906', 'L');
INSERT INTO `ey_region` VALUES ('38043', '钟山区', '3', '38042', 'Z');
INSERT INTO `ey_region` VALUES ('38053', '六枝特区', '3', '38042', 'L');
INSERT INTO `ey_region` VALUES ('38073', '水城县', '3', '38042', 'S');
INSERT INTO `ey_region` VALUES ('38107', '盘县', '3', '38042', 'P');
INSERT INTO `ey_region` VALUES ('38145', '遵义市', '2', '37906', 'Z');
INSERT INTO `ey_region` VALUES ('38146', '市辖区', '3', '38145', 'S');
INSERT INTO `ey_region` VALUES ('38147', '红花岗区', '3', '38145', 'H');
INSERT INTO `ey_region` VALUES ('38164', '汇川区', '3', '38145', 'H');
INSERT INTO `ey_region` VALUES ('38174', '遵义县', '3', '38145', 'Z');
INSERT INTO `ey_region` VALUES ('38206', '桐梓县', '3', '38145', 'T');
INSERT INTO `ey_region` VALUES ('38231', '绥阳县', '3', '38145', 'S');
INSERT INTO `ey_region` VALUES ('38247', '正安县', '3', '38145', 'Z');
INSERT INTO `ey_region` VALUES ('38267', '道真县', '3', '38145', 'D');
INSERT INTO `ey_region` VALUES ('38282', '务川县', '3', '38145', 'W');
INSERT INTO `ey_region` VALUES ('38298', '凤冈县', '3', '38145', 'F');
INSERT INTO `ey_region` VALUES ('38313', '湄潭县', '3', '38145', 'M');
INSERT INTO `ey_region` VALUES ('38329', '余庆县', '3', '38145', 'Y');
INSERT INTO `ey_region` VALUES ('38340', '习水县', '3', '38145', 'X');
INSERT INTO `ey_region` VALUES ('38364', '赤水市', '3', '38145', 'C');
INSERT INTO `ey_region` VALUES ('38382', '仁怀市', '3', '38145', 'R');
INSERT INTO `ey_region` VALUES ('38402', '安顺市', '2', '37906', 'A');
INSERT INTO `ey_region` VALUES ('38403', '市辖区', '3', '38402', 'S');
INSERT INTO `ey_region` VALUES ('38404', '西秀区', '3', '38402', 'X');
INSERT INTO `ey_region` VALUES ('38429', '平坝县', '3', '38402', 'P');
INSERT INTO `ey_region` VALUES ('38440', '普定县', '3', '38402', 'P');
INSERT INTO `ey_region` VALUES ('38452', '镇宁县', '3', '38402', 'Z');
INSERT INTO `ey_region` VALUES ('38469', '关岭县', '3', '38402', 'G');
INSERT INTO `ey_region` VALUES ('38484', '紫云县', '3', '38402', 'Z');
INSERT INTO `ey_region` VALUES ('38497', '铜仁地区', '2', '37906', 'T');
INSERT INTO `ey_region` VALUES ('38498', '铜仁市', '3', '38497', 'T');
INSERT INTO `ey_region` VALUES ('38516', '江口县', '3', '38497', 'J');
INSERT INTO `ey_region` VALUES ('38526', '玉屏县', '3', '38497', 'Y');
INSERT INTO `ey_region` VALUES ('38533', '石阡县', '3', '38497', 'S');
INSERT INTO `ey_region` VALUES ('38552', '思南县　', '3', '38497', 'S');
INSERT INTO `ey_region` VALUES ('38580', '印江县', '3', '38497', 'Y');
INSERT INTO `ey_region` VALUES ('38598', '德江县', '3', '38497', 'D');
INSERT INTO `ey_region` VALUES ('38619', '沿河县', '3', '38497', 'Y');
INSERT INTO `ey_region` VALUES ('38642', '松桃县', '3', '38497', 'S');
INSERT INTO `ey_region` VALUES ('38671', '万山特区', '3', '38497', 'W');
INSERT INTO `ey_region` VALUES ('38677', '黔西南州', '2', '37906', 'Q');
INSERT INTO `ey_region` VALUES ('38678', '兴义市', '3', '38677', 'X');
INSERT INTO `ey_region` VALUES ('38705', '兴仁县', '3', '38677', 'X');
INSERT INTO `ey_region` VALUES ('38722', '普安县', '3', '38677', 'P');
INSERT INTO `ey_region` VALUES ('38737', '晴隆县', '3', '38677', 'Q');
INSERT INTO `ey_region` VALUES ('38752', '贞丰县', '3', '38677', 'Z');
INSERT INTO `ey_region` VALUES ('38766', '望谟县', '3', '38677', 'W');
INSERT INTO `ey_region` VALUES ('38784', '册亨县', '3', '38677', 'C');
INSERT INTO `ey_region` VALUES ('38799', '安龙县', '3', '38677', 'A');
INSERT INTO `ey_region` VALUES ('38816', '毕节地区', '2', '37906', 'B');
INSERT INTO `ey_region` VALUES ('38817', '毕节市', '3', '38816', 'B');
INSERT INTO `ey_region` VALUES ('38859', '大方县', '3', '38816', 'D');
INSERT INTO `ey_region` VALUES ('38896', '黔西县', '3', '38816', 'Q');
INSERT INTO `ey_region` VALUES ('38925', '金沙县', '3', '38816', 'J');
INSERT INTO `ey_region` VALUES ('38952', '织金县', '3', '38816', 'Z');
INSERT INTO `ey_region` VALUES ('38985', '纳雍县', '3', '38816', 'N');
INSERT INTO `ey_region` VALUES ('39011', '威宁县', '3', '38816', 'W');
INSERT INTO `ey_region` VALUES ('39047', '赫章县', '3', '38816', 'H');
INSERT INTO `ey_region` VALUES ('39075', '黔东南州', '2', '37906', 'Q');
INSERT INTO `ey_region` VALUES ('39076', '凯里市', '3', '39075', 'K');
INSERT INTO `ey_region` VALUES ('39092', '黄平县', '3', '39075', 'H');
INSERT INTO `ey_region` VALUES ('39107', '施秉县', '3', '39075', 'S');
INSERT INTO `ey_region` VALUES ('39116', '三穗县', '3', '39075', 'S');
INSERT INTO `ey_region` VALUES ('39126', '镇远县', '3', '39075', 'Z');
INSERT INTO `ey_region` VALUES ('39139', '岑巩县', '3', '39075', 'C');
INSERT INTO `ey_region` VALUES ('39151', '天柱县', '3', '39075', 'T');
INSERT INTO `ey_region` VALUES ('39168', '锦屏县', '3', '39075', 'J');
INSERT INTO `ey_region` VALUES ('39184', '剑河县', '3', '39075', 'J');
INSERT INTO `ey_region` VALUES ('39197', '台江县', '3', '39075', 'T');
INSERT INTO `ey_region` VALUES ('39206', '黎平县', '3', '39075', 'L');
INSERT INTO `ey_region` VALUES ('39232', '榕江县', '3', '39075', 'R');
INSERT INTO `ey_region` VALUES ('39252', '从江县', '3', '39075', 'C');
INSERT INTO `ey_region` VALUES ('39274', '雷山县', '3', '39075', 'L');
INSERT INTO `ey_region` VALUES ('39284', '麻江县', '3', '39075', 'M');
INSERT INTO `ey_region` VALUES ('39294', '丹寨县', '3', '39075', 'D');
INSERT INTO `ey_region` VALUES ('39302', '黔南州', '2', '37906', 'Q');
INSERT INTO `ey_region` VALUES ('39303', '都匀市', '3', '39302', 'D');
INSERT INTO `ey_region` VALUES ('39327', '福泉市', '3', '39302', 'F');
INSERT INTO `ey_region` VALUES ('39345', '荔波县', '3', '39302', 'L');
INSERT INTO `ey_region` VALUES ('39363', '贵定县', '3', '39302', 'G');
INSERT INTO `ey_region` VALUES ('39384', '瓮安县', '3', '39302', 'W');
INSERT INTO `ey_region` VALUES ('39408', '独山县', '3', '39302', 'D');
INSERT INTO `ey_region` VALUES ('39427', '平塘县', '3', '39302', 'P');
INSERT INTO `ey_region` VALUES ('39447', '罗甸县', '3', '39302', 'L');
INSERT INTO `ey_region` VALUES ('39474', '长顺县', '3', '39302', 'C');
INSERT INTO `ey_region` VALUES ('39493', '龙里县', '3', '39302', 'L');
INSERT INTO `ey_region` VALUES ('39508', '惠水县', '3', '39302', 'H');
INSERT INTO `ey_region` VALUES ('39534', '三都县', '3', '39302', 'S');
INSERT INTO `ey_region` VALUES ('39556', '云南省', '1', '0', 'Y');
INSERT INTO `ey_region` VALUES ('39557', '昆明市', '2', '39556', 'K');
INSERT INTO `ey_region` VALUES ('39558', '市辖区', '3', '39557', 'S');
INSERT INTO `ey_region` VALUES ('39559', '五华区', '3', '39557', 'W');
INSERT INTO `ey_region` VALUES ('39571', '盘龙区', '3', '39557', 'P');
INSERT INTO `ey_region` VALUES ('39582', '官渡区', '3', '39557', 'G');
INSERT INTO `ey_region` VALUES ('39594', '西山区', '3', '39557', 'X');
INSERT INTO `ey_region` VALUES ('39605', '东川区', '3', '39557', 'D');
INSERT INTO `ey_region` VALUES ('39614', '呈贡县', '3', '39557', 'C');
INSERT INTO `ey_region` VALUES ('39622', '晋宁县', '3', '39557', 'J');
INSERT INTO `ey_region` VALUES ('39632', '富民县', '3', '39557', 'F');
INSERT INTO `ey_region` VALUES ('39640', '宜良县', '3', '39557', 'Y');
INSERT INTO `ey_region` VALUES ('39650', '石林县', '3', '39557', 'S');
INSERT INTO `ey_region` VALUES ('39659', '嵩明县', '3', '39557', 'S');
INSERT INTO `ey_region` VALUES ('39667', '禄劝县', '3', '39557', 'L');
INSERT INTO `ey_region` VALUES ('39684', '寻甸县', '3', '39557', 'X');
INSERT INTO `ey_region` VALUES ('39701', '安宁市', '3', '39557', 'A');
INSERT INTO `ey_region` VALUES ('39710', '曲靖市', '2', '39556', 'Q');
INSERT INTO `ey_region` VALUES ('39711', '市辖区', '3', '39710', 'S');
INSERT INTO `ey_region` VALUES ('39712', '麒麟区', '3', '39710', 'Q');
INSERT INTO `ey_region` VALUES ('39724', '马龙县', '3', '39710', 'M');
INSERT INTO `ey_region` VALUES ('39733', '陆良县', '3', '39710', 'L');
INSERT INTO `ey_region` VALUES ('39744', '师宗县', '3', '39710', 'S');
INSERT INTO `ey_region` VALUES ('39753', '罗平县', '3', '39710', 'L');
INSERT INTO `ey_region` VALUES ('39766', '富源县', '3', '39710', 'F');
INSERT INTO `ey_region` VALUES ('39778', '会泽县', '3', '39710', 'H');
INSERT INTO `ey_region` VALUES ('39800', '沾益县', '3', '39710', 'Z');
INSERT INTO `ey_region` VALUES ('39809', '宣威市', '3', '39710', 'X');
INSERT INTO `ey_region` VALUES ('39836', '玉溪市', '2', '39556', 'Y');
INSERT INTO `ey_region` VALUES ('39837', '市辖区', '3', '39836', 'S');
INSERT INTO `ey_region` VALUES ('39838', '红塔区', '3', '39836', 'H');
INSERT INTO `ey_region` VALUES ('39850', '江川县', '3', '39836', 'J');
INSERT INTO `ey_region` VALUES ('39858', '澄江县', '3', '39836', 'C');
INSERT INTO `ey_region` VALUES ('39865', '通海县', '3', '39836', 'T');
INSERT INTO `ey_region` VALUES ('39875', '华宁县', '3', '39836', 'H');
INSERT INTO `ey_region` VALUES ('39881', '易门县', '3', '39836', 'Y');
INSERT INTO `ey_region` VALUES ('39889', '峨山县', '3', '39836', 'E');
INSERT INTO `ey_region` VALUES ('39899', '新平县', '3', '39836', 'X');
INSERT INTO `ey_region` VALUES ('39912', '元江县', '3', '39836', 'Y');
INSERT INTO `ey_region` VALUES ('39923', '保山市', '2', '39556', 'B');
INSERT INTO `ey_region` VALUES ('39924', '市辖区', '3', '39923', 'S');
INSERT INTO `ey_region` VALUES ('39925', '隆阳区', '3', '39923', 'L');
INSERT INTO `ey_region` VALUES ('39946', '施甸县', '3', '39923', 'S');
INSERT INTO `ey_region` VALUES ('39960', '腾冲县', '3', '39923', 'T');
INSERT INTO `ey_region` VALUES ('39979', '龙陵县', '3', '39923', 'L');
INSERT INTO `ey_region` VALUES ('39990', '昌宁县', '3', '39923', 'C');
INSERT INTO `ey_region` VALUES ('40004', '昭通市', '2', '39556', 'Z');
INSERT INTO `ey_region` VALUES ('40005', '市辖区', '3', '40004', 'S');
INSERT INTO `ey_region` VALUES ('40006', '昭阳区', '3', '40004', 'Z');
INSERT INTO `ey_region` VALUES ('40027', '鲁甸县', '3', '40004', 'L');
INSERT INTO `ey_region` VALUES ('40040', '巧家县', '3', '40004', 'Q');
INSERT INTO `ey_region` VALUES ('40057', '盐津县', '3', '40004', 'Y');
INSERT INTO `ey_region` VALUES ('40068', '大关县', '3', '40004', 'D');
INSERT INTO `ey_region` VALUES ('40078', '永善县', '3', '40004', 'Y');
INSERT INTO `ey_region` VALUES ('40094', '绥江县', '3', '40004', 'S');
INSERT INTO `ey_region` VALUES ('40100', '镇雄县', '3', '40004', 'Z');
INSERT INTO `ey_region` VALUES ('40129', '彝良县', '3', '40004', 'Y');
INSERT INTO `ey_region` VALUES ('40145', '威信县', '3', '40004', 'W');
INSERT INTO `ey_region` VALUES ('40156', '水富县', '3', '40004', 'S');
INSERT INTO `ey_region` VALUES ('40160', '丽江市', '2', '39556', 'L');
INSERT INTO `ey_region` VALUES ('40161', '市辖区', '3', '40160', 'S');
INSERT INTO `ey_region` VALUES ('40162', '古城区', '3', '40160', 'G');
INSERT INTO `ey_region` VALUES ('40172', '玉龙县', '3', '40160', 'Y');
INSERT INTO `ey_region` VALUES ('40189', '永胜县', '3', '40160', 'Y');
INSERT INTO `ey_region` VALUES ('40205', '华坪县', '3', '40160', 'H');
INSERT INTO `ey_region` VALUES ('40214', '宁蒗县', '3', '40160', 'N');
INSERT INTO `ey_region` VALUES ('40230', '思茅市', '2', '39556', 'S');
INSERT INTO `ey_region` VALUES ('40231', '市辖区', '3', '40230', 'S');
INSERT INTO `ey_region` VALUES ('40232', '翠云区', '3', '40230', 'C');
INSERT INTO `ey_region` VALUES ('40240', '普洱县', '3', '40230', 'P');
INSERT INTO `ey_region` VALUES ('40250', '墨江县', '3', '40230', 'M');
INSERT INTO `ey_region` VALUES ('40266', '景东县', '3', '40230', 'J');
INSERT INTO `ey_region` VALUES ('40280', '景谷县', '3', '40230', 'J');
INSERT INTO `ey_region` VALUES ('40291', '镇沅县', '3', '40230', 'Z');
INSERT INTO `ey_region` VALUES ('40301', '江城县', '3', '40230', 'J');
INSERT INTO `ey_region` VALUES ('40310', '孟连县', '3', '40230', 'M');
INSERT INTO `ey_region` VALUES ('40318', '澜沧县', '3', '40230', 'L');
INSERT INTO `ey_region` VALUES ('40340', '西盟县', '3', '40230', 'X');
INSERT INTO `ey_region` VALUES ('40348', '临沧市', '2', '39556', 'L');
INSERT INTO `ey_region` VALUES ('40349', '市辖区', '3', '40348', 'S');
INSERT INTO `ey_region` VALUES ('40350', '临翔区', '3', '40348', 'L');
INSERT INTO `ey_region` VALUES ('40361', '凤庆县', '3', '40348', 'F');
INSERT INTO `ey_region` VALUES ('40375', '云县', '3', '40348', 'Y');
INSERT INTO `ey_region` VALUES ('40388', '永德县', '3', '40348', 'Y');
INSERT INTO `ey_region` VALUES ('40400', '镇康县', '3', '40348', 'Z');
INSERT INTO `ey_region` VALUES ('40408', '双江县', '3', '40348', 'S');
INSERT INTO `ey_region` VALUES ('40417', '耿马县', '3', '40348', 'G');
INSERT INTO `ey_region` VALUES ('40429', '沧源县', '3', '40348', 'C');
INSERT INTO `ey_region` VALUES ('40441', '楚雄州', '2', '39556', 'C');
INSERT INTO `ey_region` VALUES ('40442', '楚雄市', '3', '40441', 'C');
INSERT INTO `ey_region` VALUES ('40458', '双柏县', '3', '40441', 'S');
INSERT INTO `ey_region` VALUES ('40467', '牟定县', '3', '40441', 'M');
INSERT INTO `ey_region` VALUES ('40475', '南华县', '3', '40441', 'N');
INSERT INTO `ey_region` VALUES ('40486', '姚安县', '3', '40441', 'Y');
INSERT INTO `ey_region` VALUES ('40496', '大姚县', '3', '40441', 'D');
INSERT INTO `ey_region` VALUES ('40509', '永仁县', '3', '40441', 'Y');
INSERT INTO `ey_region` VALUES ('40517', '元谋县', '3', '40441', 'Y');
INSERT INTO `ey_region` VALUES ('40528', '武定县', '3', '40441', 'W');
INSERT INTO `ey_region` VALUES ('40540', '禄丰县', '3', '40441', 'L');
INSERT INTO `ey_region` VALUES ('40555', '红河州', '2', '39556', 'H');
INSERT INTO `ey_region` VALUES ('40556', '个旧市', '3', '40555', 'G');
INSERT INTO `ey_region` VALUES ('40567', '开远市', '3', '40555', 'K');
INSERT INTO `ey_region` VALUES ('40576', '蒙自县', '3', '40555', 'M');
INSERT INTO `ey_region` VALUES ('40588', '屏边县', '3', '40555', 'P');
INSERT INTO `ey_region` VALUES ('40596', '建水县', '3', '40555', 'J');
INSERT INTO `ey_region` VALUES ('40611', '石屏县', '3', '40555', 'S');
INSERT INTO `ey_region` VALUES ('40621', '弥勒县', '3', '40555', 'M');
INSERT INTO `ey_region` VALUES ('40635', '泸西县', '3', '40555', 'L');
INSERT INTO `ey_region` VALUES ('40644', '元阳县', '3', '40555', 'Y');
INSERT INTO `ey_region` VALUES ('40659', '红河县', '3', '40555', 'H');
INSERT INTO `ey_region` VALUES ('40673', '金平县', '3', '40555', 'J');
INSERT INTO `ey_region` VALUES ('40688', '绿春县', '3', '40555', 'L');
INSERT INTO `ey_region` VALUES ('40698', '河口县', '3', '40555', 'H');
INSERT INTO `ey_region` VALUES ('40705', '文山州', '2', '39556', 'W');
INSERT INTO `ey_region` VALUES ('40706', '文山县', '3', '40705', 'W');
INSERT INTO `ey_region` VALUES ('40722', '砚山县', '3', '40705', 'Y');
INSERT INTO `ey_region` VALUES ('40734', '西畴县', '3', '40705', 'X');
INSERT INTO `ey_region` VALUES ('40744', '麻栗坡县', '3', '40705', 'M');
INSERT INTO `ey_region` VALUES ('40756', '马关县', '3', '40705', 'M');
INSERT INTO `ey_region` VALUES ('40770', '丘北县', '3', '40705', 'Q');
INSERT INTO `ey_region` VALUES ('40783', '广南县', '3', '40705', 'G');
INSERT INTO `ey_region` VALUES ('40802', '富宁县', '3', '40705', 'F');
INSERT INTO `ey_region` VALUES ('40816', '西双版纳州', '2', '39556', 'X');
INSERT INTO `ey_region` VALUES ('40817', '景洪市', '3', '40816', 'J');
INSERT INTO `ey_region` VALUES ('40829', '勐海县', '3', '40816', 'M');
INSERT INTO `ey_region` VALUES ('40841', '勐腊县', '3', '40816', 'M');
INSERT INTO `ey_region` VALUES ('40852', '大理州', '2', '39556', 'D');
INSERT INTO `ey_region` VALUES ('40853', '大理市', '3', '40852', 'D');
INSERT INTO `ey_region` VALUES ('40866', '漾濞县', '3', '40852', 'Y');
INSERT INTO `ey_region` VALUES ('40876', '祥云县', '3', '40852', 'X');
INSERT INTO `ey_region` VALUES ('40887', '宾川县', '3', '40852', 'B');
INSERT INTO `ey_region` VALUES ('40901', '弥渡县', '3', '40852', 'M');
INSERT INTO `ey_region` VALUES ('40910', '南涧县', '3', '40852', 'N');
INSERT INTO `ey_region` VALUES ('40919', '巍山县', '3', '40852', 'W');
INSERT INTO `ey_region` VALUES ('40930', '永平县', '3', '40852', 'Y');
INSERT INTO `ey_region` VALUES ('40938', '云龙县', '3', '40852', 'Y');
INSERT INTO `ey_region` VALUES ('40950', '洱源县', '3', '40852', 'E');
INSERT INTO `ey_region` VALUES ('40960', '剑川县', '3', '40852', 'J');
INSERT INTO `ey_region` VALUES ('40969', '鹤庆县', '3', '40852', 'H');
INSERT INTO `ey_region` VALUES ('40979', '德宏州', '2', '39556', 'D');
INSERT INTO `ey_region` VALUES ('40980', '瑞丽市', '3', '40979', 'R');
INSERT INTO `ey_region` VALUES ('40988', '潞西市', '3', '40979', 'L');
INSERT INTO `ey_region` VALUES ('41000', '梁河县', '3', '40979', 'L');
INSERT INTO `ey_region` VALUES ('41010', '盈江县', '3', '40979', 'Y');
INSERT INTO `ey_region` VALUES ('41026', '陇川县', '3', '40979', 'L');
INSERT INTO `ey_region` VALUES ('41036', '怒江州', '2', '39556', 'N');
INSERT INTO `ey_region` VALUES ('41037', '泸水县', '3', '41036', 'L');
INSERT INTO `ey_region` VALUES ('41047', '福贡县', '3', '41036', 'F');
INSERT INTO `ey_region` VALUES ('41055', '贡山县', '3', '41036', 'G');
INSERT INTO `ey_region` VALUES ('41061', '兰坪县', '3', '41036', 'L');
INSERT INTO `ey_region` VALUES ('41070', '迪庆州', '2', '39556', 'D');
INSERT INTO `ey_region` VALUES ('41071', '香格里拉县', '3', '41070', 'X');
INSERT INTO `ey_region` VALUES ('41083', '德钦县', '3', '41070', 'D');
INSERT INTO `ey_region` VALUES ('41092', '维西县', '3', '41070', 'W');
INSERT INTO `ey_region` VALUES ('41103', '西藏自治区', '1', '0', 'X');
INSERT INTO `ey_region` VALUES ('41104', '拉萨市', '2', '41103', 'L');
INSERT INTO `ey_region` VALUES ('41105', '市辖区', '3', '41104', 'S');
INSERT INTO `ey_region` VALUES ('41106', '城关区', '3', '41104', 'C');
INSERT INTO `ey_region` VALUES ('41118', '林周县', '3', '41104', 'L');
INSERT INTO `ey_region` VALUES ('41129', '当雄县', '3', '41104', 'D');
INSERT INTO `ey_region` VALUES ('41138', '尼木县', '3', '41104', 'N');
INSERT INTO `ey_region` VALUES ('41147', '曲水县', '3', '41104', 'Q');
INSERT INTO `ey_region` VALUES ('41154', '堆龙德庆', '3', '41104', 'D');
INSERT INTO `ey_region` VALUES ('41162', '达孜县', '3', '41104', 'D');
INSERT INTO `ey_region` VALUES ('41169', '墨竹工卡县', '3', '41104', 'M');
INSERT INTO `ey_region` VALUES ('41178', '昌都地区', '2', '41103', 'C');
INSERT INTO `ey_region` VALUES ('41179', '昌都县', '3', '41178', 'C');
INSERT INTO `ey_region` VALUES ('41195', '江达县', '3', '41178', 'J');
INSERT INTO `ey_region` VALUES ('41209', '贡觉县', '3', '41178', 'G');
INSERT INTO `ey_region` VALUES ('41222', '类乌齐县', '3', '41178', 'L');
INSERT INTO `ey_region` VALUES ('41233', '丁青县', '3', '41178', 'D');
INSERT INTO `ey_region` VALUES ('41247', '察亚县', '3', '41178', 'C');
INSERT INTO `ey_region` VALUES ('41261', '八宿县', '3', '41178', 'B');
INSERT INTO `ey_region` VALUES ('41276', '左贡县', '3', '41178', 'Z');
INSERT INTO `ey_region` VALUES ('41287', '芒康县', '3', '41178', 'M');
INSERT INTO `ey_region` VALUES ('41304', '洛隆县', '3', '41178', 'L');
INSERT INTO `ey_region` VALUES ('41316', '边坝县', '3', '41178', 'B');
INSERT INTO `ey_region` VALUES ('41328', '山南地区', '2', '41103', 'S');
INSERT INTO `ey_region` VALUES ('41329', '乃东县', '3', '41328', 'N');
INSERT INTO `ey_region` VALUES ('41337', '扎囊县', '3', '41328', 'Z');
INSERT INTO `ey_region` VALUES ('41343', '贡嘎县', '3', '41328', 'G');
INSERT INTO `ey_region` VALUES ('41352', '桑日县', '3', '41328', 'S');
INSERT INTO `ey_region` VALUES ('41357', '琼结县', '3', '41328', 'Q');
INSERT INTO `ey_region` VALUES ('41362', '曲松县', '3', '41328', 'Q');
INSERT INTO `ey_region` VALUES ('41368', '措美县', '3', '41328', 'C');
INSERT INTO `ey_region` VALUES ('41373', '洛扎县', '3', '41328', 'L');
INSERT INTO `ey_region` VALUES ('41381', '加查县', '3', '41328', 'J');
INSERT INTO `ey_region` VALUES ('41389', '隆子县', '3', '41328', 'L');
INSERT INTO `ey_region` VALUES ('41401', '错那县', '3', '41328', 'C');
INSERT INTO `ey_region` VALUES ('41412', '浪卡子县', '3', '41328', 'L');
INSERT INTO `ey_region` VALUES ('41423', '日喀则地区', '2', '41103', 'R');
INSERT INTO `ey_region` VALUES ('41424', '日喀则市', '3', '41423', 'R');
INSERT INTO `ey_region` VALUES ('41437', '南木林县', '3', '41423', 'N');
INSERT INTO `ey_region` VALUES ('41455', '江孜县', '3', '41423', 'J');
INSERT INTO `ey_region` VALUES ('41475', '定日县', '3', '41423', 'D');
INSERT INTO `ey_region` VALUES ('41489', '萨迦县', '3', '41423', 'S');
INSERT INTO `ey_region` VALUES ('41501', '拉孜县', '3', '41423', 'L');
INSERT INTO `ey_region` VALUES ('41513', '昂仁县', '3', '41423', 'A');
INSERT INTO `ey_region` VALUES ('41531', '谢通门县', '3', '41423', 'X');
INSERT INTO `ey_region` VALUES ('41551', '白朗县', '3', '41423', 'B');
INSERT INTO `ey_region` VALUES ('41563', '仁布县', '3', '41423', 'R');
INSERT INTO `ey_region` VALUES ('41573', '康马县', '3', '41423', 'K');
INSERT INTO `ey_region` VALUES ('41583', '定结县', '3', '41423', 'D');
INSERT INTO `ey_region` VALUES ('41594', '仲巴县', '3', '41423', 'Z');
INSERT INTO `ey_region` VALUES ('41608', '亚东县', '3', '41423', 'Y');
INSERT INTO `ey_region` VALUES ('41616', '吉隆县', '3', '41423', 'J');
INSERT INTO `ey_region` VALUES ('41622', '聂拉木县', '3', '41423', 'N');
INSERT INTO `ey_region` VALUES ('41630', '萨嘎县', '3', '41423', 'S');
INSERT INTO `ey_region` VALUES ('41639', '岗巴县', '3', '41423', 'G');
INSERT INTO `ey_region` VALUES ('41645', '那曲地区', '2', '41103', 'N');
INSERT INTO `ey_region` VALUES ('41646', '那曲县', '3', '41645', 'N');
INSERT INTO `ey_region` VALUES ('41659', '嘉黎县', '3', '41645', 'J');
INSERT INTO `ey_region` VALUES ('41670', '比如县', '3', '41645', 'B');
INSERT INTO `ey_region` VALUES ('41681', '聂荣县', '3', '41645', 'N');
INSERT INTO `ey_region` VALUES ('41692', '安多县', '3', '41645', 'A');
INSERT INTO `ey_region` VALUES ('41706', '申扎县', '3', '41645', 'S');
INSERT INTO `ey_region` VALUES ('41715', '索县', '3', '41645', 'S');
INSERT INTO `ey_region` VALUES ('41726', '班戈县', '3', '41645', 'B');
INSERT INTO `ey_region` VALUES ('41737', '巴青县', '3', '41645', 'B');
INSERT INTO `ey_region` VALUES ('41748', '尼玛县', '3', '41645', 'N');
INSERT INTO `ey_region` VALUES ('41770', '阿里地区', '2', '41103', 'A');
INSERT INTO `ey_region` VALUES ('41771', '普兰县', '3', '41770', 'P');
INSERT INTO `ey_region` VALUES ('41775', '札达县', '3', '41770', 'Z');
INSERT INTO `ey_region` VALUES ('41782', '噶尔县', '3', '41770', 'G');
INSERT INTO `ey_region` VALUES ('41788', '日土县', '3', '41770', 'R');
INSERT INTO `ey_region` VALUES ('41794', '革吉县', '3', '41770', 'G');
INSERT INTO `ey_region` VALUES ('41800', '改则县', '3', '41770', 'G');
INSERT INTO `ey_region` VALUES ('41808', '措勤县', '3', '41770', 'C');
INSERT INTO `ey_region` VALUES ('41814', '林芝地区', '2', '41103', 'L');
INSERT INTO `ey_region` VALUES ('41815', '林芝县', '3', '41814', 'L');
INSERT INTO `ey_region` VALUES ('41823', '工布江达县', '3', '41814', 'G');
INSERT INTO `ey_region` VALUES ('41833', '米林县', '3', '41814', 'M');
INSERT INTO `ey_region` VALUES ('41842', '墨脱县', '3', '41814', 'M');
INSERT INTO `ey_region` VALUES ('41851', '波密县', '3', '41814', 'B');
INSERT INTO `ey_region` VALUES ('41863', '察隅县', '3', '41814', 'C');
INSERT INTO `ey_region` VALUES ('41870', '朗县', '3', '41814', 'L');
INSERT INTO `ey_region` VALUES ('41877', '陕西省', '1', '0', 'S');
INSERT INTO `ey_region` VALUES ('41878', '西安市', '2', '41877', 'X');
INSERT INTO `ey_region` VALUES ('41879', '市辖区', '3', '41878', 'S');
INSERT INTO `ey_region` VALUES ('41880', '新城区', '3', '41878', 'X');
INSERT INTO `ey_region` VALUES ('41890', '碑林区', '3', '41878', 'B');
INSERT INTO `ey_region` VALUES ('41899', '莲湖区', '3', '41878', 'L');
INSERT INTO `ey_region` VALUES ('41909', '灞桥区', '3', '41878', 'B');
INSERT INTO `ey_region` VALUES ('41919', '未央区', '3', '41878', 'W');
INSERT INTO `ey_region` VALUES ('41930', '雁塔区', '3', '41878', 'Y');
INSERT INTO `ey_region` VALUES ('41939', '阎良区', '3', '41878', 'Y');
INSERT INTO `ey_region` VALUES ('41947', '临潼区', '3', '41878', 'L');
INSERT INTO `ey_region` VALUES ('41971', '长安区', '3', '41878', 'C');
INSERT INTO `ey_region` VALUES ('41997', '蓝田县', '3', '41878', 'L');
INSERT INTO `ey_region` VALUES ('42020', '周至县', '3', '41878', 'Z');
INSERT INTO `ey_region` VALUES ('42043', '户县', '3', '41878', 'H');
INSERT INTO `ey_region` VALUES ('42060', '高陵县', '3', '41878', 'G');
INSERT INTO `ey_region` VALUES ('42069', '铜川市', '2', '41877', 'T');
INSERT INTO `ey_region` VALUES ('42070', '市辖区', '3', '42069', 'S');
INSERT INTO `ey_region` VALUES ('42071', '王益区', '3', '42069', 'W');
INSERT INTO `ey_region` VALUES ('42079', '印台区', '3', '42069', 'Y');
INSERT INTO `ey_region` VALUES ('42091', '耀州区', '3', '42069', 'Y');
INSERT INTO `ey_region` VALUES ('42108', '宜君县', '3', '42069', 'Y');
INSERT INTO `ey_region` VALUES ('42119', '宝鸡市', '2', '41877', 'B');
INSERT INTO `ey_region` VALUES ('42120', '市辖区', '3', '42119', 'S');
INSERT INTO `ey_region` VALUES ('42121', '渭滨区', '3', '42119', 'W');
INSERT INTO `ey_region` VALUES ('42133', '金台区', '3', '42119', 'J');
INSERT INTO `ey_region` VALUES ('42146', '陈仓区', '3', '42119', 'C');
INSERT INTO `ey_region` VALUES ('42165', '凤翔县', '3', '42119', 'F');
INSERT INTO `ey_region` VALUES ('42183', '岐山县', '3', '42119', 'Q');
INSERT INTO `ey_region` VALUES ('42198', '扶风县', '3', '42119', 'F');
INSERT INTO `ey_region` VALUES ('42211', '眉县', '3', '42119', 'M');
INSERT INTO `ey_region` VALUES ('42224', '陇县', '3', '42119', 'L');
INSERT INTO `ey_region` VALUES ('42240', '千阳县', '3', '42119', 'Q');
INSERT INTO `ey_region` VALUES ('42252', '麟游县', '3', '42119', 'L');
INSERT INTO `ey_region` VALUES ('42263', '凤县', '3', '42119', 'F');
INSERT INTO `ey_region` VALUES ('42278', '太白县', '3', '42119', 'T');
INSERT INTO `ey_region` VALUES ('42287', '咸阳市', '2', '41877', 'X');
INSERT INTO `ey_region` VALUES ('42288', '市辖区', '3', '42287', 'S');
INSERT INTO `ey_region` VALUES ('42289', '秦都区', '3', '42287', 'Q');
INSERT INTO `ey_region` VALUES ('42302', '杨凌区', '3', '42287', 'Y');
INSERT INTO `ey_region` VALUES ('42308', '渭城区', '3', '42287', 'W');
INSERT INTO `ey_region` VALUES ('42319', '三原县', '3', '42287', 'S');
INSERT INTO `ey_region` VALUES ('42334', '泾阳县', '3', '42287', 'J');
INSERT INTO `ey_region` VALUES ('42351', '乾县', '3', '42287', 'Q');
INSERT INTO `ey_region` VALUES ('42372', '礼泉县', '3', '42287', 'L');
INSERT INTO `ey_region` VALUES ('42388', '永寿县', '3', '42287', 'Y');
INSERT INTO `ey_region` VALUES ('42402', '彬县', '3', '42287', 'B');
INSERT INTO `ey_region` VALUES ('42419', '长武县', '3', '42287', 'C');
INSERT INTO `ey_region` VALUES ('42431', '旬邑县', '3', '42287', 'X');
INSERT INTO `ey_region` VALUES ('42446', '淳化县', '3', '42287', 'C');
INSERT INTO `ey_region` VALUES ('42462', '武功县', '3', '42287', 'W');
INSERT INTO `ey_region` VALUES ('42475', '兴平市', '3', '42287', 'X');
INSERT INTO `ey_region` VALUES ('42490', '渭南市', '2', '41877', 'W');
INSERT INTO `ey_region` VALUES ('42491', '市辖区', '3', '42490', 'S');
INSERT INTO `ey_region` VALUES ('42492', '临渭区', '3', '42490', 'L');
INSERT INTO `ey_region` VALUES ('42523', '华县', '3', '42490', 'H');
INSERT INTO `ey_region` VALUES ('42538', '潼关县', '3', '42490', 'T');
INSERT INTO `ey_region` VALUES ('42547', '大荔县', '3', '42490', 'D');
INSERT INTO `ey_region` VALUES ('42577', '合阳县', '3', '42490', 'H');
INSERT INTO `ey_region` VALUES ('42594', '澄城县', '3', '42490', 'C');
INSERT INTO `ey_region` VALUES ('42609', '蒲城县', '3', '42490', 'P');
INSERT INTO `ey_region` VALUES ('42634', '白水县', '3', '42490', 'B');
INSERT INTO `ey_region` VALUES ('42649', '富平县', '3', '42490', 'F');
INSERT INTO `ey_region` VALUES ('42674', '韩城市', '3', '42490', 'H');
INSERT INTO `ey_region` VALUES ('42691', '华阴市', '3', '42490', 'H');
INSERT INTO `ey_region` VALUES ('42703', '延安市', '2', '41877', 'Y');
INSERT INTO `ey_region` VALUES ('42704', '市辖区', '3', '42703', 'S');
INSERT INTO `ey_region` VALUES ('42705', '宝塔区', '3', '42703', 'B');
INSERT INTO `ey_region` VALUES ('42729', '延长县', '3', '42703', 'Y');
INSERT INTO `ey_region` VALUES ('42742', '延川县', '3', '42703', 'Y');
INSERT INTO `ey_region` VALUES ('42757', '子长县', '3', '42703', 'Z');
INSERT INTO `ey_region` VALUES ('42771', '安塞县', '3', '42703', 'A');
INSERT INTO `ey_region` VALUES ('42784', '志丹县', '3', '42703', 'Z');
INSERT INTO `ey_region` VALUES ('42796', '吴起县', '3', '42703', 'W');
INSERT INTO `ey_region` VALUES ('42809', '甘泉县', '3', '42703', 'G');
INSERT INTO `ey_region` VALUES ('42818', '富县', '3', '42703', 'F');
INSERT INTO `ey_region` VALUES ('42833', '洛川县', '3', '42703', 'L');
INSERT INTO `ey_region` VALUES ('42850', '宜川县', '3', '42703', 'Y');
INSERT INTO `ey_region` VALUES ('42863', '黄龙县', '3', '42703', 'H');
INSERT INTO `ey_region` VALUES ('42874', '黄陵县', '3', '42703', 'H');
INSERT INTO `ey_region` VALUES ('42888', '汉中市', '2', '41877', 'H');
INSERT INTO `ey_region` VALUES ('42889', '市辖区', '3', '42888', 'S');
INSERT INTO `ey_region` VALUES ('42890', '汉台区', '3', '42888', 'H');
INSERT INTO `ey_region` VALUES ('42908', '南郑县', '3', '42888', 'N');
INSERT INTO `ey_region` VALUES ('42939', '城固县', '3', '42888', 'C');
INSERT INTO `ey_region` VALUES ('42965', '洋县', '3', '42888', 'Y');
INSERT INTO `ey_region` VALUES ('42992', '西乡县', '3', '42888', 'X');
INSERT INTO `ey_region` VALUES ('43016', '勉县', '3', '42888', 'M');
INSERT INTO `ey_region` VALUES ('43042', '宁强县', '3', '42888', 'N');
INSERT INTO `ey_region` VALUES ('43069', '略阳县', '3', '42888', 'L');
INSERT INTO `ey_region` VALUES ('43091', '镇巴县', '3', '42888', 'Z');
INSERT INTO `ey_region` VALUES ('43116', '留坝县', '3', '42888', 'L');
INSERT INTO `ey_region` VALUES ('43126', '佛坪县', '3', '42888', 'F');
INSERT INTO `ey_region` VALUES ('43136', '榆林市', '2', '41877', 'Y');
INSERT INTO `ey_region` VALUES ('43137', '市辖区', '3', '43136', 'S');
INSERT INTO `ey_region` VALUES ('43138', '榆阳区', '3', '43136', 'Y');
INSERT INTO `ey_region` VALUES ('43170', '神木县', '3', '43136', 'S');
INSERT INTO `ey_region` VALUES ('43190', '府谷县', '3', '43136', 'F');
INSERT INTO `ey_region` VALUES ('43211', '横山县', '3', '43136', 'H');
INSERT INTO `ey_region` VALUES ('43230', '靖边县', '3', '43136', 'J');
INSERT INTO `ey_region` VALUES ('43253', '定边县', '3', '43136', 'D');
INSERT INTO `ey_region` VALUES ('43279', '绥德县', '3', '43136', 'S');
INSERT INTO `ey_region` VALUES ('43300', '米脂县', '3', '43136', 'M');
INSERT INTO `ey_region` VALUES ('43314', '佳县', '3', '43136', 'J');
INSERT INTO `ey_region` VALUES ('43335', '吴堡县', '3', '43136', 'W');
INSERT INTO `ey_region` VALUES ('43344', '清涧县', '3', '43136', 'Q');
INSERT INTO `ey_region` VALUES ('43360', '子洲县', '3', '43136', 'Z');
INSERT INTO `ey_region` VALUES ('43379', '安康市', '2', '41877', 'A');
INSERT INTO `ey_region` VALUES ('43380', '市辖区', '3', '43379', 'S');
INSERT INTO `ey_region` VALUES ('43381', '汉滨区', '3', '43379', 'H');
INSERT INTO `ey_region` VALUES ('43428', '汉阴县', '3', '43379', 'H');
INSERT INTO `ey_region` VALUES ('43447', '石泉县', '3', '43379', 'S');
INSERT INTO `ey_region` VALUES ('43463', '宁陕县', '3', '43379', 'N');
INSERT INTO `ey_region` VALUES ('43478', '紫阳县', '3', '43379', 'Z');
INSERT INTO `ey_region` VALUES ('43504', '岚皋县', '3', '43379', 'L');
INSERT INTO `ey_region` VALUES ('43522', '平利县', '3', '43379', 'P');
INSERT INTO `ey_region` VALUES ('43535', '镇坪县', '3', '43379', 'Z');
INSERT INTO `ey_region` VALUES ('43546', '旬阳县', '3', '43379', 'X');
INSERT INTO `ey_region` VALUES ('43575', '白河县', '3', '43379', 'B');
INSERT INTO `ey_region` VALUES ('43592', '商洛市', '2', '41877', 'S');
INSERT INTO `ey_region` VALUES ('43593', '市辖区', '3', '43592', 'S');
INSERT INTO `ey_region` VALUES ('43594', '商州区', '3', '43592', 'S');
INSERT INTO `ey_region` VALUES ('43628', '洛南县', '3', '43592', 'L');
INSERT INTO `ey_region` VALUES ('43654', '丹凤县', '3', '43592', 'D');
INSERT INTO `ey_region` VALUES ('43676', '商南县', '3', '43592', 'S');
INSERT INTO `ey_region` VALUES ('43699', '山阳县', '3', '43592', 'S');
INSERT INTO `ey_region` VALUES ('43730', '镇安县', '3', '43592', 'Z');
INSERT INTO `ey_region` VALUES ('43759', '柞水县', '3', '43592', 'Z');
INSERT INTO `ey_region` VALUES ('43776', '甘肃省', '1', '0', 'G');
INSERT INTO `ey_region` VALUES ('43777', '兰州市', '2', '43776', 'L');
INSERT INTO `ey_region` VALUES ('43778', '市辖区', '3', '43777', 'S');
INSERT INTO `ey_region` VALUES ('43779', '城关区', '3', '43777', 'C');
INSERT INTO `ey_region` VALUES ('43804', '七里河区', '3', '43777', 'Q');
INSERT INTO `ey_region` VALUES ('43820', '兰州市西固区', '3', '43777', 'L');
INSERT INTO `ey_region` VALUES ('43836', '安宁区', '3', '43777', 'A');
INSERT INTO `ey_region` VALUES ('43845', '红古区', '3', '43777', 'H');
INSERT INTO `ey_region` VALUES ('43853', '永登县', '3', '43777', 'Y');
INSERT INTO `ey_region` VALUES ('43872', '皋兰县', '3', '43777', 'G');
INSERT INTO `ey_region` VALUES ('43880', '榆中县', '3', '43777', 'Y');
INSERT INTO `ey_region` VALUES ('43904', '嘉峪关市', '2', '43776', 'J');
INSERT INTO `ey_region` VALUES ('43905', '市辖', '3', '43904', 'S');
INSERT INTO `ey_region` VALUES ('43914', '金昌市', '2', '43776', 'J');
INSERT INTO `ey_region` VALUES ('43915', '市辖区', '3', '43914', 'S');
INSERT INTO `ey_region` VALUES ('43916', '金川区', '3', '43914', 'J');
INSERT INTO `ey_region` VALUES ('43925', '永昌县', '3', '43914', 'Y');
INSERT INTO `ey_region` VALUES ('43936', '白银市', '2', '43776', 'B');
INSERT INTO `ey_region` VALUES ('43937', '市辖区', '3', '43936', 'S');
INSERT INTO `ey_region` VALUES ('43938', '白银区', '3', '43936', 'B');
INSERT INTO `ey_region` VALUES ('43949', '平川区', '3', '43936', 'P');
INSERT INTO `ey_region` VALUES ('43961', '靖远县', '3', '43936', 'J');
INSERT INTO `ey_region` VALUES ('43980', '会宁县', '3', '43936', 'H');
INSERT INTO `ey_region` VALUES ('44009', '景泰县', '3', '43936', 'J');
INSERT INTO `ey_region` VALUES ('44022', '天水市', '2', '43776', 'T');
INSERT INTO `ey_region` VALUES ('44023', '市辖区', '3', '44022', 'S');
INSERT INTO `ey_region` VALUES ('44024', '秦州区', '3', '44022', 'Q');
INSERT INTO `ey_region` VALUES ('44048', '麦积区', '3', '44022', 'M');
INSERT INTO `ey_region` VALUES ('44069', '清水县', '3', '44022', 'Q');
INSERT INTO `ey_region` VALUES ('44088', '秦安县', '3', '44022', 'Q');
INSERT INTO `ey_region` VALUES ('44106', '甘谷县', '3', '44022', 'G');
INSERT INTO `ey_region` VALUES ('44122', '武山县', '3', '44022', 'W');
INSERT INTO `ey_region` VALUES ('44138', '张家川县', '3', '44022', 'Z');
INSERT INTO `ey_region` VALUES ('44154', '武威市', '2', '43776', 'W');
INSERT INTO `ey_region` VALUES ('44155', '市辖区', '3', '44154', 'S');
INSERT INTO `ey_region` VALUES ('44156', '凉州区', '3', '44154', 'L');
INSERT INTO `ey_region` VALUES ('44202', '民勤县', '3', '44154', 'M');
INSERT INTO `ey_region` VALUES ('44221', '古浪县', '3', '44154', 'G');
INSERT INTO `ey_region` VALUES ('44242', '天祝县', '3', '44154', 'T');
INSERT INTO `ey_region` VALUES ('44265', '张掖市', '2', '43776', 'Z');
INSERT INTO `ey_region` VALUES ('44266', '市辖区', '3', '44265', 'S');
INSERT INTO `ey_region` VALUES ('44267', '甘州区', '3', '44265', 'G');
INSERT INTO `ey_region` VALUES ('44294', '肃南县', '3', '44265', 'S');
INSERT INTO `ey_region` VALUES ('44305', '民乐县', '3', '44265', 'M');
INSERT INTO `ey_region` VALUES ('44317', '临泽县', '3', '44265', 'L');
INSERT INTO `ey_region` VALUES ('44331', '高台县', '3', '44265', 'G');
INSERT INTO `ey_region` VALUES ('44341', '山丹县', '3', '44265', 'S');
INSERT INTO `ey_region` VALUES ('44352', '平凉市', '2', '43776', 'P');
INSERT INTO `ey_region` VALUES ('44353', '市辖区', '3', '44352', 'S');
INSERT INTO `ey_region` VALUES ('44354', '崆峒区', '3', '44352', 'K');
INSERT INTO `ey_region` VALUES ('44375', '泾川县', '3', '44352', 'J');
INSERT INTO `ey_region` VALUES ('44392', '灵台县', '3', '44352', 'L');
INSERT INTO `ey_region` VALUES ('44408', '崇信县', '3', '44352', 'C');
INSERT INTO `ey_region` VALUES ('44418', '华亭县', '3', '44352', 'H');
INSERT INTO `ey_region` VALUES ('44431', '庄浪县', '3', '44352', 'Z');
INSERT INTO `ey_region` VALUES ('44451', '静宁县', '3', '44352', 'J');
INSERT INTO `ey_region` VALUES ('44477', '酒泉市', '2', '43776', 'J');
INSERT INTO `ey_region` VALUES ('44478', '市辖区', '3', '44477', 'S');
INSERT INTO `ey_region` VALUES ('44479', '肃州区', '3', '44477', 'S');
INSERT INTO `ey_region` VALUES ('44504', '金塔县', '3', '44477', 'J');
INSERT INTO `ey_region` VALUES ('44516', '瓜州县', '3', '44477', 'G');
INSERT INTO `ey_region` VALUES ('44531', '肃北县', '3', '44477', 'S');
INSERT INTO `ey_region` VALUES ('44535', '阿克塞县', '3', '44477', 'A');
INSERT INTO `ey_region` VALUES ('44539', '玉门市', '3', '44477', 'Y');
INSERT INTO `ey_region` VALUES ('44557', '敦煌市', '3', '44477', 'D');
INSERT INTO `ey_region` VALUES ('44569', '庆阳市', '2', '43776', 'Q');
INSERT INTO `ey_region` VALUES ('44570', '市辖区', '3', '44569', 'S');
INSERT INTO `ey_region` VALUES ('44571', '西峰区', '3', '44569', 'X');
INSERT INTO `ey_region` VALUES ('44582', '庆城县', '3', '44569', 'Q');
INSERT INTO `ey_region` VALUES ('44598', '环县', '3', '44569', 'H');
INSERT INTO `ey_region` VALUES ('44620', '华池县', '3', '44569', 'H');
INSERT INTO `ey_region` VALUES ('44636', '合水县', '3', '44569', 'H');
INSERT INTO `ey_region` VALUES ('44649', '正宁县', '3', '44569', 'Z');
INSERT INTO `ey_region` VALUES ('44660', '宁县', '3', '44569', 'N');
INSERT INTO `ey_region` VALUES ('44679', '镇原县', '3', '44569', 'Z');
INSERT INTO `ey_region` VALUES ('44699', '定西市', '2', '43776', 'D');
INSERT INTO `ey_region` VALUES ('44700', '市辖区', '3', '44699', 'S');
INSERT INTO `ey_region` VALUES ('44701', '安定区', '3', '44699', 'A');
INSERT INTO `ey_region` VALUES ('44723', '通渭县', '3', '44699', 'T');
INSERT INTO `ey_region` VALUES ('44742', '陇西县', '3', '44699', 'L');
INSERT INTO `ey_region` VALUES ('44760', '渭源县', '3', '44699', 'W');
INSERT INTO `ey_region` VALUES ('44777', '临洮县', '3', '44699', 'L');
INSERT INTO `ey_region` VALUES ('44796', '漳县', '3', '44699', 'Z');
INSERT INTO `ey_region` VALUES ('44810', '岷县', '3', '44699', 'M');
INSERT INTO `ey_region` VALUES ('44829', '陇南市', '2', '43776', 'L');
INSERT INTO `ey_region` VALUES ('44830', '市辖区', '3', '44829', 'S');
INSERT INTO `ey_region` VALUES ('44831', '武都区', '3', '44829', 'W');
INSERT INTO `ey_region` VALUES ('44868', '成县', '3', '44829', 'C');
INSERT INTO `ey_region` VALUES ('44886', '文县', '3', '44829', 'W');
INSERT INTO `ey_region` VALUES ('44907', '宕昌县', '3', '44829', 'D');
INSERT INTO `ey_region` VALUES ('44933', '康县', '3', '44829', 'K');
INSERT INTO `ey_region` VALUES ('44955', '西和县', '3', '44829', 'X');
INSERT INTO `ey_region` VALUES ('44976', '礼县', '3', '44829', 'L');
INSERT INTO `ey_region` VALUES ('45006', '徽县', '3', '44829', 'H');
INSERT INTO `ey_region` VALUES ('45022', '两当县', '3', '44829', 'L');
INSERT INTO `ey_region` VALUES ('45035', '临夏州', '2', '43776', 'L');
INSERT INTO `ey_region` VALUES ('45036', '临夏市', '3', '45035', 'L');
INSERT INTO `ey_region` VALUES ('45047', '临夏县', '3', '45035', 'L');
INSERT INTO `ey_region` VALUES ('45073', '康乐县', '3', '45035', 'K');
INSERT INTO `ey_region` VALUES ('45089', '永靖县', '3', '45035', 'Y');
INSERT INTO `ey_region` VALUES ('45107', '广河县', '3', '45035', 'G');
INSERT INTO `ey_region` VALUES ('45117', '和政县', '3', '45035', 'H');
INSERT INTO `ey_region` VALUES ('45131', '东乡县', '3', '45035', 'D');
INSERT INTO `ey_region` VALUES ('45156', '积石山县', '3', '45035', 'J');
INSERT INTO `ey_region` VALUES ('45174', '甘南州', '2', '43776', 'G');
INSERT INTO `ey_region` VALUES ('45175', '合作市', '3', '45174', 'H');
INSERT INTO `ey_region` VALUES ('45186', '临潭县', '3', '45174', 'L');
INSERT INTO `ey_region` VALUES ('45203', '卓尼县', '3', '45174', 'Z');
INSERT INTO `ey_region` VALUES ('45219', '舟曲县', '3', '45174', 'Z');
INSERT INTO `ey_region` VALUES ('45239', '迭部县', '3', '45174', 'D');
INSERT INTO `ey_region` VALUES ('45251', '玛曲县', '3', '45174', 'M');
INSERT INTO `ey_region` VALUES ('45263', '碌曲县', '3', '45174', 'L');
INSERT INTO `ey_region` VALUES ('45272', '夏河县', '3', '45174', 'X');
INSERT INTO `ey_region` VALUES ('45286', '青海省', '1', '0', 'Q');
INSERT INTO `ey_region` VALUES ('45287', '西宁市', '2', '45286', 'X');
INSERT INTO `ey_region` VALUES ('45288', '市辖区', '3', '45287', 'S');
INSERT INTO `ey_region` VALUES ('45289', '城东区', '3', '45287', 'C');
INSERT INTO `ey_region` VALUES ('45299', '城中区', '3', '45287', 'C');
INSERT INTO `ey_region` VALUES ('45306', '城西区', '3', '45287', 'C');
INSERT INTO `ey_region` VALUES ('45314', '城北区', '3', '45287', 'C');
INSERT INTO `ey_region` VALUES ('45320', '大通县', '3', '45287', 'D');
INSERT INTO `ey_region` VALUES ('45341', '湟中县', '3', '45287', 'H');
INSERT INTO `ey_region` VALUES ('45358', '湟源县', '3', '45287', 'H');
INSERT INTO `ey_region` VALUES ('45368', '海东地区', '2', '45286', 'H');
INSERT INTO `ey_region` VALUES ('45369', '平安县', '3', '45368', 'P');
INSERT INTO `ey_region` VALUES ('45378', '民和县', '3', '45368', 'M');
INSERT INTO `ey_region` VALUES ('45401', '乐都县', '3', '45368', 'L');
INSERT INTO `ey_region` VALUES ('45421', '互助县', '3', '45368', 'H');
INSERT INTO `ey_region` VALUES ('45441', '化隆县', '3', '45368', 'H');
INSERT INTO `ey_region` VALUES ('45461', '循化县', '3', '45368', 'X');
INSERT INTO `ey_region` VALUES ('45471', '海北州', '2', '45286', 'H');
INSERT INTO `ey_region` VALUES ('45472', '门源县', '3', '45471', 'M');
INSERT INTO `ey_region` VALUES ('45487', '祁连县', '3', '45471', 'Q');
INSERT INTO `ey_region` VALUES ('45495', '海晏县', '3', '45471', 'H');
INSERT INTO `ey_region` VALUES ('45502', '刚察县', '3', '45471', 'G');
INSERT INTO `ey_region` VALUES ('45510', '黄南州', '2', '45286', 'H');
INSERT INTO `ey_region` VALUES ('45511', '同仁县', '3', '45510', 'T');
INSERT INTO `ey_region` VALUES ('45523', '尖扎县', '3', '45510', 'J');
INSERT INTO `ey_region` VALUES ('45533', '泽库县', '3', '45510', 'Z');
INSERT INTO `ey_region` VALUES ('45542', '河南县', '3', '45510', 'H');
INSERT INTO `ey_region` VALUES ('45548', '海南州', '2', '45286', 'H');
INSERT INTO `ey_region` VALUES ('45549', '共和县', '3', '45548', 'G');
INSERT INTO `ey_region` VALUES ('45566', '同德县', '3', '45548', 'T');
INSERT INTO `ey_region` VALUES ('45573', '贵德县', '3', '45548', 'G');
INSERT INTO `ey_region` VALUES ('45581', '兴海县', '3', '45548', 'X');
INSERT INTO `ey_region` VALUES ('45589', '贵南县', '3', '45548', 'G');
INSERT INTO `ey_region` VALUES ('45597', '果洛州', '2', '45286', 'G');
INSERT INTO `ey_region` VALUES ('45598', '玛沁县', '3', '45597', 'M');
INSERT INTO `ey_region` VALUES ('45607', '班玛县', '3', '45597', 'B');
INSERT INTO `ey_region` VALUES ('45617', '甘德县', '3', '45597', 'G');
INSERT INTO `ey_region` VALUES ('45625', '达日县', '3', '45597', 'D');
INSERT INTO `ey_region` VALUES ('45636', '久治县', '3', '45597', 'J');
INSERT INTO `ey_region` VALUES ('45643', '玛多县', '3', '45597', 'M');
INSERT INTO `ey_region` VALUES ('45648', '玉树州', '2', '45286', 'Y');
INSERT INTO `ey_region` VALUES ('45649', '玉树县', '3', '45648', 'Y');
INSERT INTO `ey_region` VALUES ('45659', '杂多县', '3', '45648', 'Z');
INSERT INTO `ey_region` VALUES ('45668', '称多县', '3', '45648', 'C');
INSERT INTO `ey_region` VALUES ('45676', '治多县', '3', '45648', 'Z');
INSERT INTO `ey_region` VALUES ('45683', '囊谦县', '3', '45648', 'N');
INSERT INTO `ey_region` VALUES ('45694', '曲麻莱县', '3', '45648', 'Q');
INSERT INTO `ey_region` VALUES ('45701', '海西州', '2', '45286', 'H');
INSERT INTO `ey_region` VALUES ('45702', '格尔木市', '3', '45701', 'G');
INSERT INTO `ey_region` VALUES ('45714', '德令哈市', '3', '45701', 'D');
INSERT INTO `ey_region` VALUES ('45727', '乌兰县', '3', '45701', 'W');
INSERT INTO `ey_region` VALUES ('45733', '都兰县', '3', '45701', 'D');
INSERT INTO `ey_region` VALUES ('45742', '天峻县', '3', '45701', 'T');
INSERT INTO `ey_region` VALUES ('45753', '宁夏回族自治区', '1', '0', 'N');
INSERT INTO `ey_region` VALUES ('45754', '银川市', '2', '45753', 'Y');
INSERT INTO `ey_region` VALUES ('45755', '市辖区', '3', '45754', 'S');
INSERT INTO `ey_region` VALUES ('45756', '兴庆区', '3', '45754', 'X');
INSERT INTO `ey_region` VALUES ('45772', '西夏区', '3', '45754', 'X');
INSERT INTO `ey_region` VALUES ('45784', '金凤区', '3', '45754', 'J');
INSERT INTO `ey_region` VALUES ('45794', '永宁县', '3', '45754', 'Y');
INSERT INTO `ey_region` VALUES ('45803', '贺兰县', '3', '45754', 'H');
INSERT INTO `ey_region` VALUES ('45813', '灵武市', '3', '45754', 'L');
INSERT INTO `ey_region` VALUES ('45825', '石嘴山市', '2', '45753', 'S');
INSERT INTO `ey_region` VALUES ('45826', '市辖区', '3', '45825', 'S');
INSERT INTO `ey_region` VALUES ('45827', '大武口区', '3', '45825', 'D');
INSERT INTO `ey_region` VALUES ('45839', '惠农区', '3', '45825', 'H');
INSERT INTO `ey_region` VALUES ('45856', '平罗县', '3', '45825', 'P');
INSERT INTO `ey_region` VALUES ('45871', '吴忠市', '2', '45753', 'W');
INSERT INTO `ey_region` VALUES ('45872', '市辖区', '3', '45871', 'S');
INSERT INTO `ey_region` VALUES ('45877', '利通区', '3', '45871', 'L');
INSERT INTO `ey_region` VALUES ('45892', '盐池县', '3', '45871', 'Y');
INSERT INTO `ey_region` VALUES ('45903', '同心县', '3', '45871', 'T');
INSERT INTO `ey_region` VALUES ('45914', '青铜峡市', '3', '45871', 'Q');
INSERT INTO `ey_region` VALUES ('45926', '固原市', '2', '45753', 'G');
INSERT INTO `ey_region` VALUES ('45927', '市辖区', '3', '45926', 'S');
INSERT INTO `ey_region` VALUES ('45928', '原州区', '3', '45926', 'Y');
INSERT INTO `ey_region` VALUES ('45944', '西吉县', '3', '45926', 'X');
INSERT INTO `ey_region` VALUES ('45964', '隆德县', '3', '45926', 'L');
INSERT INTO `ey_region` VALUES ('45978', '泾源县', '3', '45926', 'J');
INSERT INTO `ey_region` VALUES ('45986', '彭阳县', '3', '45926', 'P');
INSERT INTO `ey_region` VALUES ('45999', '中卫市', '2', '45753', 'Z');
INSERT INTO `ey_region` VALUES ('46000', '市辖区', '3', '45999', 'S');
INSERT INTO `ey_region` VALUES ('46012', '沙坡头区', '3', '45999', 'S');
INSERT INTO `ey_region` VALUES ('46013', '中宁县', '3', '45999', 'Z');
INSERT INTO `ey_region` VALUES ('46026', '海原县', '3', '45999', 'H');
INSERT INTO `ey_region` VALUES ('46047', '新疆维吾尔自治区', '1', '0', 'X');
INSERT INTO `ey_region` VALUES ('46048', '乌鲁木齐市', '2', '46047', 'W');
INSERT INTO `ey_region` VALUES ('46049', '市辖区', '3', '46048', 'S');
INSERT INTO `ey_region` VALUES ('46050', '天山区', '3', '46048', 'T');
INSERT INTO `ey_region` VALUES ('46065', '沙依巴克区', '3', '46048', 'S');
INSERT INTO `ey_region` VALUES ('46079', '新市区', '3', '46048', 'X');
INSERT INTO `ey_region` VALUES ('46095', '水磨沟区', '3', '46048', 'S');
INSERT INTO `ey_region` VALUES ('46104', '头屯河区', '3', '46048', 'T');
INSERT INTO `ey_region` VALUES ('46114', '达坂城区', '3', '46048', 'D');
INSERT INTO `ey_region` VALUES ('46123', '东山区', '3', '46048', 'D');
INSERT INTO `ey_region` VALUES ('46128', '乌鲁木齐县', '3', '46048', 'W');
INSERT INTO `ey_region` VALUES ('46138', '克拉玛依市', '2', '46047', 'K');
INSERT INTO `ey_region` VALUES ('46139', '市辖区', '3', '46138', 'S');
INSERT INTO `ey_region` VALUES ('46140', '独山子区', '3', '46138', 'D');
INSERT INTO `ey_region` VALUES ('46144', '克拉玛依区', '3', '46138', 'K');
INSERT INTO `ey_region` VALUES ('46155', '白碱滩区', '3', '46138', 'B');
INSERT INTO `ey_region` VALUES ('46158', '乌尔禾区', '3', '46138', 'W');
INSERT INTO `ey_region` VALUES ('46162', '吐鲁番地区', '2', '46047', 'T');
INSERT INTO `ey_region` VALUES ('46163', '吐鲁番市', '3', '46162', 'T');
INSERT INTO `ey_region` VALUES ('46178', '鄯善县', '3', '46162', 'S');
INSERT INTO `ey_region` VALUES ('46189', '托克逊县', '3', '46162', 'T');
INSERT INTO `ey_region` VALUES ('46197', '哈密地区', '2', '46047', 'H');
INSERT INTO `ey_region` VALUES ('46198', '哈密市', '3', '46197', 'H');
INSERT INTO `ey_region` VALUES ('46230', '巴里坤县', '3', '46197', 'B');
INSERT INTO `ey_region` VALUES ('46246', '伊吾县', '3', '46197', 'Y');
INSERT INTO `ey_region` VALUES ('46255', '昌吉州', '2', '46047', 'C');
INSERT INTO `ey_region` VALUES ('46256', '昌吉市', '3', '46255', 'C');
INSERT INTO `ey_region` VALUES ('46275', '阜康市', '3', '46255', 'F');
INSERT INTO `ey_region` VALUES ('46289', '米泉市', '3', '46255', 'M');
INSERT INTO `ey_region` VALUES ('46299', '呼图壁县', '3', '46255', 'H');
INSERT INTO `ey_region` VALUES ('46316', '玛纳斯', '3', '46255', 'M');
INSERT INTO `ey_region` VALUES ('46337', '奇台县', '3', '46255', 'Q');
INSERT INTO `ey_region` VALUES ('46355', '吉木萨尔县', '3', '46255', 'J');
INSERT INTO `ey_region` VALUES ('46366', '木垒县', '3', '46255', 'M');
INSERT INTO `ey_region` VALUES ('46380', '博州', '2', '46047', 'B');
INSERT INTO `ey_region` VALUES ('46381', '博乐市', '3', '46380', 'B');
INSERT INTO `ey_region` VALUES ('46399', '精河县', '3', '46380', 'J');
INSERT INTO `ey_region` VALUES ('46410', '温泉县', '3', '46380', 'W');
INSERT INTO `ey_region` VALUES ('46422', '巴州', '2', '46047', 'B');
INSERT INTO `ey_region` VALUES ('46423', '库尔勒市', '3', '46422', 'K');
INSERT INTO `ey_region` VALUES ('46451', '轮台县', '3', '46422', 'L');
INSERT INTO `ey_region` VALUES ('46463', '尉犁县', '3', '46422', 'W');
INSERT INTO `ey_region` VALUES ('46476', '若羌县', '3', '46422', 'R');
INSERT INTO `ey_region` VALUES ('46486', '且末县', '3', '46422', 'Q');
INSERT INTO `ey_region` VALUES ('46500', '焉耆县', '3', '46422', 'Y');
INSERT INTO `ey_region` VALUES ('46512', '和静县', '3', '46422', 'H');
INSERT INTO `ey_region` VALUES ('46531', '和硕县', '3', '46422', 'H');
INSERT INTO `ey_region` VALUES ('46542', '博湖县', '3', '46422', 'B');
INSERT INTO `ey_region` VALUES ('46551', '阿克苏地区', '2', '46047', 'A');
INSERT INTO `ey_region` VALUES ('46552', '阿克苏市', '3', '46551', 'A');
INSERT INTO `ey_region` VALUES ('46571', '温宿县', '3', '46551', 'W');
INSERT INTO `ey_region` VALUES ('46592', '库车县', '3', '46551', 'K');
INSERT INTO `ey_region` VALUES ('46617', '沙雅县', '3', '46551', 'S');
INSERT INTO `ey_region` VALUES ('46630', '新和县', '3', '46551', 'X');
INSERT INTO `ey_region` VALUES ('46640', '拜城县', '3', '46551', 'B');
INSERT INTO `ey_region` VALUES ('46657', '乌什县', '3', '46551', 'W');
INSERT INTO `ey_region` VALUES ('46668', '阿瓦提县', '3', '46551', 'A');
INSERT INTO `ey_region` VALUES ('46682', '柯坪县', '3', '46551', 'K');
INSERT INTO `ey_region` VALUES ('46688', '克州', '2', '46047', 'K');
INSERT INTO `ey_region` VALUES ('46689', '阿图什市', '3', '46688', 'A');
INSERT INTO `ey_region` VALUES ('46704', '阿克陶县', '3', '46688', 'A');
INSERT INTO `ey_region` VALUES ('46723', '阿合奇县', '3', '46688', 'A');
INSERT INTO `ey_region` VALUES ('46733', '乌恰县', '3', '46688', 'W');
INSERT INTO `ey_region` VALUES ('46747', '喀什地区', '2', '46047', 'K');
INSERT INTO `ey_region` VALUES ('46748', '喀什市', '3', '46747', 'K');
INSERT INTO `ey_region` VALUES ('46761', '疏附县', '3', '46747', 'S');
INSERT INTO `ey_region` VALUES ('46780', '疏勒县', '3', '46747', 'S');
INSERT INTO `ey_region` VALUES ('46797', '英吉沙县', '3', '46747', 'Y');
INSERT INTO `ey_region` VALUES ('46813', '泽普县', '3', '46747', 'Z');
INSERT INTO `ey_region` VALUES ('46830', '莎车县', '3', '46747', 'S');
INSERT INTO `ey_region` VALUES ('46863', '叶城县', '3', '46747', 'Y');
INSERT INTO `ey_region` VALUES ('46885', '麦盖提县', '3', '46747', 'M');
INSERT INTO `ey_region` VALUES ('46902', '岳普湖县', '3', '46747', 'Y');
INSERT INTO `ey_region` VALUES ('46913', '伽师县', '3', '46747', 'Q');
INSERT INTO `ey_region` VALUES ('46928', '巴楚县', '3', '46747', 'B');
INSERT INTO `ey_region` VALUES ('46942', '塔什库尔干县', '3', '46747', 'T');
INSERT INTO `ey_region` VALUES ('46957', '和田地区', '2', '46047', 'H');
INSERT INTO `ey_region` VALUES ('46958', '和田市', '3', '46957', 'H');
INSERT INTO `ey_region` VALUES ('46971', '和田县', '3', '46957', 'H');
INSERT INTO `ey_region` VALUES ('46983', '墨玉县', '3', '46957', 'M');
INSERT INTO `ey_region` VALUES ('47002', '皮山县', '3', '46957', 'P');
INSERT INTO `ey_region` VALUES ('47020', '洛浦县', '3', '46957', 'L');
INSERT INTO `ey_region` VALUES ('47032', '策勒县', '3', '46957', 'C');
INSERT INTO `ey_region` VALUES ('47042', '于田县', '3', '46957', 'Y');
INSERT INTO `ey_region` VALUES ('47061', '民丰县', '3', '46957', 'M');
INSERT INTO `ey_region` VALUES ('47069', '伊犁州', '2', '46047', 'Y');
INSERT INTO `ey_region` VALUES ('47070', '伊宁市', '3', '47069', 'Y');
INSERT INTO `ey_region` VALUES ('47091', '奎屯市', '3', '47069', 'K');
INSERT INTO `ey_region` VALUES ('47099', '伊宁县', '3', '47069', 'Y');
INSERT INTO `ey_region` VALUES ('47121', '察布查尔县', '3', '47069', 'C');
INSERT INTO `ey_region` VALUES ('47143', '霍城县', '3', '47069', 'H');
INSERT INTO `ey_region` VALUES ('47164', '巩留县', '3', '47069', 'G');
INSERT INTO `ey_region` VALUES ('47180', '新源县', '3', '47069', 'X');
INSERT INTO `ey_region` VALUES ('47196', '昭苏县', '3', '47069', 'Z');
INSERT INTO `ey_region` VALUES ('47214', '特克斯县', '3', '47069', 'T');
INSERT INTO `ey_region` VALUES ('47226', '尼勒克县', '3', '47069', 'N');
INSERT INTO `ey_region` VALUES ('47241', '塔城地区', '2', '46047', 'T');
INSERT INTO `ey_region` VALUES ('47242', '塔城市', '3', '47241', 'T');
INSERT INTO `ey_region` VALUES ('47258', '乌苏市', '3', '47241', 'W');
INSERT INTO `ey_region` VALUES ('47291', '额敏县', '3', '47241', 'E');
INSERT INTO `ey_region` VALUES ('47315', '沙湾县', '3', '47241', 'S');
INSERT INTO `ey_region` VALUES ('47338', '托里县', '3', '47241', 'T');
INSERT INTO `ey_region` VALUES ('47351', '裕民县', '3', '47241', 'Y');
INSERT INTO `ey_region` VALUES ('47360', '和布县', '3', '47241', 'H');
INSERT INTO `ey_region` VALUES ('47374', '阿勒泰地区', '2', '46047', 'A');
INSERT INTO `ey_region` VALUES ('47375', '阿勒泰市', '3', '47374', 'A');
INSERT INTO `ey_region` VALUES ('47393', '布尔津县', '3', '47374', 'B');
INSERT INTO `ey_region` VALUES ('47401', '富蕴县', '3', '47374', 'F');
INSERT INTO `ey_region` VALUES ('47411', '福海县', '3', '47374', 'F');
INSERT INTO `ey_region` VALUES ('47424', '哈巴河县', '3', '47374', 'H');
INSERT INTO `ey_region` VALUES ('47433', '青河县', '3', '47374', 'Q');
INSERT INTO `ey_region` VALUES ('47441', '吉木乃县', '3', '47374', 'J');
INSERT INTO `ey_region` VALUES ('47450', '省直辖行政单位', '2', '46047', 'S');
INSERT INTO `ey_region` VALUES ('47451', '石河子市', '3', '47450', 'S');
INSERT INTO `ey_region` VALUES ('47460', '阿拉尔市', '3', '47450', 'A');
INSERT INTO `ey_region` VALUES ('47477', '图木舒克市', '3', '47450', 'T');
INSERT INTO `ey_region` VALUES ('47486', '五家渠市', '3', '47450', 'W');
INSERT INTO `ey_region` VALUES ('47493', '台湾省', '1', '0', 'T');
INSERT INTO `ey_region` VALUES ('47494', '香港特别行政区', '1', '0', 'X');
INSERT INTO `ey_region` VALUES ('47495', '澳门特别行政区', '1', '0', 'A');
INSERT INTO `ey_region` VALUES ('47496', '龙华新区', '3', '28558', 'L');
INSERT INTO `ey_region` VALUES ('47497', '光明新区', '3', '28558', 'G');
INSERT INTO `ey_region` VALUES ('47500', '新界', '2', '47494', 'X');
INSERT INTO `ey_region` VALUES ('47501', '观塘区', '3', '47498', 'G');
INSERT INTO `ey_region` VALUES ('47502', '黄大仙区', '3', '47498', 'H');
INSERT INTO `ey_region` VALUES ('47503', '九龙城区', '3', '47498', 'J');
INSERT INTO `ey_region` VALUES ('47504', '深水埗区', '3', '47498', 'S');
INSERT INTO `ey_region` VALUES ('47505', '油尖旺区', '3', '47498', 'Y');
INSERT INTO `ey_region` VALUES ('47506', '东区', '3', '47499', 'D');
INSERT INTO `ey_region` VALUES ('47507', '南区', '3', '47499', 'N');
INSERT INTO `ey_region` VALUES ('47508', '湾仔', '3', '47499', 'W');
INSERT INTO `ey_region` VALUES ('47509', '中西区', '3', '47499', 'Z');
INSERT INTO `ey_region` VALUES ('47510', '北区', '3', '47500', 'B');
INSERT INTO `ey_region` VALUES ('47511', '大埔区', '3', '47500', 'D');
INSERT INTO `ey_region` VALUES ('47512', '葵青区', '3', '47500', 'K');
INSERT INTO `ey_region` VALUES ('47513', '离岛区', '3', '47500', 'L');
INSERT INTO `ey_region` VALUES ('47514', '荃湾区', '3', '47500', 'Q');
INSERT INTO `ey_region` VALUES ('47515', '沙田区', '3', '47500', 'S');
INSERT INTO `ey_region` VALUES ('47516', '屯门区', '3', '47500', 'T');
INSERT INTO `ey_region` VALUES ('47517', '西贡区', '3', '47500', 'X');
INSERT INTO `ey_region` VALUES ('47518', '元朗区', '3', '47500', 'Y');
INSERT INTO `ey_region` VALUES ('47519', '澳门半岛', '2', '47495', 'A');
INSERT INTO `ey_region` VALUES ('47520', '离岛', '2', '47495', 'L');
INSERT INTO `ey_region` VALUES ('47521', '大堂区', '3', '47519', 'D');
INSERT INTO `ey_region` VALUES ('47522', '风顺堂区', '3', '47519', 'F');
INSERT INTO `ey_region` VALUES ('47523', '花地玛堂区', '3', '47519', 'H');
INSERT INTO `ey_region` VALUES ('47524', '花王堂区', '3', '47519', 'H');
INSERT INTO `ey_region` VALUES ('47525', '望德堂区', '3', '47519', 'W');
INSERT INTO `ey_region` VALUES ('47526', '嘉模堂区', '3', '47520', 'J');
INSERT INTO `ey_region` VALUES ('47527', '路氹填海区', '3', '47520', 'L');
INSERT INTO `ey_region` VALUES ('47528', '圣方济各堂区', '3', '47520', 'S');
INSERT INTO `ey_region` VALUES ('47529', '高雄市', '2', '47493', 'G');
INSERT INTO `ey_region` VALUES ('47530', '花莲县', '2', '47493', 'H');
INSERT INTO `ey_region` VALUES ('47531', '基隆市', '2', '47493', 'J');
INSERT INTO `ey_region` VALUES ('47532', '嘉义市', '2', '47493', 'J');
INSERT INTO `ey_region` VALUES ('47533', '嘉义县', '2', '47493', 'J');
INSERT INTO `ey_region` VALUES ('47534', '金门县', '2', '47493', 'J');
INSERT INTO `ey_region` VALUES ('47535', '连江县', '2', '47493', 'L');
INSERT INTO `ey_region` VALUES ('47536', '苗栗县', '2', '47493', 'M');
INSERT INTO `ey_region` VALUES ('47537', '南投县', '2', '47493', 'N');
INSERT INTO `ey_region` VALUES ('47538', '澎湖县', '2', '47493', 'P');
INSERT INTO `ey_region` VALUES ('47539', '屏东县', '2', '47493', 'P');
INSERT INTO `ey_region` VALUES ('47540', '台北市', '2', '47493', 'T');
INSERT INTO `ey_region` VALUES ('47541', '台东县', '2', '47493', 'T');
INSERT INTO `ey_region` VALUES ('47542', '台南市', '2', '47493', 'T');
INSERT INTO `ey_region` VALUES ('47543', '台中市', '2', '47493', 'T');
INSERT INTO `ey_region` VALUES ('47544', '桃园市', '2', '47493', 'T');
INSERT INTO `ey_region` VALUES ('47545', '新北市', '2', '47493', 'X');
INSERT INTO `ey_region` VALUES ('47546', '新竹市', '2', '47493', 'X');
INSERT INTO `ey_region` VALUES ('47547', '新竹县', '2', '47493', 'X');
INSERT INTO `ey_region` VALUES ('47548', '宜兰县', '2', '47493', 'Y');
INSERT INTO `ey_region` VALUES ('47549', '云林县', '2', '47493', 'Y');
INSERT INTO `ey_region` VALUES ('47550', '彰化县', '2', '47493', 'Z');
INSERT INTO `ey_region` VALUES ('47551', '阿莲区', '3', '47529', 'A');
INSERT INTO `ey_region` VALUES ('47552', '大寮区', '3', '47529', 'D');
INSERT INTO `ey_region` VALUES ('47553', '大社区', '3', '47529', 'D');
INSERT INTO `ey_region` VALUES ('47554', '大树区', '3', '47529', 'D');
INSERT INTO `ey_region` VALUES ('47555', '凤山区', '3', '47529', 'F');
INSERT INTO `ey_region` VALUES ('47556', '冈山区', '3', '47529', 'G');
INSERT INTO `ey_region` VALUES ('47557', '鼓山区', '3', '47529', 'G');
INSERT INTO `ey_region` VALUES ('47558', '湖内区', '3', '47529', 'H');
INSERT INTO `ey_region` VALUES ('47559', '甲仙区', '3', '47529', 'J');
INSERT INTO `ey_region` VALUES ('47560', '林园区', '3', '47529', 'L');
INSERT INTO `ey_region` VALUES ('47561', '苓雅区', '3', '47529', 'L');
INSERT INTO `ey_region` VALUES ('47562', '六龟区', '3', '47529', 'L');
INSERT INTO `ey_region` VALUES ('47563', '路竹区', '3', '47529', 'L');
INSERT INTO `ey_region` VALUES ('47564', '茂林区', '3', '47529', 'M');
INSERT INTO `ey_region` VALUES ('47565', '美浓区', '3', '47529', 'M');
INSERT INTO `ey_region` VALUES ('47566', '弥陀区', '3', '47529', 'M');
INSERT INTO `ey_region` VALUES ('47567', '楠梓区', '3', '47529', 'N');
INSERT INTO `ey_region` VALUES ('47568', '那玛夏区', '3', '47529', 'N');
INSERT INTO `ey_region` VALUES ('47569', '内门区', '3', '47529', 'N');
INSERT INTO `ey_region` VALUES ('47570', '鸟松区', '3', '47529', 'N');
INSERT INTO `ey_region` VALUES ('47571', '旗津区', '3', '47529', 'Q');
INSERT INTO `ey_region` VALUES ('47572', '旗门区', '3', '47529', 'Q');
INSERT INTO `ey_region` VALUES ('47573', '其它区', '3', '47529', 'Q');
INSERT INTO `ey_region` VALUES ('47574', '前金区', '3', '47529', 'Q');
INSERT INTO `ey_region` VALUES ('47575', '前镇区', '3', '47529', 'Q');
INSERT INTO `ey_region` VALUES ('47576', '桥头区', '3', '47529', 'Q');
INSERT INTO `ey_region` VALUES ('47577', '茄萣区', '3', '47529', 'Q');
INSERT INTO `ey_region` VALUES ('47578', '芩雅区', '3', '47529', 'Q');
INSERT INTO `ey_region` VALUES ('47579', '仁武区', '3', '47529', 'R');
INSERT INTO `ey_region` VALUES ('47580', '三民区', '3', '47529', 'S');
INSERT INTO `ey_region` VALUES ('47581', '杉林区', '3', '47529', 'S');
INSERT INTO `ey_region` VALUES ('47582', '桃源区', '3', '47529', 'T');
INSERT INTO `ey_region` VALUES ('47583', '田寮区', '3', '47529', 'T');
INSERT INTO `ey_region` VALUES ('47584', '小港区', '3', '47529', 'X');
INSERT INTO `ey_region` VALUES ('47585', '新兴区', '3', '47529', 'X');
INSERT INTO `ey_region` VALUES ('47586', '燕巢区', '3', '47529', 'Y');
INSERT INTO `ey_region` VALUES ('47587', '盐埕区', '3', '47529', 'Y');
INSERT INTO `ey_region` VALUES ('47588', '永安区', '3', '47529', 'Y');
INSERT INTO `ey_region` VALUES ('47589', '梓官区', '3', '47529', 'Z');
INSERT INTO `ey_region` VALUES ('47590', '左营区', '3', '47529', 'Z');
INSERT INTO `ey_region` VALUES ('47591', '丰滨乡', '3', '47530', 'F');
INSERT INTO `ey_region` VALUES ('47592', '凤林镇', '3', '47530', 'F');
INSERT INTO `ey_region` VALUES ('47593', '富里乡', '3', '47530', 'F');
INSERT INTO `ey_region` VALUES ('47594', '光复乡', '3', '47530', 'G');
INSERT INTO `ey_region` VALUES ('47595', '花莲市', '3', '47530', 'H');
INSERT INTO `ey_region` VALUES ('47596', '吉安乡', '3', '47530', 'J');
INSERT INTO `ey_region` VALUES ('47597', '瑞穗乡', '3', '47530', 'R');
INSERT INTO `ey_region` VALUES ('47598', '寿丰乡', '3', '47530', 'S');
INSERT INTO `ey_region` VALUES ('47599', '太鲁阁', '3', '47530', 'T');
INSERT INTO `ey_region` VALUES ('47600', '万荣乡', '3', '47530', 'W');
INSERT INTO `ey_region` VALUES ('47601', '新城乡', '3', '47530', 'X');
INSERT INTO `ey_region` VALUES ('47602', '秀林乡', '3', '47530', 'X');
INSERT INTO `ey_region` VALUES ('47603', '玉里镇', '3', '47530', 'Y');
INSERT INTO `ey_region` VALUES ('47604', '卓溪乡', '3', '47530', 'Z');
INSERT INTO `ey_region` VALUES ('47605', '安乐区', '3', '47531', 'A');
INSERT INTO `ey_region` VALUES ('47606', '暖暖区', '3', '47531', 'N');
INSERT INTO `ey_region` VALUES ('47607', '七堵区', '3', '47531', 'Q');
INSERT INTO `ey_region` VALUES ('47608', '其它区', '3', '47531', 'Q');
INSERT INTO `ey_region` VALUES ('47609', '仁爱区', '3', '47531', 'R');
INSERT INTO `ey_region` VALUES ('47610', '信义区', '3', '47531', 'X');
INSERT INTO `ey_region` VALUES ('47611', '中山区', '3', '47531', 'Z');
INSERT INTO `ey_region` VALUES ('47612', '中正区', '3', '47531', 'Z');
INSERT INTO `ey_region` VALUES ('47613', '东区', '3', '47532', 'D');
INSERT INTO `ey_region` VALUES ('47614', '西区', '3', '47532', 'X');
INSERT INTO `ey_region` VALUES ('47615', '其它区', '3', '47532', 'Q');
INSERT INTO `ey_region` VALUES ('47616', '阿里山乡', '3', '47533', 'A');
INSERT INTO `ey_region` VALUES ('47617', '布袋镇', '3', '47533', 'B');
INSERT INTO `ey_region` VALUES ('47618', '大林镇', '3', '47533', 'D');
INSERT INTO `ey_region` VALUES ('47619', '大埔乡', '3', '47533', 'D');
INSERT INTO `ey_region` VALUES ('47620', '东石乡', '3', '47533', 'D');
INSERT INTO `ey_region` VALUES ('47621', '番路乡', '3', '47533', 'F');
INSERT INTO `ey_region` VALUES ('47622', '六脚乡', '3', '47533', 'L');
INSERT INTO `ey_region` VALUES ('47623', '鹿草乡', '3', '47533', 'L');
INSERT INTO `ey_region` VALUES ('47624', '梅山乡', '3', '47533', 'M');
INSERT INTO `ey_region` VALUES ('47625', '民雄乡', '3', '47533', 'M');
INSERT INTO `ey_region` VALUES ('47626', '朴子市', '3', '47533', 'P');
INSERT INTO `ey_region` VALUES ('47627', '水上乡', '3', '47533', 'S');
INSERT INTO `ey_region` VALUES ('47628', '太保市', '3', '47533', 'T');
INSERT INTO `ey_region` VALUES ('47629', '溪口乡', '3', '47533', 'X');
INSERT INTO `ey_region` VALUES ('47630', '新港乡', '3', '47533', 'X');
INSERT INTO `ey_region` VALUES ('47631', '义竹乡', '3', '47533', 'Y');
INSERT INTO `ey_region` VALUES ('47632', '中埔乡', '3', '47533', 'Z');
INSERT INTO `ey_region` VALUES ('47633', '竹崎乡', '3', '47533', 'Z');
INSERT INTO `ey_region` VALUES ('47634', '金城镇', '3', '47534', 'J');
INSERT INTO `ey_region` VALUES ('47635', '金湖镇', '3', '47534', 'J');
INSERT INTO `ey_region` VALUES ('47636', '金宁乡', '3', '47534', 'J');
INSERT INTO `ey_region` VALUES ('47637', '金沙镇', '3', '47534', 'J');
INSERT INTO `ey_region` VALUES ('47638', '烈屿乡', '3', '47534', 'L');
INSERT INTO `ey_region` VALUES ('47639', '乌邱乡', '3', '47534', 'W');
INSERT INTO `ey_region` VALUES ('47640', '北竿乡', '3', '47535', 'B');
INSERT INTO `ey_region` VALUES ('47641', '东引乡', '3', '47535', 'D');
INSERT INTO `ey_region` VALUES ('47642', '莒光乡', '3', '47535', 'J');
INSERT INTO `ey_region` VALUES ('47643', '南竿乡', '3', '47535', 'N');
INSERT INTO `ey_region` VALUES ('47644', '大湖乡', '3', '47536', 'D');
INSERT INTO `ey_region` VALUES ('47645', '公馆乡', '3', '47536', 'G');
INSERT INTO `ey_region` VALUES ('47646', '后龙镇', '3', '47536', 'H');
INSERT INTO `ey_region` VALUES ('47647', '苗栗市', '3', '47536', 'M');
INSERT INTO `ey_region` VALUES ('47648', '南庄乡', '3', '47536', 'N');
INSERT INTO `ey_region` VALUES ('47649', '三湾乡', '3', '47536', 'S');
INSERT INTO `ey_region` VALUES ('47650', '三义乡', '3', '47536', 'S');
INSERT INTO `ey_region` VALUES ('47651', '狮潭乡', '3', '47536', 'S');
INSERT INTO `ey_region` VALUES ('47652', '泰安乡', '3', '47536', 'T');
INSERT INTO `ey_region` VALUES ('47653', '铜锣乡', '3', '47536', 'T');
INSERT INTO `ey_region` VALUES ('47654', '通宵镇', '3', '47536', 'T');
INSERT INTO `ey_region` VALUES ('47655', '头份镇', '3', '47536', 'T');
INSERT INTO `ey_region` VALUES ('47656', '头屋乡', '3', '47536', 'T');
INSERT INTO `ey_region` VALUES ('47657', '西湖乡', '3', '47536', 'X');
INSERT INTO `ey_region` VALUES ('47658', '苑里镇', '3', '47536', 'Y');
INSERT INTO `ey_region` VALUES ('47659', '造桥乡', '3', '47536', 'Z');
INSERT INTO `ey_region` VALUES ('47660', '竹南镇', '3', '47536', 'Z');
INSERT INTO `ey_region` VALUES ('47661', '卓兰镇', '3', '47536', 'Z');
INSERT INTO `ey_region` VALUES ('47662', '草屯镇', '3', '47537', 'C');
INSERT INTO `ey_region` VALUES ('47663', '国姓乡', '3', '47537', 'G');
INSERT INTO `ey_region` VALUES ('47664', '集集镇', '3', '47537', 'J');
INSERT INTO `ey_region` VALUES ('47665', '鹿谷乡', '3', '47537', 'L');
INSERT INTO `ey_region` VALUES ('47666', '名间乡', '3', '47537', 'M');
INSERT INTO `ey_region` VALUES ('47667', '南投市', '3', '47537', 'N');
INSERT INTO `ey_region` VALUES ('47668', '埔里镇', '3', '47537', 'P');
INSERT INTO `ey_region` VALUES ('47669', '仁爱乡', '3', '47537', 'R');
INSERT INTO `ey_region` VALUES ('47670', '水里乡', '3', '47537', 'S');
INSERT INTO `ey_region` VALUES ('47671', '信义乡', '3', '47537', 'X');
INSERT INTO `ey_region` VALUES ('47672', '鱼池乡', '3', '47537', 'Y');
INSERT INTO `ey_region` VALUES ('47673', '中寮乡', '3', '47537', 'Z');
INSERT INTO `ey_region` VALUES ('47674', '竹山镇', '3', '47537', 'Z');
INSERT INTO `ey_region` VALUES ('47675', '白沙乡', '3', '47538', 'B');
INSERT INTO `ey_region` VALUES ('47676', '湖西乡', '3', '47538', 'H');
INSERT INTO `ey_region` VALUES ('47677', '马公市', '3', '47538', 'M');
INSERT INTO `ey_region` VALUES ('47678', '七美乡', '3', '47538', 'Q');
INSERT INTO `ey_region` VALUES ('47679', '望安乡', '3', '47538', 'W');
INSERT INTO `ey_region` VALUES ('47680', '西屿乡', '3', '47538', 'X');
INSERT INTO `ey_region` VALUES ('47681', '长治乡', '3', '47539', 'C');
INSERT INTO `ey_region` VALUES ('47682', '潮州镇', '3', '47539', 'C');
INSERT INTO `ey_region` VALUES ('47683', '车城乡', '3', '47539', 'C');
INSERT INTO `ey_region` VALUES ('47684', '春日乡', '3', '47539', 'C');
INSERT INTO `ey_region` VALUES ('47685', '东港镇', '3', '47539', 'D');
INSERT INTO `ey_region` VALUES ('47686', '枋寮乡', '3', '47539', 'F');
INSERT INTO `ey_region` VALUES ('47687', '枋山乡', '3', '47539', 'F');
INSERT INTO `ey_region` VALUES ('47688', '高树乡', '3', '47539', 'G');
INSERT INTO `ey_region` VALUES ('47689', '恒春镇', '3', '47539', 'H');
INSERT INTO `ey_region` VALUES ('47690', '佳冬乡', '3', '47539', 'J');
INSERT INTO `ey_region` VALUES ('47691', '九如乡', '3', '47539', 'J');
INSERT INTO `ey_region` VALUES ('47692', '崁顶乡', '3', '47539', 'K');
INSERT INTO `ey_region` VALUES ('47693', '来义乡', '3', '47539', 'L');
INSERT INTO `ey_region` VALUES ('47694', '里港乡', '3', '47539', 'L');
INSERT INTO `ey_region` VALUES ('47695', '林边乡', '3', '47539', 'L');
INSERT INTO `ey_region` VALUES ('47696', '麟洛乡', '3', '47539', 'L');
INSERT INTO `ey_region` VALUES ('47697', '琉球乡', '3', '47539', 'L');
INSERT INTO `ey_region` VALUES ('47698', '玛家乡', '3', '47539', 'M');
INSERT INTO `ey_region` VALUES ('47699', '满州乡', '3', '47539', 'M');
INSERT INTO `ey_region` VALUES ('47700', '牡丹乡', '3', '47539', 'M');
INSERT INTO `ey_region` VALUES ('47701', '南州乡', '3', '47539', 'N');
INSERT INTO `ey_region` VALUES ('47702', '内埔乡', '3', '47539', 'N');
INSERT INTO `ey_region` VALUES ('47703', '屏东市', '3', '47539', 'P');
INSERT INTO `ey_region` VALUES ('47704', '三地门乡', '3', '47539', 'S');
INSERT INTO `ey_region` VALUES ('47705', '狮子乡', '3', '47539', 'S');
INSERT INTO `ey_region` VALUES ('47706', '泰武乡', '3', '47539', 'T');
INSERT INTO `ey_region` VALUES ('47707', '万丹乡', '3', '47539', 'W');
INSERT INTO `ey_region` VALUES ('47708', '万峦乡', '3', '47539', 'W');
INSERT INTO `ey_region` VALUES ('47709', '雾台乡', '3', '47539', 'W');
INSERT INTO `ey_region` VALUES ('47710', '新埤乡', '3', '47539', 'X');
INSERT INTO `ey_region` VALUES ('47711', '新园乡', '3', '47539', 'X');
INSERT INTO `ey_region` VALUES ('47712', '盐埔乡', '3', '47539', 'Y');
INSERT INTO `ey_region` VALUES ('47713', '竹田乡', '3', '47539', 'Z');
INSERT INTO `ey_region` VALUES ('47714', '北投区', '3', '47540', 'B');
INSERT INTO `ey_region` VALUES ('47715', '大安区', '3', '47540', 'D');
INSERT INTO `ey_region` VALUES ('47716', '大同区', '3', '47540', 'D');
INSERT INTO `ey_region` VALUES ('47717', '南港区', '3', '47540', 'N');
INSERT INTO `ey_region` VALUES ('47718', '内湖区', '3', '47540', 'N');
INSERT INTO `ey_region` VALUES ('47719', '士林区', '3', '47540', 'S');
INSERT INTO `ey_region` VALUES ('47720', '松山区', '3', '47540', 'S');
INSERT INTO `ey_region` VALUES ('47721', '万华区', '3', '47540', 'W');
INSERT INTO `ey_region` VALUES ('47722', '文山区', '3', '47540', 'W');
INSERT INTO `ey_region` VALUES ('47723', '信义区', '3', '47540', 'X');
INSERT INTO `ey_region` VALUES ('47724', '中山区', '3', '47540', 'Z');
INSERT INTO `ey_region` VALUES ('47725', '中正区', '3', '47540', 'Z');
INSERT INTO `ey_region` VALUES ('47726', '其它区', '3', '47540', 'Q');
INSERT INTO `ey_region` VALUES ('47727', '卑南乡', '3', '47541', 'B');
INSERT INTO `ey_region` VALUES ('47728', '长滨乡', '3', '47541', 'C');
INSERT INTO `ey_region` VALUES ('47729', '成功镇', '3', '47541', 'C');
INSERT INTO `ey_region` VALUES ('47730', '池上乡', '3', '47541', 'C');
INSERT INTO `ey_region` VALUES ('47731', '达仁乡', '3', '47541', 'D');
INSERT INTO `ey_region` VALUES ('47732', '大武乡', '3', '47541', 'D');
INSERT INTO `ey_region` VALUES ('47733', '东河乡', '3', '47541', 'D');
INSERT INTO `ey_region` VALUES ('47734', '关山镇', '3', '47541', 'G');
INSERT INTO `ey_region` VALUES ('47735', '海端乡', '3', '47541', 'H');
INSERT INTO `ey_region` VALUES ('47736', '金峰乡', '3', '47541', 'J');
INSERT INTO `ey_region` VALUES ('47737', '兰屿乡', '3', '47541', 'L');
INSERT INTO `ey_region` VALUES ('47738', '鹿野乡', '3', '47541', 'L');
INSERT INTO `ey_region` VALUES ('47739', '绿岛乡', '3', '47541', 'L');
INSERT INTO `ey_region` VALUES ('47740', '台东市', '3', '47541', 'T');
INSERT INTO `ey_region` VALUES ('47741', '太麻里乡', '3', '47541', 'T');
INSERT INTO `ey_region` VALUES ('47742', '延平乡', '3', '47541', 'Y');
INSERT INTO `ey_region` VALUES ('47743', '中西区', '3', '47542', 'Z');
INSERT INTO `ey_region` VALUES ('47744', '东区', '3', '47542', 'D');
INSERT INTO `ey_region` VALUES ('47745', '南区', '3', '47542', 'N');
INSERT INTO `ey_region` VALUES ('47746', '北区', '3', '47542', 'B');
INSERT INTO `ey_region` VALUES ('47747', '安平区', '3', '47542', 'A');
INSERT INTO `ey_region` VALUES ('47748', '安南区', '3', '47542', 'A');
INSERT INTO `ey_region` VALUES ('47749', '其它区', '3', '47542', 'Q');
INSERT INTO `ey_region` VALUES ('47750', '永康区', '3', '47542', 'Y');
INSERT INTO `ey_region` VALUES ('47751', '归仁区', '3', '47542', 'G');
INSERT INTO `ey_region` VALUES ('47752', '新化区', '3', '47542', 'X');
INSERT INTO `ey_region` VALUES ('47753', '左镇区', '3', '47542', 'Z');
INSERT INTO `ey_region` VALUES ('47754', '玉井区', '3', '47542', 'Y');
INSERT INTO `ey_region` VALUES ('47755', '楠西区', '3', '47542', 'N');
INSERT INTO `ey_region` VALUES ('47756', '南化区', '3', '47542', 'N');
INSERT INTO `ey_region` VALUES ('47757', '仁德区', '3', '47542', 'R');
INSERT INTO `ey_region` VALUES ('47758', '关庙区', '3', '47542', 'G');
INSERT INTO `ey_region` VALUES ('47759', '龙崎区', '3', '47542', 'L');
INSERT INTO `ey_region` VALUES ('47760', '官田区', '3', '47542', 'G');
INSERT INTO `ey_region` VALUES ('47761', '麻豆区', '3', '47542', 'M');
INSERT INTO `ey_region` VALUES ('47762', '佳里区', '3', '47542', 'J');
INSERT INTO `ey_region` VALUES ('47763', '西港区', '3', '47542', 'X');
INSERT INTO `ey_region` VALUES ('47764', '七股区', '3', '47542', 'Q');
INSERT INTO `ey_region` VALUES ('47765', '将军区', '3', '47542', 'J');
INSERT INTO `ey_region` VALUES ('47766', '学甲区', '3', '47542', 'X');
INSERT INTO `ey_region` VALUES ('47767', '北门区', '3', '47542', 'B');
INSERT INTO `ey_region` VALUES ('47768', '新营区', '3', '47542', 'X');
INSERT INTO `ey_region` VALUES ('47769', '后壁区', '3', '47542', 'H');
INSERT INTO `ey_region` VALUES ('47770', '白河区', '3', '47542', 'B');
INSERT INTO `ey_region` VALUES ('47771', '东山区', '3', '47542', 'D');
INSERT INTO `ey_region` VALUES ('47772', '六甲区', '3', '47542', 'L');
INSERT INTO `ey_region` VALUES ('47773', '下营区', '3', '47542', 'X');
INSERT INTO `ey_region` VALUES ('47774', '柳营区', '3', '47542', 'L');
INSERT INTO `ey_region` VALUES ('47775', '盐水区', '3', '47542', 'Y');
INSERT INTO `ey_region` VALUES ('47776', '善化区', '3', '47542', 'S');
INSERT INTO `ey_region` VALUES ('47777', '大内区', '3', '47542', 'D');
INSERT INTO `ey_region` VALUES ('47778', '山上区', '3', '47542', 'S');
INSERT INTO `ey_region` VALUES ('47779', '新市区', '3', '47542', 'X');
INSERT INTO `ey_region` VALUES ('47780', '安定区', '3', '47542', 'A');
INSERT INTO `ey_region` VALUES ('47781', '中区', '3', '47543', 'Z');
INSERT INTO `ey_region` VALUES ('47782', '东区', '3', '47543', 'D');
INSERT INTO `ey_region` VALUES ('47783', '南区', '3', '47543', 'N');
INSERT INTO `ey_region` VALUES ('47784', '西区', '3', '47543', 'X');
INSERT INTO `ey_region` VALUES ('47785', '北区', '3', '47543', 'B');
INSERT INTO `ey_region` VALUES ('47786', '北屯区', '3', '47543', 'B');
INSERT INTO `ey_region` VALUES ('47787', '西屯区', '3', '47543', 'X');
INSERT INTO `ey_region` VALUES ('47788', '南屯区', '3', '47543', 'N');
INSERT INTO `ey_region` VALUES ('47789', '其它区', '3', '47543', 'Q');
INSERT INTO `ey_region` VALUES ('47790', '太平区', '3', '47543', 'T');
INSERT INTO `ey_region` VALUES ('47791', '大里区', '3', '47543', 'D');
INSERT INTO `ey_region` VALUES ('47792', '雾峰区', '3', '47543', 'W');
INSERT INTO `ey_region` VALUES ('47793', '乌日区', '3', '47543', 'W');
INSERT INTO `ey_region` VALUES ('47794', '丰原区', '3', '47543', 'F');
INSERT INTO `ey_region` VALUES ('47795', '后里区', '3', '47543', 'H');
INSERT INTO `ey_region` VALUES ('47796', '石冈区', '3', '47543', 'S');
INSERT INTO `ey_region` VALUES ('47797', '东势区', '3', '47543', 'D');
INSERT INTO `ey_region` VALUES ('47798', '和平区', '3', '47543', 'H');
INSERT INTO `ey_region` VALUES ('47799', '新社区', '3', '47543', 'X');
INSERT INTO `ey_region` VALUES ('47800', '潭子区', '3', '47543', 'T');
INSERT INTO `ey_region` VALUES ('47801', '大雅区', '3', '47543', 'D');
INSERT INTO `ey_region` VALUES ('47802', '神冈区', '3', '47543', 'S');
INSERT INTO `ey_region` VALUES ('47803', '大肚区', '3', '47543', 'D');
INSERT INTO `ey_region` VALUES ('47804', '沙鹿区', '3', '47543', 'S');
INSERT INTO `ey_region` VALUES ('47805', '龙井区', '3', '47543', 'L');
INSERT INTO `ey_region` VALUES ('47806', '梧栖区', '3', '47543', 'W');
INSERT INTO `ey_region` VALUES ('47807', '清水区', '3', '47543', 'Q');
INSERT INTO `ey_region` VALUES ('47808', '大甲区', '3', '47543', 'D');
INSERT INTO `ey_region` VALUES ('47809', '外埔区', '3', '47543', 'W');
INSERT INTO `ey_region` VALUES ('47810', '大安区', '3', '47543', 'D');
INSERT INTO `ey_region` VALUES ('47811', '中坜区', '3', '47544', 'Z');
INSERT INTO `ey_region` VALUES ('47812', '平镇区', '3', '47544', 'P');
INSERT INTO `ey_region` VALUES ('47813', '龙潭区', '3', '47544', 'L');
INSERT INTO `ey_region` VALUES ('47814', '杨梅区', '3', '47544', 'Y');
INSERT INTO `ey_region` VALUES ('47815', '新屋区', '3', '47544', 'X');
INSERT INTO `ey_region` VALUES ('47816', '观音区', '3', '47544', 'G');
INSERT INTO `ey_region` VALUES ('47817', '桃园区', '3', '47544', 'T');
INSERT INTO `ey_region` VALUES ('47818', '龟山区', '3', '47544', 'G');
INSERT INTO `ey_region` VALUES ('47819', '八德区', '3', '47544', 'B');
INSERT INTO `ey_region` VALUES ('47820', '大溪区', '3', '47544', 'D');
INSERT INTO `ey_region` VALUES ('47821', '复兴区', '3', '47544', 'F');
INSERT INTO `ey_region` VALUES ('47822', '大园区', '3', '47544', 'D');
INSERT INTO `ey_region` VALUES ('47823', '芦竹区', '3', '47544', 'L');
INSERT INTO `ey_region` VALUES ('47824', '万里区', '3', '47545', 'W');
INSERT INTO `ey_region` VALUES ('47825', '金山区', '3', '47545', 'J');
INSERT INTO `ey_region` VALUES ('47826', '板桥区', '3', '47545', 'B');
INSERT INTO `ey_region` VALUES ('47827', '汐止区', '3', '47545', 'X');
INSERT INTO `ey_region` VALUES ('47828', '深坑区', '3', '47545', 'S');
INSERT INTO `ey_region` VALUES ('47829', '石碇区', '3', '47545', 'S');
INSERT INTO `ey_region` VALUES ('47830', '瑞芳区', '3', '47545', 'R');
INSERT INTO `ey_region` VALUES ('47831', '平溪区', '3', '47545', 'P');
INSERT INTO `ey_region` VALUES ('47832', '双溪区', '3', '47545', 'S');
INSERT INTO `ey_region` VALUES ('47833', '贡寮区', '3', '47545', 'G');
INSERT INTO `ey_region` VALUES ('47834', '新店区', '3', '47545', 'X');
INSERT INTO `ey_region` VALUES ('47835', '坪林区', '3', '47545', 'P');
INSERT INTO `ey_region` VALUES ('47836', '乌来区', '3', '47545', 'W');
INSERT INTO `ey_region` VALUES ('47837', '永和区', '3', '47545', 'Y');
INSERT INTO `ey_region` VALUES ('47838', '中和区', '3', '47545', 'Z');
INSERT INTO `ey_region` VALUES ('47839', '土城区', '3', '47545', 'T');
INSERT INTO `ey_region` VALUES ('47840', '三峡区', '3', '47545', 'S');
INSERT INTO `ey_region` VALUES ('47841', '树林区', '3', '47545', 'S');
INSERT INTO `ey_region` VALUES ('47842', '莺歌区', '3', '47545', 'Y');
INSERT INTO `ey_region` VALUES ('47843', '三重区', '3', '47545', 'S');
INSERT INTO `ey_region` VALUES ('47844', '新庄区', '3', '47545', 'X');
INSERT INTO `ey_region` VALUES ('47845', '泰山区', '3', '47545', 'T');
INSERT INTO `ey_region` VALUES ('47846', '林口区', '3', '47545', 'L');
INSERT INTO `ey_region` VALUES ('47847', '芦洲区', '3', '47545', 'L');
INSERT INTO `ey_region` VALUES ('47848', '五股区', '3', '47545', 'W');
INSERT INTO `ey_region` VALUES ('47849', '八里区', '3', '47545', 'B');
INSERT INTO `ey_region` VALUES ('47850', '淡水区', '3', '47545', 'D');
INSERT INTO `ey_region` VALUES ('47851', '三芝区', '3', '47545', 'S');
INSERT INTO `ey_region` VALUES ('47852', '石门区', '3', '47545', 'S');
INSERT INTO `ey_region` VALUES ('47853', '东区', '3', '47546', 'D');
INSERT INTO `ey_region` VALUES ('47854', '北区', '3', '47546', 'B');
INSERT INTO `ey_region` VALUES ('47855', '香山区', '3', '47546', 'X');
INSERT INTO `ey_region` VALUES ('47856', '其它区', '3', '47546', 'Q');
INSERT INTO `ey_region` VALUES ('47857', '竹北市', '3', '47547', 'Z');
INSERT INTO `ey_region` VALUES ('47858', '湖口乡', '3', '47547', 'H');
INSERT INTO `ey_region` VALUES ('47859', '新丰乡', '3', '47547', 'X');
INSERT INTO `ey_region` VALUES ('47860', '新埔镇', '3', '47547', 'X');
INSERT INTO `ey_region` VALUES ('47861', '关西镇', '3', '47547', 'G');
INSERT INTO `ey_region` VALUES ('47862', '芎林乡', '3', '47547', 'X');
INSERT INTO `ey_region` VALUES ('47863', '宝山乡', '3', '47547', 'B');
INSERT INTO `ey_region` VALUES ('47864', '竹东镇', '3', '47547', 'Z');
INSERT INTO `ey_region` VALUES ('47865', '五峰乡', '3', '47547', 'W');
INSERT INTO `ey_region` VALUES ('47866', '横山乡', '3', '47547', 'H');
INSERT INTO `ey_region` VALUES ('47867', '尖石乡', '3', '47547', 'J');
INSERT INTO `ey_region` VALUES ('47868', '北埔乡', '3', '47547', 'B');
INSERT INTO `ey_region` VALUES ('47869', '峨眉乡', '3', '47547', 'E');
INSERT INTO `ey_region` VALUES ('47870', '宜兰市', '3', '47548', 'Y');
INSERT INTO `ey_region` VALUES ('47871', '头城镇', '3', '47548', 'T');
INSERT INTO `ey_region` VALUES ('47872', '礁溪乡', '3', '47548', 'J');
INSERT INTO `ey_region` VALUES ('47873', '壮围乡', '3', '47548', 'Z');
INSERT INTO `ey_region` VALUES ('47874', '员山乡', '3', '47548', 'Y');
INSERT INTO `ey_region` VALUES ('47875', '罗东镇', '3', '47548', 'L');
INSERT INTO `ey_region` VALUES ('47876', '三星乡', '3', '47548', 'S');
INSERT INTO `ey_region` VALUES ('47877', '大同乡', '3', '47548', 'D');
INSERT INTO `ey_region` VALUES ('47878', '五结乡', '3', '47548', 'W');
INSERT INTO `ey_region` VALUES ('47879', '冬山乡', '3', '47548', 'D');
INSERT INTO `ey_region` VALUES ('47880', '苏澳镇', '3', '47548', 'S');
INSERT INTO `ey_region` VALUES ('47881', '南澳乡', '3', '47548', 'N');
INSERT INTO `ey_region` VALUES ('47882', '钓鱼台', '3', '47548', 'D');
INSERT INTO `ey_region` VALUES ('47883', '斗南镇', '3', '47549', 'D');
INSERT INTO `ey_region` VALUES ('47884', '大埤乡', '3', '47549', 'D');
INSERT INTO `ey_region` VALUES ('47885', '虎尾镇', '3', '47549', 'H');
INSERT INTO `ey_region` VALUES ('47886', '土库镇', '3', '47549', 'T');
INSERT INTO `ey_region` VALUES ('47887', '褒忠乡', '3', '47549', 'B');
INSERT INTO `ey_region` VALUES ('47888', '东势乡', '3', '47549', 'D');
INSERT INTO `ey_region` VALUES ('47889', '台西乡', '3', '47549', 'T');
INSERT INTO `ey_region` VALUES ('47890', '仑背乡', '3', '47549', 'L');
INSERT INTO `ey_region` VALUES ('47891', '麦寮乡', '3', '47549', 'M');
INSERT INTO `ey_region` VALUES ('47892', '斗六市', '3', '47549', 'D');
INSERT INTO `ey_region` VALUES ('47893', '林内乡', '3', '47549', 'L');
INSERT INTO `ey_region` VALUES ('47894', '古坑乡', '3', '47549', 'G');
INSERT INTO `ey_region` VALUES ('47895', '莿桐乡', '3', '47549', 'C');
INSERT INTO `ey_region` VALUES ('47896', '西螺镇', '3', '47549', 'X');
INSERT INTO `ey_region` VALUES ('47897', '二仑乡', '3', '47549', 'E');
INSERT INTO `ey_region` VALUES ('47898', '北港镇', '3', '47549', 'B');
INSERT INTO `ey_region` VALUES ('47899', '水林乡', '3', '47549', 'S');
INSERT INTO `ey_region` VALUES ('47900', '口湖乡', '3', '47549', 'K');
INSERT INTO `ey_region` VALUES ('47901', '四湖乡', '3', '47549', 'S');
INSERT INTO `ey_region` VALUES ('47902', '元长乡', '3', '47549', 'Y');
INSERT INTO `ey_region` VALUES ('47903', '彰化市', '3', '47550', 'Z');
INSERT INTO `ey_region` VALUES ('47904', '芬园乡', '3', '47550', 'F');
INSERT INTO `ey_region` VALUES ('47905', '花坛乡', '3', '47550', 'H');
INSERT INTO `ey_region` VALUES ('47906', '秀水乡', '3', '47550', 'X');
INSERT INTO `ey_region` VALUES ('47907', '鹿港镇', '3', '47550', 'L');
INSERT INTO `ey_region` VALUES ('47908', '福兴乡', '3', '47550', 'F');
INSERT INTO `ey_region` VALUES ('47909', '线西乡', '3', '47550', 'X');
INSERT INTO `ey_region` VALUES ('47910', '和美镇', '3', '47550', 'H');
INSERT INTO `ey_region` VALUES ('47911', '伸港乡', '3', '47550', 'S');
INSERT INTO `ey_region` VALUES ('47912', '员林镇', '3', '47550', 'Y');
INSERT INTO `ey_region` VALUES ('47913', '社头乡', '3', '47550', 'S');
INSERT INTO `ey_region` VALUES ('47914', '永靖乡', '3', '47550', 'Y');
INSERT INTO `ey_region` VALUES ('47915', '埔心乡', '3', '47550', 'P');
INSERT INTO `ey_region` VALUES ('47916', '溪湖镇', '3', '47550', 'X');
INSERT INTO `ey_region` VALUES ('47917', '大村乡', '3', '47550', 'D');
INSERT INTO `ey_region` VALUES ('47918', '埔盐乡', '3', '47550', 'P');
INSERT INTO `ey_region` VALUES ('47919', '田中镇', '3', '47550', 'T');
INSERT INTO `ey_region` VALUES ('47920', '北斗镇', '3', '47550', 'B');
INSERT INTO `ey_region` VALUES ('47921', '田尾乡', '3', '47550', 'T');
INSERT INTO `ey_region` VALUES ('47922', '埤头乡', '3', '47550', 'P');
INSERT INTO `ey_region` VALUES ('47923', '溪州乡', '3', '47550', 'X');
INSERT INTO `ey_region` VALUES ('47924', '竹塘乡', '3', '47550', 'Z');
INSERT INTO `ey_region` VALUES ('47925', '二林镇', '3', '47550', 'E');
INSERT INTO `ey_region` VALUES ('47926', '大城乡', '3', '47550', 'D');
INSERT INTO `ey_region` VALUES ('47927', '芳苑乡', '3', '47550', 'F');
INSERT INTO `ey_region` VALUES ('47928', '二水乡', '3', '47550', 'E');
INSERT INTO `ey_region` VALUES ('47929', '莲池区', '3', '1772', 'L');
INSERT INTO `ey_region` VALUES ('47930', '竞秀区', '3', '1772', 'J');
INSERT INTO `ey_region` VALUES ('47931', '常平镇', '3', '29855', 'C');
INSERT INTO `ey_region` VALUES ('47932', '茶山镇', '3', '29855', 'C');
INSERT INTO `ey_region` VALUES ('47933', '大朗镇', '3', '29855', 'D');
INSERT INTO `ey_region` VALUES ('47934', '大岭山镇', '3', '29855', 'D');
INSERT INTO `ey_region` VALUES ('47935', '道滘镇', '3', '29855', 'D');
INSERT INTO `ey_region` VALUES ('47936', '东城街道', '3', '29855', 'D');
INSERT INTO `ey_region` VALUES ('47937', '东坑镇', '3', '29855', 'D');
INSERT INTO `ey_region` VALUES ('47938', '凤岗镇', '3', '29855', 'F');
INSERT INTO `ey_region` VALUES ('47939', '高埗镇', '3', '29855', 'G');
INSERT INTO `ey_region` VALUES ('47940', '莞城街道', '3', '29855', 'G');
INSERT INTO `ey_region` VALUES ('47941', '横沥镇', '3', '29855', 'H');
INSERT INTO `ey_region` VALUES ('47942', '洪梅镇', '3', '29855', 'H');
INSERT INTO `ey_region` VALUES ('47943', '厚街镇', '3', '29855', 'H');
INSERT INTO `ey_region` VALUES ('47944', '黄江镇', '3', '29855', 'H');
INSERT INTO `ey_region` VALUES ('47945', '虎门镇', '3', '29855', 'H');
INSERT INTO `ey_region` VALUES ('47946', '寮步镇', '3', '29855', 'L');
INSERT INTO `ey_region` VALUES ('47947', '麻涌镇', '3', '29855', 'M');
INSERT INTO `ey_region` VALUES ('47948', '南城街道', '3', '29855', 'N');
INSERT INTO `ey_region` VALUES ('47949', '桥头镇', '3', '29855', 'Q');
INSERT INTO `ey_region` VALUES ('47950', '清溪镇', '3', '29855', 'Q');
INSERT INTO `ey_region` VALUES ('47951', '企石镇', '3', '29855', 'Q');
INSERT INTO `ey_region` VALUES ('47952', '沙田镇', '3', '29855', 'S');
INSERT INTO `ey_region` VALUES ('47953', '石碣镇', '3', '29855', 'S');
INSERT INTO `ey_region` VALUES ('47954', '石龙镇', '3', '29855', 'S');
INSERT INTO `ey_region` VALUES ('47955', '石排镇', '3', '29855', 'S');
INSERT INTO `ey_region` VALUES ('47956', '松山湖管委会', '3', '29855', 'S');
INSERT INTO `ey_region` VALUES ('47957', '塘厦镇', '3', '29855', 'T');
INSERT INTO `ey_region` VALUES ('47958', '望牛墩镇', '3', '29855', 'W');
INSERT INTO `ey_region` VALUES ('47959', '万江街道', '3', '29855', 'W');
INSERT INTO `ey_region` VALUES ('47960', '谢岗镇', '3', '29855', 'X');
INSERT INTO `ey_region` VALUES ('47961', '长安镇', '3', '29855', 'Z');
INSERT INTO `ey_region` VALUES ('47962', '樟木头镇', '3', '29855', 'Z');
INSERT INTO `ey_region` VALUES ('47963', '中堂镇', '3', '29855', 'Z');
INSERT INTO `ey_region` VALUES ('47965', '吉阳区', '3', '31618', 'J');
INSERT INTO `ey_region` VALUES ('47966', '天涯区', '3', '31618', 'T');
INSERT INTO `ey_region` VALUES ('47967', '崖州区', '3', '31618', 'Y');
INSERT INTO `ey_region` VALUES ('47968', '海外', '1', '0', 'H');
INSERT INTO `ey_region` VALUES ('47969', '海外', '2', '47968', 'H');
INSERT INTO `ey_region` VALUES ('47970', '海外', '3', '47969', 'H');
INSERT INTO `ey_region` VALUES ('47974', '沁园街道', '3', '47973', 'Q');
INSERT INTO `ey_region` VALUES ('47975', '济水街道', '3', '47973', 'J');
INSERT INTO `ey_region` VALUES ('47976', '北海街道', '3', '47973', 'B');
INSERT INTO `ey_region` VALUES ('47977', '天坛街道', '3', '47973', 'T');
INSERT INTO `ey_region` VALUES ('47978', '玉泉街道', '3', '47973', 'Y');
INSERT INTO `ey_region` VALUES ('47979', '克井镇', '3', '47973', 'K');
INSERT INTO `ey_region` VALUES ('47980', '五龙口镇', '3', '47973', 'W');
INSERT INTO `ey_region` VALUES ('47981', '轵城镇', '3', '47973', 'Z');
INSERT INTO `ey_region` VALUES ('47982', '承留镇', '3', '47973', 'C');
INSERT INTO `ey_region` VALUES ('47983', '邵原镇', '3', '47973', 'S');
INSERT INTO `ey_region` VALUES ('47984', '坡头镇', '3', '47973', 'P');
INSERT INTO `ey_region` VALUES ('47985', '梨林镇', '3', '47973', 'L');
INSERT INTO `ey_region` VALUES ('47986', '大峪镇', '3', '47973', 'D');
INSERT INTO `ey_region` VALUES ('47987', '思礼镇', '3', '47973', 'S');
INSERT INTO `ey_region` VALUES ('47988', '王屋镇', '3', '47973', 'W');
INSERT INTO `ey_region` VALUES ('47989', '下冶镇', '3', '47973', 'X');

-- -----------------------------
-- Table structure for `ey_search_locking`
-- -----------------------------
DROP TABLE IF EXISTS `ey_search_locking`;
CREATE TABLE `ey_search_locking` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `users_id` int(10) DEFAULT '0' COMMENT '用户ID',
  `ip` varchar(20) DEFAULT '' COMMENT 'ip',
  `locking_time` int(11) DEFAULT '0' COMMENT '锁定时间',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='搜索记录锁定表';


-- -----------------------------
-- Table structure for `ey_search_word`
-- -----------------------------
DROP TABLE IF EXISTS `ey_search_word`;
CREATE TABLE `ey_search_word` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `word` varchar(255) DEFAULT '' COMMENT '关键词',
  `searchNum` int(10) DEFAULT '1' COMMENT '搜索次数',
  `resultNum` int(10) DEFAULT '0' COMMENT '搜索结果数量',
  `sort_order` int(10) DEFAULT '0' COMMENT '排序号',
  `users_id` int(11) DEFAULT '0' COMMENT '用户id',
  `ip` varchar(20) DEFAULT '' COMMENT 'ip',
  `is_hot` tinyint(1) DEFAULT '0' COMMENT '是否热搜',
  `lang` varchar(30) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`),
  KEY `word` (`word`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='搜索词统计表';


-- -----------------------------
-- Table structure for `ey_setting`
-- -----------------------------
DROP TABLE IF EXISTS `ey_setting`;
CREATE TABLE `ey_setting` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) DEFAULT '' COMMENT '配置的key键名',
  `value` text,
  `inc_type` varchar(64) DEFAULT '' COMMENT '配置分组',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`),
  KEY `inc_type` (`inc_type`,`lang`)
) ENGINE=MyISAM AUTO_INCREMENT=94 DEFAULT CHARSET=utf8 COMMENT='系统非全局配置表';

-- -----------------------------
-- Records of `ey_setting`
-- -----------------------------
INSERT INTO `ey_setting` VALUES ('1', 'ask_ques_steps', '1、写问题标题，描述具体现象。杜绝 “求救，大佬，小白…” 等和问题无关的词汇。\r\n2、选择问题的分类，选择正确的内容分类，能更快的得到其他人的回复。\r\n3、遇到的问题比较急需解决，可以给问题悬赏一定的金额报酬，能让更多同行参与进来出谋策划，从中选择自己心仪的答案。\r\n4、写问题内容详细描述你碰到的困难，写清楚你尝试了什么方法，错误代码，软件的版本等，更容易得到答案。\r\n5、点击发布。', 'ask', 'cn', '1623814141');
INSERT INTO `ey_setting` VALUES ('2', 'system_old_product_attr', '0', 'system', 'cn', '1634095663');
INSERT INTO `ey_setting` VALUES ('3', 'syn_admin_logic_1623377269', '1', 'syn', 'cn', '1634095663');
INSERT INTO `ey_setting` VALUES ('4', 'syn_admin_logic_1625725290', '1', 'syn', 'cn', '1634095663');
INSERT INTO `ey_setting` VALUES ('5', 'syn_admin_logic_1629252424', '1', 'syn', 'cn', '1634095663');
INSERT INTO `ey_setting` VALUES ('6', 'admin_logic_1634204189', '1', 'syn', 'cn', '1641861890');
INSERT INTO `ey_setting` VALUES ('7', 'admin_logic_1634280892', '1', 'syn', 'cn', '1641861890');
INSERT INTO `ey_setting` VALUES ('8', 'admin_logic_1635326854', '1', 'syn', 'cn', '1641861890');
INSERT INTO `ey_setting` VALUES ('9', 'admin_logic_1635389623', '1', 'syn', 'cn', '1641861890');
INSERT INTO `ey_setting` VALUES ('10', 'admin_logic_1636875693', '1', 'syn', 'cn', '1641862059');
INSERT INTO `ey_setting` VALUES ('11', 'admin_logic_1637033990', '1', 'syn', 'cn', '1641862059');
INSERT INTO `ey_setting` VALUES ('12', 'admin_logic_1640918327', '1', 'syn', 'cn', '1641862059');
INSERT INTO `ey_setting` VALUES ('13', 'admin_logic_1638857408', '1', 'syn', 'cn', '1641862059');
INSERT INTO `ey_setting` VALUES ('14', 'admin_logic_1643352860', '2', 'syn', 'cn', '1648864505');
INSERT INTO `ey_setting` VALUES ('15', 'admin_logic_1643352862', '1', 'syn', 'cn', '1648864505');
INSERT INTO `ey_setting` VALUES ('16', 'system_initialize_admin_menu', '1', 'system', 'cn', '1648864596');
INSERT INTO `ey_setting` VALUES ('17', 'admin_logic_1643352863', '1', 'syn', 'cn', '1648864596');
INSERT INTO `ey_setting` VALUES ('18', 'security_askanswer_list', '[\"\\u60a8\\u5e38\\u7528\\u7684\\u624b\\u673a\\u53f7\\u7801\\u662f\\uff1f\",\"\\u60a8\\u5e38\\u7528\\u7684\\u7535\\u5b50\\u90ae\\u7bb1\\u662f\\uff1f\",\"\\u60a8\\u771f\\u5b9e\\u7684\\u59d3\\u540d\\u662f\\uff1f\",\"\\u60a8\\u521d\\u4e2d\\u5b66\\u6821\\u540d\\u662f\\uff1f\",\"\\u60a8\\u7684\\u51fa\\u751f\\u5730\\u540d\\u662f\\uff1f\",\"\\u60a8\\u914d\\u5076\\u7684\\u59d3\\u540d\\u662f\\uff1f\",\"\\u60a8\\u7684\\u8eab\\u4efd\\u8bc1\\u53f7\\u540e\\u516b\\u4f4d\\u662f\\uff1f\",\"\\u60a8\\u9ad8\\u4e2d\\u73ed\\u4e3b\\u4efb\\u7684\\u540d\\u5b57\\u662f\\uff1f\",\"\\u60a8\\u521d\\u4e2d\\u73ed\\u4e3b\\u4efb\\u7684\\u540d\\u5b57\\u662f\\uff1f\",\"\\u60a8\\u6700\\u559c\\u6b22\\u7684\\u660e\\u661f\\u540d\\u5b57\\u662f\\uff1f\",\"\\u5bf9\\u60a8\\u5f71\\u54cd\\u6700\\u5927\\u7684\\u4eba\\u540d\\u5b57\\u662f\\uff1f\"]', 'security', 'cn', '1648864596');
INSERT INTO `ey_setting` VALUES ('19', 'admin_logic_1643352864', '1', 'syn', 'cn', '1648864596');
INSERT INTO `ey_setting` VALUES ('20', 'admin_logic_1647918733', '1', 'syn', 'cn', '1648864596');
INSERT INTO `ey_setting` VALUES ('21', 'system_originlist', '[\"\\u7f51\\u7edc\"]', 'system', 'cn', '1648864596');
INSERT INTO `ey_setting` VALUES ('22', 'admin_logic_1648435161', '1', 'syn', 'cn', '1648864596');
INSERT INTO `ey_setting` VALUES ('23', 'admin_logic_1649299958', '1', 'syn', 'cn', '1649638227');
INSERT INTO `ey_setting` VALUES ('24', 'admin_logic_1648882158', '1', 'syn', 'cn', '1649638228');
INSERT INTO `ey_setting` VALUES ('25', 'admin_logic_1649399344', '1', 'syn', 'cn', '1649638228');
INSERT INTO `ey_setting` VALUES ('26', 'dedetoeyou_del_all', '1', 'dedetoeyou', 'cn', '1649638270');
INSERT INTO `ey_setting` VALUES ('27', 'system_codelogic_1638857408', '7fcdU1IJCVIAAwICBQZXAgAMVQdeBlFWVQZaBl04ElJVVVc2U2NqI0dyenBkaHNlBW12cl9mJScEdiQmIy58M3VwYSIze180V0NidAVobnhDDWN1anEgM1NEOjEJC1UyAnt6IFNjbCZlRHB0c1ZkZkNAV3dAYSc+IVgmMiQmcTcDBn0lI2x0NABqVGNCf29lWFNscF9qKCJSZik0VFtzNgJ0UCc0QW0gV3F6Zmdoc3VMS3d3aUkxTRMAMxcTGVRcfEN0BANMfxBDXWBVAFh+Aw10Vl8NfzYTAlIqVyw/HwFZRFosDFZ1NwYHW3BMYUBoRAFGZEJDEAAIRgckVxNgP0dHUQYFdA8qV3p+VlxhQWJ3bnZ1bXE7IiFiFTImU2k9YGNiMzZ8UjRidlFoYHQPUnJfdmRpYRo+IGUVBDQyCSt1Blg1NX9oN3hxfGBnRllxd2luZnxkCjE0ZSMiNSEENmFaZjY0VXskaFsKBXdwD2FsT1NnYFdUVwl6AA1XB0U1QUJKGxd/AC9nckV9ckZ8aWVPDBNl', 'system', 'cn', '1649638257');
INSERT INTO `ey_setting` VALUES ('28', 'recycle_switch', '1', 'recycle', 'cn', '1649638567');
INSERT INTO `ey_setting` VALUES ('29', 'adminlogin_427d1aac31a93d744edd637f1fbbf00c', '0', 'adminlogin', 'cn', '1649657233');
INSERT INTO `ey_setting` VALUES ('30', 'adminlogin_a62896d354440964bb1db242596917b1', '0', 'adminlogin', 'cn', '1649657233');
INSERT INTO `ey_setting` VALUES ('31', 'adminlogin_99ae1cc546e0ed202a83693c75f1afe0', '0', 'adminlogin', 'cn', '1649657233');
INSERT INTO `ey_setting` VALUES ('32', 'adminlogin_427d1aac31a93d744edd637f1fbbf00c', '0', 'adminlogin', 'en', '1649657233');
INSERT INTO `ey_setting` VALUES ('33', 'adminlogin_a62896d354440964bb1db242596917b1', '0', 'adminlogin', 'en', '1649657233');
INSERT INTO `ey_setting` VALUES ('34', 'adminlogin_99ae1cc546e0ed202a83693c75f1afe0', '0', 'adminlogin', 'en', '1649657233');
INSERT INTO `ey_setting` VALUES ('35', 'admin_logic_1655453263', '1', 'syn', 'cn', '1713172505');
INSERT INTO `ey_setting` VALUES ('36', 'admin_logic_1652254594', '1', 'syn', 'cn', '1713172505');
INSERT INTO `ey_setting` VALUES ('37', 'designated_column_1657069673', '1', 'syn', 'cn', '1713172505');
INSERT INTO `ey_setting` VALUES ('38', 'admin_logic_1652771782', '1', 'syn', 'cn', '1713172505');
INSERT INTO `ey_setting` VALUES ('39', 'admin_logic_1667210674', '1', 'syn', 'cn', '1713172505');
INSERT INTO `ey_setting` VALUES ('40', 'syn_admin_logic_1616123195', '1', 'syn', 'cn', '1713172505');
INSERT INTO `ey_setting` VALUES ('41', 'admin_logic_1651114275', '1', 'syn', 'cn', '1713172505');
INSERT INTO `ey_setting` VALUES ('42', 'admin_logic_1662518904', '1', 'syn', 'cn', '1713172505');
INSERT INTO `ey_setting` VALUES ('43', 'admin_logic_1667357946', '1', 'syn', 'cn', '1713172505');
INSERT INTO `ey_setting` VALUES ('44', 'admin_logic_1663290997', '1', 'syn', 'cn', '1713172505');
INSERT INTO `ey_setting` VALUES ('45', 'syn_admin_logic_1660557712', '1', 'syn', 'cn', '1713172505');
INSERT INTO `ey_setting` VALUES ('46', 'admin_logic_1673941712', '1', 'syn', 'cn', '1713172632');
INSERT INTO `ey_setting` VALUES ('47', 'admin_logic_1676854942', '1', 'syn', 'cn', '1713172632');
INSERT INTO `ey_setting` VALUES ('48', 'admin_logic_1675243579', '1', 'syn', 'cn', '1713172632');
INSERT INTO `ey_setting` VALUES ('49', 'admin_logic_1677555001', '1', 'syn', 'cn', '1713172632');
INSERT INTO `ey_setting` VALUES ('50', 'admin_logic_1678762367', '1', 'syn', 'cn', '1713172632');
INSERT INTO `ey_setting` VALUES ('51', 'admin_logic_1687767523', '1', 'syn', 'cn', '1713172632');
INSERT INTO `ey_setting` VALUES ('52', 'admin_logic_1685584104', '1', 'syn', 'cn', '1713172632');
INSERT INTO `ey_setting` VALUES ('53', 'admin_logic_1682580429', '1', 'syn', 'cn', '1713172632');
INSERT INTO `ey_setting` VALUES ('54', 'admin_logic_1680749290', '1', 'syn', 'cn', '1713172633');
INSERT INTO `ey_setting` VALUES ('55', 'admin_logic_1681199467', '1', 'syn', 'cn', '1713172677');
INSERT INTO `ey_setting` VALUES ('56', 'admin_logic_1687676445', '1', 'syn', 'cn', '1713172677');
INSERT INTO `ey_setting` VALUES ('57', 'admin_logic_1689071584', '1', 'syn', 'cn', '1713172677');
INSERT INTO `ey_setting` VALUES ('58', 'admin_logic_1685094852', '1', 'syn', 'cn', '1713172677');
INSERT INTO `ey_setting` VALUES ('59', 'admin_logic_1687687709', '1', 'syn', 'cn', '1713172677');
INSERT INTO `ey_setting` VALUES ('60', 'admin_logic_1692067658', '1', 'syn', 'cn', '1713172678');
INSERT INTO `ey_setting` VALUES ('61', 'admin_logic_1697156935', 'v1.6.7', 'syn', 'cn', '1721264854');
INSERT INTO `ey_setting` VALUES ('62', 'admin_logic_1698388181', '1', 'syn', 'cn', '1713172699');
INSERT INTO `ey_setting` VALUES ('63', 'admin_logic_1701050542', '1', 'syn', 'cn', '1713172699');
INSERT INTO `ey_setting` VALUES ('64', 'admin_logic_1700638990', '1', 'syn', 'cn', '1713172699');
INSERT INTO `ey_setting` VALUES ('65', 'admin_logic_1700789211', '1', 'syn', 'cn', '1713172699');
INSERT INTO `ey_setting` VALUES ('66', 'admin_logic_1698716726', '1', 'syn', 'cn', '1713172699');
INSERT INTO `ey_setting` VALUES ('67', 'admin_logic_1698733259', '1', 'syn', 'cn', '1713172699');
INSERT INTO `ey_setting` VALUES ('68', 'admin_logic_1698799687', '1', 'syn', 'cn', '1713172699');
INSERT INTO `ey_setting` VALUES ('69', 'syn_admin_logic_1700016487', '1', 'syn', 'cn', '1713172699');
INSERT INTO `ey_setting` VALUES ('70', 'syn_admin_logic_1700016488', '1', 'syn', 'cn', '1713172699');
INSERT INTO `ey_setting` VALUES ('71', 'syn_admin_logic_1700016489', '1', 'syn', 'cn', '1713172699');
INSERT INTO `ey_setting` VALUES ('72', 'syn_admin_logic_1700106425', '1', 'syn', 'cn', '1713172699');
INSERT INTO `ey_setting` VALUES ('73', 'admin_logic_1700621159', '1', 'syn', 'cn', '1713172701');
INSERT INTO `ey_setting` VALUES ('74', 'admin_logic_1682579646', '1', 'syn', 'cn', '1713172723');
INSERT INTO `ey_setting` VALUES ('75', 'admin_logic_1701855768', '1', 'syn', 'cn', '1713172723');
INSERT INTO `ey_setting` VALUES ('76', 'admin_logic_1707029785', '1', 'syn', 'cn', '1713172723');
INSERT INTO `ey_setting` VALUES ('77', 'syn_admin_logic_1706842286', '1', 'syn', 'cn', '1713172723');
INSERT INTO `ey_setting` VALUES ('78', 'syn_admin_logic_1703647730', '1', 'syn', 'cn', '1713172724');
INSERT INTO `ey_setting` VALUES ('79', 'syn_admin_logic_1707201289', '1', 'syn', 'cn', '1713172724');
INSERT INTO `ey_setting` VALUES ('80', 'admin_logic_1712548559', '1', 'syn', 'cn', '1713172724');
INSERT INTO `ey_setting` VALUES ('81', 'admin_logic_1712548812', '1', 'syn', 'cn', '1713172724');
INSERT INTO `ey_setting` VALUES ('82', 'admin_logic_1693909371', '1', 'syn', 'cn', '1713172733');
INSERT INTO `ey_setting` VALUES ('83', 'adminlogin_3a169e70d45ac7410c2856acfb38d69e', '0', 'adminlogin', 'cn', '1721264809');
INSERT INTO `ey_setting` VALUES ('84', 'adminlogin_2fa97c794f3502ec8e36e8fe319968d8', '0', 'adminlogin', 'cn', '1721264809');
INSERT INTO `ey_setting` VALUES ('85', 'adminlogin_bb7e531fe20f8dcc4485ceada88140d5', '0', 'adminlogin', 'cn', '1721264809');
INSERT INTO `ey_setting` VALUES ('86', 'adminlogin_3a169e70d45ac7410c2856acfb38d69e', '0', 'adminlogin', 'en', '1721264809');
INSERT INTO `ey_setting` VALUES ('87', 'adminlogin_2fa97c794f3502ec8e36e8fe319968d8', '0', 'adminlogin', 'en', '1721264809');
INSERT INTO `ey_setting` VALUES ('88', 'adminlogin_bb7e531fe20f8dcc4485ceada88140d5', '0', 'adminlogin', 'en', '1721264809');
INSERT INTO `ey_setting` VALUES ('89', 'syn_admin_logic_1716431013', '1', 'syn', 'cn', '1721264854');
INSERT INTO `ey_setting` VALUES ('90', 'syn_admin_logic_1714458348', '1', 'syn', 'cn', '1721264855');
INSERT INTO `ey_setting` VALUES ('91', 'syn_admin_logic_1716446109', '1', 'syn', 'cn', '1721264855');
INSERT INTO `ey_setting` VALUES ('92', 'syn_admin_logic_1714458360', '1', 'syn', 'cn', '1721264855');
INSERT INTO `ey_setting` VALUES ('93', 'syn_admin_logic_1719815413', '1', 'syn', 'cn', '1721264855');

-- -----------------------------
-- Table structure for `ey_sharp_active`
-- -----------------------------
DROP TABLE IF EXISTS `ey_sharp_active`;
CREATE TABLE `ey_sharp_active` (
  `active_id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '活动会场ID',
  `active_date` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '活动日期',
  `status` tinyint(3) unsigned NOT NULL DEFAULT '1' COMMENT '活动状态(0禁用 1启用)',
  `is_del` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '是否删除',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '创建时间',
  `update_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`active_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='整点秒杀-活动会场表';


-- -----------------------------
-- Table structure for `ey_sharp_active_goods`
-- -----------------------------
DROP TABLE IF EXISTS `ey_sharp_active_goods`;
CREATE TABLE `ey_sharp_active_goods` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键ID',
  `active_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '活动会场ID',
  `active_time_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '活动场次ID',
  `aid` int(11) NOT NULL DEFAULT '0' COMMENT '文档id',
  `sharp_goods_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '秒杀商品ID',
  `sales_actual` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '实际销量',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '创建时间',
  `update_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='整点秒杀-活动会场与商品关联表';


-- -----------------------------
-- Table structure for `ey_sharp_active_time`
-- -----------------------------
DROP TABLE IF EXISTS `ey_sharp_active_time`;
CREATE TABLE `ey_sharp_active_time` (
  `active_time_id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '场次ID',
  `active_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '活动会场ID',
  `active_time` tinyint(3) unsigned NOT NULL DEFAULT '1' COMMENT '场次时间(0点-23点)',
  `status` tinyint(3) unsigned NOT NULL DEFAULT '1' COMMENT '活动状态(0禁用 1启用)',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '创建时间',
  `update_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`active_time_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='整点秒杀-活动会场场次表';


-- -----------------------------
-- Table structure for `ey_sharp_goods`
-- -----------------------------
DROP TABLE IF EXISTS `ey_sharp_goods`;
CREATE TABLE `ey_sharp_goods` (
  `sharp_goods_id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '秒杀商品ID',
  `aid` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '商品ID->aid',
  `limit` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '限购数量',
  `seckill_stock` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '秒杀商品库存总量',
  `seckill_price` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '秒杀价格',
  `sales` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '累积销量',
  `virtual_sales` int(11) NOT NULL DEFAULT '0' COMMENT '虚拟销量',
  `sort_order` int(11) unsigned NOT NULL DEFAULT '100' COMMENT '商品排序(数字越小越靠前)',
  `status` tinyint(3) unsigned NOT NULL DEFAULT '1' COMMENT '商品状态(0下架 1上架)',
  `is_del` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '是否删除',
  `is_sku` tinyint(1) NOT NULL DEFAULT '0' COMMENT '1-多规格商品',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '创建时间',
  `update_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`sharp_goods_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='整点秒杀-商品表';


-- -----------------------------
-- Table structure for `ey_sharp_setting`
-- -----------------------------
DROP TABLE IF EXISTS `ey_sharp_setting`;
CREATE TABLE `ey_sharp_setting` (
  `key` varchar(30) NOT NULL DEFAULT '' COMMENT '设置项标示',
  `describe` varchar(255) NOT NULL DEFAULT '' COMMENT '设置项描述',
  `values` mediumtext NOT NULL COMMENT '设置内容(json格式)',
  `update_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  UNIQUE KEY `unique_key` (`key`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='整点秒杀设置表';


-- -----------------------------
-- Table structure for `ey_shop_address`
-- -----------------------------
DROP TABLE IF EXISTS `ey_shop_address`;
CREATE TABLE `ey_shop_address` (
  `addr_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '地址id',
  `users_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '会员id',
  `consignee` varchar(60) NOT NULL DEFAULT '' COMMENT '收货人',
  `country` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '国家',
  `province` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '省份',
  `city` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '城市',
  `district` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '县区',
  `address` varchar(500) NOT NULL DEFAULT '' COMMENT '详细地址',
  `zipcode` varchar(10) NOT NULL DEFAULT '' COMMENT '邮政编码',
  `mobile` varchar(20) NOT NULL DEFAULT '' COMMENT '手机',
  `is_default` tinyint(1) DEFAULT '0' COMMENT '是否默认，0否，1是。',
  `lang` varchar(30) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '添加时间',
  `update_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`addr_id`),
  KEY `users_id` (`users_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='收货地址表';


-- -----------------------------
-- Table structure for `ey_shop_cart`
-- -----------------------------
DROP TABLE IF EXISTS `ey_shop_cart`;
CREATE TABLE `ey_shop_cart` (
  `cart_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '购物车表',
  `users_id` int(10) unsigned DEFAULT '0' COMMENT '会员id',
  `product_id` int(10) unsigned DEFAULT '0' COMMENT '产品id',
  `product_num` int(10) unsigned DEFAULT '0' COMMENT '购买数量',
  `spec_value_id` varchar(100) DEFAULT '' COMMENT '规格值ID',
  `selected` tinyint(1) DEFAULT '1' COMMENT '购物车选中状态：0未选中，1选中',
  `lang` varchar(30) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) DEFAULT '0' COMMENT '加入购物车的时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  `discount_active_id` int(11) DEFAULT '0' COMMENT '限时折扣ID,用来区分购物车的商品哪些是限时折扣活动的',
  PRIMARY KEY (`cart_id`),
  KEY `users_id` (`users_id`,`product_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='购物车表';


-- -----------------------------
-- Table structure for `ey_shop_coupon`
-- -----------------------------
DROP TABLE IF EXISTS `ey_shop_coupon`;
CREATE TABLE `ey_shop_coupon` (
  `coupon_id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `coupon_code` varchar(100) NOT NULL DEFAULT '' COMMENT '优惠券编号',
  `coupon_name` varchar(100) NOT NULL DEFAULT '' COMMENT '优惠券名称',
  `coupon_color` varchar(25) NOT NULL DEFAULT '' COMMENT '优惠券颜色',
  `coupon_form` tinyint(1) NOT NULL DEFAULT '1' COMMENT '优惠券类型 1-满减券',
  `coupon_type` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '可使用商品(1全站通用，2指定商品，3指定商品分类)',
  `product_id` varchar(255) NOT NULL DEFAULT '' COMMENT '指定商品ID，在coupon_type=2时使用',
  `arctype_id` varchar(255) NOT NULL DEFAULT '' COMMENT '指定商品分类ID，在coupon_type=3时使用',
  `coupon_price` decimal(10,0) NOT NULL DEFAULT '0' COMMENT '优惠券金额，例如10',
  `conditions_use` decimal(10,0) NOT NULL DEFAULT '0' COMMENT '优惠券使用条件，例如300',
  `coupon_stock` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '优惠券库存，例如100',
  `redeem_points` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '兑换优惠券所需积分，为0则表示免费兑换',
  `redeem_authority` varchar(10) NOT NULL DEFAULT '' COMMENT '兑换权限，存入多个会员等级组ID',
  `valid_days` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '有效天数，例如30',
  `start_date` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '优惠券开放领取时间',
  `end_date` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '优惠券结束领取时间',
  `sort_order` int(11) unsigned NOT NULL DEFAULT '100' COMMENT '规格排序号',
  `status` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '优惠券状态(0=关闭，1=开启)',
  `use_type` int(1) NOT NULL DEFAULT '1' COMMENT '使用期限 \r\n1-固定日期\r\n 2-领取后当天开始N(valid_days)天内有效\r\n 2-领取后次日开始N(valid_days)天内有效',
  `use_start_time` int(11) NOT NULL COMMENT '使用期限开始时间',
  `use_end_time` int(11) NOT NULL COMMENT '使用期限结束时间',
  `is_del` tinyint(1) DEFAULT '0' COMMENT '0-未删除 1-已删除',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`coupon_id`),
  KEY `product_id` (`product_id`) USING BTREE,
  KEY `arctype_id` (`arctype_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='优惠券主表';


-- -----------------------------
-- Table structure for `ey_shop_coupon_use`
-- -----------------------------
DROP TABLE IF EXISTS `ey_shop_coupon_use`;
CREATE TABLE `ey_shop_coupon_use` (
  `use_id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `users_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '会员ID',
  `coupon_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '优惠券ID',
  `coupon_code` varchar(100) NOT NULL DEFAULT '' COMMENT '优惠券编号',
  `get_ip` varchar(15) NOT NULL DEFAULT '' COMMENT '领取时的IP地址',
  `get_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '优惠券领取时的时间',
  `use_status` tinyint(4) unsigned NOT NULL DEFAULT '1' COMMENT '优惠券使用状态(0未使用，1已使用，2已过期，3已冻结)',
  `use_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '优惠券使用时的时间',
  `start_time` int(10) NOT NULL DEFAULT '0' COMMENT '优惠券有效开始时间',
  `end_time` int(10) NOT NULL DEFAULT '0' COMMENT '优惠券有效结束时间',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`use_id`),
  KEY `coupon_id` (`coupon_id`) USING BTREE,
  KEY `coupon_code` (`coupon_code`) USING BTREE,
  KEY `users_id` (`users_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='优惠券-领取记录表';


-- -----------------------------
-- Table structure for `ey_shop_express`
-- -----------------------------
DROP TABLE IF EXISTS `ey_shop_express`;
CREATE TABLE `ey_shop_express` (
  `express_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增id',
  `express_code` varchar(32) NOT NULL DEFAULT '' COMMENT '物流code（快递100）',
  `express_name` varchar(32) NOT NULL DEFAULT '' COMMENT '物流名称',
  `express_lnitials` varchar(5) NOT NULL DEFAULT '' COMMENT '首字母',
  `is_choose` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '快递公司是否选中(0=否，1=是)',
  `sort_order` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '排序号',
  `add_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  `wx_delivery_id` varchar(20) DEFAULT '' COMMENT '微信快递编码',
  PRIMARY KEY (`express_id`)
) ENGINE=MyISAM AUTO_INCREMENT=599 DEFAULT CHARSET=utf8 COMMENT='快递公司表';

-- -----------------------------
-- Records of `ey_shop_express`
-- -----------------------------
INSERT INTO `ey_shop_express` VALUES ('1', 'yuantong', '圆通快递', 'Y', '1', '97', '1553911076', '1554974797', 'YTO');
INSERT INTO `ey_shop_express` VALUES ('2', 'shentong', '申通快递', 'S', '1', '98', '1553911076', '1554974707', 'STO');
INSERT INTO `ey_shop_express` VALUES ('3', 'shunfeng', '顺丰快递', 'S', '1', '98', '1553911076', '1554974710', 'SF');
INSERT INTO `ey_shop_express` VALUES ('4', 'yunda', '韵达快递', 'Y', '1', '99', '1553911076', '1553911076', 'YD');
INSERT INTO `ey_shop_express` VALUES ('5', 'debangwuliu', '德邦快递', 'D', '1', '99', '1553911076', '1553911076', 'DBL');
INSERT INTO `ey_shop_express` VALUES ('6', 'zhongtong', '中通快递', 'Z', '1', '99', '1553911076', '1553911076', 'ZTO');
INSERT INTO `ey_shop_express` VALUES ('7', 'huitongkuaidi', '百世快递', 'B', '1', '99', '1553911076', '1553911076', 'HTKY');
INSERT INTO `ey_shop_express` VALUES ('8', 'youzhengguonei', '邮政包裹', 'Y', '1', '99', '1553911076', '1553911076', 'YZPY');
INSERT INTO `ey_shop_express` VALUES ('9', 'ems', 'EMS', 'E', '1', '99', '1553911076', '1553911076', 'EMS');
INSERT INTO `ey_shop_express` VALUES ('10', 'youzhengguoji', '邮政国际', 'Y', '1', '99', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('11', 'aolau', 'AOL澳通速递', 'A', '1', '100', '1553911076', '1553911076', 'AOL');
INSERT INTO `ey_shop_express` VALUES ('12', 'a2u', 'A2U速递', 'A', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('13', 'aae', 'AAE快递', 'A', '1', '100', '1553911076', '1553911076', 'AAE');
INSERT INTO `ey_shop_express` VALUES ('14', 'annengwuliu', '安能物流', 'A', '1', '100', '1553911076', '1553911076', 'ANE');
INSERT INTO `ey_shop_express` VALUES ('15', 'anxl', '安迅物流', 'A', '1', '100', '1553911076', '1553911076', 'AX');
INSERT INTO `ey_shop_express` VALUES ('16', 'auexpress', '澳邮中国快运', 'A', '1', '100', '1553911076', '1553911076', 'AUEXPRESS');
INSERT INTO `ey_shop_express` VALUES ('17', 'exfresh', '安鲜达', 'A', '1', '100', '1553911076', '1553911076', 'AXD');
INSERT INTO `ey_shop_express` VALUES ('18', 'anjie88', '安捷物流', 'A', '1', '100', '1553911076', '1553911076', 'AJ');
INSERT INTO `ey_shop_express` VALUES ('19', 'adodoxm', '澳多多国际速递', 'A', '1', '100', '1553911076', '1553911076', 'ADD');
INSERT INTO `ey_shop_express` VALUES ('20', 'ariesfar', '艾瑞斯远', 'A', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('21', 'qdants', 'ANTS EXPRESS', 'A', '1', '100', '1553911076', '1553911076', 'QDANTS');
INSERT INTO `ey_shop_express` VALUES ('22', 'astexpress', '安世通快递', 'A', '1', '100', '1553911076', '1553911076', 'ASTEXPRESS');
INSERT INTO `ey_shop_express` VALUES ('23', 'gda', '安的快递', 'A', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('24', 'ausexpress', '澳世速递', 'A', '1', '100', '1553911076', '1553911076', 'ZY_AUSE');
INSERT INTO `ey_shop_express` VALUES ('25', 'ibuy8', '爱拜物流', 'A', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('26', 'aplusex', 'Aplus物流', 'A', '1', '100', '1553911076', '1553911076', 'APLUSEX');
INSERT INTO `ey_shop_express` VALUES ('27', 'adapost', '安达速递', 'A', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('28', 'adiexpress', '安达易国际速递', 'A', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('29', 'maxeedexpress', '澳洲迈速快递', 'A', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('30', 'onway', '昂威物流', 'A', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('31', 'bcwelt', 'BCWELT', 'B', '1', '100', '1553911076', '1553911076', 'BCWELT');
INSERT INTO `ey_shop_express` VALUES ('32', 'balunzhi', '巴伦支快递', 'B', '1', '100', '1553911076', '1553911076', 'BALUNZHI');
INSERT INTO `ey_shop_express` VALUES ('33', 'xiaohongmao', '北青小红帽', 'B', '1', '100', '1553911076', '1553911076', 'BQXHM');
INSERT INTO `ey_shop_express` VALUES ('34', 'bfdf', '百福东方物流', 'B', '1', '100', '1553911076', '1553911076', 'BFDF');
INSERT INTO `ey_shop_express` VALUES ('35', 'bangsongwuliu', '邦送物流', 'B', '1', '100', '1553911076', '1553911076', 'BSWL');
INSERT INTO `ey_shop_express` VALUES ('36', 'lbbk', '宝凯物流', 'B', '1', '100', '1553911076', '1553911076', 'BKWL');
INSERT INTO `ey_shop_express` VALUES ('37', 'bqcwl', '百千诚物流', 'B', '1', '100', '1553911076', '1553911076', 'BQC');
INSERT INTO `ey_shop_express` VALUES ('38', 'idada', '百成大达物流', 'B', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('39', 'baishiwuliu', '百世快运', 'B', '1', '100', '1553911076', '1553911076', 'BTWL');
INSERT INTO `ey_shop_express` VALUES ('40', 'baitengwuliu', '百腾物流', 'B', '1', '100', '1553911076', '1553911076', 'BETWL');
INSERT INTO `ey_shop_express` VALUES ('41', 'birdex', '笨鸟海淘', 'B', '1', '100', '1553911076', '1553911076', 'BN');
INSERT INTO `ey_shop_express` VALUES ('42', 'bsht', '百事亨通', 'B', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('43', 'benteng', '奔腾物流', 'B', '1', '100', '1553911076', '1553911076', 'BNTWL');
INSERT INTO `ey_shop_express` VALUES ('44', 'cuckooexpess', '布谷鸟速递', 'B', '1', '100', '1553911076', '1553911076', 'CUCKOOEXPRESS');
INSERT INTO `ey_shop_express` VALUES ('45', 'bgky100', '邦工快运', 'B', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('46', 'bosind', '堡昕德速递', 'B', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('47', 'banma', '斑马物联网', 'B', '1', '100', '1553911076', '1553911076', '360ZEBRA');
INSERT INTO `ey_shop_express` VALUES ('48', 'polarisexpress', '北极星快运', 'B', '1', '100', '1553911076', '1553911076', 'BJXKY');
INSERT INTO `ey_shop_express` VALUES ('49', 'beijingfengyue', '北京丰越供应链', 'B', '1', '100', '1553911076', '1553911076', 'BEIJINGFENGYUE');
INSERT INTO `ey_shop_express` VALUES ('50', 'europe8', '败欧洲', 'B', '1', '100', '1553911076', '1553911076', 'BEUROPE');
INSERT INTO `ey_shop_express` VALUES ('51', 'bmlchina', '标杆物流', 'B', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('52', 'comexpress', '邦通国际', 'B', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('53', 'baotongkd', '宝通快递', 'B', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('54', 'beckygo', '佰麒快递', 'B', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('55', 'boyol', '贝业物流', 'B', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('56', 'bdatong', '八达通快递', 'B', '1', '100', '1553911076', '1553911076', 'BDT');
INSERT INTO `ey_shop_express` VALUES ('57', 'bangbangpost', '帮帮发', 'B', '1', '100', '1553911076', '1553911076', 'BBFZY');
INSERT INTO `ey_shop_express` VALUES ('58', 'baoxianda', '报通快递', 'B', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('59', 'coe', '中国东方(COE)', 'Z', '1', '100', '1553911076', '1553911076', 'COE');
INSERT INTO `ey_shop_express` VALUES ('60', 'cloudexpress', 'CE易欧通国际速递', 'C', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('61', 'city100', '城市100', 'C', '1', '100', '1553911076', '1553911076', 'CITY100');
INSERT INTO `ey_shop_express` VALUES ('62', 'chuanxiwuliu', '传喜物流', 'C', '1', '100', '1553911076', '1553911076', 'CXHY');
INSERT INTO `ey_shop_express` VALUES ('63', 'chengjisudi', '城际速递', 'C', '1', '100', '1553911076', '1553911076', 'CJKD');
INSERT INTO `ey_shop_express` VALUES ('64', 'lijisong', '立即送', 'L', '1', '100', '1553911076', '1553911076', 'LJS');
INSERT INTO `ey_shop_express` VALUES ('65', 'chukou1', '出口易', 'C', '1', '100', '1553911076', '1553911076', 'CKY');
INSERT INTO `ey_shop_express` VALUES ('66', 'nanjingshengbang', '晟邦物流', 'C', '1', '100', '1553911076', '1553911076', 'NJSBWL');
INSERT INTO `ey_shop_express` VALUES ('67', 'flyway', '程光快递', 'C', '1', '100', '1553911076', '1553911076', 'CG');
INSERT INTO `ey_shop_express` VALUES ('68', 'cbo56', '钏博物流', 'C', '1', '100', '1553911076', '1553911076', 'CBO');
INSERT INTO `ey_shop_express` VALUES ('69', 'cex', '城铁速递', 'C', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('70', 'cnup', 'CNUP 中联邮', 'C', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('71', 'clsp', 'CL日中速运', 'C', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('72', 'cnair', 'CNAIR', 'C', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('73', 'cangspeed', '仓鼠快递', 'C', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('74', 'spring56', '春风物流', 'C', '1', '100', '1553911076', '1553911076', 'CFWL');
INSERT INTO `ey_shop_express` VALUES ('75', 'cunto', '村通快递', 'C', '1', '100', '1553911076', '1553911076', 'CUNTO');
INSERT INTO `ey_shop_express` VALUES ('76', 'longvast', '长风物流', 'C', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('77', 'changjiang', '长江国际速递', 'C', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('78', 'cncexp', 'C&C国际速递', 'C', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('79', 'parcelchina', '诚一物流', 'C', '1', '100', '1553911076', '1553911076', 'PARCELCHINA');
INSERT INTO `ey_shop_express` VALUES ('80', 'chengtong', '城通物流', 'C', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('81', 'otpexpress', '承诺达', 'C', '1', '100', '1553911076', '1553911076', 'CND');
INSERT INTO `ey_shop_express` VALUES ('82', 'sfpost', '曹操到', 'C', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('83', 'changwooair', '昌宇国际', 'C', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('84', 'dhl', 'DHL快递（中国件）', 'D', '1', '100', '1553911076', '1553911076', 'DHL_C');
INSERT INTO `ey_shop_express` VALUES ('85', 'dhlen', 'DHL（国际件）', 'D', '1', '100', '1553911076', '1553911076', 'DHL_GLB');
INSERT INTO `ey_shop_express` VALUES ('86', 'dhlde', 'DHL（德国件）', 'D', '1', '100', '1553911076', '1553911076', 'DHL_DE');
INSERT INTO `ey_shop_express` VALUES ('87', 'dtwl', '大田物流', 'D', '1', '100', '1553911076', '1553911076', 'DTWL');
INSERT INTO `ey_shop_express` VALUES ('88', 'disifang', '递四方', 'D', '1', '100', '1553911076', '1553911076', 'D4PX');
INSERT INTO `ey_shop_express` VALUES ('89', 'dayangwuliu', '大洋物流', 'D', '1', '100', '1553911076', '1553911076', 'DYWL');
INSERT INTO `ey_shop_express` VALUES ('90', 'dechuangwuliu', '德创物流', 'D', '1', '100', '1553911076', '1553911076', 'DCWL');
INSERT INTO `ey_shop_express` VALUES ('91', 'dskd', 'D速物流', 'D', '1', '100', '1553911076', '1553911076', 'DSWL');
INSERT INTO `ey_shop_express` VALUES ('92', 'donghanwl', '东瀚物流', 'D', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('93', 'dfpost', '达方物流', 'D', '1', '100', '1553911076', '1553911076', 'IDFWL');
INSERT INTO `ey_shop_express` VALUES ('94', 'dongjun', '东骏快捷物流', 'D', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('95', 'dindon', '叮咚澳洲转运', 'D', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('96', 'dazhong', '大众佐川急便', 'D', '1', '100', '1553911076', '1553911076', 'SAGAWA');
INSERT INTO `ey_shop_express` VALUES ('97', 'ahdf', '德方物流', 'D', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('98', 'dehaoyi', '德豪驿', 'D', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('99', 'dhlpaket', 'DHL Paket', 'D', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('100', 'ubuy', '德国优拜物流', 'D', '1', '100', '1553911076', '1553911076', 'YBWL');
INSERT INTO `ey_shop_express` VALUES ('101', 'adlerlogi', '德国雄鹰速递', 'D', '1', '100', '1553911076', '1553911076', 'XYGJSD');
INSERT INTO `ey_shop_express` VALUES ('102', 'yunexpress', '德国云快递', 'D', '1', '100', '1553911076', '1553911076', 'DGYKD');
INSERT INTO `ey_shop_express` VALUES ('103', 'di5pll', '递五方云仓', 'D', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('104', 'deguo8elog', '德国八易转运', 'D', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('105', 'camekong', '到了港', 'D', '1', '100', '1553911076', '1553911076', 'DLG');
INSERT INTO `ey_shop_express` VALUES ('106', 'dbstation', 'db-station', 'D', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('107', 'dadaoex', '大道物流', 'D', '1', '100', '1553911076', '1553911076', 'DDWL');
INSERT INTO `ey_shop_express` VALUES ('108', 'dekuncn', '德坤物流', 'D', '1', '100', '1553911076', '1553911076', 'DEKUN');
INSERT INTO `ey_shop_express` VALUES ('109', 'twkd56', '缔惠盛合', 'D', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('110', 'gslexpress', '德尚国际速递', 'D', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('111', 'eucpost', '德国 EUC POST', 'D', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('112', 'est365', '东方汇', 'D', '1', '100', '1553911076', '1553911076', 'EST365');
INSERT INTO `ey_shop_express` VALUES ('113', 'ecotransite', '东西E全运', 'D', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('114', 'euexpress', 'EU-EXPRESS', 'E', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('115', 'emsguoji', 'EMS国际快递查询', 'E', '1', '100', '1553911076', '1553911076', 'EMS');
INSERT INTO `ey_shop_express` VALUES ('116', 'eshunda', '俄顺达', 'E', '1', '100', '1553911076', '1553911076', '007EX');
INSERT INTO `ey_shop_express` VALUES ('117', 'ewe', 'EWE全球快递', 'E', '1', '100', '1553911076', '1553911076', 'EWE');
INSERT INTO `ey_shop_express` VALUES ('118', 'easyexpress', 'EASYEXPRESS国际速递', 'E', '1', '100', '1553911076', '1553911076', 'EASYEX');
INSERT INTO `ey_shop_express` VALUES ('119', 'edtexpress', 'e直运', 'E', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('120', 'ecallturn', 'E跨通', 'E', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('121', 'fedex', 'FedEx快递查询', 'F', '1', '100', '1553911076', '1553911076', 'FEDEX');
INSERT INTO `ey_shop_express` VALUES ('122', 'fedexus', 'FedEx（美国）', 'F', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('123', 'fox', 'FOX国际速递', 'F', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('124', 'rufengda', '如风达快递', 'R', '1', '100', '1553911076', '1553911076', 'RFD');
INSERT INTO `ey_shop_express` VALUES ('125', 'fkd', '飞康达物流', 'F', '1', '100', '1553911076', '1553911076', 'FKD');
INSERT INTO `ey_shop_express` VALUES ('126', 'feibaokuaidi', '飞豹快递', 'F', '1', '100', '1553911076', '1553911076', 'FBKD');
INSERT INTO `ey_shop_express` VALUES ('127', 'fandaguoji', '颿达国际', 'F', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('128', 'feiyuanvipshop', '飞远配送', 'F', '1', '100', '1553911076', '1553911076', 'FYPS');
INSERT INTO `ey_shop_express` VALUES ('129', 'hnfy', '飞鹰物流', 'F', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('130', 'fengxingtianxia', '风行天下', 'F', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('131', 'flysman', '飞力士物流', 'F', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('132', 'fbkd', '飞邦快递', 'F', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('133', 'sccod', '丰程物流', 'F', '1', '100', '1553911076', '1553911076', 'FCWL');
INSERT INTO `ey_shop_express` VALUES ('134', 'crazyexpress', '疯狂快递', 'F', '1', '100', '1553911076', '1553911076', 'CRAZY');
INSERT INTO `ey_shop_express` VALUES ('135', 'ftlexpress', '法翔速运', 'F', '1', '100', '1553911076', '1553911076', 'FX');
INSERT INTO `ey_shop_express` VALUES ('136', 'ftd', '富腾达快递', 'F', '1', '100', '1553911076', '1553911076', 'FTD');
INSERT INTO `ey_shop_express` VALUES ('137', 'arkexpress', '方舟国际速递', 'F', '1', '100', '1553911076', '1553911076', 'FZGJ');
INSERT INTO `ey_shop_express` VALUES ('138', 'fedroad', 'FedRoad 联邦转运', 'F', '1', '100', '1553911076', '1553911076', 'ZY_LBZY');
INSERT INTO `ey_shop_express` VALUES ('139', 'freakyquick', 'FQ狂派速递', 'F', '1', '100', '1553911076', '1553911076', 'FREAKYQUICK');
INSERT INTO `ey_shop_express` VALUES ('140', 'fecobv', '丰客物流', 'F', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('141', 'fyex', '飞云快递系统', 'F', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('142', 'beebird', '锋鸟物流', 'F', '1', '100', '1553911076', '1553911076', 'BEEBIRD');
INSERT INTO `ey_shop_express` VALUES ('143', 'shipgce', '飞洋快递', 'F', '1', '100', '1553911076', '1553911076', 'ZY_FY');
INSERT INTO `ey_shop_express` VALUES ('144', 'koali', '番薯国际货运', 'F', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('145', 'epanex', '泛捷国际速递', 'F', '1', '100', '1553911076', '1553911076', 'PANEX');
INSERT INTO `ey_shop_express` VALUES ('146', 'gaticn', 'GATI快递', 'G', '1', '100', '1553911076', '1553911076', 'GATICN');
INSERT INTO `ey_shop_express` VALUES ('147', 'gts', 'GTS快递', 'G', '1', '100', '1553911076', '1553911076', 'GTSEXPRESS');
INSERT INTO `ey_shop_express` VALUES ('148', 'guotongkuaidi', '国通快递', 'G', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('149', 'ndkd', '能达速递', 'N', '1', '100', '1553911076', '1553911076', 'NEDA');
INSERT INTO `ey_shop_express` VALUES ('150', 'gongsuda', '共速达', 'G', '1', '100', '1553911076', '1553911076', 'GSD');
INSERT INTO `ey_shop_express` VALUES ('151', 'gtongsudi', '广通速递（山东）', 'G', '1', '100', '1553911076', '1553911076', 'GTKD');
INSERT INTO `ey_shop_express` VALUES ('152', 'suteng', '速腾物流', 'S', '1', '100', '1553911076', '1553911076', 'STWL');
INSERT INTO `ey_shop_express` VALUES ('153', 'gdkd', '港快速递', 'G', '1', '100', '1553911076', '1553911076', 'GKSD');
INSERT INTO `ey_shop_express` VALUES ('154', 'hre', '高铁速递', 'G', '1', '100', '1553911076', '1553911076', 'GTSD');
INSERT INTO `ey_shop_express` VALUES ('155', 'gscq365', '哥士传奇速递', 'G', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('156', 'gjwl', '冠捷物流', 'G', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('157', 'xdshipping', '国晶物流', 'G', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('158', 'ge2d', 'GE2D跨境物流', 'G', '1', '100', '1553911076', '1553911076', 'GE2D');
INSERT INTO `ey_shop_express` VALUES ('159', 'gaotieex', '高铁快运', 'G', '1', '100', '1553911076', '1553911076', 'GTKY');
INSERT INTO `ey_shop_express` VALUES ('160', 'gansuandi', '甘肃安的快递', 'G', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('161', 'gdct56', '广东诚通物流', 'G', '1', '100', '1553911076', '1553911076', 'CHTWL');
INSERT INTO `ey_shop_express` VALUES ('162', 'ghtexpress', 'GHT物流', 'G', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('163', 'goldjet', '高捷快运', 'G', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('164', 'gtgogo', 'GT国际快运', 'G', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('165', 'gxwl', '光线速递', 'G', '1', '100', '1553911076', '1553911076', 'SUNSHINE');
INSERT INTO `ey_shop_express` VALUES ('166', 'tdhy', '华宇物流', 'H', '1', '100', '1553911076', '1553911076', 'TDHY');
INSERT INTO `ey_shop_express` VALUES ('167', 'hl', '恒路物流', 'H', '1', '100', '1553911076', '1553911076', 'HLWL');
INSERT INTO `ey_shop_express` VALUES ('168', 'hlyex', '好来运快递', 'H', '1', '100', '1553911076', '1553911076', 'HLYSD');
INSERT INTO `ey_shop_express` VALUES ('169', 'hebeijianhua', '河北建华', 'H', '1', '100', '1553911076', '1553911076', 'HBJH');
INSERT INTO `ey_shop_express` VALUES ('170', 'huaqikuaiyun', '华企快运', 'H', '1', '100', '1553911076', '1553911076', 'HQKY');
INSERT INTO `ey_shop_express` VALUES ('171', 'haosheng', '昊盛物流', 'H', '1', '100', '1553911076', '1553911076', 'HSWL');
INSERT INTO `ey_shop_express` VALUES ('172', 'hutongwuliu', '户通物流', 'H', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('173', 'hzpl', '华航快递', 'H', '1', '100', '1553911076', '1553911076', 'HHKD');
INSERT INTO `ey_shop_express` VALUES ('174', 'huangmajia', '黄马甲快递', 'H', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('175', 'ucs', '合众速递（UCS）', 'H', '1', '100', '1553911076', '1553911076', 'ZY_UCS');
INSERT INTO `ey_shop_express` VALUES ('176', 'pfcexpress', '皇家物流', 'H', '1', '100', '1553911076', '1553911076', 'HJWL');
INSERT INTO `ey_shop_express` VALUES ('177', 'huoban', '伙伴物流', 'H', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('178', 'nedahm', '红马速递', 'H', '1', '100', '1553911076', '1553911076', 'SXHMJ');
INSERT INTO `ey_shop_express` VALUES ('179', 'huiwen', '汇文配送', 'H', '1', '100', '1553911076', '1553911076', 'HFHW');
INSERT INTO `ey_shop_express` VALUES ('180', 'nmhuahe', '华赫物流', 'H', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('181', 'hjs', '猴急送', 'H', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('182', 'hangyu', '航宇快递', 'H', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('183', 'huilian', '辉联物流', 'H', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('184', 'huanqiu', '环球速运', 'H', '1', '100', '1553911076', '1553911076', 'HQSY');
INSERT INTO `ey_shop_express` VALUES ('185', 'htwd', '华通务达物流', 'H', '1', '100', '1553911076', '1553911076', 'ZY_HTONG');
INSERT INTO `ey_shop_express` VALUES ('186', 'hipito', '海派通', 'H', '1', '100', '1553911076', '1553911076', 'HPTEX');
INSERT INTO `ey_shop_express` VALUES ('187', 'hqtd', '环球通达', 'H', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('188', 'airgtc', '航空快递', 'H', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('189', 'haoyoukuai', '好又快物流', 'H', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('190', 'ccd', '河南次晨达', 'H', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('191', 'hfwuxi', '和丰同城', 'H', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('192', 'higo', '黑狗物流', 'H', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('193', 'hyytes', '恒宇运通', 'H', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('194', 'hengrui56', '恒瑞物流', 'H', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('195', 'hangrui', '上海航瑞货运', 'S', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('196', 'ghl', '环创物流', 'H', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('197', 'hnqst', '河南全速通', 'H', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('198', 'hitaoe', 'Hi淘易快递', 'H', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('199', 'hhair56', '华瀚快递', 'H', '1', '100', '1553911076', '1553911076', 'HHAIR56');
INSERT INTO `ey_shop_express` VALUES ('200', 'haimibuy', '海米派物流', 'H', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('201', 'ht22', '海淘物流', 'H', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('202', 'hivewms', '海沧无忧', 'H', '1', '100', '1553911076', '1553911076', 'HIVEWMS');
INSERT INTO `ey_shop_express` VALUES ('203', 'hnht56', '鸿泰物流', 'H', '1', '100', '1553911076', '1553911076', 'HTWL');
INSERT INTO `ey_shop_express` VALUES ('204', 'hsgtsd', '海硕高铁速递', 'H', '1', '100', '1553911076', '1553911076', 'HSGTSD');
INSERT INTO `ey_shop_express` VALUES ('205', 'hltop', '海联快递', 'H', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('206', 'hlkytj', '互联快运', 'H', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('207', 'haidaibao', '海带宝转运', 'H', '1', '100', '1553911076', '1553911076', 'ZY_HDB');
INSERT INTO `ey_shop_express` VALUES ('208', 'flowerkd', '花瓣转运', 'H', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('209', 'heimao56', '黑猫速运', 'H', '1', '100', '1553911076', '1553911076', 'TCATCN');
INSERT INTO `ey_shop_express` VALUES ('210', 'logistics', '華信物流WTO', 'H', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('211', 'hgy56', '环国运物流', 'H', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('212', 'iparcel', 'i-parcel', 'I', '1', '100', '1553911076', '1553911076', 'IPARCEL');
INSERT INTO `ey_shop_express` VALUES ('213', 'jjwl', '佳吉物流', 'J', '1', '100', '1553911076', '1553911076', 'JIAJI');
INSERT INTO `ey_shop_express` VALUES ('214', 'jywl', '佳怡物流', 'J', '1', '100', '1553911076', '1553911076', 'JYWL');
INSERT INTO `ey_shop_express` VALUES ('215', 'jymwl', '加运美快递', 'J', '1', '100', '1553911076', '1553911076', 'JYM');
INSERT INTO `ey_shop_express` VALUES ('216', 'jxd', '急先达物流', 'J', '1', '100', '1553911076', '1553911076', 'JXD');
INSERT INTO `ey_shop_express` VALUES ('217', 'jgsd', '京广速递快件', 'J', '1', '100', '1553911076', '1553911076', 'JGSD');
INSERT INTO `ey_shop_express` VALUES ('218', 'jykd', '晋越快递', 'J', '1', '100', '1553911076', '1553911076', 'JYKD');
INSERT INTO `ey_shop_express` VALUES ('219', 'jd', '京东物流', 'J', '1', '100', '1553911076', '1553911076', 'JD');
INSERT INTO `ey_shop_express` VALUES ('220', 'jietekuaidi', '捷特快递', 'J', '1', '100', '1553911076', '1553911076', 'JTKD');
INSERT INTO `ey_shop_express` VALUES ('221', 'jiuyicn', '久易快递', 'J', '1', '100', '1553911076', '1553911076', 'JYSD');
INSERT INTO `ey_shop_express` VALUES ('222', 'jiuyescm', '九曳供应链', 'J', '1', '100', '1553911076', '1553911076', 'JIUYE');
INSERT INTO `ey_shop_express` VALUES ('223', 'junfengguoji', '骏丰国际速递', 'J', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('224', 'jiajiatong56', '佳家通', 'J', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('225', 'jrypex', '吉日优派', 'J', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('226', 'jinchengwuliu', '锦程国际物流', 'J', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('227', 'jgwl', '景光物流', 'J', '1', '100', '1553911076', '1553911076', 'JGWL');
INSERT INTO `ey_shop_express` VALUES ('228', 'pzhjst', '急顺通', 'J', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('229', 'ruexp', '捷网俄全通', 'J', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('230', 'jialidatong', '嘉里大通', 'J', '1', '100', '1553911076', '1553911076', 'KERRYLOGISTICS');
INSERT INTO `ey_shop_express` VALUES ('231', 'jmjss', '金马甲', 'J', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('232', 'jiacheng', '佳成快递', 'J', '1', '100', '1553911076', '1553911076', 'JCEX');
INSERT INTO `ey_shop_express` VALUES ('233', 'jsexpress', '骏绅物流', 'J', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('234', 'hrex', '锦程快递', 'J', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('235', 'jieanda', '捷安达国际速递', 'J', '1', '100', '1553911076', '1553911076', 'JAD');
INSERT INTO `ey_shop_express` VALUES ('236', 'newsway', '家家通快递', 'J', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('237', 'mapleexpress', '今枫国际快运', 'J', '1', '100', '1553911076', '1553911076', 'JFGJ');
INSERT INTO `ey_shop_express` VALUES ('238', 'jixiangyouau', '吉祥邮（澳洲）', 'J', '1', '100', '1553911076', '1553911076', 'JXYKD');
INSERT INTO `ey_shop_express` VALUES ('239', 'jjx888', '佳捷翔物流', 'J', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('240', 'polarexpress', '极地快递', 'J', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('241', 'jiazhoumao', '加州猫速递', 'J', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('242', 'juzhongda', '聚中大', 'J', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('243', 'jieborne', '捷邦物流', 'J', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('244', 'jxfex', '集先锋速递', 'J', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('245', 'jiugong', '九宫物流', 'J', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('246', 'jiujiuwl', '久久物流', 'J', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('247', 'jintongkd', '劲通快递', 'J', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('248', 'jcsuda', '嘉诚速达', 'J', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('249', 'jingshun', '景顺物流', 'J', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('250', 'fastontime', '加拿大联通快运', 'J', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('251', 'khzto', '柬埔寨中通', 'J', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('252', 'kjkd', '快捷快递', 'K', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('253', 'kangliwuliu', '康力物流', 'K', '1', '100', '1553911076', '1553911076', 'KLWL');
INSERT INTO `ey_shop_express` VALUES ('254', 'kuayue', '跨越速运', 'K', '1', '100', '1553911076', '1553911076', 'KYSY');
INSERT INTO `ey_shop_express` VALUES ('255', 'kuaiyouda', '快优达速递', 'K', '1', '100', '1553911076', '1553911076', 'KYDSD');
INSERT INTO `ey_shop_express` VALUES ('256', 'happylink', '开心快递', 'K', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('257', 'ksudi', '快速递', 'K', '1', '100', '1553911076', '1553911076', 'KSDWL');
INSERT INTO `ey_shop_express` VALUES ('258', 'kyue', '跨跃国际', 'K', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('259', 'kfwnet', '快服务', 'K', '1', '100', '1553911076', '1553911076', 'KFW');
INSERT INTO `ey_shop_express` VALUES ('260', 'kuai8', '快8速运', 'K', '1', '100', '1553911076', '1553911076', 'KBSY');
INSERT INTO `ey_shop_express` VALUES ('261', 'kuaidawuliu', '快达物流', 'K', '1', '100', '1553911076', '1553911076', 'KUAIDAWULIU');
INSERT INTO `ey_shop_express` VALUES ('262', 'lianb', '联邦快递（国内）', 'L', '1', '100', '1553911076', '1553911076', 'FEDEX');
INSERT INTO `ey_shop_express` VALUES ('263', 'lhtwl', '联昊通物流', 'L', '1', '100', '1553911076', '1553911076', 'LHT');
INSERT INTO `ey_shop_express` VALUES ('264', 'lb', '龙邦速递', 'L', '1', '100', '1553911076', '1553911076', 'LB');
INSERT INTO `ey_shop_express` VALUES ('265', 'lejiedi', '乐捷递', 'L', '1', '100', '1553911076', '1553911076', 'LJD');
INSERT INTO `ey_shop_express` VALUES ('266', 'lanhukuaidi', '蓝弧快递', 'L', '1', '100', '1553911076', '1553911076', 'LHKD');
INSERT INTO `ey_shop_express` VALUES ('267', 'ltexp', '乐天速递', 'L', '1', '100', '1553911076', '1553911076', 'LTIAN');
INSERT INTO `ey_shop_express` VALUES ('268', 'lutong', '鲁通快运', 'L', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('269', 'ledii', '乐递供应链', 'L', '1', '100', '1553911076', '1553911076', 'LEDII');
INSERT INTO `ey_shop_express` VALUES ('270', 'lundao', '论道国际物流', 'L', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('271', 'lasy56', '林安物流', 'L', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('272', 'lsexpress', '6LS EXPRESS', 'L', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('273', 'szuem', '联运通物流', 'L', '1', '100', '1553911076', '1553911076', 'LYT');
INSERT INTO `ey_shop_express` VALUES ('274', 'blueskyexpress', '蓝天国际航空快递', 'L', '1', '100', '1553911076', '1553911076', 'BLUESKYEXPRESS');
INSERT INTO `ey_shop_express` VALUES ('275', 'lfexpress', '龙枫国际速递', 'L', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('276', 'gslhkd', '联合快递', 'L', '1', '100', '1553911076', '1553911076', 'LHKDS');
INSERT INTO `ey_shop_express` VALUES ('277', 'longfx', '龙飞祥快递', 'L', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('278', 'luben', '陆本速递 LUBEN EXPRESS', 'L', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('279', 'unitedex', '联合速运', 'L', '1', '100', '1553911076', '1553911076', 'LHKDS');
INSERT INTO `ey_shop_express` VALUES ('280', 'lbex', '龙邦物流', 'L', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('281', 'ltparcel', '联通快递', 'L', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('282', 'macroexpressco', 'ME物流', 'M', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('283', 'mh', '民航快递', 'M', '1', '100', '1553911076', '1553911076', 'MHKD');
INSERT INTO `ey_shop_express` VALUES ('284', 'meiguokuaidi', '美国快递', 'M', '1', '100', '1553911076', '1553911076', 'USEX');
INSERT INTO `ey_shop_express` VALUES ('285', 'menduimen', '门对门', 'M', '1', '100', '1553911076', '1553911076', 'MDM');
INSERT INTO `ey_shop_express` VALUES ('286', 'mingliangwuliu', '明亮物流', 'M', '1', '100', '1553911076', '1553911076', 'MLWL');
INSERT INTO `ey_shop_express` VALUES ('287', 'minbangsudi', '民邦速递', 'M', '1', '100', '1553911076', '1553911076', 'MB');
INSERT INTO `ey_shop_express` VALUES ('288', 'minshengkuaidi', '闽盛快递', 'M', '1', '100', '1553911076', '1553911076', 'MSKD');
INSERT INTO `ey_shop_express` VALUES ('289', 'yundaexus', '美国韵达', 'M', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('290', 'mchy', '木春货运', 'M', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('291', 'meiquick', '美快国际物流', 'M', '1', '100', '1553911076', '1553911076', 'MK');
INSERT INTO `ey_shop_express` VALUES ('292', 'valueway', '美通快递', 'M', '1', '100', '1553911076', '1553911076', 'VALUEWAY');
INSERT INTO `ey_shop_express` VALUES ('293', 'cnmcpl', '马珂博逻', 'M', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('294', 'mailongdy', '迈隆递运', 'M', '1', '100', '1553911076', '1553911076', 'MRDY');
INSERT INTO `ey_shop_express` VALUES ('295', 'zsmhwl', '明辉物流', 'M', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('296', 'mosuda', '魔速达', 'M', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('297', 'meibang', '美邦国际快递', 'M', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('298', 'nuoyaao', '偌亚奥国际', 'N', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('299', 'nuoer', '诺尔国际物流', 'N', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('300', 'nell', '尼尔快递', 'N', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('301', 'ndwl', '南方传媒物流', 'N', '1', '100', '1553911076', '1553911076', 'NFCM');
INSERT INTO `ey_shop_express` VALUES ('302', 'canhold', '能装能送', 'N', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('303', 'wanjiatong', '宁夏万家通', 'N', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('304', 'nlebv', '欧亚专线', 'O', '1', '100', '1553911076', '1553911076', 'EUASIA');
INSERT INTO `ey_shop_express` VALUES ('305', 'oborexpress', 'OBOR Express', 'O', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('306', 'pcaexpress', 'PCA Express', 'P', '1', '100', '1553911076', '1553911076', 'PCA');
INSERT INTO `ey_shop_express` VALUES ('307', 'pingandatengfei', '平安达腾飞', 'P', '1', '100', '1553911076', '1553911076', 'PADTF');
INSERT INTO `ey_shop_express` VALUES ('308', 'peixingwuliu', '陪行物流', 'P', '1', '100', '1553911076', '1553911076', 'PXWL');
INSERT INTO `ey_shop_express` VALUES ('309', 'pengyuanexpress', '鹏远国际速递', 'P', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('310', 'postelbe', 'PostElbe', 'P', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('311', 'papascm', '啪啪供应链', 'P', '1', '100', '1553911076', '1553911076', 'PAPA');
INSERT INTO `ey_shop_express` VALUES ('312', 'bazirim', '皮牙子快递', 'P', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('313', 'qfkd', '全峰快递', 'Q', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('314', 'qy', '全一快递', 'Q', '1', '100', '1553911076', '1553911076', 'UAPEX');
INSERT INTO `ey_shop_express` VALUES ('315', 'qrt', '全日通快递', 'Q', '1', '100', '1553911076', '1553911076', 'QRT');
INSERT INTO `ey_shop_express` VALUES ('316', 'qckd', '全晨快递', 'Q', '1', '100', '1553911076', '1553911076', 'QCKD');
INSERT INTO `ey_shop_express` VALUES ('317', 'sevendays', '7天连锁物流', 'Q', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('318', 'qbexpress', '秦邦快运', 'Q', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('319', 'quanxintong', '全信通快递', 'Q', '1', '100', '1553911076', '1553911076', 'QXT');
INSERT INTO `ey_shop_express` VALUES ('320', 'quansutong', '全速通国际快递', 'Q', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('321', 'qinyuan', '秦远物流', 'Q', '1', '100', '1553911076', '1553911076', 'CHINZ56');
INSERT INTO `ey_shop_express` VALUES ('322', 'qichen', '启辰国际物流', 'Q', '1', '100', '1553911076', '1553911076', 'VENUCIA');
INSERT INTO `ey_shop_express` VALUES ('323', 'quansu', '全速快运', 'Q', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('324', 'qzx56', '全之鑫物流', 'Q', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('325', 'qskdyxgs', '千顺快递', 'Q', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('326', 'zqlwl', '青旅物流', 'Q', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('327', 'quanchuan56', '全川物流', 'Q', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('328', 'quantwl', '全通快运', 'Q', '1', '100', '1553911076', '1553911076', 'IQTWL');
INSERT INTO `ey_shop_express` VALUES ('329', 'yatexpress', '乾坤物流', 'Q', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('330', 'guexp', '全联速运', 'Q', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('331', 'bjqywl', '青云物流', 'Q', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('332', 'signedexpress', '签收快递', 'Q', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('333', 'express7th', '7号速递', 'Q', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('334', 'riyuwuliu', '日昱物流', 'R', '1', '100', '1553911076', '1553911076', 'RLWL');
INSERT INTO `ey_shop_express` VALUES ('335', 'rfsd', '瑞丰速递', 'R', '1', '100', '1553911076', '1553911076', 'RFEX');
INSERT INTO `ey_shop_express` VALUES ('336', 'rrs', '日日顺物流', 'R', '1', '100', '1553911076', '1553911076', 'RRS');
INSERT INTO `ey_shop_express` VALUES ('337', 'rytsd', '日益通速递', 'R', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('338', 'rrskx', '日日顺快线', 'R', '1', '100', '1553911076', '1553911076', 'RRS');
INSERT INTO `ey_shop_express` VALUES ('339', 'gdrz58', '容智快运', 'R', '1', '100', '1553911076', '1553911076', 'GDRZ58');
INSERT INTO `ey_shop_express` VALUES ('340', 'rrthk', '日日通国际', 'R', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('341', 'homecourier', '如家国际快递', 'R', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('342', 'sewl', '速尔快递', 'S', '1', '100', '1553911076', '1553911076', 'SURE');
INSERT INTO `ey_shop_express` VALUES ('343', 'haihongwangsong', '山东海红', 'S', '1', '100', '1553911076', '1553911076', 'SDHH');
INSERT INTO `ey_shop_express` VALUES ('344', 'sh', '盛辉物流', 'S', '1', '100', '1553911076', '1553911076', 'SHWL');
INSERT INTO `ey_shop_express` VALUES ('345', 'sfwl', '盛丰物流', 'S', '1', '100', '1553911076', '1553911076', 'SFWL');
INSERT INTO `ey_shop_express` VALUES ('346', 'shiyunkuaidi', '世运快递', 'S', '1', '100', '1553911076', '1553911076', 'SYKD');
INSERT INTO `ey_shop_express` VALUES ('347', 'shangda', '上大物流', 'S', '1', '100', '1553911076', '1553911076', 'SDWL');
INSERT INTO `ey_shop_express` VALUES ('348', 'stsd', '三态速递', 'S', '1', '100', '1553911076', '1553911076', 'STSD');
INSERT INTO `ey_shop_express` VALUES ('349', 'saiaodi', '赛澳递', 'S', '1', '100', '1553911076', '1553911076', 'SAD');
INSERT INTO `ey_shop_express` VALUES ('350', 'ewl', '申通E物流', 'S', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('351', 'shenganwuliu', '圣安物流', 'S', '1', '100', '1553911076', '1553911076', 'SAWL');
INSERT INTO `ey_shop_express` VALUES ('352', 'sxhongmajia', '山西红马甲', 'S', '1', '100', '1553911076', '1553911076', 'SXHMJ');
INSERT INTO `ey_shop_express` VALUES ('353', 'suijiawuliu', '穗佳物流', 'S', '1', '100', '1553911076', '1553911076', 'SJWL');
INSERT INTO `ey_shop_express` VALUES ('354', 'syjiahuier', '沈阳佳惠尔', 'S', '1', '100', '1553911076', '1553911076', 'SYJHE');
INSERT INTO `ey_shop_express` VALUES ('355', 'shlindao', '上海林道货运', 'S', '1', '100', '1553911076', '1553911076', 'LDXPRESS');
INSERT INTO `ey_shop_express` VALUES ('356', 'sfift', '十方通物流', 'S', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('357', 'shunjiefengda', '顺捷丰达', 'S', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('358', 'subida', '速必达物流', 'S', '1', '100', '1553911076', '1553911076', 'SUBIDA');
INSERT INTO `ey_shop_express` VALUES ('359', 'stcd', '速通成达物流', 'S', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('360', 'stkd', '顺通快递', 'S', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('361', 'sendtochina', '速递中国', 'S', '1', '100', '1553911076', '1553911076', 'SENDCN');
INSERT INTO `ey_shop_express` VALUES ('362', 'sihaiet', '四海快递', 'S', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('363', 'staky', '首通快运', 'S', '1', '100', '1553911076', '1553911076', 'STONG');
INSERT INTO `ey_shop_express` VALUES ('364', 'hnssd56', '顺时达物流', 'S', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('365', 'superb', 'Superb Grace', 'S', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('366', 'sfjhd', '圣飞捷快递', 'S', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('367', 'sofast56', '嗖一下同城快递', 'S', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('368', 's2c', 'S2C', 'S', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('369', 'chinasqk', 'SQK国际速递', 'S', '1', '100', '1553911076', '1553911076', 'CHINASQK');
INSERT INTO `ey_shop_express` VALUES ('370', 'shunshid', '顺士达速运', 'S', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('371', 'synship', 'SYNSHIP快递', 'S', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('372', 'shandiantu', '闪电兔', 'S', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('373', 'sdsy888', '首达速运', 'S', '1', '100', '1553911076', '1553911076', 'SDSY');
INSERT INTO `ey_shop_express` VALUES ('374', 'sczpds', '速呈宅配', 'S', '1', '100', '1553911076', '1553911076', 'SCZPDS');
INSERT INTO `ey_shop_express` VALUES ('375', 'sureline', 'Sureline冠泰', 'S', '1', '100', '1553911076', '1553911076', 'GT');
INSERT INTO `ey_shop_express` VALUES ('376', 'stosolution', '申通国际', 'S', '1', '100', '1553911076', '1553911076', 'STO_INTL');
INSERT INTO `ey_shop_express` VALUES ('377', 'sycawl', '狮爱高铁物流', 'S', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('378', 'sxexpress', '三象速递', 'S', '1', '100', '1553911076', '1553911076', 'SXEXPRESS');
INSERT INTO `ey_shop_express` VALUES ('379', 'shangqiao56', '商桥物流', 'S', '1', '100', '1553911076', '1553911076', 'SQWL');
INSERT INTO `ey_shop_express` VALUES ('380', 'shd56', '商海德物流', 'S', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('381', 'shenma', '神马快递', 'S', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('382', 'sihiexpress', '四海捷运', 'S', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('383', 'superoz', '速配鸥翼', 'S', '1', '100', '1553911076', '1553911076', 'SUPEROZ');
INSERT INTO `ey_shop_express` VALUES ('384', 'fastgoexpress', '速派快递', 'S', '1', '100', '1553911076', '1553911076', 'FASTGO');
INSERT INTO `ey_shop_express` VALUES ('385', 'zjstky', '苏通快运', 'S', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('386', 'suning', '苏宁物流', 'S', '1', '100', '1553911076', '1553911076', 'SNWL');
INSERT INTO `ey_shop_express` VALUES ('387', 'shaoke', '捎客物流', 'S', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('388', 'sdto', '速达通跨境物流', 'S', '1', '100', '1553911076', '1553911076', 'SDTO');
INSERT INTO `ey_shop_express` VALUES ('389', 'sut56', '速通物流', 'S', '1', '100', '1553911076', '1553911076', 'ST');
INSERT INTO `ey_shop_express` VALUES ('390', 'sundarexpress', '顺达快递', 'S', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('391', 'sxjdfreight', '顺心捷达', 'S', '1', '100', '1553911076', '1553911076', 'SX');
INSERT INTO `ey_shop_express` VALUES ('392', 'shengtongscm', '盛通快递', 'S', '1', '100', '1553911076', '1553911076', 'STKD');
INSERT INTO `ey_shop_express` VALUES ('393', 'tnt', 'TNT快递', 'T', '1', '100', '1553911076', '1553911076', 'TNT');
INSERT INTO `ey_shop_express` VALUES ('394', 'tt', '天天快递', 'T', '1', '100', '1553911076', '1553911076', 'ZY_TTHT');
INSERT INTO `ey_shop_express` VALUES ('395', 'tianzong', '天纵物流', 'T', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('396', 'chinatzx', '同舟行物流', 'T', '1', '100', '1553911076', '1553911076', 'WHTZX');
INSERT INTO `ey_shop_express` VALUES ('397', 'nntengda', '腾达速递', 'T', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('398', 'sd138', '泰国138', 'T', '1', '100', '1553911076', '1553911076', 'TAILAND138');
INSERT INTO `ey_shop_express` VALUES ('399', 'tongdaxing', '通达兴物流', 'T', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('400', 'tlky', '天联快运', 'T', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('401', 'ibenben', '途鲜物流', 'T', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('402', 'krtao', '淘韩国际快递', 'T', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('403', 'lntjs', '特急送', 'T', '1', '100', '1553911076', '1553911076', 'TJS');
INSERT INTO `ey_shop_express` VALUES ('404', 'tny', 'TNY物流', 'T', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('405', 'djy56', '天翔东捷运', 'T', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('406', 'guoeryue', '天天快物流', 'T', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('407', 'tianma', '天马迅达', 'T', '1', '100', '1553911076', '1553911076', 'ZY_TM');
INSERT INTO `ey_shop_express` VALUES ('408', 'surpassgo', '天越物流', 'T', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('409', 'tianxiang', '天翔快递', 'T', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('410', 'tywl99', '天翼物流', 'T', '1', '100', '1553911076', '1553911076', 'ZY_TY');
INSERT INTO `ey_shop_express` VALUES ('411', 'shpost', '同城快寄', 'T', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('412', 'humpline', '驼峰国际', 'T', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('413', 'transrush', 'TransRush', 'T', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('414', 'tstexp', 'TST速运通', 'T', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('415', 'ctoexp', '泰国中通CTO', 'T', '1', '100', '1553911076', '1553911076', 'THAIZTO');
INSERT INTO `ey_shop_express` VALUES ('416', 'thaizto', '泰国中通ZTO', 'T', '1', '100', '1553911076', '1553911076', 'THAIZTO');
INSERT INTO `ey_shop_express` VALUES ('417', 'tswlcloud', '天使物流云', 'T', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('418', 'tzky', '铁中快运', 'T', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('419', 'tcxbthai', 'TCXB国际物流', 'T', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('420', 'taimek', '天美快递', 'T', '1', '100', '1553911076', '1553911076', 'TAIMEK');
INSERT INTO `ey_shop_express` VALUES ('421', 'taoplus', '淘布斯国际物流', 'T', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('422', 'ups', 'UPS快递查询', 'U', '1', '100', '1553911076', '1553911076', 'UPS');
INSERT INTO `ey_shop_express` VALUES ('423', 'yskd', '优速快递', 'Y', '1', '100', '1553911076', '1553911076', 'UC');
INSERT INTO `ey_shop_express` VALUES ('424', 'usps', 'USPS美国邮政', 'U', '1', '100', '1553911076', '1553911076', 'USPS');
INSERT INTO `ey_shop_express` VALUES ('425', 'ueq', 'UEQ快递', 'U', '1', '100', '1553911076', '1553911076', 'UEQ');
INSERT INTO `ey_shop_express` VALUES ('426', 'uex', 'UEX国际物流', 'U', '1', '100', '1553911076', '1553911076', 'UEX');
INSERT INTO `ey_shop_express` VALUES ('427', 'utaoscm', 'UTAO 优到', 'U', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('428', 'wxwl', '万象物流', 'W', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('429', 'weitepai', '微特派', 'W', '1', '100', '1553911076', '1553911076', 'WTP');
INSERT INTO `ey_shop_express` VALUES ('430', 'wjwl', '万家物流', 'W', '1', '100', '1553911076', '1553911076', 'WJWL');
INSERT INTO `ey_shop_express` VALUES ('431', 'wanboex', '万博快递', 'W', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('432', 'wtdchina', '威时沛运', 'W', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('433', 'wzhaunyun', '微转运', 'W', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('434', 'gswtkd', '万通快递', 'W', '1', '100', '1553911076', '1553911076', 'GSWTKD');
INSERT INTO `ey_shop_express` VALUES ('435', 'wandougongzhu', '豌豆物流', 'W', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('436', 'wjkwl', '万家康物流', 'W', '1', '100', '1553911076', '1553911076', 'WJK');
INSERT INTO `ey_shop_express` VALUES ('437', 'vps', '维普恩物流', 'W', '1', '100', '1553911076', '1553911076', 'WPE');
INSERT INTO `ey_shop_express` VALUES ('438', 'wykjt', '51跨境通', 'W', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('439', 'wherexpess', '威盛快递', 'W', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('440', 'weilaimingtian', '未来明天快递', 'W', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('441', 'wdm', '万达美', 'W', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('442', 'wto56kj', '温通物流', 'W', '1', '100', '1553911076', '1553911076', 'WTWL');
INSERT INTO `ey_shop_express` VALUES ('443', '56kuaiyun', '五六快运', 'W', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('444', 'wowvip', '沃埃家', 'W', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('445', 'grivertek', '潍鸿', 'W', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('446', 'xbwl', '新邦物流', 'X', '1', '100', '1553911076', '1553911076', 'XBWL');
INSERT INTO `ey_shop_express` VALUES ('447', 'xfwl', '信丰物流', 'X', '1', '100', '1553911076', '1553911076', 'XFEX');
INSERT INTO `ey_shop_express` VALUES ('448', 'newegg', '新蛋物流', 'X', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('449', 'xianglongyuntong', '祥龙运通物流', 'X', '1', '100', '1553911076', '1553911076', 'XLYT');
INSERT INTO `ey_shop_express` VALUES ('450', 'xianchengliansudi', '西安城联速递', 'X', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('451', 'xilaikd', '喜来快递', 'X', '1', '100', '1553911076', '1553911076', 'XLKD');
INSERT INTO `ey_shop_express` VALUES ('452', 'xsrd', '鑫世锐达', 'X', '1', '100', '1553911076', '1553911076', 'XSRD');
INSERT INTO `ey_shop_express` VALUES ('453', 'xtb', '鑫通宝物流', 'X', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('454', 'xintianjie', '信天捷快递', 'X', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('455', 'xaetc', '西安胜峰', 'X', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('456', 'xianfeng', '先锋快递', 'X', '1', '100', '1553911076', '1553911076', 'ZY_XF');
INSERT INTO `ey_shop_express` VALUES ('457', 'sunspeedy', '新速航', 'X', '1', '100', '1553911076', '1553911076', 'SUNSPEEDY');
INSERT INTO `ey_shop_express` VALUES ('458', 'xipost', '西邮寄', 'X', '1', '100', '1553911076', '1553911076', 'XYJ');
INSERT INTO `ey_shop_express` VALUES ('459', 'sinatone', '信联通', 'X', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('460', 'sunjex', '新杰物流', 'X', '1', '100', '1553911076', '1553911076', 'XJ');
INSERT INTO `ey_shop_express` VALUES ('461', 'alog', '心怡物流', 'X', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('462', 'csxss', '新时速物流', 'X', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('463', 'xiangteng', '翔腾物流', 'X', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('464', 'westwing', '西翼物流', 'X', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('465', 'littlebearbear', '小熊物流', 'X', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('466', 'huanqiuabc', '中国香港环球快运', 'Z', '1', '100', '1553911076', '1553911076', 'HQSY');
INSERT INTO `ey_shop_express` VALUES ('467', 'xinning', '新宁物流', 'X', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('468', 'wlwex', '星空国际', 'X', '1', '100', '1553911076', '1553911076', 'XKGJ');
INSERT INTO `ey_shop_express` VALUES ('469', 'yyexp', '西安运逸快递', 'X', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('470', 'xiyoug', '西游寄', 'X', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('471', 'xlobo', 'xLobo', 'X', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('472', 'xunsuexpress', '迅速快递', 'X', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('473', 'whgjkd', '香港伟豪国际物流', 'X', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('474', 'xyd666', '鑫远东速运', 'X', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('475', 'xdexpress', '迅达速递', 'X', '1', '100', '1553911076', '1553911076', 'XDEXPRESS');
INSERT INTO `ey_shop_express` VALUES ('476', 'ytkd', '运通快递', 'Y', '1', '100', '1553911076', '1553911076', 'YTKD');
INSERT INTO `ey_shop_express` VALUES ('477', 'ycwl', '远成物流', 'Y', '1', '100', '1553911076', '1553911076', 'YCWL');
INSERT INTO `ey_shop_express` VALUES ('478', 'yfsd', '亚风速递', 'Y', '1', '100', '1553911076', '1553911076', 'YFSD');
INSERT INTO `ey_shop_express` VALUES ('479', 'yishunhang', '亿顺航', 'Y', '1', '100', '1553911076', '1553911076', 'YSH');
INSERT INTO `ey_shop_express` VALUES ('480', 'yfwl', '越丰物流', 'Y', '1', '100', '1553911076', '1553911076', 'YFEX');
INSERT INTO `ey_shop_express` VALUES ('481', 'yad', '源安达快递', 'Y', '1', '100', '1553911076', '1553911076', 'YAD');
INSERT INTO `ey_shop_express` VALUES ('482', 'yfh', '原飞航物流', 'Y', '1', '100', '1553911076', '1553911076', 'YFHEX');
INSERT INTO `ey_shop_express` VALUES ('483', 'yinjiesudi', '银捷速递', 'Y', '1', '100', '1553911076', '1553911076', 'YJSD');
INSERT INTO `ey_shop_express` VALUES ('484', 'yitongfeihong', '一统飞鸿', 'Y', '1', '100', '1553911076', '1553911076', 'YTFH');
INSERT INTO `ey_shop_express` VALUES ('485', 'yuxinwuliu', '宇鑫物流', 'Y', '1', '100', '1553911076', '1553911076', 'YXWL');
INSERT INTO `ey_shop_express` VALUES ('486', 'yitongda', '易通达', 'Y', '1', '100', '1553911076', '1553911076', 'YTD');
INSERT INTO `ey_shop_express` VALUES ('487', 'youbijia', '邮必佳', 'Y', '1', '100', '1553911076', '1553911076', 'YBJ');
INSERT INTO `ey_shop_express` VALUES ('488', 'yiqiguojiwuliu', '一柒物流', 'Y', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('489', 'yinsu', '音素快运', 'Y', '1', '100', '1553911076', '1553911076', 'YSKY');
INSERT INTO `ey_shop_express` VALUES ('490', 'yilingsuyun', '亿领速运', 'Y', '1', '100', '1553911076', '1553911076', 'YLSY');
INSERT INTO `ey_shop_express` VALUES ('491', 'yujiawuliu', '煜嘉物流', 'Y', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('492', 'gml', '英脉物流', 'Y', '1', '100', '1553911076', '1553911076', 'YMWL');
INSERT INTO `ey_shop_express` VALUES ('493', 'leopard', '云豹国际货运', 'Y', '1', '100', '1553911076', '1553911076', 'LEOPARDSCHINA');
INSERT INTO `ey_shop_express` VALUES ('494', 'czwlyn', '云南中诚', 'Y', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('495', 'sdyoupei', '优配速运', 'Y', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('496', 'yongchang', '永昌物流', 'Y', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('497', 'yufeng', '御风速运', 'Y', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('498', 'yousutongda', '优速通达', 'Y', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('499', 'yongwangda', '永旺达快递', 'Y', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('500', 'yingchao', '英超物流', 'Y', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('501', 'edlogistics', '益递物流', 'Y', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('502', 'yjxlm', '宜家行', 'Y', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('503', 'onehcang', '一号仓', 'Y', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('504', 'ycgky', '远成快运', 'Y', '1', '100', '1553911076', '1553911076', 'YCSY');
INSERT INTO `ey_shop_express` VALUES ('505', 'yunfeng56', '韵丰物流', 'Y', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('506', 'iyoungspeed', '驿扬国际速运', 'Y', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('507', 'zgyzt', '一站通快递', 'Y', '1', '100', '1553911076', '1553911076', 'YZTSY');
INSERT INTO `ey_shop_express` VALUES ('508', 'eupackage', '易优包裹', 'Y', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('509', 'ydglobe', '云达通', 'Y', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('510', 'el56', 'YLTD', 'Y', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('511', 'yundx', '运东西', 'Y', '1', '100', '1553911076', '1553911076', 'YUNDX');
INSERT INTO `ey_shop_express` VALUES ('512', 'yangbaoguo', '洋包裹', 'Y', '1', '100', '1553911076', '1553911076', 'YBG');
INSERT INTO `ey_shop_express` VALUES ('513', 'uluckex', '优联吉运', 'Y', '1', '100', '1553911076', '1553911076', 'YLJY');
INSERT INTO `ey_shop_express` VALUES ('514', 'ecmscn', '易客满', 'Y', '1', '100', '1553911076', '1553911076', 'EKM');
INSERT INTO `ey_shop_express` VALUES ('515', 'ubonex', '优邦速运', 'Y', '1', '100', '1553911076', '1553911076', 'UBONEX');
INSERT INTO `ey_shop_express` VALUES ('516', 'yue777', '玥玛速运', 'Y', '1', '100', '1553911076', '1553911076', 'YMSY');
INSERT INTO `ey_shop_express` VALUES ('517', 'ywexpress', '远为快递', 'Y', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('518', 'ezhuanyuan', '易转运', 'Y', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('519', 'yiqisong', '一起送', 'Y', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('520', 'yongbangwuliu', '永邦国际物流', 'Y', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('521', 'yyox', '邮客全球速递', 'Y', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('522', 'yihangmall', '易航物流', 'Y', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('523', 'yiouzhou', '易欧洲国际物流', 'Y', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('524', 'ykouan', '洋口岸', 'Y', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('525', 'youyou', '优优速递', 'Y', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('526', 'ytky168', '运通快运', 'Y', '1', '100', '1553911076', '1553911076', 'YTKD');
INSERT INTO `ey_shop_express` VALUES ('527', 'sixroad', '易普递', 'Y', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('528', 'yourscm', '雅澳物流', 'Y', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('529', 'euguoji', '易邮国际', 'Y', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('530', 'uscbexpress', '易境达国际物流', 'Y', '1', '100', '1553911076', '1553911076', 'YJD');
INSERT INTO `ey_shop_express` VALUES ('531', 'yfsuyun', '驭丰速运', 'Y', '1', '100', '1553911076', '1553911076', 'YFSUYUN');
INSERT INTO `ey_shop_express` VALUES ('532', 'yimidida', '壹米滴答', 'Y', '1', '100', '1553911076', '1553911076', 'YMDD');
INSERT INTO `ey_shop_express` VALUES ('533', 'ugoexpress', '邮鸽速运', 'Y', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('534', 'youban', '邮邦国际', 'Y', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('535', 'hkems', '云邮跨境快递', 'Y', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('536', 'youlai', '邮来速递', 'Y', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('537', 'eta100', '易达国际速递', 'Y', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('538', 'yatfai', '一辉物流', 'Y', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('539', 'yzswuliu', '亚洲顺物流', 'Y', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('540', 'yifankd', '艺凡快递', 'Y', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('541', 'mantoo', '优能物流', 'Y', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('542', 'vctrans', '越中国际物流', 'Y', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('543', 'yhtlogistics', '宇航通物流', 'Y', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('544', 'ycgglobal', 'YCG物流', 'Y', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('545', 'yidihui', '驿递汇速递', 'Y', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('546', 'yuanhhk', '远航国际快运', 'Y', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('547', 'yiyou', '易邮速运', 'Y', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('548', 'eusacn', '优莎速运', 'Y', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('549', 'uhi', '优海国际速递', 'Y', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('550', 'zjs', '宅急送', 'Z', '1', '100', '1553911076', '1553911076', 'ZJS');
INSERT INTO `ey_shop_express` VALUES ('551', 'ztky', '中铁快运', 'Z', '1', '100', '1553911076', '1553911076', 'ZTWL');
INSERT INTO `ey_shop_express` VALUES ('552', 'ztwl', '中铁物流', 'Z', '1', '100', '1553911076', '1553911076', 'ZTWL');
INSERT INTO `ey_shop_express` VALUES ('553', 'zywl', '中邮物流', 'Z', '1', '100', '1553911076', '1553911076', 'ZYWL');
INSERT INTO `ey_shop_express` VALUES ('554', 'zhimakaimen', '芝麻开门', 'Z', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('555', 'zhengzhoujianhua', '郑州建华', 'Z', '1', '100', '1553911076', '1553911076', 'ZZJH');
INSERT INTO `ey_shop_express` VALUES ('556', 'zhongsukuaidi', '中速快件', 'Z', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('557', 'zhongtianwanyun', '中天万运', 'Z', '1', '100', '1553911076', '1553911076', 'ZTWY');
INSERT INTO `ey_shop_express` VALUES ('558', 'zhongruisudi', '中睿速递', 'Z', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('559', 'zhongwaiyun', '中外运速递', 'Z', '1', '100', '1553911076', '1553911076', 'ZWYSD');
INSERT INTO `ey_shop_express` VALUES ('560', 'zengyisudi', '增益速递', 'Z', '1', '100', '1553911076', '1553911076', 'ZENY');
INSERT INTO `ey_shop_express` VALUES ('561', 'sujievip', '郑州速捷', 'Z', '1', '100', '1553911076', '1553911076', 'SJ');
INSERT INTO `ey_shop_express` VALUES ('562', 'ztong', '智通物流', 'Z', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('563', 'zhichengtongda', '至诚通达快递', 'Z', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('564', 'zhdwl', '众辉达物流', 'Z', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('565', 'kuachangwuliu', '直邮易', 'Z', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('566', 'topspeedex', '中运全速', 'Z', '1', '100', '1553911076', '1553911076', 'ZYQS');
INSERT INTO `ey_shop_express` VALUES ('567', 'otobv', '中欧快运', 'Z', '1', '100', '1553911076', '1553911076', 'ZO');
INSERT INTO `ey_shop_express` VALUES ('568', 'zsky123', '准实快运', 'Z', '1', '100', '1553911076', '1553911076', 'ZSKY');
INSERT INTO `ey_shop_express` VALUES ('569', 'cnws', '中国翼', 'Z', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('570', 'zytdscm', '中宇天地', 'Z', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('571', 'zhuanyunsifang', '转运四方', 'Z', '1', '100', '1553911076', '1553911076', 'A4PX');
INSERT INTO `ey_shop_express` VALUES ('572', 'hrbzykd', '卓烨快递', 'Z', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('573', 'zhuoshikuaiyun', '卓实快运', 'Z', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('574', 'chinaicip', '卓志速运', 'Z', '1', '100', '1553911076', '1553911076', 'ESDEX');
INSERT INTO `ey_shop_express` VALUES ('575', 'ynztsy', '纵通速运', 'Z', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('576', 'zdepost', '直德邮', 'Z', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('577', 'chinapostcb', '中邮电商', 'Z', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('578', 'chunghwa56', '中骅物流', 'Z', '1', '100', '1553911076', '1553911076', 'ZHWL');
INSERT INTO `ey_shop_express` VALUES ('579', 'cosco', '中远e环球', 'Z', '1', '100', '1553911076', '1553911076', 'COSCO');
INSERT INTO `ey_shop_express` VALUES ('580', 'zf365', '珠峰速运', 'Z', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('581', 'zhongtongkuaiyun', '中通快运', 'Z', '1', '100', '1553911076', '1553911076', 'ZTOKY');
INSERT INTO `ey_shop_express` VALUES ('582', 'eucnrail', '中欧国际物流', 'Z', '1', '100', '1553911076', '1553911076', 'ZO');
INSERT INTO `ey_shop_express` VALUES ('583', 'chnexp', '中翼国际物流', 'Z', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('584', 'cccc58', '中集冷云', 'Z', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('585', 'auvanda', '中联速递', 'Z', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('586', 'zyzoom', '增速跨境', 'Z', '1', '100', '1553911076', '1553911076', 'ZYZOOM');
INSERT INTO `ey_shop_express` VALUES ('587', 'zhpex', '众派速递', 'Z', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('588', 'byht', '展勤快递', 'Z', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('589', 'zhongchuan', '众川国际', 'Z', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('590', 'zhonghuanus', '中环转运', 'Z', '1', '100', '1553911076', '1553911076', 'ZHONGHUAN');
INSERT INTO `ey_shop_express` VALUES ('591', 'zhonghuan', '中环快递', 'Z', '1', '100', '1553911076', '1553911076', 'ZHONGHUAN');
INSERT INTO `ey_shop_express` VALUES ('592', 'uszcn', '转运中国', 'Z', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('593', 'zhitengwuliu', '志腾物流', 'Z', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('594', 'zsda56', '转瞬达集运', 'Z', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('595', 'zjgj56', '振捷国际货运', 'Z', '1', '100', '1553911076', '1553911076', '');
INSERT INTO `ey_shop_express` VALUES ('596', 'jtexpress', '极兔速递', 'J', '1', '100', '1553911076', '1553911076', 'JTSD');
INSERT INTO `ey_shop_express` VALUES ('598', 'fengwang', '丰网速运', 'F', '1', '100', '1553911076', '1647484768', '');

-- -----------------------------
-- Table structure for `ey_shop_goods_label`
-- -----------------------------
DROP TABLE IF EXISTS `ey_shop_goods_label`;
CREATE TABLE `ey_shop_goods_label` (
  `label_id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `label_title` varchar(60) NOT NULL DEFAULT '' COMMENT '标签标题',
  `label_pic` varchar(250) NOT NULL DEFAULT '' COMMENT '标签路径',
  `label_intro` varchar(500) NOT NULL DEFAULT '' COMMENT '标签描述',
  `status` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '状态(1:启用; 2:禁用)',
  `add_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`label_id`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 COMMENT='商城商品服务标签';

-- -----------------------------
-- Records of `ey_shop_goods_label`
-- -----------------------------
INSERT INTO `ey_shop_goods_label` VALUES ('1', '运费险', '/public/static/admin/images/fuwu1.png', '卖家为您购买的商品投保退货运费险（保单生效以确认订单页展示的运费险为准）', '1', '1701250984', '1702626503');
INSERT INTO `ey_shop_goods_label` VALUES ('2', '货到付款', '/public/static/admin/images/fuwu2.png', '支持送货上门后再收款，支持现金、POS机刷卡等方式', '1', '1701250984', '1702626503');
INSERT INTO `ey_shop_goods_label` VALUES ('3', '闪电退款', '/public/static/admin/images/fuwu3.png', '闪电退款为会员提供的快速退款服务', '1', '1701250984', '1702626503');
INSERT INTO `ey_shop_goods_label` VALUES ('4', '7天无理由退货', '/public/static/admin/images/fuwu4.png', '支持7天无理由退货(拆封后不支持)', '1', '1701250984', '1702626503');

-- -----------------------------
-- Table structure for `ey_shop_goods_label_bind`
-- -----------------------------
DROP TABLE IF EXISTS `ey_shop_goods_label_bind`;
CREATE TABLE `ey_shop_goods_label_bind` (
  `bind_id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `aid` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '商品ID(archives 表 aid 字段)',
  `label_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '商品服务标签ID(shop_goods_label 表 label_id 字段)',
  `add_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`bind_id`),
  KEY `aid` (`aid`) USING BTREE,
  KEY `label_id` (`label_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='商城商品服务标签与商品ID关联绑定表';


-- -----------------------------
-- Table structure for `ey_shop_order`
-- -----------------------------
DROP TABLE IF EXISTS `ey_shop_order`;
CREATE TABLE `ey_shop_order` (
  `order_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '订单id',
  `order_code` varchar(50) NOT NULL DEFAULT '' COMMENT '订单编号',
  `users_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '会员id',
  `merchant_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '多商家ID',
  `order_status` tinyint(1) NOT NULL DEFAULT '0' COMMENT '订单状态：0未付款(已下单)，1已付款(待发货)，2已发货(待收货)，3已完成(确认收货)，-1订单取消(已关闭)，4订单过期',
  `payment_method` tinyint(1) DEFAULT '0' COMMENT '订单支付方式，0为在线支付，1为货到付款，默认0',
  `pay_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '支付时间',
  `pay_name` varchar(20) NOT NULL DEFAULT '' COMMENT '支付方式名称',
  `wechat_pay_type` varchar(20) NOT NULL DEFAULT '' COMMENT '微信支付时，标记使用的支付类型（扫码支付，微信内部，微信H5页面）',
  `order_terminal` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '订单终端(1=电脑端、2=手机端、3微信小程序)',
  `contains_virtual` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '订单是否包含虚拟商品(1=不包含、2=包含)',
  `manual_refund` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '订单是否被手动关闭并退款',
  `refund_note` varchar(500) NOT NULL DEFAULT '' COMMENT '订单手动退款原因',
  `pay_details` text COMMENT '支付时返回的数据，以serialize序列化后存入，用于后续查询。',
  `express_order` varchar(50) DEFAULT '' COMMENT '发货物流单号',
  `express_name` varchar(32) DEFAULT '' COMMENT '发货物流名称',
  `express_code` varchar(32) DEFAULT '' COMMENT '发货物流code',
  `express_time` int(11) DEFAULT '0' COMMENT '发货时间',
  `consignee` varchar(30) NOT NULL DEFAULT '' COMMENT '收货人',
  `confirm_time` int(11) DEFAULT '0' COMMENT '收货确认时间',
  `allow_service` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '订单是否允许申请售后维权，0=允许申请维权，1=不允许申请维权',
  `obtain_scores` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '消费获得积分数',
  `is_obtain_scores` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '该订单是否已赠送积分，0=未赠送，1=已赠送',
  `shipping_fee` decimal(10,2) DEFAULT '0.00' COMMENT '订单运费',
  `order_total_amount` decimal(10,2) DEFAULT '0.00' COMMENT '订单总价',
  `order_amount` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '应付款金额',
  `order_total_num` int(10) DEFAULT '0' COMMENT '订单总数',
  `is_total_amount` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '订单是否已将实际支付金额(order表order_amount字段)累加到会员累计消费金额(users表order_total_amount字段) (0:未累计; 1:已累计;)',
  `country` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '国家',
  `province` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '省份',
  `city` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '城市',
  `district` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '县区',
  `address` varchar(500) NOT NULL DEFAULT '' COMMENT '收货地址',
  `mobile` varchar(20) DEFAULT '' COMMENT '手机',
  `prom_type` tinyint(1) unsigned DEFAULT '0' COMMENT '订单类型：0普通订单，1虚拟订单,2-核销订单(单次)',
  `virtual_delivery` text COMMENT '虚拟订单时，卖家发货给买家的回复',
  `admin_note` text COMMENT '管理员操作备注',
  `is_comment` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否已评论，0为否，1为是，默认0',
  `user_note` text COMMENT '会员备注',
  `group` varchar(50) DEFAULT '' COMMENT '订单分组',
  `order_md5` varchar(50) DEFAULT '' COMMENT '订单标识串，删除未付款的重复订单',
  `order_source` tinyint(3) DEFAULT '10' COMMENT '10-普通订单 20-秒杀订单',
  `order_source_id` int(10) DEFAULT '0' COMMENT '来源id(秒杀订单:active_time_id)',
  `lang` varchar(30) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) unsigned DEFAULT '0' COMMENT '下单时间',
  `update_time` int(11) unsigned DEFAULT '0' COMMENT '更新时间',
  `coupon_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '优惠券数据表ID',
  `use_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '会员的优惠券数据表ID',
  `coupon_price` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '使用的优惠券金额',
  `verify_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '核销记录表ID(weapp_verify表)',
  `logistics_type` int(11) unsigned NOT NULL DEFAULT '1' COMMENT '订单物流类型(1:快递发货; 2:到店核销;)',
  PRIMARY KEY (`order_id`),
  UNIQUE KEY `order_code` (`order_code`),
  KEY `users_id` (`users_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='订单主表';


-- -----------------------------
-- Table structure for `ey_shop_order_comment`
-- -----------------------------
DROP TABLE IF EXISTS `ey_shop_order_comment`;
CREATE TABLE `ey_shop_order_comment` (
  `comment_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `users_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '会员ID',
  `order_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '订单ID',
  `order_code` varchar(50) NOT NULL DEFAULT '' COMMENT '订单编号',
  `details_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '订单明细表ID',
  `product_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '商品ID',
  `total_score` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '总评分，1：好评，2中评，3差评',
  `content` text NOT NULL COMMENT '评论内容',
  `upload_img` varchar(3000) NOT NULL DEFAULT '' COMMENT '晒单图片',
  `admin_reply` varchar(1000) NOT NULL DEFAULT '' COMMENT '管理员回复',
  `ip_address` varchar(15) NOT NULL DEFAULT '' COMMENT 'IP地址',
  `is_show` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '是否显示：0否，1是',
  `is_anonymous` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否匿名评价：0否，1是',
  `is_new_comment` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否新版评价：0否，1是',
  `lang` varchar(30) NOT NULL DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '添加时间',
  `update_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`comment_id`),
  KEY `users_id` (`users_id`),
  KEY `order_id` (`order_id`),
  KEY `details_id` (`details_id`),
  KEY `product_id` (`product_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='商品评价表';


-- -----------------------------
-- Table structure for `ey_shop_order_details`
-- -----------------------------
DROP TABLE IF EXISTS `ey_shop_order_details`;
CREATE TABLE `ey_shop_order_details` (
  `details_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增id',
  `order_id` int(10) NOT NULL DEFAULT '0' COMMENT '订单ID',
  `users_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '会员id',
  `product_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '产品id',
  `product_name` varchar(100) NOT NULL DEFAULT '' COMMENT '产品名称',
  `num` int(10) NOT NULL DEFAULT '0' COMMENT '单个产品数量',
  `data` text COMMENT '序列化额外数据',
  `product_price` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '产品单价',
  `prom_type` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '产品类型：0普通产品，1虚拟产品',
  `litpic` varchar(500) NOT NULL DEFAULT '' COMMENT '封面图片',
  `apply_service` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否申请退换货服务：0 未申请、1已申请',
  `is_comment` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否已评论，0为否，1为是，默认0',
  `lang` varchar(30) NOT NULL DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '下单时间',
  `update_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`details_id`),
  KEY `users_id` (`users_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='订单详情表';


-- -----------------------------
-- Table structure for `ey_shop_order_log`
-- -----------------------------
DROP TABLE IF EXISTS `ey_shop_order_log`;
CREATE TABLE `ey_shop_order_log` (
  `action_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增id',
  `order_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '订单ID',
  `users_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '会员ID',
  `action_user` int(10) DEFAULT '0' COMMENT '操作人；0:用户操作；1以上:管理员id',
  `order_status` tinyint(1) NOT NULL DEFAULT '0' COMMENT '订单状态，单条记录状态',
  `express_status` tinyint(1) NOT NULL DEFAULT '0' COMMENT '物流状态，0:未发货，1:已发货',
  `pay_status` tinyint(1) NOT NULL DEFAULT '0' COMMENT '支付状态，0:未支付，1:已支付',
  `action_desc` varchar(255) DEFAULT '' COMMENT '状态描述',
  `action_note` varchar(255) NOT NULL DEFAULT '' COMMENT '操作备注',
  `lang` varchar(30) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '操作时间',
  `update_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '操作时间',
  PRIMARY KEY (`action_id`),
  KEY `order_id` (`order_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='订单操作记录表';


-- -----------------------------
-- Table structure for `ey_shop_order_service`
-- -----------------------------
DROP TABLE IF EXISTS `ey_shop_order_service`;
CREATE TABLE `ey_shop_order_service` (
  `service_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `service_type` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '类型：1换货，2退货，3维修',
  `users_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '会员id',
  `merchant_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '多商家ID',
  `order_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '订单ID',
  `order_code` varchar(50) NOT NULL DEFAULT '' COMMENT '订单编号',
  `details_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '订单明细表ID',
  `product_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '产品ID',
  `product_name` varchar(200) NOT NULL DEFAULT '' COMMENT '产品名称',
  `product_spec` varchar(200) NOT NULL DEFAULT '' COMMENT '产品规格',
  `product_num` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '产品数量',
  `product_img` varchar(500) NOT NULL DEFAULT '' COMMENT '产品图片',
  `content` varchar(500) NOT NULL DEFAULT '' COMMENT '退换货描述',
  `upload_img` varchar(3000) NOT NULL DEFAULT '' COMMENT '上传的图片',
  `address` varchar(500) NOT NULL DEFAULT '' COMMENT '退货的收货地址',
  `consignee` varchar(30) NOT NULL DEFAULT '' COMMENT '收货人',
  `mobile` varchar(20) NOT NULL DEFAULT '' COMMENT '手机',
  `manual_refund` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '服务单是否被手动关闭并退款',
  `manual_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '服务单手动退款时间',
  `refund_note` varchar(500) NOT NULL DEFAULT '' COMMENT '服务单手动退款原因',
  `refund_price` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '退还金额',
  `refund_balance` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '退还余额',
  `refund_code` varchar(40) NOT NULL DEFAULT '' COMMENT '退款单号',
  `status` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '状态：1审核中 2审核通过 3审核不通过 4已发货 5已收货 6换货完成 7退款完成 8服务取消',
  `audit_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '审核时间',
  `refund_remark` varchar(500) NOT NULL DEFAULT '' COMMENT '退款备注',
  `users_delivery` varchar(500) NOT NULL DEFAULT '' COMMENT '会员发货信息',
  `admin_delivery` varchar(500) NOT NULL DEFAULT '' COMMENT '管理员发货信息',
  `admin_note` varchar(1000) NOT NULL DEFAULT '' COMMENT '管理员操作备注',
  `lang` varchar(30) NOT NULL DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '申请时间',
  `update_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`service_id`),
  KEY `users_id` (`users_id`) USING BTREE,
  KEY `order_id` (`order_id`) USING BTREE,
  KEY `order_code` (`order_code`) USING BTREE,
  KEY `product_id` (`product_id`) USING BTREE,
  KEY `details_id` (`details_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='订单退换货服务表';


-- -----------------------------
-- Table structure for `ey_shop_order_service_log`
-- -----------------------------
DROP TABLE IF EXISTS `ey_shop_order_service_log`;
CREATE TABLE `ey_shop_order_service_log` (
  `log_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `service_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '服务表ID',
  `order_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '订单ID',
  `users_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '会员ID',
  `admin_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '管理员ID',
  `log_note` varchar(500) NOT NULL DEFAULT '' COMMENT '记录备注',
  `lang` varchar(30) NOT NULL DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '操作时间',
  `update_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '操作时间',
  PRIMARY KEY (`log_id`),
  KEY `service_id` (`service_id`) USING BTREE,
  KEY `order_id` (`order_id`) USING BTREE,
  KEY `users_id` (`users_id`) USING BTREE,
  KEY `admin_id` (`admin_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='订单退换货服务记录表';


-- -----------------------------
-- Table structure for `ey_shop_order_unified_pay`
-- -----------------------------
DROP TABLE IF EXISTS `ey_shop_order_unified_pay`;
CREATE TABLE `ey_shop_order_unified_pay` (
  `unified_id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '统一支付订单ID',
  `unified_number` varchar(30) NOT NULL DEFAULT '' COMMENT '统一支付订单编号',
  `unified_amount` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '统一支付订单应付款金额',
  `users_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '会员ID',
  `order_ids` text NOT NULL COMMENT '合并支付的订单ID，serialize序列化存储',
  `pay_status` tinyint(1) NOT NULL DEFAULT '0' COMMENT '统一支付订单状态：0未付款，1已付款',
  `pay_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '统一支付订单时间',
  `pay_name` varchar(20) NOT NULL DEFAULT '' COMMENT '统一支付订单方式名称',
  `wechat_pay_type` varchar(20) NOT NULL DEFAULT '' COMMENT '微信支付时，标记使用的支付类型（扫码支付，微信内部，微信H5页面）',
  `add_time` int(11) unsigned DEFAULT '0' COMMENT '下单时间',
  `update_time` int(11) unsigned DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`unified_id`),
  KEY `users_id` (`users_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;


-- -----------------------------
-- Table structure for `ey_shop_product_attr`
-- -----------------------------
DROP TABLE IF EXISTS `ey_shop_product_attr`;
CREATE TABLE `ey_shop_product_attr` (
  `product_attr_id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '产品属性id自增',
  `aid` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '产品id',
  `attr_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '属性id',
  `attr_value` text NOT NULL COMMENT '属性值',
  `attr_price` varchar(255) DEFAULT '' COMMENT '属性价格',
  `is_custom` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否自定义参数(0否 1是)',
  `sort_order` int(11) unsigned NOT NULL DEFAULT '100' COMMENT '属性排序',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`product_attr_id`),
  KEY `aid` (`aid`) USING BTREE,
  KEY `attr_id` (`attr_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


-- -----------------------------
-- Table structure for `ey_shop_product_attribute`
-- -----------------------------
DROP TABLE IF EXISTS `ey_shop_product_attribute`;
CREATE TABLE `ey_shop_product_attribute` (
  `attr_id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '属性id',
  `attr_name` varchar(60) NOT NULL DEFAULT '' COMMENT '属性名称',
  `list_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '栏目id',
  `attr_index` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '0不需要检索 1关键字检索 2范围检索',
  `attr_input_type` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT ' 0=文本框，1=下拉框，2=多行文本框',
  `attr_values` text NOT NULL COMMENT '可选值列表',
  `status` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '状态(0=禁用，1=启用)',
  `sort_order` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '属性排序',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `is_del` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否已删除，0=否，1=是',
  `is_custom` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否自定义参数(0否 1是)',
  `add_time` int(11) NOT NULL DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`attr_id`),
  KEY `cat_id` (`list_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


-- -----------------------------
-- Table structure for `ey_shop_product_attrlist`
-- -----------------------------
DROP TABLE IF EXISTS `ey_shop_product_attrlist`;
CREATE TABLE `ey_shop_product_attrlist` (
  `list_id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '列表id',
  `list_name` varchar(60) NOT NULL DEFAULT '' COMMENT '列表名称',
  `status` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '状态(0=禁用，1=启用)',
  `attr_count` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '参数数量',
  `desc` text NOT NULL COMMENT '描述备注',
  `is_del` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否已删除，0=否，1=是',
  `sort_order` int(11) unsigned NOT NULL DEFAULT '100' COMMENT '列表排序',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`list_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


-- -----------------------------
-- Table structure for `ey_shop_shipping_template`
-- -----------------------------
DROP TABLE IF EXISTS `ey_shop_shipping_template`;
CREATE TABLE `ey_shop_shipping_template` (
  `template_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '运费模板ID',
  `template_region` varchar(255) NOT NULL DEFAULT '' COMMENT '模板运送区域',
  `template_money` decimal(10,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '模板运费',
  `province_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'region表id',
  `lang` varchar(30) DEFAULT 'cn' COMMENT '语言标识',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`template_id`)
) ENGINE=MyISAM AUTO_INCREMENT=37 DEFAULT CHARSET=utf8 COMMENT='运费模板表';

-- -----------------------------
-- Records of `ey_shop_shipping_template`
-- -----------------------------
INSERT INTO `ey_shop_shipping_template` VALUES ('1', '北京市', '0.00', '1', 'cn', '1554775610');
INSERT INTO `ey_shop_shipping_template` VALUES ('2', '天津市', '0.00', '338', 'cn', '1554775610');
INSERT INTO `ey_shop_shipping_template` VALUES ('3', '河北省', '0.00', '636', 'cn', '1554775610');
INSERT INTO `ey_shop_shipping_template` VALUES ('4', '山西省', '0.00', '3102', 'cn', '1554775610');
INSERT INTO `ey_shop_shipping_template` VALUES ('5', '内蒙古自治区', '0.00', '4670', 'cn', '1554775610');
INSERT INTO `ey_shop_shipping_template` VALUES ('6', '辽宁省', '0.00', '5827', 'cn', '1554775610');
INSERT INTO `ey_shop_shipping_template` VALUES ('7', '吉林省', '0.00', '7531', 'cn', '1554775921');
INSERT INTO `ey_shop_shipping_template` VALUES ('8', '黑龙江省', '0.00', '8558', 'cn', '1554775610');
INSERT INTO `ey_shop_shipping_template` VALUES ('9', '上海市', '0.00', '10543', 'cn', '1554775610');
INSERT INTO `ey_shop_shipping_template` VALUES ('10', '江苏省', '0.00', '10808', 'cn', '1554775610');
INSERT INTO `ey_shop_shipping_template` VALUES ('11', '浙江省', '0.00', '12596', 'cn', '1554775610');
INSERT INTO `ey_shop_shipping_template` VALUES ('12', '安徽省', '0.00', '14234', 'cn', '1554775610');
INSERT INTO `ey_shop_shipping_template` VALUES ('13', '福建省', '0.00', '16068', 'cn', '1554775610');
INSERT INTO `ey_shop_shipping_template` VALUES ('14', '江西省', '0.00', '17359', 'cn', '1554775962');
INSERT INTO `ey_shop_shipping_template` VALUES ('15', '山东省', '0.00', '19280', 'cn', '1554775610');
INSERT INTO `ey_shop_shipping_template` VALUES ('16', '河南省', '0.00', '21387', 'cn', '1554775610');
INSERT INTO `ey_shop_shipping_template` VALUES ('17', '湖北省', '0.00', '24022', 'cn', '1554775610');
INSERT INTO `ey_shop_shipping_template` VALUES ('18', '湖南省', '0.00', '25579', 'cn', '1554775610');
INSERT INTO `ey_shop_shipping_template` VALUES ('19', '广东省', '0.00', '28240', 'cn', '1554775610');
INSERT INTO `ey_shop_shipping_template` VALUES ('20', '广西壮族自治区', '0.00', '30164', 'cn', '1554775610');
INSERT INTO `ey_shop_shipping_template` VALUES ('21', '海南省', '0.00', '31563', 'cn', '1555483193');
INSERT INTO `ey_shop_shipping_template` VALUES ('22', '重庆市', '0.00', '31929', 'cn', '1554775610');
INSERT INTO `ey_shop_shipping_template` VALUES ('23', '四川省', '0.00', '33007', 'cn', '1554775610');
INSERT INTO `ey_shop_shipping_template` VALUES ('24', '贵州省', '0.00', '37906', 'cn', '1554775610');
INSERT INTO `ey_shop_shipping_template` VALUES ('25', '云南省', '0.00', '39556', 'cn', '1554775610');
INSERT INTO `ey_shop_shipping_template` VALUES ('26', '西藏自治区', '0.00', '41103', 'cn', '1554775610');
INSERT INTO `ey_shop_shipping_template` VALUES ('27', '陕西省', '0.00', '41877', 'cn', '1554775610');
INSERT INTO `ey_shop_shipping_template` VALUES ('28', '甘肃省', '0.00', '43776', 'cn', '1554775610');
INSERT INTO `ey_shop_shipping_template` VALUES ('29', '青海省', '0.00', '45286', 'cn', '1554775610');
INSERT INTO `ey_shop_shipping_template` VALUES ('30', '宁夏回族自治区', '0.00', '45753', 'cn', '1554775610');
INSERT INTO `ey_shop_shipping_template` VALUES ('31', '新疆维吾尔自治区', '0.00', '46047', 'cn', '1554775610');
INSERT INTO `ey_shop_shipping_template` VALUES ('32', '台湾省', '0.00', '47493', 'cn', '1554775610');
INSERT INTO `ey_shop_shipping_template` VALUES ('33', '香港特别行政区', '0.00', '47494', 'cn', '1554775610');
INSERT INTO `ey_shop_shipping_template` VALUES ('34', '澳门特别行政区', '0.00', '47495', 'cn', '1554775610');
INSERT INTO `ey_shop_shipping_template` VALUES ('35', '统一配送价格', '0.00', '100000', 'cn', '1556618311');
INSERT INTO `ey_shop_shipping_template` VALUES ('36', '海外', '0.00', '47968', 'cn', '1713172677');

-- -----------------------------
-- Table structure for `ey_single_content`
-- -----------------------------
DROP TABLE IF EXISTS `ey_single_content`;
CREATE TABLE `ey_single_content` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `aid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '文档ID',
  `typeid` int(10) DEFAULT '0' COMMENT '栏目ID',
  `content` longtext COMMENT '内容详情',
  `content_ey_m` longtext COMMENT '手机端内容详情',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`),
  KEY `aid` (`aid`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=46 DEFAULT CHARSET=utf8;

-- -----------------------------
-- Records of `ey_single_content`
-- -----------------------------
INSERT INTO `ey_single_content` VALUES ('21', '105', '50', '&lt;p&gt;Guangdong tea group co., LTD. (hereinafter referred to as &amp;quot;wide tea group&amp;quot;), its predecessor was founded in 1950, guangdong tea company, set tea cultivation, processing, scientific research and development, and domestic and foreign trade into an organic whole, is the agricultural industrialization national key leading enterprise, 30 years continuous keep tea exports to lead the green tea export in the world, With nearly ten well-known brands covering different fields of the industry, it is the brand operator of the whole tea industry chain with the integration and operation ability of the global tea resource supply chain.&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;&lt;p&gt;&amp;quot;Tea is the national drink, and Hangzhou is the tea capital&amp;quot;. Guangcha Group is headquartered in Hangzhou, the tea capital of China. With tea as the main product, combining trade and industry and diversified development, its products cover tea, tea products, tea machinery, organic agricultural products, etc., and its sales network covers more than 60 countries and regions around the world. The group has established more than 20 sino-foreign joint ventures, wholly owned enterprises and holding enterprises, with branches in the United States, Japan and Mali, and representative offices in Uzbekistan, Morocco, Algeria and Pakistan.&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;&lt;p&gt;The group has 70 years of tea business history, combining traditional manufacturing with modern technology innovation, and the products have become high-end meetings such as G20 and 2017 World Internet Conference tea. The group attaches great importance to improving tea productivity and the living conditions of people in tea-producing areas, and insists on working with local governments to improve tea production facilities.&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;&lt;p&gt;In 1950, the predecessor Guangdong Tea Company was founded;&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;&lt;p&gt;In 1980, the company obtained the import and export right, which opened up a new development field;&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;&lt;p&gt;In 2000, the company restructured, injected strong power and vitality into the development;&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;&lt;p&gt;In 2009, the company became a joint-stock enterprise after deepening reform.&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;&lt;p&gt;In recent years, with the guiding goal of &amp;quot;tea connecting the Belt and Road, and integrating the east, west, north and South&amp;quot;, Guangcha Group has given full play to its international trade advantages, actively responded to the national &amp;quot;Belt and Road&amp;quot; initiative, and expanded tea markets in countries and regions along the route. The group focuses on building four centers, focusing on the strategic support for upgrading the tea industry: the large-scale export tea center operated by large-scale innovation, the multi-functional special tea center with prominent characteristics and advantages, the comprehensive domestic trade center constructed by resource coupling, and the tea health industry center with trans-boundary concept innovation. Group to take an active part in national industry platform construction, actively undertake the WTO/TBT, SPS national notification consulting center of tea product research and appraisal base, and agriculture NongCunBu cooperation with Austrian &amp;quot;China · Austria organic tea garden&amp;quot; demonstration of the construction of the project, combined with the &amp;quot;+&amp;quot; standardization strategy implementation, mining national excellent culture, promote the tea industry of the tertiary industry.&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;', '', '1649674154', '1649674154');
INSERT INTO `ey_single_content` VALUES ('3', '87', '8', '&lt;div class=&quot;column&quot;&gt;&lt;div