---
layout: page
title: ЧАПи Express
menu: starter
lang: uk
description: Find answers to frequently asked questions about Express.js, including
  topics on application structure, models, authentication, template engines, error
  handling, and more.
---

# Часті Питання (ЧАПи)

## Яку структуру я повинен використовувати для свого застосунку?

Немає єдиної відповіді на дане питання. Все залежить від
розміру вашого застосунку та від команди, яка приймає участь у його розробці. Щоб бути на стільки гнучким,
на скільки це можливо, Express не спирається на фіксовану структуру.

Маршрути та інша логіка застосунку може розміщуватись у файлах довільної кількості,
та поміщатись в каталоги будь-якої структури. Розгляньте наступні патерни проектування:

* [Списки маршрутів](https://github.com/expressjs/express/blob/4.13.1/examples/route-separation/index.js#L32-47)
* [Карта маршрутів](https://github.com/expressjs/express/blob/4.13.1/examples/route-map/index.js#L52-L66)
* [MVC-стиль контролерів](https://github.com/expressjs/express/tree/master/examples/mvc)

Також, існують сторонні розширення для Express, які спрощують деякі з перелічених патернів проектування:

* [Ресурсна маршрутизація](https://github.com/expressjs/express-resource)

## Як визначати моделі?

В Express немає засобів для роботи з базою даних. Їх надають деякі сторонні модулі
Node.js, що дозволяють вам взаємодіяти практично з будь-якою базою даних.

Ознайомтесь з [LoopBack](http://loopback.io) - цей фреймворк створено на базі Express,
він зорієнтований на роботу з моделями.

## Яким чином можна ідентифікувати користувачів?

Ідентифікація - це ще одна чутлива область, яку Express не ризикнув охопити. Ви можете використовувати будь-яку
схему ідентифікації. Проста схема "логін / пароль", представлена [в цьому прикладі](https://github.com/expressjs/express/tree/master/examples/auth).


## Які шаблонізатори підтримує Express?

Express підтримує будь-які шаблонізатори, що узгоджуються з сигнатурою `(path, locals, callback)`.
Додаткову інформацію, стосовно нормалізації інтерфейсів шаблонізаторів та кешування, можна знайти в проекті
[consolidate.js](https://github.com/visionmedia/consolidate.js). Цей список може й не містити певних шаблонізаторів,
проте вони можуть все ж підтримувати сигнатуру Express.

## Як можна обробляти 404-ті відповіді?

В Express, 404-ті відповіді не генеруються в результаті помилок, а тому
проміжні обробники помилок не перехоплюють їх. Така поведінка існує оскільки 404-ту відповідь ми отримуємо
через відсутність відповідної функції в переліку проміжних обробників при маршрутизації. Все що треба зробити
в такому випадку, - це додати проміжну функцію в самий низ черги обробників, яка якраз і буде призначатись для
формування 404-тої відповіді:

<pre><code class="language-javascript" translate="no">
app.use(function(req, res, next) {
  res.status(404).send('Вибачте, такої сторінки не існує!');
});
</code></pre>

## Як можна встановити обробника помилок?

Проміжні обробники помилок визначаються точно так само, як і інші проміжні обробники,
тільки передається до них чотири параметра, а не три; точніше, вони мають таку сигнатуру `(err, req, res, next)`:

<pre><code class="language-javascript" translate="no">
app.use(function(err, req, res, next) {
  console.error(err.stack);
  res.status(500).send('Щось поламалось!');
});
</code></pre>

Більш детально, можна проглянути розділ [обробка помилок](/{{ page.lang }}/guide/error-handling.html).

## Як можна відмальовувати простий код HTML?

Не треба! Не потрібно "відмальовувати" HTML за допомогою функції `res.render()`.
Якщо ви маєте окремий файл, скористайтесь функцією `res.sendFile()`.
Якщо ви маєте великий набір файлів в певній директорії, використовуйте проміжну функцію `express.static()`.
