---
layout: page
title: Спільнота Express
menu: resources
lang: uk
description: Долучайтеся до спільноти Express.js, ознайомтеся з діяльністю технічного комітету, знаходьте корисні ресурси, досліджуйте створені спільнотою модулі та приєднуйтеся до обговорень.
---

# Спільнота

## Технічний комітет

Технічний комітет Express зустрічається онлайн раз на два тижні (за потреби) для обговорення розробки та підтримки Express, а також інших питань, пов'язаних із проєктом. Зазвичай, кожна зустріч оголошується в
[expressjs/discussions](https://github.com/expressjs/discussions/issues) з посиланням для приєднання або перегляду зустрічі, яка відкрита для всіх охочих.

Зустрічі записуються; переглянути список записів можна на [YouTube-каналі Express.js](https://www.youtube.com/channel/UCYjxjAeH6TRik9Iwy5nXw7g).

Члени технічного комітету Express:

**Активні:**

- [@blakeembrey](https://github.com/blakeembrey) - Blake Embrey
- [@crandmck](https://github.com/crandmck) - Rand McKinney
- [@LinusU](https://github.com/LinusU) - Linus Unnebäck
- [@ulisesgascon](https://github.com/ulisesGascon) - Ulises Gascón
- [@sheplu](https://github.com/sheplu) - Jean Burellier
- [@wesleytodd](https://github.com/wesleytodd) - Wes Todd
- [@jonchurch](https://github.com/jonchurch) - Jon Church
- [@ctcpip](https://github.com/ctcpip/) - Chris de Almeida

**Неактивні:**

- [@dougwilson](https://github.com/dougwilson) - Douglas Wilson
- [@hacksparrow](https://github.com/hacksparrow) - Hage Yaapa
- [@jonathanong](https://github.com/jonathanong) - jongleberry
- [@niftylettuce](https://github.com/niftylettuce) - niftylettuce
- [@troygoode](https://github.com/troygoode) - Troy Goode

## Express складається з багатьох модулів

Наша активна спільнота створила безліч розширень, [проміжних модулів](/{{ page.lang }}/resources/middleware.html) та фреймворків вищого рівня.

Крім того, спільнота Express підтримує модулі в цих двох GitHub-організаціях:

- [jshttp](https://jshttp.github.io/): модулі, що надають корисні утилітарні функції; перегляньте [утилітарні модулі](/{{ page.lang }}/resources/utils.html).
- [pillarjs](https://pillarjs.github.io/): модулі нищого рівня, які Express використовує всередині.

Щоб триматися в курсі того, що відбувається в спільноті, перегляньте [ExpressJS StatusBoard](https://expressjs.github.io/statusboard/).

## Завдання

Якщо ви натрапили на помилку або хочете додати новий функціонал, відкрийте тікет у [списку завдань](https://github.com/expressjs/express/issues).

## Приклади

Перегляньте десятки прикладів [Express-застосунків](https://github.com/expressjs/express/tree/master/examples) у репозиторії, що охоплює все — від дизайну API та автентифікації до інтеграції із шаблонізаторами.

## Github-обговорення

Розділ [GitHub-обговорень](https://github.com/expressjs/discussions) — це чудове місце для участі в розмовах про розробку та підтримку Express, обміну ідеями та обговоренням тем, пов'язаних з його використанням.


# Бренд Express.js

## Логотип Express.js

Express — це проєкт OpenJS Foundation. Будь-ласка, ознайомтеся з [політикою використання торгової марки](https://trademark-policy.openjsf.org/) для отримання інформації про дозволене використання логотипів та знаків Express.js.

<div class="logo-table">
    <div>
        <h3>Логотип</h3>
        <a href="/images/brand/logotype-light.svg" class="hidden-dark">
            <img src="/images/brand/logotype-light.svg" width="250" height="56"/>
        </a>
        <a href="/images/brand/logotype-dark.svg" class="hidden-light">
            <img src="/images/brand/logotype-dark.svg" width="250" height="56"/>
        </a>
    </div>
    <div>
        <h3>Логомарка</h3>
        <a href="/images/brand/logo-light.svg" class="hidden-dark">
            <img src="/images/brand/logo-light.svg" width="96.5" height="56"/>
        </a>
        <a href="/images/brand/logo-dark.svg" class="hidden-light">
            <img src="/images/brand/logo-dark.svg" width="96.5" height="56"/>
        </a>
    </div>
<div>
