---
layout: page
title: Express 4.x Sürüm Notları
menu: changelog
lang: tr
description: Stay updated with the release change log for Express.js 4.x, detailing
  new features, bug fixes, and important changes across versions.
---
<div id="page-doc" markdown="1">
# Release Change Log

## 4.15.3 - Release date: 2017-05-16
{: id="4.15.3"}

The 4.15.3 patch release including some minor bug fixes:

<ul>
  <li markdown="1" class="changelog-item">
  Fix error when `res.set` cannot add charset to `Content-Type`.
  </li>

  <li markdown="1" class="changelog-item">
  Fix missing `</html>` in HTML document.
  </li>
</ul>

For a complete list of changes in this release, see [History.md](https://github.com/expressjs/express/blob/master/History.md#4153--2017-05-16).

## 4.15.2 - Release date: 2017-03-06
{: id="4.15.2"}

The 4.15.2 patch release including a minor bug fix:

<ul>
  <li markdown="1" class="changelog-item">
  Fix regression parsing keys starting with `[` in the extended  (default) query parser.
  </li>
</ul>

For a complete list of changes in this release, see [History.md](https://github.com/expressjs/express/blob/master/History.md#4152--2017-03-06).

## 4.15.1 - Release date: 2017-03-05
{: id="4.15.1"}

The 4.15.1 patch release including a minor bug fix:

<ul>
  <li markdown="1" class="changelog-item">
  Fix compatibility issue when using the datejs 1.x library where the [`express.static()` middleware](/{{ page.lang }}/4x/api.html#express.static) and [`res.sendFile()` method](/{{ page.lang }}/4x/api.html#res.sendFile) would incorrectly respond with 412 Precondition Failed.
  </li>
</ul>

For a complete list of changes in this release, see [History.md](https://github.com/expressjs/express/blob/master/History.md#4151--2017-03-05).

## 4.15.0 - Release date: 2017-03-01
{: id="4.15.0"}

The 4.15.0 minor release includes bug fixes, performance improvements, and other minor feature additions, including:

<ul>
  <li markdown="1" class="changelog-item">
  Starting with this version, Express supports Node.js 7.x.
  </li>

  <li markdown="1" class="changelog-item">
  The [`express.static()` middleware](/{{ page.lang }}/4x/api.html#express.static) and [`res.sendFile()` method](/{{ page.lang }}/4x/api.html#res.sendFile) now support the `If-Match` and `If-Unmodified-Since` request headers.
  </li>

  <li markdown="1" class="changelog-item">
  Update to [jshttp/etag module](https://www.npmjs.com/package/etag) to generate the default ETags for responses which work when Node.js has [FIPS-compliant crypto enabled](https://nodejs.org/dist/latest/docs/api/cli.html#cli_enable_fips).
  </li>

  <li markdown="1" class="changelog-item">
  Various auto-generated HTML responses like the default not found and error handlers will respond with complete HTML 5 documents and additional security headers.
  </li>
</ul>

For a complete list of changes in this release, see [History.md](https://github.com/expressjs/express/blob/master/History.md#4150--2017-03-01).

## 4.14.1 - Release date: 2017-01-28
{: id="4.14.1"}

The 4.14.1 patch release includes bug fixes and performance improvements, including:

<ul>
  <li markdown="1" class="changelog-item">
  Update to [pillarjs/finalhandler module](https://www.npmjs.com/package/finalhandler) fixes an exception when Express handles an `Error` object which has a `headers` property that is not an object.
  </li>
</ul>

For a complete list of changes in this release, see [History.md](https://github.com/expressjs/express/blob/master/History.md#4141--2017-01-28).

## 4.14.0 - Release date: 2016-06-16
{: id="4.14.0"}

The 4.14.0 minor release includes bug fixes, security update, performance improvements, and other minor feature additions, including:

<ul>
  <li markdown="1" class="changelog-item">
  Starting with this version, Express supports Node.js 6.x.
  </li>

  <li markdown="1" class="changelog-item">
  Update to [jshttp/negotiator module](https://www.npmjs.com/package/negotiator) fixes a [regular expression denial of service vulnerability](https://npmjs.com/advisories/106).
  </li>

  <li markdown="1" class="changelog-item">
  The [`res.sendFile()` method](/{{ page.lang }}/4x/api.html#res.sendFile) now accepts two new options: `acceptRanges` and `cacheControl`.

  - `acceptRanges` (defaut is `true`), enables or disables accepting ranged requests. When disabled, the response does not send the `Accept-Ranges` header and ignores the contents of the `Range` request header.

  - `cacheControl`, (default is `true`), enables or disables the `Cache-Control` response header. Disabling it will ignore the `maxAge` option.

  - `res.sendFile` has also been updated to handle `Range` header and redirections better.
  </li>

  <li markdown="1" class="changelog-item">
  The [`res.location()` method](/{{ page.lang }}/4x/api.html#res.location) and [`res.redirect()` method](/{{ page.lang }}/4x/api.html#res.redirect) will now URL-encode the URL string, if it is not already encoded.
  </li>

  <li markdown="1" class="changelog-item">
  The performance of the [`res.json()` method](/{{ page.lang }}/4x/api.html#res.json) and [`res.jsonp()` method](/{{ page.lang }}/4x/api.html#res.jsonp) have been improved in the common cases.
  </li>

  <li markdown="1" class="changelog-item">
  The [jshttp/cookie module](https://www.npmjs.com/package/cookie) (in addition to a number of other improvements) has been updated and now the [`res.cookie()` method](/{{ page.lang }}/4x/api.html#res.cookie) supports the `sameSite` option to let you specify the [SameSite cookie attribute](https://tools.ietf.org/html/draft-west-first-party-cookies-07).  
  
  {% include admonitions/note.html content="This attribute has not yet been fully standardized, may change in the future, and many clients may ignore it."%}

  The possible value for the `sameSite` option are:

  - `true`, which sets the `SameSite` attribute to `Strict` for strict same site enforcement.
  - `false`, which does not set the `SameSite` attribute.
  - `'lax'`, which sets the `SameSite` attribute to `Lax` for lax same site enforcement.
  - `'strict'`, which sets the `SameSite` attribute to `Strict` for strict same site enforcement.
  </li>

  <li markdown="1" class="changelog-item">
  Absolute path checking on Windows, which was incorrect for some cases, has been fixed.
  </li>

  <li markdown="1" class="changelog-item">
  IP address resolution with proxies has been greatly improved.
  </li>

  <li markdown="1" class="changelog-item">
  The [`req.range()` method](/{{ page.lang }}/4x/api.html#req.range) options object now supports a `combine` option (`false` by default), which when `true`, combines overlapping and adjacent ranges and returns them as if they were specified that way in the header.
  </li>
</ul>

For a complete list of changes in this release, see [History.md](https://github.com/expressjs/express/blob/master/History.md#4140--2016-06-16).
</div>
