---
layout: page
title: Express community
menu: resources
lang: th
description: Connect with the Express.js community, learn about the technical committee,
  find resources, explore community-contributed modules, and get involved in discussions.
---

# Community

## Issues

If you've come across what you think is a bug, or just want to make
a feature request open a ticket in the [issue queue](https://github.com/expressjs/express/issues).

## Technical committee

The Express technical committee meets online every two weeks to discuss development and maintenance of Express, and other issues relevant to the Express project.
Each meeting is typically announced in an [expressjs/discussions issue](https://github.com/expressjs/discussions/issues) with a link to the Google Hangout, which is
open to all observers.

The meetings are recorded; for a list of the recordings, see the [Express.js YouTube channel](https://www.youtube.com/channel/UCYjxjAeH6TRik9Iwy5nXw7g).

Members of the Express technical committee are:

**Active:**

- [@blakeembrey](https://github.com/blakeembrey) - Blake Embrey
- [@crandmck](https://github.com/crandmck) - Rand McKinney
- [@LinusU](https://github.com/LinusU) - Linus Unnebäck
- [@ulisesgascon](https://github.com/ulisesGascon) - Ulises Gascón
- [@sheplu](https://github.com/sheplu) - Jean Burellier
- [@wesleytodd](https://github.com/wesleytodd) - Wes Todd
- [@jonchurch](https://github.com/jonchurch) - Jon Church
- [@ctcpip](https://github.com/ctcpip/) - Chris de Almeida


**Inactive:**

- [@dougwilson](https://github.com/dougwilson) - Douglas Wilson
- [@hacksparrow](https://github.com/hacksparrow) - Hage Yaapa
- [@jonathanong](https://github.com/jonathanong) - jongleberry
- [@niftylettuce](https://github.com/niftylettuce) - niftylettuce
- [@troygoode](https://github.com/troygoode) - Troy Goode



## Examples

View dozens of Express application [examples](https://github.com/expressjs/express/tree/master/examples)
in the repository covering everything from API design and authentication to template engine integration.

## Other modules

Our vibrant community has created a large variety of extensions,
[middleware modules](/{{ page.lang }}/resources/middleware.html) and higher-level frameworks.  

Additionally, the Express community maintains modules in these two GitHub orgs:

- [jshttp](https://jshttp.github.io/) modules providing useful utility functions; see [Utility modules](/{{ page.lang }}/resources/utils.html).
- [pillarjs](https://pillarjs.github.io/): low-level modules that Express uses internally.

See also the [Express wiki](https://github.com/expressjs/express/wiki).
