---
layout: page
title: Часто задаваемые вопросы (FAQ) по Express
menu: starter
lang: ru
description: Find answers to frequently asked questions about Express.js, including
  topics on application structure, models, authentication, template engines, error
  handling, and more.
---

# Часто задаваемые вопросы (FAQ)

## Какую структуру мне следует использовать для своего приложения?

Нет единого ответа на данный вопрос. Все зависит от размеров приложения и участвующей в разработке команды. В целях обеспечения максимальной гибкости, в Express не предусмотрены какие бы то ни было предпосылки в отношении структуры.

Маршруты и другая логика приложений могут размещаться в любом количестве файлов, на ваше усмотрение, и в любой структуре каталогов, которую вы предпочтете. В качестве источника вдохновения, ознакомьтесь со следующими примерами:

* [Объявления маршрутов](https://github.com/expressjs/express/blob/4.13.1/examples/route-separation/index.js#L32-47)
* [Карта маршрутов](https://github.com/expressjs/express/blob/4.13.1/examples/route-map/index.js#L52-L66)
* [Контроллеры в MVC стиле](https://github.com/expressjs/express/tree/master/examples/mvc)

Также существуют сторонние расширения для Express, упрощающие некоторые из этих шаблонов:

* [Ресурсная маршрутизация](https://github.com/expressjs/express-resource)

## Как определить модели?

В Express нет средств для работы с базой данных. Их предоставляют исключительно
сторонние модули Node, что позволяет вам взаимодействовать практически с любой базой данных.

Фреймворк на базе Express, ориентированный на работу с моделями, описан в разделе [LoopBack](http://loopback.io).

## Как идентифицировать пользователей?

Аутентификация - это еще одна своеобразная область, которую Express не охватывает.  Можно использовать любую схему аутентификации, по вашему желанию.
Простая схема "имя пользователя / пароль" представлена в [следующем примере](https://github.com/expressjs/express/tree/master/examples/auth).


## Какие шаблонизаторы поддерживает Express?

Express поддерживает все шаблонизаторы, согласующиеся с сигнатурой `(path, locals, callback)`.
Дополнительную информацию о нормализации интерфейсов шаблонизации и кеширования можно найти в проекте
[consolidate.js](https://github.com/visionmedia/consolidate.js). Не представленные в списке шаблонизаторы также могут поддерживать сигнатуру Express.

## Как обрабатывать ошибки 404?

В Express код 404 не является результатом ошибки. Обработчик ошибок
не фиксирует их, потому что код ответа 404 указывает лишь на факт отсутствия дополнительной работы.  Другими словами, Express выполнил все функции промежуточной обработки и маршруты и обнаружил, что ни один из них не отвечает. Все, что вам нужно сделать, - добавить промежуточный обработчик в конец стека (после всех остальных функций) для обработки кода 404:

<pre>
<code class="language-javascript" translate="no">
app.use(function(req, res, next) {
  res.status(404).send('Sorry cant find that!');
});
</code>
</pre>

## Как определяется обработчик ошибок?

Функции промежуточного обработчика для обработки ошибок определяются так же, как и другие промежуточные обработчики, но с указанием не трех, а четырех аргументов в сигнатуре `(err, req, res, next)`).

<pre>
<code class="language-javascript" translate="no">
app.use(function(err, req, res, next) {
  console.error(err.stack);
  res.status(500).send('Something broke!');
});
</code>
</pre>

Дополнительная информация содержится в разделе [Обработка ошибок](/{{ page.lang }}/guide/error-handling.html).

## Как отобразить простой HTML-файл?

Вам не нужно этого делать! Нет необходимости отображать HTML с помощью функции `res.render()`.
Если у вас есть отдельный файл, воспользуйтесь функцией `res.sendFile()`.
В случае предоставления нескольких ресурсов из каталога воспользуйтесь промежуточным обработчиком `express.static()`.
