---
layout: page
title: Обновления системы безопасности Express
menu: advanced
lang: ru
description: Review the latest security updates and patches for Express.js, including
  detailed vulnerability lists for different versions to help maintain a secure application.
---

# Обновления системы безопасности

<div class="doc-box doc-notice" markdown="1">
Уязвимости Node.js оказывают непосредственное влияние на Express. Поэтому необходимо [пристально отслеживать уязвимости Node.js](https://nodejs.org
/en/blog/vulnerability/) и обязательно использовать только последнюю, стабильную версию Node.js.
</div>

В приведенном ниже списке перечислены уязвимости Express, которые были устранены в указанном обновлении версии.

## 4.x

  * 4.11.1
    * Исправлена уязвимость раскрытия корневого пути в `express.static`, `res.sendfile` и `res.sendFile`
  * 4.10.7
    * Исправлена уязвимость открытого перенаправления в `express.static` ([advisory](https://npmjs.com/advisories/35), [CVE-2015-1164](http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2015-1164)).
  * 4.8.8
    * Исправлены уязвимости обхода каталогов в `express.static` ([advisory](http://npmjs.com/advisories/32) , [CVE-2014-6394](http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2014-6394)).
  * 4.8.4
    * В Node.js 0.10 возможна утечка `fd` в некоторых ситуациях, что влияет на `express.static` и `res.sendfile`. Утечка `fd` может возникнуть вследствие вредоносных запросов и в итоге привести к ошибкам `EMFILE` и недоступности сервера.
  * 4.8.0
    * Разреженные массивы с крайне высокими индексами в строке запроса могут привести к исчерпанию памяти процессом и сбою на сервере.
    * Объекты строки запроса с очень высокой степенью вложенности могут привести к блокировке процесса и временной недоступности сервера.

## 3.x

  * 3.19.1
    * Исправлена уязвимость раскрытия корневого пути в `express.static`, `res.sendfile` и `res.sendFile`
  * 3.19.0
    * Исправлена уязвимость открытого перенаправления в `express.static` ([advisory](https://npmjs.com/advisories/35), [CVE-2015-1164](http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2015-1164)).
  * 3.16.10
    * Исправлены уязвимости обхода каталогов в `express.static`.
  * 3.16.6
    * В Node.js 0.10 возможна утечка `fd` в некоторых ситуациях, что влияет на `express.static` и `res.sendfile`. Утечка `fd` может возникнуть вследствие вредоносных запросов и в итоге привести к ошибкам `EMFILE` и недоступности сервера.
  * 3.16.0
    * Разреженные массивы с крайне высокими индексами в строке запроса могут привести к исчерпанию памяти процессом и сбою на сервере.
    * Объекты строки запроса с очень высокой степенью вложенности могут привести к блокировке процесса и временной недоступности сервера.
  * 3.3.0
    * Код ответа 404, полученный вследствие попытки переопределения неподдерживаемого метода, был подвержен атакам межсайтового скриптинга.
