---
layout: page
title: Express 4.x 업데이트 기록
menu: changelog
lang: ko
description: Stay updated with the release change log for Express.js 4.x, detailing
  new features, bug fixes, and important changes across versions.
---

# 업데이트 기록

## 4.17.1 - 출시일: 2019-05-25
{: id="4.17.1"}

4.17.1 패치에서 하나의 버그가 고쳐졌습니다.

<ul>
  <li markdown="1" class="changelog-item">
  `res.status()`가 존재하는 Express 4 애플리케이션에서 재귀를 일으키기 때문에 롤백되었습니다.
  </li>
</ul>

모든 변경 내역 확인: [History.md](https://github.com/expressjs/express/blob/master/History.md#4171--2019-05-25).

## 4.17.0 - 출시일: 2019-05-16
{: id="4.17.0"}

4.17.0 마이너 릴리즈에서는 버그를 고치고 몇몇 새 기능을 추가했습니다.

<ul>
  <li markdown="1" class="changelog-item">
  The `express.raw()` and `express.text()` middleware have been added to provide request body parsing for more raw request payloads. This uses the [expressjs/body-parser module](https://www.npmjs.com/package/body-parser) module underneath, so apps that are currently requiring the module separately can switch to the built-in parsers.
  </li>

  <li markdown="1" class="changelog-item">
  `res.cookie()` API가 이제 `sameSite` 옵션을 위해 `"none"` 값을 지원합니다.
  </li>

  <li markdown="1" class="changelog-item">
  `"trust proxy"` 설정이 활성화되어 있을 때, `req.hostname`가 이제 여러개의 `X-Forwarded-For` 헤더가 요청에 있는 것을 허용합니다.
  </li>

  <li markdown="1" class="changelog-item">
  이 버전부터 Express가 Node.js 10.x 버전과 12.x 버전을 지원합니다.
  </li>

  <li markdown="1" class="changelog-item">
  `res.sendFile()` API가 이제 비 문자열이 `path` 인수가 되었을 때 더 빠르고 쉽게 이해할 수 있는 에러를 제공합니다.
  </li>

  <li markdown="1" class="changelog-item">
  `res.status()` API가 이제 `null`이나 `undefined`가 인수가 되었을 때 더 빠르고 쉽게 이해할 수 있는 에러를 제공합니다.
  </li>
</ul>

모든 변경 내역 확인: [History.md](https://github.com/expressjs/express/blob/master/History.md#4170--2019-05-16).

## 4.16.4 - 출시일: 2018-10-10
{: id="4.16.4"}

4.16.4 패치는 여러 버그 픽스를 포함합니다.

<ul>
  <li markdown="1" class="changelog-item">
  `res.sendfile`에서 로깅될 수 있는 `"Request aborted"` 오류를 수정되었습니다.
  </li>
</ul>
모든 변경 내역 확인: [History.md](https://github.com/expressjs/express/blob/master/History.md#4164--2018-10-10).

## 4.16.3 - 출시일: 2018-03-12
{: id="4.16.3"}

4.16.3 패치는 여러 버그 픽스를 포함합니다.

<ul>
  <li markdown="1" class="changelog-item">
  `res.location` 메소드나 `res.redirect` 메소드에서 url 끝에 있는 `%` 문자가 `%25`로 인코딩되지 않는 문제를 수정했습니다.
  </li>

  <li markdown="1" class="changelog-item">
  빈 `req.url` 값이 기본 404 에러 핸들링에서 오류를 발생시키는 문제를 수정했습니다.
  </li>

  <li markdown="1" class="changelog-item">
  `express.static`의 응답이 이제 제대로 `</html>`을 포함합니다.
  </li>
</ul>

모든 변경 내역 확인: [History.md](https://github.com/expressjs/express/blob/master/History.md#4163--2018-03-12).

## 4.16.2 - 출시일: 2017-10-09
{: id="4.16.2"}

4.16.2 패치는 버그 픽스를 위한 롤백을 포함합니다.

<ul>
  <li markdown="1" class="changelog-item">
  `res.send` 메소드에서 `Buffer`가 입력되고, `ETag` 헤더가 이미 응답에 설정되었을 때 발생하는 `TypeError`를 수정했습니다.
  </li>
</ul>

모든 변경 내역 확인: [History.md](https://github.com/expressjs/express/blob/master/History.md#4162--2017-10-09).

## 4.16.1 - 출시일: 2017-09-29
{: id="4.16.1"}

4.16.1 패치는 버그 픽스를 위한 롤백을 포함합니다.

<ul>
  <li markdown="1" class="changelog-item">
  `express.static`을 사용하는 일부 유저에게 형향을 줄 수 있는 엣지 케이스 시나리오 회귀를 고치기 위해 [pillarjs/send module](https://www.npmjs.com/package/send를 업데이트 했습니다.
  </li>
</ul>

모든 변경 내역 확인: [History.md](https://github.com/expressjs/express/blob/master/History.md#4161--2017-09-29).

## 4.16.0 - 출시일: 2017-09-28
{: id="4.16.0"}

4.16.0 마이너 릴리즈는 보안 업데이트, 버그 픽스, 최적화, 그리고 새로운 기능을 포함합니다.

<ul>
  <li markdown="1" class="changelog-item">
  [jshttp/forwarded 모듈](https://www.npmjs.com/package/forwarded)에서 [발견된 취약점](https://npmjs.com/advisories/527)에 따라 업데이트되었습니다. `req.host`, `req.hostname`, `req.ip`, `req.ips`, `req.protocol`을 사용하는 애플리케이션에 영향을 끼칠 수 있습니다.
  </li>

  <li markdown="1" class="changelog-item">
  [취약점](https://npmjs.com/advisories/535)을 해결하기 위해 [pillarjs/send 모듈](https://www.npmjs.com/package/send)의 의존성 모듈로 사용된 `mime`를 업데이트했습니다. `res.type()`에서 untrusted string을 사용하는 애플리케이션에 영향을 끼칠 수 있습니다.
  </li>

  <li markdown="1" class="changelog-item">
  [pillarjs/send 모듈](https://www.npmjs.com/package/send)가 Node.js 8.5.0 [취약점](https://nodejs.org/en/blog/vulnerability/september-2017-path-validation/)에 대응하여 패치를 추가했습니다. Express.js의 이전 버전을 Node.js 8.5.0 (이 특정한 버전만 해당합니다)에서 사용하는 경우, `express.static`, `res.sendfile`과 `res.sendFile` API가 취약해집니다.
  </li>

  <li markdown="1" class="changelog-item">
  이 버전부터 Node.js 8.x.를 지원합니다.
  </li>

  <li markdown="1" class="changelog-item">
  새로운 설정, `"json escape"`는 `res.json()`, `res.jsonp()`가 문자를 escape 할 수 있도록 하고, `res.send()`의 응답을 클라이언트가 `Content-Type`에 따라 인식하는게 아니라 HTML로 인식하도록 합니다. 이건 Express 앱을 XSS 기반의 공격으로부터 지킬 수 있도록 도와줍니다.
  </li>

  <li markdown="1" class="changelog-item">
  [`res.download()` 메소드](/{{ page.lang }}/4x/api.html#res.download)가 이제 `options` 오브젝트를 받습니다.
  </li>

  <li markdown="1" class="changelog-item">
  `express.json()` 과 `express.urlencoded()` 미들웨어가 특수한 바디 파싱을 지원하기 위해 추가되었습니다. 이 기능은 [expressjs/body-parser 모듈](https://www.npmjs.com/package/body-parser)을 기반으로 돌아갑니다. 현재 `body-parser` 모듈을 사용하고 있는 앱들은 빌트인 파서로 바꿀 수 있습니다. 
  </li>

  <li markdown="1" class="changelog-item">
  [`express.static()` 미들웨어](/{{ page.lang }}/4x/api.html#express.static)와 [`res.sendFile()` 메소드](/{{ page.lang }}/4x/api.html#res.sendFile)가 이제 `Cache-Control`에서 `immutable` directive를 설정하는 것을 지원합니다. 적절한 `maxAge`와 함께 이 헤더를 설정함을 통해 지원되는 브라우저에서 파일이 아직 클라이언트 캐시에 남아 있어도 서버로 요청을 보내는 것을 방지할 수 있습니다. 
  </li>

  <li markdown="1" class="changelog-item">
  [pillarjs/send 모듈](https://www.npmjs.com/package/send)이 업데이트되어 더 많은 MIME 타입 리스트를 제공합니다. 이를 통해 `Content-Type`에 더 많은 파일을 지원할 수 있습니다. 70개의 새 파일 확장자를 지원합니다.
  </li>
</ul>

모든 변경 내역 확인: [History.md](https://github.com/expressjs/express/blob/master/History.md#4160--2017-09-28).

## 4.15.5 - 출시일: 2017-09-24
{: id="4.15.5"}

4.15.5 패치는 보안 업데이트, 최적화, 그리고 버그 픽스를 포함합니다.

<ul>
  <li markdown="1" class="changelog-item">
  [취약점](https://snyk.io/vuln/npm:debug:20170905)이 해결된 [debug 모듈](https://www.npmjs.com/package/debug)로 업데이트했습니다. Express에 영향을 끼치지는 않습니다.
  </li>

  <li markdown="1" class="changelog-item">
  [취약점](https://npmjs.com/advisories/526)이 해결된 [jshttp/fresh 모듈](https://www.npmjs.com/package/fresh)로 업데이트했습니다. 다음과 같은 API에 영향을 끼칩니다. `express.static`, `req.fresh`, `res.json`, `res.jsonp`, `res.send`, `res.sendfile` `res.sendFile`, `res.sendStatus`
  </li>

  <li markdown="1" class="changelog-item">
  [jshttp/fresh 모듈](https://www.npmjs.com/package/fresh)의 업데이트는 유효하지 않은 날짜로 이루어진 수정된 헤더 처리를 수정하고, `If-None-Match`와 같은 조건부 헤더를 파싱하는 것을 빠르게 합니다.
  </li>
</ul>

모든 변경 내역 확인: [History.md](https://github.com/expressjs/express/blob/master/History.md#4155--2017-09-24).

## 4.15.4 - 출시일: 2017-08-06
{: id="4.15.4"}

4.15.4 패치는 마이너 버그 픽스를 포함합니다.

<ul>
  <li markdown="1" class="changelog-item">
  인증서 조건에서 관리 중인 `"신뢰할 수 있는 프록시"` 값이 배열이 되던 문제 수정
  </li>
</ul>

모든 변경 내역 확인: [History.md](https://github.com/expressjs/express/blob/master/History.md#4154--2017-08-06).

## 4.15.3 - 출시일: 2017-05-16
{: id="4.15.3"}

4.15.3 패치는 보안 업데이트와 마이너 버그 픽스를 포함합니다.

<ul>
  <li markdown="1" class="changelog-item">
  Update a dependency of the [pillarjs/send module](https://www.npmjs.com/package/send) to address a [vulnerability](https://snyk.io/vuln/npm:ms:20170412). This may affect your application if untrusted string input is passed to the `maxAge` option in the following APIs: `express.static`, `res.sendfile`, and `res.sendFile`.
    
  </li>

  <li markdown="1" class="changelog-item">
  `res.set`으로 `Content-Type`에 charset을 추가할 수 없는 오류를 수정했습니다.
  </li>

  <li markdown="1" class="changelog-item">
  
  Fix missing `</html>` in HTML document.
  </li>
</ul>

모든 변경 내역 확인: [History.md](https://github.com/expressjs/express/blob/master/History.md#4153--2017-05-16).

## 4.15.2 - 출시일: 2017-03-06
{: id="4.15.2"}

4.15.2 패치는 마이너 버그 픽스를 포함합니다.

<ul>
  <li markdown="1" class="changelog-item">
  Fix regression parsing keys starting with `[` in the extended  (default) query parser.
  </li>
</ul>

모든 변경 내역 확인: [History.md](https://github.com/expressjs/express/blob/master/History.md#4152--2017-03-06).

## 4.15.1 - 출시일: 2017-03-05
{: id="4.15.1"}

4.15.1 패치는 마이너 버그 픽스를 포함합니다.

<ul>
  <li markdown="1" class="changelog-item">
  Fix compatibility issue when using the datejs 1.x library where the [`express.static()` middleware](/{{ page.lang }}/4x/api.html#express.static) and [`res.sendFile()` method](/{{ page.lang }}/4x/api.html#res.sendFile) would incorrectly respond with 412 Precondition Failed.
  </li>
</ul>

모든 변경 내역 확인: [History.md](https://github.com/expressjs/express/blob/master/History.md#4151--2017-03-05).

## 4.15.0 - 출시일: 2017-03-01
{: id="4.15.0"}

4.15.0 마이너 릴리즈는 버그 픽스, 최적화, 마이너 기능 추가를 포함합니다.

<ul>
  <li markdown="1" class="changelog-item">
  이 버전부터 Node.js 7.x.를 합니다.
  </li>

  <li markdown="1" class="changelog-item">
  The [`express.static()` middleware](/{{ page.lang }}/4x/api.html#express.static) and [`res.sendFile()` method](/{{ page.lang }}/4x/api.html#res.sendFile) now support the `If-Match` and `If-Unmodified-Since` request headers.
  </li>

  <li markdown="1" class="changelog-item">
  Update to [jshttp/etag module](https://www.npmjs.com/package/etag) to generate the default ETags for responses which work when Node.js has [FIPS-compliant crypto enabled](https://nodejs.org/dist/latest/docs/api/cli.html#cli_enable_fips).
  </li>

  <li markdown="1" class="changelog-item">
  Various auto-generated HTML responses like the default not found and error handlers will respond with complete HTML 5 documents and additional security headers.
  </li>
</ul>

모든 변경 내역 확인: [History.md](https://github.com/expressjs/express/blob/master/History.md#4150--2017-03-01).

## 4.14.1 - 출시일: 2017-01-28
{: id="4.14.1"}

4.14.1 패치는 버그 픽스와 최적화를 포함합니다.

<ul>
  <li markdown="1" class="changelog-item">
  Update to [pillarjs/finalhandler module](https://www.npmjs.com/package/finalhandler) fixes an exception when Express handles an `Error` object which has a `headers` property that is not an object.
  </li>
</ul>

모든 변경 내역 확인: [History.md](https://github.com/expressjs/express/blob/master/History.md#4141--2017-01-28).

## 4.14.0 - 출시일: 2016-06-16
{: id="4.14.0"}

4.14.0 마이너 릴리즈는 버그 픽스, 보안 업데이트, 최적화, 마이너 기능 추가를 포함합니다.

<ul>
  <li markdown="1" class="changelog-item">
  이 버전부터 Node.js 6.x.를 지원합니다.
  </li>

  <li markdown="1" class="changelog-item">
  Update to [jshttp/negotiator module](https://www.npmjs.com/package/negotiator) fixes a [regular expression denial of service vulnerability](https://npmjs.com/advisories/106).
  [jshttp/negotiator 모듈](https://www.npmjs.com/package/negotiator)을 업데이트해서 [정규 표현식 서비스 거부 취약점](https://npmjs.com/advisories/106)을 수정했습니다..
  </li>

  <li markdown="1" class="changelog-item">
  [`res.sendFile()` 메소드](/{{ page.lang }}/4x/api.html#res.sendFile)가 이제 다음의 2가지 옵션을 지원합니다. `acceptRanges`, `cacheControl`

  - `acceptRanges` (기본값: `true`): ranged requests를 받아 들이는지의 여부를 켜고 끕니다. 꺼져있을 때, 응답은 `accept-Ranges` 헤더를 보내지 않으며, `Range` 요청 헤더를 무시합니다.

  - `cacheControl`, (기본값: `true`):`Cache-Control` 헤더를 켜고 끕니다. 이 헤더를 끄면 `maxAge` 옵션을 무시합니다.

  - 또한 `res.sendFile`이 `Range` 헤더도 처리하고, 리다이렉션도 더 잘 하도록 업데이트 했습니다.
  </li>

  <li markdown="1" class="changelog-item">
  [`res.location()` 메소드](/{{ page.lang }}/4x/api.html#res.location) 와 [`res.redirect()` 메소드](/{{ page.lang }}/4x/api.html#res.redirect)가 URL 문자열이 인코딩되어있지 않다면 인코딩합니다.
  </li>

  <li markdown="1" class="changelog-item">
  [`res.json()` 메소드](/{{ page.lang }}/4x/api.html#res.json)와 [`res.jsonp()` 메소드](/{{ page.lang }}/4x/api.html#res.jsonp)의 일반적인 상황에서의 성능이 향상되었습니다.
  </li>

  <li markdown="1" class="changelog-item">
  [jshttp/cookie 모듈](https://www.npmjs.com/package/cookie) (다른 향상점과 함께)이 업데이트되었으며, 이제 [`res.cookie()` 메소드](/{{ page.lang }}/4x/api.html#res.cookie)가 `sameSite` 옵션을 지원해서 여러분이 [SameSite 쿠키 옵션](https://tools.ietf.org/html/draft-west-first-party-cookies-07)을 지정할 수 있게 됩니다.  NOTE: 이 속성은 아직 완전히 표준화되지 않았습니다. 미래에 바뀔 수도 있고, 클라이언트가 무시할 수 있습니다.

  `sameSite` 옵션으로 가능한 값:

  - `true`: `SameSite` 속성을 `Strict`로 설정해 strict same site enforcement합니다.
  - `false`: `SameSite` 속성을 설정하지 않습니다..
  - `'lax'`, `SameSite` 속성을 `Lax`로 설정해 lax same site enforcement합니다..
  - `'strict'`, `SameSite` 속성을 `Strict`로 설정해 strict same site enforcement합니다.
  </li>

  <li markdown="1" class="changelog-item">
  윈도우에서 절대 경로 검사가 종종 부정확했던 문제를 수정했습니다.
  </li>

  <li markdown="1" class="changelog-item">
  프록시를 사용하는 IP 주소 결정이 굉장하게 향상되었습니다.
  </li>

  <li markdown="1" class="changelog-item">
  [`req.range()` 메소드](/{{ page.lang }}/4x/api.html#req.range) 옵션 객체가 이제 `combine`을 지원합니다.(기본값: `false`) `true`로 설정하면, 오버랩핑과 인접 범위를 결합해서 헤더에서 설정한대로 리턴합니다.
  
  </li>
</ul>

모든 변경 내역 확인: [History.md](https://github.com/expressjs/express/blob/master/History.md#4140--2016-06-16).
