---
layout: page
title: Comunidad de Express
menu: resources
lang: es
description: Connect with the Express.js community, learn about the technical committee,
  find resources, explore community-contributed modules, and get involved in discussions.
---

# Comunidad

## Comité Técnico

El comité técnico de Express se reúne en línea cada dos semanas (según sea necesario) para discutir el desarrollo y el mantenimiento de Express, entre otros problemas relevantes para el proyecto Express. Cada reunión se anuncia normalmente en un [problema de expressjs/discussions](https://github.com/expressjs/discussions/issues) con un enlace para unirse o ver la reunión, que está abierta a todos los observadores.

Las reuniones son grabadas; para ver la lista de las grabaciones, consulte el [canal de YouTube de Express.js](https://www.youtube.com/channel/UCYjxjAeH6TRik9Iwy5nXw7g).

Los miembros del comité técnico de Express son:

**Activos:**

- [@blakeembrey](https://github.com/blakeembrey) - Blake Embrey
- [@crandmck](https://github.com/crandmck) - Rand McKinney
- [@LinusU](https://github.com/LinusU) - Linus Unnebäck
- [@ulisesgascon](https://github.com/ulisesGascon) - Ulises Gascón
- [@sheplu](https://github.com/sheplu) - Jean Burellier
- [@wesleytodd](https://github.com/wesleytodd) - Wes Todd
- [@jonchurch](https://github.com/jonchurch) - Jon Church
- [@ctcpip](https://github.com/ctcpip/) - Chris de Almeida

**Inactivos:**

- [@dougwilson](https://github.com/dougwilson) - Douglas Wilson
- [@hacksparrow](https://github.com/hacksparrow) - Hage Yaapa
- [@jonathanong](https://github.com/jonathanong) - jongleberry
- [@niftylettuce](https://github.com/niftylettuce) - niftylettuce
- [@troygoode](https://github.com/troygoode) - Troy Goode

## Express está hecho de muchos módulos

Nuestra vibrante comunidad ha creado una larga variedad de extensiones, [módulos intermedios](/{{ page.lang }}/resources/middleware.html) y frameworks de nivel superior.

Además, la comunidad de Express mantiene módulos en estas dos organizaciones de GitHub:

- [jshttp](https://jshttp.github.io/): módulos que proporcionan funciones utilitarias útiles; consulte [Módulos de utilidad](/{{ page.lang }}/resources/utils.html).
- [pillarjs](https://pillarjs.github.io/): módulos de bajo nivel que Express utiliza internamente.

Para mantenerse al tanto de lo que está sucediendo en toda la comunidad, consulte [ExpressJS StatusBoard](https://expressjs.github.io/statusboard/).

## Problemas

Si ha encontrado lo que cree que es un error, o simplemente quiere hacer una solicitud de función, abre un ticket en la [cola de problemas](https://github.com/expressjs/express/issues).

## Ejemplos

Mire docenas de [ejemplos](https://github.com/expressjs/express/tree/master/examples) de aplicaciones Express en el repositorio que cubren todo, desde el diseño y la autenticación de API hasta la integración del motor de plantillas.

## Discusiones de Github

La sección de [Discusiones de GitHub](https://github.com/expressjs/discussions) es un excelente espacio para participar en conversaciones sobre el desarrollo y mantenimiento de Express, así como para compartir ideas y debatir temas relacionados con su uso.


# Marca de Express.js

## Logo de Express.js

Express es un proyecto de la Fundación OpenJS. Por favor, revise la [política de marcas registradas](https://trademark-policy.openjsf.org/) para obtener información sobre el uso permitido de los logotipos y marcas de Express.js.

<div class="logo-table">
    <div>
        <h3>Logotipo</h3>
        <a href="/images/brand/logotype-light.svg" class="hidden-dark">
            <img src="/images/brand/logotype-light.svg" width="250" height="56"/>
        </a>
        <a href="/images/brand/logotype-dark.svg" class="hidden-light">
            <img src="/images/brand/logotype-dark.svg" width="250" height="56"/>
        </a>
    </div>
    <div>
        <h3>Logo de Marca</h3>
        <a href="/images/brand/logo-light.svg" class="hidden-dark">
            <img src="/images/brand/logo-light.svg" width="96.5" height="56"/>
        </a>
        <a href="/images/brand/logo-dark.svg" class="hidden-light">
            <img src="/images/brand/logo-dark.svg" width="96.5" height="56"/>
        </a>
    </div>
<div>

