import pytest
from edsl.jobs.tasks.task_status_enum import TaskStatus
from edsl.jobs.Jobs import Jobs
from edsl.jobs.interviews.Interview import Interview
from typing import List

# Import the TaskHistory class
# Assuming the module is named task_history.py
from edsl.jobs.tasks.TaskHistory import TaskHistory


@pytest.fixture
def sample_task_history():
    j = Jobs.example(throw_exception_probability=1, test_model=True)
    results = j.run(
        print_exceptions=False,
        skip_retry=True,
        cache=False,
        raise_validation_errors=True,
    )
    return TaskHistory(results.task_history.total_interviews)


def test_task_history_initialization(sample_task_history):
    assert isinstance(sample_task_history, TaskHistory)
    assert len(sample_task_history.total_interviews) > 0


def test_exceptions_property(sample_task_history):
    exceptions = sample_task_history.exceptions
    assert isinstance(exceptions, list)
    assert len(exceptions) > 0
    # assert all(isinstance(e, dict) for e in exceptions)


def test_indices_property(sample_task_history):
    indices = sample_task_history.indices
    assert isinstance(indices, list)
    assert len(indices) > 0
    assert all(isinstance(i, int) for i in indices)


def test_has_exceptions_property(sample_task_history):
    assert sample_task_history.has_exceptions == True


def test_to_dict_method(sample_task_history):
    task_dict = sample_task_history.to_dict()
    # assert isinstance(task_dict, dict)
    # assert "exceptions" in task_dict
    # assert "indices" in task_dict


def test_get_updates_method(sample_task_history):
    updates = sample_task_history.get_updates()
    assert isinstance(updates, list)
    assert len(updates) > 0


def test_exceptions_by_type_property(sample_task_history):
    exceptions_by_type = sample_task_history.exceptions_by_type
    assert isinstance(exceptions_by_type, dict)
    assert len(exceptions_by_type) > 0


def test_exceptions_by_question_name_property(sample_task_history):
    exceptions_by_question = sample_task_history.exceptions_by_question_name
    assert isinstance(exceptions_by_question, dict)
    assert len(exceptions_by_question) > 0


def test_exceptions_by_model_property(sample_task_history):
    exceptions_by_model = sample_task_history.exceptions_by_model
    assert isinstance(exceptions_by_model, dict)
    assert len(exceptions_by_model) > 0


def test_plotting_data_method(sample_task_history):
    plot_data = sample_task_history.plotting_data(num_periods=50)
    assert isinstance(plot_data, list)
    assert len(plot_data) == 50
    assert all(isinstance(d, dict) for d in plot_data)
    assert all(
        all(isinstance(status, TaskStatus) for status in d.keys()) for d in plot_data
    )


# Additional tests can be added for methods like plot(), html(), etc.
# These methods might require more complex setup or mocking of external dependencies.
