{
  'targets': [
    {
      'target_name': 'exokit',
      'conditions': [
        ['"<!(echo $LUMIN$ANDROID)"!="1"', {
          'conditions': [
            ['OS=="win"', {
              'sources': [
                'exokit.cpp',
                'deps/exokit-bindings/bindings/src/bindings.cc',
                'deps/exokit-bindings/util/src/defines.cc',
                'deps/exokit-bindings/console/src/console.cc',
                'deps/exokit-bindings/cache/src/cache.cc',
                'deps/exokit-bindings/threadpool/src/threadpool.cc',
                'deps/exokit-bindings/browser/src/browser.cpp',
                'deps/exokit-bindings/browser/src/browser-android.cpp',
                'deps/exokit-bindings/browser/src/browser-common.cpp',
                'deps/exokit-bindings/browser/src/browser-ml.cpp',
                'deps/exokit-bindings/browser/src/Servo2D.cpp',
                'deps/exokit-bindings/canvas/src/Color.cpp',
                'deps/exokit-bindings/canvas/src/csscolorparser.cpp',
                'deps/exokit-bindings/canvas/src/dxt.cpp',
                'deps/exokit-bindings/canvas/src/FloydSteinberg.cpp',
                'deps/exokit-bindings/canvas/src/Image.cpp',
                'deps/exokit-bindings/canvas/src/ImageData.cpp',
                'deps/exokit-bindings/canvas/src/PackedImageData.cpp',
                'deps/exokit-bindings/canvas/src/Path2D.cpp',
                'deps/exokit-bindings/canvas/src/Resource.cpp',
                'deps/exokit-bindings/canvas/src/rg_etc1.cpp',
                'deps/exokit-bindings/canvas/src/web_color.cpp',
                'deps/exokit-bindings/canvas/src/web_font.cpp',
                'deps/exokit-bindings/canvas/src/web_string.cpp',
                'deps/exokit-bindings/nanosvg/src/nanosvg.cpp',
                'deps/exokit-bindings/canvascontext/src/canvas-context.cc',
                'deps/exokit-bindings/canvascontext/src/canvas-gradient.cc',
                'deps/exokit-bindings/canvascontext/src/canvas-pattern.cc',
                'deps/exokit-bindings/canvascontext/src/imageBitmap-context.cc',
                'deps/exokit-bindings/canvascontext/src/image-context.cc',
                'deps/exokit-bindings/canvascontext/src/imageData-context.cc',
                'deps/exokit-bindings/canvascontext/src/path2d-context.cc',
                'deps/exokit-bindings/webglcontext/src/webgl.cc',
                'deps/exokit-bindings/webaudiocontext/src/AnalyserNode.cpp',
                'deps/exokit-bindings/webaudiocontext/src/Audio.cpp',
                'deps/exokit-bindings/webaudiocontext/src/AudioBuffer.cpp',
                'deps/exokit-bindings/webaudiocontext/src/AudioContext.cpp',
                'deps/exokit-bindings/webaudiocontext/src/AudioDestinationGenericImpl.cpp',
                'deps/exokit-bindings/webaudiocontext/src/AudioDestinationNode.cpp',
                'deps/exokit-bindings/webaudiocontext/src/AudioListener.cpp',
                'deps/exokit-bindings/webaudiocontext/src/AudioNode.cpp',
                'deps/exokit-bindings/webaudiocontext/src/AudioParam.cpp',
                'deps/exokit-bindings/webaudiocontext/src/AudioSourceNode.cpp',
                'deps/exokit-bindings/webaudiocontext/src/FakeAudioParam.cpp',
                'deps/exokit-bindings/webaudiocontext/src/GainNode.cpp',
                'deps/exokit-bindings/webaudiocontext/src/MediaStreamTrack.cpp',
                'deps/exokit-bindings/webaudiocontext/src/MicrophoneMediaStream.cpp',
                'deps/exokit-bindings/webaudiocontext/src/OscillatorNode.cpp',
                'deps/exokit-bindings/webaudiocontext/src/PannerNode.cpp',
                'deps/exokit-bindings/webaudiocontext/src/ScriptProcessorNode.cpp',
                'deps/exokit-bindings/webaudiocontext/src/StereoPannerNode.cpp',
                'deps/exokit-bindings/windowsystem/src/windowsystem.cc',
                'deps/exokit-bindings/glfw/src/glfw.cc',
                'deps/exokit-bindings/webrtc/src/binding.cc',
                'deps/exokit-bindings/webrtc/src/create-answer-observer.cc',
                'deps/exokit-bindings/webrtc/src/create-offer-observer.cc',
                'deps/exokit-bindings/webrtc/src/datachannel.cc',
                'deps/exokit-bindings/webrtc/src/peerconnection.cc',
                'deps/exokit-bindings/webrtc/src/peerconnectionfactory.cc',
                'deps/exokit-bindings/webrtc/src/rtcstatsreport.cc',
                'deps/exokit-bindings/webrtc/src/rtcstatsresponse.cc',
                'deps/exokit-bindings/webrtc/src/set-local-description-observer.cc',
                'deps/exokit-bindings/webrtc/src/set-remote-description-observer.cc',
                'deps/exokit-bindings/webrtc/src/stats-observer.cc',
                'deps/exokit-bindings/videocontext/src/Video.cpp',
                'deps/exokit-bindings/videocontext/src/VideoCamera.cpp',
                'deps/exokit-bindings/videocontext/src/VideoMode.cpp',
                'deps/exokit-bindings/videocontext/src/win/VideoMode_win.cpp',
                'deps/oculus/src/oculus-bindings.cpp',
                'deps/oculus/src/ovrsession.cpp',
                'deps/openvr/src/ivrcompositor.cpp',
                'deps/openvr/src/ivrsystem.cpp',
                'deps/openvr/src/openvr-bindings.cpp',
                'deps/exokit-bindings/leapmotion/src/leapmotion.cc',
              ],
              'include_dirs': [
                "<!(node -e \"console.log(require.resolve('nan').slice(0, -16))\")",
                "<!(node -e \"console.log(require.resolve('native-graphics-deps').slice(0, -9) + '/include')\")",
                "<!(node -e \"console.log(require.resolve('native-canvas-deps').slice(0, -9) + '/include/core')\")",
                "<!(node -e \"console.log(require.resolve('native-canvas-deps').slice(0, -9) + '/include/config')\")",
                "<!(node -e \"console.log(require.resolve('native-canvas-deps').slice(0, -9) + '/include/gpu')\")",
                "<!(node -e \"console.log(require.resolve('native-canvas-deps').slice(0, -9) + '/include/effects')\")",
                "<!(node -e \"console.log(require.resolve('native-audio-deps').slice(0, -9) + '/include')\")",
                "<!(node -e \"console.log(require.resolve('native-video-deps').slice(0, -9) + '/include')\")",
                "<!(node -e \"console.log(require.resolve('native-webrtc-deps').slice(0, -9) + '/include')\")",
                "<!(node -e \"console.log(require.resolve('native-webrtc-deps').slice(0, -9) + '/include/webrtc')\")",
                "<!(node -e \"console.log(require.resolve('native-oculus-deps').slice(0, -9) + '/Include')\")",
                "<!(node -e \"console.log(require.resolve('native-openvr-deps').slice(0, -9) + '/headers')\")",
                "<!(node -e \"console.log(require.resolve('leapmotion').slice(0, -9) + '/include')\")",
                '<(module_root_dir)/deps/exokit-bindings',
                '<(module_root_dir)/deps/exokit-bindings/utf8',
                '<(module_root_dir)/deps/exokit-bindings/node',
                '<(module_root_dir)/deps/oculus-mobile/deps/native_app_glue',
                '<(module_root_dir)/deps/exokit-bindings/util/include',
                '<(module_root_dir)/deps/exokit-bindings/console/include',
                '<(module_root_dir)/deps/exokit-bindings/cache/include',
                '<(module_root_dir)/deps/exokit-bindings/threadpool/include',
                '<(module_root_dir)/deps/exokit-bindings/bindings/include',
                '<(module_root_dir)/deps/exokit-bindings/canvas/include',
                '<(module_root_dir)/deps/exokit-bindings/browser/include',
                '<(module_root_dir)/deps/exokit-bindings/nanosvg/include',
                '<(module_root_dir)/deps/exokit-bindings/canvascontext/include',
                '<(module_root_dir)/deps/exokit-bindings/webglcontext/include',
                '<(module_root_dir)/deps/exokit-bindings/webaudiocontext/include',
                '<(module_root_dir)/deps/exokit-bindings/videocontext/include',
                '<(module_root_dir)/deps/exokit-bindings/windowsystem/include',
                '<(module_root_dir)/deps/exokit-bindings/glfw/include',
                '<(module_root_dir)/deps/exokit-bindings/webrtc/include',
                '<(module_root_dir)/deps/oculus/include',
                '<(module_root_dir)/deps/openvr/include',
                '<(module_root_dir)/deps/exokit-bindings/leapmotion/include',
              ],
              'library_dirs': [
                "<!(node -e \"console.log(require.resolve('native-graphics-deps').slice(0, -9) + '/lib/windows/glew')\")",
                "<!(node -e \"console.log(require.resolve('native-graphics-deps').slice(0, -9) + '/lib/windows/glfw')\")",
                "<!(node -e \"console.log(require.resolve('native-canvas-deps').slice(0, -9) + '/lib/windows')\")",
                "<!(node -e \"console.log(require.resolve('native-audio-deps').slice(0, -9) + '/lib/windows')\")",
                "<!(node -e \"console.log(require.resolve('native-video-deps').slice(0, -9) + '/lib/windows')\")",
                "<!(node -e \"console.log(require.resolve('native-oculus-deps').slice(0, -9) + '/Lib/Windows/x64/Release/VS2017')\")",
                "<!(node -e \"console.log(require.resolve('native-openvr-deps').slice(0, -9) + '/lib/win64')\")",
                "<!(node -e \"console.log(require.resolve('leapmotion').slice(0, -9) + '/lib/win')\")",
                "<!(node -e \"console.log(require.resolve('native-webrtc-deps').slice(0, -9) + '/lib/windows')\")",
              ],
              'libraries': [
                'opengl32.lib',
                'glew32.lib',
                'glfw3dll.lib',
                'gdiplus.lib',
                'skia.lib',
                'LabSound.lib',
                'avformat.lib',
                'avcodec.lib',
                'avutil.lib',
                'avdevice.lib',
                'swscale.lib',
                'swresample.lib',
                'openvr_api.lib',
                'Leap.lib',
                'LibOVR.lib',
                'webrtc.lib',
                'winmm.lib',
                'wmcodecdspuuid.lib',
                'secur32.lib',
                'msdmo.lib',
                'dmoguids.lib',
              ],
              'copies': [
                {
                  'destination': '<(module_root_dir)/build/Release/',
                  'files': [
                    "<!(node -e \"console.log(require.resolve('native-graphics-deps').slice(0, -9) + '/lib/windows/glew/glew32.dll')\")",
                    "<!(node -e \"console.log(require.resolve('native-graphics-deps').slice(0, -9) + '/lib/windows/glfw/glfw3.dll')\")",
                    "<!(node -e \"console.log(require.resolve('native-video-deps').slice(0, -9) + '/lib/windows/avformat-58.dll')\")",
                    "<!(node -e \"console.log(require.resolve('native-video-deps').slice(0, -9) + '/lib/windows/avcodec-58.dll')\")",
                    "<!(node -e \"console.log(require.resolve('native-video-deps').slice(0, -9) + '/lib/windows/avutil-56.dll')\")",
                    "<!(node -e \"console.log(require.resolve('native-video-deps').slice(0, -9) + '/lib/windows/avdevice-58.dll')\")",
                    "<!(node -e \"console.log(require.resolve('native-video-deps').slice(0, -9) + '/lib/windows/avfilter-7.dll')\")",
                    "<!(node -e \"console.log(require.resolve('native-video-deps').slice(0, -9) + '/lib/windows/postproc-55.dll')\")",
                    "<!(node -e \"console.log(require.resolve('native-video-deps').slice(0, -9) + '/lib/windows/swscale-5.dll')\")",
                    "<!(node -e \"console.log(require.resolve('native-video-deps').slice(0, -9) + '/lib/windows/swresample-3.dll')\")",
                    "<!(node -e \"console.log(require.resolve('native-oculus-deps').slice(0, -9) + '/Lib/Windows/x64/Release/VS2017')\")",
                    "<!(node -e \"console.log(require.resolve('native-openvr-deps').slice(0, -9) + '/bin/win64/openvr_api.dll')\")",
                    "<!(node -e \"console.log(require.resolve('leapmotion').slice(0, -9) + '/lib/win/Leap.dll')\")",
                  ]
                },
              ],
              'defines': [
                'NOMINMAX',
                'OCULUSVR',
                'OPENVR',
                'LEAPMOTION',
                'WEBRTC_WIN',
              ],
            }],
            ['OS=="linux"', {
              'conditions': [
                ['"<!(node -e \"console.log(process.arch)\")"=="x64"', {
                  'sources': [
                    'exokit.cpp',
                    '<!@(ls -1 deps/exokit-bindings/bindings/src/*.cc)',
                    '<!@(ls -1 deps/exokit-bindings/util/src/*.cc)',
                    '<!@(ls -1 deps/exokit-bindings/console/src/*.cc)',
                    '<!@(ls -1 deps/exokit-bindings/cache/src/*.cc)',
                    '<!@(ls -1 deps/exokit-bindings/threadpool/src/*.cc)',
                    '<!@(ls -1 deps/exokit-bindings/browser/src/*.cpp)',
                    '<!@(ls -1 deps/exokit-bindings/canvas/src/*.cpp)',
                    '<!@(ls -1 deps/exokit-bindings/nanosvg/src/*.cpp)',
                    '<!@(ls -1 deps/exokit-bindings/canvascontext/src/*.cc)',
                    '<!@(ls -1 deps/exokit-bindings/webglcontext/src/*.cc)',
                    '<!@(ls -1 deps/exokit-bindings/webaudiocontext/src/*.cpp)',
                    '<!@(ls -1 deps/exokit-bindings/videocontext/src/*.cpp)',
                    '<!@(ls -1 deps/exokit-bindings/videocontext/src/linux/*.cpp)',
                    '<!@(ls -1 deps/exokit-bindings/windowsystem/src/*.cc)',
                    '<!@(ls -1 deps/exokit-bindings/glfw/src/*.cc)',
                    '<!@(ls -1 deps/exokit-bindings/webrtc/src/*.cc)',
                    '<!@(ls -1 deps/openvr/src/*.cpp)',
                  ],
                  'include_dirs': [
                    "<!(node -e \"console.log(require.resolve('nan').slice(0, -16))\")",
                    "<!(node -e \"console.log(require.resolve('native-graphics-deps').slice(0, -9) + '/include')\")",
                    "<!(node -e \"console.log(require.resolve('native-canvas-deps').slice(0, -9) + '/include/core')\")",
                    "<!(node -e \"console.log(require.resolve('native-canvas-deps').slice(0, -9) + '/include/config')\")",
                    "<!(node -e \"console.log(require.resolve('native-canvas-deps').slice(0, -9) + '/include/gpu')\")",
                    "<!(node -e \"console.log(require.resolve('native-canvas-deps').slice(0, -9) + '/include/effects')\")",
                    "<!(node -e \"console.log(require.resolve('native-audio-deps').slice(0, -9) + '/include')\")",
                    "<!(node -e \"console.log(require.resolve('native-video-deps').slice(0, -9) + '/include')\")",
                    "<!(node -e \"console.log(require.resolve('native-webrtc-deps').slice(0, -9) + '/include')\")",
                    "<!(node -e \"console.log(require.resolve('native-webrtc-deps').slice(0, -9) + '/include/webrtc')\")",
                    "<!(node -e \"console.log(require.resolve('native-openvr-deps').slice(0, -9) + '/headers')\")",
                    '<(module_root_dir)/deps/exokit-bindings',
                    '<(module_root_dir)/deps/exokit-bindings/utf8',
                    '<(module_root_dir)/deps/exokit-bindings/node',
                    '<(module_root_dir)/deps/oculus-mobile/deps/native_app_glue',
                    '<(module_root_dir)/deps/exokit-bindings/util/include',
                    '<(module_root_dir)/deps/exokit-bindings/console/include',
                    '<(module_root_dir)/deps/exokit-bindings/cache/include',
                    '<(module_root_dir)/deps/exokit-bindings/threadpool/include',
                    '<(module_root_dir)/deps/exokit-bindings/bindings/include',
                    '<(module_root_dir)/deps/exokit-bindings/canvas/include',
                    '<(module_root_dir)/deps/exokit-bindings/browser/include',
                    '<(module_root_dir)/deps/exokit-bindings/nanosvg/include',
                    '<(module_root_dir)/deps/exokit-bindings/canvascontext/include',
                    '<(module_root_dir)/deps/exokit-bindings/webglcontext/include',
                    '<(module_root_dir)/deps/exokit-bindings/webaudiocontext/include',
                    '<(module_root_dir)/deps/exokit-bindings/videocontext/include',
                    '<(module_root_dir)/deps/exokit-bindings/windowsystem/include',
                    '<(module_root_dir)/deps/exokit-bindings/glfw/include',
                    '<(module_root_dir)/deps/exokit-bindings/webrtc/include',
                    '<(module_root_dir)/deps/openvr/include',
                  ],
                  'library_dirs': [
                    "<!(node -e \"console.log(require.resolve('native-graphics-deps').slice(0, -9) + '/lib/linux/glew')\")",
                    "<!(node -e \"console.log(require.resolve('native-graphics-deps').slice(0, -9) + '/lib/linux/glfw')\")",
                    "<!(node -e \"console.log(require.resolve('native-canvas-deps').slice(0, -9) + '/lib/linux')\")",
                    "<!(node -e \"console.log(require.resolve('native-audio-deps').slice(0, -9) + '/lib/linux')\")",
                    "<!(node -e \"console.log(require.resolve('native-video-deps').slice(0, -9) + '/lib/linux')\")",
                    "<!(node -e \"console.log(require.resolve('native-openvr-deps').slice(0, -9) + '/lib/linux64')\")",
                    "<!(node -e \"console.log(require.resolve('native-webrtc-deps').slice(0, -9) + '/lib/linux')\")",
                  ],
                  'libraries': [
                    '-lGL',
                    '-lGLU',
                    '-lX11',
                    '-lGLEW',
                    '-lglfw3',
                    '-lfontconfig',
                    '-lfreetype',
                    '-lpng16',
                    '-lskia',
                    '-lLabSound',
                    '-lavformat',
                    '-lavcodec',
                    '-lavutil',
                    '-lavdevice',
                    '-lswscale',
                    '-lswresample',
                    '-lx264',
                    '-lopenvr_api',
                    '-luuid',
                    '-lXcursor',
                    '-lXinerama',
                    '-lXxf86vm',
                    '-lXrandr',
                    '-lXi',
                    '-lasound',
                    '-lexpat',
                    '-lwebrtc',
                  ],
                  'ldflags': [
                    '-Wl,-Bsymbolic', # required for ffmpeg asm linkage
                    '-Wl,--no-as-needed', # required to prevent elision of shared object linkage

                    "-Wl,-rpath,./node_modules/native-graphics-deps/lib/linux/glew",
                    "-Wl,-rpath,./node_modules/native-graphics-deps/lib/linux/glfw",
                    "-Wl,-rpath,./node_modules/native-canvas-deps/lib/linux",
                    "-Wl,-rpath,./node_modules/native-audio-deps/lib/linux",
                    "-Wl,-rpath,./node_modules/native-video-deps/lib/linux/libavformat",
                    "-Wl,-rpath,./node_modules/native-video-deps/lib/linux/libavcodec",
                    "-Wl,-rpath,./node_modules/native-video-deps/lib/linux/libavutil",
                    "-Wl,-rpath,./node_modules/native-video-deps/lib/linux/libavdevice",
                    "-Wl,-rpath,./node_modules/native-video-deps/lib/linux/libavfilter",
                    "-Wl,-rpath,./node_modules/native-video-deps/lib/linux/libswscale",
                    "-Wl,-rpath,./node_modules/native-video-deps/lib/linux/libswresample",
                    "-Wl,-rpath,./node_modules/native-webrtc-deps/lib/linux",
                    "-Wl,-rpath,./node_modules/native-openvr-deps/bin/linux64",
                  ],
                  'defines': [
                    'NOMINMAX',
                    'OPENVR',
                    'WEBRTC_POSIX',
                  ],
                }],
                ['"<!(node -e \"console.log(process.arch)\")"=="arm64"', {
                  'sources': [
                    'exokit.cpp',
                    '<!@(ls -1 deps/exokit-bindings/bindings/src/*.cc)',
                    '<!@(ls -1 deps/exokit-bindings/util/src/*.cc)',
                    '<!@(ls -1 deps/exokit-bindings/console/src/*.cc)',
                    '<!@(ls -1 deps/exokit-bindings/cache/src/*.cc)',
                    '<!@(ls -1 deps/exokit-bindings/threadpool/src/*.cc)',
                    '<!@(ls -1 deps/exokit-bindings/canvas/src/*.cpp)',
                    '<!@(ls -1 deps/exokit-bindings/nanosvg/src/*.cpp)',
                    '<!@(ls -1 deps/exokit-bindings/canvascontext/src/*.cc)',
                    '<!@(ls -1 deps/exokit-bindings/webglcontext/src/*.cc)',
                    '<!@(ls -1 deps/exokit-bindings/webaudiocontext/src/*.cpp)',
                    '<!@(ls -1 deps/exokit-bindings/videocontext/src/*.cpp)',
                    '<!@(ls -1 deps/exokit-bindings/videocontext/src/linux/*.cpp)',
                    '<!@(ls -1 deps/exokit-bindings/windowsystem/src/*.cc)',
                    '<!@(ls -1 deps/exokit-bindings/glfw/src/*.cc)',
                    '<!@(ls -1 deps/exokit-bindings/webrtc/src/*.cc)',
                  ],
                  'include_dirs': [
                    "<!(node -e \"console.log(require.resolve('nan').slice(0, -16))\")",
                    "<!(node -e \"console.log(require.resolve('native-graphics-deps').slice(0, -9) + '/include')\")",
                    "<!(node -e \"console.log(require.resolve('native-canvas-deps').slice(0, -9) + '/include/core')\")",
                    "<!(node -e \"console.log(require.resolve('native-canvas-deps').slice(0, -9) + '/include/config')\")",
                    "<!(node -e \"console.log(require.resolve('native-canvas-deps').slice(0, -9) + '/include/gpu')\")",
                    "<!(node -e \"console.log(require.resolve('native-canvas-deps').slice(0, -9) + '/include/effects')\")",
                    "<!(node -e \"console.log(require.resolve('native-audio-deps').slice(0, -9) + '/include')\")",
                    "<!(node -e \"console.log(require.resolve('native-video-deps').slice(0, -9) + '/include')\")",
                    '<(module_root_dir)/deps/exokit-bindings',
                    '<(module_root_dir)/deps/exokit-bindings/utf8',
                    '<(module_root_dir)/deps/exokit-bindings/node',
                    '<(module_root_dir)/deps/oculus-mobile/deps/native_app_glue',
                    '<(module_root_dir)/deps/exokit-bindings/util/include',
                    '<(module_root_dir)/deps/exokit-bindings/console/include',
                    '<(module_root_dir)/deps/exokit-bindings/cache/include',
                    '<(module_root_dir)/deps/exokit-bindings/threadpool/include',
                    '<(module_root_dir)/deps/exokit-bindings/bindings/include',
                    '<(module_root_dir)/deps/exokit-bindings/canvas/include',
                    '<(module_root_dir)/deps/exokit-bindings/nanosvg/include',
                    '<(module_root_dir)/deps/exokit-bindings/canvascontext/include',
                    '<(module_root_dir)/deps/exokit-bindings/webglcontext/include',
                    '<(module_root_dir)/deps/exokit-bindings/webaudiocontext/include',
                    '<(module_root_dir)/deps/exokit-bindings/videocontext/include',
                    '<(module_root_dir)/deps/exokit-bindings/windowsystem/include',
                    '<(module_root_dir)/deps/exokit-bindings/glfw/include',
                    '<(module_root_dir)/deps/exokit-bindings/webrtc/include',
                  ],
                  'library_dirs': [
                    "<!(node -e \"console.log(require.resolve('native-graphics-deps').slice(0, -9) + '/lib2/arm64/glew')\")",
                    "<!(node -e \"console.log(require.resolve('native-graphics-deps').slice(0, -9) + '/lib2/arm64/glfw')\")",
                    "<!(node -e \"console.log(require.resolve('native-canvas-deps').slice(0, -9) + '/lib2/arm64')\")",
                    "<!(node -e \"console.log(require.resolve('native-audio-deps').slice(0, -9) + '/lib2/arm64')\")",
                    "<!(node -e \"console.log(require.resolve('native-video-deps').slice(0, -9) + '/lib2/arm64')\")",
                  ],
                  'libraries': [
                    '-lGL',
                    '-lEGL',
                    '-lGLU',
                    '-lX11',
                    '-lGLEW',
                    '-lglfw3',
                    '-lfontconfig',
                    '-lfreetype',
                    '-lpng16',
                    '-lskia',
                    '-lc++_static',
                    '-lLabSound',
                    '-lavformat',
                    '-lavcodec',
                    '-lavutil',
                    '-lavdevice',
                    '-lswscale',
                    '-lswresample',
                    '-luuid',
                    '-lXcursor',
                    '-lXinerama',
                    '-lXxf86vm',
                    '-lXrandr',
                    '-lXi',
                    '-lasound',
                    '-lexpat',
                  ],
                  'ldflags': [
                    '-Wl,-Bsymbolic', # required for ffmpeg asm linkage
                    '-Wl,--no-as-needed', # required to prevent elision of shared object linkage

                    "-Wl,-rpath,./../node_modules/native-graphics-deps/lib2/arm64/glew",
                    "-Wl,-rpath,./../node_modules/native-graphics-deps/lib2/arm64/glfw",
                    "-Wl,-rpath,./../node_modules/native-canvas-deps/lib2/arm64",
                    "-Wl,-rpath,./../node_modules/native-audio-deps/lib2/arm64",
                    "-Wl,-rpath,./../node_modules/native-video-deps/lib2/arm64/libavformat",
                    "-Wl,-rpath,./../node_modules/native-video-deps/lib2/arm64/libavcodec",
                    "-Wl,-rpath,./../node_modules/native-video-deps/lib2/arm64/libavutil",
                    "-Wl,-rpath,./../node_modules/native-video-deps/lib2/arm64/libavdevice",
                    "-Wl,-rpath,./../node_modules/native-video-deps/lib2/arm64/libavfilter",
                    "-Wl,-rpath,./../node_modules/native-video-deps/lib2/arm64/libswscale",
                    "-Wl,-rpath,./../node_modules/native-video-deps/lib2/arm64/libswresample",
                  ],
                  'defines': [
                    'NOMINMAX',
                    'WEBRTC_POSIX',
                  ],
                }],
              ],
            }],
            ['OS=="mac"', {
              'sources': [
                'exokit.cpp',
                '<!@(ls -1 deps/exokit-bindings/bindings/src/*.cc)',
                '<!@(ls -1 deps/exokit-bindings/util/src/*.cc)',
                '<!@(ls -1 deps/exokit-bindings/console/src/*.cc)',
                '<!@(ls -1 deps/exokit-bindings/cache/src/*.cc)',
                '<!@(ls -1 deps/exokit-bindings/threadpool/src/*.cc)',
                '<!@(ls -1 deps/exokit-bindings/browser/src/*.cpp)',
                '<!@(ls -1 deps/exokit-bindings/canvas/src/*.cpp)',
                '<!@(ls -1 deps/exokit-bindings/nanosvg/src/*.cpp)',
                '<!@(ls -1 deps/exokit-bindings/canvascontext/src/*.cc)',
                '<!@(ls -1 deps/exokit-bindings/webglcontext/src/*.cc)',
                '<!@(ls -1 deps/exokit-bindings/webaudiocontext/src/*.cpp)',
                '<!@(ls -1 deps/exokit-bindings/videocontext/src/*.cpp)',
                '<!@(ls -1 deps/exokit-bindings/videocontext/src/mac/*.mm)',
                '<!@(ls -1 deps/exokit-bindings/windowsystem/src/*.cc)',
                '<!@(ls -1 deps/exokit-bindings/glfw/src/*.cc)',
                '<!@(ls -1 deps/exokit-bindings/webrtc/src/*.cc)',
                '<!@(ls -1 deps/openvr/src/*.cpp)',
              ],
              'include_dirs': [
                "<!(node -e \"console.log(require.resolve('nan').slice(0, -16))\")",
                "<!(node -e \"console.log(require.resolve('native-graphics-deps').slice(0, -9) + '/include')\")",
                "<!(node -e \"console.log(require.resolve('native-canvas-deps').slice(0, -9) + '/include/core')\")",
                "<!(node -e \"console.log(require.resolve('native-canvas-deps').slice(0, -9) + '/include/config')\")",
                "<!(node -e \"console.log(require.resolve('native-canvas-deps').slice(0, -9) + '/include/gpu')\")",
                "<!(node -e \"console.log(require.resolve('native-canvas-deps').slice(0, -9) + '/include/effects')\")",
                "<!(node -e \"console.log(require.resolve('native-audio-deps').slice(0, -9) + '/include')\")",
                "<!(node -e \"console.log(require.resolve('native-video-deps').slice(0, -9) + '/include')\")",
                "<!(node -e \"console.log(require.resolve('native-webrtc-deps').slice(0, -9) + '/include')\")",
                "<!(node -e \"console.log(require.resolve('native-webrtc-deps').slice(0, -9) + '/include/webrtc')\")",
                "<!(node -e \"console.log(require.resolve('native-openvr-deps').slice(0, -9) + '/headers')\")",
                '<(module_root_dir)/deps/exokit-bindings',
                '<(module_root_dir)/deps/exokit-bindings/utf8',
                '<(module_root_dir)/deps/exokit-bindings/node',
                '<(module_root_dir)/deps/oculus-mobile/deps/native_app_glue',
                '<(module_root_dir)/deps/exokit-bindings/util/include',
                '<(module_root_dir)/deps/exokit-bindings/console/include',
                '<(module_root_dir)/deps/exokit-bindings/cache/include',
                '<(module_root_dir)/deps/exokit-bindings/threadpool/include',
                '<(module_root_dir)/deps/exokit-bindings/bindings/include',
                '<(module_root_dir)/deps/exokit-bindings/canvas/include',
                '<(module_root_dir)/deps/exokit-bindings/browser/include',
                '<(module_root_dir)/deps/exokit-bindings/nanosvg/include',
                '<(module_root_dir)/deps/exokit-bindings/canvascontext/include',
                '<(module_root_dir)/deps/exokit-bindings/webglcontext/include',
                '<(module_root_dir)/deps/exokit-bindings/webaudiocontext/include',
                '<(module_root_dir)/deps/exokit-bindings/videocontext/include',
                '<(module_root_dir)/deps/exokit-bindings/windowsystem/include',
                '<(module_root_dir)/deps/exokit-bindings/glfw/include',
                '<(module_root_dir)/deps/exokit-bindings/webrtc/include',
                '<(module_root_dir)/deps/openvr/include',
              ],
              'library_dirs': [
                "<!(node -e \"console.log(require.resolve('native-graphics-deps').slice(0, -9) + '/lib/macos/glew')\")",
                "<!(node -e \"console.log(require.resolve('native-graphics-deps').slice(0, -9) + '/lib/macos/glfw')\")",
                "<!(node -e \"console.log(require.resolve('native-canvas-deps').slice(0, -9) + '/lib/macos')\")",
                "<!(node -e \"console.log(require.resolve('native-audio-deps').slice(0, -9) + '/lib/macos')\")",
                "<!(node -e \"console.log(require.resolve('native-video-deps').slice(0, -9) + '/lib/macos')\")",
                "<!(node -e \"console.log(require.resolve('native-webrtc-deps').slice(0, -9) + '/lib/macos')\")",
              ],
              'libraries': [
                '-framework OpenGL',
                '-framework Cocoa',
                '-lGLEW',
                '-lglfw3',
                '-lskia',
                '-framework CoreAudio',
                '-framework AVFoundation',
                '-framework AudioUnit',
                '-framework AudioToolbox',
                '-llabsound',
                '-lavformat.58',
                '-lavcodec.58',
                '-lavutil.56',
                '-lavdevice.58',
                '-lavfilter.7',
                '-lswscale.5',
                '-lswresample.3',
                '-lpostproc.55',
                "-F <!(node -e \"console.log(require.resolve('native-webrtc-deps').slice(0, -9) + '/lib/macos')\")",
                '-lwebrtc',
                "-F <!(node -e \"console.log(require.resolve('native-openvr-deps').slice(0, -9) + '/bin/osx64')\")",
                "-framework OpenVR",
              ],
              'link_settings': {
                'libraries': [
                  "-Wl,-rpath,<!(node -e \"console.log(require.resolve('native-audio-deps').slice(0, -9) + '/lib/macos')\")",
                  "-Wl,-rpath,<!(node -e \"console.log(require.resolve('native-video-deps').slice(0, -9) + '/lib/macos')\")",
                  "-Wl,-rpath,<!(node -e \"console.log(require.resolve('native-webrtc-deps').slice(0, -9) + '/lib/macos')\")",
                  "-Wl,-rpath,<!(node -e \"console.log(require.resolve('native-openvr-deps').slice(0, -9) + '/bin/osx64')\")",
                  '-framework OpenVR',
                ],
              },
              'copies': [
                {
                  'destination': '<(module_root_dir)/build/Release/',
                  'files': [
                    "<!(node -e \"console.log(require.resolve('native-video-deps').slice(0, -9) + '/lib/macos/libavformat.58.dylib')\")",
                    "<!(node -e \"console.log(require.resolve('native-video-deps').slice(0, -9) + '/lib/macos/libavcodec.58.dylib')\")",
                    "<!(node -e \"console.log(require.resolve('native-video-deps').slice(0, -9) + '/lib/macos/libavutil.56.dylib')\")",
                    "<!(node -e \"console.log(require.resolve('native-video-deps').slice(0, -9) + '/lib/macos/libavdevice.58.dylib')\")",
                    "<!(node -e \"console.log(require.resolve('native-video-deps').slice(0, -9) + '/lib/macos/libavfilter.7.dylib')\")",
                    "<!(node -e \"console.log(require.resolve('native-video-deps').slice(0, -9) + '/lib/macos/libswscale.5.dylib')\")",
                    "<!(node -e \"console.log(require.resolve('native-video-deps').slice(0, -9) + '/lib/macos/libswresample.3.dylib')\")",
                    "<!(node -e \"console.log(require.resolve('native-video-deps').slice(0, -9) + '/lib/macos/libpostproc.55.dylib')\")",
                  ]
                }
              ],
              'defines': [
                'OPENVR',
                'WEBRTC_POSIX',
              ],
            }],
          ],
        }],
        ['"<!(echo $LUMIN)"=="1"', {
          'sources': [
            'exokit.cpp',
            '<!@(ls -1 deps/exokit-bindings/bindings/src/*.cc)',
            '<!@(ls -1 deps/exokit-bindings/util/src/*.cc)',
            '<!@(ls -1 deps/exokit-bindings/console/src/*.cc)',
            '<!@(ls -1 deps/exokit-bindings/cache/src/*.cc)',
            '<!@(ls -1 deps/exokit-bindings/threadpool/src/*.cc)',
            '<!@(ls -1 deps/exokit-bindings/browser/src/*.cpp)',
            '<!@(ls -1 deps/exokit-bindings/canvas/src/*.cpp)',
            '<!@(ls -1 deps/exokit-bindings/nanosvg/src/*.cpp)',
            '<!@(ls -1 deps/exokit-bindings/canvascontext/src/*.cc)',
            '<!@(ls -1 deps/exokit-bindings/webglcontext/src/*.cc)',
            '<!@(ls -1 deps/exokit-bindings/webaudiocontext/src/*.cpp)',
            '<!@(ls -1 deps/exokit-bindings/videocontext/src/*.cpp)',
            '<!@(ls -1 deps/exokit-bindings/videocontext/src/linux/*.cpp)',
            '<!@(ls -1 deps/exokit-bindings/windowsystem/src/*.cc)',
            '<!@(ls -1 deps/exokit-bindings/egl/src/*.cc)',
            '<!@(ls -1 deps/exokit-bindings/webrtc/src/*.cc)',
            '<!@(ls -1 deps/exokit-bindings/magicleap/src/*.cc)',
            '<!@(ls -1 deps/exokit-bindings/magicleap/deps/sjpeg/src/*.cc)',
          ],
          'include_dirs': [
            "<!(node -e \"console.log(require.resolve('nan').slice(0, -16))\")",
            "<!(node -e \"console.log(require.resolve('native-canvas-deps').slice(0, -9) + '/include/core')\")",
            "<!(node -e \"console.log(require.resolve('native-canvas-deps').slice(0, -9) + '/include/config')\")",
            "<!(node -e \"console.log(require.resolve('native-canvas-deps').slice(0, -9) + '/include/gpu')\")",
            "<!(node -e \"console.log(require.resolve('native-canvas-deps').slice(0, -9) + '/include/effects')\")",
            "<!(node -e \"console.log(require.resolve('native-audio-deps').slice(0, -9) + '/include')\")",
            "<!(node -e \"console.log(require.resolve('native-video-deps').slice(0, -9) + '/include')\")",
            "<!(node -e \"console.log(require.resolve('native-browser-deps').slice(0, -9) + '/lib')\")",
            "<!(node -e \"console.log(require.resolve('native-webrtc-deps').slice(0, -9) + '/include')\")",
            "<!(node -e \"console.log(require.resolve('native-webrtc-deps').slice(0, -9) + '/include/webrtc')\")",
            '<(module_root_dir)/deps/exokit-bindings',
            '<(module_root_dir)/deps/exokit-bindings/utf8',
            '<(module_root_dir)/deps/exokit-bindings/node',
            '<(module_root_dir)/deps/oculus-mobile/deps/native_app_glue',
            '<(module_root_dir)/deps/exokit-bindings/util/include',
            '<(module_root_dir)/deps/exokit-bindings/console/include',
            '<(module_root_dir)/deps/exokit-bindings/cache/include',
            '<(module_root_dir)/deps/exokit-bindings/threadpool/include',
            '<(module_root_dir)/deps/exokit-bindings/bindings/include',
            '<(module_root_dir)/deps/exokit-bindings/canvas/include',
            '<(module_root_dir)/deps/exokit-bindings/browser/include',
            '<(module_root_dir)/deps/exokit-bindings/nanosvg/include',
            '<(module_root_dir)/deps/exokit-bindings/canvascontext/include',
            '<(module_root_dir)/deps/exokit-bindings/webglcontext/include',
            '<(module_root_dir)/deps/exokit-bindings/webaudiocontext/include',
            '<(module_root_dir)/deps/exokit-bindings/videocontext/include',
            '<(module_root_dir)/deps/exokit-bindings/windowsystem/include',
            '<(module_root_dir)/deps/exokit-bindings/egl/include',
            '<(module_root_dir)/deps/exokit-bindings/webrtc/include',
            '<(module_root_dir)/deps/exokit-bindings/magicleap/include',
            '<(module_root_dir)/deps/exokit-bindings/magicleap/deps/sjpeg/src',
            "<!(echo $MLSDK)/lumin/stl/libc++/include",
            "<!(echo $MLSDK)/lumin/usr/include",
            "<!(echo $MLSDK)/include",
          ],
          'library_dirs': [
            "<!(echo $MLSDK)/lumin/stl/libc++/lib",
            "<!(echo $MLSDK)/lumin/usr/lib",
            "<!(echo $MLSDK)/lib/lumin",
            "<(module_root_dir)/node_modules/native-canvas-deps/lib2/magicleap",
            "<(module_root_dir)/node_modules/native-audio-deps/lib2/magicleap",
            "<(module_root_dir)/node_modules/native-video-deps/lib2/magicleap",
            "<(module_root_dir)/node_modules/native-browser-deps-magicleap/lib5/magicleap",
            "<(module_root_dir)/node_modules/native-webrtc-deps/lib2/magicleap",
          ],
          'libraries': [
            '-lskia',
            '-lLabSound',
            '-lavformat',
            '-lavcodec',
            '-lavutil',
            '-lavdevice',
            '-lswscale',
            '-lswresample',
            '-lopus',
            '-llog',
            '-lwebrtc',
          ],
          'ldflags': [
          ],
          'defines': [
            'NOMINMAX',
            'LUMIN',
            'WEBRTC_POSIX',
          ],
        }],
        ['"<!(echo $ANDROID)"=="1"', {
          'xcode_settings': {
            'ARCHS': ['aarch64'],
            'CLANG_CXX_LIBRARY': 'libstdc++'
          },
          'sources': [
            'exokit.cpp',
            '<!@(ls -1 deps/exokit-bindings/bindings/src/*.cc)',
            '<!@(ls -1 deps/exokit-bindings/util/src/*.cc)',
            '<!@(ls -1 deps/exokit-bindings/console/src/*.cc)',
            '<!@(ls -1 deps/exokit-bindings/cache/src/*.cc)',
            '<!@(ls -1 deps/exokit-bindings/threadpool/src/*.cc)',
            '<!@(ls -1 deps/exokit-bindings/browser/src/browser-android.cpp)',
            '<!@(ls -1 deps/exokit-bindings/canvas/src/*.cpp)',
            '<!@(ls -1 deps/exokit-bindings/nanosvg/src/*.cpp)',
            '<!@(ls -1 deps/exokit-bindings/canvascontext/src/*.cc)',
            '<!@(ls -1 deps/exokit-bindings/webglcontext/src/*.cc)',
            '<!@(ls -1 deps/exokit-bindings/webaudiocontext/src/*.cpp)',
            '<!@(ls -1 deps/exokit-bindings/videocontext/src/*.cpp)',
            '<!@(ls -1 deps/exokit-bindings/videocontext/src/linux/*.cpp)',
            '<!@(ls -1 deps/exokit-bindings/windowsystem/src/*.cc)',
            '<!@(ls -1 deps/exokit-bindings/egl/src/*.cc)',
            '<!@(ls -1 deps/exokit-bindings/webrtc/src/*.cc)',
            '<!@(ls -1 deps/oculus-mobile/src/*.cpp)',
            '<!@(ls -1 deps/oculus-mobile/deps/oboe/src/common/*.cpp)',
            '<!@(ls -1 deps/oculus-mobile/deps/oboe/src/fifo/*.cpp)',
            '<!@(ls -1 deps/oculus-mobile/deps/oboe/src/opensles/*.cpp)',
            '<!@(ls -1 deps/oculus-mobile/deps/oboe/src/aaudio/*.cpp)',
          ],
          'include_dirs': [
            "<!(node -e \"console.log(require.resolve('nan').slice(0, -16))\")",
            "<!(node -e \"console.log(require.resolve('native-canvas-deps').slice(0, -9) + '/include/core')\")",
            "<!(node -e \"console.log(require.resolve('native-canvas-deps').slice(0, -9) + '/include/config')\")",
            "<!(node -e \"console.log(require.resolve('native-canvas-deps').slice(0, -9) + '/include/gpu')\")",
            "<!(node -e \"console.log(require.resolve('native-canvas-deps').slice(0, -9) + '/include/effects')\")",
            "<!(node -e \"console.log(require.resolve('native-audio-deps').slice(0, -9) + '/include')\")",
            "<!(node -e \"console.log(require.resolve('native-video-deps').slice(0, -9) + '/include')\")",
            # "<!(node -e \"console.log(require.resolve('native-browser-deps').slice(0, -9) + '/lib')\")",
            "<!(node -e \"console.log(require.resolve('native-webrtc-deps').slice(0, -9) + '/include')\")",
            "<!(node -e \"console.log(require.resolve('native-webrtc-deps').slice(0, -9) + '/include/webrtc')\")",
            "<!(node -e \"console.log(require.resolve('native-oculus-mobile-deps').slice(0, -9) + '/lib/include')\")",
            "<!(echo $TOOLCHAIN_LIB)",
            "<!(echo $TOOLCHAIN_INCLUDE_LIB)",
            "<!(echo $TOOLCHAIN_INCLUDE_SYSROOT)/EGL",
            "<!(echo $TOOLCHAIN_INCLUDE_SYSROOT)",
            "<!(echo $TOOLCHAIN_INCLUDE_SYSROOT)/c++/v1",
            '<(module_root_dir)/deps/exokit-bindings',
            '<(module_root_dir)/deps/exokit-bindings/utf8',
            '<(module_root_dir)/deps/exokit-bindings/node',
            '<(module_root_dir)/deps/oculus-mobile/deps/native_app_glue',
            '<(module_root_dir)/deps/exokit-bindings/util/include',
            '<(module_root_dir)/deps/exokit-bindings/console/include',
            '<(module_root_dir)/deps/exokit-bindings/cache/include',
            '<(module_root_dir)/deps/exokit-bindings/threadpool/include',
            '<(module_root_dir)/deps/exokit-bindings/bindings/include',
            '<(module_root_dir)/deps/exokit-bindings/canvas/include',
            '<(module_root_dir)/deps/exokit-bindings/browser/include',
            '<(module_root_dir)/deps/exokit-bindings/nanosvg/include',
            '<(module_root_dir)/deps/exokit-bindings/canvascontext/include',
            '<(module_root_dir)/deps/exokit-bindings/webglcontext/include',
            '<(module_root_dir)/deps/exokit-bindings/webaudiocontext/include',
            '<(module_root_dir)/deps/exokit-bindings/videocontext/include',
            '<(module_root_dir)/deps/exokit-bindings/windowsystem/include',
            '<(module_root_dir)/deps/exokit-bindings/egl/include',
            '<(module_root_dir)/deps/exokit-bindings/webrtc/include',
            '<(module_root_dir)/deps/oculus-mobile/include',
            '<(module_root_dir)/deps/oculus-mobile/deps/oboe/include',
            '<(module_root_dir)/deps/oculus-mobile/deps/oboe/src',
          ],
          'library_dirs': [
            "<!(echo $TOOLCHAIN_USR)",
            "<!(echo $TOOLCHAIN_LIB)",
            "<!(echo $TOOLCHAIN_LIB_64)",
            "<!(echo $TOOLCHAIN_LIB_CXX)",
            "<(module_root_dir)/node_modules/native-canvas-deps/lib2/android",
            "<(module_root_dir)/node_modules/native-audio-deps/lib2/magicleap",
            "<(module_root_dir)/node_modules/native-video-deps/lib2/magicleap",
            "<(module_root_dir)/node_modules/native-webrtc-deps/lib2/magicleap",
            "<(module_root_dir)/node_modules/native-oculus-mobile-deps/lib/android/arm64-v8a"
          ],
          'libraries': [
            '-lskia',
            '-lavformat',
            '-lavcodec',
            '-lavutil',
            '-lavdevice',
            '-lLabSound',
            '-lswscale',
            '-lswresample',
            '-lopus',
            '-lwebrtc',
            '-lvrapi',
          ],
          'defines': [
            'ANDROID',
            'NOMINMAX',
            'WEBRTC_POSIX',
          ],
          'copies': [
            {
              'destination': '<(module_root_dir)/build/Release/',
              'files': [
                "<!(echo $TOOLCHAIN_LIB)/aarch64-linux-android/21/libEGL.so",
                "<!(echo $TOOLCHAIN_LIB)/aarch64-linux-android/21/libGLESv2.so"
              ]
            },
          ],
        }],
      ],
    },
  ],
}
