
Interested in contributing? As an open source project, we'd appreciate any help
and contributions! On top of the Exokit engine itself, you can also
contribute to any [related projects](https://github.com/exokitxr).


# Join the Community on Discord 

[Invite yourself](https://discord.gg/Apk6cZN) to the Exokit Discord.

# Get Help or Ask a Question

If you're not sure how to do something with Exokit, please ask in [Discord](https://discord.gg/Apk6cZN).

# File an Issue

1. Search the [issue tracker](https://github.com/exokitxr/exokit/issues) for similar issues.
2. Specify the version of Exokit in which the bug occurred.
3. Specify information about your browser and system (e.g., "Exokit v0.0.420 on OS X")
4. Describe the problem in detail (i.e., what happened and what you expected would happen).
5. If possible, provide a small test case with [CodePen](http://codepen.io), a link to your application, and/or a screenshot.

# Contribute Code to Exokit

[exokit]: https://github.com/exokitxr/exokit/
[easy]: https://github.com/exokitxr/exokit/issues?q=is%3Aopen+is%3Aissue+label%3Aeasy
[hard]: https://github.com/exokitxr/exokit/issues?q=is%3Aopen+is%3Aissue+label%3Ahard
[pr]: https://www.digitalocean.com/community/tutorials/how-to-create-a-pull-request-on-github
[ssh]: https://help.github.com/articles/generating-a-new-ssh-key-and-adding-it-to-the-ssh-agent/

Check out the [issues labeled *help wanted (easy)*][easy] or [*help wanted
(hard)*][hard] for good issues to tackle. Here's how to submit a pull request (PR):

1. Have a [GitHub account](https://github.com/join) with [SSH keys][ssh] set up.
2. [Fork](https://github.com/exokitxr/exokit/fork) the repository on GitHub.
3. Clone your fork of the repository locally (i.e., `git clone git@github.com:yourusername/exokit`).
4. Create a branch to work in (i.e., `git checkout -b mybranch`).
5. Make changes to your fork of the repository, commit them, and push them (i.e., `git add -A . && git commit -m 'My Changes (fixes #1234)' && git push origin mybranch`).
6. [Submit a pull request][pr] to the master branch. If you head to the [Exokit repository][exokit] after running `git push` from earlier, you should see a pop up to submit a pull request.
7. [Address review comments](http://stackoverflow.com/questions/9790448/how-to-update-a-pull-request) if any.

As per usual with open source, you would agree to license your contributions
under the [MIT License](LICENSE).

# Share your Work

1. Create something awesome using Exokit.
2. Publish your work to Github (and GitHub pages) so everyone can learn from your work.
3. Share it on [Discord](https://discord.gg/Apk6cZN), Twitter, etc.
4. For bonus points, write and publish a case study to explain how you built it.

# Update Documentation

If you catch a typo or error in the [documentation](https://exokit.org/docs/), we'd greatly appreciate a
pull request.



## Add Examples to Documentation

We like to have simple and interesting examples listed on relevant documentation pages. If you have an example that might be useful in the documentation, request to add it!

# Help Your Fellow Exokit users

## On GitHub

Help respond to [newly-filed GitHub issues](https://github.com/exokitxr/exokit/issues)

# Curate and Make Efforts Known

We round up all the cool stuff happening with Exokit on the [blog](https://exokit.org/blog).

# Spread the Word

If you want to hold an event and talk about WebXR and Exokit, check out [the
presentation kit](https://github.com/exokitxr/exokit-presentation-kit).

Thanks so much for contributing and helping grow WebXR!
