# YiYiYa简介

YiYiYa操作系统是一个朴实无华的操作系统，追求快速开发，最小实现，同时遵循SOLID原则。编码简洁明了，非常适合学习操作系统的同学。目前既有宏内核，也逐步实现了微s内核架构，未来将会是混合内核。

整体来说，YiYiYa操作系统非常轻量，支持POSIX操作系统标准协议，同时还支持扩展，方便使用其他语言开发模块。在应用层，可以通过libc/libmusl标准库和常用的库开发应用；在内核层可以调用基本内核模块的功能和共用库。


## YiYiYa系统架构

架构从上而下分层设计，同一层从左到右为模块。越下层与用户离得远，就会变得越通用越公共。分层设计便于扩展，方便维护，每一层的职责单一，让每一层依赖都是固定，不会胡乱调用（实现低耦合）。同时高层依赖底层，依赖接口，不依赖具体细节实现，底层的改动不至于影响太大，这就是基本的设计原则。

<!-- ![arch]("https://github.com/evilbinary/YiYiYa/blob/main/docs/image/arch.png?raw=true) -->
<img src="https://github.com/evilbinary/YiYiYa/blob/main/docs/image/arch.png" width="800px" />

### 1、应用层(用户库和应用)

应用层直接和用户操作打交道。有图形界面和shell命令交互。此层面对用户开发应用和常用库，对应源码目录为app。

### 2、接口层（c标准库)

接口层为操作系统内核向外核提供的基本功能。通过libc和libmusl可选，实现基本的标准库，方便开发者直接移植代码或者适配应用app。
 
### 3、内核层

内核层则为核心领域业务。每一小个模块都提供基本的功能。按各自的职责划分，分别对应与传统操作系统的内存管理、进程通信、文件系统、进程通信、等等。在演进操作系统时候，可以修改这里，对应源码目录为kernel。


### 4、基础设施层（公共层和硬件层）

 将硬件CPU相关和平台模块相关的单独作为公用库使用。目录为arch、platform、libs/kernel。
 
 在移植适配的时候基本上和这些模块打交道比较多，同时单独一个库可以提高内核代码复用性，内核有专门的内核库，以便增加代码安全，减少出错。


## 特性

* 支持荔枝派、树莓派、STM32系列开发板、x86 PC、Qemu模拟器等。

* 支持uboot引导内核，同时支持不需要uboot引导模式。

* 已经支持x86 armv7 armv7-a ,xtensa 在适配中，riscv在规划中。

* 支持lcd屏幕，st7789、st7735、通用40pin rgb屏幕。

* 支持vfs，fat32文件格式。

* 支持elf文件加载运行。

* 支持ipc管道等。

* 支持ahci、gpio、i2c、spi驱动等。

* 太多了不想列在这里了

## 协议

YiYiYa 系统完全开源，版本遵循GPL2.1 开源许可协议。主要用来学习，并不想商用，所以并没有使用MIT协议。


