# 移植适配

目前已经支持很多种架构和平台，可以根据平台来参考和开发。

## 芯片和cpu型号

1、arm架构系列

ARM7：ARMv4架构
ARM9：ARMv5架构
ARM11：ARMv6架构
ARM-Cortex 系列：ARMv7架构

ARM7 无MMU
ARM9、ARM11，带有MMU

Cortex-M23/M33   ARMv8-M 
Cortex-M3/M4/7   ARMv7-M
Cortex-M0/M0+/M1 ARMv6-M


2、riscv




### F1C100s & F1C200s

CPU: ARM926EJ-S (ARMv5TE) @ 533MHz ARM9
L1 Cache: 16KB Data, 32KB Instruction
FPU: None
GPU: Custom 2D-only
VPU: Unknown

### raspi2

Pi2 的 处理器芯片 BCM2836
CPU: quad-core ARM Cortex-A7 CPU @900MHz


## versatilepb

CPU: ARM Versatile/PB (ARM926EJ-S)  ARMV5T

## versatileab

ARM Versatile/AB (ARM926EJ-S)



### v3s

荔枝派

CPU: ARM CortexTM-A7 CPU @1.2GHz 单核



### miyoo

CPU: SoC – SigmaStar SSD202D 双核 Cortex-A7 处理器 @ 1.2 GHz
GPU: 配备2D GPU，128MB DDR3（注意：无 GPU）

### t113-s3

CPU: Dual-core ARM CortexTM-A7
32 KB L1 I-cache + 32 KB L1 D-cache per core, and 256 KB L2 cache



### esp32

版本：ESP32-D0WDQ6 v1
CPU: Xtensa® 32-bit LX6 双核处理器

• 448 KB ROM
• 520 KB SRAM
• 16 KB RTC SRAM


## 移植目录

### 架构移植

如果是全新cpu架构移植需要新建arch目录下的架构名称。

1、新建如arch/armv7-a架构文件，从dummpy空模版种拷贝过来

2、填充cpu.c mm.c interupt.c 文件

### 平台移植

如果是已有cpu架构类型，只需要新增duck/platform下，新增对应的平台目录。

1、新增gpio.h头文件

2、编写 init.c 包含基本的串口功能。


### boot移植

1、如果是新的架构，需要单独建立boot-xxx.s架构引导汇编代码。

2、如果是已有架构，则只需要添加对应的init.c初始化。

3、新增link-xxx.ld文件

### 构建文件

在上面都添加好后，需要添加构建配置。

1、修改support.py文件，添加support_platform和support_platform_cflags支持。

2、编译时候使用-p 编译对应的平台如：ya -m debug -p raspi2

3、添加duck/xlinker/link-xxx.ld


## X86 移植

参考 https://www.intel.com/content/www/us/en/architecture-and-technology/64-ia-32-architectures-software-developer-vol-3a-part-1-manual.html

### mmu 分页

保护模式

GDT（Global Descriptor Table，全局描述符表） LDT (Local Descriptor Table，局部描述符表)

GDT的每个表项，抽象地可以看成包含四个字段的数据结构：基地址（Base），大小（Limit），标志（Flag），访问信息（Access Byte）。

```bash
GDT
1st Double word:
Bits	Function	Description
0-15	Limit 0:15	First 16 bits in the segment limiter
16-31	Base 0:15	First 16 bits in the base address

2nd Double word:
Bits	Function	Description
0-7	Base 16:23	Bits 16-23 in the base address
8-12	Type	Segment type and attributes
13-14	Privilege Level	0 = Highest privilege (OS), 3 = Lowest privilege (User applications)
15	Present flag	Set to 1 if segment is present
16-19	Limit 16:19	Bits 16-19 in the segment limiter
20-22	Attributes	Different attributes, depending on the segment type
23	Granularity	Used together with the limiter, to determine the size of the segment
24-31	Base 24:31	The last 24-31 bits in the base address


The GDT Descriptor
Bits	Function	Description
0-15	Limit	Size of GDT in bytes
16-47	Address	GDT's memory address
```


无分页模式

    线性地址等于物理地址
    CR0.PG = 0
    
32bit模式

    CR0.PG = 1 and CR4.PAE = 0
    0-11:  页内偏移
    12-21: 页表 (Page Table)
    22-31: 页表目录表（Page Table Directory
PAE模式

    CR0.PG = 1, CR4.PAE = 1, and IA32_EFER.LME = 0
    0-11：页内偏移
    12-20：页表（Page Table）                          PT   PTE 512个
    21-29：页表目录表（Page Table Directory）           PTD  PDE 512个
    30-31：页目录指针表（Page Directory Pointer Table） PDPT PDPTE 4个

    CR3=>31:30
    PDPTE=>29:21
    PDE=> 20:12


### 上下文切换

```c
#define interrupt_entering_code(VEC, CODE, TYPE) \
  asm volatile(                                  \
      "cli\n"                                    \
      "push %0 \n"                               \
      "push %1 \n"                               \
      "pushal\n"                                 \
      "push %%ds\n"                              \
      "push %%es\n"                              \
      "push %%fs\n"                              \
      "push %%gs\n"                              \
      "mov %2,%%eax\n"                           \
      "mov %%ax,%%ds\n"                          \
      "mov %%ax,%%es\n"                          \
      "mov %%ax,%%gs\n"                          \
      "mov %%ax,%%fs\n"                          \
      :                                          \
      : "i"(CODE), "i"(VEC), "i"(GDT_ENTRY_32BIT_DS * GDT_SIZE))

#define interrupt_exit() \
  asm volatile(          \
      "pop %%gs\n"       \
      "pop %%fs\n"       \
      "pop %%es\n"       \
      "pop %%ds\n"       \
      "popal\n"          \
      "add $8,%%esp\n"   \
      "sti\n"            \
      "iret\n"           \
      :                  \
      :)
```


## ARMV5 移植

资料参考DDI01001.pdf官方文件。

### mmu分页

使用两级，页4k大小

1、level1

使用coarse page table

![](image/2024-01-07-15-05-42.png)



2、level2

使用small page

![](image/2024-01-07-15-04-33.png)


![](image/2024-01-07-15-59-37.png)


s r 是cp15 Register 1: Control register

s是第8位 ，R是第9位

![](image/2024-01-07-16-15-16.png)



## ARMV6 移植

CP15 控制寄存器 c1中的bit23 0 ARMv5，1 为ARMv6 
(CP15 register 1 XP = 0), the page table formats are backwards compatible with ARMv4/v5:

subpage AP bits are disabled (CP15 register 1 XP = 1), the page tables have support for ARMv6 MMU features

1、level1

![](image/2024-01-07-15-20-40.png)


2、level2

![](image/2024-01-07-15-20-18.png)

## ARMV7-A Cortext-a7 移植

移植适配资料请参考DDI0406C_d_armv7ar_arm.pdf官方文件。

### 几个重要的寄存器

堆栈，r13(sp)每个模式都有各自独立的堆栈，
链接，r14(lr)保存跳转前返回的地址，每个模式下都有各自的lr，bl、bx时候会把pc+4 地址给到lr。


根据文档 B1.8.3 Overview of exception entry章节

异常模式时候，异常模式的r14用来保存异常返回地址。

![](image/2022-11-27-00-34-44.png)


pl1 模式就是特权模式（FIQ、IRQ，Abort 、svc，und，system），pl0是用户权限，pl2是hyp模式。所以如下图，irq中，lr保存的地址为pc+4

![](image/2022-11-27-00-36-53.png)


IRQ异常时候流程，参考B1.9.10 IRQ exception的Pseudocode description of taking the IRQ exception。
异常时候，保存cpsr值到spsr，同时在arm下lr存的地址，为异常时候的pc-4。修改cpsr的m标志为irq模式。最后，跳转到向量地址运行异常程序。

![](image/2022-11-27-00-45-11.png)


ldm{cond}  mode  rn{!}, reglist{^}
stm{cond} mode  rn{!}, reglist{^}

^  : 如果reglist有pc寄存器，它表示指令执行后，spsr寄存器的值将自动复制到cpsr寄存器


根据文档，cortex-a7不会像x86一样自动push到堆栈，所以保存上下文，需要自己处理，定义上下文结构：

```
// manual push
u32 no;
u32 code;

u32 psr;
u32 pc;  // return to user addr

u32 r0;
u32 r1;
u32 r2;
u32 r3;
u32 r4;
u32 r5;
u32 r6;
u32 r7;
u32 r8;
u32 r9;
u32 r10;
u32 r11;  // fp
u32 r12;  // ip
u32 sp;   // r13 user sp
u32 lr;   // r14 user lr
```

压入堆栈操作，保存切换的上下文

```c
#define interrupt_entering_code(VEC, CODE) \
  asm volatile(                            \
      "stmfd sp, {r0-r12,sp,lr}^\n"        \
      "subs sp,sp,#60\n"                   \
      "mrs r0,spsr\n"                      \
      "stmfd sp!, {r0,lr} \n"              \
      "mov r1,%0\n"                        \
      "mov r2,%1\n"                        \
      "stmfd sp!, {r1,r2} \n"              \
      "mov r0,sp\n"                        \
      :                                    \
      : "i"(VEC), "i"(CODE))
```

恢复上下文操作。

```c
#define interrupt_exit_context(duck_context) \
  asm volatile(                              \
      "ldr sp,%0 \n"                         \
      "ldmfd sp!,{r1,r2}\n"                  \
      "ldmfd sp!,{r0,lr}\n"                  \
      "msr spsr,r0\n"                        \
      "ldmfd sp,{r0-r12,sp,lr}^\n"           \
      "add sp,sp,#60\n"                      \
      "subs pc,lr,#4\n"                      \
      :                                      \
      : "m"(duck_context->ksp))
```


### mmu

1、level1

![](image/2024-01-07-15-44-54.png)

2、level2

![](image/2024-01-07-15-45-01.png)


## ARMV8-A Cortext-53 移植


参考 DDI0487H_a_a-profile_architecture_reference_manual.pdf 官方文档。

等级划分，EL0用户态、EL1操作系统运行

![](image/2024-04-05-18-34-19.png)




## RISC-V 移植





## xtensa lx6 移植

移植适配资料请参考Xtensa_lx Overview handbook.pdf，Xtensa® Instruction Set Architecture (ISA)官方文档。

xtensa lx6 不支持mmu，所以，只需要移植context和中断就可以了。


### 几个重要的寄存器

PC 程序计数器寄存器
PS Processor state状态寄存器
AR address registers ar0-ar63
EPC1 Exception program counter2 ,RFE

### 指令

WSR：写特殊寄存器

wsr a0,epc1
wsr a0,ps 

WSR.* at：
WSR at, *：
WSR at, 0-255：

RSR：读特殊寄存器

RSR.* at：
RSR at, *：
RSR at, 0-255：

RFE
  PS.EXCM ← 0
  nextPC ← EPC[1]

