# 标准库

应用的开发，有2种方式可以选择，一种是使用libc库，另外一种则是使用libmusl库。在编译应用的时候需要加上libc或者libmusl库。
## 使用libc


>源码目录下新建ya.py文件用于构建应用。hello.c是应用程序，内容如下：

```python
target("hello")
set_type("cli")

```

>hello.c 内容

```c
#include "stdio.h"

char *buf="hello,elf\n";
int main(int argc, char* argv[]) {
    printf(buf);
    return 0;
}
```

>在app下的文件ya.py加入构建

<img src="https://github.com/evilbinary/YiYiYa/blob/main/docs/image/app-build.png" />



## 使用libmusl

libmusl构建的过程类似，不同的地方在于LIBC位置不同。

>将YiYiYa根目录下ya.py `default_libc`修改成 `libmusl`,这样就完成了c标准库的切换。

```python
default_libc = 'libc'  # libmusl libc

```

>切换后需要重新构建一下程序

```bash
ya -m debug -j8
```