# 微内核

YiYiYa提供了微服务级别的支持。鸭的一个服务可以是一个程序，也可以是一个so，一个设备驱动，一个函数。可以开多个服务，负载均衡，也可以多个版本同时开。

内核是服务的调度中心了，以前都是管cpu的调度，不管应用调度，现在也管了。


## 实现原理

鸭是一个类似mq的机制，鸭从内存分配一块，然后需要调用的时候，往里面丢消息，另外，有mq接收端负责处理从内存中拿消息处理。区别和别的os方式是，别的os都是走ipc的，需要经过syscall 直接调对方的服务。而鸭内核则不需要，这样没有开销了，而且还可以多个服务订阅同一个消息，执行相应的动作。

在elf 加载时候自动注册函数，远程可以直接调本地函数，不需要应用特别去改代码，实现远程调用啥的方式，当然可以显示的调用。

![](image/2023-07-16-12-08-27.png)

>a服务调b服务，都要先走一下ipc过一下内核，回来也要走一下，换成鸭的架构，a调b，直接掉就结束了，回来也直接回来。


"鸭"是一个类似消息队列（MQ）的机制，它充当了微服务架构的调度中心。它提供了一种不同于传统操作系统的方式来处理服务间的通信和调用。以下是对实现原理的进一步解释：

1. 鸭内存分配：鸭在内核中分配了一块内存区域，用于存储消息。这个内存区域可以被所有需要通信的服务订阅和使用。

2. 发送和接收消息：当一个服务需要向另一个服务发送消息时，它将消息放入鸭内存区域中。而接收端的服务会监听鸭，负责处理从内存中获取的消息。

3. 无IPC开销：与传统的进程间通信（IPC）方式相比，鸭内核不需要通过系统调用（syscall）来实现服务间的通信。这样避免了额外的开销，并且提高了性能。

4. 自动注册函数：在ELF加载（执行文件加载）时，服务可以自动注册函数。这意味着服务的函数可以在启动时被鸭识别和注册，使得远程服务可以直接调用本地函数，而不需要应用特别修改代码。这样实现了远程调用的方式。

5. 多个版本和负载均衡：由于鸭是一个支持多个服务和多个版本的系统，可以同时开启不同版本的服务，并且支持负载均衡，确保服务能够高效地运行。

总的来说，"鸭"提供了一种高效的服务通信和调用机制，通过内核管理消息，服务间直接通信而无需IPC开销。它还支持自动函数注册和远程调用的方式，使得微服务架构得以实现，并且能够灵活地支持多个版本和负载均衡。



##  应用场景

比如平常桌面挂了，可以0秒切换到另外一个桌面程序，不影响正常使用。而且可以同时跑多种不同的桌面程序，想用哪个桌面就直接用。

复用linux驱动，以后的linux作为服务A跑着呢，掉驱动就可以直接应用来调用了。