# 开发环境

目前开发环境支持linux window  macos，可以通过查看安装，选择对应的平台和编译器。


## 编译工具安装

编译工具安装，具体见，[安装文档](https://github.com/evilbinary/YiYiYa/tree/main/docs/install)

## 编译平台配置

### 默认方式 (推荐)

1、一般通过命令方式编译和运行。

```
ya -p raspi2 -r qemu -j8
```

### 构建平台选择方式

1、选择你要编译得平台，目前有以下几种，如果是要玩x86，就选 -p i386-pc

```
# board select platform,选择你要编译的平台 
# 可以选择的平台：
# riscv-virt qemu riscv模拟器运行
# dmulator 鸭模拟，可以运行在linux unix bsd等上面
# i386-pc qemu i386模拟器
# v3s 荔枝派zero v3s开发板真机运行
# raspi2 qemu 树莓派模拟器
# raspi3 qemu 树莓派模拟器
# esp32 esp32开发板运行
# stm32f4xx stm32f4xx qemu 或者开发板运行
# rk3128 rk开发板运行
# rk3288 rk开发板运行
# cubieboard2 cubieboard2开发板运行
# orangepi-pc qemu orangepi-pc模拟器运行
```


2、可以单独启用构建应用，打开ya.py 找到apps

```python
# 是否要构建应用
apps = [ ] # 应用名称，根据app目录来
```


## 运行方式 

一种纯粹软件模拟，可以使用qemu进行模拟运行，方便快捷开发；另外一种使用真机运行，可以通过一键运行命令下载运行（详细见开发板运行）。

1、qemu模拟效果如下图所示：

>运行树莓派qemu

<img src="https://github.com/evilbinary/YiYiYa/blob/main/docs/image/qemu-raspi2.jpg?raw=true" width="800px" />

2、真机运行如下所示：

>v3s 运行一个基于lvgl的应用

<img src="https://github.com/evilbinary/YiYiYa/blob/main/docs/image/v3s.png?raw=true" width="800px" />

>stm32 shell显示如下

<img src="https://github.com/evilbinary/YiYiYa/blob/main/docs/image/stm32-shell.png?raw=true" width="800px" />

## 使用vscode


YiYiYa操作系统使用的是Vscode开发和调试。通过配置文件，可以选择不同种的调试模式。


> 下图所示，基本的开发ide，添加基本的c/c++插件。

>名称: C/C++
ID: ms-vscode.cpptools
说明: C/C++ IntelliSense, debugging, and code browsing.
版本: 1.7.1
发布者: Microsoft
VS Marketplace 链接: https://marketplace.visualstudio.com/items?itemName=ms-vscode.cpptools

<img src="https://github.com/evilbinary/YiYiYa/blob/main/docs/image/vscode.png?raw=true" width="800px" />

## 编写代码

打开后可以看到init目录，此处为基本的入口模块。在此可以内核新增模块，或者创建内核线程。在kmain内核入口函数，可以新增一个线程如下所示：

>添加一个内核线程

```c
  thread_t* t3 = thread_create_name("test", (u32*)&do_test_thread, NULL);
  thread_add(t3);
```

>内核线程函数

```c
void do_test_thread(void) {
  u32 i = 0;
  u32 count = 0;
  for (;;) {
    count++;
    kprintf("test %d\n"，count);
  }
}
```

>编译后运行

```bash
ya -r qemu
```
## 编译某个模块

可以指定编译单独模块

> 编译app模块

```bash
ya  .\app\
```

> 编译drivers模块

```bash
ya  drivers
```

> 编译app下的luancher桌面应用

```bash
ya app/launcher
```

## 调试代码

代码调试可以通过qemu调试，也可以通过jlink或者其他工具调试。主要使用gdb工具配合vscode调试使用。

### qemu调试

首先得运行qemu程序，然后点击vscode左侧三角形debug图标，可以看到最左上边有个绿色得三角型，选择对应得程序和调试方式。

>运行命令启动qemu debug模式,将会进入调试模式，会等待gdb调试器连接上来。

```bash
ya -r qemu
```

>点击启动调试,平台为arm的，选kernel arm with gdb；平台为x86的，选kernel with gdb。

<img src="https://github.com/evilbinary/YiYiYa/blob/main/docs/image/debug-entry.png?raw=true" width="800px" />


### 真机调试
 
真机调试arm是通过jlink下载并调试，需要先运行J-Link GDB Server ，然后在运行对应程序的gdb后，就可以了。


>启动J-Link GDB Server

<img src="https://github.com/evilbinary/YiYiYa/blob/main/docs/image/jlink-server.png?raw=true" width="800px" />



>点击启动调试

<img src="https://github.com/evilbinary/YiYiYa/blob/main/docs/image/debug-stm32.png?raw=true" width="800px" />
