.section ".text.boot"
.global _start

.equ stack_size,0x200

_start:
    // save CPSR.
    mrs x0, nzcv

    mrs x1, mpidr_el1
    and   x1, x1, #3    
    cmp x1, #0
    bne apu_entry //is other core

    //main core init 
    ldr sp, = _estack
    ldr fp, = _estack

    // set sp in abt mode.
    bic r1, r0, #0x1F
    orr r1, r1, #0x17
    msr cpsr_c,r1
    ldr sp, =_stack_abt

    // set sp in undf mode.
    bic r1, r0, #0x1F
    orr r1, r1, #0x1B
    msr cpsr_c,r1
    ldr sp, =_stack_undf

    // set sp in irq mode.
    bic r1, r0, #0x1F
    orr r1, r1, #0x12
    msr cpsr_c,r1
    ldr sp,= _stack_irq


   // set sp in sys mode.
    bic r1, r0, #0x1F
    orr r1, r1, #0x1F
    msr cpsr_c, r0
    ldr sp,= _stack_sys

    // set sp in svc mode.
    bic r1, r0, #0x1F
    orr r1, r1, #0x13
    msr cpsr_c, r0
    ldr sp,= _stack_svc


    bl init_boot

apu_entry:
    //wfe
    ldr sp, = _estack
    ldr fp, = _estack

    ldr r2,=_stack_other
    mov r3,#256*4
    asr r3,r3,r4
    add r2,r2,r3

    // set sp in abt mode.
    bic r1, r0, #0x1F
    orr r1, r1, #0x17
    msr cpsr_c,r1
    mov sp, r2

    add r2,r2,$stack_size

    // set sp in undf mode.
    bic r1, r0, #0x1F
    orr r1, r1, #0x1B
    msr cpsr_c,r1
    mov sp, r2

    add r2,r2,$stack_size
    
    // set sp in irq mode.
    bic r1, r0, #0x1F
    orr r1, r1, #0x12
    msr cpsr_c,r1
    mov sp,r2

    add r2,r2,$stack_size
    
    // set sp in svc mode.
    bic r1, r0, #0x1F
    orr r1, r1, #0x13
    msr cpsr_c, r0
    mov sp, r2

    bl init_apu_boot
halt:
    wfi
    b halt

.data