# 9. Connection Invitations with Attachment

In the previous documents we went through how to establish a [Connection](./5.Connections.md) which doesn't contain an attached message and after that perform some actions (like accepting credentials, sharing proofs, answering questions) using the connection established before.

An Aries Out-of-Band Invitation provides the ability to combine **Connection Invitation** and the following protocol message (**Proof Request**/ **Credential Offer** / **Question**) into a single message so that from the user's perspective it looks like a single interaction.

> Note that Connection Invitation MUST be of [Aries Out-Of-Band type](./5.Connections.md#aries-out-of-band-invitation).


In the [document](./Out-of-Band.md) you can find all possible cases of how Out-Of-Band Invitation may look and a short overview of the steps that need to be taken depending on the invitation format.

In this document we will explain how to handle **Out-Of-Band Invitation** containing an additional protocol message as an attachment.

### 0. Edit application objects

We need to extend a previously defined application object for **Proof Request**, **Credential Offer**, **Question** with an `invitation` field where we will put an original Invitation.

```
{
    ... // previously defined fields 
    
    "invitation" - string // original invitation was received as JSON string
}
```

### 1. Analyze Invitation attachment

1. Extract the message attached to the invitation:
   ##### iOS
    ```objC
    [appDelegate.sdkApi extractAttachedMessage:invite
       completion:^(NSError *error, NSString *attachedMessage) {
       // ...
    }];
    ```

   ##### Android
    ```java
    String invitationAttachedMessage = UtilsApi.vcxExtractAttachedMessage(invite).get();
    ```

2. Determine the type of the attached message:
   * Credential Offer - the value of `@type` field **must** end with `issue-credential/1.0/offer-credential`
   
   * Proof Request - the value of `@type` field **must** end with `/present-proof/1.0/request-presentation`
   
    * Question - the value of `@type` field **must** end with `committedanswer/1.0/question`

3. Create corresponding application object:
   * Credential Offer 
     * Create SDK Credential state object as described in the Credential document [here](./6.Credentials.md#2-create-credential-state-object-using-received-credential-offer).
   * Proof Request
     * extract message attached to Proof Request in order to get the actual list of requested attributes and predicates.
     * Create SDK Proof state object as described in the Proofs document [here](./7.Proofs.md#2-create-proof-state-object-using-received-proof-request-message).
     * Retrive credentials that can be used for proving as described in the Proof document [here](./7.Proofs.md#3-retrieve-and-select-credentials-for-proof-request-filling).
   * Question
   
### 2.1 Accept Invitation which contains at least one value in `handshake_protocols`

The existence of at least one `handshake_protocols` in the invitation means that connection must be established first and after that attached protocol must be executed using this connection.

1. Create SDK Connection state object as described in the Connections document [here](./5.Connections.md#2-create-connection-state-object-using-received-invitation).


2. Check whether connection has been already established as described in the Connections document [here](./5.Connections.md#3-check-whether-connection-has-been-already-established).


3. Establish a new connection or Reuse existing one:

    3.1. Establish a new connection: 
    * Follow the steps `4. Accept connection invitation` ---> `7. Serialize Connection object and store in the application storage` as described [here](./5.Connections.md#4-accept-connection-invitation).<br><br>
    
    3.2. Reuse existing connection:
    * Follow the same steps described in the Connections document [here](./5.Connections.md#reusing-existing-connections).


4. Start protocol related to the attached message when the connection established or reused 

* Credential Offer - Follow the steps `3. Accept Credential Offer` -> `6. Serialize Credential object and store in the application storage.` as described in the Credentials document [here](./6.Credentials.md#3-accept-credential-offer).
  

* Proof Request - Follow the steps `4. Share Proof` as described in the Proofs document [here](./7.Proofs.md#4-share-proof).
  

* Question - Follow the steps `3. Answer on received Question` as described in the Structured Messages document [here](./8.StructuredMessages.md#answering-questions).

### 2.2 Accept Invitation without `handshake_protocols`

The absence of at `handshake_protocols` in the invitation means that connection establishing can be omitted and receiver can just respond directly to the endpoint defined in the `services` field of the invitation. It implies single step interaction: Invitee sends message to Inviter.

1. Create SDK Connection state object as described in the Connections document [here](./5.Connections.md#2-create-connection-state-object-using-received-invitation).

    > **NOTE:** Connection is considered as `established` at this step for this type of invitation.

2. Start protocol related to the attached message

* Credential Offer - cannot be used for this invitation format.


* Proof Request - Follow the steps `4. Share Proof` as described in the Proofs document [here](./7.Proofs.md#4-share-proof).


* Question - Follow the steps `3. Answer on received Question` as described in the Structured Messages document [here](./8.StructuredMessages.md#answering-questions).

## Next Step

Now your application is able to answer questions. Congratulations your application now supports base functionality!
If you wish you can read about some [advanced techniques](./Advanced.md).
