# 8. Structured Messages (Questions)

There are cases when one party needs to receive an answer to a specific question from another party.
For instance, it can be to authorize transactions, validate logins (2FA), accept terms and conditions, and other cases.

There are two roles in the question answering process: **Questioner** and **Responder**.
* The Questioner is the party that asks a question with its valid answers. [Verity SDK](https://github.com/evernym/verity-sdk) can be used as an **Questioner**.
* The Responder is the party that responds with the selected answer. **Mobile SDK** represents the **responds** party. Bellow in this document we will explain which steps need to be taken in order to respond on the question on the **Responder** side using Mobile SDK.

> **NOTE:** library should be initialized before using questions API. See [initialization documentation](3.Initialization.md)

> **NOTE:** there must be established connection between Sender and Received. See [connections document](5.Connections.md)

To complete this section read through the following sections:

1. [Answering Questions](#answering-questions)

## Answering Questions

### Steps overview

1. Download and Parse Question message received from the Pairwise Cloud Agent.
1. Update message (connected to Question) status on the Agent as reviewed
1. Answer on received Question
   1. Select answer
   1. Deserialize associated Connection
   1. Send answer message

### 0. Question Application object

On of the possible formats may match the following structure:
```
{
     "pwDid" - string, // reference to the connection from which proof request was received 
     "entryId" - string, // identifier of question protocol.    

     // metadata to show on the UI
     "answers": List<json>, // list of available answers
     "selectedAnswer": json, // selected answer
     
    // optionally
     "connectionName": string // name of the connection from which Crdential Offer was received 
     "connectionLogo": string // logo of the connection from which Crdential Offer was received 
      
     "timestamp": int // optional, time of answering (it can be shown on the UI)      
     "status" - string, // proof status (received / answered)
}
```
Later in this document, we will show how to get each of these fields.

### 1. Get Question from pending messages

1. Download pending messages
   See [messages documentation](4.MessagesFlow.md) for messages downloading information. Pending messages with `question` or `committed-question` type should be used.

   #### Example of Question

    ```json
    {
        "@type": "did:sov:BzCbsNYhMrjHiqZDTUASHg;spec/committedanswer/1.0/question",
        "@id": "5b4c8a32-ceae-48e1-bd6b-ffa2a07ddbf0",
        "question_text": "Hi, Thomas",
        "question_detail": "Are you on the phone with the credit union right now about transferring $100.00?",
        "valid_responses": [
          {
            "text": "Yes, I am",
            "nonce":
              "255c41413dcffcfaa4fe909cd65e477a5ed77d1550ba7f2c52cac58af84c4b8d"
          },
          {
            "text": "No, I am not",
            "nonce":
              "2a2a22bc64ecfda55fa40a2c9227c3592ac1399e63688b58d5f33c64b4326f77"
          }
        ],
        "@timing": {
          "expires_time": "2018-12-13T17:29:06+0000"
        }
      }
    ```

   The following fields can be used to show the question on the UI:
   * `question_text` - Question to show to user
   * `question_details` - Additional details for question
   * `valid_responses` - Array of possible answers for question. Each entry has following fields:
      * `text` - Readable representation of valid response.

### 2. Update message status

1. Update status of correspondent message on the Agent as reviewed. See [messages documentation](4.MessagesFlow.md) for message update information.

### 3. Answer on received Question

1. Select response option to be used

   ```
   answerJson = JSON.toString({
      "text": "Yes, I am",
      "nonce": "255c41413dcffcfaa4fe909cd65e477a5ed77d1550ba7f2c52cac58af84c4b8d"
   })
   ```

1. Deserialize Connection state object associated with received Question message

    ### iOS
    ```objC
    [appDelegate.sdkApi connectionDeserialize:serializedConnection
            completion:^(NSError *error, NSInteger connectionHandle) {
                // ...
            }];
    ```
    
    ### Android
    ```java
    int connectionHandle = ConnectionApi.connectionDeserialize(serializedConnection).get();
    ```

1. Send answer message

    ### iOS
    ```objC
    [appDelegate.sdkApi connectionSendAnswer:connHandle
            question:questionJson
            answer:answerJson
            withCompletion:^(NSError *error) {
                // ...
            }];
    ```
    
    ### Android
    ```java 
    ConnectionApi.connectionSendAnswer(connHandle, questionJson, answerJson).get();
    ```

## Next Step

Now your application is able to answer questions. Congratulations your application now supports base functionality!
You are ready to read how to [handle connection invitations containing attached messages](9.Connection-Invitations-With-Attachment.md).
