**Prerequisites**

* Minimum supported versions
  * iOS:
    * Devices 
      * 64 Bit devices only
      * No support for 32 bit devices
    * OS
      * iOS 10+
  * Android:
    * Devices
      * Both 32 bit and 64 bit devices
      * Only these architectures are supported
        * arm64, arm7, x86, x86_64
    * OS
      * Android 6+ (API version 23+)
  * React Native:
    * <=0.61.*
    * Above 0.61 react native has a known issue on Android. We are working to fix it
  * Other platforms such as Flutter, ionic, NativeScript, Xamarin, etc. are all supported with their latest versions.
  * No windows or UWP support yet for mobile devices. But we do have an SDK that works on Windows desktop based apps.

* Development environment:
  * iOS:
    * Xcode
    * Installed CocoaPods Gem for Ruby. [Install here](https://cocoapods.org)
  * Android: 
    * Android Studio

* **Currently recommended versions**
  * iOS:
      * `vcx 0.0.233` for phones
      * `vcx 0.0.234` for simulators
  * Android:
      * `com.evernym:vcx:0.14.0-d65fd6e@aar`

### Examples applications

We prepared example applications for your easy start: please check out the **/examples** folder in this repository. 
There you will find projects for both platforms (iOS and Android) and in languages you need (iOS: ObjC or Swift; Android: Java or Kotlin). 
By default, example applications points to **Production** environment.

# Project Setup

To complete this section:
1. [Create a new project](#1-create-a-new-project)
2. [Add dependency libraries](#2-add-dependency-libraries)
3. [Initialize the SDK API (VCX library)](#3-initialize-the-sdk-api)

<a id="new-project"></a>
## 1. Create a new project

### iOS 

1. Create a new Xcode project using the Xcode New Project wizard. If you have an existing project, skip to [Step 2](#2-add-dependency-libraries).

   * From the template list choose **Single View App** and click **Next**.

   * Enter a project name and select your preferred language: **Objective C** or **Swift**. (Leave **Use Core Data** unselected.)

   * In a new window select the folder where you would like to store your project and click **Create**. This directory is the *project directory*.
   
2. In a terminal navigate to the project directory:

``` 
cd <project directory path>
ls -l
```
   The directory should contain one of these files:
   * `<project_name>.xcodeproj`
   * `<project_name>.xcworkspace`

### Android

Use an existing Android Studio project or create a new Android project using the Android Studio New Project wizard. 
Instructions are available <a href='https://developer.android.com/training/basics/firstapp/creating-project' target="_blank">here</a>
* During the setup of the project you can choose either Java or Kotlin as the language for your new project.
---

<a id="libraries"></a>

## 2. Add dependency libraries

### iOS

1. Verify that you have CocoaPods. If you do not, run `sudo gem install cocoapods`

2. Verify that there is a Podfile in the project directory or create new one by running `pod init` in terminal, in the project folder. In case you started with existing project, most probably you already have Podfile in place other library dependencies. 

3. Add the next source to the top of your `Podfile`:

      ```ruby
        source 'https://cdn.cocoapods.org/'
        source 'git@gitlab.com:evernym/mobile/mobile-sdk.git'
      ```

4. Add `pod 'vcx', '0.0.233'` in Podfile inside `target <ProjectName>`

    * `vcx 0.0.233` should be used to run applications on phones
    * `vcx 0.0.234` should be used to run applications on simulators

5. Run `pod install`

6. Run the project

Verify that `<project_name>.xcworkspace` exists in the project directory. Use *only* that file to open your project and edit your source code in Xcode. *Do not* use the `<project_name>.xcodeproj` file to open or edit your project, but don’t delete it, either.   

7. Link VCX library in Xcode project

- If you are using Swift, you must create an `Objective-C` bridging header file named `<project_name>-Bridging-Header.h` in the same directory as your `AppDelegate.swift` file. Add it to your Xcode project using the **File > New > File** menu item of the Xcode IDE: 

    * In the wizard that launches, select **iOS > Header File** and then click **Next**. 
    * In the **Save As** field enter `<project_name>-Bridging-Header.h`
    * Select the **<project_name> Group**.
    * Select the **<project_name> Targets** and click **Create**. 
  
  Now `<project_name>-Bridging-Header.h` should be listed in the Xcode IDE at the same level as `AppDelegate.swift`. 

  Edit `<project_name>-Bridging-Header.h` in the Xcode IDE and make sure it has the following lines: 

```ObjC
// filename: <project_name>_Bridging_Header_h

#ifndef <project_name>_Bridging_Header_h
#define <project_name>_Bridging_Header_h

#import "vcx/vcx.h"

#endif
```

- If you are using `Objective-C`, edit `AppDelegate.h` to add the following to the `imports` section of the file:

```ObjC
// filename: AppDelegate.h

#import "vcx/vcx.h"
```

### Android

1. Open the project-level `build.gradle` file, which contains the declaration of the repositories. 

    Add a new dependency source to the `allprojects` repositories section (not the `buildscript` repositories section):
        
    ```gradle
    allprojects {
        ...
        
        repositories {
            ...
            maven {
                url 'https://evernym.mycloudrepo.io/public/repositories/libvcx-android'
            }
        }
    }
    ```

2. Open the app-level `build.gradle` file and add the following to the dependencies section.

    ```gradle
    // VCX library
    implementation 'com.evernym:vcx:0.14.0-d65fd6e@aar'
    implementation 'net.java.dev.jna:jna:4.5.0@aar'
    
    
    // optional, required to libVcx logger configuration
    implementation 'org.slf4j:slf4j-api:1.7.30'
    implementation('com.github.bright:slf4android:0.1.6'){
        transitive = true
    }
    
    // optional, required to work with CompletableFuture implementation used by libVcx
    implementation 'net.sourceforge.streamsupport:android-retrofuture:1.7.1'
    ```

3. `minSdkVersion` must be `23` or higher. 

4. Try to build your project in Android Studio to make sure the changes you have made so far are valid. Evernym recommends that you launch your mobile app in an emulator to make sure that the bundling of the APK is working.

---

<a id="initialize"></a>

## 3. Initialize the SDK API

### iOS


Two `AppDelegate` data members must be declared in `AppDelegate.h`  and then initialized in `AppDelegate.m`:
* `self.sdkApi`
* `self.sdkInited`     

1. In `AppDelegate.h` add this declaration:
    ```objc
    #import "vcx/vcx.h
    
    @property (strong, nonatomic) ConnectMeVcx *sdkApi;
    @property (nonatomic) BOOL sdkInited;
    ```

2. In `AppDelegate.m` add this synthesize statement and this constructor or initer: 
    ```objc 
    @synthesize sdkInited;
    
    //
    // further down in AppDelegate.m
    // ...
    - (id)init
    {
    self = [super init];
    if (self) {
        // Initialization code here.
        self.sdkApi = [[ConnectMeVcx alloc] init];
        self.sdkInited = false;
    }
    
    return self;
    }
    ```        

3. Try to build your project in Xcode to make sure the changes you have made so far are valid. Evernym recommends that you launch your mobile app in a simulator to make sure that the linking and deploying steps work as well. 

### Android

No steps are need.

## SDK API

* iOS - Almost all of the iOS APIs provided by mobile SDK are asynchronous, which means that a completion callback function is required to get the results of the function invocations. This page contains the steps to initialize the wallet and an Evernym Cloud Service cloud agent. Most of these wallet initialization steps are done in the AppDelegate’s `didFinishLaunchingWithOptions` lifecycle method.

* Android - Almost all of the Android APIs provided by mobile SDK are asynchronous. It uses Java Future API, namely [android-retrofuture](https://github.com/retrostreams/android-retrofuture) implementation. Most of the methods returns `CompletableFuture` objects, that could be used both synchronous and asynchronous ways.

## Next Step

Now you are ready to start adding calls to your code to [initialize the Wallet and Cloud Agent](3.Initialization.md).
