# Base Concepts

## Overview

### Connections

A connection is a verifiable encrypted communication channel between one party and another. When creating a connection, both parts exchange their public keys which will be used for messages encryption during later communications. These keys are represented as Decentralized Identifiers (DIDs). This allows secure communications between the entities.

### Messages

Messages are the main way to exchange data within connections.

### Credentials

A credential is a set of digitally signed information provided by an Issuer to a Holder, representing claims that the Holder can present to a Verifier.

### Proof requests

A proof request is a request made by a Verifier for information from a credential in the Holder's possession to be revealed.

### Proofs

A proof is digital evidence of information presented in Holder credentials.

### Questions

A question is a request to a Holder to provide an answer from a set of predefined options to a specified question.

## SDK overview

### General

Inside the SDK library, all entities (connections, proofs, etc.) are represented as state machines.
Every mutating operation, e.g. accepting or rejecting, changes the internal state of this state machine moving it into the next state.

The Mobile SDK contains four main kinds of state machines implementing different protocols:

* `Connection` - is used for establishing a communication channel between two parties.
* `Credential` - is used for obtaining verifiable credentials on the holder side.
* `DisclosedProof` - is used for providing information about the credential holders.
* `Proof` - is used for requesting information about the credential holders.

### Message receiving 

In order to receive messages from other parties, the Mobile SDK uses a Cloud Agent. 
There are two ways to receive messages from the Cloud Agent:

##### Polling

Once in a while, an application calls SDK function to get all unprocessed messages from the Cloud Agent.

##### Push notifications.

Cloud Agent is able to forward received messages to an endpoint (Push Notification service) which can be set using SDK.
In this case messages and updates will be sent in real time.
Message forwarding from the Cloud Agent will contain following attributes in message body:
- `@type`: type for push notification message. It can be: `cred`, `credOffer`, `proofReq` and `Question`. For structured messages, type of the push notification will be `Question`.
- `@uid`: identifier for specific message we are receiving
- `@forDID`: identifier for connection fom which notification was sent. It matches to connection `pwDid`.

After receiving a message from the Cloud Agent, Push Notification service should send a notification to the registered application.
Due to size limitations, push notification doesn't contain received messages by itself.
So when a push notification message is received by an application, it needs to call SDK function to download the message from the Cloud Agent with providing uid and forDid details from the notification body.

> **NOTE**: Current samples app provides only polling code samples.

##### Message status

After downloading and processing messages from the Cloud Agent, their status on the Agent must be manually changed as read by calling corresponding SDK function.
