export const EXTENSION_NAME = 'Front Matter CMS';

export const CONFIG_KEY = 'frontMatter';

export const SETTING_EXPERIMENTAL = 'experimental';

export const SETTING_EXTENSIBILITY_SCRIPTS = 'extensibility.scripts';

export const SETTING_EXTENDS = 'extends';
export const SETTING_CONFIG_DYNAMIC_FILE_PATH = 'config.dynamicFilePath';

export const SETTING_GLOBAL_NOTIFICATIONS = 'global.notifications';
export const SETTING_GLOBAL_NOTIFICATIONS_DISABLED = 'global.disabledNotifications';
export const SETTING_GLOBAL_MODES = 'global.modes';
export const SETTING_GLOBAL_ACTIVE_MODE = 'global.activeMode';
export const SETTING_GLOBAL_TIMEZONE = 'global.timezone';

export const SETTING_TAXONOMY_TAGS = 'taxonomy.tags';
export const SETTING_TAXONOMY_CATEGORIES = 'taxonomy.categories';
export const SETTING_TAXONOMY_CUSTOM = 'taxonomy.customTaxonomy';
export const SETTING_TAXONOMY_FIELD_GROUPS = 'taxonomy.fieldGroups';

export const SETTING_DATE_FORMAT = 'taxonomy.dateFormat';
export const SETTING_COMMA_SEPARATED_FIELDS = 'taxonomy.commaSeparatedFields';
export const SETTING_TAXONOMY_CONTENT_TYPES = 'taxonomy.contentTypes';

export const SETTING_SLUG_PREFIX = 'taxonomy.slugPrefix';
export const SETTING_SLUG_SUFFIX = 'taxonomy.slugSuffix';
export const SETTING_SLUG_TEMPLATE = 'taxonomy.slugTemplate';
export const SETTING_SLUG_UPDATE_FILE_NAME = 'taxonomy.alignFilename';

export const SETTING_INDENT_ARRAY = 'taxonomy.indentArrays';
export const SETTING_REMOVE_QUOTES = 'taxonomy.noPropertyValueQuotes';
export const SETTING_QUOTE_STRINGS = 'taxonomy.quoteStringValues';

export const SETTING_FRONTMATTER_TYPE = 'taxonomy.frontMatterType';

export const SETTING_SEO_TITLE_FIELD = 'taxonomy.seoTitleField';
export const SETTING_SEO_TITLE_LENGTH = 'taxonomy.seoTitleLength';
export const SETTING_SEO_SLUG_LENGTH = 'taxonomy.seoSlugLength';
export const SETTING_SEO_DESCRIPTION_LENGTH = 'taxonomy.seoDescriptionLength';
export const SETTING_SEO_CONTENT_MIN_LENGTH = 'taxonomy.seoContentLengh';
export const SETTING_SEO_DESCRIPTION_FIELD = 'taxonomy.seoDescriptionField';

export const SETTING_TEMPLATES_FOLDER = 'templates.folder';
export const SETTING_TEMPLATES_PREFIX = 'templates.prefix';
export const SETTING_TEMPLATES_ENABLED = 'templates.enabled';

export const SETTING_PANEL_FREEFORM = 'panel.freeform';
export const SETTING_PANEL_ACTIONS_DISABLED = 'panel.actions.disabled';

export const SETTING_PREVIEW_HOST = 'preview.host';
export const SETTING_PREVIEW_PATHNAME = 'preview.pathName';
export const SETTING_PREVIEW_TRAILING_SLASH = 'preview.trailingSlash';

export const SETTING_CUSTOM_SCRIPTS = 'custom.scripts';

export const SETTING_AUTO_UPDATE_DATE = 'content.autoUpdateDate';
export const SETTING_CONTENT_PAGE_FOLDERS = 'content.pageFolders';
export const SETTING_CONTENT_I18N = 'content.i18n';
export const SETTING_CONTENT_STATIC_FOLDER = 'content.publicFolder';
export const SETTING_CONTENT_FRONTMATTER_HIGHLIGHT = 'content.fmHighlight';
export const SETTING_CONTENT_DRAFT_FIELD = 'content.draftField';
export const SETTING_CONTENT_SORTING = 'content.sorting';
export const SETTING_CONTENT_GROUPING = 'content.grouping';
export const SETTING_CONTENT_FILTERS = 'content.filters';
export const SETTING_CONTENT_WYSIWYG = 'content.wysiwyg';
export const SETTING_CONTENT_PLACEHOLDERS = 'content.placeholders';
export const SETTING_CONTENT_SNIPPETS = 'content.snippets';

export const SETTING_CONTENT_SORTING_DEFAULT = 'content.defaultSorting';
export const SETTING_MEDIA_SORTING_DEFAULT = 'content.defaultSorting';

export const SETTING_CONTENT_DEFAULT_FILETYPE = 'content.defaultFileType';
export const SETTING_CONTENT_SUPPORTED_FILETYPES = 'content.supportedFileTypes';

export const SETTING_CONTENT_HIDE_FRONTMATTER = 'content.hideFm';
export const SETTING_CONTENT_HIDE_FRONTMATTER_MESSAGE = 'content.hideFmMessage';

export const SETTING_MEDIA_SUPPORTED_MIMETYPES = 'media.supportedMimeTypes';
export const SETTING_MEDIA_CONTENTTYPES = 'media.contentTypes';

export const SETTING_DASHBOARD_OPENONSTART = 'dashboard.openOnStart';
export const SETTING_DASHBOARD_CONTENT_TAGS = 'dashboard.content.cardTags';
export const SETTING_DASHBOARD_CONTENT_PAGINATION = 'dashboard.content.pagination';

// Content cards
export const SETTING_DASHBOARD_CONTENT_CARD_STATE = 'dashboard.content.card.fields.state';
export const SETTING_DASHBOARD_CONTENT_CARD_DATE = 'dashboard.content.card.fields.date';
export const SETTING_DASHBOARD_CONTENT_CARD_TITLE = 'dashboard.content.card.fields.title';
export const SETTING_DASHBOARD_CONTENT_CARD_DESCRIPTION =
  'dashboard.content.card.fields.description';

export const SETTING_DATA_FILES = 'data.files';
export const SETTING_DATA_FOLDERS = 'data.folders';
export const SETTING_DATA_TYPES = 'data.types';

export const SETTING_FILE_PRESERVE_CASING = 'file.preserveCasing';

export const SETTING_FRAMEWORK_ID = 'framework.id';
export const SETTING_FRAMEWORK_START = 'framework.startCommand';

export const SETTING_SITE_BASEURL = 'site.baseURL';

export const SETTING_GIT_ENABLED = 'git.enabled';
export const SETTING_GIT_DISABLED_BRANCHES = 'git.disableOnBranches';
export const SETTING_GIT_REQUIRES_COMMIT_MSG = 'git.requiresCommitMessage';
export const SETTING_GIT_COMMIT_MSG = 'git.commitMessage';
export const SETTING_GIT_SUBMODULE_PULL = 'git.submodule.pull';
export const SETTING_GIT_SUBMODULE_PUSH = 'git.submodule.push';
export const SETTING_GIT_SUBMODULE_BRANCH = 'git.submodule.branch';
export const SETTING_GIT_SUBMODULE_FOLDER = 'git.submodule.folder';

export const SETTING_SNIPPETS_WRAPPER = 'snippets.wrapper.enabled';

export const SETTING_WEBSITE_URL = 'website.host';

export const SETTING_COPILOT_FAMILY = 'copilot.family';

export const SETTING_LOGGING = 'logging';

/**
 * Sponsors only settings
 */
export const SETTING_SPONSORS_AI_ENABLED = 'sponsors.ai.enabled';

/**
 * Project override support
 */
export const SETTING_PROJECTS = 'projects';

/**
 * @deprecated
 */
export const SETTING_CONTENT_FOLDERS = 'content.folders';
/**
 * @deprecated
 * Use the `isPublishDate` property on the content type datetime field instead
 */
export const SETTING_DATE_FIELD = 'taxonomy.dateField';
