import * as React from 'react';
import { ReactNode } from 'react';
import { connectField } from 'uniforms';

import AutoField from './AutoField';
import ListDelField from './ListDelField';

export type ListItemFieldProps = { children?: ReactNode; value?: unknown };

function ListItem({ children = <AutoField label={null} name="" /> }: ListItemFieldProps) {
  return (
    <div>
      <ListDelField name="" />
      {children}
    </div>
  );
}

export default connectField<ListItemFieldProps>(ListItem, {
  initialValue: false
});
