## Issues

#### Guidelines

When reporting a possible bug, provide detail steps so that we will be able
to reproduce the issue. Steps to reproduce should be clear and unambiguous. Try not to use phrases like "very big bug",
"huge issue", "useless feature", etc. No need to use exclamation marks as well.

#### No support

Note that we don't provide developer help or any kind of support on GitHub.
For this, please use our [forum](https://forum.espocrm.com).

#### Forum

If you are very new to EspoCRM, it's probable that an issue you ran into is not a bug.
Consider creating a topic on our [forum](https://forum.espocrm.com/forum/general) instead.

#### Project's best interest

The issue tracker is for the benefit of the EspoCRM project. The project maintainers are going to handle issues in the project's best interest.
The maintainers have right to close issues without explanation.

#### Off-topic

As we reference GitHub issues in release notes, we strive to keep them free of off-topic comments.

## Pull Requests

We are open for contributions that are bug fixes and small improvements. If you would like to contribute something that is not a small fix, please reach out to maintainers before submitting your PR (by creating a GitHub issue).

Before we can merge your pull request, you need to accept our CLA [here](https://github.com/espocrm/cla).

It's desirable that one PR solves one specific problem. Do not include code style changes to PRs
(unless the main purpose of the PR is a code style fix).

Branches:

* *master* – the develop branch; new features should be pushed to here;
* *fix* – the upcoming maintenance release; small fixes should be pushed to here.
