import 'package:flutter/material.dart';

class BottomNav extends StatelessWidget {
  final int currentIndex;
  final Function(int) onTap;

  const BottomNav({super.key, required this.currentIndex, required this.onTap});

  @override
  Widget build(BuildContext context) {
    final double height = MediaQuery.of(context).size.height;
    final double width = MediaQuery.of(context).size.width;

    return Container(
      height: height * 0.1,
      decoration: BoxDecoration(
        color: Colors.blue,
        boxShadow: [
          BoxShadow(
            color: Colors.grey.withOpacity(0.3),
            spreadRadius: 1,
            blurRadius: 5,
            offset: const Offset(0, -3),
          ),
        ],
      ),
      child: Row(
        mainAxisAlignment: MainAxisAlignment.spaceAround,
        children: [
          _buildNavItem(0, 'assets/images/characters.png', 'Characters', width),
          _buildNavItem(1, 'assets/images/locations.png', 'Locations', width),
          _buildNavItem(2, 'assets/images/episodes.png', 'Episodes', width),
        ],
      ),
    );
  }

  Widget _buildNavItem(
      int index, String iconPath, String label, double screenWidth) {
    final isSelected = currentIndex == index;

    return GestureDetector(
      onTap: () => onTap(index),
      child: Container(
        width: screenWidth * 0.3,
        padding: const EdgeInsets.symmetric(vertical: 8),
        child: Column(
          mainAxisSize: MainAxisSize.min,
          children: [
            Image.asset(
              iconPath,
              width: 32,
              height: 32,
              color: isSelected ? Colors.white : const Color.fromARGB(129, 250, 250, 250),
            ),
            const SizedBox(height: 2.5),
            Text(
              label,
              style: TextStyle(
                color:
                    isSelected ? Colors.white : const Color.fromARGB(129, 250, 250, 250),
                fontSize: 13,
                fontWeight: isSelected ? FontWeight.bold : FontWeight.normal,
              ),
            ),
          ],
        ),
      ),
    );
  }
}
