import Cocoa
@testable import Utils

class StyleWatcher {
    /**
     * IMPORTANT: ⚠️️ StyleManger.addStylesByURL("",true)<--liveEdit flag must be true to use this watch feature
     */
    static func watch(_ folderURL:String,_ fileURL:String, _ view:NSView) {
        let fileWatcher = FileWatcher([folderURL.tildePath])
        fileWatcher.callback = { event in
            if(event.fileChange && FilePathParser.fileExtension(event.path) == "css") {//assert for .css file changes, so that .ds etc doesnt trigger events etc
                Swift.print(event.description)
                Swift.print("update to the file happened: " + "\(event.path)")
                StyleManager.addStyle(url:fileURL,liveEdit:true)
                ElementModifier.refreshSkin(view as! ElementKind)
                ElementModifier.floatChildren(view)
            }
        }
        fileWatcher.start()
    }
}
