import Cocoa
@testable import Utils
/*
 * NOTE:  having seperate values: hasStyleChanged and :hasSizeChanged and hasSkinState changed is usefull for optimization
 */
class Skin:InteractiveView,Skinable{
    private(set) public var style:Stylable?
    private(set) public var state:String
//    var skinSize:CGSize?//this should be priv pub
    private(set) public var hasChanged:HasChanged = (style:false,state:false,size:false)
    var decoratables:[GraphicDecoratableKind] = []/*The layers in the skin*/
    
    init(_ style:Stylable? = nil, _ state:String = ""){//TODO: ⚠️️⚠️️⚠️️ You can refactor out the element by using didMoveToSuperView and initing the draw inside that call
        self.style = style
        self.state = state
        super.init(frame:NSRect())/*<-this doesn't need a size, since Graphic will have frame*/
    }
    /**
     * Sort of like resolveSkin
     */
    override func viewDidMoveToSuperview() {
//        Swift.print("viewDidMoveToSuperview superview:\(superview)")
        guard superview != nil else { return}/*this method is fired when you remove a view as well. So to only check for adding you have this assert*/
//        resolveSkin()
        parent?.frame.size = Utils.size(self)
    }
    /**
     * Resets skinState
     */
    func draw(){
        hasChanged = (false,false,false)
    }
    /**
     * Sets the style instance to apply to the skin also forces a redraw.
     * NOTE: this is a great way to update an skin without querying StyleManager
     */
    func setStyle(_ style:Stylable){
        hasChanged.style = true
        self.style = style
        draw()
    }
    /**
     * Sets the skin state and forces a redraw
     * NOTE: forces a lookup of the style in the StyleManager, since it has to look for the correct state of the style
     * TODO: ⚠️️ Optionally rename state to skin_state since state may be used when implementing the NSEffectview for Translucency support
     * ⚠️️ IMPORTANT: ⚠️️ This is an expensive call: "loops through the entire styleManager" (Use setStyle for light-weight call)
     */
    func setSkinState(_ state:String){//TODO: I think this method is save to rename back to setState now since ISKin etends class this problem is gone, or is it because skinState is named state?
        hasChanged.state = true
        self.state = state
        style = StyleResolver.style(parent!)/*TODO: ⚠️️looping through the entire styleManager isn't a good idea for just a state change, you need some caching system to handle this better*/
        draw()
    }
    /**
     * Sets the width and height of skin also forces a redraw.
     * IMPORTANT: ⚠️️ Similar to setStyle, this does not querry the styleManger when called
     */
    //How is this relevant now? 🏀
    func setSize(_ width:CGFloat, _ height:CGFloat) {
//        guard self.skinSize?.width != width || self.skinSize?.height != height else {return}// :TODO: ⚠️️ this is probably wrong, since we get width and height from SkinParser.width and SkinParser.height now (since wee need margin and padding in the tot calculation of the sizes)
        hasChanged.size = true
//        skinSize = CGSize(width,height)
        draw()
    }
    required init(coder: NSCoder) {fatalError("init(coder:) has not been implemented")}/*Required by super class*/
}

private class Utils{
    /**
     * this is new, its a way for css to set parent element frame. because frame needs to be set if you want textfield caret to work, also makes sense structurally
     * Returns the width that is generated by first looking to see if there is a width value in the style, and if that value is percentage then get the width from the parent skin or if there is no width value in style use the _width variable that originated from the construction of the skin
     * NOTE: these methods are an important part of the float system
     * IMPORTANT: ⚠️️ This is "overriden" in TextSkin
     */
    static func size(_ skin:Skinable) -> CGSize{
        let w = StyleMetricParser.width(skin) ?? skin.parent?.frame.w ?? {fatalError("err")}()
        let h = StyleMetricParser.height(skin) ?? skin.parent?.frame.h ?? {fatalError("err")}()
        let size = CGSize(w,h)//sometimes css has width and frame has height so we need to check both w and h
        return size
    }
}
