# Software

- `Python`
    - <b>`Aorun`</b> [Deep Learning over PyTorch](https://github.com/ramon-oliveira/aorun)
    - <b>`Chainer`</b> [Chainer bridge the gap between algorithms and implementations of deep learning.](http://chainer.org/)
    - <b>`ChainerMN`</b> [ChainerMN: Scalable distributed deep learning with Chainer](https://github.com/chainer/chainermn)
    - <b>`ChainerRL`</b> [A deep reinforcement learning library built on top of Chainer.](https://github.com/pfnet/chainerrl)
    - <b>`Coach`</b> [Reinforcement Learning Coach by Intel](https://github.com/NervanaSystems/coach)
    - <b>`Colossal-AI`</b> [A Unified Deep Learning System for Big Model Era](https://github.com/hpcaitech/ColossalAI)
    - <b>`DeepPy`</b> [A Pythonic deep learning framework built on top of NumPy.](https://github.com/andersbll/deeppy)
    - <b>`Deepnet`</b> [A GPU-based python implementation of deep learning algorithms.](https://github.com/nitishsrivastava/deepnet) 
    - <b>`Deepgaze`</b> [A computer vision library for human-computer interaction based on CNNs](https://github.com/mpatacchiola/deepgaze) 
    - <b>`Determined`</b> [Deep learning training platform with integrated support for distributed training, hyperparameter tuning, smart GPU scheduling, experiment tracking, and a model registry.](https://github.com/determined-ai/determined)
    - <b>`Edward`</b> [A library for probabilistic modeling, inference, and criticism.](http://edwardlib.org/) 
    - <b>`Elephas`</b> [Distributed Deep learning with Keras & Spark.](https://github.com/maxpumperla/elephas)
    - <b>`fastai`</b>[The fast.ai deep learning library, lessons, and tutorials](https://github.com/fastai/fastai)
    - <b>`Gensim`</b> [Deep learning toolkit implemented in python programming language intended for handling large text collections, using efficient algorithms.](http://radimrehurek.com/gensim/)
    - <b>`Hebel`</b> [A library for deep learning with neural networks in Python using GPU acceleration with CUDA through PyCUDA.](https://github.com/hannes-brt/hebel)
    - <b>`Keras`</b> [Deep Learning library for Theano and TensorFlow.](https://keras.io/)  :star:
    - <b>`Kur`</b> [Descriptive Deep Learning.](https://github.com/deepgram/kur)  :star:
    - <b>`Mujoco-py`</b> [MuJoCo is a physics engine for detailed, efficient rigid body simulations with contacts. mujoco-py allows using MuJoCo from Python 3.](https://github.com/openai/mujoco-py)
    - <b>`Neon`</b> [Neon is Nervana's Python based Deep Learning framework](https://github.com/NervanaSystems/neon).
    - <b>`Pyclustering`</b> [A Python, C++ data mining clustering, graph coloring algorithms, oscillatory networks, neural networks library.](https://github.com/annoviko/pyclustering)
    - <b>`PyTorch`</b> [Tensors and Dynamic neural networks in Python with strong GPU acceleration.](http://pytorch.org/) :star:
    - <b>`Scikit-Learn`</b> [Machine learning in Python.](http://scikit-learn.org)  :star:
        - <b>`Semisup-Learn`</b> [Semi-supervised learning frameworks for Python](https://github.com/tmadl/semisup-learn)
    - <b>SerpentAI</b> [Game Agent Framework. Helping you create AIs / Bots to play any game you own](https://github.com/SerpentAI/SerpentAI)
    - <b>`Skll`</b> [SciKit-Learn Laboratory (SKLL) makes it easy to run machine learning experiments.](https://github.com/EducationalTestingService/skll)
    - <b>`Sonnet`</b> [TensorFlow-based neural network library](https://github.com/deepmind/sonnet)
    - <b>`Tensorflow`</b> [An open source software library for numerical computation using data flow graph by Google](https://www.tensorflow.org/) :star:
         - <b>`Polyaxon`</b> [Deep Learning library for TensorFlow for building end to end models and experiments.](https://github.com/polyaxon/polyaxon)
    - <b>`TensorFX`</b> [An end to end application framework to simplifies machine learning with TensorFlow](https://github.com/TensorLab/tensorfx)
    - <b>`Theano`</b> [Mathematical library in Python, maintained by LISA lab](http://deeplearning.net/software/theano/) 
        - <b>`Pylearn2`</b> [Theano-based deep learning libraries](http://deeplearning.net/software/pylearn2/) 
        - <b>`Blocks`</b> [A framework that helps you build neural network models on top of Theano](https://github.com/mila-udem/blocks)  :star:
        - <b>`Lasagne`</b> [Lightweight library to build and train neural networks in Theano.](https://github.com/Lasagne/Lasagne) 
    - <b>`WebDNN`</b> [Fastest DNN Execution Framework on Web Browser](https://mil-tokyo.github.io/webdnn/)
    - <b>`Neuraxle`</b> [Code Machine Learning Pipelines - The Right Way](https://github.com/Neuraxio/Neuraxle)
- `C++`
    - <b>`Caffe`</b> [Deep learning framework by the BVLC](http://caffe.berkeleyvision.org/) :star:
    - <b>`clDNN` </b>[Compute Library for Deep Neural Networks](https://github.com/01org/clDNN) 
    - <b>`CNTK` </b>[The Microsoft Cognitive Toolkit.](https://github.com/Microsoft/CNTK) 
    - <b>`DeepDetect` </b>[Open Source Deep Learning Server & API](https://deepdetect.com/) 
    - <b>`DIGITS`</b> [A new system for developing, training and visualizing deep neural networks.](https://developer.nvidia.com/digits) 
    - <b>`Dlib`</b> [A modern C++ toolkit containing machine learning algorithms and tools for creating complex software in C++.](http://dlib.net/)
    - <b>`Dll`</b> [Deep Learning Library](https://github.com/wichtounet/dll)
    - <b>`DSSTNE`</b> [An Amazon developed library for building Deep Learning (DL) machine learning (ML) models.](https://github.com/amznlabs/amazon-dsstne) 
    - <b>`Jik`</b> [Lightweight Deep Learning Framework](https://github.com/oliviersoares/jik)
    - <b>`Kann`</b> [A lightweight C library for artificial neural networks](https://github.com/attractivechaos/kann)
    - <b>`OpenNN`</b> [OpenNN - Open Neural Networks Library](https://github.com/Artelnics/OpenNN)
    - <b>`PaddlePaddle`</b> [An easy-to-use, efficient, flexible and scalable deep learning platform.](http://www.paddlepaddle.org/)
    - <b>`MaTEx`</b> [Machine Learning Toolkit for Extreme Scale](https://github.com/matex-org/matex)
    - <b>`MRPT`</b> [The Mobile Robot Programming Toolkit (MRPT)](https://github.com/MRPT/mrpt)
    - <b>`MXNet`</b> [A flexible and efficient deep learning library for heterogeneous distributed systems with multi-language support](http://mxnet.io/) :star:
        - <b>`MinPy`</b> [Providing a high performing and flexible deep learning platform, by prototyping a pure NumPy interface above MXNet backend.](https://github.com/dmlc/minpy)
    - <b>`Neural Designer`</b> [Neural Designer is the most advanced analytics software](https://www.neuraldesigner.com/)
    - <b>`NNabla`</b> [NNabla is a deep learning framework that is intended to be used for research, development and production](https://nnabla.org/)
    - <b>`NVIDIA TensorRT`</b> [High performance deep learning inference for production deployment](https://developer.nvidia.com/tensorrt)
    - <b>`Singa`</b> [An Apache Incubating project for developing an open source deep learning library.](http://singa.incubator.apache.org/en/index.html)
    - <b>`Tiny-dnn`</b> [A C++11 implementation of deep learning.](https://github.com/tiny-dnn/tiny-dnn)
- `Java`
    - <b>`Stanford CoreNLP`</b> [A Java suite of core NLP tools.](https://github.com/stanfordnlp/CoreNLP)
    - <b>`Deeplearning4J`</b> [Neural Net Platform.](https://github.com/deeplearning4j/deeplearning4j) 
    - <b>`NeuralNetworks`</b> [This is a Java implementation of some of the algorithms for training deep neural networks.](https://github.com/ivan-vasilev/neuralnetworks) 
    - <b>`NewralNet`</b> [A lightweight, easy to use and open source Java library for experimenting with feed-forward neural nets and deep learning.](https://gitlab.com/flimmerkiste/NewralNet/tree/master)
- `Scala`
    - <b>`BigDL`</b> [Distributed Deep learning on Apache Spark.](https://github.com/intel-analytics/BigDL) 
- `Julia`
    - <b>`Knet`</b> [The Koç University deep learning framework implemented in Julia.](https://github.com/denizyuret/Knet.jl)
    - <b>`Mocha`</b> [A Deep Learning framework for Julia, inspired by the C++ framework Caffe.](https://github.com/pluskid/Mocha.jl) 
- `Js`
    - <b>`Brain`</b> [Brain.js is a library of JavaScript neural networks.](https://github.com/harthur-org/brain.js)
    - <b>`Deeplearnjs`</b> [A hardware-accelerated machine intelligence library for the web.](https://github.com/PAIR-code/deeplearnjs)
    - <b>`Keras-js`</b> [Run Keras models (tensorflow backend) in the browser, with GPU support.](https://github.com/transcranial/keras-js)
    - <b>`Neataptic`</b> [Flexible neural network library with advanced neuroevolution](https://github.com/wagenaartje/neataptic)
    - <b>`Neurojs`</b> [A javascript deep learning and reinforcement learning library.](https://github.com/janhuenermann/neurojs)
    - <b>`Synapses`</b> [A lightweight library for neural networks that runs anywhere.](https://github.com/mrdimosthenis/Synapses) 
- `Matlab`
    - <b>`MatConvNet`</b> [CNNs for MATLAB](http://www.vlfeat.org/matconvnet/) 
    - <b>`DLMatFramework`</b> [Deep Learning Matlab Framework](https://github.com/leonardoaraujosantos/DLMatFramework)
- `Lua`
    - <b>`OpenNMT`</b> [Open-Source Neural Machine Translation](https://github.com/opennmt/opennmt)
    - <b>`Torch7`</b> [Deep learning library in Lua, used by Facebook and Google Deepmind](http://torch.ch/)  :star:
- `Php`
    - <b>`PHP-ML`</b> [Machine Learning library for PHP](https://github.com/php-ai/php-ml)
- `Dub`
    - <b>`Vectorflow`</b> [A minimalist neural network library optimized for sparse data and single machine environments.](https://github.com/Netflix/vectorflow)
    
