## before 2010

- A fast learning algorithm for deep belief nets.  [[url](https://www.google.co.jp/url?sa=t&rct=j&q=&esrc=s&source=web&cd=1&cad=rja&uact=8&ved=0ahUKEwjmxcXKjtDQAhVEjpQKHU5uAVkQFgggMAA&url=https%3A%2F%2Fwww.cs.toronto.edu%2F~hinton%2Fabsps%2Ffastnc.pdf&usg=AFQjCNELT7wVLLgpvARk6bCARpfzwWUOLg)] :star: 
- A Tutorial on Energy-Based Learning.  [[url]](https://www.google.co.jp/url?sa=t&rct=j&q=&esrc=s&source=web&cd=1&cad=rja&uact=8&ved=0ahUKEwiBk8i0jtDQAhVFJJQKHffxCp0QFggdMAA&url=http%3A%2F%2Fyann.lecun.com%2Fexdb%2Fpublis%2Fpdf%2Flecun-06.pdf&usg=AFQjCNHSCWGMFSXY4CSmXrAC4UpJD6izOw)
- <b>[LeNet]</b> Gradient-based learning applied to document recognition. [[pdf](http://yann.lecun.com/exdb/lenet/)] :star: 
- Constructing Informative Priors using Transfer Learning. [[url](http://ai.stanford.edu/~ang/papers/icml06-transferinformativepriors.pdf)]
- Connectionist Temporal Classification: Labelling unsegmented Sequence Data with Recurrent Neural Networks. [[url](https://www.google.com/url?sa=t&rct=j&q=&esrc=s&source=web&cd=1&cad=rja&uact=8&ved=0ahUKEwjf9J2yoo7RAhUoxFQKHZFPD_wQFggfMAA&url=http%3A%2F%2Fmachinelearning.wustl.edu%2Fmlpapers%2Fpaper_files%2Ficml2006_GravesFGS06.pdf&usg=AFQjCNFrqG2eQSvESxvp7EhHYfe9y-gH_Q)]
- Deep Boltzmann Machines.  [[url](http://www.utstat.toronto.edu/~rsalakhu/papers/dbm.pdf)] :star: 
- Exploring Strategies for Training Deep Neural Networks.  [[url]](https://www.google.co.jp/url?sa=t&rct=j&q=&esrc=s&source=web&cd=1&cad=rja&uact=8&ved=0ahUKEwiawMrP7NDQAhXJTLwKHeZzBxgQFgggMAA&url=http%3A%2F%2Fdeeplearning.cs.cmu.edu%2Fpdfs%2F1111%2Fjmlr10_larochelle.pdf&usg=AFQjCNE9A4CWIZpcCM4FFVcB5lWL-49mlw)
- Efficient Learning of Sparse Representations with an Energy-Based Model.  [[url]](https://www.google.co.jp/url?sa=t&rct=j&q=&esrc=s&source=web&cd=1&cad=rja&uact=8&ved=0ahUKEwjSloOhjtDQAhVBRJQKHaWRAicQFgghMAA&url=https%3A%2F%2Fpapers.nips.cc%2Fpaper%2F3112-efficient-learning-of-sparse-representations-with-an-energy-based-model.pdf&usg=AFQjCNFZs1ap9T-WHpdAUtFgX2aFs-38sg) :star: 
- Efficient sparse coding algorithms.  [[url]](https://www.google.co.jp/url?sa=t&rct=j&q=&esrc=s&source=web&cd=1&cad=rja&uact=8&ved=0ahUKEwipv5r1kNDQAhVDGZQKHXXjC-cQFggiMAA&url=http%3A%2F%2Fpapers.nips.cc%2Fpaper%2F2979-efficient-sparse-coding-algorithms.pdf&usg=AFQjCNEZEP5SxMogeVfZA0mmECXQzQXfqQ) :star: 
- Energy-Based Models in Document Recognition and Computer Vision.  [[url]](https://www.google.co.jp/url?sa=t&rct=j&q=&esrc=s&source=web&cd=1&cad=rja&uact=8&ved=0ahUKEwipucXYkNDQAhUDj5QKHcTrCKMQFggjMAA&url=http%3A%2F%2Fyann.lecun.com%2Fexdb%2Fpublis%2Fpdf%2Flecun-icdar-keynote-07.pdf&usg=AFQjCNFXXuq-tKKteAowMiWkRLhhBl89nA)
- Extracting and Composing Robust Features with Denoising Autoencoders.  [[url]](https://www.google.co.jp/url?sa=t&rct=j&q=&esrc=s&source=web&cd=1&cad=rja&uact=8&ved=0ahUKEwiLicmC7NDQAhXFXrwKHY0ADcUQFgggMAA&url=http%3A%2F%2Fmachinelearning.org%2Farchive%2Ficml2008%2Fpapers%2F592.pdf&usg=AFQjCNHhfwA6PKI3gKjnBc36z7Jqs7d0mw) :star: 
- Fast Inference in Sparse Coding Algorithms with Applications to Object Recognition.  [[url]](https://www.google.co.jp/url?sa=t&rct=j&q=&esrc=s&source=web&cd=2&cad=rja&uact=8&ved=0ahUKEwjByO3069DQAhVET7wKHcwSDFQQFggvMAE&url=https%3A%2F%2Farxiv.org%2Fpdf%2F1010.3467&usg=AFQjCNHcNp5zQf6YypllW96kWFpXXMCB7g)
- Gaussian Process Models for Link Analysis and Transfer Learning. [[url](http://papers.nips.cc/paper/3284-gaussian-process-models-for-link-analysis-and-transfer-learning.pdf)]
- Greedy Layer-Wise Training of Deep Networks. [[url]](https://www.google.co.jp/url?sa=t&rct=j&q=&esrc=s&source=web&cd=1&cad=rja&uact=8&ved=0ahUKEwic_va3kNDQAhWDF5QKHdw7A-YQFgggMAA&url=https%3A%2F%2Fpapers.nips.cc%2Fpaper%2F3048-greedy-layer-wise-training-of-deep-networks.pdf&usg=AFQjCNEKqhptR9m0CF7Ygu6UhJD3teRXnQ) :star: 
- Learning Invariant Features through Topographic Filter Maps. [[url]](https://www.google.co.jp/url?sa=t&rct=j&q=&esrc=s&source=web&cd=1&cad=rja&uact=8&ved=0ahUKEwjPn5m07NDQAhUIvrwKHY0WCKoQFgggMAA&url=http%3A%2F%2Fwww.cs.toronto.edu%2F~ranzato%2Fpublications%2Fkavukcuoglu-cvpr09.pdf&usg=AFQjCNFsBjrEyT8Ct8hlBz2h82ngVcp_wA)
- Linear Spatial Pyramid Matching Using Sparse Coding for Image Classification. [[url]](https://www.google.co.jp/url?sa=t&rct=j&q=&esrc=s&source=web&cd=1&cad=rja&uact=8&ved=0ahUKEwiGkqSn7NDQAhWCa7wKHWtwBSUQFggjMAA&url=http%3A%2F%2Fwww.ifp.illinois.edu%2F~jyang29%2Fpapers%2FCVPR09-ScSPM.pdf&usg=AFQjCNFJtIxHQ6evWkvnfax-9HVg4G8SdQ) :star: 
- Mapping and Revising Markov Logic Networks for Transfer Learning. [[url](http://www.aaai.org/Papers/AAAI/2007/AAAI07-096.pdf)]
- Nonlinear Learning using Local Coordinate Coding.  [[url](https://www.google.co.jp/url?sa=t&rct=j&q=&esrc=s&source=web&cd=1&cad=rja&uact=8&ved=0ahUKEwiyobCZ7NDQAhVFgrwKHQ_EC1kQFgggMAA&url=http%3A%2F%2Fece.duke.edu%2F~lcarin%2Fnips09_lcc.pdf&usg=AFQjCNFWboAUuKb5D50fnZFVsx4TWuCwTw)] :star: 
- Notes on Convolutional Neural Networks. [[url]](https://www.google.co.jp/url?sa=t&rct=j&q=&esrc=s&source=web&cd=1&cad=rja&uact=8&ved=0ahUKEwiuh-SFjtDQAhUMjZQKHQ8xAxAQFggiMAA&url=http%3A%2F%2Fcogprints.org%2F5869%2F1%2Fcnn_tutorial.pdf&usg=AFQjCNGqmw7vLOJXSwyHyS6SPTDD5VOiGg)
- Reducing the Dimensionality of Data with Neural Networks. [[science](http://science.sciencemag.org/content/313/5786/504)] :star: 
- To Recognize Shapes, First Learn to Generate Images.  [[url]](https://www.google.co.jp/url?sa=t&rct=j&q=&esrc=s&source=web&cd=1&cad=rja&uact=8&ved=0ahUKEwjNk4jKjNDQAhUMppQKHROED1cQFgggMAA&url=http%3A%2F%2Fwww.cs.toronto.edu%2F~fritz%2Fabsps%2FmontrealTR.pdf&usg=AFQjCNGmWlKfMB2j-3PWensTW6Q6k9A1uA)
- Scaling Learning Algorithms towards AI.  [[url](https://www.google.co.jp/url?sa=t&rct=j&q=&esrc=s&source=web&cd=1&cad=rja&uact=8&ved=0ahUKEwjmk-SjkNDQAhVFipQKHapJAKQQFggiMAA&url=http%3A%2F%2Fyann.lecun.com%2Fexdb%2Fpublis%2Fpdf%2Fbengio-lecun-07.pdf&usg=AFQjCNGsg3RffgzLebvpoqnCMK7BFEA-3A)] :star: 
- Sparse deep belief net model for visual area V2.  [[url](https://www.google.co.jp/url?sa=t&rct=j&q=&esrc=s&source=web&cd=1&cad=rja&uact=8&ved=0ahUKEwjTr5b4j9DQAhUTv5QKHROTAHMQFgggMAA&url=http%3A%2F%2Fai.stanford.edu%2F~ang%2Fpapers%2Fnips07-sparsedeepbeliefnetworkv2.pdf&usg=AFQjCNHRZL9gavkOrCmx0OdMzD9blaUC8Q)] :star: 
- Sparse Feature Learning for Deep Belief Networks.  [[url]](https://www.google.co.jp/url?sa=t&rct=j&q=&esrc=s&source=web&cd=1&cad=rja&uact=8&ved=0ahUKEwiNiK3Wj9DQAhUBt5QKHVOsDKIQFgggMAA&url=https%3A%2F%2Fpapers.nips.cc%2Fpaper%2F3363-sparse-feature-learning-for-deep-belief-networks.pdf&usg=AFQjCNFNpWYDTG49fBdogmG-7L4tDgM7kQ)
- Training restricted Boltzmann machines using approximations to the likelihood gradient.  [[url]](https://www.google.co.jp/url?sa=t&rct=j&q=&esrc=s&source=web&cd=1&cad=rja&uact=8&ved=0ahUKEwjH1Kvp69DQAhVEVbwKHVo8A70QFgggMAA&url=http%3A%2F%2Fwww.machinelearning.org%2Farchive%2Ficml2008%2Fpapers%2F638.pdf&usg=AFQjCNF2KMp3ZrdqkeUwe0v_jYoEGmuPDg)
- Training Products of experts by minimizing contrastive divergence</b>. [[url]](Training Products of Experts by Minimizing Contrastive Divergence)] :star: 
- Using Fast Weights to Improve Persistent Contrastive Divergence.  [[url](https://www.google.co.jp/url?sa=t&rct=j&q=&esrc=s&source=web&cd=1&cad=rja&uact=8&ved=0ahUKEwiNt4WO7NDQAhVGybwKHR5yC6sQFgggMAA&url=http%3A%2F%2Fwww.cs.toronto.edu%2F~tijmen%2Ffpcd%2Ffpcd.ps.gz&usg=AFQjCNEfcQVHseNmdUyK1q6nVcyYM-9-dQ)] :star: 
- Unsupervised Learning of Invariant Feature Hierarchies with Applications to Object Recognition.  [[url](https://www.google.co.jp/url?sa=t&rct=j&q=&esrc=s&source=web&cd=1&cad=rja&uact=8&ved=0ahUKEwjjrqmLj9DQAhUEI5QKHWe2CCcQFgggMAA&url=http%3A%2F%2Fyann.lecun.com%2Fexdb%2Fpublis%2Fpdf%2Franzato-cvpr-07.pdf&usg=AFQjCNFwvKjLRcBMth7fYufJcCZzmirlOw)]
- What is the Best Multi-Stage Architecture for Object Recognition?.  [[url](https://www.google.co.jp/url?sa=t&rct=j&q=&esrc=s&source=web&cd=1&cad=rja&uact=8&ved=0ahUKEwi5pMD46tDQAhUBxrwKHcVNBSUQFggdMAA&url=http%3A%2F%2Fyann.lecun.com%2Fexdb%2Fpublis%2Fpdf%2Fjarrett-iccv-09.pdf&usg=AFQjCNFNWVpfiBL6O_xYc_FzAf2RF2VyTw)] :star: 

### Transfer learning

- A Survey on Transfer Learning. [[url]](https://www.google.com/url?sa=t&rct=j&q=&esrc=s&source=web&cd=3&cad=rja&uact=8&ved=0ahUKEwj2zKuZr47RAhVqqVQKHWk0BtYQFgg5MAI&url=%68%74%74%70%3a%2f%2f%63%73%2e%67%6d%75%2e%65%64%75%2f%7e%63%61%72%6c%6f%74%74%61%2f%74%65%61%63%68%69%6e%67%2f%43%53%37%37%35%2d%73%31%30%2f%72%65%61%64%69%6e%67%73%2f%74%72%61%6e%73%66%65%72%6c%65%61%72%6e%69%6e%67%2e%70%64%66&usg=AFQjCNFwymAVN8XeRhulhDnWBSc_ErtzYA)] :star: 
- Modeling Transfer Relationships Between Learning Tasks for Improved Inductive Transfer. [[pdf](http://maple.cs.umbc.edu/papers/ModelingTransferRelationships.pdf)]
- To Transfer or Not To Transfer.[[url](http://web.engr.oregonstate.edu/~tgd/publications/rosenstein-marx-kaelbling-dietterich-hnb-nips2005-transfer-workshop.pdf)]
- Transfer learning for text classification. [[url](http://robotics.stanford.edu/~ang/papers/nips05-transfer.pdf)]
- Transfer learning for collaborative filtering via a rating-matrix generative model.[[url](https://www.google.com/url?sa=t&rct=j&q=&esrc=s&source=web&cd=4&cad=rja&uact=8&ved=0ahUKEwjNs6n5so7RAhVJrVQKHbKsDFEQFghEMAM&url=http%3A%2F%2Fvideolectures.net%2Fsite%2Fnormal_dl%2Ftag%3D47942%2Ficml09_li_tlcfvrmgm_01.pdf&usg=AFQjCNGUCLWwmiR1zhCb6L_BzmMHyB6z5w)]
- Transfer learning from multiple source domains via consensus regularization. [[url](https://www.google.com/url?sa=t&rct=j&q=&esrc=s&source=web&cd=3&cad=rja&uact=8&ved=0ahUKEwiloLWpuo7RAhWqrFQKHbyMD-kQFggwMAI&url=http%3A%2F%2Fwww3.ntu.edu.sg%2Fhome%2Fsinnopan%2Fpublications%2F%5BEMCL14%5DTransfer%2520Learning%2520with%2520Multiple%2520Sources%2520via%2520Consensus%2520Regularized%2520Autoencoders.pdf&usg=AFQjCNFi6ftA2gms7vi71-ktkt_WTum46Q)]
- Transfer Learning for Reinforcement Learning Domains: A Survey. [[url](https://www.google.com/url?sa=t&rct=j&q=&esrc=s&source=web&cd=1&cad=rja&uact=8&ved=0ahUKEwiu9KmlsY7RAhXJiVQKHTs_B34QFggfMAA&url=http%3A%2F%2Fwww.cs.utexas.edu%2F~ai-lab%2Fpubs%2FJMLR09-taylor.pdf&usg=AFQjCNH-Irnjnro_TgQx2T9D8mAz4KwHhw)] :star: 
- <b>[Zero-Shot]</b> Zero-Shot Learning with Semantic Output Codes. [`pdf`](http://www.cs.cmu.edu/afs/cs/project/theo-73/www/papers/zero-shot-learning.pdf) :star:

#### Instance transfer

- An improved categorization of classifier’s sensitivity on sample selection bias. [[pdf](https://pdfs.semanticscholar.org/c43c/f8d7fbb41bb9c415f83574ea251b0273acbe.pdf)]
- Boosting for transfer learning. [[url](https://www.google.com/url?sa=t&rct=j&q=&esrc=s&source=web&cd=1&cad=rja&uact=8&ved=0ahUKEwjb4qT6r47RAhVDl1QKHfYYAfIQFgghMAA&url=http%3A%2F%2Fftp.cse.ust.hk%2F~qyang%2FDocs%2F2007%2Ftradaboost.pdf&usg=AFQjCNHrEGRLIvusHTEIwYmIGRUsUqeuPw)] :star: 
    - A Decision-Theoretic Generalization of On-Line Learning and an Application to Boosting. [[pdf](http://www.face-rec.org/algorithms/Boosting-Ensemble/decision-theoretic_generalization.pdf)] :star: 
- Correcting sample selection bias by unlabeled data. [[pdf](https://papers.nips.cc/paper/3075-correcting-sample-selection-bias-by-unlabeled-data.pdf)]
- Cross domain distribution adaptation via kernel mapping. [[pdf](http://xueshu.baidu.com/s?wd=paperuri%3A%28561d2ced4ef800e5c475d510a9b9cb2b%29&filter=sc_long_sign&tn=SE_xueshusource_2kduw22v&sc_vurl=http%3A%2F%2Fciteseerx.ist.psu.edu%2Fviewdoc%2Fdownload%3Bjsessionid%3DD2DFDC65A233E29C69866A058656020A%3Fdoi%3D10.1.1.157.9773%26rep%3Drep1%26type%3Dpdf&ie=utf-8&sc_us=6113889194888417404)]
- Direct Importance Estimation with Model Selection and Its Application to Covariate Shift Adaptation.[[pdf](https://papers.nips.cc/paper/3248-direct-importance-estimation-with-model-selection-and-its-application-to-covariate-shift-adaptation.pdf)] 
- Discriminative learning for differing training and test distributions. [[pdf](http://machinelearning.org/proceedings/icml2007/papers/303.pdf)]
- Domain Adaptation via Transfer Component Analysis. [[pdf](http://home.cse.ust.hk/~qyang/Docs/2009/TCA.pdf)] :star: 
- Instance Weighting for Domain Adaptation in NLP. [[pdf](http://sifaka.cs.uiuc.edu/czhai/pub/acl07.pdf)]
- Logistic regression with an auxiliary data source. [[pdf](http://people.ee.duke.edu/~xjliao/paper/ICML05_MigLogit.pdf)]
- Transferring Naive Bayes Classifiers for Text Classification. [[pdf](https://www.cse.ust.hk/~qyang/Docs/2007/daiaaai07.pdf)]

#### Feature representation transfer

- A Spectral Regularization Framework for Multi-Task Structure Learning. [[pdf](https://papers.nips.cc/paper/3187-a-spectral-regularization-framework-for-multi-task-structure-learning.pdf)]
- Biographies, bollywood, boom- boxes and blenders: Domain adaptation for sentiment classification. [[pdf](https://www.cs.jhu.edu/~mdredze/publications/sentiment_acl07.pdf)] 
- Co-clustering based Classification for Out-of-domain Documents. [[pdf](https://er2004.cse.ust.hk/~qyang/Docs/2007/daikdd.pdf)] :star: 
- Domain adaptation with structural correspondence learning. [[pdf](http://john.blitzer.com/papers/emnlp06.pdf)]
- Frustratingly easy domain adaptation. [[pdf](http://www.umiacs.umd.edu/~hal/docs/daume07easyadapt.pdf)] :star: 
- Kernel-based inductive transfer. [[pdf](https://pdfs.semanticscholar.org/45b1/32687d62da38ca2ce0a05e4b52bcf51f1f6f.pdf)]
- Learning a meta-level prior for feature relevance from multiple related tasks. [[pdf](http://ai.stanford.edu/~koller/Papers/Lee+al:ICML07.pdf)]
- Multi-task feature and kernel selection for svms. [[pdf](http://www.cs.columbia.edu/~jebara/papers/metalearn.pdf)]
- Multi-task feature learning. [[pdf](https://papers.nips.cc/paper/3143-multi-task-feature-learning.pdf)] :star: 
- Self-taught Clustering. [[pdf](http://www.machinelearning.org/archive/icml2008/papers/432.pdf)]
- Self-taught Learning-Transfer Learning from Unlabeled Data. [[url](https://www.google.co.jp/url?sa=t&rct=j&q=&esrc=s&source=web&cd=1&cad=rja&uact=8&ved=0ahUKEwjfz7qOkNDQAhWJoZQKHSVzDOgQFggdMAA&url=http%3A%2F%2Fai.stanford.edu%2F~hllee%2Ficml07-selftaughtlearning.pdf&usg=AFQjCNG71_SrmGXuzHiE5Qo2ugmF96NKgw)] :star: 
- Spectral domain-transfer learning. [[url](https://www.google.com/url?sa=t&rct=j&q=&esrc=s&source=web&cd=2&cad=rja&uact=8&ved=0ahUKEwjg5ofSs47RAhWGjVQKHbtwB5gQFggsMAE&url=http%3A%2F%2Fciteseerx.ist.psu.edu%2Fviewdoc%2Fsummary%3Fdoi%3D10.1.1.141.1551&usg=AFQjCNEnGKdMTf64btUV6QsVSn9RgphWLA)] :star: 
- Transfer learning via dimensionality reduction. [[pdf](http://home.cse.ust.hk/~qyang/Docs/2008/AAAIsinnoA.pdf)]

#### Parameter transfer

- Knowledge transfer via multiple model local structure mapping. [[pdf](http://aisl.umbc.edu/resources/1145.pdf)]
- Learning Gaussian Process Kernels via Hierarchical Bayes. [[pdf](https://papers.nips.cc/paper/2595-learning-gaussian-process-kernels-via-hierarchical-bayes.pdf)]
- Learning to learn with the informative vector machine. [[pdf](ftp://ftp.dcs.shef.ac.uk/home/neil/mtivm.pdf)]
- Multi-task Gaussian Process Prediction. [[pdf](https://papers.nips.cc/paper/3189-multi-task-gaussian-process-prediction.pdf)]
- Regularized multi-task learning. [[pdf](http://www0.cs.ucl.ac.uk/staff/M.Pontil/reading/mt-kdd.pdf)]
- The more you know, the less you learn: from knowledge transfer to one-shot learning of object categories.[[pdf](http://ftp.idiap.ch/pub/courses/EE-700/material/28-11-2012/Tommasi_BMVC_2009.pdf)]

#### Relational knowledge transfer

- Deep transfer via second-order markov logic. [[pdf](http://homes.cs.washington.edu/~pedrod/papers/mlc09a.pdf)] 
- Mapping and revising markov logic networks for transfer learning. [[pdf](http://dl.acm.org/citation.cfm?id=1619743)]
- Transfer learning by mapping with minimal target data. [[pdf](http://www.cs.utexas.edu/~ml/papers/lily-ws-aaai-08.pdf)]
- Translated learning: Transfer learning across different feature spaces.[[url](http://machinelearning.wustl.edu/mlpapers/paper_files/NIPS2008_0098.pdf)] :star: 

