# Deep Learning

- Attentive Group Equivariant Convolutional Networks. [`arxiv`](https://arxiv.org/abs/2002.03830)
- Fast Differentiable Sorting and Ranking. [`arxiv`](https://arxiv.org/abs/2002.08871)
- Gradient Boosting Neural Networks: GrowNet. [`arxiv`](https://arxiv.org/abs/2002.07971)
- Learning with Differentiable Perturbed Optimizers. [`arxiv`](https://arxiv.org/abs/2002.08676)
- The Costs and Benefits of Goal-Directed Attention in Deep Convolutional Neural Networks. [`pdf`](https://arxiv.org/pdf/2002.02342.pdf)
- The Geometry of Sign Gradient Descent. [`arxiv`](https://arxiv.org/abs/2002.08056)
- The large learning rate phase of deep learning: the catapult mechanism. [`arxiv`](https://arxiv.org/abs/2003.02218)
- Towards Understanding Hierarchical Learning: Benefits of Neural Representations. [`arxiv`](https://arxiv.org/abs/2006.13436)

## AutoML

- When NAS Meets Robustness: In Search of Robust Architectures against Adversarial Attacks. [`arxiv`](https://arxiv.org/abs/1911.10695) [`code`](https://github.com/gmh14/RobNets)
- Gryffin: An algorithm for Bayesian optimization for categorical variables informed by physical intuition with applications to chemistry. [`arxiv`](https://arxiv.org/abs/2003.12127)
- Uncertainty Quantification for Bayesian Optimization. [`pdf`](https://arxiv.org/pdf/2002.01569.pdf)

## GAN

- BachGAN: High-Resolution Image Synthesis from Salient Object Layout. [`arxiv`](https://arxiv.org/abs/2003.11690) [`code`](https://github.com/Cold-Winter/BachGAN)
- Unbalanced GANs: Pre-training the Generator of Generative Adversarial Network using Variational Autoencoder. [`pdf`](https://arxiv.org/pdf/2002.02112.pdf)

## GNN

- Benchmark and Best Practices for Biomedical Knowledge Graph Embeddings. [`arxiv`](https://arxiv.org/abs/2006.13774) [`code`](https://github.com/dchang56/snomed_kge)
- Bridging the Gap Between Spectral and Spatial Domains in Graph Neural Networks. [`arxiv`](https://arxiv.org/abs/2003.11702) [`code`](https://github.com/balcilar/Spectral-Designed-Graph-Convolutions)
- Bringing Light Into the Dark: A Large-scale Evaluation of Knowledge Graph Embedding Models Under a Unified Framework. [`arxiv`](https://arxiv.org/abs/2006.13365)
- Generalization and Representational Limits of Graph Neural Networks. [`arxiv`](https://arxiv.org/abs/2002.06157)
- SIGN: Scalable Inception Graph Neural Networks. [`arxiv`](https://arxiv.org/abs/2004.11198)
- StickyPillars: Robust feature matching on point clouds using Graph Neural Networks. [`arxiv`](https://arxiv.org/abs/2002.03983)
- Supervised Learning on Relational Databases with Graph Neural Networks. [`arxiv`](https://arxiv.org/abs/2002.02046) [`code`](https://github.com/mwcvitkovic/Supervised-Learning-on-Relational-Databases-with-GNNs)

## Meta Learning

- A Comprehensive Overview and Survey of Recent Advances in Meta-Learning. [`arxiv`](https://arxiv.org/abs/2004.11149)
- Meta-Learning in Neural Networks: A Survey. [`arxiv`](https://arxiv.org/pdf/2004.05439.pdf)
- Regularizing Meta-Learning via Gradient Dropout. [`arxiv`](https://arxiv.org/abs/2004.05859)