# Deep Learning

- A First Look at the Crypto-Mining Malware Ecosystem: A Decade of Unrestricted Wealth. [`arxiv`](https://arxiv.org/abs/1901.00846)
- A Gentle Introduction to Deep Learning for Graphs. [`arxiv`](https://arxiv.org/abs/1912.12693)
- AugMix: A Simple Data Processing Method to Improve Robustness and Uncertainty. [`arxiv`](https://arxiv.org/pdf/1912.02781.pdf) [`code`](https://github.com/google-research/augmix) :star:
- diffGrad: An Optimization Method for Convolutional Neural Networks. [`arxiv`](https://arxiv.org/abs/1909.11015) [`code`](https://github.com/lessw2020/Best-Deep-Learning-Optimizers)
- LiSHT: Non-Parametric Linearly Scaled Hyperbolic Tangent Activation Function for Neural Networks. [`arxiv`](https://arxiv.org/abs/1901.05894)
- One-Class Convolutional Neural Network. [`arxiv`](https://arxiv.org/abs/1901.08688)
- On the effect of the activation function on the distribution of hidden nodes in a deep network. [`arxiv`](https://arxiv.org/abs/1901.02104)
- TactileGCN: A Graph Convolutional Network for Predicting Grasp Stability with Tactile Sensors. [`arxiv`](https://arxiv.org/abs/1901.06181)

## Attention

- Attentive Neural Processes. [`arxiv`](https://arxiv.org/abs/1901.05761) :star:
- FAN: Focused Attention Networks. [`arxiv`](https://arxiv.org/abs/1905.11498)

## Auto ML

- A Unified Stochastic Gradient Approach to Designing Bayesian-Optimal Experiments. [`arxiv`](https://arxiv.org/abs/1911.00294)
- Combinatorial Bayesian Optimization using the Graph Cartesian Product. [`arxiv`](https://arxiv.org/abs/1902.00448) [`code`](https://github.com/QUVA-Lab/COMBO)
- EAT-NAS: Elastic Architecture Transfer for Accelerating Large-scale Neural Architecture Search. [`arxiv`](https://arxiv.org/abs/1901.05884v1)


## Transfer Learning

- Time Series Anomaly Detection Using Convolutional Neural Networks and Transfer Learning. [`arxiv`](https://arxiv.org/abs/1905.13628)
- Virtual-to-Real-World Transfer Learning for Robots on Wilderness Trails. [`arxiv`](https://arxiv.org/abs/1901.05599)