# Computer Vision

- DSConv: Efficient Convolution Operator. [`arxiv`](https://arxiv.org/abs/1901.01928)
- EfficientNet: Rethinking Model Scaling for Convolutional Neural Networks. [`arxiv`](https://arxiv.org/abs/1905.11946) [`code`](https://github.com/tensorflow/tpu/tree/master/models/official/efficientnet)
- Exploring Randomly Wired Neural Networks for Image Recognition. [`arxiv`](https://arxiv.org/abs/1904.01569)
- FPGA-based Accelerators of Deep Learning Networks for Learning and Classification: A Review. [`arxiv`](https://arxiv.org/abs/1901.00121)
- Monocular Total Capture: Posing Face, Body, and Hands in the Wild. [`arxiv`](https://arxiv.org/abs/1812.01598)
- Semi-Supervised Learning with Self-Supervised Networks. [`arxiv`](https://arxiv.org/abs/1906.10343) [`code`](https://github.com/vuptran/sesemi)

## GAN

- A Survey on GANs for Anomaly Detection. [`arxiv`](https://arxiv.org/abs/1906.11632)
- Exploring Randomly Wired Neural Networks for Image Recognition. [`arxiv`](https://arxiv.org/abs/1904.01184)

## PreProcessing

- Learning Data Augmentation Strategies for Object Detection. [`arxiv`](https://arxiv.org/abs/1906.11172)

## Object Detection

- Consistent Optimization for Single-Shot Object Detection. [`arxiv`](https://arxiv.org/abs/1901.06563)
- DetNAS: Backbone Search for Object Detection. [`arxiv`](https://arxiv.org/pdf/1903.10979.pdf)
- EfficientDet: Scalable and Efficient Object Detection. [`arxiv`](https://arxiv.org/pdf/1911.09070v1.pdf) [`code`](https://github.com/xuannianz/EfficientDet)
- GAN-Knowledge Distillation for one-stage Object Detection. [`arxiv`](https://arxiv.org/abs/1906.08467)
- NAS-FPN: Learning Scalable Feature Pyramid Architecture for Object Detection. [`arxiv`](https://arxiv.org/pdf/1904.07392.pdf)

## Semantic Segmentation

- CenterMask : Real-Time Anchor-Free Instance Segmentation. [`arxiv`](https://arxiv.org/abs/1911.06667) [`code`](https://github.com/youngwanLEE/centermask2)
- Gated-SCNN: Gated Shape CNNs for Semantic Segmentation. [`arxiv`](https://arxiv.org/abs/1907.05740) [`code`](https://github.com/nv-tlabs/GSCNN)
- Object-Contextual Representations for Semantic Segmentation. [`arxiv`](https://arxiv.org/abs/1909.11065) [`code`](https://github.com/rosinality/ocr-pytorch)
