## Nature language process

- 500+ Times Faster Than Deep Learning (A Case Study Exploring Faster Methods for Text Mining StackOverflow). [`arxiv`](https://arxiv.org/abs/1802.05319)
- A Deep Ensemble Model with Slot Alignment for Sequence-to-Sequence Natural Language Generation. [`arxiv`](https://arxiv.org/abs/1805.06553)
- Analysis Methods in Neural Language Processing: A Survey. [`arxiv`](https://arxiv.org/abs/1812.08951)
- An end-to-end TextSpotter with Explicit Alignment and Attention. [`arxiv`](https://arxiv.org/abs/1803.03474) [`code`](https://github.com/tonghe90/textspotter)
- An Introductory Survey on Attention Mechanisms in NLP Problems. [`arxiv`](https://arxiv.org/abs/1811.05544)
- Annotation Artifacts in Natural Language Inference Data. [`arxiv`](https://arxiv.org/abs/1803.02324) :star:
- A Universal Music Translation Network. [`arxiv`](https://arxiv.org/abs/1805.07848)
- Building Dynamic Knowledge Graphs from Text using Machine Reading Comprehension. [`arxiv`](https://arxiv.org/abs/1810.05682)
- Calculating the similarity between words and sentences using a lexical database and corpus statistics. [`arxiv`](https://arxiv.org/abs/1802.05667)
- Chinese Text in the Wild. [`arxiv`](https://arxiv.org/abs/1803.00085)
- Content Selection in Deep Learning Models of Summarization. [`arxiv`](https://arxiv.org/abs/1810.12343)
- Constituency Parsing with a Self-Attentive Encoder. [`arxiv`](https://arxiv.org/abs/1805.01052) [`code`](https://github.com/nikitakit/self-attentive-parser)
- Embedding Logical Queries on Knowledge Graphs. [`arxiv`](https://arxiv.org/abs/1806.01445) [`code`](https://github.com/williamleif/graphqembed)
- Extracting Action Sequences from Texts Based on Deep Reinforcement Learning. [`arxiv`](https://arxiv.org/abs/1803.02632)
- Generating Wikipedia by Summarizing Long Sequences. [`arxiv`](https://arxiv.org/abs/1801.10198) :star:
- How Images Inspire Poems: Generating Classical Chinese Poetry from Images with Memory Networks. [`arxiv`](https://arxiv.org/abs/1803.02994)
- IncepText: A New Inception-Text Module with Deformable PSROI Pooling for Multi-Oriented Scene Text Detection. [`arxiv`](https://arxiv.org/abs/1805.01167)
- Linguistically-Informed Self-Attention for Semantic Role Labeling. [`arxiv`](https://arxiv.org/abs/1804.08199) :star:
- Neural Relational Inference for Interacting Systems. [`arxiv`](https://arxiv.org/abs/1802.04687) [`code`](https://github.com/ethanfetaya/nri)
- Neural Text Generation: Past, Present and Beyond. [`arxiv`](https://arxiv.org/abs/1803.07133)
- PixelLink: Detecting Scene Text via Instance Segmentation. [`arxiv`](https://arxiv.org/abs/1801.01315) [`code`](https://github.com/ZJULearning/pixel_link)
- Shape Robust Text Detection with Progressive Scale Expansion Network. [`arxiv`](https://arxiv.org/abs/1806.02559) [`code`](https://github.com/whai362/PSENet)
- Text2Shape: Generating Shapes from Natural Language by Learning Joint Embeddings. [`arxiv`](https://arxiv.org/abs/1803.08495)
- TextTopicNet - Self-Supervised Learning of Visual Features Through Embedding Images on Semantic Text Spaces. [`arxiv`](https://arxiv.org/abs/1807.02110) [`code`](https://github.com/lluisgomez/TextTopicNet)
- Using J-K fold Cross Validation to Reduce Variance When Tuning NLP Models. [`arxiv`](https://arxiv.org/abs/1806.07139) [`code`](https://github.com/henrymoss/COLING2018)

### Chatbot

- A Deep Reinforcement Learning Chatbot (Short Version). [`arxiv`](https://arxiv.org/abs/1801.06700)
- Dialogue Generation: From Imitation Learning to Inverse Reinforcement Learning. [`arxiv`](https://arxiv.org/abs/1812.03509)
- Goal-Oriented Chatbot Dialog Management Bootstrapping with Transfer Learning. [`arxiv`](https://arxiv.org/abs/1802.00500)
- Mem2Seq: Effectively Incorporating Knowledge Bases into End-to-End Task-Oriented Dialog Systems. [`arxiv`](https://arxiv.org/abs/1804.08217) [`code`](https://github.com/HLTCHKUST/Mem2Seq)
- The Design and Implementation of XiaoIce, an Empathetic Social Chatbot. [`arxiv`](https://arxiv.org/abs/1812.08989)

### Embeddings

- An efficient framework for learning sentence representations. [`arxiv`](https://arxiv.org/abs/1803.02893)
- A Hierarchical Multi-task Approach for Learning Embeddings from Semantic Tasks. [`arxiv`](https://arxiv.org/abs/1811.06031) [`code`](https://github.com/huggingface/hmtl)
- A robust self-learning method for fully unsupervised cross-lingual mappings of word embeddings. [`arxiv`](https://arxiv.org/abs/1805.06297) [`code`](https://github.com/artetxem/vecmap)
- Beyond Word Embeddings: Learning Entity and Concept Representations from Large Scale Knowledge Bases. [`arxiv`](https://arxiv.org/abs/1801.00388)
- Concept2vec: Metrics for Evaluating Quality of Embeddings for Ontological Concepts. [`arxiv`](https://arxiv.org/abs/1803.04488)
- Deep contextualized word representations. [`arxiv`](https://arxiv.org/abs/1802.05365)
- Evaluating Compositionality in Sentence Embeddings. [`arxiv`](https://arxiv.org/abs/1802.04302) [`code`](https://github.com/ishita-dg/ScrambleTests)
- From Word to Sense Embeddings: A Survey on Vector Representations of Meaning. [`arxiv`](https://arxiv.org/abs/1805.04032)
- Learning Domain-Sensitive and Sentiment-Aware Word Embeddings. [`arxiv`](https://arxiv.org/abs/1805.03801)
- Learning Role-based Graph Embeddings. [`arxiv`](https://arxiv.org/abs/1802.02896) [`code`](https://github.com/benedekrozemberczki/role2vec)
- Learning Word Embeddings for Low-resource Languages by PU Learning. [`arxiv`](https://arxiv.org/abs/1805.03366)
- On the Dimensionality of Word Embedding. [`arxiv`](https://arxiv.org/abs/1812.04224) [`code`](https://github.com/ziyin-dl/word-embedding-dimensionality-selection)
- Poincaré GloVe: Hyperbolic Word Embeddings. [`arxiv`](https://arxiv.org/abs/1810.06546)
- Query2Vec: NLP Meets Databases for Generalized Workload Analytics. [`arxiv`](https://arxiv.org/abs/1801.05613)
- Semantic projection: recovering human knowledge of multiple, distinct object features from word embeddings. [`arxiv`](https://arxiv.org/abs/1802.01241)
- Speech2Vec: A Sequence-to-Sequence Framework for Learning Word Embeddings from Speech. [`arxiv`](https://arxiv.org/abs/1803.08976)
- Word Embedding Attention Network: Generating Words by Querying Distributed Word Representations for Paraphrase Generation. [`arxiv`](https://arxiv.org/abs/1803.01465) [`code`](https://github.com/lancopku/WEAN)
- Word2Bits - Quantized Word Vectors. [`arxiv`](https://arxiv.org/abs/1803.05651) [`code`](https://github.com/agnusmaximus/Word2Bits) :star:

### Keyphrase Extraction

- EmbedRank: Unsupervised Keyphrase Extraction using Sentence Embeddings. [`arxiv`](https://arxiv.org/abs/1801.04470)

### Knowledge Graphs

- Variational Knowledge Graph Reasoning. [`arxiv`](https://arxiv.org/abs/1803.06581)

### Language Model

- An Analysis of Neural Language Modeling at Multiple Scales. [`arxiv`](https://arxiv.org/abs/1803.08240) [`code`](https://github.com/salesforce/awd-lstm-lm)

### Pos-tagging

- Evaluating Layers of Representation in Neural Machine Translation on Part-of-Speech and Semantic Tagging Tasks. [`arxiv`](https://arxiv.org/abs/1801.07772) [`code`](https://github.com/boknilev/nmt-repr-analysis)

### QA

- A Corpus for Modeling Word Importance in Spoken Dialogue Transcripts. [`arxiv`](https://arxiv.org/abs/1801.09746)
- A Question-Focused Multi-Factor Attention Network for Question Answering. [`arxiv`](https://arxiv.org/abs/1801.08290) [`code`](https://github.com/nusnlp/amanda)
- Being curious about the answers to questions: novelty search with learned attention. [`arxiv`](https://arxiv.org/abs/1806.00201) [`code`](https://github.com/arayabrain/QuestionDrivenNovelty)
- Bilinear Attention Networks. [`arxiv`](https://arxiv.org/abs/1805.07932) [`code`](https://github.com/jnhwkim/ban-vqa)
- EARL: Joint Entity and Relation Linking for Question Answering over Knowledge Graphs. [`arxiv`](https://arxiv.org/abs/1801.03825) [`code`](https://github.com//AskNowQA/EARL)
- Finding ReMO (Related Memory Object): A Simple Neural Architecture for Text based Reasoning. [`arxiv`](https://arxiv.org/abs/1801.08459) [`code`](https://github.com/juung/RMN)
- The Natural Language Decathlon: Multitask Learning as Question Answering. [`arxiv`](https://arxiv.org/abs/1806.08730)
- Think you have Solved Question Answering? Try ARC, the AI2 Reasoning Challenge. [`arxiv`](https://arxiv.org/abs/1803.05457) [`code`](https://github.com/allenai/arc-solvers)
- TVQA: Localized, Compositional Video Question Answering. [`arxiv`](https://arxiv.org/abs/1809.01696)
- Visual Question Generation as Dual Task of Visual Question Answering. [`url`](http://cvboy.com/publication/cvpr2018_iqan/) [`code`](https://github.com/yikang-li/iQAN)

### NER

- Chinese NER Using Lattice LSTM. [`arxiv`](https://arxiv.org/pdf/1805.02023.pdf) [`code`](https://github.com/jiesutd/LatticeLSTM)
- Named Entity Disambiguation using Deep Learning on Graphs. [`arxiv`](https://arxiv.org/abs/1810.09164) [`code`](https://github.com/contextscout/ned-graphs)

### NMT

- Achieving Human Parity on Automatic Chinese to English News Translation. [`arxiv`](https://arxiv.org/abs/1803.05567)
- Apply Chinese Radicals Into Neural Machine Translation: Deeper Than Character Level. [`arxiv`](https://arxiv.org/abs/1805.01565)
- Phrase-Based & Neural Unsupervised Machine Translation. [`arxiv`](https://arxiv.org/abs/1804.07755)
- Self-Attention with Relative Position Representations. [`arxiv`](https://arxiv.org/abs/1803.02155)


### Recommender Systems

- Billion-scale Commodity Embedding for E-commerce Recommendation in Alibaba. [`arxiv`](https://arxiv.org/abs/1803.02349)
- DKN: Deep Knowledge-Aware Network for News Recommendation. [`arxiv`](https://arxiv.org/abs/1801.08284)
- Explainable Recommendation: A Survey and New Perspectives. [`arxiv`](https://arxiv.org/abs/1804.11192)
- FashionNet: Personalized Outfit Recommendation with Deep Neural Network. [`arxiv`](https://arxiv.org/abs/1810.02443)
- Graph Convolutional Neural Networks for Web-Scale Recommender Systems. [`arxiv`](https://arxiv.org/abs/1806.01973)
- Learning Tree-based Deep Model for Recommender Systems. [`arxiv`](https://arxiv.org/abs/1801.02294)
- MARS: Memory Attention-Aware Recommender System. [`arxiv`](https://arxiv.org/abs/1805.07037)
- Offline A/B testing for Recommender Systems. [`arxiv`](https://arxiv.org/abs/1801.07030)
- Ranking Distillation: Learning Compact Ranking Models With High Performance for Recommender System. [`arxiv`](https://arxiv.org/abs/1809.07428) [`code`](https://github.com/graytowne/rank_distill)
- Sequence-Aware Recommender Systems. [`arxiv`](https://arxiv.org/abs/1802.08452)
- Top-K Off-Policy Correction for a REINFORCE Recommender System. [`arxiv`](https://arxiv.org/abs/1812.02353)

### Sentiment Analysis

- Combination of Domain Knowledge and Deep Learning for Sentiment Analysis. [`arxiv`](https://arxiv.org/abs/1806.08760)
- Word2Vec and Doc2Vec in Unsupervised Sentiment Analysis of Clinical Discharge Summaries. [`arxiv`](https://arxiv.org/abs/1805.00352)

### Speech Recognition

- Automatic Detection of Online Jihadist Hate Speech. [`arxiv`](https://arxiv.org/abs/1803.04596)
- Do WaveNets Dream of Acoustic Waves? [`arxiv`](https://arxiv.org/abs/1802.08370)
- End-to-End Speech Recognition From the Raw Waveform. [`arxiv`](https://arxiv.org/abs/1806.07098)
- Large-Scale Visual Speech Recognition. [`arxiv`](https://arxiv.org/abs/1807.05162)
- Speech Emotion Recognition with Data Augmentation and Layer-wise Learning Rate Adjustment. [`arxiv`](https://arxiv.org/abs/1802.05630)
- Stochastic WaveNet: A Generative Latent Variable Model for Sequential Data. [`arxiv`](https://arxiv.org/abs/1806.06116)
- VoxCeleb2: Deep Speaker Recognition. [`arxiv`](https://arxiv.org/abs/1806.05622)

### Text Classification

- Clinical Text Classification with Rule-based Features and Knowledge-guided Convolutional Neural Networks. [`arxiv`](https://arxiv.org/abs/1807.07425)
- Fake News Identification on Twitter with Hybrid CNN and RNN Models. [`arxiv`](https://arxiv.org/abs/1806.11316)
- Fine-tuned Language Models for Text Classification. [`arxiv`](https://arxiv.org/abs/1801.06146)
- Joint Embedding of Words and Labels for Text Classification. [`arxiv`](https://arxiv.org/pdf/1805.04174.pdf) [`code`](https://github.com/guoyinwang/LEAM)
- Online Embedding Compression for Text Classification using Low Rank Matrix Factorization. [`arxiv`](https://arxiv.org/abs/1811.00641)
- SoPa: Bridging CNNs, RNNs, and Weighted Finite-State Machines. [`arxiv`](https://arxiv.org/abs/1805.06061) [`code`](https://github.com/Noahs-ARK/soft_patterns)
