# Deep learning

- Accelerating CNN inference on FPGAs: A Survey. [`arxiv`](https://arxiv.org/abs/1806.01683) 
- Adaptive Neural Trees. [`arxiv`](https://arxiv.org/abs/1807.06699)
- Adding One Neuron Can Eliminate All Bad Local Minima. [`arxiv`](https://arxiv.org/abs/1805.08671)
- A Dual Approach to Scalable Verification of Deep Networks. [`arxiv`](https://arxiv.org/abs/1803.06567)
- A Geometric Theory of Higher-Order Automatic Differentiation. [`arxiv`](https://arxiv.org/abs/1812.11592)
- A graph-embedded deep feedforward network for disease outcome classification and feature selection using gene expression data. [`arxiv`](https://arxiv.org/abs/1801.06202) [`code`](https://github.com/yunchuankong/NetworkNeuralNetwork)
- An Intriguing Failing of Convolutional Neural Networks and the CoordConv Solution. [`url`](https://eng.uber.com/coordconv/) :star:
- A Survey on Neural Network-Based Summarization Methods. [`arxiv`](https://arxiv.org/abs/1804.04589)
- A Tutorial on Network Embeddings. [`arxiv`](https://arxiv.org/abs/1808.02590)
- A Unified Probabilistic Model for Learning Latent Factors and Their Connectivities from High-Dimensional Data. [`arxiv`](https://arxiv.org/abs/1805.09567)
- Backdrop: Stochastic Backpropagation. [`arxiv`](https://arxiv.org/abs/1806.01337) [`code`](https://github.com/dexgen/backdrop)
- Batch Kalman Normalization: Towards Training Deep Neural Networks with Micro-Batches. [`arxiv`](https://arxiv.org/abs/1802.03133) :star:
- Bayesian Convolutional Neural Networks. [`arxiv`](https://arxiv.org/abs/1806.05978) [`code`](https://github.com/felix-laumann/Bayesian_CNN)
- Bayesian Deep Convolutional Encoder-Decoder Networks for Surrogate Modeling and Uncertainty Quantification. [`arxiv`](https://arxiv.org/abs/1801.06879)
- Bayesian Layers: A Module for Neural Network Uncertainty. [`arxiv`](https://arxiv.org/abs/1812.03973)
- Bayesian Neural Networks. [`arxiv`](https://arxiv.org/abs/1801.07710) [`code`](https://github.com/mullachv/MLExp)
- Bayesian Optimization in AlphaGo.  [`arxiv`](https://arxiv.org/abs/1812.06855)
- Beyond Word Importance: Contextual Decomposition to Extract Interactions from LSTMs. [`arxiv`](https://arxiv.org/abs/1801.05453)
- BindsNET: A machine learning-oriented spiking neural networks library in Python. [`arxiv`](https://arxiv.org/abs/1806.01423) [`code`](https://github.com/Hananel-Hazan/bindsnet)
- Capturing Structure Implicitly from Time-Series having Limited Data. [`arxiv`](https://arxiv.org/abs/1803.05867) [`code`](https://github.com/emaasit/long-range-extrapolation)
- Class label autoencoder for zero-shot learning. [`arxiv`](https://arxiv.org/abs/1801.08301)
- Closing the AI Knowledge Gap. [`arxiv`](https://arxiv.org/abs/1803.07233)
- Clustering with Deep Learning: Taxonomy and New Methods. [`arxiv`](https://arxiv.org/abs/1801.07648) [`code`](https://github.com/elieJalbout/Clustering-with-Deep-learning)
- Collaborative Multi-modal deep learning for the personalized product retrieval in Facebook Marketplace. [`arxiv`](https://arxiv.org/abs/1805.12312)
- Conditional Neural Processes. [`arxiv`](https://arxiv.org/abs/1807.01613)
- Convolutional Neural Networks with Recurrent Neural Filters. [`arxiv`](https://arxiv.org/abs/1808.09315) [`code`](https://github.com/bloomberg/cnn-rnf)
- Data Dropout: Optimizing Training Data for Convolutional Neural Networks. [`arxiv`](https://arxiv.org/abs/1809.00193)
- Decorrelated Batch Normalization. [`arxiv`](https://arxiv.org/abs/1804.08450) [`code`](https://github.com/umich-vl/DecorrelatedBN)
- Decoupled Networks. [`arxiv`](https://arxiv.org/abs/1804.08071) [`code`](https://github.com/wy1iu/DCNets)
- Deep Convolutional Networks as shallow Gaussian Processes. [`arxiv`](https://arxiv.org/abs/1808.05587) [`code`](https://github.com/rhaps0dy/convnets-as-gps)
- Deep Embedding Kernel. [`arxiv`](https://arxiv.org/abs/1804.05806)
- Deep Graph Infomax. [`arxiv`](https://arxiv.org/abs/1809.10341)
- Deep Hidden Physics Models: Deep Learning of Nonlinear Partial Differential Equations. [`arxiv`](https://arxiv.org/abs/1801.06637) [`code`](https://github.com/maziarraissi/DeepHPMs)
- Deep k-Means: Re-Training and Parameter Sharing with Harder Cluster Assignments for Compressing Deep Convolutions. [`arxiv`](https://arxiv.org/abs/1806.09228) [`code`](https://github.com/Sandbox3aster/Deep-K-Means-pytorch)
- Deep k-Nearest Neighbors: Towards Confident, Interpretable and Robust Deep Learning. [`arxiv`](https://arxiv.org/abs/1803.04765)
- Deep Learning. [`arxiv`](https://arxiv.org/abs/1807.07987)
- Deep Learning using Rectified Linear Units (ReLU). [`arxiv`](https://arxiv.org/abs/1803.08375) [`code`](https://github.com/AFAgarap/relu-classifier)
- Deep Learning with the Random Neural Network and its Applications. [`arxiv`](https://arxiv.org/abs/1810.08653)
- Deep Multimodal Subspace Clustering Networks. [`arxiv`](https://arxiv.org/abs/1804.06498)
- Deep Neural Decision Trees. [`arxiv`](https://arxiv.org/abs/1806.06988) [`code`](https://github.com/wOOL/DNDT)
- Deep Self-Organization: Interpretable Discrete Representation Learning on Time Series. [`arxiv`](https://arxiv.org/abs/1806.02199)
- Deep Super Learner: A Deep Ensemble for Classification Problems. [`arxiv`](https://arxiv.org/abs/1803.02323) [`code`](https://github.com/levyben/DeepSuperLearner)
- Detail-Preserving Pooling in Deep Networks. [`arxiv`](https://arxiv.org/abs/1804.04076)
- Detecting Dead Weights and Units in Neural Networks. [`arxiv`](https://arxiv.org/abs/1806.06068)
- Digging Into Self-Supervised Monocular Depth Estimation. [`arxiv`](https://arxiv.org/abs/1806.01260)
- Don't Use Large Mini-Batches, Use Local SGD. [`arxiv`](https://arxiv.org/abs/1808.07217)
- Dropout is a special case of the stochastic delta rule: faster and more accurate deep learning. [`arxiv`](https://arxiv.org/abs/1808.03578)
- DroNet: Learning to Fly by Driving. [`pdf`](http://rpg.ifi.uzh.ch/docs/RAL18_Loquercio.pdf) [`code`](https://github.com/uzh-rpg/rpg_public_dronet)
- Dynamic Graph Neural Networks. [`arxiv`](https://arxiv.org/abs/1810.10627)
- Dynamic Planning Networks. [`arxiv`](https://arxiv.org/abs/1812.11240)
- Efficient Interactive Annotation of Segmentation Datasets with Polygon-RNN++. [`arxiv`](https://arxiv.org/abs/1803.09693) [`code`](https://github.com/davidjesusacu/polyrnn-pp)
- Efficient Neural Architecture Search ia Parameter Sharing. [`arxiv`](https://arxiv.org/abs/1802.03268) [`pytorch`](https://github.com/carpedm20/ENAS-pytorch) [`tensorflow`](https://github.com/melodyguan/enas) :star:
- Entropy and mutual information in models of deep neural networks. [`arxiv`](https://arxiv.org/abs/1805.09785)
- EcoRNN: Fused LSTM RNN Implementation with Data Layout Optimization. [`arxiv`](https://arxiv.org/abs/1805.08899)
- E-swish: Adjusting Activations to Different Network Depths. [`arxiv`](https://arxiv.org/abs/1801.07145)
- Etymo: A New Discovery Engine for AI Research. [`arxiv`](https://arxiv.org/abs/1801.08573)
- Evaluating Feature Importance Estimates. [`arxiv`](https://arxiv.org/abs/1806.10758)
- Extremely Fast Decision Tree. [`arxiv`](https://arxiv.org/abs/1802.08780) [`pytorch`](https://github.com/chaitanya-m/kdd2018)
- Eyeriss v2: A Flexible and High-Performance Accelerator for Emerging Deep Neural Networks. [`arxiv`](https://arxiv.org/abs/1807.07928)
- Fast Decoding in Sequence Models using Discrete Latent Variables. [`arxiv`](https://arxiv.org/abs/1803.03382)
- FastGCN: Fast Learning with Graph Convolutional Networks via Importance Sampling. [`arxiv`](https://arxiv.org/abs/1801.10247) [`code`](https://github.com/matenure/FastGCN)
- Fast Neural Architecture Search of Compact Semantic Segmentation Models via Auxiliary Cells. [`arxiv`](https://arxiv.org/abs/1810.10804)
- Foundations of Sequence-to-Sequence Modeling for Time Series. [`arxiv`](https://arxiv.org/abs/1805.03714)
- From Nodes to Networks: Evolving Recurrent Neural Networks. [`arxiv`](https://arxiv.org/abs/1803.04439)
- Fundamentals of Recurrent Neural Network (RNN) and Long Short-Term Memory (LSTM) Network. [`arxiv`](https://arxiv.org/abs/1808.03314) :star:
- Gaussian Process Behaviour in Wide Deep Neural Networks. [`arxiv`](https://arxiv.org/abs/1804.11271) [`code`](https://github.com/widedeepnetworks/widedeepnetworks)
- Generalized Cross Entropy Loss for Training Deep Neural Networks with Noisy Labels. [`arxiv`](https://arxiv.org/abs/1805.07836)
- Geometric Understanding of Deep Learning. [`arxiv`](https://arxiv.org/abs/1805.10451)
- GossipGraD: Scalable Deep Learning using Gossip Communication based Asynchronous Gradient Descent. [`arxiv`](https://arxiv.org/abs/1803.05880)
- Gradient Acceleration in Activation Functions. [`arxiv`](https://arxiv.org/abs/1806.09783)
- Graph Capsule Convolutional Neural Networks. [`arxiv`](https://arxiv.org/abs/1805.08090) [`code`](https://github.com/vermaMachineLearning/Graph-Capsule-CNN-Networks/)
- Graph Partition Neural Networks for Semi-Supervised Classification. [`arxiv`](https://arxiv.org/abs/1803.06272)
- GraphRNN: Generating Realistic Graphs with Deep Auto-regressive Model. [`arxiv`](https://arxiv.org/abs/1802.08773) [`code`](https://github.com/JiaxuanYou/graph-generation)
- Group Normalization. [`arxiv`](https://arxiv.org/abs/1803.08494) :star:
- Hierarchical Graph Representation Learning with Differentiable Pooling. [`arxiv`](https://arxiv.org/abs/1806.08804)
- High-Accuracy Low-Precision Training. [`arxiv`](https://arxiv.org/abs/1803.03383)
- High Dimensional Bayesian Optimization Using Dropout. [`arxiv`](https://arxiv.org/abs/1802.05400)
- How Does Batch Normalization Help Optimization. [`arxiv`](https://arxiv.org/abs/1805.11604)
- How Powerful are Graph Neural Networks? [`pdf`](https://openreview.net/pdf?id=ryGs6iA5Km)
- Hybrid Decision Making: When Interpretable Models Collaborate With Black-Box Models. [`arxiv`](https://arxiv.org/abs/1802.04346) [`code`](https://github.com/wangtongada/CoBRUSH)
- Hybrid Gradient Boosting Trees and Neural Networks for Forecasting Operating Room Data. [`arxiv`](https://arxiv.org/abs/1801.07384)
- Hyperbolic Neural Networks. [`arxiv`](https://arxiv.org/abs/1805.09112) [`code`](https://github.com/dalab/hyperbolic_nn)
- IcoRating: A Deep-Learning System for Scam ICO Identification. [`arxiv`](https://arxiv.org/abs/1803.03670)
- Impacts of Dirty Data: and Experimental Evaluation. [`arxiv`](https://arxiv.org/abs/1803.06071) [`code`](https://github.com/qizhixinhit/Dirty-dataImpacts)
- Implicit Autoencoders. [`arxiv`](https://arxiv.org/abs/1805.09804) 
- Improving Multi-Person Pose Estimation using Label Correction. [`arxiv`](https://arxiv.org/abs/1811.03331)
- Incremental Training of Deep Convolutional Neural Networks. [`arxiv`](https://arxiv.org/abs/1803.10232)
- Introducing Neuromodulation in Deep Neural Networks to Learn Adaptive Behaviours. [`arxiv`](https://arxiv.org/abs/1812.09113)
- Labelling as an unsupervised learning problem.[`arxiv`](https://arxiv.org/abs/1805.03911) 
- Large Data and Zero Noise Limits of Graph-Based Semi-Supervised Learning Algorithms. [`arxiv`](https://arxiv.org/abs/1805.09450)
- Large-Margin Classification in Hyperbolic Space. [`arxiv`](https://arxiv.org/abs/1806.00437) [`code`](https://github.com/hhcho/hyplinear)
- LARNN: Linear Attention Recurrent Neural Network. [`arxiv`](https://arxiv.org/abs/1808.05578) [`code`](https://github.com/guillaume-chevalier/Linear-Attention-Recurrent-Neural-Network)
- Learning Classifiers with Fenchel-Young Losses: Generalized Entropies, Margins, and Algorithms. [`arxiv`](https://arxiv.org/pdf/1805.09717.pdf)
- Learning Latent Representations in Neural Networks for Clustering through Pseudo Supervision and Graph-based Activity Regularization. [`arxiv`](https://arxiv.org/abs/1802.03063)
- Learning Longer-term Dependencies in RNNs with Auxiliary Losses. [`arxiv`](https://arxiv.org/abs/1803.00144)
- Learning Networks from Random Walk-Based Node Similarities. [`arxiv`](https://arxiv.org/abs/1801.07386) [`code`](https://github.com/cnmusco/graph-similarity-learning)
- Learning to generate classifiers. [`arxiv`](https://arxiv.org/abs/1803.11373) [`code`](https://github.com/arayabrain/ClassifierGenerators)
- Learning to Learn Without Labels. [`pdf`](https://openreview.net/forum?id=ByoT9Fkvz) :star:
- Learning to Make Predictions on Graphs with Autoencoders. [`arxiv`](https://arxiv.org/abs/1802.08352) [`code`](https://github.com/vuptran/graph-representation-learning)
- Learning to Reweight Examples for Robust Deep Learning. [`arxiv`](https://arxiv.org/abs/1803.09050) [`code`](https://github.com/danieltan07/learning-to-reweight-examples)
- Learning to Zoom: a Saliency-Based Sampling Layer for Neural Networks. [`arxiv`](https://arxiv.org/abs/1809.03355)
- Learning Unsupervised Learning Rules. [`arxiv`](https://arxiv.org/abs/1804.00222) [`tensorflow`](https://github.com/tensorflow/models/tree/master/research/learning_unsupervised_learning) :star:
- Learning What to Remember: Long-term Episodic Memory Networks for Learning from Streaming Data. [`arxiv`](https://arxiv.org/abs/1812.04227)
- Linear Backprop in non-linear networks. [`pdf`](https://openreview.net/forum?id=ByfPDyrYim)
- Links: A High-Dimensional Online Clustering Method. [`arxiv`](https://arxiv.org/abs/1801.10123) :star:
- LiteFlowNet: A Lightweight Convolutional Neural Network for Optical Flow Estimation. [`arxiv`](https://arxiv.org/abs/1805.07036)
- LSTM stack-based Neural Multi-sequence Alignment TeCHnique. [`arxiv`](https://arxiv.org/abs/1803.00057)
- MemGEN: Memory is All You Need. [`arxiv`](https://arxiv.org/abs/1803.11203)
- Measuring the Effects of Data Parallelism on Neural Network Training. [`arxiv`](https://arxiv.org/abs/1811.03600)
- Modeling Attention Flow on Graphs. [`arxiv`](https://arxiv.org/abs/1811.00497)
- Modeling Dynamics with Deep Transition-Learning Networks. [`arxiv`](https://arxiv.org/abs/1802.03497)
- Model Selection Techniques -- An Overview.  [`arxiv`](https://arxiv.org/abs/1810.09583)
- Multi-Layered Gradient Boosting Decision Trees. [`arxiv`](https://arxiv.org/abs/1806.00007) :star:
- Multivariate LSTM-FCNs for Time Series Classification. [`arxiv`](https://arxiv.org/abs/1801.04503) [`code`](https://github.com/houshd/MLSTM-FCN)
- Network Distance Based on Laplacian Flows on Graphs. [`arxiv`](https://arxiv.org/abs/1810.02906) :star:
- Neural Arithmetic Logic Units. [`arxiv`](https://arxiv.org/abs/1808.00508)
- Neural Architecture Optimization. [`arxiv`](https://arxiv.org/abs/1808.07233) [`code`](https://github.com/renqianluo/NAO)
- Neural Architecture Search: A Survey. [`arxiv`](https://arxiv.org/abs/1808.05377)
- Neural Nearest Neighbors Networks. [`arxiv`](https://arxiv.org/pdf/1810.12575.pdf) [`code`](https://github.com/visinf/n3net/)
- Neural Networks Regularization Through Representation Learning. [`arxiv`](https://arxiv.org/abs/1807.05292)
- Not All Samples Are Created Equal: Deep Learning with Importance Sampling. [`arxiv`](https://arxiv.org/abs/1803.00942)
- Online normalizer calculation for softmax. [`arxiv`](https://arxiv.org/abs/1805.02867)
- [Best Paper] On the Convergence of Adam and Beyond. [`pdf`](https://openreview.net/forum?id=ryQu7f-RZ) :star:
- On the Theory of Variance Reduction for Stochastic Gradient Monte Carlo. [`arxiv`](https://arxiv.org/abs/1802.05431)
- Parallel Grid Pooling for Data Augmentation. [`arxiv`](https://arxiv.org/abs/1803.11370) [`code`](https://github.com/akitotakeki/pgp-chainer)
- Personalized Top-N Sequential Recommendation via Convolutional Sequence Embedding. [`arxiv`](https://arxiv.org/abs/1809.07426)
- Piggyback: Adapting a Single Network to Multiple Tasks by Learning to Mask Weights. [`arxiv`](https://arxiv.org/abs/1801.06519) [`code`](https://github.com/arunmallya/piggyback)
- Pitfalls of Graph Neural Network Evaluation. [`arxiv`](https://arxiv.org/abs/1811.05868)
- Pooling is neither necessary nor sufficient for appropriate deformation stability in CNNs. [`arxiv`](https://arxiv.org/abs/1804.04438)
- Probabilistic Recurrent State-Space Models. [`arxiv`](https://arxiv.org/abs/1801.10395) [`code`](https://github.com/andreasdoerr/PR-SSM)
- Progress & Compress: A scalable framework for continual learning. [`arxiv`](https://arxiv.org/abs/1805.06370)
- PWC-Net: CNNs for Optical Flow Using Pyramid, Warping, and Cost Volume. [`arxiv`](https://arxiv.org/abs/1709.02371) [`code`](https://github.com/NVlabs/PWC-Net)
- Pyramid Stereo Matching Network. [`arxiv`](https://arxiv.org/abs/1803.08669) [`code`](https://github.com/JiaRenChang/PSMNet)
- Random depthwise signed convolutional neural networks. [`arxiv`](https://arxiv.org/abs/1806.05789)
- Random Fourier Features for Kernel Ridge Regression: Approximation Bounds and Statistical Guarantees. [`arxiv`](https://arxiv.org/abs/1804.09893)
- Random Warping Series: A Random Features Method for Time-Series Embedding. [`arxiv`](https://arxiv.org/abs/1809.05259) [`code`](https://github.com/IBM/RandomWarpingSeries)
- Relational recurrent neural networks. [`arxiv`](https://arxiv.org/abs/1806.01822)
- Representation Learning with Contrastive Predictive Coding. [`arxiv`](https://arxiv.org/abs/1807.03748)
- ResNet with one-neuron hidden layers is a Universal Approximator. [`arxiv`](https://arxiv.org/abs/1806.10909)
- Revisiting Small Batch Training for Deep Neural Networks. [`arxiv`](https://arxiv.org/abs/1804.07612)
- R3-Net: A Deep Network for Multi-oriented Vehicle Detection in Aerial Images and Videos. [`arxiv`](https://arxiv.org/abs/1808.05560)
- Rotation Equivariance and Invariance in Convolutional Neural Networks. [`arxiv`](https://arxiv.org/abs/1805.12301)
- Scale-free network clustering in hyperbolic and other random graphs. [`arxiv`](https://arxiv.org/abs/1812.03002)
- SlimNets: An Exploration of Deep Model Compression and Acceleration. [`arxiv`](https://arxiv.org/abs/1808.00496) [`code`](https://github.com/ChristopherSweeney/SlimNets)
- Smallify: Learning Network Size while Training. [`arxiv`](https://arxiv.org/abs/1806.03723) 
- Sparsely Connected Convolutional Networks. [`arxiv`](https://arxiv.org/abs/1801.05895)
- SparseMAP: Differentiable Sparse Structured Inference. [`arxiv`](https://arxiv.org/abs/1802.04223) :star:
- SpectralNet: Spectral Clustering using Deep Neural Networks. [`arxiv`](https://arxiv.org/abs/1801.01587) [`code`](https://github.com//kstant0725/SpectralNet)
- Spiking Deep Residual Network. [`arxiv`](https://arxiv.org/abs/1805.01352)
- Spherical CNNs. [`arxiv`](https://arxiv.org/abs/1801.10130) [`code`](https://github.com/jonas-koehler/s2cnn) :star:
- Step Size Matters in Deep Learning. [`arxiv`](https://arxiv.org/abs/1805.08890)
- Supervised classification of Dermatological diseases by Deep neural networks. [`arxiv`](https://arxiv.org/abs/1802.03752) [`code`](https://www.dropbox.com/sh/pwe3tqrb2zijexq/AADpQ9WKOdSfTdvHkVtT_GHKa?dl=0)
- Supervising Unsupervised Learning with Evolutionary Algorithm in Deep Neural Network. [`arxiv`](https://arxiv.org/abs/1803.10397)
- Syntax-Aware Language Modeling with Recurrent Neural Networks. [`arxiv`](https://arxiv.org/abs/1803.03665)
- Realistic Evaluation of Deep Semi-Supervised Learning Algorithms. [`arxiv`](https://arxiv.org/abs/1804.09170) [`code`](https://github.com/brain-research/realistic-ssl-evaluation)
- Testing Deep Neural Networks. [`arxiv`](https://arxiv.org/abs/1803.04792) [`code`](https://github.com/theyoucheng/deepcover)
- The Lottery Ticket Hypothesis: Training Pruned Neural Networks. [`arxiv`](https://arxiv.org/abs/1803.03635)
- The Matrix Calculus You Need For Deep Learning. [`arxiv`](https://arxiv.org/abs/1802.01528)
- Theory and Algorithms for Forecasting Time Series. [`arxiv`](https://arxiv.org/abs/1803.05814)
- The Singular Values of Convolutional Layers. [`arxiv`](https://arxiv.org/abs/1805.10408)
- The unreasonable effectiveness of the forget gate. [`arxiv`](https://arxiv.org/abs/1804.04849)
- Time is of the Essence: Machine Learning-based Intrusion Detection in Industrial Time Series Data. [`arxiv`](https://arxiv.org/abs/1809.07500)
- Time Series Segmentation through Automatic Feature Learning. [`arxiv`](https://arxiv.org/abs/1801.05394)
- Towards a Theoretical Understanding of Batch Normalization. [`arxiv`](https://arxiv.org/abs/1805.10694)
- Towards Efficient Large-Scale Graph Neural Network Computing. [`arxiv`](https://arxiv.org/abs/1810.08403)
- Tracking Network Dynamics: a review of distances and similarity metrics. [`arxiv`](https://arxiv.org/abs/1801.07351)
- Training convolutional neural networks with megapixel images. [`url`](https://openreview.net/forum?id=HJ7lIcjoM) [`code`](https://github.com/DIAGNijmegen/StreamingSGD)
- Tree-CNN: A Deep Convolutional Neural Network for Lifelong Learning. [`arxiv`](https://arxiv.org/abs/1802.05800)
- t-SNE-CUDA: GPU-Accelerated t-SNE and its Applications to Modern Data. [`arxiv`](https://arxiv.org/abs/1807.11824) [`code`](https://github.com/CannyLab/tsne-cuda)
- Turning Your Weakness Into a Strength: Watermarking Deep Neural Networks by Backdooring. [`arxiv`](https://arxiv.org/abs/1802.04633)
- TVM: End-to-End Optimization Stack for Deep Learning. [`arxiv`](https://arxiv.org/abs/1802.04799)
- UMAP: Uniform Manifold Approximation and Projection for Dimension Reduction. [`arxiv`](https://arxiv.org/abs/1802.03426) [`code`](https://github.com/lmcinnes/umap)
- Understanding Convolutional Neural Network Training with Information Theory. [`arxiv`](https://arxiv.org/abs/1804.06537)
- Understanding Individual Decisions of CNNs via Contrastive Backpropagation. [`arxiv`](https://arxiv.org/abs/1812.02100)
- Understanding the Disharmony between Dropout and Batch Normalization by Variance Shift. [`arxiv`](https://arxiv.org/abs/1801.05134)
- Understanding the Loss Surface of Neural Networks for Binary Classification. [`arxiv`](https://arxiv.org/abs/1803.00909)
- Universal Deep Neural Network Compression. [`arxiv`](https://arxiv.org/abs/1802.02271)
- URLNet: Learning a URL Representation with Deep Learning for Malicious URL Detection. [`arxiv`](https://arxiv.org/abs/1802.03162) [`code`](https://github.com/Antimalweb/URLNet)
- Wasserstein is all you need. [`arxiv`](https://arxiv.org/abs/1808.09663)
- Weighted Risk Minimization & Deep Learning. [`arxiv`](https://arxiv.org/abs/1812.03372)
- What Do We Understand About Convolutional Networks? [`arxiv`](https://arxiv.org/abs/1803.08834)


## Attention

- Attention-based Graph Neural Network for Semi-supervised Learning. [`arxiv`](https://arxiv.org/abs/1803.03735)
- Attention Solves Your TSP. [`arxiv`](https://arxiv.org/abs/1803.08475) [`code`](https://github.com/wouterkool/attention-tsp)
- Automatic Instrument Segmentation in Robot-Assisted Surgery Using Deep Learning. [`url`](https://www.biorxiv.org/content/early/2018/03/03/275867)
- Compositional Attention Networks for Machine Reasoning. [`arxiv`](https://arxiv.org/abs/1803.03067) [`tensorflow`](https://github.com/stanfordnlp/mac-network)
- Hyperbolic Attention Networks. [`arxiv`](https://arxiv.org/abs/1805.09786)
- Inference, Learning and Attention Mechanisms that Exploit and Preserve Sparsity in Convolutional Networks. [`arxiv`](https://arxiv.org/abs/1801.10585) [`code`](https://github.com/TimoHackel/ILA-SCNN)
- MAttNet: Modular Attention Network for Referring Expression Comprehension. [`arxiv`](https://arxiv.org/abs/1801.08186)
- Reinforced Self-Attention Network: a Hybrid of Hard and Soft Attention for Sequence Modeling. [`arxiv`](https://arxiv.org/abs/1801.10296)
- Tell Me Where to Look: Guided Attention Inference Network. [`arxiv`](https://arxiv.org/abs/1802.10171) [`CODE`](https://github.com/alokwhitewolf/Guided-Attention-Inference-Network)

## Generative learning

- Adversarial Attack on Graph Structured Data. [`arxiv`](https://arxiv.org/abs/1806.02371)
- Adversarial Attacks Against Medical Deep Learning Systems. [`arxiv`](https://arxiv.org/abs/1804.05296) [`code`](https://github.com/sgfin/adversarial-medicine)
- Adversarial Classification on Social Networks. [`arxiv`](https://arxiv.org/abs/1801.08159)
- Adversarial Logit Pairing. [`arxiv`](https://arxiv.org/abs/1803.06373) :star:
- Adversarial Reprogramming of Neural Networks. [`arxiv`](https://arxiv.org/abs/1806.11146)
- Adversarial Spheres. [`arxiv`](https://arxiv.org/abs/1801.02774)
- AmbientGAN: Generative models from lossy measurements. [`url`](https://openreview.net/forum?id=Hy7fDog0b) [`code`](https://github.com/shinseung428/ambientGAN_TF)
- An empirical study on evaluation metrics of generative adversarial networks. [`arxiv`](https://arxiv.org/abs/1806.07755) [`code`](https://github.com/xuqiantong/GAN-Metrics)
- Anime Style Space Exploration Using Metric Learning and Generative Adversarial Networks. [`arxiv`](https://arxiv.org/abs/1805.07997)
- Autoencoding topology. [`arxiv`](https://arxiv.org/abs/1803.00156)
- CariGANs: Unpaired Photo-to-Caricature Translation. [`arxiv`](https://arxiv.org/abs/1811.00222)
- CartoonGAN: Generative Adversarial Networks for Photo Cartoonization. [`pdf`](http://openaccess.thecvf.com/content_cvpr_2018/CameraReady/2205.pdf) [`pytorch`](https://github.com/Yijunmaverick/CartoonGAN-Test-Pytorch-Torch)
- cGANs with Projection Discriminator. [`pdf`](https://openreview.net/pdf?id=ByS1VpgRZ) [`code`](https://github.com/pfnet-research/sngan_projection)
- ClusterGAN : Latent Space Clustering in Generative Adversarial Networks. [`arxiv`](https://arxiv.org/abs/1809.03627)
- Compositional GAN: Learning Conditional Image Composition. [`arxiv`](https://arxiv.org/abs/1807.07560) [`code`](https://github.com/azadis/CompositionalGAN)
- Counterfactuals uncover the modular structure of deep generative models. [`arxiv`](https://arxiv.org/abs/1812.03253)
- CR-GAN: Learning Complete Representations for Multi-view Generation. [`arxiv`](https://arxiv.org/abs/1806.11191) [`code`](https://github.com/bluer555/CR-GAN)
- Deep Generative Markov State Models. [`arxiv`](https://arxiv.org/abs/1805.07601) [`code`](https://github.com/amardt/DeepGenMSM)
- Deep Learning for Imbalance Data Classification using Class Expert Generative Adversarial Network. [`arxiv`](https://arxiv.org/abs/1807.04585)
- eCommerceGAN : A Generative Adversarial Network for E-commerce. [`arxiv`](https://arxiv.org/abs/1801.03244)
- Evolving Mario Levels in the Latent Space of a Deep Convolutional Generative Adversarial Network. [`arxiv`](https://arxiv.org/abs/1805.00728)
- Geometry Score: A Method For Comparing Generative Adversarial Networks. [`arxiv`](https://arxiv.org/abs/1802.02664) [`code`](https://github.com/geom-score/geometry-score)
- Generating Handwritten Chinese Characters using CycleGAN. [`arxiv`](https://arxiv.org/abs/1801.08624) [`code`](https://github.com/changebo/HCCG-CycleGAN)
- Generative Adversarial Networks using Adaptive Convolution. [`arxiv`](https://arxiv.org/abs/1802.02226)
- Improving GANs Using Optimal Transport. [`arxiv`](https://arxiv.org/abs/1803.05573)
- Inverting The Generator Of A Generative Adversarial Network (II). [`arxiv`](https://arxiv.org/abs/1802.05701) [`code`](https://github.com/ToniCreswell/InvertingGAN)
- Learning Dynamics of Linear Denoising Autoencoders. [`arxiv`](https://arxiv.org/abs/1806.05413) [`code`](https://github.com/arnupretorius/lindaedynamics_icml2018)
- Learning Inverse Mappings with Adversarial Criterion. [`arxiv`](https://arxiv.org/abs/1802.04504) [`code`](https://github.com/zhangjiyi/FAAE)
- New Losses for Generative Adversarial Learning. [`arxiv`](https://arxiv.org/abs/1807.01290)
- On Generation of Adversarial Examples using Convex Programming. [`arxiv`](https://arxiv.org/abs/1803.03607) [`code`](https://github.com/ebalda/adversarialconvex)
- On the Latent Space of Wasserstein Auto-Encoders. [`arxiv`](https://arxiv.org/abs/1802.03761)
- Recurrent Neural Network-Based Semantic Variational Autoencoder for Sequence-to-Sequence Learning. [`arxiv`](https://arxiv.org/abs/1802.03238)
- Scalable Factorized Hierarchical Variational Autoencoder Training. [`arxiv`](https://arxiv.org/abs/1804.03201) [`code`](https://github.com/wnhsu/ScalableFHVAE)
- Semi-Amortized Variational Autoencoders. [`arxiv`](https://arxiv.org/abs/1802.02550) [`code`](https://github.com/harvardnlp/sa-vae)
- Semi-supervised Learning on Graphs with Generative Adversarial Nets. [`arxiv`](https://arxiv.org/abs/1809.00130)
- Siamese networks for generating adversarial examples. [`arxiv`](https://arxiv.org/abs/1805.01431)
- Social GAN: Socially Acceptable Trajectories with Generative Adversarial Networks. [`arxiv`](https://arxiv.org/abs/1803.10892) [`code`](https://github.com/agrimgupta92/sgan)
- Sylvester Normalizing Flows for Variational Inference. [`arxiv`](https://arxiv.org/abs/1803.05649)
- Synthesizing Audio with Generative Adversarial Networks. [`arxiv`](https://arxiv.org/abs/1802.04208)
- tempoGAN: A Temporally Coherent, Volumetric GAN for Super-resolution Fluid Flow. [`arxiv`](https://arxiv.org/abs/1801.09710)
- The relativistic discriminator: a key element missing from standard GAN. [`arxiv`](https://arxiv.org/abs/1807.00734) [`code`](https://github.com/AlexiaJM/RelativisticGAN)
- Understanding and Improving Interpolation in Autoencoders via an Adversarial Regularizer. [`arxiv`](https://arxiv.org/abs/1807.07543) [`code`](https://github.com/brain-research/acai)
- Unsupervised Cipher Cracking Using Discrete GANs. [`arxiv`](https://arxiv.org/abs/1801.04883) [`tensorflow`](https://github.com//for-ai/CipherGAN)
- Variational Bayesian Monte Carlo. [`arxiv`](https://arxiv.org/abs/1810.05558) [`code`](https://github.com/lacerbi/vbmc)

## Meta Learning

- Bayesian Model-Agnostic Meta-Learning. [`arxiv`](https://arxiv.org/abs/1806.03836)
- Meta-Learning: A Survey. [`arxiv`](https://arxiv.org/abs/1810.03548)
- Meta-Learning for Semi-Supervised Few-Shot Classification. [`arxiv`](https://arxiv.org/abs/1803.00676) [`code`](https://github.com/renmengye/few-shot-ssl-public)
- Reptile: a Scalable Metalearning Algorithm. [`arxiv`](https://arxiv.org/abs/1803.02999)


## Optimization

- Averaging Weights Leads to Wider Optima and Better Generalization. [`arxiv`](https://arxiv.org/abs/1803.05407)
- Computational Optimal Transport. [`arxiv`](https://arxiv.org/abs/1803.00567)
- Energy-entropy competition and the effectiveness of stochastic gradient descent in machine learning. [`arxiv`](https://arxiv.org/abs/1803.01927)
- Gradient Descent Quantizes ReLU Network Features. [`arxiv`](https://arxiv.org/abs/1803.08367)
- L4: Practical loss-based stepsize adaptation for deep learning. [`arxiv`](https://arxiv.org/abs/1802.05074) [`code`](https://github.com/martius-lab/l4-optimizer)
- Sequential Preference-Based Optimization. [`arxiv`](https://arxiv.org/abs/1801.02788) [`code`](https://github.com/prefopt/prefopt)
- Sever: A Robust Meta-Algorithm for Stochastic Optimization. [`arxiv`](https://arxiv.org/abs/1803.02815)
- Shampoo: Preconditioned Stochastic Tensor Optimization. [`arxiv`](https://arxiv.org/abs/1802.09568) [`pytorch`](https://github.com/moskomule/shampoo.pytorch)
- Optimizing for Generalization in Machine Learning with Cross-Validation Gradients. [`arxiv`](https://arxiv.org/abs/1805.07072) [`code`](https://github.com/sbarratt/crossval)
- WNGrad: Learn the Learning Rate in Gradient Descent. [`arxiv`](https://arxiv.org/abs/1803.02865)

## Transfer Learning

- 3D Convolutional Encoder-Decoder Network for Low-Dose CT via Transfer Learning from a 2D Trained Network. [`arxiv`](https://arxiv.org/abs/1802.05656)
- Adversarial Transfer Learning. [`arxiv`](https://arxiv.org/abs/1812.02849)
- Arbitrary Style Transfer with Style-Attentional Networks. [`arxiv`](https://arxiv.org/abs/1812.02342)
- A Survey on Deep Transfer Learning. [`arxiv`](https://arxiv.org/abs/1808.01974)
- Avatar-Net: Multi-scale Zero-shot Style Transfer by Feature Decoration. [`arxiv`](https://arxiv.org/abs/1805.03857)
- Capsule networks for low-data transfer learning. [`arxiv`](https://arxiv.org/abs/1804.10172)
- Delete, Retrieve, Generate: A Simple Approach to Sentiment and Style Transfer. [`arxiv`](https://arxiv.org/abs/1804.06437v1) [`code`](https://github.com/lijuncen/Sentiment-and-Style-Transfer)
- Learn from Your Neighbor: Learning Multi-modal Mappings from Sparse Annotations. [`arxiv`](https://arxiv.org/abs/1806.02934)
- [Best Paper] Taskonomy: Disentangling Task Transfer Learning. [`arxiv`](https://arxiv.org/abs/1804.08328) :star:

## Zero/One Shot Learning

- A Large-scale Attribute Dataset for Zero-shot Learning. [`arxiv`](https://arxiv.org/abs/1804.04314)
- Deep Triplet Ranking Networks for One-Shot Recognition. [`arxiv`](https://arxiv.org/abs/1804.07275)
- One-Shot Learning using Mixture of Variational Autoencoders: a Generalization Learning approach. [`arxiv`](https://arxiv.org/abs/1804.07645)
- One-Shot Unsupervised Cross Domain Translation. [`arxiv`](https://arxiv.org/abs/1806.06029) [`code`](https://github.com/sagiebenaim/OneShotTranslation)
- Preserving Semantic Relations for Zero-Shot Learning. [`arxiv`](https://arxiv.org/abs/1803.03049)
